/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kyuubi;

import java.io.Serializable;
import org.apache.kyuubi.engine.spark.KyuubiSparkUtil$;
import org.apache.kyuubi.engine.spark.schema.RowSet$;
import org.apache.kyuubi.reflection.DynMethods;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.CollectLimitExec;
import org.apache.spark.sql.execution.LocalTableScanExec;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanExec;
import org.apache.spark.sql.execution.arrow.KyuubiArrowConverters$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.kyuubi.SparkDatasetHelper$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class SparkDatasetHelper$
implements Logging {
    public static SparkDatasetHelper$ MODULE$;
    private long maxBatchSize;
    private DynMethods.UnboundMethod commandResultExecRowsMethod;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    static {
        new SparkDatasetHelper$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public byte[][] executeCollect(Dataset<Row> df) {
        return (byte[][])this.withNewExecutionId(df, (Function0 & Serializable & scala.Serializable)() -> (byte[][])MODULE$.executeArrowBatchCollect().apply((Object)df.queryExecution().executedPlan()));
    }

    public Function1<SparkPlan, byte[][]> executeArrowBatchCollect() {
        return (Function1 & Serializable & scala.Serializable)x0$1 -> {
            SparkPlan sparkPlan;
            boolean bl = false;
            CollectLimitExec collectLimitExec = null;
            SparkPlan sparkPlan2 = x0$1;
            if (sparkPlan2 instanceof AdaptiveSparkPlanExec) {
                AdaptiveSparkPlanExec adaptiveSparkPlanExec = (AdaptiveSparkPlanExec)sparkPlan2;
                return (byte[][])MODULE$.executeArrowBatchCollect().apply((Object)MODULE$.finalPhysicalPlan(adaptiveSparkPlanExec));
            }
            if (sparkPlan2 instanceof CollectLimitExec) {
                bl = true;
                collectLimitExec = (CollectLimitExec)sparkPlan2;
                if (MODULE$.offset(collectLimitExec) > 0) {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "unsupported offset > 0, an extra shuffle will be introduced.");
                    return (byte[][])MODULE$.toArrowBatchRdd((SparkPlan)collectLimitExec).collect();
                }
            }
            if (bl && collectLimitExec.limit() >= 0) {
                return MODULE$.doCollectLimit(collectLimitExec);
            }
            if (bl && collectLimitExec.limit() < 0) {
                return (byte[][])MODULE$.executeArrowBatchCollect().apply((Object)collectLimitExec.child());
            }
            if (sparkPlan2 != null && MODULE$.isCommandResultExec(sparkPlan = sparkPlan2)) {
                return MODULE$.doCommandResultExec(sparkPlan);
            }
            if (sparkPlan2 instanceof LocalTableScanExec) {
                LocalTableScanExec localTableScanExec = (LocalTableScanExec)sparkPlan2;
                return MODULE$.doLocalTableScan(localTableScanExec);
            }
            if (sparkPlan2 != null) {
                SparkPlan sparkPlan3 = sparkPlan2;
                return (byte[][])MODULE$.toArrowBatchRdd(sparkPlan3).collect();
            }
            throw new MatchError((Object)sparkPlan2);
        };
    }

    public <T> RDD<byte[]> toArrowBatchRdd(Dataset<T> ds) {
        return ds.toArrowBatchRdd();
    }

    public RDD<byte[]> toArrowBatchRdd(SparkPlan plan) {
        StructType schemaCaptured = plan.schema();
        int maxRecordsPerBatch = SparkSession$.MODULE$.active().sessionState().conf().arrowMaxRecordsPerBatch();
        String timeZoneId = SparkSession$.MODULE$.active().sessionState().conf().sessionLocalTimeZone();
        long maxBatchSizePerBatch = this.maxBatchSize();
        RDD qual$1 = plan.execute();
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)iter -> KyuubiArrowConverters$.MODULE$.toBatchIterator((Iterator<InternalRow>)iter, schemaCaptured, maxRecordsPerBatch, maxBatchSizePerBatch, -1L, timeZoneId);
        boolean x$2 = qual$1.mapPartitionsInternal$default$2();
        return qual$1.mapPartitionsInternal((Function1)x$1, x$2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public Iterator<byte[]> toArrowBatchLocalIterator(Dataset<Row> df) {
        return (Iterator)this.withNewExecutionId(df, (Function0 & Serializable & scala.Serializable)() -> MODULE$.toArrowBatchRdd(df).toLocalIterator());
    }

    public Dataset<Row> convertTopLevelComplexTypeToHiveString(Dataset<Row> df, boolean timestampAsString) {
        public final class Org_apache_spark_sql_kyuubi_SparkDatasetHelper$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_apache_spark_sql_kyuubi_SparkDatasetHelper$$typecreator3$1() {
            }
        }
        public final class Org_apache_spark_sql_kyuubi_SparkDatasetHelper$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.Row").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_kyuubi_SparkDatasetHelper$$typecreator2$1() {
            }
        }
        public final class Org_apache_spark_sql_kyuubi_SparkDatasetHelper$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Org_apache_spark_sql_kyuubi_SparkDatasetHelper$$typecreator1$1() {
            }
        }
        Function1 & Serializable & scala.Serializable quotedCol = (Function1 & Serializable & scala.Serializable)name -> functions$.MODULE$.col(MODULE$.quoteIfNeeded((String)name));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        UserDefinedFunction toHiveStringUDF = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(row, schemaDDL) -> {
            DataType tt;
            StructField structField;
            StructField[] structFieldArray;
            Option option;
            DataType mt;
            StructField structField2;
            StructField[] structFieldArray2;
            Option option2;
            DataType at;
            StructField structField3;
            StructField[] structFieldArray3;
            Option option3;
            DataType dt = DataType$.MODULE$.fromDDL(schemaDDL);
            boolean bl = false;
            StructType structType = null;
            DataType dataType = dt;
            if (dataType instanceof StructType) {
                DataType st;
                StructField structField4;
                bl = true;
                structType = (StructType)dataType;
                StructField[] structFieldArray4 = structType.fields();
                Option option4 = Array$.MODULE$.unapplySeq((Object)structFieldArray4);
                if (!option4.isEmpty() && option4.get() != null && ((SeqLike)option4.get()).lengthCompare(1) == 0 && (structField4 = (StructField)((SeqLike)option4.get()).apply(0)) != null && (st = structField4.dataType()) instanceof StructType) {
                    StructType structType2 = (StructType)st;
                    return RowSet$.MODULE$.toHiveString((Tuple2<Object, DataType>)new Tuple2(row, (Object)structType2), true);
                }
            }
            if (bl && !(option3 = Array$.MODULE$.unapplySeq((Object)(structFieldArray3 = structType.fields()))).isEmpty() && option3.get() != null && ((SeqLike)option3.get()).lengthCompare(1) == 0 && (structField3 = (StructField)((SeqLike)option3.get()).apply(0)) != null && (at = structField3.dataType()) instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)at;
                return RowSet$.MODULE$.toHiveString((Tuple2<Object, DataType>)new Tuple2(row.toSeq().head(), (Object)arrayType), true);
            }
            if (bl && !(option2 = Array$.MODULE$.unapplySeq((Object)(structFieldArray2 = structType.fields()))).isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0 && (structField2 = (StructField)((SeqLike)option2.get()).apply(0)) != null && (mt = structField2.dataType()) instanceof MapType) {
                MapType mapType = (MapType)mt;
                return RowSet$.MODULE$.toHiveString((Tuple2<Object, DataType>)new Tuple2(row.toSeq().head(), (Object)mapType), true);
            }
            if (bl && !(option = Array$.MODULE$.unapplySeq((Object)(structFieldArray = structType.fields()))).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0 && (structField = (StructField)((SeqLike)option.get()).apply(0)) != null && (tt = structField.dataType()) instanceof TimestampType) {
                TimestampType timestampType = (TimestampType)tt;
                return RowSet$.MODULE$.toHiveString((Tuple2<Object, DataType>)new Tuple2(row.toSeq().head(), (Object)timestampType), true);
            }
            throw new UnsupportedOperationException();
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_kyuubi_SparkDatasetHelper$$typecreator1$1()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_kyuubi_SparkDatasetHelper$$typecreator2$1()), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_kyuubi_SparkDatasetHelper$$typecreator3$1()));
        Seq cols = (Seq)df.schema().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StructField structField = x0$1;
            if (structField != null) {
                String name = structField.name();
                if (structField.dataType() instanceof StructType) {
                    return toHiveStringUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)quotedCol.apply((Object)name), functions$.MODULE$.lit((Object)structField.toDDL())})).as(name);
                }
            }
            if (structField != null) {
                String name = structField.name();
                if (structField.dataType() instanceof MapType ? true : structField.dataType() instanceof ArrayType) {
                    return toHiveStringUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)quotedCol.apply((Object)name)})), functions$.MODULE$.lit((Object)structField.toDDL())})).as(name);
                }
            }
            if (structField != null) {
                String name = structField.name();
                if (structField.dataType() instanceof TimestampType && timestampAsString) {
                    return toHiveStringUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)quotedCol.apply((Object)name)})), functions$.MODULE$.lit((Object)structField.toDDL())})).as(name);
                }
            }
            if (structField != null) {
                String name = structField.name();
                return (Column)quotedCol.apply((Object)name);
            }
            throw new MatchError((Object)structField);
        }, Seq$.MODULE$.canBuildFrom());
        return df.select(cols);
    }

    private String quoteIfNeeded(String part) {
        if (part.matches("[a-zA-Z0-9_]+") && !part.matches("\\d+")) {
            return part;
        }
        return new StringBuilder(2).append("`").append(part.replace("`", "``")).append("`").toString();
    }

    private long maxBatchSize$lzycompute() {
        SparkDatasetHelper$ sparkDatasetHelper$ = this;
        synchronized (sparkDatasetHelper$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.maxBatchSize = BoxesRunTime.unboxToLong((Object)KyuubiSparkUtil$.MODULE$.globalSparkContext().getConf().getOption("spark.connect.grpc.arrow.maxBatchSize").orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)"4m")).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)SparkDatasetHelper$.$anonfun$maxBatchSize$2(x$1))).get());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.maxBatchSize;
    }

    private long maxBatchSize() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.maxBatchSize$lzycompute();
        }
        return this.maxBatchSize;
    }

    private byte[][] doCollectLimit(CollectLimitExec collectLimit) {
        String timeZoneId = SparkSession$.MODULE$.active().sessionState().conf().sessionLocalTimeZone();
        int maxRecordsPerBatch = SparkSession$.MODULE$.active().sessionState().conf().arrowMaxRecordsPerBatch();
        Tuple2<byte[], Object>[] batches = KyuubiArrowConverters$.MODULE$.takeAsArrowBatches(collectLimit, maxRecordsPerBatch, this.maxBatchSize(), timeZoneId);
        ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int rest = collectLimit.limit();
        for (int i = 0; i < batches.length && rest > 0; ++i) {
            Tuple2<byte[], Object> tuple2 = batches[i];
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            byte[] batch = (byte[])tuple2._1();
            long size = tuple2._2$mcJ$sp();
            Tuple2 tuple22 = new Tuple2((Object)batch, (Object)BoxesRunTime.boxToLong((long)size));
            byte[] batch2 = (byte[])tuple22._1();
            long size2 = tuple22._2$mcJ$sp();
            if (size2 <= (long)rest) {
                result.$plus$eq((Object)batch2);
                rest -= (int)size2;
                continue;
            }
            result.$plus$eq((Object)KyuubiArrowConverters$.MODULE$.slice(collectLimit.schema(), timeZoneId, batch2, 0, rest));
            rest = 0;
        }
        return (byte[][])result.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    private DynMethods.UnboundMethod commandResultExecRowsMethod$lzycompute() {
        SparkDatasetHelper$ sparkDatasetHelper$ = this;
        synchronized (sparkDatasetHelper$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.commandResultExecRowsMethod = DynMethods.builder("rows").impl("org.apache.spark.sql.execution.CommandResultExec", new Class[0]).build();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.commandResultExecRowsMethod;
    }

    private DynMethods.UnboundMethod commandResultExecRowsMethod() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.commandResultExecRowsMethod$lzycompute();
        }
        return this.commandResultExecRowsMethod;
    }

    private byte[][] doCommandResultExec(SparkPlan command) {
        SparkSession spark = SparkSession$.MODULE$.active();
        Seq rows = (Seq)this.commandResultExecRowsMethod().invoke(command, new Object[0]);
        command.longMetric("numOutputRows").add((long)rows.size());
        this.sendDriverMetrics(spark.sparkContext(), (Map<String, SQLMetric>)command.metrics());
        return (byte[][])KyuubiArrowConverters$.MODULE$.toBatchIterator((Iterator<InternalRow>)rows.iterator(), command.schema(), spark.sessionState().conf().arrowMaxRecordsPerBatch(), this.maxBatchSize(), -1L, spark.sessionState().conf().sessionLocalTimeZone()).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    private byte[][] doLocalTableScan(LocalTableScanExec localTableScan) {
        SparkSession spark = SparkSession$.MODULE$.active();
        localTableScan.longMetric("numOutputRows").add((long)localTableScan.rows().size());
        this.sendDriverMetrics(spark.sparkContext(), (Map<String, SQLMetric>)localTableScan.metrics());
        return (byte[][])KyuubiArrowConverters$.MODULE$.toBatchIterator((Iterator<InternalRow>)localTableScan.rows().iterator(), localTableScan.schema(), spark.sessionState().conf().arrowMaxRecordsPerBatch(), this.maxBatchSize(), -1L, spark.sessionState().conf().sessionLocalTimeZone()).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public SparkPlan finalPhysicalPlan(AdaptiveSparkPlanExec adaptiveSparkPlanExec) {
        return (SparkPlan)this.withFinalPlanUpdate(adaptiveSparkPlanExec, (Function1 & Serializable & scala.Serializable)x -> (SparkPlan)Predef$.MODULE$.identity(x));
    }

    private <T> T withFinalPlanUpdate(AdaptiveSparkPlanExec adaptiveSparkPlanExec, Function1<SparkPlan, T> fun) {
        DynMethods.UnboundMethod getFinalPhysicalPlan = DynMethods.builder("getFinalPhysicalPlan").hiddenImpl(adaptiveSparkPlanExec.getClass(), new Class[0]).build();
        SparkPlan plan = (SparkPlan)getFinalPhysicalPlan.invoke(adaptiveSparkPlanExec, new Object[0]);
        Object result = fun.apply((Object)plan);
        DynMethods.UnboundMethod finalPlanUpdate = DynMethods.builder("finalPlanUpdate").hiddenImpl(adaptiveSparkPlanExec.getClass(), new Class[0]).build();
        finalPlanUpdate.invoke(adaptiveSparkPlanExec, new Object[0]);
        return (T)result;
    }

    private int offset(CollectLimitExec collectLimitExec) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(DynMethods.builder("offset").impl(collectLimitExec.getClass(), new Class[0]).orNoop().build().invoke(collectLimitExec, new Object[0])).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    private boolean isCommandResultExec(SparkPlan sparkPlan) {
        String string = sparkPlan.getClass().getName();
        String string2 = "org.apache.spark.sql.execution.CommandResultExec";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private <T> T withNewExecutionId(Dataset<Row> df, Function0<T> body) {
        return (T)SQLExecution$.MODULE$.withNewExecutionId(df.queryExecution(), (Option)new Some((Object)"collectAsArrow"), (Function0 & Serializable & scala.Serializable)() -> {
            df.queryExecution().executedPlan().resetMetrics();
            return body.apply();
        });
    }

    private void sendDriverMetrics(SparkContext sc, Map<String, SQLMetric> metrics) {
        String executionId = sc.getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
        SQLMetrics$.MODULE$.postDriverMetricUpdates(sc, executionId, metrics.values().toSeq());
    }

    public static final /* synthetic */ long $anonfun$maxBatchSize$2(String x$1) {
        return JavaUtils.byteStringAs((String)x$1, (ByteUnit)ByteUnit.MiB);
    }

    private SparkDatasetHelper$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

