/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.kyuubi;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.service.AbstractFrontendService;
import org.apache.kyuubi.service.Serverable;
import org.apache.kyuubi.service.ServiceState$;
import org.apache.spark.SparkException;
import org.apache.spark.scheduler.JobFailed;
import org.apache.spark.scheduler.JobResult;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001\u0002\t\u0012\u0001iA\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\u0006[\u0001!\tA\f\u0005\te\u0001A)\u0019!C\u0005g!A!\n\u0001EC\u0002\u0013%1\u0007\u0003\u0005L\u0001!\u0015\r\u0011\"\u0003M\u0011!\t\u0006\u0001#b\u0001\n\u0013\u0011\u0006b\u0002,\u0001\u0005\u0004%Ia\u0016\u0005\u0007I\u0002\u0001\u000b\u0011\u0002-\t\u000f\u0015\u0004\u0001\u0019!C\u0005\u0019\"9a\r\u0001a\u0001\n\u00139\u0007BB7\u0001A\u0003&Q\nC\u0003s\u0001\u0011\u00053\u000fC\u0003z\u0001\u0011\u0005#\u0010C\u0004\u0002\u0002\u0001!\t%a\u0001\t\u000f\u0005=\u0001\u0001\"\u0003\u0002\u0012\t12\u000b]1sWN\u000bF*\u00128hS:,G*[:uK:,'O\u0003\u0002\u0013'\u000511._;vE&T!\u0001F\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y9\u0012AB1qC\u000eDWMC\u0001\u0019\u0003\ry'oZ\u0002\u0001'\r\u00011$\t\t\u00039}i\u0011!\b\u0006\u0003=M\t\u0011b]2iK\u0012,H.\u001a:\n\u0005\u0001j\"!D*qCJ\\G*[:uK:,'\u000f\u0005\u0002#I5\t1E\u0003\u0002\u0013+%\u0011Qe\t\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0019XM\u001d<feB\u0011\u0001fK\u0007\u0002S)\u0011!fI\u0001\bg\u0016\u0014h/[2f\u0013\ta\u0013F\u0001\u0006TKJ4XM]1cY\u0016\fa\u0001P5oSRtDCA\u00182!\t\u0001\u0004!D\u0001\u0012\u0011\u00151#\u00011\u0001(\u0003Q!WM]3hSN$XM]#yG\u0016\u0004H/[8ogV\tA\u0007E\u00026\u007f\ts!A\u000e\u001f\u000f\u0005]RT\"\u0001\u001d\u000b\u0005eJ\u0012A\u0002\u001fs_>$h(C\u0001<\u0003\u0015\u00198-\u00197b\u0013\tid(A\u0004qC\u000e\\\u0017mZ3\u000b\u0003mJ!\u0001Q!\u0003\u0007M+\u0017O\u0003\u0002>}A\u00111i\u0012\b\u0003\t\u0016\u0003\"a\u000e \n\u0005\u0019s\u0014A\u0002)sK\u0012,g-\u0003\u0002I\u0013\n11\u000b\u001e:j]\u001eT!A\u0012 \u0002%\u0011,'/Z4jgR,'/T3tg\u0006<Wm]\u0001\u0017I\u0016\u0014XmZ5ti\u0016\u0014X\t_2faRLwN\u001c+U\u0019V\tQ\n\u0005\u0002O\u001f6\ta(\u0003\u0002Q}\t!Aj\u001c8h\u00039QwNY'bq\u001a\u000b\u0017\u000e\\;sKN,\u0012a\u0015\t\u0003\u001dRK!!\u0016 \u0003\u0007%sG/A\u0007k_\n4\u0015-\u001b7ve\u0016tU/\\\u000b\u00021B\u0011\u0011LY\u0007\u00025*\u00111\fX\u0001\u0007CR|W.[2\u000b\u0005us\u0016AC2p]\u000e,(O]3oi*\u0011q\fY\u0001\u0005kRLGNC\u0001b\u0003\u0011Q\u0017M^1\n\u0005\rT&!D!u_6L7-\u00138uK\u001e,'/\u0001\bk_\n4\u0015-\u001b7ve\u0016tU/\u001c\u0011\u0002\u001f1\f7\u000f\u001e$bS2,(/\u001a+j[\u0016\f1\u0003\\1ti\u001a\u000b\u0017\u000e\\;sKRKW.Z0%KF$\"\u0001[6\u0011\u00059K\u0017B\u00016?\u0005\u0011)f.\u001b;\t\u000f1T\u0011\u0011!a\u0001\u001b\u0006\u0019\u0001\u0010J\u0019\u0002!1\f7\u000f\u001e$bS2,(/\u001a+j[\u0016\u0004\u0003FA\u0006p!\tq\u0005/\u0003\u0002r}\tAao\u001c7bi&dW-\u0001\tp]\u0006\u0003\b\u000f\\5dCRLwN\\#oIR\u0011\u0001\u000e\u001e\u0005\u0006k2\u0001\rA^\u0001\u0006KZ,g\u000e\u001e\t\u00039]L!\u0001_\u000f\u00037M\u0003\u0018M]6MSN$XM\\3s\u0003B\u0004H.[2bi&|g.\u00128e\u0003)ygNS8c'R\f'\u000f\u001e\u000b\u0003QnDQ\u0001`\u0007A\u0002u\f\u0001B[8c'R\f'\u000f\u001e\t\u00039yL!a`\u000f\u0003+M\u0003\u0018M]6MSN$XM\\3s\u0015>\u00147\u000b^1si\u0006AqN\u001c&pE\u0016sG\rF\u0002i\u0003\u000bAq!a\u0002\u000f\u0001\u0004\tI!\u0001\u0004k_\n,e\u000e\u001a\t\u00049\u0005-\u0011bAA\u0007;\t\u00192\u000b]1sW2K7\u000f^3oKJTuNY#oI\u0006Ia-\u001b8e\u0007\u0006,8/\u001a\u000b\u0005\u0003'\tI\u0002E\u00026\u0003+I1!a\u0006B\u0005%!\u0006N]8xC\ndW\rC\u0004\u0002\u001c=\u0001\r!a\u0005\u0002\u0003QD3aDA\u0010!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013}\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u00121\u0005\u0002\bi\u0006LGN]3d\u0001")
public class SparkSQLEngineListener
extends SparkListener
implements Logging {
    private Seq<String> deregisterExceptions;
    private Seq<String> deregisterMessages;
    private long deregisterExceptionTTL;
    private int jobMaxFailures;
    private final Serverable server;
    private final AtomicInteger jobFailureNum;
    private volatile long lastFailureTime;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile byte bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private Seq<String> deregisterExceptions$lzycompute() {
        SparkSQLEngineListener sparkSQLEngineListener = this;
        synchronized (sparkSQLEngineListener) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.deregisterExceptions = this.server.getConf().get(KyuubiConf$.MODULE$.ENGINE_DEREGISTER_EXCEPTION_CLASSES());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.deregisterExceptions;
    }

    private Seq<String> deregisterExceptions() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.deregisterExceptions$lzycompute();
        }
        return this.deregisterExceptions;
    }

    private Seq<String> deregisterMessages$lzycompute() {
        SparkSQLEngineListener sparkSQLEngineListener = this;
        synchronized (sparkSQLEngineListener) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deregisterMessages = this.server.getConf().get(KyuubiConf$.MODULE$.ENGINE_DEREGISTER_EXCEPTION_MESSAGES());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.deregisterMessages;
    }

    private Seq<String> deregisterMessages() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.deregisterMessages$lzycompute();
        }
        return this.deregisterMessages;
    }

    private long deregisterExceptionTTL$lzycompute() {
        SparkSQLEngineListener sparkSQLEngineListener = this;
        synchronized (sparkSQLEngineListener) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.deregisterExceptionTTL = BoxesRunTime.unboxToLong((Object)this.server.getConf().get(KyuubiConf$.MODULE$.ENGINE_DEREGISTER_EXCEPTION_TTL()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.deregisterExceptionTTL;
    }

    private long deregisterExceptionTTL() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.deregisterExceptionTTL$lzycompute();
        }
        return this.deregisterExceptionTTL;
    }

    private int jobMaxFailures$lzycompute() {
        SparkSQLEngineListener sparkSQLEngineListener = this;
        synchronized (sparkSQLEngineListener) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.jobMaxFailures = BoxesRunTime.unboxToInt((Object)this.server.getConf().get(KyuubiConf$.MODULE$.ENGINE_DEREGISTER_JOB_MAX_FAILURES()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.jobMaxFailures;
    }

    private int jobMaxFailures() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.jobMaxFailures$lzycompute();
        }
        return this.jobMaxFailures;
    }

    private AtomicInteger jobFailureNum() {
        return this.jobFailureNum;
    }

    private long lastFailureTime() {
        return this.lastFailureTime;
    }

    private void lastFailureTime_$eq(long x$1) {
        this.lastFailureTime = x$1;
    }

    public void onApplicationEnd(SparkListenerApplicationEnd event) {
        Enumeration.Value value = this.server.getServiceState();
        Enumeration.Value value2 = ServiceState$.MODULE$.STOPPED();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Received ApplicationEnd Message form Spark after the engine has stopped");
            return;
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Received ApplicationEnd Message from Spark at ").append(value).append(", stopping").toString());
        this.server.stop();
    }

    public void onJobStart(SparkListenerJobStart jobStart) {
        String statementId = jobStart.properties().getProperty("kyuubi.statement.id");
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Add jobStartInfo. Query [").append(statementId).append("]: Job ").append(jobStart.jobId()).append(" started with ").append(jobStart.stageIds().length()).append(" stages").toString());
    }

    public void onJobEnd(SparkListenerJobEnd jobEnd) {
        JobFailed jobFailed;
        Exception e;
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Job end. Job ").append(jobEnd.jobId()).append(" state is ").append(jobEnd.jobResult().toString()).toString());
        JobResult jobResult = jobEnd.jobResult();
        if (jobResult instanceof JobFailed && (e = (jobFailed = (JobFailed)jobResult).exception()) != null) {
            Throwable cause = this.findCause(e);
            None$ deregisterInfo = None$.MODULE$;
            if (this.deregisterExceptions().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.equals(cause.getClass().getCanonicalName())))) {
                deregisterInfo = new Some((Object)new StringBuilder(71).append("Job failed exception class is in the set of ").append(KyuubiConf$.MODULE$.ENGINE_DEREGISTER_EXCEPTION_CLASSES().key()).append(", deregistering the engine.").toString());
            } else {
                String string = Utils$.MODULE$.stringifyException(cause);
                if (this.deregisterMessages().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)string.contains(x$1)))) {
                    deregisterInfo = new Some((Object)new StringBuilder(78).append("Job failed exception message matches the specified ").append(KyuubiConf$.MODULE$.ENGINE_DEREGISTER_EXCEPTION_MESSAGES().key()).append(", deregistering the engine.").toString());
                }
            }
            deregisterInfo.foreach((Function1 & Serializable & scala.Serializable)din -> {
                SparkSQLEngineListener.$anonfun$onJobEnd$4(this, e, din);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private Throwable findCause(Throwable t) {
        Throwable throwable;
        while (((throwable = t) instanceof SparkException ? true : (throwable instanceof UndeclaredThrowableException ? true : throwable instanceof InvocationTargetException)) && throwable.getCause() != null) {
            t = throwable.getCause();
        }
        return throwable;
    }

    public static final /* synthetic */ void $anonfun$onJobEnd$4(SparkSQLEngineListener $this, Exception e$1, String din) {
        Integer n;
        long currentTime = System.currentTimeMillis();
        if ($this.lastFailureTime() == 0L || currentTime - $this.lastFailureTime() < $this.deregisterExceptionTTL()) {
            n = BoxesRunTime.boxToInteger((int)$this.jobFailureNum().incrementAndGet());
        } else {
            $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(94).append("It has been more than one deregister exception ttl [").append($this.deregisterExceptionTTL()).append(" ms]").append(" since last failure, restart counting.").toString());
            $this.jobFailureNum().set(1);
            n = BoxedUnit.UNIT;
        }
        $this.lastFailureTime_$eq(currentTime);
        int curFailures = $this.jobFailureNum().get();
        $this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append(din).append(", current job failure number is [").append(curFailures).append("]").toString(), e$1);
        if (curFailures >= $this.jobMaxFailures()) {
            $this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Job failed ").append(curFailures).append(" times; deregistering the engine").toString());
            AbstractFrontendService fe = (AbstractFrontendService)$this.server.frontendServices().head();
            fe.discoveryService().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.stop();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public SparkSQLEngineListener(Serverable server) {
        this.server = server;
        Logging.$init$(this);
        this.jobFailureNum = new AtomicInteger(0);
        this.lastFailureTime = 0L;
    }
}

