/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.io;

import alluxio.exception.InvalidPathException;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import alluxio.util.io.PathUtils;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);

    public static void changeLocalFileGroup(String path, String group) throws IOException {
        UserPrincipalLookupService lookupService = FileSystems.getDefault().getUserPrincipalLookupService();
        PosixFileAttributeView view = Files.getFileAttributeView(Paths.get(path, new String[0]), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        GroupPrincipal groupPrincipal = lookupService.lookupPrincipalByGroupName(group);
        view.setGroup(groupPrincipal);
    }

    public static void changeLocalFilePermission(String filePath, String perms) throws IOException {
        Files.setPosixFilePermissions(Paths.get(filePath, new String[0]), PosixFilePermissions.fromString(perms));
    }

    public static void changeLocalFileToFullPermission(String filePath) throws IOException {
        FileUtils.changeLocalFilePermission(filePath, "rwxrwxrwx");
    }

    public static String getLocalFileOwner(String filePath) throws IOException {
        PosixFileAttributes attr = Files.readAttributes(Paths.get(filePath, new String[0]), PosixFileAttributes.class, new LinkOption[0]);
        return attr.owner().getName();
    }

    public static String getLocalFileGroup(String filePath) throws IOException {
        PosixFileAttributes attr = Files.readAttributes(Paths.get(filePath, new String[0]), PosixFileAttributes.class, new LinkOption[0]);
        return attr.group().getName();
    }

    public static short getLocalFileMode(String filePath) throws IOException {
        Set<PosixFilePermission> permission = Files.readAttributes(Paths.get(filePath, new String[0]), PosixFileAttributes.class, new LinkOption[0]).permissions();
        return FileUtils.translatePosixPermissionToMode(permission);
    }

    public static short translatePosixPermissionToMode(Set<PosixFilePermission> permission) {
        int mode = 0;
        for (PosixFilePermission action : PosixFilePermission.values()) {
            mode <<= 1;
            mode += permission.contains((Object)action) ? 1 : 0;
        }
        return (short)mode;
    }

    public static Set<PosixFilePermission> translateModeToPosixPermissions(int mode) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        Preconditions.checkArgument(mode >= 0, "Mode can not be a negative value");
        if ((mode & 0x100) != 0) {
            perms.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) != 0) {
            perms.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) != 0) {
            perms.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) != 0) {
            perms.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) != 0) {
            perms.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) != 0) {
            perms.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) != 0) {
            perms.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) != 0) {
            perms.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) != 0) {
            perms.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return perms;
    }

    public static void changeLocalFileUser(String path, String user) throws IOException {
        UserPrincipalLookupService lookupService = FileSystems.getDefault().getUserPrincipalLookupService();
        PosixFileAttributeView view = Files.getFileAttributeView(Paths.get(path, new String[0]), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        UserPrincipal userPrincipal = lookupService.lookupPrincipalByName(user);
        view.setOwner(userPrincipal);
    }

    public static void setLocalDirStickyBit(String dir) {
        try {
            if (dir.startsWith("/")) {
                Runtime.getRuntime().exec("chmod +t " + dir);
            }
        }
        catch (IOException e) {
            LOG.info("Can not set the sticky bit of the directory: {}", (Object)dir, (Object)e);
        }
    }

    public static void createBlockPath(String path, String workerDataFolderPermissions) throws IOException {
        try {
            FileUtils.createStorageDirPath(PathUtils.getParent(path), workerDataFolderPermissions);
        }
        catch (InvalidPathException e) {
            throw new IOException("Failed to create block path, get parent path of " + path + "failed", e);
        }
        catch (IOException e) {
            throw new IOException("Failed to create block path " + path, e);
        }
    }

    public static void move(String srcPath, String dstPath) throws IOException {
        Files.move(Paths.get(srcPath, new String[0]), Paths.get(dstPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void delete(String path) throws IOException {
        if (!Files.deleteIfExists(Paths.get(path, new String[0]))) {
            throw new IOException("Failed to delete " + path);
        }
    }

    public static void deletePathRecursively(String path) throws IOException {
        if (!FileUtils.exists(path)) {
            return;
        }
        Path root = Paths.get(path, new String[0]);
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                if (e == null) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                throw e;
            }
        });
    }

    public static boolean createStorageDirPath(String path, String workerDataFolderPermissions) throws IOException {
        Path storagePath;
        if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
            return false;
        }
        try {
            storagePath = Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
        }
        catch (IOException | SecurityException | UnsupportedOperationException e) {
            throw new IOException("Failed to create folder " + path, e);
        }
        String absolutePath = storagePath.toAbsolutePath().toString();
        FileUtils.changeLocalFilePermission(absolutePath, workerDataFolderPermissions);
        FileUtils.setLocalDirStickyBit(absolutePath);
        return true;
    }

    public static void createFile(String filePath) throws IOException {
        Path storagePath = Paths.get(filePath, new String[0]);
        Path parent = storagePath.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        Files.createFile(storagePath, new FileAttribute[0]);
    }

    public static void createDir(String path) throws IOException {
        Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
    }

    public static boolean exists(String path) {
        return Files.exists(Paths.get(path, new String[0]), new LinkOption[0]);
    }

    public static boolean isStorageDirAccessible(String path) {
        Path filePath = Paths.get(path, new String[0]);
        return Files.exists(filePath, new LinkOption[0]) && Files.isReadable(filePath) && Files.isWritable(filePath) && Files.isExecutable(filePath);
    }

    private FileUtils() {
    }
}

