/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.rest.constant.ModelStatusToDisplayEnum;
import org.apache.kylin.rest.response.NDataModelResponse;
import org.apache.kylin.rest.response.NDataSegmentResponse;
import org.apache.kylin.rest.response.SimplifiedMeasure;

public class NDataModelResponse3X
extends NDataModel {
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="last_build_end")
    private String lastBuildEnd;
    @JsonProperty(value="storage")
    private long storage;
    @JsonProperty(value="source")
    private long source;
    @JsonProperty(value="expansion_rate")
    private String expansionrate;
    @JsonProperty(value="usage")
    private long usage;
    @JsonProperty(value="model_broken")
    private boolean modelBroken;
    @JsonProperty(value="root_fact_table_deleted")
    private boolean rootFactTableDeleted = false;
    @JsonProperty(value="segments")
    private List<NDataSegmentResponse> segments;
    @JsonProperty(value="recommendations_count")
    private int recommendationsCount;
    @JsonProperty(value="available_indexes_count")
    private long availableIndexesCount;
    @JsonProperty(value="empty_indexes_count")
    private long emptyIndexesCount;
    @JsonProperty(value="segment_holes")
    private List<SegmentRange> segmentHoles;
    @JsonProperty(value="total_indexes")
    private long totalIndexes;
    private long lastModify;
    @JsonProperty(value="simplified_dimensions")
    private List<NDataModel.NamedColumn> namedColumns;
    @JsonProperty(value="all_measures")
    private List<NDataModel.Measure> measures;
    @JsonProperty(value="simplified_measures")
    private List<SimplifiedMeasure> simplifiedMeasures;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="lookups")
    private List<JoinTableDesc> joinTables;
    @JsonProperty(value="is_streaming")
    private boolean streaming;
    @JsonProperty(value="size_kb")
    private long sizeKB;
    @JsonProperty(value="input_records_count")
    private long inputRecordCnt;
    @JsonProperty(value="input_records_size")
    private long inputRecordSizeBytes;
    @JsonProperty(value="project")
    private String projectName;
    @JsonProperty(value="unauthorized_tables")
    private Set<String> unauthorizedTables = Sets.newHashSet();
    @JsonProperty(value="unauthorized_columns")
    private Set<String> unauthorizedColumns = Sets.newHashSet();

    @JsonProperty(value="visible")
    public boolean isVisible() {
        return this.unauthorizedTables.isEmpty() && this.unauthorizedColumns.isEmpty();
    }

    public static NDataModelResponse3X convert(NDataModelResponse nDataModelResponse) throws Exception {
        NDataModelResponse3X nDataModelResponse3X = (NDataModelResponse3X)((Object)JsonUtil.readValue((String)JsonUtil.writeValueAsString((Object)((Object)nDataModelResponse)), NDataModelResponse3X.class));
        ModelStatus3XEnum newStatus = ModelStatus3XEnum.convert(nDataModelResponse.getStatus());
        nDataModelResponse3X.setStatus(null == newStatus ? null : newStatus.name());
        nDataModelResponse3X.setMvcc(nDataModelResponse.getMvcc());
        return nDataModelResponse3X;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getLastBuildEnd() {
        return this.lastBuildEnd;
    }

    @Generated
    public long getStorage() {
        return this.storage;
    }

    @Generated
    public long getSource() {
        return this.source;
    }

    @Generated
    public String getExpansionrate() {
        return this.expansionrate;
    }

    @Generated
    public long getUsage() {
        return this.usage;
    }

    @Generated
    public boolean isModelBroken() {
        return this.modelBroken;
    }

    @Generated
    public boolean isRootFactTableDeleted() {
        return this.rootFactTableDeleted;
    }

    @Generated
    public List<NDataSegmentResponse> getSegments() {
        return this.segments;
    }

    @Generated
    public int getRecommendationsCount() {
        return this.recommendationsCount;
    }

    @Generated
    public long getAvailableIndexesCount() {
        return this.availableIndexesCount;
    }

    @Generated
    public long getEmptyIndexesCount() {
        return this.emptyIndexesCount;
    }

    @Generated
    public List<SegmentRange> getSegmentHoles() {
        return this.segmentHoles;
    }

    @Generated
    public long getTotalIndexes() {
        return this.totalIndexes;
    }

    @Generated
    public long getLastModify() {
        return this.lastModify;
    }

    @Generated
    public List<NDataModel.NamedColumn> getNamedColumns() {
        return this.namedColumns;
    }

    @Generated
    public List<NDataModel.Measure> getMeasures() {
        return this.measures;
    }

    @Generated
    public List<SimplifiedMeasure> getSimplifiedMeasures() {
        return this.simplifiedMeasures;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<JoinTableDesc> getJoinTables() {
        return this.joinTables;
    }

    @Generated
    public boolean isStreaming() {
        return this.streaming;
    }

    @Generated
    public long getSizeKB() {
        return this.sizeKB;
    }

    @Generated
    public long getInputRecordCnt() {
        return this.inputRecordCnt;
    }

    @Generated
    public long getInputRecordSizeBytes() {
        return this.inputRecordSizeBytes;
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public Set<String> getUnauthorizedTables() {
        return this.unauthorizedTables;
    }

    @Generated
    public Set<String> getUnauthorizedColumns() {
        return this.unauthorizedColumns;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setLastBuildEnd(String lastBuildEnd) {
        this.lastBuildEnd = lastBuildEnd;
    }

    @Generated
    public void setStorage(long storage) {
        this.storage = storage;
    }

    @Generated
    public void setSource(long source) {
        this.source = source;
    }

    @Generated
    public void setExpansionrate(String expansionrate) {
        this.expansionrate = expansionrate;
    }

    @Generated
    public void setUsage(long usage) {
        this.usage = usage;
    }

    @Generated
    public void setModelBroken(boolean modelBroken) {
        this.modelBroken = modelBroken;
    }

    @Generated
    public void setRootFactTableDeleted(boolean rootFactTableDeleted) {
        this.rootFactTableDeleted = rootFactTableDeleted;
    }

    @Generated
    public void setSegments(List<NDataSegmentResponse> segments) {
        this.segments = segments;
    }

    @Generated
    public void setRecommendationsCount(int recommendationsCount) {
        this.recommendationsCount = recommendationsCount;
    }

    @Generated
    public void setAvailableIndexesCount(long availableIndexesCount) {
        this.availableIndexesCount = availableIndexesCount;
    }

    @Generated
    public void setEmptyIndexesCount(long emptyIndexesCount) {
        this.emptyIndexesCount = emptyIndexesCount;
    }

    @Generated
    public void setSegmentHoles(List<SegmentRange> segmentHoles) {
        this.segmentHoles = segmentHoles;
    }

    @Generated
    public void setTotalIndexes(long totalIndexes) {
        this.totalIndexes = totalIndexes;
    }

    @Generated
    public void setLastModify(long lastModify) {
        this.lastModify = lastModify;
    }

    @Generated
    public void setNamedColumns(List<NDataModel.NamedColumn> namedColumns) {
        this.namedColumns = namedColumns;
    }

    @Generated
    public void setMeasures(List<NDataModel.Measure> measures) {
        this.measures = measures;
    }

    @Generated
    public void setSimplifiedMeasures(List<SimplifiedMeasure> simplifiedMeasures) {
        this.simplifiedMeasures = simplifiedMeasures;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setJoinTables(List<JoinTableDesc> joinTables) {
        this.joinTables = joinTables;
    }

    @Generated
    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }

    @Generated
    public void setSizeKB(long sizeKB) {
        this.sizeKB = sizeKB;
    }

    @Generated
    public void setInputRecordCnt(long inputRecordCnt) {
        this.inputRecordCnt = inputRecordCnt;
    }

    @Generated
    public void setInputRecordSizeBytes(long inputRecordSizeBytes) {
        this.inputRecordSizeBytes = inputRecordSizeBytes;
    }

    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Generated
    public void setUnauthorizedTables(Set<String> unauthorizedTables) {
        this.unauthorizedTables = unauthorizedTables;
    }

    @Generated
    public void setUnauthorizedColumns(Set<String> unauthorizedColumns) {
        this.unauthorizedColumns = unauthorizedColumns;
    }

    public static enum ModelStatus3XEnum {
        READY,
        DISABLED,
        WARNING,
        DESCBROKEN;


        public static ModelStatus3XEnum convert(ModelStatusToDisplayEnum modelStatusToDisplayEnum) {
            if (null == modelStatusToDisplayEnum) {
                return null;
            }
            switch (modelStatusToDisplayEnum) {
                case ONLINE: {
                    return READY;
                }
                case OFFLINE: {
                    return DISABLED;
                }
                case WARNING: {
                    return WARNING;
                }
                case BROKEN: {
                    return DESCBROKEN;
                }
            }
            return null;
        }
    }
}

