/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import lombok.Generated;
import org.apache.kylin.metadata.cube.model.IndexPlan;

public class DiffRuleBasedIndexResponse
implements Serializable {
    private static DiffRuleBasedIndexResponse EMPTY = new DiffRuleBasedIndexResponse("", 0, 0, 0);
    @JsonProperty(value="index_plan_id")
    private String indexPlanId;
    @JsonProperty(value="decrease_layouts")
    private Integer decreaseLayouts;
    @JsonProperty(value="increase_layouts")
    private Integer increaseLayouts;
    @JsonProperty(value="rollback_layouts")
    private Integer rollbackLayouts;

    public static DiffRuleBasedIndexResponse from(String modelId, IndexPlan.UpdateRuleImpact impact) {
        return new DiffRuleBasedIndexResponse(modelId, impact.getDecreaseLayouts().size(), impact.getIncreaseLayouts().size(), impact.getRollbackLayouts().size());
    }

    public static DiffRuleBasedIndexResponse combine(DiffRuleBasedIndexResponse batch, DiffRuleBasedIndexResponse stream) {
        if (batch.isEmpty()) {
            return stream;
        }
        if (stream.isEmpty()) {
            return batch;
        }
        return new DiffRuleBasedIndexResponse(stream.indexPlanId, stream.getDecreaseLayouts() + batch.getDecreaseLayouts(), stream.getIncreaseLayouts() + batch.getIncreaseLayouts(), stream.getRollbackLayouts() + batch.getRollbackLayouts());
    }

    private boolean isEmpty() {
        return this == EMPTY;
    }

    public static DiffRuleBasedIndexResponse empty() {
        return EMPTY;
    }

    @Generated
    public String getIndexPlanId() {
        return this.indexPlanId;
    }

    @Generated
    public Integer getDecreaseLayouts() {
        return this.decreaseLayouts;
    }

    @Generated
    public Integer getIncreaseLayouts() {
        return this.increaseLayouts;
    }

    @Generated
    public Integer getRollbackLayouts() {
        return this.rollbackLayouts;
    }

    @Generated
    public DiffRuleBasedIndexResponse(String indexPlanId, Integer decreaseLayouts, Integer increaseLayouts, Integer rollbackLayouts) {
        this.indexPlanId = indexPlanId;
        this.decreaseLayouts = decreaseLayouts;
        this.increaseLayouts = increaseLayouts;
        this.rollbackLayouts = rollbackLayouts;
    }
}

