/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.persistence.metadata.JdbcAuditLogStore;
import org.apache.kylin.common.persistence.metadata.JdbcAuditLogStoreTool;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.TestUtils;
import org.apache.kylin.junit.JdbcInfo;
import org.apache.kylin.junit.annotation.JdbcMetadataInfo;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.rules.ExpectedException;
import org.junitpioneer.jupiter.RetryingTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MetadataInfo(onlyProps=true)
@JdbcMetadataInfo
public class JdbcAuditLogGroupbyReplayerTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcAuditLogGroupbyReplayerTest.class);
    private static final String LOCAL_INSTANCE = "127.0.0.1";
    private final Charset charset = Charset.defaultCharset();
    public ExpectedException thrown = ExpectedException.none();

    @RetryingTest(value=3)
    @Disabled
    public void testReplayGroupbyProject(JdbcInfo info) throws Exception {
        ResourceStore workerStore = this.initResourceStore();
        String project1 = "abc1";
        String project2 = "abc2";
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(project1, info, false);
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(project2, info, false);
        workerStore.catchup();
        Assert.assertEquals((long)3L, (long)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        JdbcAuditLogStoreTool.prepareJdbcAuditLogStore(project1, info.getJdbcTemplate(), 6000L);
        JdbcAuditLogStoreTool.prepareJdbcAuditLogStore(project2, info.getJdbcTemplate(), 6000L);
        Awaitility.await().atMost(6L, TimeUnit.SECONDS).until(() -> 12003 == workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        Awaitility.await().atMost(6L, TimeUnit.SECONDS).until(() -> 12002L == workerStore.getAuditLogStore().getLogOffset());
        workerStore.getAuditLogStore().catchupWithTimeout();
        ((JdbcAuditLogStore)workerStore.getAuditLogStore()).forceClose();
    }

    private ResourceStore initResourceStore() {
        TestUtils.getTestConfig().setProperty("kylin.auditlog.replay-groupby-project-reload-enable", "true");
        ResourceStore workerStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        workerStore.checkAndPutResource(ResourceStore.METASTORE_UUID_TAG, (RootPersistentEntity)new StringEntity(RandomUtil.randomUUIDStr()), StringEntity.serializer);
        Assert.assertEquals((long)1L, (long)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        return workerStore;
    }

    @Test
    public void testHandleProjectChange(JdbcInfo info) throws Exception {
        ResourceStore workerStore = this.initResourceStore();
        String project = "abc1";
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(project, info, false);
        workerStore.catchup();
        Assert.assertEquals((long)2L, (long)workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        JdbcAuditLogStoreTool.mockAuditLogForProjectEntry(project, info, true);
        Awaitility.await().atMost(6L, TimeUnit.SECONDS).until(() -> 1 == workerStore.listResourcesRecursively(MetadataType.ALL.name()).size());
        ((JdbcAuditLogStore)workerStore.getAuditLogStore()).forceClose();
    }
}

