/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.nio.charset.Charset;
import java.sql.SQLTransactionRollbackException;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.transaction.TransactionException;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkParams;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.apache.kylin.junit.annotation.OverwriteProp;
import org.junit.Ignore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@MetadataInfo(onlyProps=true)
class UnitOfWorkTest {
    UnitOfWorkTest() {
    }

    @Test
    void testTransaction() {
        UnitOfWork.doInTransactionWithRetry(() -> {
            ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            UnitOfWork.get().getCopyForWriteItems().add("PROJECT/res");
            UnitOfWork.get().getCopyForWriteItems().add("PROJECT/res2");
            UnitOfWork.get().getCopyForWriteItems().add("PROJECT/res3");
            resourceStore.checkAndPutResource("PROJECT/res", ByteSource.wrap((byte[])"{}".getBytes(Charset.defaultCharset())), -1L);
            resourceStore.checkAndPutResource("PROJECT/res2", ByteSource.wrap((byte[])"{}".getBytes(Charset.defaultCharset())), -1L);
            resourceStore.checkAndPutResource("PROJECT/res3", ByteSource.wrap((byte[])"{}".getBytes(Charset.defaultCharset())), -1L);
            return 0;
        }, (String)"_global");
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
        Assertions.assertEquals((long)0L, (long)resourceStore.getResource("PROJECT/res").getMvcc());
        Assertions.assertEquals((long)0L, (long)resourceStore.getResource("PROJECT/res2").getMvcc());
        Assertions.assertEquals((long)0L, (long)resourceStore.getResource("PROJECT/res3").getMvcc());
    }

    @Test
    void testExceptionInTransactionWithRetry() {
        try {
            UnitOfWork.doInTransactionWithRetry(() -> {
                ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
                UnitOfWork.get().getCopyForWriteItems().add("PROJECT/res");
                UnitOfWork.get().getCopyForWriteItems().add("PROJECT/res2");
                resourceStore.checkAndPutResource("PROJECT/res", ByteSource.wrap((byte[])"{}".getBytes(Charset.defaultCharset())), -1L);
                resourceStore.checkAndPutResource("PROJECT/res2", ByteSource.wrap((byte[])"{}".getBytes(Charset.defaultCharset())), -1L);
                throw new IllegalArgumentException("surprise");
            }, (String)"_global");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
        Assertions.assertNull((Object)resourceStore.getResource("PROJECT/res"));
        Assertions.assertNull((Object)resourceStore.getResource("PROJECT/res2"));
        this.testTransaction();
    }

    @Test
    void testUnitOfWorkPreprocess() {
        class A
        implements UnitOfWork.Callback<Object> {
            private final List<String> list = Lists.newArrayList();

            A() {
            }

            public String toString() {
                return String.valueOf(this.list.size());
            }

            public void preProcess() {
                try {
                    throw new Throwable("no args");
                }
                catch (Throwable e) {
                    this.list.add(e.getMessage());
                    return;
                }
            }

            public Object process() {
                this.list.add(this.toString());
                throw new IllegalStateException("conflict");
            }

            public void onProcessError(Throwable throwable) {
                this.list.add("conflict");
            }
        }
        A callback = new A();
        Assertions.assertTrue((boolean)callback.list.isEmpty());
        try {
            UnitOfWork.doInTransactionWithRetry((UnitOfWork.Callback)callback, (String)"_global");
            Assertions.fail();
        }
        catch (Throwable e) {
            Assertions.assertTrue((boolean)(e instanceof TransactionException));
            Assertions.assertEquals((Object)"conflict", (Object)Throwables.getRootCause((Throwable)e).getMessage());
        }
        Assertions.assertEquals((int)7, (int)callback.list.size());
        Assertions.assertEquals((Object)"no args", callback.list.get(0));
        Assertions.assertEquals((Object)"1", callback.list.get(1));
        Assertions.assertEquals((Object)"no args", callback.list.get(2));
        Assertions.assertEquals((Object)"3", callback.list.get(3));
        Assertions.assertEquals((Object)"no args", callback.list.get(4));
        Assertions.assertEquals((Object)"5", callback.list.get(5));
        Assertions.assertEquals((Object)"conflict", callback.list.get(6));
    }

    @Test
    @OverwriteProp(key="kylin.metadata.audit-log.catchup-timeout", value="100000")
    void testReentrant() {
        UnitOfWork.doInTransactionWithRetry(() -> {
            ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            UnitOfWork.get().getCopyForWriteItems().add("PROJECT/res");
            UnitOfWork.get().getCopyForWriteItems().add("PROJECT/res2");
            resourceStore.checkAndPutResource("PROJECT/res", ByteSource.wrap((byte[])"{}".getBytes(Charset.defaultCharset())), -1L);
            resourceStore.checkAndPutResource("PROJECT/res2", ByteSource.wrap((byte[])"{}".getBytes(Charset.defaultCharset())), -1L);
            UnitOfWork.doInTransactionWithRetry(() -> {
                ResourceStore resourceStore2 = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
                UnitOfWork.get().getCopyForWriteItems().add("MODEL/1");
                UnitOfWork.get().getCopyForWriteItems().add("MODEL/2");
                UnitOfWork.get().getCopyForWriteItems().add("MODEL/3");
                resourceStore2.checkAndPutResource("MODEL/1", ByteSource.wrap((byte[])"{}".getBytes(Charset.defaultCharset())), -1L);
                resourceStore2.checkAndPutResource("MODEL/2", ByteSource.wrap((byte[])"{}".getBytes(Charset.defaultCharset())), -1L);
                resourceStore2.checkAndPutResource("MODEL/3", ByteSource.wrap((byte[])"{}".getBytes(Charset.defaultCharset())), -1L);
                Assertions.assertEquals((Object)resourceStore, (Object)resourceStore2);
                return 0;
            }, (String)"_global");
            UnitOfWork.get().getCopyForWriteItems().add("PROJECT/res3");
            resourceStore.checkAndPutResource("PROJECT/res3", ByteSource.wrap((byte[])"{}".getBytes(Charset.defaultCharset())), -1L);
            NavigableSet set = resourceStore.getMetadataStore().listAll();
            Assertions.assertEquals((int)6, (int)set.size());
            return 0;
        }, (String)"_global");
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
        Assertions.assertEquals((long)0L, (long)resourceStore.getResource("PROJECT/res").getMvcc());
        Assertions.assertEquals((long)0L, (long)resourceStore.getResource("PROJECT/res2").getMvcc());
        Assertions.assertEquals((long)0L, (long)resourceStore.getResource("MODEL/1").getMvcc());
        Assertions.assertEquals((long)0L, (long)resourceStore.getResource("MODEL/2").getMvcc());
        Assertions.assertEquals((long)0L, (long)resourceStore.getResource("MODEL/3").getMvcc());
        Assertions.assertEquals((long)0L, (long)resourceStore.getResource("PROJECT/res3").getMvcc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testReadLockExclusive() {
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
        resourceStore.checkAndPutResource("PROJECT/res1", ByteSource.wrap((byte[])"{}".getBytes(Charset.defaultCharset())), -1L);
        Object condition = new Object();
        AtomicBoolean stop = new AtomicBoolean();
        ResourceStore kylinMetaStore = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
        Thread readLockHelder = new Thread(() -> UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)UnitOfWorkParams.builder().unitName("_global").readonly(true).maxRetry(1).processor(() -> {
            kylinMetaStore.getResource("PROJECT/res1");
            Object object = condition;
            synchronized (object) {
                condition.notify();
            }
            boolean interrupted = false;
            while (!(interrupted || Thread.interrupted() || stop.get())) {
                Object object2 = condition;
                synchronized (object2) {
                    condition.notify();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            return 0;
        }).build()));
        readLockHelder.start();
        Object object = condition;
        synchronized (object) {
            try {
                condition.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)UnitOfWorkParams.builder().unitName("_global").readonly(true).maxRetry(1).processor(() -> {
            Assertions.assertEquals((long)0L, (long)kylinMetaStore.getResource("PROJECT/res1").getMvcc());
            return 0;
        }).build());
        new Thread(() -> {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            stop.set(true);
        }).start();
        long writeStart = System.currentTimeMillis();
        try {
            UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)UnitOfWorkParams.builder().unitName("_global").readonly(false).maxRetry(1).processor(() -> {
                UnitOfWork.get().getCopyForWriteItems().add("PROJECT/res1");
                long cost = System.currentTimeMillis() - writeStart;
                Assertions.assertEquals((long)0L, (long)kylinMetaStore.getResource("PROJECT/res1").getMvcc());
                return 0;
            }).build());
        }
        catch (Exception e) {
            Assertions.fail();
        }
        stop.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testWriteLockExclusive() {
        Object condition = new Object();
        AtomicBoolean stop = new AtomicBoolean();
        Thread writeLockHelder = new Thread(() -> UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)UnitOfWorkParams.builder().unitName("_global").maxRetry(1).processor(() -> {
            Object object;
            ResourceStore resourceStoreInTransaction = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            System.out.println("Write thread start to lock");
            String resPath = "PROJECT/res1";
            UnitOfWork.get().getCopyForWriteItems().add(resPath);
            resourceStoreInTransaction.getResource(resPath, true);
            resourceStoreInTransaction.checkAndPutResource(resPath, ByteSource.wrap((byte[])"{}".getBytes(Charset.defaultCharset())), -1L);
            Object object2 = condition;
            synchronized (object2) {
                condition.notify();
            }
            boolean interrupted = false;
            while (!(interrupted || Thread.interrupted() || stop.get())) {
                object = condition;
                synchronized (object) {
                    condition.notify();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            object = condition;
            synchronized (object) {
                condition.notify();
            }
            System.out.println("Write thread finished.");
            return 0;
        }).build()));
        writeLockHelder.start();
        Object object = condition;
        synchronized (object) {
            try {
                condition.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        new Thread(() -> {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            stop.set(true);
        }).start();
        long start = System.currentTimeMillis();
        UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)UnitOfWorkParams.builder().unitName("_global").maxRetry(1).processor(() -> {
            System.out.println("Read thread start to lock.");
            RawResource raw = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv()).getResource("PROJECT/res1", true);
            System.out.println("Read thread lock succeed.");
            long cost = System.currentTimeMillis() - start;
            System.out.println("Read thread cost " + cost + "ms, mvcc:" + (raw == null ? -2L : raw.getMvcc()));
            assert (raw != null);
            Assertions.assertEquals((long)0L, (long)raw.getMvcc());
            return 0;
        }).build());
        stop.set(true);
    }

    @OverwriteProp(key="kylin.env", value="PROD")
    @Test
    void testUpdateInReadTransaction() {
        try {
            ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)UnitOfWorkParams.builder().unitName("_global").readonly(true).maxRetry(1).processor(() -> {
                UnitOfWork.get().getCopyForWriteItems().add("PROJECT/res1");
                resourceStore.checkAndPutResource("PROJECT/res1", ByteSource.wrap((byte[])"{}".getBytes(Charset.defaultCharset())), -1L);
                return 0;
            }).build());
            Assertions.fail();
        }
        catch (Exception e) {
            Assertions.assertEquals(TransactionException.class, e.getClass());
        }
    }

    @Test
    public void testReadTransaction() {
        ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv()).checkAndPutResource("PROJECT/res1", ByteSource.wrap((byte[])"{}".getBytes(Charset.defaultCharset())), -1L);
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
        UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)UnitOfWorkParams.builder().unitName("_global").readonly(true).maxRetry(1).processor(() -> {
            Assertions.assertEquals((long)0L, (long)resourceStore.getResource("PROJECT/res1").getMvcc());
            return 0;
        }).build());
    }

    @Test
    public void testWriteTransaction() {
        UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)UnitOfWorkParams.builder().unitName("_global").readonly(false).maxRetry(1).processor(() -> {
            ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            UnitOfWork.get().getCopyForWriteItems().add("PROJECT/res1");
            resourceStore.checkAndPutResource("PROJECT/res1", ByteSource.wrap((byte[])"{}".getBytes(Charset.defaultCharset())), -1L);
            return 0;
        }).build());
        Assertions.assertEquals((long)0L, (long)ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv()).getResource("PROJECT/res1").getMvcc());
    }

    @Ignore(value="No need to test")
    @Test
    void testRetryMoreTimeForDeadLockException() {
        KylinConfig.getInstanceFromEnv().setProperty("kylin.env.max-seconds-for-dead-lock-retry", "2");
        long startTime = System.currentTimeMillis();
        try {
            UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)UnitOfWorkParams.builder().retryMoreTimeForDeadLockException(true).processor(() -> {
                throw new SQLTransactionRollbackException("test");
            }).build());
        }
        catch (Exception e) {
            Assertions.assertEquals(SQLTransactionRollbackException.class, e.getCause().getClass());
            Assertions.assertTrue((System.currentTimeMillis() - startTime > 2000L ? 1 : 0) != 0);
        }
    }
}

