/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.util.NavigableSet;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

@MetadataInfo
public class ResourceStoreTest {
    @Test
    public void testCreateMetaStoreUuidIfNotExist() {
        ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv()).createMetaStoreUuidIfNotExist();
        ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv()).deleteResource(ResourceStore.METASTORE_UUID_TAG);
        NavigableSet res = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv()).listResources(MetadataType.SYSTEM.name());
        Assert.assertFalse((String)"failed", (boolean)res.contains(ResourceStore.METASTORE_UUID_TAG));
        ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv()).createMetaStoreUuidIfNotExist();
        res = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv()).listResources(MetadataType.SYSTEM.name());
        Assert.assertTrue((String)"failed", (boolean)res.contains(ResourceStore.METASTORE_UUID_TAG));
    }

    @Test
    public void testCreateMetaStoreUuidUsingTwoKylinConfig() {
        KylinConfig A = KylinConfig.getInstanceFromEnv();
        ResourceStore AStore = ResourceStore.getKylinMetaStore((KylinConfig)A);
        KylinConfig B = KylinConfig.createKylinConfig((KylinConfig)A);
        ResourceStore BStore = ResourceStore.getKylinMetaStore((KylinConfig)B);
        ResourceStore.getKylinMetaStore((KylinConfig)A).createMetaStoreUuidIfNotExist();
        ResourceStore.getKylinMetaStore((KylinConfig)A).deleteResource(ResourceStore.METASTORE_UUID_TAG);
        ResourceStore.getKylinMetaStore((KylinConfig)B).createMetaStoreUuidIfNotExist();
        ResourceStore.getKylinMetaStore((KylinConfig)B).deleteResource(ResourceStore.METASTORE_UUID_TAG);
        NavigableSet res = AStore.listResources(MetadataType.SYSTEM.name());
        Assert.assertFalse((boolean)res.contains(ResourceStore.METASTORE_UUID_TAG));
        res = BStore.listResources(MetadataType.SYSTEM.name());
        Assert.assertFalse((boolean)res.contains(ResourceStore.METASTORE_UUID_TAG));
        BStore.createMetaStoreUuidIfNotExist();
        res = BStore.listResources(MetadataType.SYSTEM.name());
        Assert.assertTrue((boolean)res.contains(ResourceStore.METASTORE_UUID_TAG));
        res = AStore.listResources(MetadataType.SYSTEM.name());
        Assert.assertFalse((boolean)res.contains(ResourceStore.METASTORE_UUID_TAG));
        AStore.createMetaStoreUuidIfNotExist();
        BStore.createMetaStoreUuidIfNotExist();
    }
}

