/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.MockMetaContent;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceTool;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.resources.ProjectRawResource;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.TestUtils;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@MetadataInfo
class RawResourceTest {
    RawResourceTest() {
    }

    @Test
    void testRawResourceByteSourceSerializer() throws IOException {
        MockMetaContent mockContent = new MockMetaContent("abc", 18);
        byte[] mockContentJson = JsonUtil.writeValueAsBytes((Object)mockContent);
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)TestUtils.getTestConfig());
        String resPath = MetadataType.mergeKeyWithType((String)"abc", (MetadataType)MetadataType.SYSTEM);
        resourceStore.putResourceWithoutCheck(resPath, ByteSource.wrap((byte[])mockContentJson), 123L, 101L);
        RawResource rawRes = resourceStore.getResource(resPath);
        MockMetaContent mockContentSer = (MockMetaContent)JsonUtil.readValue((byte[])rawRes.getByteSource().read(), MockMetaContent.class);
        Assertions.assertEquals((Object)"abc", (Object)mockContentSer.getName());
        Assertions.assertEquals((int)18, (int)mockContentSer.getAge());
    }

    @Test
    void testFillContentDiffFromRaw() throws IOException {
        ProjectRawResource p1 = RawResourceTool.createProjectRawResource("p1", 0L);
        ProjectRawResource p2 = RawResourceTool.createProjectRawResource("p1_copy", 1L, p1.getUuid());
        p2.fillContentDiffFromRaw((RawResource)p1);
        Assertions.assertEquals((Object)"[{\"op\":\"replace\",\"path\":\"/meta_key\",\"value\":\"p1_copy\"},{\"op\":\"replace\",\"path\":\"/name\",\"value\":\"p1_copy\"}]", (Object)new String(p2.getDiffByteSource().read(), Charset.defaultCharset()));
    }

    @Test
    void testExceptionWhenFillContentDiffFromRaw() {
        ProjectRawResource p1 = RawResourceTool.createProjectRawResource("p1", 0L);
        ProjectRawResource p2 = RawResourceTool.createProjectRawResource("p1_copy", 2L, p1.getUuid());
        Assertions.assertThrows(IllegalStateException.class, () -> p2.fillContentDiffFromRaw(null));
        Assertions.assertThrows(KylinRuntimeException.class, () -> p2.fillContentDiffFromRaw((RawResource)p1));
        p2.setMvcc(1L);
        p2.setContent("abc".getBytes());
        Assertions.assertThrows(KylinRuntimeException.class, () -> p2.fillContentDiffFromRaw((RawResource)p1));
    }

    @Test
    void testApplyContentDiffFromRaw() throws IOException {
        ProjectRawResource p1 = RawResourceTool.createProjectRawResource("p1", 0L);
        ProjectRawResource p2 = RawResourceTool.createProjectRawResource("p1_copy", 1L, p1.getUuid());
        p2.fillContentDiffFromRaw((RawResource)p1);
        RawResource diff = new RawResource();
        Assertions.assertNull((Object)RawResource.applyContentDiffFromRaw((RawResource)p1, (RawResource)diff));
        diff.setContentDiff(p2.getContentDiff());
        Assertions.assertArrayEquals((byte[])diff.getContentDiff(), (byte[])RawResource.applyContentDiffFromRaw(null, (RawResource)diff).read());
        ProjectRawResource applied = (ProjectRawResource)RawResource.constructResource((MetadataType)MetadataType.PROJECT, (ByteSource)RawResource.applyContentDiffFromRaw((RawResource)p1, (RawResource)diff));
        Assertions.assertEquals((Object)p2.getName(), (Object)applied.getName());
    }

    @Test
    void testExceptionOnApplyContentDiffFromRaw() {
        ProjectRawResource p1 = RawResourceTool.createProjectRawResource("p1", 0L);
        RawResource diff = new RawResource();
        diff.setMvcc(1L);
        diff.setContentDiff("abc".getBytes());
        Assertions.assertThrows(KylinRuntimeException.class, () -> RawResource.applyContentDiffFromRaw(null, (RawResource)diff));
        Assertions.assertThrows(KylinRuntimeException.class, () -> RawResource.applyContentDiffFromRaw((RawResource)p1, (RawResource)diff));
    }
}

