/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.type.JdbcType;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.logging.LogOutputStream;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.metadata.favorite.AsyncTaskMapper;
import org.apache.kylin.metadata.favorite.FavoriteRuleMapper;
import org.apache.kylin.metadata.favorite.ModelFavoriteRuleMapper;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffsetMapper;
import org.apache.kylin.metadata.job.JobTokenMapper;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataStoreUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataStoreUtil.class);
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    public static final String CREATE_OFFSET_TABLE = "create.queryhistoryoffset.store.table";
    public static final String CREATE_FAVORITE_RULE_TABLE = "create.favoriterule.store.table";
    public static final String CREATE_MODEL_FAVORITE_RULE_TABLE = "create.model.favoriterule.store.table";
    public static final String CREATE_ASYNC_TASK_TABLE = "create.asynctask.store.table";
    public static final String CREATE_REC_TABLE = "create.job-token.table";
    private static final Map<TableType, String> SQL_TEMPLATE_MAP = new EnumMap<TableType, String>(TableType.class);
    private static final Map<TableType, Class<?>> TABLE_MAPPER_MAP = new EnumMap(TableType.class);

    public static SqlSessionFactory getSqlSessionFactory(DataSource dataSource, String tableName, TableType type) {
        return (SqlSessionFactory)Singletons.getInstance((String)((Object)((Object)type) + "-session-factory"), SqlSessionFactory.class, clz -> {
            log.info("Start to build SqlSessionFactory");
            SpringManagedTransactionFactory transactionFactory = new SpringManagedTransactionFactory();
            Environment environment = new Environment(type.name(), (TransactionFactory)transactionFactory, dataSource);
            Configuration configuration = new Configuration(environment);
            configuration.setUseGeneratedKeys(true);
            configuration.setJdbcTypeForNull(JdbcType.NULL);
            configuration.addMapper(TABLE_MAPPER_MAP.get((Object)type));
            MetadataStoreUtil.createTableIfNotExist((BasicDataSource)dataSource, SQL_TEMPLATE_MAP.get((Object)type), tableName);
            return new SqlSessionFactoryBuilder().build(configuration);
        });
    }

    private static void createTableIfNotExist(BasicDataSource dataSource, String sqlTemplate, String tableName) throws IOException, SQLException {
        if (JdbcUtil.isTableExists((Connection)dataSource.getConnection(), (String)tableName)) {
            log.info("{} already existed in database", (Object)tableName);
            return;
        }
        Properties properties = JdbcUtil.getProperties((BasicDataSource)dataSource);
        String createTableStmt = String.format(Locale.ROOT, properties.getProperty(sqlTemplate), tableName);
        try (Connection connection = dataSource.getConnection();){
            ScriptRunner sr = new ScriptRunner(connection);
            sr.setLogWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new LogOutputStream(log), DEFAULT_CHARSET)));
            log.debug("start to create table({})", (Object)tableName);
            sr.runScript((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(createTableStmt.getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET));
            log.debug("create table finished");
        }
        if (!JdbcUtil.isTableExists((Connection)dataSource.getConnection(), (String)tableName)) {
            log.debug("failed to create table({})", (Object)tableName);
            throw new IllegalStateException(String.format(Locale.ROOT, "create table(%s) failed", tableName));
        }
        log.debug("table({}) already exists.", (Object)tableName);
    }

    static {
        SQL_TEMPLATE_MAP.put(TableType.FAVORITE_RULE, CREATE_FAVORITE_RULE_TABLE);
        SQL_TEMPLATE_MAP.put(TableType.MODEL_FAVORITE_RULE, CREATE_MODEL_FAVORITE_RULE_TABLE);
        SQL_TEMPLATE_MAP.put(TableType.QUERY_HISTORY_OFFSET, CREATE_OFFSET_TABLE);
        SQL_TEMPLATE_MAP.put(TableType.ASYNC_TASK, CREATE_ASYNC_TASK_TABLE);
        SQL_TEMPLATE_MAP.put(TableType.JOB_TOKEN, CREATE_REC_TABLE);
        TABLE_MAPPER_MAP.put(TableType.FAVORITE_RULE, FavoriteRuleMapper.class);
        TABLE_MAPPER_MAP.put(TableType.MODEL_FAVORITE_RULE, ModelFavoriteRuleMapper.class);
        TABLE_MAPPER_MAP.put(TableType.QUERY_HISTORY_OFFSET, QueryHistoryIdOffsetMapper.class);
        TABLE_MAPPER_MAP.put(TableType.ASYNC_TASK, AsyncTaskMapper.class);
        TABLE_MAPPER_MAP.put(TableType.JOB_TOKEN, JobTokenMapper.class);
    }

    public static enum TableType {
        FAVORITE_RULE,
        MODEL_FAVORITE_RULE,
        QUERY_HISTORY_OFFSET,
        ASYNC_TASK,
        JOB_TOKEN;

    }
}

