/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.List;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.security.AclManager;
import org.apache.kylin.rest.security.MutableAclRecord;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.MutableAclService;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.Sid;
import org.springframework.stereotype.Component;

@Component(value="aclService")
public class AclService
implements MutableAclService {
    private AclManager getAclManager() {
        return AclManager.getInstance(KylinConfig.getInstanceFromEnv());
    }

    public List<ObjectIdentity> findChildren(ObjectIdentity parentIdentity) {
        return this.getAclManager().findChildren(parentIdentity);
    }

    public MutableAclRecord readAcl(ObjectIdentity oid) {
        return this.getAclManager().readAcl(oid);
    }

    public Acl readAclById(ObjectIdentity object) {
        return this.getAclManager().readAclById(object);
    }

    public Acl readAclById(ObjectIdentity object, List<Sid> sids) {
        return this.readAclById(object);
    }

    public Map<ObjectIdentity, Acl> readAclsById(List<ObjectIdentity> objects) {
        return this.readAclsById(objects, null);
    }

    public Map<ObjectIdentity, Acl> readAclsById(List<ObjectIdentity> oids, List<Sid> sids) {
        return this.getAclManager().readAclsById(oids);
    }

    public MutableAcl createAcl(ObjectIdentity objectIdentity) {
        return this.getAclManager().createAcl(objectIdentity);
    }

    public void deleteAcl(ObjectIdentity objectIdentity, boolean deleteChildren) {
        this.getAclManager().deleteAcl(objectIdentity, deleteChildren);
    }

    public MutableAcl updateAcl(MutableAcl mutableAcl) throws NotFoundException {
        return this.getAclManager().updateAcl(mutableAcl);
    }

    MutableAclRecord upsertAce(MutableAclRecord acl, Sid sid, Permission perm) {
        return this.getAclManager().upsertAce(acl, sid, perm);
    }

    void batchUpsertAce(MutableAclRecord acl, Map<Sid, Permission> sidToPerm) {
        this.getAclManager().batchUpsertAce(acl, sidToPerm);
    }

    MutableAclRecord inherit(MutableAclRecord acl, MutableAclRecord parentAcl) {
        return this.getAclManager().inherit(acl, parentAcl);
    }
}

