/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.concurrent.Semaphore;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.query.exception.BusyQueryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryLimiter {
    private static final Logger logger = LoggerFactory.getLogger(QueryLimiter.class);
    private static volatile boolean isDowngrading;
    private static final ThreadLocal<Boolean> downgradeState;
    private static final Semaphore semaphore;

    private QueryLimiter() {
    }

    @VisibleForTesting
    public static Semaphore getSemaphore() {
        return semaphore;
    }

    public static synchronized void downgrade() {
        if (!isDowngrading) {
            isDowngrading = true;
            logger.info("Query server state changed to downgrade");
        } else {
            logger.debug("Query server is already in downgrading state");
        }
    }

    public static synchronized void recover() {
        if (isDowngrading) {
            isDowngrading = false;
            logger.info("Query server state changed to normal");
        } else {
            logger.debug("Query server is already in normal state");
        }
    }

    public static void tryAcquire() {
        downgradeState.set(isDowngrading);
        if (!isDowngrading) {
            return;
        }
        if (!semaphore.tryAcquire()) {
            downgradeState.set(false);
            logger.info("query: {} failed to get acquire", (Object)QueryContext.current().getQueryId());
            throw new BusyQueryException("Query rejected. Caused by query server is too busy");
        }
        logger.debug("query: {} success to get acquire", (Object)QueryContext.current().getQueryId());
    }

    public static void release() {
        if (Boolean.FALSE.equals(downgradeState.get())) {
            return;
        }
        logger.debug("query: {} release acquire, current server state: {}", (Object)QueryContext.current().getQueryId(), (Object)downgradeState.get());
        semaphore.release();
    }

    public static boolean getStatus() {
        return isDowngrading;
    }

    static {
        downgradeState = new ThreadLocal();
        semaphore = new Semaphore(KylinConfig.getInstanceFromEnv().getDowngradeParallelQueryThreshold(), true);
    }
}

