/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.table;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.Arrays;
import java.util.Locale;
import lombok.Generated;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.StringSplitter;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.DatabaseDesc;

public abstract class ATable
extends RootPersistentEntity {
    protected final DatabaseDesc database = new DatabaseDesc();
    protected String identity = null;
    protected String name;
    @JsonProperty(value="columns")
    protected ColumnDesc[] columns;

    public String getCaseSensitiveIdentity() {
        if (this.identity == null) {
            this.identity = this.getCaseSensitiveDatabase().equals("null") ? String.format(Locale.ROOT, "%s", this.getCaseSensitiveName()) : String.format(Locale.ROOT, "%s.%s", this.getCaseSensitiveDatabase(), this.getCaseSensitiveName());
        }
        return this.identity;
    }

    public String getName() {
        return this.name == null ? null : this.name.toUpperCase(Locale.ROOT);
    }

    @JsonGetter(value="name")
    public String getCaseSensitiveName() {
        return this.name;
    }

    public String getDatabase() {
        return this.database.getName().toUpperCase(Locale.ROOT);
    }

    @JsonGetter(value="database")
    public String getCaseSensitiveDatabase() {
        return this.database.getName();
    }

    @JsonSetter(value="database")
    public void setDatabase(String database) {
        this.database.setName(database);
    }

    public String resourceName() {
        return ATable.generateResourceName(this.getProject(), this.getIdentity());
    }

    public static String generateResourceName(String project, String identity) {
        return project + "." + identity;
    }

    public String getIdentity() {
        String originIdentity = this.getCaseSensitiveIdentity();
        return originIdentity.toUpperCase(Locale.ROOT);
    }

    public String getLowerCaseIdentity() {
        String originIdentity = this.getCaseSensitiveIdentity();
        return originIdentity.toLowerCase(Locale.ROOT);
    }

    @JsonSetter(value="name")
    public void setName(String name) {
        if (name != null) {
            String[] splits = StringSplitter.split((String)name, (String)".");
            if (splits.length == 2) {
                this.setDatabase(splits[0]);
                this.name = splits[1];
            } else if (splits.length == 1) {
                this.name = splits[0];
            }
            this.identity = null;
        } else {
            this.name = null;
        }
    }

    public void init(String project) {
        this.project = project;
        if (this.columns != null) {
            Arrays.sort(this.columns, (col1, col2) -> {
                Integer id1 = Integer.parseInt(col1.getId());
                Integer id2 = Integer.parseInt(col2.getId());
                return id1.compareTo(id2);
            });
            for (ColumnDesc col : this.columns) {
                col.init(this);
            }
        }
    }

    @Generated
    public ColumnDesc[] getColumns() {
        return this.columns;
    }

    @Generated
    public void setColumns(ColumnDesc[] columns) {
        this.columns = columns;
    }
}

