/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.enumerator;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Locale;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.kylin.common.util.DBUtils;
import org.apache.kylin.query.relnode.OlapContext;

public class HiveEnumerator
implements Enumerator<Object[]> {
    private final OlapContext olapContext;
    private final Object[] current;
    private ResultSet rs;
    private Connection conn;

    public HiveEnumerator(OlapContext olapContext) {
        this.olapContext = olapContext;
        this.current = new Object[olapContext.getReturnTupleInfo().size()];
    }

    public Object[] current() {
        return this.current;
    }

    public boolean moveNext() {
        if (this.rs == null) {
            this.rs = this.executeQuery();
        }
        return this.populateResult();
    }

    private ResultSet executeQuery() {
        ResultSet resultSet;
        String url = this.olapContext.getOlapSchema().getStarSchemaUrl();
        String user = this.olapContext.getOlapSchema().getStarSchemaUser();
        String pwd = this.olapContext.getOlapSchema().getStarSchemaPassword();
        String sql = this.olapContext.getSql();
        Statement stmt = null;
        try {
            this.conn = DriverManager.getConnection(url, user, pwd);
            stmt = this.conn.createStatement();
            resultSet = stmt.executeQuery(sql);
        }
        catch (SQLException e) {
            try {
                throw new IllegalStateException(url + " can't execute query " + sql, e);
            }
            catch (Throwable throwable) {
                DBUtils.closeQuietly(stmt);
                DBUtils.closeQuietly((Connection)this.conn);
                throw throwable;
            }
        }
        DBUtils.closeQuietly((Statement)stmt);
        DBUtils.closeQuietly((Connection)this.conn);
        return resultSet;
    }

    private boolean populateResult() {
        try {
            boolean hasNext = this.rs.next();
            if (hasNext) {
                List allFields = this.olapContext.getReturnTupleInfo().getAllFields();
                for (int i = 0; i < allFields.size(); ++i) {
                    Object value;
                    this.current[i] = value = this.rs.getObject(((String)allFields.get(i)).toLowerCase(Locale.ROOT));
                }
            }
            return hasNext;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Can't populate result!", e);
        }
    }

    public void reset() {
        this.close();
        this.rs = this.executeQuery();
    }

    public void close() {
        try {
            if (this.rs != null) {
                this.rs.close();
                this.rs = null;
            }
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Can't close ResultSet!", e);
        }
    }
}

