/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api.histogram;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Utils;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.LongFunction;

public final class BucketCounter
implements DistributionSummary {
    private final Registry registry;
    private final Id id;
    private final LongFunction<String> f;
    private final ConcurrentHashMap<String, Counter> counters;

    public static BucketCounter get(Registry registry, Id id, LongFunction<String> f) {
        return new BucketCounter(registry, id, f);
    }

    BucketCounter(Registry registry, Id id, LongFunction<String> f) {
        this.registry = registry;
        this.id = id;
        this.f = f;
        this.counters = new ConcurrentHashMap();
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public void record(long amount) {
        this.counter(this.f.apply(amount)).increment();
    }

    Counter counter(String bucket) {
        return Utils.computeIfAbsent(this.counters, bucket, k -> this.registry.counter(this.id.withTag("bucket", (String)k)));
    }

    @Override
    public long count() {
        return 0L;
    }

    @Override
    public long totalAmount() {
        return 0L;
    }
}

