/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.insert.InsertColumnListModel;
import org.mybatis.dynamic.sql.insert.InsertSelectModel;
import org.mybatis.dynamic.sql.insert.render.DefaultGeneralInsertStatementProvider;
import org.mybatis.dynamic.sql.insert.render.InsertRenderingUtilities;
import org.mybatis.dynamic.sql.insert.render.InsertSelectStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class InsertSelectRenderer {
    private final InsertSelectModel model;
    private final RenderingStrategy renderingStrategy;

    private InsertSelectRenderer(Builder builder) {
        this.model = Objects.requireNonNull(builder.model);
        this.renderingStrategy = Objects.requireNonNull(builder.renderingStrategy);
    }

    public InsertSelectStatementProvider render() {
        SelectStatementProvider selectStatement = this.model.selectModel().render(this.renderingStrategy);
        String statementStart = InsertRenderingUtilities.calculateInsertStatementStart(this.model.table());
        Optional<String> columnsPhrase = this.calculateColumnsPhrase();
        String renderedSelectStatement = selectStatement.getSelectStatement();
        String insertStatement = statementStart + columnsPhrase.map(StringUtilities::spaceBefore).orElse("") + StringUtilities.spaceBefore(renderedSelectStatement);
        return DefaultGeneralInsertStatementProvider.withInsertStatement(insertStatement).withParameters(selectStatement.getParameters()).build();
    }

    private Optional<String> calculateColumnsPhrase() {
        return this.model.columnList().map(this::calculateColumnsPhrase);
    }

    private String calculateColumnsPhrase(InsertColumnListModel columnList) {
        return columnList.mapColumns(SqlColumn::name).collect(Collectors.joining(", ", "(", ")"));
    }

    public static Builder withInsertSelectModel(InsertSelectModel model) {
        return new Builder().withInsertSelectModel(model);
    }

    public static class Builder {
        private InsertSelectModel model;
        private RenderingStrategy renderingStrategy;

        public Builder withInsertSelectModel(InsertSelectModel model) {
            this.model = model;
            return this;
        }

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public InsertSelectRenderer build() {
            return new InsertSelectRenderer(this);
        }
    }
}

