/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Collect;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.ImmutableSubQueryRemoveRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.LogicVisitor;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlQuantifyOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.immutables.value.Value;

@Value.Enclosing
public class SubQueryRemoveRule
extends RelRule<Config>
implements TransformationRule {
    protected SubQueryRemoveRule(Config config) {
        super(config);
        Objects.requireNonNull(config.matchHandler());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        ((Config)this.config).matchHandler().accept(this, call);
    }

    protected RexNode apply(RexSubQuery e, Set<CorrelationId> variablesSet, RelOptUtil.Logic logic, RelBuilder builder, int inputCount, int offset) {
        switch (e.getKind()) {
            case SCALAR_QUERY: {
                return SubQueryRemoveRule.rewriteScalarQuery(e, variablesSet, builder, inputCount, offset);
            }
            case ARRAY_QUERY_CONSTRUCTOR: {
                return SubQueryRemoveRule.rewriteCollection(e, SqlTypeName.ARRAY, variablesSet, builder, inputCount, offset);
            }
            case MAP_QUERY_CONSTRUCTOR: {
                return SubQueryRemoveRule.rewriteCollection(e, SqlTypeName.MAP, variablesSet, builder, inputCount, offset);
            }
            case MULTISET_QUERY_CONSTRUCTOR: {
                return SubQueryRemoveRule.rewriteCollection(e, SqlTypeName.MULTISET, variablesSet, builder, inputCount, offset);
            }
            case SOME: {
                return SubQueryRemoveRule.rewriteSome(e, variablesSet, builder);
            }
            case IN: {
                return SubQueryRemoveRule.rewriteIn(e, variablesSet, logic, builder, offset);
            }
            case EXISTS: {
                return SubQueryRemoveRule.rewriteExists(e, variablesSet, logic, builder);
            }
            case UNIQUE: {
                return SubQueryRemoveRule.rewriteUnique(e, builder);
            }
        }
        throw new AssertionError((Object)e.getKind());
    }

    private static RexNode rewriteScalarQuery(RexSubQuery e, Set<CorrelationId> variablesSet, RelBuilder builder, int inputCount, int offset) {
        builder.push(e.rel);
        RelMetadataQuery mq = e.rel.getCluster().getMetadataQuery();
        Boolean unique = mq.areColumnsUnique(builder.peek(), ImmutableBitSet.of());
        if (unique == null || !unique.booleanValue()) {
            builder.aggregate(builder.groupKey(), builder.aggregateCall(SqlStdOperatorTable.SINGLE_VALUE, builder.field(0)));
        }
        builder.join(JoinRelType.LEFT, (RexNode)builder.literal(true), variablesSet);
        return SubQueryRemoveRule.field(builder, inputCount, offset);
    }

    private static RexNode rewriteCollection(RexSubQuery e, SqlTypeName collectionType, Set<CorrelationId> variablesSet, RelBuilder builder, int inputCount, int offset) {
        builder.push(e.rel);
        builder.push(Collect.create(builder.build(), collectionType, "x"));
        builder.join(JoinRelType.INNER, (RexNode)builder.literal(true), variablesSet);
        return SubQueryRemoveRule.field(builder, inputCount, offset);
    }

    private static RexNode rewriteSome(RexSubQuery e, Set<CorrelationId> variablesSet, RelBuilder builder) {
        RexNode caseRexNode;
        block13: {
            SqlAggFunction minMax;
            RexLiteral literalUnknown;
            RexLiteral literalTrue;
            RexLiteral literalFalse;
            SqlQuantifyOperator op;
            block12: {
                op = (SqlQuantifyOperator)e.op;
                switch (op.comparisonKind) {
                    case GREATER_THAN_OR_EQUAL: 
                    case LESS_THAN_OR_EQUAL: 
                    case LESS_THAN: 
                    case GREATER_THAN: 
                    case NOT_EQUALS: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("unexpected " + op));
                    }
                }
                literalFalse = builder.literal(false);
                literalTrue = builder.literal(true);
                literalUnknown = builder.getRexBuilder().makeNullLiteral(((RexNode)literalFalse).getType());
                SqlAggFunction sqlAggFunction = minMax = op.comparisonKind == SqlKind.GREATER_THAN || op.comparisonKind == SqlKind.GREATER_THAN_OR_EQUAL ? SqlStdOperatorTable.MIN : SqlStdOperatorTable.MAX;
                if (!variablesSet.isEmpty()) break block12;
                switch (op.comparisonKind) {
                    case GREATER_THAN_OR_EQUAL: 
                    case LESS_THAN_OR_EQUAL: 
                    case LESS_THAN: 
                    case GREATER_THAN: {
                        builder.push(e.rel).aggregate(builder.groupKey(), builder.aggregateCall(minMax, builder.field(0)).as("m"), builder.count(false, "c", new RexNode[0]), builder.count(false, "d", builder.field(0))).as("q").join(JoinRelType.INNER, new String[0]);
                        caseRexNode = builder.call((SqlOperator)SqlStdOperatorTable.CASE, builder.equals(builder.field("q", "c"), builder.literal(0)), literalFalse, builder.call((SqlOperator)SqlStdOperatorTable.IS_TRUE, builder.call(RexUtil.op(op.comparisonKind), (RexNode)e.operands.get(0), builder.field("q", "m"))), literalTrue, builder.greaterThan(builder.field("q", "c"), builder.field("q", "d")), literalUnknown, builder.call(RexUtil.op(op.comparisonKind), (RexNode)e.operands.get(0), builder.field("q", "m")));
                        break block13;
                    }
                    case NOT_EQUALS: {
                        builder.push(e.rel);
                        builder.distinct().aggregate(builder.groupKey(), builder.count(false, "c", new RexNode[0]), builder.count(false, "d", builder.field(0)), builder.max(builder.field(0)).as("m")).as("q").join(JoinRelType.INNER, new String[0]);
                        caseRexNode = builder.call((SqlOperator)SqlStdOperatorTable.CASE, builder.equals(builder.field("c"), builder.literal(0)), literalFalse, builder.isNull(e.getOperands().get(0)), literalUnknown, builder.and(builder.notEquals(builder.field("d"), builder.field("c")), builder.lessThanOrEqual(builder.field("d"), builder.literal(1))), builder.or(builder.notEquals((RexNode)e.operands.get(0), builder.field("q", "m")), literalUnknown), builder.equals(builder.field("d"), builder.literal(1)), builder.notEquals((RexNode)e.operands.get(0), builder.field("q", "m")), literalTrue);
                        break block13;
                    }
                    default: {
                        throw new AssertionError((Object)"not possible - per above check");
                    }
                }
            }
            String indicator = "trueLiteral";
            ArrayList<RexNode> parentQueryFields = new ArrayList<RexNode>();
            switch (op.comparisonKind) {
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN_OR_EQUAL: 
                case LESS_THAN: 
                case GREATER_THAN: {
                    builder.push(e.rel).aggregate(builder.groupKey(), builder.aggregateCall(minMax, builder.field(0)).as("m"), builder.count(false, "c", new RexNode[0]), builder.count(false, "d", builder.field(0)));
                    parentQueryFields.addAll((Collection<RexNode>)builder.fields());
                    parentQueryFields.add(builder.alias(literalTrue, "trueLiteral"));
                    builder.project(parentQueryFields).as("q");
                    builder.join(JoinRelType.LEFT, (RexNode)literalTrue, variablesSet);
                    caseRexNode = builder.call((SqlOperator)SqlStdOperatorTable.CASE, builder.isNull(builder.field("q", "trueLiteral")), literalFalse, builder.equals(builder.field("q", "c"), builder.literal(0)), literalFalse, builder.call((SqlOperator)SqlStdOperatorTable.IS_TRUE, builder.call(RexUtil.op(op.comparisonKind), (RexNode)e.operands.get(0), builder.field("q", "m"))), literalTrue, builder.greaterThan(builder.field("q", "c"), builder.field("q", "d")), literalUnknown, builder.call(RexUtil.op(op.comparisonKind), (RexNode)e.operands.get(0), builder.field("q", "m")));
                    break;
                }
                case NOT_EQUALS: {
                    builder.push(e.rel).aggregate(builder.groupKey(), builder.count(true, "c", new RexNode[0]), builder.count(true, "d", builder.field(0)), builder.max(builder.field(0)).as("m"));
                    parentQueryFields.addAll((Collection<RexNode>)builder.fields());
                    parentQueryFields.add(builder.alias(literalTrue, "trueLiteral"));
                    builder.project(parentQueryFields).as("q");
                    builder.join(JoinRelType.LEFT, (RexNode)literalTrue, variablesSet);
                    caseRexNode = builder.call((SqlOperator)SqlStdOperatorTable.CASE, builder.isNull(builder.field("q", "trueLiteral")), literalFalse, builder.equals(builder.field("c"), builder.literal(0)), literalFalse, builder.isNull(e.getOperands().get(0)), literalUnknown, builder.and(builder.notEquals(builder.field("d"), builder.field("c")), builder.lessThanOrEqual(builder.field("d"), builder.literal(1))), builder.or(builder.notEquals((RexNode)e.operands.get(0), builder.field("q", "m")), literalUnknown), builder.equals(builder.field("d"), builder.literal(1)), builder.notEquals((RexNode)e.operands.get(0), builder.field("q", "m")), literalTrue);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"not possible - per above check");
                }
            }
        }
        if (!e.getType().isNullable()) {
            return builder.cast(caseRexNode, e.getType().getSqlTypeName());
        }
        return caseRexNode;
    }

    private static RexNode rewriteExists(RexSubQuery e, Set<CorrelationId> variablesSet, RelOptUtil.Logic logic, RelBuilder builder) {
        builder.push(e.rel);
        builder.project(builder.alias(builder.literal(true), "i"));
        switch (logic) {
            case TRUE: {
                builder.aggregate(builder.groupKey(0), new RelBuilder.AggCall[0]);
                builder.as("dt");
                builder.join(JoinRelType.INNER, (RexNode)builder.literal(true), variablesSet);
                return builder.literal(true);
            }
        }
        builder.distinct();
        builder.as("dt");
        builder.join(JoinRelType.LEFT, (RexNode)builder.literal(true), variablesSet);
        return builder.isNotNull(Util.last(builder.fields()));
    }

    private static RexNode rewriteUnique(RexSubQuery e, RelBuilder builder) {
        RelMetadataQuery mq = e.rel.getCluster().getMetadataQuery();
        Boolean isUnique = mq.areRowsUnique(e.rel, true);
        if (isUnique != null && isUnique.booleanValue()) {
            return builder.getRexBuilder().makeLiteral(true);
        }
        builder.push(e.rel);
        List notNullCondition = builder.fields().stream().map(builder::isNotNull).collect(Collectors.toList());
        builder.filter(notNullCondition).aggregate(builder.groupKey((Iterable<? extends RexNode>)builder.fields()), builder.countStar("c")).filter(builder.greaterThan(Util.last(builder.fields()), builder.literal(1)));
        RelNode relNode = builder.build();
        return builder.call((SqlOperator)SqlStdOperatorTable.NOT, RexSubQuery.exists(relNode));
    }

    private static RexNode rewriteIn(RexSubQuery e, Set<CorrelationId> variablesSet, RelOptUtil.Logic logic, RelBuilder builder, int offset) {
        builder.push(e.rel);
        ArrayList<RexNode> fields = new ArrayList<RexNode>((Collection<RexNode>)builder.fields());
        boolean allLiterals = RexUtil.allLiterals(e.getOperands());
        ArrayList<RexNode> expressionOperands = new ArrayList<RexNode>(e.getOperands());
        List keyIsNulls = e.getOperands().stream().filter(operand -> operand.getType().isNullable()).map(builder::isNull).collect(Collectors.toList());
        RexLiteral trueLiteral = builder.literal(true);
        RexLiteral falseLiteral = builder.literal(false);
        RexLiteral unknownLiteral = builder.getRexBuilder().makeNullLiteral(trueLiteral.getType());
        if (allLiterals) {
            List conditions = Pair.zip(expressionOperands, fields).stream().map(pair -> builder.equals((RexNode)pair.left, (RexNode)pair.right)).collect(Collectors.toList());
            switch (logic) {
                case TRUE: 
                case TRUE_FALSE: {
                    builder.filter(conditions);
                    builder.project(builder.alias(trueLiteral, "cs"));
                    builder.distinct();
                    break;
                }
                default: {
                    List isNullOperands = fields.stream().map(builder::isNull).collect(Collectors.toList());
                    isNullOperands.addAll(keyIsNulls);
                    builder.filter(builder.or(builder.and(conditions), builder.or(isNullOperands)));
                    RexNode project = builder.and(fields.stream().map(builder::isNotNull).collect(Collectors.toList()));
                    builder.project(builder.alias(project, "cs"));
                    if (variablesSet.isEmpty()) {
                        builder.aggregate(builder.groupKey(builder.field("cs")), builder.count(false, "c", new RexNode[0]));
                        builder.sortLimit(0, 1, (Iterable<? extends RexNode>)ImmutableList.of((Object)builder.desc(builder.field("cs"))));
                        break;
                    }
                    builder.distinct();
                }
            }
            expressionOperands.clear();
            fields.clear();
        } else {
            switch (logic) {
                case TRUE: {
                    builder.aggregate(builder.groupKey(fields), new RelBuilder.AggCall[0]);
                    break;
                }
                case TRUE_FALSE_UNKNOWN: 
                case UNKNOWN_AS_TRUE: {
                    builder.aggregate(builder.groupKey(), builder.count(false, "c", new RexNode[0]), builder.count((Iterable<? extends RexNode>)builder.fields()).as("ck"));
                    builder.as("ct");
                    if (!variablesSet.isEmpty()) {
                        builder.join(JoinRelType.LEFT, (RexNode)trueLiteral, variablesSet);
                    } else {
                        builder.join(JoinRelType.INNER, (RexNode)trueLiteral, variablesSet);
                    }
                    offset += 2;
                    builder.push(e.rel);
                }
                default: {
                    fields.add(builder.alias(trueLiteral, "i"));
                    builder.project(fields);
                    builder.distinct();
                }
            }
        }
        builder.as("dt");
        int refOffset = offset;
        List conditions = Pair.zip(expressionOperands, builder.fields()).stream().map(pair -> builder.equals((RexNode)pair.left, RexUtil.shift((RexNode)pair.right, refOffset))).collect(Collectors.toList());
        switch (logic) {
            case TRUE: {
                builder.join(JoinRelType.INNER, builder.and(conditions), variablesSet);
                return trueLiteral;
            }
        }
        builder.join(JoinRelType.LEFT, builder.and(conditions), variablesSet);
        ImmutableList.Builder operands = ImmutableList.builder();
        RexLiteral b = trueLiteral;
        switch (logic) {
            case TRUE_FALSE_UNKNOWN: {
                b = unknownLiteral;
            }
            case UNKNOWN_AS_TRUE: {
                if (allLiterals) {
                    if (variablesSet.isEmpty()) {
                        operands.add((Object[])new RexNode[]{builder.isNull(builder.field("c")), falseLiteral});
                    }
                    operands.add((Object[])new RexNode[]{builder.equals(builder.field("cs"), falseLiteral), b});
                    break;
                }
                operands.add((Object[])new RexNode[]{builder.equals(builder.field("ct", "c"), builder.literal(0)), falseLiteral});
                break;
            }
        }
        if (!keyIsNulls.isEmpty()) {
            operands.add((Object[])new RexNode[]{builder.or(keyIsNulls), unknownLiteral});
        }
        if (allLiterals) {
            operands.add((Object[])new RexNode[]{builder.isNotNull(builder.field("cs")), trueLiteral});
        } else {
            operands.add((Object[])new RexNode[]{builder.isNotNull(Util.last(builder.fields())), trueLiteral});
        }
        if (!allLiterals) {
            switch (logic) {
                case TRUE_FALSE_UNKNOWN: 
                case UNKNOWN_AS_TRUE: {
                    operands.add((Object[])new RexNode[]{builder.lessThan(builder.field("ct", "ck"), builder.field("ct", "c")), b});
                    break;
                }
            }
        }
        operands.add((Object)falseLiteral);
        return builder.call((SqlOperator)SqlStdOperatorTable.CASE, (Iterable<? extends RexNode>)operands.build());
    }

    private static RexInputRef field(RelBuilder builder, int inputCount, int offset) {
        int inputOrdinal = 0;
        RelNode r;
        while (offset >= (r = builder.peek(inputCount, inputOrdinal)).getRowType().getFieldCount()) {
            ++inputOrdinal;
            offset -= r.getRowType().getFieldCount();
        }
        return builder.field(inputCount, inputOrdinal, offset);
    }

    private static List<RexNode> fields(RelBuilder builder, int fieldCount) {
        ArrayList<RexNode> projects = new ArrayList<RexNode>();
        for (int i = 0; i < fieldCount; ++i) {
            projects.add(builder.field(i));
        }
        return projects;
    }

    private static void matchProject(SubQueryRemoveRule rule, RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        RelBuilder builder = call.builder();
        RexSubQuery e = RexUtil.SubQueryFinder.find(project.getProjects());
        assert (e != null);
        RelOptUtil.Logic logic = LogicVisitor.find(RelOptUtil.Logic.TRUE_FALSE_UNKNOWN, project.getProjects(), e);
        builder.push(project.getInput());
        int fieldCount = builder.peek().getRowType().getFieldCount();
        Set<CorrelationId> variablesSet = RelOptUtil.getVariablesUsed(e.rel);
        RexNode target = rule.apply(e, variablesSet, logic, builder, 1, fieldCount);
        ReplaceSubQueryShuttle shuttle = new ReplaceSubQueryShuttle(e, target);
        builder.project(shuttle.apply(project.getProjects()), project.getRowType().getFieldNames());
        call.transformTo(builder.build());
    }

    private static void matchFilter(SubQueryRemoveRule rule, RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        RelBuilder builder = call.builder();
        builder.push(filter.getInput());
        int count = 0;
        RexNode c = filter.getCondition();
        while (true) {
            RexSubQuery e;
            if ((e = RexUtil.SubQueryFinder.find(c)) == null) {
                assert (count > 0);
                break;
            }
            ++count;
            RelOptUtil.Logic logic = LogicVisitor.find(RelOptUtil.Logic.TRUE, (List<RexNode>)ImmutableList.of((Object)c), e);
            Set<CorrelationId> variablesSet = RelOptUtil.getVariablesUsed(e.rel);
            RexNode target = rule.apply(e, variablesSet, logic, builder, 1, builder.peek().getRowType().getFieldCount());
            ReplaceSubQueryShuttle shuttle = new ReplaceSubQueryShuttle(e, target);
            c = c.accept(shuttle);
        }
        builder.filter(c);
        builder.project(SubQueryRemoveRule.fields(builder, filter.getRowType().getFieldCount()));
        call.transformTo(builder.build());
    }

    private static void matchJoin(SubQueryRemoveRule rule, RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        RelBuilder builder = call.builder();
        RexSubQuery e = RexUtil.SubQueryFinder.find(join.getCondition());
        assert (e != null);
        RelOptUtil.Logic logic = LogicVisitor.find(RelOptUtil.Logic.TRUE, (List<RexNode>)ImmutableList.of((Object)join.getCondition()), e);
        builder.push(join.getLeft());
        builder.push(join.getRight());
        int fieldCount = join.getRowType().getFieldCount();
        Set<CorrelationId> variablesSet = RelOptUtil.getVariablesUsed(e.rel);
        RexNode target = rule.apply(e, variablesSet, logic, builder, 2, fieldCount);
        ReplaceSubQueryShuttle shuttle = new ReplaceSubQueryShuttle(e, target);
        builder.join(join.getJoinType(), shuttle.apply(join.getCondition()));
        builder.project(SubQueryRemoveRule.fields(builder, join.getRowType().getFieldCount()));
        call.transformTo(builder.build());
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RelRule.Config {
        public static final Config PROJECT = ImmutableSubQueryRemoveRule.Config.builder().withMatchHandler((x$0, x$1) -> SubQueryRemoveRule.access$200(x$0, x$1)).build().withOperandSupplier(b -> b.operand(Project.class).predicate(RexUtil.SubQueryFinder::containsSubQuery).anyInputs()).withDescription("SubQueryRemoveRule:Project");
        public static final Config FILTER = ImmutableSubQueryRemoveRule.Config.builder().withMatchHandler((x$0, x$1) -> SubQueryRemoveRule.access$100(x$0, x$1)).build().withOperandSupplier(b -> b.operand(Filter.class).predicate(RexUtil.SubQueryFinder::containsSubQuery).anyInputs()).withDescription("SubQueryRemoveRule:Filter");
        public static final Config JOIN = ImmutableSubQueryRemoveRule.Config.builder().withMatchHandler((x$0, x$1) -> SubQueryRemoveRule.access$000(x$0, x$1)).build().withOperandSupplier(b -> b.operand(Join.class).predicate(RexUtil.SubQueryFinder::containsSubQuery).anyInputs()).withDescription("SubQueryRemoveRule:Join");

        @Override
        default public SubQueryRemoveRule toRule() {
            return new SubQueryRemoveRule(this);
        }

        public RelRule.MatchHandler<SubQueryRemoveRule> matchHandler();

        public Config withMatchHandler(RelRule.MatchHandler<SubQueryRemoveRule> var1);
    }

    private static class ReplaceSubQueryShuttle
    extends RexShuttle {
        private final RexSubQuery subQuery;
        private final RexNode replacement;

        ReplaceSubQueryShuttle(RexSubQuery subQuery, RexNode replacement) {
            this.subQuery = subQuery;
            this.replacement = replacement;
        }

        @Override
        public RexNode visitSubQuery(RexSubQuery subQuery) {
            return subQuery.equals(this.subQuery) ? this.replacement : subQuery;
        }
    }
}

