/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.types;

import io.delta.standalone.types.DataType;
import java.util.Objects;

public final class ArrayType
extends DataType {
    private final DataType elementType;
    private final boolean containsNull;

    public ArrayType(DataType dataType, boolean bl) {
        this.elementType = dataType;
        this.containsNull = bl;
    }

    public DataType getElementType() {
        return this.elementType;
    }

    public boolean containsNull() {
        return this.containsNull;
    }

    protected void buildFormattedString(String string, StringBuilder stringBuilder) {
        String string2 = string + "    |";
        stringBuilder.append(String.format("%s-- element: %s (containsNull = %b)\n", string, this.elementType.getTypeName(), this.containsNull));
        DataType.buildFormattedString(this.elementType, string2, stringBuilder);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ArrayType arrayType = (ArrayType)object;
        return this.containsNull == arrayType.containsNull && Objects.equals(this.elementType, arrayType.elementType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.elementType, this.containsNull);
    }
}

