/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.filter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.engine.spark.filter.QueryFiltersCollector;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetBloomFilter {
    public static final Logger LOGGER = LoggerFactory.getLogger(ParquetBloomFilter.class);
    private static final SortedSet<ColumnFilter> columnFilters = new TreeSet<ColumnFilter>();
    private static boolean loaded = false;
    private static final List<String> buildBloomColumns = Lists.newArrayList();

    public static void registerBloomColumnIfNeed(String project, String modelId) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (!config.isBloomBuildEnabled()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)project) || StringUtils.isBlank((CharSequence)modelId)) {
            return;
        }
        if (loaded) {
            return;
        }
        try {
            project = StringUtils.upperCase((String)project);
            FileSystem fs = HadoopUtil.getFileSystem((String)config.getHdfsWorkingDirectory());
            Path filterInfo = new Path(QueryFiltersCollector.FILTER_STORAGE_PATH);
            if (!fs.exists(filterInfo)) {
                loaded = true;
                return;
            }
            FileStatus[] hostsDir = fs.listStatus(new Path(QueryFiltersCollector.FILTER_STORAGE_PATH));
            HashMap columnsHits = Maps.newHashMap();
            for (FileStatus host : hostsDir) {
                Map modelColumns;
                String hostName = host.getPath().getName();
                Path projectFiltersFile = QueryFiltersCollector.getProjectFiltersFile(hostName, project);
                if (!fs.exists(projectFiltersFile) || !(modelColumns = (Map)JsonUtil.readValue((String)HadoopUtil.readStringFromHdfs((FileSystem)fs, (Path)projectFiltersFile), Map.class)).containsKey(modelId)) continue;
                ((Map)modelColumns.get(modelId)).forEach((column, hit) -> {
                    int originHit = columnsHits.getOrDefault(column, 0);
                    columnsHits.put(column, originHit + hit);
                });
            }
            columnsHits.forEach((column, hit) -> columnFilters.add(new ColumnFilter((String)column, (int)hit)));
            String columnFiltersLog = Arrays.toString(columnFilters.toArray());
            LOGGER.info("Register BloomFilter info from HDFS: {}", (Object)columnFiltersLog);
        }
        catch (Exception e) {
            LOGGER.error("Error when register BloomFilter.", (Throwable)e);
        }
        loaded = true;
    }

    public static void configBloomColumnIfNeed(Dataset<Row> data, DataFrameWriter<Row> dataWriter) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (!config.isBloomBuildEnabled()) {
            return;
        }
        String manualColumn = config.getBloomBuildColumn();
        String bloomColumnIds = config.getBloomBuildColumnIds();
        if (StringUtils.isNotBlank((CharSequence)manualColumn)) {
            String[] blooms = manualColumn.split("#");
            for (int i = 0; i < blooms.length; i += 2) {
                String nvd = blooms[i + 1];
                dataWriter.option("parquet.bloom.filter.enabled#" + blooms[i], "true");
                dataWriter.option("parquet.bloom.filter.expected.ndv#" + blooms[i], nvd);
                LOGGER.info("build BloomFilter info: columnId is {}, nvd is {}", (Object)blooms[i], (Object)nvd);
                buildBloomColumns.add(blooms[i]);
            }
            return;
        }
        dataWriter.option("parquet.bloom.filter.dynamic.enabled", "true");
        dataWriter.option("parquet.bloom.filter.candidate.size", "10");
        if (StringUtils.isNotBlank((CharSequence)bloomColumnIds)) {
            String[] blooms = bloomColumnIds.split("#");
            for (int i = 0; i < blooms.length; ++i) {
                dataWriter.option("parquet.bloom.filter.enabled#" + blooms[i], "true");
                LOGGER.info("build dynamic BloomFilter info: columnIds is {}", (Object)blooms[i]);
                buildBloomColumns.add(blooms[i]);
            }
            return;
        }
        Set columns = Arrays.stream(data.columns()).collect(Collectors.toSet());
        Set dataColumns = columnFilters.stream().filter(column -> columns.contains(((ColumnFilter)column).columnId)).collect(Collectors.toSet());
        int count = 0;
        for (ColumnFilter columnFilter : dataColumns) {
            if (count >= config.getBloomBuildColumnMaxNum()) break;
            dataWriter.option("parquet.bloom.filter.enabled#" + columnFilter.columnId, "true");
            buildBloomColumns.add(columnFilter.columnId);
            LOGGER.info("building BloomFilter : columnId is {}", (Object)columnFilter.columnId);
            ++count;
        }
    }

    private ParquetBloomFilter() {
    }

    public static void resetParquetBloomFilter() {
        loaded = false;
        buildBloomColumns.clear();
        columnFilters.clear();
    }

    public static List<String> getBuildBloomColumns() {
        return buildBloomColumns;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static class ColumnFilter
    implements Comparable<ColumnFilter> {
        private String columnId;
        private int hit;

        @Override
        public int compareTo(ColumnFilter o) {
            if (o.hit != this.hit) {
                return Integer.compare(o.hit, this.hit);
            }
            return o.columnId.compareTo(this.columnId);
        }

        @Generated
        public String getColumnId() {
            return this.columnId;
        }

        @Generated
        public int getHit() {
            return this.hit;
        }

        @Generated
        public void setColumnId(String columnId) {
            this.columnId = columnId;
        }

        @Generated
        public void setHit(int hit) {
            this.hit = hit;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColumnFilter)) {
                return false;
            }
            ColumnFilter other = (ColumnFilter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$columnId = this.getColumnId();
            String other$columnId = other.getColumnId();
            if (this$columnId == null ? other$columnId != null : !this$columnId.equals(other$columnId)) {
                return false;
            }
            return this.getHit() == other.getHit();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ColumnFilter;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $columnId = this.getColumnId();
            result = result * 59 + ($columnId == null ? 43 : $columnId.hashCode());
            result = result * 59 + this.getHit();
            return result;
        }

        @Generated
        public String toString() {
            return "ParquetBloomFilter.ColumnFilter(columnId=" + this.getColumnId() + ", hit=" + this.getHit() + ")";
        }

        @Generated
        public ColumnFilter(String columnId, int hit) {
            this.columnId = columnId;
            this.hit = hit;
        }

        @Generated
        public ColumnFilter() {
        }
    }
}

