/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.rest.JobFilter;
import org.apache.kylin.job.util.JobContextUtil;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.view.LogicalView;
import org.apache.kylin.metadata.view.LogicalViewManager;
import org.apache.kylin.rest.controller.BaseController;
import org.apache.kylin.rest.request.JobErrorRequest;
import org.apache.kylin.rest.request.JobUpdateRequest;
import org.apache.kylin.rest.request.LoadGlutenCacheRequest;
import org.apache.kylin.rest.request.ReplaceMetaRequest;
import org.apache.kylin.rest.request.SparkJobTimeRequest;
import org.apache.kylin.rest.request.SparkJobUpdateRequest;
import org.apache.kylin.rest.request.StageRequest;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.EventResponse;
import org.apache.kylin.rest.response.ExecutableResponse;
import org.apache.kylin.rest.response.ExecutableStepResponse;
import org.apache.kylin.rest.response.JobStatisticsResponse;
import org.apache.kylin.rest.service.JobInfoService;
import org.apache.kylin.rest.service.JobService;
import org.apache.kylin.rest.service.RouteService;
import org.apache.kylin.util.DumpInfo;
import org.apache.kylin.util.MetadataDumpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/jobs"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class JobController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger((String)"schedule");
    private static final String JOB_ID_ARG_NAME = "jobId";
    private static final String STEP_ID_ARG_NAME = "stepId";
    @Autowired
    @Qualifier(value="jobService")
    private JobService jobService;
    @Autowired
    private JobInfoService jobInfoService;
    @Autowired
    private RouteService routeService;

    protected Logger getLogger() {
        return logger;
    }

    @ApiOperation(value="getJobList", tags={"DW"}, notes="Update Param: job_names, time_filter, subject_alias, project_name, page_offset, page_size, sort_by; Update Response: total_size")
    @GetMapping(value={""})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<ExecutableResponse>>> getJobList(@RequestParam(value="statuses", required=false, defaultValue="") List<String> statuses, @RequestParam(value="job_names", required=false) List<String> jobNames, @RequestParam(value="time_filter") Integer timeFilter, @RequestParam(value="subject", required=false) String subject, @RequestParam(value="key", required=false) String key, @RequestParam(value="exact", required=false, defaultValue="false") boolean exactMatch, @RequestParam(value="project", required=false) String project, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="sort_by", required=false, defaultValue="last_modified") String sortBy, @RequestParam(value="reverse", required=false, defaultValue="true") boolean reverse, @RequestParam(value="type", required=false) List<String> types) {
        this.jobInfoService.checkJobStatus(statuses);
        jobNames = CollectionUtils.isEmpty(jobNames) ? Lists.newArrayList() : jobNames;
        types = CollectionUtils.isEmpty(types) ? Lists.newArrayList() : types;
        jobNames.addAll(types);
        if (jobNames.stream().anyMatch(type -> Objects.isNull(JobTypeEnum.getEnumByName((String)type)))) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_TYPE_ILLEGAL, new Object[0]);
        }
        this.checkRequiredArg("time_filter", timeFilter);
        if (jobNames.isEmpty()) {
            jobNames = JobTypeEnum.BUILD_JOB_TYPES;
        }
        JobFilter jobFilter = new JobFilter(this.jobInfoService.parseJobStatus(statuses), jobNames, timeFilter.intValue(), subject, key, exactMatch, project, sortBy, reverse);
        Integer pageOffsetNew = pageOffset * pageSize;
        List result = this.jobInfoService.listJobs(jobFilter, pageOffsetNew.intValue(), pageSize.intValue());
        long count = this.jobInfoService.countJobs(jobFilter);
        DataResult executables = new DataResult((Collection)result, (int)count, pageOffset.intValue(), pageSize.intValue());
        return new EnvelopeResponse("000", (Object)executables, "");
    }

    @ApiOperation(value="dropJob dropGlobalJob", tags={"DW"}, notes="Update URL: {project}; Update Param: project, job_ids")
    @DeleteMapping(value={""})
    @ResponseBody
    public EnvelopeResponse<String> dropJob(@RequestParam(value="project", required=false) String project, @RequestParam(value="job_ids", required=false) List<String> jobIds, @RequestParam(value="statuses", required=false) List<String> statuses) throws IOException {
        this.jobInfoService.checkJobStatus(statuses);
        if (StringUtils.isBlank((CharSequence)project) && CollectionUtils.isEmpty(jobIds)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_ID_EMPTY, new Object[]{"delete"});
        }
        if (null != project) {
            this.jobInfoService.batchDropJob(project, jobIds, statuses);
        } else {
            this.jobInfoService.batchDropGlobalJob(jobIds, statuses);
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updateJobStatus", tags={"DW"}, notes="Update Body: job_ids")
    @PutMapping(value={"/status"})
    @ResponseBody
    public EnvelopeResponse<String> updateJobStatus(@RequestBody JobUpdateRequest jobUpdateRequest, @RequestHeader HttpHeaders headers) throws IOException {
        this.checkRequiredArg("action", jobUpdateRequest.getAction());
        this.jobInfoService.checkJobStatusAndAction(jobUpdateRequest);
        Map nodeWithJobs = JobContextUtil.splitJobIdsByScheduleInstance((List)jobUpdateRequest.getJobIds());
        if (this.needRouteToOtherInstance(nodeWithJobs, jobUpdateRequest.getAction())) {
            return this.remoteUpdateJobStatus(jobUpdateRequest, headers, nodeWithJobs);
        }
        if (StringUtils.isBlank((CharSequence)jobUpdateRequest.getProject()) && CollectionUtils.isEmpty((Collection)jobUpdateRequest.getJobIds())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_ID_EMPTY, new Object[]{jobUpdateRequest.getAction()});
        }
        this.jobInfoService.batchUpdateJobStatus(jobUpdateRequest.getJobIds(), jobUpdateRequest.getProject(), jobUpdateRequest.getAction(), jobUpdateRequest.getStatuses());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    private EnvelopeResponse<String> remoteUpdateJobStatus(JobUpdateRequest jobUpdateRequest, HttpHeaders headers, Map<String, List<String>> nodeWithJobs) throws IOException {
        for (Map.Entry<String, List<String>> entry : nodeWithJobs.entrySet()) {
            jobUpdateRequest.setJobIds(entry.getValue());
            this.forwardRequestToTargetNode(JsonUtil.writeValueAsBytes((Object)jobUpdateRequest), headers, entry.getKey(), "/jobs/status");
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="getJobDetail", tags={"DW"}, notes="Update Param: job_id")
    @GetMapping(value={"/{job_id:.+}/detail"})
    @ResponseBody
    public EnvelopeResponse<List<ExecutableStepResponse>> getJobDetail(@PathVariable(value="job_id") String jobId, @RequestParam(value="project") String project) {
        this.checkProjectName(project);
        this.checkRequiredArg(JOB_ID_ARG_NAME, jobId);
        return new EnvelopeResponse("000", (Object)this.jobInfoService.getJobDetail(project, jobId), "");
    }

    @ApiOperation(value="updateJobStatus", tags={"DW"}, notes="Update URL: {job_id}, {step_id}; Update Param: job_id, step_id")
    @GetMapping(value={"/{job_id:.+}/steps/{step_id:.+}/output"})
    @ResponseBody
    public EnvelopeResponse<Map<String, String>> getJobOutput(@PathVariable(value="job_id") String jobId, @PathVariable(value="step_id") String stepId, @RequestParam(value="project") String project) {
        this.checkProjectName(project);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(JOB_ID_ARG_NAME, jobId);
        result.put(STEP_ID_ARG_NAME, stepId);
        result.put("cmd_output", this.jobInfoService.getJobOutput(project, jobId, stepId));
        return new EnvelopeResponse("000", result, "");
    }

    @ApiOperation(value="downloadLogFile", tags={"DW"}, notes="Update URL: {job_id}, {step_id}; Update Param: job_id, step_id")
    @GetMapping(value={"/{job_id:.+}/steps/{step_id:.+}/log"})
    @ResponseBody
    public EnvelopeResponse<String> downloadLogFile(@PathVariable(value="job_id") String jobId, @PathVariable(value="step_id") String stepId, @RequestParam(value="project") String project, HttpServletResponse response) {
        String projectName = this.checkProjectName(project);
        this.checkRequiredArg(JOB_ID_ARG_NAME, jobId);
        this.checkRequiredArg(STEP_ID_ARG_NAME, stepId);
        String downloadFilename = String.format(Locale.ROOT, "%s_%s.log", projectName, stepId);
        InputStream jobOutput = this.jobInfoService.getAllJobOutput(projectName, jobId, stepId);
        this.setDownloadResponse(jobOutput, downloadFilename, "application/octet-stream", response);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @GetMapping(value={"/statistics"})
    @ApiOperation(value="jobStatistics", tags={"DW"})
    @ResponseBody
    public EnvelopeResponse<JobStatisticsResponse> getJobStats(@RequestParam(value="project") String project, @RequestParam(value="start_time") long startTime, @RequestParam(value="end_time") long endTime) {
        this.checkProjectName(project);
        return new EnvelopeResponse("000", (Object)this.jobService.getJobStats(project, startTime, endTime), "");
    }

    @GetMapping(value={"/statistics/count"})
    @ApiOperation(value="jobStatisticsCount", tags={"DW"})
    @ResponseBody
    public EnvelopeResponse<Map<String, Integer>> getJobCount(@RequestParam(value="project") String project, @RequestParam(value="start_time") long startTime, @RequestParam(value="end_time") long endTime, @RequestParam(value="dimension") String dimension) {
        this.checkProjectName(project);
        return new EnvelopeResponse("000", (Object)this.jobService.getJobCount(project, startTime, endTime, dimension), "");
    }

    @GetMapping(value={"/statistics/duration_per_byte"})
    @ApiOperation(value="jobDurationCount", tags={"DW"})
    @ResponseBody
    public EnvelopeResponse<Map<String, Double>> getJobDurationPerByte(@RequestParam(value="project") String project, @RequestParam(value="start_time") long startTime, @RequestParam(value="end_time") long endTime, @RequestParam(value="dimension") String dimension) {
        this.checkProjectName(project);
        return new EnvelopeResponse("000", (Object)this.jobService.getJobDurationPerByte(project, startTime, endTime, dimension), "");
    }

    @ApiOperation(value="updateJobError", tags={"DW"}, notes="Update Body: job error")
    @PutMapping(value={"error"})
    @ResponseBody
    public EnvelopeResponse<String> updateJobError(@RequestBody JobErrorRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getProject()) && StringUtils.isBlank((CharSequence)request.getJobId())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_ID_EMPTY, new Object[]{"At least one job should be selected to update stage status"});
        }
        this.checkProjectName(request.getProject());
        logger.info("updateJobError errorRequest is : {}", (Object)request);
        return this.updateJobInfoWithCheck(request.getProject(), request.getJobId(), request.getJobLastRunningStartTime(), () -> this.jobInfoService.updateJobError(request.getProject(), request.getJobId(), request.getFailedStepId(), request.getFailedSegmentId(), request.getFailedStack(), request.getFailedReason()));
    }

    @ApiOperation(value="updateStageStatus", tags={"DW"}, notes="Update Body: jobIds(stage ids)")
    @PutMapping(value={"/stage/status"})
    @ResponseBody
    public EnvelopeResponse<String> updateStageStatus(@RequestBody StageRequest stageRequest) {
        if (StringUtils.isBlank((CharSequence)stageRequest.getProject()) && StringUtils.isBlank((CharSequence)stageRequest.getTaskId())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_ID_EMPTY, new Object[]{"At least one job should be selected to update stage status"});
        }
        this.checkProjectName(stageRequest.getProject());
        logger.info("updateStageStatus stageRequest is : {}", (Object)stageRequest);
        return this.updateJobInfoWithCheck(stageRequest.getProject(), stageRequest.getTaskId(), stageRequest.getJobLastRunningStartTime(), () -> this.jobInfoService.updateStageStatus(stageRequest.getProject(), stageRequest.getTaskId(), stageRequest.getSegmentId(), stageRequest.getStatus(), stageRequest.getUpdateInfo(), stageRequest.getErrMsg()));
    }

    @PutMapping(value={"/spark"})
    @ApiOperation(value="updateURL", tags={"DW"})
    @ResponseBody
    public EnvelopeResponse<String> updateSparkJobInfo(@RequestBody SparkJobUpdateRequest sparkJobUpdateRequest) {
        this.checkProjectName(sparkJobUpdateRequest.getProject());
        return this.updateJobInfoWithCheck(sparkJobUpdateRequest.getProject(), sparkJobUpdateRequest.getJobId(), sparkJobUpdateRequest.getJobLastRunningStartTime(), () -> this.jobInfoService.updateSparkJobInfo(sparkJobUpdateRequest));
    }

    @PutMapping(value={"/wait_and_run_time"})
    @ApiOperation(value="updateWaitTime", tags={"DW"})
    @ResponseBody
    public EnvelopeResponse<String> updateSparkJobTime(@RequestBody SparkJobTimeRequest sparkJobTimeRequest) {
        this.checkProjectName(sparkJobTimeRequest.getProject());
        return this.updateJobInfoWithCheck(sparkJobTimeRequest.getProject(), sparkJobTimeRequest.getJobId(), sparkJobTimeRequest.getJobLastRunningStartTime(), () -> this.jobInfoService.updateSparkTimeInfo(sparkJobTimeRequest.getProject(), sparkJobTimeRequest.getJobId(), sparkJobTimeRequest.getTaskId(), sparkJobTimeRequest.getYarnJobWaitTime(), sparkJobTimeRequest.getYarnJobRunTime()));
    }

    private EnvelopeResponse<String> updateJobInfoWithCheck(String project, String taskOrJobId, String jobLastRunningStartTime, Runnable runner) {
        try {
            JobContextUtil.withTxAndRetry(() -> {
                this.checkJobStatus(project, taskOrJobId, jobLastRunningStartTime);
                runner.run();
                return true;
            });
        }
        catch (Exception e) {
            logger.warn("Update job info failed.", (Throwable)e);
            if (!this.checkJobStatusWithOutException(project, taskOrJobId, jobLastRunningStartTime)) {
                return new EnvelopeResponse("999", (Object)"", "Job has stopped.");
            }
            return new EnvelopeResponse("999", (Object)"", "");
        }
        return new EnvelopeResponse("000", (Object)"", "");
    }

    private boolean checkJobStatusWithOutException(String project, String jobOrTaskId, String jobLastRunningStartTime) {
        try {
            this.checkJobStatus(project, jobOrTaskId, jobLastRunningStartTime);
            return true;
        }
        catch (IllegalStateException ignored) {
            return false;
        }
    }

    private void checkJobStatus(String project, String jobOrTaskId, String jobLastRunningStartTime) {
        String jobId;
        ExecutableManager execMgr = ExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        AbstractExecutable job = execMgr.getJob(jobId = ExecutableManager.extractJobId((String)jobOrTaskId));
        if (job.getOutput().getState() != ExecutableState.RUNNING) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Job's state is : %s instead of %s !", job.getOutput().getState(), ExecutableState.RUNNING));
        }
        if (!String.valueOf(job.getOutput().getLastRunningStartTime()).equals(jobLastRunningStartTime)) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Job's lastRunningStartTime is : %s instead of %s !", job.getOutput().getLastRunningStartTime(), jobLastRunningStartTime));
        }
    }

    @Deprecated
    @ApiOperation(value="getWaitingJobs", tags={"DW"}, notes="Update Response: total_size")
    @GetMapping(value={"/waiting_jobs"})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<EventResponse>>> getWaitingJobs(@RequestParam(value="project") String project, @RequestParam(value="model") String modelId, @RequestParam(value="offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="limit", required=false, defaultValue="10") Integer limit) {
        this.checkProjectName(project);
        return new EnvelopeResponse("000", (Object)DataResult.get(null, (int)offset, (int)limit), "");
    }

    @Deprecated
    @ApiOperation(value="waitingJobsByModel", tags={"DW"})
    @GetMapping(value={"/waiting_jobs/models"})
    @ResponseBody
    public EnvelopeResponse<Map<String, Object>> getWaitingJobsInfoGroupByModel(@RequestParam(value="project") String project) {
        this.checkProjectName(project);
        return new EnvelopeResponse("000", (Object)this.jobService.getEventsInfoGroupByModel(project), "");
    }

    @PostMapping(value={"/destroy_job_process"})
    @ApiOperation(value="destroyJobProcess", tags={"DW"})
    @ResponseBody
    public void destroyJobProcess(@RequestParam(value="project") String project) {
        ExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).destroyAllProcess();
    }

    @PostMapping(value={"/replace_metadata"})
    @ApiOperation(value="replace_metadata", tags={"DW"})
    @ResponseBody
    public EnvelopeResponse<String> updateDumpedMetadata(@RequestBody ReplaceMetaRequest request) throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>();
        String project = request.getProject();
        String modelId = request.getModelId();
        String viewTable = request.getViewTable();
        String distMetaUrl = request.getDistMetaUrl();
        NDataflow df = NDataflowManager.getInstance((KylinConfig)config, (String)project).getDataflow(modelId);
        dumpList.addAll(df.collectPrecalculationResource());
        dumpList.addAll(this.getLogicalViewMetaDumpList(config, project, viewTable, modelId));
        DumpInfo dumpInfo = new DumpInfo(project, distMetaUrl, dumpList, DumpInfo.DumpType.DATA_LOADING);
        MetadataDumpUtil.dumpMetadata((DumpInfo)dumpInfo);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    private Set<String> getLogicalViewMetaDumpList(KylinConfig config, String project, String viewTable, String modelId) {
        LogicalView logicalView;
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>();
        if (!config.isDDLLogicalViewEnabled()) {
            return dumpList;
        }
        LogicalViewManager viewManager = LogicalViewManager.getInstance((KylinConfig)config);
        if (StringUtils.isNotBlank((CharSequence)modelId)) {
            Set viewsMeta = viewManager.findLogicalViewsInModel(project, modelId).stream().map(RootPersistentEntity::getResourcePath).collect(Collectors.toSet());
            dumpList.addAll(viewsMeta);
        }
        if (StringUtils.isNotBlank((CharSequence)viewTable) && (logicalView = viewManager.findLogicalViewInProject(project, viewTable)) != null) {
            dumpList.add(logicalView.getResourcePath());
        }
        return dumpList;
    }

    @ApiOperation(value="startProfile", tags={"DW"}, notes="")
    @GetMapping(value={"/profile/start_project"})
    @ResponseBody
    public EnvelopeResponse<String> profile(@RequestParam(value="project") String project, @RequestParam(value="step_id") String jobStepId, @RequestParam(value="params", defaultValue="start,event=cpu", required=false) String params, HttpServletRequest request) {
        this.jobService.setResponseLanguage(request);
        this.checkProjectName(project);
        this.jobService.startProfileByProject(project, jobStepId, params);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="dumpProfile", tags={"DW"}, notes="")
    @GetMapping(value={"/profile/dump_project"})
    @ResponseBody
    public EnvelopeResponse<String> stopProfile(@RequestParam(value="project") String project, @RequestParam(value="step_id") String jobStepId, @RequestParam(value="params", defaultValue="flamegraph", required=false) String params, HttpServletRequest request, HttpServletResponse response) {
        this.jobService.setResponseLanguage(request);
        this.checkProjectName(project);
        Pair jobOutputAndDownloadFile = new Pair();
        this.jobService.dumpProfileByProject(project, jobStepId, params, jobOutputAndDownloadFile);
        if (jobOutputAndDownloadFile.getFirst() == null || jobOutputAndDownloadFile.getSecond() == null) {
            return new EnvelopeResponse("000", (Object)"", "dump profile for ut");
        }
        this.setDownloadResponse((InputStream)jobOutputAndDownloadFile.getFirst(), (String)jobOutputAndDownloadFile.getSecond(), "application/octet-stream", response);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="startProfileByYarnAppId", tags={"DW"}, notes="")
    @GetMapping(value={"/profile/start_appid"})
    @ResponseBody
    public EnvelopeResponse<String> profileByYarnAppId(@RequestParam(value="app_id") String yarnAppId, @RequestParam(value="params", defaultValue="start,event=cpu", required=false) String params, HttpServletRequest request) {
        this.jobService.setResponseLanguage(request);
        this.jobService.startProfileByYarnAppId(yarnAppId, params);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="dumpProfile", tags={"DW"}, notes="")
    @GetMapping(value={"/profile/dump_appid"})
    @ResponseBody
    public EnvelopeResponse<String> stopProfileByYarnAppId(@RequestParam(value="app_id") String yarnAppId, @RequestParam(value="params", defaultValue="flamegraph", required=false) String params, HttpServletRequest request, HttpServletResponse response) {
        this.jobService.setResponseLanguage(request);
        Pair jobOutputAndDownloadFile = new Pair();
        this.jobService.dumpProfileByYarnAppId(yarnAppId, params, jobOutputAndDownloadFile);
        if (jobOutputAndDownloadFile.getFirst() == null || jobOutputAndDownloadFile.getSecond() == null) {
            return new EnvelopeResponse("000", (Object)"", "dump profile for ut");
        }
        this.setDownloadResponse((InputStream)jobOutputAndDownloadFile.getFirst(), (String)jobOutputAndDownloadFile.getSecond(), "application/octet-stream", response);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @PostMapping(value={"/gluten_cache"})
    @ApiOperation(value="routeGlutenCache", tags={"Gluten"})
    @ResponseBody
    public EnvelopeResponse<Boolean> routeGlutenCache(@RequestBody LoadGlutenCacheRequest request, HttpServletRequest servletRequest) throws Exception {
        logger.info("routeGlutenCache request is [{}]", (Object)request);
        this.checkProjectName(request.getProject());
        this.checkCollectionRequiredArg("cache_commands", request.getCacheCommands());
        boolean result = this.routeService.routeGlutenCache(request.getCacheCommands(), servletRequest);
        return new EnvelopeResponse("000", (Object)result, "");
    }
}

