/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.cache.CacheBuilder;
import org.apache.kylin.guava30.shaded.common.cache.CacheLoader;
import org.apache.kylin.guava30.shaded.common.cache.LoadingCache;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;

public class StorageURL {
    public static final int METADATA_MAX_LENGTH = 33;
    private static final LoadingCache<String, StorageURL> cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<String, StorageURL>(){

        public StorageURL load(String metadataUrl) throws Exception {
            return new StorageURL(metadataUrl);
        }
    });
    final String identifier;
    final String scheme;
    final Map<String, String> params;

    public static StorageURL valueOf(String metadataUrl) {
        try {
            return (StorageURL)cache.get((Object)metadataUrl);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    StorageURL(String metadataUrl) {
        boolean first = true;
        String n = null;
        String s = null;
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        for (String split : metadataUrl.split(",(?=(?:[^\"']*[\"'][^\"']*[\"'])*[^\"']*$)")) {
            String v;
            String k;
            int cut;
            if (first) {
                cut = split.lastIndexOf(64);
                if (cut < 0) {
                    n = split.trim();
                    s = "file";
                } else {
                    n = split.substring(0, cut).trim();
                    s = split.substring(cut + 1).trim();
                }
                first = false;
                continue;
            }
            cut = split.indexOf(61);
            if (cut < 0) {
                k = split.trim();
                v = "";
            } else {
                k = split.substring(0, cut).trim();
                v = split.substring(cut + 1).trim();
            }
            m.put(k, StringUtils.strip((String)v, (String)"\"'"));
        }
        this.identifier = StringUtils.isEmpty(n) ? "kylin_metadata" : n;
        this.scheme = s;
        this.params = ImmutableMap.copyOf(m);
    }

    public StorageURL(String identifier, String scheme, Map<String, String> params) {
        this.identifier = identifier;
        this.scheme = scheme;
        this.params = ImmutableMap.copyOf(params);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean containsParameter(String k) {
        return this.params.containsKey(k);
    }

    public String getParameter(String k) {
        return this.params.get(k);
    }

    public Map<String, String> getAllParameters() {
        return this.params;
    }

    public StorageURL copy(Map<String, String> params) {
        return new StorageURL(this.identifier, this.scheme, params);
    }

    public static String replaceUrl(StorageURL storageURL) {
        return storageURL.getIdentifier().replaceAll("[^0-9|a-z|A-Z|_]{1,}", "_");
    }

    public boolean metadataLengthIllegal() {
        return this.getIdentifier().length() > 33;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.identifier);
        if (!this.scheme.isEmpty()) {
            str.append("@").append(this.scheme);
        }
        for (Map.Entry<String, String> kv : this.params.entrySet()) {
            str.append(",").append(kv.getKey());
            if (kv.getValue().isEmpty()) continue;
            String value = kv.getValue();
            if (value.contains(",")) {
                value = "\"" + value + "\"";
            }
            str.append("=").append(value);
        }
        return str.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        result = 31 * result + (this.scheme == null ? 0 : this.scheme.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageURL other = (StorageURL)obj;
        if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
            return false;
        }
        if (this.params == null ? other.params != null : !this.params.equals(other.params)) {
            return false;
        }
        return !(this.scheme == null ? other.scheme != null : !this.scheme.equals(other.scheme));
    }
}

