/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import java.util.Map;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.common.util.SetThreadName;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.Executable;

public class ExecutableThread
extends Thread {
    public static final String JOB_THREAD_NAME_PATTERN = "JobWorker(project:%s,jobid:%s)";
    private Map<String, Executable> dagExecutablesMap;
    private JobContext context;
    private DefaultExecutable dagExecutable;
    private Executable executable;

    public ExecutableThread() {
    }

    public ExecutableThread(DefaultExecutable dagExecutable, Map<String, Executable> dagExecutablesMap, JobContext context, Executable executable) {
        this.dagExecutable = dagExecutable;
        this.dagExecutablesMap = dagExecutablesMap;
        this.context = context;
        this.executable = executable;
    }

    @Override
    public void run() {
        String jobIdSimple = this.dagExecutable.getId().split("-")[0];
        String project = this.dagExecutable.getProject();
        try (SetThreadName ignored = new SetThreadName(JOB_THREAD_NAME_PATTERN, new Object[]{project, jobIdSimple});
             SetLogCategory ignore = new SetLogCategory("schedule");){
            this.dagExecutable.executeDagExecutable(this.dagExecutablesMap, this.executable, this.context);
        }
    }
}

