/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdbm.helper.CacheEntry;
import jdbm.helper.CacheEvictionException;
import jdbm.helper.CachePolicy;
import jdbm.helper.CachePolicyListener;
import jdbm.helper.MRUEnumeration;
import org.apache.directory.server.i18n.I18n;

public class MRU<K, V>
implements CachePolicy<K, V> {
    Map<Object, CacheEntry> map = new HashMap<Object, CacheEntry>();
    int max;
    CacheEntry first;
    CacheEntry last;
    List<CachePolicyListener> listeners = new ArrayList<CachePolicyListener>();

    public MRU(int max) {
        if (max <= 0) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_528, (Object[])new Object[0]));
        }
        this.max = max;
    }

    @Override
    public void put(K key, V value) throws CacheEvictionException {
        CacheEntry entry = this.map.get(key);
        if (entry != null) {
            entry.setValue(value);
            this.touchEntry(entry);
        } else {
            if (this.map.size() == this.max) {
                entry = this.purgeEntry();
                entry.setKey(key);
                entry.setValue(value);
            } else {
                entry = new CacheEntry(key, value);
            }
            this.addEntry(entry);
            this.map.put(entry.getKey(), entry);
        }
    }

    @Override
    public V get(K key) {
        CacheEntry entry = this.map.get(key);
        if (entry != null) {
            this.touchEntry(entry);
            return (V)entry.getValue();
        }
        return null;
    }

    @Override
    public void remove(K key) {
        CacheEntry entry = this.map.get(key);
        if (entry != null) {
            this.removeEntry(entry);
            this.map.remove(entry.getKey());
        }
    }

    @Override
    public void removeAll() {
        this.map = new HashMap<Object, CacheEntry>();
        this.first = null;
        this.last = null;
    }

    @Override
    public Enumeration<V> elements() {
        return new MRUEnumeration(this.map.values().iterator());
    }

    @Override
    public void addListener(CachePolicyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_539_BAD_BLOCK_ID, (Object[])new Object[0]));
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(CachePolicyListener listener) {
        this.listeners.remove(listener);
    }

    protected void addEntry(CacheEntry entry) {
        if (this.first == null) {
            this.first = entry;
            this.last = entry;
        } else {
            this.last.setNext(entry);
            entry.setPrevious(this.last);
            this.last = entry;
        }
    }

    protected void removeEntry(CacheEntry entry) {
        if (entry == this.first) {
            this.first = entry.getNext();
            if (this.first != null) {
                this.first.setPrevious(null);
            }
        } else if (this.last == entry) {
            this.last = entry.getPrevious();
            if (this.last != null) {
                this.last.setNext(null);
            }
        } else {
            entry.getPrevious().setNext(entry.getNext());
            entry.getNext().setPrevious(entry.getPrevious());
        }
    }

    protected void touchEntry(CacheEntry entry) {
        if (this.last == entry) {
            return;
        }
        this.removeEntry(entry);
        this.addEntry(entry);
    }

    protected CacheEntry purgeEntry() throws CacheEvictionException {
        CacheEntry entry = this.first;
        for (int i = 0; i < this.listeners.size(); ++i) {
            CachePolicyListener listener = this.listeners.get(i);
            listener.cacheObjectEvicted(entry.getValue());
        }
        this.removeEntry(entry);
        this.map.remove(entry.getKey());
        entry.setValue(null);
        return entry;
    }
}

