/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.api;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteStepDescriptor;

public abstract class UrlRewriteStepDescriptorFactory {
    private static Map<String, Class<? extends UrlRewriteStepDescriptor>> MAP = UrlRewriteStepDescriptorFactory.loadStepDescriptors();

    private UrlRewriteStepDescriptorFactory() {
    }

    public static <T extends UrlRewriteStepDescriptor<?>> T create(String type) {
        try {
            Class<? extends UrlRewriteStepDescriptor> descriptorClass = MAP.get(type);
            return (T)descriptorClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(type);
        }
    }

    private static Map<String, Class<? extends UrlRewriteStepDescriptor>> loadStepDescriptors() {
        HashMap<String, Class<? extends UrlRewriteStepDescriptor>> map = new HashMap<String, Class<? extends UrlRewriteStepDescriptor>>();
        ServiceLoader<UrlRewriteStepDescriptor> descriptors = ServiceLoader.load(UrlRewriteStepDescriptor.class);
        for (UrlRewriteStepDescriptor descriptor : descriptors) {
            String descriptorType = descriptor.type();
            Class<?> descriptorClass = descriptor.getClass();
            map.put(descriptorType, descriptorClass);
        }
        return map;
    }

    public static Set<String> getTypes() {
        return MAP.keySet();
    }
}

