/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.RollingCalendar;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class DailyZipRollingFileAppender
extends FileAppender {
    static final int TOP_OF_TROUBLE = -1;
    static final int TOP_OF_MINUTE = 0;
    static final int TOP_OF_HOUR = 1;
    static final int HALF_DAY = 2;
    static final int TOP_OF_DAY = 3;
    static final int TOP_OF_WEEK = 4;
    static final int TOP_OF_MONTH = 5;
    private String datePattern = "'.'yyyy-MM-dd";
    private String scheduledFilename;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date now = null;
    SimpleDateFormat sdf;
    RollingCalendar rc = new RollingCalendar();
    int checkPeriod = -1;
    protected int maxBackupIndex = 1;
    private String compressBackups = "false";
    private String typeOfCompression = "gz";
    private String baseFileName;
    private String perentDirectory;
    static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");

    public DailyZipRollingFileAppender() {
    }

    public DailyZipRollingFileAppender(Layout layout, String filename, String datePattern) throws IOException {
        super(layout, filename, true);
        this.datePattern = datePattern;
        this.activateOptions();
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public void setMaxBackupIndex(int maxBackups) {
        this.maxBackupIndex = maxBackups;
    }

    public String getCompressBackups() {
        return this.compressBackups;
    }

    public void setCompressBackups(String compressBackups) {
        this.compressBackups = compressBackups;
    }

    public String getTypeOfCompression() {
        return this.typeOfCompression;
    }

    public void setTypeOfCompression(String typeOfCompression) {
        this.typeOfCompression = typeOfCompression;
    }

    @Override
    public void activateOptions() {
        if (this.datePattern != null && this.fileName != null) {
            File file;
            if (this.now == null) {
                this.now = new Date();
                this.now.setTime(System.currentTimeMillis());
            }
            this.sdf = new SimpleDateFormat(this.datePattern);
            int type = this.computeCheckPeriod();
            this.printPeriodicity(type);
            this.rc.setType(type);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            if (this.baseFileName == null) {
                this.baseFileName = this.fileName;
            }
            this.fileName = this.scheduledFilename = this.baseFileName + this.sdf.format(this.now);
            if (this.perentDirectory == null && (file = new File(this.fileName)) != null) {
                this.perentDirectory = file.getParent();
                if (file.exists() && file.getParent() == null) {
                    String absolutePath = file.getAbsolutePath();
                    this.perentDirectory = absolutePath.substring(0, absolutePath.lastIndexOf(this.fileName));
                }
            }
        } else {
            LogLog.error("Either File or DatePattern options are not set for appender [" + this.name + "].");
        }
        super.activateOptions();
    }

    void printPeriodicity(int type) {
        switch (type) {
            case 0: {
                LogLog.debug("Appender [" + this.name + "] to be rolled every minute.");
                break;
            }
            case 1: {
                LogLog.debug("Appender [" + this.name + "] to be rolled on top of every hour.");
                break;
            }
            case 2: {
                LogLog.debug("Appender [" + this.name + "] to be rolled at midday and midnight.");
                break;
            }
            case 3: {
                LogLog.debug("Appender [" + this.name + "] to be rolled at midnight.");
                break;
            }
            case 4: {
                LogLog.debug("Appender [" + this.name + "] to be rolled at start of week.");
                break;
            }
            case 5: {
                LogLog.debug("Appender [" + this.name + "] to be rolled at start of every month.");
                break;
            }
            default: {
                LogLog.warn("Unknown periodicity for appender [" + this.name + "].");
            }
        }
    }

    int computeCheckPeriod() {
        RollingCalendar rollingCalendar = new RollingCalendar(gmtTimeZone, Locale.getDefault());
        Date epoch = new Date(0L);
        if (this.datePattern != null) {
            for (int i = 0; i <= 5; ++i) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                simpleDateFormat.setTimeZone(gmtTimeZone);
                String r0 = simpleDateFormat.format(epoch);
                rollingCalendar.setType(i);
                Date next = new Date(rollingCalendar.getNextCheckMillis(epoch));
                String r1 = simpleDateFormat.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return i;
            }
        }
        return -1;
    }

    void rollOver() throws IOException {
        if (this.getCompressBackups().equalsIgnoreCase("YES") || this.getCompressBackups().equalsIgnoreCase("TRUE")) {
            File file = new File(this.fileName);
            Thread fileCompressor = new Thread(new CompressFile(file));
            fileCompressor.start();
        }
        if (this.datePattern == null) {
            this.errorHandler.error("Missing DatePattern option in rollOver().");
            return;
        }
        String datedFilename = this.baseFileName + this.sdf.format(this.now);
        if (this.scheduledFilename.equals(datedFilename)) {
            return;
        }
        this.activateOptions();
    }

    protected void cleanupAndRollOver() throws IOException {
        Thread clth = new Thread(new CleanUpThread());
        clth.start();
        this.rollOver();
    }

    @Override
    protected void subAppend(LoggingEvent event) {
        long n = event.timeStamp;
        if (n >= this.nextCheck) {
            try {
                this.now.setTime(n);
                this.cleanupAndRollOver();
            }
            catch (IOException ioe) {
                if (ioe instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.error("rollOver() failed.", ioe);
            }
        }
        super.subAppend(event);
    }

    class CompressFile
    implements Runnable {
        File file;

        public CompressFile(File file) {
            this.file = file;
        }

        @Override
        public void run() {
            try {
                if (!this.file.getName().endsWith("." + DailyZipRollingFileAppender.this.typeOfCompression)) {
                    if ("zip".equals(DailyZipRollingFileAppender.this.typeOfCompression)) {
                        int bytesRead;
                        File zipFile = new File(this.file.getParent(), this.file.getName() + ".zip");
                        FileInputStream fis = new FileInputStream(this.file);
                        FileOutputStream fos = new FileOutputStream(zipFile);
                        ZipOutputStream zos = new ZipOutputStream(fos);
                        ZipEntry zipEntry = new ZipEntry(this.file.getName());
                        zos.putNextEntry(zipEntry);
                        byte[] buffer = new byte[4096];
                        while ((bytesRead = fis.read(buffer)) != -1) {
                            zos.write(buffer, 0, bytesRead);
                        }
                        zos.closeEntry();
                        fis.close();
                        zos.close();
                        this.file.delete();
                    } else if ("gz".equals(DailyZipRollingFileAppender.this.typeOfCompression)) {
                        int bytesRead;
                        File zipFile = new File(this.file.getParent(), this.file.getName() + ".gz");
                        FileInputStream fis = new FileInputStream(this.file);
                        FileOutputStream fos = new FileOutputStream(zipFile);
                        GZIPOutputStream zos = new GZIPOutputStream(fos);
                        byte[] buffer = new byte[4096];
                        while ((bytesRead = fis.read(buffer)) != -1) {
                            zos.write(buffer, 0, bytesRead);
                        }
                        fis.close();
                        zos.close();
                        this.file.delete();
                    }
                }
            }
            catch (IOException e) {
                LogLog.error("Error during compression of file " + DailyZipRollingFileAppender.this.fileName + ".", e);
            }
        }
    }

    class CleanUpThread
    implements Runnable {
        CleanUpThread() {
        }

        private List<ModifiedTimeSortableFile> getAllFiles(String perentDirectory) {
            ArrayList<ModifiedTimeSortableFile> files = null;
            try {
                files = new ArrayList<ModifiedTimeSortableFile>();
                File dir = new File(perentDirectory);
                String[] names = dir.list();
                for (int i = 0; i < names.length; ++i) {
                    files.add(new ModifiedTimeSortableFile(dir + System.getProperty("file.separator") + names[i]));
                }
            }
            catch (Exception e) {
                LogLog.error("Error during retrieving all files of parent folder. ", e);
            }
            return files;
        }

        @Override
        public void run() {
            List<ModifiedTimeSortableFile> files = this.getAllFiles(DailyZipRollingFileAppender.this.perentDirectory);
            if (files.size() >= DailyZipRollingFileAppender.this.maxBackupIndex) {
                Collections.sort(files);
                int index = 0;
                int diff = files.size() - (DailyZipRollingFileAppender.this.maxBackupIndex - 1);
                for (ModifiedTimeSortableFile file : files) {
                    if (index >= diff) break;
                    file.delete();
                    ++index;
                }
            }
        }
    }

    class ModifiedTimeSortableFile
    extends File
    implements Serializable,
    Comparable<File> {
        private static final long serialVersionUID = 1373373728209668895L;

        public ModifiedTimeSortableFile(String parent, String child) {
            super(parent, child);
        }

        public ModifiedTimeSortableFile(URI uri) {
            super(uri);
        }

        public ModifiedTimeSortableFile(File parent, String child) {
            super(parent, child);
        }

        public ModifiedTimeSortableFile(String string) {
            super(string);
        }

        @Override
        public int compareTo(File anotherPathName) {
            long anotherVal;
            long thisVal = this.lastModified();
            return thisVal < (anotherVal = anotherPathName.lastModified()) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
    }
}

