/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.coordinator.group.Utils;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;

public class OffsetAndMetadata {
    public static final String NO_METADATA = "";
    public final long committedOffset;
    public final OptionalInt leaderEpoch;
    public final String metadata;
    public final long commitTimestampMs;
    public final OptionalLong expireTimestampMs;
    public final long recordOffset;
    public final Uuid topicId;

    public OffsetAndMetadata(long committedOffset, OptionalInt leaderEpoch, String metadata, long commitTimestampMs, OptionalLong expireTimestampMs, Uuid topicId) {
        this(-1L, committedOffset, leaderEpoch, metadata, commitTimestampMs, expireTimestampMs, topicId);
    }

    public OffsetAndMetadata(long recordOffset, long committedOffset, OptionalInt leaderEpoch, String metadata, long commitTimestampMs, OptionalLong expireTimestampMs, Uuid topicId) {
        this.recordOffset = recordOffset;
        this.committedOffset = committedOffset;
        this.leaderEpoch = Objects.requireNonNull(leaderEpoch);
        this.metadata = Objects.requireNonNull(metadata);
        this.commitTimestampMs = commitTimestampMs;
        this.expireTimestampMs = Objects.requireNonNull(expireTimestampMs);
        this.topicId = topicId;
    }

    public String toString() {
        return "OffsetAndMetadata(offset=" + this.committedOffset + ", leaderEpoch=" + String.valueOf(this.leaderEpoch) + ", metadata=" + this.metadata + ", commitTimestampMs=" + this.commitTimestampMs + ", expireTimestampMs=" + String.valueOf(this.expireTimestampMs) + ", topicId=" + String.valueOf(this.topicId) + ", recordOffset=" + this.recordOffset + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetAndMetadata that = (OffsetAndMetadata)o;
        if (this.committedOffset != that.committedOffset) {
            return false;
        }
        if (this.commitTimestampMs != that.commitTimestampMs) {
            return false;
        }
        if (this.recordOffset != that.recordOffset) {
            return false;
        }
        if (!Objects.equals(this.leaderEpoch, that.leaderEpoch)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.topicId, that.topicId)) {
            return false;
        }
        return Objects.equals(this.expireTimestampMs, that.expireTimestampMs);
    }

    public int hashCode() {
        int result = (int)(this.committedOffset ^ this.committedOffset >>> 32);
        result = 31 * result + (this.leaderEpoch != null ? this.leaderEpoch.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        result = 31 * result + (this.topicId != null ? this.topicId.hashCode() : 0);
        result = 31 * result + (int)(this.commitTimestampMs ^ this.commitTimestampMs >>> 32);
        result = 31 * result + (this.expireTimestampMs != null ? this.expireTimestampMs.hashCode() : 0);
        result = 31 * result + (int)(this.recordOffset ^ this.recordOffset >>> 32);
        return result;
    }

    public static OffsetAndMetadata fromRecord(long recordOffset, OffsetCommitValue record) {
        return new OffsetAndMetadata(recordOffset, record.offset(), Utils.ofSentinel(record.leaderEpoch()), record.metadata(), record.commitTimestamp(), Utils.ofSentinel(record.expireTimestamp()), record.topicId());
    }

    public static OffsetAndMetadata fromRequest(Uuid topicId, OffsetCommitRequestData.OffsetCommitRequestPartition partition, long currentTimeMs, OptionalLong expireTimestampMs) {
        return new OffsetAndMetadata(partition.committedOffset(), Utils.ofSentinel(partition.committedLeaderEpoch()), partition.committedMetadata() == null ? NO_METADATA : partition.committedMetadata(), currentTimeMs, expireTimestampMs, topicId);
    }

    public static OffsetAndMetadata fromRequest(TxnOffsetCommitRequestData.TxnOffsetCommitRequestPartition partition, long currentTimeMs) {
        return new OffsetAndMetadata(partition.committedOffset(), Utils.ofSentinel(partition.committedLeaderEpoch()), partition.committedMetadata() == null ? NO_METADATA : partition.committedMetadata(), currentTimeMs, OptionalLong.empty(), Uuid.ZERO_UUID);
    }
}

