/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.runtime.isolation.VersionedPluginLoadingException;
import org.apache.maven.artifact.versioning.VersionRange;

public class CachedConnectors {
    private static final String LATEST_VERSION = "latest";
    private final Map<String, Map<String, Connector>> connectors;
    private final Map<String, Throwable> invalidConnectors;
    private final Map<String, Map<String, VersionedPluginLoadingException>> invalidVersions;
    private final Plugins plugins;

    public CachedConnectors(Plugins plugins) {
        this.plugins = plugins;
        this.connectors = new ConcurrentHashMap<String, Map<String, Connector>>();
        this.invalidConnectors = new ConcurrentHashMap<String, Throwable>();
        this.invalidVersions = new ConcurrentHashMap<String, Map<String, VersionedPluginLoadingException>>();
    }

    private void validate(String connectorName, VersionRange range) throws ConnectException, VersionedPluginLoadingException {
        String version;
        if (this.invalidConnectors.containsKey(connectorName)) {
            throw new ConnectException(this.invalidConnectors.get(connectorName));
        }
        String string = version = range == null ? LATEST_VERSION : range.toString();
        if (this.invalidVersions.containsKey(connectorName) && this.invalidVersions.get(connectorName).containsKey(version)) {
            throw new VersionedPluginLoadingException(this.invalidVersions.get(connectorName).get(version).getMessage());
        }
    }

    private Connector lookup(String connectorName, VersionRange range) {
        String version;
        String string = version = range == null ? LATEST_VERSION : range.toString();
        if (this.connectors.containsKey(connectorName) && this.connectors.get(connectorName).containsKey(version)) {
            return this.connectors.get(connectorName).get(version);
        }
        try {
            Connector connector = this.plugins.newConnector(connectorName, range);
            this.connectors.computeIfAbsent(connectorName, k -> new ConcurrentHashMap()).put(version, connector);
            return connector;
        }
        catch (VersionedPluginLoadingException e) {
            this.invalidVersions.computeIfAbsent(connectorName, k -> new ConcurrentHashMap()).put(version, e);
            throw e;
        }
        catch (Exception e) {
            this.invalidConnectors.put(connectorName, e);
            throw e;
        }
    }

    public Connector getConnector(String connectorName, VersionRange range) {
        this.validate(connectorName, range);
        return this.lookup(connectorName, range);
    }
}

