/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import java.util.Set;
import org.apache.james.backends.opensearch.ClientProvider;
import org.apache.james.backends.opensearch.IndexName;
import org.apache.james.backends.opensearch.OpenSearchHealthCheck;
import org.apache.james.backends.opensearch.ReactorOpenSearchClient;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.mailbox.opensearch.OpenSearchMailboxConfiguration;
import org.apache.james.quota.search.opensearch.OpenSearchQuotaConfiguration;

public class OpenSearchClientModule
extends AbstractModule {
    protected void configure() {
        this.bind(ClientProvider.class).in(Scopes.SINGLETON);
        this.bind(ReactorOpenSearchClient.class).toProvider(ClientProvider.class);
        Multibinder.newSetBinder((Binder)this.binder(), HealthCheck.class).addBinding().to(OpenSearchHealthCheck.class);
    }

    @Provides
    @Singleton
    Set<IndexName> provideIndexNames(OpenSearchMailboxConfiguration mailboxConfiguration, OpenSearchQuotaConfiguration quotaConfiguration) {
        return ImmutableSet.of((Object)mailboxConfiguration.getIndexMailboxName(), (Object)quotaConfiguration.getIndexQuotaRatioName());
    }
}

