/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import org.apache.jackrabbit.commons.xml.SerializingContentHandler;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WorkspaceContentHandler
extends DefaultHandler {
    private static Logger log = LoggerFactory.getLogger(WorkspaceContentHandler.class);
    private final String parentAbsPath;
    private final int uuidBehavior;
    private final Workspace workspace;
    private final File tmpFile;
    private final OutputStream tmpStream;
    private final ContentHandler delegatee;

    public WorkspaceContentHandler(Workspace workspace, String parentAbsPath, int uuidBehavior) throws RepositoryException {
        this.workspace = workspace;
        this.parentAbsPath = parentAbsPath;
        this.uuidBehavior = uuidBehavior;
        try {
            String tmpName = Text.md5(parentAbsPath);
            this.tmpFile = File.createTempFile("___" + tmpName, ".xml");
            this.tmpStream = new FileOutputStream(this.tmpFile);
            this.delegatee = SerializingContentHandler.getSerializer(this.tmpStream);
        }
        catch (FileNotFoundException e) {
            throw new RepositoryException(e);
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        catch (SAXException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.delegatee.endDocument();
        try (FileInputStream is = new FileInputStream(this.tmpFile);){
            this.workspace.importXML(this.parentAbsPath, is, this.uuidBehavior);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (RepositoryException e) {
            throw new SAXException(e);
        }
        finally {
            try {
                this.tmpStream.close();
            }
            catch (IOException ex) {
                log.error("closing temp file stream", ex);
            }
            this.tmpFile.delete();
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.delegatee.startDocument();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.delegatee.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.delegatee.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.delegatee.endPrefixMapping(prefix);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.delegatee.skippedEntity(name);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.delegatee.setDocumentLocator(locator);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.delegatee.processingInstruction(target, data);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.delegatee.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.delegatee.endElement(namespaceURI, localName, qName);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.delegatee.startElement(namespaceURI, localName, qName, atts);
    }
}

