/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class RemoveRegion
extends Statement {
    private final int regionId;
    private final int dataNodeId;

    public RemoveRegion(int regionId, int dataNodeId) {
        super(null);
        this.regionId = regionId;
        this.dataNodeId = dataNodeId;
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(RemoveRegion.class, this.regionId, this.dataNodeId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RemoveRegion)) {
            return false;
        }
        RemoveRegion another = (RemoveRegion)obj;
        return this.regionId == another.regionId && this.dataNodeId == another.dataNodeId;
    }

    @Override
    public String toString() {
        return String.format("remove region %d from %d", this.regionId, this.dataNodeId);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRemoveRegion(this, context);
    }

    public int getRegionId() {
        return this.regionId;
    }

    public int getDataNodeId() {
        return this.dataNodeId;
    }
}

