/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array;

import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.ApproxMostFrequentBucketDeserializer;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.ApproxMostFrequentBucketSerializer;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.SpaceSaving;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.approximate.SpaceSavingByteCalculator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.array.ObjectBigArray;
import org.apache.tsfile.utils.RamUsageEstimator;

public class SpaceSavingBigArray<T> {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(SpaceSavingBigArray.class);
    private final ObjectBigArray<SpaceSaving<T>> array = new ObjectBigArray();
    private long sizeOfSpaceSaving;

    public long sizeOf() {
        return INSTANCE_SIZE + RamUsageEstimator.shallowSizeOf(this.array) + this.sizeOfSpaceSaving;
    }

    public SpaceSaving<T> get(long index) {
        return this.array.get(index);
    }

    public SpaceSaving<T> get(long index, int maxBuckets, int capacity, ApproxMostFrequentBucketSerializer<T> serializer, ApproxMostFrequentBucketDeserializer<T> deserializer, SpaceSavingByteCalculator<T> calculator) {
        return this.get(index, new SpaceSaving<T>(maxBuckets, capacity, serializer, deserializer, calculator));
    }

    public SpaceSaving<T> get(long index, SpaceSaving<T> spaceSaving) {
        SpaceSaving<T> result = this.array.get(index);
        if (result == null) {
            this.set(index, spaceSaving);
            return spaceSaving;
        }
        return result;
    }

    public void set(long index, SpaceSaving<T> spaceSaving) {
        this.updateRetainedSize(index, spaceSaving);
        this.array.set(index, spaceSaving);
    }

    public boolean isEmpty() {
        return this.sizeOfSpaceSaving == 0L;
    }

    public void ensureCapacity(long length) {
        this.array.ensureCapacity(length);
    }

    public void updateRetainedSize(long index, SpaceSaving<T> value) {
        SpaceSaving<T> spaceSaving = this.array.get(index);
        if (spaceSaving != null) {
            this.sizeOfSpaceSaving -= spaceSaving.getEstimatedSize();
        }
        if (value != null) {
            this.sizeOfSpaceSaving += value.getEstimatedSize();
        }
    }

    public void reset() {
        this.array.forEach(item -> {
            if (item != null) {
                item.reset();
            }
        });
    }
}

