/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.payload.evolvable.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.IoTDBSinkRequestVersion;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTabletRawReq;
import org.apache.iotdb.db.pipe.sink.util.sorter.PipeTableModelTabletEventSorter;
import org.apache.iotdb.db.pipe.sink.util.sorter.PipeTreeModelTabletEventSorter;
import org.apache.iotdb.db.queryengine.plan.parser.StatementGenerator;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.session.util.SessionUtils;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTransferTabletRawReqV2
extends PipeTransferTabletRawReq {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTransferTabletRawReqV2.class);
    protected transient String dataBaseName;

    public String getDataBaseName() {
        return this.dataBaseName;
    }

    @Override
    public InsertTabletStatement constructStatement() {
        if (Objects.isNull(this.dataBaseName)) {
            new PipeTreeModelTabletEventSorter(this.tablet).deduplicateAndSortTimestampsIfNecessary();
        } else {
            new PipeTableModelTabletEventSorter(this.tablet).sortByTimestampIfNecessary();
        }
        try {
            if (PipeRawTabletInsertionEvent.isTabletEmpty(this.tablet)) {
                return new InsertTabletStatement();
            }
            TSInsertTabletReq request = new TSInsertTabletReq();
            for (IMeasurementSchema measurementSchema : this.tablet.getSchemas()) {
                request.addToMeasurements(measurementSchema.getMeasurementName());
                request.addToTypes(measurementSchema.getType().ordinal());
            }
            request.setPrefixPath(this.tablet.getDeviceId());
            request.setIsAligned(this.isAligned);
            request.setTimestamps(SessionUtils.getTimeBuffer((Tablet)this.tablet));
            request.setValues(SessionUtils.getValueBuffer((Tablet)this.tablet));
            request.setSize(this.tablet.getRowSize());
            if (Objects.isNull(this.dataBaseName)) {
                request.setMeasurements(PathUtils.checkIsLegalSingleMeasurementsAndUpdate((List)request.getMeasurements()));
                return StatementGenerator.createStatement(request);
            }
            request.setWriteToTable(true);
            request.columnCategories = this.tablet.getColumnTypes().stream().map(t -> (byte)t.ordinal()).collect(Collectors.toList());
            InsertTabletStatement statement = StatementGenerator.createStatement(request);
            statement.setDatabaseName(this.dataBaseName);
            return statement;
        }
        catch (MetadataException e) {
            LOGGER.warn("Generate Statement from tablet {} error.", (Object)this.tablet, (Object)e);
            return null;
        }
    }

    public static PipeTransferTabletRawReqV2 toTPipeTransferRawReq(Tablet tablet, boolean isAligned, String dataBaseName) {
        PipeTransferTabletRawReqV2 tabletReq = new PipeTransferTabletRawReqV2();
        tabletReq.tablet = tablet;
        tabletReq.isAligned = isAligned;
        tabletReq.dataBaseName = dataBaseName;
        tabletReq.version = IoTDBSinkRequestVersion.VERSION_1.getVersion();
        tabletReq.type = PipeRequestType.TRANSFER_TABLET_RAW_V2.getType();
        return tabletReq;
    }

    public static PipeTransferTabletRawReqV2 toTPipeTransferReq(Tablet tablet, boolean isAligned, String dataBaseName) throws IOException {
        PipeTransferTabletRawReqV2 tabletReq = new PipeTransferTabletRawReqV2();
        tabletReq.tablet = tablet;
        tabletReq.isAligned = isAligned;
        tabletReq.dataBaseName = dataBaseName;
        tabletReq.version = IoTDBSinkRequestVersion.VERSION_1.getVersion();
        tabletReq.type = PipeRequestType.TRANSFER_TABLET_RAW_V2.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            tablet.serialize(outputStream);
            ReadWriteIOUtils.write((Boolean)isAligned, (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)dataBaseName, (OutputStream)outputStream);
            tabletReq.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return tabletReq;
    }

    public static PipeTransferTabletRawReqV2 fromTPipeTransferReq(TPipeTransferReq transferReq) {
        PipeTransferTabletRawReqV2 tabletReq = new PipeTransferTabletRawReqV2();
        tabletReq.tablet = Tablet.deserialize((ByteBuffer)transferReq.body);
        tabletReq.isAligned = ReadWriteIOUtils.readBool((ByteBuffer)transferReq.body);
        tabletReq.dataBaseName = ReadWriteIOUtils.readString((ByteBuffer)transferReq.body);
        tabletReq.version = transferReq.version;
        tabletReq.type = transferReq.type;
        tabletReq.body = transferReq.body;
        return tabletReq;
    }

    public static byte[] toTPipeTransferBytes(Tablet tablet, boolean isAligned, String dataBaseName) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            byte[] byArray;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                ReadWriteIOUtils.write((byte)IoTDBSinkRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((short)PipeRequestType.TRANSFER_TABLET_RAW_V2.getType(), (OutputStream)outputStream);
                tablet.serialize(outputStream);
                ReadWriteIOUtils.write((Boolean)isAligned, (OutputStream)outputStream);
                ReadWriteIOUtils.write((String)dataBaseName, (OutputStream)outputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PipeTransferTabletRawReqV2 that = (PipeTransferTabletRawReqV2)((Object)o);
        return Objects.equals(this.dataBaseName, that.dataBaseName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dataBaseName);
    }
}

