#The OSULeaf data set consist of one dimensional outlines of leaves.
#The series were obtained by color image segmentation and boundary
#extraction (in the anti-clockwise direction) from digitized leaf
#images of six classes: Acer Circinatum, Acer Glabrum, Acer
#Macrophyllum, Acer Negundo, Quercus Garryana and Quercus Kelloggii
#for the MSc thesis "Content-Based Image Retrieval: Plant Species
#Identification" by A. Grandhi.
@problemName OSULeaf
@timeStamps false
@missing false
@univariate true
@equalLength true
@seriesLength 427
@classLabel true 1 2 3 4 5 6
@data
1.3045772,1.2161866,1.1277111,1.033539,0.92973678,0.86436239,0.7928873,0.71497623,0.67250049,0.61197211,0.51895278,0.44300053,0.37154811,0.26272829,0.21008957,0.28419929,0.37378099,0.45958843,0.55460075,0.64744193,0.64694304,0.52369479,0.3844994,0.28915922,0.18471146,0.054844077,-0.079626758,-0.21578872,-0.34147669,-0.46119255,-0.58140562,-0.71708834,-0.85166114,-0.97860875,-1.0834872,-1.154281,-1.2148671,-1.2741493,-1.183075,-1.0711254,-0.95918218,-0.84196347,-0.72909199,-0.61441375,-0.49933812,-0.38788391,-0.27622579,-0.16367452,-0.090448272,-0.056401237,0.052237931,0.16073234,0.27494527,0.39194261,0.50162118,0.61497291,0.73205268,0.83432691,0.75705578,0.65157293,0.54699883,0.44337811,0.34248824,0.27294561,0.19707689,0.10903407,0.021732152,-0.062146002,-0.14621997,-0.23911348,-0.33451853,-0.33248648,-0.26333412,-0.26588383,-0.33217081,-0.40688838,-0.4967677,-0.59382164,-0.67473986,-0.78150184,-0.8436914,-0.94460414,-1.0282034,-1.1112292,-1.1965191,-1.250433,-1.3079628,-1.2879895,-1.3095192,-1.2640318,-1.1731994,-1.1147866,-1.0577884,-1.0939158,-1.1549259,-1.2034853,-1.2542358,-1.323478,-1.4010461,-1.4981743,-1.5486519,-1.5819411,-1.5215335,-1.425652,-1.3162332,-1.2102373,-1.1168113,-1.0178257,-0.90504963,-0.7954599,-0.68814674,-0.61049757,-0.49681603,-0.38148312,-0.27307385,-0.15982372,-0.052790961,0.065817249,0.12004837,0.23069807,0.34347186,0.45937923,0.57320361,0.68496299,0.79289441,0.90887743,1.0200183,1.1335337,1.2476817,1.3603611,1.4740646,1.5839339,1.6910847,1.8076277,1.9217866,2.0302095,2.1476547,2.2436503,2.352467,2.4625824,2.5678724,2.6302625,2.611317,2.5717836,2.4578648,2.3452203,2.2357709,2.1320165,2.0364608,1.9444293,1.8335069,1.7242636,1.6079322,1.495424,1.3880312,1.2699354,1.1589071,1.0469757,0.93814136,0.82124853,0.70765739,0.59634271,0.47882165,0.37072113,0.25320828,0.14139197,0.02174371,-0.089528278,-0.20309253,-0.31259861,-0.43075151,-0.54051933,-0.65134819,-0.76547576,-0.87348736,-0.98706505,-1.099376,-1.2095674,-1.3237172,-1.4414368,-1.4896787,-1.5478494,-1.6357057,-1.6657596,-1.7536289,-1.8303469,-1.8936852,-1.8203478,-1.7475243,-1.6398078,-1.5314514,-1.4228204,-1.3388629,-1.2417704,-1.1664864,-1.123985,-1.0698866,-0.96806774,-0.94584666,-1.0393304,-1.1416836,-1.2201664,-1.285415,-1.3541014,-1.3685415,-1.2346158,-1.1179037,-1.001709,-0.91295485,-0.85269708,-0.76344727,-0.67397225,-0.58943685,-0.49063242,-0.3885624,-0.31638135,-0.37920475,-0.42281396,-0.44505916,-0.36243083,-0.28327748,-0.19543013,-0.11129289,-0.035050408,0.014696444,0.088381472,0.16737286,0.26006956,0.3410691,0.43635189,0.5495338,0.6429568,0.6916641,0.56850832,0.42583713,0.27421484,0.14110237,-9.932142E-5,-0.14267144,-0.27375944,-0.40970056,-0.54107652,-0.66901496,-0.7936553,-0.91605295,-1.0411325,-1.1696473,-1.2788447,-1.2790216,-1.1747456,-1.0777359,-0.99677356,-0.89575857,-0.78985544,-0.69255784,-0.58936052,-0.50310113,-0.40490321,-0.28928246,-0.19025071,-0.1049209,0.0021365084,0.11540443,0.22652245,0.33549245,0.33079844,0.2375031,0.15901396,0.11341863,0.078425894,0.10377115,0.15784866,0.21687248,0.31115033,0.38561434,0.4859766,0.56011067,0.60952179,0.64408576,0.72164298,0.84422467,0.95230325,1.0567898,1.164949,1.2660902,1.4152592,1.4517096,1.3481683,1.2358841,1.1323823,1.0357613,0.94137988,0.85564381,0.77099418,0.67665452,0.57775362,0.47641509,0.38959201,0.30669207,0.21454461,0.13728778,0.074590942,0.017770403,-0.056624392,-0.17516556,-0.31169778,-0.42765347,-0.56054297,-0.69322024,-0.83809383,-0.9654941,-1.1017323,-1.2344312,-1.34958,-1.3747823,-1.4381818,-1.3788876,-1.2781592,-1.171893,-1.1098322,-0.96281258,-0.83198239,-0.72275422,-0.59815538,-0.47394609,-0.36710357,-0.25662936,-0.1456415,-0.027814744,0.069309286,0.17999552,0.28197299,0.29737123,0.23681272,0.18749132,0.15911004,0.2008757,0.28963135,0.38496675,0.48161147,0.58231124,0.68183187,0.78416563,0.88783805,0.98382878,1.059622,1.1459018,1.2393887,1.3330417,1.4344952,1.5348965,1.6196544,1.7221041,1.8236282,1.9326189,2.0402985,1.9751052,1.8618813,1.7510797,1.644535,1.5656546,1.4622486,1.3347089,1.2503867,1.1895843,1.1400571,1.0450419,0.92925269,0.81847006,0.71219802,0.60378032,0.50884848,0.48636509,0.51280947,0.57577399,0.64005611,0.66363458,0.55485799,0.44423515,0.34271264,0.23697133,0.1250548,0.014677345,-0.098006766,-0.20210574,-0.31070111,-0.43263573,-0.54640308,-0.66313308,-0.76428727,-0.87193619,-0.97482271,-1.0459829,-1.1184375,-1.1998498,-1.3020492,-1.3662939,-1.4580305,-1.5218134,-1.4523384,-1.4300829,-1.3028545,-1.1783003,-1.045599,-0.94900273,-0.83481433,-0.71547584,-0.59035025,-0.46455129,-0.31432709,-0.18714942,-0.054930575,-0.027676081,0.015859502,0.080488236,0.19223331,0.28810294,0.38365438,0.4777205,0.55515428,0.66374871,0.78264471,0.88001975,0.95949438,1.0736659,1.1790214,1.262479:5
-0.57117143,-0.57515486,-0.59727074,-0.63260268,-0.66361089,-0.6864368,-0.72848383,-0.78305416,-0.83265551,-0.88723856,-0.95818341,-1.0063602,-1.0871808,-1.1798172,-1.2739274,-1.3570424,-1.418021,-1.4864713,-1.4566504,-1.4086934,-1.3570124,-1.297311,-1.2404216,-1.1739254,-1.1166052,-1.0585131,-0.99448308,-0.92472685,-0.85627346,-0.79660672,-0.73055658,-0.66002124,-0.5952757,-0.54132462,-0.46411295,-0.42275879,-0.34839192,-0.27567394,-0.20935391,-0.14251251,-0.087143724,-0.024842367,0.0014721962,0.054671075,0.10860187,0.16199757,0.23840926,0.3092918,0.35168439,0.4038163,0.43712958,0.47307516,0.50896641,0.51876797,0.50965053,0.49571213,0.4862227,0.44728158,0.42802252,0.38305088,0.3417219,0.28409941,0.22538014,0.18799099,0.13921629,0.13802349,0.18101808,0.23480337,0.28815269,0.34695382,0.42698869,0.50485184,0.56514823,0.6219962,0.69243431,0.73843224,0.81662154,0.86916932,0.92187861,0.97628483,1.0288916,1.0810863,1.1361352,1.1917043,1.2421743,1.2988453,1.3590291,1.4139166,1.4730807,1.5310471,1.5891585,1.6382239,1.6803249,1.7389837,1.7864239,1.8471667,1.9041609,1.9630446,2.0266702,2.0581771,2.1033811,2.135477,2.1701059,2.1961475,2.2077899,2.2043721,2.1864371,2.1869474,2.1733546,2.1506064,2.1248789,2.0945485,2.0572015,2.0205608,1.9963344,1.9793026,1.9754108,1.9605542,1.9493006,1.9019907,1.8518797,1.7992744,1.747231,1.6966174,1.6436267,1.5872687,1.5160753,1.4579081,1.3992086,1.3229649,1.2680533,1.2207153,1.1724399,1.0875823,1.0342705,0.94922003,0.86303709,0.8068077,0.71750253,0.62605726,0.55481422,0.49342895,0.39384105,0.30001871,0.2413431,0.16370064,0.076737494,8.1462659E-5,-0.08901561,-0.1658707,-0.23124516,-0.29947611,-0.40164347,-0.46700888,-0.54313508,-0.57668532,-0.5394122,-0.49097047,-0.43715195,-0.36006439,-0.31094075,-0.24561104,-0.18519223,-0.12694054,-0.06880017,-0.013989018,0.016384318,0.06722888,0.087742911,0.071030486,0.038057112,0.0053026418,-0.034623658,-0.065989473,-0.12633605,-0.19642716,-0.25528855,-0.29955364,-0.36736598,-0.42984552,-0.49475005,-0.55450876,-0.61876607,-0.67320607,-0.7401505,-0.80921506,-0.83653693,-0.82114293,-0.88980517,-0.94870799,-1.0074347,-1.0543912,-1.1087874,-1.1555088,-1.2090219,-1.2281658,-1.2789264,-1.3342398,-1.3884453,-1.4386799,-1.5040856,-1.5590629,-1.6107239,-1.6612889,-1.7035717,-1.7354657,-1.7359993,-1.6747687,-1.6009447,-1.538037,-1.4747,-1.3998729,-1.3426433,-1.2804755,-1.2165887,-1.159561,-1.1071681,-1.0571398,-1.0521844,-1.0772905,-1.069948,-1.091891,-1.1127073,-1.1164907,-1.1404677,-1.1432361,-1.1698431,-1.1545422,-1.1575521,-1.1564008,-1.1549405,-1.1499715,-1.1491486,-1.1550864,-1.1575291,-1.1465085,-1.1420818,-1.1394549,-1.1314253,-1.1258609,-1.1256439,-1.1240462,-1.1252038,-1.1241378,-1.1426237,-1.141224,-1.1454373,-1.1556239,-1.1689422,-1.1768855,-1.1783422,-1.1155193,-1.0695563,-1.0452231,-0.99325733,-0.95549032,-0.89085016,-0.84071702,-0.79347381,-0.7407515,-0.68587585,-0.59304421,-0.52643602,-0.45322184,-0.39740631,-0.34330566,-0.29887877,-0.22479292,-0.15922124,-0.057558696,0.0094447264,0.1045175,0.18056398,0.24140874,0.27615851,0.31177567,0.34745428,0.41254584,0.47026524,0.52477493,0.59081016,0.64728913,0.72139656,0.78962224,0.84703858,0.92903705,0.9967899,1.061412,1.1566279,1.1959832,1.2512827,1.3173562,1.3858918,1.440395,1.4754942,1.5367265,1.5766978,1.6382324,1.6884431,1.730726,1.7178501,1.6464804,1.6293043,1.5747577,1.4758757,1.3765778,1.2766303,1.2136382,1.1372086,1.0880265,1.0247545,0.96291694,0.93630625,0.83644085,0.76359942,0.71900361,0.64927602,0.60040031,0.5406662,0.49832859,0.40797341,0.38953967,0.42059253,0.43191897,0.45321939,0.48387639,0.52523136,0.56432752,0.61525382,0.65693599,0.73185489,0.81443229,0.85869195,0.87507949,0.82914014,0.72990182,0.6620584,0.59455852,0.52681991,0.47862081,0.42389541,0.36918828,0.34120958,0.28473326,0.23213063,0.22894793,0.17642334,0.12316092,0.073816157,0.034403511,-0.021559141,0.0090077357,-0.0662488,-0.11600318,-0.18162342,-0.25624357,-0.28607137,-0.27560765,-0.26993594,-0.29268898,-0.29551459,-0.31995095,-0.39452243,-0.45380244,-0.4920682,-0.53037537,-0.54078069,-0.54527289,-0.54923432,-0.55716772,-0.53857067,-0.53863129,-0.53553973,-0.53881737,-0.54055688,-0.5420968,-0.54842025,-0.54810213,-0.55509053,-0.55888573,-0.55847869,-0.55602361,-0.55496674,-0.56071453,-0.56568785,-0.57897881,-0.60079047,-0.61573296,-0.63130279,-0.64357173,-0.65436384,-0.66472645,-0.67587352,-0.68438576,-0.68194727,-0.67291332,-0.66528177,-0.66691917,-0.67169683,-0.68092273,-0.68688231,-0.70015898,-0.72652646,-0.73938053,-0.7532916,-0.7508182,-0.74164616,-0.71904089,-0.6955847,-0.67674093,-0.65582017,-0.64639896,-0.63352873,-0.62463867,-0.61961968,-0.61632684,-0.60421571,-0.60741795,-0.60730107,-0.59236356,-0.59645629,-0.58302274,-0.57587134,-0.56753788,-0.56424994,-0.54443843,-0.5503989:2
1.9485389,1.8981896,1.87315,1.8084175,1.7794545,1.7251683,1.6546842,1.5884013,1.4993671,1.4304773,1.3610912,1.2554014,1.1618753,1.0673012,0.97528756,0.91907678,0.81743837,0.72320712,0.61522025,0.50811405,0.41480324,0.30726198,0.20007447,0.093034896,-0.013916564,-0.075299252,-0.15374238,-0.245567,-0.35247159,-0.44402412,-0.54955756,-0.6392483,-0.72246029,-0.76422996,-0.67804342,-0.59330313,-0.50840193,-0.45483644,-0.37071536,-0.30494532,-0.23983804,-0.18848216,-0.20893365,-0.13467951,-0.060829779,-0.029377082,0.0051406414,-0.0068364697,0.042365073,0.080244399,0.053471254,0.096519323,0.1475583,0.20787238,0.22606228,0.28068317,0.31982167,0.36012283,0.31270461,0.24032681,0.24758511,0.29365648,0.3028087,0.36678047,0.37936496,0.40420251,0.36482837,0.32770946,0.39745792,0.42937932,0.47629965,0.58128704,0.55430838,0.61468532,0.70109177,0.73554856,0.82282869,0.8989226,0.96031758,1.0307986,1.0556087,0.93467102,0.84375455,0.76195559,0.6682123,0.59226287,0.4762068,0.3853858,0.32200934,0.25840448,0.19514844,0.088926212,0.011619089,-0.074479955,-0.15856309,-0.23348479,-0.33983621,-0.41940949,-0.48362275,-0.57453655,-0.65460672,-0.74055603,-0.83266842,-0.91938149,-0.98455718,-1.0638486,-1.125617,-1.2294337,-1.2963327,-1.3625763,-1.4159851,-1.4584151,-1.484686,-1.516294,-1.565327,-1.5900361,-1.5851967,-1.5581016,-1.4757695,-1.4373519,-1.3557625,-1.2348602,-1.1411402,-1.044657,-0.97273063,-0.92125482,-0.88670982,-0.98542798,-1.0980439,-1.1862315,-1.2884791,-1.3794656,-1.4992716,-1.6011068,-1.6744922,-1.7517264,-1.866338,-1.9562273,-1.9853828,-1.913958,-1.817928,-1.7735631,-1.7564939,-1.6887241,-1.5869869,-1.4937822,-1.4089248,-1.3352556,-1.2302544,-1.1588708,-1.0835029,-1.0117322,-0.96091224,-0.88089991,-0.79719265,-0.70559579,-0.61850517,-0.53598298,-0.47690155,-0.39526173,-0.33942523,-0.2581832,-0.17410566,-0.091332221,-0.037993661,0.045702394,0.13736048,0.20868334,0.29312982,0.33107562,0.40902722,0.45287142,0.37429242,0.2922618,0.26596803,0.20562961,0.27639819,0.38136988,0.46644563,0.42507969,0.51286135,0.59958169,0.69223457,0.71296528,0.81160726,0.89863952,0.90768633,0.91451709,0.99808498,1.0607169,1.1560515,1.1682031,1.2546595,1.3545367,1.4562953,1.5753555,1.6619268,1.751231,1.8566423,1.9515822,2.0691137,2.1759311,2.2746563,2.2092016,2.1345314,2.0602127,1.9737976,1.9266887,1.848122,1.7898642,1.6929579,1.6366557,1.5885454,1.495532,1.4123174,1.4084651,1.3765126,1.2993963,1.2372441,1.2081446,1.2230226,1.1589772,1.0911066,1.0148091,0.94269336,0.86113588,0.88909981,0.90085305,0.83005376,0.75313783,0.69716679,0.63724368,0.57125303,0.51609586,0.50350083,0.54120384,0.50699964,0.41487281,0.36902255,0.26293789,0.2321129,0.21989618,0.26062459,0.33936411,0.41500666,0.45066431,0.5288617,0.58887009,0.66099152,0.57773499,0.49218867,0.43902042,0.36162824,0.32085414,0.23445145,0.18333014,0.128654,0.10408274,0.02177372,-0.025566557,-0.10400956,-0.16325335,-0.19084709,-0.27817724,-0.35389661,-0.44656296,-0.48999332,-0.49710278,-0.5788357,-0.64561866,-0.72385052,-0.77857059,-0.8743027,-0.92793489,-1.0093497,-1.0978324,-1.1705472,-1.2092495,-1.2863947,-1.365034,-1.472375,-1.5329353,-1.63722,-1.7116223,-1.7714973,-1.8068679,-1.7993535,-1.8484992,-1.8792046,-1.9517459,-1.9980135,-2.0544414,-1.9609152,-1.9133765,-1.8116629,-1.7180238,-1.6431017,-1.5230035,-1.510309,-1.5925983,-1.6352507,-1.6620118,-1.6628278,-1.6521156,-1.6156283,-1.5836999,-1.5328238,-1.4755212,-1.4100401,-1.339871,-1.2678732,-1.1891283,-1.1273072,-1.0659486,-0.99796627,-0.9136386,-0.83497906,-0.76931432,-0.72720416,-0.64269614,-0.55116138,-0.47649077,-0.39080168,-0.32400458,-0.23915976,-0.14265044,-0.058971085,0.0089256055,0.075530931,0.15423117,0.24196976,0.31659277,0.38880348,0.47444093,0.56744795,0.66366107,0.75224689,0.68638783,0.61710094,0.57209577,0.48953455,0.44614095,0.42982131,0.39659135,0.34394526,0.29245816,0.34812753,0.31326395,0.26505951,0.25519565,0.19511697,0.23585405,0.2306935,0.18110073,0.13360996,0.12515826,0.074771676,0.13100423,0.20656203,0.17129314,0.12750491,0.12929221,0.10586755,0.068723504,0.036483448,0.1133819,0.1720662,0.25369,0.21069473,0.18868898,0.13842083,0.14193324,0.091058229,0.093899064,0.052924348,0.0083067979,0.020303964,0.083227161,0.11088396,0.074721816,0.047484235,0.033821344,-0.039111967,-0.031468756,-0.072183718,-0.11942003,-0.19243005,-0.16459931,-0.225906,-0.25596927,-0.32524344,-0.34762017,-0.40684161,-0.47653149,-0.54906023,-0.61160965,-0.68355606,-0.62421878,-0.50365916,-0.44149601,-0.33571583,-0.22971028,-0.11251276,-0.0028473638,0.10336868,0.20441877,0.3048706,0.40786592,0.48544334,0.59000892,0.68465753,0.79173793,0.88331785,0.96201107,1.0692441,1.1626552,1.2666664,1.3455864,1.4408061,1.5114009,1.5955352,1.6715835,1.7202398,1.7943576,1.8096459,1.8535461,1.9235837:6
1.0485972,0.97836408,0.9152695,0.84743127,0.78963997,0.720722,0.63497266,0.55904705,0.48539969,0.40398532,0.33387079,0.24321961,0.16897312,0.0735516,-0.021563032,-0.11773365,-0.21532365,-0.33814333,-0.43879166,-0.56351616,-0.66502798,-0.79017612,-0.8902267,-1.0122018,-1.1339335,-1.2536057,-1.3592253,-1.4630853,-1.5266509,-1.5665719,-1.496156,-1.4112535,-1.3246733,-1.2341939,-1.1525313,-1.0620956,-0.98154816,-0.89433233,-0.81140393,-0.72004322,-0.63380339,-0.54764635,-0.45921933,-0.3690946,-0.28737104,-0.19901347,-0.11015452,-0.031477414,0.057391368,0.14417459,0.22501944,0.32125199,0.3994843,0.4902476,0.56793348,0.6523789,0.73601556,0.82310866,0.89903574,0.98534131,1.0629846,1.1398176,1.1772947,1.1889581,1.213294,1.2151692,1.1993495,1.1914693,1.163903,1.1326031,1.0916362,1.0301361,0.95732131,0.88271194,0.84817675,0.7956907,0.752447,0.69027097,0.62033714,0.54298177,0.46639419,0.38971746,0.30880839,0.22622853,0.13938351,0.06409371,-0.018905821,-0.095114599,-0.17543706,-0.25923023,-0.3305103,-0.39731671,-0.45933759,-0.51480562,-0.57963213,-0.64918376,-0.71350954,-0.79371734,-0.85648992,-0.92638957,-0.99558442,-1.072106,-1.1445285,-1.2158594,-1.2876291,-1.3656367,-1.4309943,-1.4827554,-1.5358155,-1.580566,-1.6016145,-1.6283332,-1.6436257,-1.6093158,-1.5621649,-1.5016064,-1.4318858,-1.3553753,-1.2766295,-1.1864049,-1.1013916,-1.1119662,-1.0138046,-1.0303482,-0.90830238,-0.83738533,-0.73150692,-0.60836418,-0.50531497,-0.4084656,-0.33086353,-0.25995289,-0.19437609,-0.15028101,-0.10583273,-0.080003316,-0.056676275,-0.048399595,-0.057806058,-0.061938111,-0.067333963,-0.071124348,-0.075326143,-0.081933678,-0.086918076,-0.086255673,-0.093670552,-0.09041221,-0.091424697,-0.087792686,-0.091774562,-0.099124284,-0.077142622,-0.011153828,0.065873807,0.16407321,0.25372875,0.334456,0.42395299,0.52181525,0.61251343,0.6722338,0.71393939,0.73669769,0.71251458,0.66344514,0.65941842,0.71253454,0.75966999,0.80363672,0.87562366,0.94787627,1.0386695,1.1164579,1.1776432,1.2129613,1.2443687,1.244359,1.252597,1.2478752,1.265433,1.3133355,1.4139937,1.5196082,1.6040589,1.7044251,1.7989782,1.8879172,1.9773208,2.0827472,2.1579184,2.1741838,2.1916042,2.1456466,2.0660975,1.9778254,1.877474,1.7733008,1.6569464,1.5661171,1.4571079,1.3795947,1.3107392,1.2859869,1.2916669,1.2699322,1.2288364,1.1733916,1.1270772,1.0696122,1.0179622,0.95754617,0.89429215,0.8184093,0.7462655,0.68448783,0.62575938,0.5601447,0.5120222,0.54145947,0.53036528,0.52177861,0.52702887,0.53005391,0.54111375,0.5337977,0.52293564,0.51648207,0.49170762,0.47544456,0.46222846,0.43549621,0.40730611,0.37743092,0.33889649,0.30268257,0.24900964,0.19964777,0.13435587,0.050945324,-0.036588719,-0.13871874,-0.22560996,-0.30987831,-0.40083918,-0.4808319,-0.56264239,-0.64022394,-0.72384194,-0.798421,-0.86493757,-0.93127306,-0.98092865,-1.0335865,-1.0956877,-1.1356844,-1.1853449,-1.2319688,-1.2594105,-1.2779694,-1.2768566,-1.2301078,-1.1962423,-1.1607185,-1.1062448,-1.0987391,-1.0574799,-1.0149983,-0.95573128,-0.90097258,-0.84907523,-0.7958918,-0.7310494,-0.66562869,-0.58839147,-0.54244361,-0.49557586,-0.44100623,-0.39674927,-0.33564616,-0.30546078,-0.24480366,-0.1800551,-0.12411397,-0.068554671,-0.0029205593,0.06890394,0.12580615,0.18958741,0.24716842,0.29312828,0.32692455,0.32371757,0.27183268,0.22018836,0.22404297,0.26217011,0.30566121,0.3469297,0.38751494,0.42548958,0.44784674,0.45301327,0.44217042,0.38714666,0.32051925,0.23871127,0.13501071,0.035417638,-0.064239711,-0.16700202,-0.27489845,-0.38794637,-0.49191236,-0.61279857,-0.71784226,-0.84201076,-0.93805938,-1.0296137,-1.1022968,-1.2058273,-1.3095584,-1.3909011,-1.4941559,-1.6194138,-1.7217382,-1.8249293,-1.9046215,-2.0006802,-2.0744916,-2.1866709,-2.2835766,-2.3678279,-2.4122488,-2.361063,-2.2963366,-2.2134131,-2.1348995,-2.1446482,-2.0248608,-1.9509961,-1.850941,-1.7735091,-1.6887632,-1.604086,-1.4982661,-1.4517491,-1.431347,-1.3546504,-1.2658596,-1.2173375,-1.1575408,-1.0720547,-0.9741354,-0.89273419,-0.84883172,-0.75727209,-0.66542347,-0.60020112,-0.55610549,-0.47630188,-0.38925144,-0.30877035,-0.22601895,-0.14824914,-0.060056777,0.015023464,0.10237383,0.17864021,0.25786522,0.33392199,0.41640652,0.49746315,0.56581524,0.64895213,0.73126328,0.80631168,0.88534176,0.95115038,0.99706644,1.0321211,1.0163368,0.9889324,0.95390309,0.8874476,0.81130904,0.74275397,0.67027964,0.6037908,0.55440739,0.48120847,0.40379731,0.35002673,0.26417811,0.19574615,0.19146029,0.270897,0.36321028,0.46282506,0.55875834,0.66311057,0.75680419,0.86086965,0.95581777,1.0580423,1.1415011,1.221313,1.2936816,1.3545029,1.4219968,1.4692436,1.431941,1.3854889,1.3418665,1.3009689,1.2606336,1.2007548,1.1333881,1.1349343,1.1795681,1.1555948,1.132179,1.1121529,1.0958424,1.082596,1.0732533,1.0665392:2
1.6735862,1.6602892,1.6208584,1.586277,1.4744952,1.3621156,1.2522249,1.1653097,1.083521,1.112091,1.1328997,1.0224513,0.92357575,0.81689377,0.70632318,0.59422885,0.49891838,0.38926135,0.27892511,0.168113,0.074842938,-0.036857098,-0.14459005,-0.25594448,-0.34970014,-0.4655954,-0.56676766,-0.67613723,-0.78593579,-0.89627762,-1.0048587,-1.1281815,-1.1770323,-1.0687632,-0.99316809,-0.91841117,-0.8316157,-0.79117473,-0.80591857,-0.70457493,-0.6369037,-0.5396493,-0.50001039,-0.47125826,-0.38654976,-0.33896797,-0.318357,-0.23293457,-0.27333376,-0.30323637,-0.35378824,-0.35884279,-0.25596595,-0.19336851,-0.094850434,-0.059043845,-0.028047337,0.073538071,0.11558115,0.13112374,0.22079281,0.2516182,0.2474007,0.2223487,0.15351553,0.23880734,0.34230623,0.35648697,0.47043005,0.51165129,0.52609787,0.53499609,0.52672315,0.61830896,0.69438519,0.73896932,0.79410659,0.80338686,0.81018985,0.89352303,0.94834357,0.98986317,1.0433789,1.1181259,1.1557371,1.2408593,1.2990867,1.3953146,1.3178682,1.2235501,1.1022435,1.0079227,0.88484963,0.7918808,0.70552641,0.59246974,0.49059409,0.38442702,0.31876754,0.21209945,0.1131822,0.0036768909,-0.10101446,-0.2415848,-0.34621524,-0.43761195,-0.56329602,-0.68607371,-0.78205169,-0.86223424,-0.92962132,-1.0576228,-1.1932156,-1.2579634,-1.358355,-1.4768788,-1.5357259,-1.5903022,-1.7099415,-1.795495,-1.8781345,-1.9761788,-2.0545599,-2.0563918,-1.9522263,-1.8930469,-1.8203161,-1.760096,-1.6987595,-1.5894722,-1.4781449,-1.4051651,-1.3115651,-1.2170416,-1.1300771,-1.0635996,-0.99790513,-0.91901074,-0.83295783,-0.7444759,-0.66022883,-0.5910093,-0.50322118,-0.41022468,-0.33537939,-0.26050492,-0.17601927,-0.10468258,-0.011193506,0.059269434,-0.0060609231,-0.072617988,-0.097534869,-0.18317046,-0.27721178,-0.32409233,-0.35098718,-0.43645725,-0.46812426,-0.56867745,-0.60688298,-0.59951531,-0.67077096,-0.75920825,-0.75865713,-0.84537452,-0.94667326,-0.9194408,-0.9861885,-0.90722712,-0.80428165,-0.71911631,-0.62126759,-0.49755408,-0.36139659,-0.24004239,-0.13128764,-0.0095581559,0.12822805,0.26429409,0.35185686,0.42294499,0.4314577,0.46202214,0.47053293,0.58662979,0.70243264,0.7591933,0.8700161,0.95843184,1.0162231,1.0883223,1.0663835,1.0771915,1.1839035,1.2822086,1.3654596,1.423499,1.4951786,1.5566979,1.5593279,1.572287,1.6584376,1.7449456,1.7784758,1.8607755,1.8661989,1.9364462,2.0195217,2.094919,2.0973599,2.1744323,2.2525173,2.2851907,2.3663886,2.4326936,2.437691,2.3156257,2.2256589,2.1400914,2.0315837,1.9190586,1.8789212,1.7757667,1.6745623,1.6398221,1.5529373,1.4356433,1.4381436,1.4282365,1.3569408,1.3106657,1.2271041,1.1090037,1.1407342,1.1611118,1.1441256,1.1027062,1.0169684,0.97750594,0.87385639,0.81634418,0.78174772,0.67072114,0.56148365,0.54899641,0.58025677,0.55622794,0.57176013,0.55814597,0.45182011,0.41180763,0.32535125,0.22031239,0.17525073,0.096219153,-0.0016463516,-0.088609714,-0.12931862,-0.2245506,-0.32258616,-0.34761166,-0.32332198,-0.23545827,-0.12463604,-0.020515955,-0.002456621,0.045681266,0.15259715,0.20176819,0.26789548,0.33094306,0.33615626,0.25688242,0.1805241,0.22502277,0.13189043,0.047127997,-0.044157006,-0.035489711,-0.093399451,-0.18288255,-0.28311217,-0.36548963,-0.36652364,-0.39428435,-0.47445145,-0.50728445,-0.6168125,-0.72058738,-0.72781082,-0.82451585,-0.93371207,-1.0557586,-1.0673345,-1.1016595,-1.1911405,-1.2568275,-1.3752002,-1.4385061,-1.5293419,-1.6723962,-1.8104279,-1.843109,-1.9252076,-1.9212411,-1.7985227,-1.7468038,-1.6887231,-1.6074465,-1.5016388,-1.3809733,-1.2910163,-1.219663,-1.1114655,-1.0238523,-0.90103311,-0.8318222,-0.77259308,-0.70479816,-0.58494067,-0.47088352,-0.36162911,-0.25325107,-0.14601138,-0.09300193,0.0065968677,0.12538271,0.23803701,0.33363973,0.38886575,0.5067614,0.61763778,0.69553556,0.81096229,0.90164104,0.86320194,0.80296198,0.68279295,0.66563863,0.59174769,0.55073917,0.52527889,0.44847925,0.32624093,0.39104596,0.34971977,0.26366351,0.23938878,0.12987488,0.13933807,0.19476303,0.13459777,0.052629402,0.051552665,-0.057287269,-0.081657538,-0.028575127,0.016596369,-0.032614139,-0.12013679,-0.068973032,-0.14918023,-0.24170969,-0.33435412,-0.28438952,-0.24608639,-0.23222308,-0.28833616,-0.27844069,-0.36526752,-0.40992082,-0.41534836,-0.50233801,-0.54723066,-0.63936201,-0.69923947,-0.66313256,-0.69982462,-0.77665804,-0.85412996,-0.93833928,-1.0053593,-0.99133938,-1.0697209,-1.1305487,-1.2145601,-1.2876079,-1.3681641,-1.443371,-1.5353709,-1.638751,-1.7483259,-1.8473749,-1.7606291,-1.6559693,-1.5508187,-1.4455194,-1.3372649,-1.2293336,-1.116013,-1.001033,-0.9290603,-0.82645567,-0.71971217,-0.61168832,-0.50362657,-0.39624428,-0.2893654,-0.18556518,-0.082549479,0.021583202,0.13164442,0.23713913,0.33956417,0.44216497,0.55255712,0.66120742,0.78153144,0.86475365,0.97071121,1.0731341,1.1777621,1.2815781,1.3839288,1.4987003,1.6021023:6
1.5586404,1.5178529,1.3809658,1.2268883,1.0943266,0.94440841,0.80920275,0.68778571,0.51853627,0.37426912,0.20751458,0.035455453,-0.12243716,-0.1843672,-0.25715577,-0.42564863,-0.59387474,-0.75150435,-0.92562009,-1.0643632,-1.2103143,-1.3927068,-1.5571187,-1.7046567,-1.837287,-1.9905818,-2.1565861,-2.3359589,-2.3700066,-2.3141788,-2.1820773,-2.0864289,-1.9702102,-1.8272568,-1.6905509,-1.5508102,-1.4527641,-1.3142642,-1.1620772,-1.1067365,-1.1848349,-1.2809985,-1.1926981,-1.0538951,-0.91241627,-0.78349591,-0.62042325,-0.52408192,-0.4764596,-0.40739422,-0.22721473,-0.084281012,0.081290105,0.21919837,0.33281929,0.23187774,0.08851946,-0.039356367,-0.16234341,-0.27006882,-0.36380994,-0.42005045,-0.24041013,-0.12750138,0.066429264,0.10986026,0.21455172,0.34265805,0.45160066,0.60978165,0.75842523,0.77096932,0.78188792,0.9943876,1.1514826,1.2665808,1.3340227,1.4962513,1.57965,1.7249516,1.8428154,2.0080982,2.1247038,2.1183263,2.0074556,1.8242979,1.6707531,1.4585442,1.2689148,1.1676268,1.0009423,0.83423574,0.63673546,0.67117164,0.66129748,0.58320875,0.46590762,0.25694936,0.12765312,0.083243627,-0.080987297,-0.25120237,-0.35003752,-0.39240844,-0.3092971,-0.20144265,-0.070537002,0.076560603,0.11067496,0.04868699,-0.055556446,-0.19770124,-0.23762358,-0.36974343,-0.55121726,-0.51944126,-0.50027504,-0.6295308,-0.80461044,-0.97788629,-1.1730008,-1.3394401,-1.4711518,-1.4986894,-1.3625933,-1.3146089,-1.4406394,-1.560091,-1.7220717,-1.8891086,-1.9921786,-2.1445995,-2.3181886,-2.4700057,-2.5584012,-2.6904522,-2.6885006,-2.5524488,-2.3831925,-2.2495816,-2.0889621,-1.9266599,-1.7876507,-1.6142133,-1.4672297,-1.3171159,-1.188511,-1.0280059,-0.9241081,-0.86307378,-0.7081112,-0.54910811,-0.38110026,-0.22118754,-0.077378386,0.065638367,0.23696735,0.41141506,0.55477354,0.68515585,0.84653472,1.0107613,1.1213931,1.2560593,1.4195852,1.5563988,1.725451,1.8797124,1.9365204,1.8387391,1.6954796,1.5843931,1.5228844,1.3859696,1.2710191,1.2477082,1.1329014,1.002645,0.87797975,0.79269019,0.6828799,0.64644762,0.74790211,0.71813626,0.6034673,0.52426428,0.4080597,0.3117281,0.29493965,0.18871946,0.087188029,0.0069147594,-0.059609793,0.052356014,0.19127448,0.37648597,0.36818033,0.31431819,0.2553739,0.16427247,0.082935117,0.11657755,0.046526388,-0.056879657,-0.16448506,-0.26513804,-0.36390482,-0.28114552,-0.11451235,-0.13492225,-0.20286164,-0.30609095,-0.38643495,-0.41357677,-0.48203706,-0.5272028,-0.58849253,-0.59512168,-0.41472761,-0.27406378,-0.11290714,0.020484557,0.19485302,0.3171054,0.45779197,0.63501897,0.80599566,0.98066329,1.0760266,1.0469315,0.9663758,0.96741659,0.89165549,0.8296705,0.75532826,0.8227964,0.76931283,0.68886096,0.60241047,0.50180019,0.45479645,0.31271838,0.34692274,0.51543657,0.63440417,0.63902157,0.53981923,0.44648741,0.34122939,0.25205168,0.18527235,0.046814453,-0.091420962,-0.22985443,-0.29756383,-0.15109846,0.0016368923,0.032482867,-0.025995425,-0.15202143,-0.25060736,-0.32491208,-0.4377951,-0.53585705,-0.63821962,-0.73760618,-0.81520839,-0.89095163,-0.96345738,-1.0228654,-1.0715745,-1.1352993,-1.181651,-1.2405004,-1.3176121,-1.2042156,-1.1235354,-0.98249419,-0.80999433,-0.68299601,-0.53405828,-0.35751146,-0.27072259,-0.23669982,-0.090800406,0.039275621,0.20637188,0.4183844,0.58556193,0.75274128,0.96510027,1.1774329,1.2130137,1.4226119,1.6350657,1.7544242,1.8851808,2.0940302,2.2965989,2.3342521,2.2323037,2.0532067,1.8905011,1.7256148,1.6237573,1.4853315,1.3187166,1.1329746,0.95682288,0.76877336,0.55535378,0.38759226,0.21806229,0.095207378,-0.04770326,-0.2291915,-0.18535251,-0.35088017,-0.40282966,-0.51454517,-0.6749634,-0.84384541,-1.0440301,-1.1288155,-1.2152582,-1.2200118,-1.1509011,-1.1041266,-1.0744013,-1.0272053,-0.96923963,-0.91097971,-0.85142179,-0.77657297,-0.68584373,-0.58666357,-0.47290118,-0.37177347,-0.28218313,-0.14162413,-0.02215962,0.045174249,0.10641868,0.1583982,0.16125377,0.037109845,-0.096161253,-0.08734358,0.036642406,0.18108993,0.28720972,0.28487942,0.40073938,0.48204086,0.56868796,0.64273958,0.64932926,0.49979931,0.47584806,0.58083286,0.63867378,0.69681568,0.78262503,0.81307144,0.80768204,0.89531223,0.94473739,0.97065149,0.87392424,0.72934736,0.55452427,0.40860533,0.2537684,0.084396357,-0.068600105,-0.21624859,-0.37564082,-0.54049046,-0.72467666,-0.74154526,-0.69030058,-0.650904,-0.58724876,-0.52708817,-0.47994745,-0.42383702,-0.37121585,-0.31573642,-0.34983081,-0.46638986,-0.59738796,-0.51812953,-0.40082135,-0.27725345,-0.18137217,-0.16227122,-0.1186365,-0.041409997,0.01108112,0.048463481,-0.039015787,-0.23204655,-0.39215485,-0.28180601,-0.18212505,-0.076014313,-0.009715335,0.026546783,0.11410797,0.2136931,0.3069043,0.33884085,0.22784794,0.26153719,0.36419638,0.47696279,0.58752244,0.72613681,0.82492709,0.80207583,0.88864441,1.0075481,1.1331381,1.2317999,1.2986275,1.4052373,1.5165462:3
2.0551923,2.0172546,1.9628922,1.9163608,1.8823062,1.8470669,1.863108,1.868546,1.9115519,1.9014122,1.9351012,1.8995786,1.833301,1.7560467,1.7224679,1.6452363,1.5582133,1.4859204,1.4103117,1.3219134,1.284028,1.2323995,1.1565326,1.0835049,1.0082426,0.92863955,0.85053014,0.77835615,0.69955468,0.62415526,0.55495153,0.47435954,0.42385535,0.34784986,0.26553864,0.19514934,0.12567151,0.04975741,-0.034278652,-0.11694982,-0.19153494,-0.24088131,-0.29584951,-0.36517869,-0.43454522,-0.51952889,-0.58968653,-0.66148183,-0.7408499,-0.8165521,-0.89251786,-0.96630342,-1.0491439,-1.1234657,-1.1990558,-1.2858652,-1.3651337,-1.447146,-1.5040986,-1.5471978,-1.5356469,-1.5134531,-1.4724458,-1.446452,-1.422715,-1.4035364,-1.3754236,-1.3412995,-1.2950495,-1.2229224,-1.1725405,-1.1507563,-1.1566482,-1.1066921,-1.0500635,-0.9967559,-0.9664141,-0.92540896,-0.93352086,-0.95659096,-0.91574933,-0.85911437,-0.80247584,-0.74443055,-0.69117944,-0.63392459,-0.57656376,-0.58584426,-0.6144002,-0.59370121,-0.52657903,-0.46482269,-0.39140689,-0.32278077,-0.24962681,-0.18328363,-0.14267094,-0.063845412,0.0069764826,0.085703862,0.15599967,0.23587417,0.31105032,0.38083675,0.33308149,0.26354632,0.1958792,0.12205589,0.068973995,0.0011066435,-0.076736666,-0.11752312,-0.15926697,-0.23795779,-0.27221467,-0.26341994,-0.1780719,-0.11282379,-0.038457935,0.01604045,0.10231011,0.18290564,0.18623692,0.16377954,0.19154141,0.26243394,0.34406801,0.39675026,0.49420346,0.48729412,0.58130252,0.66408871,0.72855516,0.80470246,0.82532401,0.89300003,0.99347176,1.0939809,1.1706024,1.269092,1.3498738,1.4299837,1.5225339,1.5805592,1.646955,1.7096868,1.8141599,1.8793845,1.9612499,2.0379094,2.0142659,1.9420413,1.8845333,1.7983153,1.7443737,1.65659,1.5875531,1.576929,1.4904896,1.4007103,1.3805612,1.3106088,1.2463198,1.215664,1.1589974,1.1321416,1.059264,0.97994272,0.91872566,0.94400011,0.93267585,0.86422606,0.80096419,0.70352841,0.69039077,0.73168124,0.71850262,0.6550944,0.59386501,0.59714404,0.50803418,0.45422165,0.44687903,0.45160421,0.50303962,0.4733589,0.41628746,0.32208176,0.28231233,0.26869595,0.18197511,0.13636343,0.18588577,0.24846259,0.29603725,0.34576725,0.31848257,0.25143321,0.15936272,0.14631843,0.071942993,0.066834255,-0.001856111,-0.088432911,-0.10410538,-0.16991927,-0.25694533,-0.33137325,-0.34578309,-0.36770501,-0.44433367,-0.52293882,-0.54460927,-0.61494338,-0.69321348,-0.76499139,-0.8504349,-0.84333427,-0.83690235,-0.86050968,-0.93075185,-0.97692892,-1.0504202,-1.1046992,-1.1756867,-1.2460838,-1.319443,-1.3999249,-1.4720749,-1.5431202,-1.5854352,-1.6059495,-1.619298,-1.6343695,-1.7340927,-1.8131687,-1.8747381,-1.9572501,-2.0376484,-1.9695385,-1.9030774,-1.8244797,-1.7422802,-1.7199129,-1.6777657,-1.6043808,-1.535566,-1.4583717,-1.3829607,-1.3124633,-1.2372313,-1.1506422,-1.1060039,-1.1261392,-1.0471556,-0.9722043,-0.89624598,-0.83291055,-0.7467263,-0.66359476,-0.63256607,-0.56091417,-0.48668965,-0.41224533,-0.33852878,-0.26252166,-0.17392716,-0.11589385,-0.054316734,0.042933192,0.12054311,0.20267466,0.21372835,0.28629981,0.38889651,0.47579937,0.51697621,0.59974848,0.67570613,0.71671405,0.80539959,0.8854642,0.96496015,0.89809684,0.83735627,0.7724276,0.68606784,0.63180513,0.55714377,0.47338164,0.49274343,0.4293738,0.36203346,0.29364173,0.32539899,0.26308673,0.20157494,0.13724869,0.18174529,0.13691362,0.072164114,0.031220244,-0.027092094,0.0041182341,0.034424557,-0.016834227,-0.069434131,-0.1458795,-0.18433353,-0.21486444,-0.14983607,-0.090641296,-0.13813824,-0.20630343,-0.25964383,-0.32476736,-0.31125809,-0.37256734,-0.46252087,-0.47622765,-0.47115574,-0.40773245,-0.35746387,-0.41281529,-0.47472689,-0.55330422,-0.55932507,-0.63782981,-0.70557171,-0.79101956,-0.86997534,-0.94427505,-0.93227069,-0.85353933,-0.78112338,-0.72395191,-0.66385751,-0.58633889,-0.52701443,-0.49122513,-0.41728504,-0.3919578,-0.31553503,-0.2435648,-0.1644475,-0.16260215,-0.2184641,-0.27623928,-0.32303869,-0.38549969,-0.3632107,-0.43188643,-0.49177557,-0.51871423,-0.58030868,-0.65092281,-0.7110665,-0.71676222,-0.74844105,-0.80647409,-0.86262832,-0.91896972,-0.97603581,-1.0470471,-1.1189699,-1.1852141,-1.2557185,-1.321076,-1.3828504,-1.4502613,-1.5116643,-1.4645301,-1.4495476,-1.3899133,-1.314072,-1.2401766,-1.1705856,-1.0937913,-1.0200026,-0.94701186,-0.87039058,-0.79802112,-0.7253649,-0.64973075,-0.57462424,-0.50011003,-0.41789414,-0.3462831,-0.26842252,-0.1917821,-0.11112439,-0.038189488,0.045844286,0.068329492,0.10581607,0.17912693,0.25387856,0.3308291,0.40749386,0.48260446,0.55894985,0.63522919,0.70643579,0.7357371,0.80960715,0.88566082,0.96326009,1.0412444,1.1167998,1.1951543,1.2710552,1.3450567,1.4117352,1.4430612,1.5276991,1.6043732,1.6599279,1.6779524,1.7377419,1.7813609,1.8154166,1.8312434,1.8371737,1.8643514,1.9124571,1.9792777,2.0190833:6
0.79816079,0.76505604,0.7239915,0.6750377,0.63046442,0.57951884,0.53504884,0.48421838,0.43306534,0.37396132,0.31897905,0.2700555,0.21714314,0.1636187,0.11807481,0.059871023,9.6522177E-4,-0.051282435,-0.096059429,-0.13806921,-0.18923629,-0.23962397,-0.28838634,-0.33628844,-0.38433393,-0.4444868,-0.496963,-0.55046842,-0.60084036,-0.64825077,-0.70354502,-0.75787597,-0.82458921,-0.89096331,-0.95439054,-1.0112487,-1.0691242,-1.137098,-1.2214492,-1.2979976,-1.3799696,-1.4606966,-1.5293635,-1.6164651,-1.6777807,-1.7528356,-1.8207202,-1.8717904,-1.9156337,-1.9373665,-1.9311187,-1.9025102,-1.8626949,-1.792956,-1.708104,-1.6274993,-1.5499104,-1.4675613,-1.3912989,-1.3054892,-1.2228863,-1.1451861,-1.0644879,-0.99211904,-0.90237648,-0.82010236,-0.75360845,-0.65982106,-0.58330495,-0.5425278,-0.50774399,-0.47685724,-0.45600194,-0.44051395,-0.43087058,-0.42022774,-0.41122289,-0.41095654,-0.40095144,-0.39275406,-0.37933097,-0.36915855,-0.37900025,-0.38485738,-0.4053737,-0.42813715,-0.43962287,-0.45400737,-0.45946768,-0.46175584,-0.46595763,-0.46844802,-0.47477119,-0.46722658,-0.47489954,-0.48150166,-0.5141682,-0.54070796,-0.56849264,-0.5918675,-0.60796936,-0.62146067,-0.59580419,-0.48377109,-0.40556245,-0.32660876,-0.24775942,-0.13543108,-0.050145839,0.046932628,0.12045686,0.17813853,0.22762747,0.27352882,0.31861405,0.36435459,0.40926788,0.44931695,0.48477239,0.52318305,0.56459481,0.60572378,0.6396075,0.67270043,0.70900936,0.73228004,0.76427405,0.78535756,0.81152874,0.84134664,0.86135223,0.87980804,0.91874942,0.94890679,1.0004622,1.0271244,1.0815837,1.1249611,1.1939735,1.2653927,1.332644,1.4237775,1.4946289,1.5834341,1.6557924,1.7387826,1.8241842,1.9066328,1.9825685,2.0774138,2.1490403,2.2282661,2.2978087,2.3809494,2.4131029,2.4316346,2.3990608,2.3474408,2.2689315,2.1773252,2.168629,2.1524604,2.0703965,2.0353954,1.9598945,1.8724911,1.7997152,1.7224572,1.6456596,1.5610867,1.4796066,1.4021326,1.3194482,1.2304187,1.150847,1.0924351,1.0549617,1.0052457,0.97535479,0.92831485,0.89241978,0.85013954,0.79356153,0.7666952,0.76421238,0.7650982,0.77052515,0.76435369,0.76560462,0.74902575,0.73333016,0.71352015,0.67989171,0.64394564,0.61428955,0.55979428,0.52668272,0.49898803,0.47629587,0.43949202,0.41620965,0.38619213,0.37021151,0.34637718,0.32297548,0.28016348,0.24418035,0.19087551,0.17929317,0.13586135,0.090309258,0.044120182,-9.3253965E-4,-0.063465996,-0.1191888,-0.17551094,-0.23944435,-0.31171896,-0.39625378,-0.47985303,-0.59338846,-0.67599023,-0.75778442,-0.87032669,-0.95016453,-1.0211335,-1.0821236,-1.1439461,-1.1264074,-1.1121291,-1.0968929,-1.0567576,-1.0230586,-0.9823077,-0.94098857,-0.90455772,-0.86688252,-0.83035463,-0.78690611,-0.74208146,-0.70348747,-0.66750109,-0.62058263,-0.58008642,-0.52807995,-0.49017844,-0.47852804,-0.45581151,-0.4392133,-0.39396421,-0.36524268,-0.31665734,-0.28689437,-0.26165887,-0.2562986,-0.23810372,-0.24066886,-0.23826717,-0.24319207,-0.25549395,-0.27729914,-0.31620505,-0.37176902,-0.44561673,-0.522465,-0.60107642,-0.68097802,-0.76492893,-0.8291712,-0.90492245,-0.98073119,-1.0577369,-1.1347118,-1.2209852,-1.2922012,-1.3706268,-1.4467656,-1.5336332,-1.6122976,-1.6891451,-1.7728237,-1.8509735,-1.9316841,-1.9975717,-1.99613,-1.9796693,-1.9579885,-1.902583,-1.8410491,-1.7735029,-1.7158153,-1.6607138,-1.5759846,-1.5201745,-1.4461552,-1.3871004,-1.3270039,-1.2585113,-1.1844464,-1.1254999,-1.0469021,-0.96816855,-0.8863459,-0.81153349,-0.74762815,-0.66774564,-0.59463272,-0.52688685,-0.45528308,-0.37927531,-0.31755887,-0.24945727,-0.17681528,-0.11605709,-0.057417826,0.0050887947,0.070138137,0.13742742,0.19170656,0.25681134,0.30918537,0.35964717,0.39696245,0.44784134,0.46752183,0.44394973,0.33492426,0.26106002,0.1828934,0.11775978,0.024093924,-0.058688926,-0.13564645,-0.20523375,-0.28980697,-0.33742922,-0.44151412,-0.50693643,-0.57466273,-0.6753933,-0.73930541,-0.79623389,-0.84311105,-0.87432272,-0.89003887,-0.86906106,-0.79500447,-0.72462978,-0.65567967,-0.58704574,-0.51047935,-0.43065979,-0.35690793,-0.27439074,-0.19466915,-0.13523328,-0.046244295,0.038292564,0.094574859,0.19331648,0.27634785,0.34783142,0.37498633,0.39600375,0.48716637,0.56620607,0.64861588,0.71966069,0.80361571,0.86943494,0.94485724,1.0181887,1.0801679,1.164178,1.2316863,1.2936695,1.3661918,1.4463431,1.5102208,1.5498007,1.5594977,1.5557873,1.5382948,1.5242526,1.4952817,1.4536487,1.4209798,1.3877581,1.3430102,1.3087004,1.2592319,1.211671,1.1485015,1.070652,1.0191962,0.94763384,0.87886207,0.81352804,0.72535216,0.65846304,0.58509135,0.50506205,0.42502244,0.35585594,0.2754755,0.19625983,0.13379611,0.050395702,-0.0062430202,-0.011629585,0.046825897,0.14207426,0.23734817,0.32174239,0.40089182,0.49703325,0.56364625,0.6615244,0.72636683,0.78811468,0.83532068,0.87044167,0.90204747,0.89457841,0.87260539,0.84180652,0.82397606:2
1.8632435,1.746876,1.681332,1.6420181,1.5104925,1.3935903,1.2894463,1.1930854,1.0885097,0.98891904,0.93355737,0.87232592,0.90379846,0.94812015,1.0084195,1.1332508,1.24312,1.24432,1.1274791,0.99797476,0.87150851,0.74426875,0.62918566,0.55922683,0.43566872,0.30918605,0.18569264,0.06602581,-0.056089319,-0.17973641,-0.29601922,-0.42446553,-0.55012873,-0.66917615,-0.79218133,-0.91496362,-1.0387772,-1.1675339,-1.2904973,-1.4068743,-1.5327834,-1.6629055,-1.6782453,-1.5601292,-1.4418611,-1.3142393,-1.2498344,-1.1311103,-1.0064598,-0.88349073,-0.81483111,-0.72175838,-0.61520102,-0.52398332,-0.44012614,-0.41284981,-0.31546564,-0.16256151,-0.095540117,0.015833317,0.067890911,0.12020777,0.1365365,0.035813041,-0.067754554,-0.12467588,-0.12458249,-0.026295475,0.080616336,0.1044377,0.18280288,0.22086268,0.28075687,0.30535768,0.3486658,0.28039734,0.30314694,0.3731793,0.42350695,0.51498814,0.56126178,0.59596258,0.56283301,0.60977042,0.65100578,0.71801469,0.76263835,0.76014795,0.74981728,0.84286708,0.92158999,0.98786633,1.0448875,1.1313098,1.2110014,1.3107895,1.3940279,1.4930648,1.5924201,1.6289606,1.5103616,1.387898,1.2933803,1.1755395,1.0646383,0.98447662,0.88535815,0.78050083,0.72004557,0.59937501,0.48150999,0.38076393,0.28722274,0.22087548,0.095847643,-0.024054119,-0.13355642,-0.21918416,-0.33398127,-0.3801145,-0.47411366,-0.59279228,-0.69278905,-0.7904368,-0.88999712,-0.99739917,-1.0636153,-1.1770711,-1.2717431,-1.3790764,-1.4221474,-1.5280636,-1.4624813,-1.369683,-1.3517502,-1.2555532,-1.1361104,-1.0352589,-0.99085172,-0.91424202,-0.79170748,-0.69964481,-0.67896413,-0.55606272,-0.44608926,-0.31531064,-0.19263392,-0.063038932,0.035916079,-0.020151156,-0.14535119,-0.25976245,-0.30724378,-0.43526203,-0.49367263,-0.59196025,-0.70695637,-0.73957694,-0.80026915,-0.87984814,-0.99174492,-1.0714696,-1.191589,-1.1970761,-1.3144033,-1.3956532,-1.5444609,-1.5724699,-1.7207926,-1.8027208,-1.8516969,-1.8848612,-1.7369272,-1.6347294,-1.4845695,-1.3631793,-1.2309241,-1.1137203,-1.0117185,-0.85729939,-0.72174634,-0.63428564,-0.51363723,-0.40547335,-0.29398918,-0.19484037,-0.24216622,-0.24897942,-0.19955086,-0.078916733,0.0025071688,0.070622799,0.18350548,0.26274496,0.37049555,0.46483495,0.51216454,0.48002198,0.46159016,0.56854169,0.68102163,0.71813333,0.83317102,0.89336161,0.98921788,1.0699189,1.0250782,1.0611934,1.1703235,1.2321754,1.3244327,1.432911,1.4291368,1.5204937,1.613229,1.7273706,1.7240226,1.8486172,1.9676688,2.0031911,2.1218077,2.2197063,2.3330623,2.4561237,2.577456,2.681466,2.5626567,2.4364277,2.317081,2.1951776,2.0987725,1.9760886,1.8546047,1.7923489,1.6748301,1.5790001,1.5424741,1.4235051,1.3261403,1.2812146,1.3092488,1.1998931,1.0804125,1.0198607,0.90214229,0.9177595,0.90456057,0.78776183,0.73048947,0.60699208,0.55399682,0.43466401,0.39408934,0.39848517,0.35019252,0.23293047,0.19290775,0.061441955,0.033896848,-0.090230007,-0.18208719,-0.2591002,-0.24136571,-0.19558087,-0.26443762,-0.37174198,-0.48279079,-0.51881075,-0.64979017,-0.77966367,-0.84904451,-0.98667384,-1.0700751,-1.2226857,-1.285725,-1.3863857,-1.5214889,-1.6291347,-1.5371842,-1.47902,-1.3794154,-1.2716834,-1.1812055,-1.0879561,-1.0023049,-0.8734973,-0.83171506,-0.77146493,-0.63960721,-0.52214984,-0.46992,-0.33652939,-0.25894961,-0.12550338,-0.007566722,0.029980834,-0.095099673,-0.19510415,-0.30045933,-0.35138797,-0.4664872,-0.61149669,-0.61105042,-0.71279092,-0.85300892,-0.852272,-0.84635769,-0.9815903,-1.0566474,-1.0988286,-1.2260273,-1.3134158,-1.2509818,-1.24153,-1.1097136,-0.99308368,-0.86896981,-0.77834149,-0.66437648,-0.52861468,-0.45024451,-0.30238912,-0.1728254,-0.06482662,0.019535761,0.12191465,0.25891947,0.34927857,0.46118289,0.59419169,0.6961504,0.83355051,0.95713942,0.97200288,0.87844205,0.76176407,0.6216123,0.6139942,0.47238374,0.51248644,0.39425691,0.32264542,0.27848646,0.33177679,0.22916289,0.22036192,0.12035541,0.14267582,0.16005663,0.12659595,0.044819001,0.015863908,-0.092443034,-0.031157236,0.020915267,-0.053543645,-0.034650315,-0.12770141,-0.13001263,-0.17813779,-0.26395058,-0.21309283,-0.14450905,-0.0080660152,0.014117905,-0.011447044,-0.088380307,-0.077279276,-0.15499633,-0.21775266,-0.26188325,-0.23700738,-0.30818096,-0.35543088,-0.43912981,-0.42794156,-0.39082307,-0.45473991,-0.48281556,-0.51490547,-0.59453637,-0.62598249,-0.68821807,-0.7790947,-0.83564514,-0.88292868,-0.9573867,-1.0269193,-1.1316781,-1.2122156,-1.3280364,-1.4839835,-1.6275369,-1.7604577,-1.8541927,-1.7934885,-1.6721725,-1.5457321,-1.41829,-1.3012339,-1.1766667,-1.0569415,-0.92654746,-0.81058078,-0.68228909,-0.5575429,-0.43218461,-0.31416148,-0.1884905,-0.063577944,0.060859649,0.1287172,0.25194244,0.37328426,0.49736433,0.62975705,0.74550546,0.86788698,0.9948911,1.1219728,1.2494784,1.3753836,1.5204274,1.6524802,1.794086,1.7553287,1.7584465:6
2.5426656,2.5535781,2.5396587,2.4660819,2.4058722,2.3053866,2.202842,2.0989902,1.9995718,1.8999409,1.797699,1.6968384,1.5782365,1.481688,1.3753784,1.3130802,1.2868826,1.2775715,1.2887004,1.2816246,1.2784899,1.2826326,1.2526619,1.2298006,1.2086575,1.1640367,1.1194148,1.0841074,1.0332409,0.98736824,0.95253875,0.89806049,0.85663767,0.81787584,0.78154602,0.73766152,0.68386624,0.6529687,0.60340122,0.54169972,0.46650138,0.40057584,0.31772767,0.23151333,0.16290149,0.087219385,0.0047812609,-0.061597798,-0.14383261,-0.23009725,-0.32088969,-0.39893021,-0.48068882,-0.58984591,-0.69304339,-0.77763492,-0.84031308,-0.89500089,-0.96265439,-0.98693421,-1.0641389,-1.1157926,-1.1240374,-1.1197873,-1.103435,-1.0790291,-1.0580299,-1.0309731,-1.0022102,-0.95967379,-0.91593168,-0.86883066,-0.82673081,-0.78316337,-0.74554944,-0.69097606,-0.64939822,-0.61204457,-0.5770072,-0.54521504,-0.51381451,-0.48293161,-0.44526086,-0.40049586,-0.35158768,-0.29825268,-0.2552582,-0.21190428,-0.17364665,-0.16888202,-0.16333886,-0.16555469,-0.17003223,-0.17356932,-0.16317181,-0.12227666,-0.069763969,-0.024945859,0.030050669,0.052800316,0.078142801,0.076655533,0.033835461,-0.037707224,-0.13355518,-0.23531024,-0.34104477,-0.42431732,-0.5235464,-0.61762481,-0.70917522,-0.79544137,-0.89597375,-0.99212264,-1.0846859,-1.1746523,-1.2695661,-1.3659493,-1.4538882,-1.5472665,-1.5988281,-1.5467222,-1.4786044,-1.3990413,-1.3331876,-1.2634676,-1.1699214,-1.0665004,-0.94953898,-0.84162271,-0.7700597,-0.67533801,-0.55713008,-0.44596988,-0.36314696,-0.27898879,-0.20104199,-0.10368232,-0.022562311,0.047741201,0.12748689,0.19431194,0.26834246,0.33948916,0.40650036,0.46731767,0.53043917,0.60832134,0.67018943,0.73435165,0.80734003,0.87580973,0.8705467,0.84821011,0.82829664,0.81186799,0.799317,0.78931585,0.78234469,0.75873529,0.6756484,0.59622137,0.51940571,0.44302067,0.34429086,0.26102805,0.16969553,0.068549283,-0.0319572,-0.13238606,-0.23142757,-0.33135428,-0.4039015,-0.49904822,-0.59646873,-0.69485651,-0.79233067,-0.89077381,-1.0085388,-1.0817815,-1.0742749,-1.0085201,-0.91737452,-0.84850427,-0.74331579,-0.65368984,-0.56553349,-0.47015245,-0.3722405,-0.29778021,-0.21258684,-0.12334802,-0.051125669,0.04024685,0.12645074,0.20642022,0.30070596,0.38535534,0.48362156,0.55899174,0.6424996,0.72766539,0.80201219,0.87632354,0.95989189,1.0275206,1.1003151,1.1667935,1.2453049,1.3247897,1.3789351,1.4313275,1.4935259,1.5332354,1.5734222,1.6195303,1.6679409,1.6985762,1.7122827,1.6953089,1.6533324,1.5980587,1.5345429,1.4693976,1.3828776,1.2939845,1.2035843,1.1185978,1.0289888,0.94607579,0.85382833,0.75792393,0.67508782,0.58178939,0.49313494,0.40546809,0.31192659,0.22608292,0.14183124,0.054997245,0.011782866,0.049992147,0.10842601,0.1597295,0.23347812,0.3132707,0.39482869,0.45819569,0.52684103,0.59896665,0.67304119,0.74734165,0.80484247,0.87334532,0.92674495,0.97305603,1.0192999,1.0496182,1.0692668,1.0175981,0.96183971,0.90321578,0.83664483,0.77036332,0.68538307,0.6193842,0.53892051,0.47014058,0.39022409,0.30659218,0.22340094,0.14517475,0.059692236,-0.024295589,-0.11586603,-0.20676953,-0.31166684,-0.41703967,-0.52219756,-0.63102688,-0.75511334,-0.86325293,-0.96810404,-1.0726324,-1.2041956,-1.3105569,-1.4399716,-1.5442144,-1.6399601,-1.7021511,-1.6782872,-1.5956908,-1.5097279,-1.4171753,-1.3340077,-1.2541572,-1.1742338,-1.0829566,-0.99306666,-0.90701803,-0.82387604,-0.73434285,-0.64519827,-0.56855432,-0.47398298,-0.38354286,-0.29665676,-0.22174913,-0.14714724,-0.073996163,-0.025710003,0.0050789297,-0.037358974,-0.076562271,-0.12301086,-0.17366623,-0.23840531,-0.31036117,-0.39981878,-0.47692319,-0.54496418,-0.61463025,-0.6640529,-0.77262663,-0.85250704,-0.91855259,-0.98453162,-1.0644405,-1.1271257,-1.2251635,-1.3279911,-1.4179634,-1.5081386,-1.5999671,-1.7012815,-1.7480366,-1.7996172,-1.8449029,-1.9045099,-1.9302193,-1.8742028,-1.7917953,-1.6965223,-1.6108192,-1.5132084,-1.4221232,-1.3270821,-1.2455041,-1.1490988,-1.0597343,-0.95495399,-0.85416058,-0.8190784,-0.79300013,-0.78883816,-0.78017045,-0.78122393,-0.78617864,-0.78863473,-0.78956213,-0.7845169,-0.81475274,-0.82391721,-0.8392502,-0.87181435,-0.86139251,-0.835158,-0.82235246,-0.81397552,-0.79447518,-0.80211655,-0.82142342,-0.83909193,-0.86546214,-0.8911192,-0.9180158,-0.93767356,-0.96159932,-0.95857452,-0.86643243,-0.81627465,-0.72469194,-0.6495257,-0.58907014,-0.54487397,-0.41247625,-0.33833043,-0.28862633,-0.1939599,-0.1300041,-0.071215787,-0.01684244,0.031464012,0.081431593,0.13165127,0.18259422,0.22604358,0.27418995,0.33566837,0.39931438,0.47579075,0.5046592,0.58595658,0.65314788,0.71634039,0.76370887,0.83977509,0.92191355,0.99261744,1.0672722,1.1383928,1.1710153,1.2371508,1.3161708,1.3929468,1.5005378,1.6160915,1.5687564,1.6639912,1.765957,1.8667674,1.9913053,2.0859668,2.1996921,2.3073607,2.4126542,2.4905605:2
1.8202648,1.7089177,1.5687842,1.4428082,1.3798592,1.2546088,1.130269,0.97153821,0.91269461,0.77136679,0.64672369,0.57920356,0.41276133,0.29205224,0.19588884,0.16729713,0.057439132,-0.034555841,-0.1979298,-0.3319709,-0.41924409,-0.59394577,-0.72050939,-0.64336262,-0.55030259,-0.41918703,-0.33459842,-0.2446927,-0.11373782,-0.012749041,0.10250915,0.18355779,0.14134959,0.26455633,0.39959639,0.49640489,0.61951514,0.75658894,0.7756387,0.82902146,0.94891805,1.0657803,1.2008688,1.3242569,1.4356246,1.4596124,1.3050653,1.1643972,1.0224788,0.8868922,0.8144935,0.66886547,0.55327355,0.43043399,0.35679968,0.30239603,0.16978936,0.068140851,-0.06627379,-0.19291873,-0.3118677,-0.40652015,-0.46990849,-0.58004705,-0.69382012,-0.80802039,-0.94210748,-1.0662206,-1.1792477,-1.3083812,-1.4069822,-1.2828962,-1.152324,-1.0034706,-0.84442731,-0.67038326,-0.51167902,-0.41215283,-0.23982613,-0.084249715,0.001898979,0.069736381,0.1941033,0.37464352,0.50842059,0.5295966,0.65317177,0.79262446,0.90189216,1.0164827,1.1849,1.293438,1.2346924,1.1111063,1.0154768,0.88185132,0.77679116,0.65791247,0.58276751,0.46116846,0.35858426,0.34555269,0.2993488,0.18626661,0.085254824,0.0048755435,-0.12683906,-0.24169937,-0.18665245,-0.25122297,-0.33463989,-0.44860008,-0.56510836,-0.6255726,-0.68911459,-0.77507889,-0.87931768,-0.9853671,-1.0456227,-1.1884677,-1.2820468,-1.2816039,-1.2695396,-1.2172148,-1.0921769,-0.97028295,-0.83693117,-0.71485655,-0.58832345,-0.4512256,-0.33110403,-0.22035698,-0.099997265,0.033674849,0.1360063,0.28001563,0.41845081,0.52632104,0.67345018,0.78214029,0.78543627,0.64296237,0.54638417,0.44916259,0.2839919,0.25213806,0.20213236,0.068620311,-0.076367845,-0.062056698,-0.12005099,-0.22191037,-0.31694893,-0.35299154,-0.45154058,-0.54364511,-0.53289933,-0.43587275,-0.48387706,-0.54524147,-0.63372017,-0.73833941,-0.78074617,-0.86872805,-0.92914486,-1.0468633,-0.93288048,-0.79356936,-0.62450834,-0.51188679,-0.47650174,-0.34461447,-0.22303087,-0.077838371,0.0020086503,-0.014849944,-0.12190689,-0.17031027,-0.24402947,-0.32055996,-0.39533913,-0.4733538,-0.54789014,-0.53873166,-0.6312259,-0.69869736,-0.78152496,-0.8637834,-0.96573108,-0.94716699,-0.88362859,-0.94081617,-0.98913402,-1.0451136,-1.1105561,-1.1528014,-1.198164,-1.2553449,-1.3388956,-1.3924488,-1.4268262,-1.2731429,-1.1787209,-1.0467598,-1.0336119,-1.0966067,-1.1865584,-1.2697866,-1.323328,-1.4076358,-1.510678,-1.6077699,-1.6175209,-1.4481945,-1.294413,-1.1377392,-1.0157555,-0.83755127,-0.70108341,-0.52517932,-0.39460469,-0.25171688,-0.075620642,0.099914241,0.19217678,0.37240298,0.50468404,0.6450367,0.80769275,0.96196588,1.0965056,1.2617096,1.3882811,1.5187373,1.6481327,1.7546982,1.871023,1.9805593,2.0797135,2.2012938,2.3040703,2.4017282,2.4535995,2.49209,2.4461735,2.4635357,2.4392199,2.4582254,2.4392814,2.3832771,2.26864,2.2643893,2.2927387,2.246425,2.1869031,2.1338191,2.0151812,1.9036482,1.8134208,1.6696855,1.5449075,1.5073903,1.4048331,1.2709113,1.169129,1.0290211,0.88911538,0.75210888,0.61664533,0.45485066,0.30210877,0.16719818,0.031604525,-0.14283324,-0.2733944,-0.41346642,-0.58251347,-0.70946294,-0.88581246,-1.0203037,-1.1490725,-1.3181952,-1.4517603,-1.5807997,-1.7439284,-1.8732594,-2.0325411,-2.1537075,-2.2845197,-2.156219,-2.0114185,-1.8875472,-1.8036104,-1.6957963,-1.5762122,-1.498795,-1.3824781,-1.3165207,-1.3223259,-1.2630911,-1.1966575,-1.1644584,-1.2698806,-1.3874453,-1.3284688,-1.2699771,-1.2020224,-1.0937231,-1.0484469,-0.96991025,-0.90187875,-0.86169805,-0.72148953,-0.6463157,-0.54707186,-0.47201324,-0.39169519,-0.33171281,-0.28552901,-0.23278149,-0.14195227,-0.07575195,-0.020205661,0.042100213,-0.002298693,0.0099206069,0.074977751,0.13047229,0.21032473,0.27762335,0.2617341,0.0787289,-0.071863945,-0.14770612,-0.25046572,-0.19462164,-0.31889154,-0.49310778,-0.61947487,-0.74467169,-0.84769978,-0.9020569,-0.81059882,-0.729442,-0.64419001,-0.55421999,-0.48063422,-0.42139854,-0.39130838,-0.29434358,-0.21024427,-0.15361006,-0.17628833,-0.069819027,0.0042167128,0.081229538,0.17338879,0.2033585,0.34159129,0.46121975,0.53427381,0.42013162,0.52703839,0.65395017,0.78209314,0.81551339,0.89339653,0.97738201,1.078839,1.1524916,1.234149,1.3371479,1.3074826,1.1658366,1.0430142,0.90088751,0.76631366,0.69933511,0.59510118,0.47863932,0.34351197,0.20938459,0.072981084,0.041450803,-0.050937125,-0.19241233,-0.31828935,-0.4416352,-0.511999,-0.62123582,-0.76307258,-0.78986383,-0.94094725,-1.0608988,-1.0824913,-0.99144175,-0.83792722,-0.73831073,-0.63713181,-0.55178907,-0.45538215,-0.33963765,-0.23236571,-0.1305082,-0.031643729,0.053363215,-0.029512467,0.071109407,0.18965484,0.29862639,0.37095268,0.47539483,0.59288466,0.68937194,0.60638158,0.72643146,0.84995977,0.96390892,1.0986898,1.1146336,1.1299161,1.2573654,1.3632585,1.4844889,1.5926954,1.7198804,1.8317584:1
1.2511575,1.1729189,1.0656579,0.95060561,0.83180117,0.75262098,0.63306321,0.52248633,0.4109652,0.28456151,0.17200487,0.048506843,-0.069461308,-0.19957708,-0.31673165,-0.44108493,-0.54441631,-0.64839615,-0.70171943,-0.68177721,-0.58357457,-0.52910265,-0.5557779,-0.59192901,-0.52217903,-0.41565881,-0.36020341,-0.36159878,-0.38378108,-0.38430752,-0.31393962,-0.22922217,-0.33400322,-0.43436966,-0.54858224,-0.62238944,-0.73602545,-0.84264641,-0.94999003,-1.0485956,-1.1488589,-1.1626358,-1.1051347,-1.0013421,-0.94314158,-0.89243532,-0.76712674,-0.69303143,-0.59305913,-0.56040835,-0.44485112,-0.36483056,-0.26229786,-0.16288216,-0.087062939,0.020557001,0.10944045,0.21666408,0.32395437,0.40565299,0.52500516,0.58806963,0.65557767,0.75420988,0.86537618,0.93571825,1.0571973,1.087662,1.1783779,1.2825719,1.3497863,1.4555258,1.5696151,1.6745386,1.8039918,1.9084582,1.9983243,1.9139739,1.832067,1.7248956,1.6394185,1.5389364,1.4827448,1.3833345,1.2918466,1.2745959,1.2110396,1.1255113,1.0658641,1.0468358,0.99132056,0.92228108,0.81536955,0.74762506,0.69464989,0.71080945,0.70959456,0.65934779,0.55897619,0.53322022,0.40639175,0.34990716,0.25390664,0.29060681,0.32684479,0.25667073,0.15782544,0.11575728,0.0016738074,-0.058664346,-0.17197095,-0.23905691,-0.22465554,-0.26239382,-0.35093778,-0.40334548,-0.50796351,-0.54588915,-0.64602524,-0.70058416,-0.79076435,-0.82371869,-0.91988543,-1.0160635,-1.0917371,-1.1839312,-1.2549583,-1.3397587,-1.3646808,-1.4681665,-1.3861047,-1.2666273,-1.145323,-1.0173776,-0.89600072,-0.77217026,-0.65219164,-0.53323713,-0.4247767,-0.31232277,-0.20142685,-0.090759983,0.014297883,0.10873221,0.22331063,0.33965523,0.45009758,0.52045736,0.47964543,0.44165343,0.41733809,0.41736449,0.44912551,0.48891026,0.52363564,0.58582014,0.69622268,0.72403452,0.78801059,0.89648369,0.96919744,0.99236319,1.009412,0.9946445,0.94094306,0.88389829,0.87896636,0.93173021,0.987123,0.94244627,0.91716981,0.87678437,0.81659454,0.80947653,0.82477684,0.80698683,0.79561971,0.78294497,0.77327255,0.75762562,0.74511003,0.77977445,0.69437047,0.65370454,0.55570663,0.44647518,0.33261263,0.21300187,0.10357623,-0.016153672,-0.12400019,-0.21282146,-0.32398491,-0.44491149,-0.55190124,-0.6673737,-0.79208896,-0.91539298,-1.0360693,-1.1563757,-1.2255697,-1.3146259,-1.3452794,-1.4455112,-1.5677984,-1.6872243,-1.7107475,-1.617881,-1.5191933,-1.4288611,-1.397989,-1.2976571,-1.1918059,-1.1422634,-1.0514427,-0.97321716,-0.88056071,-0.79716247,-0.76429286,-0.67658515,-0.62692177,-0.55976232,-0.59199069,-0.51630352,-0.45006475,-0.36659831,-0.28413019,-0.29618354,-0.20856738,-0.12988288,-0.11029856,-0.03909528,0.0255338,0.08752972,0.093365898,0.016321811,-0.041610714,-0.06682425,-0.0080589663,0.10244526,0.10895868,0.21349457,0.28309819,0.34850133,0.42814443,0.37876812,0.32122007,0.42895935,0.51212322,0.55952447,0.67267767,0.73395752,0.79017154,0.71569839,0.73781372,0.79943396,0.9170586,0.98775494,0.91487464,0.99924248,1.0823431,1.2029355,1.1992241,1.3045849,1.3729033,1.4480092,1.5191106,1.6067784,1.5494863,1.4411816,1.3179304,1.2479065,1.1326406,1.0612139,0.96052404,0.87283426,0.82285878,0.70436025,0.6206312,0.528576,0.46172539,0.35095633,0.34208026,0.23447393,0.14318746,0.060673097,-0.054047944,-0.20416502,-0.24744517,-0.26882929,-0.41750058,-0.50939041,-0.62839171,-0.69790293,-0.78529177,-0.90610211,-0.97902613,-1.0773768,-1.1684367,-1.2561995,-1.3300272,-1.442577,-1.5210782,-1.6312507,-1.7126403,-1.8094721,-1.9041036,-2.0075373,-2.1187819,-2.1752995,-2.2627756,-2.358746,-2.4651945,-2.5672236,-2.6788764,-2.7765004,-2.8338725,-2.7377006,-2.6460863,-2.5220777,-2.4016168,-2.3084178,-2.2036558,-2.0966388,-2.0747204,-2.08376,-2.038522,-2.0094329,-1.9389021,-1.8497072,-1.7682286,-1.6908262,-1.6088282,-1.4815084,-1.4025238,-1.299833,-1.1885922,-1.0758827,-0.99098941,-0.88723967,-0.77158125,-0.66646872,-0.54634096,-0.43616254,-0.33335326,-0.26392764,-0.21749042,-0.1062929,0.0025507656,0.073944552,0.185475,0.25694649,0.3589144,0.36544229,0.40706093,0.51265168,0.59032085,0.67586665,0.77179791,0.73910128,0.83781956,0.9131109,1.0231365,1.0281953,1.1145746,1.2178279,1.2828696,1.38849,1.4949078,1.4334106,1.3287625,1.2725936,1.169091,1.1394343,1.0391266,0.96667816,0.88026321,0.81540548,0.72199422,0.6477309,0.57772326,0.56383523,0.473548,0.42236035,0.32530669,0.27681681,0.20541126,0.30935953,0.41377063,0.48414602,0.59037028,0.6707575,0.76600288,0.86103505,0.91246498,0.84766199,0.75673999,0.67042365,0.58214057,0.5019162,0.44608019,0.37164146,0.27184242,0.17312177,0.084612245,0.010392887,-0.021502813,-0.003390869,0.032341089,0.09297596,0.10989315,0.1695909,0.24033398,0.3067386,0.35692977,0.34213776,0.3230352,0.38121877,0.48827475,0.60235775,0.69569913,0.7978207,0.86733009,0.90321885,0.98411225,1.0850772,1.1974732:6
-0.25640791,-0.27279364,-0.31175443,-0.33982354,-0.40136241,-0.47673784,-0.55288656,-0.66102949,-0.75509833,-0.85022693,-0.93281066,-1.0143069,-1.117941,-1.2034236,-1.289339,-1.3535466,-1.4138821,-1.4763401,-1.5575002,-1.6636329,-1.7429871,-1.8220169,-1.8903004,-1.8419999,-1.7873782,-1.7316651,-1.6600597,-1.6644539,-1.7003419,-1.6452341,-1.5963953,-1.5324492,-1.4740962,-1.4185359,-1.3558271,-1.3035641,-1.2238053,-1.1670824,-1.1075167,-1.045714,-0.98591811,-0.93415676,-0.87146981,-0.80695106,-0.74223839,-0.6778081,-0.61626413,-0.53959816,-0.4696909,-0.40961973,-0.36738475,-0.29323821,-0.25418466,-0.25045925,-0.26938065,-0.28099804,-0.2636131,-0.18241159,-0.10011945,-0.021180916,0.066810615,0.14951498,0.20154827,0.27464549,0.31330549,0.37365157,0.41481167,0.45758076,0.49234739,0.48912237,0.45301228,0.3975853,0.34902913,0.28531896,0.23643928,0.17808915,0.10987903,0.051500661,-0.012035528,-0.080674622,-0.03482692,0.065471232,0.15592875,0.23876624,0.34319138,0.44684702,0.55562082,0.65989929,0.76171211,0.83029744,0.87500094,0.94519324,1.007328,1.0664254,1.111297,1.160951,1.2233262,1.2676498,1.3254761,1.3713284,1.413939,1.4534178,1.490974,1.5108849,1.5094187,1.4972274,1.4591718,1.4134771,1.3707122,1.3061319,1.2522195,1.2010141,1.1278633,1.0715786,0.98293735,0.92056197,0.81922998,0.72082703,0.63280121,0.52437506,0.44789792,0.40608059,0.44207973,0.49940109,0.57322914,0.63408674,0.71599086,0.79349242,0.8735908,0.93969411,1.0221059,1.0836933,1.1576487,1.2256928,1.2896186,1.3437485,1.393826,1.4422377,1.4390816,1.413952,1.3823746,1.3288867,1.295839,1.2368117,1.1744847,1.1120755,1.0477585,0.98032115,0.94394926,0.84672132,0.77664728,0.68964812,0.63066376,0.57292052,0.53044626,0.45996897,0.37627659,0.28289928,0.18689075,0.0932534,-0.0056438005,-0.079221306,-0.17085486,-0.24458127,-0.30540542,-0.38853297,-0.47616498,-0.5547932,-0.61541764,-0.68315971,-0.76987024,-0.84987308,-0.91993422,-1.0025909,-1.0801849,-1.1532432,-1.2336822,-1.3117063,-1.3870077,-1.4619138,-1.5461735,-1.6252903,-1.7076386,-1.7692912,-1.832402,-1.8081167,-1.729466,-1.6440175,-1.5621498,-1.4805028,-1.406534,-1.3241459,-1.2517986,-1.1702949,-1.0927753,-1.0102414,-0.93965625,-0.85415179,-0.7802746,-0.69774443,-0.61404841,-0.54449917,-0.4614742,-0.37585739,-0.29536445,-0.19459609,-0.099063212,-0.0083538312,0.058590847,0.097125535,0.10810557,0.11973201,0.10534057,0.090033096,0.067763605,0.036352611,-0.0065830927,-0.051198727,-0.10102471,-0.13491446,-0.18767274,-0.23731309,-0.26565632,-0.21946142,-0.19500379,-0.16390304,-0.18601608,-0.23600528,-0.27742707,-0.31597311,-0.37344895,-0.43597873,-0.48519105,-0.53201156,-0.58341492,-0.63082791,-0.6808081,-0.73334319,-0.77788605,-0.82461644,-0.86697314,-0.90380256,-0.93842818,-0.96095817,-0.99941558,-1.0377314,-1.087775,-1.1285802,-1.1760936,-1.197858,-1.2146646,-1.2482894,-1.2725757,-1.2870852,-1.3007396,-1.313605,-1.3202019,-1.3262025,-1.328416,-1.3279902,-1.3274309,-1.3298543,-1.3413167,-1.3299655,-1.3290992,-1.3256723,-1.3208241,-1.3054169,-1.2796864,-1.2346179,-1.2162334,-1.1541717,-1.0876776,-1.0275671,-0.95933223,-0.88938826,-0.83134252,-0.76064436,-0.68299594,-0.61337845,-0.54424937,-0.46364263,-0.39218997,-0.30552117,-0.22553704,-0.14543729,-0.07788111,-0.0099941333,0.032820164,0.074510677,0.12020477,0.14609182,0.16592992,0.19027665,0.1989193,0.21056888,0.21085623,0.21440673,0.2289434,0.3039215,0.40669179,0.50503293,0.57342583,0.63983681,0.70538139,0.76444413,0.80828217,0.86973896,0.93048463,0.98576423,1.0454996,1.1062027,1.1518928,1.2011544,1.2477139,1.2933998,1.3292287,1.3680412,1.3902326,1.4093626,1.4195904,1.433031,1.4532072,1.4701001,1.5264902,1.6067288,1.7163632,1.8153739,1.9047509,1.9836444,2.0676353,2.14662,2.251672,2.3079087,2.336836,2.3316292,2.2637174,2.206796,2.108384,2.0235821,1.9209534,1.8374115,1.732126,1.6227037,1.5450284,1.4675253,1.4091029,1.3717809,1.3367004,1.3035706,1.2603705,1.227181,1.1969621,1.1695945,1.1254338,1.0845154,1.0470009,1.0091178,0.97462671,0.94037667,0.9059516,0.87240546,0.8321182,0.79538098,0.74745697,0.72782088,0.71748883,0.69401451,0.67065848,0.64628373,0.61323165,0.58019118,0.54139631,0.49927226,0.4732967,0.43106411,0.37593654,0.33099219,0.29623738,0.22978142,0.17454535,0.094025447,0.010032713,-0.078327404,-0.16197712,-0.24867646,-0.31834141,-0.40265395,-0.47047527,-0.54715717,-0.61547581,-0.6885271,-0.71094775,-0.76209196,-0.74941157,-0.73445385,-0.69669206,-0.66131291,-0.64379153,-0.6106999,-0.59751546,-0.58426423,-0.56128954,-0.54889515,-0.5210065,-0.49191031,-0.46914146,-0.45751042,-0.43950344,-0.42126563,-0.42731095,-0.43025073,-0.43618214,-0.43141121,-0.4220365,-0.40803207,-0.39170905,-0.37737753,-0.36375344,-0.34693797,-0.33343554,-0.31851292,-0.30001897,-0.27631726,-0.25793571,-0.25496635,-0.24884991:2
2.7265353,2.6214932,2.5132416,2.3874093,2.2779247,2.1799504,2.0694626,1.9565805,1.8490871,1.7376138,1.6262598,1.5120426,1.4034814,1.2898655,1.181527,1.0762228,0.95577024,0.84885859,0.7351324,0.6214356,0.52151706,0.39740756,0.29636106,0.18955619,0.069761511,-0.047986632,-0.1638211,-0.27737345,-0.40156375,-0.51080561,-0.64131789,-0.74109595,-0.81746265,-0.93913675,-1.061291,-1.1768934,-1.3092331,-1.4364386,-1.538947,-1.649176,-1.7215066,-1.7688479,-1.7311034,-1.707902,-1.7286472,-1.7075717,-1.649591,-1.5928533,-1.548,-1.4507095,-1.4111382,-1.2902782,-1.1772275,-1.0687388,-1.0146368,-0.93318837,-0.88251935,-0.81063985,-0.72845468,-0.70869942,-0.77548312,-0.77320402,-0.68292818,-0.61417574,-0.54838516,-0.48426634,-0.42781054,-0.33787057,-0.25978637,-0.19083647,-0.25011288,-0.29705104,-0.22982413,-0.16939063,-0.11780676,-0.078848908,-0.13118411,-0.092512645,-0.061982342,-0.041796221,-0.17708174,-0.33944481,-0.50161532,-0.63066619,-0.75207374,-0.8103919,-0.77026881,-0.70314031,-0.62998491,-0.56056742,-0.47249327,-0.40933474,-0.33179789,-0.2588456,-0.29623945,-0.24063524,-0.19211135,-0.097520535,-0.0062269539,0.067258453,0.038532026,0.11328545,0.15267212,0.21757632,0.25426037,0.16103337,0.026214486,0.024674333,0.12020602,0.21629434,0.3252477,0.37122135,0.3808956,0.48747609,0.59143371,0.64955478,0.67171658,0.78299926,0.896998,1.0123575,1.0855295,1.1517017,1.2686863,1.3349219,1.4282941,1.5420464,1.566461,1.4750205,1.3629389,1.2459984,1.124161,1.0135518,0.89042816,0.78713415,0.66832743,0.55560013,0.44047079,0.32240607,0.21625672,0.10681115,-0.02950581,-0.022613102,-0.035390406,-0.13861956,-0.24566703,-0.37143665,-0.46875725,-0.55385543,-0.6691628,-0.77809132,-0.88722575,-1.0012638,-1.1140439,-1.2341028,-1.3428724,-1.4477308,-1.505909,-1.5733453,-1.5710868,-1.4831268,-1.4054393,-1.2909562,-1.153424,-1.0393976,-0.94878938,-0.82507447,-0.67830608,-0.6001438,-0.5807887,-0.66349547,-0.55503988,-0.43683444,-0.27895307,-0.11851089,8.5446213E-4,0.082528404,0.024657292,0.085400751,0.18684758,0.27094189,0.27910633,0.35833328,0.42244788,0.36187836,0.23650456,0.16501695,0.096472282,0.062472923,0.16818165,0.26463267,0.37877368,0.48189573,0.5579814,0.5119288,0.49239869,0.5616375,0.67027692,0.7339119,0.839348,0.93133648,0.95349801,1.0785605,1.1529498,1.2795992,1.3907345,1.5457373,1.6856923,1.7684433,1.7359823,1.6786804,1.5816858,1.4727497,1.4194301,1.2943119,1.2056223,1.1467026,0.99557876,0.86656892,0.73061924,0.74302517,0.68265408,0.56850296,0.42732571,0.32583842,0.20102737,0.07932314,-0.059075883,-0.10231223,-0.0088465166,0.077474416,0.1862781,0.2429194,0.13922921,0.0077716352,-0.018057826,-0.068286263,-0.19584597,-0.27535024,-0.21739677,-0.1859235,-0.25313209,-0.36665946,-0.48537318,-0.59567398,-0.70434616,-0.81246678,-0.82695013,-0.76484071,-0.78032578,-0.8825765,-0.98357688,-1.079332,-1.1830389,-1.2736244,-1.3698765,-1.4706099,-1.5655219,-1.6469452,-1.7348557,-1.6870823,-1.5280725,-1.3949654,-1.2597524,-1.1560577,-0.99649378,-0.83680496,-0.70354665,-0.61145742,-0.49862125,-0.36487669,-0.23273797,-0.10711921,-0.013692766,0.0096062025,0.098175044,0.21878412,0.32929737,0.47705092,0.6226982,0.78034927,0.88699264,0.92222121,1.0571581,1.1639826,1.2758685,1.4013402,1.5311636,1.6273906,1.6046116,1.5087748,1.412497,1.3298177,1.29328,1.1767087,1.070203,1.058569,0.98035687,0.88644324,0.78857222,0.74023459,0.62669105,0.57348222,0.6496953,0.62226377,0.52539909,0.40516238,0.31531689,0.23062189,0.2358165,0.16449481,0.078414156,-0.034743921,-0.14168537,-0.064612151,0.043822209,0.14199663,0.11918926,0.062917589,0.01963549,-0.021097851,-0.05281564,-0.14792593,-0.23377608,-0.33714032,-0.29134017,-0.18696444,-0.18066904,-0.23958222,-0.31167115,-0.40339516,-0.48153787,-0.57568672,-0.6935603,-0.74713753,-0.80637321,-0.7161657,-0.61260011,-0.49977796,-0.38124208,-0.27132691,-0.14976833,-0.038721259,0.080805077,0.19406948,0.31143672,0.42537198,0.45781048,0.35135346,0.31388878,0.22824453,0.12789484,0.17425595,0.10654236,-0.0031141684,-0.11552825,-0.20861005,-0.30936549,-0.34405495,-0.23916961,-0.28338283,-0.36887481,-0.45428649,-0.55852965,-0.65513967,-0.7335216,-0.82931586,-0.88467507,-0.92378364,-0.95170719,-1.0027596,-1.0674344,-1.1570025,-1.2320842,-1.3150723,-1.4120487,-1.4889444,-1.5612245,-1.6360312,-1.696828,-1.7589821,-1.7882977,-1.7650222,-1.7634669,-1.7828633,-1.7956631,-1.844982,-1.784559,-1.6594114,-1.5364183,-1.4041721,-1.2951862,-1.1714664,-1.0462933,-0.93171238,-0.81293085,-0.70010518,-0.57878962,-0.4616361,-0.34760217,-0.23391394,-0.12097851,-0.011877106,0.099559134,0.20167239,0.32120057,0.44085717,0.53695147,0.6507895,0.76026405,0.86607468,0.97788307,1.0840044,1.1935409,1.3011808,1.4135531,1.5175865,1.626409,1.7330223,1.8427249,1.9538581,2.0559325,2.1646726,2.2800744,2.3873158,2.4884313,2.5928525,2.6791055:3
0.53642509,0.44844206,0.35910641,0.25080612,0.11661365,-0.035840695,-0.19258386,-0.32363408,-0.46106849,-0.56964798,-0.63536378,-0.69954457,-0.79391897,-0.80855903,-0.77112327,-0.73641621,-0.65562252,-0.57094245,-0.48772752,-0.40188017,-0.3046132,-0.21777679,-0.11424179,-0.0027599334,0.091832394,0.16581024,0.2135678,0.24668604,0.29406778,0.33207261,0.43613326,0.51885648,0.56826523,0.61084541,0.66276972,0.64911281,0.60221773,0.60224921,0.58548033,0.61788848,0.70801029,0.75127507,0.84971421,0.92672485,0.9998473,1.0466188,1.1166432,1.1645497,1.1904013,1.2498929,1.3207315,1.3605674,1.4167682,1.4800807,1.5421718,1.6134443,1.6808034,1.7238584,1.6735249,1.5983393,1.4632839,1.3572855,1.2727033,1.1789061,1.0383717,0.92251557,0.78254585,0.63823505,0.50472412,0.36349333,0.25097865,0.16614338,0.11080369,0.032339186,-0.053614032,-0.16475861,-0.2680858,-0.38087503,-0.51756557,-0.65023613,-0.78675239,-0.93198484,-0.93278472,-1.059418,-1.2059664,-1.2834227,-1.4143078,-1.375903,-1.389727,-1.3927623,-1.3370578,-1.2872278,-1.2416569,-1.1623695,-1.046646,-1.0683356,-0.98535391,-0.9066669,-0.8406408,-0.74174132,-0.64820948,-0.58655043,-0.5344636,-0.45061568,-0.31874611,-0.22622287,-0.13123653,-0.036925654,0.055350352,0.14812073,0.23496448,0.31829773,0.39985478,0.46382564,0.5171503,0.55614041,0.55498191,0.53066816,0.56870332,0.5772227,0.6527559,0.74537335,0.8243811,0.87358019,0.91821925,1.0257079,1.123753,1.2030595,1.298779,1.3782311,1.4642973,1.5693721,1.6211351,1.6726505,1.7744958,1.8321047,1.8978669,1.8733525,1.7634693,1.6429037,1.5401542,1.4217272,1.3811025,1.3397163,1.2498472,1.172968,1.0840997,1.0191483,1.0021933,0.93886912,0.84674571,0.73949989,0.67072725,0.59148098,0.57365692,0.4690746,0.41748184,0.32783205,0.22269453,0.20646244,0.10711991,-0.0038250897,-0.052789978,-0.098713999,-0.15701255,-0.1346708,-0.14796266,-0.13482768,-0.18937454,-0.22201292,-0.30768403,-0.41486653,-0.53303022,-0.6380552,-0.73256455,-0.78675239,-0.90954175,-0.95198887,-1.0580664,-1.1532904,-1.2542165,-1.396157,-1.5346041,-1.652303,-1.6876655,-1.7444594,-1.8557312,-1.9397471,-1.949081,-2.0247338,-2.0493197,-2.1997049,-2.1225325,-2.0694304,-1.988246,-1.8736582,-1.7362458,-1.5719701,-1.4416062,-1.3252512,-1.2137467,-1.1264599,-1.0128798,-0.89961135,-0.82426139,-0.73927556,-0.63875337,-0.62199706,-0.54613489,-0.45524045,-0.34856937,-0.31533498,-0.19455572,-0.078477778,0.048817808,0.18660546,0.32623067,0.40480907,0.51198616,0.61561555,0.69023961,0.75592045,0.81441546,0.8386152,0.89893822,0.92092664,0.93233959,0.92805377,0.85993578,0.85969488,0.81232303,0.81438172,0.73114918,0.6853396,0.65770419,0.57079208,0.50222349,0.46450395,0.39843478,0.33617971,0.27080307,0.17312845,0.11038686,-1.538146E-5,-0.069403661,-0.059954553,-0.030252434,-0.024001763,0.010970717,0.048146364,0.020077776,-0.078580504,-0.15711112,-0.25536453,-0.35189699,-0.45464391,-0.55712311,-0.64795345,-0.7166891,-0.80760555,-0.89084379,-0.98295881,-1.05858,-1.1248117,-1.1103507,-1.0349344,-0.96622943,-0.8625215,-0.7235694,-0.60077578,-0.50174253,-0.36049282,-0.29129215,-0.20931954,-0.07780948,0.065626942,0.17362782,0.22285051,0.17360496,0.10697796,0.045648222,-0.02552755,-0.054471416,-0.10077209,-0.1885227,-0.25701665,-0.33240325,-0.39545317,-0.44028273,-0.41764817,-0.41963915,-0.47523024,-0.53721594,-0.6059212,-0.67579035,-0.73266574,-0.76547297,-0.83095836,-0.86959204,-0.90010488,-0.88651433,-0.95386829,-1.0513873,-1.1157627,-1.1798703,-1.2402631,-1.268664,-1.2698527,-1.2598334,-1.1645551,-1.1573419,-1.1399344,-1.0284266,-0.94442045,-0.90865298,-0.78651095,-0.66307191,-0.56013525,-0.49822932,-0.45816467,-0.34166385,-0.23043102,-0.11150179,0.016555345,0.12943435,0.25366385,0.32691405,0.39278644,0.50345248,0.62537394,0.74166896,0.86960744,0.99284334,1.0854102,1.0753203,1.1792217,1.1884441,1.2770938,1.2873506,1.362987,1.4658287,1.5844874,1.6978757,1.7636131,1.8777719,1.9812842,2.0957864,2.1993972,2.296892,2.3859804,2.4017561,2.325518,2.2799082,2.165966,2.1075786,1.9939713,1.872199,1.7673752,1.6534469,1.5369179,1.4209575,1.2948095,1.1645846,1.0605298,0.92784317,0.81426747,0.68783508,0.61615349,0.48228538,0.4015893,0.29049579,0.21090414,0.081634294,-0.027911437,-0.13838311,-0.26569974,-0.37421539,-0.50319846,-0.60890837,-0.72629155,-0.8512183,-0.96359665,-1.0806161,-1.1590223,-1.2246097,-1.2523595,-1.3074027,-1.4309032,-1.5453749,-1.6527367,-1.6619112,-1.7357591,-1.7669821,-1.7493731,-1.665121,-1.5409132,-1.3972829,-1.2926816,-1.1848386,-1.1163083,-1.1209393,-1.1304345,-1.1242678,-1.0580403,-0.96963908,-0.94917246,-0.86054608,-0.78939553,-0.7242847,-0.65176259,-0.5785713,-0.5261375,-0.45504688,-0.39974837,-0.3542092,-0.32103439,-0.23574028,-0.15125705,-0.067839018,0.025994761,0.091569846,0.15365556,0.22762184,0.29789664,0.37159237,0.44883443,0.51366843:5
1.4889331,1.4855481,1.4693368,1.4260285,1.3400141,1.2545691,1.1929211,1.1180174,1.0894233,1.1145881,1.1708889,1.2068055,1.2345147,1.25797,1.2898889,1.2859404,1.2808973,1.2835815,1.2594637,1.2532259,1.2174054,1.1948716,1.1566066,1.1278278,1.0903424,1.0499212,0.99471969,0.95033162,0.90949594,0.85001338,0.78993394,0.75266449,0.69939109,0.6488254,0.59184149,0.52116706,0.44530055,0.39177619,0.36271774,0.326801,0.30488319,0.2803194,0.27739183,0.29285789,0.31537542,0.3438884,0.35419253,0.35885043,0.34761459,0.31481449,0.29324741,0.24402418,0.2034622,0.14518062,0.093776095,0.034100775,-0.023390637,-0.10516398,-0.17493083,-0.24039042,-0.3271788,-0.40789132,-0.46870341,-0.51990197,-0.59386238,-0.6555901,-0.72574517,-0.78683866,-0.85008212,-0.90968325,-0.96550638,-1.0296395,-1.0788127,-1.1358367,-1.1930312,-1.2463868,-1.3006483,-1.3582649,-1.4163872,-1.4744675,-1.5153498,-1.5638598,-1.6061921,-1.648371,-1.6912661,-1.7339325,-1.7723137,-1.8100046,-1.8562294,-1.8894932,-1.9171991,-1.8998586,-1.8432563,-1.7990062,-1.7561686,-1.7062642,-1.6515918,-1.605684,-1.5619391,-1.5224153,-1.4667453,-1.4378855,-1.3797042,-1.325563,-1.2816484,-1.222794,-1.1843362,-1.1177887,-1.0620904,-1.0096506,-0.94988467,-0.884247,-0.82234689,-0.77940744,-0.71451218,-0.64671576,-0.57686154,-0.51039867,-0.44667905,-0.38140917,-0.34576262,-0.29391995,-0.24684933,-0.2140241,-0.15691586,-0.11077242,-0.040396801,0.0111317,0.079578234,0.15601037,0.23928892,0.30081978,0.38667679,0.44674436,0.53899233,0.59897475,0.68449667,0.76691017,0.84809865,0.91342294,0.97424601,1.0209476,1.0846256,1.131844,1.155685,1.2158337,1.2337714,1.2643504,1.2845265,1.3220029,1.3221671,1.3189986,1.2791208,1.2533291,1.2236022,1.2022831,1.1669775,1.1223341,1.0785637,1.0184599,0.96977766,0.92219459,0.87433539,0.92255403,0.97709258,1.0340104,1.089533,1.1457071,1.2005639,1.2568417,1.3035761,1.353756,1.3858805,1.437834,1.464152,1.5011427,1.5229731,1.5458658,1.5654681,1.5805314,1.5882083,1.5685654,1.5431234,1.4896422,1.4423178,1.3779581,1.3188149,1.2615203,1.1711259,1.1119605,1.0206648,0.92971506,0.8562555,0.8948307,0.94636358,0.98700363,1.031338,1.0645138,1.1024578,1.128817,1.1238362,1.0931215,1.0636023,1.0275125,0.98156938,0.93329106,0.87974628,0.82724173,0.74712104,0.69501752,0.6109248,0.52330165,0.43521724,0.37540093,0.28710007,0.2175329,0.13243347,0.043625371,-0.043669674,-0.10132258,-0.19266674,-0.25502572,-0.34344468,-0.41638349,-0.49517196,-0.57923452,-0.64375217,-0.73329614,-0.79223995,-0.87699634,-0.96551392,-1.0244457,-1.1154192,-1.1790928,-1.2199247,-1.2629173,-1.2453589,-1.2152282,-1.1718791,-1.1504248,-1.1069324,-1.100796,-1.0808295,-1.0553585,-1.0192232,-0.98568917,-0.91692068,-0.85782163,-0.79605747,-0.7330286,-0.66271043,-0.62701778,-0.57705599,-0.51595972,-0.45407193,-0.38503893,-0.31716267,-0.25939904,-0.19349387,-0.1157891,-0.037582207,0.01260085,0.086516396,0.14199307,0.20177253,0.27013994,0.29068764,0.27206469,0.26039378,0.24506387,0.20517724,0.15908624,0.10397425,0.065984085,0.014733084,-0.030436597,-0.079110973,-0.13257786,-0.18607735,-0.23797415,-0.28462223,-0.33233873,-0.36950113,-0.41473091,-0.46378035,-0.50812911,-0.56361023,-0.61635071,-0.65691715,-0.69331231,-0.7358946,-0.78530772,-0.8337538,-0.87092055,-0.91454644,-0.96681059,-1.0128821,-1.0563397,-1.0980483,-1.1401697,-1.1770044,-1.2127239,-1.2488451,-1.280186,-1.3085214,-1.3375487,-1.3760562,-1.3986408,-1.4410477,-1.4667015,-1.498715,-1.51942,-1.5494431,-1.5778825,-1.5960048,-1.6091706,-1.63734,-1.6578994,-1.68887,-1.7020286,-1.7395887,-1.7635863,-1.7610619,-1.7486036,-1.750621,-1.7236117,-1.684128,-1.6532333,-1.5986729,-1.5345379,-1.4764327,-1.4105588,-1.3329482,-1.2725076,-1.2085995,-1.1455093,-1.0666033,-1.0000172,-0.93575025,-0.86057292,-0.79816133,-0.7406118,-0.67374726,-0.6050196,-0.53345187,-0.46918603,-0.40168148,-0.34402978,-0.26924969,-0.2164937,-0.18883957,-0.14217725,-0.11630618,-0.094787546,-0.06523128,-0.042370058,-0.023918923,-0.005309553,0.0046207383,0.022460234,0.033593692,0.039735503,0.047156221,0.05702565,0.054741766,0.065603707,0.064490333,0.065873327,0.067770332,0.064889818,0.070848071,0.082044274,0.092520898,0.10326776,0.11569282,0.13429182,0.15583014,0.18116675,0.21092283,0.2429022,0.2880589,0.32652853,0.36954251,0.40692777,0.43659218,0.47363121,0.50789021,0.53845047,0.57929085,0.60721769,0.63130072,0.66531861,0.6863163,0.71897598,0.74794764,0.76924791,0.81763681,0.85440791,0.88911895,0.9203181,0.95699005,0.99295158,1.0278389,1.0775058,1.0979357,1.1346292,1.1590856,1.1815891,1.1916285,1.1834076,1.2126778,1.1620119,1.1149843,1.0724768,1.0117756,0.99230654,0.95579044,0.95472132,0.95083051,1.0004792,1.0634186,1.1546719,1.2454147,1.3319845,1.4151082,1.4544354,1.4864038:2
1.1792949,1.1261486,1.0439252,0.94371427,0.8214134,0.75696949,0.63279936,0.59856481,0.53478312,0.4213465,0.40403744,0.47204142,0.35916296,0.286635,0.23611911,0.14090836,0.092385494,0.0025161489,-0.043137229,0.084669229,-0.021737287,-0.092169055,-0.20065643,-0.30692376,-0.35748295,-0.46724847,-0.50356496,-0.6386641,-0.74941737,-0.87583015,-1.030311,-0.86688354,-0.67834237,-0.50060738,-0.30951867,-0.13018701,0.056380091,0.22640571,0.40547668,0.58148248,0.77998474,0.78770993,0.747138,0.6565072,0.57273521,0.50526021,0.45103651,0.35844779,0.27829374,0.20671896,0.36107732,0.27215456,0.19696417,0.1411143,0.12107645,0.066863174,-0.021424554,-0.10031229,-0.12046477,-0.2447401,-0.30690741,-0.40819084,-0.47909081,-0.59219719,-0.70477283,-0.71248922,-0.46632449,-0.264273,-0.062744988,-0.090562684,-0.21559627,-0.2325208,-0.27172711,-0.3506518,-0.39338106,-0.38150597,-0.44637156,-0.5438329,-0.63318971,-0.71090923,-0.81460691,-0.75456272,-0.77270651,-0.90088965,-0.99620012,-1.1059516,-1.2241118,-1.3390367,-1.4280144,-1.5435274,-1.6168322,-1.672078,-1.793178,-1.719536,-1.5200159,-1.2605786,-0.99698803,-0.73730817,-0.4831015,-0.2210917,0.041484188,0.2999796,0.55822609,0.82073805,1.0827891,1.3429346,1.5618112,1.760058,1.9169889,2.0831979,2.3212277,2.4542856,2.6272802,2.8133498,2.9552546,3.02993,3.0048613,2.9270222,2.7510442,2.5698885,2.314694,2.1390718,1.8834471,1.6997726,1.4403777,1.2411024,0.99088777,0.81501604,0.55399435,0.29421592,0.17770078,-0.06374264,-0.26699924,-0.52610428,-0.7873872,-1.0188038,-1.2364949,-1.4180152,-1.6629015,-1.9223986,-2.0727012,-1.9694397,-1.8733294,-1.7499396,-1.6468762,-1.5121812,-1.4064005,-1.2451903,-1.1108491,-0.97226131,-0.85394997,-0.69533804,-0.53936582,-0.51657809,-0.46252619,-0.29153953,-0.18150937,-0.097449898,-0.034003886,0.061053991,0.044435243,0.12941954,0.1804323,0.28190194,0.3848352,0.27290863,0.067502192,-0.091747654,-0.27844541,-0.46292642,-0.65266648,-0.60092424,-0.50847734,-0.42157362,-0.34985584,-0.29524915,-0.23492653,-0.17963359,-0.10152015,-0.092387604,-0.081664314,0.0010142816,0.061077035,0.11813423,0.16199415,0.26524643,0.29288576,0.16691738,0.25527661,0.31697317,0.36848456,0.43671756,0.51910273,0.5118997,0.41240714,0.53857912,0.63000848,0.70879354,0.74998441,0.83023971,0.880833,0.76830014,0.58354071,0.32223714,0.12889094,-0.063967394,-0.32806988,-0.51973089,-0.78443226,-0.90879906,-0.77016835,-0.66624642,-0.56947623,-0.51648505,-0.39460462,-0.34725808,-0.26651224,-0.16673949,-0.0590007,0.069035087,0.13915286,0.25362461,0.36568601,0.27629688,0.3012751,0.40580037,0.50940201,0.58871148,0.6479108,0.7732338,0.88112332,0.89400637,1.0160409,1.1393215,1.2974485,1.4031417,1.4823765,1.5387189,1.4168556,1.219333,0.97090008,0.77952471,0.58997591,0.48613733,0.3284083,0.12436322,-0.059672291,-0.26664273,-0.4782779,-0.68948911,-0.8775533,-1.0825357,-1.1461782,-0.99959642,-0.82618331,-0.73990961,-0.5641425,-0.40431879,-0.28922799,-0.13196888,-0.041305455,0.10690832,0.21699686,0.3216893,0.17812588,0.095734278,0.28576065,0.4232019,0.52988544,0.64132695,0.80736928,0.93272939,0.75967741,0.75437069,0.90673516,1.1063433,1.2395975,1.2818156,1.4571515,1.5988359,1.7438517,1.8840019,1.971818,1.8209203,1.634901,1.4648214,1.2944046,1.0949428,0.97948597,0.80223338,0.64200236,0.45593916,0.28777396,0.19388022,0.031632867,-0.12095544,-0.32058443,-0.47370634,-0.67913258,-0.82557626,-1.0341107,-1.1786304,-1.3769011,-1.5839267,-1.7327781,-1.9251843,-2.1225365,-2.3234543,-2.3118711,-2.1411565,-2.0123391,-1.8448433,-1.689844,-1.5357206,-1.3913257,-1.2346531,-1.10282,-0.97447793,-0.82466632,-0.71356856,-0.55747944,-0.49638425,-0.67072769,-0.59691546,-0.44061049,-0.30356715,-0.15407624,-0.0061205232,0.15136362,0.074389252,0.16376641,0.31837826,0.47596548,0.58066919,0.76407737,0.90549428,1.1063399,1.0902063,0.92344782,0.76066872,0.60230421,0.53316612,0.29386201,0.14015192,0.2287635,0.097633093,-0.047791771,-0.20566785,-0.35053364,-0.25217775,-0.1924994,-0.29106942,-0.43883123,-0.58104491,-0.7426728,-0.91067008,-1.0916384,-1.2222893,-1.4210213,-1.4418424,-1.258793,-1.0984741,-0.90997422,-0.74564682,-0.55485019,-0.37707069,-0.29078023,-0.22838107,-0.051631753,0.092074783,0.2142356,0.39465407,0.53844819,0.65035158,0.84638209,1.0408917,1.2375097,1.4402606,1.6280777,1.7192641,1.6132229,1.5164666,1.3579151,1.2442737,1.1280161,1.0458149,0.89459404,0.79878712,0.67853243,0.53565279,0.38427485,0.23688078,0.2175126,0.058272497,-0.043648443,-0.21726569,-0.35108554,-0.48487268,-0.47530015,-0.54062022,-0.6724701,-0.79607244,-0.9573581,-1.0558886,-1.1953051,-1.338065,-1.449104,-1.5837992,-1.7144875,-1.8886168,-1.8990322,-2.1185648,-1.9056099,-1.7137157,-1.4535843,-1.1945922,-1.0130843,-0.75296635,-0.49206738,-0.3960421,-0.20459453,0.056170444,0.31761397,0.50299324,0.76561377,0.95581358,1.1849476:1
1.4378089,1.417364,1.4050533,1.3924035,1.3664555,1.3079642,1.3189182,1.2768621,1.2781069,1.2131296,1.1617364,1.1096013,1.0483233,0.96895426,0.91678283,0.83386091,0.81279665,0.81929794,0.84755076,0.83523221,0.80317588,0.80034481,0.77632937,0.75754716,0.72807814,0.68937542,0.63071907,0.5847858,0.51619895,0.47299174,0.37108041,0.2923145,0.18900606,0.077534138,-0.0077056943,-0.062425692,-0.12182112,-0.1624757,-0.2206739,-0.27391279,-0.3276075,-0.38039718,-0.42167365,-0.46277956,-0.51897322,-0.59855751,-0.65924694,-0.74261936,-0.75387365,-0.75946599,-0.71579101,-0.71221169,-0.66873539,-0.66603593,-0.63490955,-0.64129676,-0.58977478,-0.58358787,-0.56261322,-0.54357513,-0.52739551,-0.51090404,-0.4814666,-0.46658882,-0.42822352,-0.3968462,-0.36778949,-0.33945117,-0.29735969,-0.27974568,-0.24855419,-0.21224396,-0.18875864,-0.17493724,-0.17614162,-0.14301467,-0.026742828,-1.355883E-4,0.021992486,0.041887067,0.046954137,0.06284179,0.077015825,0.087456192,0.070977326,0.026323583,-0.089906957,-0.20830067,-0.25526787,-0.36594378,-0.45151499,-0.56745593,-0.65029235,-0.74037711,-0.85904402,-0.95075396,-1.0660155,-1.1484513,-1.2542359,-1.3194205,-1.4008107,-1.4930279,-1.6104007,-1.6732401,-1.7596702,-1.8519609,-1.9090184,-1.991086,-2.0455933,-1.9612038,-1.8894014,-1.8148614,-1.7309418,-1.670903,-1.5959238,-1.5174284,-1.4403517,-1.3596656,-1.2841363,-1.2014251,-1.1415656,-1.0614535,-0.97699185,-0.90087433,-0.82711431,-0.74847592,-0.67588142,-0.59721086,-0.52201036,-0.44789956,-0.3612764,-0.29255968,-0.22247509,-0.14376823,-0.064925709,0.0038595503,0.077466303,0.17022293,0.2462144,0.31280081,0.4028016,0.49496789,0.56191233,0.6025734,0.66273499,0.75006808,0.8319649,0.88125334,0.92948143,0.97351774,1.0231043,1.0554388,1.1016336,1.1353418,1.164902,1.1904915,1.1581764,1.1114619,1.0462711,0.98026072,0.91200364,0.84095791,0.76904589,0.69683811,0.62578078,0.54440866,0.48501254,0.40235248,0.32412614,0.24520137,0.16629303,0.087846487,0.019191532,-0.065669255,-0.13238851,-0.1115482,-0.031711528,0.04295498,0.12564421,0.23549643,0.33429773,0.42903418,0.51044301,0.59787693,0.70378676,0.78418241,0.86232846,0.93352208,1.0264041,1.0850384,1.1572956,1.2162199,1.2778412,1.3415941,1.3995288,1.4465197,1.5292465,1.5609974,1.610192,1.6510114,1.6860641,1.6651098,1.7076306,1.6800534,1.6548358,1.5948965,1.6066129,1.54218,1.503826,1.4602822,1.4278638,1.3847629,1.3305986,1.3299436,1.3436224,1.3054959,1.282877,1.229884,1.1977706,1.1563107,1.1147183,1.0522858,0.99224968,0.93340001,0.86165424,0.77629657,0.7036297,0.61419986,0.53743989,0.43215243,0.33330872,0.24627251,0.16174617,0.050997545,-0.041665479,-0.15290512,-0.24159552,-0.33180348,-0.43210688,-0.53009532,-0.62509372,-0.7121835,-0.72478213,-0.67120849,-0.62097531,-0.55643222,-0.47150954,-0.39848455,-0.3172041,-0.24024861,-0.17359217,-0.085820617,-0.030753605,0.021121773,0.09346853,0.19422807,0.25629055,0.33652387,0.37765205,0.43517089,0.45653132,0.46252023,0.47937698,0.52674083,0.55199651,0.49365185,0.44756461,0.38988511,0.31914829,0.24842789,0.17598118,0.10313756,0.030431462,-0.044749805,-0.11694834,-0.19259051,-0.25968735,-0.3205126,-0.38927461,-0.45696133,-0.52590463,-0.59015541,-0.65168,-0.72473039,-0.7822657,-0.85999027,-0.92997857,-0.99926134,-1.0654018,-1.1367192,-1.2072656,-1.2773868,-1.3438116,-1.411135,-1.4265824,-1.4793907,-1.5557171,-1.6268661,-1.7064003,-1.7698831,-1.8579961,-1.8540695,-1.9705485,-2.0245104,-2.107098,-2.1577917,-2.2034997,-2.2251763,-2.198189,-2.1058993,-2.0677151,-1.9908547,-1.9225346,-1.8609583,-1.7720906,-1.6562633,-1.5700855,-1.4529186,-1.3343981,-1.2165632,-1.1091982,-1.017405,-0.92438364,-0.80424496,-0.71413893,-0.63301496,-0.56342178,-0.53236792,-0.53236986,-0.54649579,-0.54380438,-0.54973173,-0.55960923,-0.57610992,-0.60011165,-0.61505947,-0.62745483,-0.65309887,-0.67366332,-0.69159514,-0.72040964,-0.73938891,-0.76744941,-0.78616975,-0.80208766,-0.81237868,-0.83974074,-0.86026529,-0.87431736,-0.87487026,-0.8769013,-0.88508976,-0.88875844,-0.88475967,-0.89324763,-0.90176151,-0.90255933,-0.93247082,-0.92203102,-0.96745385,-0.91916991,-0.96653313,-0.94712943,-0.90383977,-0.83925449,-0.76504039,-0.68882778,-0.59085589,-0.49534593,-0.40313806,-0.29250189,-0.20280622,-0.12678523,-0.074503583,-0.0065919063,0.052536236,0.10530867,0.1573526,0.2077972,0.26574701,0.3190982,0.39373476,0.45566455,0.49644286,0.54073082,0.56231276,0.59306067,0.62012377,0.66106807,0.69442144,0.75441989,0.81943207,0.92443827,1.0202175,1.0796037,1.1157536,1.170657,1.2122859,1.2712226,1.2931259,1.3177437,1.3529366,1.3725596,1.3832553,1.4106277,1.4264148,1.4108987,1.4097702,1.4727472,1.4984653,1.5017374,1.5068869,1.5163597,1.5183496,1.5553817,1.5995445,1.6118855,1.6074941,1.6047847,1.5801577,1.5707698,1.546004,1.5307818,1.5169223,1.4993533,1.4817986,1.4598799:2
2.8748152,2.7820593,2.6919562,2.607841,2.5172127,2.4288907,2.3425814,2.2495628,2.1559831,2.0717587,1.9784745,1.8873277,1.8049211,1.708267,1.6264172,1.538129,1.4442803,1.355238,1.2689684,1.1790527,1.0861053,1.0016273,0.90801924,0.81456475,0.73294483,0.64373535,0.55326254,0.46283959,0.37684773,0.27937012,0.19446232,0.10346553,0.011229437,-0.072952969,-0.15921511,-0.25128503,-0.34069523,-0.43051151,-0.51899707,-0.61090159,-0.70332875,-0.7914191,-0.87668108,-0.97063746,-1.0629286,-1.1417167,-1.2356602,-1.3262584,-1.4208082,-1.4744255,-1.5598759,-1.6515157,-1.7178459,-1.8024204,-1.799783,-1.7742868,-1.7622802,-1.7424549,-1.7006839,-1.6783751,-1.6392504,-1.6045004,-1.5452584,-1.5020663,-1.4566347,-1.3971058,-1.3309662,-1.2419869,-1.1725374,-1.1100632,-1.0651414,-1.0229747,-0.96565296,-0.96426918,-0.98547502,-0.93440937,-0.87025575,-0.81390171,-0.74989038,-0.7128581,-0.63982984,-0.60271103,-0.55925811,-0.57416487,-0.51555091,-0.44622661,-0.38312481,-0.33264847,-0.33660561,-0.32168245,-0.26973261,-0.2369487,-0.24363508,-0.3620509,-0.46643934,-0.55710708,-0.6411188,-0.75609717,-0.81190561,-0.88996934,-0.90833394,-0.88053623,-0.85059111,-0.7687862,-0.69257526,-0.61520837,-0.53687837,-0.46204693,-0.45675192,-0.52162813,-0.56021175,-0.4651245,-0.38181854,-0.28951768,-0.25685063,-0.18992757,-0.11311794,-0.053593475,-0.090565712,-0.13616581,-0.13109803,-0.036479609,0.070392504,0.085202736,0.18407276,0.29199946,0.37173553,0.41526678,0.35406142,0.38521775,0.47504256,0.58789529,0.67083282,0.71206757,0.80317626,0.86116832,0.94921733,1.0313855,0.99651575,0.9080899,0.80033379,0.70228261,0.61553931,0.51309172,0.47349029,0.39860177,0.31324981,0.22328338,0.13701087,0.028733505,-0.054049988,-0.06186964,-0.12348833,-0.21417769,-0.30228158,-0.40430287,-0.49662046,-0.57125996,-0.63166753,-0.73798853,-0.8436522,-0.9339776,-1.0345747,-1.1198925,-1.2002732,-1.2482215,-1.1671222,-1.0907376,-0.99708686,-0.92517351,-0.82966499,-0.74343241,-0.66947371,-0.59773271,-0.49231695,-0.38602136,-0.34155283,-0.39372365,-0.4055881,-0.31415314,-0.21949683,-0.13244105,-0.027320955,0.066318616,0.050888007,0.068125216,0.14691258,0.23388979,0.28407883,0.31180101,0.36610774,0.42874933,0.48581222,0.4418727,0.34237761,0.28068889,0.22960833,0.21804084,0.28728686,0.37559756,0.45610276,0.51174302,0.59311431,0.67527899,0.66523342,0.68866618,0.77019446,0.86460498,0.94908086,0.9979825,1.0435884,1.1231992,1.2111992,1.30268,1.3887359,1.4672894,1.5535023,1.645427,1.6776182,1.5845567,1.4950143,1.4090918,1.3360145,1.2636877,1.1863772,1.0861216,1.059464,0.96806979,0.90404755,0.87946513,0.7950951,0.70434817,0.60683012,0.52692678,0.43921863,0.35253903,0.2600879,0.29311865,0.36477623,0.46215333,0.51437333,0.47243728,0.39865882,0.37265685,0.3130407,0.23092506,0.15311256,0.18431318,0.10194305,0.01283961,-0.075032751,-0.15231525,-0.23599134,-0.17252677,-0.22479408,-0.3059063,-0.38035199,-0.46373603,-0.55212935,-0.63286447,-0.72052853,-0.78572523,-0.85607534,-0.90514102,-0.83733527,-0.76637427,-0.67002613,-0.61199848,-0.53945472,-0.4393128,-0.31566719,-0.22457919,-0.16614271,-0.085582087,0.031864091,0.13947812,0.2195984,0.28293345,0.27700986,0.35660727,0.45937932,0.53899603,0.61981616,0.70980978,0.78244771,0.86907189,0.94669399,1.0192909,1.0564907,0.99839234,0.88244209,0.78749701,0.72868313,0.61433903,0.50750069,0.43387873,0.48317633,0.40637255,0.33105391,0.2233218,0.21254616,0.12056997,0.023919908,0.0072720736,0.075907652,0.12799177,0.069833806,9.1934637E-4,-0.079292439,-0.16951608,-0.2385926,-0.31244424,-0.39237349,-0.4057435,-0.32425609,-0.27535273,-0.32676914,-0.40431482,-0.51193779,-0.58732608,-0.65877896,-0.71612846,-0.73786929,-0.64090761,-0.55803865,-0.47076262,-0.38785722,-0.29348574,-0.20607242,-0.11590608,-0.03323484,0.048520314,0.10456936,0.077601803,-0.004233711,-0.085552182,-0.17854914,-0.22192309,-0.27133728,-0.24998678,-0.30118592,-0.38713354,-0.46252203,-0.54767891,-0.62523702,-0.691629,-0.59421462,-0.57888678,-0.6433795,-0.71701217,-0.78230751,-0.83458926,-0.9111429,-0.90495524,-0.91423094,-0.97293407,-1.0197355,-1.0858599,-1.1163845,-1.185131,-1.2568477,-1.3143083,-1.3336164,-1.3823302,-1.4159221,-1.460277,-1.5172796,-1.5580001,-1.6017546,-1.660286,-1.6829565,-1.7023496,-1.7362837,-1.7656039,-1.780921,-1.6964097,-1.6016804,-1.5151777,-1.4262959,-1.3275652,-1.2476988,-1.150638,-1.0686142,-0.97508954,-0.89158464,-0.81063001,-0.71668752,-0.62882543,-0.54234209,-0.44856512,-0.36306051,-0.27297378,-0.18402574,-0.099758281,-0.014320443,0.079638889,0.16683085,0.25903365,0.35083562,0.43456527,0.52335467,0.6108039,0.70046155,0.78901893,0.8781912,0.96391495,1.0512672,1.143673,1.2319852,1.3212918,1.4055705,1.4950504,1.5885341,1.6766682,1.7678411,1.8593112,1.94224,2.0314658,2.122327,2.2089758,2.3007219,2.3939811,2.4772327,2.5665695,2.6582328,2.7476106,2.8251922:3
1.9027983,1.7987564,1.6879286,1.6232206,1.557558,1.4929332,1.4190848,1.3504755,1.2964604,1.2386348,1.174137,1.1284567,1.0723287,1.0134108,0.93786901,0.86158029,0.80875537,0.70281055,0.61956737,0.54826142,0.51985909,0.46487471,0.45208099,0.4499103,0.40722082,0.42393634,0.43566235,0.46470976,0.5156727,0.55244589,0.49798895,0.37344156,0.27005713,0.15170795,0.043846477,0.028569828,0.084310947,0.16024809,0.24800952,0.32420486,0.39742817,0.47249778,0.5578519,0.62731041,0.64755922,0.66535955,0.68614946,0.7553415,0.82400666,0.87738625,0.91150304,0.96036205,0.95417454,0.95528276,0.95576109,0.95188815,0.93534588,0.92740196,0.91594801,0.90385077,0.87901443,0.79531426,0.7096464,0.65288062,0.60787734,0.54046896,0.45728052,0.41708693,0.43304956,0.45650815,0.48641397,0.50656692,0.51704796,0.53817533,0.55281953,0.52419313,0.51391905,0.46370755,0.39549761,0.32942873,0.2517722,0.17433496,0.066140377,-0.026834341,-0.092277947,-0.1500391,-0.21777702,-0.29203501,-0.36327593,-0.44735997,-0.5174455,-0.60825691,-0.67232401,-0.75176548,-0.83253032,-0.89298176,-0.95099812,-1.0100687,-1.0633878,-1.1239274,-1.1883043,-1.2400305,-1.2413133,-1.2698306,-1.3297912,-1.2825244,-1.2682683,-1.2163623,-1.1489089,-1.0799575,-1.0309945,-0.94712441,-0.86933972,-0.79451832,-0.70072942,-0.61650142,-0.52946706,-0.4466697,-0.3760291,-0.29637014,-0.23028032,-0.17994328,-0.13273891,-0.083122508,-0.083183869,-0.17257468,-0.22863103,-0.27623386,-0.36548511,-0.4384751,-0.47077353,-0.51442077,-0.56829252,-0.65408732,-0.71864791,-0.74458597,-0.7866159,-0.80597518,-0.83436918,-0.87791668,-0.97028004,-1.0553386,-1.1351673,-1.0707983,-1.1204013,-1.2008816,-1.2538658,-1.3488636,-1.4271811,-1.5076571,-1.5434246,-1.5156032,-1.4859766,-1.4609201,-1.3564942,-1.2698081,-1.1754304,-1.0902486,-1.0189126,-0.92339362,-0.82795344,-0.74144089,-0.65209202,-0.54561224,-0.45809954,-0.36376308,-0.27434114,-0.17600602,-0.15169765,-0.10022531,-9.8622397E-5,0.095516021,0.19986199,0.28700871,0.38175084,0.46870171,0.55577164,0.65129691,0.73789787,0.80451041,0.90543734,0.99994201,1.1020968,1.1931633,1.2790944,1.3841715,1.4758434,1.5831164,1.672463,1.7788603,1.8681243,1.9256651,2.0172503,2.1226362,2.1968768,2.2837325,2.4011681,2.4868438,2.5479425,2.5963184,2.6331171,2.5635342,2.4891447,2.4089221,2.3346714,2.2435728,2.1384671,2.0325248,1.9354451,1.8396278,1.7339339,1.6285123,1.5439889,1.4351085,1.3361523,1.2432468,1.1407195,1.0474194,0.94142495,0.85454567,0.7506064,0.65928859,0.56059865,0.46420304,0.37735745,0.271454,0.17999678,0.090269676,-0.012212081,-0.10548233,-0.19526004,-0.2829464,-0.38946192,-0.47870032,-0.57526316,-0.67253115,-0.75974329,-0.85617521,-0.95599888,-1.0426603,-1.1407584,-1.2398979,-1.3271688,-1.4147331,-1.5033489,-1.5939017,-1.6896883,-1.7623214,-1.8386661,-1.8450324,-1.7661676,-1.6657193,-1.5880605,-1.5310459,-1.460694,-1.4103009,-1.3472286,-1.2981499,-1.2204738,-1.1813586,-1.2677674,-1.2682998,-1.2851555,-1.2176843,-1.3104435,-1.2516503,-1.1979722,-1.1552345,-1.0633975,-0.96780089,-0.88536114,-0.85364682,-0.78457441,-0.71255407,-0.63688422,-0.5526255,-0.50473051,-0.49599328,-0.45466226,-0.45775477,-0.42144656,-0.38906755,-0.33298592,-0.27515373,-0.21137128,-0.11591829,-0.018325808,0.043227547,0.10941337,0.15489283,0.18189792,0.1447181,0.049880584,-0.038633236,-0.13441621,-0.219365,-0.31153345,-0.38317457,-0.42576775,-0.48522413,-0.57335164,-0.65597616,-0.742824,-0.83653232,-0.92626795,-0.99648482,-1.0658037,-1.1420192,-1.1881024,-1.1354958,-1.1603738,-1.1031365,-1.0040246,-0.90406984,-0.79410622,-0.67274447,-0.55154687,-0.45492781,-0.3796077,-0.31055209,-0.23820983,-0.17038588,-0.11554246,-0.049581534,-0.012432249,-0.058662346,-0.11967318,-0.18315224,-0.22034422,-0.15602773,-0.080901159,-0.011086673,0.064786967,0.12167076,0.1725003,0.22720663,0.28253522,0.25985111,0.30437493,0.28216555,0.22948951,0.16760137,0.10183146,0.046474256,0.041939833,0.015570413,-0.050226739,-0.12178953,-0.19002152,-0.22944776,-0.29128511,-0.34938331,-0.42802184,-0.41101254,-0.46297766,-0.484353,-0.53320024,-0.57906475,-0.6622665,-0.75890138,-0.84209484,-0.9353491,-1.023761,-1.083274,-1.1402781,-1.1891636,-1.2601327,-1.3506884,-1.4464417,-1.5053824,-1.4833386,-1.4080424,-1.3220261,-1.2342063,-1.1461005,-1.0612147,-0.97083602,-0.88055424,-0.80225802,-0.7021909,-0.64814213,-0.55781515,-0.47136566,-0.38218322,-0.32896406,-0.26948415,-0.18530374,-0.1064603,-0.065858516,0.021859847,0.11476812,0.20636612,0.29095195,0.37385305,0.46243829,0.5516395,0.64016901,0.65606652,0.62158219,0.58910373,0.58395569,0.5848465,0.56439294,0.55135491,0.52432821,0.47971264,0.44945865,0.54339022,0.63052982,0.72586016,0.83341759,0.92661121,1.0406623,1.1333511,1.2180749,1.2935178,1.3266843,1.3646211,1.4110972,1.5031598,1.6157179,1.696414,1.7586728,1.8097067,1.844457,1.8897341,1.9103753:5
1.4435633,1.3427705,1.2245521,1.1358079,1.0387139,0.99172915,0.90997537,0.82585614,0.75567969,0.68999334,0.66837015,0.65186421,0.56787066,0.43001354,0.33043811,0.19782356,0.12726935,0.037361843,-0.03324349,-0.12238684,-0.1726015,-0.064996029,-0.030392991,0.052594335,0.15478136,0.25521608,0.36159456,0.43787609,0.35209041,0.22477458,0.10442457,-0.013705385,-0.092167147,-0.20109703,-0.30852431,-0.42246038,-0.53805042,-0.61482378,-0.69442455,-0.80404616,-0.91379828,-0.99484607,-1.0690452,-1.1830021,-1.2814961,-1.3941164,-1.4682922,-1.4861929,-1.5000181,-1.4650916,-1.419715,-1.2988431,-1.1966498,-1.1447669,-1.0857845,-0.96491044,-0.92374529,-0.86481315,-0.7501856,-0.63591981,-0.53645569,-0.45459034,-0.34766905,-0.2216471,-0.097066214,0.034892373,0.14676854,0.25708575,0.3836545,0.44210961,0.36703245,0.27780478,0.19068897,0.088390303,0.013122556,-0.04913332,-0.11611689,-0.1929334,-0.24302077,-0.29242957,-0.38009522,-0.45504309,-0.53879576,-0.61245706,-0.65648571,-0.69171399,-0.74825782,-0.79055328,-0.78257065,-0.83062384,-0.87280942,-0.91475786,-0.9633573,-1.0582568,-1.1520783,-1.1912968,-1.2903887,-1.3757282,-1.4318938,-1.3921482,-1.4179489,-1.4585096,-1.5412061,-1.6128663,-1.6879838,-1.6371528,-1.5240308,-1.4059981,-1.2940591,-1.179144,-1.0741032,-0.96814746,-0.85389825,-0.73487851,-0.62429568,-0.5073291,-0.39092097,-0.27326873,-0.16175286,-0.041615239,0.073469154,0.19600847,0.30712473,0.43462244,0.53306856,0.64303013,0.76346353,0.8795357,1.0009451,1.1151375,1.230135,1.3501447,1.4325163,1.554459,1.6487268,1.7720696,1.8877199,2.0073361,2.0877855,2.2107809,2.3216389,2.4247624,2.5002561,2.4779239,2.4495776,2.3711683,2.262775,2.1803988,2.0850427,2.0451088,1.9854769,1.930547,1.8249287,1.8104802,1.7452345,1.715248,1.6693569,1.6353917,1.5901886,1.5129628,1.3995867,1.3416885,1.2652576,1.1466285,1.0282907,0.95722407,0.91560255,0.7968643,0.67846885,0.5632516,0.44792668,0.33008307,0.2121689,0.12040205,0.019702277,-0.092223114,-0.20972325,-0.32616856,-0.44069393,-0.55491326,-0.67178831,-0.78633288,-0.8991647,-1.0106558,-1.1312794,-1.2412206,-1.3586483,-1.4719504,-1.58635,-1.5992917,-1.5228965,-1.430483,-1.3380075,-1.2736961,-1.2291233,-1.2648921,-1.2949042,-1.2495403,-1.1807878,-1.1179758,-0.97762053,-0.84787276,-0.76504366,-0.73358673,-0.74434664,-0.72053438,-0.67225096,-0.67561443,-0.62713109,-0.54836173,-0.48093633,-0.41192185,-0.35749303,-0.28678242,-0.20663813,-0.14718084,-0.08254183,0.0026190139,0.036645892,0.11961558,0.19852606,0.29335115,0.39670855,0.49163094,0.41857882,0.27256923,0.13385095,-0.002015292,-0.13427868,-0.26667207,-0.4005219,-0.52163458,-0.65090876,-0.78515472,-0.90837308,-1.0211713,-1.1286891,-1.1078974,-1.059788,-1.0100998,-0.93502177,-0.85389429,-0.76614376,-0.68481763,-0.60371887,-0.48654809,-0.37989943,-0.26928261,-0.16567166,-0.071135641,0.004518939,0.087956732,0.13918282,0.24182359,0.34078541,0.30461649,0.19895737,0.088712667,-0.016646546,-0.016258029,0.048973586,0.17350462,0.28001597,0.38087031,0.472464,0.51990117,0.61958505,0.70802125,0.71207293,0.74369173,0.80548297,0.8730148,0.95130659,1.0288516,1.0896048,1.1574648,1.2406762,1.3346644,1.4320414,1.4406303,1.3243619,1.2086175,1.0924983,0.99107327,0.87326983,0.73903734,0.64315337,0.54250857,0.41746149,0.27999203,0.15647954,0.061284993,-0.0098724297,-0.033831982,-0.11582156,-0.23186199,-0.35943521,-0.49536917,-0.63122988,-0.74331264,-0.87559976,-0.97346946,-1.0833606,-1.1481121,-1.2305726,-1.299188,-1.3374946,-1.4033976,-1.4750401,-1.4800288,-1.5023302,-1.4229684,-1.3559824,-1.3407611,-1.2714023,-1.1624236,-1.0578912,-0.97891547,-0.90949188,-0.80811549,-0.73303209,-0.61536743,-0.55170593,-0.43956388,-0.35018225,-0.24569776,-0.1202334,0.0090873429,0.084921555,0.19734857,0.29770764,0.40523768,0.51170096,0.61731082,0.72106807,0.82549568,0.75939929,0.66298969,0.59226632,0.52487742,0.50565731,0.60158309,0.69869766,0.79406686,0.89199898,0.98585784,1.0874762,1.1785932,1.2434616,1.3502831,1.4475853,1.5466652,1.6414356,1.7448057,1.8511557,1.9566672,1.8440943,1.7247641,1.6084531,1.5037316,1.3969514,1.2976949,1.1831728,1.1053588,1.0743905,1.0460601,0.93319556,0.82710879,0.71476432,0.599221,0.49378348,0.43641016,0.32669757,0.27816349,0.29409156,0.34283509,0.41382761,0.45855452,0.3692402,0.26447896,0.15028231,0.041779889,-0.075230722,-0.1904855,-0.29329559,-0.38895733,-0.52846328,-0.65809332,-0.74604352,-0.82108764,-0.94788031,-1.0267678,-1.1362437,-1.2400706,-1.3637199,-1.4840394,-1.564789,-1.6353043,-1.7336873,-1.7843042,-1.6602693,-1.531929,-1.4046812,-1.2669939,-1.1181034,-0.97075568,-0.81168325,-0.6542683,-0.52576859,-0.37126073,-0.24914993,-0.15330317,-0.089539516,-0.0087591465,0.059702923,0.1769966,0.29612819,0.41635246,0.51512956,0.58481905,0.68813419,0.80922143,0.92189309,1.0329748,1.1436803,1.2572117,1.3822126:5
1.1418511,1.1199864,1.0598228,0.99965847,0.98050643,1.0149818,0.94652281,0.9142896,0.93598973,0.94513851,0.92204714,0.89691739,0.87945162,0.75092203,0.63925523,0.5112263,0.46361624,0.35465377,0.25972423,0.11459575,-0.013750729,-0.15886802,-0.30393839,-0.44894959,-0.54377273,-0.67222359,-0.78381534,-0.91210039,-1.0398361,-1.1847626,-1.312767,-1.4222891,-1.4713163,-1.3568918,-1.2569434,-1.161418,-1.1018855,-1.0458354,-0.96538031,-0.89710258,-0.89815299,-0.81108442,-0.77986763,-0.70012606,-0.71247262,-0.68396764,-0.6238059,-0.53916652,-0.55242993,-0.46462066,-0.44617923,-0.39987696,-0.4262649,-0.38754002,-0.31261122,-0.24398933,-0.22914347,-0.17491524,-0.1387253,-0.09942493,0.0041357968,0.11373709,0.22591489,0.34169537,0.44866788,0.51513575,0.58212088,0.67149929,0.60393707,0.66796136,0.71888193,0.7929564,0.82378658,0.93489653,0.95302204,1.0912338,1.1547556,1.2546453,1.3582948,1.441275,1.4724184,1.3593991,1.2335599,1.1115697,1.0267934,0.90519851,0.83906865,0.72247001,0.62983811,0.54658767,0.46841156,0.3641905,0.26796841,0.19853467,0.10873611,0.069810886,-0.070117876,-0.15100567,-0.24787821,-0.35622378,-0.41830841,-0.47665129,-0.5873955,-0.67660389,-0.7374755,-0.79815291,-0.84277739,-0.79132409,-0.71367124,-0.63111926,-0.56563049,-0.49407699,-0.39950164,-0.32267697,-0.2987374,-0.20732689,-0.13095059,-0.02866111,0.042106689,-0.062319088,-0.16241392,-0.19642037,-0.30114608,-0.33885141,-0.42792782,-0.49825055,-0.56162968,-0.59168799,-0.49061572,-0.39021015,-0.28048007,-0.19175683,-0.0939884,0.0064664102,0.10157955,0.19540362,0.25298668,0.27445507,0.35116313,0.41446063,0.49746774,0.57940293,0.67820281,0.75730498,0.80584397,0.85802036,0.94793981,1.053088,1.1615117,1.2494943,1.3602359,1.4554534,1.559812,1.6542177,1.7573018,1.8590206,1.9483006,2.0606399,2.1690727,2.264578,2.1640493,2.0625159,1.9644103,1.891115,1.7889828,1.7150029,1.6291389,1.6280041,1.5282098,1.4300235,1.3655177,1.3741619,1.2732164,1.2056924,1.1637137,1.0581131,1.0742305,1.0710195,0.99071496,0.89414147,0.84116668,0.76683005,0.80377265,0.86078883,0.79219963,0.7104325,0.65312853,0.58955919,0.49530914,0.43714831,0.35744256,0.3463831,0.35468658,0.36901711,0.38140644,0.28425662,0.18178051,0.14272476,0.037372642,-0.0028886748,-0.13169127,-0.21099837,-0.35608307,-0.36744379,-0.49552336,-0.60044079,-0.66856768,-0.78666112,-0.78568439,-0.91623777,-1.0033633,-0.90378111,-0.82794323,-0.73259631,-0.63947805,-0.53477997,-0.43809763,-0.34780946,-0.34617735,-0.27846437,-0.21430577,-0.1253801,-0.040959899,0.033254511,0.035078158,0.13528931,0.23042522,0.28899662,0.35561715,0.45570959,0.52219829,0.62135973,0.7217666,0.7121163,0.60088992,0.51070549,0.40213908,0.39560431,0.28190055,0.17519932,0.18263997,0.122568,0.028038462,-0.046417764,-0.051553246,0.001110943,-0.10360244,-0.18585327,-0.23784553,-0.3008726,-0.4125605,-0.40844914,-0.42594603,-0.52614311,-0.60530813,-0.67997448,-0.79101369,-0.78852319,-0.88915814,-0.97839622,-1.0440833,-1.0321762,-1.1334539,-1.2276066,-1.3041491,-1.4121669,-1.4196156,-1.5263753,-1.6271299,-1.6891772,-1.7324196,-1.8300749,-1.8964833,-1.9985973,-2.0720545,-2.2011383,-2.3045557,-2.4246217,-2.5103829,-2.546363,-2.6117071,-2.6366704,-2.6263112,-2.584795,-2.4882797,-2.3814823,-2.3880026,-2.3824663,-2.3467932,-2.2855961,-2.191157,-2.111223,-2.050678,-1.983512,-1.896456,-1.8165206,-1.743926,-1.6633167,-1.5587222,-1.4962505,-1.4307604,-1.3490106,-1.2520187,-1.1586385,-1.061675,-0.96087259,-0.84267977,-0.79635004,-0.68955744,-0.60492854,-0.5046519,-0.39905242,-0.33416136,-0.25917681,-0.14503507,-0.070698986,0.037029113,0.10872611,0.16530077,0.27173968,0.34076204,0.43354992,0.52976221,0.60034075,0.58567232,0.693064,0.75948706,0.86702518,0.98811228,0.96141045,1.0904038,1.2083814,1.2733823,1.4148318,1.4855137,1.6017154,1.7009495,1.792626,1.6884393,1.58347,1.4584021,1.4174356,1.2893406,1.1647884,1.1551058,1.0375102,0.93639165,1.0197317,0.92361546,0.81513126,0.79114961,0.69291595,0.75811744,0.70939407,0.61535463,0.56561974,0.59628265,0.51038957,0.46935885,0.39474882,0.33294152,0.2400341,0.19495056,0.26440557,0.31027252,0.2537525,0.20464058,0.10128843,0.10001921,-0.0010576409,0.04211449,0.1421414,0.16926034,0.25297301,0.3309923,0.33802183,0.27345026,0.21539543,0.18250478,0.1204279,0.043115197,0.023186733,-0.017301014,-0.11266127,-0.19917794,-0.25818731,-0.22679427,-0.31248687,-0.38976627,-0.43942674,-0.53195407,-0.5693555,-0.66008341,-0.75376751,-0.85169873,-0.8851207,-0.97409762,-1.0615293,-1.1392856,-1.2173727,-1.3180839,-1.227871,-1.0987933,-0.97269043,-0.8281006,-0.70250332,-0.67184519,-0.54012602,-0.43210253,-0.28711371,-0.16808665,-0.03077168,0.11429958,0.24304055,0.38825608,0.47467614,0.52834119,0.65564875,0.76903926,0.84900102,0.89208652,0.91546548,0.91213188,0.96761734,1.038812,1.1091901,1.1383654:6
1.087737,0.99809045,0.89923429,0.81270772,0.73060113,0.64467334,0.56041895,0.51958799,0.42938882,0.34687143,0.27000975,0.21080084,0.15302516,0.092043604,0.018000779,-0.062144969,-0.10333782,-0.14863708,-0.21678892,-0.30115969,-0.39528451,-0.44207866,-0.48264368,-0.52931927,-0.55586964,-0.59607919,-0.50488871,-0.40466936,-0.31394603,-0.21947418,-0.14242019,-0.17563758,-0.24421202,-0.32155735,-0.41105833,-0.52442601,-0.61172862,-0.693532,-0.75580993,-0.80113202,-0.82732249,-0.89405724,-0.97928778,-1.1005781,-1.2135743,-1.2653195,-1.2599746,-1.3120248,-1.3612608,-1.3493927,-1.2824044,-1.1739445,-1.0741504,-0.9718079,-0.91974386,-0.81470304,-0.70714114,-0.60521676,-0.49602914,-0.40993682,-0.30407296,-0.20076033,-0.095775834,0.010547917,0.073314195,0.14570063,0.21224099,0.2304446,0.170239,0.096005805,0.030450765,-0.064261899,-0.16614682,-0.25299956,-0.34432498,-0.44056235,-0.52461059,-0.60803128,-0.67336037,-0.72304639,-0.72351338,-0.75745623,-0.80557978,-0.86546659,-0.91688049,-0.9869561,-1.0582454,-1.082032,-1.1448101,-1.2275392,-1.2913434,-1.3343419,-1.2845199,-1.2513976,-1.2233025,-1.2221927,-1.2349604,-1.2553064,-1.2826107,-1.3094384,-1.3460648,-1.3901894,-1.3304638,-1.2501951,-1.1294422,-0.99216884,-0.89083915,-0.76461938,-0.61482921,-0.50476913,-0.36713728,-0.21932019,-0.096151453,-7.6768108E-4,0.14796345,0.27328508,0.36797956,0.50356458,0.60891613,0.58902386,0.71097927,0.84904325,0.96837538,1.088347,1.1708007,1.2800345,1.4028467,1.5379065,1.6397248,1.7379897,1.8350477,1.8899056,1.9835635,2.0765652,2.0734783,2.1017065,2.1936213,2.221961,2.3283874,2.3861183,2.4619768,2.5338331,2.5558909,2.5579024,2.5119323,2.4341484,2.345304,2.2556773,2.1215613,2.0265366,1.9472173,1.8764439,1.8256248,1.7407885,1.6626501,1.6451068,1.527616,1.4151682,1.2923017,1.1566547,1.0243163,0.9121059,0.77552758,0.64874004,0.54221252,0.40388919,0.26840427,0.1302773,0.016602462,-0.12833579,-0.26343744,-0.38608721,-0.5324495,-0.66772463,-0.81437737,-0.91774072,-1.0274422,-1.16365,-1.2826365,-1.4134326,-1.4999115,-1.5898797,-1.5413157,-1.4794115,-1.3968751,-1.3358465,-1.294244,-1.2774352,-1.3145311,-1.3133842,-1.300935,-1.2314368,-1.1427009,-1.0544567,-0.94559365,-0.83915589,-0.72165584,-0.60723934,-0.49681444,-0.39267482,-0.33138988,-0.32945954,-0.34261351,-0.37136274,-0.38181306,-0.37440648,-0.33192402,-0.28611204,-0.25849671,-0.17187011,-0.052480164,0.06928003,0.1478775,0.20292952,0.2144028,0.25296287,0.34284398,0.4317892,0.512104,0.5909226,0.66219962,0.72981756,0.73013416,0.6243769,0.51261614,0.38830716,0.27819157,0.17319131,0.06816304,-0.041398487,-0.14249857,-0.26861072,-0.38257218,-0.52050659,-0.65818333,-0.77485323,-0.89243045,-0.99636067,-1.0904568,-1.1013291,-1.0815239,-1.0463518,-0.98404784,-0.91393569,-0.84164027,-0.76128326,-0.68346338,-0.62430177,-0.53575651,-0.44616152,-0.37440617,-0.30470597,-0.23050798,-0.16473597,-0.093037704,-0.024392712,0.047355139,0.11925899,0.20300986,0.2895522,0.3890189,0.37021433,0.31155618,0.2356671,0.1449778,0.10643818,0.1008157,0.16266581,0.24157113,0.34010809,0.43780541,0.50554178,0.57461454,0.61234083,0.66640995,0.71297706,0.78910585,0.85318421,0.91186591,0.98513179,1.0353131,1.1317237,1.2017732,1.1476842,1.0382981,0.93669274,0.83390212,0.73116389,0.63662222,0.54075845,0.44006446,0.33937448,0.26300592,0.18068273,0.094929379,-0.0054645687,-0.10986343,-0.21418495,-0.33426171,-0.45017563,-0.51649121,-0.61681936,-0.68871472,-0.77977946,-0.85617645,-0.96003986,-1.0504515,-1.0609918,-0.98769037,-0.95600816,-0.870686,-0.82726289,-0.72188315,-0.61835002,-0.48873211,-0.39297652,-0.34689914,-0.24992236,-0.13557695,-0.032305221,0.054077956,0.14820575,0.24717169,0.35260958,0.47122679,0.57606196,0.6800226,0.77097676,0.86893412,0.94158614,0.90934699,0.87504903,0.89034691,0.94453435,1.0097083,1.0717448,1.1450172,1.2131916,1.2800536,1.3468567,1.4202554,1.474938,1.5462714,1.6158694,1.6921069,1.7655076,1.8523232,1.9406496,2.0070914,1.9116499,1.8124639,1.7139477,1.6214609,1.5524256,1.453234,1.3661981,1.2536511,1.1634716,1.0916202,1.0221286,0.93747784,0.840091,0.75104077,0.61508839,0.48107252,0.37464564,0.28171902,0.23534245,0.19932445,0.18904522,0.19891935,0.21437581,0.12095006,0.025747134,-0.086633309,-0.19146307,-0.29944632,-0.40860678,-0.51924367,-0.62734074,-0.73109744,-0.77955725,-0.84989134,-0.91837296,-0.97093576,-1.0538049,-1.0825629,-1.1466418,-1.1725698,-1.2574567,-1.344907,-1.3806323,-1.464424,-1.4990132,-1.5922272,-1.6545098,-1.7107906,-1.76142,-1.6868373,-1.6175873,-1.5128064,-1.4031301,-1.3243766,-1.268997,-1.2362817,-1.1503962,-1.1072018,-1.0073734,-0.89687632,-0.79095124,-0.68186097,-0.63423138,-0.54376273,-0.44557672,-0.32519457,-0.20843119,-0.094014667,0.01876711,0.14572394,0.23647285,0.34740759,0.46878349,0.58570149,0.70333956,0.8203782,0.95416007,1.0833186:5
1.5082258,1.4268719,1.3157856,1.2033976,1.1577467,1.0507066,0.92122675,0.84978003,0.80080975,0.68895899,0.5702349,0.46264762,0.35336352,0.32219562,0.39820343,0.31488391,0.21157946,0.116611,0.027794988,-0.050567951,0.030841535,-0.0019148821,-0.093933924,-0.2120465,-0.28309366,-0.35623539,-0.26714597,-0.1235389,0.011069017,0.086826816,0.055093942,-0.024885066,-0.12166545,-0.18700635,-0.27100412,-0.33922494,-0.44429226,-0.51765634,-0.59566623,-0.65060898,-0.54516504,-0.42408461,-0.42333774,-0.4920419,-0.55454694,-0.5939798,-0.63656918,-0.71781484,-0.78528166,-0.82174581,-0.88510692,-0.75881864,-0.6321717,-0.49078578,-0.34778751,-0.2188617,-0.10133914,0.032667551,0.14973476,0.26518905,0.41424097,0.53101593,0.65970722,0.78786795,0.8925461,0.84761584,0.75471981,0.67541991,0.57612267,0.43543809,0.35690717,0.20874799,0.065224572,-0.0043365631,-0.10182469,-0.10461839,0.0089150509,0.016237204,-0.063306648,-0.18318,-0.29537423,-0.35778802,-0.45621791,-0.56243119,-0.67387355,-0.76649221,-0.66714548,-0.58537067,-0.56474921,-0.65420923,-0.73758111,-0.83968162,-0.95444542,-1.032465,-1.0532074,-1.0655692,-1.1294339,-1.18566,-1.2838087,-1.3308494,-1.4033498,-1.4099527,-1.2531561,-1.1468735,-1.3066047,-1.1818024,-0.99565796,-0.80601759,-0.61801128,-0.4415627,-0.28961461,-0.10248537,0.048289217,0.22618881,0.36536846,0.50094092,0.6609642,0.8291613,1.0176242,1.2049015,1.3460565,1.5340092,1.6765451,1.8142814,2.005188,2.1462078,2.2888245,2.4330594,2.5790209,2.6276445,2.6001344,2.4948109,2.3504316,2.2134842,2.0240066,1.9048925,1.7897306,1.6571674,1.4695163,1.3324794,1.2365356,1.0538304,0.86576188,0.67746381,0.48910545,0.30165653,0.16235538,-0.02296407,-0.16491065,-0.31572958,-0.45338677,-0.58022771,-0.71857041,-0.90708526,-1.0454189,-1.2164576,-1.3207772,-1.4862733,-1.6441878,-1.6012659,-1.7161744,-1.7676076,-1.654987,-1.6233965,-1.5579172,-1.4879549,-1.4031487,-1.3213861,-1.2227959,-1.1405062,-1.0541202,-0.9558614,-0.82839704,-0.73091566,-0.61838728,-0.52050315,-0.41227513,-0.33555983,-0.34713875,-0.324644,-0.23047626,-0.10158895,0.020396719,0.14385931,0.11971353,0.024802335,0.16009896,0.27775446,0.35028932,0.40988209,0.5407841,0.60718933,0.70653043,0.77498617,0.69324367,0.56495335,0.42767495,0.29610491,0.16635975,0.044178911,-0.069995758,-0.20782492,-0.34370966,-0.46071252,-0.47646544,-0.46043099,-0.39864837,-0.32756158,-0.27820488,-0.21017225,-0.11064928,-0.033762745,-0.1345787,-0.28097093,-0.32155798,-0.26653217,-0.1638442,-0.096152873,0.074721741,0.17488123,0.23121498,0.3217691,0.3836864,0.50300207,0.56114881,0.49450397,0.35599249,0.22420929,0.1018738,-0.0301613,-0.097903297,-0.0032068666,0.094751114,0.12215701,0.19120192,0.27106412,0.16866039,0.18386048,0.27608635,0.39109237,0.48072022,0.58636209,0.6988127,0.68810135,0.60321275,0.6736509,0.76100818,0.76171492,0.88419088,1.0004649,1.1119001,1.1764427,1.1821038,1.3077114,1.4444578,1.5466733,1.6595814,1.7624497,1.8377772,1.7565703,1.6224244,1.440575,1.2942751,1.1542777,1.006565,0.83131775,0.71271258,0.56011342,0.41543216,0.3568294,0.23134942,0.085280339,-0.064477654,-0.17805852,-0.32863219,-0.4741931,-0.61591255,-0.59281163,-0.60011264,-0.73166766,-0.89667459,-1.0392521,-1.1978538,-1.3379508,-1.466342,-1.6167289,-1.7533291,-1.8932261,-2.044029,-2.1680421,-2.0696466,-1.9468374,-1.8312463,-1.6853844,-1.5676376,-1.4396402,-1.3449889,-1.3028812,-1.281797,-1.3625433,-1.2726939,-1.227704,-1.1075087,-0.97600375,-0.85350134,-0.75719416,-0.6043054,-0.46259776,-0.45632366,-0.4909362,-0.33244438,-0.18771553,-0.093841439,-0.032423271,-0.025560665,-0.13575846,-0.24063395,-0.35622426,-0.44286712,-0.42531547,-0.33702334,-0.24256135,-0.11675828,-0.041223942,-0.0013797065,0.18156418,0.26848032,0.38698851,0.497731,0.6053612,0.67512112,0.59865517,0.56234724,0.71062091,0.86128074,0.99457338,1.1271571,1.1747339,1.2911197,1.4258344,1.5613976,1.6980455,1.833853,1.9717577,2.1093978,2.2277169,2.2438405,2.1370159,2.0004784,1.8288316,1.6786385,1.491864,1.3555725,1.2416562,1.1078626,0.94567536,0.76065921,0.63686101,0.68276871,0.5905415,0.44340556,0.31079402,0.12913841,0.02395752,0.039535446,-0.13494439,-0.31894448,-0.3930061,-0.30685639,-0.23040074,-0.15413383,-0.031997699,0.090616937,0.17058242,0.10976487,-8.3115072E-4,-0.13366209,-0.21505845,-0.38571786,-0.46108214,-0.46998031,-0.55992098,-0.70783332,-0.85790134,-0.99824193,-1.1397236,-1.2783628,-1.2394308,-1.1700772,-1.2686943,-1.3911729,-1.5486239,-1.6855314,-1.844718,-1.9737453,-2.1107691,-2.1687392,-2.0511937,-1.9145675,-1.7716933,-1.6272809,-1.5012171,-1.3597035,-1.2238998,-1.0903391,-0.96225393,-0.81718814,-0.67106591,-0.54623142,-0.51240314,-0.50552944,-0.39156426,-0.25383534,-0.11608304,0.014588651,0.13709384,0.28456932,0.40938744,0.50684685,0.64621966,0.79316235,0.92930514,1.0750659,1.1971047,1.3402555,1.4858986,1.5493794:3
1.6753635,1.6240292,1.5549264,1.4878988,1.4309776,1.3574928,1.2810676,1.2154652,1.1661674,1.1187185,1.0825881,1.0524373,1.0140054,0.97317819,0.9031108,0.83853537,0.75993885,0.68053908,0.58982246,0.49537136,0.40079348,0.3047069,0.18399463,0.059970367,-0.033955754,-0.13814933,-0.26727443,-0.37303895,-0.47870718,-0.58836627,-0.687313,-0.80419913,-0.90898045,-1.0258471,-1.1316769,-1.2455915,-1.3641533,-1.477075,-1.5581551,-1.6170625,-1.5966031,-1.4965913,-1.4064039,-1.3105567,-1.21548,-1.123196,-1.030789,-0.9388207,-0.83605339,-0.74469302,-0.64666784,-0.55814096,-0.47101387,-0.37272319,-0.27595854,-0.1789992,-0.083865619,0.0063577478,0.11417571,0.20982731,0.28379363,0.3222125,0.35660458,0.44216226,0.50491103,0.53132401,0.54185518,0.56647817,0.59010975,0.62403884,0.64864459,0.64306813,0.68104629,0.70899028,0.71391338,0.72238614,0.70383368,0.67810355,0.64490486,0.63719255,0.62623313,0.64746035,0.67990524,0.68203381,0.6809221,0.63690806,0.57964251,0.5097767,0.43645269,0.36148702,0.27880607,0.19231061,0.099507493,0.0424111,-0.025763099,-0.082644816,-0.14562729,-0.20782112,-0.27232078,-0.3339768,-0.40160549,-0.46836804,-0.53568505,-0.6018571,-0.67335006,-0.73573994,-0.78314627,-0.84544075,-0.9053578,-0.95374449,-1.013378,-1.0582146,-1.1231958,-1.169727,-1.2376442,-1.3110254,-1.389588,-1.4132174,-1.4943403,-1.5651479,-1.6244907,-1.6513402,-1.6476664,-1.5937689,-1.5578182,-1.5527775,-1.5701918,-1.5668926,-1.5461448,-1.4837029,-1.3954,-1.3176987,-1.2321584,-1.1749856,-1.1272409,-1.0972455,-1.0082352,-0.92042141,-0.82100639,-0.76723629,-0.78793057,-0.74182071,-0.64943192,-0.55723967,-0.46848605,-0.38064326,-0.31678708,-0.25397662,-0.20093482,-0.13039735,-0.066105518,0.0079034672,0.071994847,0.10497201,0.11952161,0.12456037,0.042241454,-0.013036402,-0.027703596,-0.065050093,0.0034574116,0.084785747,0.20179923,0.28820722,0.37197344,0.43064531,0.50733024,0.56354023,0.637449,0.70209873,0.75568577,0.80715732,0.82653557,0.85331367,0.84902907,0.91916364,1.0324033,1.1219172,1.2200771,1.333209,1.401339,1.4719617,1.5631374,1.6870818,1.7912653,1.8901475,1.9791625,2.0324875,2.0507578,2.0363737,1.993147,1.9164113,1.8343341,1.7052557,1.5949683,1.4825605,1.3704427,1.2787971,1.2201705,1.1832873,1.1303715,1.1186847,1.1236025,1.1255714,1.1235209,1.1277625,1.1218166,1.1221874,1.087086,1.0494809,1.0031201,0.94634046,0.88897811,0.83559911,0.77035605,0.71182654,0.66986308,0.66050892,0.65318643,0.62073288,0.57960883,0.53673437,0.47886863,0.42349698,0.33535377,0.23028493,0.1387627,0.063106137,0.0012603834,0.012227184,0.0096087809,0.012856402,0.043173943,0.055805768,0.051735136,0.09969987,0.129412,0.12730117,0.14320454,0.15257788,0.14876314,0.15834143,0.18589139,0.22361196,0.25221597,0.27668141,0.28756876,0.32022117,0.34865574,0.36461536,0.4005774,0.4143115,0.45445645,0.49581611,0.48843397,0.53895642,0.5518048,0.58380623,0.58870712,0.60795442,0.62341268,0.61780181,0.60779547,0.56152953,0.46447751,0.37505955,0.27837736,0.18444089,0.093388222,-0.006936958,-0.10920456,-0.21010399,-0.30731008,-0.40114583,-0.47280629,-0.5731125,-0.63279568,-0.73488738,-0.80339179,-0.89782701,-1.0117491,-1.0820467,-1.1847619,-1.2309596,-1.2592647,-1.3020833,-1.3844323,-1.4891849,-1.5168247,-1.5623549,-1.642564,-1.7402037,-1.8244694,-1.9295595,-1.9857644,-1.9948796,-1.9668546,-1.9789955,-1.9365703,-1.9128626,-1.8712179,-1.8334676,-1.7984647,-1.744375,-1.6958677,-1.6539833,-1.6108349,-1.5666317,-1.5185361,-1.4709192,-1.4193121,-1.3560407,-1.3281551,-1.2791299,-1.2317105,-1.1770168,-1.1276339,-1.0898269,-1.0242947,-0.95501619,-0.88513215,-0.80546682,-0.73375927,-0.65802508,-0.57895274,-0.50993354,-0.42379758,-0.35120088,-0.2694574,-0.1847708,-0.11252644,-0.040260963,0.032058963,0.076273232,0.062940288,0.034197331,0.042525158,0.10716866,0.1833651,0.25285982,0.31625433,0.39259581,0.46093384,0.53147187,0.60108734,0.65630125,0.67264621,0.65296403,0.61533212,0.55219612,0.47602163,0.36688312,0.24997324,0.15243284,0.048920586,-0.021735101,-0.095693373,-0.18573451,-0.28090248,-0.31638552,-0.393812,-0.46800284,-0.56229901,-0.65444403,-0.75987323,-0.84338516,-0.90659322,-0.95420121,-1.0011139,-1.0769856,-1.1603883,-1.2085503,-1.2680246,-1.331917,-1.340629,-1.3988848,-1.3466464,-1.2394389,-1.1629041,-1.0529216,-0.94556598,-0.83694026,-0.73400027,-0.64068225,-0.52712394,-0.42001717,-0.30629389,-0.18687091,-0.11239474,-0.0061634878,0.098997112,0.22625993,0.34869773,0.4393925,0.5194162,0.48234614,0.55756085,0.66373786,0.7486937,0.864511,0.95795656,1.0520506,1.1458495,1.2337824,1.29877,1.3640936,1.4158744,1.4676343,1.522062,1.5635669,1.6175019,1.6718669,1.7366213,1.7671877,1.7439449,1.7220856,1.7036428,1.6876112,1.6750556,1.6654818,1.6588609,1.6552849,1.6544345,1.6572989,1.6626996,1.6713753,1.6712309:2
1.5309398,1.5361992,1.5505162,1.5555196,1.5415693,1.5093678,1.474759,1.4517491,1.4235878,1.395783,1.3698866,1.3379109,1.2822431,1.2511071,1.1815698,1.1548806,1.123668,1.0864165,1.0637059,1.0605657,1.0796113,1.1065776,1.1454325,1.1803047,1.2016089,1.2320899,1.2737695,1.3031348,1.2996564,1.2850363,1.2684817,1.2461058,1.2171026,1.1935954,1.1444149,1.0961301,1.0644254,1.005679,0.93871359,0.90941014,0.85659244,0.78863861,0.7262831,0.66253717,0.60498758,0.57223488,0.54462684,0.50718693,0.49469114,0.46850464,0.46646636,0.46741212,0.46161511,0.46713743,0.49794889,0.47707664,0.48462479,0.49287317,0.47264002,0.43669554,0.39224119,0.34548981,0.28825892,0.22165115,0.19627081,0.12992444,0.084754559,0.016852013,-0.016842205,-0.090181307,-0.14286371,-0.19700422,-0.24738558,-0.32127579,-0.35780081,-0.41381413,-0.48191919,-0.53628425,-0.58892311,-0.63502959,-0.69302274,-0.7569905,-0.82866554,-0.88833852,-0.93875238,-1.0165727,-1.0643838,-1.111101,-1.1618876,-1.2115239,-1.2327454,-1.2420039,-1.2352647,-1.2009641,-1.1840729,-1.1565593,-1.1272461,-1.1029458,-1.0890793,-1.0655784,-1.0432508,-1.0364859,-1.0468262,-1.0482893,-1.0597131,-1.0727952,-1.1047908,-1.1310532,-1.1568449,-1.1998281,-1.2324698,-1.2641951,-1.2943197,-1.3301417,-1.371786,-1.3979161,-1.4404803,-1.474647,-1.5143413,-1.5458494,-1.5662838,-1.6043805,-1.6145639,-1.6337247,-1.6699184,-1.6835827,-1.7092708,-1.7329535,-1.7465293,-1.7858519,-1.8013619,-1.8327383,-1.8739786,-1.8973994,-1.8846401,-1.840488,-1.7416945,-1.6874557,-1.6382747,-1.5852616,-1.5048495,-1.4382218,-1.3584798,-1.3070584,-1.2305773,-1.162694,-1.074584,-0.99806836,-0.94084311,-0.89677989,-0.82055529,-0.79197422,-0.77189299,-0.72036105,-0.70438686,-0.67460534,-0.63364247,-0.59269009,-0.56201046,-0.54348605,-0.51791378,-0.49163251,-0.4614388,-0.44398827,-0.41310384,-0.4027229,-0.39645079,-0.35337771,-0.34183265,-0.25184694,-0.21498769,-0.17558955,-0.14629045,-0.087728432,-0.03559941,0.017742911,0.064892554,0.15049761,0.19442994,0.27300237,0.32213591,0.41646319,0.45518131,0.54951741,0.64368382,0.73774637,0.83149736,0.92520413,1.0187705,1.1123556,1.205977,1.299529,1.3931403,1.4441277,1.5247856,1.6183438,1.7120616,1.7647924,1.8442783,1.9380304,2.0063944,2.0706273,2.1644955,2.2274126,2.2729286,2.3021754,2.2822066,2.2624706,2.230281,2.1878831,2.1002447,2.0066996,1.9126391,1.8330788,1.7821228,1.6898783,1.5975453,1.5051232,1.4124191,1.3195672,1.2706062,1.190755,1.0982136,1.0052393,0.91374175,0.82210403,0.75592655,0.69251229,0.60276864,0.51292561,0.4765269,0.38865051,0.31640678,0.26618155,0.18335307,0.14322119,0.070417218,0.027765763,-0.034898447,-0.084298537,-0.11993344,-0.18423175,-0.21863853,-0.23593865,-0.24660048,-0.26107364,-0.26554011,-0.26955824,-0.28176242,-0.28366423,-0.29443054,-0.30027177,-0.30455839,-0.30628503,-0.30996651,-0.32108867,-0.30612503,-0.30234381,-0.3081312,-0.29427127,-0.31165082,-0.30511841,-0.30320322,-0.32021505,-0.33764138,-0.36072146,-0.36380416,-0.36619872,-0.3731382,-0.38602963,-0.40739047,-0.4338793,-0.46065286,-0.52096304,-0.58749623,-0.66411868,-0.72253686,-0.77394938,-0.83300807,-0.91776004,-0.98404288,-1.0428704,-1.1158581,-1.1763911,-1.2355317,-1.2918559,-1.3069414,-1.3032998,-1.2991244,-1.2824532,-1.2542205,-1.2234224,-1.1812382,-1.1479323,-1.1121521,-1.0708404,-1.0371101,-1.0068936,-0.96620998,-0.92317968,-0.88906315,-0.84072609,-0.80408491,-0.76656361,-0.73083,-0.695236,-0.66247384,-0.6328202,-0.60450381,-0.56776491,-0.52982188,-0.51244695,-0.48439961,-0.46737862,-0.43326885,-0.4058435,-0.38284311,-0.36417487,-0.32840368,-0.31429514,-0.2856509,-0.26158355,-0.24556002,-0.23355204,-0.22369465,-0.22204036,-0.23086775,-0.23426932,-0.25791083,-0.26974915,-0.29227816,-0.3149399,-0.34518124,-0.38406347,-0.42038392,-0.45360458,-0.52193203,-0.58644276,-0.62493965,-0.70297771,-0.77637409,-0.80356948,-0.87633413,-0.90606206,-0.97260092,-0.97244746,-0.96682533,-0.95676524,-0.93975303,-0.89840513,-0.88657874,-0.84705688,-0.78715137,-0.72030608,-0.65534415,-0.59251135,-0.52554811,-0.46145504,-0.40354444,-0.33926037,-0.29152291,-0.25160294,-0.19953667,-0.17627317,-0.11638723,-0.080157535,-0.029472997,0.037031765,0.062782516,0.12611847,0.16474956,0.21296057,0.25876725,0.30485927,0.36291,0.39695605,0.45710622,0.49241354,0.54702469,0.58349487,0.62123191,0.65240655,0.67858262,0.67746914,0.68734828,0.68631459,0.67721743,0.66412899,0.65965886,0.63479423,0.5929894,0.56267759,0.54891721,0.56277815,0.54694475,0.5122948,0.51907629,0.51458689,0.52559921,0.53400006,0.56982642,0.59971799,0.62143068,0.67120448,0.69192401,0.73581065,0.78840424,0.84022357,0.88461922,0.91960534,0.974154,1.0138515,1.0614967,1.1107866,1.1362619,1.1777307,1.2081573,1.2532855,1.3091813,1.3354918,1.3778124,1.4093751,1.4529386,1.4746695,1.497517,1.5277094,1.5312142:2
2.0546226,1.9533595,1.8519025,1.7659056,1.6607201,1.5680114,1.4479186,1.3429688,1.2375491,1.1307974,1.0269011,0.92018939,0.995334,1.1114859,1.2156499,1.3257478,1.4246762,1.5295455,1.6311638,1.5661699,1.4826934,1.3889669,1.3104054,1.2277398,1.1391904,1.0552495,0.95068305,0.87886606,0.7956794,0.70698041,0.62432906,0.53205583,0.4471523,0.35880064,0.25536199,0.16509,0.06040848,-0.028883596,-0.13095001,-0.23386406,-0.3326584,-0.42457321,-0.5258745,-0.62988988,-0.74797927,-0.86643828,-0.98140845,-1.0422818,-1.0235009,-0.92392039,-0.84976108,-0.76771395,-0.6863766,-0.61317277,-0.54388366,-0.51819094,-0.45247575,-0.38762647,-0.3401008,-0.35503545,-0.29646035,-0.28678442,-0.261404,-0.20769126,-0.19404936,-0.14847235,-0.1222673,-0.13214332,-0.13445282,-0.10682429,-0.065132557,-0.079371999,-0.026073185,-0.078865216,-0.07080009,-0.046170055,-0.022599381,-0.069061601,-0.16343411,-0.23278567,-0.24282669,-0.2613355,-0.28179805,-0.29787495,-0.3231193,-0.35976408,-0.41352292,-0.5182271,-0.5867897,-0.60615243,-0.59434557,-0.5482558,-0.49341048,-0.44377322,-0.39605172,-0.3595676,-0.30575571,-0.2451282,-0.18348557,-0.12007514,-0.065275929,0.0052471338,0.042351868,0.10860804,0.18377201,0.2267668,0.22644077,0.24163138,0.34071604,0.43057539,0.50109034,0.41434778,0.29992564,0.19741497,0.10735854,0.077156758,-0.020351782,-0.072850954,-0.14737012,-0.22207424,-0.26706004,-0.34164165,-0.45142535,-0.51470732,-0.48568255,-0.39559222,-0.29102654,-0.20026785,-0.11611034,-0.021862333,0.059923615,0.15904816,0.24509597,0.2718131,0.32950429,0.41120685,0.52142234,0.54789523,0.62268324,0.71017881,0.81562723,0.84128461,0.84513674,0.93346074,1.0282539,1.0826977,1.0700462,1.1485123,1.2358822,1.302525,1.4141749,1.5429959,1.660356,1.7682546,1.8729132,1.9661881,2.0648322,2.1841617,2.2741453,2.208517,2.0939198,2.002535,1.9064053,1.7901511,1.7370118,1.7026302,1.5990626,1.4973338,1.5160746,1.4239727,1.3412491,1.2718929,1.3218076,1.283789,1.1912604,1.0901927,1.0185691,0.98490143,1.0479081,0.9538271,0.88505123,0.78900974,0.75732333,0.64623143,0.66477643,0.71450908,0.68920004,0.59102867,0.49477324,0.42082055,0.36197039,0.27925411,0.31165648,0.35152999,0.41181545,0.33629964,0.22270399,0.15294462,0.040594047,-0.010280124,-0.091415343,-0.12057944,-0.24141193,-0.30645911,-0.37574209,-0.44276491,-0.45622903,-0.36696031,-0.27881118,-0.2016207,-0.11059673,-0.021820982,0.060981666,0.080390348,0.18933927,0.27071534,0.37103565,0.46633978,0.55615527,0.61074343,0.51240303,0.42672026,0.35368529,0.25796562,0.23854365,0.13143238,0.058399593,0.086505852,-0.010349686,-0.11730782,-0.157227,-0.14570216,-0.15470122,-0.236918,-0.31595759,-0.38254055,-0.38973569,-0.36363429,-0.45636629,-0.55149428,-0.5878383,-0.68837795,-0.70445921,-0.79199011,-0.87505766,-0.95823386,-0.94170301,-1.0199321,-1.1109902,-1.1710029,-1.2724729,-1.2669167,-1.3675654,-1.4829953,-1.5888919,-1.6947746,-1.790483,-1.893126,-1.9969999,-2.0999177,-2.1987087,-2.3054997,-2.3945015,-2.4927296,-2.5794694,-2.6656596,-2.7052095,-2.6390742,-2.6075922,-2.4916465,-2.3838723,-2.2868175,-2.1544201,-2.0371375,-1.9251525,-1.7902905,-1.6733713,-1.6330073,-1.7011852,-1.7457637,-1.794938,-1.8339993,-1.888124,-1.9200426,-1.9205335,-1.9212673,-1.905367,-1.9139802,-1.8862504,-1.8371177,-1.8014404,-1.7360671,-1.6780697,-1.6180598,-1.5632839,-1.4958188,-1.434748,-1.341868,-1.2524249,-1.1680163,-1.0890121,-1.0005641,-0.91003515,-0.84192557,-0.76070252,-0.66206758,-0.56197579,-0.48754547,-0.40518834,-0.31231786,-0.2460178,-0.1622232,-0.074528414,0.011825411,0.068193787,0.1435387,0.23153352,0.31505079,0.40779588,0.50022064,0.5916991,0.53244655,0.47602584,0.41402934,0.32907687,0.32413443,0.25089322,0.20959163,0.16733009,0.10300695,0.14156439,0.088062002,0.038358485,0.009001934,0.0036202436,0.053873242,0.015448088,0.0010736446,-0.012583928,0.089228781,0.060539186,0.047082709,0.010614441,0.026948494,0.0077915807,-0.052467399,-0.038079601,0.063719068,0.15513523,0.12412556,0.077207203,0.11376234,0.038309938,0.093884517,0.05865403,0.013937275,0.045125511,0.14125247,0.22256832,0.19838718,0.16038828,0.12873726,0.16571332,0.10040993,0.062267992,0.13011844,0.075373895,0.024386701,0.0039434481,-0.001539635,-0.037256729,-0.080414351,-0.10866504,-0.067773362,-0.11428212,-0.19476614,-0.21968502,-0.23298563,-0.20435256,-0.28030849,-0.32260492,-0.39274295,-0.35636683,-0.4217334,-0.4606614,-0.538459,-0.61675722,-0.70683391,-0.79417007,-0.84746085,-0.84730088,-0.79208466,-0.76527915,-0.64827382,-0.61898726,-0.53621952,-0.45037922,-0.35124038,-0.25113219,-0.1526539,-0.061645685,0.033630978,0.13106544,0.22440143,0.32967273,0.4314029,0.51045637,0.59972223,0.70205124,0.73825335,0.81413991,0.91595754,0.99157095,1.063342,1.1458304,1.2326032,1.3152106,1.4048948,1.5020067,1.5180713,1.5682006,1.6501272,1.7490924,1.8014814,1.885826,1.9683255,2.0269943:6
0.2647345,0.27060587,0.25614668,0.23174915,0.19974174,0.1494414,0.10346151,0.04460656,-0.016311806,-0.087614593,-0.17243585,-0.23380912,-0.31980137,-0.39162685,-0.48853857,-0.56480384,-0.65884531,-0.72560267,-0.7503426,-0.66934118,-0.54686108,-0.46689373,-0.37004128,-0.27923256,-0.1699509,-0.08575788,0.012043626,0.1061886,0.20661084,0.31057839,0.39983947,0.49862349,0.59561407,0.66467692,0.72486858,0.80435849,0.90313209,0.95513686,1.0467598,1.0939778,1.1399918,1.169224,1.200606,1.2084469,1.2217398,1.2296868,1.2015778,1.172494,1.102775,1.0259306,0.94929402,0.88385075,0.80446888,0.71489573,0.63151158,0.55927213,0.4789555,0.40852038,0.33232712,0.25266801,0.16858992,0.082138486,0.0048108371,-0.060952747,-0.078596178,-0.16545565,-0.23304084,-0.2426609,-0.19429492,-0.12406555,-0.051095008,0.025054026,0.096747185,0.18618086,0.27934483,0.33362186,0.42955617,0.5199994,0.55942603,0.65543271,0.73492899,0.79243015,0.83521319,0.91024746,0.97351258,1.0473136,1.0902096,1.1314558,1.1655275,1.1918315,1.2136473,1.1976559,1.187958,1.1763696,1.1628952,1.1286348,1.0777933,1.0342016,0.9577286,0.92248536,0.86212739,0.8213832,0.7471393,0.66764937,0.59322327,0.52152806,0.60604625,0.51549009,0.45743245,0.38346734,0.29819456,0.24402295,0.15681995,0.059871867,-0.014217254,-0.08567719,-0.17770949,-0.22475745,-0.33723581,-0.36536018,-0.41684655,-0.47452301,-0.58325354,-0.48245855,-0.54363445,-0.6564903,-0.67110745,-0.76095161,-0.82215024,-0.94029328,-0.97091377,-1.0364406,-1.1137818,-1.2367497,-1.2993103,-1.382497,-1.5028184,-1.6105635,-1.7286533,-1.8440075,-1.8834351,-1.9574243,-2.0101177,-2.0931845,-2.1431871,-2.2432055,-2.3275272,-2.4288986,-2.5289504,-2.6323164,-2.6947265,-2.698954,-2.6302733,-2.5589448,-2.4375874,-2.3544408,-2.2205137,-2.1329304,-1.9967753,-1.9042728,-1.772682,-1.6824661,-1.5454067,-1.4577145,-1.3230538,-1.2348697,-1.0983216,-0.98362833,-0.88194277,-0.74782292,-0.61582722,-0.48723896,-0.36263424,-0.24163048,-0.16162395,-0.037507044,0.08797037,0.16498199,0.25706458,0.3633481,0.48747643,0.56339515,0.6738055,0.71521617,0.81961818,0.85167541,0.90340793,0.96077379,0.99314162,1.0599091,1.1157337,1.1663667,1.240288,1.2762077,1.3222671,1.3717114,1.3955841,1.3907965,1.3871808,1.3693628,1.3343412,1.2918665,1.248728,1.2068211,1.1582386,1.1155844,1.0680621,1.0254264,0.97684708,0.94119631,0.89921455,0.84508469,0.79603625,0.73395335,0.68995368,0.63200206,0.56138646,0.50875563,0.4528011,0.39222015,0.33904391,0.29626102,0.2382047,0.18824955,0.13478398,0.071726629,0.022024146,-0.023411451,-0.072608417,-0.11692473,-0.17154118,-0.21619509,-0.27239767,-0.33026112,-0.37118606,-0.41931982,-0.4634873,-0.501077,-0.54961007,-0.59928797,-0.65721009,-0.72466224,-0.78154761,-0.85605748,-0.91982478,-1.0095451,-1.0779161,-1.1367379,-1.2176142,-1.2633815,-1.2938299,-1.3520067,-1.416217,-1.3402594,-1.2420053,-1.1555689,-1.0619056,-0.96110923,-0.85490307,-0.76703821,-0.67142958,-0.57811551,-0.46913637,-0.35918676,-0.26617984,-0.1673628,-0.06201402,0.02891125,0.0877782,0.13677101,0.18511924,0.22692702,0.24907387,0.25792795,0.27337603,0.27872264,0.28406569,0.29293362,0.29932609,0.31965214,0.33153132,0.3439753,0.36000252,0.38369599,0.38787435,0.37316049,0.36990165,0.38145365,0.36867349,0.34947599,0.32447096,0.25720006,0.22310463,0.27315779,0.31492179,0.35354391,0.38121004,0.41019099,0.43960276,0.45020367,0.47856904,0.48240158,0.4896547,0.50325044,0.53947046,0.56699175,0.58768404,0.60913144,0.63965692,0.67451936,0.71192693,0.73886717,0.76717364,0.79740687,0.81243183,0.82117423,0.85830744,0.88908586,0.91472398,0.91470963,0.89861027,0.88747538,0.88955154,0.96551149,1.0379007,1.1066231,1.1908256,1.2877891,1.3872606,1.4831912,1.5743751,1.6756402,1.7856851,1.8813003,1.9506822,1.9696465,2.0177804,2.0586293,2.0080483,1.9094979,1.7962975,1.692238,1.5995668,1.4781015,1.3832997,1.30293,1.1809516,1.0774625,0.98677621,0.92735933,0.82584962,0.73975916,0.71072554,0.64081632,0.58272007,0.53573545,0.4321864,0.40215823,0.32058308,0.20636544,0.11089325,0.021683038,-0.047052245,-0.12677874,-0.21344122,-0.25337844,-0.29587632,-0.33567799,-0.37678804,-0.45068098,-0.49032315,-0.51312709,-0.53456618,-0.62441824,-0.68365351,-0.60102769,-0.569195,-0.63994853,-0.67564682,-0.73156742,-0.79231576,-0.87373756,-0.93528328,-0.95654792,-1.0189907,-1.0953923,-1.155137,-1.2459363,-1.2986748,-1.3688081,-1.4124732,-1.4689483,-1.5064957,-1.5491525,-1.5815928,-1.636362,-1.6881736,-1.7458084,-1.7746308,-1.8312684,-1.8679926,-1.7882816,-1.696817,-1.608435,-1.5148833,-1.4052459,-1.299276,-1.2016634,-1.1089137,-1.0168325,-0.9380736,-0.84096975,-0.78123768,-0.6841635,-0.60192182,-0.51248362,-0.44262898,-0.36102599,-0.29031961,-0.20548835,-0.13789618,-0.066920008,-0.005464822,0.075999592,0.12459438,0.18839318,0.23918435:2
0.086027264,0.010805171,-0.06558231,-0.13726596,-0.20892266,-0.28688613,-0.37541319,-0.4600772,-0.53930955,-0.60889153,-0.69453128,-0.78349226,-0.85498862,-0.9306793,-1.0113321,-1.0780743,-1.1190894,-1.145649,-1.1543504,-1.1624653,-1.1548643,-1.1282936,-1.0720975,-1.0309814,-0.96710509,-0.89898623,-0.80637116,-0.71493222,-0.64194491,-0.54281697,-0.46497509,-0.38411651,-0.3026115,-0.20790941,-0.13137076,-0.0355017,0.043336969,0.12445707,0.2225535,0.29876965,0.31624233,0.36790469,0.45342026,0.53329897,0.61536227,0.69428505,0.76930142,0.84265895,0.91988773,0.91006596,0.84082907,0.77868535,0.71721693,0.66121712,0.59529545,0.54670315,0.49865925,0.45141701,0.41360335,0.38000304,0.37591199,0.39365888,0.44372285,0.50270941,0.60102667,0.67684346,0.75337131,0.85086082,0.92800878,1.0048785,1.0807882,1.1698774,1.2501102,1.3087598,1.3843998,1.462131,1.5101611,1.4742319,1.4887926,1.5410385,1.6276007,1.708991,1.7877891,1.8668336,1.8608454,1.8084824,1.747739,1.6681377,1.5983616,1.5318841,1.4591393,1.3982787,1.3469871,1.3272319,1.3334699,1.3739639,1.4305325,1.4943173,1.4262457,1.3252121,1.2478084,1.2260489,1.1413658,1.0657232,0.98927505,0.89022308,0.81225519,0.73339464,0.6480201,0.55564887,0.47150906,0.38001078,0.30611663,0.23608326,0.18588645,0.13512668,0.071798163,0.021195699,-8.4232906E-4,-0.022688511,-0.033921917,-0.029244015,-0.015466116,0.019292535,0.062605765,0.12141804,0.18604971,0.24307823,0.3088636,0.37193219,0.42697908,0.49992999,0.55962234,0.61858768,0.5530143,0.48026513,0.40355962,0.33032358,0.2371981,0.15766763,0.076040538,-1.3872003E-4,-0.082938489,-0.1532397,-0.17977109,-0.14790663,-0.18529157,-0.26375176,-0.34321041,-0.41344024,-0.49377873,-0.56684555,-0.6365118,-0.71681305,-0.79637151,-0.87292713,-0.94927389,-1.0248326,-1.0999148,-1.1640507,-1.2454739,-1.3170195,-1.3890075,-1.4604559,-1.5299534,-1.5949186,-1.6638901,-1.7244859,-1.7865273,-1.8434906,-1.8931429,-1.9081048,-1.9081794,-1.9072235,-1.9116787,-1.900705,-1.8831056,-1.8550888,-1.8149451,-1.7533215,-1.6646632,-1.5618699,-1.4812141,-1.3990004,-1.3178597,-1.2373942,-1.1581407,-1.107541,-1.0540084,-0.97745312,-0.89750299,-0.79477496,-0.69184659,-0.70650864,-0.76298291,-0.82072235,-0.86536636,-0.90005047,-0.92779776,-0.91955736,-0.91214518,-0.86020681,-0.87885309,-0.89796845,-0.91933322,-0.94125597,-0.95303237,-0.97535662,-0.99307254,-1.0140258,-1.0334221,-1.0453055,-1.0618476,-1.0783464,-1.0845601,-1.0846676,-1.0837231,-1.0872106,-1.0758546,-1.0636928,-1.0500761,-1.0390637,-1.027247,-0.97585718,-0.92025623,-0.84546068,-0.77306277,-0.7203296,-0.65726006,-0.58446776,-0.51570961,-0.44260819,-0.36967659,-0.29813922,-0.23424582,-0.1570793,-0.0844989,-0.01439129,0.055793906,0.12221741,0.19784577,0.26617921,0.33215715,0.40101927,0.47483621,0.54119571,0.61602961,0.59409014,0.56139577,0.54142737,0.51070579,0.49418158,0.48876046,0.50515485,0.56389652,0.64445423,0.67074523,0.67635986,0.69015569,0.70591703,0.7215942,0.74154837,0.74971767,0.76771158,0.77755707,0.79627365,0.83047065,0.86426595,0.89965837,0.92695582,0.9602911,1.0002309,1.0469292,1.1033164,1.187217,1.2678114,1.3496028,1.4346331,1.5173416,1.6024916,1.5930152,1.5948044,1.5955783,1.5986244,1.59831,1.5910815,1.582101,1.5656547,1.5434312,1.5199388,1.498149,1.4668569,1.4315338,1.4010571,1.358539,1.3199445,1.2771885,1.2267846,1.1856404,1.1769322,1.2085785,1.2719538,1.3474547,1.28709,1.1985736,1.2883562,1.2381842,1.1602534,1.1167193,1.1004274,1.1082835,1.1237083,1.1410887,1.161362,1.1719423,1.1783035,1.1700211,1.1651151,1.1508049,1.1455526,1.1312521,1.1155414,1.0967589,1.0797336,1.0529971,1.0302661,1.0021373,0.97044367,0.94341516,0.92456701,0.91465545,0.91915313,0.97352053,0.93165404,0.87459324,0.80913483,0.74884975,0.68786784,0.63001686,0.55955287,0.48993913,0.39960798,0.33012533,0.26688773,0.18119899,0.1174354,0.064077301,0.013736534,-0.039510221,-0.098223431,-0.13291559,-0.18650432,-0.23861677,-0.28731682,-0.33944751,-0.38719851,-0.42817199,-0.46428166,-0.47593469,-0.48003185,-0.47069391,-0.45341527,-0.41582383,-0.3764619,-0.42542696,-0.47015654,-0.54267142,-0.61750069,-0.68346989,-0.75919821,-0.82824044,-0.90668264,-0.9769765,-1.0492056,-1.1179556,-1.2014917,-1.2654196,-1.3340682,-1.4042561,-1.4681145,-1.5043667,-1.5368351,-1.5548337,-1.5632913,-1.5718468,-1.57886,-1.5751472,-1.5631017,-1.5479139,-1.5205698,-1.4968569,-1.4653793,-1.4435585,-1.4171692,-1.3969754,-1.37468,-1.3421186,-1.3128135,-1.2848876,-1.2510784,-1.2173341,-1.1762699,-1.1303408,-1.0808064,-1.0332773,-0.97896345,-0.9298291,-0.87248277,-0.82128837,-0.76361398,-0.70902819,-0.65838778,-0.60715506,-0.55929392,-0.4997514,-0.45750381,-0.51097491,-0.49228943,-0.43840672,-0.38611246,-0.32480574,-0.26204832,-0.20289382,-0.14318716,-0.079098362,-0.013570499,0.054267787:4
1.2782765,1.1255819,0.93002796,0.73450185,0.55042293,0.44544238,0.40108488,0.28948654,0.11067964,-0.052728761,-0.23074596,-0.29412665,-0.4391566,-0.59214804,-0.58832185,-0.45602796,-0.31999372,-0.16595785,-0.05908775,0.07645638,0.1029949,0.17626967,0.30634443,0.45796846,0.57618087,0.70325496,0.83180519,0.84911078,0.89309774,1.0073408,1.1335424,1.2127529,1.2893908,1.4472624,1.4891241,1.638079,1.6575561,1.6229065,1.4854081,1.3345115,1.1712299,1.1660767,1.0982728,0.99902161,0.87997029,0.95300072,0.91126709,0.83330556,0.65914906,0.58897055,0.44799386,0.265921,0.15695833,0.012269766,-0.15858682,-0.17113732,-0.24306761,-0.32400955,-0.33175271,-0.29094652,-0.27983552,-0.40264824,-0.41546531,-0.3064593,-0.22943884,-0.21157549,-0.12296384,-0.26045835,-0.20031993,-0.17148501,-0.050127297,0.11399065,0.12668771,0.15607752,0.28552518,0.32213017,0.21233905,0.2142702,0.10638227,0.059456932,0.0088199425,-0.050830257,-0.18377752,-0.2940485,-0.42710668,-0.56066821,-0.67674168,-0.84390019,-0.88087831,-1.0037441,-0.9508742,-0.87358608,-0.72011342,-0.59278684,-0.40258308,-0.26647704,-0.087985734,0.054228331,0.2170399,0.29086863,0.46770264,0.58972136,0.74964029,0.83554433,0.99321252,1.1260028,1.2905206,1.4590852,1.6088801,1.7293734,1.7553107,1.6697156,1.6315202,1.5299112,1.374656,1.3106029,1.2065646,1.1613865,1.0094789,0.96323123,0.87604064,0.76965303,0.59908707,0.51062417,0.3902384,0.25110176,0.13519874,0.076649835,-0.024647458,-0.084561873,0.0051767261,0.12064947,0.26148908,0.35843646,0.53389586,0.60354603,0.69100646,0.81396786,0.96044468,1.0317379,1.1136022,1.2563759,1.4447951,1.6029774,1.7775593,1.7838045,1.6667942,1.5369841,1.416808,1.3424492,1.2436478,1.1698123,1.0618574,0.9786396,0.88338596,0.80026703,0.72893877,0.66804405,0.56186119,0.42311675,0.29660105,0.24562678,0.21678863,0.10835832,0.012521621,-0.10412554,-0.14417583,-0.18558822,-0.28686307,-0.44895907,-0.53992078,-0.64361491,-0.5599715,-0.47624279,-0.2727245,-0.17324127,-0.0076807744,0.12769546,0.21118746,0.35450619,0.45714853,0.67418848,0.79448606,0.71579918,0.59925197,0.47113317,0.40737377,0.28694128,0.15285922,0.12727034,-0.0011371382,-0.094456025,-0.18542288,-0.19752508,-0.24243443,-0.33521228,-0.45326821,-0.42631141,-0.38339517,-0.54132005,-0.48309466,-0.59557014,-0.69404564,-0.59063409,-0.67365746,-0.75302593,-0.79722696,-0.80492351,-0.8288078,-0.96117682,-1.0088705,-0.84332512,-0.63785406,-0.50156406,-0.33978077,-0.35140689,-0.21604016,-0.12611491,0.057948392,0.053997872,0.077077078,-0.041914234,-0.15110059,-0.21697762,-0.33360372,-0.427383,-0.42207409,-0.49662296,-0.62339012,-0.68927261,-0.77332626,-0.86220731,-0.98885319,-1.1104169,-1.244963,-1.1622654,-1.1928671,-1.2913749,-1.3879261,-1.5308921,-1.5875856,-1.714125,-1.8455302,-2.0151091,-2.1872531,-2.3060567,-2.4751429,-2.6290849,-2.7455278,-2.8787677,-2.7040751,-2.5819419,-2.4753842,-2.2796298,-2.1052539,-1.9362278,-1.7640286,-1.5725872,-1.3935463,-1.2139222,-1.190835,-0.99989295,-0.81726256,-0.63549904,-0.44839641,-0.30123844,-0.095490149,0.073769929,0.24176438,0.41915717,0.60269205,0.77146684,0.9648193,1.1195887,1.3022134,1.4963522,1.6675682,1.8365179,2.0252767,2.1960166,2.3691938,2.4655526,2.531522,2.4787297,2.3919891,2.216369,2.041648,1.8451622,1.6726039,1.5389739,1.3632205,1.173842,0.99737447,0.87244093,0.77999901,0.64191163,0.45975273,0.28428465,0.25041122,0.17800926,0.042228629,-0.019609598,-0.19625254,-0.38343696,-0.52366894,-0.65943815,-0.78905245,-0.93355109,-1.0943657,-1.181577,-1.2916726,-1.3779014,-1.4381429,-1.5200776,-1.6904182,-1.8793869,-1.9020162,-2.0708192,-2.2532603,-2.11805,-2.0637699,-2.2013913,-2.1276242,-1.9654227,-1.7871965,-1.709187,-1.5870682,-1.579442,-1.4261169,-1.2914347,-1.2009933,-1.0453563,-1.1450282,-1.2884841,-1.2754326,-1.1543375,-1.0125893,-0.89565204,-0.79117009,-0.7006599,-0.59680402,-0.49323441,-0.40432505,-0.32065887,-0.36993723,-0.26212133,-0.16510273,-0.070653528,0.015400533,-0.095526396,-0.017880975,0.093310398,0.17461557,0.26545039,0.3045373,0.39835438,0.49580745,0.47588349,0.31170422,0.12764997,-0.066862437,-0.13984801,-0.32670876,-0.52795555,-0.62506007,-0.79203181,-0.86189326,-0.73464499,-0.61263032,-0.51203738,-0.36814233,-0.26393831,-0.18388861,-0.054272285,0.019874815,-0.003065703,0.12951647,0.17199511,0.31678798,0.28852605,0.37777026,0.46363339,0.51045428,0.61477931,0.68718504,0.81092951,0.69395216,0.53786558,0.42975022,0.27591617,0.096340141,0.016598275,-0.16610567,-0.30572528,-0.37199052,-0.54409461,-0.70238497,-0.87693318,-1.0355182,-0.95325417,-0.7694258,-0.66107573,-0.55146111,-0.44934167,-0.36385621,-0.26711931,-0.14545674,-0.034447997,-0.11552542,-0.036210183,0.076963083,0.17477086,0.24208002,0.35570745,0.43824285,0.46954454,0.38131116,0.48268331,0.54653729,0.65165356,0.75596398,0.74884883,0.88272961,0.93621448,1.0562524,1.1391244,1.2564135:1
1.6151488,1.5445903,1.5036586,1.4378743,1.3626893,1.2804315,1.1980786,1.1461302,1.0908613,1.0597683,0.99646906,0.93879848,0.81676967,0.7325707,0.6573927,0.55982106,0.41637219,0.32563767,0.30174042,0.28676969,0.37248227,0.44787092,0.53778745,0.62320656,0.6704756,0.55558567,0.40832055,0.25730879,0.13629364,-0.044414408,-0.16206455,-0.29341875,-0.44019078,-0.61058054,-0.75112635,-0.88355306,-1.0156923,-1.15272,-1.3096124,-1.4565579,-1.5735488,-1.7331179,-1.872923,-1.8401269,-1.9712982,-2.0779933,-2.2088177,-2.2379505,-2.2605134,-2.2578194,-2.1665423,-2.0573612,-1.9236056,-1.7841269,-1.6475769,-1.5096223,-1.3584431,-1.2212491,-1.0845542,-0.94977588,-0.81313252,-0.67949218,-0.55524288,-0.42605328,-0.29422949,-0.1780529,-0.054107131,0.03172897,0.11114394,0.24886521,0.38247856,0.51213,0.64437962,0.77710291,0.89296265,0.96961762,1.0962448,1.2162012,1.3499333,1.4874766,1.6193308,1.7573173,1.8891398,1.9303692,1.8399962,1.7333066,1.6101039,1.4926239,1.3718114,1.2821842,1.2153819,1.148059,1.0792611,0.97709201,0.88413454,0.77305179,0.69404781,0.58373055,0.51251971,0.43318843,0.34168903,0.36195787,0.33176312,0.46543693,0.60242435,0.71487564,0.8200439,0.9137942,1.0300489,1.1417319,1.102918,1.0056433,0.91194158,0.79974102,0.67031296,0.54457724,0.43883985,0.37753832,0.27989364,0.17220841,0.11805915,-0.0051753845,-0.081100495,-0.17863727,-0.23545776,-0.33085868,-0.41991779,-0.54907388,-0.6576155,-0.68703048,-0.76216379,-0.85034132,-0.89273287,-0.94652221,-0.90408243,-0.87338119,-0.76858706,-0.58788697,-0.41502292,-0.31843833,-0.17826611,-0.049383665,0.059958092,0.19156252,0.31742397,0.39856395,0.50097925,0.62717834,0.74546773,0.8524285,0.98691295,1.0528464,1.1752097,1.3043519,1.4337274,1.5499831,1.4926464,1.3596674,1.2364715,1.103287,1.0891549,0.9747283,0.88653363,0.77163453,0.68772373,0.62476757,0.53048538,0.43166051,0.34092053,0.24055009,0.12534324,0.053905726,0.0078762198,-0.042612946,-0.054543097,-0.11274101,-0.21364149,-0.31308477,-0.41548145,-0.54736901,-0.67177926,-0.77989398,-0.89916185,-0.98593172,-1.1052109,-1.1230548,-1.029323,-0.95684108,-0.91823853,-1.0031833,-1.1026641,-1.2067765,-1.3225431,-1.4414788,-1.5389651,-1.6500969,-1.7061576,-1.6346964,-1.4679135,-1.3305831,-1.1781323,-1.0400796,-0.90818705,-0.77481812,-0.64070727,-0.5109031,-0.37933097,-0.2482488,-0.11788979,0.013161647,0.14505445,0.28902638,0.42409568,0.55732982,0.70523977,0.85081635,0.98893412,1.148399,1.2956227,1.443639,1.5946325,1.7493976,1.8153079,1.6736168,1.5171434,1.363406,1.2150318,1.0667819,0.91726902,0.76627339,0.61913028,0.47169169,0.3284719,0.19065897,0.045023254,-0.089544019,-0.22390755,-0.35629941,-0.49371099,-0.63313574,-0.76370536,-0.90757104,-1.0378351,-1.1886016,-1.3363624,-1.4949734,-1.6051172,-1.4979133,-1.4371057,-1.3740156,-1.2837867,-1.1613862,-1.0658124,-0.93423192,-0.84120414,-0.78561943,-0.68457265,-0.63367046,-0.60471232,-0.70481758,-0.86260556,-0.96540847,-0.99879534,-0.96858501,-0.90931694,-0.85612377,-0.7573894,-0.65791783,-0.5640998,-0.45340425,-0.34605592,-0.24951307,-0.16383079,-0.07940634,-0.12117786,-0.10972399,0.0068769201,0.11053356,0.22746747,0.30942489,0.40612466,0.49530737,0.55122755,0.64384483,0.74494541,0.84675235,0.97177427,1.1065482,1.2341139,1.3340863,1.2191552,1.0905835,0.96093278,0.83552895,0.70566636,0.57486095,0.44128583,0.31057968,0.18571487,0.053312063,-0.078709171,-0.21888271,-0.33534671,-0.4507891,-0.52872625,-0.65318073,-0.79351075,-0.90936806,-1.0128153,-0.97827978,-0.95579678,-0.95811987,-0.87928565,-0.74996759,-0.67255979,-0.59638491,-0.48777521,-0.4208242,-0.34468783,-0.26344095,-0.13897944,-0.01573146,0.093274098,0.19608013,0.30165657,0.40006342,0.4891,0.57351221,0.65329242,0.694428,0.56820957,0.50425107,0.37910221,0.29279724,0.1922774,0.16313443,0.27420654,0.35648252,0.42986034,0.50925942,0.58646419,0.6820688,0.73382434,0.79308785,0.87306203,0.9370066,1.0355829,1.1385256,1.2417825,1.3531591,1.471664,1.5951299,1.6562125,1.506709,1.3451485,1.2256948,1.0827201,0.9420755,0.81982498,0.66674626,0.54562814,0.37062105,0.24314946,0.16783001,0.15823003,0.065374772,-0.094185719,-0.21243757,-0.36617862,-0.50179805,-0.62406218,-0.74713302,-0.85643267,-0.94097839,-1.0622042,-1.1865477,-1.321535,-1.4292206,-1.5794253,-1.6915746,-1.8110037,-1.9041475,-1.9677829,-2.0674976,-2.1925203,-2.2766497,-2.2262401,-2.1143741,-1.9883034,-1.862508,-1.7414437,-1.6160247,-1.4907243,-1.3602383,-1.245967,-1.1124099,-0.98153834,-0.85303876,-0.72383216,-0.59094408,-0.45795762,-0.32328731,-0.19428413,-0.060497962,0.073070906,0.20992873,0.34683299,0.42909435,0.31808444,0.21829601,0.14604286,0.12993697,0.17539378,0.2873283,0.41127929,0.57242706,0.71788955,0.79405571,0.88238699,0.98323367,1.0896524,1.1848853,1.2591638,1.3893095,1.4835882,1.6005495,1.6444523:5
2.3359916,2.301691,2.2368608,2.1133994,2.0008664,1.9101437,1.790904,1.6733511,1.5725087,1.4729588,1.3923099,1.3557136,1.3150535,1.2377464,1.1372072,1.0677934,0.98438332,0.98760467,0.94544801,0.91845082,0.90471385,0.82930637,0.77728987,0.70079662,0.64785225,0.59842625,0.53143936,0.44870293,0.36397912,0.27284339,0.14720697,0.022399433,-0.1040547,-0.1875812,-0.22854574,-0.28109767,-0.31771032,-0.3516998,-0.39889665,-0.44498466,-0.49021852,-0.54750318,-0.60880969,-0.68493667,-0.75804864,-0.87467744,-0.97648718,-1.0690207,-1.1650157,-1.2463519,-1.3410892,-1.4052696,-1.4930742,-1.5041364,-1.5143251,-1.5162552,-1.5241583,-1.505834,-1.4879422,-1.4747702,-1.4546858,-1.4426637,-1.4317802,-1.4036764,-1.3854975,-1.3716216,-1.3388876,-1.3048124,-1.2722885,-1.2576416,-1.2304736,-1.1542394,-1.1100714,-1.047128,-0.9977665,-0.99537412,-0.91612479,-0.85198445,-0.80358571,-0.75622766,-0.73103182,-0.66170435,-0.61703668,-0.53775423,-0.47848484,-0.41548477,-0.33710524,-0.26394638,-0.21841672,-0.15079137,-0.077469401,-0.012022755,0.07052905,0.15088461,0.20539578,0.28342259,0.34040618,0.36253267,0.39343591,0.37511519,0.35209347,0.35538373,0.42501358,0.49013749,0.55837797,0.62575021,0.68876146,0.73636945,0.77969542,0.82399255,0.8702694,0.91466579,0.91580431,0.92451609,0.88296487,0.80266539,0.6997749,0.61386347,0.5217812,0.41067679,0.31569989,0.20780864,0.083478202,-0.018899388,-0.078020514,-0.14932065,-0.2376755,-0.33542646,-0.42102721,-0.53209058,-0.63445908,-0.68994491,-0.80496741,-0.8895126,-0.94328292,-1.0453731,-1.1285007,-1.0617494,-1.163663,-1.148082,-1.0487575,-0.9852436,-0.90872843,-0.81298651,-0.72702429,-0.63133525,-0.54757876,-0.47996626,-0.40818744,-0.31278462,-0.21414786,-0.12363551,-0.038143787,0.044166252,0.14736171,0.24706684,0.34402201,0.4370835,0.50023108,0.55988101,0.64113384,0.7025613,0.76832513,0.80977966,0.86773742,0.91436182,0.96537692,1.0222035,1.0633103,1.0927847,1.1314514,1.1511032,1.1746591,1.1680128,1.1777232,1.1181432,1.0925394,1.0773496,1.0624438,1.0062839,0.93224883,0.85561388,0.7883447,0.70561757,0.62106091,0.53905067,0.44760911,0.37307615,0.28969885,0.20356807,0.11303537,0.034529031,-0.053804965,-0.13684037,-0.17101947,-0.080536742,0.015038955,0.10827377,0.2054638,0.31639754,0.39827171,0.48453567,0.57959234,0.64528096,0.69198447,0.75770675,0.81592626,0.90122411,0.96996461,1.0377235,1.0740579,1.0887194,1.0714922,1.0507897,1.0218067,0.98484885,0.9436263,0.89756021,0.83817005,0.76830648,0.70049415,0.63080279,0.55080723,0.46368064,0.39966358,0.33166868,0.2864006,0.2281798,0.15493949,0.088120924,0.013902964,-0.067749515,-0.13665964,-0.23357212,-0.31688705,-0.41879727,-0.52129654,-0.64568614,-0.76686137,-0.88739662,-0.97178502,-1.0860017,-1.2029393,-1.3279572,-1.3996495,-1.4729399,-1.5924672,-1.6927399,-1.8095839,-1.9040825,-2.0223698,-2.1202098,-2.2092025,-2.3289037,-2.3553674,-2.2580136,-2.1598015,-2.0785734,-1.9690471,-1.8907389,-1.7858776,-1.6842667,-1.5885746,-1.4986282,-1.3998985,-1.2919532,-1.2161389,-1.0962496,-1.0132955,-0.91497683,-0.84332713,-0.76876433,-0.67006939,-0.57945538,-0.46318015,-0.38010634,-0.28322405,-0.18242038,-0.080772188,0.010230786,0.10345415,0.20974584,0.30293404,0.38707589,0.40232833,0.52028097,0.57908511,0.67823117,0.68822848,0.72028292,0.7886811,0.83817856,0.83098763,0.82932265,0.81845378,0.76388705,0.74097204,0.67626461,0.63011063,0.57082996,0.50333881,0.43715175,0.3693519,0.30968177,0.24049118,0.16127152,0.095862224,0.012430898,-0.042754033,-0.037678328,0.02730697,0.084931645,0.11964191,0.08641383,0.034123847,-0.027955079,-0.087025327,-0.15496185,-0.22095813,-0.2910099,-0.34133281,-0.40523525,-0.46764788,-0.53013427,-0.60438847,-0.66521301,-0.74395541,-0.83893709,-0.94791647,-0.99861032,-0.94790237,-0.92439785,-0.93992415,-0.95918692,-0.99501242,-1.0215422,-1.0595314,-1.0828747,-1.1106228,-1.1425951,-1.1637757,-1.1815797,-1.1994783,-1.2204889,-1.2494519,-1.271364,-1.2941022,-1.312847,-1.3462643,-1.2852958,-1.3617519,-1.3332942,-1.3410967,-1.3472819,-1.2988216,-1.2423233,-1.1454408,-1.0969085,-1.0063303,-0.9106457,-0.81143019,-0.77565493,-0.67100303,-0.57318356,-0.48968537,-0.38036246,-0.29275252,-0.20129137,-0.14611197,-0.091730918,-0.046230854,0.0060523317,0.039482794,0.07862102,0.1036674,0.12264484,0.15063021,0.18201728,0.22187878,0.24397474,0.26373056,0.27467422,0.28296419,0.28393361,0.28993242,0.29460156,0.30483144,0.30518385,0.34356673,0.42261796,0.51644001,0.62382066,0.73168651,0.85651389,0.93994853,1.0123626,1.0469325,1.0876955,1.1293282,1.1722722,1.2187378,1.2644798,1.3345502,1.397478,1.4499827,1.5175917,1.5616012,1.5994137,1.6203145,1.6269574,1.6301688,1.5979866,1.5525217,1.5107492,1.4570511,1.4486634,1.5240445,1.620606,1.7331632,1.8512941,1.9864942,2.0553265,2.154531,2.2514084,2.3091019,2.3365851,2.3617779:2
1.5749958,1.4941184,1.3242997,1.1927142,1.0482946,0.9159683,0.7706758,0.6373345,0.59039049,0.47841124,0.34233199,0.19755261,0.056754091,-0.055374559,-0.20296,-0.31441131,-0.44970679,-0.51622021,-0.64380204,-0.77815641,-0.91765525,-1.0880667,-1.2548505,-1.2830741,-1.3161418,-1.3981031,-1.5439487,-1.6867151,-1.8133938,-1.9664081,-2.0574564,-1.9610797,-2.1115054,-2.0835041,-2.1885035,-2.2313028,-2.2617644,-2.2045778,-2.1741749,-2.1452661,-2.0354421,-1.9596479,-1.8653361,-1.7769581,-1.6888653,-1.6312432,-1.557348,-1.6460415,-1.6920753,-1.6099487,-1.4988223,-1.4026858,-1.302706,-1.242599,-1.1409123,-1.1024914,-1.0256715,-0.95161054,-0.88040578,-0.85914666,-0.96757999,-1.0802369,-1.1946325,-1.1821197,-1.0640643,-0.97335821,-0.86600081,-0.7434659,-0.65392729,-0.5608827,-0.44885937,-0.32402227,-0.21924874,-0.12733879,-0.11261997,-0.23724746,-0.15042155,-0.028609767,0.094598468,0.22660433,0.34780507,0.43977178,0.57301042,0.68367496,0.77143129,0.83772554,0.95588041,1.0813658,1.1960423,1.3268838,1.3454951,1.2650697,1.1651619,1.0866693,0.97404695,0.84018685,0.69870623,0.56662671,0.42995597,0.29424316,0.15235171,0.0058944653,-0.13072735,-0.23776007,-0.12837023,-0.18094785,-0.27554829,-0.33512535,-0.44544,-0.57977317,-0.7052115,-0.8448178,-0.88661161,-1.0162158,-1.1433752,-1.2628093,-1.3698435,-1.4548981,-1.3714025,-1.3588079,-1.2332606,-1.0934735,-1.0052732,-0.96255789,-1.0156234,-1.0786447,-1.140893,-1.1873333,-1.2488617,-1.2549084,-1.2805427,-1.3425051,-1.4585434,-1.5572469,-1.6666724,-1.6845454,-1.8026993,-1.7113026,-1.6339462,-1.6764662,-1.7413161,-1.7986875,-1.8616884,-1.9408485,-1.992916,-2.0917136,-2.1698658,-2.1430952,-2.3093957,-2.146625,-2.1117553,-2.0052093,-1.8683085,-1.7318302,-1.5891039,-1.4524357,-1.4304676,-1.2903495,-1.1269597,-0.97660211,-0.79091753,-0.70119543,-0.60934198,-0.47117083,-0.29565155,-0.18497892,-0.10710857,-0.060380055,0.0063580771,0.14326494,0.29458381,0.46155322,0.616415,0.72808317,0.83279128,0.99163008,1.1131077,1.2360434,1.4100151,1.5396127,1.6777504,1.7652574,1.7813545,1.7886036,1.7449555,1.6723413,1.5854729,1.5591769,1.5126694,1.4378202,1.3175332,1.2493871,1.2799652,1.2320871,1.1473641,1.0352783,0.97350199,0.97367527,1.0106697,1.0965529,1.1030101,1.0947153,1.0069987,0.91198023,0.80145502,0.71824419,0.64331712,0.55990394,0.47949009,0.42435709,0.50603347,0.6287022,0.75659521,0.82739209,0.8668642,0.84417649,0.84712627,0.77656428,0.72166287,0.64958438,0.58130425,0.60231914,0.5034353,0.55959108,0.52717863,0.46260929,0.38232445,0.32089889,0.3089352,0.32734189,0.37364274,0.44640194,0.43477155,0.35616452,0.24746407,0.17355356,0.12294862,0.084621165,0.025817075,-0.040688918,-0.059826009,-0.093222554,-0.015969699,0.14282037,0.27997214,0.41495437,0.59232826,0.74728786,0.9079259,1.0529486,1.1109543,1.0731818,0.99307426,0.94094101,0.94154048,0.90284332,0.86621516,0.93586066,0.90185382,0.82611487,0.75475515,0.67149926,0.61152064,0.55628395,0.62098716,0.7516341,0.81307739,0.75616035,0.69606246,0.62212318,0.56527354,0.46597144,0.37469247,0.29925797,0.34930867,0.32998738,0.27803002,0.20555795,0.15640225,0.078722073,-0.0052511889,-0.08786258,-0.15154727,-0.23026788,-0.31257738,-0.37308483,-0.41492296,-0.47275608,-0.50913539,-0.55500851,-0.58666142,-0.58995522,-0.61321956,-0.64717263,-0.69894569,-0.67253693,-0.56509182,-0.4170018,-0.28449328,-0.14893461,-0.036119286,0.089505158,0.14523924,0.21417825,0.18675802,0.11298792,-0.02881066,-0.16344253,-0.28384767,-0.41971151,-0.53830038,-0.680158,-0.82219688,-0.83682254,-0.79876302,-0.77428015,-0.74443192,-0.70291202,-0.63639309,-0.57458384,-0.49760816,-0.35767408,-0.23680751,-0.090475116,0.063883502,0.21310647,0.3610706,0.50757136,0.59068236,0.64655127,0.75202705,0.81664905,0.88664133,0.96450085,1.0000375,0.91772376,0.7809046,0.66458818,0.57721518,0.60473311,0.65700502,0.70108021,0.74704899,0.80948648,0.84718513,0.8868219,0.91579312,0.96538307,1.0096531,1.0387659,0.97593524,0.82870953,0.82363476,0.85787104,0.88104876,0.92499404,0.96124399,0.90720333,0.9110892,0.9335306,0.91240967,0.84129183,0.73673985,0.5552247,0.42274928,0.29171286,0.11025941,-0.020811271,-0.14965543,-0.28459957,-0.30189146,-0.28470221,-0.26445389,-0.21718588,-0.17642968,-0.12548883,-0.073162836,8.3379036E-4,0.066316958,0.12834833,0.17874879,0.1371689,0.13647381,0.20191648,0.30148176,0.33223609,0.41268842,0.50062627,0.58040577,0.66750043,0.68089903,0.62529881,0.53218711,0.42659633,0.42659037,0.3438003,0.25684644,0.18188448,0.24534693,0.28358053,0.38337716,0.48339627,0.45628556,0.45275237,0.53718183,0.62752076,0.71022449,0.80694837,0.89498583,0.94538073,0.88196304,0.90124296,0.90799369,0.83356584,0.90497977,0.97388465,1.054415,1.1471568,1.2293935,1.2237698,1.3546294,1.4303393,1.4795067,1.5423652,1.5805917,1.5557011,1.5901798:3
-0.22247225,-0.21228533,-0.19632474,-0.19317113,-0.20100486,-0.19957419,-0.19329928,-0.19561854,-0.17794881,-0.17956626,-0.16565041,-0.17296339,-0.17547652,-0.17566401,-0.17321024,-0.15897615,-0.14984631,-0.14910108,-0.15066845,-0.15325458,-0.16878682,-0.18996232,-0.20144519,-0.22163969,-0.23355119,-0.24974417,-0.26698169,-0.27556805,-0.29107522,-0.28573362,-0.29298125,-0.29274607,-0.29365434,-0.30704631,-0.32480779,-0.33190771,-0.34887038,-0.36571721,-0.35745897,-0.34315635,-0.26805041,-0.21079815,-0.16481487,-0.085881887,-0.035165228,0.026644961,0.1004097,0.16489245,0.23461566,0.29976124,0.38894486,0.4515208,0.53917159,0.62086235,0.69572662,0.74868973,0.7997525,0.84403819,0.89591398,0.93843485,0.96263209,0.98958871,1.0186784,1.0464612,1.0530161,1.0762792,1.0917154,1.0899163,1.1061121,1.1231591,1.1503907,1.1711688,1.1981862,1.2244873,1.2438326,1.2703087,1.2986015,1.3196599,1.3527881,1.3842448,1.4082616,1.4304116,1.4479854,1.4653425,1.4760791,1.4865488,1.4960335,1.4981871,1.49528,1.4939243,1.4973783,1.4946037,1.4884032,1.4769276,1.459514,1.4500261,1.445305,1.4801088,1.5285373,1.5631079,1.5902449,1.5852128,1.6138699,1.59713,1.5150109,1.4392109,1.3592131,1.3162521,1.2513602,1.1714733,1.0742019,0.99676639,0.92454711,0.85893819,0.79563377,0.69818044,0.60132965,0.50387327,0.40633104,0.30951873,0.25149849,0.15429747,0.057608119,-0.038568956,-0.13576267,-0.23261528,-0.28999376,-0.38579059,-0.44414202,-0.53643935,-0.5908346,-0.6442537,-0.69695526,-0.74139224,-0.79057729,-0.80973848,-0.82128859,-0.83496852,-0.82001955,-0.79627986,-0.78076627,-0.77358305,-0.79339307,-0.82232983,-0.79913293,-0.78740689,-0.7644507,-0.7587012,-0.7412098,-0.71940387,-0.69835943,-0.66741658,-0.64616412,-0.61002718,-0.5927245,-0.57250676,-0.54895961,-0.53376648,-0.50766088,-0.49358299,-0.45637222,-0.42019521,-0.38995595,-0.35441749,-0.30521519,-0.28432663,-0.24870761,-0.22503158,-0.2248248,-0.22162712,-0.21833935,-0.21139454,-0.21607458,-0.20662448,-0.18601504,-0.18129839,-0.18155479,-0.16482403,-0.17117368,-0.16424098,-0.16348659,-0.16689061,-0.18501297,-0.20075772,-0.212209,-0.20962944,-0.21790599,-0.23418827,-0.24700059,-0.24268123,-0.25860446,-0.28270195,-0.30467046,-0.31828605,-0.34807041,-0.38520011,-0.41892998,-0.4706306,-0.52945461,-0.61444307,-0.66704478,-0.72284489,-0.80570489,-0.86401821,-0.95786364,-1.0560256,-1.1150559,-1.2124046,-1.300793,-1.3738252,-1.4430458,-1.5379955,-1.6000322,-1.668302,-1.7418611,-1.8268666,-1.8880237,-1.9172572,-1.862672,-1.8150267,-1.769055,-1.7127617,-1.6521218,-1.5956255,-1.5368495,-1.46727,-1.3941737,-1.342448,-1.2849988,-1.2097972,-1.1369192,-1.0806382,-1.0232105,-0.96155371,-0.90331045,-0.83742349,-0.77548194,-0.71395293,-0.64756927,-0.58495761,-0.51198244,-0.45465009,-0.39290585,-0.33898049,-0.26212945,-0.20052932,-0.15456809,-0.082480485,-0.015809578,0.044765007,0.10714726,0.1698973,0.22358264,0.28351444,0.31805466,0.36690953,0.40317229,0.46468424,0.5074965,0.5570885,0.5865504,0.6465821,0.67748104,0.70651662,0.7575331,0.77155013,0.83188235,0.85884712,0.89571992,0.91028115,0.9268002,0.92405396,0.89302616,0.84930267,0.80423624,0.75762027,0.69701863,0.65535243,0.60506066,0.54521548,0.50297431,0.48242374,0.47676095,0.52510511,0.5755656,0.60265253,0.66888923,0.68300413,0.75163398,0.83123305,0.89108788,0.94286821,1.0343373,1.0844111,1.1723742,1.2247239,1.2834698,1.3614124,1.4164701,1.4666921,1.5156693,1.5656334,1.6028126,1.643336,1.6829927,1.73036,1.7533114,1.7771324,1.7788299,1.7538001,1.7186086,1.6856283,1.6358913,1.6026798,1.5676757,1.532535,1.4766954,1.4237677,1.3676381,1.3055785,1.2285182,1.1578134,1.1136224,1.0478069,0.99385181,0.94720689,0.8918842,0.84035942,0.78652079,0.77058926,0.78563403,0.81736198,0.84652408,0.88849287,0.91262923,0.94016037,0.9582961,0.94793664,0.92504748,0.88248607,0.83661106,0.79682977,0.74865165,0.70481235,0.64086539,0.59351551,0.54757331,0.49397409,0.43474685,0.38967097,0.314166,0.27371389,0.23647434,0.17351606,0.11789384,0.038172682,-0.041394032,-0.1209567,-0.20380472,-0.24238989,-0.31213684,-0.38451238,-0.42780264,-0.47617117,-0.55805046,-0.63539519,-0.71356565,-0.77198662,-0.83541681,-0.91861859,-0.99795005,-1.0584803,-1.123177,-1.2041713,-1.2626859,-1.3333061,-1.4087507,-1.4592949,-1.5263275,-1.6054058,-1.6501113,-1.7277,-1.7731,-1.8448176,-1.9153051,-1.9631017,-2.01541,-2.0822261,-2.1392478,-2.1955727,-2.252479,-2.2956199,-2.2794495,-2.2140512,-2.1492879,-2.05566,-1.9707363,-1.8940956,-1.8223846,-1.7428728,-1.6670157,-1.6031492,-1.5039286,-1.4425219,-1.3454273,-1.2503449,-1.1547811,-1.0610738,-0.96805648,-0.87323691,-0.80552683,-0.72667329,-0.67318551,-0.6203297,-0.5517541,-0.49885086,-0.4426613,-0.39682179,-0.3607534,-0.33835474,-0.31014743,-0.2966752,-0.27927705,-0.27004669,-0.25335085,-0.23362588,-0.22268927:2
1.6752401,1.5710535,1.4222501,1.2731386,1.1245691,0.97620249,0.82802361,0.68003826,0.57853412,0.43182704,0.28563929,0.20052613,0.19664246,0.24420555,0.31464142,0.37474213,0.43243275,0.49587662,0.58025291,0.6515596,0.72293006,0.7803648,0.73427481,0.75702188,0.77357813,0.80277674,0.75220325,0.69745741,0.60538153,0.55052167,0.55633435,0.59237056,0.65294844,0.732957,0.77212439,0.79956961,0.83573014,0.80726176,0.81778109,0.84151693,0.86311331,0.87037393,0.78146728,0.7214325,0.72012738,0.7300205,0.74893007,0.76006048,0.73576862,0.68841827,0.67512094,0.66459301,0.65813157,0.6362464,0.58499419,0.47053358,0.38353924,0.24242792,0.13607755,0.018092642,-0.08522729,-0.11691206,-0.12851445,-0.15690324,-0.14996644,-0.11060316,-0.15362223,-0.092717342,-0.13645219,-0.095121652,-0.06662958,-0.062097283,-0.073008942,-0.053495101,-0.024769305,-0.0072495413,0.002840139,-0.081108732,-0.13058355,-0.098744721,-0.049381733,0.0098150224,0.064255295,0.096946671,0.10761335,0.15129839,0.17938016,0.23160478,0.25294779,0.26219973,0.24435527,0.17262387,0.10424995,-0.0018356696,-0.039658338,-0.047324821,-0.0092107773,0.048939363,0.1216174,0.13433428,0.19559102,0.27048442,0.33692357,0.36442068,0.39305919,0.39461591,0.39035913,0.43505648,0.4562323,0.52029927,0.57989845,0.61906285,0.6854331,0.75797508,0.80404534,0.84461604,0.87456076,0.90307382,0.92531979,0.90855581,0.84657858,0.7380475,0.62278444,0.52431736,0.42226279,0.31436045,0.21849783,0.10947507,0.0022901544,-0.11078808,-0.21085539,-0.32779558,-0.42410812,-0.53810543,-0.65394817,-0.753572,-0.8152723,-0.93098976,-1.045797,-1.1488845,-1.253732,-1.3649182,-1.4580438,-1.5718809,-1.6594363,-1.7742901,-1.8637941,-1.9699427,-2.1041837,-2.195502,-2.2787811,-2.4000126,-2.4561212,-2.5654336,-2.5610365,-2.5267913,-2.4961225,-2.4196925,-2.3634635,-2.3103241,-2.2011413,-2.0826441,-1.9615896,-1.8483579,-1.7682695,-1.6513474,-1.5670219,-1.4845067,-1.444915,-1.3942933,-1.2597291,-1.132412,-1.0408119,-0.9514779,-0.86419912,-0.80871582,-0.73522196,-0.64322839,-0.54940873,-0.46429659,-0.36217961,-0.26641101,-0.17398319,-0.12987521,-0.18620367,-0.26131618,-0.32899678,-0.4254357,-0.4729755,-0.55144768,-0.60419477,-0.59600974,-0.4800324,-0.37933695,-0.27178114,-0.13332603,-0.058575934,0.064033992,0.12795068,0.23189144,0.34516109,0.45457032,0.56546438,0.68264762,0.74593176,0.77375312,0.72708564,0.8260375,0.91601894,1.0240165,1.1179634,1.2253953,1.3251236,1.4214175,1.4934388,1.5803269,1.6963908,1.805835,1.9014931,1.980978,2.0815427,2.1704569,2.2630837,2.3526629,2.4527922,2.500018,2.4933719,2.4379039,2.2910263,2.1837397,2.036447,1.9290804,1.7970521,1.6795057,1.5523007,1.4349187,1.3228416,1.2115643,1.0946434,1.0299973,0.93821421,0.79786652,0.65688364,0.51738137,0.4410752,0.40338817,0.44712438,0.38459212,0.31663009,0.18943247,0.063939738,-0.0062527485,-0.10074648,-0.22313329,-0.28985162,-0.36818977,-0.47914687,-0.59750996,-0.71829048,-0.7811821,-0.6871535,-0.630609,-0.552148,-0.6076485,-0.55643535,-0.58845999,-0.67848021,-0.78186728,-0.7989231,-0.89973777,-1.0047301,-1.0946059,-1.0773697,-1.1491294,-1.2481411,-1.346377,-1.434343,-1.5255546,-1.6072469,-1.5890727,-1.628503,-1.7010211,-1.7777027,-1.8375522,-1.8527968,-1.92179,-1.9853403,-2.046706,-2.0950085,-2.1212844,-2.1628802,-2.158824,-2.1097154,-2.0408278,-1.9224207,-1.7836568,-1.676315,-1.5706608,-1.4619803,-1.3227236,-1.2070682,-1.1300672,-1.0945736,-1.0356672,-0.91095744,-0.84744529,-0.75015517,-0.68303848,-0.57561215,-0.46792354,-0.36231668,-0.26218156,-0.1770018,-0.047714005,0.063956199,0.1713019,0.2793943,0.3694364,0.46521611,0.55072366,0.67238095,0.78193894,0.90276367,0.95074426,0.90943545,0.86180021,0.81037155,0.73135862,0.66043638,0.60332582,0.51698027,0.44610705,0.39753333,0.42973667,0.38969036,0.32991985,0.27268244,0.24743674,0.19029547,0.13718768,0.13142682,0.1875619,0.14476043,0.10181452,0.066236874,-0.0022137036,-0.014954884,-0.053215233,-0.097456452,-0.16191041,-0.21055653,-0.22171428,-0.14346111,-0.026578252,-0.0026102021,-0.036927239,-0.052598501,-0.062670834,-0.12480158,-0.085875604,-0.077230046,-0.12280379,-0.17326217,-0.2224036,-0.24045233,-0.13005021,-0.15806403,-0.1956213,-0.21919069,-0.23967995,-0.26388322,-0.24065435,-0.27234894,-0.3080186,-0.35935281,-0.37783858,-0.41323937,-0.45234372,-0.42585291,-0.49225062,-0.4166338,-0.2948718,-0.23676847,-0.24958157,-0.22764953,-0.16554206,-0.15134441,-0.11246403,-0.0072538595,0.014229269,0.032299977,0.060641367,0.10713649,0.22006726,0.28346597,0.31159726,0.32013483,0.35095272,0.34372469,0.35283731,0.39941544,0.47155114,0.51708053,0.52465442,0.514725,0.50554877,0.51934719,0.46346857,0.46995576,0.42021677,0.42582849,0.40020939,0.34602483,0.3225613,0.39036391,0.39187839,0.43377934,0.57230755,0.69116894,0.84139705,0.99155943,1.1418445,1.2922142,1.4424873,1.5927878,1.6529658,1.6904166:3
1.0815518,1.0435551,0.94177289,0.80382083,0.67319665,0.69211017,0.68693689,0.6116146,0.59371804,0.67622368,0.53506296,0.37767781,0.26592118,0.18980286,0.2703971,0.082164189,0.24450151,0.22219817,0.17203215,0.097584533,0.064971478,0.053736671,-0.0092912337,-0.18209527,-0.27980015,-0.27628842,-0.4050752,-0.40704184,-0.49454424,-0.33503563,-0.32736416,-0.24937963,-0.2376368,-0.065835243,0.082055193,0.025517551,0.074280514,0.21025783,0.34758454,0.51712768,0.52817144,0.71424423,0.82150628,0.88333254,1.0608306,1.1529817,1.3333744,1.518695,1.6861376,1.8286307,1.8240792,1.7309788,1.6106868,1.4440391,1.2524319,1.174027,1.0163581,0.89001771,0.77593428,0.67193749,0.56408495,0.4988522,0.39280123,0.3019973,0.32066324,0.23689166,0.21613408,0.14029823,4.0397501E-4,0.016117101,-0.085785955,-0.12692748,-0.24897893,-0.3376654,-0.31895723,-0.20768663,-0.10312349,-0.042238558,0.14111455,0.26800882,0.49211626,0.6228892,0.80404926,0.7788533,0.66148181,0.59500668,0.52416106,0.50931384,0.42683981,0.34465265,0.20061235,0.095310272,0.19649207,0.17337424,0.16790178,0.14435243,0.071619189,-0.004093654,-0.060046429,-0.21384899,-0.32484287,-0.33886983,-0.39815641,-0.41485271,-0.42673696,-0.42796661,-0.44994281,-0.52281957,-0.67317177,-0.55509361,-0.445655,-0.46709161,-0.2223117,-0.19584629,-0.18586471,-0.18152375,-0.25283285,-0.29470272,-0.32406884,-0.37193459,-0.37115308,-0.41435143,-0.34510284,-0.4900579,-0.51084116,-0.630519,-0.80251085,-0.92987179,-0.93498187,-1.0502136,-1.1464298,-1.3061749,-1.4886938,-1.6137765,-1.7258186,-1.8967752,-1.9967161,-2.1161171,-2.3041734,-2.3654821,-2.5026414,-2.3867915,-2.1932013,-2.0573043,-1.865614,-1.6884799,-1.4816402,-1.3261832,-1.1763432,-0.99718495,-0.80769773,-0.60955641,-0.42444401,-0.2419155,-0.055096163,0.15368682,0.31193033,0.5039904,0.68013858,0.89032236,1.0589171,1.2358514,1.371876,1.56677,1.7500601,1.9256944,2.1232086,2.2725355,2.4708055,2.6404849,2.8480404,3.0520467,3.1521125,3.1658619,3.0535079,2.9830775,2.8095197,2.6285142,2.4396405,2.2499953,2.039999,1.8593755,1.6715449,1.4626187,1.2823329,1.0963734,0.88381156,0.70197747,0.51346081,0.33560348,0.14549988,-0.040981856,-0.2503289,-0.43502648,-0.61484938,-0.79602401,-1.0036769,-1.1982396,-1.3800997,-1.5591642,-1.7590447,-1.9612618,-2.1374356,-2.305716,-2.3436783,-2.3260995,-2.0969922,-1.8716804,-1.699281,-1.5726478,-1.467164,-1.3162021,-1.1745167,-1.0438912,-0.91006531,-0.85188536,-0.82320168,-0.76069056,-0.78819328,-0.7438492,-0.67225799,-0.61977091,-0.64405484,-0.59546294,-0.71444654,-0.69484796,-0.63861593,-0.58572099,-0.52008067,-0.4728016,-0.43489773,-0.36313932,-0.33448338,-0.25780754,-0.22096897,-0.17092263,-0.080066704,-0.064229078,-0.014962696,-0.029511612,0.008911097,0.08413058,0.069931385,0.1049774,0.22417392,0.3399109,0.35939494,0.386265,0.39881227,0.25808039,0.066638502,-0.020328579,-0.18952818,-0.37133994,-0.57447995,-0.75309634,-0.88406886,-1.0124015,-0.88910119,-0.76570776,-0.76362254,-0.68380691,-0.62125036,-0.49509526,-0.39447818,-0.32932635,-0.22575545,-0.11758979,-0.088894784,-0.061466802,0.0018316482,-0.13862762,-0.023195663,0.066876923,0.16066834,0.25072997,0.40465356,0.5363089,0.45213321,0.59863565,0.73653108,0.87210851,0.97465372,1.0565187,1.1456737,1.2164959,1.0309922,0.86922484,0.69374604,0.53126351,0.36136068,0.22050704,0.058827137,-0.047763419,-0.22797983,-0.36423883,-0.45290964,-0.56621995,-0.64464984,-0.73683566,-0.88104937,-1.0926079,-1.0725181,-0.89987199,-0.93592192,-1.1101486,-0.93766867,-0.84228013,-0.6977162,-0.58489882,-0.46019139,-0.3318957,-0.17762883,-0.07212563,0.017351878,0.12299586,0.20041379,0.29325197,0.27900421,0.17824351,0.32598718,0.44885614,0.57562039,0.69932609,0.81412497,0.96300654,0.90082882,0.796103,0.90021441,1.0304567,1.1880872,1.1645116,1.3077078,1.4266124,1.5369669,1.4802717,1.277672,1.4018125,1.2763691,1.1224825,1.065309,1.0465023,0.99296062,0.8876411,0.79958466,0.74064717,0.66643646,0.65060729,0.65497433,0.59264749,0.53163888,0.58235995,0.46440407,0.61707933,0.64704687,0.52094518,0.30202034,0.33236071,0.1232981,-0.079833105,-0.26946848,-0.48466132,-0.65686819,-0.81900761,-0.97790638,-1.1620614,-1.3628147,-1.5470574,-1.7481896,-1.6709097,-1.5029716,-1.3251673,-1.165524,-0.9648186,-0.80627343,-0.66723102,-0.47888616,-0.31914215,-0.15614806,-0.07198241,-0.11732194,-0.054440183,-0.10520257,0.077588637,0.19836518,0.19652862,0.25210117,0.31410799,0.30439588,0.23870263,0.28409215,0.36479825,0.22161143,0.15651136,0.073031091,-0.042887497,-0.21224019,-0.16390674,-0.31068826,-0.4615553,-0.5422916,-0.67419278,-0.67401357,-0.7937503,-0.82599235,-0.94541582,-1.0088648,-1.1658485,-1.2284842,-1.2056238,-1.4131627,-1.4890966,-1.254083,-1.0845487,-0.89266926,-0.69159683,-0.50079647,-0.30608677,-0.35320262,-0.179923,-0.02501958,0.18674636,0.38181468,0.49025339,0.69657932,0.86341907,1.0262222:1
2.7401999,2.6339566,2.5509118,2.4694266,2.3621594,2.2626796,2.1737911,2.0667487,1.9597252,1.8785779,1.7716678,1.6647486,1.5579122,1.4512028,1.344633,1.2642975,1.1603396,1.1043601,1.0328809,0.98052444,0.94307219,0.88602002,0.84738473,0.79999836,0.75739923,0.72370187,0.69687241,0.67340968,0.65395083,0.6421905,0.63717036,0.62783924,0.62273745,0.61419997,0.59658781,0.5853068,0.56806492,0.5462349,0.53927258,0.52081619,0.50614048,0.4886338,0.47815173,0.45595116,0.43094788,0.39605002,0.36225254,0.33196757,0.28531046,0.23183032,0.2030585,0.19147567,0.19252085,0.21592282,0.21008054,0.1352189,0.061798971,-0.016630498,-0.080628442,-0.16330236,-0.23437248,-0.31871075,-0.39641926,-0.47188355,-0.56022472,-0.62960368,-0.71695855,-0.79072016,-0.82791884,-0.85201495,-0.87472218,-0.90102644,-0.92171364,-0.93415308,-0.94363124,-0.94161815,-0.93984703,-0.93576318,-0.92652969,-0.90879679,-0.89614315,-0.88281202,-0.8646772,-0.86251968,-0.84898694,-0.83705503,-0.82998689,-0.8221833,-0.80746068,-0.78470048,-0.75948481,-0.74770199,-0.78267355,-0.83257634,-0.85664376,-0.84233072,-0.80929888,-0.78888322,-0.763625,-0.72667766,-0.67924025,-0.63039272,-0.57790636,-0.51855761,-0.47396082,-0.53436574,-0.61657864,-0.6807012,-0.75197051,-0.82830847,-0.89400988,-0.97383705,-1.057758,-1.162598,-1.2530479,-1.3506398,-1.4295481,-1.532231,-1.6050045,-1.6664882,-1.7219854,-1.7392479,-1.738959,-1.7273787,-1.7110749,-1.6722362,-1.6270109,-1.5824753,-1.5480536,-1.5161412,-1.4782171,-1.4361358,-1.3698052,-1.2902176,-1.2203252,-1.1490758,-1.0743912,-0.98547374,-0.91139841,-0.8376525,-0.74942838,-0.66253517,-0.5937416,-0.50578942,-0.41442375,-0.33208829,-0.25193048,-0.16994058,-0.10244495,-0.10070822,-0.019020964,0.073308808,0.17132501,0.2529213,0.33397624,0.41843176,0.4931949,0.57580689,0.61489806,0.54407585,0.46734287,0.38207896,0.31379128,0.24319074,0.1713455,0.099613217,0.025185479,-0.041750885,-0.10631257,-0.17560292,-0.24289079,-0.30608767,-0.36251308,-0.41839678,-0.47686723,-0.53347194,-0.58932702,-0.63510668,-0.66634422,-0.62671267,-0.57280212,-0.49946593,-0.41920611,-0.32419743,-0.24867798,-0.1729605,-0.09787419,-0.021331338,0.055407899,0.13364413,0.22870471,0.31594811,0.39399584,0.47190403,0.54839666,0.6214278,0.67834724,0.73965778,0.80978129,0.87673111,0.94602262,1.023093,1.1086401,1.0375334,0.96527999,0.93894553,0.97557223,1.0336449,1.1001061,1.1700477,1.247604,1.3287326,1.4087862,1.4970788,1.5570466,1.465868,1.5051916,1.5869258,1.6922193,1.7684843,1.8261423,1.778308,1.7144528,1.6547914,1.5768066,1.5025446,1.4281997,1.3215512,1.2143188,1.1330889,1.0318715,0.94819276,0.84311546,0.7376421,0.65569415,0.54987819,0.47239254,0.37362969,0.30637774,0.24876539,0.22509711,0.23575461,0.27015426,0.31858007,0.37928437,0.43641246,0.49935976,0.57123552,0.64536198,0.7105127,0.79494907,0.88011732,0.9432404,0.85983503,0.75836058,0.65881696,0.55844566,0.4762108,0.37698267,0.3075855,0.21275087,0.11383972,0.018294743,-0.077901372,-0.1805896,-0.25974628,-0.35095646,-0.44385126,-0.52305014,-0.60512687,-0.69201844,-0.77714237,-0.85881289,-0.95211104,-1.0481772,-1.1254072,-1.2179394,-1.2657879,-1.3152022,-1.358523,-1.3801214,-1.391093,-1.372591,-1.3372206,-1.2830507,-1.222548,-1.145827,-1.0568187,-0.98179188,-0.89104016,-0.81118969,-0.74366598,-0.71060408,-0.71093831,-0.62145007,-0.54458033,-0.47525539,-0.40103902,-0.34077392,-0.26410313,-0.19826067,-0.18712541,-0.21757768,-0.27872273,-0.33484019,-0.38912763,-0.44861167,-0.50530041,-0.55082065,-0.58011853,-0.6062911,-0.55951175,-0.61952745,-0.67551148,-0.72914328,-0.78836174,-0.83495816,-0.89702107,-0.94399876,-0.98899064,-1.0365898,-1.0814605,-1.1206036,-1.1540324,-1.1927732,-1.22672,-1.2561223,-1.2882414,-1.3213596,-1.3499727,-1.3702037,-1.383196,-1.3951253,-1.4059078,-1.4234266,-1.4340098,-1.4339839,-1.4159311,-1.3955082,-1.375152,-1.3453176,-1.2927212,-1.239477,-1.182583,-1.1205007,-1.0556088,-0.98716032,-0.91605979,-0.83874552,-0.7604431,-0.68674234,-0.6125469,-0.538613,-0.46006457,-0.38710064,-0.30051912,-0.23763935,-0.18698801,-0.19946112,-0.20663341,-0.22259388,-0.22638205,-0.22065321,-0.19513409,-0.16348641,-0.10819154,-0.065195124,-0.070479435,-0.059585061,-0.055842011,-0.058096692,-0.056853395,-0.058108758,-0.057956575,-0.058361973,-0.049733753,-0.038923631,-0.029727528,-0.011720016,0.0065653352,0.029774636,0.058670044,0.08095982,0.10640737,0.13549612,0.15544375,0.19632949,0.24034576,0.28514111,0.32974429,0.37090097,0.40493582,0.44200735,0.46880872,0.48945534,0.54509376,0.58440525,0.62138549,0.66970107,0.7207752,0.76537197,0.81112352,0.85424403,0.8915379,0.93308655,0.98293678,1.0295625,1.0802434,1.1345547,1.1982917,1.2565693,1.3437634,1.4411462,1.5438098,1.6291152,1.7360861,1.8226205,1.9241281,2.0310931,2.1356771,2.2190389,2.325902,2.4330063,2.5141404,2.6213178,2.7025568,2.7483418:4
0.35317908,0.25524729,0.26547848,0.16530993,0.14482216,0.10083257,0.17122038,0.12158371,0.1608737,0.14987355,0.10700911,0.010980179,0.076859206,-0.01925169,-0.047822448,-0.12509997,-0.16687046,-0.12122354,-0.12945454,-0.052124602,0.037898283,0.22090582,0.14228917,0.091616161,0.10372811,0.17937663,0.1657268,0.090831296,0.062997384,0.077852352,-0.055300065,-0.098176374,0.012545328,-0.092162065,-0.13586243,-0.07800133,-0.2245092,-0.19672304,-0.2401117,-0.33658124,-0.42579027,-0.39928866,-0.53767377,-0.68994821,-0.83686995,-0.98162097,-1.1181672,-1.2416648,-1.2620967,-1.3869747,-1.5221146,-1.6527803,-1.8178677,-1.9809641,-1.8852862,-1.8244589,-1.6855448,-1.5236813,-1.3353316,-1.273007,-1.1588816,-0.96869934,-0.80205626,-0.6055183,-0.44220591,-0.25262089,-0.058803288,0.13983423,0.3083025,0.49074698,0.67760032,0.85837886,1.0486612,1.2299686,1.4252444,1.6340258,1.8095755,2.0066243,2.2376368,2.3958191,2.4155209,2.3382771,2.1625009,2.0095146,1.8005925,1.6094922,1.4052686,1.240996,1.0184115,0.85643617,0.65837149,0.50728737,0.36010437,0.18214032,-0.010741608,-0.045580011,-0.1468871,-0.20770051,-0.28202473,-0.38417876,-0.60463535,-0.75847187,-0.84090529,-0.96453335,-1.1481276,-1.2624548,-1.3205657,-1.4918093,-1.6463175,-1.8184224,-1.9345256,-2.1067201,-2.2346039,-2.3879699,-2.5512638,-2.7086197,-2.6064332,-2.460051,-2.3689953,-2.247801,-2.1471739,-2.1166756,-2.1688702,-2.2095635,-2.2084369,-2.1168729,-2.043694,-1.9097987,-1.7762439,-1.654904,-1.5009256,-1.3138072,-1.1935109,-1.0496147,-0.96302865,-0.85819087,-0.78926681,-0.68538828,-0.52845371,-0.41506526,-0.25025889,-0.11692079,-0.030535559,0.10766074,0.12791727,0.072384084,0.08360039,0.028970222,0.10763114,0.18122872,0.23184518,0.28641945,0.3332105,0.3629374,0.4509461,0.53064716,0.5439903,0.53338401,0.61295314,0.69618962,0.80099214,0.84579619,0.77299094,0.68866633,0.52645773,0.37796823,0.23678011,0.055719576,-0.11692024,-0.29602747,-0.42694551,-0.25945309,-0.36468981,-0.27742219,-0.10360846,-0.08661175,0.0016054508,0.086466792,0.15106354,0.24564664,0.37606799,0.47218763,0.52100332,0.59879086,0.61481422,0.64147641,0.66938009,0.50964309,0.67519241,0.66898646,0.70368034,0.77954326,0.79766599,0.85535395,0.9062465,0.90513102,0.96492336,1.1486935,1.2501488,1.4189106,1.5488065,1.6821488,1.7945183,1.9308987,1.8579128,1.5910709,1.3224998,1.0546251,0.92067782,0.65311162,0.54761037,0.38556449,0.17336137,-0.064077431,-0.26896523,-0.53274697,-0.58151181,-0.42269375,-0.38693659,-0.25071147,-0.21882706,-0.10719831,0.016524655,0.1676629,0.30003605,0.44029393,0.54270799,0.57842251,0.6581928,0.4537859,0.51019456,0.64674464,0.75170024,0.91930821,1.0751334,1.1434811,1.2869414,1.4442093,1.5460598,1.7054863,1.7990178,1.9478798,2.1197095,2.2412398,2.1169061,1.9571427,1.7518894,1.6314582,1.4451593,1.2493161,1.1343472,1.0180098,0.81564462,0.5954843,0.41814521,0.37468377,0.20759429,0.027567113,-0.18211128,-0.3648617,-0.55403337,-0.76375087,-0.92271218,-1.0788796,-0.98788913,-0.81454122,-0.61199955,-0.39914461,-0.25909792,-0.11696087,0.071641246,0.1408211,0.037581796,0.24136595,0.38371698,0.56636445,0.5588559,0.4278231,0.57403145,0.73275653,0.73111448,0.5576331,0.64172204,0.55300228,0.37747247,0.23764173,0.32537107,0.3422754,0.16684636,0.017161046,-0.12307443,-0.28847149,-0.1278989,-0.05146607,-0.20663795,-0.37003453,-0.52366849,-0.66493586,-0.81452813,-1.0002296,-1.139809,-1.2984913,-1.4453846,-1.5997389,-1.6964505,-1.5013303,-1.3470621,-1.1525723,-0.95240725,-0.78670958,-0.61028859,-0.45339302,-0.26852295,-0.088353763,0.10008727,0.26304072,0.31596238,0.21096055,0.40696835,0.61654175,0.77021816,0.98374782,1.0895543,1.1184564,1.191946,1.4040647,1.6226547,1.7835037,1.8733135,1.8108203,1.7136844,1.6037752,1.4570593,1.3357118,1.4405982,1.3153529,1.1699035,1.0605342,0.93730922,0.85887955,0.99172394,0.89864685,0.78954895,0.65082973,0.5575116,0.41127823,0.26461791,0.035854055,-0.11893135,-0.20314648,-0.038260562,0.02251313,-0.13414499,-0.24921203,-0.38939935,-0.54784641,-0.64410964,-0.79886067,-0.87891877,-1.0283927,-1.1368701,-1.3093863,-1.3811215,-1.4963293,-1.4546905,-1.626294,-1.4876375,-1.3001483,-1.1130503,-0.89507635,-0.69535983,-0.50218387,-0.29636786,-0.080345869,0.057658302,0.22034856,0.36023547,0.44265938,0.29762093,0.12704167,0.12370789,0.052072135,0.11113309,0.20451505,0.081316969,0.15095652,0.14241491,0.017196059,0.010863018,0.14630604,0.35623289,0.42876505,0.36418134,0.2542573,0.13817657,0.082519405,0.070389219,0.11684408,0.036299978,-0.054474785,-0.093495701,-0.18682381,-0.27579892,-0.32761849,-0.37403539,-0.37128687,-0.40928508,-0.46979413,-0.55909597,-0.65281714,-0.76971741,-0.75053786,-0.8990522,-0.96919939,-1.041668,-1.1330474,-1.2034624,-1.0033195,-0.84358893,-0.63687404,-0.45022817,-0.26310412,-0.042439043,0.11228925,0.29755605,0.23039118,0.34288525:1
0.87953477,0.81248002,0.7537515,0.69669433,0.62726867,0.59261291,0.5624812,0.48176248,0.41606113,0.34025613,0.26877962,0.19809219,0.11913104,0.049579456,-0.023882237,-0.095683968,-0.18268128,-0.25803425,-0.32579751,-0.41534615,-0.48607673,-0.5585091,-0.64433938,-0.70020755,-0.76145677,-0.8133789,-0.74005309,-0.67740908,-0.60570206,-0.5498944,-0.48865731,-0.43618047,-0.38103933,-0.32043836,-0.25353448,-0.20153645,-0.1440758,-0.089903747,-0.042267815,-0.0089011025,-0.030526223,-0.061177358,-0.095409215,-0.14055083,-0.18274054,-0.22812834,-0.28302971,-0.33085902,-0.3871091,-0.45371383,-0.51065585,-0.56528743,-0.61511237,-0.65941012,-0.69161452,-0.71914026,-0.74253203,-0.77227629,-0.78311088,-0.80774693,-0.83162842,-0.86879187,-0.90781614,-0.94936153,-1.018407,-1.0699553,-1.1272663,-1.1793018,-1.2294806,-1.2402885,-1.2162447,-1.1597714,-1.0771603,-1.0043671,-0.93061534,-0.85090219,-0.77649634,-0.69735308,-0.63724705,-0.62277011,-0.60884649,-0.60969797,-0.61416922,-0.62047426,-0.63597608,-0.6421092,-0.66018552,-0.67191385,-0.69004174,-0.72563232,-0.77043786,-0.80397278,-0.81841873,-0.76835989,-0.68094106,-0.59312153,-0.54693916,-0.53415771,-0.52752426,-0.52244098,-0.53132818,-0.54135247,-0.54375808,-0.52913547,-0.50779491,-0.49756783,-0.47260097,-0.449146,-0.41454757,-0.37543557,-0.36540123,-0.32083136,-0.28422587,-0.24196858,-0.18211842,-0.1199702,-0.054989992,-0.0073981258,0.063872038,0.11481717,0.18293138,0.23872226,0.26147456,0.33192302,0.39046598,0.4734675,0.54672284,0.63319494,0.70914819,0.77880127,0.85247972,0.91618453,0.99090059,1.0657276,1.1272173,1.1996243,1.2742927,1.3447526,1.4189698,1.5034028,1.5738258,1.6599752,1.6860065,1.7827924,1.8611927,1.928653,1.9895506,2.0644779,2.1285701,2.1884031,2.2511719,2.3058274,2.3318569,2.34576,2.3441732,2.3267103,2.2568578,2.1823693,2.1053452,2.0384875,1.9841168,1.9138772,1.8384969,1.7681358,1.6830771,1.6130108,1.5329318,1.4607773,1.3817343,1.3120323,1.2383209,1.163451,1.0921424,1.0203858,0.9414248,0.85367611,0.78293145,0.69525395,0.61814704,0.5731761,0.54365095,0.47171208,0.39663702,0.32305071,0.24343045,0.23443915,0.30321301,0.2597203,0.18283383,0.14357591,0.17369346,0.11119475,0.05028997,0.019179476,-0.062281089,-0.13405138,-0.22238433,-0.29734708,-0.37331024,-0.39678654,-0.41734134,-0.44915707,-0.44665487,-0.44849906,-0.44570732,-0.41360337,-0.36759424,-0.28309863,-0.19692405,-0.14523874,-0.10731073,-0.098477009,-0.10832295,-0.14070794,-0.18470787,-0.24699777,-0.30441854,-0.35795352,-0.4181737,-0.47433312,-0.54661849,-0.62783086,-0.68874614,-0.6656337,-0.64130403,-0.60548863,-0.57039361,-0.5429605,-0.52926737,-0.51982807,-0.51510367,-0.4880158,-0.49853912,-0.52119461,-0.53268759,-0.54424665,-0.53529905,-0.55434,-0.56098137,-0.54254021,-0.56574583,-0.55707581,-0.56920119,-0.59268882,-0.63892606,-0.7032524,-0.79386389,-0.90188941,-0.98810134,-1.0760854,-1.1650702,-1.2526187,-1.321636,-1.40956,-1.4795816,-1.5599184,-1.6189562,-1.6882301,-1.7552104,-1.8116899,-1.8782141,-1.9246864,-1.9729233,-1.9869839,-2.006237,-2.035425,-2.0575369,-2.0620702,-2.0399963,-2.0049665,-1.9540681,-1.9110265,-1.8566342,-1.7968951,-1.7283207,-1.6705253,-1.5987492,-1.5643974,-1.4888472,-1.4161812,-1.3511389,-1.2988187,-1.231075,-1.1455085,-1.1062033,-1.0281072,-0.94734136,-0.88647832,-0.84303071,-0.7892124,-0.72824853,-0.65570861,-0.59096268,-0.51659552,-0.45911656,-0.39645404,-0.32131965,-0.27107063,-0.21782607,-0.15800246,-0.10242798,-0.05045052,-0.012971372,0.022136586,0.059747448,0.091319117,0.11437493,0.11889111,0.079266809,0.032856625,-0.021761618,-0.072098066,-0.1196749,-0.17801064,-0.23507453,-0.28911283,-0.35290252,-0.41258803,-0.47587302,-0.53573011,-0.59374698,-0.65491905,-0.71539365,-0.78332941,-0.85649286,-0.93004744,-0.9951422,-1.0604693,-1.1252657,-1.201448,-1.2610823,-1.3197026,-1.2860461,-1.212617,-1.1026655,-1.0263246,-0.93337012,-0.8754574,-0.78112125,-0.69307162,-0.60720057,-0.52072103,-0.43257697,-0.34017679,-0.25675263,-0.1660706,-0.082206692,0.0049353221,0.092785274,0.16319594,0.23728975,0.31800621,0.39897148,0.47359518,0.54126409,0.61455465,0.68445081,0.7541827,0.82663685,0.89614317,0.96664766,1.0408519,1.1024349,1.1676158,1.2275074,1.2758596,1.3338659,1.3877016,1.4373309,1.4857623,1.5067404,1.4769773,1.4420125,1.3840079,1.3158898,1.2510494,1.1812647,1.1127003,1.0326654,0.96221634,0.90891055,0.9318127,1.0026109,1.0679776,1.1346682,1.2058752,1.2736101,1.3411671,1.4031149,1.4675676,1.5321183,1.5912686,1.6200848,1.6352352,1.6408356,1.6150921,1.5973477,1.568278,1.534944,1.4639511,1.3846296,1.3080016,1.2260444,1.1526666,1.0786646,1.0027391,0.92807855,0.84626706,0.77796648,0.70434416,0.62817687,0.54612541,0.52147121,0.5303102,0.56985841,0.61233689,0.66639227,0.72325663,0.77523611,0.81157127,0.86377634,0.90388853,0.93995862,0.97487274,0.96888116,0.94783669,0.89714231:2
0.78213107,0.66841863,0.55622281,0.3893958,0.22218037,0.064795621,-0.046097204,-0.04084122,0.057978287,0.077849661,0.048776767,0.087464915,0.13477369,0.12526998,0.1776812,0.21231464,0.2517463,0.32418165,0.32520481,0.2892207,0.24622383,0.21216918,0.25321415,0.26689499,0.28790464,0.28323332,0.20715973,0.21171215,0.24057426,0.25750984,0.14189038,0.12577624,0.10318972,0.0044416374,-0.02200293,-0.086680481,-0.028587565,0.039481011,0.10408829,0.18062033,0.11902559,0.12801347,0.14233663,0.17370786,0.18032102,0.20225538,0.22328292,0.27833686,0.32616054,0.29572913,0.22850986,0.11506716,0.020039965,-0.097475622,-0.1345755,-0.096195545,-0.046708031,-0.01347156,0.0071406433,0.087578488,0.11391096,0.12010685,0.19703611,0.2258837,0.20218042,0.19484949,0.16183509,0.1752696,0.1895655,0.19619494,0.19990033,0.15166379,0.13559911,0.050088327,-0.024165867,-0.027484174,0.01101166,-0.0038430766,0.038112488,0.085519781,0.10383548,0.15639736,0.21262322,0.24709217,0.26229283,0.2521792,0.24530384,0.28294005,0.32243365,0.37258657,0.39822396,0.42480024,0.52680792,0.5742046,0.62513181,0.6947819,0.76059945,0.84747296,0.90897719,0.97685808,1.0315095,1.0428432,0.97831483,0.8125238,0.68023839,0.56245001,0.42201278,0.30819377,0.19230625,0.082090523,-0.027280506,-0.14170105,-0.30769343,-0.46611241,-0.58445571,-0.69661965,-0.81311489,-0.93606411,-1.0200268,-1.1296426,-1.296959,-1.4631268,-1.6287505,-1.7382768,-1.901105,-1.9901105,-2.0959734,-2.0951617,-2.0629156,-2.0325956,-1.9801707,-1.924577,-1.8358835,-1.7791863,-1.6814105,-1.618262,-1.5398732,-1.4336992,-1.3550925,-1.2656315,-1.1956765,-1.1652224,-1.1453883,-1.2311147,-1.3275196,-1.2108793,-1.1107485,-0.99114381,-0.88851214,-0.78322707,-0.73692084,-0.65089534,-0.51248151,-0.39184331,-0.30096,-0.21131422,-0.12430283,-0.01133571,0.045199365,0.12341808,0.12974011,0.07465452,-0.033610563,-0.13420395,-0.20938997,-0.085324437,0.03149496,0.16723518,0.3201368,0.42754897,0.57972558,0.72319406,0.80679932,0.87131776,0.92598429,0.87887614,0.97770307,1.0975628,1.2416281,1.383719,1.4770631,1.62842,1.7736236,1.8649039,1.9883344,2.1268616,2.2824551,2.4455907,2.5504576,2.6604211,2.6957293,2.6560804,2.5595824,2.4803146,2.3714194,2.2516356,2.1305641,1.9822908,1.8442758,1.7246869,1.6031086,1.4436111,1.2803919,1.1532683,1.0501934,0.92473585,0.82970272,0.68379642,0.59708285,0.67222997,0.63365638,0.57591094,0.46996993,0.36477556,0.20724412,0.10371228,0.007667661,-0.091523005,-0.19402683,-0.30271284,-0.40052172,-0.50013491,-0.60336285,-0.70405934,-0.81236786,-0.79390835,-0.72567506,-0.63155255,-0.53461364,-0.44855185,-0.47053593,-0.49106743,-0.5591077,-0.63437005,-0.7100139,-0.79757879,-0.8602085,-0.96397706,-1.0186544,-1.1222258,-1.2214296,-1.2765385,-1.3187454,-1.4204476,-1.5152658,-1.6315699,-1.7530958,-1.8417207,-1.9536382,-1.9922488,-2.0072871,-2.0568117,-2.1285876,-2.2001241,-2.2652724,-2.3259572,-2.3832948,-2.4386258,-2.4930428,-2.5437008,-2.6076129,-2.6522907,-2.6562027,-2.6663312,-2.5565285,-2.4444968,-2.3153582,-2.1899217,-2.0870555,-1.9517641,-1.8339135,-1.7205227,-1.5952543,-1.4800796,-1.3613557,-1.2491419,-1.1240048,-0.99766312,-0.95041924,-0.90165794,-0.78478416,-0.65597648,-0.53642361,-0.4036795,-0.28683581,-0.13352506,-0.017379403,0.093535956,0.21927835,0.31356285,0.43392217,0.55872981,0.68022913,0.78988287,0.89075722,0.9764201,1.0848982,1.0547331,0.96448698,0.85339622,0.77591441,0.67405928,0.57478792,0.47786286,0.36905871,0.30909304,0.27827046,0.21827961,0.11808392,0.031601171,-0.030214179,-0.082093891,-0.11179865,-0.0033941055,0.037068027,0.0065604701,-0.059917716,-0.12841983,-0.18355463,-0.15275371,-0.2143735,-0.26604168,-0.32088369,-0.35165269,-0.35374552,-0.29126484,-0.1645312,-8.8173349E-4,0.082029672,0.10937729,0.13543232,0.13803224,0.12396695,0.10181932,0.097880371,0.17930521,0.17678945,0.12565053,0.081229225,0.028732674,-0.020912893,0.012280926,0.078008775,0.061590926,0.0046211617,-0.023539584,-0.040344087,-0.05991353,-0.091693294,-0.12012057,-0.15949682,-0.14433542,-0.15318419,-0.12211126,-0.0097977169,0.10806552,0.23099501,0.35132743,0.50745027,0.62148762,0.71570184,0.76390466,0.78023755,0.79479207,0.79369471,0.77022194,0.85678573,0.91377293,0.91480313,0.88581138,0.87535823,0.84337776,0.80630629,0.79663527,0.90132644,0.99267752,0.97686228,0.95864923,0.92912299,0.92753541,0.92090921,0.88785938,0.79545,0.78324086,0.73933072,0.70226757,0.82264768,0.85683397,0.8525553,0.86159009,0.83947642,0.79779248,0.76898898,0.76295611,0.72821951,0.75440385,0.75704314,0.71022889,0.76724064,0.70616238,0.61443106,0.53027152,0.57669257,0.49745241,0.47031564,0.38011763,0.3648147,0.35157091,0.27175664,0.17780404,0.21374795,0.17710171,0.066116536,0.052625686,0.04837697,0.089221985,0.010116731,-0.0065780368,-0.083371137,-0.023346404,0.13931827,0.30226691,0.45315648,0.56670763,0.72991148,0.8090603,0.84028449:3
2.107909,2.0590933,1.9928543,1.905508,1.8770187,1.8125942,1.7449151,1.6861803,1.5867853,1.5436279,1.486845,1.4181392,1.3521029,1.2703274,1.257282,1.2220273,1.1385059,1.0844541,0.99447405,0.92415463,0.91725746,0.94800485,0.9117689,0.85926102,0.77971364,0.71010078,0.63414537,0.51628747,0.55574285,0.53612358,0.58510878,0.5555322,0.46048574,0.43045127,0.3632976,0.2807897,0.24415819,0.13458949,0.074803923,0.060700015,0.12900814,0.14609913,0.19144651,0.16355969,0.10450724,0.026989621,-0.062692059,-0.084972605,-0.17131826,-0.25006966,-0.34515196,-0.41098552,-0.44486438,-0.53110074,-0.61304282,-0.69255184,-0.77566454,-0.86187761,-0.94714058,-1.0139376,-1.0919063,-1.1731236,-1.225496,-1.2291961,-1.1513895,-1.0742597,-1.0206118,-0.94623537,-0.87011097,-0.8004606,-0.70987673,-0.63142633,-0.58175206,-0.50303151,-0.4196764,-0.34847976,-0.26632111,-0.18631345,-0.13147553,-0.054315388,0.011361069,0.091454733,0.1861615,0.25987654,0.30419593,0.39309663,0.48221388,0.56464615,0.62017356,0.7030174,0.77898346,0.85552375,0.93915547,0.92373601,0.86307217,0.81129637,0.77652935,0.7166548,0.69146917,0.64257884,0.62680436,0.64689802,0.6247746,0.58774424,0.53600973,0.48761356,0.49087646,0.54571414,0.51756388,0.47552541,0.4583207,0.40159146,0.35128825,0.36295021,0.41653601,0.43387547,0.4230325,0.38357705,0.38124097,0.32645301,0.30128284,0.34921343,0.33983846,0.30987525,0.31802551,0.25749767,0.21469271,0.24373208,0.21321317,0.14467188,0.094761989,0.099626731,0.099814327,0.057340701,-0.0039550949,-0.0086153154,-0.077471579,-0.14763702,-0.11982682,-0.20147663,-0.2828352,-0.37006766,-0.35578364,-0.41913328,-0.5037343,-0.58716301,-0.64036634,-0.7115514,-0.79645961,-0.87657233,-0.95031662,-1.0280359,-1.050986,-0.95518101,-0.85638283,-0.75817067,-0.6652006,-0.57632954,-0.48721695,-0.38799278,-0.29063964,-0.19506578,-0.10669949,-0.013263265,0.084735812,0.18319092,0.26768063,0.35720415,0.43446816,0.51833909,0.61294354,0.70409138,0.6229519,0.70037239,0.80597767,0.85378524,0.95253875,1.0337638,1.0790602,1.068648,0.995218,0.9006055,0.80696114,0.7088064,0.61230475,0.52597699,0.43060502,0.33263787,0.23909983,0.15084597,0.058216224,-0.036555175,-0.13319846,-0.22978343,-0.31652829,-0.4080413,-0.50645262,-0.59398112,-0.68287178,-0.78120943,-0.87873086,-0.97071774,-1.0568801,-1.1506116,-1.0905982,-0.99816508,-0.91827893,-0.83943382,-0.77708858,-0.68000204,-0.59820888,-0.54388998,-0.51539815,-0.44965414,-0.36913865,-0.29965467,-0.24115084,-0.2584771,-0.18325554,-0.11566037,-0.061889948,0.0019256873,0.048447289,0.030142993,0.10357333,0.1675085,0.22234643,0.19910915,0.27246666,0.30173595,0.34060426,0.35050969,0.31316936,0.38578802,0.42575779,0.49674651,0.55226537,0.49309568,0.53546784,0.60572352,0.59113035,0.66473878,0.68697992,0.64343636,0.5690004,0.55842327,0.63193644,0.72243167,0.69707743,0.75556537,0.79091099,0.75633969,0.71412181,0.81070146,0.83135425,0.88271505,0.90529768,0.86997244,0.85024525,0.91866625,0.96431023,1.0116058,1.0137989,0.99928218,1.0753273,1.1232304,1.1696185,1.1704021,1.2455326,1.2751379,1.3348143,1.3230852,1.2199781,1.1216278,1.0152733,0.96346531,0.85903496,0.76247848,0.71444155,0.64296908,0.53806631,0.44089738,0.36704464,0.32361762,0.22682975,0.12489989,0.050478746,-0.027246148,-0.14756708,-0.24618927,-0.30366765,-0.3971552,-0.49473841,-0.57784492,-0.67200715,-0.73806645,-0.80062819,-0.89699032,-0.98568734,-1.0677361,-1.1643477,-1.2559364,-1.3499332,-1.4108603,-1.4951893,-1.5589915,-1.6119173,-1.657658,-1.7438236,-1.8099539,-1.8667247,-1.9186243,-1.9729024,-2.0044561,-1.9823789,-1.9566949,-2.0296564,-2.0419399,-2.0270125,-2.030498,-2.0021418,-1.9677683,-1.9357204,-1.8701884,-1.7789998,-1.8536735,-1.9485003,-2.0489564,-2.1509088,-2.2437019,-2.3352533,-2.4145134,-2.4258419,-2.3949764,-2.343514,-2.2810974,-2.2045319,-2.1324301,-2.0926471,-2.0443303,-1.9602932,-1.8963939,-1.8605454,-1.8570671,-1.7624866,-1.6995727,-1.6184928,-1.5935318,-1.6307078,-1.5236035,-1.4443916,-1.4199846,-1.3355342,-1.2691434,-1.1859462,-1.1272936,-1.0880046,-1.0097972,-0.90937997,-0.82655188,-0.7925371,-0.69502049,-0.62277296,-0.544425,-0.51000093,-0.52954305,-0.45016798,-0.35328387,-0.31047243,-0.23096329,-0.15696596,-0.13218965,-0.1548061,-0.071005033,0.0074150609,0.070073397,0.032533054,0.10627355,0.16375924,0.23699881,0.15569213,0.084176191,0.079204329,0.059266852,0.099382128,0.19020166,0.27194274,0.27562486,0.33061035,0.40922019,0.49076896,0.55791713,0.57437727,0.66680785,0.74672295,0.8196099,0.84598648,0.79742094,0.77254464,0.74245159,0.69233767,0.79407351,0.89680323,0.89802257,0.99010664,1.036662,1.0938058,1.1139828,1.0754786,1.0307907,1.135184,1.1554758,1.2547912,1.326565,1.3060945,1.3540709,1.4513372,1.5205819,1.6011245,1.5903498,1.682747,1.7839918,1.8475373,1.9180578,2.0098952,2.0242886,2.1093101:6
2.5182961,2.4564906,2.3723111,2.2714553,2.1764688,2.0866688,1.9913478,1.8878408,1.7799822,1.6711142,1.5723834,1.4610007,1.3552841,1.2391989,1.1438948,1.0322108,0.93282269,0.83051952,0.71761076,0.61738522,0.51358918,0.4113691,0.32059068,0.21440446,0.11301892,0.018823494,-0.08258906,-0.18407415,-0.28708119,-0.36240899,-0.45205478,-0.55548866,-0.65529434,-0.74528999,-0.84315105,-0.9353176,-1.0331119,-1.1326152,-1.2266783,-1.3213871,-1.4125784,-1.5052735,-1.5980032,-1.6852298,-1.7661252,-1.853835,-1.936077,-2.0139197,-1.9351017,-1.8290968,-1.7160097,-1.5906556,-1.4651304,-1.3701333,-1.3139352,-1.1998668,-1.1049912,-1.0259141,-0.93739864,-0.86008391,-0.80741821,-0.73843964,-0.65289266,-0.55777246,-0.47936288,-0.40258754,-0.33702281,-0.26575247,-0.17304265,-0.081266737,-0.0029922638,0.069254824,0.094888995,0.039124214,-0.033725866,-0.1066066,-0.20596501,-0.28480581,-0.33725913,-0.43435755,-0.49625308,-0.54347858,-0.58813664,-0.66227392,-0.72335564,-0.79556716,-0.82162763,-0.75095876,-0.70568531,-0.63987666,-0.61465001,-0.53453206,-0.51600781,-0.44946602,-0.38702276,-0.42502252,-0.3283485,-0.24417759,-0.16836292,-0.086790284,-0.02136468,0.065838173,0.14809015,0.23498553,0.31465506,0.39683392,0.48581915,0.57978116,0.67251397,0.76170678,0.85080332,0.93464742,0.99610328,0.95296686,0.86787165,0.78095926,0.7289367,0.70199548,0.7265628,0.77847061,0.84754001,0.88621258,0.92627636,0.95877006,1.0077386,1.0605395,1.1041617,1.1615643,1.2456245,1.3186995,1.4112714,1.502073,1.6023934,1.6698371,1.6202112,1.5494975,1.4745346,1.4400582,1.3671108,1.284397,1.2032425,1.1209808,1.0619071,0.984618,0.89782024,0.80478208,0.71502045,0.6597245,0.65319378,0.59394039,0.50439771,0.40234632,0.29985205,0.19684389,0.079735472,-0.022295734,-0.12358797,-0.2422023,-0.3433604,-0.46008258,-0.59357705,-0.70918711,-0.84157059,-0.94075489,-0.98886018,-1.0172097,-1.1182412,-1.2070245,-1.2777624,-1.3537771,-1.370917,-1.3078225,-1.2268102,-1.145105,-1.0786072,-0.9966417,-0.96522672,-0.87426077,-0.7867683,-0.69843528,-0.61172525,-0.5543036,-0.49674495,-0.41302211,-0.33300471,-0.24934904,-0.16101044,-0.080121316,0.012876496,0.10844039,0.19772768,0.29397239,0.38738671,0.47574788,0.55094426,0.62846802,0.70577273,0.78348534,0.86339593,0.88788278,0.8734661,0.83137887,0.77854746,0.7403011,0.71660698,0.72445674,0.734242,0.82495528,0.9019554,0.99328553,1.0838758,1.1194579,1.1629183,1.1655517,1.2274803,1.3199003,1.4102829,1.5028184,1.5712604,1.6075838,1.5757555,1.4827052,1.3867997,1.3037595,1.2118776,1.130251,1.0677687,1.0384909,0.95345355,0.8709834,0.78372271,0.69705801,0.60675604,0.5147096,0.43612046,0.43035365,0.37169728,0.38630365,0.44764722,0.50635813,0.53704398,0.57773093,0.57068368,0.48983105,0.40573214,0.31705387,0.23732502,0.14749067,0.056236601,0.006262609,-0.09566682,-0.19515574,-0.25775149,-0.37542089,-0.48069864,-0.58152406,-0.68862947,-0.79121504,-0.82765907,-0.90981949,-1.0218647,-1.099062,-1.1571723,-1.1949677,-1.3021813,-1.3406033,-1.4250567,-1.5150748,-1.5348626,-1.5778109,-1.6313586,-1.5809232,-1.5146211,-1.5174572,-1.4105404,-1.4717548,-1.3703258,-1.3083522,-1.207893,-1.1211108,-1.0912917,-1.0142686,-0.99083426,-0.9000623,-0.8298313,-0.73437088,-0.63784482,-0.53555255,-0.43668164,-0.34753046,-0.25044792,-0.17727056,-0.1154225,-0.026534561,0.055138697,0.12728745,0.17276956,0.20336908,0.26145668,0.30651412,0.38840244,0.46853707,0.55127913,0.62437738,0.70449371,0.78663189,0.85572806,0.94139014,1.0242458,1.0016307,0.93243171,0.84313221,0.77176316,0.76640692,0.69953336,0.62780922,0.56277263,0.54936767,0.50854874,0.44645237,0.37871181,0.31917019,0.27609667,0.18359018,0.11823492,0.088120728,0.18408731,0.28082086,0.37622198,0.47497825,0.4746667,0.44172439,0.35246105,0.26681406,0.20948333,0.1238145,0.041608171,-0.03420622,-0.12616781,-0.21940695,-0.30057477,-0.38080235,-0.46186328,-0.53668522,-0.6262945,-0.6769076,-0.69291336,-0.77838903,-0.88493406,-0.96843805,-1.0490843,-1.1278912,-1.2033345,-1.2734317,-1.3455763,-1.415887,-1.4256634,-1.3746691,-1.28259,-1.2015927,-1.1121457,-1.0272693,-0.92965994,-0.85002635,-0.77732626,-0.69209588,-0.60785182,-0.52851566,-0.4817677,-0.45604256,-0.5214516,-0.64169262,-0.74948696,-0.81761076,-0.90016006,-0.9774576,-1.0186612,-1.0654104,-1.1605487,-1.2693368,-1.3685635,-1.4571609,-1.5078543,-1.5891775,-1.6487747,-1.6774891,-1.5815111,-1.4826316,-1.3854046,-1.2942627,-1.1889816,-1.098242,-0.99475704,-0.90297789,-0.80008865,-0.69949762,-0.60773219,-0.50543954,-0.40201195,-0.2983612,-0.20700002,-0.10773186,-0.0028251674,0.09964674,0.19896414,0.29418692,0.39599534,0.50064827,0.60583629,0.71445688,0.81537595,0.92494339,1.0279257,1.1414887,1.2384823,1.3499705,1.460994,1.5721296,1.6850882,1.7921451,1.8995916,2.0147701,2.1170047,2.222175,2.3224603,2.4175043,2.4802207:5
0.98658393,0.86517604,0.75110394,0.64134176,0.53152753,0.45405793,0.35110538,0.28461695,0.22204089,0.16371326,0.11616377,0.059246993,-0.041241423,-0.12937288,-0.23241699,-0.31835824,-0.40021471,-0.48446614,-0.55956275,-0.59766752,-0.62531579,-0.65775175,-0.66589176,-0.68254763,-0.69164352,-0.6973276,-0.69758444,-0.69295934,-0.68242436,-0.66576014,-0.63517968,-0.62572899,-0.60254828,-0.57552945,-0.54033388,-0.50650645,-0.464555,-0.42609832,-0.38737356,-0.34353462,-0.29022097,-0.2338618,-0.17790818,-0.17545709,-0.26417201,-0.32328271,-0.30143956,-0.25671069,-0.19961582,-0.13666931,-0.07218589,3.8106883E-4,0.061295966,0.13256031,0.059648539,-0.02198514,-0.099965259,-0.1575101,-0.24731251,-0.32297308,-0.4089996,-0.49460616,-0.58168094,-0.66430251,-0.76425488,-0.84061,-0.94430942,-1.0216941,-1.1175857,-1.2249464,-1.3054292,-1.3988615,-1.5000948,-1.5908302,-1.7003305,-1.8239344,-1.9105903,-1.978883,-2.014988,-2.0337948,-2.0300674,-2.0326357,-2.0057564,-1.977509,-1.9364869,-1.861864,-1.7622336,-1.6579296,-1.5584974,-1.4838028,-1.3780883,-1.267772,-1.1544771,-1.0491233,-0.9643302,-0.86467,-0.76990555,-0.6523325,-0.53118242,-0.40917648,-0.30167064,-0.20237428,-0.079514829,0.022550189,0.11830048,0.22029193,0.33139321,0.44840119,0.54715965,0.6485538,0.69136973,0.60286219,0.5219384,0.41867087,0.3392799,0.26051964,0.17818845,0.091942577,0.016242112,-0.071229048,-0.14364962,-0.21730177,-0.29322442,-0.36148754,-0.4202008,-0.46382427,-0.47303738,-0.45139111,-0.40371283,-0.33124088,-0.25706263,-0.18231234,-0.097081559,0.0010241945,0.088264972,0.17763798,0.26353222,0.3596019,0.45795343,0.55755412,0.65340224,0.74379295,0.82226543,0.9156957,0.99306792,1.0915204,1.193186,1.2710067,1.3596006,1.4612292,1.5628154,1.6623499,1.7103155,1.6554995,1.666799,1.7458466,1.8224517,1.9245368,2.003859,2.0939029,2.0174362,1.8896256,1.7922065,1.6889615,1.5629526,1.5069318,1.4808605,1.5456533,1.6361321,1.6414853,1.541755,1.4404844,1.3392588,1.2383553,1.1365906,1.0332774,0.93036691,0.83253257,0.73133384,0.60517185,0.50806864,0.40853721,0.31032449,0.20101948,0.090441994,-0.015329724,-0.1110901,-0.21062701,-0.32941551,-0.44224748,-0.51342328,-0.54946273,-0.54296171,-0.51992337,-0.46201762,-0.38579017,-0.29574771,-0.2210605,-0.13971052,-0.039230372,0.049653826,0.14430107,0.2358261,0.32516045,0.40833544,0.49899758,0.59309251,0.60980262,0.53325989,0.42855162,0.34873981,0.24706251,0.21966344,0.12707829,0.040332637,-0.065603602,-0.14779855,-0.2432648,-0.33961262,-0.42418332,-0.52016012,-0.6052787,-0.69733212,-0.78702433,-0.87118239,-0.9663256,-1.0461701,-1.1442883,-1.2324552,-1.3063409,-1.4038195,-1.4798616,-1.5643617,-1.6554136,-1.7273384,-1.8118645,-1.8975288,-1.9701904,-2.0455653,-2.1159255,-2.1779524,-2.2237818,-2.2517366,-2.2514328,-2.2242862,-2.1760527,-2.1051564,-2.0225979,-1.9391742,-1.84013,-1.7106211,-1.5841497,-1.4942912,-1.3692322,-1.2784525,-1.151778,-1.053164,-0.93319629,-0.84121129,-0.71340173,-0.62060771,-0.4977431,-0.39895248,-0.26901684,-0.17366153,-0.076630166,0.018551342,0.14827505,0.27848937,0.40884347,0.46912098,0.37985962,0.28777404,0.16114399,0.071043997,-0.017064798,-0.10714319,-0.17582658,-0.24252316,-0.32608731,-0.38652956,-0.45261417,-0.50395744,-0.56447756,-0.6121741,-0.66861871,-0.71936797,-0.77547813,-0.81017864,-0.84608065,-0.88175672,-0.91849657,-0.9497548,-0.98687645,-1.0073095,-1.0133679,-1.0424476,-1.0512826,-1.0566712,-1.0601768,-1.0664849,-1.0684526,-1.0648759,-1.0533879,-1.0418219,-1.0180373,-1.0048104,-0.97365277,-0.93976821,-0.90122475,-0.83583564,-0.75552357,-0.68537624,-0.59759671,-0.47406852,-0.39881499,-0.30736798,-0.23975504,-0.17228172,-0.10757116,-0.056074758,0.013886466,0.080777248,0.13519852,0.199777,0.24603621,0.2942298,0.33134372,0.35896014,0.38640171,0.43435618,0.44844929,0.44807874,0.45683368,0.44276731,0.44120925,0.45645169,0.48008541,0.49848575,0.51551366,0.55512299,0.65517536,0.65649561,0.65940007,0.6651835,0.66196087,0.67602653,0.66948179,0.66697228,0.67143608,0.67707852,0.69537027,0.70673891,0.72262345,0.74259646,0.77153959,0.79398155,0.83262971,0.87184185,0.90287141,0.9292351,0.95712323,0.97403777,0.97758629,0.97442628,0.97787874,0.97843725,0.97243135,0.96618003,0.95729979,0.96372293,1.0057179,1.0596954,1.1464635,1.239315,1.3439738,1.3970153,1.4692442,1.5753475,1.6732124,1.8015265,1.8198534,1.6931799,1.5936654,1.5159632,1.4331238,1.3934741,1.395283,1.4260291,1.4419704,1.4563709,1.4605756,1.4589147,1.4482125,1.4298835,1.4080158,1.3760884,1.3454964,1.3159122,1.2756985,1.2307756,1.198349,1.1668147,1.1111071,1.0686798,1.0179549,0.98067703,0.94679063,0.92198257,0.90536252,0.87413088,0.85700423,0.85446532,0.8517284,0.84180916,0.83855156,0.8318998,0.74920483,0.66546356,0.66384983,0.75123914,0.85265677,0.90342918,0.93379161,0.96468619,0.99013224,1.0312814:4
0.90071733,0.86531776,0.80437426,0.75823944,0.72447919,0.68172559,0.60374115,0.54885613,0.51074164,0.47821607,0.39944002,0.33639631,0.25884359,0.18975037,0.26289711,0.26821174,0.22520845,0.16609103,0.096666176,0.033898806,-0.027246187,-0.080164346,-0.11559509,-0.11488945,-0.13610355,-0.1744284,-0.20208894,-0.23500753,-0.30172673,-0.3622429,-0.40367403,-0.30787323,-0.21527774,-0.24058568,-0.24801868,-0.29325986,-0.32490357,-0.32370728,-0.34203887,-0.39783448,-0.41627802,-0.41135995,-0.46162683,-0.49950024,-0.55320645,-0.58917046,-0.56791543,-0.52518289,-0.52139049,-0.56467314,-0.62403242,-0.66750171,-0.69119817,-0.73423723,-0.79262374,-0.86890396,-0.91083234,-0.96690946,-1.0137158,-1.0795315,-1.1019412,-1.1600212,-1.0330809,-0.94206692,-0.79959029,-0.6946684,-0.62660797,-0.59129705,-0.51977515,-0.44866902,-0.40832194,-0.37162165,-0.25244654,-0.20241257,-0.18475726,-0.18756938,-0.17339613,-0.15958291,-0.15443561,-0.14308847,-0.15985386,-0.16610442,-0.18843126,-0.22170276,-0.28708761,-0.2880939,-0.28957089,-0.29533859,-0.31748959,-0.3856152,-0.44601881,-0.49184101,-0.54052914,-0.59508378,-0.6298187,-0.65965777,-0.70149681,-0.72322869,-0.75751433,-0.77526531,-0.7801648,-0.69895239,-0.58512116,-0.48535121,-0.38684021,-0.28718807,-0.2420899,-0.15952073,-0.051748791,0.044676295,0.15147935,0.24041898,0.36041039,0.44429485,0.55060377,0.6394521,0.74944022,0.84210198,0.95457843,1.0552558,1.1742259,1.2634098,1.3713995,1.4681437,1.5762371,1.6702186,1.7726525,1.8846547,2.0100835,2.1008189,2.2077301,2.3206729,2.40379,2.4633595,2.4598838,2.3645367,2.2395473,2.1555906,2.0410783,1.9313373,1.8375698,1.7320433,1.6350225,1.5289602,1.4253347,1.3228427,1.2233294,1.1104336,1.0184639,0.91434256,0.80972903,0.71169164,0.61037499,0.5124916,0.41127882,0.30712705,0.2091759,0.1082946,0.011477955,-0.091066899,-0.18973437,-0.28809316,-0.38639461,-0.49398594,-0.58931912,-0.69946227,-0.79928295,-0.83848935,-0.7953815,-0.73332209,-0.65812228,-0.60631939,-0.51089137,-0.45675085,-0.3717666,-0.30568881,-0.24962254,-0.15238631,-0.076720151,-0.010659344,0.045289085,0.12302101,0.18758603,0.25279086,0.31521101,0.34631051,0.37585013,0.38442693,0.3623373,0.37160953,0.38173119,0.40131994,0.42998124,0.45659085,0.39549731,0.27277105,0.28980235,0.299367,0.30030994,0.31609252,0.30547521,0.25951331,0.22912746,0.2362838,0.23485953,0.2397374,0.20416522,0.093531503,-0.029136411,-0.13994353,-0.26669055,-0.37550991,-0.4533386,-0.48196469,-0.47964147,-0.48460372,-0.48656574,-0.46922055,-0.44304655,-0.44368234,-0.4217581,-0.41080867,-0.42926435,-0.45204052,-0.39283692,-0.39068542,-0.3660324,-0.37861462,-0.40277407,-0.3840767,-0.38470916,-0.39178638,-0.42774174,-0.48841497,-0.58747454,-0.63217083,-0.59275343,-0.55421354,-0.52470531,-0.53772309,-0.5184654,-0.45516551,-0.41197346,-0.37489941,-0.4250336,-0.42104135,-0.31259208,-0.25631396,-0.2285025,-0.17123996,-0.073041095,-0.024161786,-0.0011292205,0.085285745,0.12949149,0.15108517,0.15155457,0.093316594,-0.0098341519,-0.14700215,-0.28564316,-0.37148353,-0.44925886,-0.5339123,-0.64785478,-0.78034208,-0.87746805,-0.97856916,-1.0824388,-1.1868736,-1.2881754,-1.4216422,-1.5313219,-1.6342298,-1.7354448,-1.8314854,-1.8892113,-1.8577971,-1.8170737,-1.7612289,-1.7257079,-1.667859,-1.6053639,-1.550426,-1.4816923,-1.4124133,-1.3509322,-1.2849501,-1.238115,-1.1692923,-1.0980881,-1.0142937,-0.98040988,-1.0024554,-0.9316899,-0.85358184,-0.75987708,-0.68706098,-0.5972513,-0.4968688,-0.43202533,-0.34248489,-0.26127907,-0.18425173,-0.11064631,-0.03747331,0.017031735,0.017217214,-0.025237248,0.0047645366,0.077856231,0.16992289,0.28309895,0.38073946,0.48710963,0.56337173,0.65119956,0.73507508,0.84023622,0.93782917,1.0414403,1.1188847,1.2173103,1.2636383,1.2976279,1.4198339,1.500094,1.5896278,1.7052586,1.7982649,1.8775063,1.966287,2.0637091,2.1594892,2.2523735,2.3366029,2.4198379,2.5147717,2.6146055,2.6661528,2.6361756,2.5247967,2.4309176,2.3185724,2.2384807,2.1450435,2.0366464,1.9296629,1.8230867,1.7391899,1.6330434,1.5336591,1.4024897,1.304915,1.2049747,1.0912126,1.0004114,0.91085523,0.87153353,0.83714888,0.73994194,0.62783167,0.53970896,0.44543636,0.3533364,0.22861661,0.14906432,0.048369467,-0.049603405,-0.14688109,-0.24555369,-0.35674977,-0.390867,-0.28719452,-0.23372638,-0.27083543,-0.33086255,-0.39459129,-0.49676493,-0.57164478,-0.65562978,-0.73370283,-0.82089792,-0.89863178,-0.99232487,-1.0830663,-1.1796477,-1.2133608,-1.2777912,-1.3609921,-1.4474887,-1.5217249,-1.59673,-1.6702967,-1.7343057,-1.8114391,-1.8594587,-1.9327455,-1.9871418,-2.0144598,-1.933124,-1.8423414,-1.6997887,-1.5571548,-1.4226719,-1.3258945,-1.183263,-1.0402305,-0.94342274,-0.80765574,-0.74169062,-0.63433774,-0.58772253,-0.45005988,-0.3093433,-0.16682854,-0.023691557,0.10267652,0.20889488,0.29433766,0.38930834,0.50524472,0.60579361,0.69258702,0.83439654,0.91449128,0.92700278:3
0.3700019,0.33913004,0.26885488,0.21412111,0.14293754,0.091701147,0.014042346,-0.046758865,-0.11762129,-0.18288196,-0.2466726,-0.31582484,-0.37401968,-0.44545124,-0.51743973,-0.60626439,-0.65084259,-0.71920122,-0.78137264,-0.85101114,-0.90662212,-0.9530628,-1.0029134,-1.0473299,-1.1022498,-1.1259936,-1.1746619,-1.1747163,-1.2214347,-1.2268968,-1.2991283,-1.3498398,-1.3651572,-1.4228712,-1.4913301,-1.5607256,-1.6416126,-1.6841283,-1.7301686,-1.7835601,-1.8327046,-1.876481,-1.9304207,-1.9649286,-2.0101572,-2.0493279,-2.1224953,-2.1639973,-2.2197029,-2.2635233,-2.2956253,-2.3121947,-2.3299529,-2.3513339,-2.3622899,-2.3603308,-2.3236659,-2.268388,-2.2263592,-2.1765355,-2.1063265,-2.0223058,-1.9299189,-1.8291246,-1.7574867,-1.6560318,-1.5410178,-1.4614797,-1.343494,-1.2571606,-1.1578639,-1.0479133,-0.94517258,-0.84546193,-0.7436363,-0.64701208,-0.53928215,-0.43966588,-0.34112097,-0.24594047,-0.14560428,-0.10491982,-0.042829291,-0.011868065,0.012912113,0.017678455,0.046073078,0.059661472,0.10061773,0.065319943,0.076236046,0.084865667,0.042964533,0.01300609,-0.057389555,-0.10407822,-0.14186546,-0.084628764,0.027769411,0.14252302,0.2090886,0.26247118,0.30436747,0.32128202,0.34412229,0.34418186,0.34752873,0.3450348,0.33239951,0.32550733,0.32894919,0.32876545,0.33499156,0.33811327,0.34950401,0.36830759,0.38713476,0.39866445,0.40843249,0.41633616,0.45392917,0.48875669,0.51991436,0.56290082,0.62995267,0.67673852,0.73865779,0.80302701,0.8722106,0.93874898,0.99786829,1.0323004,1.0854234,1.1201942,1.1615357,1.1832285,1.1737332,1.1790144,1.181961,1.2629244,1.3303197,1.4062052,1.4819245,1.5647035,1.6533507,1.7440831,1.8100821,1.8984919,1.9796171,2.0476519,2.1321329,2.1942356,2.2700066,2.2806578,2.2000714,2.0845135,1.9635111,1.8639286,1.7807498,1.7031251,1.6076742,1.5063621,1.4372396,1.3484648,1.2685911,1.193932,1.1767845,1.1478319,1.1362885,1.1239599,1.1343001,1.1418176,1.142891,1.1364831,1.1179486,1.0896721,1.0350008,0.97738858,0.95389811,0.86170736,0.81467421,0.77805263,0.72120946,0.67427226,0.60468447,0.51977442,0.45942379,0.43092654,0.37128609,0.31949805,0.24265466,0.19603155,0.11268308,0.018249479,-0.069845817,-0.1633486,-0.24614854,-0.345247,-0.42998064,-0.51123022,-0.61720452,-0.70318324,-0.79903078,-0.88483806,-0.98702996,-1.0738548,-1.1491097,-1.2375468,-1.2624341,-1.2241984,-1.185233,-1.1278152,-1.073605,-1.0025661,-0.96326483,-0.89204299,-0.84089933,-0.78598045,-0.74946315,-0.72292453,-0.67711666,-0.64328378,-0.60876778,-0.53452799,-0.48702649,-0.40149999,-0.32878894,-0.25948868,-0.19832117,-0.15478672,-0.11890156,-0.11501923,-0.14593101,-0.17447041,-0.20865028,-0.26846392,-0.33529503,-0.41662906,-0.49588579,-0.55651305,-0.51304579,-0.44132416,-0.38180753,-0.33249986,-0.26564624,-0.20344232,-0.15615125,-0.10951047,-0.092493312,-0.060565457,-0.053699396,-0.046182236,-0.039050074,-0.01843611,-0.024852452,-0.053260878,-0.057657995,-0.11660584,-0.23768065,-0.35702175,-0.46042959,-0.57865696,-0.56135233,-0.47683944,-0.39598189,-0.34541782,-0.26971738,-0.24485153,-0.21416143,-0.21267565,-0.24178005,-0.26010394,-0.24562523,-0.13336484,-0.022454197,0.06693704,0.18727596,0.30500884,0.35600911,0.44617862,0.52861659,0.60519507,0.69404538,0.76834138,0.81970288,0.87000547,0.92157351,0.96020536,0.97874987,0.98285558,0.92908778,0.84911932,0.76109363,0.66103706,0.59380651,0.55853693,0.55041822,0.48758335,0.40804664,0.33321562,0.2482755,0.15964545,0.066213546,-0.0073884324,-0.10850106,-0.20911754,-0.30854393,-0.41167141,-0.51431749,-0.61289691,-0.72324499,-0.8075468,-0.90675524,-1.0141566,-1.0914583,-1.1796734,-1.2660085,-1.3460789,-1.421761,-1.4793235,-1.4362446,-1.358856,-1.2888684,-1.2258214,-1.107199,-0.98148485,-0.87849997,-0.73928371,-0.64964884,-0.51047202,-0.41608757,-0.28388174,-0.19336033,-0.10351752,-0.014340172,0.075938599,0.16674517,0.25803043,0.35087412,0.42220252,0.49549858,0.56286113,0.6249328,0.69970367,0.75879467,0.81337361,0.86499931,0.9200341,0.97077123,1.0198474,1.078878,1.1370233,1.1917378,1.2398628,1.2857936,1.362061,1.4150521,1.4702621,1.5053992,1.5271143,1.516427,1.48947,1.4366719,1.3572004,1.2769724,1.1648647,1.0398352,0.91431984,0.78192893,0.74188716,0.83298285,0.9242175,1.0105458,1.094334,1.1884844,1.2722377,1.3552322,1.4204886,1.4453941,1.4095187,1.3372326,1.2803852,1.2152502,1.1215991,1.0138234,0.90258827,0.77599532,0.66673759,0.59257739,0.53917143,0.46608689,0.41482093,0.41496148,0.39302009,0.33241178,0.24641253,0.15092688,0.061126041,-0.040422243,-0.14016049,-0.24723001,-0.34187344,-0.44640095,-0.53486605,-0.6300632,-0.72794218,-0.80685915,-0.78470885,-0.73941886,-0.62093851,-0.49626418,-0.3708691,-0.31471359,-0.27853262,-0.26917219,-0.26534666,-0.26420896,-0.24220391,-0.17101585,-0.089597812,0.032776517,0.1284167,0.21454212,0.30351363,0.37511517,0.40130878,0.38331421:2
1.0221735,0.96983915,0.92080769,0.89786251,0.83423837,0.78977722,0.73393669,0.71653026,0.67061714,0.6321918,0.57903329,0.5217211,0.45323345,0.39065258,0.33605264,0.25937617,0.18703143,0.10999528,0.035850588,-0.036929986,-0.11564467,-0.16597798,-0.25536314,-0.3137175,-0.39009276,-0.47867322,-0.56578504,-0.63603101,-0.72542512,-0.81475476,-0.88384371,-0.97160493,-1.0355473,-1.1066041,-1.0858293,-1.0144062,-0.93581549,-0.86281542,-0.77311448,-0.69552378,-0.62858232,-0.56217633,-0.49489465,-0.43219811,-0.37488345,-0.32168035,-0.27027485,-0.22045053,-0.18024008,-0.16547071,-0.18142824,-0.20292096,-0.23554132,-0.28148916,-0.30685357,-0.31715533,-0.34121538,-0.3769059,-0.42596017,-0.46838601,-0.4954384,-0.52862531,-0.56010205,-0.59469744,-0.60381139,-0.63353178,-0.66639237,-0.67638295,-0.72386555,-0.75428125,-0.79839207,-0.84616314,-0.87874907,-0.91286489,-0.96415016,-1.0118641,-1.0759732,-1.1280537,-1.1959436,-1.2620101,-1.3234691,-1.3870199,-1.444818,-1.5092981,-1.5632078,-1.6158296,-1.6618021,-1.694962,-1.7390502,-1.7357244,-1.6731989,-1.5969967,-1.5281017,-1.4539456,-1.3756297,-1.3004194,-1.2122612,-1.1254524,-1.0513651,-0.96063515,-0.88329846,-0.77923181,-0.69293169,-0.59001677,-0.50282651,-0.44981863,-0.34602196,-0.28615316,-0.23859493,-0.20889338,-0.18864507,-0.18673429,-0.20035708,-0.21856973,-0.19244999,-0.15059064,-0.1258249,-0.085453211,-0.065371504,-0.043774292,-0.030205575,-0.023946298,-0.023797982,-0.021767211,-0.015192958,-0.023629225,-0.024143053,-0.013922854,0.022562727,0.088118986,0.14076271,0.20945255,0.28178986,0.35768886,0.41718277,0.47710669,0.5274814,0.5696364,0.61140912,0.65584999,0.69512666,0.70831908,0.71631095,0.71896561,0.71535593,0.71009822,0.68802905,0.68018323,0.66606136,0.65598981,0.64851845,0.66518371,0.68037066,0.70028356,0.70694479,0.66960205,0.67809404,0.62227046,0.57133396,0.55943532,0.59779533,0.67042853,0.75053547,0.82340049,0.90019485,0.98171279,1.0513259,1.1382159,1.2117948,1.2873535,1.3713935,1.4441564,1.5252917,1.6110274,1.6829534,1.7595861,1.8378309,1.9171624,1.998851,2.0759052,2.1481235,2.2326313,2.3178438,2.3576245,2.3703563,2.3332116,2.2661581,2.1891085,2.1062577,2.0249466,1.9544241,1.86207,1.7896116,1.7086859,1.6242542,1.5544099,1.461902,1.3851389,1.3102138,1.2291646,1.1487816,1.0748005,0.99975827,0.91378811,0.83505477,0.76087042,0.67919364,0.60019407,0.5259202,0.45340928,0.41539087,0.39617466,0.37406449,0.37313102,0.34774075,0.31930637,0.2864774,0.22306335,0.17826545,0.14265641,0.084318667,0.027967686,-0.028829113,-0.087930901,-0.14788188,-0.19664054,-0.24741239,-0.26746118,-0.31681298,-0.36957514,-0.41538922,-0.45547766,-0.48191153,-0.49677115,-0.52372982,-0.54793056,-0.57682917,-0.5759932,-0.60301851,-0.60135168,-0.61715993,-0.64221871,-0.6642579,-0.69739825,-0.73746474,-0.78494714,-0.84047239,-0.89678862,-0.99401255,-1.1023089,-1.1921983,-1.2796678,-1.3573821,-1.4327678,-1.4985205,-1.5090205,-1.5389394,-1.5352201,-1.4926004,-1.4472502,-1.4625691,-1.4219917,-1.3736158,-1.3280968,-1.2754741,-1.2365755,-1.1874152,-1.1356693,-1.088936,-1.0360406,-0.98324818,-0.93827991,-0.92279572,-0.89736572,-0.86705622,-0.86638451,-0.8206591,-0.80105208,-0.74360791,-0.70993167,-0.6683021,-0.65513618,-0.61546332,-0.57374284,-0.54120035,-0.48989227,-0.45030851,-0.42544619,-0.40295192,-0.38406597,-0.3792455,-0.37775662,-0.38445166,-0.4076642,-0.45476551,-0.51127374,-0.56292818,-0.62125495,-0.67489309,-0.73047508,-0.80379992,-0.85596708,-0.91719332,-0.98504463,-1.0569268,-1.1248691,-1.1574008,-1.2045561,-1.2767155,-1.2922874,-1.3532016,-1.3670519,-1.4293171,-1.4982598,-1.5550825,-1.630363,-1.6952245,-1.7461198,-1.8158885,-1.839356,-1.8632178,-1.818753,-1.7551654,-1.714796,-1.605543,-1.5191756,-1.4102935,-1.3012326,-1.2147368,-1.127837,-1.018917,-0.9098643,-0.82345815,-0.72892781,-0.65026986,-0.56325589,-0.49345791,-0.41526257,-0.33790311,-0.26416218,-0.1914709,-0.123203,-0.054220865,0.012599369,0.075409706,0.13478061,0.19957979,0.25135031,0.31642596,0.37887122,0.437786,0.49248237,0.5515941,0.59216956,0.65011274,0.69528134,0.73899146,0.77652157,0.79427039,0.77845961,0.75356848,0.73539208,0.70872166,0.66582727,0.62631946,0.59377687,0.55680983,0.52138437,0.50598721,0.50391616,0.48133486,0.50528727,0.48191747,0.56068126,0.64586538,0.71981345,0.78949505,0.86997179,0.94456012,1.025107,1.0947791,1.173945,1.197724,1.2150076,1.2487065,1.2920185,1.3568114,1.413418,1.4634932,1.5425675,1.5526555,1.5751613,1.6565689,1.6350768,1.6086734,1.5828028,1.5774393,1.5543538,1.5352834,1.4979936,1.4282534,1.3583229,1.2979745,1.2367407,1.1701369,1.1329593,1.0537438,1.0091351,0.93509215,0.87196736,0.81481616,0.77661735,0.72044103,0.67302457,0.6875712,0.7261542,0.77284603,0.84516747,0.89927016,0.9523505,1.0075325,1.04671,1.0809014,1.1018275,1.1237299,1.1096421,1.0684746:2
1.5908076,1.5492607,1.4970883,1.4433091,1.3891183,1.3312281,1.2763901,1.2236042,1.1714216,1.0885544,1.072231,0.99078074,0.93921654,0.85666783,0.79627055,0.74210273,0.6888332,0.682566,0.63122669,0.56423836,0.50739345,0.45504363,0.42502015,0.45966694,0.49310348,0.51731397,0.56539329,0.63901811,0.68148484,0.70308303,0.69975603,0.66867552,0.64143695,0.640024,0.6325346,0.60712815,0.56512189,0.49771879,0.43809022,0.36767003,0.29734936,0.22854227,0.16228727,0.10191872,0.02130996,-0.048348162,-0.1433965,-0.21590817,-0.28397744,-0.3520986,-0.41881223,-0.4571034,-0.51554395,-0.56570549,-0.60700223,-0.64238454,-0.71749284,-0.7927716,-0.85030563,-0.91050254,-1.0094518,-1.0877556,-1.1863488,-1.2789598,-1.3396514,-1.4149315,-1.453289,-1.4812916,-1.4876827,-1.4433388,-1.4226176,-1.3957526,-1.3405669,-1.2602609,-1.1984152,-1.1265666,-1.0550601,-0.97386213,-0.90224037,-0.83441866,-0.7501553,-0.6753826,-0.60358212,-0.52977309,-0.48480416,-0.42093757,-0.36608849,-0.35055563,-0.33121728,-0.28541035,-0.21741991,-0.18515091,-0.13266209,-0.088769081,-0.063156173,-0.047420199,-0.054201518,-0.011087297,-0.0055190897,-0.0092121765,-0.018904079,-0.030355337,-0.036168711,-0.046962303,-0.076088012,-0.086515522,-0.10448674,-0.12840951,-0.15562335,-0.17640748,-0.19739825,-0.21608113,-0.241633,-0.25960351,-0.28863024,-0.31428562,-0.34646849,-0.37083765,-0.39558561,-0.43374753,-0.46613385,-0.5012797,-0.53700058,-0.58195791,-0.62480213,-0.65813353,-0.71846965,-0.78007557,-0.84975824,-0.85256673,-0.88534637,-0.83096091,-0.80018041,-0.77327506,-0.76476622,-0.7683237,-0.75960791,-0.79094622,-0.78292784,-0.79005965,-0.82069045,-0.82907996,-0.83488262,-0.84020623,-0.83729806,-0.81391642,-0.77952512,-0.70377993,-0.64182755,-0.55571919,-0.49142803,-0.41279562,-0.33153731,-0.24999857,-0.16738214,-0.079991284,-0.01668959,0.071379541,0.14596998,0.21780553,0.31921523,0.38641434,0.45882497,0.54859476,0.625781,0.70400376,0.78920554,0.85966757,0.93784872,1.0234992,1.0970713,1.1741486,1.2518826,1.324571,1.4051221,1.4898028,1.5692756,1.6590367,1.7297888,1.8290053,1.8993546,1.9867005,2.034552,2.0655021,2.0701724,2.0216755,2.0046704,1.9548782,1.8897823,1.8133059,1.7330725,1.6408894,1.5805606,1.5072292,1.4075831,1.3274967,1.2488156,1.1734065,1.0960558,1.0168568,0.92865751,0.8599435,0.77187509,0.70001608,0.64738186,0.61633096,0.59888366,0.55690039,0.48470458,0.42530374,0.3444374,0.28471659,0.21335796,0.14574769,0.063033821,-0.0097884158,-0.013151126,0.066832564,0.12647055,0.20825636,0.26931101,0.35248397,0.40317159,0.47644582,0.53822749,0.55297826,0.5193623,0.440984,0.36466229,0.28269308,0.2031365,0.12077945,0.045448352,-0.035964854,-0.11551015,-0.19758479,-0.26655438,-0.34091667,-0.41885167,-0.47822662,-0.56126607,-0.62851288,-0.69338716,-0.76007616,-0.83508929,-0.85591447,-0.85996984,-0.83162134,-0.81735902,-0.7932535,-0.78221774,-0.73377839,-0.70885997,-0.68459111,-0.6745196,-0.67225323,-0.65652789,-0.65848373,-0.6659019,-0.67834422,-0.70491866,-0.72602507,-0.7560957,-0.79944107,-0.88112185,-0.95065047,-1.0538354,-1.1576651,-1.2621319,-1.364058,-1.4425839,-1.4397884,-1.3862018,-1.3405357,-1.2679249,-1.2228987,-1.1797659,-1.1275743,-1.0862955,-1.0323662,-0.98273721,-0.94300329,-0.89562805,-0.87861533,-0.86242585,-0.84126013,-0.82420321,-0.81082059,-0.78366003,-0.85452671,-0.83034042,-0.80859308,-0.7393652,-0.74198417,-0.71053283,-0.70374478,-0.69888828,-0.67270556,-0.64702446,-0.64607957,-0.67609885,-0.64144303,-0.60823145,-0.61549865,-0.58684768,-0.54684018,-0.54561698,-0.51555425,-0.49858035,-0.48280579,-0.46544714,-0.45859437,-0.45254676,-0.4391792,-0.43829477,-0.44450619,-0.46046758,-0.46930925,-0.48607659,-0.49384145,-0.52107147,-0.56289257,-0.60856135,-0.65725652,-0.71448915,-0.77802237,-0.84382855,-0.93453005,-1.0163926,-1.1021763,-1.1695593,-1.2380716,-1.3231795,-1.3784678,-1.3808039,-1.3868865,-1.4115643,-1.4452634,-1.4337524,-1.4791116,-1.5252651,-1.5357112,-1.496774,-1.4413394,-1.4075167,-1.3572759,-1.306207,-1.2440893,-1.1820302,-1.1252058,-1.1211442,-1.1181602,-1.1419305,-1.1014308,-1.0794859,-1.0270294,-0.96397796,-0.89520292,-0.84142859,-0.78542967,-0.7206089,-0.66240751,-0.60988911,-0.53214081,-0.43993349,-0.39011913,-0.30090826,-0.24916394,-0.20095345,-0.12574045,-0.039437943,0.027831262,0.10121762,0.1699599,0.24325704,0.31468207,0.38035182,0.44151388,0.51236254,0.5809914,0.64463729,0.71060633,0.77516816,0.84108607,0.91052584,0.97729028,1.0351458,1.0999612,1.1302127,1.144736,1.1575268,1.1623654,1.1803012,1.2193783,1.2965894,1.3634938,1.4285076,1.501296,1.5878745,1.649801,1.7327244,1.7955722,1.8599493,1.9114632,1.9440412,1.9570906,1.9979804,2.0314902,2.0755036,2.115656,2.1508576,2.1823325,2.2093176,2.2205315,2.2227362,2.1734473,2.1091158,2.0496535,1.986525,1.9326883,1.8860285,1.833935,1.8029327,1.7762423,1.7311418,1.6895726,1.6287151:2
1.4712281,1.4029244,1.334047,1.2615795,1.2023541,1.1264856,1.0369786,0.94650282,0.87332987,0.86705723,0.89722692,0.87424973,0.79426276,0.71332121,0.64164431,0.58836947,0.51300138,0.42746476,0.34957915,0.34490951,0.38924359,0.44774584,0.50464063,0.56852878,0.61727802,0.58076916,0.52667007,0.48398748,0.41842884,0.35045242,0.37359765,0.35050721,0.26553741,0.17985475,0.13382497,0.035359568,-0.049616908,-0.12772109,-0.096142888,-0.065447239,-0.13431094,-0.21424229,-0.29960564,-0.38673339,-0.48919071,-0.52765194,-0.62497376,-0.70542099,-0.79582439,-0.87215332,-0.93548451,-1.0072317,-1.0579893,-1.121462,-1.1463634,-1.1586848,-1.0869681,-1.0454047,-0.9728536,-0.94394735,-0.86915516,-0.79084958,-0.71610642,-0.64122142,-0.5684565,-0.48991649,-0.41277553,-0.39162845,-0.31307527,-0.23523854,-0.16695008,-0.090202212,-0.01149527,-0.003796073,-0.03555971,0.0064923848,0.079278417,0.15753588,0.22540355,0.30935872,0.38549939,0.46643859,0.53794385,0.60935351,0.65408284,0.739041,0.80979826,0.88978218,0.96265375,1.040511,1.0592688,0.99795953,0.9308336,0.85803049,0.81541388,0.72678378,0.66695484,0.58464151,0.55033647,0.53892264,0.48500012,0.40757184,0.33994906,0.25447371,0.18456681,0.1235171,0.045951255,-0.017850869,-0.05232733,-0.0032065805,0.036121557,0.11597846,0.078684931,0.011824097,-0.039844901,-0.10479383,-0.16649911,-0.23780923,-0.26089001,-0.30715679,-0.33408044,-0.39367858,-0.45750863,-0.52044284,-0.56591504,-0.64208083,-0.70721563,-0.77297623,-0.71700061,-0.70340741,-0.63489895,-0.5664517,-0.49672594,-0.41372112,-0.35546607,-0.35937736,-0.4196742,-0.46345165,-0.49348283,-0.47382839,-0.53756579,-0.59846154,-0.66919348,-0.72567153,-0.74940175,-0.68302423,-0.67531821,-0.73756139,-0.79051951,-0.86423415,-0.93840053,-1.012871,-1.1051167,-1.1399646,-1.1186302,-1.1236772,-1.1794951,-1.2049263,-1.2827221,-1.3481903,-1.4343029,-1.5073048,-1.585508,-1.6636781,-1.7318094,-1.7767563,-1.8301424,-1.8268758,-1.8525076,-1.883865,-1.831212,-1.7429304,-1.6526121,-1.5644129,-1.474657,-1.3869388,-1.2974631,-1.2085221,-1.1186393,-1.0315164,-0.93969173,-0.86391544,-0.7767782,-0.67901455,-0.60539898,-0.50248826,-0.42232959,-0.33333653,-0.24800074,-0.15532401,-0.065737288,0.025872017,0.11364255,0.19910593,0.28819,0.38081272,0.47241563,0.5454907,0.63115077,0.71799697,0.8069712,0.89724204,0.98690424,1.074771,1.1655805,1.2538907,1.3421279,1.4314197,1.5200932,1.6095763,1.6974433,1.7907743,1.8900839,1.9798345,2.0735961,2.1631286,2.251285,2.3364494,2.4248885,2.5147177,2.6046028,2.7003399,2.7867961,2.77489,2.7441583,2.6692475,2.561258,2.4741474,2.3807482,2.2744581,2.1883401,2.0968745,2.0075593,1.918453,1.8302681,1.7411467,1.6521309,1.5632169,1.4759621,1.3863099,1.2972825,1.209046,1.1187976,1.0285512,0.94080307,0.85108761,0.7616757,0.67165077,0.58215485,0.49254799,0.40197006,0.31455133,0.23423786,0.14473576,0.058111663,-0.022428224,-0.112454,-0.20328202,-0.29261486,-0.38296099,-0.47117488,-0.55993181,-0.6313122,-0.71912638,-0.80845756,-0.89588234,-0.98551946,-1.075312,-1.1647789,-1.2528472,-1.341251,-1.425966,-1.5009494,-1.5958811,-1.6897853,-1.779806,-1.8729821,-1.9417069,-1.9646691,-1.9516694,-1.9322399,-1.910657,-1.9137061,-1.8540811,-1.7695324,-1.6991123,-1.6285677,-1.5965645,-1.5317668,-1.4840254,-1.4182694,-1.3493355,-1.281565,-1.2080543,-1.1374781,-1.0721874,-1.0580768,-1.0595458,-1.0857915,-1.0134441,-0.93258122,-0.86845405,-0.80222128,-0.72525359,-0.66346588,-0.58232193,-0.62370546,-0.61348345,-0.54395468,-0.52252827,-0.48033065,-0.43404237,-0.36446385,-0.4105584,-0.48255331,-0.55694709,-0.63515747,-0.71084285,-0.78254891,-0.76646751,-0.6752584,-0.58858103,-0.54468905,-0.45826964,-0.38209922,-0.32574657,-0.33981206,-0.41273824,-0.42296391,-0.34980756,-0.26832834,-0.2346546,-0.15859284,-0.099463923,-0.054166934,-0.0035341607,-0.049907195,-0.12500434,-0.17483968,-0.12037228,-0.067388249,9.3352919E-4,0.091059976,0.14735413,0.13637669,0.18071181,0.24287394,0.32215505,0.38673651,0.45025718,0.44702929,0.39852993,0.4559414,0.53793882,0.58631477,0.66613716,0.7271942,0.76426475,0.83727022,0.87147527,0.81727184,0.71428998,0.65494777,0.55624112,0.46318786,0.40110439,0.28994791,0.20556624,0.15447469,0.18136889,0.1373953,0.051259557,-0.024709082,-0.1265355,-0.20297916,-0.26176606,-0.33488125,-0.40907324,-0.50477024,-0.57692335,-0.67175821,-0.63871326,-0.5709585,-0.50150484,-0.42316233,-0.36074434,-0.29277916,-0.21690814,-0.13517048,-0.072590748,0.0062651218,0.07531127,0.10468081,0.059629944,0.11775629,0.19884325,0.23166121,0.31602165,0.38199507,0.34466845,0.40161966,0.47910092,0.5269854,0.61255549,0.64207166,0.58652946,0.5068132,0.43806222,0.3811779,0.42143188,0.51335171,0.59944851,0.63047974,0.69780898,0.79663397,0.88737104,0.97154951,0.97876165,0.93211658,1.004059,1.1011168,1.2029909,1.2390298,1.3331133,1.3986113,1.4860579,1.5072484:3
2.15376,2.1574688,2.1395962,2.1097626,2.0999456,2.0512744,1.9983962,1.9504624,1.8801105,1.8341929,1.7610478,1.6877078,1.6251146,1.5765813,1.5548795,1.5798317,1.5909635,1.5655909,1.543469,1.5059556,1.4582959,1.4087939,1.3557693,1.2810811,1.224302,1.1392264,1.0476507,0.95565899,0.86001122,0.79052448,0.69436709,0.63044529,0.5316767,0.45683823,0.38051387,0.28689617,0.22636473,0.1354399,0.045896245,-0.017571248,-0.10159354,-0.19685298,-0.21907067,-0.28316298,-0.31394636,-0.35809901,-0.35809901,-0.3118975,-0.25212524,-0.15810552,-0.091072695,-0.0054906738,0.0059737048,0.055507276,0.133003,0.20209873,0.28402295,0.3645428,0.3275492,0.33087009,0.41690092,0.40963054,0.4235716,0.41145658,0.36295111,0.30636827,0.25922681,0.19287291,0.14152926,0.085476745,0.027336315,-0.033493195,-0.091545843,-0.14865683,-0.1926356,-0.24027301,-0.28244559,-0.3209384,-0.37625076,-0.42175367,-0.46898685,-0.51315,-0.55174174,-0.60285962,-0.64950937,-0.6976706,-0.7427171,-0.79635905,-0.83885017,-0.87771707,-0.94290433,-0.98823958,-1.0455226,-1.110938,-1.1442522,-1.2106864,-1.267292,-1.3001136,-1.3350085,-1.3329688,-1.3425269,-1.3640538,-1.3925824,-1.3852013,-1.320523,-1.2499206,-1.1634333,-1.0885982,-1.0133501,-0.93103236,-0.87273078,-0.80637971,-0.74149679,-0.68403924,-0.61355929,-0.5545905,-0.49972933,-0.44048211,-0.38745593,-0.36041532,-0.32641646,-0.31193011,-0.28964314,-0.25509211,-0.24023287,-0.22644802,-0.22644882,-0.19597582,-0.18227836,-0.17158908,-0.16099003,-0.14310163,-0.12841635,-0.13324157,-0.14519687,-0.13084888,-0.14014134,-0.13091615,-0.12942305,-0.10801763,-0.12315524,-0.11383409,-0.10508635,-0.085785963,-0.076893222,-0.064888983,-0.045725946,-0.030699537,-0.026966551,-0.022704833,-0.013719787,-0.0033991023,0.006183927,0.01773553,0.029884362,0.028633235,0.04159881,0.084222901,0.13164166,0.19725681,0.28186857,0.35408013,0.43304399,0.46950391,0.49859231,0.53774415,0.57627936,0.64583429,0.75252282,0.85595908,0.92738961,1.0004699,1.0796347,1.1321711,1.1912872,1.2594025,1.3174416,1.3502053,1.3256013,1.2953998,1.2708854,1.2420379,1.1950536,1.1396531,1.0810437,1.0787474,1.0426029,1.0120538,0.97805533,0.95103047,0.90948344,0.87905549,0.84176788,0.80533773,0.76580471,0.73023909,0.68699925,0.64247791,0.60285298,0.55163704,0.50367599,0.43846037,0.38336118,0.30940727,0.25414472,0.17590634,0.12942037,0.063895274,0.075566328,0.11042088,0.14437121,0.18722536,0.15939307,0.17663039,0.25952284,0.27380839,0.35857718,0.40956776,0.42678952,0.46526765,0.38683413,0.28928609,0.3225017,0.31747516,0.35088339,0.37998666,0.38488622,0.44177104,0.4345752,0.47120011,0.45688493,0.51414367,0.52473653,0.55066321,0.5515876,0.54448261,0.57443502,0.61151986,0.51800157,0.47266847,0.40965995,0.34645604,0.28433387,0.24249604,0.20383433,0.17849163,0.15542263,0.12473366,0.10939524,0.090082826,0.064603284,0.025411406,-0.024654216,-0.062832066,-0.10009798,-0.13611191,-0.16950859,-0.20822721,-0.23689894,-0.28914501,-0.33804769,-0.38409092,-0.43219546,-0.51381675,-0.603861,-0.67635034,-0.75218466,-0.78896922,-0.84599596,-0.84336139,-0.91787417,-0.94528846,-0.9028714,-0.83764313,-0.76263621,-0.67601072,-0.60719302,-0.58228397,-0.64368098,-0.6912618,-0.73774515,-0.81870516,-0.89944871,-0.96398327,-1.0418044,-1.1056288,-1.1347853,-1.1796025,-1.2157048,-1.2405837,-1.2823492,-1.3319876,-1.3829658,-1.4364152,-1.491448,-1.5487229,-1.6175453,-1.6939233,-1.7745469,-1.8566028,-1.9137884,-2.0031106,-2.0550573,-2.104101,-2.1482971,-2.1695587,-2.2154072,-2.2492379,-2.2642334,-2.2725441,-2.2620193,-2.2318702,-2.1945709,-2.1677067,-2.1285277,-2.0941773,-2.0555554,-2.0153363,-1.9751472,-1.9301587,-1.8753033,-1.8211166,-1.7633936,-1.7109744,-1.6462814,-1.586434,-1.5328249,-1.4754262,-1.416942,-1.358585,-1.2961104,-1.2353563,-1.1711279,-1.1046866,-1.0435126,-0.97361565,-0.90910735,-0.83856199,-0.77119006,-0.71208149,-0.64289034,-0.57827257,-0.51819076,-0.43900258,-0.37960311,-0.2934571,-0.23481913,-0.15312511,-0.087643432,-0.013233691,0.064636682,0.14561945,0.21979853,0.27334401,0.33315634,0.37201201,0.40556423,0.42768948,0.41456132,0.37332025,0.32109534,0.26404171,0.21639548,0.14783602,0.097370026,0.0384974,-0.010503265,-0.077439287,-0.12181591,-0.19264772,-0.23684683,-0.31186533,-0.3567635,-0.42223775,-0.48816422,-0.55017727,-0.60460703,-0.68891307,-0.70025652,-0.60214512,-0.49818583,-0.42527226,-0.31905895,-0.21511139,-0.11741125,-0.040249258,0.063731797,0.167964,0.26980997,0.33762019,0.44029619,0.54214145,0.61045493,0.70805116,0.76821611,0.81615735,0.87252648,0.93811376,1.0020037,1.0665093,1.1307286,1.1997182,1.2560744,1.3230531,1.3752677,1.4266054,1.4679537,1.4671894,1.4568261,1.4304289,1.3927462,1.3466242,1.406794,1.4793312,1.5537526,1.6271564,1.701161,1.7737639,1.837814,1.8956768,1.9509739,1.99923,2.0432678,2.0839628,2.1089727,2.1385402,2.1582511:2
1.3532127,1.2694748,1.1405397,0.97776196,0.85434821,0.73706616,0.64296078,0.52413105,0.44865533,0.35216714,0.2845422,0.19483632,0.051475319,0.10010898,0.20507586,0.30829958,0.42575189,0.49908103,0.5517166,0.64420005,0.71992515,0.75679987,0.77321729,0.89223816,0.98089378,1.0109293,1.1212059,1.2525152,1.3690182,1.3722737,1.3062715,1.1981977,1.0668925,0.89003172,0.87070884,0.8093888,0.6720109,0.54419395,0.43534649,0.3451441,0.2637149,0.14329208,-0.014165511,-0.084441351,-0.19485918,-0.36030526,-0.48269639,-0.59208556,-0.54202901,-0.448834,-0.30473212,-0.17918129,-0.032570448,0.057933219,0.17338218,0.3092105,0.40248481,0.54450422,0.67247942,0.72378246,0.82643991,0.93565912,1.0762308,1.1736972,1.3027851,1.4533838,1.59391,1.5776391,1.463093,1.316421,1.2192759,1.1114151,0.98119514,1.0128648,0.9016883,0.82493529,0.75637064,0.69584991,0.62180101,0.52720138,0.4101943,0.29916886,0.31557492,0.25002008,0.13493791,0.092249564,-0.021148929,-0.086329968,-0.21093052,-0.25558641,-0.38974866,-0.49577934,-0.60630974,-0.68794209,-0.67850648,-0.552373,-0.44734152,-0.252704,-0.10197301,0.067069374,0.15465815,0.30910116,0.46364652,0.65970786,0.819153,0.89986062,1.0144381,1.2096685,1.2585821,1.2405118,1.1532002,1.0338513,0.91390147,0.90813511,0.7791571,0.72877516,0.65543571,0.63830955,0.56924083,0.53375819,0.47047289,0.43041261,0.40365793,0.3339065,0.25821786,0.1874933,0.081683297,-0.017001138,-0.087674905,-0.080314058,-0.16398019,-0.2555224,-0.24205439,-0.33803813,-0.45860429,-0.47729564,-0.42716647,-0.52609491,-0.52759749,-0.62160614,-0.70039671,-0.54436055,-0.54782851,-0.42237384,-0.38793731,-0.25156031,-0.14386619,0.0053967032,0.13686591,0.26618509,0.36289797,0.50032642,0.62257098,0.71266693,0.67726314,0.72299564,0.57534859,0.47610704,0.47601072,0.35781778,0.27447915,0.23767689,0.1587518,0.092030398,-0.031836975,-0.11911814,-0.21286116,-0.15291705,-0.2497248,-0.33796583,-0.41380272,-0.49689817,-0.60175514,-0.669653,-0.78741288,-0.87477722,-0.80115059,-0.68980419,-0.51698454,-0.33225856,-0.18568866,-0.15329963,-0.24319,-0.36516686,-0.41859679,-0.49768693,-0.53735412,-0.61171719,-0.56005121,-0.63298295,-0.71175222,-0.78188514,-0.81047603,-0.9015302,-0.93987373,-0.96663769,-1.0322228,-1.1149224,-1.1996857,-1.3005485,-1.3374345,-1.2590561,-1.1605152,-1.1979736,-1.3225924,-1.3918092,-1.4255872,-1.4849903,-1.5552617,-1.6252559,-1.7207848,-1.8150634,-1.9250808,-2.0784434,-2.2319533,-2.3822914,-2.5525991,-2.4413994,-2.3105453,-2.1781038,-2.0937585,-1.9371219,-1.8056691,-1.6841935,-1.6204537,-1.5175985,-1.4698712,-1.3227041,-1.1745287,-1.0460093,-0.91496798,-0.75311656,-0.63265832,-0.577476,-0.44731503,-0.30682666,-0.17316841,-0.021800168,0.076056557,0.21095917,0.33274131,0.43059012,0.57501649,0.72955192,0.85750947,1.000974,1.1267952,1.2742094,1.4195249,1.5688721,1.7135598,1.8773296,2.018654,2.1678393,2.3114252,2.4636779,2.609385,2.7346754,2.7469167,2.8396137,2.8455203,2.9207667,2.7598841,2.6214396,2.483294,2.3443424,2.2012691,2.0599349,1.9182029,1.7736987,1.624468,1.4813765,1.3322934,1.1843093,1.0532497,0.9391659,0.8266726,0.67542881,0.52792807,0.38438701,0.25889787,0.21781443,0.12735954,-0.017396022,-0.16106908,-0.28715731,-0.43802022,-0.58574967,-0.71074551,-0.86590954,-1.008827,-1.0732411,-1.1715342,-1.333226,-1.467482,-1.6068769,-1.7126522,-1.7746313,-1.8194974,-1.9157974,-2.0469339,-2.0064305,-1.886114,-1.8437989,-1.7770675,-1.6423652,-1.5403905,-1.4016407,-1.2509387,-1.1710001,-1.0927199,-1.0497411,-1.0065743,-0.94666654,-0.90275924,-0.82413249,-0.76638977,-0.77148743,-0.69546518,-0.62854399,-0.56097251,-0.58813708,-0.54231347,-0.4889857,-0.44232191,-0.40611947,-0.31785818,-0.3549848,-0.52121504,-0.63778373,-0.71227238,-0.85031219,-0.9719362,-0.89804951,-0.81789157,-0.76515099,-0.69074696,-0.65990933,-0.58488004,-0.52835365,-0.44241686,-0.4007458,-0.5037773,-0.40993448,-0.33581706,-0.27297459,-0.19862262,-0.18435769,-0.084930118,0.0087973446,0.11440719,0.23239449,0.25971171,0.093452114,0.0078420115,-0.15290628,-0.24113035,-0.40660789,-0.55205847,-0.7294091,-0.83775934,-0.89664791,-0.95654154,-0.8518177,-0.73770093,-0.64147367,-0.52226215,-0.41449942,-0.42096831,-0.29678448,-0.220541,-0.11434118,-0.035535875,-0.14160306,-0.054493981,0.058842636,0.10780172,0.25053823,0.20332524,0.30904312,0.3424955,0.4794996,0.58059959,0.67181833,0.69359783,0.69896023,0.62248249,0.50250642,0.35862078,0.23774392,0.096215592,-0.037032494,-0.16652756,-0.30615924,-0.43557642,-0.57160984,-0.6700872,-0.70286977,-0.84239225,-0.84688318,-0.97519228,-0.85808131,-0.69391902,-0.56669548,-0.47012251,-0.33930662,-0.22900681,-0.058377447,-0.14977934,-0.068691562,0.068755678,0.20472681,0.28217258,0.3978073,0.52015251,0.45261186,0.51732142,0.61594124,0.7187822,0.83596819,0.82652684,0.9727397,1.0276392,1.1785758,1.2295923,1.2751901,1.3305797:1
0.25637295,0.14013437,0.068793187,-0.049675351,-0.15198574,-0.16506263,-0.19808626,-0.11035248,-0.15378346,-0.12281601,-0.089408119,-0.12453012,-0.17706286,-0.17412215,-0.23918727,-0.29497819,-0.43411577,-0.52816984,-0.61693282,-0.70881195,-0.78255063,-0.85563452,-1.0609577,-0.98171655,-0.81987106,-0.64693585,-0.60902964,-0.51016925,-0.48101058,-0.54391167,-0.66616044,-0.76538974,-0.8403214,-0.93050502,-1.0392759,-1.0872683,-1.1666068,-1.2224775,-1.3058823,-1.4161391,-1.5826377,-1.7366874,-1.901079,-2.0774019,-2.2106138,-2.3839398,-2.457973,-2.5790639,-2.5311662,-2.6873857,-2.6259901,-2.7989434,-2.9348833,-2.9596402,-3.0353668,-2.9063091,-2.8159178,-2.624426,-2.5152214,-2.3421412,-2.1911311,-2.0804835,-1.9455711,-1.7703893,-1.6025151,-1.4335287,-1.3396236,-1.1623667,-1.0096021,-0.84163618,-0.67430878,-0.48503457,-0.344409,-0.16941681,0.010410697,0.16065345,0.33443745,0.31240237,0.44907528,0.59248141,0.70842773,0.84687059,1.0306476,1.1815429,1.3466058,1.5371133,1.687145,1.8389651,1.9801668,2.1462445,2.310735,2.4149888,2.532234,2.6085824,2.5892985,2.6429584,2.547409,2.4327685,2.3209114,2.176622,1.9721919,1.7894481,1.5913285,1.4381482,1.2631784,1.0905068,0.95776985,0.81585348,0.64797765,0.49280117,0.30843695,0.17482951,0.048487804,-0.085347507,-0.26580821,-0.4095592,-0.62247419,-0.76956693,-0.93002082,-1.0933318,-1.2298044,-1.3790822,-1.45381,-1.415438,-1.2771798,-1.1446607,-1.078791,-0.98169515,-0.89891216,-0.82208898,-0.74441709,-0.68410598,-0.65774929,-0.67062699,-0.62183723,-0.63524303,-0.60573085,-0.53969308,-0.51464779,-0.44157686,-0.3802583,-0.31339093,-0.25221826,-0.20859058,-0.33183708,-0.48131668,-0.69183867,-0.76879524,-0.71514308,-0.66784699,-0.63469227,-0.60288166,-0.57498509,-0.5942935,-0.58712483,-0.49808708,-0.44054883,-0.39746305,-0.4176332,-0.31277756,-0.43706679,-0.41642197,-0.32465379,-0.28310525,-0.36053877,-0.33685018,-0.2926452,-0.20091675,-0.0679853,-0.044468126,-0.15389706,-0.20352626,-0.31327999,-0.37669871,-0.45477852,-0.53988826,-0.64522167,-0.69934433,-0.86610836,-0.82307298,-0.9192489,-0.82379323,-0.7305365,-0.61853749,-0.44455996,-0.40276529,-0.35766318,-0.20351651,-0.14930363,-0.036155115,0.01385727,0.074759472,0.21901432,0.1996121,0.30816921,0.40816084,0.53340395,0.53579098,0.41602219,0.49960333,0.5544799,0.62220892,0.69654654,0.7698019,0.911467,0.98951748,0.99712678,1.0005501,1.0980663,1.2367406,1.3870986,1.5322989,1.4253425,1.282618,1.1546721,1.0649584,0.90265957,0.7590069,0.62774286,0.70812355,0.54483817,0.43013885,0.24050828,0.068389666,-0.086246508,-0.25691194,-0.41987474,-0.3216418,-0.39146961,-0.44244673,-0.31087357,-0.25124374,-0.21644975,-0.13461432,-0.07756731,-0.0074681546,-0.05927495,0.0059174673,0.08787793,0.21536451,0.37431163,0.35834334,0.26719759,0.25791427,0.31151282,0.19600186,0.3336575,0.42295019,0.47236877,0.53066055,0.62917862,0.66650768,0.76834967,0.8738094,0.98461692,1.0522577,1.0153833,0.88044597,0.77786476,0.61607852,0.52466853,0.35407993,0.23172261,0.12287,-0.030694514,-0.060038787,-0.1400599,-0.28550215,-0.42249989,-0.54148529,-0.71265128,-0.88695199,-0.9727072,-1.031859,-0.8975957,-0.80702364,-0.71560942,-0.61044396,-0.63534564,-0.51140455,-0.46984336,-0.42148628,-0.34699045,-0.32672732,-0.31373002,-0.37856599,-0.27880379,-0.22092717,-0.34665759,-0.2750431,-0.16721186,-0.073675741,0.03248512,0.17694864,0.2157358,0.2689931,0.21418625,0.29478522,0.25410579,0.15063687,0.086838753,-0.046672651,0.020713724,0.10206304,-0.020730363,-0.12452581,-0.22836257,-0.33146743,-0.44038375,-0.54490389,-0.65638762,-0.7303449,-0.62171816,-0.64689864,-0.54925762,-0.39805885,-0.35135333,-0.28358987,-0.23877601,-0.16475259,0.0065918763,0.15536283,0.27919087,0.46237242,0.48030858,0.58561348,0.73921261,0.81174106,0.95331633,1.0384865,1.1366451,1.1432354,1.322135,1.4785878,1.6071228,1.7303905,1.8773782,1.759127,1.6670635,1.5578577,1.4429726,1.4603489,1.3733441,1.2497647,1.1821852,1.0891247,1.1826471,1.1148338,1.0081853,0.93048992,0.83249496,0.73190158,0.62145754,0.67646559,0.67277922,0.78745872,0.77778078,0.67498164,0.57712215,0.51816856,0.40844796,0.29994472,0.43735198,0.31039565,0.19793362,0.061047171,0.17094834,0.015176385,-0.10050774,-0.095687434,-0.19800859,-0.39033966,-0.3721588,-0.36568998,-0.23814096,-0.10142711,0.046941429,0.20270049,0.35129516,0.50074896,0.64295393,0.7845804,0.82507969,0.94679743,1.1140419,1.2504163,1.4061382,1.4999068,1.3509292,1.2613153,1.1868485,1.1665129,1.1000773,1.0536187,0.93813287,0.92654838,0.93920523,0.85997853,0.74983184,0.70813939,0.7029473,0.6388875,0.52983121,0.39328183,0.33449634,0.24771506,0.3146267,0.25021414,0.13166976,0.040042655,-0.046277192,-0.12053948,-0.16332065,-0.30284445,-0.2792055,-0.37013757,-0.41671993,-0.47053545,-0.57909331,-0.44889611,-0.29712587,-0.17746919,-0.0128703,0.17856246,0.2446289,0.17253478,0.23364052:1
0.36180723,0.27361217,0.2079738,0.14873008,0.021110053,-0.10117389,-0.21716641,-0.31545123,-0.43146952,-0.5105908,-0.5536482,-0.51451572,-0.55092255,-0.66562564,-0.79671329,-0.9133815,-1.0078992,-1.1203493,-1.2126977,-1.2926181,-1.3823811,-1.4749969,-1.5513884,-1.6328367,-1.6947701,-1.7555304,-1.8081027,-1.852474,-1.9007266,-1.9204017,-1.9067096,-1.8293038,-1.7452464,-1.6541643,-1.5522752,-1.4596828,-1.3649287,-1.2756899,-1.1743272,-1.0828662,-0.99012379,-0.88817735,-0.7970995,-0.70004094,-0.59920923,-0.50691699,-0.41406754,-0.30844849,-0.2175342,-0.11306615,-0.014147672,0.071696323,-0.032422142,-0.10690924,-0.18840885,-0.25818704,-0.33095805,-0.39384711,-0.44092827,-0.45505025,-0.37508117,-0.32525828,-0.33417199,-0.38844261,-0.44040112,-0.50898155,-0.57443541,-0.62206111,-0.67054148,-0.70493331,-0.74389918,-0.78146044,-0.82194974,-0.85839613,-0.89143952,-0.91113181,-0.90746157,-0.88055253,-0.84434361,-0.797028,-0.7382157,-0.66935754,-0.57491972,-0.45786204,-0.3252927,-0.21589519,-0.13365701,-0.063220548,0.0054685538,0.059178569,0.11253438,0.1638099,0.21448393,0.24879211,0.28142633,0.31381987,0.38201744,0.36510552,0.37051968,0.38718159,0.41415117,0.44843687,0.50227515,0.60137798,0.59215969,0.5713609,0.55770408,0.57553666,0.59716815,0.60962565,0.63224875,0.65254061,0.65828695,0.67360903,0.69638779,0.71770225,0.73748496,0.75243294,0.78594578,0.84602241,0.89680629,0.90970642,0.92026777,0.91400447,0.90912499,0.93581362,1.0142783,1.0983749,1.1815236,1.276538,1.3739395,1.469633,1.5657029,1.660206,1.7569949,1.8521057,1.9487887,2.0449695,2.1381219,2.2348756,2.2826389,2.1757835,2.0804793,1.9848351,1.8891368,1.7929064,1.6956395,1.6064533,1.5087403,1.413072,1.3153158,1.2246453,1.145938,1.2407396,1.3105828,1.2621837,1.2913493,1.3056166,1.3062576,1.2950187,1.2963466,1.2883325,1.2597342,1.2213959,1.1744937,1.1165846,1.0556312,1.0161047,0.95440018,0.91058179,0.87299053,0.83197193,0.80970596,0.7901029,0.78063786,0.77819446,0.77733791,0.76773911,0.72430435,0.7210566,0.69270005,0.69777274,0.72740719,0.76361358,0.7262649,0.67103594,0.6172835,0.5544691,0.47801241,0.41720922,0.35772533,0.30252555,0.24907395,0.19493209,0.14698833,0.085271822,0.025780776,-0.061889248,-0.15379017,-0.2457935,-0.3350751,-0.4069985,-0.4677089,-0.53353495,-0.57488411,-0.58850383,-0.59054078,-0.58543252,-0.56191006,-0.53258675,-0.51147879,-0.49243291,-0.4782648,-0.46387184,-0.44265245,-0.42234036,-0.38820869,-0.33525751,-0.32306666,-0.41735144,-0.47402706,-0.47903822,-0.46261418,-0.42831488,-0.37163501,-0.31048188,-0.22988352,-0.17426968,-0.099043307,-0.022195548,-0.095865789,-0.19460254,-0.28335292,-0.36344951,-0.44916784,-0.52431314,-0.60901389,-0.68561748,-0.75430242,-0.84391351,-0.91753593,-1.005929,-1.0827024,-1.1730345,-1.2621106,-1.3536475,-1.4521342,-1.5516215,-1.6396251,-1.7633137,-1.8310529,-1.8778422,-1.9086216,-1.9259277,-1.9235456,-1.908777,-1.8629721,-1.8010127,-1.7327923,-1.6626246,-1.5657845,-1.4780136,-1.3752115,-1.2851396,-1.1872398,-1.0669222,-0.94889195,-0.84240155,-0.71881593,-0.77469489,-0.75596953,-0.67747716,-0.57701646,-0.4732677,-0.36431277,-0.24875269,-0.13764723,-0.080001364,0.0048500259,0.12125211,0.022072004,-0.091169588,-0.19533019,-0.24285503,-0.33052374,-0.45262875,-0.58000414,-0.68374551,-0.7914409,-0.88273093,-0.98445111,-1.0713133,-1.1643643,-1.2539113,-1.3523694,-1.43622,-1.5357082,-1.6121438,-1.6767162,-1.7204492,-1.7235307,-1.6927439,-1.6324818,-1.5514643,-1.4679242,-1.3830262,-1.2919368,-1.1992168,-1.1056679,-1.0045661,-0.90420428,-0.81064848,-0.70848775,-0.6125735,-0.51258351,-0.41840741,-0.31739073,-0.2148422,-0.10279418,0.0053642034,0.10781923,0.21013987,0.31423521,0.32156573,0.31330668,0.38483533,0.47091062,0.5580304,0.64859793,0.74135638,0.83734897,0.93616281,1.0285433,1.1314363,1.0734589,0.96493746,0.85562575,0.74650213,0.63610511,0.55641613,0.49979835,0.48675429,0.53777763,0.62134363,0.71321059,0.80710783,0.89753765,0.99377915,1.0857385,1.1777332,1.2741932,1.3657333,1.4600032,1.5563596,1.5992095,1.5284249,1.5688328,1.6679517,1.7573664,1.856156,1.9560596,2.0236942,1.9224993,1.8297121,1.7330814,1.6591208,1.6446211,1.5445925,1.4522468,1.3558715,1.2649375,1.1628068,1.0731583,0.97257981,0.87772814,0.78394259,0.6883973,0.64738171,0.66622553,0.70789649,0.78299536,0.878029,0.98328742,1.0951828,1.1808845,1.136504,1.0338209,0.94312714,0.84237148,0.75342783,0.7091236,0.69958975,0.65645077,0.56284987,0.46743283,0.37340348,0.28004848,0.18169029,0.088286469,-0.0068225548,-0.10010926,-0.19582631,-0.29082978,-0.38570979,-0.48501038,-0.56749482,-0.66396044,-0.75662387,-0.84148298,-0.90937624,-0.91770782,-0.88690056,-0.83654524,-0.78347232,-0.71780224,-0.64816635,-0.56767822,-0.48292102,-0.39874925,-0.31419125,-0.22850108,-0.13878213,-0.033660008,0.014752672,0.09567766,0.19696404,0.30802426:4
1.1854842,1.115287,1.0690713,1.0734992,1.0353621,0.97048844,0.89860297,0.81836794,0.72918593,0.6489471,0.54632798,0.44288036,0.34634113,0.25380965,0.12972708,0.015069835,-0.088913692,-0.18028337,-0.30353396,-0.39363114,-0.51677005,-0.64291953,-0.76389079,-0.89455389,-1.0197029,-1.1443521,-1.2794247,-1.3904033,-1.4555514,-1.3863652,-1.3189724,-1.2766704,-1.1746937,-1.0728325,-0.96309881,-0.94918941,-0.85003317,-0.73771919,-0.63335555,-0.54617026,-0.44261547,-0.34546661,-0.23172818,-0.14166773,-0.12388523,-0.013118793,0.096699533,0.18121719,0.25607009,0.35061254,0.44678521,0.54685499,0.61283459,0.71399208,0.80579843,0.92602069,1.0079099,1.0934267,1.1808775,1.1886834,1.2072017,1.1769135,1.1405842,1.0595574,0.98821745,0.88980756,0.78804427,0.66368003,0.55187152,0.41467338,0.30380552,0.16992078,0.06109601,-0.071363934,-0.18647454,-0.30043402,-0.42019466,-0.53419911,-0.63933071,-0.74400128,-0.85470323,-0.96501614,-1.0685329,-1.1561965,-1.268327,-1.349594,-1.4379768,-1.541732,-1.6348096,-1.7169406,-1.8026179,-1.8893922,-1.9924482,-2.0889339,-2.1749523,-2.2668284,-2.3697457,-2.4352559,-2.5300871,-2.6231717,-2.7273163,-2.7651055,-2.598984,-2.5127062,-2.3423686,-2.1788709,-2.050364,-1.9137658,-1.78304,-1.6530771,-1.5262877,-1.3907556,-1.2604174,-1.1296883,-0.99149005,-0.84248806,-0.69568309,-0.56455872,-0.43384626,-0.26329099,-0.13426972,-0.0044327152,0.16696958,0.31236936,0.40643666,0.50566386,0.65983898,0.7488298,0.8735711,0.97667793,1.040737,1.0832618,1.1204241,1.1507965,1.1652862,1.1606054,1.1510152,1.1050594,1.080251,1.041773,1.0047077,0.95427551,0.88809832,0.81147133,0.75969222,0.71201389,0.64540028,0.58019658,0.49873113,0.43746842,0.36370777,0.30780742,0.2488446,0.17897354,0.10376595,0.048725557,-0.047441483,-0.13247188,-0.21202613,-0.32397145,-0.3656704,-0.41457174,-0.4790795,-0.56037185,-0.65489085,-0.74046638,-0.8627426,-0.99570038,-1.0901329,-1.1915567,-1.3383995,-1.4393216,-1.5698348,-1.6896477,-1.6891694,-1.6504724,-1.5983012,-1.519946,-1.403862,-1.2874457,-1.1698828,-1.0553767,-0.94336527,-0.80225337,-0.69496833,-0.60321864,-0.49192337,-0.36205044,-0.24545195,-0.1418647,-0.01497181,0.11114954,0.2124846,0.33525056,0.45884642,0.55924628,0.63514054,0.70155536,0.7652776,0.82136761,0.8502399,0.8652949,0.87427477,0.90106823,0.91111091,0.90772691,0.88198782,0.91639445,0.90038394,0.88273884,0.85137387,0.84887143,0.83504269,0.79808807,0.81669006,0.82091703,0.79029662,0.77320918,0.72701229,0.72587015,0.66988717,0.63582283,0.59333326,0.54947731,0.52882475,0.54841594,0.57063498,0.59785844,0.62459332,0.63475741,0.66114708,0.660506,0.65460619,0.62062045,0.62660032,0.57180795,0.51087932,0.56325648,0.68792586,0.73837529,0.84167861,0.92486079,1.0929769,1.2544915,1.3508002,1.4460632,1.477486,1.4888076,1.5402428,1.5705564,1.5074412,1.3974215,1.2646978,1.1156367,0.9467655,0.81713611,0.64808193,0.48556298,0.41770743,0.38223809,0.3516193,0.3451108,0.36149692,0.38635549,0.38459708,0.36177594,0.35122463,0.32207098,0.29710556,0.26113273,0.2291469,0.19474549,0.15732821,0.11565922,0.059066851,-0.0049814861,-0.058870314,-0.11492447,-0.17929469,-0.22904291,-0.27780101,-0.31899158,-0.36831339,-0.42676279,-0.47447571,-0.50706064,-0.55433552,-0.52900375,-0.4844948,-0.36770129,-0.27035435,-0.2076736,-0.09586768,-0.041740796,0.027199752,0.10839538,0.17355856,0.2278901,0.30196293,0.38734734,0.43960722,0.51757505,0.57256991,0.62141577,0.68371622,0.73426908,0.78800864,0.83955041,0.85247934,0.88911766,0.89404199,0.86129134,0.76572204,0.66541797,0.56295873,0.46261576,0.35879504,0.2307202,0.12399041,0.0027084655,-0.13091444,-0.26133531,-0.39424005,-0.52405594,-0.69405136,-0.82251831,-0.99381126,-1.1618625,-1.2927187,-1.4619647,-1.6305056,-1.8001836,-1.9681181,-2.0942312,-2.1166266,-2.1865507,-2.1710903,-2.0942037,-2.02101,-1.930603,-1.8475417,-1.7215096,-1.6334541,-1.5193261,-1.4072708,-1.3054782,-1.1871121,-1.0722911,-0.96776835,-0.86377755,-0.76336816,-0.6631276,-0.55333848,-0.44391593,-0.3316853,-0.23266742,-0.13693953,-0.051234807,0.055594969,0.16105611,0.2456099,0.33995242,0.44628157,0.53818962,0.6356247,0.72162131,0.80680496,0.89432297,0.98748437,1.0704455,1.1449308,1.2399265,1.3275872,1.3979582,1.4687432,1.5079372,1.5239222,1.5224547,1.4821287,1.4324205,1.3558519,1.3719484,1.2906173,1.21717,1.0983392,0.96224697,0.84136321,0.7196559,0.59462917,0.47841072,0.36353172,0.22532197,0.11831063,-0.018127792,-0.12302185,-0.24659072,-0.35976019,-0.46458805,-0.58612837,-0.64520819,-0.70374809,-0.57675739,-0.45263923,-0.32596354,-0.20099606,-0.062598818,0.042218416,0.18744885,0.31878713,0.45661803,0.54593273,0.62742673,0.70255518,0.75840765,0.81952581,0.86005478,0.90990229,0.96683106,1.0161461,1.0611337,1.1005095,1.1544086,1.1814843,1.2255127,1.239142,1.2837465,1.2091268:2
1.9933094,1.887765,1.7778919,1.655484,1.5297691,1.4339658,1.4096835,1.4077955,1.4102603,1.4110763,1.4218009,1.4235635,1.4111899,1.3939674,1.3789893,1.3629377,1.3474772,1.3354548,1.3218405,1.2976409,1.2572904,1.2233341,1.1957134,1.1647708,1.1373502,1.0994639,1.0677577,1.0430297,1.0184286,0.98965188,0.96718305,0.94793172,0.92507156,0.91421511,0.8935999,0.87271194,0.85271385,0.81363223,0.80216483,0.78605788,0.76472782,0.73727187,0.70512165,0.6677685,0.59005012,0.51190213,0.42305752,0.33483808,0.23366263,0.14615676,0.056571176,-0.044855966,-0.13156295,-0.22891789,-0.26498505,-0.30740931,-0.33435584,-0.36675152,-0.403701,-0.42678001,-0.44198741,-0.47014592,-0.51257066,-0.52524922,-0.53216457,-0.5255081,-0.50664275,-0.49693586,-0.47966252,-0.47419097,-0.47589038,-0.45760709,-0.4322305,-0.4269149,-0.41052418,-0.36867222,-0.32179324,-0.27155383,-0.21458451,-0.15276283,-0.09335008,-0.021298422,0.03503202,0.13042405,0.21034219,0.1543035,0.053430316,-0.049101722,-0.1515135,-0.25296862,-0.38008004,-0.44040899,-0.54271852,-0.64178731,-0.73539482,-0.84472354,-0.94609126,-1.0463703,-1.1447809,-1.2421371,-1.3422517,-1.4537557,-1.575015,-1.6669209,-1.7531716,-1.8324054,-1.9029307,-1.9614642,-2.015491,-2.0551809,-2.074069,-2.0597347,-2.0170721,-1.9653845,-1.8965135,-1.8308192,-1.7597358,-1.689964,-1.6147682,-1.5427983,-1.471875,-1.3867143,-1.3101446,-1.2191396,-1.1431949,-1.0522621,-0.97071108,-0.88760778,-0.79027441,-0.69975896,-0.61821746,-0.52683392,-0.43790802,-0.35522877,-0.42304925,-0.50882356,-0.50627745,-0.40280679,-0.30520388,-0.21004626,-0.11204801,-0.020972026,0.079018269,0.16907302,0.26978204,0.23896248,0.14892258,0.053527497,-0.037003955,-0.12549058,-0.20553956,-0.29917697,-0.38589808,-0.4671614,-0.54626004,-0.63155186,-0.70933633,-0.79333089,-0.87282389,-0.94417676,-1.0155098,-1.0654748,-1.0757936,-1.0649711,-1.0213299,-0.9630389,-0.87105722,-0.77515261,-0.67724754,-0.57922522,-0.48049856,-0.35746845,-0.25720095,-0.15686501,-0.042189544,0.06883508,0.17947545,0.29692702,0.42409114,0.52811181,0.65520069,0.78188869,0.80956064,0.76608025,0.86630308,0.97042009,1.0714808,1.1313752,1.0351173,0.92957428,0.85258039,0.79075678,0.73207236,0.6876633,0.68424963,0.71704588,0.77423013,0.85953586,0.94347561,1.0440001,1.1334991,1.2245218,1.3242274,1.4151904,1.5158607,1.5679745,1.470008,1.4427237,1.527722,1.6552098,1.7785699,1.8619027,1.9727391,1.934858,1.8317005,1.7549901,1.6845365,1.6068066,1.5880044,1.4905443,1.4099374,1.2881583,1.1891551,1.0651332,0.94691517,0.90384316,0.89933795,0.94901613,1.0166904,1.0940057,1.1705159,1.2539629,1.1670872,1.0762477,0.97252101,0.92099267,0.83390519,0.7322056,0.61049254,0.50682756,0.40492125,0.28382928,0.16456103,0.062957394,-0.057208886,-0.15748684,-0.2763882,-0.35048703,-0.44499407,-0.53052719,-0.60793347,-0.65507344,-0.69632724,-0.71412545,-0.70533113,-0.66791919,-0.62012947,-0.56985835,-0.50259123,-0.4263994,-0.33422692,-0.25145681,-0.15733447,-0.061397101,0.029179295,0.12702065,0.20078737,0.24496037,0.33224314,0.43545058,0.48698725,0.39644592,0.30137319,0.21365125,0.12600414,0.038816741,-0.05141289,-0.1343307,-0.17451368,-0.10163698,-0.12311238,-0.22032734,-0.31407762,-0.39472928,-0.49096306,-0.57648926,-0.66561003,-0.75062233,-0.84079355,-0.92208509,-1.0040422,-1.0906221,-1.165329,-1.2527824,-1.3356423,-1.412171,-1.4870247,-1.5651477,-1.6365705,-1.7122539,-1.7831025,-1.8501903,-1.9120014,-1.9666696,-2.0208571,-2.0737712,-2.1008628,-2.0878957,-2.0608,-2.0063379,-1.9355076,-1.8517062,-1.7605189,-1.6716541,-1.5838905,-1.4585572,-1.3388081,-1.2503746,-1.1627983,-1.0599354,-0.936191,-0.8377812,-0.71418466,-0.5923907,-0.58147775,-0.48943759,-0.3783548,-0.27595388,-0.15934062,-0.068620326,0.041185501,0.1614022,0.26536661,0.19879292,0.081934803,-0.01546187,-0.030980756,-0.11911102,-0.19430403,-0.28308793,-0.36250411,-0.42473158,-0.47922178,-0.52499375,-0.56167906,-0.60604556,-0.65220787,-0.69107845,-0.72848198,-0.76017874,-0.78853775,-0.81771902,-0.84000843,-0.86257989,-0.86974364,-0.87910755,-0.887256,-0.88963415,-0.88781834,-0.88294958,-0.87053945,-0.85277086,-0.82390828,-0.79001998,-0.75791661,-0.72249563,-0.65110449,-0.5691061,-0.47953028,-0.36241447,-0.25588159,-0.17002103,-0.096943143,-0.021085873,0.057453844,0.12444059,0.2004329,0.27218175,0.33912088,0.40797256,0.46916449,0.51508021,0.53798637,0.52362628,0.51339518,0.49490264,0.49133252,0.50466209,0.55798098,0.53880722,0.5157818,0.5034244,0.50227763,0.50576094,0.53327771,0.55801507,0.59015988,0.62345538,0.64791613,0.67953269,0.72358394,0.78464322,0.83706295,0.88146101,0.93173575,0.9707672,1.0168076,1.0648293,1.112586,1.1503615,1.1907277,1.228435,1.2585201,1.285267,1.3038037,1.3180445,1.3288082,1.3461649,1.365168,1.4166155,1.5018911,1.5199283,1.5984319,1.6918475,1.7936284,1.8809695,1.9769963:4
2.2867557,2.2989964,2.3053849,2.3698614,2.3854772,2.3712089,2.3447924,2.3091124,2.2881262,2.2530562,2.174888,2.0884813,2.0111491,1.9515968,1.8447251,1.7399006,1.6816683,1.592917,1.4983141,1.4210727,1.3148773,1.235516,1.1714763,1.0849699,0.97809279,0.88332733,0.84653254,0.72167898,0.65984362,0.55702512,0.47681576,0.38786274,0.31010972,0.23137872,0.13600189,0.04796328,-0.023584511,-0.10903037,-0.18689554,-0.28582612,-0.34998491,-0.44350606,-0.52556516,-0.59940223,-0.68726356,-0.75692909,-0.84348249,-0.93879463,-0.97941631,-1.0656103,-1.154,-1.2024796,-1.2867901,-1.3381122,-1.3876379,-1.4561418,-1.5163293,-1.556893,-1.5988827,-1.6362193,-1.6791867,-1.7082552,-1.7278857,-1.7462168,-1.7708795,-1.8003284,-1.8298542,-1.8349543,-1.8429045,-1.8469694,-1.8728992,-1.8851506,-1.8813834,-1.8655711,-1.8565277,-1.8535577,-1.8448896,-1.8131151,-1.7901217,-1.7330172,-1.6645627,-1.5887329,-1.5516768,-1.4899531,-1.431385,-1.3740796,-1.3327555,-1.3000775,-1.2369545,-1.1732987,-1.1073086,-1.0299823,-0.96100712,-0.89156932,-0.81599159,-0.79363279,-0.71561552,-0.64055905,-0.55810891,-0.47472852,-0.40204678,-0.36804641,-0.2908152,-0.21478582,-0.17607802,-0.10862906,-0.024670132,0.044529815,0.08592839,0.13671745,0.17638274,0.23622608,0.26177578,0.29176091,0.34836532,0.37156037,0.39954591,0.45578257,0.48251146,0.49863208,0.5783607,0.60782057,0.66416962,0.71081464,0.75236416,0.82738367,0.84452884,0.8815467,0.94617739,0.99840443,1.0097735,1.0430832,1.0692067,1.0827367,1.0668743,1.0897183,1.0777844,1.044903,1.0164731,0.98261711,0.9281317,0.90020303,0.84895342,0.83388355,0.77527672,0.73316846,0.67504452,0.64999475,0.59593138,0.55215891,0.49275031,0.41964634,0.37689478,0.31516094,0.26264397,0.19558872,0.1320307,0.093104531,0.046809448,0.046809448,0.14152292,0.19744135,0.24968042,0.36005451,0.42275015,0.50994883,0.60692402,0.63271098,0.66162705,0.66062006,0.68186241,0.71814021,0.74491645,0.73365635,0.67450978,0.57776573,0.53622155,0.43888103,0.34492988,0.3088941,0.26776813,0.21137642,0.20322877,0.20820324,0.21871869,0.26075151,0.29964999,0.29268312,0.32171369,0.33437002,0.33710651,0.37084097,0.38934006,0.43131595,0.52462562,0.61032364,0.6573214,0.74005946,0.8354073,0.92261048,1.0113358,1.0861074,1.1399596,1.1657796,1.1887711,1.1873836,1.1570794,1.141422,1.1314516,1.1255101,1.1390469,1.1548884,1.1220398,1.057756,1.0189188,0.99983086,0.98467546,0.990261,0.99616848,0.98772735,1.0225556,1.0184884,1.0260632,1.0258299,0.98360666,0.96684168,0.95739606,0.91367286,0.87106307,0.83220909,0.80716431,0.79519017,0.75562178,0.69621861,0.65029365,0.57115702,0.52501999,0.44320879,0.39715349,0.3171517,0.27485012,0.22785207,0.14198144,0.069931415,-0.035738517,-0.095094767,-0.19763536,-0.26822516,-0.33109756,-0.4116929,-0.49103487,-0.53689077,-0.61281564,-0.62195452,-0.60798602,-0.55267817,-0.49855542,-0.44250237,-0.37373392,-0.32234182,-0.24096697,-0.17067569,-0.11940663,-0.059791031,-0.0063467304,0.051518697,0.09253213,0.15450983,0.18631955,0.24063491,0.26183048,0.28912939,0.29379323,0.23926197,0.18073734,0.12108124,0.066836793,-4.760303E-4,-0.068105679,-0.13161254,-0.21472926,-0.3093313,-0.35688516,-0.39394811,-0.44669157,-0.47362592,-0.48658071,-0.49649523,-0.48396,-0.45079146,-0.41607679,-0.41013707,-0.40582427,-0.37657733,-0.34290958,-0.32615238,-0.29968798,-0.24770433,-0.23508859,-0.23171953,-0.23113545,-0.24191448,-0.24750015,-0.26791544,-0.2757238,-0.28936305,-0.32549076,-0.33970993,-0.38693896,-0.41694236,-0.43984523,-0.51341106,-0.55950988,-0.58031533,-0.65423958,-0.72647722,-0.81421403,-0.84409318,-0.85221604,-0.92544656,-1.0169995,-1.0686717,-1.1601944,-1.2111507,-1.2247418,-1.2558561,-1.365392,-1.3869062,-1.3859584,-1.4492685,-1.5400786,-1.6535643,-1.7294102,-1.814345,-1.858542,-1.838186,-1.7330521,-1.6262287,-1.5150192,-1.4085006,-1.2999073,-1.2472131,-1.1664425,-1.0969338,-1.0582037,-1.0217479,-0.96432994,-0.903239,-0.87301422,-0.82545869,-0.76968919,-0.73391939,-0.70932186,-0.68438637,-0.64696582,-0.62735727,-0.61520011,-0.59446271,-0.59060674,-0.58839387,-0.53476451,-0.50546066,-0.49301666,-0.47719856,-0.43159463,-0.41022768,-0.42805302,-0.4283631,-0.41749173,-0.38326201,-0.44231548,-0.4584735,-0.47973022,-0.48281838,-0.54205709,-0.59574262,-0.64098423,-0.68965874,-0.76839362,-0.82492669,-0.82632051,-0.83613486,-0.88421466,-0.86727569,-0.87136166,-0.87841524,-0.86500378,-0.84219736,-0.83004088,-0.7958918,-0.7338667,-0.65850582,-0.57907809,-0.49341929,-0.41347909,-0.35795063,-0.24525915,-0.1857448,-0.087564688,-0.016463802,0.081760629,0.19049262,0.24032629,0.33265962,0.4281448,0.51521839,0.59116198,0.67342605,0.76772267,0.85523618,0.93519454,1.0205331,1.1213331,1.201599,1.2527534,1.3658579,1.4661662,1.5342664,1.6065629,1.7137078,1.8086677,1.8673645,1.95923,2.056761,2.1513733,2.1969655,2.2763749:2
0.27072883,0.25580177,0.19985433,0.25017848,0.18007031,0.18360813,0.17326898,0.096740946,0.053797161,-0.10737223,-0.14782302,-0.24520921,-0.34063311,-0.22622853,-0.10984456,-0.11973629,-0.23460536,-0.23337988,-0.36753101,-0.46934124,-0.57051761,-0.59132144,-0.57933848,-0.69435155,-0.80770038,-0.91435349,-0.98366842,-0.96391121,-1.1357838,-1.2011712,-1.2625361,-1.1419858,-1.2528223,-1.2520921,-1.2940677,-1.3044569,-1.3027321,-1.2880956,-1.3417703,-1.3837894,-1.3717412,-1.4384191,-1.4779663,-1.5031483,-1.5494189,-1.5534881,-1.5255492,-1.3720118,-1.2101502,-1.0928868,-0.98962238,-0.85055635,-0.71140427,-0.54810031,-0.48471371,-0.41816026,-0.28549884,-0.13415869,-0.09324219,-0.029297077,0.11216273,0.24958515,0.40116009,0.45251269,0.56734915,0.56457823,0.64990115,0.76108726,0.84324991,0.99637955,1.1599906,1.3001129,1.4459385,1.5915731,1.6501667,1.8302779,1.8381301,1.8619302,1.9114981,1.8326141,1.7232695,1.6074966,1.5069575,1.4025235,1.332666,1.316086,1.1666347,1.0577197,0.90287894,0.81395736,0.66420576,0.52178191,0.39269666,0.36501419,0.23009728,0.064911933,-0.07780137,-0.21461417,-0.36589603,-0.4832107,-0.66194612,-0.71320787,-0.84934644,-0.99828968,-1.1410845,-1.1131582,-1.241211,-1.2570196,-1.3292819,-1.1998682,-1.1563166,-1.2001334,-1.112315,-1.0650367,-0.99286595,-0.91778479,-0.95647882,-0.92440875,-0.88889194,-0.85782168,-0.81194064,-0.78513677,-0.74997659,-0.63108075,-0.6410402,-0.57439112,-0.54606268,-0.51285301,-0.48463377,-0.40779204,-0.36043579,-0.25134281,-0.19223748,-0.15231727,-0.10093969,-0.053769496,0.021304,0.071415201,0.08894764,0.12388816,0.089994414,-0.039055981,-0.19520843,-0.30464011,-0.45379124,-0.46727759,-0.46547748,-0.60051604,-0.65308513,-0.62456015,-0.60485343,-0.56044986,-0.45902052,-0.35415566,-0.25078589,-0.11845655,-0.10899219,-0.061802663,0.0142644,0.09565709,0.17818165,0.24806031,0.30573098,0.37733087,0.43622253,0.48843411,0.57143349,0.63891976,0.70078774,0.62036621,0.49052025,0.37891572,0.39873848,0.47948464,0.47011261,0.54511292,0.59109974,0.56339502,0.67322758,0.7838066,0.88031313,0.957675,1.0086903,0.93939231,1.0582604,1.1861894,1.303068,1.415786,1.4495439,1.5657123,1.6607804,1.7738227,1.9078692,1.9910517,2.090943,2.0553127,1.9526202,1.8659812,1.6800188,1.5311058,1.3352366,1.1349856,0.97704893,0.86647546,0.74477253,0.54076653,0.36427548,0.18455147,0.025581955,-0.10647124,-0.10467697,-0.22286041,-0.28192925,-0.39971242,-0.58818086,-0.75908556,-0.94380483,-1.1008758,-1.3023592,-1.4569961,-1.6593641,-1.8145341,-1.7468493,-1.6273333,-1.7761466,-1.7381286,-1.6321563,-1.5951847,-1.5506663,-1.4828264,-1.3770998,-1.3674894,-1.2641652,-1.2262414,-1.2370252,-1.2218105,-1.3504555,-1.4337679,-1.3101458,-1.1867279,-1.0243403,-0.90852664,-0.77119708,-0.64682573,-0.60553749,-0.66824459,-0.69366579,-0.56470771,-0.43563691,-0.32211321,-0.28669271,-0.14242994,-0.027167525,0.073867902,0.0048753743,0.012319162,-0.058104762,-0.16551787,-0.23963696,-0.1493406,-0.0093281504,0.098151425,0.21987612,0.37699176,0.48477498,0.51077539,0.50451903,0.51869867,0.6730743,0.80454332,0.97143029,1.0907344,1.2436226,1.3630387,1.5270164,1.6077055,1.6014627,1.5720045,1.4221424,1.27847,1.1489428,1.0227922,0.96499926,0.84620863,0.6937627,0.56325264,0.48299397,0.51641602,0.47999036,0.34971638,0.21750116,0.089671942,-0.012817239,-0.14809083,-0.26256963,-0.31874774,-0.24378636,-0.10419626,-0.033978448,0.045950226,0.095875402,0.0034492278,-0.09440523,-0.21523165,-0.32437261,-0.40031267,-0.5219231,-0.63988104,-0.76030001,-0.83532608,-0.8373156,-0.93895642,-1.0553944,-1.188609,-1.3179779,-1.4278068,-1.5421299,-1.6594822,-1.7897813,-1.9005988,-1.9936923,-2.0871259,-2.1571347,-2.1608459,-2.0583661,-1.9825172,-1.8642411,-1.7352342,-1.6102555,-1.4814615,-1.3379851,-1.1930655,-1.0617331,-0.87448884,-0.72792042,-0.58862903,-0.461716,-0.40134278,-0.40835206,-0.32944084,-0.15236932,-5.4333643E-4,0.16227937,0.2611631,0.40491762,0.58737345,0.74543412,0.86745327,0.99678336,1.0541568,1.1822084,1.3878631,1.5066142,1.665819,1.8617239,1.9986572,2.140154,2.2415952,2.2646783,2.2055034,2.1044753,1.9751932,1.9027066,1.8054047,1.6844417,1.5759443,1.4675574,1.3707152,1.2413056,1.2720501,1.3661742,1.2848199,1.1961136,1.0818577,0.98009286,0.88075937,0.87409324,0.95568881,0.8815243,0.75498044,0.67211358,0.59056469,0.49932761,0.40316237,0.32875941,0.46371894,0.61315013,0.75176485,0.89503796,0.87603414,0.77508274,0.73432366,0.66292621,0.58498612,0.50783275,0.40910688,0.40660947,0.37833057,0.24990786,0.17999825,0.20309452,0.082965667,-0.025483214,-0.078957534,-0.15830598,-0.013906599,0.085569956,0.064501714,-0.0051094542,-0.048921847,-0.15377294,-0.26962085,-0.3606521,-0.42726296,-0.49100906,-0.57280235,-0.5844717,-0.66375613,-0.73624675,-0.65345443,-0.45375802,-0.25359475,-0.10470011,0.048051701,0.24766857,0.33440491,0.31887984:3
1.1437961,1.1356034,1.1388326,1.085811,1.0241525,0.96474553,0.87957709,0.76315372,0.6669283,0.56024048,0.53277321,0.55234519,0.56534533,0.60337882,0.64826866,0.69250646,0.75538537,0.73867351,0.77065931,0.80591891,0.84479383,0.91110737,0.89869373,0.95892215,0.97215078,0.99457636,0.99283406,1.0384725,1.0346009,1.0703869,1.0826223,1.0841694,1.1107663,1.1152114,1.1340689,1.1637267,1.1926319,1.2328253,1.2859045,1.3495975,1.4113013,1.4647049,1.4930163,1.4679742,1.398569,1.3039643,1.189412,1.0849069,0.98578937,0.90120342,0.78514154,0.6836033,0.57125646,0.48024216,0.39007589,0.28249743,0.16634454,0.058300695,-0.049876311,-0.12537413,-0.19351576,-0.28202632,-0.35445414,-0.45119385,-0.56472472,-0.66281728,-0.75315683,-0.82186805,-0.89618235,-1.029068,-1.135185,-1.257579,-1.3586698,-1.4907935,-1.5846414,-1.6288309,-1.710927,-1.7789245,-1.8833693,-1.9720068,-1.989577,-2.0795784,-2.1478435,-2.0485679,-2.0436528,-2.1450015,-2.1685801,-2.1763666,-2.144676,-2.2022144,-2.1668974,-2.0920827,-2.1103306,-2.059719,-2.0106932,-1.9919381,-1.9457498,-1.8679708,-1.8352867,-1.7570372,-1.8006227,-1.670131,-1.590982,-1.4611311,-1.386091,-1.2920291,-1.2135041,-1.1734709,-1.0794777,-1.0292908,-0.97321894,-0.90765058,-0.84562642,-0.78201715,-0.72590522,-0.64850614,-0.63651276,-0.58144614,-0.52643718,-0.46363213,-0.40736508,-0.38561209,-0.3239248,-0.29892556,-0.23220119,-0.23376349,-0.24309889,-0.26277552,-0.27392839,-0.23851628,-0.20007782,-0.13889241,-0.080213187,0.0041592699,0.043370978,0.10941691,0.16484217,0.24646358,0.3201848,0.36906061,0.41908211,0.4716172,0.55384206,0.62551965,0.68720831,0.7428511,0.75985429,0.78780471,0.84725105,0.85819709,0.86570005,0.80343194,0.75708286,0.66579739,0.62137971,0.57215653,0.50686005,0.46114736,0.39539483,0.3231491,0.24242936,0.16155133,0.063012274,-0.016832177,-0.10746765,-0.17841848,-0.2703669,-0.33560695,-0.36769702,-0.40671044,-0.45879301,-0.43415925,-0.48010799,-0.43745709,-0.43212013,-0.39397307,-0.36908284,-0.35238129,-0.32151556,-0.34663936,-0.29095726,-0.31515546,-0.37651114,-0.45230875,-0.52715095,-0.62879986,-0.70590635,-0.78424067,-0.86995161,-0.95019524,-1.0476767,-1.126848,-1.2169444,-1.3037427,-1.4236303,-1.5242281,-1.6241045,-1.7119226,-1.7895905,-1.8632357,-1.9170072,-1.9832129,-2.0554838,-2.120337,-2.2215162,-2.2910686,-2.3604546,-2.4038463,-2.2785924,-2.3589828,-2.3216643,-2.2054134,-2.1189613,-2.0371589,-1.9291702,-1.8365012,-1.7925522,-1.7478564,-1.6308468,-1.5670923,-1.474777,-1.3504606,-1.2712697,-1.2123232,-1.1886949,-1.1001472,-1.0078765,-0.89673192,-0.86423515,-0.86617035,-0.77420115,-0.66561585,-0.56501871,-0.48825705,-0.47709873,-0.40016033,-0.34601203,-0.2719906,-0.18590335,-0.078205637,-1.3284284E-4,0.087382127,0.12439881,0.22925603,0.29948028,0.3514542,0.45772616,0.54411045,0.63091085,0.6814296,0.76900425,0.86817169,0.94855359,1.0639711,1.1554,1.2434273,1.359837,1.4606082,1.5527705,1.6099924,1.5614754,1.494087,1.385837,1.2935755,1.239944,1.1904977,1.1677688,1.1287338,1.0840248,1.0424283,1.0036263,0.97013714,0.95416443,0.95694582,0.96621302,0.93416366,0.88977393,0.8226382,0.75053354,0.71293835,0.65339554,0.59877418,0.57404598,0.55459535,0.55354464,0.59308951,0.69235507,0.77056242,0.84597629,0.90609534,0.95404988,0.91660504,0.96075598,0.99887364,0.96561621,0.92027463,0.87247215,0.82099666,0.76019428,0.6964609,0.65582196,0.60441883,0.55166241,0.51222616,0.46023594,0.39888326,0.33206797,0.27037954,0.21300303,0.14856837,0.08531802,0.029128538,-0.04209396,-0.088618873,-0.152645,-0.22059863,-0.21405206,-0.12824496,-0.059499202,0.047104044,0.09769045,0.20793654,0.30733676,0.40055463,0.49507667,0.57784937,0.67790638,0.76231114,0.86362694,0.95626124,1.0017349,1.0123971,1.0662778,1.076806,1.0554999,1.0384325,1.0124047,0.9976044,0.97669812,0.97278732,0.98078289,0.96065587,0.9367705,0.90966106,0.86940995,0.83971249,0.79111394,0.76516206,0.71844016,0.70215745,0.71484834,0.74767209,0.73105511,0.70064233,0.61938849,0.60124303,0.56926612,0.50776634,0.43833976,0.3418495,0.25574167,0.16582255,0.10735196,0.055429815,0.0064635047,-0.036649712,-0.083890463,-0.022106765,0.041288145,0.017651019,-0.058592092,-0.13797687,-0.23251952,-0.30156341,-0.36494809,-0.32867842,-0.24823572,-0.17172009,-0.10203085,-0.063517509,-0.077995205,-0.10654805,-0.022405517,0.055977153,0.14563985,0.27675454,0.39950378,0.49463024,0.54378736,0.51587447,0.48454872,0.45668392,0.43264832,0.41237367,0.39634367,0.38424225,0.37595255,0.37168886,0.37125845,0.37514716,0.38259318,0.38988453,0.31657732,0.24773971,0.11104689,0.037333862,-0.022101551,-0.0019563883,0.010961088,0.026907018,0.060954209,0.10450436,0.16520022,0.22327784,0.29271318,0.35855707,0.42644294,0.48526289,0.56008989,0.63081672,0.70872461,0.7756943,0.85573029,0.89605704,0.94542283,1.0388489,1.1040489:5
0.60541517,0.49229374,0.40390302,0.33199928,0.35157152,0.26031831,0.26043451,0.21436763,0.15935103,0.09395059,0.021543539,-0.061170841,-0.013885603,-0.060747643,-0.081190414,-0.15337654,-0.23461809,-0.32183494,-0.37163557,-0.44318938,-0.49435198,-0.57722496,-0.65721562,-0.68167317,-0.53750414,-0.39209661,-0.23827559,-0.090295692,0.049644642,0.16895315,0.11838434,0.14914709,0.092122514,0.039672372,-0.0066566261,-0.072872258,-0.1277518,-0.11947885,-0.16817108,-0.22913876,-0.31061025,-0.37525007,-0.40760384,-0.46238872,-0.56395107,-0.62042262,-0.71209157,-0.81836952,-0.84007462,-0.74882063,-0.78914011,-0.84998685,-0.92471333,-1.0078855,-1.0672491,-1.1418437,-1.2507646,-1.3516537,-1.4554452,-1.5741392,-1.6923117,-1.8096371,-1.925905,-2.0394614,-2.1547322,-2.280058,-2.3917813,-2.4365475,-2.5748463,-2.4397586,-2.258909,-2.1359277,-1.9668172,-1.9354885,-1.8329591,-1.7593756,-1.616944,-1.4776797,-1.3468989,-1.2835842,-1.1504974,-1.1329791,-1.0427754,-0.89731448,-0.72269029,-0.56480368,-0.39057212,-0.28250051,-0.10949008,0.061587339,0.23281335,0.4044769,0.51085029,0.56555954,0.65980876,0.83132674,0.97112075,1.1737836,1.3331091,1.5181092,1.6888243,1.8609193,2.0252033,2.1749672,2.3413438,2.4873926,2.6303918,2.8327932,3.0007913,3.0969797,3.1576355,3.1996875,3.1730698,3.1110326,3.004124,2.8022333,2.6148908,2.5045839,2.2993726,2.1269923,1.953329,1.7532092,1.5826062,1.4131344,1.2089172,1.0681987,0.88140859,0.69797554,0.55721278,0.42774245,0.289291,0.16102341,0.0046243668,-0.12170682,-0.15717263,-0.32757869,-0.46495032,-0.5964494,-0.76828452,-0.90867733,-1.0744699,-1.2509089,-1.3878269,-1.5236037,-1.6885992,-1.8312824,-1.9660599,-2.0936428,-2.1075263,-2.0334383,-1.9415639,-1.8115861,-1.6408474,-1.5010131,-1.3976696,-1.3077978,-1.2164896,-1.1475621,-1.0712511,-0.96732193,-0.8837224,-0.86076128,-0.76922162,-0.67761607,-0.59893767,-0.49841686,-0.59055496,-0.71180661,-0.81109769,-0.9517086,-1.113391,-1.037413,-0.93142458,-0.83640155,-0.75477881,-0.66777954,-0.61559807,-0.56975747,-0.48056301,-0.40980171,-0.40641526,-0.31951731,-0.23202521,-0.17942959,-0.13829885,-0.050159108,0.0065614412,0.16906372,0.080373407,-0.066213656,-0.2010578,-0.32361151,-0.42082631,-0.56933537,-0.70241601,-0.75422132,-0.66951197,-0.53792032,-0.46305677,-0.38869022,-0.31862802,-0.28730534,-0.28396307,-0.20524695,-0.14885926,-0.055399656,-0.041409576,-0.09096787,-0.016228447,0.09642063,0.071691282,0.16115367,0.24152684,0.24450395,0.31403046,0.40547927,0.48687347,0.59820315,0.60656598,0.49287935,0.30938241,0.12080639,-0.011850212,-0.17637907,-0.28996909,-0.39692174,-0.5330562,-0.68907389,-0.79821183,-0.69544117,-0.56423714,-0.49063161,-0.38848249,-0.30775868,-0.23400178,-0.1532311,-0.066234702,-0.10082713,-0.097921174,0.013374198,0.1218532,0.22603539,0.3476322,0.34094014,0.38667816,0.50239618,0.62360695,0.70790459,0.67512169,0.8051749,0.9091292,0.94270055,1.0710477,1.1816348,1.2584981,1.1653654,1.0116779,0.84857372,0.70345498,0.59099096,0.47153854,0.33888857,0.20508357,0.047742935,-0.1056181,-0.048386629,0.037213485,0.1356612,0.20973767,0.31425845,0.39430183,0.49516529,0.54377304,0.57549707,0.5820946,0.70420672,0.74398891,0.81016618,0.9151249,0.9974008,1.0742114,1.1641971,1.3334314,1.4268829,1.4541684,1.3210583,1.1911655,1.0411352,0.97025977,0.820122,0.67540636,0.66221518,0.62499376,0.49559376,0.35978682,0.22364115,0.11276356,0.23340912,0.33648131,0.43204768,0.54201225,0.5741595,0.60602112,0.69292111,0.79031436,0.85706797,0.96930813,1.0493833,1.0396854,0.92608144,0.76035778,0.68289259,0.53422907,0.40617716,0.40874764,0.28546556,0.16100418,0.025129188,-0.11098673,-0.12710269,-0.15158254,-0.2729226,-0.40254356,-0.54123219,-0.60812941,-0.70963371,-0.82446743,-0.9455865,-1.0610553,-1.1856336,-1.0129807,-0.86631112,-0.73081358,-0.599915,-0.58053489,-0.42662825,-0.34489259,-0.18562021,-0.23487843,-0.20513643,-0.050404026,0.055715116,0.16148082,0.30060593,0.43284339,0.53953323,0.67644557,0.80416009,0.93910918,1.085246,1.2035449,1.290298,1.1157632,1.0061893,0.86959069,0.8994627,0.74920882,0.64561384,0.63952566,0.58491345,0.44551761,0.38608624,0.25229999,0.10225592,0.1313066,0.17200393,-0.0039935189,-0.098249313,-0.16423663,-0.28607047,-0.4203359,-0.54639479,-0.71004999,-0.73038481,-0.73237724,-0.58821707,-0.46008329,-0.32736936,-0.18141137,-0.037805124,0.090871502,0.23059978,0.36681837,0.51743231,0.65599167,0.80215735,0.95310918,1.0325656,0.99744495,0.88103889,0.74125201,0.68846823,0.58459052,0.47591159,0.40182798,0.31321592,0.27080351,0.26944084,0.28454671,0.20152443,0.089924559,0.022257884,-0.082888995,-0.072475271,-0.16380557,-0.18705628,-0.2559727,-0.35920834,-0.42733034,-0.54066779,-0.58963648,-0.70464301,-0.82035946,-0.92686232,-0.99423033,-0.95185062,-0.78292285,-0.58548141,-0.41312003,-0.24193249,-0.076517209,-0.039339827,0.026701434,0.18402878,0.31946649,0.49866703,0.61528441:1
2.5095713,2.4491427,2.3808104,2.3067332,2.249024,2.1762811,2.1032302,2.0467206,1.9713426,1.8992108,1.8403752,1.7716826,1.7064505,1.6649674,1.6067148,1.5385319,1.4759777,1.4144775,1.3659333,1.2983212,1.2267976,1.1638427,1.0967428,1.0249371,0.95181535,0.88476595,0.82104105,0.74680683,0.6902452,0.61678487,0.54982681,0.47020409,0.41258144,0.34130559,0.26520047,0.20980052,0.13651341,0.068518368,-0.0026061224,-0.069451418,-0.14079526,-0.21046985,-0.28660489,-0.34204556,-0.41485794,-0.48760478,-0.56142117,-0.63281658,-0.70374245,-0.77591288,-0.84777123,-0.91973128,-0.98920762,-1.0612581,-1.1323518,-1.2051317,-1.2803549,-1.3528333,-1.4369398,-1.5064265,-1.5759094,-1.6620424,-1.7303826,-1.8002494,-1.8794858,-1.9230418,-1.9783559,-1.939029,-1.8946177,-1.8439182,-1.7852568,-1.8149019,-1.7538055,-1.727502,-1.6620829,-1.6285457,-1.5950322,-1.5391007,-1.5153709,-1.4560484,-1.3914323,-1.3288545,-1.2607934,-1.2426391,-1.1894009,-1.1376704,-1.0757109,-1.0094966,-0.9783588,-0.9155434,-0.88834345,-0.86227893,-0.8307088,-0.76290909,-0.72650427,-0.65806083,-0.61712527,-0.56277177,-0.55391101,-0.53664194,-0.49644324,-0.45523994,-0.41858469,-0.38003632,-0.33216066,-0.35305412,-0.39784406,-0.42903246,-0.47663421,-0.51748188,-0.56483476,-0.58381744,-0.56446068,-0.50966375,-0.4553388,-0.39654145,-0.33747291,-0.28786665,-0.22418818,-0.16605663,-0.11028841,-0.071930671,-0.10465594,-0.05485112,0.002270173,0.068116482,0.098113504,0.15269134,0.21728318,0.27368802,0.32633277,0.36651855,0.40028973,0.42547583,0.43538886,0.39911533,0.37582062,0.33206018,0.37986926,0.41549955,0.48946408,0.52165567,0.56407814,0.6336042,0.67446251,0.72336527,0.75464539,0.78586824,0.72764792,0.72868477,0.7491915,0.7831962,0.79863655,0.80079954,0.74695279,0.74454316,0.72395779,0.66443526,0.59753242,0.53594666,0.49649715,0.44292122,0.46339093,0.50350463,0.52611929,0.49099474,0.43985292,0.39720448,0.36019245,0.29598607,0.23936681,0.19114933,0.13857745,0.091295904,0.054173221,7.0203235E-4,-0.045416764,-0.095639212,-0.091113154,-0.083841825,-0.078515922,-0.063571185,-0.0023509718,0.051618224,0.11713244,0.16404883,0.21591921,0.22311826,0.18317745,0.23624588,0.28932174,0.34384966,0.38105582,0.42952703,0.44498624,0.46938374,0.49345594,0.52387026,0.56383917,0.52146058,0.44377343,0.3908942,0.35552917,0.36647884,0.33099836,0.31004553,0.27894852,0.24781707,0.20384266,0.16983507,0.20149554,0.19656056,0.23511354,0.26390106,0.31289736,0.35995899,0.40015117,0.43563936,0.45392057,0.45559097,0.44047079,0.37521878,0.33615391,0.28471043,0.21382504,0.14550607,0.11991411,0.10560358,0.10946183,0.060911497,0.0039351168,-0.057753291,-0.12985776,-0.17165158,-0.16241895,-0.18506543,-0.16209526,-0.13029839,-0.072280244,-0.012348179,0.052639022,0.11269533,0.17582897,0.20681791,0.27324839,0.33121561,0.38696572,0.40892009,0.43331067,0.4708405,0.50843316,0.49038624,0.51044724,0.53933457,0.56475086,0.61297888,0.66232843,0.71997669,0.78931728,0.85855541,0.90661664,0.90675812,0.94143993,0.98632844,1.0102785,1.0213786,1.0118394,0.99173447,0.96993539,0.91085549,0.85015961,0.78326471,0.76013689,0.74331897,0.68458649,0.62979606,0.57698099,0.51910922,0.45834347,0.48336396,0.48491219,0.42940501,0.36405292,0.30820131,0.25472606,0.23956069,0.27813627,0.30838218,0.3453392,0.32257517,0.26941384,0.2232581,0.16849935,0.11926741,0.056907781,0.070418138,0.023153888,-0.041349342,-0.098318069,-0.16823179,-0.21536363,-0.21969441,-0.19115226,-0.23217061,-0.28410656,-0.34098314,-0.40329808,-0.457972,-0.5185878,-0.57496256,-0.61024624,-0.56446246,-0.52196776,-0.4700636,-0.41934038,-0.41468462,-0.36861047,-0.32249925,-0.27352059,-0.31188503,-0.36220175,-0.42237436,-0.46140057,-0.51841223,-0.5392958,-0.5898446,-0.57718439,-0.58348232,-0.63572709,-0.70542766,-0.76586632,-0.82336071,-0.89280748,-0.97026923,-1.0360966,-1.0414632,-1.0330554,-1.0772616,-1.1288257,-1.1997308,-1.256078,-1.2483397,-1.3144654,-1.3803587,-1.4394108,-1.5067084,-1.5714781,-1.6337846,-1.6916086,-1.7532818,-1.7954691,-1.8413209,-1.8780016,-1.9123956,-1.9484178,-1.9778513,-2.0036569,-2.0292749,-2.0615146,-2.0721267,-2.0476516,-1.9752582,-1.9034303,-1.8327322,-1.7487096,-1.673279,-1.6021604,-1.5130578,-1.442873,-1.3679541,-1.2822838,-1.2112075,-1.1398177,-1.0686111,-0.99681297,-0.92025634,-0.85266598,-0.77904864,-0.70801432,-0.63617211,-0.56333163,-0.49051733,-0.41830243,-0.34842613,-0.28732998,-0.21789302,-0.14538169,-0.072393872,-0.0011971222,0.06177439,0.12871832,0.20169769,0.27567538,0.33710918,0.40479156,0.47771457,0.53661938,0.60653711,0.68026288,0.74718875,0.8123559,0.88265136,0.95449929,1.0122237,1.0864424,1.1568806,1.2179462,1.2897233,1.3556836,1.419836,1.4937609,1.5623688,1.6230006,1.6981173,1.7560416,1.8284475,1.8941476,1.9594532,2.0246015,2.090225,2.1598839,2.222901,2.2834238,2.3560309,2.4182523,2.4732859,2.5015668:3
1.5774074,1.4615101,1.3448245,1.2498833,1.182682,1.1507419,1.1491792,1.1640809,1.2004598,1.2396421,1.2863593,1.3242281,1.3703334,1.3957819,1.4038966,1.3847945,1.3728429,1.3650646,1.3178993,1.2788755,1.2538994,1.1757893,1.0771498,0.96905221,0.8416147,0.71179065,0.63304336,0.59900786,0.56969581,0.55481106,0.56310143,0.61585781,0.67456964,0.72888113,0.76802056,0.80708289,0.83524078,0.84203304,0.80145948,0.78738341,0.73662152,0.73115429,0.70092751,0.65018122,0.58646557,0.54357984,0.45731616,0.36413275,0.26659057,0.16605178,0.14823101,0.059663859,-0.035200692,-0.12751092,-0.21832037,-0.30690805,-0.3963984,-0.49823434,-0.59332804,-0.686847,-0.79124469,-0.8908887,-0.9202027,-0.951733,-0.97590321,-0.99367723,-1.0021967,-1.0005607,-0.98772028,-0.94871225,-0.89664403,-0.86035002,-0.81565009,-0.75423564,-0.70410259,-0.63635837,-0.58509526,-0.50952299,-0.44146645,-0.36993794,-0.30704473,-0.28031111,-0.23344596,-0.15604673,-0.041558567,-0.042564204,0.049558794,-0.023691111,-0.100767,-0.17781924,-0.22759739,-0.21995701,-0.17222252,-0.12887724,-0.075861714,-0.02980431,0.024550983,0.078435934,0.13871735,0.19704451,0.26794979,0.34489376,0.44363993,0.53194776,0.54957271,0.58859286,0.67812553,0.69787691,0.60393962,0.48874325,0.40951465,0.30316203,0.16630029,0.051481757,-0.068626226,-0.17309781,-0.2277927,-0.21870294,-0.16789747,-0.26561121,-0.40281168,-0.51765953,-0.6344984,-0.73750563,-0.83577842,-0.9416021,-1.056939,-1.1721158,-1.3016677,-1.4246687,-1.5615864,-1.6766531,-1.8128842,-1.9235059,-1.9784728,-2.0482478,-2.1111882,-2.1429377,-2.1601869,-2.1490643,-2.1142883,-2.0467667,-1.9733136,-1.8869834,-1.8063706,-1.717149,-1.6264556,-1.5285522,-1.4376163,-1.3469238,-1.2404622,-1.1483266,-1.0405237,-0.94674548,-0.83971086,-0.74298789,-0.6376062,-0.54008889,-0.44975056,-0.34924649,-0.25208034,-0.15179046,-0.050822245,0.031686888,0.062865624,0.17103449,0.27208226,0.37066807,0.47179549,0.56498316,0.61354253,0.53363243,0.44440673,0.38715686,0.3071069,0.22835361,0.14471815,0.073082969,0.057736728,0.086213115,0.13265121,0.17829453,0.23536684,0.31104726,0.38783819,0.49691262,0.60270283,0.72867097,0.83446914,0.96619303,1.0998665,1.2291567,1.3176447,1.4409479,1.5598076,1.5299792,1.5452982,1.6253855,1.7412168,1.8573381,1.9619134,2.0540928,2.1354143,2.0639256,1.9947654,1.9180715,1.8321164,1.7397001,1.6425608,1.5556959,1.4993552,1.5378795,1.6162354,1.537434,1.4221321,1.320744,1.2279301,1.1364797,1.0386931,0.93839934,0.83185237,0.73770474,0.64409186,0.55101465,0.45828302,0.40061427,0.36794768,0.35770088,0.37444869,0.41583565,0.47329636,0.54084198,0.60956271,0.68970839,0.77536769,0.83959502,0.92769988,1.0227383,1.1101539,1.0853096,0.9504498,0.83557213,0.70574478,0.59995366,0.51695446,0.47419622,0.48054511,0.46963629,0.35582555,0.24187244,0.13586843,0.020730305,-0.092482486,-0.21210089,-0.28776764,-0.38313933,-0.51038724,-0.63013956,-0.73193856,-0.83117372,-0.90369683,-1.0181803,-1.1258554,-1.2212932,-1.313907,-1.4278124,-1.5305066,-1.625025,-1.7314164,-1.8278526,-1.9413855,-2.0370669,-2.1376223,-2.1875916,-2.2209619,-2.2218294,-2.2027342,-2.1297473,-2.0199682,-1.9154057,-1.8195101,-1.7143599,-1.6194141,-1.5268382,-1.4247158,-1.3314081,-1.2316466,-1.1324664,-1.0346213,-0.93399891,-0.83657296,-0.739039,-0.64261531,-0.54394623,-0.44430708,-0.35258016,-0.24633516,-0.15413564,-0.11186492,-0.15305044,-0.12604065,-0.042429925,0.039263666,0.15499524,0.25477276,0.36299119,0.46256935,0.55956598,0.65215242,0.58998945,0.50612234,0.41731755,0.37959387,0.29875696,0.2154091,0.13055115,0.041157259,-0.038764836,-0.11294271,-0.18726883,-0.25898003,-0.32468172,-0.38088749,-0.41842427,-0.44428669,-0.4365981,-0.38324037,-0.29122958,-0.39475704,-0.4902779,-0.56761677,-0.62848922,-0.69874318,-0.76710724,-0.82315091,-0.88211726,-0.94041699,-0.98427288,-1.0231342,-1.0684635,-1.1110037,-1.1418254,-1.1828151,-1.2245431,-1.2601484,-1.2977685,-1.3363376,-1.3741212,-1.4035369,-1.4110362,-1.4253087,-1.4334118,-1.4324643,-1.4106364,-1.368719,-1.3041625,-1.2388429,-1.1627982,-1.0755012,-0.97864698,-0.88038305,-0.78004576,-0.68710164,-0.58241576,-0.48047176,-0.36933714,-0.29794924,-0.21732813,-0.12035936,-0.0088415592,0.10364367,0.21888956,0.31744012,0.42095695,0.53107566,0.52211899,0.41017929,0.32971981,0.30224866,0.28133618,0.31512083,0.30491067,0.29521038,0.29350756,0.28510277,0.28654201,0.28552618,0.28331646,0.28368541,0.2818946,0.27947862,0.27549456,0.28701373,0.30241065,0.32834476,0.36048807,0.41788236,0.4917825,0.5764404,0.63096677,0.73722255,0.82858933,0.91007172,1.0100008,1.0510353,1.0410203,1.0633953,1.0885704,1.1187321,1.1375757,1.1509551,1.16797,1.1955871,1.2122183,1.2146774,1.2100379,1.196378,1.178682,1.1548012,1.1451676,1.1399583,1.1482262,1.1627269,1.1939902,1.2655783,1.3745439,1.4902882:4
1.3802917,1.3759782,1.3732605,1.3000123,1.2156686,1.1093264,0.99468403,0.87764336,0.73085637,0.61025715,0.5153736,0.39253076,0.2404959,0.10316582,-0.039001646,-0.18805419,-0.28723074,-0.27504876,-0.17997872,-0.074553373,0.02319536,0.1233932,0.2334693,0.33918784,0.44487927,0.55174642,0.65951659,0.75863442,0.86639611,0.978513,1.0253345,1.0024239,0.93474104,0.83059167,0.72165795,0.60099624,0.50252944,0.40538911,0.28735422,0.1787686,0.066157938,-0.041472968,-0.14923967,-0.25936543,-0.37748124,-0.48481491,-0.60607341,-0.70568501,-0.82099027,-0.94164831,-1.0512236,-1.1678344,-1.2806277,-1.4104582,-1.5173589,-1.6370058,-1.7582467,-1.8576846,-1.965046,-2.0702379,-2.1717687,-2.2656603,-2.276377,-2.1990182,-2.1014434,-1.9450773,-1.7868327,-1.6239336,-1.49043,-1.3274859,-1.1926169,-1.0812625,-0.92868156,-0.79466379,-0.62933805,-0.49528154,-0.3324452,-0.20012445,-0.057099962,0.091874384,0.25042661,0.35192538,0.48296293,0.61602509,0.74017218,0.84960747,0.96279613,1.0555568,1.1599479,1.2083277,1.1763561,1.1317598,1.0770473,1.0195875,0.9444807,0.85881496,0.79257387,0.69584886,0.60544624,0.53157881,0.54604274,0.61798171,0.69004226,0.72485732,0.69663501,0.63302331,0.54790404,0.45258025,0.33952804,0.24887843,0.13278061,0.043690915,-0.071311068,-0.18141292,-0.29423335,-0.40589936,-0.5152352,-0.62430224,-0.7504737,-0.85885937,-0.98573511,-1.1021191,-1.2362935,-1.3687687,-1.4617636,-1.5726293,-1.6528793,-1.7350146,-1.8020371,-1.8720497,-1.9367759,-1.9669282,-1.963128,-1.940287,-1.8550499,-1.7518241,-1.6562659,-1.5500417,-1.4459116,-1.3341683,-1.2252214,-1.1252747,-1.0095287,-0.89101798,-0.78036705,-0.65893688,-0.54755694,-0.4338761,-0.31073304,-0.19969161,-0.084981741,0.036759347,0.14959813,0.25819207,0.38179376,0.49555428,0.61340343,0.73074444,0.83211324,0.87846853,0.89484602,0.89762621,0.89094579,0.85937511,0.83062151,0.78560251,0.73380234,0.67221959,0.62256488,0.57679796,0.52642525,0.45493884,0.4080127,0.35272135,0.28110113,0.20856959,0.12586569,0.066504987,-0.0085332262,-0.081251921,-0.13867597,-0.17569314,-0.17254049,-0.11012137,0.0086008277,0.12516339,0.26112895,0.41834111,0.54717243,0.65464709,0.71094045,0.74111918,0.75845675,0.76143705,0.75384703,0.71858016,0.67942129,0.64219872,0.59461677,0.56657946,0.58618641,0.63772351,0.71674138,0.77509731,0.82616134,0.85930442,0.85091311,0.84413937,0.81228695,0.78045227,0.84134625,0.9827233,1.1171812,1.2491032,1.4030039,1.5409256,1.676654,1.7921961,1.8956138,1.9358521,2.0060443,1.966093,1.8484757,1.6999526,1.5932724,1.4862685,1.388642,1.2737092,1.1522958,1.032539,0.96177611,1.0134599,1.0317354,1.0229791,1.0105324,0.97598004,0.95667214,0.91963657,0.90968886,0.87541567,0.8713754,0.84030608,0.80112248,0.76328226,0.7370425,0.70933837,0.67742475,0.64718316,0.63109437,0.60390385,0.54692084,0.45599361,0.35361233,0.24909989,0.14221457,0.037352734,-0.088396219,-0.20769917,-0.34255937,-0.43856803,-0.53312318,-0.49515034,-0.44263675,-0.38218768,-0.32187297,-0.26031337,-0.20675111,-0.15534312,-0.095312129,-0.041471668,0.013643374,0.060195825,0.11288472,0.16083275,0.20097037,0.24199521,0.2857446,0.32166509,0.36649978,0.41047407,0.45211868,0.48278609,0.5205386,0.5532771,0.58332728,0.62289684,0.65347523,0.6746666,0.67495995,0.65107409,0.60536868,0.53648234,0.44054863,0.28219896,0.12038715,-0.015926685,-0.15261277,-0.29367438,-0.40275903,-0.51654531,-0.62909382,-0.74063187,-0.8575704,-0.96808698,-1.0959054,-1.2034643,-1.3119513,-1.4188616,-1.5252502,-1.6279071,-1.7289356,-1.82071,-1.9315687,-2.0349746,-2.1198758,-2.1996558,-2.2681102,-2.3124717,-2.3788435,-2.3317072,-2.2601488,-2.1862976,-2.102966,-2.0251953,-1.9396241,-1.8536783,-1.7688567,-1.6720823,-1.5742869,-1.4756404,-1.3762476,-1.277634,-1.178688,-1.0724376,-0.96930581,-0.8731572,-0.76999586,-0.68757692,-0.57724311,-0.47886183,-0.37987562,-0.27033382,-0.16225405,-0.05093488,0.053508606,0.16238832,0.26286425,0.37566506,0.4827042,0.5923029,0.69886885,0.76474263,0.78407545,0.74494151,0.6727099,0.60069939,0.49655203,0.50242145,0.60899574,0.68162463,0.80135676,0.89244547,0.96912736,1.0304873,1.0762325,1.0982107,1.0895683,0.9924369,0.89508414,0.7937683,0.68396604,0.58384775,0.47046404,0.35609324,0.26125685,0.14438786,0.037103525,-0.082423833,-0.20302706,-0.32058854,-0.4332626,-0.54746712,-0.66240926,-0.77769939,-0.88809379,-0.99451931,-1.1035763,-1.2090782,-1.3249845,-1.4307638,-1.5359457,-1.5076295,-1.3832959,-1.2265231,-1.0654602,-0.93012478,-0.76689757,-0.60635132,-0.47294414,-0.31636096,-0.1810598,-0.034023194,0.099122884,0.20569982,0.33308391,0.46117917,0.56187716,0.67564828,0.76488904,0.8559809,0.93205421,0.99779884,1.0123629,1.0022396,0.94835189,0.86415004,0.77143864,0.69502624,0.628989,0.73487186,0.82708228,0.93247331,1.0248299,1.1083697,1.1912611,1.2685468,1.3354311:2
0.46205721,0.38734941,0.36273127,0.33378993,0.18382304,0.12090214,0.049050039,-0.025909304,-0.10626299,-0.22406363,-0.30389555,-0.38683001,-0.51782402,-0.60915967,-0.73313121,-0.80744573,-1.021772,-1.1617219,-1.2689272,-1.5294331,-1.6619602,-1.873413,-1.966689,-2.1719695,-2.4644785,-2.5719692,-2.799803,-2.9299825,-3.0709171,-3.0784144,-2.9072693,-2.6964454,-2.4830702,-2.3848471,-2.214796,-2.0314727,-1.8160906,-1.6055477,-1.4068862,-1.1954979,-0.99879441,-0.77476173,-0.60304925,-0.38763273,-0.1807923,0.028443639,0.25673709,0.45059966,0.62500677,0.85952296,1.0898211,1.2669376,1.463862,1.6906783,1.8852045,2.1121466,2.3248628,2.4904638,2.4607383,2.3929234,2.2819184,2.0933587,1.8539962,1.6406803,1.4344573,1.228836,1.0437177,0.88855697,0.7188057,0.51524493,0.28536127,0.089652024,-0.095349135,-0.34758721,-0.40640049,-0.64346937,-0.81029967,-1.0177074,-1.1918285,-1.2205044,-1.1708543,-1.155665,-0.96689454,-1.0249662,-0.89638738,-0.82051515,-0.72860104,-0.60867549,-0.60604,-0.51504963,-0.62532984,-0.57331111,-0.49771743,-0.37993155,-0.29277607,-0.12970448,-0.1699064,-0.11350606,-0.085112896,-0.028225332,0.12321712,0.18748054,0.26414808,0.32809393,0.41590606,0.52962226,0.36637527,0.086810674,-0.063304451,-0.23919877,-0.38397033,-0.41196147,-0.44850686,-0.54465412,-0.52485196,-0.41013858,-0.4240478,-0.30498265,-0.24511621,-0.25837755,-0.35849342,-0.38876855,-0.31977761,-0.24464202,-0.14953752,-0.076644867,-0.15314414,-0.040227495,0.076154034,0.1471958,0.2030518,0.31489461,0.42990089,0.51228838,0.42525011,0.25658782,0.05141315,-0.12391255,-0.39656071,-0.4715342,-0.5971706,-0.67974528,-0.81899111,-1.1103816,-1.2444677,-1.3150763,-1.1217442,-0.9677845,-0.86836273,-0.7971904,-0.71381596,-0.5603203,-0.48177929,-0.3535246,-0.30063,-0.28289012,-0.23406887,-0.079677521,0.082873785,-0.083067447,-0.10105238,-0.097835808,-0.073129065,0.070616125,0.21292721,0.19049544,0.2703538,0.21598957,0.37737955,0.47129411,0.64693,0.43984771,0.52911782,0.70487425,0.78005123,0.85577977,0.66283032,0.43996951,0.34390754,0.17872003,-0.053803715,-0.20525547,-0.43854351,-0.55963363,-0.47870767,-0.56581076,-0.6618966,-0.56832413,-0.75884196,-0.89312824,-1.0681933,-1.2558921,-1.3429484,-1.1473513,-1.167573,-1.2505777,-1.1227558,-1.0516837,-0.94506584,-0.75466256,-0.85661467,-0.69275173,-0.44462101,-0.27126709,-0.19192732,-0.0012083223,-0.032538074,0.03315869,0.16552512,0.24994858,0.36533309,0.40307498,0.42525011,0.49255343,0.39253886,0.50709701,0.63671131,0.80339635,0.97693278,1.1188577,1.2679704,1.4703237,1.5571329,1.4898922,1.5736879,1.3719953,1.2043837,1.2012154,0.93378894,0.69962579,0.48674681,0.27872111,0.13262287,-0.0517711,-0.10213044,-0.10793585,-0.32101873,-0.50220366,-0.68221689,-0.80733743,-0.97926497,-1.0924802,-1.2801975,-1.443654,-1.3743689,-1.2568501,-1.1442622,-1.0933695,-0.95571879,-0.90832822,-0.93073048,-0.81996379,-0.78134467,-0.65922944,-0.68777061,-0.62331069,-0.42364809,-0.26972673,-0.20793063,-0.045822309,-0.18159621,-0.047143265,0.09912928,0.27846005,0.25354929,0.16085738,0.2460617,0.022143192,-0.11498191,-0.12317358,0.038649471,-0.093352581,-0.20334236,-0.40597655,-0.51731149,-0.69937909,-0.90260706,-1.0971532,-1.2698435,-1.1051528,-0.88264873,-0.73920828,-0.53118415,-0.39209554,-0.25501513,-0.088482385,0.15465662,0.20751165,0.36072767,0.59626194,0.59793389,0.81378906,0.95307318,1.1115254,1.2921966,1.3531258,1.5594961,1.8098612,1.9318622,2.13453,2.2538041,2.1185332,1.9500717,1.7727168,1.7256832,1.5545826,1.4207973,1.2755248,1.3794663,1.2127815,1.0030848,0.98977057,1.0325604,0.89344851,0.75547022,0.60549751,0.47992192,0.56887195,0.47866796,0.35537502,0.18375353,0.094099651,-0.013680313,-0.16524634,-0.273778,-0.41503565,-0.54977196,-0.67466615,-0.82738261,-0.77615559,-0.62530655,-0.78867502,-0.6196656,-0.39885384,-0.19922265,-0.2208097,-0.035986956,0.13846358,0.14380284,0.36047685,0.49340449,0.71819982,0.93501268,1.1019448,1.283212,1.2752562,1.4874529,1.7149835,1.8797435,2.1022231,2.3682691,2.5267684,2.4222542,2.305034,2.1363569,1.9563296,1.8229834,1.7337435,1.561149,1.435494,1.3841785,1.3067993,1.1971147,1.0832661,0.97329681,0.94456812,1.0071418,0.86065923,0.7375353,0.64910464,0.52696626,0.38793084,0.37206935,0.3644456,0.37841473,0.24850709,0.14184947,0.0024244406,-5.4859378E-4,-0.19345936,-0.25031795,-0.42640643,-0.60737686,-0.65890347,-0.72525553,-0.83632026,-0.98252596,-0.96219389,-1.1000922,-0.88917316,-0.78540599,-0.57727038,-0.37358697,-0.18153633,0.047649361,0.28335291,0.49218778,0.39757744,0.32937197,0.26370478,0.15677729,0.132761,0.062109518,0.18321594,0.064153935,0.082257455,0.010182642,0.088566203,0.018277261,0.10708983,-0.024072254,-0.06101858,-0.053709944,-0.10347818,-0.21508799,-0.32336658,-0.41865758,-0.49194301,-0.61853369,-0.49193315,-0.24175117,-0.045101017,0.24772076,0.45632719,0.42534363,0.40981717,0.55714637:1
2.9126232,2.850569,2.7489567,2.637601,2.536549,2.4305784,2.3265891,2.2066016,2.1124383,1.9868437,1.8806787,1.7885213,1.6693025,1.5457141,1.5301164,1.5711659,1.4697241,1.3462516,1.2661174,1.1450127,1.0514708,0.93650091,0.83757523,0.70931663,0.62926189,0.58288637,0.6471698,0.63122975,0.56917216,0.48611866,0.37664855,0.28974862,0.17526633,0.088511908,0.047460655,-0.053229017,-0.16774315,-0.25415744,-0.35162316,-0.45031828,-0.54873402,-0.6513614,-0.71888128,-0.74753286,-0.7297483,-0.6896447,-0.58112421,-0.52351121,-0.61189491,-0.70075411,-0.80323467,-0.85941533,-0.86631791,-0.90254082,-0.98443322,-1.0470762,-1.0573853,-1.0773449,-1.1137843,-1.1934908,-1.2676861,-1.3266899,-1.3890487,-1.4579319,-1.4427268,-1.5056927,-1.5585585,-1.5549311,-1.576881,-1.6555824,-1.683054,-1.6846952,-1.6375037,-1.5536996,-1.4940927,-1.3794976,-1.2724113,-1.1614351,-1.0550306,-0.96092186,-0.879106,-0.80311896,-0.72767014,-0.63015936,-0.52287554,-0.38292476,-0.29306428,-0.17490504,-0.085601861,-0.070091876,-0.087536326,-0.12221607,-0.16904568,-0.17494596,-0.27091561,-0.29683518,-0.31956781,-0.25887861,-0.25242376,-0.26185113,-0.30502781,-0.3223071,-0.37298548,-0.37808593,-0.34636979,-0.26573329,-0.17973621,-0.13081654,-0.15395355,-0.16162432,-0.19432811,-0.27642743,-0.32469172,-0.35176973,-0.30996529,-0.31284425,-0.30845796,-0.37941882,-0.42753971,-0.48276804,-0.488628,-0.55089932,-0.54197698,-0.5754333,-0.50572113,-0.46170858,-0.3630907,-0.27259032,-0.15743697,-0.063585775,-0.023700056,-0.035597325,-0.074997417,-0.10830829,-0.13202963,-0.11047669,-0.13626914,-0.19805842,-0.20228351,-0.099470185,-0.061901042,-0.1056812,-0.17595989,-0.2094048,-0.21402663,-0.26866583,-0.21945452,-0.13443416,-0.1395735,-0.1824795,-0.24211218,-0.26601274,-0.27570288,-0.35049858,-0.41249995,-0.44809834,-0.41899275,-0.4694187,-0.54970817,-0.61172175,-0.66955427,-0.72946434,-0.80689285,-0.84804072,-0.89425379,-0.95837739,-0.9057708,-0.84469059,-0.76823129,-0.67188311,-0.53315158,-0.43972564,-0.30322316,-0.20432665,-0.070557601,0.060222444,0.15917464,0.29197636,0.39206426,0.53091885,0.62420997,0.7609534,0.89912255,0.9980138,1.079754,1.1704276,1.3089333,1.446028,1.5813084,1.717515,1.7876287,1.8796501,1.9873954,2.1144819,2.1812679,2.244579,2.2488215,2.1903666,2.1054709,1.9699421,1.8352435,1.7005824,1.5973514,1.4716631,1.3456193,1.2385424,1.1280559,1.0066733,0.89747975,0.77531857,0.63471579,0.54380872,0.40644006,0.26929223,0.17697286,0.039194408,-0.05236487,-0.18814818,-0.31712782,-0.41692671,-0.55013071,-0.67413347,-0.7786944,-0.8962464,-0.85669203,-0.80313016,-0.78833823,-0.73916731,-0.71227141,-0.65621185,-0.58379085,-0.52507492,-0.47231924,-0.39065748,-0.32302579,-0.24770885,-0.23540164,-0.20963765,-0.1640418,-0.11248328,-0.068263542,-0.034265945,-0.079253457,0.015780374,0.040726347,0.074230857,0.11465227,0.12094373,-0.0015692942,-0.079452548,-0.11357696,-0.052817168,-0.0066311726,0.044322178,0.11172829,0.16542968,0.20847372,0.23447716,0.13632215,0.04710776,0.056103147,0.086328512,0.12232476,0.16493486,0.18677515,0.21864497,0.14979191,0.11017034,0.15579319,0.18568918,0.21717361,0.24721856,0.27235298,0.19782958,0.10899124,0.0042781346,-0.039420045,-0.17429726,-0.27779461,-0.37812423,-0.37546058,-0.36295007,-0.32478093,-0.29110711,-0.24925788,-0.20742752,-0.17074583,-0.12951114,-0.086393838,-0.05444237,-0.14441346,-0.14924977,-0.11687062,-0.083328455,-0.034618098,0.019439404,0.074994645,0.11988128,0.12871079,0.053327441,-0.03616295,-0.14398215,-0.20328065,-0.19142472,-0.15171717,-0.10943942,-0.064368069,-0.027353371,1.6456437E-4,-0.034491116,-0.086604577,-0.084316991,-0.034164138,0.037039231,0.099414106,0.17959242,0.25643607,0.31139008,0.2636891,0.14063807,0.04742436,-0.042987978,-0.13155958,-0.23699125,-0.33634517,-0.44459271,-0.53355581,-0.64279117,-0.69282462,-0.71127376,-0.76731678,-0.86291007,-0.96734876,-1.0600132,-1.1645246,-1.2747091,-1.3744184,-1.4624264,-1.5582306,-1.6702754,-1.7602836,-1.8006321,-1.8326726,-1.9204642,-1.9301108,-1.8837081,-1.8400114,-1.7993384,-1.7457312,-1.6569263,-1.599544,-1.5309955,-1.4282989,-1.3445506,-1.3227372,-1.241968,-1.1251701,-1.053575,-0.98490719,-0.93715718,-0.92570415,-0.99607894,-0.96975365,-0.8887375,-0.81214172,-0.73221315,-0.65084039,-0.56680098,-0.54460057,-0.49677708,-0.42537426,-0.34402057,-0.25925225,-0.17501141,-0.12143572,-0.06108256,-0.03514373,-0.14254038,-0.23292104,-0.32487463,-0.3628757,-0.36624566,-0.38164813,-0.42855707,-0.36858813,-0.27186445,-0.18785131,-0.088136574,-0.0093330564,0.069185477,0.12131218,0.19468752,0.29174345,0.38922182,0.4878986,0.58844118,0.6881737,0.77027816,0.85675537,0.90568683,0.82575241,0.75551086,0.75209545,0.83835016,0.93181396,1.0079927,1.1129548,1.2125432,1.3161886,1.4201543,1.5204457,1.5936824,1.6596735,1.7212387,1.8175353,1.9176059,2.0204526,2.1156381,2.2063785,2.3000653,2.3943264,2.4860379,2.5779028,2.6672256,2.7559796,2.8293685,2.9015192:3
0.62109017,0.50653887,0.39645016,0.29338882,0.17954721,0.072923753,-0.044923386,-0.16442898,-0.22173558,-0.33899175,-0.44248022,-0.54625646,-0.64750521,-0.75514189,-0.87495146,-0.99404916,-1.0986158,-1.2192385,-1.340624,-1.4533538,-1.5219539,-1.5856491,-1.6167926,-1.6241045,-1.5961184,-1.5414536,-1.4462961,-1.3519659,-1.2333869,-1.1125279,-1.0085393,-0.87988266,-0.77179309,-0.64911223,-0.52389259,-0.41443271,-0.31074342,-0.20339932,-0.090226474,0.022288901,0.12350569,0.16499626,0.12311693,0.20080345,0.31232247,0.42926374,0.5241787,0.62698475,0.72937132,0.82685092,0.92237886,0.85986247,0.77095976,0.6896621,0.60351936,0.51587097,0.42305585,0.33951581,0.2593204,0.18806316,0.11818557,0.078325636,0.068126078,0.078365429,0.1488927,0.26471866,0.38377468,0.50374761,0.60630939,0.71341146,0.8399871,0.95485342,1.0642692,1.2115826,1.3608918,1.3189595,1.2233507,1.1678327,1.2146858,1.3155802,1.41595,1.5297655,1.6256757,1.7430025,1.8437984,1.9169586,1.8604066,1.8403518,1.7152297,1.5674714,1.441444,1.2924054,1.1781799,1.074419,1.0275046,1.0697304,1.1563098,1.2629484,1.3691414,1.3161754,1.1681491,1.0422917,0.90088433,0.787547,0.63844441,0.51159323,0.36326281,0.24181726,0.095307809,-0.027039772,-0.17217116,-0.292949,-0.39578427,-0.46937506,-0.48295277,-0.47006395,-0.44711282,-0.37357482,-0.29480325,-0.20425205,-0.11461123,-0.020812937,0.072108718,0.16939658,0.26650324,0.37052426,0.46959901,0.56958931,0.67236281,0.75884048,0.70532138,0.59689398,0.48423677,0.37897518,0.26429538,0.1509228,0.042654874,-0.071489888,-0.092898241,-0.079544837,-0.19117771,-0.2995016,-0.40423036,-0.51566447,-0.62875053,-0.73986946,-0.84657932,-0.96920402,-1.0755535,-1.184421,-1.293934,-1.4058755,-1.5150448,-1.6320461,-1.7401059,-1.8526164,-1.9527808,-2.0629988,-2.1040388,-2.0818056,-2.0321842,-1.9604836,-1.8588728,-1.7479791,-1.6248209,-1.5143039,-1.4019162,-1.2977129,-1.1911666,-1.078392,-0.98306704,-0.86765644,-0.77152786,-0.65475326,-0.53939429,-0.43735525,-0.32654646,-0.22060857,-0.12327911,-0.027801582,0.078934231,0.012575798,-0.084304639,-0.16920699,-0.2521554,-0.33495788,-0.42947343,-0.51839569,-0.59612034,-0.65671799,-0.57170449,-0.50956835,-0.61056258,-0.6993189,-0.78538341,-0.86383128,-0.94673102,-1.0240581,-1.0850871,-1.1484546,-1.2013386,-1.2567396,-1.3034828,-1.3469475,-1.3942428,-1.4377559,-1.4861523,-1.5344732,-1.5584996,-1.5584249,-1.5445556,-1.4876935,-1.3909715,-1.2786345,-1.1753017,-1.0604034,-0.92406685,-0.791827,-0.66044872,-0.53122802,-0.44717812,-0.35113185,-0.27097317,-0.18132601,-0.10390538,-0.035334274,-0.081828391,-0.1270675,-0.17534105,-0.22231988,-0.27022966,-0.31667514,-0.3464246,-0.36829546,-0.40454426,-0.41956359,-0.43716517,-0.44437277,-0.4592249,-0.46593452,-0.46556878,-0.45333924,-0.45253975,-0.43291033,-0.40126216,-0.35056443,-0.26507839,-0.14762066,-0.047607351,0.043058083,0.14069318,0.24080428,0.32096066,0.38726185,0.46476729,0.50245014,0.55688316,0.52573511,0.50129637,0.4945553,0.51284407,0.53888862,0.55432008,0.58535256,0.60576573,0.62160971,0.64217066,0.65105728,0.71155604,0.76293615,0.81795841,0.87511218,0.92508442,0.96067091,1.0041291,1.0397674,1.082882,1.1318424,1.1843807,1.2342283,1.2876692,1.3268742,1.3669124,1.3941976,1.425327,1.4643163,1.5618281,1.709536,1.8365491,1.9508908,2.0685846,2.1796563,2.3022483,2.4083567,2.48421,2.4056112,2.2873713,2.1679287,2.0545631,1.9475626,1.8250655,1.7184497,1.6114144,1.517873,1.4784447,1.4815197,1.5000743,1.5177908,1.5240909,1.5028891,1.4825949,1.4507751,1.4149762,1.3711824,1.3307902,1.2860329,1.2392857,1.1965362,1.1557702,1.126838,1.0982719,1.0688448,1.0423281,1.0084125,0.97698307,0.95440538,0.93937702,0.93980673,0.9290121,0.92066495,0.88002004,0.87458098,0.85421797,0.7912371,0.74433145,0.68015775,0.61058503,0.53058208,0.43550972,0.31078515,0.2043663,0.082353106,-0.0010334453,-0.078298539,-0.13877826,-0.18089278,-0.22036569,-0.2442876,-0.27232077,-0.29108597,-0.31003749,-0.30990453,-0.3085054,-0.31016326,-0.29551531,-0.27686149,-0.24658165,-0.20855511,-0.15424989,-0.103715,-0.15703069,-0.2013586,-0.16992681,-0.11115,-0.07893556,-0.033843368,0.011543209,0.061992419,0.11598906,0.147873,0.066687929,-0.01104454,-0.095690615,-0.19126389,-0.29512062,-0.39957994,-0.4892626,-0.59782242,-0.7186423,-0.82845626,-0.93930532,-1.0414201,-1.1531925,-1.257066,-1.3646552,-1.4652438,-1.5667825,-1.6381641,-1.6763755,-1.6994674,-1.7122349,-1.6973997,-1.6647448,-1.6228995,-1.5755776,-1.5140302,-1.4616164,-1.3934665,-1.3260314,-1.262868,-1.1995589,-1.1227129,-1.0465395,-0.96121934,-0.87242937,-0.78672374,-0.6897494,-0.59087367,-0.48657066,-0.48845087,-0.4365959,-0.56318611,-0.64549352,-0.60577578,-0.52593367,-0.43355264,-0.33851289,-0.2390492,-0.14351589,-0.047719052,0.041583083,0.06419384,0.14533945,0.25205229,0.3481519,0.44607213,0.54805223:4
1.7303223,1.6317682,1.5164755,1.3962882,1.2809199,1.1554135,1.0642644,0.92124984,0.79668191,0.65890795,0.49912466,0.36375991,0.40555009,0.4415974,0.36855935,0.25106253,0.12669635,-0.0092556049,0.011698832,-0.096163678,-0.22379787,-0.35391749,-0.51474109,-0.46113133,-0.36843203,-0.26260576,-0.14410976,-0.024714292,0.052495057,-0.0050150384,-0.10617548,-0.18911798,-0.22679944,-0.32176556,-0.37661197,-0.45245556,-0.49662277,-0.46537455,-0.59250871,-0.73673208,-0.91321554,-1.027502,-1.2051207,-1.3236886,-1.4023805,-1.3995228,-1.2889827,-1.2377027,-1.312983,-1.4455337,-1.5767568,-1.6830774,-1.813238,-1.9854118,-2.1122161,-2.2438325,-2.3730012,-2.4957334,-2.4535941,-2.5523346,-2.5941771,-2.476666,-2.3484606,-2.2089906,-2.078159,-1.9378271,-1.7957206,-1.6576275,-1.527774,-1.3861403,-1.3638274,-1.2271052,-1.0949874,-0.95469389,-0.81673874,-0.67206216,-0.55129629,-0.41230877,-0.34589331,-0.39601566,-0.40665958,-0.26449054,-0.1372595,0.0033306926,0.13905615,0.27289811,0.41310666,0.54551813,0.67520269,0.6725454,0.80688544,0.95128487,1.0790427,1.2081004,1.3498722,1.4845597,1.6169013,1.5690819,1.4460085,1.3169439,1.2058385,1.2016114,1.0969608,0.96343546,0.90746456,0.77293238,0.66351673,0.75285853,0.78023,0.69224599,0.58919302,0.47745922,0.36137406,0.44605824,0.47721218,0.41479016,0.31770482,0.2563123,0.20881498,0.23439657,0.27544715,0.37148761,0.54953856,0.57774918,0.49610296,0.43524335,0.35260223,0.3814193,0.36212417,0.27906669,0.1806007,0.080836399,-0.027419111,-0.11197824,-0.05795256,0.060135945,0.15877748,0.19268563,0.13768433,0.071361119,-0.024525532,-0.086186986,-0.16775601,-0.24638212,-0.31109875,-0.33847396,-0.40149558,-0.36458559,-0.27309605,-0.16108375,-0.022721444,0.12857871,0.25671108,0.40051303,0.55491006,0.69905058,0.70776323,0.64388213,0.58717817,0.58491817,0.53679892,0.46185424,0.42562872,0.5267384,0.50354575,0.40616516,0.31694969,0.25164614,0.14349461,0.066295662,0.065460635,0.18836163,0.29526302,0.24407919,0.1727158,0.087650626,0.010911366,-0.10376942,-0.13363547,-0.2030704,-0.27891094,-0.33077368,-0.42147446,-0.49883496,-0.58664928,-0.62978345,-0.6794833,-0.71624309,-0.76193528,-0.81196846,-0.84164616,-0.87169879,-0.89625389,-0.91504323,-0.96407543,-0.95409978,-0.87942006,-0.71611859,-0.5392136,-0.38450173,-0.19794535,-0.041692483,0.11389263,0.301406,0.45673834,0.64201513,0.82888103,1.011444,1.1950923,1.3776211,1.5593161,1.7075048,1.8648073,2.036469,2.1855987,2.3669368,2.5172036,2.699017,2.7240388,2.6591138,2.5069937,2.350752,2.1717359,2.0211041,1.8344203,1.6486518,1.4647585,1.3125712,1.1266779,0.94033872,0.75386922,0.59699839,0.40884729,0.2520077,0.075561968,-0.096612258,-0.25633809,-0.41489542,-0.57538438,-0.74141971,-0.89560341,-0.94479632,-0.99139785,-0.92987346,-0.889979,-0.85363588,-0.78625281,-0.77661175,-0.72892772,-0.68809438,-0.69364078,-0.69423853,-0.65435495,-0.66031743,-0.59982859,-0.5393272,-0.50389129,-0.45036543,-0.36976892,-0.29274876,-0.21237899,-0.16146387,-0.11085493,-0.075100804,-0.05121047,-0.12700556,-0.21113573,-0.10609318,5.4870456E-4,0.10992302,0.15541839,0.25406228,0.34680185,0.36780938,0.25503789,0.36615536,0.47363721,0.57545665,0.56569356,0.55615679,0.60745602,0.67377672,0.70815439,0.73177943,0.58423968,0.45373982,0.32451275,0.18653457,0.046586851,-0.083077846,-0.22316809,-0.35921305,-0.46003709,-0.40044333,-0.33791154,-0.28007286,-0.23102376,-0.18903982,-0.096930144,-0.069026231,-0.015338828,0.026110043,0.011384339,-0.11481147,-0.074422201,-0.029373746,0.046623389,0.15389593,0.23947402,0.20881214,0.25014037,0.33344458,0.38678718,0.45115139,0.41736615,0.27693969,0.14413875,0.023219806,-0.014502057,0.077227116,0.17556745,0.27065355,0.35446851,0.29425429,0.38183555,0.48368813,0.59066767,0.69343188,0.77988511,0.72206241,0.67153615,0.79047732,0.91447944,0.95303292,1.0446442,1.1648076,1.2603839,1.2620775,1.3746261,1.4727538,1.5822924,1.6901977,1.791353,1.7276496,1.575365,1.3980328,1.2648048,1.1057122,0.9721391,0.83590357,0.76773509,0.64836001,0.48846028,0.32794977,0.16847729,0.091720928,-0.061527492,-0.22922641,-0.41769897,-0.57605205,-0.72127906,-0.73182713,-0.7871685,-0.96827542,-1.1069246,-1.2852078,-1.4255665,-1.5862668,-1.7236426,-1.865799,-2.0246318,-2.1890369,-2.3063135,-2.4255975,-2.3598642,-2.2770248,-2.1795584,-2.0679956,-1.9411994,-1.8301305,-1.7239805,-1.5934981,-1.474941,-1.3675863,-1.3800585,-1.4808918,-1.3714272,-1.242923,-1.1149762,-0.98494906,-0.86214308,-0.72429585,-0.61027812,-0.62275577,-0.49386411,-0.36384496,-0.24909685,-0.15380627,-0.032098749,0.031869249,-0.054688395,-0.19026087,-0.26990316,-0.38983852,-0.49905854,-0.56206042,-0.4987555,-0.34222097,-0.1869777,-0.043798663,0.048084269,-0.018388124,0.098780544,0.26245842,0.43446038,0.56240968,0.64736588,0.56449637,0.63977382,0.77167877,0.89323331,1.0649166,1.1821239,1.3398372,1.4898721,1.6524516,1.7834829:3
-0.6962006,-0.72374957,-0.77509347,-0.81192771,-0.8459308,-0.89416211,-0.94176218,-0.98823899,-1.0332212,-1.0877452,-1.1353117,-1.1868934,-1.2566395,-1.3111282,-1.3676072,-1.4303253,-1.4982345,-1.5512115,-1.6239755,-1.6651841,-1.6829901,-1.688082,-1.671803,-1.6518376,-1.618259,-1.571179,-1.5235041,-1.4740416,-1.4279374,-1.3794155,-1.3320309,-1.2900609,-1.2401752,-1.1849595,-1.1360872,-1.0915803,-1.0573437,-1.0059861,-0.96097164,-0.92172302,-0.86849264,-0.82599043,-0.78412235,-0.73429257,-0.69352852,-0.63845251,-0.59793181,-0.53949637,-0.50024199,-0.44083566,-0.38571642,-0.34465093,-0.29664092,-0.25939853,-0.22682238,-0.18198803,-0.14061703,-0.11878177,-0.097828809,-0.082108402,-0.066082538,-0.051260837,-0.036936924,-0.022405025,-3.6729383E-4,0.0055292125,0.011888782,0.00961363,0.025761145,0.021729975,0.025919954,0.022487879,0.020474217,0.02151574,0.019365316,0.016786791,0.01759035,0.015505847,0.014089621,0.022495781,0.037871677,0.051575396,0.057414598,0.076537857,0.10343124,0.13914091,0.1522196,0.19080929,0.22832157,0.26656872,0.29775338,0.33014959,0.39173395,0.43545502,0.47584759,0.50640638,0.53756776,0.56026005,0.63479807,0.67445808,0.71304117,0.78154339,0.80622282,0.8513938,0.88916893,0.9443981,0.98561646,1.031656,1.0727888,1.110932,1.1563249,1.1993188,1.2446351,1.2905007,1.3295811,1.3548059,1.3760748,1.4104749,1.4413128,1.4792135,1.5169679,1.5551957,1.5873603,1.6257554,1.6711415,1.7073009,1.7287442,1.7543331,1.7701066,1.7842188,1.7988477,1.8116452,1.8044039,1.7841961,1.7847794,1.7743366,1.7507607,1.722016,1.6937646,1.662263,1.6396476,1.6056345,1.5800913,1.562513,1.5255034,1.4956664,1.4674,1.4374645,1.4053578,1.3731456,1.3176519,1.2829073,1.2468221,1.2262764,1.158064,1.1129984,1.0421022,1.0259926,0.99084086,0.92720856,0.86816326,0.82989555,0.75610044,0.68874681,0.61809392,0.54757166,0.47615321,0.40441788,0.33567048,0.27207795,0.19951601,0.15293226,0.12404246,0.085895097,0.05742374,0.051212921,0.055455584,0.079156714,0.094516826,0.12755666,0.14682163,0.16661798,0.19183654,0.21064472,0.21511389,0.22400516,0.22766916,0.22356912,0.21876511,0.20592672,0.19565872,0.16332499,0.11832938,0.077820791,0.036695283,-0.0051445189,-0.043252657,-0.09935152,-0.12962114,-0.18249665,-0.21757711,-0.26991128,-0.30708378,-0.35618276,-0.40141672,-0.4386384,-0.48414197,-0.5385625,-0.5891136,-0.63788487,-0.68169527,-0.73178171,-0.78073529,-0.83152594,-0.88038817,-0.92754457,-0.97359095,-1.0198784,-1.0668246,-1.1136229,-1.1793922,-1.2267079,-1.2644027,-1.3150298,-1.3607243,-1.3998213,-1.4546247,-1.4993916,-1.5466667,-1.5982476,-1.6488095,-1.7019677,-1.7397527,-1.7821376,-1.8072273,-1.8307617,-1.8195462,-1.7608374,-1.7206667,-1.6663531,-1.6141364,-1.5588663,-1.5026553,-1.4428603,-1.3914827,-1.3336604,-1.2856646,-1.2175701,-1.1622825,-1.1140612,-1.0650726,-1.0034924,-0.95671776,-0.90530611,-0.84855501,-0.8158083,-0.75537368,-0.71183242,-0.65620295,-0.62274303,-0.57891842,-0.56335214,-0.53680264,-0.52165985,-0.51122867,-0.494013,-0.49990784,-0.49939834,-0.48251464,-0.48178032,-0.47874292,-0.4773247,-0.46910544,-0.46758228,-0.47535687,-0.4709392,-0.46800798,-0.4687248,-0.47549313,-0.4758168,-0.47648746,-0.47861986,-0.47389716,-0.46550865,-0.46004937,-0.45050826,-0.45679391,-0.4419353,-0.42807872,-0.41917735,-0.40774193,-0.40476144,-0.39709403,-0.39824758,-0.40695899,-0.40576978,-0.40501659,-0.40589767,-0.39151307,-0.36895828,-0.35360221,-0.34725602,-0.35261675,-0.34839179,-0.33640822,-0.29706547,-0.25070173,-0.201333,-0.14719802,-0.090839433,-0.029371586,0.024668251,0.07140684,0.1188745,0.18293487,0.22707055,0.28288412,0.35040404,0.39956609,0.44934496,0.49588071,0.57729395,0.62707718,0.67770817,0.74661332,0.80862564,0.88399337,0.94070017,1.0263139,1.0720305,1.1553958,1.232316,1.2850952,1.3682047,1.4525913,1.4967322,1.5395319,1.5826093,1.6639841,1.7463337,1.8309888,1.8796655,1.9634225,2.0122617,2.0646574,2.0951961,2.0896618,2.0789814,2.0881181,2.0628552,2.0008538,1.9333667,1.8654046,1.8155383,1.7681115,1.6923233,1.6348959,1.5564934,1.5019324,1.4459948,1.371346,1.2874065,1.2404646,1.1550757,1.1085641,1.0260108,0.95266978,0.89463814,0.81388929,0.73038497,0.67727196,0.60305725,0.52148976,0.43796041,0.35967882,0.30211309,0.23194013,0.15261284,0.082268489,0.038999883,0.029498397,-0.045866609,-0.11930911,-0.19594711,-0.24184839,-0.30263533,-0.37955326,-0.44539902,-0.48948766,-0.54328975,-0.61157126,-0.69183518,-0.75882536,-0.81882967,-0.88529668,-0.91428362,-0.93835462,-0.94902926,-0.95101127,-0.92937683,-0.88748783,-0.83025844,-0.77870846,-0.73993593,-0.72644132,-0.71075458,-0.68636286,-0.65725745,-0.64462981,-0.6264715,-0.61563014,-0.60719767,-0.59435086,-0.5935395,-0.5652908,-0.54795918,-0.53986127,-0.53040449,-0.52719601,-0.51153349,-0.5076299,-0.52230082,-0.53459997,-0.5477336,-0.57612634,-0.60864614,-0.64174446:2
1.119563,1.0671925,1.013469,0.94263866,0.8852821,0.81833655,0.75340034,0.68958715,0.62264746,0.57339029,0.50899463,0.52395628,0.54422049,0.5682025,0.55367704,0.51301418,0.45500913,0.39778806,0.33341677,0.26345913,0.18781425,0.11218951,0.030230294,-0.038162427,-0.12794167,-0.20059238,-0.27326771,-0.36548496,-0.45511695,-0.54869922,-0.64020907,-0.71335076,-0.79766381,-0.88773952,-0.97750713,-1.0672734,-1.1550031,-1.2249317,-1.304545,-1.3956936,-1.4768191,-1.5537283,-1.6177138,-1.6367326,-1.6230795,-1.6451199,-1.6003437,-1.4948513,-1.4143209,-1.3126872,-1.2169748,-1.1250839,-1.0394001,-0.93317924,-0.84789687,-0.76115181,-0.67642916,-0.58247987,-0.49380265,-0.40376663,-0.31624837,-0.22600476,-0.13986327,-0.060165993,0.024936669,0.1177094,0.20418025,0.2895407,0.37227435,0.45372904,0.54664579,0.61750053,0.70207965,0.78028391,0.87254645,0.93062201,0.93534131,0.9274861,0.90770977,0.86607548,0.83534039,0.77846234,0.70321875,0.61687637,0.51818356,0.44380841,0.35891523,0.31896678,0.32997336,0.36718643,0.40172832,0.42580584,0.4160809,0.37292457,0.30262198,0.23185557,0.18148769,0.13146962,0.067994944,-0.0079215077,-0.058874237,-0.1203487,-0.17078887,-0.21883937,-0.25292682,-0.29008121,-0.32793924,-0.36592404,-0.39078375,-0.42750051,-0.38419466,-0.3418985,-0.24571946,-0.15256505,-0.099574871,-0.04863426,0.0068313093,0.05806669,0.11093238,0.16013499,0.20189548,0.2426157,0.2722192,0.30772076,0.34383436,0.38506157,0.40858285,0.45881266,0.51589898,0.56978163,0.63572837,0.69496476,0.73785767,0.78901044,0.8405682,0.88611135,0.92217073,0.9584478,0.96012583,0.96665832,0.96692448,0.94996927,0.93794601,0.93836917,0.95778597,0.9914442,1.0659005,1.1312749,1.1644667,1.1993478,1.2113657,1.2326808,1.2384522,1.23675,1.2443115,1.2209683,1.1834236,1.1996425,1.2120347,1.2776882,1.3314005,1.424926,1.5149106,1.6034795,1.7037994,1.7950512,1.8676601,1.8955561,1.897984,1.8539911,1.7679623,1.6758259,1.578308,1.47328,1.3827884,1.2969393,1.2021919,1.1304353,1.1603518,1.1863315,1.2037486,1.2004629,1.2401928,1.2827532,1.3199132,1.295569,1.2825117,1.2577285,1.2100596,1.1632997,1.1522102,1.1448926,1.1346245,1.1018597,1.0814081,1.0630337,1.0302372,0.99318599,0.95657073,0.90448448,0.85056492,0.7917102,0.72657987,0.66901618,0.65136743,0.65666634,0.66789459,0.65854978,0.65370415,0.64820594,0.63920828,0.62067251,0.60581514,0.57573236,0.55813523,0.52772948,0.4945817,0.45573827,0.40788846,0.36503003,0.31752108,0.21132872,0.1088999,0.030626926,-0.051055846,-0.14331157,-0.22832249,-0.2974612,-0.36928736,-0.43967123,-0.5071144,-0.56699671,-0.6315287,-0.6980383,-0.75157459,-0.81396487,-0.9031296,-0.93389019,-0.93820814,-0.93897042,-0.93111298,-0.92308434,-0.89996549,-0.87306338,-0.84477193,-0.79064108,-0.75321253,-0.68961299,-0.64290246,-0.59519068,-0.57651428,-0.55810097,-0.53757961,-0.53748273,-0.52573233,-0.49564379,-0.46670306,-0.43895607,-0.39128556,-0.34818653,-0.31091994,-0.27801187,-0.23621828,-0.20046772,-0.15948491,-0.12756967,-0.078228101,-0.029088392,0.011085161,0.056903768,0.10140915,0.13702353,0.16136938,0.17967423,0.11423729,0.03602925,-0.044990648,-0.12705704,-0.22077322,-0.30410057,-0.38920628,-0.48246071,-0.58371393,-0.66454588,-0.74194976,-0.79084182,-0.84838483,-0.9597266,-1.0524359,-1.1469458,-1.2394663,-1.3261164,-1.4277534,-1.5202527,-1.6130403,-1.7211626,-1.8057044,-1.8694089,-1.9103563,-1.968101,-2.0603223,-2.163522,-2.278875,-2.3724731,-2.4633761,-2.5262616,-2.6169088,-2.6786442,-2.7424694,-2.7155825,-2.6557097,-2.608374,-2.5598161,-2.4808075,-2.3860213,-2.3011034,-2.1832271,-2.0881134,-2.117568,-2.0411879,-1.9790475,-1.9156975,-1.8406321,-1.7544111,-1.6755562,-1.5868951,-1.4989393,-1.4246068,-1.3422768,-1.2482889,-1.1532827,-1.0585749,-0.96359986,-0.87963526,-0.86940332,-0.77914821,-0.6922077,-0.61343544,-0.53333749,-0.47525187,-0.45005192,-0.4527023,-0.44809322,-0.36988845,-0.29513338,-0.212127,-0.12465539,-0.038058496,0.0380742,0.12000689,0.19502004,0.26433415,0.33269237,0.40134474,0.46457019,0.52376774,0.59040674,0.65249223,0.71013866,0.76724475,0.80686959,0.82978102,0.84136783,0.8366214,0.83086759,0.77409733,0.72280037,0.64157531,0.54257003,0.4301055,0.35488601,0.29762736,0.21257496,0.12960539,0.025560119,-0.03439244,-0.10468565,-0.17817938,-0.24551094,-0.28282174,-0.35663463,-0.4154047,-0.48433091,-0.55759267,-0.61202747,-0.71637293,-0.775575,-0.84683245,-0.78858316,-0.74477208,-0.65196731,-0.55752642,-0.4735166,-0.37806173,-0.29875512,-0.20625748,-0.11457202,-0.023436778,0.058542888,0.14742755,0.24299889,0.34166977,0.42927476,0.52728953,0.60987076,0.71121502,0.8055,0.87599682,0.97537058,1.0506806,1.1332956,1.2062714,1.2643632,1.3016327,1.3053591,1.2779177,1.2462858,1.1862742,1.1157354,1.048655,0.9781102,0.97633793,1.0300948,1.094378,1.1410001,1.1887208,1.1654947:2
2.7982221,2.7191558,2.6390589,2.5625075,2.4977609,2.4371603,2.4149753,2.3607513,2.3293442,2.2338011,2.1463377,2.0616436,1.9707954,1.96042,1.8740978,1.8262423,1.7385732,1.6489728,1.5575198,1.4688803,1.3878816,1.3014487,1.2159283,1.1288082,1.0379823,0.94995524,0.87998816,0.831632,0.79818675,0.77025735,0.74287708,0.70859838,0.67663137,0.65155824,0.62441054,0.57138997,0.50451056,0.44591711,0.38502853,0.31914174,0.25807865,0.20556833,0.15421059,0.085749119,0.043062244,-0.0076155343,-0.086690584,-0.16146974,-0.21769323,-0.27432062,-0.31934252,-0.36543078,-0.41877611,-0.45913524,-0.49989481,-0.53176749,-0.55782029,-0.56854572,-0.56082252,-0.54274769,-0.50788339,-0.501356,-0.48934648,-0.41546015,-0.44531672,-0.528672,-0.60239507,-0.67090753,-0.74806308,-0.82579268,-0.88816636,-0.95050963,-1.020748,-1.0836849,-1.1601956,-1.2793786,-1.3560732,-1.4127861,-1.4606285,-1.4954889,-1.5098202,-1.5101538,-1.5047596,-1.4922988,-1.4726356,-1.4498909,-1.4321141,-1.4055368,-1.3644986,-1.3193022,-1.2647814,-1.1936522,-1.1313765,-1.0651558,-0.97765832,-0.90862335,-0.82915711,-0.74750213,-0.66940684,-0.56833658,-0.48900417,-0.39669075,-0.29716312,-0.19678474,-0.20389579,-0.28895497,-0.3744144,-0.4656889,-0.54004834,-0.53957357,-0.49075626,-0.43465103,-0.37771561,-0.30984808,-0.2250877,-0.1512301,-0.074496466,-0.045848022,-0.095769511,-0.031503274,0.085370953,0.18316865,0.30241602,0.22824487,0.1916711,0.096630682,-0.02600461,-0.1436352,-0.23538032,-0.2521195,-0.2675996,-0.3611818,-0.48137115,-0.60209566,-0.72375011,-0.82289444,-0.92248682,-1.0217489,-1.1215182,-1.2001228,-1.2834424,-1.3593321,-1.4240455,-1.4717145,-1.4672191,-1.4174352,-1.3585783,-1.2828479,-1.2094988,-1.142725,-1.060559,-0.97891811,-0.89668997,-0.83577514,-0.75232459,-0.66677069,-0.58785888,-0.51721345,-0.43113394,-0.35076036,-0.26861114,-0.189802,-0.10404751,-0.019619519,0.066397351,0.1602559,0.10437534,0.051172228,0.10350213,0.18354911,0.26369199,0.34808941,0.43493477,0.51888122,0.59802511,0.62539007,0.53632086,0.43340859,0.35001221,0.2538141,0.14841604,0.072873375,0.003641138,-0.039495719,-0.062561564,-0.045597478,0.023235339,0.10649388,0.18805729,0.27002846,0.34443409,0.43632178,0.51464313,0.60327339,0.68726168,0.77317563,0.85625704,0.94303169,1.027377,1.1136497,1.127411,1.0387065,0.94976082,0.90477454,0.95698565,1.0494317,1.135743,1.2189664,1.3059698,1.3919535,1.4816658,1.5337081,1.5918716,1.6237191,1.533281,1.4551282,1.3762568,1.2940081,1.2653272,1.3503571,1.3912299,1.303006,1.2208443,1.1354637,1.0505417,0.96744719,0.88578604,0.80329222,0.72004512,0.64811539,0.59246284,0.60674716,0.65728089,0.7297641,0.80608479,0.88457147,0.81410465,0.71759313,0.61807338,0.53074122,0.50109316,0.39951082,0.31408982,0.2257281,0.13626886,0.048671522,-0.035747593,-0.12176475,-0.19952749,-0.2842587,-0.3712552,-0.445464,-0.52071558,-0.60261804,-0.67749123,-0.74574997,-0.8057482,-0.83816618,-0.82516069,-0.79475694,-0.75316539,-0.70311542,-0.64468097,-0.57263985,-0.48409522,-0.37600841,-0.2809106,-0.17818213,-0.22756212,-0.2151451,-0.12320375,-0.02131974,0.088267385,0.17367092,0.2703042,0.24619765,0.14867811,0.068944602,-0.0075561203,-0.11732555,-0.20927243,-0.28057905,-0.34912401,-0.37785461,-0.32641634,-0.25519457,-0.18842154,-0.16282453,-0.24596768,-0.34701213,-0.46611289,-0.55813078,-0.64833026,-0.74737996,-0.83415827,-0.92685906,-1.0165847,-1.1140088,-1.199741,-1.2843583,-1.3697319,-1.4500578,-1.527338,-1.6008778,-1.6641272,-1.7048612,-1.7349248,-1.743983,-1.7165765,-1.644081,-1.5553028,-1.4746641,-1.387412,-1.2956416,-1.2115403,-1.1281265,-1.0426613,-0.95564852,-0.86886122,-0.78462541,-0.70207885,-0.62631595,-0.66925757,-0.60820094,-0.52114597,-0.43601568,-0.35578663,-0.27191106,-0.18801472,-0.094576618,-0.15779961,-0.24146984,-0.32395852,-0.3566964,-0.4147876,-0.49320126,-0.56840771,-0.6472625,-0.71883659,-0.74442795,-0.68430229,-0.59860218,-0.50761693,-0.51128445,-0.5884171,-0.65794445,-0.71617195,-0.77572946,-0.83425273,-0.88484574,-0.92840985,-0.97209627,-1.014784,-1.0492338,-1.082665,-1.1091923,-1.1223412,-1.1161472,-1.1010303,-1.0782463,-1.0481018,-1.0138926,-0.97336218,-0.91560335,-0.85276586,-0.76865254,-0.68707189,-0.59630072,-0.51550065,-0.4453184,-0.40427245,-0.35234826,-0.30541975,-0.25707949,-0.19340254,-0.10543324,-0.039023974,0.049482328,0.004681728,-0.037987281,-0.042360481,-0.04457979,-0.042706073,-0.010077977,0.036141564,0.08560684,0.15312534,0.22084264,0.30713527,0.34282299,0.36403623,0.38448371,0.41361514,0.44223535,0.47724202,0.52697037,0.56553009,0.6006944,0.62344925,0.65755639,0.70114864,0.75248001,0.81644933,0.85348311,0.89368809,0.93952429,1.0101559,1.0949113,1.1895725,1.2743736,1.3608228,1.446001,1.5340304,1.6218613,1.711252,1.7993924,1.8841066,1.9683183,2.0539872,2.1404003,2.2251912,2.31404,2.4011947,2.4921717,2.5780187,2.6611177,2.7451281:4
1.9665116,1.9234543,1.8327161,1.7746795,1.7036245,1.6341848,1.5814934,1.526327,1.4651144,1.4232256,1.3709865,1.3214324,1.26792,1.2133781,1.1579812,1.1071894,1.0496089,0.99051096,0.91406136,0.86631915,0.82038116,0.76135286,0.67107088,0.58112176,0.53044977,0.48607735,0.40089279,0.35471691,0.26492105,0.1768077,0.13098504,0.073272637,0.015893968,-0.018077068,-0.042548409,-0.0889324,-0.10517407,-0.10494003,-0.12947471,-0.13404573,-0.14328125,-0.17123073,-0.20728518,-0.22734335,-0.26581622,-0.28233619,-0.30167814,-0.33265943,-0.37118014,-0.39249189,-0.42941979,-0.45010101,-0.46978506,-0.48912748,-0.50719337,-0.53178482,-0.53137276,-0.54263983,-0.54251895,-0.57723045,-0.58975183,-0.59670174,-0.61577031,-0.62227303,-0.64114447,-0.65371005,-0.64869229,-0.6638448,-0.67954804,-0.69714685,-0.69564906,-0.71138306,-0.72666249,-0.71984727,-0.72992727,-0.7400821,-0.75224612,-0.76965825,-0.77463538,-0.79241956,-0.80312657,-0.81400446,-0.8204543,-0.83362157,-0.84125699,-0.84264842,-0.85456461,-0.85886311,-0.86189047,-0.86715067,-0.87200714,-0.86858195,-0.86587193,-0.87436786,-0.88249119,-0.88786097,-0.90155415,-0.91411065,-0.92315635,-0.93448015,-0.94322194,-0.96240822,-0.97452495,-0.99635359,-1.0102963,-1.0321474,-1.0586739,-1.1016219,-1.1407308,-1.1737095,-1.2093585,-1.2464392,-1.2733285,-1.3113052,-1.3640556,-1.4294741,-1.4236788,-1.3800084,-1.4345851,-1.408861,-1.3512183,-1.313373,-1.2426316,-1.2034299,-1.137108,-1.0933674,-1.0254486,-0.98253616,-0.91849218,-0.85409793,-0.81208056,-0.74668476,-0.68919121,-0.64558342,-0.57187878,-0.51320855,-0.46049417,-0.39452107,-0.32957891,-0.26423853,-0.20784685,-0.17587961,-0.13127647,-0.097893427,-0.031868821,0.033058888,0.098542788,0.14498213,0.18956623,0.26779985,0.32872757,0.35905157,0.416981,0.44779705,0.48416768,0.53010303,0.55988031,0.58975286,0.62244706,0.66217466,0.66186489,0.67499996,0.71195363,0.69831976,0.65131469,0.60145058,0.59366548,0.60730754,0.5881276,0.56560641,0.55961246,0.55675212,0.63165299,0.67784897,0.71879542,0.7628557,0.84658907,0.92879063,0.97774539,1.0512278,1.1003999,1.1719063,1.2133257,1.2473598,1.2823541,1.3133522,1.3345718,1.3669127,1.3939284,1.4270822,1.4691575,1.5053209,1.5257602,1.5399479,1.5539955,1.5542453,1.5474116,1.5423505,1.5076828,1.4979998,1.4608171,1.4525582,1.4596822,1.4782645,1.5052192,1.5373729,1.550345,1.541978,1.5175394,1.4915935,1.4705216,1.433202,1.3990847,1.3598856,1.3150784,1.2750522,1.2354594,1.1826947,1.1310418,1.0958364,1.0657152,1.0651864,1.0999161,1.1229773,1.1156977,1.1710056,1.1999214,1.1893533,1.2290802,1.262315,1.3015122,1.341488,1.3739648,1.3847135,1.3949005,1.405699,1.3753409,1.3610934,1.3416001,1.3216056,1.2821555,1.2418986,1.1876646,1.143033,1.0682469,0.98946591,0.92401671,0.8866102,0.81473811,0.74367375,0.71328389,0.66763358,0.63177765,0.62585644,0.61569575,0.62124726,0.5985806,0.57243605,0.54560797,0.49250823,0.42835957,0.36325917,0.29539142,0.22721884,0.15366262,0.10192031,0.03127736,-0.027934004,-0.093165404,-0.15944766,-0.2058321,-0.26857791,-0.341081,-0.38913226,-0.45633876,-0.51273489,-0.58365656,-0.62795948,-0.69713273,-0.74630758,-0.80175327,-0.87355765,-0.92230442,-0.97720728,-1.04423,-1.079556,-1.1505596,-1.1833399,-1.2234005,-1.2477207,-1.2562465,-1.2492707,-1.2330904,-1.2005887,-1.1450486,-1.107198,-1.0671756,-1.0339023,-0.95163591,-0.91010322,-0.85733663,-0.82335157,-0.77935735,-0.74490133,-0.70469871,-0.6782785,-0.69549058,-0.72591099,-0.74423475,-0.77415654,-0.7886633,-0.81423156,-0.84659149,-0.871867,-0.89173436,-0.92061467,-0.95344505,-0.96745325,-0.9939786,-1.0107312,-1.0482784,-1.0782032,-1.1081721,-1.1524343,-1.1666578,-1.2035252,-1.2154836,-1.2335022,-1.2571831,-1.2788574,-1.2944256,-1.3018493,-1.3169014,-1.3300644,-1.3440282,-1.3624003,-1.3738468,-1.3708936,-1.3719501,-1.376012,-1.3693794,-1.363621,-1.3563825,-1.3592492,-1.3540992,-1.347431,-1.3362961,-1.3274885,-1.32153,-1.315657,-1.2966516,-1.2986141,-1.2809701,-1.2662167,-1.2498129,-1.2357183,-1.2261414,-1.2004194,-1.1735112,-1.1713364,-1.1054824,-1.0981222,-1.0756239,-1.0779021,-1.0329951,-1.0141627,-0.96581573,-0.94828813,-0.90726284,-0.86639379,-0.81939315,-0.77732973,-0.73155546,-0.68160019,-0.63877908,-0.56099026,-0.50509932,-0.41462346,-0.32404364,-0.23330119,-0.15108811,-0.094383769,-0.003112564,0.087773367,0.16759385,0.20865465,0.22641127,0.21458229,0.19321463,0.18131331,0.17264603,0.2264209,0.24735618,0.27521296,0.29470328,0.32704381,0.37255613,0.41767134,0.44549309,0.49151948,0.55543006,0.64528294,0.69327344,0.75758142,0.82032704,0.86236871,0.90098231,0.94104828,0.98921539,1.0347415,1.1227091,1.1632134,1.2103515,1.2563005,1.3057221,1.3515211,1.3981996,1.4455238,1.499756,1.5840099,1.6354813,1.6896007,1.7480529,1.8234286,1.8797344,1.9392863,1.9762137:2
1.117554,1.0255283,0.9269002,0.8246562,0.72409392,0.62350541,0.52807059,0.4262811,0.31759293,0.23164554,0.15665594,0.19349937,0.22231242,0.20808323,0.088972533,-0.010931648,-0.11386914,-0.22782334,-0.34394338,-0.46053623,-0.5769047,-0.69120747,-0.77920203,-0.88981741,-1.0043818,-1.105917,-1.2009458,-1.3101445,-1.4200775,-1.5337302,-1.6089544,-1.7177405,-1.7998014,-1.8979993,-1.9949256,-2.0656901,-2.129479,-2.1642314,-2.1533091,-2.0760424,-1.9927427,-1.9066018,-1.8057703,-1.7091542,-1.6127199,-1.512516,-1.4112603,-1.3075321,-1.2006401,-1.0929833,-0.99339043,-0.89379275,-0.78312927,-0.66584311,-0.57063583,-0.46332774,-0.34774115,-0.23090683,-0.14417144,-0.035126054,0.070023348,0.16949766,0.28257315,0.39046608,0.49218587,0.59680581,0.69933071,0.61129239,0.49732903,0.38073379,0.28431512,0.30386899,0.19510457,0.079293381,-0.025982011,-0.1404706,-0.25507248,-0.3474866,-0.45878627,-0.55634345,-0.62075011,-0.69976476,-0.75422446,-0.83494178,-0.91297713,-0.98717691,-1.0547535,-1.1038884,-1.1544815,-1.2063275,-1.2426615,-1.2578978,-1.2691844,-1.2699498,-1.2524013,-1.2250572,-1.1905355,-1.1495459,-1.0873699,-1.0132351,-0.94542659,-0.84986869,-0.72583722,-0.62028049,-0.51619621,-0.41164536,-0.32509006,-0.22615118,-0.13562707,-0.030556229,0.058353817,0.14273488,0.22211932,0.33335027,0.41168238,0.49013138,0.56352735,0.64610742,0.68904706,0.63968454,0.58635617,0.53571628,0.52333096,0.55714944,0.64076759,0.62083555,0.58899283,0.55991909,0.5283723,0.50983651,0.50986787,0.51999023,0.52658437,0.54134127,0.56638035,0.59228674,0.6268774,0.67211111,0.72816524,0.78076967,0.83400275,0.88556543,0.92883102,0.98550816,1.0322065,1.1023217,1.1733285,1.234982,1.276742,1.3181153,1.3352702,1.357045,1.4090146,1.46944,1.5634536,1.680092,1.7816957,1.8909719,1.9893876,1.9542348,1.8489387,1.7496249,1.6376292,1.5301618,1.4224151,1.3260738,1.3507015,1.4469386,1.451357,1.4055827,1.4011317,1.4140305,1.4335426,1.4520907,1.4479938,1.4520352,1.4486044,1.4268516,1.4000917,1.3743642,1.3380136,1.3067593,1.2776615,1.2507906,1.22013,1.1968776,1.1811304,1.1938141,1.222158,1.2948593,1.2552789,1.118481,0.99141589,0.88666727,0.78749285,0.65666275,0.5363904,0.48596091,0.42690713,0.32825528,0.26247306,0.17581289,0.050465724,-0.048593784,-0.13341774,-0.09514508,-0.070398447,-0.045522136,0.007943247,0.022880079,0.09061472,0.18002901,0.17185852,0.13056585,0.10542406,0.088774558,0.066485595,0.058552252,0.041800718,0.045819842,0.061315082,0.078678979,0.10475025,0.12904613,0.098384722,0.11412825,0.14049309,0.19015236,0.18577616,0.18780359,0.20229123,0.16349253,0.097083538,0.037428585,-0.020831217,-0.094189022,-0.15949267,-0.2288962,-0.30740508,-0.37717554,-0.44923024,-0.5084086,-0.57689653,-0.65290021,-0.72807506,-0.82441382,-0.92994834,-1.0534161,-1.1716889,-1.2847776,-1.3606545,-1.433811,-1.4978839,-1.5355635,-1.5702759,-1.58963,-1.6087428,-1.6127704,-1.5862681,-1.5603311,-1.5123679,-1.4584573,-1.3918529,-1.3113353,-1.2477939,-1.1633358,-1.0793123,-0.99480065,-0.93196656,-0.84398546,-0.78134287,-0.72628022,-0.82587041,-0.86147214,-0.83082697,-0.75122814,-0.66193782,-0.54863364,-0.42512676,-0.31773831,-0.31516956,-0.19980332,-0.10049238,0.022289202,0.10899443,0.17559689,0.24053893,0.2176218,0.086402277,0.0010140034,-0.12404309,-0.23710278,-0.35318754,-0.47019841,-0.5369952,-0.59118006,-0.71536847,-0.83496052,-0.94749305,-1.0685427,-1.1764595,-1.2850124,-1.3868119,-1.4833567,-1.6020749,-1.7025693,-1.8011679,-1.8837119,-1.9640784,-2.0196967,-2.043122,-2.0343083,-2.0006494,-1.9498194,-1.8873284,-1.8139956,-1.7255689,-1.636,-1.5403139,-1.4348362,-1.3410889,-1.2232377,-1.1120934,-1.0189662,-0.90299162,-0.81628412,-0.6920353,-0.57792825,-0.46158632,-0.34660022,-0.2225255,-0.10656659,0.0092174326,0.15004389,0.26874352,0.33954703,0.2817926,0.31283924,0.41166027,0.53265775,0.65181225,0.75504185,0.8648222,0.97912239,1.0972249,1.1937819,1.289498,1.3958092,1.4977503,1.5481303,1.4328163,1.3127962,1.1956,1.078246,0.96134534,0.81562821,0.67918945,0.54221069,0.43827243,0.34362922,0.25236691,0.16984223,0.11562618,0.066321381,0.02077797,-0.0047774512,0.0065527276,0.086161574,0.16211488,0.24886838,0.34337232,0.44354606,0.53964362,0.64057589,0.74465826,0.84913609,0.95332559,1.0430129,1.1500901,1.2548792,1.3490943,1.4559744,1.5581737,1.6601481,1.6591018,1.5432239,1.4672023,1.4548014,1.4148985,1.3691447,1.3211876,1.2900209,1.2894175,1.2949098,1.2754993,1.1604977,1.0620318,0.95429063,0.86462801,0.75387873,0.66018782,0.55854255,0.45902442,0.35174141,0.26076189,0.1558838,0.046331876,-0.038266495,-0.13928494,-0.22730183,-0.31194578,-0.32179184,-0.27092228,-0.20124694,-0.13564951,-0.061806175,0.0087486016,0.084189178,0.17562115,0.23122443,0.32745084,0.46636598,0.61318834,0.72898842,0.84793054,0.96670248,1.0857425:4
1.4468251,1.3442234,1.212838,1.1688611,1.0496945,0.9138947,0.93890584,0.85251394,0.75830963,0.65444431,0.72008221,0.70065746,0.60371496,0.49489113,0.41167133,0.40544195,0.54603871,0.570432,0.61058512,0.54244193,0.45584169,0.3692623,0.29294491,0.29287491,0.21582277,0.14367395,0.045773372,-0.08561829,-0.2210346,-0.28552327,-0.16037557,-0.080237746,0.079307964,0.23795746,0.40819766,0.54467993,0.4427591,0.36342495,0.28356327,0.17024793,0.14646008,0.047506293,-0.059623914,-0.17614567,-0.34747502,-0.23497996,-0.23156712,-0.32776211,-0.43281381,-0.54784749,-0.67764326,-0.7940633,-0.92920281,-1.1044563,-1.237626,-1.3959816,-1.5546738,-1.7232408,-1.8793076,-1.9229692,-1.8231978,-1.6791283,-1.5199408,-1.307343,-1.151951,-0.98026145,-0.75056873,-0.50977627,-0.29976405,-0.1047636,0.12828104,0.35130059,0.50400353,0.67499718,0.86348519,1.0422227,1.2356511,1.4120633,1.650505,1.8336186,2.0784872,2.3215621,2.5672086,2.7331716,2.942108,3.1363049,3.3596633,3.3935216,3.3488929,3.2916902,3.0474116,2.861752,2.6155428,2.3711474,2.1699848,1.9413433,1.697259,1.4541502,1.2704833,1.0304124,0.84806257,0.60505061,0.36508693,0.12408654,-0.033913827,-0.14668845,-0.37188888,-0.50419567,-0.75000943,-0.94819123,-1.082465,-1.184066,-1.2364653,-1.3209566,-1.2350206,-1.1478022,-1.0825648,-1.0567634,-1.1019113,-1.0271501,-0.93642261,-0.83743109,-0.79217304,-0.73811375,-0.67109466,-0.63427831,-0.55961253,-0.78948473,-0.98788519,-1.1539267,-1.1919556,-1.178886,-1.1268713,-1.0451311,-0.94878295,-0.86433221,-0.78789937,-0.80780192,-0.815619,-0.69454582,-0.58005862,-0.47567582,-0.46768459,-0.61422759,-0.50926509,-0.36469394,-0.24635325,-0.17861774,-0.047116141,-0.14437012,-0.087237819,0.078008626,0.21901349,0.11493932,0.27443589,0.37503187,0.53510699,0.65389932,0.57070123,0.40779689,0.21127772,0.054078343,-0.14749496,-0.30333476,-0.46382943,-0.47582509,-0.64781346,-0.83223947,-1.0166653,-1.0853627,-1.2370075,-1.265744,-1.1892987,-1.0453577,-0.97516261,-0.93589746,-0.81246666,-0.81394341,-0.7402386,-0.65367306,-0.52127377,-0.41485964,-0.34794335,-0.49657041,-0.39250389,-0.25157999,-0.33158789,-0.188882,-0.21217724,-0.13353449,-0.050445678,0.012299061,0.026547348,0.17308039,0.11862206,0.25614694,0.36040783,0.43802947,0.4273263,0.5708463,0.67629252,0.71850108,0.77378767,0.79922143,0.91182914,0.97652657,1.1054043,1.0871851,0.97007122,0.80005774,0.66639133,0.4166645,0.19994006,0.035720177,-0.15538048,-0.29202191,-0.47665961,-0.61985983,-0.76531798,-0.86588755,-1.0567881,-1.3061309,-1.4903681,-1.6770677,-1.9227369,-1.9860811,-1.8016439,-1.6830501,-1.5690776,-1.4452923,-1.3092071,-1.1974047,-1.0645133,-0.97046916,-0.95609111,-0.82666568,-0.6765491,-0.71954974,-0.64683531,-0.60210988,-0.47546745,-0.3409109,-0.27983777,-0.15510132,-0.017666545,0.057797017,0.20140994,0.33986025,0.41444618,0.35871911,0.51288315,0.67435989,0.75661329,0.83587333,0.84441175,0.90810777,1.0747991,1.2375351,1.3967048,1.5702469,1.7352657,1.8613922,1.7009989,1.5160568,1.3221322,1.1313697,1.1132763,0.96016875,0.76834243,0.68670029,0.50772723,0.32619018,0.24517962,0.058952116,-0.11271565,-0.12606876,-0.29283798,-0.47250596,-0.6163643,-0.78257579,-0.88847992,-1.0470409,-1.2156813,-1.394247,-1.5838074,-1.7405178,-1.7332562,-1.602583,-1.4086189,-1.1756255,-1.0241622,-0.84114387,-0.71195103,-0.55002185,-0.40727179,-0.24915076,-0.080139982,-0.13926394,0.077701901,0.30205022,0.47303914,0.70937925,0.83070869,0.71451901,0.56561629,0.4317314,0.28940867,0.12250788,-0.016004127,0.054388181,-0.081074808,-0.21619647,-0.32344114,-0.46642368,-0.63469723,-0.58627322,-0.58894827,-0.72722229,-0.8628404,-0.98876667,-1.1578994,-1.1661106,-1.3262212,-1.4483232,-1.5794329,-1.7369818,-1.6462053,-1.4500379,-1.2533497,-1.0528744,-0.87872117,-0.7094838,-0.53824288,-0.36562035,-0.27231656,-0.1799179,-0.0036840904,0.14818537,0.32415985,0.4882901,0.60376861,0.67312514,0.88183405,1.0497667,1.0799011,1.282,1.4386212,1.5735089,1.4759881,1.3469725,1.2803961,1.0659689,1.0166641,0.85453597,0.70272179,0.56591538,0.61753643,0.51087122,0.32763903,0.2553036,0.11625863,-0.092740103,-0.15424291,-0.012657085,-0.061085474,-0.2051005,-0.35308514,-0.48953221,-0.59977554,-0.67647062,-0.79888724,-0.90149382,-0.99254513,-1.1335812,-1.2318031,-1.3900694,-1.2374785,-1.0529829,-0.89555044,-0.72127806,-0.54088802,-0.33895954,-0.17384744,0.0092102822,0.045599367,0.21372371,0.39290331,0.5676701,0.68213131,0.85484873,1.0301824,1.2073671,1.1982715,1.1112926,1.0202135,0.90036608,0.7708061,0.66837145,0.7435619,0.63214614,0.63825751,0.55158286,0.42789723,0.47426744,0.41607684,0.35267744,0.31337092,0.23440802,0.11662904,0.05795366,-0.019502045,-0.12997272,-0.21694429,-0.29718761,-0.38117416,-0.50046294,-0.58558123,-0.4046939,-0.15526717,0.094447014,0.34409838,0.58318273,0.56158225,0.738319,0.93059292,1.1803704,1.3717567:1
3.0079512,2.9951781,2.8695266,2.750046,2.6270672,2.505612,2.3868401,2.2602041,2.1515857,2.0298028,1.9083882,1.7968978,1.6731108,1.5563426,1.427212,1.2959059,1.186858,1.0666247,0.95357457,0.83462372,0.70479958,0.57945328,0.46025761,0.34734336,0.22388847,0.093419852,-0.01659595,-0.1441851,-0.26308529,-0.38840334,-0.50444816,-0.64080908,-0.74984935,-0.86232769,-0.98382549,-1.1187357,-1.2357446,-1.371685,-1.437548,-1.5573491,-1.5395188,-1.550688,-1.5407284,-1.4879762,-1.4850668,-1.4500902,-1.4327277,-1.3593256,-1.2941291,-1.2438166,-1.1775769,-1.0967839,-1.0069974,-0.991956,-0.90308849,-0.84272704,-0.80446265,-0.87517121,-0.98159867,-1.0386244,-1.0068671,-0.94683809,-0.87657433,-0.80641028,-0.74929654,-0.69424257,-0.60567318,-0.55443721,-0.49438007,-0.49808547,-0.62038285,-0.68075678,-0.61492042,-0.5388345,-0.47869195,-0.39468136,-0.31968114,-0.25239866,-0.22537716,-0.1545455,-0.090567734,-0.071219172,-0.0085110513,-0.0088705565,-0.10161789,-0.22403744,-0.35960943,-0.49644115,-0.63708774,-0.77004691,-0.90640305,-1.016585,-0.98989015,-0.91263636,-0.83886576,-0.75969341,-0.6766003,-0.63369599,-0.53254281,-0.42758798,-0.38610637,-0.48904999,-0.59958403,-0.59397462,-0.52013938,-0.47573561,-0.36857418,-0.27428395,-0.19515643,-0.14908077,-0.061903711,0.0074541019,0.12582397,0.17474725,0.051761586,-0.058129777,-0.15325345,-0.056230414,0.046204064,0.13938656,0.15828405,0.28509445,0.40575444,0.48523314,0.50650693,0.4494913,0.52985315,0.62275457,0.74152266,0.81761609,0.88278793,0.96748832,1.0313905,1.0464828,1.0074038,0.88470854,0.7569644,0.60674381,0.48404189,0.38591147,0.26922788,0.14214277,-2.2746865E-4,-0.12523258,-0.25187388,-0.30924909,-0.32488409,-0.43936233,-0.57339937,-0.68943339,-0.81533907,-0.96335125,-1.085798,-1.2064019,-1.3198604,-1.4372798,-1.5397499,-1.4989084,-1.4422035,-1.3269258,-1.3161195,-1.1964031,-1.1072071,-1.0253812,-0.89905556,-0.78592723,-0.71750559,-0.69314668,-0.79025895,-0.82420028,-0.6974287,-0.56588474,-0.43635785,-0.32517252,-0.28887686,-0.21114627,-0.10660088,2.0074442E-4,0.077405732,0.092005745,0.0060774148,-0.11456147,-0.19756474,-0.27125651,-0.31564902,-0.25361541,-0.15916076,-0.051834189,0.064603852,0.12015869,0.19430041,0.29447241,0.34995422,0.46662296,0.55771104,0.55697754,0.50903426,0.63645984,0.77248581,0.88569867,1.0086768,1.1291897,1.2055484,1.2487737,1.367087,1.4876659,1.5770305,1.7189648,1.8361206,1.9482023,2.0668124,2.1290103,2.0370801,1.8911457,1.7647607,1.6127074,1.484448,1.3897251,1.2556577,1.1265754,0.99165268,0.94738489,1.0111761,0.96352615,0.84311742,0.71789218,0.60139637,0.52387895,0.48945304,0.35663621,0.22870517,0.085835279,0.05713784,0.16407241,0.28046747,0.39801793,0.52158682,0.5554176,0.51119904,0.45207705,0.3887233,0.27463715,0.20939383,0.21331392,0.10685284,-0.013685583,-0.11612008,-0.21778872,-0.33249153,-0.42582685,-0.42801394,-0.51871942,-0.61746546,-0.72215585,-0.8120213,-0.90903352,-1.0156907,-1.0991343,-1.1895431,-1.2787018,-1.3516583,-1.4355529,-1.3907597,-1.290106,-1.1519287,-1.0100402,-0.88521164,-0.73020428,-0.60679426,-0.47824618,-0.34861476,-0.23795007,-0.25162873,-0.16870024,-0.034721104,0.092948728,0.22459581,0.3521568,0.48183739,0.64702003,0.74402447,0.79685974,0.96364369,1.12677,1.2207867,1.3551397,1.5209183,1.6185564,1.5641841,1.4939367,1.386943,1.278551,1.181093,1.15997,1.103874,0.97601678,0.86412407,0.76321796,0.71479915,0.61835207,0.50147875,0.5250277,0.51219399,0.44277358,0.34013236,0.24822752,0.16588386,0.060555412,-0.040529577,-0.12881331,-0.15709384,-0.068725647,0.037204021,0.14632906,0.14534162,0.079476138,0.027730103,-0.015299352,-0.097915575,-0.025767155,-0.076111599,-0.16027152,-0.2825894,-0.37437357,-0.36737161,-0.26438083,-0.28164752,-0.32904732,-0.39363044,-0.46657887,-0.55780745,-0.62500973,-0.72892356,-0.79045804,-0.86127102,-0.95944474,-0.84525187,-0.73400086,-0.61776243,-0.5008787,-0.37229926,-0.3618964,-0.3803431,-0.32077618,-0.32945307,-0.29035124,-0.26639383,-0.28352588,-0.36764947,-0.38245833,-0.38832851,-0.42516961,-0.48009852,-0.48742762,-0.47677731,-0.53296589,-0.54156509,-0.63202378,-0.69321571,-0.71554659,-0.77292063,-0.85793499,-0.91165675,-0.98908804,-1.0492718,-1.0866714,-1.0753105,-0.96144452,-0.83122532,-0.66649144,-0.60607602,-0.61235078,-0.64824643,-0.71594577,-0.73280999,-0.77655218,-0.77893663,-0.85858121,-0.93246222,-1.0169901,-1.113668,-1.1538812,-1.1946022,-1.2784284,-1.2948756,-1.3544134,-1.4065401,-1.4596367,-1.5164369,-1.5129865,-1.3882573,-1.2717218,-1.1441258,-1.0264697,-0.89959165,-0.78342831,-0.66860895,-0.55362922,-0.4205623,-0.29834236,-0.18538212,-0.051841855,0.064929094,0.18661101,0.29797323,0.41859861,0.55255346,0.67011756,0.7874941,0.90853558,1.032689,1.1587309,1.2774168,1.3939581,1.5155845,1.6355218,1.7680172,1.8838603,1.9985418,2.1144559,2.2365355,2.3648597,2.4847726,2.5971613,2.719533,2.8521937,2.9688375:3
1.8376868,1.7746088,1.7265339,1.7434271,1.8510063,1.790671,1.7109946,1.7061961,1.6228605,1.5231108,1.4521652,1.4240947,1.4046255,1.3727095,1.3311764,1.2807558,1.2812333,1.3128726,1.3569463,1.4052403,1.4258249,1.3866091,1.331949,1.3095992,1.2839293,1.2408279,1.211295,1.2106736,1.234299,1.2551619,1.2507005,1.1796039,1.0911557,1.0010683,0.90991394,0.81080965,0.71724234,0.63456592,0.53561698,0.43842338,0.34761232,0.2549824,0.16288059,0.070760433,-0.025261884,-0.12338675,-0.21136686,-0.3062206,-0.39500987,-0.49549713,-0.58023189,-0.67855899,-0.77378112,-0.8590452,-0.95701676,-1.0456647,-1.1413793,-1.2369966,-1.3305269,-1.4251198,-1.5134129,-1.6079718,-1.702308,-1.7675351,-1.8049096,-1.8307817,-1.7985929,-1.8035431,-1.790168,-1.7754022,-1.7252829,-1.6792038,-1.6283975,-1.5752245,-1.5231907,-1.4743825,-1.4093791,-1.3502403,-1.289584,-1.2309022,-1.1705133,-1.1084309,-1.0337127,-0.9616549,-0.89466929,-0.82065144,-0.74019277,-0.66723393,-0.58648875,-0.50728109,-0.43532162,-0.36577472,-0.28700379,-0.22544002,-0.16873772,-0.13094855,-0.18164798,-0.14569278,-0.09501327,-0.058246811,-0.041135255,-0.0061835431,0.061301352,0.1110299,0.14281639,0.20880575,0.25490985,0.30215489,0.35849876,0.37161866,0.32263127,0.23573666,0.18743309,0.10114295,0.025016169,-0.023058325,-0.11152276,-0.18205319,-0.26669146,-0.30342309,-0.36893858,-0.45581076,-0.49831901,-0.58990417,-0.61539251,-0.6674068,-0.61419069,-0.61868923,-0.5685821,-0.46957201,-0.40003733,-0.40501663,-0.32528951,-0.25527465,-0.22437522,-0.12322428,-0.049362304,0.035403261,0.062290725,-0.02132912,-0.090840887,-0.17963702,-0.28096736,-0.24510929,-0.32415764,-0.39905299,-0.4420515,-0.51967584,-0.45980683,-0.36873998,-0.27636412,-0.20787072,-0.15419834,-0.04417888,0.015355469,0.030561162,0.10961331,0.19777412,0.27787366,0.36191685,0.42972677,0.50017091,0.56238319,0.55646805,0.63556677,0.71410091,0.7852776,0.86234998,0.9272667,0.9453919,1.0234209,1.1309288,1.2065612,1.2946416,1.3103053,1.3991611,1.4917342,1.5848133,1.6273511,1.7372619,1.8293168,1.9168025,2.0177017,2.1117302,2.2057306,2.2922457,2.3786608,2.4553987,2.446613,2.3369864,2.2275376,2.1186729,2.0280748,1.9253389,1.85248,1.8072906,1.7166061,1.6885777,1.6301017,1.5620296,1.4882466,1.3956149,1.4097395,1.4215798,1.3428467,1.2851552,1.2429976,1.1640601,1.0789486,1.0723029,1.0582083,1.0367614,0.94014726,0.90047376,0.79547284,0.78088415,0.71530599,0.60510653,0.60378867,0.59651423,0.6056359,0.51773398,0.41081047,0.33725148,0.26706439,0.17509261,0.075010042,-0.028744062,-0.14064824,-0.2430354,-0.3455462,-0.4438689,-0.53691469,-0.61742825,-0.7010616,-0.79915371,-0.8911726,-0.98745692,-1.0537585,-1.0955593,-1.085072,-1.1655575,-1.2409931,-1.1542609,-1.0537814,-1.0246151,-0.93806694,-0.91018125,-0.82436346,-0.73591521,-0.74353892,-0.63826831,-0.57138838,-0.48115014,-0.4554036,-0.37980168,-0.30925063,-0.27988925,-0.17324779,-0.083462491,0.012668062,0.097663994,0.18007885,0.11476428,0.04042754,0.0043139171,-0.077315902,-0.1121864,-0.15877144,-0.24865178,-0.31314054,-0.31335146,-0.30057692,-0.37818312,-0.43883485,-0.54304937,-0.52118815,-0.55171365,-0.59947876,-0.67257888,-0.77460463,-0.77723754,-0.82025248,-0.86587691,-0.94044137,-0.95471994,-1.0588299,-1.0832148,-1.1051516,-1.1991662,-1.2260396,-1.3243189,-1.3741302,-1.3725608,-1.2840695,-1.2022014,-1.1447234,-1.096418,-0.98342416,-0.90616378,-0.80874301,-0.70024855,-0.68356766,-0.59587107,-0.49127481,-0.40583289,-0.30754639,-0.23802277,-0.2173952,-0.13876497,-0.070547342,0.032600548,0.091311959,0.15366714,0.19995366,0.27056236,0.36502842,0.45464755,0.56015213,0.65827176,0.74219163,0.69507747,0.62527581,0.5834769,0.48035673,0.43375349,0.41972044,0.33766516,0.2838818,0.35816777,0.2892597,0.24043865,0.21106312,0.1394639,0.19296046,0.18235558,0.11351669,0.094984837,0.028005699,0.019247291,-0.022121836,0.03169321,0.11359518,0.052947182,-0.022328189,-0.027953811,-0.11112258,-0.12079082,-0.16368388,-0.23467712,-0.27924175,-0.18162836,-0.09926113,-0.17075924,-0.21293765,-0.2953234,-0.29800769,-0.33201882,-0.40419966,-0.42194766,-0.45136169,-0.52462982,-0.59517079,-0.6707527,-0.74737046,-0.82827414,-0.90444169,-0.97498132,-1.0428196,-1.0985088,-1.1714435,-1.2463702,-1.3149005,-1.3740399,-1.4231325,-1.4732681,-1.5198314,-1.5431139,-1.5874591,-1.6362506,-1.670961,-1.7125499,-1.7358838,-1.7787633,-1.7253431,-1.6366837,-1.5462588,-1.4748997,-1.3841779,-1.3974963,-1.3019033,-1.20537,-1.1675923,-1.0735066,-0.98103789,-0.88946552,-0.79179299,-0.70621378,-0.60667272,-0.50996171,-0.41493346,-0.32194543,-0.2347199,-0.14101989,-0.04123538,0.048982409,0.15118824,0.21894407,0.27999891,0.37462147,0.46494988,0.56400285,0.65347749,0.74564287,0.84563076,0.94523081,1.01046,1.1020943,1.1668283,1.26144,1.3370801,1.40769,1.5050947,1.5269727,1.6045612,1.678875,1.7642037:6
1.8422467,1.7528894,1.6612782,1.5413739,1.427651,1.3025126,1.1913309,1.0828588,0.95952646,0.83845236,0.72419271,0.59669722,0.50402054,0.39108831,0.30084668,0.18155035,0.05457401,-0.069389817,-0.16825973,-0.28032381,-0.40939529,-0.53341658,-0.65566943,-0.77498395,-0.9058173,-1.0536234,-1.1549961,-1.24414,-1.3697836,-1.3692314,-1.4321602,-1.511918,-1.5948013,-1.5926713,-1.5862661,-1.5996905,-1.5862713,-1.5185426,-1.4433157,-1.3637014,-1.2821503,-1.2013198,-1.1117671,-1.0335921,-0.9342053,-0.8367139,-0.75700458,-0.6764161,-0.58438259,-0.48840438,-0.38414092,-0.2991498,-0.21324541,-0.1262376,-0.052398493,0.04095443,0.11023885,0.14579995,0.18454586,0.23704403,0.28108556,0.29411175,0.31868816,0.35783976,0.36880398,0.41745297,0.44942451,0.45472604,0.50256183,0.56094364,0.62944755,0.69388351,0.7562153,0.76766462,0.76587101,0.77610882,0.76569465,0.72465456,0.73950999,0.63182253,0.4947995,0.37321989,0.24252117,0.12280861,-0.014946535,-0.13107655,-0.26195825,-0.38198019,-0.50664968,-0.58656802,-0.6517769,-0.72112378,-0.83748337,-0.95367553,-1.0678053,-1.1819902,-1.2970087,-1.4119789,-1.5262615,-1.6396114,-1.7435112,-1.7865037,-1.8422883,-1.9182362,-1.8300061,-1.698546,-1.7274307,-1.5973536,-1.4891579,-1.3750676,-1.3464011,-1.2043596,-1.1258196,-1.0281781,-0.91209272,-0.77870709,-0.65074854,-0.58914306,-0.50349733,-0.50062622,-0.51617435,-0.52564978,-0.52290089,-0.49992025,-0.44409277,-0.42333793,-0.43218964,-0.45985033,-0.49646096,-0.55985462,-0.63224888,-0.58766153,-0.49070695,-0.44402444,-0.40569012,-0.33087898,-0.26190842,-0.26683743,-0.28259937,-0.29050348,-0.2990207,-0.32767585,-0.3849139,-0.40538318,-0.43745437,-0.44878141,-0.52175487,-0.58534151,-0.62078196,-0.67046171,-0.66874472,-0.64980298,-0.71856535,-0.70634084,-0.68762507,-0.70945466,-0.73717961,-0.74061502,-0.81050151,-0.76268175,-0.86450144,-0.90427177,-0.93379428,-0.99654935,-1.0739604,-1.1832816,-1.3007824,-1.3856308,-1.4736486,-1.5430436,-1.5024406,-1.5030672,-1.4388307,-1.4362063,-1.3151635,-1.2112077,-1.0905412,-0.98688494,-0.91462252,-0.78741088,-0.71598649,-0.59367853,-0.48091027,-0.35658699,-0.23830538,-0.11784895,-0.0034855089,0.12246012,0.24831932,0.33519553,0.42590916,0.55503558,0.68187149,0.81313514,0.85149695,0.75033028,0.88997089,0.82815412,0.77951594,0.89103708,0.99037323,1.0615563,0.98427064,1.0728027,1.1301431,1.2404995,1.363321,1.497293,1.6079709,1.6400183,1.7526045,1.8521143,1.9483353,2.0210385,1.9951247,1.9856339,1.8901752,1.7876581,1.6666367,1.5598076,1.4811271,1.3540515,1.243269,1.1245749,1.0139595,0.90522233,0.80316627,0.72197593,0.60589781,0.51138227,0.43372552,0.29948708,0.22522098,0.10018833,-0.0036952745,-0.094636972,-0.14642488,-0.24311734,-0.29064605,-0.35257356,-0.35973307,-0.45074082,-0.54280274,-0.62251585,-0.66617154,-0.5677534,-0.54813614,-0.57883246,-0.45734635,-0.34509698,-0.33674721,-0.2339737,-0.11371302,-0.020906544,0.090043937,0.1710963,0.23066231,0.25219158,0.27005465,0.20167173,0.14877918,0.068072156,0.016582448,0.02294754,-0.01399715,-0.014860959,-0.041625524,-0.095049475,-0.13002775,-0.16297896,-0.15915893,-0.15882003,-0.17708669,-0.2091723,-0.18265912,-0.21468667,-0.26310711,-0.3197817,-0.37972181,-0.42457659,-0.50684553,-0.5927165,-0.67115551,-0.74416476,-0.83453576,-0.92005318,-0.99970094,-1.0807949,-1.1748814,-1.2560705,-1.2359906,-1.2044931,-1.1793066,-1.1749957,-1.130799,-1.1794365,-1.1534468,-1.1718363,-1.1619845,-1.1990561,-1.2020275,-1.2535539,-1.3100468,-1.4162037,-1.4912011,-1.5619417,-1.6067325,-1.5769123,-1.5845988,-1.4766435,-1.3624036,-1.2558038,-1.1991809,-1.0901837,-1.0704367,-0.98514391,-0.89487994,-0.84261723,-0.72079212,-0.64251842,-0.5803371,-0.4985542,-0.40489191,-0.27767839,-0.17014552,-0.10712959,-0.030357295,0.020003474,0.13407238,0.21390737,0.30509648,0.34115447,0.35931108,0.33264254,0.39380086,0.4254096,0.45402927,0.48818115,0.56673485,0.6178909,0.67662391,0.74725555,0.8679905,0.85947578,0.95361122,1.0343195,1.1135633,1.1736259,1.2298192,1.2855196,1.3351286,1.3863334,1.3928763,1.3093197,1.1909125,1.0928915,1.022968,0.97943077,0.87449336,0.81242793,0.72783048,0.64041803,0.55518214,0.45863532,0.37254737,0.29379791,0.18236847,0.090301354,-0.0019072297,-0.091139888,-0.1572819,-0.23103063,-0.23003598,-0.17204483,-0.096013787,-0.01439135,0.078153113,0.17345072,0.20388396,0.29842355,0.38575664,0.49541047,0.5831681,0.68214129,0.77088168,0.8574325,0.95011778,1.0394124,1.1098428,1.1917336,1.2812336,1.3593135,1.4363355,1.5018761,1.5826978,1.6682822,1.766557,1.8539928,1.8245833,1.720988,1.6525671,1.5167677,1.4679848,1.4093771,1.3716647,1.3216494,1.3138441,1.3201731,1.3390419,1.361096,1.4183144,1.5125979,1.5942,1.6763936,1.7305035,1.7777181,1.83067,1.8403191,1.8237299,1.8326008,1.8505914,1.8580229,1.8512605,1.8234379,1.7992184,1.828357,1.9138162:5
1.9312729,1.8499218,1.7630795,1.6724876,1.5848251,1.4867338,1.3866809,1.321244,1.3288289,1.3804945,1.4355764,1.4987365,1.5139305,1.4338797,1.3192742,1.2230462,1.107218,1.0118713,0.89634582,0.76063426,0.62551764,0.52860893,0.41492415,0.29998499,0.16476814,0.035748827,-0.065988557,-0.20150584,-0.33697901,-0.47252988,-0.57016811,-0.60911329,-0.62401453,-0.60437425,-0.55559121,-0.50454557,-0.45069277,-0.38652841,-0.31800757,-0.23517116,-0.14801416,-0.053235534,0.035066134,0.12531501,0.19155728,0.25951948,0.33528369,0.42490555,0.5090141,0.60677688,0.69429084,0.77658983,0.74435853,0.64976933,0.54833301,0.45360744,0.35496945,0.25709503,0.15294107,0.046584996,-0.052857629,-0.15918774,-0.18500131,-0.12151324,-0.05717541,-0.038841352,-0.096213955,-0.19381832,-0.2926059,-0.39242233,-0.48737843,-0.58142281,-0.68113863,-0.78037864,-0.87573138,-0.97892729,-1.0797947,-1.1786926,-1.2801086,-1.3754277,-1.4731695,-1.5715241,-1.6659523,-1.7612608,-1.8513109,-1.9345544,-2.0075359,-2.0701957,-2.089769,-2.1008381,-2.0816602,-2.0206106,-1.9319282,-1.8155179,-1.6991105,-1.5955023,-1.4848148,-1.3676591,-1.2512764,-1.1160664,-1.0213851,-0.94902078,-0.8703429,-0.7703523,-0.68335973,-0.58499878,-0.49046387,-0.40424056,-0.36642596,-0.26082271,-0.17451191,-0.079203834,0.010556336,0.10637788,0.20878504,0.31249341,0.42626506,0.50717973,0.38114975,0.28588156,0.24325929,0.17325349,0.086121865,-0.0058654675,-0.078690578,-0.15919008,-0.22744544,-0.28490178,-0.34111199,-0.39274727,-0.42253754,-0.40013652,-0.31758943,-0.20100816,-0.088927648,-0.019476947,-0.14016295,-0.23940169,-0.32473631,-0.38689787,-0.44494932,-0.49278537,-0.54334704,-0.58876822,-0.62444324,-0.65552748,-0.68787984,-0.72236434,-0.75617473,-0.78944493,-0.82129567,-0.84811274,-0.87090821,-0.88514133,-0.8953382,-0.89662012,-0.89417289,-0.89025897,-0.88066643,-0.85395545,-0.82924312,-0.78988575,-0.73578969,-0.66910692,-0.55238012,-0.45605652,-0.35912066,-0.26279399,-0.17666454,-0.097036611,-0.019408881,0.054194076,0.10812572,0.17353161,0.25196811,0.34995117,0.43025355,0.47018367,0.56694688,0.63967947,0.70402936,0.72646621,0.79049902,0.86490132,0.83744457,0.81733058,0.7998926,0.79565675,0.80346192,0.81503231,0.82950209,0.85357038,0.88721395,0.92430001,0.95955982,0.99844114,1.0452497,1.0831539,1.116889,1.159334,1.1915505,1.2243481,1.2546726,1.2886945,1.3233082,1.3523948,1.3834024,1.4048052,1.4159941,1.4237291,1.4475753,1.5131369,1.5987594,1.5249854,1.4610681,1.3931896,1.4051279,1.4492266,1.509726,1.5617291,1.6131775,1.6616746,1.7116264,1.7452035,1.7733444,1.8037607,1.8196345,1.8069134,1.7949152,1.778573,1.7261842,1.6667183,1.5805822,1.483718,1.3864248,1.2878976,1.2163402,1.147356,1.1007244,1.0698341,1.0407474,1.0082414,0.98915589,0.97937714,0.96413156,0.9553036,0.9413083,0.93472741,0.92972422,0.93238792,0.94615283,0.96464745,0.96476007,0.94775053,0.96987845,1.0027745,1.0073166,0.92767201,0.87212102,0.81997538,0.74738982,0.66975163,0.60583884,0.53892714,0.49609337,0.43348966,0.34417255,0.25566077,0.16533378,0.060774221,-0.017949076,-0.13944198,-0.24405455,-0.33174243,-0.39719992,-0.44571755,-0.49171506,-0.52344358,-0.5579826,-0.59023445,-0.62993018,-0.65461449,-0.68044577,-0.69636941,-0.70285318,-0.71894057,-0.74493286,-0.76615881,-0.77830942,-0.78843473,-0.78480049,-0.78798355,-0.78581458,-0.77083769,-0.74661161,-0.7097782,-0.66652227,-0.63145309,-0.5646856,-0.48897539,-0.42219497,-0.37309862,-0.31959743,-0.26761475,-0.34475985,-0.45406125,-0.5665727,-0.65936105,-0.78827652,-0.90775649,-0.9930767,-1.0402045,-1.093403,-1.1613611,-1.2265469,-1.2913839,-1.3544765,-1.4044535,-1.4645845,-1.5138533,-1.5361959,-1.5369599,-1.5726733,-1.6278245,-1.6873659,-1.7849927,-1.8197686,-1.7861716,-1.7202581,-1.7073015,-1.7415021,-1.7868073,-1.859168,-1.8884045,-1.8921973,-1.8705678,-1.8376268,-1.7958024,-1.7442284,-1.6888389,-1.6242801,-1.5549678,-1.4891181,-1.4153245,-1.3452417,-1.2710382,-1.1983401,-1.1160788,-1.0453282,-0.9571942,-0.87775192,-0.79049271,-0.70282129,-0.61356277,-0.52149377,-0.43677943,-0.336872,-0.24359926,-0.15035922,-0.050040846,-0.063946591,-0.15652023,-0.22521777,-0.14743819,-0.05193526,0.039679993,0.13221472,0.2279585,0.32182532,0.42971365,0.53392173,0.55039502,0.47427125,0.36065579,0.29325781,0.20928366,0.118822,0.021417701,-0.077110901,-0.17536475,-0.27006937,-0.37080111,-0.46061194,-0.55503976,-0.61825713,-0.67925946,-0.71973847,-0.71124343,-0.67991523,-0.60148127,-0.495593,-0.39929529,-0.28819219,-0.17929726,-0.057936077,0.052776224,0.1668574,0.28269797,0.39818841,0.49886507,0.60015126,0.701233,0.79048671,0.87660016,1.0064013,1.0964084,1.2079776,1.09513,0.99721323,0.9017767,0.81917225,0.7506067,0.7286749,0.74185146,0.78176849,0.85406155,0.93991529,1.0485504,1.1588978,1.2686209,1.3773716,1.4902704,1.6073053,1.7236461,1.8413799,1.8633483,1.8461955:4
0.77869438,0.67526818,0.57345007,0.47558397,0.36925476,0.2968217,0.22921994,0.15133096,0.089109859,0.088147802,0.16778755,0.23729931,0.30922752,0.33010045,0.35127902,0.42234969,0.51197445,0.56426662,0.56950146,0.56820155,0.64102943,0.72004375,0.82876278,0.88140355,0.94245273,1.0417274,1.1341817,1.2530012,1.2758838,1.1572003,1.0422881,0.92243125,0.80112157,0.69358916,0.57848758,0.4984325,0.46909311,0.39230739,0.3397579,0.2438777,0.12890793,0.021372942,-0.083381753,-0.19391228,-0.27390666,-0.35545295,-0.47292844,-0.59561587,-0.69156349,-0.81030517,-0.9232523,-1.0341165,-1.1510079,-1.2188534,-1.3185548,-1.4438604,-1.5534976,-1.6418523,-1.712825,-1.8348175,-1.918064,-2.0474263,-2.1623653,-2.26036,-2.2322646,-2.2052833,-2.093135,-1.9835278,-1.8477455,-1.7572593,-1.6561936,-1.5363669,-1.4372837,-1.325472,-1.2211429,-1.1236067,-1.0037881,-0.99609635,-0.86513439,-0.77124105,-0.62730852,-0.50246803,-0.3834395,-0.29062203,-0.18929845,-0.080098991,0.022905012,0.10934728,0.15418721,0.15693574,0.20557736,0.26895472,0.34179713,0.37144704,0.44025812,0.48756464,0.5623431,0.60878255,0.6564555,0.72012039,0.81082368,0.93074961,1.02694,1.1189672,1.1853238,1.2880937,1.3558793,1.4028624,1.3839645,1.4167771,1.4363512,1.4377617,1.4569091,1.4677977,1.478875,1.5020389,1.5320939,1.5482433,1.5819851,1.6211378,1.6650655,1.7137504,1.7117204,1.6352499,1.58153,1.5176006,1.4519615,1.4003636,1.2947636,1.1976271,1.0783076,1.0282481,1.0210154,1.001533,0.96844624,0.97273937,0.92342629,0.86875516,0.82808276,0.70647617,0.6135379,0.5407486,0.5242859,0.43160964,0.41353889,0.32461846,0.31332086,0.28128651,0.29738665,0.30545702,0.3528763,0.4143527,0.37550754,0.26279247,0.12601045,0.03352753,-0.073325098,-0.18639786,-0.275743,-0.40071987,-0.46421394,-0.54649831,-0.67123722,-0.79305595,-0.899043,-1.0205187,-1.133487,-1.2470653,-1.3415451,-1.4373416,-1.5303379,-1.6015678,-1.6999469,-1.7710446,-1.8612772,-1.9267532,-1.9169645,-1.8642516,-1.7340241,-1.6120422,-1.5022152,-1.535569,-1.5515943,-1.545448,-1.4770794,-1.4142577,-1.3742904,-1.264512,-1.1390924,-1.0242208,-0.89849555,-0.75660555,-0.64856113,-0.59429149,-0.48607817,-0.38974709,-0.28669682,-0.18118606,-0.065843956,0.051306368,0.19282937,0.28486342,0.37003212,0.43867889,0.54172274,0.65059075,0.70141958,0.61306605,0.50232703,0.40878466,0.30353984,0.193122,0.086731042,0.04084415,0.001310171,-0.049890243,-0.10353682,-0.17395916,-0.22761003,-0.28585653,-0.34715558,-0.40790367,-0.47266852,-0.55105669,-0.6175836,-0.63311209,-0.58377243,-0.49471917,-0.40205717,-0.27609192,-0.15356662,-0.05941867,0.03829382,0.13295531,0.25848763,0.32628652,0.44730259,0.57038149,0.65274514,0.76351735,0.88205596,0.95287672,0.88818291,0.80743352,0.73411336,0.65858442,0.56193652,0.46909311,0.40728725,0.36457301,0.25740436,0.14312809,0.043376184,-0.059987269,-0.10907088,-0.14178285,-0.21895607,-0.32053844,-0.42580321,-0.52828987,-0.62697151,-0.69346463,-0.78024647,-0.84057858,-0.92881883,-1.0129537,-1.1002387,-1.1444025,-1.1591073,-1.0775798,-0.94400949,-0.83591659,-0.69422294,-0.59260899,-0.42978271,-0.32598875,-0.17496231,-0.036980012,0.078642716,0.22652578,0.30096542,0.45368321,0.55681044,0.69433239,0.83174036,0.9984588,1.1642668,1.3027532,1.4545974,1.5956627,1.7353823,1.8348711,1.9328137,1.9942007,2.1457111,2.2996946,2.4524401,2.5919118,2.6437214,2.5624845,2.4195368,2.308651,2.1532886,2.0261287,1.8729561,1.745197,1.578156,1.4107655,1.2678464,1.1430677,1.0295217,0.90233861,0.84060107,0.68872388,0.5487501,0.41201339,0.3214941,0.18158838,0.06864527,-0.028203737,-0.14794206,-0.23771336,-0.32518949,-0.44761787,-0.47466973,-0.55719791,-0.64232517,-0.74957127,-0.82369849,-0.94862303,-0.99157178,-1.082466,-1.1953452,-1.2903281,-1.3822069,-1.4311747,-1.4619164,-1.4312219,-1.4523187,-1.4079879,-1.4051787,-1.3663394,-1.3423007,-1.2975378,-1.2569687,-1.1854116,-1.1228299,-1.0428026,-0.99156023,-0.92960835,-0.85667424,-0.78726333,-0.70914558,-0.62733142,-0.5385557,-0.44568102,-0.35559565,-0.25239122,-0.15625509,-0.11325731,-0.13520343,-0.17461574,-0.14077208,-0.050171503,0.06414537,0.17720755,0.29521655,0.41568998,0.48338102,0.50047464,0.55722206,0.63231008,0.69985729,0.80473177,0.90344175,0.9927571,1.0795334,1.0944384,0.99110422,0.87398328,0.7546448,0.64198847,0.5172285,0.392559,0.27744166,0.1948763,0.11311414,-0.022010968,-0.13797654,-0.21687351,-0.29303848,-0.42240523,-0.54938385,-0.689801,-0.74213445,-0.81824651,-0.92363237,-1.0452243,-1.1128137,-1.1800514,-1.1668948,-1.1198378,-1.0471686,-1.0084205,-0.93204666,-0.84254436,-0.80690556,-0.7522333,-0.71273236,-0.71002579,-0.58973276,-0.47847241,-0.39454996,-0.30784886,-0.22574275,-0.11019808,0.0053642465,0.099304631,0.17764532,0.22648211,0.2832582,0.36406669,0.44690307,0.51374392,0.59583382,0.68563044,0.76409442:5
2.8469175,2.6440628,2.4479015,2.2781542,2.1433007,1.9587122,1.8028744,1.6599353,1.4917057,1.3155673,1.1338132,0.95526129,0.77946265,0.60872519,0.44369343,0.28371942,0.13000292,-0.018282888,-0.16132206,-0.30096146,-0.16756147,-0.031196277,0.11295421,0.22829824,0.076328286,-0.074592739,-0.22596835,-0.35858005,-0.48622979,-0.59823053,-0.51775556,-0.39035196,-0.31208486,-0.42870227,-0.55367797,-0.6513567,-0.72688089,-0.78823465,-0.68292785,-0.65288859,-0.64067015,-0.66817867,-0.73131824,-0.85613709,-1.007065,-1.0368854,-1.0810337,-1.0922847,-1.1026084,-1.1044539,-1.0925314,-1.0791983,-1.0365996,-0.97839751,-0.85245475,-0.78057116,-0.72678958,-0.5868097,-0.44513942,-0.30896264,-0.15087905,-0.046752743,-0.16973051,-0.26678553,-0.35864924,-0.52063911,-0.43792512,-0.30345288,-0.17931205,-0.03778299,0.12194575,0.2747796,0.42839846,0.59778442,0.75534079,0.92992819,1.0941632,1.2750108,1.4414967,1.6315902,1.8010347,1.9988532,2.0007984,1.8277584,1.6354368,1.4694711,1.282217,1.1008156,0.91190846,0.7331442,0.55916337,0.39708364,0.23811783,0.097153961,-0.036900849,-0.14770145,-0.25389603,-0.33325697,-0.40156733,-0.44144605,-0.51657699,-0.66524272,-0.82720515,-0.90412787,-0.82742611,-0.8718553,-0.77694469,-0.71735518,-0.55909402,-0.41838018,-0.33499571,-0.20814597,-0.19914368,-0.094527301,-0.049362931,0.075038671,0.16638101,0.20290233,0.1804723,0.12608869,0.14582062,0.023702678,-0.082718999,-0.10226018,-0.21083717,-0.28112611,-0.39527111,-0.50385902,-0.65160368,-0.80268207,-0.94201517,-0.96714226,-1.0108345,-1.0740436,-1.1618045,-1.3003514,-1.4058607,-1.5514917,-1.4997023,-1.6112575,-1.5010236,-1.397967,-1.1655883,-1.0020057,-0.82508885,-0.66936591,-0.53133769,-0.52378931,-0.44597468,-0.33589945,-0.40743295,-0.335453,-0.29255821,-0.17255772,-0.19325646,-0.24135148,-0.20624768,-0.15076853,-0.073372312,-0.15561659,-0.15936591,-0.26171306,-0.39003376,-0.5112065,-0.56773337,-0.67742966,-0.63192677,-0.5507535,-0.47969325,-0.31570489,-0.25593909,-0.13368216,0.016755183,0.13101301,0.13840257,0.11243586,0.22178051,0.33157048,0.42074229,0.36010088,0.48703241,0.61178961,0.75256055,0.80430554,0.96009917,1.0759941,1.1010718,1.1563757,1.2364578,1.2710654,1.3578574,1.5244403,1.5779908,1.5277966,1.4614985,1.2779145,1.2446024,1.1125611,1.0459958,1.050904,0.89575782,0.87012199,0.76457352,0.69218948,0.60093607,0.48389763,0.31338557,0.20321773,0.27682083,0.13233572,0.0097436164,-0.11276378,-0.18785626,-0.26524899,-0.40910119,-0.34457454,-0.22505647,-0.13070021,0.021486171,0.16161162,0.30030006,0.46711581,0.53261093,0.6641067,0.81685303,0.87630845,0.92381871,1.0329085,1.1914087,1.2942806,1.446326,1.5847325,1.7592482,1.8194627,1.678855,1.6530938,1.5629541,1.4385109,1.41182,1.2975411,1.2691028,1.2477758,1.122745,1.0056132,0.90209934,0.86323842,0.96450503,0.85263359,0.74223673,0.68108348,0.56068144,0.42852205,0.47893313,0.41146705,0.34662056,0.2583665,0.18002878,0.087255049,0.05978064,0.083907186,0.20521326,0.39345972,0.48516528,0.66183535,0.83750627,0.95317857,1.1462074,1.1020045,1.0099796,0.9007217,0.85883152,0.78885045,0.69855367,0.79060981,0.74165016,0.65954341,0.64075242,0.5662959,0.44198898,0.47206505,0.39958106,0.28930856,0.27680578,0.17241147,0.07983006,-0.030186536,-0.047934716,-0.16594349,-0.30632407,-0.40317722,-0.32951678,-0.16249572,-0.05499644,0.11193381,0.078651629,0.021677789,-0.040566192,-0.15656429,-0.083217474,-0.19319812,-0.27026128,-0.30960043,-0.41362051,-0.51674611,-0.42169743,-0.51674912,-0.61108852,-0.7353458,-0.82126134,-0.91514292,-1.004766,-1.1216623,-1.2444602,-1.3283516,-1.3990038,-1.5162771,-1.5809356,-1.7132146,-1.8010882,-1.6734724,-1.8286961,-1.6339631,-1.4415464,-1.215407,-1.0171635,-0.82036405,-0.62272458,-0.424558,-0.23561573,-0.057926025,0.13990238,0.30961926,0.51022139,0.68005665,0.88140995,1.0702323,1.2871124,1.4830013,1.6623407,1.7051303,1.6955223,1.5789931,1.3477136,1.1981859,1.022377,0.84819061,0.65991769,0.48221782,0.29634952,0.12405055,-0.079307899,-0.28263221,-0.4427372,-0.5945073,-0.79649769,-0.96422901,-1.1851418,-1.3658729,-1.5983774,-1.7209207,-1.8795039,-1.9855907,-1.9545843,-1.8751345,-1.8313341,-1.7434584,-1.7156923,-1.5880598,-1.5871392,-1.4837525,-1.5768805,-1.44903,-1.3439473,-1.3360964,-1.3176817,-1.3703452,-1.2682382,-1.2983967,-1.2025927,-1.2191538,-1.2406709,-1.1456988,-1.1502588,-1.1485935,-1.2506128,-1.3363167,-1.3860453,-1.4645152,-1.4639577,-1.4788,-1.4726296,-1.4188403,-1.3128087,-1.2196866,-1.2067565,-1.1629345,-1.1504584,-1.1572189,-1.144997,-1.0505367,-1.0073457,-1.0076884,-1.0070878,-0.88701824,-0.78181515,-0.66905623,-0.57026978,-0.47799201,-0.34592249,-0.20360761,-0.076246665,0.076072408,0.23577349,0.39818462,0.56777995,0.74030965,0.91962978,1.1012439,1.2871535,1.4755897,1.6670944,1.7830835,1.972954,2.1704925,2.36928,2.5709107,2.7610479:1
1.9285257,1.8624743,1.7635706,1.652911,1.5432397,1.4372277,1.3285703,1.219703,1.1198383,0.97558367,0.86528427,0.76608081,0.65919101,0.50820332,0.35645016,0.26111136,0.16170365,0.039591995,-0.05789773,-0.20905596,-0.35341879,-0.44056475,-0.5347372,-0.6512029,-0.751678,-0.87695536,-0.89405271,-0.78160615,-0.68092859,-0.57847484,-0.48549716,-0.36168558,-0.30223256,-0.20165656,-0.089645318,-0.013542874,-0.0091343736,-0.0033969899,0.065028214,0.1325274,0.23192239,0.26188395,0.17531717,0.059595884,-0.036354172,-0.12844816,-0.21335128,-0.31469131,-0.36428487,-0.44642654,-0.47297078,-0.53346704,-0.59877972,-0.70045292,-0.778048,-0.88012657,-0.96578947,-0.9278337,-1.0002677,-1.0655482,-0.95488254,-0.80089166,-0.89639877,-0.84567303,-0.68511726,-0.55753299,-0.51208588,-0.66827962,-0.57576414,-0.42917161,-0.3556178,-0.35714101,-0.24547425,-0.20589364,-0.093640431,0.042920249,0.03552741,0.18988666,0.31011479,0.43014307,0.51425821,0.61536703,0.73578628,0.85320362,0.95482975,0.99767822,1.0788882,1.1475761,1.2651427,1.3684794,1.4721383,1.5673166,1.6411221,1.6787733,1.5425825,1.408675,1.329911,1.2506627,1.1656178,1.0408717,0.92788615,0.92737343,0.8448467,0.75302429,0.67436536,0.61487984,0.54475012,0.46548224,0.41467789,0.44523079,0.3214354,0.21616825,0.11008619,0.04998199,-0.012168441,-0.067817677,-0.044408846,-0.16278102,-0.12604385,-0.13947925,-0.20984397,-0.15298524,-0.099208292,-0.026064483,0.079231276,0.15907176,0.27515093,0.35585627,0.45693263,0.55785876,0.65436595,0.76298397,0.70286485,0.65185445,0.57032749,0.50208928,0.47194015,0.36752181,0.23938294,0.1824424,0.17811618,0.059238524,-0.057231357,-0.16103324,-0.26302596,-0.25706819,-0.34299323,-0.40305296,-0.50542346,-0.59972087,-0.58485571,-0.65812261,-0.75632688,-0.83653576,-0.93535727,-0.98928501,-0.94466251,-0.98220125,-1.0219623,-1.0608054,-1.0789653,-0.92531425,-0.83091447,-0.72055832,-0.5649458,-0.55059317,-0.40030996,-0.27785773,-0.24943377,-0.33567941,-0.42706491,-0.48821685,-0.53022026,-0.5947885,-0.65926846,-0.60304238,-0.62878301,-0.68440016,-0.681039,-0.76449319,-0.73991533,-0.8350526,-0.79556004,-0.86347574,-0.93743726,-1.0050649,-1.0753615,-1.1726622,-1.1847244,-1.1698203,-1.1529422,-1.2077608,-1.2667939,-1.3064845,-1.3498676,-1.3971461,-1.4810841,-1.5662546,-1.6140453,-1.6810258,-1.7930207,-1.7471141,-1.6410625,-1.5091834,-1.3998293,-1.2687407,-1.1390211,-1.0154321,-0.91115808,-0.78593075,-0.64414443,-0.55490395,-0.47035962,-0.33574515,-0.21834824,-0.11551896,0.032253214,0.14710828,0.25167481,0.38729808,0.51295244,0.63922449,0.77302634,0.87863558,1.01427,1.1424302,1.2424489,1.378437,1.5096892,1.6403393,1.7427301,1.8538164,1.9629485,2.1022154,2.2068354,2.3163209,2.4514549,2.5529236,2.6344402,2.6071211,2.5999651,2.5599816,2.435913,2.326288,2.2066523,2.0988106,1.9631609,1.8512769,1.7302013,1.6193884,1.4810699,1.3692802,1.2619794,1.1265851,0.99387076,0.87698065,0.768104,0.6377068,0.51449975,0.41008897,0.27613717,0.14730443,0.048902185,-0.080864906,-0.21038827,-0.31445551,-0.44360117,-0.5746491,-0.68116242,-0.81078467,-0.91024903,-1.0524178,-1.1594389,-1.2778553,-1.3943085,-1.5147283,-1.6456597,-1.7430384,-1.8819285,-1.9836879,-2.0784726,-2.0207101,-2.0309008,-1.9577152,-1.9008643,-1.8067246,-1.7276821,-1.5931832,-1.5020409,-1.43361,-1.3635342,-1.3934018,-1.2876566,-1.2563151,-1.2065896,-1.2452376,-1.2108876,-1.2222413,-1.1477991,-1.0807766,-1.1048677,-1.2024672,-1.2621643,-1.3115402,-1.2801201,-1.2035699,-1.1194848,-1.0426688,-0.96920038,-0.88889969,-0.79889113,-0.73653395,-0.68872023,-0.63001915,-0.5597544,-0.48392961,-0.46919526,-0.41442052,-0.35720728,-0.28840736,-0.37718734,-0.28718217,-0.22129716,-0.13788658,-0.11936498,-0.027441547,0.059268804,0.14786076,0.20838039,0.12105652,-0.030519371,-0.11864451,-0.23059342,-0.30144008,-0.38889178,-0.50542033,-0.60814281,-0.72983004,-0.88084521,-0.9476586,-1.0372629,-0.97613186,-0.86407113,-0.76327842,-0.65217959,-0.55912604,-0.48369328,-0.41235952,-0.29778097,-0.19488372,-0.1395144,-0.085806118,0.024073267,0.1442335,0.19344246,0.098115778,0.18226401,0.32076023,0.44497872,0.52064459,0.5995578,0.7137471,0.70006161,0.733492,0.81285606,0.85482743,0.96226881,1.048451,1.0785485,1.0374393,1.1767844,1.2710788,1.3064717,1.3988611,1.4644799,1.390514,1.2678139,1.1686493,1.0685635,0.94619845,0.92498453,0.80283093,0.66077023,0.55494236,0.45620305,0.43707817,0.31376219,0.18062762,0.060666121,-0.063723216,-0.15211808,-0.2739947,-0.39534562,-0.49869729,-0.63112037,-0.75628772,-0.82795204,-0.698075,-0.61118791,-0.50559184,-0.40438402,-0.31782858,-0.2145074,-0.11201021,-0.053310383,0.062818259,0.15502785,0.251515,0.31327368,0.37678226,0.49893405,0.62763259,0.73852039,0.84809748,0.83977607,0.9327922,1.0376396,1.1437588,1.2458612,1.3483384,1.3161882,1.4207306,1.5273073,1.6454776,1.7241572,1.8256327,1.9152696:1
1.5254661,1.4446196,1.4459019,1.4511577,1.3709365,1.430545,1.410685,1.378852,1.3503618,1.2876998,1.2525708,1.2251237,1.1526133,1.0891645,1.0227587,0.97462071,0.92068923,0.86722344,0.80175629,0.73475566,0.6709551,0.57104829,0.50117318,0.42705654,0.3246886,0.24614001,0.1478635,0.040248117,-0.039988181,-0.13748501,-0.24670712,-0.33128554,-0.43170011,-0.54150447,-0.65888451,-0.73920383,-0.85278352,-0.96253115,-1.0457591,-1.1478071,-1.2063893,-1.2164497,-1.1946285,-1.1244617,-1.0586264,-1.0047749,-0.90925973,-0.84177011,-0.76994534,-0.74950729,-0.72641468,-0.74548207,-0.73152396,-0.75203495,-0.77464184,-0.77119249,-0.80573926,-0.79944078,-0.85047687,-0.91290641,-0.95674789,-0.99849314,-1.0654776,-1.1376859,-1.1872899,-1.2701703,-1.3367101,-1.3950906,-1.4516138,-1.5128558,-1.5794401,-1.6427181,-1.7139542,-1.7642406,-1.818111,-1.8679625,-1.9142986,-1.9451202,-1.9191345,-1.8759903,-1.7881742,-1.7143567,-1.6120356,-1.6284893,-1.5164295,-1.4320389,-1.351076,-1.2735406,-1.1945303,-1.1011458,-1.0129574,-0.954631,-0.92142573,-0.83530134,-0.73724444,-0.63903309,-0.52336684,-0.41843267,-0.32125601,-0.20809362,-0.12762616,-0.051963598,0.059654312,0.12727892,0.20021076,0.25182541,0.28970363,0.3153845,0.32157793,0.35652571,0.35774254,0.35177245,0.33984208,0.31896791,0.29069434,0.25540892,0.23306729,0.19237941,0.15145134,0.11581425,0.080916971,0.044452475,-0.013503883,-0.045431139,-0.08531707,-0.13216373,-0.17767311,-0.22300829,-0.26453145,-0.3250811,-0.36401917,-0.39803841,-0.42909042,-0.45636278,-0.47812957,-0.48572588,-0.5113677,-0.53586491,-0.55085593,-0.56314235,-0.57941875,-0.60437092,-0.61906371,-0.63447099,-0.64670616,-0.64846682,-0.66579709,-0.67552267,-0.68517192,-0.70228699,-0.70631932,-0.71106631,-0.73057377,-0.71025075,-0.72331083,-0.72426139,-0.76702951,-0.73207406,-0.71807105,-0.69080338,-0.60459761,-0.51515874,-0.42185734,-0.322684,-0.25068291,-0.1504182,-0.078570155,0.0031545159,0.052098407,0.12431544,0.17391772,0.20303456,0.28437178,0.3373775,0.39240158,0.43820876,0.4990326,0.54462574,0.58006205,0.62155447,0.6831672,0.71265904,0.73928032,0.78398278,0.83121714,0.86725786,0.89960457,0.9622414,0.97231828,1.0620784,1.1307384,1.1961284,1.2601271,1.3221596,1.3734884,1.4236458,1.4865783,1.5545578,1.6155652,1.6616178,1.7295121,1.7567139,1.7872283,1.7989766,1.811288,1.8417657,1.8579877,1.8778783,1.8889805,1.9407209,2.0055909,2.0555968,2.0860637,2.0937747,2.058291,1.9981469,1.9598491,1.8779111,1.7800763,1.6822051,1.5915407,1.5194838,1.480141,1.4744439,1.4889948,1.4659919,1.4931078,1.5171925,1.5243102,1.519982,1.5071371,1.4955968,1.4665423,1.4280973,1.3836714,1.3373969,1.2919603,1.2189501,1.1495648,1.0878568,1.0132316,0.92835155,0.87336566,0.81365489,0.75616511,0.67994506,0.64435929,0.60900719,0.56631235,0.52440331,0.47972657,0.44083258,0.41006639,0.37328633,0.34566342,0.31208753,0.23649681,0.19259509,0.15877783,0.12733532,0.06544258,0.0081541794,-0.078790615,-0.1228998,-0.13806833,-0.15519166,-0.16330436,-0.18505438,-0.20129703,-0.20123063,-0.20435501,-0.20897507,-0.21566952,-0.22633223,-0.24496348,-0.28726347,-0.35558,-0.43152178,-0.50997609,-0.58711301,-0.6825616,-0.7644264,-0.86512844,-0.94849708,-1.0335645,-1.1164485,-1.2036694,-1.2523111,-1.3234768,-1.3979862,-1.4061604,-1.4246254,-1.4220849,-1.4223016,-1.4308835,-1.4321781,-1.4318639,-1.4310872,-1.4494369,-1.4525979,-1.4239309,-1.4046117,-1.3645422,-1.3361991,-1.3042153,-1.2503032,-1.1950139,-1.1423558,-1.0835577,-1.0145442,-0.9414009,-0.86593891,-0.77881147,-0.68617603,-0.62565044,-0.54699798,-0.49812991,-0.44178137,-0.41733623,-0.45432349,-0.49151657,-0.53123469,-0.51404787,-0.44873662,-0.38227363,-0.30109265,-0.23810555,-0.17334303,-0.086177868,-0.014444341,0.050821063,0.12275323,0.1818612,0.24223774,0.30014149,0.36440771,0.42331575,0.44430257,0.49094636,0.52423466,0.51954301,0.47180241,0.41058618,0.36266297,0.31856224,0.34418909,0.30383323,0.26856604,0.18255044,0.1028738,-0.0064029983,-0.070772379,-0.16896538,-0.24983813,-0.3333741,-0.41048983,-0.49817694,-0.59038032,-0.66289893,-0.73868459,-0.83306984,-0.91769628,-0.99541899,-1.0839913,-1.1698877,-1.2511449,-1.3350452,-1.4215426,-1.4987044,-1.5528465,-1.5297318,-1.4673077,-1.4038013,-1.3041914,-1.2008409,-1.1094816,-1.0404984,-0.98175141,-0.87559858,-0.77627192,-0.67199037,-0.56516999,-0.46129757,-0.39715286,-0.29659485,-0.1896424,-0.087493019,-0.015881665,0.07481703,0.13972522,0.24704534,0.34620166,0.41575601,0.50083359,0.54141581,0.63109556,0.69962419,0.74970074,0.8003276,0.85001487,0.90181508,0.93450769,0.97409839,1.015056,1.0660205,1.0648511,1.1281158,1.1445583,1.1951479,1.1961833,1.2039865,1.2166806,1.2077835,1.2516328,1.1681773,1.1617594,1.1958687,1.2342782,1.2689989,1.2908279,1.2715093,1.3364509,1.355351,1.4042586,1.3982318,1.4441051,1.5248716:2
0.66736154,0.58313995,0.50640234,0.43832883,0.38857053,0.34225163,0.31260835,0.26177336,0.20775357,0.15610112,0.10429163,0.037698983,-0.032995027,-0.10481275,-0.16843692,-0.25347598,-0.3088719,-0.35583879,-0.37291887,-0.32332398,-0.30139074,-0.27571521,-0.19697286,-0.12730075,-0.10282946,-0.17585924,-0.24928395,-0.30258384,-0.35341034,-0.42190508,-0.4880648,-0.56358466,-0.63763381,-0.7028339,-0.78997342,-0.89415943,-1.0017867,-1.1109219,-1.1946564,-1.2648535,-1.3094923,-1.3280556,-1.3569255,-1.3774451,-1.4019254,-1.4081063,-1.3221581,-1.2131733,-1.1026669,-0.99972518,-0.88524668,-0.81049024,-0.77390191,-0.67185179,-0.57041055,-0.49833529,-0.38571596,-0.27016682,-0.19903039,-0.098952071,0.007044604,0.094350711,0.10940218,0.057525832,0.0067073721,0.020624705,-0.0033748935,-0.054878174,-0.10012843,-0.13068849,-0.19294243,-0.23679406,-0.31537147,-0.38695488,-0.38586597,-0.36658632,-0.36169982,-0.33128659,-0.33364522,-0.26614029,-0.19885842,-0.1139936,-0.044990914,0.072877778,0.17465689,0.27910685,0.38984018,0.46755142,0.56852558,0.65145752,0.74790555,0.85838805,0.97504617,1.0352312,1.0959444,1.1764027,1.2960128,1.4056861,1.5112455,1.6234989,1.6315725,1.7505097,1.8611864,1.9759872,2.1046102,2.2110577,2.2045629,2.1535395,2.0902582,2.0058336,1.8949598,1.8282737,1.6981701,1.5888679,1.4879328,1.4049526,1.2996248,1.1867311,1.0507682,1.0394862,0.96533945,0.85419192,0.74359172,0.62654541,0.56510957,0.45909366,0.34485425,0.22900012,0.13784667,0.043977134,-0.051720931,-0.14627552,-0.27546006,-0.36456735,-0.46073918,-0.56645571,-0.60928119,-0.69144778,-0.76823302,-0.85961971,-0.94251289,-0.99947601,-1.078109,-1.105575,-1.1682082,-1.1794966,-1.2393346,-1.2637267,-1.3407074,-1.4192458,-1.431361,-1.5303356,-1.6242791,-1.7460619,-1.7288138,-1.7765774,-1.8208481,-1.724609,-1.7087415,-1.7996459,-1.7032319,-1.6225901,-1.5325025,-1.4223585,-1.3649109,-1.2854064,-1.2007058,-1.1142085,-1.0697873,-1.0604847,-1.0650272,-0.98454939,-0.89045984,-0.79002545,-0.69471074,-0.59554677,-0.49607287,-0.4089836,-0.32076126,-0.21487551,-0.11868927,-0.057355778,-0.027390676,-0.043504785,-0.057343387,-0.030336768,0.0052014787,0.094132977,0.1983618,0.28726627,0.35506388,0.37471777,0.41214928,0.45784772,0.51751971,0.60938553,0.67248476,0.74450067,0.79376902,0.88416068,0.98177669,0.9476038,0.87862681,0.7791192,0.68046881,0.56672866,0.46656963,0.3614106,0.25378956,0.1556476,0.046646721,-0.064965143,-0.19273023,-0.30158721,-0.43077653,-0.54886688,-0.65172361,-0.74916746,-0.77283303,-0.77642847,-0.73585991,-0.78148795,-0.74706454,-0.66002195,-0.57023403,-0.44737121,-0.32607987,-0.20423975,-0.11182604,-0.0399544,0.046577947,0.1291449,0.20538135,0.27259069,0.32205274,0.34816582,0.38999103,0.40066644,0.41135736,0.42650316,0.44670695,0.47144008,0.50100619,0.53439974,0.57273188,0.58669759,0.5998407,0.66135011,0.72522902,0.7833251,0.82371276,0.82594744,0.87398945,0.97160751,1.047566,1.119474,1.1955733,1.28005,1.3665522,1.4386646,1.5060298,1.5649539,1.6443883,1.6887582,1.6191603,1.4975945,1.392181,1.2737403,1.1676998,1.0503044,0.94174416,0.82042333,0.70664832,0.60437016,0.48950417,0.38890307,0.26798384,0.16737437,0.058544348,-0.013135888,-0.082405132,-0.15257487,-0.20361325,-0.25471775,-0.35639609,-0.46986535,-0.58133533,-0.67738532,-0.76583459,-0.79004377,-0.90499249,-1.011963,-1.0804538,-1.064001,-0.99314716,-0.90670793,-0.79300892,-0.68657155,-0.63273382,-0.57775753,-0.51097761,-0.40318287,-0.32290164,-0.20331181,-0.10882011,0.012013961,0.067562914,0.12527278,0.22591905,0.32816111,0.42781728,0.50947064,0.56009976,0.51429435,0.44454588,0.38976493,0.33776488,0.30599263,0.32650166,0.38119553,0.48019769,0.62602548,0.683757,0.7555459,0.8570709,0.96522263,1.0606134,1.1271404,1.1833644,1.2695776,1.3450957,1.4368129,1.5312163,1.6125892,1.6904245,1.7766806,1.8617054,1.9479926,2.0434914,2.1299829,2.1640224,2.0769922,1.9662797,1.8514566,1.7594782,1.6758745,1.5975421,1.5254902,1.4320434,1.3408317,1.2496775,1.1722796,1.0925272,1.0371816,0.97651773,0.86190697,0.74246117,0.6263839,0.52815131,0.43583592,0.33857536,0.22288755,0.10070168,0.056471651,0.090442459,0.14566885,0.20802135,0.28445812,0.2652781,0.16210747,0.028964727,-0.072003484,-0.14850622,-0.25488034,-0.29267911,-0.36517708,-0.47892592,-0.59675362,-0.73116633,-0.8503934,-0.92592626,-0.95214805,-1.0160952,-1.1065551,-1.1822762,-1.2967505,-1.3434887,-1.4527565,-1.5686096,-1.688661,-1.7923192,-1.8244875,-1.9444843,-2.062769,-2.1661157,-2.2672414,-2.3216171,-2.3606156,-2.3563397,-2.2443441,-2.1278686,-2.0201757,-1.9071132,-1.7874096,-1.6760994,-1.552613,-1.4513321,-1.3378716,-1.2190007,-1.1112129,-0.98253928,-0.86728003,-0.73574865,-0.61822217,-0.57499257,-0.48776714,-0.41292074,-0.29628472,-0.18228342,-0.057135424,0.044906585,0.15033159,0.26696068,0.37620097,0.48844575,0.61361786,0.68750936:5
0.6664029,0.60406524,0.5348652,0.46916354,0.39597218,0.34245743,0.30741991,0.3011644,0.25383004,0.19537179,0.13913691,0.080668872,0.013258787,-0.052837139,-0.076325658,-0.15909358,-0.21556184,-0.27824083,-0.34548819,-0.43585542,-0.52074746,-0.60444163,-0.68681974,-0.77235851,-0.88107932,-0.8769498,-0.98526069,-0.97970726,-1.0604613,-1.1262356,-1.1646722,-1.105483,-1.0554366,-1.0004405,-0.95734597,-0.89413024,-0.83815809,-0.76428931,-0.72497788,-0.70814125,-0.73470567,-0.80253485,-0.80696403,-0.85778773,-0.92637241,-0.98489619,-1.0859136,-1.1847102,-1.2589492,-1.3284199,-1.3262103,-1.36091,-1.3966605,-1.4568704,-1.520224,-1.5762436,-1.6468995,-1.6987162,-1.7694474,-1.8475455,-1.8989092,-1.9375804,-1.9875532,-1.9298265,-1.8539209,-1.8226171,-1.736883,-1.6531751,-1.5678462,-1.5180451,-1.4252876,-1.3461718,-1.2536333,-1.1849556,-1.1241754,-1.0311592,-0.94143377,-0.86304884,-0.78704907,-0.68631853,-0.71614406,-0.60983555,-0.52064958,-0.44814882,-0.36251244,-0.268971,-0.19727375,-0.12541932,-0.085958733,-0.036904738,0.027917454,0.061856396,0.14106456,0.21526538,0.29771821,0.3578934,0.44369834,0.53093321,0.55626131,0.61411979,0.67111817,0.71088684,0.78404585,0.83046893,0.89570461,0.95569531,1.0348415,1.1281552,1.1885654,1.2438456,1.2711181,1.3218116,1.3695705,1.4114379,1.4304074,1.4768623,1.5127109,1.5570855,1.6264797,1.6759744,1.707974,1.7709112,1.8061438,1.8797211,1.9178843,1.9261742,1.9255536,1.9071552,1.8904509,1.8751681,1.8627239,1.8519563,1.7828983,1.7790259,1.6989372,1.6298383,1.590612,1.5182399,1.443768,1.3668828,1.3241569,1.2974835,1.2593176,1.1955974,1.1703831,1.0880731,1.0250264,0.96466109,0.91278818,0.83916603,0.78236648,0.72042434,0.67117815,0.68267509,0.6454682,0.62651744,0.58222605,0.62194758,0.5687987,0.47809224,0.44029808,0.34042552,0.35319615,0.2897165,0.22896031,0.13055647,0.068525876,-0.0083652866,-0.11102054,-0.18821042,-0.23930639,-0.30730948,-0.37961658,-0.41274735,-0.47695173,-0.50666932,-0.57939484,-0.59521691,-0.68992995,-0.7211669,-0.82293036,-0.90492645,-1.0004709,-1.0879571,-1.1797802,-1.2652569,-1.3516531,-1.4416145,-1.5172507,-1.6109438,-1.6855156,-1.7570217,-1.8175863,-1.8896085,-1.9388498,-2.0182666,-2.0120775,-1.9872682,-1.9769673,-1.9198784,-1.8710958,-1.7952429,-1.7361332,-1.6605427,-1.5858716,-1.5205801,-1.4774232,-1.4106168,-1.3481853,-1.2792853,-1.2125967,-1.1322708,-1.0683996,-0.9921012,-0.92417597,-0.84860223,-0.77265234,-0.71306003,-0.6317428,-0.56138365,-0.49291407,-0.48678593,-0.49000302,-0.51936606,-0.54944213,-0.60364188,-0.65213701,-0.70933979,-0.768777,-0.81635369,-0.88035348,-0.92545498,-0.93106814,-0.94072245,-0.91304134,-0.89384486,-0.88007793,-0.7947784,-0.72733737,-0.64121772,-0.54834373,-0.47928144,-0.3958094,-0.3210218,-0.21136433,-0.11164412,-0.024776567,0.074226281,0.14046098,0.20612207,0.23773634,0.29412681,0.35026119,0.41309471,0.47849999,0.53665534,0.59700932,0.66012796,0.72079294,0.7510836,0.74496534,0.73847609,0.75401918,0.80930618,0.83247226,0.88098532,0.93938944,0.98216974,1.0211248,1.054519,1.0900249,1.1265906,1.1695561,1.211753,1.2068798,1.1615036,1.0874251,1.0078004,0.97412649,0.97020143,0.93019805,0.84053354,0.74748911,0.66414218,0.57691102,0.48719088,0.42749184,0.33341617,0.26089519,0.1728207,0.096028877,0.01437785,-0.061507038,-0.13963632,-0.21574758,-0.2929084,-0.37763636,-0.45445124,-0.53662402,-0.61375424,-0.68657394,-0.76981925,-0.84033947,-0.92304144,-0.99881476,-1.000698,-0.9513062,-0.93686319,-0.88160699,-0.86913784,-0.8110818,-0.72376849,-0.67086206,-0.58120433,-0.49791195,-0.41992274,-0.34877802,-0.27752658,-0.19118469,-0.11403696,-0.024863452,0.055336189,0.14201559,0.22312196,0.31044018,0.4036461,0.50251013,0.58627645,0.67818389,0.77217036,0.85943903,0.95926084,1.0280659,1.0921671,1.0874938,1.0461037,1.0186984,1.0001441,1.0271682,1.0871706,1.1390044,1.2060979,1.2825105,1.335961,1.3486016,1.402478,1.4424526,1.467257,1.4447848,1.4808661,1.4890692,1.458514,1.4073091,1.3534948,1.3205867,1.3222642,1.2595595,1.2016268,1.1317246,1.0620717,0.99775221,0.93442885,0.92861473,0.95929312,0.99404189,1.0374361,1.0791734,1.0981377,1.0283371,0.95242965,0.87551792,0.76920325,0.70800245,0.62419334,0.56765584,0.46750567,0.36072813,0.28199592,0.2161034,0.11767516,0.034872426,-0.069756398,-0.14411118,-0.23921409,-0.31363295,-0.40727828,-0.49790068,-0.60545684,-0.66755051,-0.74570202,-0.81681362,-0.88927581,-0.96237066,-0.92560509,-0.8571416,-0.78290911,-0.71792154,-0.65372967,-0.57897221,-0.50460628,-0.43102192,-0.35952657,-0.28593481,-0.21204819,-0.14025823,-0.069385869,0.0076314581,0.074886999,0.14232501,0.21569749,0.29297055,0.36398155,0.44106849,0.51650375,0.5824991,0.59885292,0.58906769,0.63836249,0.71046426,0.76980403,0.78721816,0.789332,0.76045815,0.74529785,0.73778158,0.71928687,0.69069626:5
1.5166701,1.4611057,1.3995448,1.3331898,1.2572578,1.1920798,1.0825264,0.9875627,0.86671091,0.79986838,0.90785748,1.0169832,1.0798268,1.0004843,0.88307685,0.78147774,0.67251235,0.5714604,0.47081191,0.3574472,0.24681567,0.15042371,0.042494949,-0.049127373,-0.14900037,-0.25312771,-0.21803362,-0.16095928,-0.15688582,-0.07547669,-0.0095489748,0.027611503,0.096524365,0.12229975,0.19437952,0.16307187,0.21169682,0.26979787,0.28106673,0.28843154,0.32905205,0.38882167,0.41245912,0.33444371,0.2728316,0.2984885,0.35661809,0.36630389,0.40111252,0.43876589,0.49700369,0.54367627,0.51302144,0.45237165,0.46720013,0.49302358,0.54237337,0.50992279,0.5308119,0.56886421,0.62129557,0.59937991,0.61821462,0.67968072,0.72780853,0.72108193,0.78074283,0.79992229,0.8600474,0.90882665,0.97130641,1.0342123,1.0073521,0.91263833,0.82478482,0.75267837,0.65277606,0.57543116,0.46809785,0.37765745,0.29225268,0.18829678,0.11605918,0.039285704,-0.042690023,-0.13406296,-0.21660375,-0.29277675,-0.37280187,-0.45610772,-0.53302298,-0.61024259,-0.69647557,-0.77831679,-0.871456,-0.94295885,-1.0252963,-1.0915007,-1.1731249,-1.2423734,-1.325504,-1.3758969,-1.421035,-1.4736337,-1.5021691,-1.5633191,-1.5798162,-1.5906094,-1.543832,-1.5467733,-1.4667609,-1.4780862,-1.4042539,-1.3076695,-1.2055913,-1.098109,-1.017838,-1.023804,-1.1107758,-1.1968652,-1.3057333,-1.407992,-1.5329407,-1.6579081,-1.7828533,-1.8948282,-1.9939436,-2.1059519,-2.1981197,-2.1561615,-2.0435477,-1.9982395,-1.9996825,-1.9583205,-1.8840005,-1.7943434,-1.7130211,-1.611985,-1.5170165,-1.4246503,-1.3287608,-1.251804,-1.1682447,-1.078136,-0.99676407,-0.91159821,-0.81827751,-0.74844531,-0.66487492,-0.58548708,-0.49429979,-0.41766063,-0.33904042,-0.25280381,-0.17721116,-0.091767098,-0.0061101492,0.058728536,0.1443961,0.19533051,0.28026228,0.36754878,0.34043724,0.28096112,0.2244509,0.20887864,0.14362474,0.095813503,0.064293256,-7.8382571E-4,-0.018891813,0.072014754,0.16337612,0.25666027,0.35728731,0.44309031,0.43620163,0.46411577,0.49236951,0.60380595,0.65731342,0.74885954,0.81607852,0.90759991,0.91785212,0.95438862,1.0351901,1.1103585,1.207757,1.2909584,1.329648,1.3062633,1.3869017,1.4633399,1.5156706,1.5889787,1.6824766,1.7842185,1.8708162,1.9696476,2.0792756,2.2022466,2.3119525,2.4069866,2.3439983,2.2516268,2.162496,2.0502243,1.9608071,1.8789713,1.7989095,1.712866,1.6604384,1.5553323,1.5035243,1.5436127,1.4407375,1.3961415,1.3146603,1.2471368,1.2490285,1.2828525,1.2291919,1.134321,1.0837605,1.0152088,0.92074294,0.8858406,0.94354112,0.90122358,0.80040381,0.7524134,0.69741163,0.64548529,0.58285843,0.53285013,0.55337438,0.60308023,0.53094218,0.46377135,0.37568278,0.34426058,0.244199,0.17245609,0.10733247,0.077135991,-0.019995195,-0.023723879,0.054728475,0.067483425,0.128427,0.20929987,0.24678098,0.33115552,0.39842485,0.48412584,0.56587232,0.49301687,0.40169315,0.37829379,0.28308291,0.21270459,0.19195543,0.15832676,0.088181717,0.040019861,0.022729838,-0.01029107,-0.081098315,-0.11827556,-0.19402093,-0.22511477,-0.31059759,-0.37788929,-0.36717764,-0.43796937,-0.4847103,-0.57391648,-0.61447381,-0.69050313,-0.7679943,-0.82977453,-0.91210616,-0.98536955,-1.0691406,-1.1695667,-1.1758412,-1.2577378,-1.3111755,-1.3888044,-1.4840869,-1.6042159,-1.6819881,-1.7847134,-1.8735946,-1.9319003,-1.9532621,-1.9959973,-2.0829978,-2.0993714,-2.0492488,-1.9692106,-1.881261,-1.7631236,-1.6517153,-1.5554367,-1.4326608,-1.4219546,-1.4548143,-1.5304619,-1.5855652,-1.6013885,-1.6123122,-1.6003115,-1.5888178,-1.5429856,-1.4921638,-1.4155752,-1.353448,-1.2967948,-1.2447887,-1.1781612,-1.0989141,-1.017072,-0.94707136,-0.86949563,-0.78452279,-0.72325445,-0.64943447,-0.56497585,-0.49378319,-0.41872836,-0.35476356,-0.28765694,-0.20436181,-0.14866616,-0.073458344,0.0013442142,0.085951514,0.14521422,0.20512222,0.28767915,0.3708312,0.45277963,0.54766933,0.58420253,0.61042215,0.65450559,0.69076939,0.66132028,0.63249694,0.63027768,0.65712939,0.62082454,0.56188956,0.58578843,0.52685724,0.56218614,0.63335316,0.58049616,0.52062728,0.51550604,0.43918426,0.44134283,0.37741348,0.41002046,0.44881735,0.52063072,0.47453062,0.44159527,0.43184158,0.38851817,0.32722857,0.3673514,0.29514758,0.25760743,0.23092293,0.25081945,0.33307954,0.28882808,0.26412738,0.23633908,0.20276611,0.12441184,0.13950889,0.073444302,0.019338759,-0.059769676,-0.036993172,-0.10114945,-0.15255345,-0.22294607,-0.24130152,-0.32084732,-0.34130785,-0.41836944,-0.50159188,-0.58322994,-0.67323781,-0.76511116,-0.83576115,-0.76099627,-0.66065982,-0.56433415,-0.46561641,-0.36488325,-0.30470237,-0.20901402,-0.11003482,7.6442759E-4,0.10149564,0.20102252,0.31251679,0.41338825,0.52600774,0.62657012,0.71270057,0.8088576,0.84344782,0.94752321,1.0243724,1.1348385,1.2353481,1.3170315,1.4111002,1.4271772,1.4788116:6
2.1352716,2.1201898,2.0663523,2.0031058,1.9656854,1.8992517,1.8523063,1.7951682,1.7520976,1.6910198,1.6474105,1.5833835,1.5482667,1.4836653,1.4443858,1.3827044,1.3413784,1.2688294,1.2375457,1.1734125,1.1328282,1.0610865,1.0256524,0.96306609,0.92334593,0.85273364,0.81989795,0.75094967,0.7128468,0.64610353,0.59968396,0.5471014,0.48048762,0.44849367,0.38870176,0.36317605,0.30786785,0.25797517,0.23419646,0.18744255,0.16351882,0.1173795,0.070072993,0.04586606,-0.0040561391,-0.057491947,-0.11223739,-0.16456127,-0.20201691,-0.23453572,-0.28225871,-0.33019094,-0.37916171,-0.42640992,-0.46538069,-0.48956964,-0.53260914,-0.57540107,-0.61482394,-0.65386102,-0.69128147,-0.72600355,-0.74661235,-0.76612876,-0.79363964,-0.81785014,-0.84355709,-0.86901531,-0.88122694,-0.89507543,-0.91138623,-0.92769675,-0.94230926,-0.96372143,-0.97386695,-1.010926,-1.0790562,-1.1454151,-1.2088478,-1.2386759,-1.2693759,-1.305647,-1.330422,-1.348862,-1.3563221,-1.3654879,-1.3646081,-1.3547378,-1.3429034,-1.3235797,-1.3012293,-1.2733471,-1.2440922,-1.2124947,-1.1808816,-1.1595344,-1.1339359,-1.098167,-1.0630292,-1.0283918,-1.0130044,-0.97492399,-0.94326867,-0.92045385,-0.87449333,-0.82545081,-0.77289007,-0.71322208,-0.65324665,-0.5921063,-0.53408437,-0.48740587,-0.51664675,-0.56410468,-0.55417582,-0.57789154,-0.63589732,-0.68785715,-0.72128035,-0.76546099,-0.81005821,-0.85914307,-0.89870124,-0.92740215,-0.97475262,-1.0010452,-1.0072487,-0.99697869,-0.97048717,-0.94860535,-0.91020614,-0.87563315,-0.82932664,-0.78607229,-0.75227422,-0.69068572,-0.64661432,-0.59591907,-0.5415057,-0.50032635,-0.43610622,-0.40411147,-0.34461815,-0.30719745,-0.24090542,-0.209589,-0.15415818,-0.11097232,-0.065570807,-0.014658022,0.018149881,0.070974798,0.11968288,0.15482462,0.19077381,0.25304942,0.28441274,0.34654932,0.38535905,0.44600549,0.48564818,0.55461579,0.62313525,0.68850594,0.68338579,0.63756065,0.5975682,0.56819741,0.60036231,0.5671461,0.5341422,0.50914438,0.52774544,0.55623951,0.597946,0.6387705,0.68809088,0.73894252,0.77889144,0.82502283,0.87729719,0.92260401,0.96302889,1.0184158,1.0654005,1.1035395,1.1697719,1.2190235,1.2742502,1.3153815,1.3718874,1.4162077,1.4731372,1.4737015,1.4701077,1.5245095,1.5852625,1.6253037,1.6928238,1.747587,1.7960994,1.8669311,1.9317981,1.9765747,1.9654251,1.9008493,1.843628,1.8157754,1.7682025,1.7063134,1.644066,1.5933537,1.5629369,1.5049214,1.4446979,1.3786392,1.3135948,1.2804993,1.2159293,1.1466956,1.0841301,1.0220991,0.97187928,0.96264421,0.96998948,0.94355597,0.90673529,0.83715981,0.80751219,0.73560068,0.69834735,0.63333085,0.601478,0.52849139,0.49126106,0.43395353,0.36725302,0.32743466,0.26876488,0.21572213,0.16753124,0.10868947,0.065609309,-0.0018089878,-0.033408234,-0.097231726,-0.16230938,-0.19628257,-0.25137229,-0.30651539,-0.33314468,-0.36823697,-0.39222753,-0.39361539,-0.38618442,-0.35328742,-0.31066196,-0.25832167,-0.22959681,-0.20563547,-0.17723677,-0.13901906,-0.16540622,-0.21497251,-0.27097726,-0.30443755,-0.36669584,-0.40305033,-0.44844555,-0.49498749,-0.5431159,-0.57563876,-0.62548193,-0.6600176,-0.71495135,-0.74799367,-0.79961606,-0.83412235,-0.87997223,-0.92139144,-0.96851692,-1.0056443,-1.0562113,-1.0900469,-1.1323996,-1.178126,-1.2206099,-1.25484,-1.3038677,-1.3425667,-1.3756405,-1.4086419,-1.449203,-1.4772014,-1.5041742,-1.5396477,-1.5566097,-1.5686006,-1.5698149,-1.5588017,-1.533897,-1.5091204,-1.4613822,-1.4145932,-1.3579133,-1.3242875,-1.2646881,-1.2207068,-1.1646563,-1.1182129,-1.0498573,-0.98236372,-0.94300196,-0.89019095,-0.89155059,-0.92323087,-0.95079698,-0.96934179,-0.99200287,-1.004027,-1.0241207,-1.0330043,-1.0460154,-1.0562744,-1.0689836,-1.07482,-1.075621,-1.0768584,-1.0770653,-1.0697987,-1.0730685,-1.0619113,-1.0605389,-1.0554755,-1.0517794,-1.0474749,-1.0263698,-1.0121697,-0.97890783,-0.95207253,-0.9003379,-0.84838438,-0.7924285,-0.78539517,-0.77660468,-0.76875414,-0.75438801,-0.73528947,-0.71714024,-0.70999941,-0.68477797,-0.6657711,-0.64071467,-0.61979356,-0.59404766,-0.56435251,-0.53671265,-0.51540534,-0.47657495,-0.45535222,-0.42810981,-0.38981161,-0.36407638,-0.34358372,-0.30169172,-0.26664309,-0.23927756,-0.20258156,-0.16343018,-0.12179415,-0.089409503,-0.055314563,-0.021786646,0.020651265,0.070363183,0.10499694,0.14382842,0.17805835,0.21977895,0.25133495,0.28512508,0.32131047,0.35594559,0.40333045,0.42806921,0.4213753,0.3536912,0.31793309,0.25251157,0.23006017,0.26937503,0.32637759,0.37751169,0.41626189,0.48241439,0.53177523,0.58947625,0.63823629,0.69033514,0.75692131,0.79458443,0.86019587,0.89660872,0.96780465,1.0063269,1.0670996,1.1049744,1.179026,1.210786,1.2747882,1.3156696,1.3832438,1.4191893,1.4849375,1.5259173,1.5914595,1.6266941,1.7001148,1.7337155,1.800691,1.8479786,1.9026482,1.957482,2.004305,2.0744254,2.1181044,2.1351551:4
0.23879579,0.14440399,0.073382703,0.023107634,-0.012247787,-0.012705906,-0.025544893,-0.041852782,-0.063316141,-0.086363568,-0.088332507,-0.10850837,-0.091333958,-0.083759028,-0.084696829,-0.052854046,-0.033705208,0.016603929,0.057280604,0.11294346,0.16704994,0.22399782,0.29547425,0.36860492,0.45873723,0.53841411,0.62871788,0.70940217,0.7946585,0.85801164,0.9296856,0.99205991,1.0198152,1.0515454,1.0866842,1.1291022,1.1766835,1.2186713,1.2787836,1.2723198,1.3025445,1.3484883,1.3815623,1.4311631,1.4652685,1.5004768,1.5170776,1.5413083,1.5633467,1.5894186,1.6079962,1.6260236,1.633103,1.6392917,1.6239864,1.6047366,1.5731931,1.5548124,1.55183,1.6054229,1.6375318,1.5785183,1.5078016,1.4424716,1.4178325,1.4372895,1.4697496,1.495588,1.527842,1.5452249,1.5514621,1.5531607,1.5419677,1.5302302,1.5077164,1.4836359,1.4533285,1.4161642,1.3838786,1.3474646,1.3117063,1.2747722,1.2484899,1.2170748,1.1949072,1.167514,1.1398749,1.1144406,1.0972271,1.0860287,1.0728032,1.0614725,1.0569935,1.0452964,1.0416045,1.04602,1.0563088,1.0727019,1.0939852,1.0655144,0.98781319,1.002705,0.93876886,0.88606687,0.82612338,0.76196898,0.70178503,0.62977536,0.56603229,0.50154376,0.4398701,0.37829095,0.29993375,0.22758336,0.15201945,0.075704659,-0.017716791,-0.1327431,-0.18028889,-0.28925254,-0.38887278,-0.46964366,-0.53867491,-0.59995064,-0.64281077,-0.686515,-0.71847931,-0.72680471,-0.73061759,-0.72276971,-0.72348487,-0.70734676,-0.70987525,-0.71048765,-0.71543632,-0.71490795,-0.70938646,-0.70257942,-0.68791382,-0.66443431,-0.6575176,-0.63671677,-0.61942877,-0.58848779,-0.54702341,-0.508581,-0.46458644,-0.4348408,-0.42455705,-0.38893246,-0.30883562,-0.24964744,-0.1887625,-0.1022868,-0.023368685,-0.067593126,-0.171806,-0.26293149,-0.37034683,-0.46495922,-0.55072897,-0.6408395,-0.71341849,-0.78507926,-0.86818215,-0.97137343,-1.0533226,-1.1529361,-1.2567974,-1.340104,-1.425901,-1.5152189,-1.6074321,-1.6920293,-1.7828866,-1.8706883,-1.9457402,-2.0111556,-2.0660208,-2.1153945,-2.1483167,-2.1611981,-2.1642774,-2.1450182,-2.1206885,-2.0921215,-2.0466818,-1.9948392,-1.9415294,-1.883418,-1.8237299,-1.754999,-1.6760836,-1.6119585,-1.540788,-1.4577784,-1.3862438,-1.3173833,-1.244183,-1.1674939,-1.086148,-1.0116617,-0.91976655,-0.8477023,-0.7611828,-0.68615184,-0.61199068,-0.57926927,-0.50149825,-0.42539623,-0.33055701,-0.25720573,-0.17433125,-0.084113933,-0.011947614,0.077807671,0.16309409,0.23335964,0.33194268,0.35530397,0.27550686,0.18979856,0.10054619,0.012980319,-0.070978126,-0.15339393,-0.23997374,-0.32924894,-0.41382338,-0.49067508,-0.58093123,-0.65862077,-0.73994399,-0.81813298,-0.8494645,-0.88063539,-0.88932607,-0.86487693,-0.82181542,-0.77237881,-0.70608252,-0.62336509,-0.55447926,-0.47262827,-0.382036,-0.28472666,-0.2032122,-0.089888824,1.8981607E-4,0.08874953,0.18062573,0.26609473,0.33619746,0.42734466,0.51048479,0.61797491,0.69829146,0.79279506,0.86880136,0.97072903,1.0563085,1.1398175,1.1633369,1.0943284,1.0301432,0.96652167,0.93481257,1.0122284,1.1276603,1.23653,1.3172284,1.4053359,1.509337,1.5985102,1.7135745,1.8168128,1.9113896,1.9944702,1.9524113,1.8687228,1.8239631,1.7375344,1.6619613,1.5789407,1.4918583,1.4026354,1.3356762,1.2782514,1.1903432,1.1168724,1.0370907,0.97336624,0.89919548,0.84686649,0.86171051,0.93191607,1.0458134,1.1255754,1.0964328,1.0128419,0.92459873,0.8420915,0.77124298,0.70217778,0.61586719,0.53070432,0.46316382,0.37750061,0.31154682,0.227762,0.14303933,0.056493965,-0.022772108,-0.099098741,-0.1755699,-0.2484897,-0.31781866,-0.38511181,-0.44667789,-0.49827035,-0.54158459,-0.56985313,-0.57148934,-0.5367648,-0.47754763,-0.40982611,-0.34140937,-0.26169828,-0.18195819,-0.11036318,-0.019681491,0.069528152,0.15723072,0.23337128,0.31408231,0.40763182,0.46115464,0.38312746,0.28237456,0.18298682,0.087044525,-0.025513235,-0.13921705,-0.21965323,-0.33175689,-0.43866802,-0.49999199,-0.47165513,-0.45928212,-0.56240169,-0.66624419,-0.76606136,-0.8609434,-0.92747777,-0.99775617,-1.0968648,-1.1839986,-1.2420558,-1.3150569,-1.3652091,-1.3986857,-1.4303705,-1.4580243,-1.463878,-1.4486679,-1.4308963,-1.3873583,-1.3206438,-1.2250184,-1.1467763,-1.0560858,-0.96720631,-0.87521628,-0.78618261,-0.7067779,-0.62119938,-0.52848848,-0.45396759,-0.36885351,-0.29987462,-0.20896404,-0.25710598,-0.33087955,-0.40482584,-0.47677115,-0.54474137,-0.61060805,-0.67566447,-0.74202792,-0.78006163,-0.79709261,-0.78647767,-0.83823342,-0.89558656,-0.95137374,-0.99651527,-1.0399559,-1.0743212,-1.110793,-1.1316561,-1.1526278,-1.1806114,-1.2016655,-1.2091587,-1.1943066,-1.1883752,-1.1470179,-1.1005454,-1.0605396,-0.99866322,-0.9382931,-0.86526222,-0.79269015,-0.71451493,-0.62359204,-0.50990202,-0.40576294,-0.32589338,-0.23066572,-0.12497971,-0.038998123,0.041780941,0.12053688,0.10653834,0.052707662,0.11171391,0.22813961:4
0.70428161,0.69355644,0.66229834,0.63490708,0.58472962,0.54994105,0.50447035,0.46059019,0.41236617,0.35860152,0.31336385,0.26944017,0.23162831,0.19270841,0.14273205,0.086809571,0.0094084964,-0.068596614,-0.13937944,-0.20529513,-0.28866327,-0.39289636,-0.46033603,-0.56140715,-0.6066674,-0.68073901,-0.77268801,-0.85880991,-0.93806834,-1.0400383,-1.145254,-1.2505456,-1.3570868,-1.4684024,-1.5745692,-1.6537143,-1.7415034,-1.8041433,-1.8498469,-1.9255031,-1.9676369,-1.9201825,-1.838478,-1.7335362,-1.6577598,-1.5572945,-1.4736174,-1.3773695,-1.2797595,-1.1847132,-1.0985963,-0.99600731,-0.90457812,-0.80994051,-0.71377296,-0.62224598,-0.52040199,-0.42092782,-0.31232623,-0.23066666,-0.15976739,-0.11925995,-0.091690099,-0.073661772,-0.05380407,-0.043513382,-0.038729047,-0.036555422,-0.047200011,-0.071574379,-0.087613661,-0.095316448,-0.10101637,-0.089539475,-0.090691993,-0.09163347,-0.093108569,-0.090513219,-0.098485348,-0.11039829,-0.11756374,-0.14605793,-0.17634309,-0.20804496,-0.23734936,-0.27459132,-0.30974255,-0.33793856,-0.36979842,-0.39798414,-0.42302599,-0.45638664,-0.45648973,-0.38048475,-0.28095625,-0.1518081,-0.043713621,0.059806557,0.14062818,0.20048594,0.25743495,0.29728695,0.33028529,0.361494,0.39046446,0.43343602,0.48552411,0.53083533,0.5868038,0.64135406,0.69840825,0.7490189,0.80131645,0.82475236,0.85443538,0.86666236,0.87326132,0.89703596,0.92640283,0.95650381,0.98912489,1.0123483,1.0385876,1.1061268,1.2068629,1.2916116,1.3922469,1.4881161,1.5865638,1.6892402,1.7865201,1.8786303,1.9786646,1.9746395,1.88627,1.9211556,1.9981625,2.0752415,2.1255595,2.1938288,2.2162613,2.2819706,2.2935935,2.2964832,2.2320533,2.1437422,2.0389873,1.9414551,1.8461843,1.7547851,1.6501295,1.6062069,1.5535163,1.5110779,1.4496029,1.356356,1.2559947,1.1554849,1.0600899,0.96189812,0.94718461,0.92091537,0.92929271,0.91388273,0.87414984,0.83344904,0.7935319,0.74939862,0.67791338,0.59863041,0.51079824,0.43459472,0.35664356,0.27186459,0.19192699,0.11856381,0.038638471,-0.042443462,-0.11711781,-0.19428278,-0.27263936,-0.36616697,-0.45963657,-0.53654311,-0.54652037,-0.56865115,-0.62355768,-0.67805652,-0.73227661,-0.75145494,-0.77987446,-0.76932743,-0.83268939,-0.88393177,-0.97724079,-1.0552207,-1.1278548,-1.1942597,-1.2535721,-1.3308423,-1.3982738,-1.4408737,-1.4448447,-1.4311769,-1.4212143,-1.3931034,-1.3553675,-1.302347,-1.2609735,-1.2065883,-1.1501196,-1.1168136,-1.0696489,-1.0146217,-0.96267342,-0.91674434,-0.86632265,-0.81423128,-0.76144905,-0.70526118,-0.63855505,-0.58363413,-0.52231598,-0.46291833,-0.39707876,-0.33940238,-0.2766993,-0.21889915,-0.13511905,-0.076646678,-0.030886391,0.037611987,0.095593872,0.13449262,0.18982684,0.2605229,0.29443811,0.31396146,0.32751734,0.33139165,0.29624408,0.2412574,0.16717237,0.103439,0.094348284,0.10181868,0.11739473,0.11672073,0.16782648,0.21096765,0.24902957,0.26053587,0.26563719,0.25185206,0.23515416,0.19189278,0.11083938,0.022783743,-0.079682192,-0.17031528,-0.27922049,-0.39883652,-0.48792122,-0.59401078,-0.68107649,-0.77515381,-0.87757839,-0.96496895,-1.0679679,-1.167916,-1.2800605,-1.38724,-1.4806333,-1.5869851,-1.6974141,-1.7877803,-1.8943445,-1.9918816,-2.1053809,-2.1323053,-2.0336325,-1.9204683,-1.8321348,-1.7062962,-1.6280655,-1.5660912,-1.4417487,-1.3460425,-1.2172967,-1.0998641,-1.0260599,-0.89992657,-0.8037492,-0.70501286,-0.58163614,-0.49175944,-0.4046005,-0.31770851,-0.22346469,-0.13130402,-0.051738496,0.037687879,0.11827348,0.20053001,0.27745,0.3620427,0.44603357,0.52531625,0.59883232,0.68025199,0.74010739,0.79932884,0.85674791,0.91746233,0.96686284,1.0092456,1.0631071,1.1030338,1.1293696,1.1038507,1.0596016,1.0093475,0.93836728,0.87941726,0.7958151,0.72897351,0.64120198,0.56433326,0.47902209,0.40287759,0.31241481,0.22461302,0.13812054,0.061459416,0.093034298,0.17575122,0.27064755,0.36731104,0.45546262,0.54313828,0.6175959,0.7033257,0.78578592,0.86209018,0.94248059,1.0167029,1.0915378,1.1726382,1.2334787,1.3206625,1.3981437,1.4490141,1.5094229,1.5436752,1.559444,1.5710676,1.5700582,1.5688699,1.555677,1.5355224,1.5002657,1.4707483,1.4263322,1.3747794,1.2926319,1.2294146,1.1552916,1.071701,0.98464881,0.88970008,0.81735894,0.73166778,0.64843827,0.56128022,0.46628167,0.38611988,0.28869819,0.1976068,0.11300429,0.025076129,-0.062104522,-0.16186837,-0.25370123,-0.34091592,-0.4287261,-0.53703465,-0.62822457,-0.72986172,-0.81329499,-0.91764439,-1.0126116,-1.1178379,-1.2008518,-1.3165064,-1.4196507,-1.5154766,-1.6295956,-1.7156122,-1.7288943,-1.6827732,-1.5966312,-1.5070709,-1.3821055,-1.2843942,-1.1569365,-1.0591531,-0.92860441,-0.83188113,-0.73607958,-0.60218352,-0.46975676,-0.37062946,-0.24470301,-0.15289641,-0.074800232,0.02191285,0.12191616,0.20930436,0.29096385,0.37938275,0.45646782,0.52301281,0.58685682,0.632316,0.68638742,0.69914488,0.71872516:2
0.39747575,0.29625411,0.2259373,0.13468689,0.17132395,0.048469242,-0.029331487,-0.067520437,-0.072381088,-0.12277304,-0.20316044,-0.27284608,-0.32479998,-0.33511789,-0.45182393,-0.50906376,-0.49656755,-0.54213067,-0.54063073,-0.57664305,-0.60656411,-0.68196418,-0.73664596,-0.78352241,-0.78889284,-0.80082486,-0.80044376,-0.80499323,-0.75727029,-0.78848221,-0.68332472,-0.5546433,-0.42530988,-0.29769948,-0.19738473,-0.074729699,0.054379578,0.18545569,0.29414507,0.40638632,0.48259133,0.43504906,0.3394028,0.23500004,0.14061667,-0.0052639846,-0.11434626,-0.2381643,-0.36930535,-0.48740621,-0.53302428,-0.56332644,-0.50796164,-0.50342257,-0.46816452,-0.45043758,-0.40117971,-0.40797316,-0.36573173,-0.34625281,-0.29753452,-0.23952405,-0.14146291,-0.11373419,-0.09235056,-0.021606779,0.014919849,0.029402454,0.096444264,0.17609508,0.28718843,0.32420984,0.34829919,0.39602411,0.46539296,0.53575278,0.64203568,0.70545082,0.75932548,0.72214395,0.74235349,0.80104196,0.86450069,0.92202285,0.96263388,0.98606036,1.0100133,0.93202861,0.94088316,0.98298694,1.0094759,1.0563211,1.1044573,1.0967136,1.0015184,0.88945851,0.78436778,0.68789878,0.55517865,0.4376427,0.33583932,0.20721524,0.14353084,0.092643949,0.068048663,0.10479708,0.13648281,0.18940016,0.2594464,0.32196601,0.34247998,0.39963214,0.44354517,0.44647559,0.41611056,0.47724336,0.55437842,0.60246577,0.64188765,0.65407616,0.72544223,0.75754232,0.80076438,0.84894309,0.80931238,0.69789533,0.57120922,0.45975379,0.39429705,0.35163631,0.40229252,0.48113117,0.54131147,0.56785351,0.65324292,0.67738362,0.77985096,0.87695521,0.95759588,0.98746797,0.9559631,0.92535369,1.0364354,1.1386757,1.2256642,1.2936753,1.3703488,1.4574315,1.5363746,1.6051118,1.6594047,1.7301009,1.7482091,1.7275274,1.6089303,1.4833837,1.3811616,1.2608853,1.1395854,1.0270817,0.92153176,0.81315473,0.70138325,0.69007645,0.58071679,0.46233738,0.34823994,0.22052654,0.11551859,0.01114187,-0.10951808,-0.23336986,-0.33695578,-0.45715233,-0.45118115,-0.4644703,-0.53387374,-0.65927019,-0.7685869,-0.88214038,-0.99682096,-1.1111875,-1.2248038,-1.340691,-1.4473205,-1.5482434,-1.6808695,-1.7852112,-1.8923704,-1.9975839,-2.1255104,-2.2383466,-2.3492537,-2.4631874,-2.5730874,-2.6866726,-2.7032724,-2.667463,-2.6438809,-2.5987152,-2.541262,-2.4833381,-2.3988071,-2.2916395,-2.2116698,-2.0808705,-1.9565977,-1.911208,-1.7877233,-1.7032806,-1.656908,-1.734572,-1.8197008,-1.7972647,-1.7174212,-1.6471735,-1.5160415,-1.4373598,-1.3102115,-1.1590667,-1.0531421,-0.98005233,-1.012271,-0.94907103,-0.88656389,-0.79820769,-0.75932664,-0.70358905,-0.64556593,-0.62219509,-0.5503797,-0.56885797,-0.65992094,-0.74026819,-0.81429654,-0.84561933,-0.73101807,-0.6274837,-0.52488457,-0.41274167,-0.32150256,-0.22377506,-0.13513454,-0.037490877,0.087675418,0.19822587,0.29083213,0.34154112,0.44954028,0.56161588,0.64465503,0.75298112,0.85611719,0.95729676,1.05311,1.1265065,1.1632522,1.0240372,0.8640011,0.73738203,0.65214761,0.52329351,0.45531737,0.39712088,0.27285732,0.19362108,0.18084207,0.1070025,-0.020314003,-0.1346283,-0.27787888,-0.41092029,-0.5060834,-0.59772371,-0.63481821,-0.58652051,-0.50676777,-0.39432946,-0.30024424,-0.32299972,-0.3967754,-0.5166853,-0.58139825,-0.69150152,-0.77138264,-0.87266601,-0.97992055,-1.0991913,-1.1956524,-1.1330626,-1.1668186,-1.2227398,-1.3142334,-1.4221598,-1.4919578,-1.5742994,-1.6722464,-1.7655741,-1.8463933,-1.9128435,-1.9671785,-2.014814,-1.9814356,-1.8902052,-1.77802,-1.6697328,-1.5499836,-1.4228074,-1.2961021,-1.1673879,-1.0473536,-0.98734095,-0.87210747,-0.7419278,-0.61714963,-0.5085815,-0.38425552,-0.22434175,-0.069439535,0.012112213,-0.015626871,0.034260607,0.15749449,0.30541848,0.404549,0.48640589,0.62764695,0.75504692,0.8905865,1.0406968,1.1798926,1.2354308,1.3298826,1.4669069,1.5886311,1.6676971,1.8097815,1.9399764,2.0478582,2.0883543,2.0270586,1.9325198,1.8465924,1.7298454,1.6738378,1.65216,1.553496,1.4567009,1.430961,1.3526544,1.2560553,1.1554238,1.0772458,1.0981618,1.1702583,1.1477335,1.0740705,1.001898,0.93010519,0.85358931,0.7517258,0.71062029,0.64748219,0.57631826,0.51013164,0.43854943,0.47010926,0.57378769,0.68366835,0.78776951,0.85641101,0.83912095,0.80770511,0.74108433,0.69740724,0.64169903,0.56660342,0.49161239,0.45912305,0.4146562,0.32801829,0.27613241,0.22821503,0.18853157,0.14941692,0.14373279,0.23677358,0.30401832,0.28294674,0.2292867,0.16926052,0.11115251,0.043718084,-0.020243972,-0.074460227,-0.089101485,-0.11809121,-0.13622855,-0.17038953,-0.178663,-0.21149359,-0.099738511,0.023197371,0.14521796,0.25580347,0.36328991,0.49363602,0.616307,0.73824512,0.85654429,0.88312477,0.81594358,0.76208702,0.72882036,0.66271596,0.59782298,0.56568953,0.6634261,0.63136044,0.56074254,0.48276074,0.43981794,0.3637766,0.28496352,0.3253406,0.428563,0.45822767:3
2.2723296,2.1752048,2.0595655,1.9429434,1.8265282,1.7113326,1.5815077,1.4665209,1.3754673,1.2617452,1.1579888,1.0647511,0.97578502,0.88255815,0.76239069,0.64585364,0.54996637,0.45805584,0.39060467,0.36406124,0.31986485,0.20267415,0.11880698,0.022049759,0.023921785,0.048254374,-0.061598438,-0.12232711,-0.22095786,-0.32562033,-0.42174663,-0.51385768,-0.61404743,-0.71524874,-0.80873619,-0.89947464,-0.99279692,-1.0937202,-1.1944196,-1.2139706,-1.1337206,-1.0422087,-0.95241934,-0.85803984,-0.75936936,-0.68909801,-0.59059482,-0.56603001,-0.52382757,-0.41982598,-0.36937963,-0.30599476,-0.25628167,-0.17078954,-0.12617765,-0.089181292,-0.12577894,-0.22495963,-0.31057777,-0.39869852,-0.48020346,-0.58463446,-0.66106312,-0.74380587,-0.8316111,-0.88953218,-0.98396474,-1.0132483,-0.93166103,-0.84191992,-0.74324189,-0.65165116,-0.57184048,-0.49647767,-0.45328262,-0.37111433,-0.25631332,-0.17903405,-0.083893881,0.020801143,0.08400789,0.14121425,0.25149185,0.35308056,0.46753768,0.50467116,0.56290582,0.66621338,0.76830101,0.79743552,0.89584556,0.99473198,1.0401145,1.1325495,1.2210262,1.2370119,1.1437673,1.0425219,0.92631941,0.86448794,0.75299967,0.71005407,0.58260431,0.51639687,0.44710425,0.35959776,0.34277738,0.28563061,0.21235366,0.11945634,0.11654052,0.076277357,0.011211856,-0.042444096,-0.083686997,-0.13926908,-0.12825385,-0.13871131,-0.21193461,-0.25677599,-0.32691357,-0.3616706,-0.44084403,-0.48526211,-0.57310698,-0.60598106,-0.49871647,-0.41011551,-0.33874607,-0.2822147,-0.2819623,-0.29774857,-0.33224528,-0.40858501,-0.40071593,-0.46693924,-0.4418744,-0.365115,-0.24770601,-0.16889068,-0.068650988,0.0421642,0.14276568,0.25242322,0.35075729,0.4554547,0.55592596,0.65983121,0.76066975,0.86152017,0.97153406,1.0747625,1.1751671,1.2717223,1.369015,1.4757037,1.5650351,1.6514497,1.7251908,1.7467051,1.776822,1.7861225,1.8297806,1.9047768,1.9549644,2.0362359,1.9823707,1.8984108,1.8099753,1.735906,1.6428852,1.5560949,1.5343536,1.4652303,1.4222132,1.307409,1.2115216,1.1044843,1.0028638,0.89844952,0.78905329,0.68653669,0.58471432,0.49878943,0.41878363,0.3079327,0.20109162,0.10033476,4.7650326E-4,-0.1000662,-0.19987517,-0.30002729,-0.39962914,-0.46940916,-0.56211978,-0.66042167,-0.75677805,-0.85514376,-0.9523479,-1.0490772,-1.1311222,-1.1252407,-1.2395836,-1.3484126,-1.42563,-1.3477813,-1.2318814,-1.1149958,-1.0166749,-0.91823522,-0.84463021,-0.75877816,-0.69178406,-0.61043188,-0.54528161,-0.50532219,-0.49187607,-0.4436396,-0.41062746,-0.34242562,-0.257442,-0.22616038,-0.15695468,-0.16773924,-0.094634394,-0.015569463,-0.019291239,0.073456088,0.1065182,0.18993946,0.15449818,0.065512652,0.05161901,-0.048381294,-0.06724646,-0.12236462,-0.21963351,-0.17747009,-0.11211441,-0.061150859,0.018696084,0.063862032,0.14957976,0.098025548,0.073739544,-0.0034060528,0.10238753,0.14500578,0.20882924,0.26825339,0.19755251,0.21609557,0.29058139,0.36224448,0.45429517,0.40234107,0.42789914,0.49215229,0.57152759,0.57082599,0.62356025,0.71186673,0.76683299,0.81262248,0.92396713,0.9549735,1.0827519,1.1581165,1.247429,1.2019853,1.0923285,0.99444765,0.89934206,0.82100975,0.70092056,0.62787643,0.57150257,0.45697313,0.34294917,0.33119604,0.23967872,0.17102875,0.058260682,-0.036851034,-0.10069533,-0.13343706,-0.18123242,-0.28866119,-0.35308655,-0.46084143,-0.53359631,-0.60628719,-0.71757425,-0.79007432,-0.90053689,-0.98340254,-1.0527824,-1.1377782,-1.234643,-1.3177555,-1.4108055,-1.4840443,-1.5550469,-1.6344957,-1.7121162,-1.7995316,-1.8874387,-1.9216544,-2.010817,-2.0907721,-2.1565112,-2.1912315,-2.1900152,-2.1352556,-2.0577235,-2.135928,-2.2652395,-2.3101658,-2.4047218,-2.4948618,-2.5083642,-2.4115334,-2.2942993,-2.2941507,-2.2468087,-2.2359851,-2.1951669,-2.1135582,-2.0107565,-1.8980355,-1.8066328,-1.7419303,-1.6392563,-1.5454351,-1.4918613,-1.3813265,-1.265457,-1.1865528,-1.0764927,-0.98099107,-0.89005833,-0.81737664,-0.79336262,-0.70043423,-0.60575696,-0.55034307,-0.45411871,-0.36242258,-0.35946222,-0.35018686,-0.2545835,-0.15961492,-0.10195105,-0.040409167,0.054523677,0.085005982,0.17608901,0.2436283,0.32765859,0.30246353,0.21423785,0.19005847,0.099020019,0.0056942036,0.015512175,-0.075758851,-0.15023934,-0.2255038,-0.24717215,-0.28882216,-0.37752465,-0.46290991,-0.54704329,-0.62947504,-0.70755807,-0.63679462,-0.53435338,-0.47559227,-0.42226087,-0.3273361,-0.29609393,-0.2014508,-0.10805233,-0.074693224,-0.010944963,0.081168137,0.15235918,0.19785949,0.28992789,0.3600684,0.41922977,0.39115891,0.33900147,0.32257295,0.32825157,0.39975715,0.48073045,0.53282239,0.6277118,0.69492861,0.64436736,0.67474162,0.72630139,0.81188015,0.88678136,0.93191348,0.91091598,0.9592645,1.0348823,1.1139166,1.2086469,1.2065454,1.2534026,1.3319432,1.4152847,1.4306181,1.4239259,1.5233672,1.6453798,1.667608,1.7844012,1.8139018,1.9151426,2.0016983,2.0845034,2.1526128,2.2271269:6
2.4820629,2.4763274,2.3686296,2.2521199,2.1299967,2.0213009,1.9106206,1.8058611,1.689653,1.5884788,1.4820321,1.373877,1.2592206,1.1628819,1.0573794,0.93078802,0.81954755,0.73830944,0.69623022,0.64388925,0.57465151,0.47045469,0.37263133,0.2439544,0.14930367,0.045793047,-0.071409789,-0.17654833,-0.27550042,-0.39030994,-0.50661069,-0.61445558,-0.71862176,-0.81923827,-0.91116914,-0.99959329,-1.1240143,-1.1008858,-1.0585098,-0.99072653,-0.93914221,-0.8389046,-0.74203731,-0.68281579,-0.58242165,-0.53857221,-0.48472334,-0.41247368,-0.31288625,-0.3012774,-0.23655527,-0.24852212,-0.28059457,-0.22176294,-0.18330117,-0.15907462,-0.11407866,-0.042127722,-0.08262453,-0.024224642,-0.053854536,0.0069408844,0.10034023,0.13204427,0.093774567,0.0043067671,-0.086674427,-0.16202677,-0.25740132,-0.36146997,-0.46893357,-0.56581334,-0.62241634,-0.67076282,-0.62658123,-0.57015484,-0.50409034,-0.44223148,-0.35014104,-0.29436067,-0.2047444,-0.14526669,-0.089740979,-0.021732081,0.033149419,0.11771496,0.19090773,0.2674057,0.3341481,0.33228637,0.29222818,0.22602693,0.22196502,0.24767281,0.31241796,0.38040247,0.43196796,0.46085015,0.47618823,0.49881916,0.58512828,0.71075205,0.73964072,0.8261032,0.92913578,1.0209283,1.1143241,1.2053591,1.2481085,1.1757279,1.0718573,0.96242347,0.84339245,0.72619293,0.60935724,0.53247865,0.40681088,0.30390995,0.17866032,0.074644128,-0.03391467,-0.14160992,-0.26513915,-0.32825617,-0.42849088,-0.51208055,-0.60482553,-0.71643029,-0.81649996,-0.94240072,-1.0360095,-1.1541495,-1.2653133,-1.3716703,-1.481162,-1.5938393,-1.7083633,-1.8233284,-1.9214432,-2.0276733,-2.0855872,-2.0267505,-2.1258099,-2.1013293,-2.1045154,-2.0748479,-2.0282444,-1.9904972,-1.9000703,-1.8276811,-1.8100172,-1.7205167,-1.6067449,-1.482053,-1.3336849,-1.179987,-1.0320526,-0.91523364,-0.76662253,-0.64943701,-0.53220984,-0.41696235,-0.31390155,-0.21929026,-0.12533712,-0.023449241,0.072039233,0.15292948,0.23167131,0.22778166,0.17155542,0.12889296,0.15198426,0.18958718,0.2693847,0.3258779,0.43014765,0.5169349,0.59123325,0.66752775,0.75848918,0.85287674,0.95186597,1.0267883,1.1126132,1.1957498,1.2867535,1.358353,1.429055,1.5006101,1.5927472,1.6804886,1.7090007,1.6875872,1.7819132,1.8664835,1.9487353,2.0380053,2.1061185,2.0948273,1.997711,1.8810788,1.7454587,1.6113228,1.4922888,1.4033407,1.3172067,1.2369051,1.1024019,0.99125173,0.8681983,0.7644425,0.63876861,0.5393894,0.54641281,0.50499763,0.5070676,0.55388343,0.57627053,0.63204636,0.59246899,0.48970369,0.38296842,0.27688479,0.1673724,0.06165943,-0.040951467,-0.13950381,-0.2485511,-0.36267516,-0.45891662,-0.56754537,-0.61863543,-0.68561812,-0.76431446,-0.88034782,-0.98248121,-1.0360643,-1.1534698,-1.1550539,-1.2209655,-1.3251119,-1.4411445,-1.5388764,-1.6120576,-1.4901936,-1.4947592,-1.5377545,-1.4468032,-1.35093,-1.4096123,-1.3407332,-1.2288933,-1.211896,-1.2987438,-1.1802779,-1.0874279,-1.0273668,-0.90706107,-0.79428131,-0.66800186,-0.53675807,-0.45741437,-0.34568961,-0.2654595,-0.20422974,-0.10951102,-0.0055402483,0.10491275,0.23155308,0.3676938,0.50621498,0.60089196,0.69995896,0.8011039,0.90442133,1.0329576,1.1511058,1.239889,1.387615,1.4954059,1.5343105,1.4510548,1.3440324,1.2365502,1.150309,1.0769836,1.0356424,0.98203856,0.89741594,0.81566596,0.79172005,0.77294152,0.70038675,0.62063265,0.53663592,0.45514837,0.38114199,0.31982791,0.25350077,0.20277487,0.12407019,0.13478976,0.095186569,0.036737701,-0.018745317,-0.053424269,-0.018507666,-0.0717124,-0.024251011,-0.087777026,0.034316797,0.11488021,0.19634254,0.25465455,0.22280449,0.14248071,0.11866456,0.079451417,0.026007681,-0.035609979,-0.10919656,-0.1823315,-0.25783493,-0.29779342,-0.3685479,-0.3870518,-0.46549358,-0.43357404,-0.50158656,-0.53652334,-0.6067415,-0.68906237,-0.81054522,-0.89107986,-1.0052988,-1.032186,-1.0731773,-1.0735506,-1.0904093,-1.0861128,-1.0273105,-0.94868187,-0.87046334,-0.7589243,-0.64945003,-0.54265107,-0.41776732,-0.29062969,-0.17178384,-0.057343748,0.0088920823,-0.077975627,-0.10619246,-0.17715659,-0.20133339,-0.25979483,-0.32327194,-0.37322883,-0.36773706,-0.34624147,-0.4125886,-0.38519534,-0.41686123,-0.43378995,-0.47740436,-0.52341762,-0.59545802,-0.60303097,-0.65545695,-0.6310673,-0.69309291,-0.79106794,-0.80038487,-0.89468053,-0.951879,-1.0030022,-1.0894539,-1.1413946,-1.1618564,-1.2126108,-1.2782762,-1.300816,-1.3576934,-1.3978163,-1.4794697,-1.3854009,-1.2981401,-1.2050318,-1.2104074,-1.1132699,-1.0142457,-0.90419586,-0.80504769,-0.69709292,-0.58067713,-0.50879144,-0.42174673,-0.33216666,-0.29581588,-0.18808686,-0.080288521,0.023369529,0.12618489,0.2335601,0.33887772,0.445626,0.55546814,0.66115434,0.76863943,0.87369895,0.98223604,1.0883537,1.2037938,1.3122273,1.410896,1.5137022,1.6279888,1.7313877,1.8174109,1.8707272,1.9701603,2.0853058,2.1876893,2.313318,2.3674591,2.4438495:5
1.2177449,1.0923935,0.92361669,0.78751157,0.72081679,0.64076863,0.58856285,0.65031597,0.70350014,0.67494258,0.61615139,0.5521071,0.46511801,0.44884642,0.29143569,0.27583063,0.16808648,0.2513711,0.32691417,0.33322587,0.28241168,0.1978366,0.059613605,0.010916947,-0.13462094,-0.24799539,-0.33908356,-0.5021995,-0.56454804,-0.62874644,-0.77505845,-0.92027518,-1.0591341,-1.1651539,-1.2795385,-1.3624778,-1.4489115,-1.3209446,-1.1560892,-1.0197196,-0.85488391,-0.7215158,-0.56652183,-0.42941332,-0.27796248,-0.13053803,0.025917298,0.17807639,0.34079264,0.41265237,0.47694902,0.54543249,0.7082983,0.88086483,0.9982002,0.85210053,0.83968428,1.0151044,1.1963766,1.345836,1.5195296,1.5862482,1.7380958,1.7206689,1.6358515,1.4904867,1.302138,1.1780854,1.0974649,1.0381408,0.95743023,0.86251839,0.98515494,0.87851413,0.76238468,0.84435433,0.80801347,0.7571475,0.68857478,0.60422757,0.48570188,0.41609674,0.39199237,0.34584658,0.22582327,0.13623627,0.036034739,-0.032620639,-0.11164013,-0.20600264,-0.317482,-0.4172262,-0.46999352,-0.61765453,-0.65548547,-0.54189004,-0.44495657,-0.3338032,-0.20563103,-0.053420378,0.069874724,0.088397992,0.17682027,0.17104533,0.15181876,0.11647523,0.04483083,-0.03285814,-0.062267389,-0.12296523,-0.041223548,0.0023466763,-0.013321209,-0.057075023,-0.052700141,-0.13515406,0.018379624,0.1005245,0.052486911,-0.14709224,-0.1838901,-0.18254995,-0.18796631,-0.27525219,-0.33636961,-0.41392161,-0.5011961,-0.56572084,-0.69129607,-0.59854548,-0.49434689,-0.4425122,-0.39283368,-0.37950887,-0.30935333,-0.24955439,-0.29318444,-0.25639482,-0.3285357,-0.33246099,-0.3249215,-0.37285541,-0.41584744,-0.43523933,-0.50952976,-0.65767536,-0.67885609,-0.82482305,-0.83474375,-0.77788319,-0.74429948,-0.8434901,-0.88230689,-0.97435449,-1.1170863,-1.2290718,-1.3635956,-1.4059126,-1.3565348,-1.1888517,-1.0689366,-0.90625912,-0.74624115,-0.55689791,-0.41381799,-0.2264691,-0.083639059,0.11143272,0.26023484,0.46041621,0.64846142,0.76711239,0.97415453,1.1291418,1.2773399,1.4530619,1.6463287,1.8342488,1.961088,2.0554262,2.1032997,2.1396962,2.0094271,1.9221421,1.8002192,1.6227184,1.4709668,1.2681616,1.1064918,0.91130277,0.76855862,0.58399014,0.41551124,0.23912561,0.084559195,-0.10155155,-0.2626506,-0.43564728,-0.60500777,-0.77839007,-0.93861736,-1.0900995,-1.2692884,-1.4314001,-1.5911267,-1.7405861,-1.9170329,-2.0920274,-2.2055679,-2.3203788,-2.3411533,-2.5008627,-2.6456331,-2.799948,-2.8397527,-2.9643242,-2.9891636,-3.156681,-3.3016489,-3.4166405,-3.4267761,-3.2660307,-3.207848,-3.1219708,-2.9612911,-2.7301895,-2.5514136,-2.4224854,-2.1982909,-2.0158875,-1.7830479,-1.5562231,-1.3948639,-1.2076359,-1.0873981,-0.90027042,-0.81252627,-0.69431497,-0.58661215,-0.48152387,-0.36813685,-0.22123807,-0.25050771,-0.175628,-0.12013222,-0.084587858,-0.08596961,-0.029972867,0.031410532,0.11658167,0.091798136,-0.0036366419,-0.088432844,0.018040159,0.036730374,-0.16162963,-0.086164347,-0.070368203,0.015171124,0.017557938,0.047549687,0.041615471,0.14401424,0.18178512,0.20887923,0.28462587,0.15515816,0.25075788,0.30868903,0.42776325,0.56542486,0.68141371,0.57217487,0.57704605,0.57111569,0.73597596,0.66097816,0.47231483,0.32255022,0.23815491,0.041983592,-0.10968267,-0.295906,-0.44804346,-0.38212307,-0.3052708,-0.23143173,-0.16326749,-0.1619617,-0.10286637,-0.017634696,-0.030062282,-0.095142905,-0.038079424,0.0040849786,0.065645362,0.12166828,0.16243842,0.23411276,0.297298,0.35040244,0.44926837,0.51224273,0.63500298,0.73917133,0.82945384,0.94784008,1.1090732,1.1344551,0.94288183,0.79807159,0.60907133,0.46403611,0.46323414,0.38427718,0.22448318,0.08254984,-0.062754727,-0.11620721,-0.23945685,-0.24902205,-0.34602074,-0.43655655,-0.45280569,-0.33666024,-0.29275453,-0.25558025,-0.15178299,-0.044302795,0.062692058,0.16725809,0.2602536,0.36035028,0.44671461,0.51557209,0.64074551,0.73189313,0.84134043,0.92771682,1.0453458,1.0749868,1.027584,1.1166487,1.1444403,1.228685,1.3453859,1.397805,1.512991,1.6289947,1.724468,1.8034194,1.784777,1.6915272,1.6540864,1.5083925,1.3231756,1.1396716,0.98866134,0.91911526,0.80684968,0.67988671,0.50717035,0.33759136,0.20453362,0.067995499,0.055085637,-0.050412939,-0.0739357,-0.085344353,-0.1265379,-0.12807942,-0.24563491,-0.15356197,-0.064613524,0.037082479,0.19627669,0.24243754,0.38959669,0.46472173,0.42191263,0.3714709,0.44626822,0.51050991,0.6806953,0.85719581,1.0310133,1.1019639,1.034611,0.89855747,0.73233554,0.67048928,0.72538225,0.63479128,0.47042722,0.38114902,0.34071245,0.23170763,0.26789022,0.18718104,0.058811921,-0.10238245,-0.2066448,-0.34907098,-0.48090849,-0.64109978,-0.78359907,-0.9213958,-1.0587496,-1.018502,-0.93498791,-0.84454749,-0.76022729,-0.64617902,-0.46021492,-0.37925584,-0.21169011,-0.052117992,0.10024828,0.29574685,0.30773211,0.37714717,0.48270058,0.63673599,0.80194205,0.96851228,1.1357482,1.2163408:1
2.4298252,2.3461897,2.2039873,2.0484478,1.8905402,1.7627337,1.6523629,1.5093397,1.3671558,1.2240534,1.0819221,0.93904905,0.79654256,0.65592897,0.52206078,0.38049096,0.24043955,0.097569205,-0.044611391,-0.171369,-0.31474514,-0.45412228,-0.58118311,-0.71443531,-0.8507491,-0.9748795,-1.0549018,-1.1454518,-1.0729748,-1.0327158,-0.98954956,-1.0197773,-1.1163206,-1.1930373,-1.140207,-1.0666039,-1.0123754,-0.95571922,-0.88391834,-0.84402667,-0.77536977,-0.6886948,-0.58856742,-0.48677347,-0.3907257,-0.28243861,-0.24057882,-0.23247042,-0.20156313,-0.1154116,-0.010040341,0.082658272,0.18898077,0.30808136,0.40390144,0.45376389,0.51996091,0.63940547,0.76042643,0.81963308,0.91303365,1.0395029,1.1647315,1.272802,1.1827304,1.0591346,0.94258342,0.83137011,0.71581134,0.59771558,0.47398571,0.37777659,0.26452895,0.15998096,0.060147345,-0.053770719,-0.18231266,-0.2960553,-0.42627068,-0.54850517,-0.67766498,-0.78598757,-0.90213682,-1.0340812,-1.1451755,-1.2342845,-1.3440225,-1.4540989,-1.5384423,-1.5938572,-1.5318744,-1.4672081,-1.411754,-1.4062031,-1.4227351,-1.3596662,-1.2378315,-1.187516,-1.1520801,-1.0753364,-0.95197278,-0.82266884,-0.7596085,-0.65063968,-0.5660699,-0.4729899,-0.40505548,-0.31764784,-0.22824201,-0.14368148,-0.0508414,0.022577796,-0.045994383,-0.16943274,-0.25294415,-0.33933467,-0.41530851,-0.46011996,-0.48177019,-0.47478245,-0.41113371,-0.32974051,-0.22725535,-0.1203519,-0.03511696,0.04793916,0.11674266,0.22020765,0.3070588,0.34786803,0.39096758,0.48087311,0.55837113,0.64547727,0.74965349,0.81824825,0.87318083,0.97696596,1.0834808,1.1993285,1.3137965,1.4260211,1.4622948,1.3341619,1.2086134,1.0809903,0.95324773,0.83474481,0.70876702,0.58571138,0.45515428,0.36510607,0.23939792,0.11837335,-0.0039441579,-0.12290868,-0.23942883,-0.36520322,-0.47671926,-0.60172148,-0.71872546,-0.83800747,-0.96371043,-1.0826923,-1.2076406,-1.3268427,-1.4458362,-1.570262,-1.6931049,-1.819982,-1.9438898,-2.0718531,-2.1931132,-2.3172652,-2.4057159,-2.2989312,-2.199636,-2.0709146,-1.9375359,-1.7922173,-1.6748334,-1.5453155,-1.406689,-1.2727394,-1.1489775,-1.0163444,-0.89306194,-0.76167662,-0.64352435,-0.50792682,-0.35340624,-0.20829456,-0.064362967,0.075913185,0.21283049,0.35246984,0.44535377,0.39445965,0.32625207,0.2714704,0.26277334,0.29431564,0.3694721,0.43036086,0.55476143,0.66842853,0.78068479,0.87431712,0.90500029,0.99192638,1.09053,1.1557043,1.246675,1.3194966,1.379755,1.4886268,1.5837386,1.7063575,1.8301406,1.8930092,1.7926319,1.6556371,1.5189996,1.4008855,1.2892421,1.1995439,1.1052268,0.97367472,0.87713305,0.77315976,0.73051759,0.70553259,0.61344574,0.48882981,0.36743994,0.24652359,0.14691274,0.27910494,0.36642953,0.47020947,0.59174878,0.71459752,0.73621956,0.65773237,0.55661312,0.46033871,0.38039894,0.30241792,0.22480409,0.11930814,-0.010959393,-0.15067196,-0.27355021,-0.41051298,-0.55173404,-0.66333137,-0.78332923,-0.84371849,-0.72256042,-0.60084856,-0.46945069,-0.34853506,-0.22657478,-0.10652495,0.0085415255,0.013047035,0.040136667,0.080871552,0.18385285,0.30822051,0.43169681,0.54993685,0.64886134,0.76699435,0.87121664,0.94818291,1.0807456,1.1983096,1.3270845,1.4513933,1.5865416,1.7138343,1.8086985,1.8296677,1.7110291,1.5981726,1.4912206,1.3765464,1.3019296,1.2261338,1.1339237,1.0627283,0.981421,0.88863412,0.8361787,0.82980321,0.76834602,0.67956141,0.59161111,0.51420739,0.44101366,0.37075298,0.28027861,0.18534789,0.1098392,0.040378165,0.039201238,0.14792304,0.22856861,0.32139177,0.46145035,0.55280632,0.50510586,0.40647821,0.31666111,0.2278641,0.15102509,0.074364263,0.0018348087,-0.067147778,-0.12802492,-0.22644611,-0.34401352,-0.43718903,-0.53640901,-0.63929698,-0.71369772,-0.7676026,-0.82160013,-0.8515097,-0.85849146,-0.91954998,-0.96579818,-1.0009439,-0.98098343,-0.89230813,-0.84636952,-0.72424237,-0.59515271,-0.47272838,-0.33767603,-0.20460428,-0.095284724,0.031920385,0.11988131,0.17580498,0.29268032,0.41761873,0.52412998,0.65307887,0.7657556,0.88782629,0.97346745,0.86389061,0.73324681,0.62048935,0.55169186,0.46963541,0.43651711,0.32270847,0.24493482,0.16482101,0.11153089,0.0050681723,-0.11910261,-0.22999924,-0.31259712,-0.35817562,-0.38865538,-0.41387122,-0.45277347,-0.5432148,-0.54791854,-0.62388487,-0.70810182,-0.81391659,-0.91209602,-0.9963874,-1.0939508,-1.1682618,-1.2488602,-1.3436861,-1.4046718,-1.4545608,-1.499065,-1.5913644,-1.6620195,-1.7920962,-1.8841143,-1.9387579,-2.0798787,-2.0804501,-2.0254638,-1.9249761,-1.8175756,-1.7105126,-1.5996602,-1.4875852,-1.3672983,-1.2437251,-1.1175896,-0.99645799,-0.87786777,-0.74360675,-0.61945384,-0.49005586,-0.35390975,-0.22928465,-0.091754986,0.038278874,0.18064001,0.30596144,0.44826237,0.59054023,0.73252034,0.87063622,1.0170073,1.1585618,1.3005905,1.4582942,1.5993667,1.7565379,1.9130604,2.0666215,2.2150053,2.3292742,2.3953057:5
2.1490445,2.0839377,2.0212739,1.9565106,1.898841,1.8317228,1.7681865,1.7026698,1.6416147,1.5776399,1.5141457,1.4520417,1.3859909,1.3220191,1.2528483,1.1879745,1.1303442,1.0616847,0.98905519,0.92022715,0.92032137,0.87918179,0.7941491,0.7414374,0.67610457,0.60723585,0.5387709,0.47143545,0.39400882,0.3246555,0.28235194,0.2411296,0.20166356,0.15908275,0.1208345,0.085090544,0.063896404,0.061414765,0.073833067,0.08334456,0.089223486,0.083598845,0.062653044,0.035088733,0.0073435398,-0.046470643,-0.078638772,-0.12029891,-0.14881786,-0.17149146,-0.20323317,-0.2258998,-0.24643691,-0.2856536,-0.33374876,-0.39201581,-0.43379066,-0.48107854,-0.52915598,-0.58554851,-0.64292424,-0.69154806,-0.74998672,-0.8040136,-0.87351697,-0.92439717,-0.97931936,-1.034582,-1.098066,-1.1491607,-1.209523,-1.2702946,-1.3364674,-1.401437,-1.4698513,-1.5349021,-1.6249371,-1.6921078,-1.7289259,-1.6889314,-1.6357145,-1.5779025,-1.5187949,-1.467977,-1.4185355,-1.3633022,-1.3196066,-1.2760241,-1.2313449,-1.1815278,-1.1342643,-1.096711,-1.0468881,-1.0103838,-0.97446475,-0.93583228,-0.89953206,-0.87412802,-0.84613733,-0.81639727,-0.78479964,-0.73631902,-0.68093739,-0.6359597,-0.58190753,-0.53673375,-0.48122764,-0.43665499,-0.39689156,-0.3738256,-0.34914062,-0.33045072,-0.31716996,-0.32084916,-0.33495163,-0.34555183,-0.36405877,-0.3929798,-0.43355987,-0.47500021,-0.53241362,-0.58648906,-0.64665301,-0.68625058,-0.71348103,-0.73163438,-0.72139246,-0.69852576,-0.65849662,-0.61984171,-0.56239277,-0.52774482,-0.46403492,-0.4039438,-0.32388115,-0.24228115,-0.15979303,-0.078913876,-3.8952418E-6,0.052818629,0.099429684,0.15735753,0.19101213,0.24608185,0.29566735,0.34971439,0.40071317,0.45134716,0.5055299,0.54208983,0.59127288,0.64130979,0.6832655,0.72695832,0.77035366,0.81255847,0.85364376,0.89926636,0.93697178,0.97476294,1.0181949,1.0550975,1.0849694,1.1175479,1.1410838,1.1635021,1.179334,1.1979404,1.2201448,1.2212022,1.2172412,1.1986764,1.1845684,1.1660486,1.1445892,1.1254304,1.0797324,1.0414056,1.009027,0.97636263,0.94070312,0.89696857,0.84468226,0.80825382,0.7557953,0.70804735,0.6511209,0.61514484,0.5805483,0.5409612,0.49910452,0.4745773,0.44402321,0.41673475,0.40943881,0.40519881,0.43612478,0.48521055,0.53507661,0.58088696,0.63791902,0.6871628,0.74167158,0.79654457,0.8525691,0.90843261,0.95864159,1.0047086,1.064002,1.111812,1.1702185,1.223937,1.2737381,1.2939167,1.3193698,1.335851,1.3516566,1.3703388,1.3845091,1.3927546,1.3956526,1.3932531,1.3834021,1.361897,1.3439885,1.3155538,1.2830179,1.2303867,1.1676763,1.117153,1.0482493,0.99686159,0.92917447,0.91369208,0.87230015,0.81393957,0.82211131,0.78326138,0.75475213,0.74641565,0.74149827,0.70482322,0.65330207,0.60175642,0.55111709,0.49717216,0.44575829,0.38323316,0.32891819,0.26002512,0.21044537,0.1390997,0.065653795,0.0057625456,-0.054988452,-0.12289096,-0.19578307,-0.24778271,-0.31676739,-0.38329676,-0.45147052,-0.52001117,-0.60867673,-0.67444753,-0.74190221,-0.80856451,-0.88099497,-0.96433712,-1.0444658,-1.107209,-1.1848064,-1.2167454,-1.2466223,-1.3069904,-1.379499,-1.371402,-1.3222736,-1.2737898,-1.2251056,-1.1786385,-1.1057974,-1.0510106,-1.0032683,-0.94993863,-0.89750035,-0.85277313,-0.81995094,-0.76800681,-0.72994186,-0.68551616,-0.65580206,-0.61546661,-0.57187619,-0.54037063,-0.50767734,-0.47519415,-0.43535223,-0.40746173,-0.38483231,-0.35895111,-0.35551943,-0.35598518,-0.36511579,-0.37981882,-0.39267435,-0.41468443,-0.43562387,-0.46576493,-0.49660936,-0.53134139,-0.56933413,-0.60360823,-0.65096366,-0.69468661,-0.75224803,-0.78732835,-0.8309027,-0.86912626,-0.90096704,-0.9346316,-0.97285811,-1.009369,-1.0519094,-1.0897631,-1.1287044,-1.1662544,-1.2011501,-1.2381959,-1.3007021,-1.3633859,-1.4298362,-1.4932613,-1.5531991,-1.6103842,-1.6587199,-1.7134089,-1.7620213,-1.8132659,-1.8476644,-1.8739145,-1.8992595,-1.8874501,-1.8585724,-1.8179259,-1.7545286,-1.7124595,-1.6525077,-1.5989171,-1.5376091,-1.4648004,-1.3985986,-1.3279809,-1.2655434,-1.1822016,-1.1259802,-1.0599521,-0.98910696,-0.93028429,-0.85734943,-0.7985285,-0.74177525,-0.68837736,-0.64654315,-0.60341994,-0.56068358,-0.51605668,-0.48043999,-0.44965495,-0.41433755,-0.38093863,-0.34205485,-0.31034519,-0.281215,-0.25231252,-0.21864991,-0.17852094,-0.14577736,-0.11505909,-0.08082591,-0.059026607,-0.030127944,0.0037208576,0.027336873,0.063738774,0.084087038,0.085105961,0.080979987,0.075076411,0.10633287,0.15029579,0.19809177,0.25794836,0.30802315,0.35872036,0.42155815,0.47079875,0.53297912,0.58875436,0.64644652,0.71085414,0.77270609,0.83585108,0.90319503,0.96539742,1.0269641,1.0979655,1.1582555,1.2181608,1.2893419,1.3448971,1.4153553,1.4734814,1.537689,1.6119413,1.6747789,1.7356472,1.805374,1.8624291,1.9254612,2.0042776,2.0631564,2.1284798,2.1987849,2.2229956,2.2241011,2.2068928,2.1925929:2
1.2719724,1.0732241,0.84922827,0.65521311,0.46199946,0.33863083,0.18724459,-0.003227266,-0.14905943,-0.24271545,-0.43559201,-0.55104105,-0.71208604,-0.86573439,-0.97048717,-0.90661171,-0.84306779,-0.76153165,-0.66298326,-0.60767381,-0.50027227,-0.47588239,-0.41817035,-0.36049309,-0.27137487,-0.31321662,-0.32222813,-0.27239575,-0.1683558,-0.031150723,-0.11386711,-0.029584822,0.019529675,0.12519535,0.23057518,0.3410386,0.45005461,0.51775991,0.59446446,0.53095155,0.55961377,0.61054749,0.59384496,0.6675316,0.76391895,0.76853033,0.88528487,0.99203181,0.89694096,0.93409229,1.0477844,0.98668225,1.0170144,0.89074214,0.74930708,0.56892948,0.41902567,0.25488655,0.1439119,-0.027980876,-0.10370384,-0.27352669,-0.463296,-0.55185459,-0.72207596,-0.84868779,-0.9589645,-0.99534467,-1.0646431,-1.173691,-1.12695,-1.2480922,-1.253411,-1.2276937,-1.2932511,-1.3977659,-1.379106,-1.4470276,-1.5136074,-1.3693639,-1.2753394,-1.12034,-0.97953608,-0.92703595,-0.79563513,-0.78164649,-0.82171926,-0.65646344,-0.54652157,-0.42410733,-0.35201837,-0.4204382,-0.36828233,-0.2616938,-0.26440348,-0.19914895,-0.16104612,-0.052522098,0.039599878,0.002125799,0.11021731,0.24594155,0.30041493,0.34194423,0.23244794,0.083632035,-0.07072452,-0.19798666,-0.2125563,-0.33252095,-0.48132709,-0.62323577,-0.7121254,-0.79087374,-0.89454494,-1.0443521,-1.1757914,-1.230103,-1.3747016,-1.5359271,-1.6956131,-1.7366492,-1.8596467,-1.8827723,-2.0098739,-2.0977322,-2.2621098,-2.3428958,-2.2463871,-2.2629015,-2.1170525,-2.0620255,-1.9501331,-1.9140361,-1.7612467,-1.8482533,-1.7241189,-1.5799982,-1.4429933,-1.4251163,-1.3107629,-1.2496255,-1.1417611,-1.0373916,-0.92231712,-0.79772141,-0.71824638,-0.58957022,-0.49367263,-0.39451764,-0.28835607,-0.18546285,-0.078491902,0.0049281913,0.086236956,0.093897392,-0.0079313679,-0.027919291,-0.063212268,-0.16004077,-0.21700574,-0.26280243,-0.33188304,-0.46604463,-0.61608398,-0.73228574,-0.81208576,-0.88813738,-0.98828955,-1.0251871,-1.1970118,-1.3484895,-1.4746329,-1.3617936,-1.4890022,-1.6517318,-1.5986056,-1.4328359,-1.2800388,-1.1283439,-1.0201255,-0.86019338,-0.76111219,-0.58957022,-0.44707469,-0.28359441,-0.12762612,0.036533415,0.1832942,0.36345503,0.51202458,0.6658712,0.77522034,0.80278283,0.73878709,0.64292672,0.50866554,0.50516108,0.35517168,0.27587752,0.24753309,0.16543468,0.22193254,0.20412415,0.080420362,-0.038813699,-0.16270112,-0.3076841,-0.42585008,-0.39068706,-0.32121161,-0.43903251,-0.53902993,-0.65402592,-0.76782669,-0.87187375,-0.82351694,-0.89677319,-0.9928112,-1.1201101,-1.213094,-1.1754173,-1.055761,-1.0321374,-0.81375964,-0.64761812,-0.46564758,-0.35010387,-0.15496666,0.03283905,0.2269239,0.45619888,0.68204901,0.87452065,1.0633982,1.2562192,1.456781,1.5851304,1.6657169,1.6366499,1.5770804,1.4941923,1.4143921,1.3311044,1.2823128,1.2039111,1.1228521,1.1809145,1.0844088,1.0103553,0.94724617,0.87360609,0.80094446,0.82561199,0.82270591,0.75285187,0.69569572,0.62053221,0.55019106,0.61882487,0.55947841,0.47586189,0.39981563,0.32285036,0.24894136,0.16311275,0.060605138,0.0033461795,0.17494336,0.34098524,0.51503876,0.65553709,0.81252006,0.99171084,1.163925,1.2614837,1.4363555,1.5924603,1.7694264,1.9534107,1.8734424,1.7925341,1.7074336,1.643086,1.5394945,1.5133479,1.4537669,1.3797066,1.4457102,1.4617952,1.403729,1.3767584,1.3302499,1.2826687,1.3697505,1.3690901,1.3107388,1.2543506,1.1575715,1.095424,1.0088114,0.95050461,0.84151726,0.70916929,0.6837589,0.7980602,0.9456003,1.1243158,1.2998051,1.4620575,1.6213561,1.7837373,1.7430964,1.6703191,1.5939931,1.6211007,1.5530558,1.5199625,1.4487373,1.4059609,1.3570936,1.2965928,1.2165176,1.1087165,0.99935259,0.88198058,0.78306555,0.66881927,0.56598144,0.45557735,0.35863663,0.24567766,0.13866406,0.025190529,-0.093521893,-0.23340818,-0.36525789,-0.49146514,-0.64576682,-0.78059998,-0.92162828,-1.0437572,-1.1893585,-1.3423911,-1.3717245,-1.521072,-1.67259,-1.864501,-2.0074147,-2.0984941,-2.1078875,-2.0886786,-1.9636915,-1.8515032,-1.8146836,-1.6972072,-1.5352459,-1.4022909,-1.263385,-1.1109981,-0.97207624,-0.84487617,-0.70854957,-0.58720501,-0.45990443,-0.34284718,-0.22170619,-0.11308044,0.010559781,0.1143376,0.22544314,0.27423545,0.40198251,0.48478998,0.50051174,0.45710003,0.54982478,0.65757102,0.74408144,0.7926599,0.86273769,0.90527598,0.94151825,0.99752248,1.0126791,1.0552336,1.1034556,0.99259133,1.0363175,1.0936273,1.203743,1.0788924,0.98673633,0.8735136,0.8243554,0.77651822,0.62344035,0.51740661,0.36725215,0.24242191,0.12850491,0.07339003,0.02272372,0.075571275,0.15292246,0.21517814,0.27518768,0.35872434,0.44812449,0.38160625,0.46821001,0.51791864,0.54036215,0.59250244,0.68080262,0.66057872,0.56036337,0.59802188,0.64065938,0.69958247,0.79449655,0.92357848,0.92806181,1.0329544,1.1125596,1.1905761,1.2816677:1
2.2094607,2.1705763,2.1182141,2.0511679,1.9661731,1.8907331,1.8273171,1.7294583,1.6665904,1.5779836,1.504991,1.4360012,1.3495849,1.2779618,1.2107245,1.1424263,1.0932472,1.0200715,0.9583956,0.90468822,0.85390873,0.80003512,0.75999622,0.75157478,0.76155343,0.76649268,0.73309289,0.73637273,0.71341369,0.67009918,0.6276587,0.58833949,0.59388917,0.58997553,0.55655255,0.51970229,0.47951619,0.42880078,0.36083352,0.29825091,0.23798763,0.14119015,0.044934089,-1.8149367E-4,-0.0053450554,3.0633039E-4,0.011227269,9.6786367E-4,-0.016251537,-0.032311698,-0.047252344,-0.074121522,-0.11146806,-0.1478835,-0.18260527,-0.23181746,-0.27734962,-0.32607038,-0.36534058,-0.41556147,-0.44954507,-0.49738601,-0.54513914,-0.58932256,-0.63825195,-0.71779688,-0.80593809,-0.87003741,-0.9487803,-1.0271244,-1.084563,-1.1493232,-1.161909,-1.1344297,-1.0925435,-1.0488556,-0.98605296,-0.93925152,-0.90441545,-0.87006541,-0.85241098,-0.81796708,-0.82876283,-0.81800283,-0.80864069,-0.79062401,-0.76832407,-0.74769173,-0.73629457,-0.72752084,-0.69673593,-0.68739339,-0.66589576,-0.64375989,-0.62965472,-0.6107077,-0.57757518,-0.54551026,-0.52447636,-0.49112066,-0.46025602,-0.43007676,-0.40958585,-0.38026392,-0.37072742,-0.3426319,-0.33458979,-0.32254745,-0.30832882,-0.29569046,-0.29639224,-0.30379099,-0.32703402,-0.34391348,-0.37589865,-0.42023767,-0.47772199,-0.52773062,-0.58920974,-0.61430827,-0.67073047,-0.72684822,-0.79638028,-0.86847132,-0.93021045,-0.99555145,-1.076816,-1.1298604,-1.2211899,-1.289264,-1.3654173,-1.4585453,-1.5511772,-1.6409367,-1.7301526,-1.7787295,-1.8315537,-1.9008833,-1.9075487,-1.891741,-1.8373064,-1.7743664,-1.7033493,-1.6328767,-1.5713411,-1.5382771,-1.4671871,-1.401296,-1.3186954,-1.2513984,-1.1674485,-1.1184393,-1.0367274,-0.95421565,-0.88720753,-0.81663672,-0.74820041,-0.67277168,-0.61299525,-0.55533639,-0.49363588,-0.42027745,-0.35954736,-0.29191895,-0.22097914,-0.16613172,-0.098507277,-0.043815034,0.026968947,0.098557397,0.16053538,0.22521833,0.29738386,0.35792053,0.41753319,0.47191032,0.55455474,0.60278368,0.68090915,0.74376076,0.80754219,0.86840347,0.92339222,0.96132751,1.0197373,1.0545757,1.1128321,1.1466955,1.1886917,1.2009712,1.2051809,1.2073201,1.1897441,1.1568073,1.1044968,1.0475531,0.99718491,0.9311946,0.86322979,0.82439737,0.80639769,0.76890867,0.7443142,0.74947047,0.80337169,0.88386597,0.9611041,1.0244748,1.1154608,1.1801336,1.2698457,1.3537927,1.4037166,1.4769846,1.5269558,1.5719746,1.6099346,1.6342843,1.6511627,1.6679793,1.6478295,1.6553152,1.6519152,1.6224266,1.5855613,1.5322859,1.4698083,1.4156189,1.4196633,1.4840123,1.5093146,1.4871843,1.4609412,1.4237876,1.3828451,1.329567,1.2711248,1.210392,1.1561567,1.1078332,1.0413095,0.98479292,0.9229167,0.87319756,0.81954808,0.76028695,0.71860509,0.65927085,0.56403641,0.46967558,0.40847366,0.31233429,0.21626142,0.12011532,0.023891155,-0.072590431,-0.1688751,-0.26522173,-0.36135861,-0.41697688,-0.39761734,-0.40866382,-0.35903728,-0.31872517,-0.26234811,-0.20557312,-0.1563087,-0.10259884,-0.095859693,-0.070119191,-0.021873288,-0.021949589,-7.3020731E-4,0.024175058,0.031706952,0.025477716,0.033170547,0.023079595,-0.0094609272,-0.058930624,-0.12990346,-0.17448101,-0.23184694,-0.29666838,-0.38396654,-0.46103034,-0.50263239,-0.53168658,-0.58975542,-0.63362011,-0.68559725,-0.73675788,-0.77360961,-0.83357893,-0.86043318,-0.92179864,-0.99287271,-1.0637752,-1.1267856,-1.1915597,-1.249837,-1.315953,-1.39165,-1.4631341,-1.5191913,-1.5842374,-1.6540674,-1.7167241,-1.7818786,-1.8410121,-1.9054818,-1.899318,-1.8759754,-1.806147,-1.7312928,-1.7145589,-1.6872191,-1.6265176,-1.5939625,-1.5339126,-1.4622177,-1.3740876,-1.3121368,-1.2373813,-1.1536046,-1.0689032,-1.0081073,-0.95499084,-0.86677438,-0.78632083,-0.73831264,-0.69000388,-0.64798101,-0.61115963,-0.59181849,-0.56912711,-0.56317075,-0.56065291,-0.56495591,-0.55408574,-0.55634749,-0.55819061,-0.55789053,-0.54123263,-0.53044684,-0.52635134,-0.52716338,-0.50800797,-0.49616222,-0.50359603,-0.50313528,-0.50784179,-0.50691045,-0.50525903,-0.49910401,-0.49998606,-0.50281672,-0.49766631,-0.50394367,-0.50077759,-0.50761724,-0.5069447,-0.51978125,-0.53287333,-0.53258568,-0.54338256,-0.56236343,-0.5769975,-0.57673897,-0.51718571,-0.49964735,-0.42189162,-0.34785879,-0.27418801,-0.21370403,-0.14279458,-0.065299867,-0.0037932728,0.064053846,0.13336037,0.19708936,0.2685859,0.32077638,0.3816806,0.41079541,0.4652299,0.48958601,0.52160329,0.54490294,0.56105211,0.58930705,0.59759742,0.60423288,0.60246821,0.59594989,0.58166995,0.54106966,0.49772952,0.45941273,0.45067376,0.46248776,0.50453566,0.57180555,0.63935168,0.7245781,0.80747847,0.87817775,0.96061538,1.037053,1.0979272,1.1967449,1.2595024,1.3313453,1.4225924,1.4851154,1.5700017,1.649955,1.7109222,1.7925414,1.8757661,1.94015,2.0182786,2.096592,2.1446667,2.1619762,2.2018863,2.2380412:2
2.5651063,2.4569327,2.3231612,2.1896154,2.0561145,1.9484779,1.8152935,1.6821033,1.5749036,1.4418803,1.3347659,1.2053453,1.0954774,0.98926284,0.90088837,0.82805065,0.8125559,0.82683997,0.82848968,0.81882367,0.79733755,0.78065465,0.7600823,0.73608144,0.70770057,0.6815084,0.65733173,0.62857695,0.59253907,0.55804661,0.52480164,0.48658622,0.43571863,0.39433497,0.35983535,0.33257984,0.31859715,0.30357246,0.28349459,0.28032491,0.28218142,0.28696192,0.29974896,0.3111264,0.32220658,0.34908041,0.38551348,0.35748908,0.2744501,0.20567575,0.14464811,0.038061775,-0.04667367,-0.13815532,-0.19955475,-0.28452272,-0.37525201,-0.4644327,-0.56113701,-0.65868745,-0.77070334,-0.84673689,-0.89113836,-0.92452969,-0.94039017,-0.94626762,-0.94877509,-0.94904292,-0.95960747,-0.96399035,-0.95250851,-0.94658397,-0.94315882,-0.93069699,-0.90160523,-0.86051821,-0.81798529,-0.76837918,-0.7192505,-0.66539338,-0.6069349,-0.54707733,-0.48768727,-0.42445475,-0.35569682,-0.28801807,-0.26938938,-0.29204426,-0.24804143,-0.18554842,-0.11994225,-0.035069197,0.044866318,0.13255686,0.23440015,0.33395717,0.42519804,0.43033,0.32331396,0.18896985,0.081034182,-0.0096064184,-0.11961873,-0.2136559,-0.28298954,-0.37533442,-0.47715921,-0.56853373,-0.66069821,-0.75751457,-0.86814911,-0.97843124,-1.0910527,-1.2018172,-1.3137022,-1.4220806,-1.5486885,-1.6440077,-1.7219225,-1.7610248,-1.8023125,-1.8290255,-1.8219434,-1.762792,-1.6762258,-1.6004242,-1.4970932,-1.4147219,-1.3181519,-1.2183892,-1.1128214,-1.0138158,-0.91514229,-0.8130237,-0.70634754,-0.61681701,-0.50907014,-0.40276558,-0.29938062,-0.20239666,-0.10315308,0.0011329326,0.10005189,0.19464049,0.30101325,0.39912088,0.43427298,0.35810314,0.36624446,0.421726,0.51656726,0.62628779,0.72665937,0.8259903,0.93971903,1.0285383,1.1397277,1.1667214,1.0788828,0.97918204,0.88923288,0.80213875,0.70818429,0.62396759,0.54437052,0.44784817,0.36320731,0.2802556,0.20198368,0.14187999,0.091473219,0.10527746,0.16013553,0.22576567,0.2890546,0.37593788,0.47684276,0.57942849,0.70942673,0.81359596,0.9103266,0.99480812,1.1101723,1.2282823,1.3609913,1.4801182,1.5550886,1.5126479,1.4256416,1.3887009,1.445666,1.5377429,1.6319101,1.7386517,1.8459839,1.9794727,2.049938,1.9539983,1.8446397,1.7122835,1.5786416,1.4634486,1.4804687,1.5376893,1.4058004,1.2974065,1.1636696,1.030033,0.89634593,0.76284674,0.62938117,0.52177412,0.38849322,0.26054459,0.17508812,0.10220621,0.052029108,0.043476311,0.085447026,0.144944,0.21560105,0.2868502,0.35962817,0.43309309,0.5083451,0.59943304,0.68164032,0.75646984,0.86884888,0.7979938,0.70256508,0.5927738,0.49800268,0.38905434,0.35748104,0.31814579,0.22015847,0.12380807,0.020751499,-0.07801973,-0.17503418,-0.28587107,-0.39641082,-0.48679601,-0.59899238,-0.7074488,-0.83652278,-0.94481352,-1.0757808,-1.1831555,-1.2918498,-1.3994263,-1.5260189,-1.6511644,-1.7661145,-1.826095,-1.9481749,-2.0314851,-2.1023947,-2.1437192,-2.1611711,-2.1538697,-2.0979127,-1.990217,-1.887643,-1.7781229,-1.682925,-1.5811493,-1.4722543,-1.3789005,-1.2836489,-1.1878898,-1.0978581,-1.015392,-0.9190429,-0.82796058,-0.75825314,-0.69845384,-0.66111573,-0.56534987,-0.46363982,-0.37160632,-0.27799507,-0.18563989,-0.094292453,-0.012864929,-0.085439776,-0.16634489,-0.24694669,-0.32876507,-0.40365724,-0.48733574,-0.57663664,-0.65637159,-0.72329763,-0.77790809,-0.73461223,-0.62391239,-0.51764546,-0.50252978,-0.59062873,-0.67101384,-0.74856239,-0.82526076,-0.90180294,-0.97213814,-1.0401281,-1.0981401,-1.167309,-1.2289207,-1.2880211,-1.3466653,-1.3929775,-1.4448547,-1.4953717,-1.5274234,-1.5520546,-1.5858085,-1.6147848,-1.617956,-1.6108923,-1.5900057,-1.5358116,-1.4800892,-1.3951459,-1.298724,-1.2031432,-1.1134484,-1.0346328,-0.94197513,-0.89151667,-0.83676144,-0.77447783,-0.70547999,-0.64909152,-0.59082791,-0.49071777,-0.40955701,-0.32354561,-0.2396292,-0.17027991,-0.10056048,-0.032480813,0.04615684,0.11943718,0.18959268,0.16999136,0.1038376,0.042076913,-0.010577799,-0.056062369,-0.099619958,-0.1428835,-0.18455733,-0.21831527,-0.24842932,-0.26226477,-0.27272046,-0.28481073,-0.28860297,-0.29806361,-0.2988044,-0.2963004,-0.28877551,-0.28682646,-0.27978601,-0.27646212,-0.27253768,-0.26387151,-0.23806654,-0.2147194,-0.19893527,-0.17610995,-0.1469133,-0.10909759,-0.063823059,-8.8657187E-4,0.11115904,0.21279837,0.30235659,0.37506249,0.4449522,0.50216451,0.53623798,0.54183547,0.5440245,0.55902724,0.57395299,0.60720643,0.63081649,0.65612227,0.68997255,0.71963119,0.7428058,0.77543022,0.80824424,0.83980472,0.87078348,0.89797142,0.91864658,0.92240092,0.92082966,0.90720724,0.91004765,0.92314775,0.94067304,0.96880405,1.0229464,1.1029379,1.1149402,0.98737725,0.91267371,0.92187229,1.0286016,1.1594171,1.2689065,1.3823283,1.509703,1.6172674,1.7506918,1.8584197,1.9918855,2.0997392,2.2333519,2.3669905,2.5006924,2.573134:4
1.9077857,1.8825598,1.8826958,1.8596347,1.8684224,1.8645495,1.8234121,1.774832,1.746294,1.6971814,1.6637546,1.6284742,1.6030972,1.591998,1.5239973,1.5286744,1.5663771,1.5275579,1.5076759,1.5073445,1.6030235,1.5855952,1.5522548,1.58708,1.5693399,1.5154379,1.5013614,1.4757978,1.4252682,1.4016962,1.348487,1.3234404,1.2615175,1.1859687,1.140242,1.0934236,1.0299362,0.96105196,0.88153655,0.80774604,0.73370489,0.64886824,0.56787956,0.49209189,0.41571953,0.38458986,0.35861477,0.30285465,0.25017107,0.16076238,0.085672457,0.040732459,-0.051435027,-0.08675821,-0.17248098,-0.24146535,-0.29228315,-0.38189613,-0.41954016,-0.50125269,-0.54075305,-0.60114621,-0.67436423,-0.74950522,-0.80461668,-0.86419917,-0.87861559,-0.90825155,-0.85795245,-0.87593283,-0.89211419,-0.9087753,-0.9174002,-0.91233905,-0.92423709,-0.94532141,-0.96869222,-1.0048646,-1.0356405,-1.0562735,-1.0672603,-1.1117164,-1.1332098,-1.1676067,-1.1901729,-1.2271308,-1.2263904,-1.2489314,-1.2636415,-1.2859074,-1.2922585,-1.3316676,-1.3331957,-1.3505624,-1.3543613,-1.361151,-1.3477515,-1.3076095,-1.2588391,-1.2681414,-1.2341077,-1.1650024,-1.1207989,-1.0673351,-1.0038556,-0.99721334,-0.9459961,-0.88492914,-0.82630997,-0.76240941,-0.70193226,-0.65687186,-0.62445596,-0.56598137,-0.50836466,-0.44867229,-0.41678808,-0.37845115,-0.36214968,-0.30831401,-0.28365763,-0.22329906,-0.19740214,-0.15419785,-0.11995698,-0.11294826,-0.12344274,-0.071986906,-0.042729792,-0.004059742,-0.019936928,7.5205242E-4,0.02313432,0.060215555,0.055153401,0.043185461,0.071553361,0.10733411,0.11606245,0.089454332,0.14052455,0.16636011,0.19263135,0.19195346,0.19989815,0.2112963,0.28067651,0.37576478,0.37777957,0.3408065,0.34166424,0.36906703,0.40183646,0.43682244,0.47334754,0.5714108,0.59180301,0.63389075,0.6544845,0.68255438,0.72194268,0.77822661,0.83134529,0.9396674,1.0037987,1.0850243,1.1321126,1.228829,1.2816817,1.3320404,1.3450172,1.3035854,1.2525777,1.2502446,1.2114793,1.1513187,1.1252013,1.0866935,1.0460398,0.97831618,0.91252797,0.85894085,0.808317,0.71277331,0.65949438,0.56142207,0.52006486,0.47238695,0.46336774,0.44914582,0.50147338,0.52407891,0.54902491,0.54416676,0.57669988,0.6355511,0.70987983,0.7761343,0.80691043,0.88106736,0.90331056,0.94662703,1.0052358,1.0628584,1.1110511,1.1020438,1.096062,1.1056584,1.052504,1.0199031,0.98694304,0.91454031,0.91454031,0.89960102,0.88110706,0.81059384,0.78454327,0.75532183,0.72833398,0.75231321,0.69622116,0.68518963,0.67202328,0.65587302,0.62100562,0.57932803,0.58014435,0.55288822,0.53637993,0.51122991,0.47793081,0.46305179,0.43772409,0.39926949,0.30650427,0.21427498,0.1463537,0.030965872,-0.02343937,-0.067659386,-0.12284093,-0.16981294,-0.22344231,-0.1841122,-0.12944347,-0.15900663,-0.21009323,-0.23124461,-0.21311047,-0.2215638,-0.22490027,-0.21777832,-0.1993343,-0.1900359,-0.18941348,-0.17704151,-0.20012665,-0.19861988,-0.18157512,-0.18544874,-0.18403939,-0.18174522,-0.17443387,-0.17160966,-0.1759305,-0.17580868,-0.17081102,-0.17237277,-0.16747028,-0.17514625,-0.18040633,-0.18703056,-0.21421168,-0.25457176,-0.28525551,-0.3283444,-0.3659797,-0.39154191,-0.4369654,-0.48297152,-0.55112635,-0.61371057,-0.6838449,-0.76473635,-0.82251783,-0.9331966,-0.99357667,-1.0952593,-1.1511984,-1.254877,-1.3413125,-1.3715613,-1.4664936,-1.5769414,-1.6235408,-1.7103626,-1.65345,-1.7007473,-1.810279,-1.8548826,-1.9651509,-2.0756509,-2.1334472,-2.1676781,-2.1958817,-2.2481649,-2.2481649,-2.1728883,-2.1490619,-2.190487,-2.145343,-2.095816,-2.0405892,-1.9900382,-1.9351804,-1.8611533,-1.8235697,-1.7503631,-1.7049984,-1.6345534,-1.5764693,-1.5227081,-1.4678777,-1.4140204,-1.3584564,-1.2909403,-1.2500616,-1.1547457,-1.0792552,-1.0173664,-0.9425349,-0.86264384,-0.80823591,-0.72089781,-0.64555906,-0.56733231,-0.49269123,-0.41985328,-0.34551467,-0.31133707,-0.25711416,-0.21215601,-0.18353542,-0.15536697,-0.10494582,-0.081272735,-0.059933854,-0.029816767,-0.027770988,-0.0091894646,-8.0775024E-4,-0.025072225,-0.057019648,-9.2680984E-4,-0.04319797,-0.12240975,-0.15892849,-0.1997716,-0.23745835,-0.2332966,-0.28831222,-0.3368091,-0.40727101,-0.45454795,-0.51983412,-0.59161004,-0.64001665,-0.69744614,-0.77665243,-0.85337496,-0.86468072,-0.8690461,-0.9605989,-1.0354661,-1.0780761,-1.0330241,-0.97938121,-0.89125033,-0.83373757,-0.76913404,-0.68791771,-0.58993959,-0.53868853,-0.43187616,-0.36946405,-0.28217265,-0.2166646,-0.13113992,-0.064854036,0.002054744,0.066217581,0.16736978,0.21981241,0.26438938,0.31147761,0.38821765,0.45994083,0.50840971,0.56419719,0.62404976,0.68608672,0.72792103,0.775417,0.83252096,0.89067492,0.94251037,0.98602357,1.0405225,1.0728769,1.1266991,1.1756319,1.2317018,1.286852,1.3265483,1.396681,1.4595109,1.5107845,1.5862479,1.6396642,1.6786632,1.7530012,1.7596833,1.7402927,1.7685647,1.8439633,1.8772615,1.9190693:2
2.2318269,2.1666887,2.1164975,2.0785086,1.9688661,1.8103929,1.6675161,1.5386501,1.4102793,1.2967907,1.1638886,1.0100085,0.93957279,0.81189533,0.66863675,0.52653275,0.39808042,0.2557586,0.11333917,-0.0021381058,-0.11246735,-0.27025571,-0.39792041,-0.52705356,-0.65453848,-0.78272033,-0.90364991,-1.0533432,-1.1841599,-1.2651822,-1.2374395,-1.2145923,-1.1636767,-1.1304222,-1.1006488,-1.0540624,-1.0128715,-0.92280563,-0.87181477,-0.82536313,-0.74263648,-0.71179234,-0.62299313,-0.57423986,-0.54630623,-0.49165319,-0.39913705,-0.30982469,-0.22103291,-0.17759606,-0.11174731,-0.050091124,0.026766561,0.036223041,0.10541133,0.063660285,0.12928533,0.22126832,0.28408863,0.34474331,0.44333039,0.50450025,0.50788131,0.45311744,0.37841865,0.27147385,0.17875914,0.070164644,-0.044982691,-0.15317367,-0.23407074,-0.346688,-0.37818017,-0.46673332,-0.48717587,-0.55685663,-0.51841336,-0.56181755,-0.65564802,-0.73210243,-0.67342116,-0.67377699,-0.62018622,-0.59187188,-0.5022388,-0.44237225,-0.34422425,-0.31159527,-0.26954773,-0.16390908,-0.065129637,0.023226482,0.11271104,0.15301917,0.18837527,0.24804855,0.25588523,0.29782155,0.29021334,0.26047282,0.25756122,0.27508504,0.28849194,0.31457668,0.36373581,0.43765866,0.43686599,0.51130002,0.55916177,0.60136082,0.66726663,0.74031485,0.83274322,0.88201284,0.93776829,0.99170124,1.0506054,1.1008587,1.1477471,1.1004279,1.0732394,0.98165625,0.86818406,0.73579064,0.60507457,0.46734476,0.36127139,0.25166058,0.20348366,0.13023745,0.0043668315,-0.062031408,-0.14665994,-0.20496267,-0.28608418,-0.40302995,-0.53427378,-0.65478844,-0.77795564,-0.89586971,-1.0087628,-1.1179432,-1.1937378,-1.2697471,-1.3778343,-1.4898846,-1.6036111,-1.678151,-1.7884506,-1.840996,-1.9118179,-1.9751146,-2.0524008,-2.1306177,-2.241485,-2.3313475,-2.4498985,-2.4747545,-2.4336473,-2.3694974,-2.305622,-2.226298,-2.1382708,-2.0212051,-1.9227928,-1.8393642,-1.7240788,-1.6593834,-1.5437108,-1.431939,-1.3288474,-1.2007229,-1.0893684,-0.97461427,-0.89736968,-0.79452482,-0.68366152,-0.56239496,-0.43208703,-0.30222782,-0.19606755,-0.12404844,-0.051715419,-0.043899389,0.0081174668,0.087044732,0.15148275,0.21812091,0.3098741,0.40217906,0.51308679,0.61654277,0.70832986,0.78011302,0.86730271,0.91666386,0.93958478,0.95840891,0.98615908,1.0246092,1.062285,1.1053691,1.1563771,1.2077607,1.2520686,1.2959276,1.3444551,1.4141338,1.4891683,1.5658772,1.6491185,1.7382456,1.8245477,1.9056273,1.8179802,1.7303094,1.6462398,1.5664596,1.4897549,1.4157286,1.3482424,1.2841852,1.2243886,1.1693394,1.1191817,1.0745409,1.0351343,1.000828,0.971983,0.94911307,0.93232544,0.92349278,0.92136945,0.92117133,0.92635942,0.93053841,0.94606002,0.94849076,0.90478495,0.88970275,0.85706004,0.86813677,0.8688619,0.84201409,0.74568315,0.67516763,0.57763728,0.4715543,0.36840868,0.26949684,0.14152839,0.071967147,-0.0050033767,-0.012898911,0.043192884,0.069648624,0.11385318,0.058612169,-0.063622557,-0.17441294,-0.27958486,-0.37280616,-0.50176554,-0.6126767,-0.72736562,-0.85072186,-0.97077477,-1.0924519,-1.2017321,-1.3151292,-1.4262527,-1.5357083,-1.6307579,-1.6854386,-1.6608931,-1.5619213,-1.4736058,-1.4393953,-1.3334179,-1.2218355,-1.136281,-1.0430009,-0.97595665,-0.91081151,-0.79928562,-0.71817881,-0.63251321,-0.50668184,-0.4602927,-0.33004658,-0.24057888,-0.12961544,-0.0026965559,0.11221024,0.21665439,0.32369881,0.40575655,0.43267669,0.5003421,0.58805892,0.67824782,0.78568345,0.90525943,1.0040703,1.1308308,1.2497706,1.388944,1.5172996,1.4806243,1.3917471,1.3116712,1.2351884,1.1621961,1.0859859,1.011144,0.93149517,0.87681322,0.81306074,0.73416723,0.65558866,0.58170103,0.54977317,0.48507832,0.41648063,0.37709981,0.40654275,0.4639464,0.53113325,0.60648218,0.59589665,0.51251075,0.43135559,0.37013907,0.30057386,0.21458938,0.1300781,0.10154414,0.0050345109,-0.060421587,-0.14093749,-0.27489106,-0.38877937,-0.52316491,-0.4545756,-0.5630683,-0.65036974,-0.72726148,-0.76021682,-0.73255522,-0.6644188,-0.61186578,-0.53548514,-0.46474178,-0.39020044,-0.32552273,-0.25791,-0.20993712,-0.10865447,-0.02189546,0.029607558,0.12443875,0.22464249,0.32994991,0.42630041,0.49636029,0.43746136,0.31815521,0.24836537,0.22514567,0.12717731,0.039313951,-0.049873051,-0.083068861,-0.18904153,-0.27787001,-0.32343617,-0.42545915,-0.44702588,-0.54976077,-0.59540957,-0.62938471,-0.68678171,-0.72864791,-0.83448201,-0.93633769,-1.0466678,-1.1482251,-1.1670226,-1.2628605,-1.1960875,-1.2803609,-1.3451888,-1.4015984,-1.4723221,-1.5478348,-1.6149117,-1.7036743,-1.5904167,-1.4660021,-1.3552282,-1.2014925,-1.0623286,-0.90691002,-0.76705502,-0.61093494,-0.47029452,-0.31348311,-0.15657693,-0.01507159,0.14198741,0.28350595,0.44077682,0.58293526,0.73761919,0.88269371,1.040623,1.18438,1.3407996,1.4831896,1.6174276,1.755383,1.8706329,1.9034714,1.9452769,2.0089427,2.1075705,2.2074381:5
1.9290627,1.8199687,1.756405,1.6442966,1.5269631,1.3475632,1.2192565,1.0260559,0.83047981,0.65979593,0.64357698,0.47194669,0.33350208,0.38132198,0.44862982,0.29794185,0.094686155,0.050945903,-3.7431817E-4,-0.044759956,-0.17560034,-0.23644212,-0.3582011,-0.43798232,-0.59495254,-0.5411272,-0.75603411,-0.87011621,-1.0057214,-1.2337296,-1.1853113,-1.4252114,-1.3573058,-1.3856133,-1.1395662,-0.95660316,-0.79831925,-0.58321589,-0.33697267,-0.23672056,0.010371251,0.20302437,0.31498746,0.55861538,0.73339074,0.94798425,1.1594497,1.3189971,1.4980493,1.5121213,1.521127,1.5738811,1.4645461,1.381147,1.2793767,1.1800192,1.0343122,0.89035353,0.75592385,0.71537989,0.56371692,0.38255935,0.31491726,0.23465685,0.08502922,-0.047449073,0.031471716,-0.015395954,-0.023539497,-0.088341201,-0.12959303,-0.20310595,-0.3265171,-0.37983604,-0.40234558,-0.43057729,-0.54583908,-0.63868419,-0.66820288,-0.75422045,-0.9222424,-0.97124083,-0.87036038,-0.68749082,-0.46484732,-0.31756121,-0.063678092,0.080552751,0.279826,0.35398437,0.40420722,0.47890888,0.68617078,0.82190367,0.8905485,0.8624017,0.83828858,0.8047188,0.78274505,0.73247598,0.67703939,0.63368379,0.64676484,0.60733635,0.55241126,0.51658467,0.42588771,0.35994389,0.32516693,0.29908397,0.27834505,0.21600444,0.14307696,0.11774927,0.062616702,-0.057840942,-0.16741834,-0.310291,-0.44323701,-0.50611792,-0.49722699,-0.39252166,-0.27101651,-0.24851312,-0.26160343,-0.26962208,-0.3389341,-0.35891169,-0.51374623,-0.58165729,-0.55374236,-0.63998839,-0.65587726,-0.65388991,-0.77959626,-0.81441941,-1.0035701,-0.92949138,-1.0613983,-1.2023688,-1.3023709,-1.4506417,-1.4819608,-1.5836873,-1.437656,-1.4088055,-1.2000017,-1.0852764,-0.88832547,-0.65606597,-0.53130322,-0.32839451,-0.13787941,-0.01680714,0.18784959,0.41634969,0.63803567,0.80506722,0.95005447,1.1560236,1.2833942,1.4961735,1.7247833,1.9277823,2.1341062,2.359297,2.5722313,2.7983596,2.9920806,3.1871747,3.3999755,3.2692165,3.0829272,2.8843022,2.6671409,2.4540576,2.2481395,2.045415,1.8381681,1.6238023,1.4054139,1.1956642,0.99316822,0.76468115,0.56496714,0.3571474,0.14976667,-0.071600114,-0.28459294,-0.48827149,-0.69537347,-0.91836378,-1.1289134,-1.1201083,-1.057908,-0.8834547,-0.72236411,-0.61541696,-0.47027848,-0.4377665,-0.49979428,-0.33592115,-0.24132954,-0.12072518,-0.047139171,-0.018061951,0.055584553,0.10243554,0.2246567,0.20183484,0.25476202,0.19175133,0.31934985,0.38532393,0.41216146,0.46803431,0.56333432,0.51730134,0.49022463,0.53978767,0.35278817,0.15798821,0.10845608,0.084531838,-0.031673347,-0.082199631,0.039287772,-0.10496899,0.028226889,0.071417923,0.12466473,0.22531396,0.28924051,0.36331248,0.25862915,0.35941655,0.39498498,0.4278161,0.282717,0.42407291,0.37057654,0.40750969,0.42784885,0.47965445,0.5312788,0.47422328,0.4295754,0.52326995,0.52236782,0.62599489,0.78686273,0.71439145,0.50656167,0.32696404,0.14762858,0.057306,-0.041116493,-0.14194006,-0.17554867,-0.36772687,-0.60616524,-0.8050598,-0.7676793,-0.90949686,-0.81846374,-0.99326894,-0.91654913,-0.85571977,-0.75227343,-0.82424345,-0.75683663,-0.68206523,-0.6062632,-0.70016476,-0.6722939,-0.51960216,-0.44765429,-0.36902753,-0.32244944,-0.22363792,-0.29211854,-0.15139836,-0.0085015776,0.032834476,0.12051498,0.27957988,0.36726654,0.53942209,0.54021944,0.72047575,0.74727406,0.5933908,0.42817839,0.22021917,0.050349847,-0.14011951,-0.35666933,-0.47443249,-0.65030979,-0.8633558,-0.96363177,-1.1580612,-1.2850349,-1.4822225,-1.3705435,-1.2826992,-1.1773507,-1.0580367,-0.88365278,-0.91935711,-0.766029,-0.62637132,-0.72619512,-0.63875735,-0.48845371,-0.35332871,-0.20074026,-0.18091248,-0.12050534,-0.0051866486,0.10815408,0.21589611,0.39708315,0.52227215,0.55881932,0.76492069,0.82966283,1.0115361,0.98922091,0.81587496,0.65979593,0.5908714,0.47019341,0.28769258,0.14549906,0.0055528217,-0.037114479,-0.2411285,-0.43142818,-0.53374446,-0.65131235,-0.67724229,-0.87943783,-1.0063867,-1.0453479,-1.2424056,-1.4902372,-1.7039102,-1.8802,-1.9653949,-2.0637179,-2.2331113,-2.3342641,-2.4810366,-2.3269646,-2.1639987,-1.9721169,-1.796156,-1.7402546,-1.6433751,-1.4464776,-1.2695072,-1.0627222,-1.0321381,-0.87602223,-0.68846521,-0.50434065,-0.41847262,-0.27252455,-0.099816441,0.068351632,0.037367586,0.24219359,0.40966989,0.5630142,0.69897992,0.8847748,1.1061253,0.91964914,0.85007269,0.81183741,0.89906378,0.75373927,0.57355357,0.35624827,0.16859294,0.045996084,-0.15081972,-0.34943138,-0.54841375,-0.76648941,-0.80108011,-0.97502501,-1.1108262,-1.2753286,-1.4285118,-1.6082738,-1.7946964,-1.7100085,-1.7712298,-1.9857808,-1.8892393,-1.6468881,-1.4947793,-1.3717944,-1.1573706,-0.94846483,-0.94997013,-0.77331733,-0.54621885,-0.34867997,-0.10230111,0.086783389,0.025786345,0.26500524,0.42892573,0.64723946,0.82010935,0.92710068,1.1593233,1.3376643,1.3775724,1.6242977,1.8811915,2.0271927,1.9758127,1.9879071:1
1.6389457,1.5577855,1.4712384,1.3699094,1.2664122,1.1385023,1.0083638,0.8991512,0.79429503,0.697705,0.5821096,0.50752614,0.54855287,0.47356468,0.40629945,0.32934359,0.2906671,0.26252747,0.28450899,0.34127375,0.39208795,0.40332798,0.4397832,0.40241709,0.29386732,0.18975233,0.083729641,-0.014221444,-0.1085602,-0.21943544,-0.31246021,-0.41639407,-0.51776479,-0.6186055,-0.72480374,-0.82612373,-0.92270012,-1.0257566,-1.1247164,-1.2279602,-1.3336972,-1.4121994,-1.4861822,-1.5796189,-1.6806531,-1.6750595,-1.7681179,-1.8499501,-1.9203475,-1.9897488,-2.0732466,-2.138234,-2.1638908,-2.1055034,-2.0346935,-1.9625675,-1.9031417,-1.8536043,-1.7508798,-1.654821,-1.5224836,-1.4173854,-1.2866033,-1.185174,-1.1195588,-1.0348607,-0.92534629,-0.82086311,-0.73278796,-0.60816211,-0.49697361,-0.34949825,-0.2560793,-0.17934565,-0.11163746,-0.045681003,0.046739378,0.1573664,0.29317307,0.40120896,0.49322346,0.55320393,0.65302061,0.76738212,0.86071395,0.96745134,1.0864506,1.1813616,1.3005829,1.3024051,1.2316843,1.1652404,1.0925548,1.0387521,0.97246839,0.92231474,0.90126642,0.85842835,0.80391035,0.74056195,0.70159988,0.65186846,0.59198127,0.54342589,0.48841746,0.44174187,0.39678087,0.3669281,0.32599405,0.24860976,0.27233846,0.20951499,0.18649949,0.18226229,0.21085273,0.2420597,0.29498997,0.3542156,0.35953021,0.3422817,0.27480958,0.18560288,0.09587534,0.024893059,-0.052494545,-0.13850021,-0.22103832,-0.27770034,-0.35299467,-0.42633954,-0.50460022,-0.58784888,-0.6761572,-0.73286619,-0.80308758,-0.80389327,-0.80644843,-0.85078993,-0.82210173,-0.79817629,-0.70807078,-0.62600349,-0.5345454,-0.44831674,-0.50255586,-0.42535797,-0.37531912,-0.27548002,-0.16081434,-0.057219121,0.066244935,0.18909039,0.33333109,0.43531405,0.46166077,0.43074921,0.35981146,0.32661362,0.26917671,0.24184329,0.21710565,0.15264962,0.085316251,0.024729107,-0.042784881,-0.1023705,-0.13558854,-0.18100475,-0.1520154,-0.17568234,-0.16916993,-0.19229507,-0.22154744,-0.26946717,-0.29363088,-0.36105571,-0.43063113,-0.50972534,-0.56482831,-0.65601458,-0.71540539,-0.77986464,-0.86430662,-0.76743037,-0.70198109,-0.62548599,-0.55295314,-0.41509094,-0.28977851,-0.16966316,-0.026958249,0.098101903,0.20507513,0.34873135,0.49504007,0.64055462,0.7879166,0.93552239,1.0655354,1.2133979,1.3607714,1.509148,1.618544,1.7480669,1.895901,2.0451474,2.1596107,2.2937724,2.3689076,2.4274417,2.4157149,2.4039773,2.3568456,2.2612944,2.1595354,2.0419976,1.9111206,1.7913071,1.6597371,1.5431614,1.4095381,1.2642073,1.1616802,1.0330442,0.89414308,0.74678908,0.65561473,0.51045201,0.36663558,0.24460436,0.10283777,-0.018050384,-0.15753864,-0.27670799,-0.4155649,-0.53318443,-0.67059989,-0.80776567,-0.94385292,-1.0788851,-1.1903001,-1.3218706,-1.450197,-1.5675166,-1.6751668,-1.7963695,-1.8968041,-1.9654154,-1.9139673,-1.8240188,-1.7843745,-1.6702116,-1.5649632,-1.4592094,-1.4054682,-1.3471939,-1.2812457,-1.2035819,-1.1721667,-1.0946642,-1.0123113,-0.92709872,-0.8245913,-0.71721891,-0.61739806,-0.57964883,-0.52173139,-0.43087636,-0.34065154,-0.2696095,-0.21589596,-0.19691081,-0.16303331,-0.093883483,-0.03140025,0.032975453,0.11158655,0.15451445,0.16996206,0.23901258,0.31030782,0.38347942,0.45159619,0.51880698,0.57644302,0.57411725,0.46575476,0.35207692,0.24150193,0.13038231,0.049526093,-0.033736916,-0.16266014,-0.26119211,-0.36258102,-0.46880674,-0.50635378,-0.62835082,-0.63755567,-0.56191363,-0.48278822,-0.40966071,-0.33286963,-0.26209715,-0.18486093,-0.1025544,-0.020708362,0.06126077,0.14720246,0.23054063,0.32097397,0.3993679,0.47742601,0.55770651,0.63446765,0.71862107,0.79451612,0.87786248,0.91016274,0.84744613,0.76569788,0.66037187,0.60838089,0.58174006,0.58552568,0.64809673,0.69658652,0.74915374,0.84151482,0.92280746,1.0234564,1.0887344,1.1306561,1.1532868,1.2040262,1.2788734,1.3306034,1.3873501,1.4677222,1.5490948,1.6296696,1.603026,1.5016213,1.3963227,1.2962803,1.1996715,1.1020218,1.0064103,0.90606034,0.83648901,0.71642027,0.60921831,0.50401007,0.40227401,0.30741454,0.20290764,0.10782386,0.044448131,-0.061483866,-0.15615893,-0.22918792,-0.33926416,-0.44557655,-0.55198659,-0.66262763,-0.78147767,-0.88475121,-0.96838955,-1.055563,-1.1859778,-1.2867188,-1.3430317,-1.4297824,-1.4989222,-1.5945827,-1.7054592,-1.8240214,-1.898389,-1.9505319,-1.9766913,-1.9539574,-1.9146547,-1.828717,-1.7151068,-1.6089291,-1.5146693,-1.406731,-1.288317,-1.1869034,-1.0824015,-0.97833552,-0.88019815,-0.75569648,-0.64025759,-0.51095998,-0.39517351,-0.2676871,-0.16008463,-0.058352034,0.037400766,0.12943053,0.21501711,0.31951366,0.41384312,0.43569871,0.37332975,0.32031524,0.30539621,0.32021113,0.33814979,0.40613474,0.49360831,0.60032367,0.69045958,0.76064788,0.83967011,0.94481629,1.0329344,1.125372,1.1944574,1.2625534,1.315466,1.36457,1.4174626,1.4737828,1.5334803,1.5964039:5
0.99441053,0.95306092,0.97653239,0.90539081,0.8486688,0.74976973,0.63412253,0.52001295,0.4096835,0.25501725,0.14463146,0.013472839,-0.010696795,0.017445651,0.050347232,0.1265294,0.18751762,0.25556992,0.30898985,0.27312028,0.29407224,0.3693278,0.40419144,0.45796094,0.40309044,0.40001787,0.38678171,0.44384784,0.48804562,0.46181692,0.37911403,0.27763717,0.22000584,0.24872367,0.27892916,0.36964457,0.40327043,0.36492629,0.38358392,0.43942752,0.42316796,0.44873204,0.45915843,0.46624509,0.45093168,0.33624757,0.23999199,0.14517903,0.17794789,0.23962788,0.27038157,0.33418545,0.40326063,0.43024409,0.43051798,0.5069903,0.55166384,0.62922626,0.68160354,0.67850981,0.65716573,0.68591019,0.72728729,0.75238339,0.80862723,0.84529489,0.85130469,0.88181548,0.94239411,1.0026763,1.0469041,1.1077504,1.1862677,1.2263718,1.2861033,1.3127277,1.3031806,1.2409798,1.1277367,1.0240576,0.92350705,0.82209683,0.72117427,0.57087668,0.46996161,0.34201949,0.22229931,0.10835516,-0.037364785,-0.13934636,-0.27360842,-0.38186407,-0.46100568,-0.55784989,-0.68074341,-0.77057475,-0.8845762,-1.0328595,-1.1328975,-1.2477354,-1.3908365,-1.5359785,-1.6298202,-1.7390889,-1.8830041,-1.9821209,-2.0259905,-2.0971493,-2.2385366,-2.1848277,-2.1539094,-2.1900346,-2.220539,-2.1528903,-2.1435393,-2.1342257,-2.1244566,-2.0759658,-2.0261532,-1.9648203,-1.8788431,-1.8379498,-1.773078,-1.7117008,-1.6963365,-1.7111935,-1.649051,-1.5883693,-1.4917088,-1.4187936,-1.3396874,-1.2681112,-1.2193841,-1.139075,-1.056363,-0.98784786,-0.91208043,-0.81538238,-0.74699759,-0.72233364,-0.77264338,-0.90642943,-1.026686,-1.1445753,-1.251057,-1.2577052,-1.1434649,-1.04722,-0.94422881,-0.84762985,-0.74314379,-0.63976997,-0.57547246,-0.48698154,-0.36001563,-0.2571342,-0.13293943,-0.022600525,0.07828159,0.075711437,0.20355477,0.30856457,0.44442795,0.54852823,0.68449157,0.77960622,0.85716429,0.96646846,1.0743076,1.2203367,1.3245962,1.4633601,1.5779467,1.6956305,1.7968901,1.8758087,1.8277936,1.7506408,1.6557014,1.5532332,1.4433738,1.3512554,1.2406004,1.1343559,1.0367767,0.92516194,0.81521092,0.72420986,0.65064633,0.55167883,0.43155147,0.32853026,0.22506113,0.12511084,0.13336692,0.16419819,0.10199143,0.0036317767,-0.079082406,-0.17066566,-0.28096459,-0.37957345,-0.4565212,-0.55221363,-0.54698485,-0.6454626,-0.73163436,-0.82073809,-0.90434712,-0.85475374,-0.81072153,-0.7632282,-0.69378987,-0.63087273,-0.53224786,-0.51000326,-0.5724513,-0.64896411,-0.74291882,-0.8158067,-0.8944022,-0.96052692,-1.0499521,-1.0660358,-1.0665501,-1.1493977,-1.2093751,-1.3483828,-1.4407949,-1.5293416,-1.6225046,-1.7020456,-1.7760855,-1.768885,-1.6984481,-1.6847259,-1.6188132,-1.5893311,-1.6285788,-1.6957061,-1.7671579,-1.788768,-1.8715636,-1.9451196,-2.0176563,-2.1066966,-2.1640562,-2.2218958,-2.2280661,-2.196805,-2.0865671,-1.9772675,-1.873793,-1.7731341,-1.6618596,-1.5577766,-1.4545814,-1.3610683,-1.2394656,-1.1195204,-1.021362,-0.91169329,-0.81921477,-0.70595616,-0.57950969,-0.52963735,-0.48996091,-0.4101651,-0.33449958,-0.22816146,-0.1272671,-0.0054990738,0.086829674,0.20031335,0.28912328,0.39996455,0.51304932,0.59461265,0.67834955,0.78159251,0.87969177,1.0002642,1.09923,1.2045976,1.3030421,1.4201706,1.5304768,1.6362147,1.7301518,1.8428764,1.8238435,1.7804339,1.6896504,1.5919168,1.4980055,1.3965247,1.3512621,1.2763476,1.1671684,1.1150631,1.1326768,1.0341217,0.94937857,0.87823116,0.77357042,0.6857085,0.68123009,0.79474917,0.7791966,0.72262715,0.68482468,0.60546336,0.53629765,0.46425332,0.42775157,0.42375799,0.35325336,0.27741666,0.20738352,0.138701,0.083400337,0.14868017,0.22149202,0.34653193,0.35474542,0.34009372,0.31111576,0.2721029,0.27702836,0.22237743,0.14911734,0.088913884,0.087559292,0.049790971,0.015480158,-0.015601423,0.038541849,0.15169661,0.18287648,0.16819073,0.1249469,0.11055306,0.07348522,0.031890375,7.3886204E-5,-0.014403965,0.018099329,0.068256333,0.072970026,0.19201167,0.28681814,0.38092435,0.49007689,0.60396024,0.66638408,0.65426998,0.71446456,0.69540037,0.68104257,0.7438978,0.75674341,0.72492169,0.69266763,0.65462318,0.67351485,0.76203349,0.75944832,0.74087571,0.69291497,0.6781001,0.63333398,0.59463297,0.55906202,0.58878996,0.68577727,0.6936672,0.66884912,0.60735238,0.56458842,0.52893805,0.42459067,0.32370038,0.21369837,0.12914833,0.093534967,0.018309739,-0.036655417,-0.10713601,-0.15775312,-0.18828816,-0.26308559,-0.19604969,-0.15789931,-0.11807186,-0.026916177,0.10940706,0.2391468,0.30914128,0.35548725,0.43768903,0.51940192,0.56982732,0.61251347,0.60092429,0.58998253,0.60380839,0.54825791,0.5640008,0.6074024,0.6340887,0.65707607,0.61740559,0.6517913,0.68327704,0.7062645,0.71929933,0.76871658,0.70947261,0.73205948,0.79811758,0.84267878,0.89341552,0.94213585,0.91268448,0.92168876,0.92290226,0.98641835:3
1.6669247,1.6037989,1.5283944,1.4494388,1.3943584,1.3314548,1.2662258,1.2261049,1.1858449,1.0824611,1.0259344,0.95005498,0.87196209,0.85986378,0.86968197,0.91201425,0.96340078,1.0483777,1.0022913,0.87850084,0.76046086,0.63507766,0.51721128,0.39180293,0.27564583,0.15285462,0.033607904,-0.081347981,-0.20528592,-0.31954573,-0.43656693,-0.55374272,-0.66237387,-0.78452237,-0.89159187,-1.0022792,-1.1195158,-1.2243429,-1.3268934,-1.4287645,-1.5054284,-1.4506891,-1.3314607,-1.3155873,-1.2915438,-1.1818384,-1.0744576,-0.95913174,-0.84975905,-0.73562956,-0.62254015,-0.51321537,-0.40314879,-0.29655674,-0.18814012,-0.11024628,-0.066727404,0.018799639,0.12234375,0.23584964,0.34777868,0.38529968,0.36934455,0.41913236,0.52257373,0.65424364,0.76025492,0.8744976,0.97033094,1.0214066,1.1257255,1.2347577,1.2921895,1.375259,1.4879402,1.5883356,1.5983394,1.4870063,1.3807867,1.2809365,1.180727,1.0787217,1.0174928,0.98553425,0.91525797,0.85660511,0.75230189,0.67680672,0.61791598,0.63679377,0.71240419,0.78412221,0.87331217,0.87987277,0.79628452,0.68638905,0.59040799,0.52185616,0.45237793,0.3857272,0.27741332,0.18870182,0.10072328,-0.024917274,-0.11657786,-0.17699409,-0.26014941,-0.33797254,-0.42646898,-0.53867893,-0.61648058,-0.66128266,-0.69561534,-0.69895711,-0.7459312,-0.67019833,-0.56665259,-0.49552056,-0.4125443,-0.29668034,-0.19102523,-0.074457313,0.025988705,0.14490577,0.25433467,0.34970846,0.42392228,0.49183719,0.5761232,0.60940105,0.69725598,0.80825776,0.87883733,0.97046937,1.0863799,1.1967667,1.3051784,1.2842563,1.2046305,1.1049084,1.0080043,0.91718772,0.8327125,0.76088668,0.70329928,0.61204244,0.521613,0.45956108,0.47200229,0.39048751,0.29092266,0.18905758,0.092670557,-0.013494506,-0.084630895,-0.13652683,-0.10550442,-0.048141201,-0.063838045,-0.15177332,-0.2382401,-0.32734309,-0.41614072,-0.49216984,-0.57788539,-0.66715188,-0.74928806,-0.8089974,-0.86115643,-0.94115516,-1.0166596,-1.0058524,-0.93005652,-0.88097903,-0.91342778,-0.96788061,-1.0284671,-1.0988073,-1.1846196,-1.2654361,-1.316,-1.2601152,-1.2601542,-1.1563327,-1.0284207,-0.89071732,-0.76046025,-0.63238602,-0.50133905,-0.3748493,-0.30613725,-0.20051751,-0.071923592,0.055935683,0.19633452,0.32474205,0.44834049,0.54798443,0.68887131,0.82276039,0.96014335,1.1117709,1.2242977,1.3641373,1.5045381,1.6322604,1.7751806,1.8864917,2.0264434,2.1452853,2.2380498,2.1895338,2.1403528,2.0101009,1.8921683,1.762476,1.6332293,1.4929892,1.3641794,1.2264186,1.0870605,0.94817149,0.80937879,0.67009523,0.54358942,0.40553148,0.26806575,0.13867583,-8.6548469E-4,-0.12725441,-0.25489508,-0.38262403,-0.51286231,-0.6410125,-0.77476443,-0.90129695,-1.0303019,-1.1550625,-1.2874464,-1.4193694,-1.5495922,-1.650189,-1.6744254,-1.5847999,-1.5301226,-1.4185769,-1.3357961,-1.2357602,-1.1308207,-1.0372717,-0.93262486,-0.84651532,-0.74019305,-0.65505359,-0.5610623,-0.44524184,-0.39223076,-0.41136175,-0.37884319,-0.27133635,-0.15901869,-0.025301274,0.022977283,0.10353335,0.20725235,0.31180226,0.38675016,0.43116707,0.47355489,0.51576301,0.58224229,0.64277819,0.70374206,0.78575198,0.86232777,0.9246413,0.98063062,0.89203247,0.77845027,0.66051654,0.53245893,0.41061799,0.3102388,0.19295223,0.079059698,-0.025949939,-0.1188634,-0.23639211,-0.33765526,-0.454421,-0.5682988,-0.70516049,-0.81530904,-0.90752879,-1.0268012,-1.0824495,-1.14399,-1.2168647,-1.2890276,-1.3391299,-1.3819491,-1.3929951,-1.37415,-1.3284547,-1.3048932,-1.2792222,-1.2233567,-1.1726377,-1.1191703,-1.0736876,-0.9874935,-0.89033779,-0.80981885,-0.77194786,-0.66082671,-0.59507047,-0.49462132,-0.40621715,-0.29830139,-0.20409828,-0.1092566,-0.024694625,0.075686529,0.17509345,0.26717463,0.36141381,0.45035089,0.52152112,0.58815479,0.66305507,0.71711711,0.78242475,0.84653517,0.95312203,1.0620946,1.172907,1.2828187,1.4052925,1.5157952,1.5281317,1.4516863,1.3609779,1.2931661,1.1943068,1.1163265,1.0428199,0.94944393,0.83712062,0.73261269,0.66153455,0.65026986,0.56242869,0.49292822,0.3937742,0.28385587,0.17807404,0.069815251,-0.036701429,-0.14876993,-0.25584798,-0.36420809,-0.46777011,-0.58145485,-0.68972921,-0.80766221,-0.91598629,-1.0306672,-1.1306588,-1.23677,-1.3478191,-1.4494062,-1.5397241,-1.6487636,-1.7635936,-1.8676101,-1.9265936,-1.9482921,-1.9698086,-1.9458006,-2.0540951,-2.1513755,-2.2640298,-2.3662022,-2.3394015,-2.2463666,-2.2227379,-2.1765256,-2.0671267,-1.9702135,-1.8474295,-1.7418005,-1.6293553,-1.5709514,-1.4728804,-1.3643422,-1.2330181,-1.1155432,-0.96708063,-0.85657271,-0.73362233,-0.60650253,-0.47618683,-0.35675374,-0.22913293,-0.077980228,0.072692716,0.22260601,0.37208645,0.48840605,0.59471083,0.64709269,0.55402128,0.47348292,0.40706787,0.43067822,0.48899707,0.60049375,0.71153118,0.80131526,0.8870441,0.91109961,1.01729,1.1296755,1.2391129,1.3472831,1.4625741,1.6165959:5
2.9179543,2.8959398,2.8060923,2.648506,2.5249728,2.407028,2.2959037,2.1889639,2.058666,1.9247064,1.7900833,1.665434,1.5291061,1.3990883,1.2699238,1.1384854,1.0104046,0.87476658,0.75056439,0.65095825,0.50230464,0.35959596,0.25687373,0.11789467,-0.012474675,-0.1424828,-0.27359222,-0.38082531,-0.53113632,-0.66182816,-0.79216186,-0.89850571,-1.0659815,-1.1752495,-1.1612184,-1.1407804,-1.0492254,-0.96267102,-0.86012128,-0.73996804,-0.64249266,-0.58400773,-0.48914736,-0.40405171,-0.33867899,-0.28175567,-0.31257641,-0.25631066,-0.12515381,-0.030404672,-0.022646859,-0.01230588,0.02709635,0.031455768,0.028737007,3.2551283E-4,0.024586888,0.06342863,0.093935929,0.12054527,0.10386555,0.058599035,0.074179581,0.069310506,-0.011096502,-0.1224264,-0.23326084,-0.33578811,-0.45825848,-0.53784253,-0.55360132,-0.55375026,-0.51991822,-0.48878076,-0.44403399,-0.44683984,-0.42929552,-0.46285737,-0.53991227,-0.49939596,-0.46526733,-0.42072341,-0.40604652,-0.36065716,-0.35653024,-0.32406872,-0.29511945,-0.30805898,-0.3860332,-0.48975136,-0.50749111,-0.4968688,-0.4387944,-0.35142831,-0.282113,-0.18068939,-0.16941146,-0.092839098,-0.0023020032,0.053338378,0.075782908,0.023514645,0.019423302,0.08710231,0.16391813,0.27407321,0.36007262,0.48413164,0.52191114,0.51186749,0.61178351,0.68017037,0.79001582,0.9250074,1.0562368,1.1874919,1.3071242,1.3348107,1.2629367,1.1266759,1.0182811,0.89031627,0.7623818,0.64268609,0.51449075,0.38173007,0.26160027,0.14931972,0.027698175,-0.11129472,-0.2186388,-0.338987,-0.46567737,-0.60151913,-0.66228794,-0.74610891,-0.8559239,-0.97676885,-1.1252352,-1.2450213,-1.3573591,-1.4971442,-1.6306708,-1.7405012,-1.8744455,-1.920481,-1.8899822,-1.8465356,-1.7637741,-1.6979218,-1.6170907,-1.5280607,-1.4396563,-1.3746413,-1.2700288,-1.1689543,-1.0496093,-0.98304987,-0.93357682,-0.96593928,-0.82434312,-0.71844546,-0.6101788,-0.50440536,-0.39538136,-0.28757417,-0.21249043,-0.18246119,-0.068902997,-0.015831239,0.057049294,0.1609134,0.22733117,0.3154959,0.32388031,0.24997316,0.15197579,0.062827155,-0.021351851,-0.086959005,-0.10912767,0.019563358,0.10006369,0.2096262,0.28488344,0.38449428,0.50188793,0.58698457,0.69579128,0.81126516,0.87884631,0.94999029,1.0844621,1.168739,1.3058848,1.4198902,1.5242779,1.6139548,1.7034613,1.8081685,1.9353592,2.0538292,2.1691788,2.3032568,2.3915187,2.3973872,2.2989599,2.1386258,1.9728259,1.8498465,1.7206807,1.5570503,1.4446249,1.3379504,1.1889059,1.1214049,1.0993689,0.93765446,0.8188978,0.66167322,0.53559853,0.52492172,0.4425719,0.28567238,0.15428807,-3.0755612E-4,0.011091509,0.11938269,0.22894713,0.26843427,0.35183731,0.3565447,0.29247827,0.15633057,0.047627476,-0.038920545,-0.14783887,-0.28352866,-0.35102395,-0.38426845,-0.48280798,-0.601882,-0.72484572,-0.84905127,-0.98140914,-1.0964753,-1.2094006,-1.2496488,-1.1262272,-1.1570875,-1.2813219,-1.3744985,-1.4789595,-1.585093,-1.6837928,-1.7726287,-1.869261,-1.959416,-2.0326012,-2.0774746,-1.9392844,-1.7909094,-1.6668223,-1.5596378,-1.4020106,-1.2579037,-1.1310421,-0.96351721,-0.80066664,-0.63969029,-0.51057674,-0.41438575,-0.28330105,-0.1537934,0.01183491,0.14107524,0.2693996,0.40061842,0.53523073,0.66227538,0.78739937,0.9568979,1.115362,1.1508647,1.0728213,0.98663122,0.89979357,0.78671496,0.70515074,0.62845525,0.54331147,0.44341335,0.3396325,0.31354004,0.24638898,0.13426551,0.059122839,-0.032513513,-0.096797995,-0.061240477,0.022965146,0.0079842717,-0.046467836,-0.1278286,-0.21026939,-0.28308032,-0.28432153,-0.35508153,-0.41501008,-0.48167038,-0.53427816,-0.58186434,-0.56020959,-0.44076349,-0.32520599,-0.22514063,-0.22667495,-0.26096335,-0.34004337,-0.37215404,-0.3975019,-0.4713473,-0.4849758,-0.53426866,-0.58140819,-0.63441891,-0.68549751,-0.73139393,-0.75791283,-0.68335639,-0.55013216,-0.5594858,-0.59748299,-0.65797111,-0.76386856,-0.81744011,-0.84036679,-0.93089552,-0.97287938,-1.0021371,-0.99629976,-0.88827428,-0.76011121,-0.64255446,-0.52327451,-0.40769321,-0.33488302,-0.29402717,-0.26796832,-0.25158537,-0.23872573,-0.2250727,-0.12930289,-0.083549892,-0.07065961,-0.11065169,-0.11746326,-0.12478285,-0.13489461,-0.072510575,-0.051934967,-0.058638541,-0.10923931,-0.11720623,-0.12296857,-0.14327233,-0.21880619,-0.23108317,-0.11571365,-0.085920368,-0.021586149,-0.046150303,-0.092908812,-0.13527415,-0.18534886,-0.24866902,-0.16666831,-0.22769089,-0.30770164,-0.37084503,-0.49068719,-0.56032797,-0.66403257,-0.74205767,-0.81350103,-0.89206518,-0.95368367,-1.0267601,-1.0995717,-1.1691807,-1.1965917,-1.2553062,-1.2676984,-1.273278,-1.1436811,-1.0256089,-0.91408502,-0.78066789,-0.64839873,-0.51056886,-0.38473686,-0.25292157,-0.11729348,0.0089990103,0.13083122,0.24246114,0.36516816,0.4966775,0.62698609,0.75939848,0.8894314,1.0213813,1.1515516,1.2816066,1.4184759,1.5507785,1.6836377,1.8123557,1.9377653,2.0462119,2.1672944,2.3058656,2.4219179,2.5375654,2.6705531,2.7896445,2.897303:3
1.841267,1.7985852,1.7518601,1.7209728,1.6689821,1.6315918,1.5865826,1.5241903,1.4610086,1.4144026,1.3557442,1.3026266,1.2246568,1.1676344,1.1081873,1.0293814,0.94395774,0.86880102,0.7715267,0.67870492,0.59758331,0.50161812,0.39777625,0.32970625,0.20416599,0.10423243,-0.0045145813,-0.098596834,-0.18296647,-0.089087275,0.028362639,0.1232787,0.23902736,0.36230501,0.45897492,0.57076259,0.68344274,0.79210722,0.90280914,1.0058199,1.1075672,1.2204944,1.32869,1.4303993,1.5204479,1.6317573,1.7281007,1.8256878,1.9016484,2.0089681,2.0967581,2.1462917,2.1906419,2.1718659,2.1632972,2.1197779,2.0752308,2.0403636,1.973803,1.9008454,1.8309208,1.7185773,1.6038014,1.5018882,1.4167528,1.3333683,1.2131612,1.0883218,0.98782643,0.87420219,0.7652627,0.6575093,0.54878637,0.43320984,0.33219411,0.21763192,0.1127395,0.0095717738,-0.091584693,-0.18651865,-0.30627896,-0.4156055,-0.51920978,-0.64121283,-0.72561584,-0.77536231,-0.88108297,-1.0108561,-1.1240293,-1.2269885,-1.3338597,-1.4508061,-1.5754447,-1.7087238,-1.8483501,-1.9343069,-2.0654814,-2.2001893,-2.294254,-2.3898792,-2.4126684,-2.2965216,-2.2610485,-2.0939641,-1.9700774,-1.8418393,-1.6714273,-1.5882705,-1.4166185,-1.2471694,-1.1476594,-1.0570851,-0.98866254,-0.81458118,-0.64841165,-0.53686634,-0.40651384,-0.30710426,-0.24957787,-0.12233551,-0.006738999,0.1603498,0.25769254,0.34271363,0.41951424,0.52096197,0.64469551,0.76000275,0.86168422,0.98510195,1.0590344,1.1308171,1.2047181,1.2631854,1.2759883,1.2802398,1.252018,1.2261939,1.1922788,1.1464281,1.0823594,1.036981,0.96507803,0.90565203,0.8356385,0.77455329,0.70479121,0.62304875,0.55015061,0.49001353,0.43405705,0.37094261,0.28523512,0.24944728,0.17374103,0.10022061,0.0064365815,-0.073980748,-0.16377323,-0.27415325,-0.38010135,-0.47640648,-0.59610109,-0.69023683,-0.8108798,-0.77506602,-0.68661453,-0.61956504,-0.53417068,-0.46793125,-0.41251549,-0.37758549,-0.35244009,-0.36016792,-0.32853669,-0.34009219,-0.35336451,-0.33925763,-0.35503047,-0.42645061,-0.4891529,-0.5601724,-0.66836331,-0.75523959,-0.86928507,-0.94682984,-0.9211126,-1.0291552,-0.96053915,-1.0343097,-0.96686598,-0.8846672,-0.77646362,-0.70938071,-0.62966177,-0.57367398,-0.49358881,-0.44106828,-0.37094797,-0.32769929,-0.25562976,-0.2268352,-0.19930471,-0.18584485,-0.18010049,-0.18745998,-0.20818662,-0.16188571,-0.053461955,0.061713365,0.16669072,0.27452859,0.37708,0.48547473,0.52612107,0.59350444,0.63278976,0.55715307,0.56760049,0.55471664,0.47965545,0.52046453,0.47860055,0.41858444,0.37871517,0.35917376,0.32163756,0.28215909,0.25299091,0.20711642,0.17959841,0.15151515,0.13815394,0.13499001,0.12525676,0.1142317,0.11251193,0.1114814,0.1127102,0.11789578,0.13161505,0.13645115,0.15535918,0.17396699,0.19251472,0.19756592,0.21635202,0.25152751,0.27196811,0.29548246,0.33494138,0.36599786,0.38214971,0.4190266,0.45420979,0.49287166,0.48845309,0.39041855,0.34382249,0.31345179,0.2588374,0.20776072,0.18964649,0.13711964,0.13136229,0.10530317,0.078921094,0.068498276,0.047920168,0.0044125153,0.0019544538,-0.026580427,-0.020595103,-0.084017948,-0.073840602,-0.09262778,-0.11659903,-0.10245233,-0.083454824,-0.038114541,-0.048756257,-0.023780852,-0.0066015623,0.024399474,0.026802839,0.058294726,0.079588051,0.056031264,-0.03246415,-0.1290897,-0.23390215,-0.33567179,-0.41645917,-0.43605329,-0.49020374,-0.53499262,-0.56486638,-0.5763565,-0.58351541,-0.5901737,-0.56946196,-0.53469986,-0.50416728,-0.45414807,-0.42108136,-0.39048899,-0.38087663,-0.36081112,-0.35822325,-0.35738715,-0.37789155,-0.37787369,-0.37090562,-0.40519384,-0.47101266,-0.59276715,-0.6935595,-0.82881421,-0.93396894,-1.0713664,-1.1972569,-1.2083967,-1.1530991,-1.0426796,-0.94533952,-0.86062318,-0.76920737,-0.69238572,-0.60530794,-0.54758266,-0.47410601,-0.39121514,-0.32569736,-0.26387594,-0.21022409,-0.15153083,-0.072543549,-0.0016786784,0.044849517,0.099484452,0.15340963,0.20193732,0.25837239,0.29942706,0.32962863,0.34415793,0.37438692,0.37754688,0.35399066,0.29367042,0.1798695,0.071603457,-0.047104822,-0.16420458,-0.30105621,-0.40231188,-0.51097807,-0.64244438,-0.74873179,-0.87736261,-1.0408615,-1.1557591,-1.2586858,-1.3149988,-1.4485427,-1.6164713,-1.7381204,-1.8489055,-1.9747175,-2.0374822,-2.0381469,-2.1364504,-2.2715869,-2.3552068,-2.3782895,-2.3069798,-2.2178578,-2.1222897,-2.0041036,-1.9034138,-1.8002797,-1.6952125,-1.5918232,-1.4848364,-1.3665962,-1.2536401,-1.1389882,-1.0428429,-0.9139592,-0.80897274,-0.68304094,-0.56374483,-0.46403211,-0.39370952,-0.33350895,-0.27887883,-0.23597264,-0.19392264,-0.15776469,-0.14072259,-0.12009992,-0.12772502,-0.11900807,-0.027457211,0.11594662,0.20547441,0.29311118,0.36241722,0.40395362,0.56812378,0.69775158,0.82189398,0.94901568,1.1040803,1.2489344,1.3703949,1.5387808,1.6965393,1.7957114,1.8907317,1.9258958,1.9711005,1.9827801,1.9815003,1.9372656,1.8970384,1.862123:2
2.3890872,2.2821991,2.1918515,2.0953484,1.993895,1.8923624,1.8029646,1.7072664,1.608597,1.5114312,1.4121042,1.318689,1.2210989,1.1869181,1.1993637,1.2242733,1.2474915,1.2539765,1.2562084,1.2469437,1.2253467,1.1987923,1.1685477,1.139558,1.0982286,1.0376296,0.95802804,0.88474081,0.80837276,0.72612945,0.65146982,0.61252504,0.56746817,0.51378798,0.49237278,0.47082004,0.4654547,0.47322877,0.48582269,0.46941264,0.41368154,0.41666573,0.45341302,0.51510874,0.56329115,0.57595241,0.50228576,0.41418428,0.31346714,0.21844687,0.13574649,0.043517647,-0.033849035,-0.10659764,-0.18039637,-0.25487497,-0.32993543,-0.42606149,-0.51859769,-0.61525817,-0.69510374,-0.78637859,-0.85710728,-0.91356083,-0.93586413,-0.93988722,-0.94738739,-0.94452171,-0.93311993,-0.91255545,-0.89072693,-0.87241382,-0.85859086,-0.85122572,-0.84453825,-0.82925422,-0.78348714,-0.73853856,-0.69540152,-0.65909607,-0.59230052,-0.52057216,-0.44241149,-0.3657851,-0.2791319,-0.19586657,-0.20635499,-0.29065058,-0.26219027,-0.18555571,-0.085326517,-0.0031104813,0.091721098,0.19265004,0.27935273,0.31314554,0.24975378,0.20906322,0.11743417,0.017378442,-0.076553729,-0.17123593,-0.2707381,-0.36794334,-0.43864975,-0.48965856,-0.58454498,-0.67949514,-0.77490728,-0.86870989,-0.96577189,-1.0585501,-1.1554241,-1.2509297,-1.3464242,-1.439499,-1.5305642,-1.6299697,-1.7258451,-1.813092,-1.9124888,-2.0110282,-2.1017244,-2.2022953,-2.2634983,-2.294852,-2.2992166,-2.2944294,-2.2740726,-2.2381628,-2.1765902,-2.0823168,-1.9873456,-1.8884343,-1.7629046,-1.6614572,-1.560069,-1.432973,-1.3489721,-1.2555833,-1.1532759,-1.0418449,-0.9154582,-0.80433848,-0.67501604,-0.5457622,-0.4342653,-0.3009605,-0.21726116,-0.19793291,-0.24749733,-0.22982484,-0.13350763,-0.024172708,0.089043543,0.22013744,0.3213564,0.41480125,0.4284062,0.50837901,0.46859108,0.56928605,0.68090564,0.61234649,0.57916708,0.44666412,0.31374577,0.25415638,0.21427323,0.1108525,0.032306584,-0.064517544,-0.14210156,-0.21297012,-0.26956621,-0.32440438,-0.36670573,-0.35647357,-0.29571449,-0.22121331,-0.14250432,-0.059026218,0.034932979,0.12423385,0.21234155,0.31274877,0.41084851,0.50906373,0.59027241,0.68396199,0.77516628,0.87449411,0.96316382,1.0524922,1.1510033,1.2448085,1.3408056,1.2996657,1.2017026,1.0937872,1.035083,1.0769114,1.1722201,1.2709498,1.3837719,1.4861239,1.5162519,1.4973612,1.3789402,1.2784513,1.1560011,1.0546312,1.0225056,1.0901931,1.1782808,1.2381455,1.1442459,1.034319,0.94612891,0.8428608,0.73864974,0.63348662,0.52999847,0.42751101,0.32993452,0.23092876,0.12777682,0.038816308,0.010800503,0.0048426485,0.021635043,0.062554825,0.12233405,0.18815867,0.2593846,0.34357912,0.42264408,0.53684844,0.64217002,0.73735668,0.84608984,0.93597285,1.0321884,1.056504,0.96612144,0.87485495,0.77802834,0.69603455,0.59862677,0.50357436,0.41408216,0.34142159,0.34957913,0.42899944,0.54946062,0.48963544,0.37118828,0.28073472,0.18235011,0.08062678,-0.016592299,-0.11609567,-0.21172637,-0.30459895,-0.39021897,-0.48885117,-0.58479732,-0.69108156,-0.78233367,-0.8837872,-0.9777107,-1.0703493,-1.1631726,-1.2454722,-1.3391019,-1.4257093,-1.5181569,-1.604314,-1.6841426,-1.7636816,-1.8406993,-1.9043089,-1.9597535,-2.0014025,-2.0194344,-2.0059794,-1.9748436,-1.9219858,-1.8554226,-1.7760381,-1.6815291,-1.5856489,-1.4701931,-1.3782934,-1.2636498,-1.1713219,-1.061195,-0.96029002,-0.86535976,-0.75257693,-0.64150951,-0.54330686,-0.43351325,-0.3218597,-0.20959055,-0.18229697,-0.13970044,-0.031006502,0.096042805,0.22233853,0.34733437,0.47170181,0.54592334,0.47207683,0.40347922,0.34393978,0.28092641,0.19174449,0.10433206,0.044713148,-0.031406248,-0.087075967,-0.14972681,-0.17904611,-0.14030901,-0.04232777,0.060580686,-0.042652008,-0.14832135,-0.23146266,-0.33583338,-0.44533984,-0.54470056,-0.61099958,-0.6761307,-0.75055808,-0.81808857,-0.87287314,-0.91910811,-0.97043603,-1.0186261,-1.0586587,-1.0907202,-1.1277557,-1.168057,-1.2128516,-1.2350043,-1.2397608,-1.2364105,-1.2370899,-1.227844,-1.2080872,-1.1691831,-1.1251333,-1.0530101,-0.96572677,-0.85960773,-0.75041427,-0.6465695,-0.56212373,-0.4882042,-0.41275375,-0.3259603,-0.25442308,-0.17597781,-0.0942788,-0.02066252,0.050794229,0.11539169,0.18277416,0.24699824,0.31308203,0.37306291,0.44424592,0.50711959,0.58606856,0.5650204,0.51015675,0.45472638,0.41086476,0.38191744,0.35647493,0.36246986,0.41596956,0.52298401,0.58264474,0.55257048,0.52843315,0.50783,0.49714004,0.5111686,0.52832109,0.5498144,0.57678578,0.58965152,0.59855664,0.63355225,0.67384026,0.72409289,0.77416545,0.82259881,0.87838191,0.93582589,1.0019907,1.0581531,1.1114322,1.1386349,1.1616546,1.170517,1.1725004,1.1675432,1.1674049,1.1580618,1.1727434,1.2617902,1.3526575,1.417538,1.475116,1.5627863,1.6674004,1.7564415,1.8538492,1.9399549,2.0429223,2.142047,2.2372289,2.326881:4
1.78752,1.7250917,1.6744965,1.5848924,1.5767432,1.508323,1.4585981,1.3975097,1.3431883,1.2180752,1.1574005,1.0713913,1.0897499,1.0479157,0.95335753,0.90492169,0.7829883,0.6978728,0.64792788,0.5794467,0.6134033,0.55562101,0.47937985,0.3813758,0.29414596,0.26130772,0.264926,0.18811443,0.13079305,0.086369668,0.037095633,0.039093366,-0.095427571,0.043497335,0.21799643,0.37244256,0.47227433,0.56059223,0.72177627,0.92191003,0.91006521,0.82076415,0.73478153,0.67574067,0.63866486,0.51389184,0.38393163,0.30352764,0.37411378,0.44488203,0.36411973,0.24550003,0.16301839,0.13439335,0.065324854,-0.029492062,-0.11013557,-0.20194464,-0.23687394,-0.32205831,-0.40657352,-0.48892277,-0.56736667,-0.63645326,-0.58404162,-0.50524563,-0.53591315,-0.5824817,-0.63645326,-0.70643893,-0.7600618,-0.83188057,-0.89918834,-1.013896,-1.0627498,-1.1819918,-1.193632,-1.2654775,-1.2927874,-1.342607,-1.4377576,-1.5890894,-1.7187854,-1.926537,-1.8172202,-1.8548868,-1.7281625,-1.5810192,-1.5388141,-1.4253078,-1.2402909,-1.1129531,-1.0252114,-0.85957797,-0.7026044,-0.53588952,-0.38294468,-0.22145872,-0.051637559,0.10938922,0.27719752,0.40774592,0.56705176,0.7368096,0.84834057,0.97199498,1.1440385,1.311746,1.4626982,1.5590849,1.7491707,1.9153602,2.047798,2.1829488,2.2564623,2.3822961,2.4275187,2.3583483,2.2557104,2.0913137,1.9235428,1.7597536,1.5994785,1.4303421,1.2693618,1.1136793,0.94290595,0.77788053,0.60554214,0.4445108,0.30286533,0.13172907,-0.035833096,-0.19827155,-0.34925623,-0.52008587,-0.68728592,-0.84252765,-1.0081797,-1.1531434,-1.3203837,-1.4870094,-1.65561,-1.8202974,-1.8645278,-1.7829417,-1.6733337,-1.8236444,-1.7300484,-1.7518544,-1.6700951,-1.5862429,-1.567035,-1.4542295,-1.4674722,-1.3674001,-1.3273504,-1.3250518,-1.1952491,-1.1121281,-0.98028067,-0.9084297,-0.90043596,-0.84127204,-0.71511346,-0.64445375,-0.62713518,-0.53204976,-0.53060759,-0.35601291,-0.27643619,-0.14654803,0.011400211,0.15720374,0.28877849,0.33827542,0.19956493,0.028492309,-0.097886859,-0.24761586,-0.28398588,-0.40281004,-0.30061703,-0.17478335,-0.16015244,-0.19047454,-0.069438634,-0.031591346,0.094291987,0.010241464,0.10225106,0.12747691,0.17962714,0.30076329,0.43214168,0.3608516,0.44355963,0.55177738,0.57703089,0.39680833,0.22275442,0.056431955,-0.12262615,-0.27134655,-0.50112519,-0.7106181,-0.77798664,-0.81835715,-0.97619052,-0.85114778,-0.82223364,-0.80528067,-0.73374856,-0.63344582,-0.51423288,-0.43742645,-0.47367244,-0.52206889,-0.51864486,-0.39387116,-0.29247072,-0.24715143,-0.19319888,-0.12570836,-0.018692869,0.056085284,0.19281753,0.26871237,0.37526876,0.48421215,0.55036711,0.63817031,0.71244331,0.71417195,0.8506342,0.95233817,1.0890312,1.1959367,1.2965868,1.4124451,1.4898855,1.3087072,1.1613779,0.99284196,0.84102281,0.64323121,0.50053138,0.41685904,0.26494179,0.10290692,-0.06802242,-0.16553598,-0.27988743,-0.44073748,-0.59202014,-0.76015733,-0.91525303,-1.1124751,-1.1809023,-1.307016,-1.472602,-1.6481878,-1.8188793,-1.900755,-1.7543978,-1.6767743,-1.7188977,-1.590327,-1.4805397,-1.3628657,-1.2497424,-1.0352669,-0.90128298,-0.75966549,-0.64620244,-0.72992618,-0.64857916,-0.49676709,-0.34710833,-0.24610172,-0.25914882,-0.11215448,0.011805314,0.11646465,0.21944275,0.28616272,0.24664534,0.41196587,0.54543334,0.68472568,0.72129467,0.72371502,0.89440888,1.035883,1.0589421,1.2135148,1.3182296,1.4451278,1.4689316,1.3370956,1.1077057,0.93969962,0.8029195,0.83505646,0.68132404,0.51595515,0.35793604,0.18313897,0.13112452,-0.050981973,-0.21008358,-0.36931613,-0.45343429,-0.60563347,-0.8225792,-0.97470737,-1.1803236,-1.2952654,-1.1260934,-0.98690555,-0.85005669,-0.71637789,-0.61060129,-0.47080391,-0.32611059,-0.1886308,-0.25319725,-0.11268253,0.036791854,0.14329191,0.14485965,0.28844346,0.42649754,0.58300988,0.48954753,0.28781438,0.13243483,-0.076788625,-0.17324512,-0.15490704,-0.33565309,-0.49479001,-0.68266904,-0.62605408,-0.75911738,-0.91843164,-0.990282,-1.1475795,-1.2993742,-1.3721426,-1.5336588,-1.6843992,-1.8220331,-1.9204407,-2.0297733,-2.0471918,-1.8968425,-1.7116517,-1.5556163,-1.4731811,-1.2863752,-1.0975302,-0.92181562,-0.7363775,-0.57460291,-0.38894293,-0.19752297,0.011696158,0.14733816,0.14556159,0.25034321,0.43575898,0.61596035,0.7910751,0.9666696,0.97991607,1.1107642,1.2946099,1.4262583,1.6022385,1.8226,1.9947144,2.0829903,1.9740236,1.8599173,1.7066407,1.5909833,1.4799665,1.365055,1.2308791,1.2059931,1.1273773,1.1107585,1.0556326,0.95497966,0.87559449,0.78146145,0.69648602,0.5921949,0.50204348,0.46165332,0.322567,0.25467092,0.17459383,0.062355156,0.041892634,-0.049721243,-0.053820007,-0.15605707,-0.2613589,-0.35722252,-0.45700191,-0.51801936,-0.35394626,-0.15356678,0.0056390652,0.18126357,0.32146531,0.50355676,0.6818836,0.82815056,0.85945152,0.99024026,1.2201662,1.4069376,1.6310391,1.8063181:1
2.5668657,2.4786733,2.403174,2.3250262,2.2422631,2.1710778,2.1056737,2.019146,1.9526229,1.8877309,1.8228895,1.7577685,1.6698533,1.5815988,1.4930904,1.404692,1.3163885,1.2506833,1.1622363,1.0737129,0.99603361,0.91982255,0.83150314,0.76628378,0.67849763,0.59054206,0.52561763,0.46151532,0.40843205,0.35768304,0.31822129,0.27171151,0.23662614,0.19838962,0.22794323,0.19093781,0.17054218,0.14373005,0.11766792,0.082097386,0.032781792,-0.0082569658,-0.075957617,-0.13837756,-0.1977386,-0.28216955,-0.32472442,-0.38797762,-0.46497233,-0.52968926,-0.54432202,-0.55327858,-0.56039962,-0.55553641,-0.55981184,-0.57198325,-0.57357681,-0.59396778,-0.61258658,-0.63757168,-0.65970056,-0.68210967,-0.71356131,-0.73019875,-0.77069823,-0.82543252,-0.86410023,-0.92366115,-0.99503898,-1.0527509,-1.1172748,-1.1712005,-1.2434896,-1.3082816,-1.3692714,-1.4065691,-1.4314139,-1.4345272,-1.4326836,-1.4245084,-1.4105745,-1.4003514,-1.3966745,-1.3839017,-1.3631009,-1.3566149,-1.3230879,-1.3115246,-1.2920189,-1.2748711,-1.2559512,-1.2313537,-1.1962988,-1.1582031,-1.120079,-1.0709905,-1.0317407,-0.97884239,-0.93417043,-0.89093807,-0.84848197,-0.81578388,-0.77280543,-0.7419665,-0.70449923,-0.66098757,-0.62392252,-0.58697844,-0.54895448,-0.50088956,-0.4577146,-0.41984041,-0.37495873,-0.33319397,-0.2914807,-0.24598457,-0.20276268,-0.16290079,-0.11656191,-0.07782133,-0.048634649,-0.019306901,0.0053498727,0.011968854,0.0020105865,-0.015133024,-0.033318772,-0.061811529,-0.090349571,-0.11385622,-0.15015625,-0.19136599,-0.23053396,-0.28790221,-0.35204387,-0.39337314,-0.45721334,-0.49980637,-0.54050753,-0.58295053,-0.63402845,-0.69489268,-0.74620552,-0.81526936,-0.87501855,-0.93038024,-0.95861998,-1.0224024,-1.0572028,-1.0883516,-1.0620277,-0.99575601,-0.93907831,-0.87287942,-0.81115056,-0.7503099,-0.68304852,-0.62357741,-0.56637351,-0.49310989,-0.43563938,-0.36913158,-0.29965498,-0.2282923,-0.16350281,-0.093652928,-0.027787481,0.036319964,0.10511046,0.18658269,0.24660552,0.3278881,0.40697824,0.48459385,0.55930404,0.61311955,0.66828049,0.73228363,0.78635569,0.83750348,0.87987384,0.91990225,0.96209293,0.99195728,1.0263003,1.0544991,1.0788852,1.0997863,1.1212194,1.1188637,1.0971967,1.1052418,1.1038718,1.0848012,1.061735,1.088369,1.1284169,1.1890447,1.2502247,1.3035924,1.3465546,1.3882162,1.4234576,1.4589562,1.4906103,1.5010649,1.4859686,1.4543324,1.410583,1.365451,1.3198521,1.2696719,1.22178,1.1722691,1.1083741,1.0449479,1.0401465,1.0778442,1.1247696,1.1698399,1.2155477,1.2519604,1.28728,1.3146076,1.3467574,1.3573121,1.368381,1.3720492,1.3810267,1.3668086,1.3368895,1.3034881,1.2584271,1.2094349,1.1304658,1.0914777,1.0416203,0.9850234,0.92688456,0.85443054,0.78783194,0.72365386,0.6481302,0.59214387,0.51247857,0.4517062,0.36951504,0.29696664,0.22028583,0.13374664,0.067962613,-0.011144962,-0.08313095,-0.16821589,-0.23254931,-0.31643757,-0.38438422,-0.45599768,-0.53650828,-0.60115655,-0.68633696,-0.74921151,-0.80403566,-0.85463628,-0.92462392,-0.97680015,-1.0442087,-1.0823807,-1.0766477,-1.0334029,-0.96567347,-0.90766461,-0.85320122,-0.79525305,-0.73329261,-0.67445436,-0.61429913,-0.55239975,-0.49139265,-0.42893938,-0.36311458,-0.29402624,-0.23062106,-0.17546882,-0.13054161,-0.06669356,-0.028606333,0.0016386414,0.017532012,0.022450673,0.010705795,-0.028464624,-0.074595519,-0.12298276,-0.16659413,-0.2220928,-0.2664842,-0.31732435,-0.3679041,-0.41439323,-0.45775441,-0.50298731,-0.53672001,-0.57659156,-0.615733,-0.64799945,-0.68976137,-0.73144896,-0.77263048,-0.80233477,-0.83854243,-0.87804255,-0.92334383,-0.96476213,-1.0104472,-1.0571188,-1.1032329,-1.1467172,-1.1907188,-1.2309457,-1.2726678,-1.3263728,-1.3840333,-1.4562047,-1.5191341,-1.5536942,-1.5629935,-1.5727979,-1.5699924,-1.577134,-1.5885049,-1.6011225,-1.6082086,-1.6195749,-1.5793107,-1.5057357,-1.4439406,-1.3870329,-1.3172286,-1.2480868,-1.1894664,-1.1209197,-1.0750596,-1.02816,-0.96662282,-0.89988367,-0.84374734,-0.79843426,-0.81584786,-0.80873828,-0.8077378,-0.80910126,-0.80731117,-0.80294088,-0.80144419,-0.78842925,-0.78661413,-0.76080417,-0.73851542,-0.71573097,-0.6891903,-0.65427895,-0.60782526,-0.53948599,-0.53878683,-0.55561712,-0.52258213,-0.45800888,-0.39553016,-0.32449508,-0.24720394,-0.19467769,-0.16144738,-0.13697423,-0.12198681,-0.062912873,-0.028352406,0.0010101578,0.035906284,0.065037896,0.091965107,0.12527895,0.15515002,0.18308321,0.20960406,0.2453183,0.27657082,0.31948178,0.35264125,0.38739401,0.40948997,0.43531231,0.43819216,0.41986358,0.41225455,0.42898745,0.46142675,0.50445509,0.55598139,0.61116177,0.66515348,0.71596126,0.77423424,0.838671,0.90346327,0.99140112,1.0564847,1.1446435,1.2328603,1.3211647,1.4093894,1.4750825,1.5637395,1.6296921,1.6985186,1.7846679,1.8451804,1.8916203,1.9563084,2.0212981,2.0905772,2.1605223,2.2396073,2.304819,2.3702205,2.4356101,2.5238681:2
2.843055,2.7701207,2.680929,2.5408261,2.4020838,2.2606721,2.119738,1.9779365,1.8348231,1.6932862,1.5525052,1.4120125,1.2714447,1.1304547,0.98832061,0.84728552,0.70620474,0.56563796,0.42493943,0.28720599,0.14998626,0.014626558,-0.067801394,-0.18064265,-0.21859209,-0.22450304,-0.17847985,-0.17446782,-0.13924545,-0.10757163,-0.040176322,-0.00709907,0.045603673,0.10523571,0.20580552,0.21713343,0.27594444,0.3093497,0.31557704,0.37523983,0.41410985,0.40199764,0.34788437,0.25386568,0.15923625,0.1822914,0.19948376,0.21647709,0.22895315,0.17853154,0.18000586,0.19856155,0.19092088,0.17384148,0.069979144,-0.005334026,-4.2430228E-4,0.03005993,0.034009527,0.025983505,0.032702368,0.029111707,-0.0017975009,-0.046379095,-0.035390759,-0.020694741,-0.041837218,-0.055672817,-0.11872988,-0.18516934,-0.29858048,-0.40023025,-0.47675735,-0.51519934,-0.49485121,-0.50078897,-0.4791406,-0.47187418,-0.44422192,-0.46722641,-0.44670012,-0.41903484,-0.3690354,-0.33788688,-0.29048853,-0.24072883,-0.21084009,-0.20171433,-0.1471803,-0.079450373,-0.045888225,0.0044994666,0.030453207,0.052841619,0.032790948,-0.0068382227,-0.023234034,-0.050798264,-0.013343106,0.025688657,0.068208904,0.064785158,0.10430655,0.10322054,0.1445225,0.17112038,0.1792402,0.20759549,0.25817344,0.28561489,0.34976571,0.41214491,0.47535927,0.51299171,0.52440591,0.5062159,0.39474172,0.28749833,0.19043173,0.080898561,-0.018376462,-0.11837866,-0.21213593,-0.29731047,-0.42484388,-0.50809117,-0.60712245,-0.70955371,-0.81313765,-0.85685344,-0.9686625,-1.0555224,-1.1584088,-1.253174,-1.3581757,-1.4624101,-1.5657917,-1.6520827,-1.6776918,-1.621906,-1.5202562,-1.5221505,-1.4499359,-1.3967967,-1.3469084,-1.2949361,-1.269468,-1.1893731,-1.1124431,-1.0028086,-0.93291796,-0.86825656,-0.82405744,-0.70451398,-0.63306277,-0.53199961,-0.45165154,-0.3756525,-0.31391302,-0.27324632,-0.19938968,-0.1691393,-0.094094781,-0.031539447,0.046336891,0.10697415,0.16455031,0.10081019,0.037557917,-0.0648216,-0.17016805,-0.24194585,-0.32330291,-0.38516862,-0.34675642,-0.26489785,-0.17425671,-0.081535092,0.0016288593,0.090182973,0.21400839,0.31364728,0.3592946,0.45445867,0.58027482,0.67527242,0.75213952,0.79630636,0.77602141,0.80304145,0.91636731,1.0233323,1.1033228,1.2149221,1.3145978,1.374785,1.4606266,1.5710399,1.6673516,1.7744696,1.8847702,1.9915651,2.0945487,2.2035753,2.3012752,2.4015088,2.4839104,2.5360135,2.5246432,2.4704314,2.3951737,2.2591505,2.1437587,2.021494,1.8816004,1.7445074,1.6059675,1.4664037,1.3341252,1.242691,1.1753663,1.1085446,0.98953257,0.84580226,0.70381433,0.63454638,0.64249298,0.58398293,0.51253936,0.38304725,0.25218388,0.15740513,0.066820875,-0.04362808,-0.13821281,-0.27053277,-0.39856634,-0.50543523,-0.43561219,-0.4012623,-0.35027395,-0.26706057,-0.16412955,-0.17236969,-0.1932875,-0.23739419,-0.34803689,-0.41825978,-0.50998071,-0.61862882,-0.74148329,-0.83270823,-0.87131084,-0.98141513,-1.0896541,-1.1755166,-1.2754786,-1.3095005,-1.3954964,-1.509937,-1.5966662,-1.6859518,-1.7947359,-1.8888848,-1.9638267,-2.0536416,-2.1254683,-2.2057795,-2.2688995,-2.2213683,-2.0925918,-2.0404041,-1.9301956,-1.8281695,-1.692291,-1.5947971,-1.4582459,-1.3471786,-1.2504735,-1.1522824,-1.0484769,-0.97461152,-0.86933334,-0.76909923,-0.6704481,-0.5703292,-0.46402397,-0.33132166,-0.22777833,-0.11403292,-0.0053268512,0.097455537,0.2121944,0.32207139,0.37393836,0.35865307,0.3064056,0.24095911,0.1572261,0.079755327,0.0072407647,-0.062329353,-0.140879,-0.20350661,-0.23272988,-0.30201344,-0.36528792,-0.42832905,-0.47693098,-0.40463118,-0.40248513,-0.44209474,-0.50000873,-0.5491056,-0.59177844,-0.62610943,-0.64722895,-0.66557637,-0.70149671,-0.6224925,-0.5099638,-0.44130009,-0.4686994,-0.48689651,-0.52201946,-0.54862226,-0.58197445,-0.62773729,-0.57147191,-0.62189593,-0.68492173,-0.74627499,-0.75973819,-0.76613129,-0.81244359,-0.84940817,-0.89774752,-0.92954424,-0.94786738,-0.99942893,-0.9612838,-0.98469276,-1.0207834,-1.0560899,-1.0527243,-1.052994,-1.0444956,-1.0406734,-1.016903,-0.918494,-0.81242186,-0.71340893,-0.61815284,-0.51281188,-0.40821405,-0.31587856,-0.24353981,-0.24734957,-0.2445908,-0.23246984,-0.21500949,-0.20193558,-0.14017586,-0.10459438,-0.11130736,-0.10781801,-0.10421589,-0.061742815,0.041516826,0.072178009,0.082284532,0.067129462,0.043933215,0.055826003,0.023552409,0.0011929731,0.026126318,0.052892296,0.076671731,0.031974869,0.046085649,-0.01035754,-0.046451919,-0.034796581,-0.12018467,-0.1566923,-0.20842748,-0.25920793,-0.26567135,-0.28222733,-0.32334057,-0.32265213,-0.34939447,-0.39202108,-0.39340866,-0.37173626,-0.33205133,-0.31044085,-0.30112122,-0.39894571,-0.37968189,-0.30277296,-0.20814993,-0.066161163,0.075516357,0.21704685,0.35830556,0.49954954,0.64157453,0.78374287,0.92541371,1.0679164,1.2105173,1.3526342,1.494648,1.6367452,1.7790828,1.9208748,2.0629536,2.2052517,2.346838,2.4370704,2.5731021,2.6716718,2.7791903,2.8421984,2.8594814:3
-0.87731467,-0.89367621,-0.92219683,-0.94865982,-0.96936083,-0.99325854,-1.023011,-1.0564916,-1.0812215,-1.1117739,-1.1399534,-1.1703979,-1.2049953,-1.2388898,-1.2568929,-1.2922746,-1.3023003,-1.3223873,-1.3376191,-1.3364215,-1.3533055,-1.3774479,-1.3935689,-1.4337864,-1.4722636,-1.4942466,-1.5417835,-1.5701715,-1.596363,-1.5405934,-1.4979767,-1.4281699,-1.3639829,-1.2952211,-1.2250586,-1.1518117,-1.0892993,-1.0257395,-0.953968,-0.88687293,-0.84473182,-0.78149407,-0.73796238,-0.6835947,-0.65735939,-0.61814294,-0.55492916,-0.49342077,-0.43748629,-0.41221378,-0.36561196,-0.32848538,-0.27794068,-0.23931706,-0.19960022,-0.15432679,-0.118197,-0.079436386,-0.036281423,0.003680338,0.041883071,0.10199361,0.16102721,0.18075274,0.22774904,0.26471808,0.29285608,0.32098253,0.3399211,0.37167229,0.36325211,0.37609617,0.38223895,0.42026165,0.4620827,0.5039004,0.58455287,0.64604508,0.72039154,0.79419623,0.86717416,0.96301091,1.0537316,1.1248727,1.1662706,1.2344437,1.3175078,1.4029177,1.4676045,1.5425069,1.5986236,1.6722297,1.746793,1.80632,1.8724283,1.9333787,1.9949477,2.0482449,2.1050458,2.101244,2.08325,2.0689281,2.0201257,1.9574517,1.8996719,1.8426182,1.784985,1.7256522,1.6596096,1.5911411,1.5145935,1.4670849,1.3949504,1.3231001,1.2511971,1.2042385,1.1590444,1.1133574,1.0670602,0.99567546,0.92539124,0.94578178,0.91403658,0.86567043,0.82002136,0.78732584,0.77209828,0.74439121,0.72374834,0.6852883,0.66102049,0.59038523,0.49596911,0.42309189,0.37624604,0.33198174,0.28497615,0.23610967,0.19856045,0.19998692,0.22651179,0.25831434,0.2889649,0.31775269,0.33391063,0.36061531,0.36827822,0.36758413,0.35550281,0.34923609,0.3255446,0.31205394,0.2941642,0.26287548,0.23742204,0.22010378,0.19914671,0.17529042,0.15015456,0.13221669,0.11354593,0.10116892,0.076294449,0.062255619,0.041136408,0.024652788,0.0059478545,-0.011100716,-0.027559136,-0.055184635,-0.07954786,-0.1029448,-0.12085393,-0.14681722,-0.17671529,-0.21168918,-0.25192788,-0.3036802,-0.33876917,-0.39854488,-0.46799278,-0.52917698,-0.5993174,-0.66576055,-0.74204333,-0.80388598,-0.8783253,-0.94520507,-1.0222371,-1.092046,-1.148455,-1.1715567,-1.1615468,-1.1422722,-1.1142764,-1.0767977,-1.0539591,-1.021639,-1.0108442,-0.9707902,-0.93361329,-0.90940354,-0.88627372,-0.87419925,-0.86046435,-0.84919368,-0.84728621,-0.85056287,-0.84206383,-0.83701843,-0.84604524,-0.84027728,-0.83160764,-0.82048387,-0.79698934,-0.78086946,-0.75169074,-0.71869392,-0.68689617,-0.65893491,-0.6281917,-0.59794925,-0.57493596,-0.56398518,-0.55927627,-0.55858638,-0.55873223,-0.55296194,-0.55403547,-0.56875402,-0.64722234,-0.72409572,-0.80464259,-0.89349279,-0.96460406,-1.0356528,-1.1068787,-1.1810473,-1.2382795,-1.3137618,-1.2755391,-1.2405152,-1.1838396,-1.1178057,-1.0549008,-0.97571845,-0.91481013,-0.84692085,-0.78391153,-0.71483308,-0.64975284,-0.57812032,-0.51412553,-0.44097517,-0.36046453,-0.28790006,-0.22316834,-0.15584739,-0.072271161,0.0088804143,0.086552674,0.15302428,0.23308523,0.31231327,0.39379458,0.47669331,0.5295669,0.60816216,0.66263733,0.71489209,0.76349033,0.80310543,0.83438127,0.85175548,0.82665355,0.78759616,0.7548058,0.70433471,0.65730083,0.60870146,0.56518919,0.50542858,0.45192071,0.4014089,0.35089168,0.2994613,0.28089232,0.35038119,0.42677048,0.50993456,0.5989877,0.64735389,0.71094291,0.78919484,0.88247391,0.95420484,1.0440131,1.1110788,1.1983012,1.2694904,1.3332872,1.3940471,1.4476714,1.5077479,1.5568179,1.6044574,1.6471252,1.7012216,1.7395158,1.772023,1.7981077,1.8028732,1.7958097,1.7759601,1.7493495,1.7209548,1.6955292,1.6554392,1.6116526,1.5690059,1.5258802,1.4729184,1.4227366,1.3686689,1.3105756,1.2468683,1.1761386,1.0952516,1.015093,0.95469127,0.90777059,0.86050218,0.82493339,0.78882136,0.76115872,0.71106753,0.66380878,0.62650903,0.5654321,0.50436617,0.42386638,0.36835818,0.32429569,0.28925957,0.26645444,0.27801282,0.28701982,0.32875921,0.31086443,0.29947095,0.33773363,0.39258848,0.43870533,0.49650188,0.54515001,0.59360661,0.64595303,0.69120907,0.73749333,0.77980333,0.81582332,0.83121863,0.84261416,0.81079077,0.76667225,0.71369935,0.6615787,0.58762995,0.52882697,0.44906663,0.36503011,0.27778027,0.21655415,0.13019203,0.048534565,-0.019555938,-0.085293482,-0.16886204,-0.23599173,-0.30669943,-0.39053565,-0.45791477,-0.53192688,-0.59621053,-0.6631609,-0.73871019,-0.80918679,-0.8790528,-0.94538771,-1.0112703,-1.0799251,-1.14557,-1.209392,-1.2801963,-1.329193,-1.3739159,-1.4395418,-1.5101963,-1.5799766,-1.6397861,-1.7113519,-1.7681692,-1.8330905,-1.8940241,-1.9368424,-1.9423868,-1.9499426,-1.8764589,-1.7999704,-1.7239033,-1.6586852,-1.5914001,-1.5147325,-1.4384717,-1.3631261,-1.2732468,-1.2011208,-1.1133698,-1.02499,-0.94771795,-0.89129639,-0.84619574,-0.8166028,-0.81210851,-0.81196227,-0.8315777,-0.85297272:2
0.1756052,0.13250259,0.068071912,-0.01149326,-0.061314323,-0.1321892,-0.19433342,-0.2691456,-0.31364609,-0.35604924,-0.40400574,-0.45696464,-0.51939832,-0.59581154,-0.66608669,-0.67767788,-0.61433971,-0.62902079,-0.64283721,-0.73202832,-0.79926282,-0.88899476,-0.98171701,-1.0713736,-1.1831405,-1.2925575,-1.4046466,-1.4967181,-1.5836568,-1.6077403,-1.6144986,-1.6505778,-1.7251871,-1.801224,-1.8628363,-1.9302324,-2.0403658,-2.1419507,-2.0458839,-1.9307433,-1.7984199,-1.6707847,-1.5514161,-1.4216609,-1.3038752,-1.1811045,-1.0570841,-0.92730972,-0.82092054,-0.67671306,-0.55450323,-0.42798467,-0.31082471,-0.17667177,-0.044026506,0.061803679,0.20550661,0.34182125,0.45412858,0.58352851,0.72602815,0.85442713,0.96119621,1.1003861,1.2344271,1.3749929,1.4969936,1.6201132,1.7519012,1.870123,1.9959955,2.1262675,2.2364591,2.3701645,2.4853724,2.6091639,2.6536148,2.6221366,2.5828285,2.4906561,2.3756528,2.2410888,2.1063486,1.9983274,1.8553149,1.7316469,1.6128261,1.4840617,1.3593143,1.2539408,1.1510166,1.0065191,0.85849348,0.74011229,0.6382088,0.52231504,0.41352502,0.27829672,0.13852629,0.017847117,-0.11358521,-0.16796901,-0.23749449,-0.36386868,-0.50010064,-0.63568918,-0.75376778,-0.88758939,-0.99875983,-1.1186755,-1.2622357,-1.3344999,-1.4454443,-1.4325127,-1.5324323,-1.6292054,-1.7319707,-1.7152632,-1.6150179,-1.5127749,-1.4627302,-1.4069973,-1.3399471,-1.3099307,-1.2730744,-1.2653414,-1.2944311,-1.340645,-1.3183357,-1.2234369,-1.1706091,-1.0780966,-1.0006164,-0.91834318,-0.84792985,-0.7616082,-0.67851416,-0.60828094,-0.56508408,-0.5609016,-0.55219632,-0.52350321,-0.47034191,-0.40567366,-0.31309617,-0.24720241,-0.17663361,-0.10530622,-0.038622753,0.03787542,0.092424657,0.078612374,0.039716676,-0.001068609,-0.11221452,-0.24791951,-0.38990302,-0.5233186,-0.6445748,-0.77044297,-0.90724733,-1.0237854,-1.1501374,-1.2892596,-1.3103292,-1.3280184,-1.2992026,-1.2651278,-1.2227166,-1.109159,-0.98975907,-0.87062774,-0.75277514,-0.63389657,-0.49896031,-0.37348562,-0.25118331,-0.11260014,0.0023210077,0.14443853,0.24945781,0.3613186,0.4913225,0.59014735,0.7266395,0.86758579,0.96436551,1.0285543,0.9902266,0.88772953,0.77420618,0.68296206,0.58816046,0.47990847,0.37695553,0.36325758,0.39532139,0.4437924,0.5068348,0.5662261,0.65283326,0.75169932,0.85622547,0.93342133,1.000074,1.0277819,1.0249391,1.0798833,1.1070183,1.1411773,1.1371797,1.0462504,0.94288672,0.92729892,1.0001425,0.98230714,0.93670605,0.85636185,0.76161295,0.64433802,0.53677079,0.41576993,0.31475975,0.20722435,0.12446379,0.049998738,-0.015301846,-0.051739071,-0.023937323,-0.026169067,-0.14348278,-0.30618814,-0.47252096,-0.64010713,-0.80783157,-0.97724094,-1.1144516,-1.2476172,-1.387375,-1.4718441,-1.373369,-1.259309,-1.1448492,-1.021301,-0.90037254,-0.76095592,-0.64953574,-0.54565173,-0.43408335,-0.32393444,-0.21466073,-0.10289289,0.0076604463,0.11854573,0.23968401,0.34984638,0.45063081,0.56041167,0.6470691,0.76231451,0.86715306,0.95309204,0.96608082,0.89934555,0.84253568,0.76371498,0.69862342,0.6232078,0.55970739,0.51446608,0.54308904,0.65209325,0.77094398,0.88593072,1.0051457,1.1337141,1.2360799,1.3129317,1.3378857,1.3660428,1.4007885,1.4276477,1.4218855,1.3532349,1.2859372,1.3260881,1.3422372,1.2920853,1.190556,1.0936331,0.9787367,0.88378425,0.79272672,0.71439443,0.6918823,0.60613064,0.48898744,0.39789097,0.29373266,0.17988156,0.075909861,-0.019376618,-0.007795777,0.027576418,0.076618103,0.14104162,0.24184331,0.31469413,0.41992071,0.50237637,0.42592149,0.31207137,0.19534218,0.094724367,-0.0080146029,-0.1064433,-0.20990758,-0.34256174,-0.44242764,-0.57404921,-0.66922323,-0.80121132,-0.90671276,-1.0707898,-1.1307135,-1.1691115,-1.3024375,-1.3852922,-1.4916644,-1.603426,-1.6233534,-1.4993229,-1.4132185,-1.2919554,-1.1491345,-1.0357253,-0.9082185,-0.77709391,-0.64314682,-0.46945196,-0.335711,-0.20286277,-0.06667935,0.067875595,0.16810537,0.215281,0.18311965,0.16716344,0.20549154,0.30827702,0.43455443,0.55402078,0.66672123,0.77531844,0.8779572,0.95745703,1.0420562,1.1292212,1.228569,1.2633132,1.2279043,1.2648088,1.3042779,1.2666036,1.2206989,1.1716822,1.103029,1.0369265,0.97499235,0.9074626,0.84892154,0.7946091,0.8076174,0.73749067,0.65382768,0.56956665,0.49607973,0.4261671,0.35233306,0.27093886,0.17612376,0.13363532,0.11678638,0.16930943,0.2960277,0.43134552,0.55786521,0.69395229,0.82640714,0.94900465,0.94417501,0.84754564,0.74137893,0.62833959,0.53187744,0.4250103,0.361581,0.30081482,0.2070506,0.11028223,0.014845638,-0.090362592,-0.19978436,-0.31241863,-0.43598014,-0.55276769,-0.66738913,-0.77547008,-0.87353365,-0.96016562,-1.0519773,-1.1524665,-1.2383289,-1.3331488,-1.3567174,-1.3746113,-1.2056075,-1.0344141,-0.8715183,-0.73267092,-0.60844025,-0.48960125,-0.36525178,-0.24081374,-0.071058754,0.097690514,0.18640161:5
1.2324002,1.1563758,1.0264819,0.91781937,0.7878109,0.65049425,0.4946302,0.41904885,0.38435889,0.32572992,0.15456383,0.031325285,-0.094914763,-0.039768957,-0.12155224,-0.18232906,-0.31712916,-0.42862159,-0.42078602,-0.38465887,-0.46117908,-0.42955677,-0.32718404,-0.29381723,-0.22390795,-0.11894249,-0.038585746,-0.1265204,-0.23775344,-0.37523402,-0.4777628,-0.51944835,-0.63477235,-0.73683724,-0.85907528,-0.94938829,-1.0312637,-1.0419742,-1.0887413,-1.1385497,-1.2323749,-1.2956408,-1.3777187,-1.4450875,-1.5047293,-1.6246116,-1.7290084,-1.7961532,-1.8812448,-1.7900391,-1.6607021,-1.501098,-1.3408105,-1.2033821,-1.036588,-0.91939385,-0.80716742,-0.70944975,-0.5665656,-0.43285939,-0.30879037,-0.16942211,-0.13401535,-0.06275877,0.035787568,0.11631649,0.24735109,0.3130783,0.37110733,0.50761999,0.63712618,0.759433,0.78872821,0.914222,1.049646,1.1863829,1.3205051,1.4502073,1.6029704,1.7331932,1.8547428,1.8306608,1.7403782,1.6355847,1.5399459,1.4632292,1.3643748,1.2831515,1.2892326,1.1835039,1.0843864,1.0104652,0.91037355,0.93988214,1.0301228,0.98699038,0.89068998,0.80486296,0.74937741,0.67704158,0.58262345,0.50752286,0.44043543,0.43473875,0.44267743,0.54087641,0.65032877,0.71270312,0.6650309,0.59294312,0.52346568,0.43375908,0.3435659,0.3208017,0.24086875,0.18297733,0.13957599,0.14640681,0.11811346,0.079154387,0.017746267,-0.030030641,-0.14469915,-0.20052535,-0.086177823,0.050605732,0.16767698,0.28835108,0.41873778,0.53911965,0.67804419,0.81295839,0.81103465,0.77641966,0.70204788,0.69155813,0.60014007,0.50390402,0.51667393,0.44860253,0.32865149,0.22983032,0.1843592,0.0473965,-0.063807288,0.027834557,0.01507568,-0.067906627,-0.14826936,-0.25359102,-0.37527587,-0.44388531,-0.51962957,-0.44534911,-0.43842442,-0.46236301,-0.53464243,-0.5943238,-0.68258147,-0.79125697,-0.8383864,-0.8397524,-0.88260051,-0.93754433,-1.0052778,-1.0671051,-1.1011069,-1.1576834,-1.2024917,-1.2441437,-1.2044602,-1.09645,-0.93581378,-0.77518324,-0.61404373,-0.42522558,-0.26654674,-0.12845152,0.030624502,0.19058229,0.31755123,0.45532691,0.58981246,0.72671341,0.84415255,0.98271541,1.092795,1.2229723,1.3452652,1.4626261,1.5873727,1.7146972,1.8289429,1.9473714,2.0552043,2.1487028,2.1941512,2.136131,2.0046011,1.8818179,1.7562271,1.6279324,1.5076608,1.3911275,1.2474155,1.1335474,0.99484253,0.87738682,0.74289965,0.61797609,0.48433072,0.34681919,0.20859457,0.068886188,-0.092030284,-0.24617592,-0.41615271,-0.57827276,-0.73897696,-0.90103314,-1.0899702,-1.2192295,-1.214022,-1.1692309,-1.1617821,-1.1581931,-1.0894659,-1.0271885,-0.93833053,-0.87820962,-0.85487694,-0.82370599,-0.77556519,-0.72392873,-0.6373005,-0.57445779,-0.52323864,-0.45181669,-0.37724191,-0.26194855,-0.17347893,-0.092370048,-0.049087215,-0.036939266,0.020726631,0.063784842,0.14327443,0.10034542,-0.032347627,-0.14647043,-0.091520992,-0.029673039,0.046547155,0.11843092,0.16285808,0.15785027,0.30331401,0.42566415,0.53291872,0.66852206,0.75281486,0.6621546,0.60870326,0.72004895,0.8126171,0.88852952,0.94339399,1.0197621,1.0648076,1.1208331,1.2111126,1.2863247,1.3757194,1.4474088,1.4142627,1.2688741,1.112709,0.96914343,0.80985656,0.64798267,0.52345832,0.34663461,0.20298398,0.051928541,-0.1018889,-0.24335528,-0.37773668,-0.33281461,-0.28306083,-0.22975973,-0.16858472,-0.11163576,-0.11816727,-0.064708361,-0.0031839675,0.0081929158,-0.094886939,-0.22148998,-0.1800564,-0.11787975,-0.068791358,-0.018162832,0.051287737,0.049785667,0.13102368,0.22122179,0.25103817,0.3220229,0.30822084,0.17865815,0.07861507,0.05466155,0.13697513,0.22485799,0.31531935,0.39759702,0.51039434,0.5696456,0.50327776,0.48755372,0.61301047,0.73013433,0.75184605,0.86985001,0.99897574,1.1155598,1.1575072,1.2230388,1.3521874,1.4753339,1.6064364,1.7418653,1.8541039,1.8180952,1.6851374,1.5578361,1.4162202,1.3340384,1.2323941,1.1079439,0.99683173,0.8724975,0.74039745,0.6834303,0.58905916,0.45027851,0.34125118,0.2666838,0.17612135,0.034347314,-0.094468737,-0.22594698,-0.35725606,-0.36241243,-0.40693333,-0.42836379,-0.56812349,-0.69272126,-0.78658907,-0.91631599,-1.053269,-1.1878917,-1.3195131,-1.46427,-1.5852175,-1.6400181,-1.6884356,-1.8312081,-1.960958,-2.0191213,-2.1428072,-2.2822278,-2.4161381,-2.5467059,-2.6443286,-2.7685589,-2.734364,-2.6636389,-2.593824,-2.5054725,-2.3790408,-2.2652833,-2.1718977,-2.0511874,-1.9176628,-1.8337766,-1.8153542,-1.6781238,-1.5315609,-1.3531988,-1.2765289,-1.2361115,-1.0962092,-1.0087274,-0.89093825,-0.77110068,-0.67139964,-0.70510402,-0.77885358,-0.85689857,-0.9186052,-1.0181458,-0.99663375,-1.0681934,-0.96568879,-0.85862404,-0.77007375,-0.66477671,-0.54128939,-0.53609035,-0.60447131,-0.51045636,-0.35689106,-0.21562827,-0.098457116,0.026972147,0.13817944,0.11762398,0.1436557,0.25186274,0.38421582,0.51560524,0.604019,0.74948684,0.89030465,1.0304085,1.189128:3
2.4611537,2.3733212,2.2855902,2.1990926,2.1084584,2.0186148,1.9288741,1.8380938,1.7490905,1.6602707,1.5733981,1.4776761,1.3846177,1.2991308,1.2013423,1.109484,1.0221997,0.92411709,0.8239716,0.75939273,0.69728079,0.67173219,0.66594993,0.6428258,0.61403761,0.58194448,0.50429555,0.40816132,0.35143198,0.33362956,0.31596725,0.27978651,0.23137153,0.17859846,0.12380223,0.08637467,0.054081057,0.03364869,0.024246922,0.017605965,0.011689663,0.0049082453,0.0071065818,0.029666393,0.051861464,0.07809171,0.10387562,0.13165413,0.12807679,0.078362674,0.068164147,0.094855777,0.12255116,0.16192757,0.13073942,0.071510309,0.021181692,-0.031520996,-0.10098486,-0.16064288,-0.22788552,-0.28817024,-0.36188338,-0.43117632,-0.49750444,-0.56623346,-0.63872666,-0.70174834,-0.78081451,-0.85956079,-0.95360489,-1.0533223,-1.109288,-1.1848917,-1.2358578,-1.2638895,-1.2730917,-1.2648405,-1.2542611,-1.2324912,-1.2068194,-1.1770866,-1.1392966,-1.0946327,-1.044404,-0.98434969,-0.92578375,-0.86382035,-0.79842911,-0.72486063,-0.64467831,-0.56887857,-0.48168818,-0.40611045,-0.40886256,-0.51077959,-0.50810321,-0.43291501,-0.34410931,-0.25605716,-0.16451407,-0.069719859,-7.6074418E-4,0.02701266,0.11734597,0.082263959,-0.020066198,-0.11141931,-0.20146536,-0.30001047,-0.36485007,-0.40558549,-0.50211368,-0.59692172,-0.69660654,-0.78953996,-0.87614633,-0.97600407,-1.0686991,-1.1665669,-1.2557951,-1.3517213,-1.4414722,-1.5375712,-1.6340816,-1.7219395,-1.8122081,-1.9071412,-1.9542628,-1.966818,-1.9503732,-1.9326126,-1.8958122,-1.8379547,-1.774345,-1.6975465,-1.5979502,-1.5065364,-1.3892104,-1.2652302,-1.1868893,-1.0560713,-0.94293935,-0.82985335,-0.71697214,-0.61014586,-0.50812815,-0.39417413,-0.28011677,-0.14772404,-0.021609592,0.099360398,0.13549328,0.085338429,0.13979273,0.23847305,0.35378338,0.46717212,0.56775351,0.68310049,0.76108191,0.82757257,0.74241202,0.6353671,0.54398292,0.4314292,0.32812286,0.24930949,0.17006246,0.10348145,0.043757414,-5.23454E-4,-0.041958762,-0.054677979,-0.051142582,0.0035698111,0.08198112,0.16953864,0.25653407,0.33967137,0.42530577,0.51078324,0.59769396,0.6909941,0.78236623,0.8795275,0.97438104,1.0897526,1.1978271,1.3101153,1.2607696,1.1721248,1.1088875,1.0594737,1.0360884,1.0625315,1.1327006,1.2137264,1.3023401,1.3921275,1.4807942,1.5665493,1.6570334,1.7495304,1.7633981,1.7197267,1.7979383,1.8915019,1.9470986,1.8442578,1.7708233,1.6758815,1.5826337,1.4861108,1.3923383,1.3242086,1.3412067,1.4093009,1.4156875,1.3256527,1.2277556,1.1294331,1.0416948,0.94281798,0.85086099,0.75690571,0.66285409,0.56924821,0.47128217,0.37520491,0.28511038,0.18903082,0.169285,0.19253965,0.22111938,0.27314619,0.32779612,0.38147876,0.44363068,0.52230233,0.63422599,0.72451675,0.82651926,0.91341408,0.83719875,0.74609526,0.68974959,0.58853172,0.49977295,0.39595128,0.30450472,0.2706578,0.31112742,0.21595776,0.1127512,0.013977125,-0.09407122,-0.20683971,-0.30638248,-0.40893303,-0.50300451,-0.60203708,-0.70436537,-0.80363739,-0.89462433,-0.99484524,-1.0901672,-1.1867218,-1.2767175,-1.3703548,-1.4583758,-1.5441966,-1.6285227,-1.6970364,-1.724529,-1.7218688,-1.6918832,-1.6261296,-1.5496211,-1.4632617,-1.3830448,-1.2939043,-1.1981944,-1.1017883,-0.99565897,-0.90766225,-0.79223973,-0.69450742,-0.57909791,-0.4708283,-0.38452874,-0.27410974,-0.23760633,-0.1227045,-0.0077112251,0.12538893,0.053088138,-0.058171437,-0.11025291,-0.24039003,-0.3507409,-0.44140561,-0.53926727,-0.61808618,-0.66419313,-0.60396332,-0.52162714,-0.59708789,-0.6801616,-0.79297197,-0.89491538,-0.99687956,-1.0920952,-1.1886877,-1.2620052,-1.345859,-1.4160894,-1.4824726,-1.559636,-1.6116832,-1.6404186,-1.6727942,-1.6927692,-1.7000568,-1.6842994,-1.6477031,-1.5972128,-1.4831711,-1.3812944,-1.2855407,-1.2009468,-1.1183978,-1.0340135,-0.95030038,-0.86074472,-0.78133044,-0.69955226,-0.61065501,-0.52915392,-0.44158574,-0.34886296,-0.25228342,-0.16621603,-0.081790807,0.011377477,0.099939293,0.10418281,0.020350234,-0.047888464,-0.10253689,-0.13612951,-0.085890726,-0.15328425,-0.23159323,-0.3028437,-0.36139881,-0.40148351,-0.43393691,-0.45967872,-0.47924419,-0.50729912,-0.51971514,-0.52797609,-0.5432713,-0.53385571,-0.50596086,-0.46435687,-0.40721254,-0.33917718,-0.24323801,-0.18512948,-0.12258251,-0.081705773,-0.026375628,-0.018004148,-0.097611903,-0.07784595,0.034516195,0.1111974,0.16055914,0.19249606,0.21270735,0.23208131,0.26096261,0.28450602,0.32199604,0.35543444,0.39559275,0.43786114,0.48079569,0.511876,0.55668058,0.59199978,0.6075019,0.62182382,0.61672001,0.61585869,0.61015576,0.60466105,0.60540842,0.64749862,0.54681333,0.54462734,0.64602165,0.73062932,0.82867157,0.92439722,1.0132799,1.1035271,1.2006633,1.292454,1.3841304,1.4726076,1.5629569,1.6461238,1.691553,1.7610949,1.829908,1.8824313,1.91861,1.8732376,1.9629915,2.0497242,2.1433431,2.2315093,2.3151556,2.400265:4
1.4789011,1.4013577,1.304108,1.2079581,1.1392056,1.0877583,0.99358494,0.9242596,0.89067867,0.84167324,0.82791899,0.79311802,0.76110076,0.67931593,0.62114601,0.60052581,0.54771424,0.47364508,0.44316783,0.43860515,0.42529009,0.45774672,0.50789465,0.5697216,0.65308171,0.75088482,0.82561054,0.81565515,0.71875645,0.62663262,0.54586582,0.43002642,0.32029878,0.21958059,0.11221016,0.0014870624,-0.1003935,-0.14370598,-0.24750058,-0.35489138,-0.43096719,-0.53401388,-0.63279144,-0.73308208,-0.83206483,-0.92351876,-0.99357211,-1.0788603,-1.1421732,-1.1642444,-1.1352692,-1.0732146,-0.93382086,-0.80572483,-0.73520401,-0.61484448,-0.4986298,-0.37867528,-0.27743967,-0.151426,-0.029094357,0.076885532,0.12000756,0.22749191,0.35377317,0.4822054,0.57722928,0.71556963,0.82499887,0.78443675,0.72127066,0.67967838,0.61649326,0.54952606,0.47881697,0.39165381,0.31898009,0.26976514,0.21587323,0.16758253,0.10765155,0.036351143,-0.026410014,-0.089947278,-0.15833171,-0.22004697,-0.27847928,-0.3438605,-0.38700431,-0.40029334,-0.39884128,-0.42042323,-0.46878269,-0.53003457,-0.59060823,-0.68056986,-0.77696202,-0.85881751,-0.95631427,-1.0451456,-1.1088109,-1.1568379,-1.1917513,-1.1730254,-1.1548756,-1.0995774,-1.0735174,-1.0750733,-1.117337,-1.1571834,-1.1988984,-1.3071169,-1.3989452,-1.4485791,-1.4517252,-1.5055956,-1.4031044,-1.2935025,-1.1765482,-1.0570395,-0.94721686,-0.84468822,-0.71513156,-0.58732327,-0.45686389,-0.31459086,-0.18451111,-0.040260195,0.09207996,0.22867282,0.36098086,0.49442303,0.6306305,0.767823,0.88585419,1.0099838,1.1490081,1.2860485,1.4037915,1.522207,1.6390468,1.7592004,1.8640498,1.9250398,2.0267147,2.145286,2.2522554,2.3592577,2.4694601,2.570355,2.6883529,2.7996961,2.8610868,2.8514118,2.7818675,2.6648608,2.5450537,2.439514,2.3276662,2.2072473,2.0976963,1.9832564,1.8909617,1.7799574,1.6511725,1.5231106,1.3964259,1.268548,1.1295122,0.99142645,0.85366999,0.71679872,0.58056295,0.44525684,0.29731088,0.16209179,0.027231194,-0.11829117,-0.25223608,-0.38589707,-0.51942075,-0.6528541,-0.78492093,-0.91609415,-1.046527,-1.179349,-1.300617,-1.4235555,-1.4108753,-1.3233114,-1.2248084,-1.1724615,-1.1284016,-1.172624,-1.2230861,-1.2843328,-1.2682227,-1.2123095,-1.1025022,-1.0292358,-0.93692754,-0.89984878,-0.8664356,-0.76380446,-0.72798447,-0.68172329,-0.65557642,-0.61598117,-0.58918837,-0.56266624,-0.53550778,-0.45682481,-0.38320361,-0.34207637,-0.29265039,-0.23786157,-0.17506802,-0.12872152,-0.048742014,0.017731491,-0.037556341,-0.16209721,-0.28777703,-0.39528476,-0.51659948,-0.62685527,-0.73416981,-0.84483617,-0.96467954,-1.0833847,-1.1850475,-1.2302985,-1.2168807,-1.1954199,-1.151618,-1.0862437,-0.98433285,-0.88481194,-0.77822485,-0.69972823,-0.59034688,-0.50642898,-0.39996048,-0.29169894,-0.21787688,-0.19389626,-0.11966617,-0.030710696,0.038519645,0.13742168,0.15913348,0.2383727,0.29805416,0.21410648,0.11761654,0.024675404,-0.042300455,-0.06555102,-0.014746008,0.030104516,0.11097776,0.18915799,0.27814697,0.36078489,0.4219352,0.48073937,0.55134635,0.61870764,0.6922928,0.75534247,0.8337953,0.92113063,1.0280256,1.0871696,0.99419203,0.88969559,0.7856418,0.68389944,0.59139812,0.4781847,0.3919419,0.29854646,0.20468765,0.10123055,6.842373E-4,-0.076064664,-0.16759331,-0.26594313,-0.33003965,-0.39418917,-0.44648737,-0.49113479,-0.57089025,-0.6886142,-0.79786087,-0.92641055,-0.89425025,-1.0050344,-1.1336053,-1.2624528,-1.413746,-1.4878214,-1.5029303,-1.548738,-1.6117314,-1.6426093,-1.7178831,-1.6932745,-1.6537282,-1.5991671,-1.5316085,-1.4871352,-1.403639,-1.3239258,-1.224508,-1.1372143,-1.0576182,-1.0138233,-0.9563023,-0.836414,-0.72650227,-0.6167615,-0.51698901,-0.40937083,-0.30978152,-0.20589711,-0.10538282,-0.010189949,0.088220753,0.15818248,0.12193663,0.089836081,0.12538309,0.15502633,0.17188322,0.2304966,0.33000605,0.42962521,0.53627983,0.64096423,0.74058594,0.84214341,0.91263331,0.987873,1.0877869,1.162952,1.2736271,1.3447348,1.4240687,1.5239976,1.6313875,1.7479154,1.7679337,1.6684539,1.564332,1.463691,1.3816385,1.3648883,1.2644408,1.1689305,1.093536,1.0011258,0.91692582,0.824804,0.73879927,0.64310607,0.58441681,0.51411606,0.46279694,0.4251503,0.39241709,0.41108051,0.41862694,0.33861443,0.2639687,0.17238884,0.072503551,-0.03025628,-0.12890719,-0.22006067,-0.31824978,-0.42019535,-0.52105798,-0.57577105,-0.61533379,-0.70129593,-0.68528349,-0.70174285,-0.76612075,-0.86607093,-0.97067733,-1.1007806,-1.2129363,-1.3087153,-1.4282946,-1.5356977,-1.6222845,-1.5763374,-1.5904527,-1.5476381,-1.4077378,-1.281032,-1.1522896,-1.0184458,-0.86701364,-0.72482607,-0.599492,-0.45967378,-0.34507541,-0.25682583,-0.17938874,-0.11091312,-0.041132964,0.040507191,0.13903679,0.26403707,0.38454753,0.49118115,0.58065353,0.67836159,0.77911479,0.88565837,0.9837755,1.0820952,1.1910685,1.3015206,1.4108278:5
0.20862128,0.12782299,0.061585712,-0.016821576,-0.098816561,-0.17628276,-0.2548064,-0.35284791,-0.43133807,-0.5210136,-0.61057008,-0.7001026,-0.7883451,-0.88879737,-0.98772195,-1.1124448,-1.2126663,-1.3374814,-1.4595488,-1.5466028,-1.6247162,-1.6676036,-1.6779186,-1.6852476,-1.6774079,-1.6616564,-1.622216,-1.5819762,-1.5075446,-1.4675494,-1.4023603,-1.3092696,-1.2331035,-1.1390116,-1.0565776,-0.96778723,-0.87979448,-0.79177699,-0.69804186,-0.6017378,-0.50390019,-0.4140731,-0.31624116,-0.22177418,-0.1329285,-0.10401458,-0.1038055,-0.0035521786,0.09085701,0.19300317,0.28836013,0.36152863,0.26718902,0.17268962,0.087742861,0.0052259449,-0.087811662,-0.18436657,-0.26681515,-0.3512685,-0.42856337,-0.5086646,-0.60252582,-0.68018107,-0.7593024,-0.84335846,-0.92094703,-0.99674385,-1.0723054,-1.130025,-1.1827911,-1.2035796,-1.1637646,-1.1112777,-1.0330342,-0.94547222,-0.82583681,-0.73693145,-0.64753789,-0.55692652,-0.4654247,-0.34470626,-0.24964745,-0.15733214,-0.039630765,0.060845429,0.18616788,0.31279865,0.43870671,0.56332079,0.55244583,0.65769414,0.78389639,0.88122345,0.97898622,1.0232858,0.95174896,0.87827841,0.80235468,0.7353071,0.68623769,0.69263601,0.76535559,0.86227978,0.95902206,1.0860246,1.1533077,1.2729426,1.3777829,1.4958904,1.6012461,1.6948571,1.7970209,1.8479727,1.7548696,1.6622246,1.6273682,1.5103004,1.3847957,1.2910401,1.1664165,1.0663432,0.97533427,0.9307882,0.98502812,1.0613846,1.1453652,1.2509099,1.2172548,1.0929424,0.99590589,0.89723786,0.77215939,0.64837048,0.52587707,0.43577911,0.34702267,0.2616248,0.16979916,0.065506253,-0.024936852,-0.11216419,-0.22836422,-0.30934537,-0.39535673,-0.47947285,-0.53456026,-0.56835953,-0.58136845,-0.55391638,-0.48775242,-0.4164527,-0.34126571,-0.25141418,-0.16878279,-0.088382319,-0.0053985331,0.079506537,0.1717969,0.26166782,0.35446503,0.43994307,0.48656414,0.39329945,0.29947743,0.21168883,0.11097692,0.02808073,-0.067713148,-0.16513008,-0.25800808,-0.34986393,-0.43695082,-0.39251241,-0.47550291,-0.56396913,-0.65912387,-0.75765019,-0.84371445,-0.92914808,-1.0154564,-1.1071147,-1.1942855,-1.2855911,-1.3851012,-1.4624176,-1.5425555,-1.6320705,-1.7044533,-1.7857921,-1.8451275,-1.8929982,-1.9151119,-1.9293765,-1.9507907,-1.9468689,-1.927499,-1.9036429,-1.8471698,-1.7988605,-1.7394151,-1.6753911,-1.6095995,-1.5317651,-1.4379843,-1.3115179,-1.1853255,-1.0803226,-0.96345635,-0.86394315,-0.77170668,-0.68016597,-0.60834162,-0.52516704,-0.43969124,-0.35686,-0.28430918,-0.15989654,-0.06199446,0.048003412,0.16136215,0.14721257,0.054723819,-0.032295856,-0.10764717,-0.18839283,-0.25156595,-0.3127867,-0.36285401,-0.3786898,-0.31510682,-0.31526321,-0.37270965,-0.42861332,-0.48122298,-0.52960238,-0.57768227,-0.63138004,-0.68136818,-0.72343088,-0.76217349,-0.79270468,-0.8184635,-0.84574597,-0.86492921,-0.88285878,-0.90378972,-0.91659546,-0.9284839,-0.93409947,-0.94232555,-0.95397664,-0.95697177,-0.96240541,-0.94564653,-0.91168062,-0.87778926,-0.82840879,-0.77636765,-0.71614996,-0.62723485,-0.53204965,-0.44050193,-0.34574686,-0.25713125,-0.17220045,-0.077380037,5.7628752E-4,0.09117829,0.16808832,0.25332992,0.33631521,0.43293358,0.50683978,0.60061112,0.68783452,0.77399918,0.81761453,0.7775342,0.72898168,0.68715883,0.65429163,0.63364074,0.63166777,0.64477111,0.69507888,0.75193583,0.82866917,0.81165187,0.80276912,0.80016917,0.79295174,0.78834605,0.77612371,0.77479205,0.78613402,0.79009665,0.7932867,0.80033888,0.80712214,0.80347536,0.80856011,0.82197222,0.84396397,0.86871017,0.89617707,0.93526862,0.98928342,1.0503736,1.0959085,1.1375199,1.1797019,1.2311265,1.2764515,1.3297807,1.3949851,1.446498,1.4924247,1.538183,1.5783904,1.6103171,1.6440543,1.6705853,1.6991826,1.7231249,1.7456708,1.7658966,1.7821346,1.8210882,1.8702851,1.9445255,2.010581,2.1024568,2.1140736,2.0638543,2.0143792,1.9871611,1.9679029,1.9525613,1.9378002,1.9258667,1.9060521,1.879045,1.8412842,1.7918791,1.7492668,1.7042616,1.6449832,1.5968177,1.5347049,1.4934199,1.4370747,1.3847809,1.3262955,1.2821792,1.2263327,1.1648063,1.1112941,1.0776122,1.0253796,0.96641388,0.92630897,0.86933212,0.82084544,0.78540041,0.73522721,0.68871728,0.66236957,0.61827619,0.57052798,0.53242558,0.50100168,0.46119587,0.36429485,0.27753712,0.19095378,0.10096359,0.0025694795,-0.079948422,-0.16818952,-0.25589831,-0.3424251,-0.43123819,-0.52658134,-0.61850113,-0.69894832,-0.79603424,-0.86714867,-0.91475364,-0.95942854,-1.021092,-1.054461,-1.0859985,-1.087423,-1.0870259,-1.087357,-1.0840204,-1.0700989,-1.0515072,-1.0237117,-1.0037321,-0.97038405,-0.94024006,-0.91595717,-0.88883057,-0.8668237,-0.83088848,-0.79180868,-0.74955957,-0.7027798,-0.64753378,-0.59072987,-0.53700536,-0.48128246,-0.42513428,-0.37830609,-0.40682334,-0.38346148,-0.32309183,-0.27630478,-0.2046651,-0.13174047,-0.074261095,-0.01319606,0.052002364,0.1183345,0.1871022:4
0.81108887,0.77192747,0.65493609,0.6136721,0.50130394,0.38249052,0.35695878,0.302357,0.18709373,0.088333865,0.024890838,-0.088475208,-0.1667185,-0.29823273,-0.41440065,-0.44313386,-0.47880727,-0.52542822,-0.52110236,-0.55704975,-0.63019135,-0.71212534,-0.77085643,-0.81743103,-0.89319708,-0.94799106,-0.96872707,-0.99512322,-1.058566,-1.0402365,-1.0825806,-1.1108746,-1.1071384,-1.0703802,-1.033478,-0.96192188,-0.88422597,-0.8073558,-0.72123428,-0.63849862,-0.60430579,-0.50561547,-0.45301017,-0.44133087,-0.45296423,-0.45303932,-0.51983639,-0.56337196,-0.56122666,-0.58116363,-0.59579714,-0.57854333,-0.53458196,-0.5258872,-0.47767692,-0.44117383,-0.47563084,-0.41886678,-0.3866732,-0.39014224,-0.3007128,-0.24716791,-0.27641148,-0.17894327,-0.12316076,-0.13096778,-0.0062961126,0.020761358,0.054057569,0.049262117,0.098181408,0.14314442,0.17252839,0.27623226,0.39128323,0.53104159,0.58461403,0.72214624,0.86677652,1.0053427,1.1140853,1.2432174,1.3556939,1.4764985,1.5254009,1.6483405,1.7386318,1.8336209,1.8999403,1.9581807,1.9762647,2.0082919,2.0059115,1.9889452,1.9571383,1.9188224,1.8453279,1.7712451,1.7340186,1.6573229,1.5734128,1.4800506,1.5022965,1.3989023,1.2557307,1.1416259,1.0556722,0.97227702,0.86064961,0.751687,0.63887739,0.53120996,0.41748751,0.27544068,0.15998864,0.048248272,-0.062635977,-0.19691226,-0.25948913,-0.33636585,-0.4348664,-0.48863957,-0.55497248,-0.65081802,-0.74490902,-0.77124432,-0.87912706,-0.92037259,-1.0204642,-1.1226621,-1.1729127,-1.208354,-1.2915681,-1.3804728,-1.4682458,-1.5922051,-1.5655523,-1.5781088,-1.4338418,-1.4863283,-1.3939031,-1.416561,-1.3041663,-1.2805135,-1.2281685,-1.1698607,-1.1075771,-1.0615559,-0.98549433,-0.91014299,-0.81131105,-0.74484235,-0.6686799,-0.58988002,-0.5116454,-0.42600933,-0.35328721,-0.27091166,-0.19034464,-0.10779764,-0.054942053,-0.037330354,-0.04728238,-0.10209346,-0.17826663,-0.22295536,-0.2935592,-0.34968202,-0.37347028,-0.41951322,-0.3782914,-0.37799921,-0.2926431,-0.21203666,-0.16831114,-0.089007151,0.013280296,0.12788529,0.21679899,0.27523332,0.3502117,0.43142714,0.51394522,0.59136532,0.65061616,0.75712756,0.84755517,0.93200353,0.99580395,1.0246621,0.961534,0.89928647,0.82431851,0.73160251,0.64542166,0.56951061,0.48969371,0.40811574,0.33936882,0.24375301,0.15641107,0.063084326,-0.038121508,-0.1221973,-0.1695167,-0.20089028,-0.2592997,-0.32766029,-0.40269522,-0.47751185,-0.56541235,-0.65933079,-0.74983165,-0.84120026,-0.95966013,-1.0779738,-1.1956861,-1.3186963,-1.431312,-1.562154,-1.6656945,-1.7820306,-1.8682363,-1.9533185,-2.0343724,-2.1166128,-2.1966072,-2.2497843,-2.2751838,-2.2750801,-2.275293,-2.2461002,-2.2190829,-2.1887005,-2.0837264,-2.0596213,-2.0185499,-1.9476166,-1.8409508,-1.74058,-1.6206561,-1.5531703,-1.5033933,-1.3931386,-1.2928838,-1.1720072,-1.1052635,-0.99030028,-0.98113254,-1.0945044,-0.97884257,-0.91986627,-0.81808928,-0.73455398,-0.61666304,-0.4948036,-0.36966562,-0.26717046,-0.16669194,-0.059272651,0.0041278982,0.062099131,0.1451281,0.23002303,0.32334545,0.42271737,0.50775703,0.60375603,0.6722109,0.65432911,0.62744828,0.61420768,0.65343553,0.70222624,0.779663,0.84452626,0.94294491,1.040857,1.139261,1.2350736,1.3232359,1.3785374,1.4623695,1.5443193,1.6331107,1.699389,1.767638,1.8714785,1.9352187,1.8799343,1.7987968,1.7369801,1.6515191,1.5655212,1.4746997,1.38568,1.300952,1.21716,1.1204676,1.0258692,0.92589959,0.88051064,0.8299254,0.87144187,0.77501606,0.88118802,0.93700061,0.99930734,1.0477142,1.0152587,0.91451623,0.83152417,0.75820214,0.69392976,0.62291784,0.55146703,0.46757417,0.36428279,0.26761001,0.1764201,0.083874373,-0.0072306739,-0.098716742,-0.17634588,-0.28263775,-0.38432296,-0.44926659,-0.51343352,-0.5373627,-0.60630691,-0.67610762,-0.71206156,-0.71912457,-0.77961918,-0.86216657,-0.93105335,-0.95345032,-0.99953389,-0.96246101,-0.87450263,-0.81757419,-0.79938776,-0.77016421,-0.79068676,-0.7747912,-0.69210511,-0.63919444,-0.67394225,-0.60466759,-0.52644343,-0.45056294,-0.36763436,-0.31142758,-0.22148137,-0.23420342,-0.15896,-0.065118928,-0.029090062,-0.068482913,-0.17487912,-0.23806242,-0.20057663,-0.22623334,-0.17083239,-0.20228175,-0.180926,-0.23533503,-0.26333269,-0.33867123,-0.28255997,-0.35498241,-0.35768048,-0.41661664,-0.45516574,-0.48156637,-0.39924037,-0.49856984,-0.46331987,-0.43649356,-0.38587814,-0.35442899,-0.25979925,-0.23337901,-0.13090568,-0.026967178,0.022340231,0.099384386,0.15952863,0.27388292,0.38282389,0.47229358,0.58134464,0.69998546,0.79429716,0.91093457,1.0146008,1.1229995,1.2253798,1.3396107,1.4173044,1.4861134,1.5928533,1.7075556,1.8007012,1.8657225,1.8170178,1.7330713,1.6607738,1.5866344,1.5141179,1.4443978,1.3775022,1.3100936,1.2353027,1.1787228,1.1066357,1.0603291,1.0620447,1.0171523,0.99065571,0.92018726,0.907181,0.89753389,0.89201169,0.88056697,0.86992639,0.84374521:5
-0.81570511,-0.87736652,-0.95003426,-1.0160971,-1.0877941,-1.1577304,-1.2282285,-1.3237118,-1.3881934,-1.4581408,-1.5179646,-1.5630225,-1.5924435,-1.6042131,-1.5983395,-1.5731938,-1.535492,-1.49295,-1.4441769,-1.3865566,-1.3436546,-1.2942562,-1.2372708,-1.1788166,-1.1115709,-1.0587414,-1.0024177,-0.9552694,-0.88838984,-0.82788437,-0.78297785,-0.71992958,-0.66217957,-0.62499901,-0.57598865,-0.55264011,-0.50761819,-0.48206246,-0.47498396,-0.4553367,-0.40702203,-0.32792259,-0.27533378,-0.20003612,-0.12764972,-0.055507108,0.013736554,0.077829681,0.13131536,0.16232934,0.19204147,0.20908359,0.18212376,0.15913881,0.12451253,0.088590576,0.02577829,-0.038377839,-0.10121096,-0.13427191,-0.19521038,-0.26760457,-0.32513964,-0.37264284,-0.40577301,-0.44640637,-0.44881659,-0.42631519,-0.40328141,-0.33700032,-0.27758055,-0.18933867,-0.13686081,-0.045278034,0.045095931,0.10068775,0.18445072,0.23636987,0.32354896,0.37302347,0.43138393,0.51058213,0.56137287,0.60965566,0.67117973,0.73140196,0.76826348,0.81246505,0.85033824,0.90050413,0.94437393,0.98735575,1.0364069,1.081117,1.1135281,1.1460167,1.1880251,1.2240057,1.2733979,1.301762,1.3394146,1.3658183,1.4027872,1.4196581,1.4416068,1.4640648,1.4957121,1.5317098,1.5695316,1.608391,1.6409052,1.6878661,1.7396768,1.7723273,1.7839701,1.7787583,1.7672694,1.7513628,1.7278488,1.7059559,1.6849728,1.6594022,1.6418913,1.6147415,1.5872312,1.5510789,1.5076407,1.4588664,1.4165997,1.3735045,1.3210249,1.2651821,1.1967546,1.1208335,1.0662393,0.99228254,0.91429717,0.86189869,0.80991454,0.76079368,0.72028539,0.71207788,0.7343173,0.77341321,0.80368244,0.86650304,0.91891302,0.95840269,1.0113994,1.0551172,1.0843044,1.1085369,1.1288734,1.086193,1.0549241,1.011011,0.96979836,0.92818774,0.85704023,0.80946686,0.73793931,0.68735561,0.60989147,0.56364715,0.48835022,0.42580677,0.37367777,0.29303121,0.22443068,0.17659132,0.10107628,0.030860452,-0.011515377,-0.086117916,-0.15393017,-0.22742839,-0.29517881,-0.37508933,-0.45362024,-0.53541138,-0.59181237,-0.66539794,-0.74613295,-0.79915454,-0.88326166,-0.94130558,-1.0250499,-1.0914983,-1.1563521,-1.2281253,-1.307786,-1.3618048,-1.428714,-1.50373,-1.5719514,-1.6197055,-1.6719338,-1.6681072,-1.611017,-1.5138787,-1.4098634,-1.3067371,-1.2041346,-1.102345,-1.0027822,-0.91858844,-0.84978563,-0.75812913,-0.70463435,-0.65416669,-0.62567718,-0.58878259,-0.60246453,-0.59400476,-0.59565827,-0.62032864,-0.63898451,-0.66109834,-0.68917426,-0.71332426,-0.7228458,-0.7427731,-0.76949433,-0.78944928,-0.80274249,-0.8192262,-0.82710624,-0.84332089,-0.85836542,-0.87714677,-0.89287983,-0.90825925,-0.92481439,-0.94424539,-0.95987977,-0.97738567,-0.96756435,-0.97048796,-0.96459084,-0.96403164,-0.96554587,-0.96460067,-0.95403802,-0.95556858,-0.9506583,-0.96519787,-0.96421199,-0.96754107,-0.98153815,-0.98134206,-0.9924623,-1.0004466,-1.0013477,-0.99767262,-0.98856893,-0.98407918,-0.97239213,-0.95216958,-0.94967271,-0.93832198,-0.90969139,-0.89998841,-0.87846753,-0.86120369,-0.83873748,-0.78474803,-0.74755192,-0.7092723,-0.67324829,-0.63929997,-0.62451031,-0.61142806,-0.58761981,-0.57353731,-0.54716583,-0.52461405,-0.50592925,-0.46845639,-0.45359145,-0.41376227,-0.38906918,-0.35648546,-0.33182431,-0.30725153,-0.25921372,-0.20921362,-0.16372114,-0.095698864,-0.065423979,-0.02201606,0.034288898,0.078040361,0.1385974,0.18532631,0.24856256,0.30296139,0.34946444,0.40919994,0.46251867,0.51966835,0.57196749,0.63222793,0.69046275,0.74191079,0.79709291,0.85535238,0.89072335,0.94050215,0.98930575,1.0428791,1.0991534,1.1748283,1.2437627,1.3198284,1.4054377,1.4547686,1.543389,1.6084053,1.7131905,1.781438,1.8421892,1.9045809,1.9777212,2.0426173,2.109648,2.1762846,2.2214341,2.2617918,2.2972081,2.314296,2.2700311,2.2074883,2.141587,2.060284,1.9820077,1.8735073,1.764503,1.6556775,1.5466721,1.4374358,1.3713421,1.2668963,1.2044039,1.122107,1.0802099,1.0178667,0.9657752,0.91793068,0.88050187,0.83604306,0.77970276,0.71895854,0.66642328,0.61214089,0.55838285,0.50592307,0.45128424,0.39846159,0.34904178,0.29590135,0.2579662,0.22189368,0.15661645,0.13144948,0.089418213,0.0427089,0.0074860515,-0.023057653,-0.07774634,-0.12675195,-0.17278301,-0.2096216,-0.25550329,-0.29574706,-0.3325369,-0.34991367,-0.37503047,-0.4073882,-0.42569111,-0.45688219,-0.48083034,-0.51195087,-0.54266368,-0.5751716,-0.60538659,-0.62546192,-0.64351423,-0.66851527,-0.68843339,-0.71170757,-0.71838905,-0.71738103,-0.72462922,-0.72926019,-0.74146862,-0.75838432,-0.76774977,-0.78719186,-0.81340652,-0.82778963,-0.84578041,-0.85727894,-0.86419642,-0.87982979,-0.90223028,-0.89624281,-0.90109999,-0.89437736,-0.88657699,-0.87897292,-0.87342939,-0.86646202,-0.85815724,-0.84315539,-0.8329951,-0.8273145,-0.82011969,-0.82368472,-0.81177946,-0.79064125,-0.77148577,-0.7555601,-0.75074239,-0.74768753,-0.75573779,-0.76470756,-0.78322993:2
1.1829201,1.1835184,1.1150673,1.0598699,0.96960801,0.91547015,0.90621813,0.84409099,0.80488241,0.74574845,0.6910583,0.65413634,0.61416331,0.60776977,0.5263452,0.51818559,0.44363444,0.37645731,0.29249225,0.27939027,0.1994828,0.15107275,0.055705397,0.061722102,0.13214988,0.21316165,0.30761952,0.40148375,0.46705736,0.54687547,0.53704659,0.45269186,0.32458033,0.20882395,0.075828834,-0.040692327,-0.15943521,-0.28431568,-0.33330576,-0.4180924,-0.47534931,-0.59920855,-0.71476611,-0.83871848,-0.95326865,-1.0809407,-1.2098163,-1.2538828,-1.3536522,-1.4697248,-1.596401,-1.6409424,-1.7647233,-1.83117,-1.8642881,-1.9337857,-1.967843,-2.0367609,-2.0660096,-2.1216246,-2.1578245,-2.1410684,-2.054415,-2.0412639,-2.1005546,-1.9805146,-1.8437284,-1.8021535,-1.6791023,-1.550335,-1.4232752,-1.2783734,-1.1763346,-1.0675645,-1.0143172,-0.99630156,-0.91935105,-0.78541031,-0.69760781,-0.61836174,-0.5281398,-0.40775228,-0.32754584,-0.20539059,-0.083284155,0.0083772965,0.11935439,0.21371081,0.35671682,0.48058432,0.52347479,0.5899796,0.66743968,0.79787408,0.89664137,0.95136869,1.0876385,1.21174,1.3295636,1.4496487,1.6023774,1.7543449,1.8600051,1.9444707,1.9609434,1.9018489,1.8125856,1.7316208,1.647477,1.5853539,1.5095881,1.4270567,1.41468,1.3895944,1.3481557,1.293376,1.2089376,1.1207514,1.035548,0.9660924,0.88833091,0.77941135,0.69555687,0.58266378,0.55735783,0.58936771,0.66120313,0.75754925,0.79462792,0.87844882,0.97969571,1.1033077,1.1822887,1.2041849,1.1855197,1.1421396,1.0099331,0.91143641,0.82261024,0.83954833,0.72578566,0.62219185,0.58947453,0.51276432,0.42332404,0.30884679,0.1711566,0.15268559,0.035132388,-0.097264515,-0.12402735,-0.21853865,-0.32388753,-0.38132348,-0.43224568,-0.45913052,-0.51795042,-0.5162701,-0.58609409,-0.51275031,-0.38819424,-0.30651588,-0.17937731,-0.095491497,0.029359274,0.1463542,0.21640796,0.33233109,0.46011772,0.58410618,0.70681913,0.83548331,0.94922023,1.0826661,1.0234444,0.91816227,0.81040471,0.69828594,0.59003518,0.48079532,0.37803289,0.26905026,0.16318043,0.073651423,0.10443229,0.011654395,-0.090338306,-0.18465258,-0.28645519,-0.37473161,-0.46864305,-0.56524208,-0.58436378,-0.58343721,-0.59726523,-0.68255126,-0.78327212,-0.89230089,-1.0162769,-1.1418255,-1.2015542,-1.2810037,-1.3967373,-1.4650723,-1.394484,-1.3645391,-1.3197793,-1.359593,-1.3935204,-1.397692,-1.383242,-1.3830128,-1.4515232,-1.4892432,-1.5656563,-1.5355502,-1.4804214,-1.3836016,-1.2847299,-1.1740891,-1.0636142,-0.9678957,-0.90303546,-0.80124187,-0.74840905,-0.80323552,-0.82072013,-0.850905,-0.75830667,-0.64577754,-0.5638575,-0.44757419,-0.32389047,-0.21509445,-0.12752132,-0.003568347,0.040828831,0.14318527,0.26337808,0.38394305,0.51078842,0.63489552,0.75499543,0.87851636,0.96276393,1.0955004,1.2205071,1.3183616,1.4328405,1.5581782,1.6780473,1.7433545,1.8257587,1.9023085,2.01536,2.1334712,2.2682239,2.3717117,2.3224328,2.2423379,2.1784168,2.049439,1.937024,1.8070113,1.6753791,1.5530039,1.4252964,1.2899685,1.1615695,1.0385341,0.91972452,0.79069463,0.66493417,0.53551882,0.41053582,0.29225455,0.16602802,0.052946746,-0.036387638,-0.066505259,-0.096926515,-0.12486002,-0.060548149,-0.069363614,-0.043829698,0.019713572,0.11418128,0.21502671,0.24496783,0.30001618,0.38829532,0.36378076,0.24155223,0.12358915,-7.4535253E-4,-0.032247458,-0.14714089,-0.23300239,-0.28850897,-0.35421544,-0.40647783,-0.50581683,-0.57961279,-0.60635177,-0.67670456,-0.78929431,-0.76662297,-0.66914639,-0.58094482,-0.57660532,-0.43841257,-0.43102655,-0.503584,-0.41191358,-0.44144223,-0.33451073,-0.2822251,-0.28045777,-0.23393203,-0.099825768,-0.045594488,0.05660169,0.12832505,0.090110345,0.14936259,0.25541506,0.34584683,0.27118151,0.18887442,0.12580793,0.032078914,-0.038702032,-0.049286025,-0.084357494,-0.02320795,-0.012851388,0.020653625,0.093541715,0.14158424,0.18323587,0.2902802,0.38694074,0.41271226,0.41198453,0.46969753,0.57642387,0.68042187,0.76238609,0.84790599,0.92696277,1.0228738,0.96969963,0.8815636,0.78305485,0.69136877,0.55102616,0.47459311,0.40879014,0.37051648,0.30256135,0.17592743,0.092148881,-0.049246178,-0.12677324,-0.11049826,-0.092877462,-0.084935259,-0.11487725,-0.24486058,-0.36106121,-0.48458619,-0.60453503,-0.72311363,-0.85071914,-0.95002834,-1.048593,-1.1757021,-1.2311517,-1.3585556,-1.4537642,-1.5266571,-1.6428064,-1.7621738,-1.8861258,-1.9733032,-2.0707863,-2.1631988,-2.263083,-2.1304472,-2.0210667,-1.8813499,-1.737853,-1.5947905,-1.4495186,-1.3191437,-1.15975,-1.0322493,-0.89958995,-0.76393689,-0.66058719,-0.56472094,-0.49022937,-0.41301295,-0.42255122,-0.46541121,-0.54632266,-0.56115654,-0.43662925,-0.31135921,-0.18778657,-0.063436114,0.059675666,0.16425161,0.30985649,0.40355872,0.44286585,0.49601628,0.5833012,0.67504788,0.7523708,0.81236708,0.85469131,0.90380004,0.94897943,1.0249047,1.0678727,1.1499985:5
1.257817,1.1895305,1.1080593,1.0343112,0.96668003,0.88253648,0.86130218,0.81652264,0.81463661,0.75637109,0.68663466,0.60308695,0.53352604,0.50513994,0.41461484,0.30221364,0.22035225,0.30062,0.32577312,0.33990925,0.41278768,0.49886359,0.60910581,0.71302245,0.66317955,0.54993805,0.41002539,0.31188709,0.25866552,0.14274993,0.034800453,-0.060244862,-0.18476011,-0.27570363,-0.37276511,-0.49205742,-0.61117178,-0.72250285,-0.79885619,-0.84123645,-0.88868715,-0.98381024,-1.0159293,-1.0459182,-1.1094544,-1.0401797,-1.013118,-0.88510849,-0.79906752,-0.72324372,-0.60297847,-0.52831885,-0.41827783,-0.3036821,-0.25075505,-0.15412052,-0.038871979,0.095752604,0.23006828,0.30578772,0.41769524,0.49918289,0.61721737,0.70873987,0.69446099,0.59672697,0.50427993,0.39461278,0.29265324,0.20573039,0.14219733,0.081430125,0.0049937177,-0.085577826,-0.18674581,-0.26809477,-0.3364973,-0.42602421,-0.51005959,-0.5789861,-0.63704991,-0.71391603,-0.74413114,-0.7940183,-0.81553223,-0.87788855,-0.90419124,-0.91993061,-0.96516624,-1.0531129,-1.044242,-1.1278381,-1.1576284,-1.1887198,-1.2783608,-1.2972665,-1.3223184,-1.3505285,-1.3760223,-1.4038025,-1.4652017,-1.4997517,-1.546187,-1.6218602,-1.724651,-1.7994783,-1.7716325,-1.7031783,-1.5864703,-1.506723,-1.4032001,-1.2963768,-1.1798691,-1.0598389,-0.94011577,-0.82091537,-0.70012301,-0.62091639,-0.49717107,-0.37547664,-0.25760767,-0.13672225,-0.017366268,0.096951995,0.22155022,0.33790484,0.45857149,0.57458781,0.69238494,0.81636172,0.9171442,1.0394418,1.1436327,1.2589432,1.3809928,1.5006408,1.6250489,1.7372395,1.858306,1.9117733,2.0137478,2.1368682,2.2546066,2.3789784,2.4974004,2.615878,2.7390694,2.715367,2.5945881,2.4744588,2.3561211,2.232282,2.111695,1.9907186,1.8704461,1.7478718,1.627651,1.5090882,1.386383,1.2680595,1.1486113,1.0286233,0.90631757,0.78491451,0.66784055,0.54614507,0.42854644,0.30675597,0.1872882,0.064656402,-0.053647279,-0.17054261,-0.2922101,-0.41300023,-0.535127,-0.65271609,-0.77569726,-0.89666746,-1.0145784,-1.1350602,-1.2544068,-1.3761603,-1.450234,-1.5682971,-1.6861654,-1.7238763,-1.8109504,-1.86552,-1.9810777,-2.0611979,-1.9939398,-1.9196832,-1.8247942,-1.7203836,-1.6229299,-1.5466356,-1.4670376,-1.414001,-1.3593895,-1.3343512,-1.2830263,-1.2333609,-1.1855444,-1.2318688,-1.2380711,-1.2467861,-1.18868,-1.1566639,-1.0750903,-0.9784109,-0.8695762,-0.77494536,-0.70351732,-0.62667088,-0.55129034,-0.55094121,-0.51042048,-0.4878885,-0.45045408,-0.39572831,-0.31436889,-0.21801092,-0.1424905,-0.046893654,0.036272348,0.1147346,0.20779389,0.3117741,0.40528589,0.50023014,0.59817425,0.6847204,0.73060885,0.61264117,0.46246126,0.31739296,0.16770795,0.028951352,-0.1099433,-0.2533403,-0.38441402,-0.51573334,-0.64331697,-0.76746546,-0.88019369,-0.91827272,-0.99452353,-1.0044794,-1.1024064,-1.2242317,-1.2467295,-1.2002924,-1.1980929,-1.1584734,-1.1265268,-1.0557755,-0.93903081,-0.84038975,-0.74042568,-0.62318022,-0.57241216,-0.47106395,-0.38257545,-0.26479428,-0.14931432,-0.044678323,0.058519938,0.11672697,0.19746948,0.32286518,0.43306487,0.49406049,0.59248122,0.714394,0.85320247,0.90045377,0.78669003,0.67933526,0.57733346,0.47161344,0.36619144,0.25846641,0.16968666,0.14972831,0.21078162,0.29223961,0.33256819,0.40638974,0.47770248,0.54451513,0.56954453,0.66947668,0.75767267,0.74413138,0.79837675,0.87381585,0.93225932,0.98191771,1.0421543,1.0890235,1.1493696,1.2290973,1.3189701,1.3463196,1.2232377,1.1039425,0.97956429,0.87516184,0.77202943,0.71525816,0.6220671,0.5035621,0.38275922,0.26337233,0.12881462,-0.0028435805,-0.10732384,-0.20212639,-0.27068003,-0.35523507,-0.52248598,-0.6469645,-0.77926368,-0.93077298,-1.0449359,-1.1298675,-1.2234729,-1.351078,-1.4227646,-1.4675956,-1.5658816,-1.5178263,-1.4935155,-1.4047804,-1.3511645,-1.3093411,-1.2446045,-1.1452268,-1.0381895,-0.92054908,-0.88923214,-0.91812312,-0.89209843,-0.81624885,-0.71798159,-0.64872335,-0.60412322,-0.48287222,-0.36640839,-0.29896351,-0.19415176,-0.095862132,0.022842508,0.13185222,0.24510766,0.35073525,0.46328688,0.57743227,0.66090974,0.59036949,0.5067644,0.44345601,0.41475054,0.39815294,0.43572867,0.54268155,0.65509467,0.76469161,0.87911146,0.99778238,1.1098572,1.1471811,1.2054273,1.3156523,1.4429029,1.5189206,1.6043746,1.7353876,1.844742,1.7382301,1.6155954,1.5122634,1.4207232,1.3109226,1.2197752,1.1418045,1.0446651,0.94340961,0.87050105,0.7589202,0.64112236,0.5605093,0.45873559,0.35554644,0.26793839,0.18008532,0.15820428,0.076099596,0.047726055,0.098220065,0.1497769,0.21608856,0.1871248,0.082468098,-0.011529917,-0.10654914,-0.16173571,-0.19637175,-0.22502936,-0.13318808,-0.25893943,-0.11622945,-0.023043963,0.0033035492,0.061170008,0.16652314,0.28504515,0.41797476,0.53499089,0.65785759,0.79138103,0.89589648,0.99945053,1.1225548,1.2314913,1.2386792,1.2505073:5
2.3799045,2.3222015,2.2544772,2.1840141,2.1308203,2.0602138,1.9798302,1.914382,1.8334722,1.7692976,1.691988,1.6224464,1.5489762,1.4742311,1.407168,1.328609,1.2625302,1.1885794,1.1189501,1.0492492,0.97625608,0.90702444,0.83267142,0.77270465,0.70310191,0.6386478,0.57086621,0.52231519,0.49127205,0.46021534,0.41723909,0.37223372,0.37185818,0.39168623,0.39136665,0.36862988,0.31844263,0.26217004,0.19296263,0.11741769,0.069903444,-4.375201E-4,-0.063493208,-0.11771232,-0.16879928,-0.21434581,-0.24707255,-0.26970689,-0.27676285,-0.27382043,-0.26110219,-0.24647396,-0.22996403,-0.2130419,-0.19877393,-0.18460477,-0.15610555,-0.11643981,-0.078403623,-0.033518944,0.013166761,0.036672648,-0.017882157,-0.040657472,-0.074231098,-0.089451312,-0.051510322,-0.0035414926,0.05656218,0.13416441,0.15367135,0.11176568,0.032540834,-0.039463078,-0.11240103,-0.18029636,-0.24514938,-0.27059709,-0.29325078,-0.36396448,-0.43941896,-0.5034824,-0.58077143,-0.64688746,-0.71973111,-0.78183028,-0.84341084,-0.91300474,-0.97719603,-1.0357511,-1.0899909,-1.151765,-1.2051075,-1.2605653,-1.3173033,-1.3661641,-1.4223924,-1.4823122,-1.5546388,-1.6297627,-1.6843242,-1.7369655,-1.7780157,-1.8107639,-1.8347477,-1.8554418,-1.856756,-1.8486791,-1.8288376,-1.8123844,-1.7793151,-1.7458103,-1.7098463,-1.6647089,-1.6128504,-1.5473087,-1.4861145,-1.4265131,-1.3669444,-1.3064991,-1.2260117,-1.1614344,-1.0935943,-1.0308039,-0.96711083,-0.89824037,-0.83111155,-0.74741772,-0.68976692,-0.62311889,-0.55809529,-0.48764933,-0.41600669,-0.34604114,-0.2765415,-0.20411859,-0.13076289,-0.038829845,0.051584726,0.028387459,-0.055673692,-0.13136021,-0.18475218,-0.20597043,-0.16816432,-0.098117513,-0.021395744,0.051566354,0.1243865,0.202938,0.27862099,0.34901462,0.42777722,0.46697572,0.52188848,0.50281474,0.443245,0.37172538,0.288305,0.19185866,0.13338975,0.078192386,0.010277279,-0.053294876,-0.092988745,-0.13422819,-0.16723242,-0.17854565,-0.17526024,-0.13536356,-0.064622207,0.0026890463,0.072410968,0.15099582,0.22495445,0.29665733,0.36769711,0.44138634,0.51491425,0.58720023,0.66226072,0.73748179,0.80636814,0.88783772,0.96260757,1.0352681,1.1030367,1.182563,1.255878,1.312974,1.2437618,1.1784985,1.1030214,1.0312041,0.96275599,0.89691572,0.89771003,0.95498472,1.037221,1.1087945,1.1884502,1.2771811,1.355243,1.4391659,1.5129259,1.584514,1.6536002,1.6097661,1.6615979,1.7076973,1.692405,1.6168937,1.5505005,1.5531774,1.6328011,1.6362261,1.564482,1.4909917,1.4132495,1.3386635,1.26357,1.1933549,1.1147291,1.0368884,0.96623566,0.89474441,0.83908272,0.80349499,0.82412366,0.85748983,0.90840215,0.96267138,1.0080441,0.92632099,0.857208,0.8586652,0.76081815,0.66311351,0.57805716,0.50117003,0.41997672,0.33316924,0.24750051,0.1735649,0.089097078,0.0079174151,-0.070961936,-0.14589913,-0.23016088,-0.30572211,-0.37957911,-0.4536957,-0.52634757,-0.5899113,-0.66185313,-0.71918764,-0.77235566,-0.80415938,-0.79727204,-0.76479928,-0.71484695,-0.66711474,-0.61257607,-0.55343187,-0.49073013,-0.43252409,-0.37158222,-0.30401735,-0.23054741,-0.16169196,-0.079138694,-0.1020206,-0.061073446,0.022014625,0.090956329,0.14015559,0.058652591,-0.031484588,-0.076478513,-0.17167,-0.25595482,-0.35470937,-0.44013136,-0.52149508,-0.57043809,-0.55089784,-0.48526292,-0.46654268,-0.5640058,-0.65289072,-0.74183058,-0.82602389,-0.9119397,-0.99769016,-1.1002105,-1.1990398,-1.29322,-1.3681068,-1.4620674,-1.555637,-1.6449642,-1.7290008,-1.7900385,-1.8655132,-1.9160162,-1.9714805,-2.0011341,-2.0115014,-2.0038858,-1.9869606,-1.940857,-1.8908422,-1.8291912,-1.7593394,-1.6856521,-1.6139313,-1.5149943,-1.4620116,-1.4136887,-1.3743813,-1.3265153,-1.2825205,-1.2393147,-1.1888067,-1.141347,-1.0932043,-1.0422876,-0.98268666,-0.92468439,-0.86587478,-0.80224799,-0.77316256,-0.70459715,-0.63349207,-0.56892732,-0.50583425,-0.44188462,-0.37255478,-0.3079848,-0.23634513,-0.17547787,-0.15267886,-0.21775546,-0.28368616,-0.34694575,-0.40660954,-0.45999169,-0.50585709,-0.53494984,-0.53552885,-0.45371477,-0.47810993,-0.51343598,-0.5489259,-0.58046467,-0.60523304,-0.62219358,-0.63966797,-0.65849558,-0.66574297,-0.66635648,-0.66154766,-0.65482316,-0.64897708,-0.63210025,-0.60561125,-0.56411935,-0.50981153,-0.44950086,-0.38306676,-0.30807109,-0.23697666,-0.15520028,-0.090605354,-0.032968214,0.021716702,0.071498022,0.12678911,0.17279196,0.216693,0.26200728,0.32761091,0.37552627,0.35947514,0.36792955,0.39186639,0.38167236,0.37286087,0.37149896,0.37672824,0.38875594,0.40712223,0.41981675,0.45800147,0.49638769,0.55128625,0.58327288,0.61674871,0.65183839,0.67100855,0.66593855,0.65349898,0.66046456,0.66393684,0.70383819,0.77539066,0.85728263,0.9352049,1.0091723,1.0833662,1.1629036,1.2324189,1.3049496,1.3829908,1.4490022,1.5261918,1.5980288,1.6681144,1.7473674,1.817018,1.8866601,1.9665624,2.0418026,2.1152466,2.1877031,2.2628279,2.3353271:4
-0.014705371,-0.084908335,-0.16844139,-0.24603483,-0.29899145,-0.25580218,-0.21815845,-0.30260391,-0.38100998,-0.46514698,-0.55007765,-0.63537946,-0.7284063,-0.80877975,-0.87882138,-0.94661104,-0.98429591,-1.029907,-1.0871402,-1.1357003,-1.1882108,-1.2328298,-1.2667587,-1.2982868,-1.3252328,-1.3525999,-1.3729032,-1.3771558,-1.3627878,-1.3434916,-1.2950979,-1.2413602,-1.1532349,-1.0565261,-0.95664222,-0.861027,-0.7522587,-0.69216079,-0.63441797,-0.56726868,-0.51127281,-0.43974716,-0.36409595,-0.29987416,-0.24048664,-0.17748534,-0.12872123,-0.05124353,0.0069837959,0.068697828,0.13368733,0.11879663,0.096027745,0.092822753,0.098829315,0.10398118,0.12324185,0.15074616,0.16605171,0.16993718,0.19582727,0.23593537,0.27800123,0.32774097,0.42463122,0.52162535,0.61248563,0.7020578,0.76779857,0.80533377,0.79766721,0.8338733,0.86233268,0.88447658,0.8803815,0.87776167,0.87252262,0.87741358,0.88356354,0.88923153,0.88528165,0.87161928,0.86985009,0.87441376,0.85513243,0.82254312,0.83327135,0.84818281,0.89485481,0.96797842,0.99828802,1.1116668,1.2135397,1.3205315,1.4103854,1.5168232,1.6073798,1.7178028,1.8230815,1.7460174,1.6428271,1.5330572,1.4325617,1.3314862,1.2503593,1.1613941,1.0835353,1.0339176,0.98686098,0.94389835,0.93810047,0.85746746,0.78029533,0.6818146,0.61414092,0.54229318,0.47898825,0.45128569,0.52866619,0.60966121,0.69615359,0.80502675,0.85559047,0.91764162,0.94034626,0.92473698,0.90619277,0.89173864,0.87734346,0.8785408,0.87419759,0.86909874,0.86147946,0.86505924,0.87891251,0.89053222,0.9040158,0.92086184,0.89586092,0.82364962,0.72022636,0.60750245,0.4995431,0.42837671,0.35946313,0.29339771,0.23736032,0.17558468,0.11741391,0.061365209,0.0049963868,-0.044823689,-0.086367653,-0.15316134,-0.24248714,-0.32785188,-0.39238339,-0.45982527,-0.51445475,-0.57789738,-0.6199926,-0.64976172,-0.67826526,-0.69040569,-0.6985175,-0.7041292,-0.70592759,-0.7019027,-0.66449581,-0.61814446,-0.55976891,-0.50777594,-0.45808814,-0.41426002,-0.36245974,-0.3017228,-0.24741764,-0.16781188,-0.07018727,0.030425116,0.13542466,0.22451444,0.16786678,0.069154603,-0.029656495,-0.13240993,-0.19059695,-0.17112707,-0.10426994,-0.028018815,0.042165072,0.11895661,0.22164838,0.32716258,0.4438227,0.49483948,0.61045015,0.59218524,0.47565918,0.36706836,0.25906407,0.15840164,0.047554959,-0.072720598,-0.18859031,-0.28194453,-0.30887841,-0.26681834,-0.27070377,-0.35292387,-0.47959914,-0.60018255,-0.72788519,-0.84262456,-0.95995815,-1.07488,-1.1945573,-1.3029854,-1.4241535,-1.531029,-1.6373696,-1.7489388,-1.8460055,-1.9490737,-2.0467154,-2.146662,-2.2449099,-2.3341585,-2.4067833,-2.4284082,-2.4239203,-2.4038643,-2.3761822,-2.3161382,-2.2573479,-2.1860395,-2.1067925,-2.0219208,-1.9291604,-1.8277287,-1.7364087,-1.6361406,-1.5498958,-1.4500297,-1.3561397,-1.2555831,-1.1597127,-1.0705094,-0.97227022,-0.88051712,-0.78705793,-0.69394149,-0.6043753,-0.50693297,-0.42010173,-0.32469143,-0.22162454,-0.12079719,-0.0016226491,0.04430316,-0.030635986,-0.14849834,-0.21515517,-0.21311816,-0.1460752,-0.05144664,0.045299714,0.14388645,0.23833402,0.33967233,0.43445046,0.48049364,0.57369703,0.67195734,0.68855408,0.58945653,0.48933722,0.39175402,0.28924949,0.18773258,0.11588565,0.071139628,-0.026350295,-0.12071495,-0.22430145,-0.32379255,-0.41737415,-0.50917874,-0.59490002,-0.65207527,-0.69099166,-0.69478975,-0.67943789,-0.62876583,-0.55579867,-0.47655918,-0.36299449,-0.25568001,-0.1352914,-0.027126685,0.096992525,0.20716234,0.31503045,0.43848035,0.56007966,0.66805377,0.7780226,0.89341585,0.99255259,1.0930393,1.1550434,1.1990942,1.2786684,1.3689195,1.480094,1.4441014,1.3544536,1.2812481,1.2117273,1.1380688,1.0784979,1.0252422,1.0250759,1.1180708,1.2371266,1.3525017,1.4695768,1.5872423,1.6911617,1.8048417,1.8503589,1.7968994,1.9013367,2.025914,2.0828602,1.9713342,1.9872948,1.9548091,1.8455419,1.7366852,1.627541,1.5333307,1.4660779,1.4763911,1.5421464,1.6348063,1.5753368,1.4361572,1.3163441,1.2060997,1.0994745,0.97651452,0.85366548,0.73088949,0.61826041,0.51266356,0.42006575,0.34205626,0.27907599,0.25340014,0.2518363,0.28514379,0.3441931,0.41816934,0.48653836,0.56230345,0.64289359,0.73036552,0.82804343,0.92733563,0.88517612,0.80259157,0.67932504,0.57058344,0.46020595,0.37257166,0.37032166,0.43947909,0.51011078,0.43996143,0.35089417,0.24638568,0.14699054,0.044416383,-0.06583741,-0.17701225,-0.2979562,-0.41031933,-0.53005602,-0.63666849,-0.75702223,-0.8784899,-0.98551016,-1.1070189,-1.2102453,-1.3144107,-1.434373,-1.5402525,-1.6549318,-1.7691263,-1.8880431,-1.9594407,-2.0054602,-2.0231352,-1.9984911,-1.9403014,-1.8312495,-1.7193906,-1.6089288,-1.5108125,-1.4118787,-1.3109449,-1.2016417,-1.1002668,-0.99324888,-0.88593042,-0.78684231,-0.68412849,-0.58421227,-0.48127444,-0.38520229,-0.30797687,-0.34475002,-0.27557702,-0.15834753,-0.049504906,0.016387261:4
1.6979879,1.626276,1.5345609,1.4889488,1.4207654,1.3405039,1.2558462,1.2048819,1.1558414,1.0347882,0.92634274,0.85085015,0.73323575,0.63467005,0.5561794,0.51946508,0.51535288,0.53287374,0.58305531,0.63671471,0.70771805,0.74562317,0.71005867,0.58117313,0.45112833,0.33250775,0.22214583,0.12550307,0.013789711,-0.10638214,-0.22037771,-0.28290072,-0.37015967,-0.47838406,-0.6019064,-0.70473453,-0.80406049,-0.84503281,-0.94582998,-1.0062471,-0.95447813,-0.93049054,-0.83955269,-0.7617117,-0.69813705,-0.59931419,-0.5396811,-0.44194407,-0.3438433,-0.23904166,-0.14315732,-0.042479406,0.065270842,0.16709935,0.22926665,0.26452493,0.28835006,0.361116,0.4400663,0.52243608,0.62526641,0.73471489,0.82413017,0.91867898,0.93914131,1.0344678,1.1424184,1.2661527,1.3690106,1.4798979,1.521749,1.4630814,1.3878141,1.3035523,1.2221813,1.1503002,1.0917365,1.0144112,0.9711732,0.91824146,0.86547353,0.78651373,0.70988022,0.66149868,0.61316598,0.55413054,0.49854055,0.42313724,0.38272122,0.33168026,0.3092493,0.305152,0.3829316,0.45017523,0.51336224,0.55820733,0.59592071,0.52300644,0.44760122,0.37265188,0.28184018,0.22729618,0.1898725,0.11978572,0.052997878,-0.044900655,-0.13037353,-0.2384305,-0.33461607,-0.41936971,-0.56036801,-0.69067734,-0.78178542,-0.86701688,-0.90413389,-0.92831381,-0.97653736,-0.98265879,-1.0310843,-0.99877075,-0.95528242,-0.91288269,-0.86097068,-0.77389481,-0.76655484,-0.69223751,-0.63454062,-0.54986423,-0.45695025,-0.37528924,-0.27389931,-0.19216546,-0.10023123,-0.020729116,0.059891832,0.15063477,0.23278998,0.2989347,0.38034426,0.4670308,0.47756146,0.3720207,0.2907356,0.18671558,0.10182228,0.018950927,-0.083349768,-0.18694211,-0.23143898,-0.20961013,-0.20980834,-0.2632874,-0.33716419,-0.42927766,-0.51732354,-0.53116801,-0.61969046,-0.69887809,-0.7226109,-0.76044198,-0.83600355,-0.92120919,-0.96731388,-1.0347638,-1.1132847,-1.159994,-1.2464233,-1.2720004,-1.3576111,-1.4477918,-1.5299526,-1.5612652,-1.6536594,-1.6780377,-1.6400386,-1.5906531,-1.6407256,-1.7153377,-1.7572725,-1.8349898,-1.8071075,-1.7446057,-1.6387935,-1.5346707,-1.4255939,-1.3115137,-1.2175587,-1.1041389,-0.97495752,-0.86041826,-0.74300003,-0.61686237,-0.50364143,-0.38930285,-0.25896933,-0.15026326,-0.030757447,0.08742166,0.19772559,0.31936532,0.44362387,0.55785527,0.67511852,0.79755768,0.91538333,1.0403311,1.1587753,1.2830698,1.4010327,1.515048,1.6454276,1.7588988,1.8884429,2.0158104,2.1566866,2.2808842,2.3950244,2.5076037,2.4791178,2.5177346,2.4687267,2.5037638,2.4472343,2.3167245,2.2040894,2.076217,1.9468699,1.8308001,1.7156233,1.5998301,1.4850839,1.3691207,1.2579486,1.1397821,1.0245735,0.90967802,0.79468647,0.67956477,0.56381361,0.4366099,0.31914298,0.20504332,0.090942307,-0.038017062,-0.15296431,-0.27004987,-0.39672334,-0.51115821,-0.62822675,-0.75601628,-0.87088328,-0.98450177,-1.1151102,-1.2282071,-1.3579558,-1.4705453,-1.6049969,-1.7393493,-1.8699918,-1.9952935,-2.0895419,-2.1590537,-2.1272961,-2.0429466,-1.9809345,-1.8936126,-1.8423633,-1.7385556,-1.6687902,-1.6043052,-1.5189827,-1.538098,-1.5385387,-1.4628874,-1.4887409,-1.4484818,-1.3480522,-1.2594836,-1.1785753,-1.0857493,-0.9828793,-0.90607605,-0.82714357,-0.76245746,-0.71487545,-0.68068174,-0.63240772,-0.57009051,-0.45880179,-0.38971491,-0.31815564,-0.24469618,-0.14117371,-0.058404852,0.028089711,0.11715754,0.22635436,0.3356819,0.33015136,0.24367416,0.15039157,0.058788527,-0.037917307,-0.1316382,-0.21439493,-0.30472784,-0.41010668,-0.49016881,-0.56932688,-0.63090888,-0.68935122,-0.78558826,-0.86261758,-0.87139785,-0.91617978,-0.88917857,-0.81797225,-0.73069011,-0.68109086,-0.613289,-0.54271017,-0.44769734,-0.37226587,-0.29499941,-0.22076422,-0.13216688,-0.1081735,-0.02500039,0.059531731,0.13461235,0.20620286,0.27747321,0.34926402,0.39995855,0.34535425,0.27853472,0.2192312,0.17328225,0.17102041,0.20402826,0.26317131,0.33462678,0.4148481,0.4994328,0.57484689,0.635159,0.6493004,0.70622241,0.78129466,0.86026131,0.93994836,1.0335054,1.1137352,1.0599228,0.94821288,0.84469478,0.73811102,0.63637601,0.52823509,0.41401922,0.31238186,0.2496383,0.15110441,0.04070185,-0.040532153,-0.14951351,-0.24798532,-0.35016973,-0.45763763,-0.55572165,-0.66162545,-0.76088034,-0.85636815,-0.96375545,-1.0653227,-1.1678968,-1.2717245,-1.3711764,-1.4774389,-1.5252263,-1.485153,-1.4023587,-1.3178384,-1.2025966,-1.0958454,-0.96894773,-0.85601357,-0.75698136,-0.64928524,-0.53529965,-0.42071647,-0.31813466,-0.20510551,-0.10314232,0.023039981,0.14528094,0.25884738,0.38078813,0.49886454,0.59062496,0.72291705,0.84312257,0.95462286,0.98349671,0.91914511,0.85420069,0.78351282,0.69680599,0.63457796,0.58140252,0.61117497,0.66483912,0.71781447,0.79444821,0.89019913,0.99020553,1.0801573,1.1428173,1.171024,1.2331752,1.2934878,1.3639618,1.444064,1.4950876,1.5579019,1.6296774,1.6862147:5
2.4296517,2.354043,2.2448085,2.1694165,2.0603461,1.9850002,1.8761329,1.8005471,1.6920358,1.5858276,1.5080929,1.39938,1.2906808,1.1982106,1.1069396,0.99830037,0.91894343,0.81484446,0.73343513,0.63439506,0.55774173,0.48416813,0.44329476,0.46757418,0.49662512,0.52209672,0.54696291,0.56130323,0.57110594,0.57693807,0.57360799,0.55845147,0.57184456,0.56562324,0.58451507,0.56043993,0.54045757,0.50984639,0.50051473,0.46792411,0.43322484,0.40551337,0.38178114,0.34872394,0.32527525,0.3116075,0.29723414,0.28539339,0.26517945,0.2402431,0.20963183,0.1968915,0.20073344,0.20474902,0.21915172,0.24138332,0.21285121,0.12874478,0.049492341,-0.016039484,-0.10254324,-0.17186602,-0.23689354,-0.32217602,-0.37149668,-0.43028033,-0.46793639,-0.50273599,-0.53414254,-0.56604017,-0.58657597,-0.60853724,-0.62183174,-0.63059241,-0.63608792,-0.63815081,-0.64015953,-0.62516058,-0.61259916,-0.58896875,-0.56274313,-0.54034014,-0.50646475,-0.47597527,-0.43593304,-0.38072535,-0.33753126,-0.28393304,-0.21613196,-0.15576343,-0.078067709,-0.011159037,0.056242687,0.14109893,0.2138229,0.26238744,0.16684524,0.085230973,0.0082717432,-0.097663395,-0.17464381,-0.28325129,-0.35889049,-0.46661062,-0.57517246,-0.68378439,-0.79222343,-0.86683749,-0.96833988,-1.0488992,-1.1292354,-1.2288932,-1.3018924,-1.4093991,-1.516216,-1.625639,-1.7005699,-1.7440621,-1.7842017,-1.8105327,-1.835628,-1.8433172,-1.836314,-1.8125441,-1.7746711,-1.7266987,-1.6711931,-1.6167858,-1.5587916,-1.4857035,-1.4104456,-1.3332335,-1.2532521,-1.1940126,-1.149123,-1.0757391,-0.98315389,-0.90854323,-0.81863044,-0.73825196,-0.64825659,-0.55225429,-0.47979033,-0.38535751,-0.30341533,-0.22129602,-0.12661067,-0.043783293,0.032025037,0.10100284,0.18720744,0.26311093,0.33258065,0.41210941,0.47812968,0.52671892,0.46076798,0.39338484,0.32568464,0.26145828,0.19957466,0.13542067,0.071753621,-7.3688883E-5,-0.066573823,-0.12540722,-0.18312198,-0.24270389,-0.28609214,-0.3129623,-0.2955991,-0.26681039,-0.19401301,-0.11345585,-0.039100636,0.043696132,0.13414122,0.20551154,0.30989561,0.38260247,0.47986747,0.55681729,0.6355417,0.73507882,0.84033779,0.91466894,1.021349,1.1011678,1.2018722,1.3098922,1.3824965,1.3045858,1.3259552,1.4123845,1.3424817,1.2893595,1.2502499,1.2868388,1.3558593,1.438281,1.5142801,1.6230456,1.7318554,1.8116767,1.915696,1.9906837,2.0993084,2.2078698,2.2187664,2.1272103,2.0516361,1.956045,1.871157,1.7967219,1.7232662,1.6156444,1.5412988,1.4333189,1.3330665,1.2961511,1.3117972,1.3716895,1.4423889,1.5249074,1.5652502,1.4709905,1.3628923,1.2550063,1.1476179,1.0404492,0.93274112,0.82622316,0.72024783,0.64620401,0.5417013,0.4353095,0.33098608,0.25378803,0.15610396,0.049164276,-0.057275931,-0.16367436,-0.26703093,-0.37088515,-0.4757111,-0.5797486,-0.6668176,-0.74681777,-0.80703285,-0.85393052,-0.87258901,-0.8781578,-0.82663788,-0.77955568,-0.70854256,-0.64980695,-0.58626721,-0.52285909,-0.4468186,-0.37504977,-0.31113833,-0.23849818,-0.15900877,-0.086388121,-0.023047761,0.048777256,0.13217357,0.21368703,0.28818019,0.34640495,0.2640766,0.1863507,0.10019736,0.032307869,-0.048615235,-0.12847732,-0.19965477,-0.26438345,-0.3052063,-0.39170224,-0.4687592,-0.54179005,-0.61918558,-0.69893722,-0.77670913,-0.84951518,-0.93437638,-1.0048028,-1.0798571,-1.1514938,-1.2317254,-1.298455,-1.3613856,-1.4262171,-1.4983616,-1.5647097,-1.6247671,-1.6788754,-1.7402056,-1.792037,-1.8480974,-1.8778436,-1.8930914,-1.8848037,-1.873046,-1.8394996,-1.7793516,-1.7015878,-1.6244656,-1.5280799,-1.4439377,-1.3367715,-1.2628913,-1.1885459,-1.0821409,-1.0075509,-0.89930683,-0.82452316,-0.74948876,-0.66990303,-0.59701935,-0.52184044,-0.44542074,-0.3747638,-0.34516954,-0.38316013,-0.42656851,-0.46554278,-0.50783094,-0.53431833,-0.51407839,-0.53413549,-0.56619437,-0.60400015,-0.64700833,-0.68331483,-0.7214653,-0.76575553,-0.79435388,-0.83597856,-0.86079474,-0.88391436,-0.90846326,-0.93431827,-0.95650679,-0.97088574,-0.98332982,-0.98993466,-0.99909083,-1.003097,-0.99352228,-0.98427095,-0.97301092,-0.95462933,-0.94806087,-0.93769037,-0.99076748,-1.0182867,-0.97943331,-0.88936336,-0.81058768,-0.7395257,-0.66255679,-0.5749001,-0.50174959,-0.42614873,-0.37351545,-0.34392076,-0.28489495,-0.2460373,-0.21901432,-0.14911971,-0.12755645,-0.12336693,-0.1219564,-0.12166026,-0.099609777,-0.07407395,-0.04650125,-0.013192661,0.0069568598,0.046087753,0.084434941,0.11868483,0.14828547,0.18317683,0.20367693,0.2278832,0.25344124,0.27585735,0.29547106,0.32099594,0.33724064,0.34774466,0.36255158,0.3706979,0.37894425,0.37760608,0.37404868,0.36514351,0.34802979,0.33318401,0.3084475,0.34336617,0.4050238,0.50413548,0.58151424,0.65667029,0.76539177,0.87107343,0.94951891,1.0582662,1.1671482,1.2759597,1.3521094,1.4601658,1.5690664,1.6445205,1.7536386,1.8314699,1.9384115,2.0140371,2.1234392,2.1990523,2.3001634,2.3846907,2.4414815:4
2.6386592,2.4941346,2.2834197,2.0873891,1.8476054,1.6374728,1.4673986,1.2714478,1.0435806,0.83914366,0.63237295,0.4315317,0.23944945,-0.010476242,-0.20568055,-0.45115413,-0.64739236,-0.85518297,-0.93031269,-1.1051282,-1.3127713,-1.5588926,-1.7506359,-1.9482546,-2.0843575,-2.2281601,-2.4650733,-2.662421,-2.8384767,-2.7412044,-2.6102449,-2.4327865,-2.2630407,-2.1181403,-1.9703686,-1.8509093,-1.8504986,-1.7957411,-1.7838633,-1.6504354,-1.5444676,-1.4805268,-1.4480369,-1.3359717,-1.2550388,-1.2085417,-1.1059439,-1.0452435,-1.0016803,-0.88678001,-0.78455138,-0.69081141,-0.72059467,-0.78108876,-0.62831417,-0.58208469,-0.45038449,-0.34888819,-0.32985457,-0.33954506,-0.25173235,-0.1822307,-0.067652038,-0.080430364,-0.016884584,0.10468893,-0.0038250507,-0.18598637,-0.30754497,-0.49221069,-0.51738022,-0.4836414,-0.47791567,-0.39686514,-0.28569129,-0.44509791,-0.43290334,-0.34542781,-0.24216409,-0.25589532,-0.17502869,-0.099808551,-0.0049194175,0.087939516,0.074100286,0.17905706,0.34983515,0.43552515,0.57116068,0.70930974,0.83680821,0.889329,0.86777638,0.81498974,0.70160778,0.55388412,0.3985059,0.236956,0.1178386,0.14771536,-0.016524089,-0.17300125,-0.31477535,-0.49419591,-0.52935908,-0.68517501,-0.82732189,-0.75243768,-0.64515471,-0.58704596,-0.51287989,-0.42414594,-0.2955015,-0.28075068,-0.18004394,-0.14718903,-0.045804233,0.015757123,0.14863215,0.23559329,0.36705482,0.47107635,0.59087045,0.66425874,0.76737312,0.85636611,0.97520876,1.0758807,1.1862913,1.3195834,1.4407825,1.4827407,1.5382435,1.5976416,1.6299515,1.5356961,1.3333978,1.1626065,0.96033611,0.88293175,0.77677293,0.59600225,0.55604273,0.47914877,0.39015977,0.235558,0.28864814,0.13884106,0.094875376,-0.033029072,-0.11555109,-0.19692007,-0.053401871,-0.11239978,0.019960418,0.073698045,0.17129208,0.31275135,0.43445584,0.55152165,0.62759143,0.6882539,0.81898558,0.96073841,1.0430597,1.1985898,1.3492417,1.515133,1.6967325,1.7744589,1.8434616,1.7262625,1.527174,1.3628037,1.1927657,1.0164701,0.9294746,0.78845151,0.75746423,0.71160884,0.61958382,0.60203778,0.4436174,0.44820571,0.35783002,0.26035263,0.08532786,-0.062750778,-0.22555505,-0.39015537,-0.48134085,-0.65805678,-0.84004333,-0.99108637,-0.90078839,-0.74289671,-0.60028641,-0.39473577,-0.30890006,-0.17188552,-0.09033201,-0.070748674,-0.11166916,-0.012287772,0.012355854,0.078689811,0.12375553,0.15515713,0.064302314,0.12558758,-0.026936532,-0.028843141,0.040386832,-0.070035054,-0.19575852,-0.3118815,-0.44836076,-0.53120656,-0.53603435,-0.65182862,-0.80783342,-0.85420159,-1.023313,-1.1587525,-1.2455676,-1.4008271,-1.5708756,-1.4427304,-1.299065,-1.1231416,-1.0725297,-0.93674763,-0.84041777,-0.66652211,-0.49698396,-0.34234411,-0.24183845,-0.17463503,0.0027363428,0.13757068,0.1616198,0.29330073,0.40107916,0.53497426,0.68385339,0.82436263,0.97091862,1.1385224,1.2324808,1.3621678,1.545369,1.6827514,1.8324184,1.9614472,1.8580049,1.6984764,1.4762026,1.3915831,1.1759646,1.2323572,1.0953331,0.95428346,0.81517115,0.70679726,0.8259873,0.70139151,0.567015,0.49407339,0.31381122,0.17457542,0.27703438,0.151733,0.04164098,-0.12583741,-0.098146993,-0.27132164,-0.43897329,-0.57790193,-0.60377452,-0.58083645,-0.39654698,-0.32509511,-0.19853151,-0.018296579,0.1136798,0.23784359,0.33175043,0.44620994,0.54075365,0.66122396,0.74984847,0.90857172,1.0400545,1.1988769,1.3186333,1.4374199,1.3694881,1.2247096,1.0684806,1.0174913,0.8642456,0.8152449,0.65167463,0.52034194,0.60999581,0.53923422,0.41503554,0.3033982,0.20011078,0.36935408,0.30886628,0.19222473,0.15036936,0.030857232,-0.09416535,-0.075323525,-0.1473086,-0.25573861,-0.36284774,-0.47453867,-0.56723372,-0.65811983,-0.70746377,-0.71163332,-0.7237496,-0.4784867,-0.31913581,-0.47614848,-0.34771396,-0.15881165,-0.020083001,0.1291851,0.35124843,0.59691481,0.74329839,0.58296602,0.45798428,0.36416647,0.30564715,0.22635401,0.10742325,0.046916751,0.17547732,0.10175565,0.023021719,-0.034935342,-0.11830495,-0.19179706,-0.16016423,-0.093933015,-0.19838713,-0.28475971,-0.33793355,-0.37992704,-0.4297252,-0.49137635,-0.53854509,-0.63692692,-0.59341382,-0.59418405,-0.52774768,-0.36287749,-0.27365556,-0.12826874,0.051071848,-0.0041822687,-0.073008341,-0.1172271,-0.061447685,-0.079142896,-0.16756937,-0.15163349,-0.21396843,-0.28265829,-0.35097122,-0.45177568,-0.41182179,-0.51460705,-0.52417243,-0.56144927,-0.49603623,-0.62291811,-0.70339163,-0.72622492,-0.78994357,-0.96531318,-1.0178577,-1.0432612,-1.1454109,-1.2639554,-1.3178745,-1.4377361,-1.504714,-1.5635075,-1.6738772,-1.8029842,-1.9324621,-2.0602781,-2.2190839,-2.3405363,-2.1221225,-1.9177184,-1.688442,-1.4452815,-1.2492254,-1.0162277,-0.80941986,-0.61092337,-0.37827106,-0.16998177,0.027137218,0.2237807,0.42260245,0.62548311,0.85628668,1.0506772,1.2253485,1.4184854,1.6266178,1.8166425,2.0144753,2.2163292,2.4070848,2.5214574,2.6190251,2.707061,2.7182985:1
1.9686269,1.8229719,1.6825665,1.6062073,1.5174221,1.4269487,1.3290748,1.2454703,1.1850813,1.0520445,0.87860201,0.86402216,0.71734943,0.60986237,0.51223766,0.49846836,0.54060891,0.64283047,0.62672649,0.46209731,0.29798961,0.1608441,0.01036135,-0.12259817,-0.25421013,-0.30660326,-0.43026917,-0.50799024,-0.60699727,-0.71645978,-0.75344911,-0.65171188,-0.53809417,-0.53314616,-0.62446071,-0.74074857,-0.85837849,-0.97757738,-1.0797991,-1.2204783,-1.3416,-1.4483504,-1.477346,-1.3753909,-1.238737,-1.1446413,-1.0217292,-0.93823534,-0.80761242,-0.68331197,-0.58282984,-0.48494001,-0.37820602,-0.27312448,-0.1974723,-0.085199488,0.030205735,0.15745242,0.24592616,0.32967074,0.45557311,0.55623043,0.67695246,0.7605756,0.87276095,0.96224926,0.91582615,0.78009843,0.72233436,0.63601404,0.5295169,0.40467349,0.27568907,0.1508676,0.025297202,-0.093473923,-0.21392529,-0.3378805,-0.44518767,-0.56283184,-0.6736612,-0.74330329,-0.77596978,-0.90121402,-0.94512517,-1.0819271,-1.1838923,-1.2508553,-1.3676038,-1.4010106,-1.53928,-1.5771117,-1.5358965,-1.4670404,-1.3827104,-1.323915,-1.2697739,-1.18583,-1.1017397,-1.1007644,-1.2749686,-1.4251329,-1.5419759,-1.6002398,-1.5202375,-1.4302874,-1.3336541,-1.2174526,-1.114769,-0.99338427,-0.85604984,-0.73616727,-0.6620734,-0.76020618,-0.8793525,-0.95946747,-0.9801949,-0.81790113,-0.65802941,-0.50761065,-0.36347525,-0.35268929,-0.40411187,-0.31309394,-0.14349435,-0.023969454,0.12446884,0.26713805,0.41443582,0.504972,0.58424185,0.66950255,0.76358197,0.86402005,0.97195596,1.0781043,1.1962566,1.3203,1.4414035,1.5758818,1.7130452,1.8578961,2.0025486,2.1402072,2.2719277,2.1242031,1.9747964,1.829102,1.6872175,1.5495482,1.41636,1.2880332,1.1649535,1.0476109,0.93616829,0.8315178,0.73353914,0.64312206,0.56073372,0.48807913,0.4230422,0.36562138,0.3185388,0.28204485,0.25573,0.23948236,0.23368529,0.2387934,0.25423476,0.27970338,0.3160641,0.36181085,0.41751711,0.48226615,0.55638735,0.52448606,0.45459048,0.39135539,0.33885922,0.29458023,0.25896617,0.23468962,0.22211614,0.21913408,0.2273099,0.24267901,0.27191053,0.30944047,0.34765281,0.34291925,0.21445038,0.073325885,-0.060121743,-0.17788768,-0.29787127,-0.4045824,-0.54867387,-0.71404359,-0.87941898,-1.0574797,-1.2496257,-1.434383,-1.5932618,-1.7143915,-1.8951078,-1.8994058,-1.8958739,-1.7607672,-1.5791852,-1.3971704,-1.2298618,-1.1007149,-0.9815329,-0.90279664,-0.80078698,-0.65300015,-0.48650826,-0.40193532,-0.49202353,-0.61298385,-0.72550334,-0.8297698,-0.71494687,-0.60356582,-0.49850842,-0.34598205,-0.25329066,-0.18943356,-0.037550424,0.10564002,0.23783599,0.38260403,0.54035652,0.63514558,0.69655328,0.56070053,0.45678685,0.37218738,0.29533568,0.15916973,0.083939152,-0.011010129,-0.14573591,-0.25878918,-0.35597153,-0.42321437,-0.41976409,-0.38338561,-0.47097017,-0.60656786,-0.73686247,-0.87319698,-0.9922079,-1.1106518,-1.2144069,-1.3315099,-1.4646954,-1.6051753,-1.7130097,-1.7861029,-1.8944735,-1.9855407,-2.1320166,-2.2541996,-2.3419286,-2.3608711,-2.23764,-2.0827579,-1.9192972,-1.7625662,-1.6397492,-1.505503,-1.3596888,-1.1926621,-1.0574797,-0.90895975,-0.75100836,-0.56982274,-0.39642359,-0.24769577,-0.12956464,-0.041650897,0.062300443,0.18230721,0.1245648,0.066036977,0.0076845071,-0.062698099,-0.020768544,0.11032323,0.23954574,0.32739336,0.35818935,0.3812889,0.51831307,0.61308673,0.68412046,0.81172572,0.85283492,0.93975615,0.99994936,1.0263552,1.0413759,1.0207224,1.0992448,1.0519275,0.98375358,0.91448176,0.80816036,0.72602648,0.6322503,0.53825483,0.46159381,0.41565106,0.46292556,0.57807352,0.69798988,0.82371308,0.95547124,0.88805077,0.74848748,0.58553048,0.42959412,0.29476083,0.20468396,0.08023145,-0.066168327,-0.21229768,-0.35864657,-0.48072354,-0.60887796,-0.66968891,-0.74758629,-0.87543094,-1.018769,-1.1621836,-1.2997299,-1.3920578,-1.4529884,-1.4922897,-1.5048003,-1.4279724,-1.3148767,-1.2222719,-1.1542561,-1.0394521,-0.93265297,-0.83824844,-0.70664567,-0.59513709,-0.46532774,-0.31891182,-0.17312644,-0.025562001,0.11887385,0.26478815,0.41467278,0.54745643,0.52364922,0.60809171,0.72753541,0.88396198,1.0412112,1.184152,1.3157681,1.4561997,1.6088575,1.7564075,1.9097817,1.8854231,1.7345196,1.622053,1.5027461,1.4580383,1.3775967,1.2576704,1.2832283,1.2303611,1.1759208,1.0995021,1.0248663,0.95995759,0.84508172,0.80693705,0.88430378,1.0260483,1.171751,1.3069209,1.4627499,1.6425341,1.6945219,1.5714422,1.4070684,1.3157505,1.2173335,1.1294259,0.99566434,0.86946399,0.74773571,0.662372,0.5308348,0.40179513,0.26177657,0.056265159,-0.027723383,-0.14766908,-0.26899404,-0.44188821,-0.5131856,-0.57593908,-0.55824697,-0.40916455,-0.23796092,-0.047675884,0.12032413,0.30211309,0.4843573,0.65564938,0.85017178,1.0102022,1.0976579,1.2448845,1.4116698,1.5680084,1.7154687,1.8729808,1.93075:5
2.2222296,2.1394081,2.072267,1.9594398,1.8833767,1.7746588,1.7101456,1.6300876,1.5575484,1.4733737,1.3833981,1.2865048,1.2206443,1.1477553,1.0795635,1.0088822,0.95066634,0.87413009,0.78011249,0.67848012,0.58909896,0.48926369,0.39132316,0.29227232,0.19548375,0.090299419,1.6222198E-5,-0.10554073,-0.19740103,-0.30114289,-0.39035614,-0.48907178,-0.58470129,-0.68244164,-0.77236414,-0.86336962,-0.95505663,-1.0475084,-1.1427601,-1.2371775,-1.3246873,-1.4172282,-1.5105275,-1.6016862,-1.6887809,-1.731326,-1.8123811,-1.747356,-1.6729942,-1.6009188,-1.5316559,-1.476528,-1.4276697,-1.3736126,-1.299667,-1.2698106,-1.2016727,-1.1356397,-1.1553813,-1.2192389,-1.2793397,-1.3302264,-1.3612779,-1.4325789,-1.5005774,-1.5482318,-1.5812691,-1.5589293,-1.5233611,-1.5193815,-1.4764558,-1.4711953,-1.4144692,-1.3333839,-1.2699111,-1.1926448,-1.1510805,-1.0762895,-0.99467472,-0.96813803,-0.92249437,-0.86152007,-0.78219039,-0.76190597,-0.7014073,-0.61461679,-0.60268854,-0.57618202,-0.53196891,-0.48507935,-0.40521431,-0.31778997,-0.23473724,-0.1527211,-0.062563829,0.021147831,0.044888271,1.638359E-4,-0.084395957,-0.17101919,-0.17083392,-0.16068543,-0.16484792,-0.13183005,-0.068510743,0.022189116,0.11813677,0.1926588,0.25130047,0.33747729,0.42974684,0.48902788,0.55094378,0.59351382,0.64974026,0.66784427,0.70523678,0.71536668,0.78341444,0.83379591,0.88656443,0.93958663,0.99314028,0.99850776,0.95166505,0.88887618,0.83504818,0.76750726,0.69783152,0.63134499,0.55816657,0.48149378,0.40117816,0.32964707,0.25025052,0.17936224,0.11847615,0.076906558,0.029865759,-0.029268725,-0.096192152,-0.16195852,-0.21311284,-0.27270465,-0.32830799,-0.43263681,-0.52029803,-0.62382813,-0.74525293,-0.8489536,-0.94810399,-0.99606941,-1.0429958,-1.0989938,-1.1391966,-1.1160229,-1.1444661,-1.1905004,-1.1317138,-1.0612914,-0.97291732,-0.86676774,-0.78887622,-0.69312494,-0.64987479,-0.55297319,-0.4690669,-0.41626855,-0.32110086,-0.23247397,-0.14836739,-0.075032006,0.011932753,0.088158495,0.17245857,0.22776258,0.29465921,0.37288531,0.4460794,0.51229568,0.57754948,0.64021945,0.6641921,0.63855941,0.63222277,0.61900502,0.64582934,0.73271683,0.76570133,0.84918568,0.93052952,1.0159487,1.0889598,1.1639976,1.2007756,1.261293,1.3378231,1.4158747,1.4836872,1.5445111,1.5886808,1.5994291,1.5592927,1.5009302,1.4632657,1.3936052,1.3345469,1.2903315,1.2672102,1.2395344,1.1747463,1.0976981,1.0214697,0.94143309,0.86184263,0.79363736,0.75105319,0.68963974,0.69973933,0.70653141,0.76593351,0.81683166,0.85528852,0.79798316,0.72662957,0.65545059,0.58882049,0.51035262,0.42875746,0.36114787,0.28747521,0.19638665,0.11982627,0.047241857,-0.045318726,-0.12700695,-0.22040182,-0.29967718,-0.38443655,-0.47152754,-0.55447012,-0.63811489,-0.7212847,-0.80975053,-0.89519496,-0.98536221,-1.059617,-1.1277899,-1.1621865,-1.2160981,-1.1763436,-1.1308181,-1.0787676,-1.0129971,-0.94034487,-0.85349445,-0.74704772,-0.64070895,-0.53236744,-0.42639982,-0.33073155,-0.22449508,-0.13222909,-0.046792944,0.032199808,0.11423858,0.19256346,0.27882599,0.36019017,0.43599421,0.49514711,0.56767527,0.63022329,0.70999529,0.79356393,0.86210684,0.93955105,1.0100854,1.0846617,1.1587876,1.2227746,1.3034161,1.3824849,1.4518679,1.4291,1.3720371,1.3243502,1.260295,1.2017513,1.1439992,1.0972799,1.0333862,0.98974562,0.98290654,0.95124469,0.88755794,0.80334974,0.71158036,0.64245752,0.55459091,0.46210288,0.38919983,0.35482235,0.36819042,0.38183658,0.43728544,0.47883113,0.54708528,0.61991152,0.67547318,0.66463686,0.58911552,0.50980447,0.42937356,0.3591536,0.28204854,0.20324952,0.12766009,0.047927327,-0.025663156,-0.11523915,-0.1697227,-0.24610953,-0.33140742,-0.39530581,-0.4723657,-0.51708932,-0.55135454,-0.58155768,-0.63941083,-0.69823416,-0.71055799,-0.74396249,-0.79454508,-0.8490276,-0.79077919,-0.83345175,-0.78090226,-0.72767376,-0.64622217,-0.57069395,-0.51058793,-0.45366201,-0.3911334,-0.3280995,-0.29707896,-0.23544542,-0.29287351,-0.36859507,-0.45108068,-0.5292854,-0.58470089,-0.6410317,-0.70887182,-0.76706685,-0.84924072,-0.92975601,-0.97950777,-0.98906707,-1.0000189,-1.0257526,-1.0792875,-1.1232846,-1.1805485,-1.1968453,-1.2899001,-1.3255893,-1.4399155,-1.513252,-1.6048065,-1.6036686,-1.6837255,-1.7665832,-1.7682678,-1.8134394,-1.8718194,-1.7984788,-1.7136047,-1.6319644,-1.5496312,-1.4625379,-1.3797075,-1.2906964,-1.2034276,-1.1125627,-1.0234648,-0.92808005,-0.83404783,-0.74466017,-0.6532368,-0.56065696,-0.46964242,-0.37821811,-0.28602053,-0.1941187,-0.091733486,-0.0014317991,0.10040485,0.19242994,0.29081573,0.38750758,0.48542151,0.58127184,0.67244763,0.77660975,0.87159504,0.96505363,1.0593375,1.1517694,1.2371073,1.3290731,1.4196002,1.4993091,1.5846438,1.6693362,1.72488,1.7916209,1.8786171,1.969807,2.0761568,2.1589259,2.2041237,2.2132347,2.2154354,2.2237742,2.2439272,2.2458213:5
2.531198,2.4375822,2.3552828,2.2346363,2.1275432,2.0003367,1.8822909,1.7766222,1.6620062,1.552115,1.4365542,1.3042301,1.1779061,1.066909,0.99521021,0.89404367,0.76232196,0.64329688,0.52684662,0.40891591,0.29349329,0.18947125,0.064093652,-0.061683323,-0.17277694,-0.29126771,-0.41047882,-0.52211509,-0.63634697,-0.77141852,-0.88000786,-1.001895,-1.1213941,-1.1755579,-1.2916669,-1.4096708,-1.5160051,-1.653816,-1.7602265,-1.8854262,-2.0001927,-2.118494,-2.2271223,-2.3634164,-2.4265087,-2.3267365,-2.1883478,-2.0819596,-1.9806204,-1.8860967,-1.7943051,-1.7233028,-1.620592,-1.5416959,-1.4720484,-1.4033838,-1.352587,-1.3270378,-1.2747216,-1.2590994,-1.1641489,-1.0885174,-1.002907,-0.9364953,-0.87062939,-0.8307759,-0.76940289,-0.69166591,-0.70907203,-0.64649543,-0.56159918,-0.532176,-0.46470263,-0.4965182,-0.59724183,-0.73821852,-0.86565478,-0.98599722,-1.0337645,-0.945148,-0.90711362,-0.83080446,-0.74637629,-0.66669436,-0.64659938,-0.57834405,-0.51394937,-0.42144119,-0.36063067,-0.32153446,-0.2999856,-0.25043115,-0.17302266,-0.15473688,-0.097031723,-0.0072248718,0.065838956,0.13681346,0.23100518,0.20501805,0.084297445,-0.017035526,-0.15321939,-0.27474976,-0.38853156,-0.50087846,-0.62769528,-0.74560968,-0.81723289,-0.80907128,-0.93817512,-0.98906733,-1.0903344,-0.99894294,-0.91130898,-0.81503106,-0.70855635,-0.6219005,-0.50908224,-0.43381741,-0.33581903,-0.25987897,-0.16789015,-0.13994406,-0.09158634,-0.025587268,0.049100208,0.12967909,0.22635665,0.26977552,0.29287188,0.41031458,0.44993875,0.53675183,0.63025257,0.78008246,0.84820376,0.95143842,1.0538986,0.98505108,0.8799235,0.74846562,0.63783405,0.51388114,0.43842375,0.30990797,0.2345219,0.12281292,0.056562108,0.015959094,-0.074986986,-0.14681387,-0.23781899,-0.36581708,-0.47831131,-0.57287793,-0.56535745,-0.47226192,-0.36777592,-0.30806158,-0.22487228,-0.12068779,-0.039301745,0.049442842,0.14072547,0.2313926,0.29906965,0.357494,0.35328664,0.42590764,0.43507541,0.51341483,0.61490116,0.70914702,0.78603902,0.8770442,0.97473181,1.0502643,1.0897777,1.1693506,1.2610195,1.3351439,1.4188914,1.5005782,1.6039663,1.7004934,1.7840562,1.7242723,1.5719955,1.4167016,1.2626751,1.2196513,1.0860097,0.98643931,0.91790483,0.78845396,0.73427179,0.63181544,0.52633073,0.53140178,0.43877846,0.293337,0.14828773,0.0056548031,-0.11897471,-0.24213718,-0.19312989,-0.09645767,-7.3551435E-4,0.11313036,0.23809314,0.3204857,0.43703968,0.55307705,0.68718783,0.7899392,0.91999403,1.0327928,1.1457947,1.2152399,1.1904587,1.0865268,1.0123386,0.93093359,0.93740299,0.89859101,0.82553936,0.73684046,0.71259407,0.64851901,0.54412589,0.42487214,0.32715006,0.26338266,0.14712964,0.053184247,-0.043704465,-0.145296,-0.25225562,-0.36396713,-0.4587073,-0.44156378,-0.28728896,-0.13972116,-0.059810452,0.0078697533,0.12976425,0.25352939,0.30196574,0.3843672,0.5170981,0.5615928,0.65272434,0.80172874,0.82484033,0.9843212,1.1027454,1.2628642,1.3793839,1.4517217,1.3512329,1.2609457,1.1683883,1.101148,0.98514314,0.98206409,0.90780474,0.82367883,0.73639598,0.76577691,0.68751477,0.60057362,0.52774679,0.45679437,0.353553,0.27410139,0.33409866,0.27066657,0.15142587,0.055226226,-0.033741907,-0.10981109,-0.21905955,-0.29268497,-0.40201898,-0.47733062,-0.56185048,-0.45999911,-0.36656982,-0.25458805,-0.13205487,-0.030118659,5.6357249E-5,0.078015283,0.18717771,0.28172306,0.38903728,0.52648448,0.62310546,0.74029193,0.84651641,0.87988585,0.84486755,0.76459167,0.67670992,0.58058824,0.53456573,0.42598985,0.33800471,0.31352733,0.25168577,0.1752276,0.09209337,-0.015362812,-0.12220461,-0.19226194,-0.25683858,-0.31763333,-0.39770169,-0.49874844,-0.61227125,-0.67546937,-0.77389738,-0.88567978,-0.98749222,-1.0243157,-0.93945723,-0.8168117,-0.67762859,-0.54626894,-0.41556858,-0.27571431,-0.14579166,-0.031980383,0.063796464,-0.022635067,-0.09856929,-0.18584778,-0.24919683,-0.25054455,-0.33503371,-0.39166136,-0.46866161,-0.48459388,-0.4874224,-0.55592931,-0.62187302,-0.68712291,-0.70146417,-0.77334105,-0.85250906,-0.93180628,-0.98745711,-0.83264186,-0.70840432,-0.59643088,-0.45919961,-0.33826703,-0.3917981,-0.45304952,-0.48086427,-0.55192322,-0.62586888,-0.64672352,-0.70554646,-0.7732502,-0.84421343,-0.90777876,-0.97209574,-1.069619,-1.1822929,-1.2886996,-1.2263634,-1.2894375,-1.3731333,-1.4735757,-1.5372201,-1.6543276,-1.750609,-1.8492577,-1.9822473,-2.0773913,-2.1161399,-2.0001061,-1.8961872,-1.7759615,-1.6600278,-1.541593,-1.4171533,-1.2996458,-1.1790034,-1.0706065,-0.95708697,-0.83741396,-0.72113038,-0.60038294,-0.48784714,-0.37311362,-0.25891307,-0.13628161,-0.0094592933,0.10600133,0.21997156,0.34220908,0.45406937,0.58516207,0.70094092,0.81183161,0.92842097,1.0483713,1.1616219,1.2726936,1.3876475,1.508622,1.6363092,1.7479622,1.8587218,1.983242,2.0993738,2.1696266,2.2710596,2.3972441,2.5287413,2.5835221,2.6079947,2.6246432,2.6054065:1
1.7439209,1.6859998,1.6184017,1.560125,1.517459,1.4519887,1.3832152,1.3285239,1.2490252,1.1655207,1.0937217,1.0046667,0.92010169,0.84468318,0.75224002,0.65238735,0.55195697,0.45141839,0.35142518,0.25922796,0.15233259,0.053467333,-0.045371915,-0.14351295,-0.24177944,-0.30892788,-0.29532686,-0.21829857,-0.13866977,-0.057273041,0.030921322,0.12264928,0.20550464,0.29960826,0.38698838,0.46480942,0.54178104,0.61268547,0.68531181,0.74121329,0.80235575,0.85834887,0.92665538,0.95353015,0.97060146,0.98671717,0.95892299,0.9756572,0.94540082,0.91938014,0.8732497,0.84234942,0.79945672,0.74365667,0.67895005,0.61220546,0.53626119,0.46772279,0.39401318,0.27847831,0.16618533,0.047391244,-0.070310918,-0.19693959,-0.32177484,-0.41671652,-0.51413932,-0.61208497,-0.72664219,-0.84769036,-0.93601206,-1.0484188,-1.1472241,-1.2387347,-1.3554258,-1.4527231,-1.464135,-1.4597162,-1.4030856,-1.3384378,-1.2447248,-1.1520846,-1.0878968,-1.0899997,-1.044029,-0.97723375,-0.86470857,-0.76446524,-0.66465203,-0.56550789,-0.4888175,-0.41022922,-0.31108981,-0.19726202,-0.074744617,0.02665515,0.084455439,0.1765811,0.24942522,0.31405215,0.38051715,0.45021285,0.50654657,0.53598238,0.57117733,0.58110356,0.59108377,0.59026135,0.56377998,0.52987052,0.4868875,0.44548246,0.39804581,0.35680339,0.32764224,0.29344217,0.25226708,0.20451879,0.15770921,0.11625621,0.074807156,0.018639417,-0.024054672,-0.057001395,-0.12626504,-0.1869127,-0.2500563,-0.33484167,-0.43504766,-0.52733751,-0.63292044,-0.7579042,-0.87615688,-0.98331516,-1.1189469,-1.2532994,-1.3442423,-1.4777068,-1.5642163,-1.656168,-1.7392586,-1.7621155,-1.7770565,-1.6755427,-1.588149,-1.4921189,-1.3960644,-1.304901,-1.1949867,-1.0907584,-0.98625803,-0.87762435,-0.77671984,-0.69154346,-0.60188851,-0.53026087,-0.45701161,-0.38541982,-0.31290076,-0.26446958,-0.23229842,-0.21161793,-0.20439706,-0.2127361,-0.209055,-0.2292484,-0.18630864,-0.23946291,-0.25931666,-0.33187556,-0.42153333,-0.52983367,-0.55719352,-0.56189457,-0.54906563,-0.47500386,-0.44028707,-0.42003249,-0.39835009,-0.36879471,-0.34834714,-0.33817685,-0.31755804,-0.29999214,-0.26785676,-0.24981898,-0.20940857,-0.15639879,-0.089023857,-0.010204593,0.10569734,0.19510042,0.32254128,0.41700673,0.55245291,0.6707671,0.78403956,0.92322349,1.0197732,1.1537361,1.2573013,1.3842281,1.4934612,1.6227539,1.7305759,1.8308136,1.9533611,2.0719187,2.1787458,2.2826152,2.3864307,2.4710777,2.551885,2.5612348,2.5243711,2.4644692,2.3631588,2.2259452,2.1266392,1.9899302,1.8865742,1.7516784,1.6517148,1.5127109,1.412891,1.3019276,1.1739688,1.0665106,0.96426439,0.8592054,0.75930513,0.68178688,0.60707096,0.52010231,0.45487549,0.39785884,0.35164661,0.35889484,0.35882368,0.38207119,0.3699986,0.33653723,0.32675157,0.31526132,0.29525164,0.2608135,0.2300228,0.2086695,0.17938418,0.1492098,0.13090303,0.10564483,0.065319046,0.024312244,-0.020246887,-0.092126917,-0.13950229,-0.21404889,-0.33685456,-0.4741006,-0.57430816,-0.67993401,-0.78891683,-0.87472294,-0.96471262,-1.0449833,-1.1366988,-1.2320225,-1.3005722,-1.3188568,-1.2756853,-1.2094747,-1.1362913,-1.0624286,-0.98039274,-0.88910501,-0.80523585,-0.72155211,-0.62284026,-0.5476543,-0.46475504,-0.39177049,-0.30508913,-0.22427564,-0.14701737,-0.064290849,0.010960713,0.077422692,0.13455616,0.17819052,0.21777721,0.26597894,0.30446228,0.33396239,0.36146507,0.37763143,0.39367934,0.41213393,0.41892173,0.42372628,0.41491289,0.40681904,0.39545079,0.37874782,0.33617374,0.25951953,0.1882762,0.11039796,0.023012964,-0.065902061,-0.17051746,-0.25428712,-0.35901952,-0.45114709,-0.5474333,-0.65092178,-0.75907456,-0.86575685,-0.94625249,-1.0491975,-1.1574237,-1.2665915,-1.3668054,-1.4607398,-1.5817948,-1.6634108,-1.7673168,-1.8767793,-1.982264,-2.0750125,-2.1667921,-2.2657335,-2.3540591,-2.4256597,-2.4486175,-2.434295,-2.3923629,-2.3218343,-2.249995,-2.155759,-2.0599909,-1.9631891,-1.8529008,-1.7529388,-1.6654531,-1.5404347,-1.4390593,-1.3331619,-1.2339228,-1.1336557,-1.0326176,-0.9321649,-0.84766364,-0.76484813,-0.6639414,-0.58325798,-0.49214334,-0.42181161,-0.34483296,-0.2564162,-0.19087475,-0.11031915,-0.044075437,0.021357374,0.090076704,0.16772782,0.23062276,0.29665287,0.36594338,0.42959163,0.48889546,0.56219195,0.62912857,0.69408938,0.76606697,0.82805171,0.84841086,0.83663292,0.80310498,0.74273752,0.69007894,0.63409314,0.55173224,0.48533904,0.42175045,0.32259244,0.21768313,0.13387425,0.061623348,-0.030504224,-0.12676332,-0.17916942,-0.22003686,-0.27219149,-0.3421615,-0.43263394,-0.43417723,-0.42315297,-0.38316845,-0.31908612,-0.20260574,-0.10063635,0.0029654021,0.10478144,0.19880376,0.32489843,0.4268349,0.55013792,0.66646777,0.781932,0.8837518,0.96879718,1.0877837,1.1596853,1.2340691,1.3140727,1.4035284,1.4451864,1.5058391,1.547926,1.6178602,1.6673107,1.7165285,1.7612266,1.7886878,1.8129298,1.7841076:2
2.5086195,2.4891749,2.4051006,2.3183263,2.2496077,2.1767315,2.115412,2.0348509,1.9561345,1.8905953,1.8132263,1.7487426,1.6632497,1.5864787,1.5279547,1.4475478,1.3836678,1.3137147,1.225602,1.1602178,1.0902892,1.0450108,1.006638,0.92018712,0.86103134,0.79065494,0.72961308,0.65255477,0.57956094,0.5202891,0.45314883,0.3706204,0.31150638,0.24106795,0.18575711,0.11110484,0.048049491,-9.8734492E-4,-0.066046344,-0.12218471,-0.20314692,-0.26611723,-0.33127204,-0.40125826,-0.48365677,-0.56025106,-0.63778002,-0.71563585,-0.79644418,-0.89556662,-0.97243514,-1.0418166,-1.0923841,-1.1878909,-1.2721432,-1.3713499,-1.4453612,-1.5250139,-1.5878912,-1.6817836,-1.7601572,-1.7153248,-1.6829671,-1.6415583,-1.6343786,-1.6099962,-1.5749244,-1.5481039,-1.5046433,-1.4386625,-1.3942576,-1.3745275,-1.3421237,-1.3269689,-1.3219575,-1.3369041,-1.4027385,-1.3797964,-1.3641265,-1.2987222,-1.2682527,-1.2170354,-1.1841921,-1.1705944,-1.1003916,-1.0464366,-1.0165864,-0.99514049,-0.94474357,-0.90895145,-0.87642319,-0.86243342,-0.88160533,-0.97579698,-1.0291788,-1.0762355,-1.0366637,-0.9757005,-0.90260495,-0.85677887,-0.80360762,-0.7501584,-0.73081878,-0.68229065,-0.62096717,-0.56803701,-0.51487888,-0.46556543,-0.41622676,-0.38096121,-0.35543417,-0.34198066,-0.36384613,-0.43233552,-0.38964063,-0.36729757,-0.30923921,-0.23515825,-0.1689285,-0.08845293,-0.014771422,0.01118731,0.012654417,0.083150642,0.16431384,0.23711717,0.31417516,0.38965945,0.47558254,0.54174772,0.62406729,0.67643487,0.68709153,0.62352749,0.55853666,0.48870536,0.41057264,0.34355788,0.27261129,0.20274916,0.14045205,0.071459008,8.0017004E-4,-0.066128554,-0.13567753,-0.1987517,-0.26281499,-0.33319899,-0.40716548,-0.47746827,-0.56122789,-0.62973728,-0.69621988,-0.76206413,-0.81834503,-0.78781994,-0.71038363,-0.63272491,-0.56098678,-0.5008735,-0.41691177,-0.34956525,-0.28278556,-0.25817678,-0.21800482,-0.15131628,-0.072512663,0.015167841,0.052662253,0.13435346,0.20068331,0.26223752,0.31269583,0.36762012,0.37247752,0.32693248,0.28937813,0.27654798,0.3330081,0.40455211,0.47926585,0.55369715,0.60055777,0.62833047,0.69056514,0.76353003,0.82365507,0.89255693,0.91929513,0.98248585,1.0712187,1.126732,1.1709873,1.2330287,1.3225443,1.3989077,1.4998382,1.5773017,1.6540662,1.7310119,1.7910485,1.7595877,1.7022746,1.6236393,1.5444745,1.4773139,1.4113179,1.3160843,1.2261108,1.1872866,1.0918273,1.0014888,0.95162685,0.91900002,0.88327926,0.83356778,0.74643154,0.65081025,0.55272022,0.49411409,0.42718167,0.40794147,0.34071618,0.37270818,0.42414295,0.470914,0.52278672,0.50603863,0.43382584,0.38138211,0.30030956,0.25319852,0.17304737,0.083263839,0.041759082,-0.030669117,-0.1036504,-0.19232514,-0.25926405,-0.29537684,-0.26682912,-0.33810979,-0.40072898,-0.43406292,-0.51813497,-0.58345263,-0.64751382,-0.72355316,-0.76698362,-0.78387982,-0.73856456,-0.6767071,-0.58372894,-0.51293468,-0.43470342,-0.36282825,-0.26839946,-0.19247886,-0.10371127,-0.059309741,-0.042911632,0.034683839,0.11526864,0.20273383,0.28455763,0.3611216,0.41710377,0.47970809,0.55585685,0.63317863,0.70682944,0.78229199,0.84946695,0.93894598,1.013876,1.0105794,0.95718077,0.89640289,0.83422465,0.77980856,0.71723226,0.65966212,0.62528945,0.56950426,0.50591256,0.45416289,0.38662784,0.40225711,0.40663979,0.34813936,0.29461741,0.2317125,0.16973557,0.10939068,0.049188676,-0.015273127,-0.061140681,-0.031677527,0.0085857118,-0.038690652,-0.088092744,-0.14297615,-0.17866631,-0.24310606,-0.27460012,-0.32376263,-0.38769428,-0.45420466,-0.50923534,-0.50543923,-0.53608949,-0.54242497,-0.5785832,-0.6294231,-0.67582624,-0.73691879,-0.78952248,-0.77211149,-0.84527007,-0.890143,-0.81671499,-0.90064766,-0.94269093,-0.88412045,-0.81839363,-0.73915862,-0.70071609,-0.72025875,-0.74781426,-0.77696665,-0.74839951,-0.78204824,-0.81618864,-0.85762628,-0.8442862,-0.86206518,-0.93288883,-0.96457158,-1.0157327,-1.0190155,-1.0505785,-1.0614458,-1.0601204,-1.0559704,-1.0687168,-1.0979203,-1.1284116,-1.1573516,-1.1908799,-1.2327948,-1.1865334,-1.1565371,-1.2024443,-1.242811,-1.3088684,-1.3363257,-1.3429383,-1.3866524,-1.4330726,-1.4659797,-1.5150893,-1.5566306,-1.5512428,-1.6100608,-1.6032656,-1.6724798,-1.6085701,-1.5292396,-1.4371399,-1.3540104,-1.2710139,-1.1751076,-1.0988211,-1.0200965,-0.91895065,-0.84433706,-0.74409962,-0.66404592,-0.58851168,-0.48762038,-0.40896235,-0.34430951,-0.27361927,-0.21640694,-0.16474197,-0.10332561,-0.054432023,0.0040048349,0.063894594,0.080200802,0.15969235,0.21992527,0.28331677,0.36251423,0.43350237,0.49752466,0.56637055,0.62704147,0.69422292,0.75929814,0.82847563,0.90004727,0.96044619,1.0210969,1.0965231,1.166294,1.2331123,1.3058264,1.3726657,1.448837,1.5335698,1.5955004,1.6643168,1.7392022,1.820217,1.8982426,1.8887474,1.9356187,2.0056614,2.0721469,2.1404524,2.2066278,2.2815312,2.3416412,2.4035407,2.4534217,2.4818786:3
1.692399,1.6112555,1.4575242,1.3097985,1.1495962,1.0153033,0.85673879,0.69658305,0.56400918,0.52436881,0.43849317,0.29777088,0.2539054,0.21837722,0.22620963,0.15037446,0.07184864,-0.014840668,-0.11919827,-0.18022092,-0.28744068,-0.37170112,-0.49863942,-0.51954293,-0.63710932,-0.76116068,-0.89849185,-1.0136933,-1.0807009,-1.0658589,-1.1420898,-1.2428547,-1.2698611,-1.354911,-1.4624956,-1.5462978,-1.5385921,-1.4690687,-1.4351536,-1.3483671,-1.2232656,-1.0949307,-1.0268555,-0.90686167,-0.77887311,-0.71183912,-0.59885871,-0.46619112,-0.3736361,-0.33831764,-0.25046434,-0.19587545,-0.086211283,-0.0063364508,0.08461639,0.12201795,0.12482174,0.20114189,0.31819415,0.38682286,0.52895999,0.66318701,0.79494546,0.91869728,1.0002264,1.1573204,1.2670757,1.3591889,1.4929259,1.5806372,1.6671951,1.7062623,1.689838,1.7338038,1.700522,1.6356226,1.5278342,1.4302177,1.3449654,1.2675953,1.1845376,1.0745889,0.97058103,0.91338735,0.8102395,0.70205064,0.61813814,0.53981389,0.4703158,0.40244417,0.33270641,0.34109618,0.44769752,0.5713719,0.60973781,0.57024362,0.46418175,0.35119101,0.19634182,0.062467919,-0.068607586,-0.17622147,-0.26232421,-0.32838916,-0.35555228,-0.4457698,-0.51971967,-0.61731899,-0.76668421,-0.91692747,-0.99730078,-1.1093895,-1.1435656,-1.2168608,-1.2452818,-1.2045762,-1.1400494,-1.0180032,-1.0982778,-1.0596478,-0.95490683,-0.86782019,-0.75605336,-0.61299929,-0.4837325,-0.36905284,-0.25237737,-0.14380607,-0.024065837,0.08897126,0.21032777,0.35443724,0.4728072,0.56739124,0.54377956,0.47852066,0.41162377,0.31778172,0.18191249,0.062275596,-0.0064911636,-0.1146935,-0.24463467,-0.31579327,-0.31892922,-0.29875465,-0.29335048,-0.30427651,-0.43275205,-0.54408489,-0.65222987,-0.69160918,-0.73899171,-0.79900194,-0.87835499,-0.99616813,-1.1067212,-1.1975554,-1.2433027,-1.3085793,-1.4159986,-1.4784116,-1.533304,-1.4593629,-1.341754,-1.2474843,-1.1824259,-1.2590204,-1.3061244,-1.3990594,-1.4280985,-1.5093892,-1.5031015,-1.5117486,-1.6129998,-1.6335736,-1.6238112,-1.6139746,-1.546832,-1.4158255,-1.3553965,-1.2339341,-1.1143264,-0.98110939,-0.85896255,-0.73796925,-0.60390282,-0.46063397,-0.30970151,-0.17502746,-0.016379618,0.11832192,0.27628332,0.43527472,0.54403,0.65476843,0.81301537,0.95950589,1.1070593,1.2646021,1.4223421,1.579228,1.7580107,1.9057094,2.0419553,2.1945643,2.3745792,2.4891235,2.5403332,2.5406651,2.3926108,2.2411843,2.0845387,1.921371,1.7687749,1.6104965,1.452254,1.2929994,1.1827369,1.024083,0.88898513,0.73043955,0.57191028,0.4230602,0.27753924,0.1197931,-0.038442872,-0.19672846,-0.35565435,-0.507986,-0.64973095,-0.80837154,-0.91282767,-0.85721746,-0.88318425,-0.94799399,-1.0036343,-1.0072045,-1.0312975,-1.0451207,-0.95608292,-0.84692201,-0.75530024,-0.63796875,-0.57609582,-0.489135,-0.3845238,-0.31307467,-0.19708934,-0.093158072,-0.049379407,-0.057038389,-0.075639975,-0.062274094,-0.0054654605,0.060940426,0.18987493,0.27146777,0.38071828,0.44045161,0.40604435,0.46014926,0.34468912,0.40909852,0.45609577,0.44980198,0.4960994,0.58483711,0.66690283,0.64386499,0.66869924,0.72482386,0.81630682,0.94758656,1.0852986,1.1699957,1.0978795,0.98639451,0.86844855,0.75930333,0.63690784,0.5240447,0.40596867,0.28886836,0.17416431,0.051927166,-0.073553372,-0.2011246,-0.33232226,-0.37880088,-0.47744254,-0.62246448,-0.67394106,-0.81376677,-0.86282462,-0.97447532,-1.0863933,-1.1678091,-1.2357988,-1.2010086,-1.178051,-1.1311696,-1.0818497,-1.1069701,-1.0443601,-0.97248759,-0.92133209,-0.84354662,-0.76881603,-0.68649364,-0.57391238,-0.46955528,-0.35656966,-0.25068648,-0.1438026,-0.046976161,0.034294774,0.11902624,0.21203507,0.29836023,0.39355957,0.47243607,0.55650457,0.56026075,0.45603016,0.35693459,0.24847207,0.22912322,0.28278952,0.36575429,0.45493355,0.54055372,0.63764552,0.72843576,0.81711071,0.91782055,1.0085779,1.0942708,1.1997564,1.3020941,1.4029077,1.5091552,1.6151685,1.7206088,1.843272,1.8552717,1.7712257,1.6475965,1.5181098,1.3992286,1.2589292,1.1292437,1.0335888,0.93929397,0.92902063,0.84174523,0.71545982,0.58675637,0.45602933,0.36811071,0.27134239,0.14215501,0.031493643,-0.044217815,-0.10547395,-0.13018084,-0.13796127,-0.13791557,-0.19212674,-0.25091259,-0.37752822,-0.50279813,-0.63094187,-0.75817101,-0.87828463,-1.0082176,-1.1438587,-1.2771157,-1.4177047,-1.5510914,-1.6816051,-1.7656719,-1.8609076,-1.9809747,-2.0706432,-2.1971497,-2.1625238,-2.0512944,-1.9439775,-1.7831353,-1.6470751,-1.5549525,-1.4186492,-1.2784605,-1.1354848,-0.99216427,-0.82109933,-0.67056414,-0.49750138,-0.35108766,-0.21112354,-0.078825639,0.043580206,0.16554581,0.27612178,0.37657957,0.36487653,0.2986799,0.24774198,0.25555177,0.31825655,0.40434781,0.49779626,0.57868719,0.67277928,0.7584289,0.84702851,0.92298023,0.96625288,1.0462988,1.1277212,1.2209149,1.294148,1.368527,1.4347619,1.5242401,1.6339303:5
2.4414502,2.3427879,2.2426216,2.1270281,2.0349017,1.9221749,1.8419845,1.7527922,1.6797518,1.6052887,1.544234,1.4739607,1.4062934,1.3396136,1.3224294,1.2817176,1.2246468,1.1419714,1.0883108,1.1011561,1.0518835,1.0148929,0.94633393,0.86420255,0.78157282,0.70004473,0.64533057,0.67218262,0.64459087,0.57006049,0.46771587,0.41032254,0.36269424,0.27339131,0.20338879,0.14026822,0.059929923,0.066006743,0.080634126,0.1488275,0.19281535,0.10956897,0.026315421,-0.0064744694,0.015502469,-0.065101933,-0.15506307,-0.15671829,-0.23313843,-0.31861611,-0.39484386,-0.47066796,-0.52889518,-0.59678078,-0.68216511,-0.75635924,-0.82158465,-0.8871695,-0.95437667,-1.0354826,-1.1009052,-1.1735753,-1.2359314,-1.3015008,-1.3546573,-1.4023351,-1.4216813,-1.3152002,-1.233686,-1.1768241,-1.1175205,-1.0324002,-0.9636789,-0.90989041,-0.84820286,-0.77510797,-0.7218482,-0.63481563,-0.55046553,-0.48933233,-0.42788848,-0.32708565,-0.24762299,-0.15354524,-0.068595579,-0.0038111909,0.12184553,0.1786086,0.25855797,0.33113345,0.43143732,0.53179771,0.58566273,0.67316754,0.78808913,0.86088127,0.96688111,1.0942826,1.1687013,1.1106006,1.0420394,1.0025702,0.92701393,0.87231144,0.7829467,0.74419174,0.68499199,0.62204024,0.56798689,0.52735991,0.52396984,0.47183487,0.40226247,0.38486165,0.38784487,0.37915584,0.33670074,0.30086455,0.26521207,0.23989828,0.25272374,0.26937681,0.23343073,0.19951698,0.17209203,0.14276225,0.086127045,0.067936353,0.076102464,0.010416782,-0.070783505,-0.092143058,-0.075553576,-0.07193981,-0.13017677,-0.11718563,-0.18547319,-0.19846266,-0.19634419,-0.28011236,-0.30539577,-0.24330755,-0.32448533,-0.39879289,-0.43954151,-0.44900647,-0.5249436,-0.58088323,-0.53664325,-0.59696993,-0.66625787,-0.67938971,-0.7335104,-0.80959731,-0.78843336,-0.86435053,-0.93865237,-1.0308844,-1.011543,-1.0890809,-1.1842178,-1.2670374,-1.3151594,-1.212415,-1.0847545,-0.97846151,-0.87837136,-0.78621302,-0.6796765,-0.55696952,-0.44491493,-0.33779664,-0.23073766,-0.10311453,0.0032992953,0.085690555,0.09382399,0.17501511,0.28178403,0.38967389,0.47788215,0.5753904,0.63081359,0.6553526,0.63964832,0.61392695,0.62795194,0.64614472,0.66911897,0.68231585,0.68558341,0.68279383,0.6643969,0.66482164,0.70693072,0.63889695,0.56269627,0.49788749,0.39161751,0.30667772,0.20058318,0.073043816,-0.033054451,-0.1390401,-0.26648211,-0.37239665,-0.48118128,-0.54929085,-0.64711187,-0.75266423,-0.85813332,-0.98485829,-1.0899223,-1.1947532,-1.2893637,-1.2346454,-1.1595566,-1.0936297,-1.0425422,-0.96336419,-0.87946236,-0.79979153,-0.72103215,-0.65851407,-0.57166059,-0.4954487,-0.42433046,-0.35577293,-0.36003673,-0.27658713,-0.21071214,-0.2183165,-0.1463022,-0.10642053,-0.12833367,-0.078628114,-0.022390033,0.049390645,0.10283917,0.055435502,0.14253032,0.21656083,0.19199129,0.27538393,0.31577118,0.30844018,0.24012431,0.34088271,0.40650731,0.49571618,0.49640109,0.57501435,0.58373085,0.64400601,0.68214864,0.65167634,0.6041643,0.60057382,0.69821877,0.72242235,0.76936783,0.81169744,0.88626471,0.93292977,0.86960508,0.82419812,0.86270154,0.91348979,0.98189556,1.0605595,1.0147939,1.0346034,1.1193982,1.190619,1.2572052,1.2465436,1.319681,1.3918305,1.3981023,1.4896053,1.5506095,1.61135,1.6198854,1.5118841,1.3854518,1.2779031,1.1772275,1.1360365,1.0691208,0.94411716,0.88363273,0.78667229,0.69632789,0.61399231,0.53340089,0.48868058,0.39268372,0.30800967,0.20717435,0.13432094,0.035131564,-0.057679043,-0.10435869,-0.23152425,-0.32690191,-0.38298229,-0.46606846,-0.53089179,-0.6323101,-0.71725774,-0.79945403,-0.84020576,-0.95305756,-1.0184114,-1.0952971,-1.1641899,-1.2247217,-1.3013362,-1.3660769,-1.4211979,-1.5139376,-1.5977031,-1.6640253,-1.7337307,-1.7917656,-1.8849996,-1.9750652,-2.033512,-2.075156,-2.1288693,-2.1953552,-2.2676898,-2.2976459,-2.2768183,-2.2523806,-2.2016469,-2.1374623,-2.095182,-2.1471939,-2.0702612,-2.0021056,-2.0193729,-1.9333624,-1.8665472,-1.8020046,-1.7758563,-1.7831693,-1.7015959,-1.6241334,-1.5628699,-1.5763407,-1.4912308,-1.4401323,-1.3577729,-1.322214,-1.3625575,-1.278363,-1.1899358,-1.1033157,-1.0918684,-1.0601916,-0.96638974,-0.94269276,-0.85334032,-0.81911853,-0.81941961,-0.72400187,-0.63876823,-0.63324851,-0.53337949,-0.44729091,-0.43628874,-0.39193999,-0.29421041,-0.20390871,-0.21464756,-0.14527688,-0.082171972,-0.0042031074,-0.046489022,-0.050551136,-0.11592062,-0.045624735,0.0037648978,0.10637684,0.15565406,0.16663561,0.26228951,0.32710404,0.35480386,0.41502741,0.49177164,0.50496927,0.45235287,0.46542825,0.40787702,0.44092931,0.52585183,0.60932737,0.63459053,0.71851389,0.77105833,0.75296181,0.76094791,0.84572281,0.93471831,0.99050852,1.0509173,1.1205545,1.1261213,1.1108788,1.2189178,1.2930643,1.3995951,1.473379,1.4691459,1.5525447,1.6322865,1.70805,1.7782194,1.8689285,1.9574423,2.0414982,2.1369538,2.2286404,2.3102003,2.3944048:6
0.44474369,0.43250415,0.41333389,0.41779031,0.39455315,0.3754091,0.35346071,0.32889247,0.30585289,0.28982491,0.26549177,0.25872294,0.25051933,0.25099273,0.24515381,0.2665945,0.27218362,0.29586016,0.28004946,0.29155715,0.26991068,0.28454087,0.32151969,0.36442938,0.39722809,0.43712323,0.48875266,0.53427141,0.57854457,0.63074701,0.67360282,0.71785858,0.76217817,0.79707111,0.81562775,0.80509065,0.80724317,0.8077376,0.82099666,0.83757629,0.86663995,0.89267893,0.93851113,1.0360874,1.1357197,1.2340331,1.3371871,1.4365641,1.5394866,1.6408832,1.742434,1.8424234,1.941707,2.0342983,2.1327612,2.0990613,2.003681,1.9008313,1.8018194,1.7047096,1.6085535,1.5148915,1.4179581,1.3247143,1.2503313,1.1960183,1.1787908,1.1783413,1.1745869,1.1649877,1.1441471,1.1256711,1.0976095,1.0703969,1.0376441,1.0106981,0.98421985,0.95411641,0.93661882,0.91581242,0.89072404,0.86369941,0.83207239,0.80483471,0.77735669,0.7528764,0.72296952,0.69857667,0.6810863,0.67249561,0.66141767,0.58994595,0.58278142,0.58860853,0.60723654,0.63217743,0.64654125,0.63120798,0.6107802,0.59628803,0.55728114,0.50027766,0.44425309,0.38238316,0.31199647,0.23397526,0.16509424,0.094417705,0.023866551,-0.050986576,-0.12946765,-0.21327541,-0.32701147,-0.41847909,-0.50061553,-0.55521799,-0.54060078,-0.5536255,-0.58410532,-0.6205205,-0.64714769,-0.67614843,-0.70610179,-0.72729067,-0.74233456,-0.73869199,-0.72552991,-0.71693847,-0.69757807,-0.67180483,-0.65311949,-0.63113998,-0.60409344,-0.57758465,-0.54865813,-0.52236875,-0.49311685,-0.43792691,-0.37747969,-0.30115859,-0.24163751,-0.16381864,-0.1018917,-0.024343732,-0.040720937,-0.11257078,-0.055301722,0.0094835418,0.065979627,0.12021168,0.17671775,0.24661365,0.34095937,0.25732959,0.16431053,0.079551906,-0.0083439561,-0.12794942,-0.24252333,-0.327574,-0.45529452,-0.5633373,-0.6867468,-0.79255629,-0.91621704,-1.0283101,-1.1238863,-1.2357982,-1.3365255,-1.4257586,-1.5204491,-1.6041856,-1.6904871,-1.7640207,-1.8220073,-1.8626173,-1.89504,-1.8948883,-1.8710133,-1.8296207,-1.7789421,-1.7241796,-1.6606302,-1.592492,-1.5194056,-1.4480527,-1.3827901,-1.3056687,-1.2357896,-1.1585062,-1.0799883,-0.99661368,-0.92746386,-0.84005164,-0.7583766,-0.67371146,-0.58613868,-0.50064739,-0.41080875,-0.32049355,-0.24638344,-0.27312252,-0.32156424,-0.35743749,-0.44542079,-0.55683616,-0.64000053,-0.71200398,-0.7641769,-0.80664755,-0.82329451,-0.80929046,-0.76275361,-0.68043112,-0.58931313,-0.48526777,-0.39612792,-0.29126768,-0.19908215,-0.094828686,0.0098257777,0.10385245,0.21217293,0.30893625,0.40193645,0.50324249,0.60750258,0.71080301,0.80889863,0.90483564,1.004596,1.1002939,1.2055746,1.3031675,1.3982487,1.4967102,1.4288776,1.3350548,1.2392766,1.1490542,1.0556757,0.9718977,0.95117323,1.0093121,1.1211799,1.2263235,1.3219323,1.4368708,1.5328756,1.6465987,1.7408394,1.8554608,1.8613148,1.7893426,1.8757892,1.9818661,2.0900461,2.1843973,2.0879479,1.989109,1.8840818,1.7759714,1.6785695,1.6149915,1.6974895,1.6782002,1.5757807,1.4859422,1.3929273,1.2893958,1.1913133,1.098603,1.0000872,0.91258798,0.82881064,0.74393443,0.67508078,0.63889349,0.66111856,0.72540256,0.80432916,0.90294033,0.98522899,1.1162302,1.2218956,1.1430321,1.0484768,0.93373495,0.81894381,0.70453626,0.5907308,0.47472119,0.35969249,0.25637562,0.1488631,0.036172247,-0.06200511,-0.17716545,-0.27489118,-0.38921012,-0.48363873,-0.6000815,-0.69677145,-0.793921,-0.8906805,-0.98541827,-1.0723903,-1.1349028,-1.1828893,-1.2049809,-1.180965,-1.1371454,-1.0852072,-1.0320534,-0.95763884,-0.88658086,-0.81886072,-0.745374,-0.66664065,-0.58586305,-0.48551816,-0.38438553,-0.28789181,-0.18059404,-0.098478138,-0.020434922,0.080879622,0.17776662,0.27990156,0.29098686,0.17552566,0.06500217,-0.046951559,-0.16168747,-0.27413153,-0.38903529,-0.50064489,-0.61003075,-0.70904145,-0.69191125,-0.59889775,-0.6931224,-0.79073563,-0.91175405,-1.0176022,-1.1268187,-1.2338366,-1.3504165,-1.4633831,-1.574788,-1.6890962,-1.7901586,-1.8656131,-1.9339866,-1.969894,-1.9898859,-1.9962246,-1.9885846,-1.9717642,-1.9245658,-1.866678,-1.8548196,-1.7986735,-1.6999787,-1.5886609,-1.4721182,-1.3847441,-1.2572635,-1.1302492,-1.0020864,-0.8729789,-0.74470326,-0.69714285,-0.66233625,-0.63720606,-0.61815571,-0.64666774,-0.60402643,-0.54405902,-0.48141215,-0.41171778,-0.33068041,-0.23269473,-0.1681878,-0.28051895,-0.35817153,-0.30878942,-0.42038746,-0.51198131,-0.60148618,-0.67767211,-0.7527777,-0.83120693,-0.8147978,-0.85702788,-0.94466714,-1.0179065,-1.0519908,-1.0562428,-1.0857216,-1.1003478,-1.1180023,-1.1211685,-1.1328573,-1.1330757,-1.109772,-1.0786613,-1.0135269,-0.94138569,-0.85972934,-0.77285043,-0.67146947,-0.57080489,-0.44907782,-0.35605079,-0.26079845,-0.18657739,-0.10227475,-0.011717309,0.080628004,0.14969173,0.22853076,0.3012059,0.36300039,0.40225089,0.41518133,0.42743538:4
2.4277923,2.3241147,2.2236941,2.1213125,2.0204595,1.922719,1.816932,1.7186219,1.6198521,1.5214381,1.4190521,1.2977887,1.1962627,1.0857223,0.98037589,0.85918282,0.76416161,0.69802525,0.70620938,0.72618082,0.7600979,0.78802394,0.84630099,0.89928978,0.92570545,0.98147663,1.0343709,1.0647548,1.0861001,1.1298824,1.1452853,1.1704397,1.1831363,1.1997738,1.2087751,1.2282808,1.2387088,1.2602139,1.2760593,1.2990777,1.3228855,1.346304,1.3601583,1.3784709,1.3894961,1.4063696,1.3562752,1.2577972,1.1651568,1.0683194,0.95753276,0.8582201,0.75780048,0.65500817,0.56295773,0.46092662,0.36373806,0.26532346,0.16576055,0.069444191,-0.027153166,-0.11974886,-0.22088831,-0.32227538,-0.41210008,-0.51729924,-0.59893567,-0.7044641,-0.75467452,-0.80785883,-0.84066284,-0.85130566,-0.85697097,-0.85712925,-0.86436574,-0.85552606,-0.85692571,-0.84630593,-0.83708657,-0.82011755,-0.81180294,-0.80089534,-0.79149851,-0.77565375,-0.75697337,-0.73353043,-0.70020176,-0.66334917,-0.61369338,-0.59278098,-0.56003172,-0.52159758,-0.47677735,-0.43759915,-0.37104833,-0.35226308,-0.44966457,-0.54878735,-0.64713032,-0.73130196,-0.81106196,-0.93068499,-1.0115885,-1.0991049,-1.1793701,-1.270866,-1.3523989,-1.4446707,-1.5276694,-1.6147932,-1.7056284,-1.7985287,-1.894981,-1.9827442,-2.0704114,-2.1341478,-2.1775474,-2.1941976,-2.1775788,-2.1318048,-2.047545,-1.9624808,-1.881993,-1.8010684,-1.7189051,-1.6341075,-1.546064,-1.4613979,-1.3698538,-1.2779433,-1.1917468,-1.0942247,-0.99086456,-0.89529604,-0.80745408,-0.71817691,-0.6244258,-0.50663126,-0.43769206,-0.39800889,-0.35412848,-0.31664387,-0.21228448,-0.086080571,-0.071544114,-0.024397741,0.099190961,0.099067126,0.0036006652,-0.092778889,-0.18789442,-0.27832091,-0.35831743,-0.44759754,-0.53783011,-0.63307584,-0.71717952,-0.79968969,-0.88093362,-0.96042333,-1.045078,-1.1044388,-1.1720065,-1.1975698,-1.1386831,-1.0778148,-0.99023667,-0.90127332,-0.81960936,-0.72123508,-0.60465495,-0.51793319,-0.38770988,-0.30078182,-0.18349154,-0.081836978,0.0054483473,0.12106932,0.22669422,0.31620507,0.4209142,0.53971,0.66575681,0.76599262,0.90202383,1.0176255,0.9175472,0.82487237,0.85943187,0.78290313,0.71140666,0.63943568,0.55392776,0.55592474,0.61532188,0.69766196,0.76969301,0.85782089,0.92187132,1.0153595,1.1026273,1.1953903,1.2970798,1.4029342,1.5034946,1.4669654,1.4637397,1.5547624,1.6531439,1.6632514,1.5618844,1.508836,1.5399079,1.4100131,1.3117168,1.2130746,1.1160178,0.97804957,0.88664793,0.75266642,0.61837569,0.4891305,0.4164371,0.38770037,0.43212738,0.50495493,0.59496994,0.67431216,0.76134623,0.85289718,0.93144932,0.968048,0.87971377,0.78321655,0.64962757,0.55624834,0.48781311,0.40035763,0.30004398,0.19179839,0.08817909,-0.0158971,-0.1153333,-0.2200931,-0.32121083,-0.41832414,-0.5388643,-0.65065945,-0.74394651,-0.84232014,-0.96250746,-1.0727261,-1.168321,-1.2853779,-1.3883886,-1.4845636,-1.5797183,-1.6509676,-1.6665276,-1.6477122,-1.6062089,-1.5134794,-1.4357963,-1.3178129,-1.2268991,-1.1146885,-1.0158791,-0.9317633,-0.81174585,-0.70842054,-0.60947397,-0.50955122,-0.4157181,-0.31589345,-0.21220477,-0.10926723,-0.011033963,0.078830689,0.17981535,0.28234666,0.37768351,0.43033978,0.54864665,0.64922485,0.74270844,0.86997823,0.97980066,0.9403114,0.83945959,0.73646074,0.63197014,0.52853289,0.4354758,0.3449312,0.26919417,0.18678721,0.11728282,0.045188719,-0.040644018,-0.13127766,-0.21273928,-0.30711216,-0.38274446,-0.46991838,-0.55990893,-0.62787936,-0.70336266,-0.77097961,-0.84009115,-0.91367021,-0.98751168,-1.0492049,-1.1229386,-1.1798897,-1.2445563,-1.3095713,-1.3670592,-1.4166152,-1.4608548,-1.5071481,-1.5547508,-1.5913478,-1.622311,-1.6351512,-1.6229917,-1.5602622,-1.4857423,-1.4130495,-1.3067751,-1.2298544,-1.137151,-1.0340686,-0.93232873,-0.8322183,-0.71394586,-0.60337769,-0.47009753,-0.37947173,-0.24781281,-0.12809772,-0.064860943,0.047490173,0.13319925,0.1954099,0.291278,0.37686649,0.44767259,0.39861669,0.34116912,0.28828749,0.23561524,0.1722918,0.14813398,0.12069367,0.19123954,0.15053654,0.10513329,0.050313272,0.019728296,-0.0051721455,-0.043825457,-0.061047064,-0.067820175,-0.081114328,-0.090137474,-0.10406414,-0.11611643,-0.12242457,-0.12361559,-0.12735792,-0.12885346,-0.13693764,-0.14309506,-0.14357986,-0.14462064,-0.15607705,-0.15394961,-0.13531237,-0.12277047,-0.1026321,-0.07353715,-0.05509911,-0.027090731,0.0017822958,0.024777971,0.046781264,0.080836829,0.10988083,0.12618433,0.14612171,0.17815318,0.19949869,0.24418835,0.27767691,0.31116647,0.35587153,0.39249419,0.43315315,0.46012193,0.48175402,0.50442123,0.51974733,0.54658369,0.56445588,0.58694758,0.6051033,0.59639408,0.62373477,0.68833927,0.78031163,0.85804452,0.95947603,1.0243419,1.1307392,1.2272411,1.3346709,1.4474402,1.5464027,1.6525525,1.7560072,1.8626369,1.9663628,2.068248,2.1665668,2.2680518,2.3673402,2.4121254:4
1.3831848,1.3638808,1.3306781,1.2902701,1.2328399,1.1682802,1.1004123,1.0501269,1.0117701,1.0656988,1.1177828,1.1641375,1.2088383,1.2091669,1.2005675,1.1558777,1.0872255,1.0189608,0.93421283,0.84876323,0.77209905,0.70020877,0.61548382,0.52025879,0.42195408,0.33618671,0.22825423,0.1482248,0.042008698,-0.040716807,-0.14373576,-0.25166871,-0.33473246,-0.41270189,-0.49968493,-0.60448437,-0.68526731,-0.77183603,-0.86418325,-0.94879973,-1.0311671,-1.1160595,-1.155358,-1.0848631,-1.0095778,-0.93985483,-0.86895473,-0.78122039,-0.70317018,-0.62180599,-0.53803953,-0.46634227,-0.38583881,-0.29692452,-0.22788079,-0.1598929,-0.094333313,-0.014245464,0.034365043,0.074107151,0.097916072,0.093842552,0.066340338,0.021224567,-0.04397725,-0.1140853,-0.18170681,-0.2336429,-0.24897718,-0.24117877,-0.24606395,-0.27838165,-0.32905875,-0.37220153,-0.43555493,-0.49496051,-0.54504268,-0.61615668,-0.65891266,-0.72832385,-0.80915819,-0.87232107,-0.95989502,-1.0605892,-1.1451407,-1.2124451,-1.2863665,-1.3509952,-1.3829611,-1.3781976,-1.3696571,-1.4076532,-1.4510538,-1.5093746,-1.5585128,-1.6093994,-1.6348038,-1.6719654,-1.6896644,-1.7109294,-1.7436359,-1.7156209,-1.6513192,-1.5643755,-1.4842873,-1.3979937,-1.3445971,-1.2527047,-1.1511595,-1.0748345,-0.97421647,-0.86457213,-0.7839471,-0.72514343,-0.61737333,-0.50946508,-0.44206344,-0.34840733,-0.28540909,-0.21684023,-0.17509878,-0.13628088,-0.11345544,-0.093000687,-0.084302526,-0.0902206,-0.085780607,-0.088189982,-0.087392655,-0.089868146,-0.087487342,-0.10400497,-0.10902098,-0.11555713,-0.1218106,-0.14103491,-0.15062973,-0.16855732,-0.16961506,-0.18788708,-0.22174725,-0.28063845,-0.35289734,-0.42937547,-0.48814197,-0.51518348,-0.51918767,-0.53995108,-0.55703149,-0.56238072,-0.52753766,-0.49798379,-0.40338402,-0.33226307,-0.2620862,-0.18479322,-0.096431168,0.012125648,0.090023928,0.16502065,0.23849477,0.29126719,0.33566247,0.3613539,0.39800208,0.45095682,0.52126342,0.622595,0.69657359,0.7422463,0.817564,0.90773833,0.96648034,1.0395975,1.1078623,1.1508365,1.1973814,1.2551862,1.2841222,1.3410329,1.3399627,1.4021558,1.4589732,1.5097533,1.5638156,1.6214183,1.6701405,1.7085293,1.7388529,1.8103562,1.8992071,1.9909779,2.0962439,2.2101203,2.3240968,2.4380528,2.5188728,2.555064,2.5344134,2.5150555,2.5019306,2.4627362,2.3817299,2.2927319,2.1798504,2.0661676,1.9529264,1.8400998,1.7517276,1.6695634,1.6534919,1.6728936,1.6369233,1.6184867,1.6110115,1.5967668,1.56921,1.5323494,1.4867608,1.4407135,1.3654575,1.2723206,1.1972824,1.1022733,1.0439585,0.99155949,0.96689019,0.93268591,0.89188357,0.84193155,0.79802791,0.74999234,0.70252229,0.6507816,0.61050183,0.55481124,0.49560225,0.43472861,0.35660651,0.28699254,0.2242807,0.13145734,0.054230951,-0.038557689,-0.13166785,-0.22536082,-0.30280667,-0.39031578,-0.47725816,-0.54918264,-0.60228108,-0.59842701,-0.58466057,-0.58111011,-0.57518637,-0.57433384,-0.57839934,-0.58232736,-0.58553741,-0.58883035,-0.58481732,-0.57908223,-0.56526007,-0.55762561,-0.55690962,-0.55242969,-0.548121,-0.53493541,-0.52091691,-0.508718,-0.49445881,-0.47678962,-0.46261431,-0.44536683,-0.42678916,-0.40622514,-0.38516098,-0.35982415,-0.34167954,-0.34336283,-0.32555743,-0.3005055,-0.2649996,-0.22068621,-0.18308774,-0.15055293,-0.1275593,-0.095286753,-0.075724954,-0.072459615,-0.11531321,-0.20321296,-0.3036981,-0.38082168,-0.47613006,-0.56278402,-0.67741754,-0.76485807,-0.8494651,-0.92930072,-1.0092676,-1.0843842,-1.1553007,-1.2263883,-1.3066469,-1.3914465,-1.4797859,-1.5646327,-1.6274107,-1.7131529,-1.787086,-1.8568685,-1.9383072,-2.0205165,-2.1268157,-2.1421887,-2.1179155,-2.0720445,-2.0152011,-1.9585404,-1.8993594,-1.8273883,-1.7695367,-1.7079787,-1.6416556,-1.5703158,-1.4993779,-1.4195352,-1.3537408,-1.2762931,-1.2114229,-1.1265726,-1.0595505,-0.97530005,-0.90255732,-0.83350611,-0.75549594,-0.68036319,-0.604365,-0.52225886,-0.44741021,-0.36750521,-0.29543874,-0.21538924,-0.13576026,-0.063933055,0.018822331,0.10062365,0.12058784,0.11459941,0.10454554,0.10089791,0.14437098,0.22301194,0.29372161,0.38390933,0.47450492,0.54144959,0.60198578,0.66231739,0.71047929,0.75731507,0.80479248,0.80340089,0.76882995,0.72446993,0.66606505,0.60937299,0.54875966,0.48095222,0.41389053,0.36022711,0.28150917,0.21214342,0.15612378,0.0818758,0.0018880407,-0.069482537,-0.14968693,-0.22052468,-0.31087991,-0.38257474,-0.46252544,-0.54554559,-0.53137494,-0.4239277,-0.36198831,-0.36785883,-0.38496879,-0.40865863,-0.36484141,-0.37169233,-0.29299723,-0.20952318,-0.1214491,-0.077163247,-0.015146842,0.034068507,0.1258433,0.20696462,0.2914522,0.38977767,0.4810356,0.56228575,0.66334154,0.75680775,0.83871255,0.84283763,0.84366512,0.80235573,0.75082648,0.71672823,0.67052117,0.63661346,0.57595785,0.52531938,0.58016793,0.68755583,0.76380178,0.81377624,0.91668364,1.0291192,1.1201477,1.2133262,1.2899314,1.3656498,1.3841308:2
2.227162,2.1628775,2.0899667,2.0202294,1.9487054,1.8738232,1.8030897,1.7435841,1.6692646,1.6044728,1.5368481,1.5274018,1.4582813,1.3943357,1.3187775,1.264031,1.2621076,1.2046567,1.1366599,1.0824869,1.004467,0.99136583,0.98586758,0.94188315,0.87949971,0.82434043,0.74404862,0.64760433,0.61522482,0.65759956,0.66648335,0.64885304,0.59366114,0.5203526,0.45420459,0.37701803,0.28729874,0.24759708,0.16789566,0.097339044,0.085904979,0.14668525,0.20800044,0.199156,0.25854774,0.32530615,0.39405626,0.40508733,0.47662787,0.52286118,0.59314544,0.57108658,0.52634848,0.4521136,0.40393532,0.320004,0.22892407,0.18998246,0.18899543,0.089952044,0.043450847,-0.034314357,-0.079942273,-0.16586112,-0.21654716,-0.23163564,-0.31795584,-0.39140489,-0.44223145,-0.51678492,-0.58141844,-0.65850045,-0.73824997,-0.80218091,-0.84025974,-0.92385883,-0.99783415,-1.0544094,-1.1325309,-1.2146868,-1.2530788,-1.3311289,-1.4072754,-1.4845738,-1.5435592,-1.6242851,-1.701677,-1.7843349,-1.8625975,-1.9325902,-1.9976209,-2.0565038,-2.1319871,-2.2049955,-2.2550161,-2.2701282,-2.2446057,-2.1896877,-2.1080118,-2.0282836,-1.9447147,-1.8563797,-1.7657142,-1.6833794,-1.6096439,-1.5786105,-1.5925714,-1.6154897,-1.6243835,-1.6194904,-1.609863,-1.5605419,-1.51091,-1.4454215,-1.3732932,-1.3276896,-1.2621507,-1.2036736,-1.1226862,-1.0433448,-0.97608286,-0.89486163,-0.82600498,-0.75985864,-0.66455926,-0.61331063,-0.530512,-0.47040198,-0.4370563,-0.38038755,-0.30921836,-0.23675989,-0.15206519,-0.10019507,-0.040417503,0.043494141,0.12375347,0.18884698,0.26932337,0.33758435,0.42910524,0.5066133,0.56634244,0.62395153,0.7017479,0.78355397,0.83138083,0.91672296,0.98874409,1.0660522,1.1184876,1.1885293,1.2629582,1.3378111,1.4130154,1.4856335,1.5626605,1.6348149,1.712306,1.7909662,1.8632172,1.8494881,1.7647547,1.7024181,1.6202116,1.5969684,1.5631931,1.4856007,1.4453357,1.4159325,1.376404,1.3009984,1.3212285,1.2895278,1.2350981,1.1574962,1.1444054,1.0663863,1.037046,1.0658318,1.0541026,0.98331295,0.98555549,0.91683127,0.83810276,0.82469299,0.79521606,0.72017001,0.64369518,0.6539256,0.68880939,0.68123313,0.69148103,0.6196385,0.57348486,0.49244363,0.48486178,0.41668758,0.33499635,0.30140326,0.24594664,0.16724368,0.089998112,0.11832084,0.16929758,0.20618342,0.21447417,0.25806462,0.27577025,0.26538229,0.20271425,0.12488929,0.10073673,0.064219904,-0.011641969,-0.12099474,-0.13826737,-0.19957357,-0.26426686,-0.32435965,-0.37342912,-0.45827704,-0.53982014,-0.5750837,-0.64886933,-0.70948703,-0.77918252,-0.84016451,-0.91642399,-0.93773604,-0.87026342,-0.79441717,-0.71827408,-0.63689538,-0.55831545,-0.47703467,-0.39884456,-0.32096624,-0.24055742,-0.19102702,-0.12329706,-0.044934074,0.034592624,0.11219789,0.19289045,0.27155091,0.35325675,0.43060128,0.51117954,0.59976059,0.68720216,0.78619287,0.85693979,0.82906126,0.84301934,0.89142896,0.79585452,0.78742964,0.70978089,0.62933985,0.55223496,0.47704607,0.40042549,0.32436164,0.26583026,0.21801337,0.13812838,0.058053061,-0.022100718,-0.10059869,-0.18270386,-0.26293846,-0.33457812,-0.4193678,-0.49701948,-0.57941881,-0.667652,-0.71628195,-0.7625541,-0.84059905,-0.92487439,-1.0045904,-1.0862941,-1.1690446,-1.244775,-1.3316875,-1.4075842,-1.4919724,-1.5405604,-1.6098207,-1.6476828,-1.5963834,-1.5434464,-1.4891852,-1.4284059,-1.3718938,-1.3810944,-1.3175324,-1.2881351,-1.2273041,-1.1950032,-1.2173068,-1.1434813,-1.089146,-1.0390309,-1.0652526,-0.98305535,-0.92506214,-0.95944689,-0.89461773,-0.89281035,-0.88021842,-0.94798822,-0.97526437,-0.97728718,-0.93008251,-0.84899284,-0.80890207,-0.81656066,-0.75067804,-0.71118621,-0.70774973,-0.66256616,-0.68902005,-0.71366957,-0.7445732,-0.67911903,-0.63973211,-0.58089922,-0.60741657,-0.54552987,-0.47128993,-0.4923697,-0.42911819,-0.38945521,-0.39339002,-0.4387743,-0.3748956,-0.31585332,-0.30202314,-0.29604931,-0.22554405,-0.19486861,-0.19377232,-0.19865883,-0.130319,-0.086453512,-0.032819574,3.7432434E-5,0.01517227,0.081189267,0.14531593,0.18559474,0.25342194,0.32222774,0.32102778,0.23403733,0.15721301,0.10672412,0.031334063,-0.051581326,-0.12904281,-0.17949538,-0.26236901,-0.338298,-0.36344069,-0.40627057,-0.46453292,-0.44727987,-0.48805942,-0.56210945,-0.58777527,-0.63785592,-0.64895267,-0.71709834,-0.74920906,-0.67459934,-0.60561821,-0.55290915,-0.47784074,-0.40210963,-0.3423275,-0.27886682,-0.20442585,-0.12747478,-0.075497141,-0.003077173,0.074403782,0.091085759,0.16495398,0.23264008,0.25560678,0.25347308,0.28738762,0.33367235,0.39704728,0.47729228,0.5056844,0.55128088,0.63006418,0.67240315,0.75171703,0.79166648,0.82028328,0.83921144,0.90572254,0.98665203,1.0296801,1.0787757,1.1383896,1.2209126,1.2572036,1.2505271,1.3286627,1.4050602,1.4618229,1.5356914,1.5546278,1.6001277,1.685094,1.7542711,1.8240586,1.8645775,1.9479996,2.0212729,2.1008319,2.1672282:6
1.3722776,1.3757984,1.3368945,1.2824505,1.2120834,1.1124899,1.0341708,0.91786005,0.77022679,0.69105705,0.56333205,0.40853151,0.26656902,0.1766657,0.17564402,0.18319473,0.32416461,0.33502575,0.46248133,0.58286243,0.70022982,0.82206159,0.88655026,0.98957146,1.0266827,1.0481584,1.0838336,1.0787198,1.0830096,0.95669692,0.83737431,0.7225478,0.56669525,0.44462949,0.319227,0.20138289,0.083888366,-0.032438908,-0.10309402,-0.18333468,-0.24002567,-0.20711606,-0.12842031,-0.075564636,0.0073230878,0.094924429,0.059362106,0.043481474,-0.048458723,-0.15142326,-0.23973819,-0.35944116,-0.45303652,-0.45482579,-0.36519125,-0.26053574,-0.11728403,0.0030593326,0.1251226,0.25373449,0.41365076,0.50966454,0.62606079,0.74197158,0.81761825,0.88526977,0.9152039,0.94456066,0.97726658,0.96833567,0.92651289,0.88583461,0.84713091,0.78009636,0.70555286,0.6060924,0.52358061,0.418535,0.28628669,0.21162523,0.10258253,0.059467848,-0.012368731,-0.05811758,-0.11968774,-0.21318917,-0.29319886,-0.35991643,-0.41436412,-0.46973979,-0.59954935,-0.68923157,-0.85624059,-0.94673178,-1.0460974,-1.0958794,-1.2016906,-1.3576876,-1.4499986,-1.5471809,-1.5652294,-1.6491851,-1.7430075,-1.8644976,-1.9916245,-2.0234415,-1.9108859,-1.8204356,-1.8347786,-1.7242288,-1.5873559,-1.4605958,-1.3501861,-1.2253224,-1.086336,-0.97804466,-0.8495892,-0.73433253,-0.62113033,-0.49720178,-0.38181766,-0.26800236,-0.1555271,-0.039162069,0.063725247,0.16846882,0.27075214,0.38933146,0.47590507,0.54469209,0.58550757,0.60673883,0.61618925,0.61332726,0.59486478,0.55607675,0.52641057,0.4778445,0.39503995,0.33870458,0.25133776,0.18802931,0.081421155,0.0016873853,0.017318026,-0.069923328,-0.13096486,-0.20066401,-0.1559929,-0.17610048,-0.1559414,-0.22964283,-0.27427767,-0.32111256,-0.42460429,-0.48046349,-0.58927531,-0.64048858,-0.74972852,-0.86456372,-0.97393642,-1.0692704,-1.1637692,-1.1080878,-1.0260519,-0.90177296,-0.73405973,-0.60976484,-0.48679806,-0.4048627,-0.35805886,-0.32712012,-0.35111708,-0.34997305,-0.35082392,-0.37620179,-0.38776189,-0.3752115,-0.40464576,-0.41974731,-0.45616743,-0.48686805,-0.52360392,-0.54933541,-0.58315626,-0.62828246,-0.67392317,-0.70747812,-0.74962534,-0.74760148,-0.75451969,-0.6180151,-0.58872411,-0.40876102,-0.26403799,-0.14409856,-0.021382994,0.046017471,0.11579356,0.17058809,0.22697298,0.25270697,0.27131209,0.28635768,0.28447362,0.29666525,0.30844154,0.30584702,0.31836103,0.32197471,0.35545463,0.38751797,0.45748721,0.51138948,0.55538384,0.61782337,0.64796485,0.69904417,0.73819646,0.75590263,0.79353001,0.8197188,0.82874783,0.86798732,0.97195852,1.0907098,1.207832,1.3512747,1.4817842,1.5539835,1.6620226,1.74695,1.7982232,1.8452613,1.8641926,1.923514,1.9954139,2.0257944,2.1421849,2.2838924,2.3491184,2.4360341,2.5232772,2.5613196,2.5577964,2.6001995,2.6084651,2.6246097,2.5258549,2.394741,2.2687582,2.1501508,2.0346379,1.914375,1.8233527,1.7289886,1.6109852,1.4884576,1.370246,1.2287832,1.1743751,1.2048664,1.214201,1.216998,1.0778494,0.97877106,0.89094147,0.80580311,0.67962633,0.56897171,0.51822295,0.49054805,0.46170655,0.43241962,0.39028998,0.34053547,0.25702236,0.18006883,0.079666459,-0.018653524,-0.10715337,-0.21056441,-0.30737237,-0.3524427,-0.28138086,-0.27257113,-0.27689553,-0.29468309,-0.31392993,-0.35592923,-0.41506258,-0.5002557,-0.63927272,-0.7712605,-0.86124135,-0.93845232,-1.0325188,-1.0074119,-0.9609573,-0.92261548,-0.87862292,-0.84304247,-0.80455802,-0.77195418,-0.73814536,-0.68687611,-0.65259284,-0.60468896,-0.56602235,-0.5201098,-0.49351271,-0.43621855,-0.41148684,-0.39985456,-0.39616576,-0.39864638,-0.41233882,-0.49178291,-0.52941364,-0.63094483,-0.75403415,-0.88447744,-1.0273098,-1.1706271,-1.293435,-1.4409672,-1.5612882,-1.7009227,-1.8310106,-1.82174,-1.9182607,-1.841203,-1.7206195,-1.5979209,-1.4820926,-1.3609279,-1.2342072,-1.1030896,-0.9794303,-0.85849541,-0.72268107,-0.62563242,-0.5161021,-0.46851915,-0.41362804,-0.34507898,-0.25116907,-0.15603347,-0.05184023,0.061009709,0.15273983,0.26617118,0.32668415,0.40237959,0.46763074,0.51454951,0.57548648,0.61117784,0.68344002,0.72950904,0.78205083,0.83364278,0.85172229,0.87666501,0.80342095,0.73168143,0.62802706,0.57207541,0.50136983,0.41338542,0.31706483,0.18774538,0.097395947,-0.025019381,-0.15822212,-0.24451939,-0.38230297,-0.53121939,-0.63889044,-0.78561998,-0.92011765,-1.0376552,-1.181602,-1.2894424,-1.4341007,-1.5540385,-1.6836169,-1.8111408,-1.9291959,-2.038991,-2.1716727,-2.2985382,-2.4087949,-2.3025931,-2.1461413,-2.0253426,-1.850469,-1.7082499,-1.5271766,-1.3837867,-1.2050383,-1.056348,-0.93942651,-0.8020693,-0.65577517,-0.54670071,-0.43434673,-0.30701752,-0.17420113,-0.058321369,0.047583678,0.16085804,0.25600215,0.31664366,0.36641681,0.46713346,0.5759915,0.64493242,0.7332937,0.78044516,0.86171858,0.92981375,1.0140188,1.1043294,1.1887043,1.2765634,1.3496479:2
0.7616589,0.69412812,0.62439482,0.54843055,0.4574341,0.35945559,0.25917916,0.15577961,0.03040488,-0.098177584,-0.2290731,-0.33867281,-0.44924512,-0.56114371,-0.6909012,-0.80993243,-0.92990885,-1.0407566,-1.1500822,-1.266442,-1.3903378,-1.4906814,-1.6065897,-1.7176278,-1.813645,-1.8889989,-1.8138472,-1.7271407,-1.6246845,-1.5423987,-1.4491395,-1.3531346,-1.2623314,-1.1673433,-1.0734405,-0.97896818,-0.88645675,-0.78884087,-0.69935689,-0.59497249,-0.50707551,-0.41438793,-0.31388818,-0.22553903,-0.13511191,-0.045677178,0.060993472,0.15513148,0.24336124,0.32836587,0.43321415,0.5190746,0.61430066,0.70993714,0.80999709,0.90169415,1.0057923,1.1014403,1.179057,1.2414549,1.2860734,1.2755364,1.2221293,1.1384732,1.0587547,0.98249325,0.88874517,0.81936139,0.73177753,0.65525491,0.58476117,0.50875917,0.4466843,0.47838317,0.56231261,0.68442748,0.77013028,0.85456575,0.91787429,0.9896594,1.0557023,1.0752272,1.1329774,1.2212008,1.2899993,1.3721797,1.4172025,1.4743145,1.5201987,1.5655644,1.5977828,1.6044148,1.5957244,1.5506336,1.5084304,1.4452261,1.3596267,1.2900054,1.1969543,1.1137262,1.0105272,0.92589002,0.84121911,0.74763492,0.647249,0.54350422,0.4447489,0.34521099,0.23629292,0.12746269,0.011067009,-0.11700896,-0.22439694,-0.3086612,-0.44434819,-0.5798903,-0.68821406,-0.79519926,-0.87543264,-0.86329752,-0.80804722,-0.73087882,-0.64995029,-0.57999273,-0.49197086,-0.40498279,-0.31776255,-0.23666926,-0.14947502,-0.065076363,0.019810516,0.11363676,0.19140937,0.28201331,0.37299759,0.45740086,0.55078767,0.625921,0.71063117,0.77099995,0.82482798,0.83283884,0.81981014,0.77553357,0.72633562,0.66975735,0.62351501,0.55500002,0.47977546,0.402492,0.29651553,0.21911404,0.11747401,0.011845267,-0.097635426,-0.19039521,-0.28988177,-0.39071746,-0.48609823,-0.5874506,-0.67191598,-0.76842887,-0.86591122,-0.96089142,-1.0491239,-1.144012,-1.2356919,-1.3308736,-1.3830015,-1.4807156,-1.5365513,-1.6213507,-1.714017,-1.8062767,-1.8907574,-1.9284244,-2.0238396,-2.0488716,-2.0851561,-1.9780001,-1.8817329,-1.7851825,-1.6860454,-1.5908148,-1.4947108,-1.3998679,-1.2966425,-1.2054004,-1.1089131,-1.0064779,-0.9038467,-0.80187428,-0.70315587,-0.58816436,-0.49664697,-0.38019306,-0.28184434,-0.17898392,-0.06214512,0.037598577,0.14254646,0.26697564,0.35774334,0.39895007,0.40750017,0.38636534,0.36446436,0.3427947,0.29718321,0.25150959,0.20347181,0.15051206,0.098243289,0.057539321,-0.003146754,-0.049848148,-0.093693059,-0.11696401,-0.14837515,-0.18868212,-0.23477193,-0.28374994,-0.34489741,-0.39974309,-0.46708099,-0.51673627,-0.56981346,-0.62392445,-0.67659418,-0.73714954,-0.78424565,-0.84011795,-0.89386037,-0.94822511,-0.9996553,-1.0470493,-1.0942727,-1.1146263,-1.1802537,-1.22682,-1.2591995,-1.2777599,-1.2842794,-1.2773078,-1.2427415,-1.1766921,-1.1629116,-1.1350736,-1.0941574,-1.0466679,-0.98452229,-0.91519791,-0.8329125,-0.74735753,-0.63183787,-0.52871823,-0.41860003,-0.30785343,-0.21799206,-0.14130084,-0.056921555,0.0044550498,0.041022537,0.086960747,0.10745708,0.14744215,0.16869702,0.19612525,0.21065646,0.23078278,0.25578411,0.28541793,0.31215234,0.34447089,0.3774776,0.41306437,0.45722655,0.50967179,0.5579453,0.60255904,0.66026568,0.70254395,0.74430115,0.79392019,0.8100249,0.84408483,0.87465615,0.897801,0.92366589,0.95548404,0.98870881,1.0365282,1.0773293,1.1244041,1.165785,1.2024187,1.2407519,1.3094084,1.4089759,1.5219375,1.6322412,1.7490818,1.8631156,1.9706253,2.0850061,2.1984913,2.3087108,2.4440279,2.5451765,2.5552431,2.5393562,2.5125798,2.4543306,2.3428998,2.2375913,2.1321514,1.9982031,1.8781068,1.7522868,1.6412194,1.5143199,1.4145834,1.3214691,1.2454217,1.1779081,1.1266295,1.0748187,1.0280009,0.98004507,0.92192645,0.87145278,0.81560623,0.76271131,0.71784067,0.68000985,0.64809528,0.61315877,0.56894218,0.51165766,0.45036371,0.38209017,0.33621264,0.30559149,0.28975195,0.27358156,0.25263393,0.22586391,0.19648239,0.16007636,0.13830875,0.11459102,0.091456174,0.062730624,0.039572287,0.03410982,0.014846978,0.0059578031,1.2071148E-5,-0.0012087965,-0.015093321,-0.032453334,-0.060953559,-0.069189296,-0.10640566,-0.12693546,-0.17634777,-0.25662869,-0.3143813,-0.41021883,-0.50569091,-0.59956941,-0.70710532,-0.8067756,-0.90188757,-1.0060353,-1.1020845,-1.1929315,-1.2878606,-1.3554763,-1.4232282,-1.4990644,-1.5777414,-1.6459656,-1.6721607,-1.6712667,-1.6506851,-1.6197034,-1.5763089,-1.5398441,-1.4706684,-1.3903378,-1.3193429,-1.2602882,-1.1936579,-1.124827,-1.0537752,-0.99798403,-0.93575496,-0.87827577,-0.82881375,-0.7717777,-0.71299838,-0.65766808,-0.58976162,-0.53550179,-0.47649357,-0.41280812,-0.35860839,-0.29687569,-0.22951135,-0.15706221,-0.089489878,-0.028406927,0.032800672,0.086193387,0.13598255,0.18855941,0.24057208,0.2864227,0.34992547,0.42017588,0.48177326,0.54731482,0.6061524,0.66335682,0.70853015,0.75005468:2
1.2237674,1.2597496,1.2337776,1.1138343,0.99819688,0.86433202,0.74829873,0.6348263,0.48978917,0.37246198,0.24023882,0.12700003,0.012861049,-0.10242159,-0.20474859,-0.33760901,-0.48321303,-0.57948069,-0.70863334,-0.82385691,-0.9516939,-1.0652638,-1.1850916,-1.3064487,-1.3970106,-1.5083249,-1.6557731,-1.7571789,-1.8904028,-2.0373566,-2.1383781,-2.2766261,-2.3193568,-2.2283157,-2.1680496,-2.1062153,-2.0066606,-1.8926119,-1.8327011,-1.7238196,-1.5902316,-1.5376797,-1.4613735,-1.3181823,-1.1964693,-1.0475035,-0.97716163,-0.85881492,-0.77376291,-0.68532971,-0.54718117,-0.4584515,-0.44561861,-0.52177528,-0.60942034,-0.68311778,-0.71970255,-0.68532579,-0.52391591,-0.36596031,-0.20569349,-0.097804218,0.013493454,0.14257195,0.31191272,0.43465388,0.54849188,0.59979383,0.58780577,0.72962185,0.86599073,1.0068253,1.140313,1.2637085,1.3672798,1.4934666,1.6546535,1.7785038,1.8959645,2.0219324,2.1573389,2.2296961,2.2399978,2.1812945,2.0555785,1.9196947,1.7898635,1.6561168,1.5347786,1.3972735,1.2908828,1.2123045,1.08542,0.96022666,0.83241516,0.71033505,0.58051528,0.58418176,0.57331072,0.47219415,0.34883639,0.2287183,0.10992275,0.026507725,-0.069178235,-0.14006977,-0.24373482,-0.2847888,-0.2464725,-0.17624238,-0.057793473,-0.0033281626,-0.035676674,-0.1639229,-0.27867251,-0.37864281,-0.45040712,-0.57285372,-0.71872696,-0.77891643,-0.83930347,-0.91481924,-1.0187194,-1.1599407,-1.2662274,-1.3719994,-1.4811638,-1.4948612,-1.3941931,-1.4291362,-1.4949925,-1.5872401,-1.6795648,-1.7128994,-1.8027831,-1.8696784,-1.9504395,-1.9811685,-2.0715075,-2.0386595,-1.9057407,-1.7645794,-1.6619552,-1.635447,-1.5469157,-1.4234614,-1.2807241,-1.1538914,-1.043297,-0.92341158,-0.79691634,-0.66912055,-0.55113204,-0.45675047,-0.3667903,-0.23159361,-0.11514706,0.024798021,0.14042608,0.25180654,0.3752368,0.48176719,0.61232249,0.73156929,0.84317905,0.97419307,1.0832869,1.2133905,1.3231317,1.313704,1.2843695,1.2147537,1.1195671,1.0132854,0.89303211,0.80327582,0.71511852,0.67504984,0.60871821,0.53700217,0.50269552,0.48492508,0.56321487,0.53543276,0.49827693,0.45232468,0.3852186,0.36420898,0.37236075,0.42981601,0.35011492,0.27529375,0.22539793,0.17067585,0.12834208,0.074434956,0.09910876,0.20867901,0.32398528,0.37866796,0.31537041,0.25754187,0.18421676,0.1314527,0.1383558,0.15939685,0.10653674,0.037108541,-0.02098285,-0.066416414,-0.10037918,-0.16156871,-0.088238457,0.0198115,-0.025255024,-0.081070433,-0.13476291,-0.18063062,-0.2125416,-0.23761826,-0.28188603,-0.30694047,-0.35012909,-0.38445947,-0.4079227,-0.30515686,-0.17593425,-0.063418855,0.080210411,0.2163149,0.22456882,0.20099232,0.17482966,0.16243576,0.16506142,0.16577909,0.25960056,0.26231054,0.24625035,0.2098624,0.1385852,0.10761593,0.050257049,0.12713382,0.14414244,0.14171716,0.091745936,0.036150445,-0.027166324,-0.043617155,-0.14671055,-0.21024089,-0.15577666,-0.15813326,-0.1810923,-0.24606062,-0.27812786,-0.37532578,-0.43564836,-0.51921074,-0.5986951,-0.68923977,-0.77398222,-0.84415395,-0.91085473,-0.98280395,-1.0317303,-1.0911221,-1.136359,-1.1673379,-1.0870466,-1.0958545,-0.998436,-0.9257916,-0.84314152,-0.69656774,-0.54545747,-0.37156019,-0.19780568,-0.023977119,0.14929489,0.32329557,0.49667211,0.6704672,0.84466072,1.0178672,1.1818999,1.3151937,1.4405814,1.5644177,1.7146921,1.8431914,1.939308,2.0659819,2.2406468,2.3675929,2.4669308,2.5577348,2.6459342,2.6811848,2.6499396,2.5525538,2.4623814,2.3411047,2.2145423,2.162118,2.1423126,1.9885478,1.9098664,1.7847862,1.6103113,1.4358742,1.3105755,1.1364567,0.96225378,0.80580738,0.66320487,0.48891253,0.32229133,0.23666691,0.11448226,-0.0595597,-0.23361242,-0.40762371,-0.57366153,-0.70601405,-0.87998351,-1.0271018,-1.1388591,-1.2078327,-1.1451185,-1.0908268,-1.0372741,-0.99641821,-0.92864552,-0.86065183,-0.79892781,-0.74058889,-0.65592404,-0.57265019,-0.50865449,-0.42567938,-0.33566175,-0.25994722,-0.21995227,-0.26059105,-0.38042697,-0.43945515,-0.37496426,-0.33620447,-0.28980737,-0.26149514,-0.30716064,-0.24682314,-0.18947519,-0.10095317,-0.068185217,-0.16392458,-0.19910786,-0.12787679,-0.083340191,-0.038356917,0.0073784888,0.052487372,0.072774681,-0.014621503,-0.033493445,-0.024937558,-0.028938252,-0.015910386,-0.0020591378,-0.0013135041,-0.075662654,-0.20566129,-0.34120157,-0.47954972,-0.60160195,-0.73951125,-0.71156739,-0.64712751,-0.60371678,-0.53831976,-0.48461281,-0.43872084,-0.37548941,-0.33361052,-0.28559612,-0.22942215,-0.17230211,-0.16035272,-0.25063758,-0.20446237,-0.14435444,-0.091732615,-0.037331411,0.015106526,0.075492853,0.14385308,0.13593692,0.18984469,0.24619419,0.28363898,0.33061163,0.29569825,0.15805979,-0.017291714,-0.040725936,0.021997246,0.085762961,0.15344255,0.22505687,0.182175,0.2667561,0.33531989,0.42961142,0.50617265,0.45302837,0.37195619,0.42170436,0.52828456,0.63214027,0.71426537,0.80067529,0.89312475,0.98751533,1.0938072,1.1713643:3
1.6368238,1.5638322,1.4927627,1.4176231,1.33612,1.2756187,1.2164358,1.1511415,1.1155273,1.0505009,0.97989699,0.90671815,0.82480128,0.77286263,0.72135031,0.68034559,0.69272941,0.74833567,0.81867698,0.89144424,0.96144564,1.0287633,0.97541268,0.87868739,0.7731469,0.70178095,0.61261891,0.51891005,0.4282137,0.35952916,0.33193718,0.24879921,0.14506533,0.12917647,0.048936832,0.020377875,-0.069167829,-0.20047823,-0.31961519,-0.37119469,-0.40622031,-0.47064957,-0.56094932,-0.67706481,-0.80807195,-0.86129054,-0.86170226,-0.85451986,-0.84990049,-0.76798678,-0.66386842,-0.55938122,-0.51042422,-0.43423309,-0.35787879,-0.28093659,-0.19038677,-0.10243351,-0.0020611648,0.10440744,0.20658737,0.31295352,0.41601163,0.51946351,0.53221901,0.44175264,0.34110812,0.23335395,0.1380573,0.074501581,-0.016851302,-0.10404407,-0.19531346,-0.28462343,-0.36865456,-0.42283491,-0.49531652,-0.57570785,-0.63968416,-0.64840873,-0.64854241,-0.6738322,-0.73328047,-0.8048858,-0.89136918,-0.97864209,-1.056787,-1.1332438,-1.2260803,-1.2968601,-1.3652753,-1.4341615,-1.4469871,-1.4424593,-1.4480136,-1.4821348,-1.5220042,-1.5460091,-1.5771333,-1.653177,-1.5705836,-1.5821202,-1.521202,-1.4853309,-1.3999433,-1.3356438,-1.2465558,-1.165446,-1.0782025,-0.98065813,-0.87562207,-0.76854906,-0.66943977,-0.56051,-0.44646355,-0.34286815,-0.23893881,-0.14276807,-0.030568892,0.062658748,0.16200076,0.26524684,0.35911609,0.44302855,0.54699041,0.65889497,0.76145242,0.84435207,0.95421119,1.0631759,1.1531155,1.2216301,1.1579555,1.2344965,1.3274715,1.3962042,1.4748215,1.5467074,1.6450963,1.7540236,1.8611543,1.968519,2.0679857,2.1790199,2.2547935,2.2725044,2.276742,2.1678534,2.0650828,2.0108608,1.9016634,1.8470092,1.7970255,1.7436882,1.6851246,1.6478678,1.570683,1.5229803,1.4629418,1.4202988,1.3251369,1.2670903,1.1600809,1.0555998,0.95065856,0.8445153,0.73640516,0.62924579,0.52453855,0.4179766,0.33856775,0.2391637,0.1326874,0.02434308,-0.080386835,-0.18940455,-0.29451786,-0.39607417,-0.50362342,-0.60996905,-0.71910139,-0.82241199,-0.93258407,-1.0387155,-1.141218,-1.2515142,-1.345803,-1.3868408,-1.4550578,-1.5261348,-1.4957205,-1.4663535,-1.4673992,-1.4767501,-1.3773977,-1.2756685,-1.1680154,-1.0934178,-1.0346398,-0.94914786,-0.86192989,-0.80825825,-0.76300562,-0.71066376,-0.63697649,-0.55960653,-0.50482356,-0.48161675,-0.48988569,-0.40920356,-0.33108947,-0.26296079,-0.23670472,-0.18828534,-0.12794017,-0.028570651,0.039063801,0.052534002,-0.05008605,-0.1659541,-0.26803759,-0.37637056,-0.48850665,-0.58821956,-0.70547417,-0.83138234,-0.95254013,-1.0910789,-1.1181275,-1.0751184,-1.0575936,-1.048881,-1.0065972,-0.89198165,-0.79635398,-0.70684624,-0.6582197,-0.60107134,-0.50179133,-0.38431655,-0.27295912,-0.18816057,-0.14537574,-0.07994348,-0.028824143,0.033623367,0.11609865,0.20380714,0.26440541,0.3379164,0.42905373,0.48435014,0.54243285,0.58018353,0.50737836,0.43693238,0.37706743,0.3588414,0.43302981,0.50022342,0.59170536,0.68262277,0.77639672,0.86266559,0.92196884,0.92687439,0.82266124,0.71423452,0.67450774,0.61040752,0.5033799,0.43675447,0.4875155,0.50687838,0.49900793,0.40386642,0.29737742,0.19498431,0.13785889,0.12681677,0.080948935,-0.019091182,-0.12222382,-0.22248095,-0.3253988,-0.42941626,-0.5372671,-0.64509053,-0.7516026,-0.855555,-0.94650791,-1.0211286,-1.1348965,-1.2357701,-1.3322532,-1.4001919,-1.477557,-1.4710505,-1.5734164,-1.6318494,-1.6894771,-1.7280972,-1.7854516,-1.7795048,-1.7369462,-1.7170441,-1.6353976,-1.5678195,-1.4778491,-1.3698681,-1.2430459,-1.1357152,-1.0198699,-0.8957433,-0.78532519,-0.69135645,-0.62159591,-0.50137456,-0.42771244,-0.33350523,-0.24994388,-0.16652141,-0.066632804,0.056354875,0.1567459,0.2353689,0.3363788,0.43485122,0.49745979,0.6074497,0.70869915,0.6967554,0.64525275,0.59855288,0.61779992,0.68095047,0.77418274,0.86373524,0.94108412,1.010168,1.1024131,1.1936464,1.2735008,1.3308783,1.4157794,1.4947354,1.586635,1.6681911,1.7539448,1.8488706,1.9407749,1.9612056,1.8394511,1.7224814,1.6169124,1.5409267,1.4380143,1.3202733,1.2382928,1.1661266,1.1114653,1.0083301,0.88208899,0.78824505,0.67936023,0.57076256,0.4658565,0.449658,0.42459886,0.45203218,0.52077485,0.57126932,0.52090967,0.41415218,0.30510975,0.20987347,0.12398668,0.02146703,-0.052881645,-0.15623502,-0.26108366,-0.36574198,-0.46573366,-0.569989,-0.67551534,-0.78527633,-0.87086055,-0.97063655,-1.0757837,-1.1703721,-1.2726095,-1.3450078,-1.4495611,-1.5549406,-1.6072323,-1.6686572,-1.7052344,-1.6618524,-1.5490311,-1.4342365,-1.3262312,-1.2134799,-1.1125328,-1.0021864,-0.89332996,-0.78617929,-0.66736588,-0.54913354,-0.43855017,-0.31988535,-0.20509292,-0.091481494,0.02696192,0.14984765,0.24636718,0.36589552,0.49411559,0.61916967,0.72801382,0.84375479,0.95442705,1.0863387,1.2042566,1.3371819,1.4580509,1.5774485,1.6836021:5
2.6823231,2.5929464,2.5292171,2.4196833,2.3232741,2.2100583,2.1264136,2.020832,1.9183664,1.8143964,1.710874,1.6044865,1.5009946,1.4149409,1.3503776,1.2462372,1.1563557,1.071023,0.98294011,0.88601964,0.80422827,0.69643815,0.61408247,0.52893772,0.42605961,0.32001987,0.23301837,0.12572873,0.03627792,-0.052691813,-0.1489059,-0.2387852,-0.34383236,-0.43284803,-0.53026784,-0.61434521,-0.73648417,-0.8265411,-0.93804508,-1.0213158,-1.1242056,-1.2510226,-1.3297888,-1.4330985,-1.5351556,-1.6323052,-1.7159613,-1.8325892,-1.8888378,-1.8768562,-1.8404791,-1.8323966,-1.7991511,-1.759374,-1.805779,-1.7654402,-1.7112262,-1.6543735,-1.5761442,-1.5411707,-1.4724024,-1.3863053,-1.3110376,-1.2589639,-1.1693216,-1.1044489,-1.1103236,-1.0619076,-1.1095088,-1.2028619,-1.1860669,-1.1005616,-1.0167244,-0.91980084,-0.8330786,-0.77682356,-0.74558485,-0.78958513,-0.76466944,-0.8115907,-0.79457711,-0.80115385,-0.74586583,-0.65809249,-0.60206364,-0.51641402,-0.48687012,-0.43896206,-0.37094092,-0.31838228,-0.23685937,-0.20497387,-0.21108502,-0.27754688,-0.36872782,-0.44520691,-0.53320632,-0.61807891,-0.70667595,-0.79160724,-0.88061913,-0.95113173,-0.94016002,-0.89146599,-0.82322555,-0.77207231,-0.71778099,-0.64387265,-0.59674891,-0.59752288,-0.60740444,-0.50292506,-0.43931535,-0.3796317,-0.32686518,-0.26580599,-0.22262603,-0.15274234,-0.1148902,-0.083541945,-0.10913633,-0.17270298,-0.22633975,-0.23701681,-0.16741309,-0.10154873,-0.01429903,0.059986969,0.12785879,0.19948593,0.269975,0.33812532,0.40041299,0.44054315,0.51785842,0.60954322,0.69387759,0.76289247,0.84471015,0.94067027,1.0128433,1.096731,1.1729447,1.1429072,1.0790094,0.96765126,0.88108209,0.78543441,0.68674964,0.59435471,0.53825072,0.48523651,0.38924309,0.2983322,0.21056888,0.12124614,0.029092601,-0.061372139,-0.081178747,-0.082752019,-0.13929314,-0.23707143,-0.31158772,-0.40356151,-0.48598699,-0.56945601,-0.64664633,-0.7376064,-0.81008779,-0.85553732,-0.90900986,-0.88808743,-0.78973538,-0.67506809,-0.57670198,-0.49047986,-0.42008238,-0.34447747,-0.31625326,-0.32533912,-0.23640501,-0.11453378,-0.012920299,0.10526745,0.14332965,0.21321788,0.28201548,0.33774753,0.41015574,0.42633258,0.36970571,0.29743584,0.23825613,0.18413076,0.13819152,0.12739311,0.22590368,0.35056532,0.41804678,0.49691294,0.56838784,0.64709721,0.7225086,0.80745793,0.86247552,0.83182237,0.84188876,0.9294613,1.0297221,1.1238787,1.2019984,1.3057939,1.3888103,1.4869096,1.5904512,1.6712539,1.7021799,1.6555645,1.5615927,1.4657606,1.3770468,1.3246822,1.2163653,1.10802,1.016582,0.95785539,0.98293446,0.90147829,0.78181348,0.66802121,0.56572747,0.49953182,0.41253774,0.32486078,0.26708728,0.32919442,0.39771169,0.47378953,0.54087994,0.54451563,0.47433236,0.37272274,0.32120404,0.22617645,0.20974007,0.11106169,0.02610824,-0.072113144,-0.16753286,-0.19805729,-0.22904707,-0.32897226,-0.42454839,-0.51814777,-0.61255504,-0.67585968,-0.76279432,-0.69221441,-0.64413571,-0.54607553,-0.49693458,-0.46971573,-0.381803,-0.28953843,-0.20593999,-0.14374152,-0.045208859,0.055199741,0.13603029,0.11311197,0.10369712,0.19724313,0.30151286,0.38642634,0.48286855,0.57916847,0.67037889,0.75508591,0.83679152,0.90576602,0.9929245,1.0599811,1.1539586,1.2591394,1.3635244,1.4421858,1.4123388,1.3458599,1.276304,1.1887075,1.1119641,1.0330668,0.96821683,0.88770975,0.80213433,0.71470327,0.62770911,0.6348359,0.62948248,0.55453909,0.48544676,0.41410441,0.32831806,0.30299799,0.35469166,0.29715621,0.21756557,0.15952232,0.09145085,0.021978982,0.045363623,0.10540399,0.15792042,0.23043781,0.16926563,0.098342411,0.04513647,-0.028837584,-0.087271843,-0.15715385,-0.22848898,-0.30461072,-0.37292704,-0.33744375,-0.37932366,-0.43467414,-0.49732954,-0.54412228,-0.63024161,-0.69784889,-0.77945045,-0.71843765,-0.63227221,-0.54561953,-0.45764202,-0.36879588,-0.2940404,-0.21017451,-0.1251583,-0.039655219,0.03148018,5.101759E-5,-0.059135534,-0.12732259,-0.17071053,-0.23581654,-0.32151123,-0.42519305,-0.5224651,-0.5218273,-0.54289244,-0.58281921,-0.681345,-0.76508496,-0.87239927,-0.95979222,-1.0411247,-1.1231462,-1.0421055,-1.0175586,-1.0691508,-1.110727,-1.1844487,-1.2548432,-1.3234948,-1.4075281,-1.4899958,-1.5631591,-1.6401425,-1.7250755,-1.8117584,-1.9019283,-1.9837489,-2.0638456,-2.1345705,-2.1968059,-2.131369,-2.0342082,-1.9099468,-1.8117158,-1.686564,-1.587943,-1.4887981,-1.3803233,-1.2894934,-1.1805163,-1.0861734,-0.98780119,-0.88659494,-0.78496383,-0.69863553,-0.60622544,-0.50361025,-0.40342494,-0.32332584,-0.21978629,-0.12921612,-0.037087911,0.057170508,0.14731826,0.23840349,0.33154467,0.42161514,0.51665413,0.5973096,0.70286584,0.78425164,0.8805272,0.97242631,1.0764849,1.1662462,1.2626289,1.3454061,1.4216516,1.4950235,1.596817,1.6831365,1.7868738,1.8906411,1.9946216,2.0982112,2.2008438,2.3070278,2.4203026,2.5123084,2.5972067,2.6454721:3
1.7595362,1.726797,1.6211576,1.4781996,1.3633887,1.2360249,1.1543355,1.0752865,0.96624777,0.8946287,0.76837837,0.6440417,0.53191653,0.38313914,0.25602295,0.16711478,0.11386718,-0.066592887,-0.2510631,-0.42506447,-0.39568053,-0.40125591,-0.54572467,-0.75081183,-0.83189355,-0.84200414,-0.99985141,-1.028439,-1.1916448,-1.0716336,-0.89113582,-0.71819859,-0.53242523,-0.3504483,-0.25001579,-0.051485425,0.1325562,0.30698016,0.35322195,0.46862169,0.66919128,0.8798087,1.0503023,1.2407052,1.4367986,1.53201,1.464763,1.377799,1.2779149,1.1608479,1.064953,0.98611348,0.89561783,0.76619839,0.65384574,0.52127988,0.37737126,0.30996234,0.23758041,0.12742223,0.068681997,-0.021046458,-0.066136167,-0.148858,-0.19643032,-0.27387055,-0.35361775,-0.48346762,-0.58602134,-0.73314804,-0.80111024,-0.70672466,-0.52709598,-0.34412182,-0.21834794,-0.061278907,0.11942786,0.35425368,0.48995142,0.68154228,0.87259014,1.0527379,1.1845219,1.2071546,1.1767463,1.1123793,1.0649721,1.0096045,0.91915933,0.84803518,0.81475895,0.72191386,0.76109352,0.63766727,0.56048622,0.46777297,0.43092273,0.35529783,0.25800812,0.18848957,0.12972701,0.042339392,-0.0037308523,-0.045122282,-0.12591551,-0.25433732,-0.32909378,-0.33590808,-0.42649558,-0.27190997,-0.21364687,-0.032577793,0.15544431,0.098770038,0.045819185,-0.016522642,-0.10111582,-0.14444879,-0.19453078,-0.29758351,-0.37525828,-0.41949497,-0.53985844,-0.41474648,-0.38251958,-0.44370971,-0.53303751,-0.66425627,-0.75996711,-0.90247992,-0.97827312,-1.094659,-1.2391597,-1.3665354,-1.5066015,-1.5857598,-1.6907286,-1.8084096,-1.8579855,-1.9066967,-2.0416263,-2.1747752,-2.3099125,-2.4588653,-2.59815,-2.7550752,-2.7050603,-2.5233317,-2.3462826,-2.1946467,-1.9513653,-1.7036894,-1.4615063,-1.2791296,-1.1458328,-0.99098661,-0.77258291,-0.58960348,-0.40308563,-0.15658399,0.028887865,0.27598905,0.48725218,0.7096327,0.89728989,1.1448286,1.3340497,1.5801586,1.7694265,1.9584672,2.1460689,2.3347145,2.4652258,2.6313038,2.7644791,2.8075841,2.7957848,2.611196,2.4230988,2.2301145,2.0918241,1.9149838,1.7569269,1.5706845,1.3790146,1.1290775,0.93769795,0.68793443,0.49680934,0.24737426,0.056578304,-0.19259204,-0.38320416,-0.57895926,-0.82202283,-1.0113107,-1.2596641,-1.4500356,-1.6977386,-1.9465025,-2.1965054,-2.3837947,-2.3119977,-2.1957705,-2.1059581,-2.0325831,-1.8964855,-1.7808699,-1.6025512,-1.4736032,-1.3187225,-1.2211311,-1.073603,-0.97377683,-0.94934202,-0.88774243,-0.80799413,-0.73198226,-0.61209873,-0.48730157,-0.37770364,-0.34737864,-0.20684801,-0.13177007,-0.09042465,-0.078461564,-0.17884991,-0.081133294,0.029363848,0.16698284,0.22944112,0.36629078,0.43711507,0.33847402,0.14056125,-0.015113642,-0.13805924,-0.33266898,-0.49412805,-0.5121838,-0.43176159,-0.42009935,-0.32072022,-0.16649324,-0.13853821,-0.069937381,-0.020565688,0.06403379,0.068955486,0.096977442,0.20611369,0.248005,0.28067133,0.34674798,0.41114668,0.30998153,0.36680248,0.41893428,0.48286254,0.55081086,0.56353351,0.62536366,0.69473577,0.75648869,0.55210085,0.35318776,0.14292913,0.10012485,-0.076141981,-0.25872336,-0.44649316,-0.60071562,-0.55881199,-0.73673744,-0.90665869,-0.8135985,-0.72160369,-0.64142275,-0.54202261,-0.48018994,-0.38957208,-0.30871287,-0.26807527,-0.16818063,-0.095251385,-0.025868945,-0.057577735,-0.13702839,-0.049557847,0.067932274,0.16602762,0.29293925,0.35409806,0.30859027,0.41427595,0.54283658,0.55369196,0.64718735,0.76795144,0.89609569,0.98835215,1.0478215,0.95487734,0.77729216,0.60238517,0.4578394,0.26321244,0.14413563,0.020498213,-0.10511344,-0.27648194,-0.41466322,-0.57984826,-0.7103589,-0.91118149,-0.81126084,-0.68819353,-0.57103161,-0.44148079,-0.3036184,-0.3522025,-0.28117033,-0.13259292,0.015095908,0.13199395,0.28349831,0.41604058,0.54391243,0.46631772,0.45955049,0.62823369,0.7872975,0.94484382,1.0024151,1.1635308,1.2714191,1.4279287,1.5304642,1.5051946,1.3206314,1.182055,0.98809928,0.82550595,0.65414669,0.46411701,0.38527394,0.2173322,0.04923998,-0.11776398,-0.29528478,-0.43202427,-0.61459879,-0.78566984,-0.95041729,-1.0889612,-1.1303902,-1.1284514,-0.98846621,-0.776433,-0.6156541,-0.43121207,-0.32953774,-0.19744317,-0.1864624,-0.04530025,0.11116245,0.19246475,0.41842788,0.52355693,0.5394769,0.70681467,0.8598078,0.99538797,1.1311149,1.3375559,1.2448028,1.0857926,0.95643754,0.83225339,0.70076366,0.67732549,0.59540177,0.47678319,0.35793839,0.24874767,0.14079992,0.083588066,-0.049557847,-0.15781892,-0.29602158,-0.40840951,-0.4963792,-0.62832647,-0.79407328,-0.92401447,-1.1549795,-1.2947912,-1.5004862,-1.4761888,-1.6022439,-1.7261988,-1.6011525,-1.3904975,-1.212174,-1.0488734,-0.87853525,-0.9321914,-0.7699219,-0.61251176,-0.44540088,-0.31609991,-0.151781,0.0063257455,0.18520379,0.16335088,0.1306942,0.28165485,0.43901647,0.57619416,0.73192516,0.8393783,0.92801096,1.0954765,1.2431731,1.3988178,1.5646039,1.7175172:1
1.8977132,1.9038945,1.9495067,1.9797717,2.0658041,2.1212284,2.0805933,2.0057259,1.9823964,2.0245896,2.0441702,2.0416237,1.9593838,1.8968815,1.8317959,1.7551508,1.667797,1.606398,1.5359498,1.468539,1.4090762,1.3288535,1.285038,1.2203393,1.1526739,1.1117415,1.0730063,1.0336111,0.99558041,0.97405963,0.93930881,0.89992682,0.86296448,0.82911502,0.79482102,0.77021615,0.75851446,0.73817608,0.70224884,0.6749637,0.63934392,0.61507853,0.58935841,0.55375735,0.53106803,0.50143477,0.47795051,0.45189726,0.41416009,0.40184418,0.37137247,0.34062048,0.32766217,0.31816192,0.2973691,0.28467442,0.26395713,0.25786971,0.21945772,0.19444026,0.18078378,0.18566746,0.16587784,0.1395161,0.12636169,0.09396259,0.057320598,0.038957817,0.027305108,0.026326645,0.026065021,0.0085245508,-0.0073838029,-0.039569877,-0.069963743,-0.072175716,-0.099266704,-0.090078034,-0.1066292,-0.099266704,-0.093418392,-0.11209565,-0.16178658,-0.17079426,-0.1854347,-0.21571296,-0.22782581,-0.17593004,-0.20890727,-0.16096473,-0.13679598,-0.19708622,-0.22734104,-0.25217043,-0.2060304,-0.20239949,-0.22341104,-0.24338724,-0.22683311,-0.3044667,-0.33327157,-0.36561302,-0.37282742,-0.44397574,-0.52539933,-0.60500639,-0.67522561,-0.74593749,-0.82249293,-0.91123198,-0.98289695,-1.0661049,-1.1419166,-1.2025119,-1.2896994,-1.3499657,-1.4338378,-1.5104573,-1.5894607,-1.6698946,-1.7522393,-1.7714222,-1.7483438,-1.6794855,-1.7155574,-1.7485358,-1.7911284,-1.7402097,-1.6778195,-1.6369177,-1.6185301,-1.5719946,-1.5367116,-1.4895094,-1.4530495,-1.3752542,-1.3222986,-1.293362,-1.2646732,-1.1648869,-1.1330023,-1.0841337,-1.0643598,-1.0275636,-0.96643142,-0.92248447,-0.86868207,-0.81408337,-0.78887292,-0.7560661,-0.7496931,-0.74018378,-0.73506601,-0.68960812,-0.65592495,-0.59603165,-0.53344491,-0.49813627,-0.46963495,-0.43584566,-0.38995131,-0.36973086,-0.3245757,-0.28110167,-0.24378904,-0.19557307,-0.15548233,-0.11611629,-0.094417522,-0.015885691,0.031706158,0.08150438,0.10911816,0.17682783,0.24346726,0.26138735,0.27338666,0.27516447,0.289796,0.29909803,0.29318911,0.28773779,0.31958799,0.29027558,0.2679724,0.31027962,0.26077005,0.25211727,0.25209828,0.23285084,0.15941061,0.19387317,0.25904414,0.26348727,0.24041286,0.23449083,0.19572109,0.19984946,0.15686862,0.11039606,0.099740369,0.088133177,0.17083576,0.16649347,0.14286806,0.22663458,0.2990089,0.39025976,0.43202273,0.51032094,0.54584938,0.62675791,0.66525563,0.7498845,0.79863858,0.87015201,0.91725357,0.95655752,0.98130536,1.0329706,1.0749767,1.1322908,1.1665895,1.1673389,1.2019122,1.2716306,1.3320825,1.3811818,1.4028646,1.4394232,1.5174234,1.4678808,1.4171817,1.4573471,1.5039889,1.5422268,1.5850664,1.6632985,1.7014418,1.7547354,1.7929543,1.8373612,1.8537444,1.8631829,1.8621096,1.845599,1.8219157,1.7764236,1.7423113,1.7012305,1.6580651,1.6085923,1.5595778,1.5068624,1.447358,1.3903256,1.3290201,1.2770914,1.2130521,1.1550291,1.1017757,1.0219115,0.94555529,0.88596929,0.82342268,0.75375411,0.66821198,0.60039767,0.50361348,0.43078036,0.36095992,0.26169495,0.15968744,0.091969868,-0.020296698,-0.13169945,-0.19005201,-0.30229333,-0.38888651,-0.42839195,-0.38050528,-0.31388449,-0.21354499,-0.18900972,-0.23641231,-0.27864401,-0.33253557,-0.38107692,-0.42552158,-0.46739354,-0.51115811,-0.54344067,-0.5961144,-0.62160499,-0.67777791,-0.74206897,-0.79182225,-0.82964804,-0.80439862,-0.72320469,-0.75980825,-0.83092043,-0.88838504,-0.87661686,-0.87456746,-0.89830698,-0.91444416,-0.91515192,-0.93076656,-0.95278572,-0.97648178,-0.98660756,-1.0256579,-1.0648079,-1.1292056,-1.1708357,-1.2292333,-1.2485165,-1.3463021,-1.3884191,-1.4265927,-1.4843311,-1.5196446,-1.5694883,-1.5920144,-1.6405848,-1.6553865,-1.6720891,-1.6699436,-1.6797415,-1.6852169,-1.655248,-1.6416619,-1.5944101,-1.5262253,-1.4773889,-1.3918006,-1.3111624,-1.2485793,-1.1625195,-1.1060452,-1.0161817,-0.9636071,-0.90256577,-0.8526594,-0.79851903,-0.76176418,-0.72825133,-0.69479342,-0.69379298,-0.69110128,-0.67919825,-0.68427471,-0.69115678,-0.69841027,-0.70560942,-0.70910934,-0.71199865,-0.71240751,-0.70172707,-0.68451938,-0.67355791,-0.66300228,-0.65187924,-0.64209179,-0.66729718,-0.66205593,-0.6686473,-0.65715963,-0.67945953,-0.70208548,-0.72574812,-0.72945429,-0.74265107,-0.78668523,-0.81331976,-0.83859744,-0.862492,-0.8599856,-0.8761415,-0.81738339,-0.81109834,-0.82262466,-0.7549563,-0.74378909,-0.70102674,-0.63881448,-0.57848374,-0.53902737,-0.61898293,-0.62786411,-0.55358094,-0.48981128,-0.42500487,-0.39026501,-0.37935415,-0.32527661,-0.23606344,-0.16705306,-0.076285415,-0.020408603,-0.053000718,-0.013471501,0.050671525,0.068710593,0.17316386,0.26504012,0.3348428,0.42002502,0.5104145,0.58696759,0.67598677,0.7585596,0.8484289,0.92672628,1.0206072,1.1013018,1.1659922,1.2461818,1.3289056,1.4120038,1.4828989,1.5652538,1.6441456,1.7222582,1.8055407,1.8883749:2
1.9192548,1.8025513,1.6819793,1.5826815,1.4649704,1.364349,1.2623872,1.1422738,1.0293023,0.98048223,0.9956141,1.0627602,1.1455731,1.2364897,1.3304567,1.2817553,1.1746445,1.1031176,1.1324168,1.1117826,1.0090862,0.91558529,0.82281874,0.72261132,0.62149198,0.52200396,0.43381762,0.33257286,0.24395749,0.14240121,0.049709825,-0.045018366,-0.13877058,-0.23737627,-0.3467447,-0.45950662,-0.5496918,-0.66082208,-0.746911,-0.84756782,-0.91881744,-0.97271255,-0.99911743,-0.98485537,-0.91920775,-0.83883919,-0.74222193,-0.64285895,-0.55157088,-0.46952813,-0.36969787,-0.27280368,-0.18739594,-0.08272574,0.0014403794,0.096115006,0.19031112,0.27770084,0.37456213,0.45909178,0.54836815,0.60898984,0.51491253,0.43780736,0.34374175,0.25887999,0.17119081,0.087931841,-0.004808013,-0.088505379,-0.17476757,-0.25394408,-0.33765179,-0.40143956,-0.39603784,-0.47557702,-0.56468185,-0.65111878,-0.73074386,-0.8148185,-0.89623186,-0.97432329,-1.0609172,-1.1376087,-1.2090724,-1.2844009,-1.3608899,-1.4285751,-1.5065797,-1.5758977,-1.6490057,-1.7181148,-1.802181,-1.8629425,-1.9288498,-1.9876903,-2.0370843,-2.0760194,-2.1163991,-2.1528607,-2.1825698,-2.1883642,-2.1747678,-2.1369531,-2.0870282,-2.0223472,-1.9517449,-1.8702917,-1.7796794,-1.6931724,-1.5992385,-1.4891128,-1.3806674,-1.2973739,-1.2177908,-1.1455642,-1.0664742,-0.96618286,-0.84898692,-0.74690232,-0.64876383,-0.58901919,-0.63488295,-0.68028725,-0.70999795,-0.70355568,-0.73305068,-0.74486038,-0.76657004,-0.78526085,-0.81688122,-0.83788645,-0.8555247,-0.86188212,-0.86039325,-0.85718597,-0.85666178,-0.85407875,-0.84954893,-0.85652454,-0.85592466,-0.85563865,-0.85040784,-0.8503098,-0.84298161,-0.82898663,-0.78559884,-0.72142421,-0.63992139,-0.57633407,-0.50104545,-0.44286133,-0.36059497,-0.27394334,-0.16049367,-0.066621409,0.019507151,0.10687522,0.18026124,0.25599017,0.33165767,0.40382435,0.47778036,0.54946185,0.6151048,0.69614484,0.77243003,0.83340391,0.85372573,0.80056398,0.78141408,0.77679627,0.80076904,0.84062868,0.82787073,0.81637073,0.80782102,0.81196438,0.81852377,0.82991553,0.84432722,0.86064551,0.886603,0.91010691,0.92923572,0.95951586,0.98304636,0.99081938,0.97613571,0.90570084,0.87633677,0.90200599,0.92429885,0.8701102,0.89027229,0.97007667,1.007517,1.0494888,1.0987321,1.1506721,1.254469,1.3589989,1.4796363,1.5776204,1.7010597,1.8242383,1.9343509,2.0380195,2.0543854,1.9543054,1.8486341,1.736161,1.6138254,1.5170065,1.3964602,1.3218819,1.2537066,1.197875,1.129721,1.1188997,1.1511035,1.1830632,1.1977374,1.2038672,1.2044557,1.2027447,1.1985262,1.1842553,1.1729269,1.1593184,1.1391715,1.1224905,1.1102733,1.0868552,1.0674164,1.032633,1.0122488,0.97826533,0.94830597,0.91642121,0.88518139,0.86151096,0.83276867,0.81250496,0.7934932,0.78066953,0.7577911,0.72712747,0.74640557,0.73985707,0.73605063,0.73460857,0.74390508,0.75154921,0.76769526,0.78908391,0.81918198,0.85239566,0.8060961,0.80819512,0.82286988,0.84422318,0.87088922,0.91009099,0.94641896,1.006793,0.95452139,0.85842081,0.74171986,0.65957888,0.55045347,0.43871149,0.32738731,0.23266316,0.12372702,0.016585207,-0.07823274,-0.1678918,-0.27499555,-0.35987497,-0.44645702,-0.54012438,-0.62280705,-0.71008794,-0.77611034,-0.83706686,-0.86966444,-0.89777915,-0.90163643,-0.90362768,-0.88886066,-0.88764989,-0.88391356,-0.87393249,-0.85763613,-0.83666284,-0.818589,-0.78199509,-0.75262432,-0.71313231,-0.67372591,-0.62986712,-0.5836085,-0.53251125,-0.48863224,-0.4363871,-0.387334,-0.4444962,-0.45211053,-0.41517362,-0.36395628,-0.30439081,-0.2469955,-0.17339003,-0.10230666,-0.070795268,-0.0083332771,0.055940356,0.062049041,-0.028753127,-0.11019567,-0.18502956,-0.25877393,-0.34286969,-0.42833116,-0.551178,-0.63488644,-0.72449201,-0.82316349,-0.93030294,-1.0158909,-1.1158464,-1.2196194,-1.3199059,-1.4267077,-1.5246012,-1.6434257,-1.7536078,-1.8338923,-1.8875172,-1.9040206,-1.9099459,-1.8950442,-1.8693466,-1.831584,-1.7795136,-1.7225884,-1.6280395,-1.5360979,-1.4452226,-1.3578794,-1.2565953,-1.1738168,-1.0658356,-0.95823477,-0.84558457,-0.72958409,-0.61067456,-0.49355566,-0.38065507,-0.26564439,-0.17608755,-0.10172278,-0.10398294,-0.040655459,0.047521191,0.12958679,0.22648378,0.31954144,0.41907583,0.54454926,0.60325678,0.60005859,0.4974978,0.40360264,0.32737482,0.25459215,0.19722741,0.10961224,0.011913856,-0.067557229,-0.15609174,-0.23191863,-0.3081452,-0.37381986,-0.44415561,-0.51466707,-0.58717825,-0.61115871,-0.5860721,-0.54331358,-0.47273107,-0.40028108,-0.32314451,-0.24431109,-0.16738352,-0.077982678,0.011682497,0.093341803,0.17438773,0.26186112,0.35483678,0.43822974,0.54318589,0.62094895,0.68871242,0.76639308,0.8484621,0.93163321,1.0245185,1.1134854,1.0270023,0.90862543,0.84640096,0.86257716,0.92393368,0.99681325,1.0656552,1.1584819,1.2444934,1.3268148,1.4155923,1.5024119,1.5965345,1.6940372,1.7970178,1.882989:4
-0.47865143,-0.45144798,-0.44870392,-0.44661068,-0.48356275,-0.5316478,-0.61374451,-0.66434459,-0.75009973,-0.82907476,-0.89949202,-0.99129905,-1.0566709,-1.1508977,-1.2218697,-1.2902105,-1.3818112,-1.4471951,-1.5191884,-1.599021,-1.6670063,-1.7450505,-1.7416006,-1.6522869,-1.5820059,-1.5026808,-1.4216321,-1.3402297,-1.2590725,-1.1914635,-1.1190087,-1.0399646,-0.96047121,-0.8866349,-0.80460898,-0.73387537,-0.6603603,-0.57335653,-0.49151409,-0.41545057,-0.33799354,-0.26446895,-0.18708144,-0.10105199,-0.017436012,0.0576788,0.12828653,0.22461721,0.30545721,0.39028306,0.48272557,0.54748619,0.64265519,0.73034458,0.79090327,0.87346922,0.97054916,1.0537459,1.1268159,1.1837581,1.2236598,1.2613879,1.2965396,1.3151597,1.3226165,1.3127802,1.3019907,1.2739435,1.2382108,1.2076891,1.1599841,1.1330348,1.1154721,1.0699788,1.0355538,1.0274885,1.05608,1.0673002,1.1151481,1.1781433,1.2374784,1.2899657,1.3475766,1.3920203,1.4481414,1.4797636,1.5345387,1.5774387,1.6280881,1.6592581,1.7060644,1.7406609,1.7731799,1.7999501,1.8087616,1.8393976,1.8403401,1.8349307,1.8215699,1.8034415,1.7757589,1.7503944,1.714248,1.6856263,1.6554158,1.6162238,1.574127,1.5285017,1.4864107,1.440627,1.3875397,1.3489503,1.3098497,1.2630002,1.2478695,1.1834155,1.13311,1.0773834,1.0204276,0.99181699,0.95223525,0.87934944,0.83734112,0.78192715,0.69260591,0.64087938,0.55775729,0.50298105,0.4240963,0.37500641,0.28362318,0.23276567,0.14255432,0.05164563,0.020188615,-0.039562407,-0.10149558,-0.1648156,-0.21095175,-0.24981294,-0.18680523,-0.12999641,-0.046354008,0.023455039,0.08093885,0.15035439,0.23355099,0.29012677,0.37639511,0.44798002,0.51918604,0.55434876,0.58036358,0.60677167,0.62714788,0.62456404,0.62621737,0.58189205,0.52288686,0.47538353,0.41185484,0.35401017,0.28861587,0.24261832,0.17694022,0.12238572,0.059110036,0.016281203,0.0027693665,-0.056444797,-0.099259741,-0.16177756,-0.18527651,-0.20076573,-0.24857941,-0.29684111,-0.34967104,-0.39331877,-0.44625863,-0.48201431,-0.51940284,-0.56512442,-0.60957206,-0.64567282,-0.68558772,-0.7343853,-0.77659072,-0.81940125,-0.85378268,-0.90372915,-0.9413166,-0.97654643,-1.0091259,-1.0496422,-1.0847994,-1.121051,-1.1722947,-1.1628043,-1.1637775,-1.2142656,-1.1561849,-1.0940484,-1.0360683,-0.96826909,-0.89178186,-0.81811969,-0.7412346,-0.67165842,-0.61862129,-0.56682008,-0.51545674,-0.47253975,-0.44374391,-0.46881666,-0.45133353,-0.44065364,-0.43111263,-0.42453605,-0.43768014,-0.43122871,-0.40202632,-0.43308985,-0.41669724,-0.41460609,-0.41091059,-0.40520919,-0.41021057,-0.41127653,-0.40752895,-0.40487451,-0.40278575,-0.40042663,-0.38376626,-0.39521177,-0.3902407,-0.36802875,-0.36191201,-0.36097134,-0.34852459,-0.34596746,-0.33330059,-0.31661558,-0.3010517,-0.28410196,-0.27032054,-0.25034662,-0.22907693,-0.20420193,-0.17459453,-0.1470517,-0.13466511,-0.10679058,-0.077586736,-0.066252934,-0.04243444,-0.015096997,0.014720712,0.047385187,0.083499805,0.11924963,0.1479701,0.17153265,0.19622207,0.20227542,0.20373137,0.21463768,0.24901519,0.26174732,0.30817302,0.39820513,0.4308444,0.49606622,0.58230712,0.65960736,0.73580318,0.80274,0.86589681,0.9147636,0.96398279,1.0148033,1.0647593,1.0896446,1.0737777,1.0964372,1.1369712,1.1759551,1.2275372,1.2720068,1.3184702,1.3720785,1.4202671,1.4771286,1.5037049,1.5685808,1.614651,1.663056,1.7101791,1.7554116,1.792474,1.7515438,1.7089116,1.6548057,1.6064694,1.5559356,1.5036366,1.4525591,1.402195,1.3494753,1.2932642,1.2328169,1.1845478,1.125971,1.0631036,0.97077483,0.867693,0.82167552,0.77652435,0.73016069,0.68321319,0.65241617,0.63000582,0.5819439,0.5232765,0.45398471,0.35782221,0.32147302,0.28771538,0.2524812,0.24938119,0.24513531,0.24152834,0.23560314,0.22191656,0.19663282,0.17359907,0.14289131,0.10745898,0.086750526,0.072191625,0.050539456,0.02458456,0.0037593368,-0.025555981,-0.044082642,-0.066874048,-0.097992102,-0.12680734,-0.15874083,-0.19862778,-0.21856015,-0.25170363,-0.27889813,-0.30858476,-0.34419502,-0.37219761,-0.39889196,-0.42303562,-0.45066722,-0.48739437,-0.51306935,-0.54720984,-0.5633139,-0.60952186,-0.6325493,-0.6459712,-0.68186173,-0.70812195,-0.75601764,-0.79406027,-0.84744754,-0.90309276,-0.96609717,-1.0537386,-1.1264731,-1.207236,-1.27955,-1.3755796,-1.4377334,-1.5306118,-1.6142368,-1.6942782,-1.7706305,-1.8500712,-1.9141876,-1.987134,-1.9964626,-1.9991408,-1.9887058,-1.9701396,-1.9649918,-1.939448,-1.9163642,-1.8939716,-1.8513363,-1.8235179,-1.7967944,-1.7612468,-1.7192419,-1.6919556,-1.6469912,-1.6056392,-1.5617241,-1.5268626,-1.4824679,-1.4405557,-1.410905,-1.3682726,-1.3179645,-1.2807234,-1.2406406,-1.1977145,-1.1549757,-1.1055123,-1.0575072,-1.0158446,-0.97749342,-0.929379,-0.88354835,-0.8315289,-0.7889467,-0.75482211,-0.69999,-0.6482173,-0.60586751,-0.5729504,-0.52497246,-0.48561985:2
1.4030901,1.3589598,1.2785951,1.2412919,1.186793,1.1325525,1.0643241,0.9786988,0.86243956,0.69313419,0.59286694,0.56014401,0.58820254,0.5175003,0.43403757,0.30413004,0.2172686,0.12112516,0.043867257,-0.072001087,-0.16909325,-0.27283341,-0.35212654,-0.38222271,-0.41384888,-0.32956453,-0.27088004,-0.2398531,-0.14610621,-0.12180302,-0.21294534,-0.29233348,-0.4127251,-0.54162357,-0.67030948,-0.80311324,-0.9183825,-1.0214511,-1.1184024,-1.2260994,-1.3425965,-1.3843679,-1.503244,-1.5860754,-1.6994029,-1.8098457,-1.8853768,-1.9625194,-1.9655868,-2.0611455,-2.0959842,-2.0614292,-1.9275208,-1.8531607,-1.7969193,-1.6853624,-1.5745955,-1.4613916,-1.4636191,-1.403708,-1.3255736,-1.2252303,-1.2249331,-1.1473466,-1.1395794,-1.0499258,-1.0003059,-0.94190976,-0.84970223,-0.77335037,-0.67273853,-0.6031893,-0.52619725,-0.43684776,-0.30997417,-0.22870064,-0.14508082,-0.096393224,-0.022352595,0.077203333,0.20124325,0.2107127,0.24663085,0.38206821,0.38411534,0.4455004,0.5659024,0.65739012,0.73851742,0.81748436,0.8277272,0.95607965,1.0976504,1.2185118,1.2361824,1.206582,1.170836,1.1224061,1.0824632,1.0283539,0.97098052,0.91552673,0.8769616,0.85628085,0.80840362,0.75975834,0.69789732,0.62507364,0.56926504,0.48877696,0.4381931,0.38500482,0.36116513,0.37831948,0.3941208,0.47196228,0.57039418,0.68007329,0.76476471,0.83999715,0.91770119,1.0386084,1.0524229,0.99499747,0.92496083,0.85745496,0.79224496,0.72855758,0.66530815,0.59517401,0.54827854,0.47948631,0.41364414,0.31912743,0.21852023,0.067002426,0.026677321,-0.06919746,-0.14815046,-0.25251248,-0.27253266,-0.32814608,-0.21925649,-0.35781675,-0.40505022,-0.39373718,-0.44811996,-0.42327964,-0.3006974,-0.20333164,-0.076997246,-0.031091315,0.071331711,0.19427843,0.32703928,0.4356675,0.5679091,0.68538823,0.78340861,0.88667973,0.92921061,0.89444902,0.87271553,0.81771397,0.73235175,0.69838856,0.67444898,0.5971377,0.51064236,0.4405631,0.38139791,0.35117686,0.25715694,0.20425398,0.13289703,0.099194967,0.066546404,0.043054765,0.013290964,-0.013789876,-0.10212727,-0.17565767,-0.24329696,-0.30094778,-0.39385168,-0.49264362,-0.48885873,-0.52456539,-0.5638428,-0.56926482,-0.6560443,-0.72358534,-0.82927269,-0.87787201,-0.86725962,-0.93938687,-1.022631,-1.0638988,-1.0447266,-0.94451533,-0.86985425,-0.84748176,-0.83789288,-0.7959255,-0.70253049,-0.60229964,-0.48825613,-0.4053343,-0.34422164,-0.22564048,-0.18834069,-0.097972783,-0.025041419,0.043948376,0.13454381,0.17056013,0.20609294,0.28834966,0.27192957,0.23432561,0.22391875,0.1988642,0.20681891,0.30697571,0.40866954,0.54029487,0.65860299,0.73702161,0.80995649,0.82710337,0.86069372,0.89275289,1.0007552,1.108372,1.2157555,1.3254975,1.4190957,1.4496395,1.5368921,1.596315,1.5944793,1.4593979,1.33567,1.1961591,1.065397,0.96199721,0.82510119,0.71476732,0.57485373,0.43640562,0.30271242,0.18459633,0.050052663,-0.074180119,-0.20048547,-0.33041125,-0.45938507,-0.59487125,-0.71597161,-0.73102779,-0.64487652,-0.59335346,-0.47318504,-0.33629167,-0.21560491,-0.087466041,0.038473882,0.17828887,0.30263533,0.30445532,0.37624939,0.43740341,0.50721819,0.49875227,0.57812169,0.58039903,0.61740541,0.68897429,0.7422052,0.76513315,0.86701052,0.88292911,0.98353066,1.0669878,1.1436835,1.189161,1.0790037,0.97393123,0.86793775,0.7686027,0.67530624,0.60203561,0.51643018,0.45398131,0.46455765,0.51088603,0.56878073,0.62659144,0.68791931,0.77252778,0.85544665,0.94853421,1.0370972,1.1003247,1.1382765,1.1023537,1.0908194,1.1256458,1.1932568,1.255484,1.3295815,1.37041,1.4283752,1.4923245,1.5573255,1.6414497,1.7131226,1.7970761,1.7664034,1.6514213,1.5027606,1.3325577,1.191461,1.0514785,0.93321062,0.82987957,0.70370896,0.57091446,0.4325194,0.31243041,0.19451957,0.087046524,-0.0070389557,-0.030536058,-0.07583726,-0.091038622,-0.10293244,-0.15015021,-0.24740285,-0.39438419,-0.53341123,-0.63150882,-0.66455531,-0.7956679,-0.90705576,-0.98697676,-1.0637228,-1.1493839,-1.2548064,-1.3645057,-1.4537085,-1.5055009,-1.5778934,-1.653765,-1.7441435,-1.807387,-1.8695762,-1.9826199,-2.0861721,-2.2094043,-2.2795576,-2.3489104,-2.4847646,-2.6193808,-2.7714691,-2.7788171,-2.8883595,-2.831754,-2.7331359,-2.6295685,-2.5183956,-2.411031,-2.2979682,-2.1776655,-2.0636368,-1.9446732,-1.8181935,-1.6916848,-1.5702313,-1.443899,-1.3317346,-1.1987547,-1.0776076,-0.93438799,-0.79951614,-0.67439945,-0.53863196,-0.38895686,-0.25400486,-0.10453181,-0.042739967,-0.10725441,-0.1319149,-0.18148006,-0.19438874,-0.17926756,-0.24189019,-0.2538988,-0.2048269,-0.25120533,-0.25658189,-0.20243989,-0.11243606,0.0010811611,0.07626719,0.16143776,0.26084892,0.36581532,0.31101975,0.40390658,0.50599606,0.55757125,0.61771643,0.68763538,0.60603463,0.69395744,0.78108638,0.85350825,0.94592791,0.98762589,1.0565128,1.077257,1.1483106,1.2449906,1.2458632,1.3395705,1.419828:5
0.84072829,0.76532028,0.67323992,0.57945614,0.49934563,0.42082145,0.34134879,0.26430569,0.17786459,0.09850985,0.024025454,-0.052174194,-0.13263311,-0.2071907,-0.28131872,-0.35774624,-0.44196556,-0.51933296,-0.59668673,-0.67418127,-0.7495561,-0.82426329,-0.89925637,-0.95482911,-0.8952994,-0.80957705,-0.7661887,-0.69122747,-0.59862557,-0.57912671,-0.51250563,-0.41749377,-0.37313133,-0.29693214,-0.26043067,-0.16898334,-0.15817779,-0.075736211,0.010201591,0.086679255,0.070550755,0.15068739,0.21124493,0.26912355,0.24043126,0.21073938,0.16639065,0.16345856,0.1210598,0.069158358,0.11185029,0.18873979,0.26481478,0.28469361,0.35080256,0.43141948,0.4630901,0.50680171,0.56874815,0.63062339,0.66975855,0.63976852,0.65053387,0.60831503,0.65520771,0.73257162,0.80161004,0.80043436,0.84745996,0.92379239,0.95365741,1.0077546,1.0603214,1.0379348,1.0035763,1.0756941,1.1321489,1.1646639,1.2209358,1.2963183,1.2860557,1.3017904,1.347751,1.4240781,1.424101,1.4862026,1.5645251,1.5615731,1.6265158,1.7047365,1.7485761,1.8305367,1.8429517,1.7691558,1.6982213,1.619333,1.5418448,1.4635326,1.3964884,1.3259044,1.2530028,1.1783173,1.1050667,1.0564978,0.98019469,0.90567094,0.82766301,0.77889873,0.70178623,0.61472884,0.5540457,0.50562474,0.42797019,0.34164017,0.27596921,0.18912112,0.12533168,0.066618749,-0.017116099,-0.088130856,-0.12732252,-0.20870166,-0.28755586,-0.35689491,-0.42758442,-0.45600781,-0.50020213,-0.57360013,-0.65289585,-0.71606237,-0.80600356,-0.86861852,-0.96298051,-1.0262272,-1.0945233,-1.1805198,-1.2481845,-1.301518,-1.3605785,-1.4267083,-1.4949133,-1.5551303,-1.6017714,-1.6220643,-1.6274165,-1.6271389,-1.6103626,-1.5776435,-1.602363,-1.6621743,-1.7579991,-1.8488536,-1.9351313,-2.0169864,-2.0954878,-2.1702702,-2.2268467,-2.2511289,-2.2338429,-2.1838436,-2.1342072,-2.0647966,-2.0018752,-1.9300077,-1.8850452,-1.8186785,-1.7426222,-1.6635981,-1.5861777,-1.5045546,-1.4472932,-1.3716302,-1.2941263,-1.2172726,-1.1805238,-1.1032214,-1.0254452,-0.96569462,-0.8925438,-0.8115316,-0.773942,-0.70888252,-0.6289623,-0.55368178,-0.50969693,-0.43043696,-0.37471376,-0.30738871,-0.22840113,-0.19497349,-0.14280503,-0.057993851,-0.011037233,0.064317842,0.11086246,0.20700794,0.21127095,0.24924086,0.33664753,0.42080345,0.46764116,0.54679802,0.58845371,0.6158537,0.54822471,0.50710421,0.43414984,0.42244442,0.35377126,0.29003375,0.21845829,0.23096757,0.1793306,0.11062019,0.11051702,0.20295256,0.28155482,0.32057024,0.40484652,0.47817644,0.55099428,0.61618984,0.67480157,0.6856358,0.67732801,0.63410201,0.68852922,0.78277694,0.84696793,0.91598728,0.97477694,1.002132,1.0022174,1.0483689,1.1215736,1.1792716,1.2337431,1.2744981,1.2785978,1.3535319,1.4159222,1.4877309,1.5558836,1.5555099,1.6317714,1.7022993,1.7674256,1.823825,1.9040094,1.9669615,2.0428644,2.1094613,2.1779853,2.2425989,2.1600724,2.0621706,1.9754057,1.9025044,1.8419254,1.7963405,1.7032106,1.6400646,1.5660697,1.5716508,1.4977855,1.4267155,1.3804393,1.2907195,1.2811325,1.2655869,1.1869436,1.1261006,1.0517048,1.0320401,0.95581172,0.88636958,0.83451894,0.82189286,0.81007506,0.72065445,0.67556087,0.60348678,0.53001491,0.51362891,0.45360721,0.37577602,0.32539234,0.27140245,0.27569643,0.25203642,0.20099001,0.12749497,0.077038445,0.0016711005,-0.060143127,-0.12072393,-0.19305713,-0.26881963,-0.32961111,-0.3887607,-0.46182284,-0.53720532,-0.59826285,-0.67271377,-0.71831819,-0.64862323,-0.58715093,-0.57733767,-0.53127491,-0.48108545,-0.43455202,-0.45119757,-0.3987169,-0.36635912,-0.31862082,-0.28235072,-0.20300181,-0.12864119,-0.091104367,-0.01679012,0.066775798,0.14305675,0.21184369,0.2900651,0.3531603,0.2864767,0.21816498,0.15613163,0.11735511,0.053098578,0.0040568704,-0.0034001517,-0.065494983,-0.092260049,-0.16263665,-0.19149627,-0.16569897,-0.21490168,-0.25825314,-0.29894055,-0.27859219,-0.34455182,-0.40385521,-0.40273579,-0.3608247,-0.4130352,-0.44894686,-0.47310216,-0.49418636,-0.5660463,-0.58941912,-0.59943233,-0.66583254,-0.69270979,-0.73540826,-0.68818811,-0.65595653,-0.68361256,-0.73168438,-0.71846592,-0.7899299,-0.82714665,-0.82098359,-0.88685653,-0.93298173,-1.0065929,-0.94440181,-0.91534106,-0.87844933,-0.90764016,-0.92755541,-0.96989851,-0.94905002,-1.0299619,-1.050306,-1.0657728,-1.1317406,-1.1848778,-1.2243625,-1.2209307,-1.2812343,-1.3039845,-1.3686134,-1.3628725,-1.4047224,-1.4657193,-1.5240227,-1.5752557,-1.6173347,-1.6606139,-1.6036842,-1.5368821,-1.4718415,-1.3879983,-1.3133114,-1.226911,-1.1577733,-1.0662757,-0.99002748,-0.91125776,-0.82799042,-0.75267869,-0.71062817,-0.63340779,-0.54616809,-0.46753338,-0.38867186,-0.31124121,-0.24229603,-0.15385263,-0.076728855,0.0011809726,0.080196545,0.15863035,0.22540426,0.25589297,0.33564921,0.41532777,0.48694641,0.56779049,0.64725775,0.72045593,0.74884819,0.81563297,0.85669088,0.78533135,0.81709077:6
1.0741911,1.0401882,1.0071702,0.94882593,0.87168565,0.83088628,0.72600491,0.63634651,0.55268028,0.44820667,0.36775216,0.27804006,0.16990403,0.072945239,-0.068020068,-0.17119163,-0.2745173,-0.41422989,-0.51968834,-0.66081847,-0.76075008,-0.89827135,-1.0422183,-1.1819294,-1.2843715,-1.4065281,-1.5029254,-1.6328874,-1.7483396,-1.8229549,-1.8105277,-1.7157978,-1.5877104,-1.4998007,-1.4000352,-1.3505411,-1.323908,-1.2423583,-1.1994992,-1.1313578,-1.0578041,-0.99118956,-0.97350672,-0.89286137,-0.78104078,-0.71679831,-0.64334165,-0.62976589,-0.54713156,-0.41705193,-0.32955181,-0.29574237,-0.18794663,-0.092357269,0.0054684893,0.082329801,0.12136352,0.13365628,0.21108474,0.29340677,0.3248067,0.407659,0.50009189,0.58699859,0.67999902,0.776934,0.87032125,0.90046023,0.93947133,0.96888282,0.93360545,0.88343217,0.83337309,0.81570695,0.90835778,1.0123542,1.0875043,1.1588328,1.1971875,1.2513493,1.3047621,1.3480484,1.3822395,1.3999704,1.4092433,1.4209489,1.4308873,1.4075225,1.3526356,1.303654,1.2337747,1.1635663,1.100372,1.0293871,0.9550415,0.89253291,0.82564664,0.74578859,0.68084737,0.62920182,0.55581248,0.50058374,0.4450894,0.3803532,0.31744491,0.25197143,0.19875057,0.11412383,0.056666152,-0.029086799,-0.11194372,-0.17165626,-0.2756009,-0.3247111,-0.43384303,-0.5114935,-0.59836966,-0.7117029,-0.78906027,-0.90174447,-0.95568083,-0.84719308,-0.77353104,-0.70730471,-0.62426266,-0.48118489,-0.40228845,-0.29052341,-0.19981823,-0.095164519,-0.0011622166,0.079920185,0.18358987,0.26427953,0.33738518,0.42413409,0.50040997,0.55999744,0.61230087,0.6386832,0.65820772,0.64170046,0.62919623,0.60348762,0.58652607,0.55732485,0.52141738,0.45886961,0.42316171,0.37869528,0.31980069,0.23735206,0.27743877,0.22447934,0.16254316,0.079619132,0.04484899,-0.031494365,-0.07932135,-0.13719954,-0.21107333,-0.32919247,-0.41450082,-0.29829315,-0.3605681,-0.46607531,-0.57654959,-0.63910007,-0.63693371,-0.71848492,-0.80172684,-0.86088103,-0.96081417,-1.0628218,-1.1752955,-1.2326378,-1.147135,-1.2166036,-1.2108015,-1.1687787,-1.0458658,-0.93683092,-0.81309557,-0.72254123,-0.63886519,-0.57635981,-0.51931744,-0.46410698,-0.45249384,-0.45717338,-0.45876679,-0.49316002,-0.51955746,-0.56383898,-0.61365864,-0.65785972,-0.69880317,-0.73233159,-0.7641285,-0.81039195,-0.8549032,-0.90311791,-0.95446549,-1.004234,-1.0637557,-1.0982235,-1.1369021,-1.0491572,-0.96928565,-0.88548997,-0.76798764,-0.66651051,-0.51931078,-0.37183766,-0.25791934,-0.14296698,-0.056900226,0.054334197,0.097065222,0.13189422,0.2245536,0.30357553,0.36549098,0.45251052,0.51599794,0.55665876,0.54728733,0.60355091,0.61111072,0.65727459,0.71133252,0.68159938,0.73946969,0.75760159,0.77705095,0.78660102,0.80551509,0.8122145,0.80334393,0.7381997,0.6582336,0.73072191,0.75595546,0.81349448,0.85118002,0.94662946,1.0504603,1.1534197,1.2517379,1.3503047,1.4489578,1.5540594,1.5911081,1.6932598,1.7691266,1.8693297,1.9581694,2.0747202,2.192616,2.2898561,2.392202,2.4299512,2.5183096,2.5141107,2.524359,2.5476667,2.5695323,2.4856987,2.3984785,2.2706177,2.158853,2.0689973,1.9530863,1.8472225,1.7447318,1.6486378,1.5390208,1.4326978,1.3244593,1.2346426,1.1166036,1.0140067,0.94677808,0.89215442,0.86495081,0.86675004,0.84950181,0.84322043,0.82202088,0.79392274,0.73620277,0.68217427,0.63878571,0.58943573,0.53551023,0.4880028,0.42849815,0.37569114,0.32570677,0.28309241,0.22958944,0.20409887,0.17301125,0.12235826,0.057035159,-0.016350873,-0.10414873,-0.18997701,-0.27130207,-0.3718246,-0.46948689,-0.55550703,-0.64928636,-0.74575199,-0.76237132,-0.81676039,-0.87902012,-0.95678382,-0.99261527,-0.95219842,-0.96109317,-0.9109152,-0.86345328,-0.82784778,-0.78577366,-0.73974164,-0.6958504,-0.66126134,-0.62862787,-0.5946211,-0.56389913,-0.52978791,-0.50356201,-0.45883801,-0.42455883,-0.3926259,-0.35622081,-0.31397597,-0.26391081,-0.23638321,-0.20494481,-0.15224755,-0.10076656,-0.078391487,-0.050719289,-0.0062281703,0.052558126,0.082762552,0.098237626,0.10873231,0.11599123,0.10132979,0.10266314,0.066955638,0.033199768,0.04146319,-0.023600474,-0.070401679,-0.17401726,-0.28325914,-0.40667467,-0.51359705,-0.59923591,-0.70406486,-0.83305981,-0.93542493,-1.020454,-1.1322181,-1.2294727,-1.3392056,-1.4466285,-1.5463868,-1.6518407,-1.7541597,-1.8611637,-1.9624287,-2.0544381,-2.1152201,-2.2349263,-2.321125,-2.4295435,-2.4521119,-2.3554304,-2.2476197,-2.1402354,-2.0300301,-1.9427632,-1.8341968,-1.7153046,-1.6141841,-1.5266942,-1.4522232,-1.3376259,-1.218075,-1.1262286,-1.0080311,-0.92396797,-0.82975889,-0.74237826,-0.65701305,-0.56082682,-0.46896373,-0.37469888,-0.28620184,-0.2218913,-0.13760965,-0.071358664,0.013611261,0.090195734,0.16963488,0.24157307,0.28915696,0.37746275,0.37775454,0.42080657,0.46771806,0.54962509,0.61611617,0.70068841,0.75875793,0.80196326,0.79433328,0.86315495,0.94684076,1.0007768,1.0348223,1.0900546:2
2.4764389,2.3731064,2.225817,2.181011,2.0364944,1.9842329,1.8663619,1.774572,1.6808009,1.5650912,1.4947821,1.3776901,1.2813536,1.1892619,1.073892,0.99372224,0.87542327,0.80243938,0.78515371,0.69136959,0.57626736,0.52117322,0.39475192,0.32773225,0.22401637,0.090083716,0.0018541436,-0.095083001,-0.18782013,-0.27105413,-0.31040211,-0.21605107,-0.13356086,-0.15626974,-0.24602423,-0.35031174,-0.47257134,-0.53717112,-0.61747317,-0.72047416,-0.80285111,-0.81302487,-0.82058338,-0.92773385,-1.003282,-1.0966607,-1.1936067,-1.2397043,-1.3252824,-1.4153648,-1.4609904,-1.4514325,-1.4190841,-1.3897248,-1.3226974,-1.2064921,-1.0699359,-0.9555876,-0.85766058,-0.85483382,-0.88920355,-0.94746615,-1.0097808,-1.0791235,-1.139151,-1.1989799,-1.1989799,-1.198333,-1.2173943,-1.2991485,-1.3545008,-1.3924508,-1.3484882,-1.3353777,-1.3552855,-1.3896728,-1.4450784,-1.476679,-1.5299568,-1.5741172,-1.593397,-1.6223747,-1.6536027,-1.6025025,-1.4718737,-1.4241228,-1.3300092,-1.2321631,-1.107548,-0.97638647,-0.83747407,-0.78216165,-0.66876987,-0.62018338,-0.51290124,-0.39389116,-0.26386862,-0.17469912,-0.066110268,0.052697597,0.16759492,0.28851016,0.41523576,0.45952996,0.44458509,0.3977384,0.38165312,0.3736896,0.30354952,0.26896572,0.27441899,0.28454146,0.26780558,0.21562831,0.18496743,0.1402278,0.18118995,0.26511062,0.3442887,0.34498519,0.34264556,0.32508692,0.30367351,0.28735893,0.27023669,0.26983597,0.19416831,0.16908331,0.19363371,0.28160123,0.39142924,0.42463202,0.44859133,0.44388363,0.39151913,0.37715394,0.3620574,0.36950623,0.3270102,0.30095253,0.38879522,0.42452328,0.39635259,0.33536603,0.28865683,0.26489746,0.2567868,0.2491876,0.20269792,0.15951724,0.14878961,0.17160384,0.24258517,0.37758793,0.48106573,0.56701643,0.63249689,0.70383621,0.80431361,0.85892798,0.88983772,0.87745079,0.84537302,0.806284,0.80740362,0.81820124,0.83093504,0.82438321,0.89827423,0.93482955,0.98698642,0.94522711,0.8997447,0.85555295,0.81808185,0.80783263,0.79173086,0.76333037,0.77365455,0.82840415,0.88286149,0.87596919,0.85006155,0.78501259,0.74966448,0.70739,0.65305005,0.63371688,0.58005054,0.53239914,0.49862687,0.44713608,0.37020419,0.3261441,0.23365595,0.20159229,0.15623163,0.099183081,0.051418773,0.0088462366,-0.039794812,-0.14040336,-0.22606857,-0.18877213,-0.14140217,-0.046513405,0.02544276,0.10482552,0.18118746,0.2360493,0.32338441,0.40889851,0.48925189,0.54620617,0.55045602,0.61848153,0.67792514,0.72655896,0.75960098,0.80405646,0.81332144,0.8159969,0.75813321,0.63174179,0.60597542,0.62152283,0.68364236,0.70724634,0.77099592,0.79185923,0.83979472,0.87523266,0.93579715,0.9804497,0.97615771,0.95111943,0.82628446,0.82146926,0.84867285,0.87725276,0.90848873,0.93303182,0.87437808,0.87086474,0.90465255,0.92414572,0.94310371,0.94637425,0.90021672,0.84839592,0.71319373,0.58760742,0.47204071,0.38381652,0.31959487,0.31108794,0.30719043,0.32626578,0.35995628,0.37164658,0.40396961,0.42209992,0.4719278,0.50560006,0.5199449,0.4507486,0.41113335,0.41113335,0.52129182,0.54419292,0.53821998,0.56143708,0.59087299,0.61830123,0.63701208,0.64506646,0.58615981,0.49769036,0.40341879,0.39136405,0.42212221,0.45186593,0.51656551,0.56112398,0.54025888,0.48712538,0.42744663,0.42744663,0.474172,0.55825236,0.56165797,0.559515,0.60604467,0.66001689,0.69090631,0.71521635,0.71980939,0.69028963,0.55375705,0.48509177,0.37947246,0.30812806,0.21815593,0.15047308,0.06863575,-0.019524336,-0.058044965,-0.14056802,-0.21926519,-0.29160267,-0.38710886,-0.46763507,-0.54896583,-0.56763936,-0.55707369,-0.63461152,-0.6736742,-0.74126039,-0.8692403,-0.98989963,-1.0655265,-1.1356503,-1.2378739,-1.3360029,-1.4182512,-1.5219384,-1.5985877,-1.7289635,-1.8042857,-1.9154796,-2.0054981,-2.0244832,-2.0699792,-2.0803765,-2.0785793,-2.0584468,-2.0565925,-2.0413459,-1.9965819,-1.9339603,-1.87594,-1.8556315,-1.7822656,-1.7040552,-1.6378703,-1.6278649,-1.6451804,-1.7254741,-1.7768323,-1.7388664,-1.7021993,-1.6078991,-1.5030911,-1.4493529,-1.4184784,-1.4386862,-1.3964053,-1.3601411,-1.339131,-1.3314321,-1.2430889,-1.19697,-1.1222161,-1.0724027,-1.0357319,-1.0305042,-1.1264625,-1.1975342,-1.3132647,-1.3739692,-1.4647473,-1.5165552,-1.5133774,-1.4755695,-1.3854467,-1.2994746,-1.2257995,-1.1244644,-1.055199,-0.94270895,-0.86730813,-0.83086417,-0.74306034,-0.69079523,-0.60211746,-0.52454256,-0.40995631,-0.34845206,-0.27123011,-0.18477417,-0.12879386,-0.13968692,-0.18681263,-0.21872066,-0.15449486,-0.072858354,0.0065157735,0.12706718,0.17985718,0.3077078,0.38355468,0.4457218,0.51941066,0.62135682,0.7156034,0.83303706,0.84480755,0.86539086,0.90679536,1.0163624,1.0998016,1.1842545,1.2890494,1.357272,1.4838502,1.5860815,1.692655,1.7265764,1.8222998,1.8969714,1.9975515,2.0728066,2.1478478,2.2575892,2.3136457,2.3916838,2.4713233:3
0.3949036,0.33887042,0.28501779,0.24756413,0.20536259,0.17466836,0.15653808,0.14642212,0.18238318,0.19348738,0.17320144,0.14285292,0.11931784,0.087586038,0.057750151,0.039234594,0.017833987,0.0046604835,0.0030728265,0.004733798,0.018174915,0.034867691,0.068879281,0.11415753,0.14138144,0.17856101,0.2050037,0.22617627,0.25131883,0.26621815,0.2805531,0.30474094,0.2990631,0.28533712,0.27169551,0.27824518,0.34648976,0.40393372,0.32220251,0.23198215,0.18672032,0.27631479,0.36572032,0.45912178,0.54623268,0.63831127,0.72996605,0.8109277,0.89693196,0.97304927,1.063981,1.1585232,1.2559436,1.3392328,1.4264729,1.515845,1.604388,1.6887115,1.7820455,1.8642606,1.9533101,2.0165666,2.1057711,2.1852176,2.2805793,2.3669946,2.4126214,2.3485229,2.2622198,2.1692507,2.0785255,1.9901779,1.9003605,1.8131803,1.7212103,1.634552,1.5483832,1.4602803,1.3665527,1.2872843,1.1972538,1.1064541,1.0231712,0.93473394,0.84444527,0.75571757,0.67078065,0.58363669,0.49719887,0.42594814,0.36151351,0.33500251,0.31754292,0.29211,0.25805646,0.20876486,0.15606728,0.10411349,0.057092706,0.014802024,-0.014720003,-0.032754712,-0.058251001,-0.090012611,-0.12158835,-0.15347638,-0.18165787,-0.20882016,-0.22864892,-0.24266146,-0.23959426,-0.21393146,-0.18782546,-0.15742193,-0.14597018,-0.20996522,-0.23654299,-0.22795227,-0.18365538,-0.13506772,-0.070495933,-0.011860839,0.038458633,-0.032567793,-0.10320729,-0.1763285,-0.24846048,-0.31912969,-0.39972339,-0.47847538,-0.5560252,-0.62352668,-0.70037616,-0.77910463,-0.85469769,-0.93742073,-1.0271342,-1.1296279,-1.202804,-1.2637809,-1.3316967,-1.3830946,-1.4190183,-1.4399578,-1.4467616,-1.4512299,-1.4483569,-1.4220159,-1.3753184,-1.3338035,-1.291946,-1.2406841,-1.1803568,-1.0987895,-1.0287335,-0.96124939,-0.89669457,-0.84613477,-0.77224025,-0.69463657,-0.59180543,-0.48557811,-0.41297372,-0.34603566,-0.43105459,-0.49692927,-0.48486427,-0.42415844,-0.30953203,-0.19580675,-0.081924294,0.018116251,0.10771097,0.20844645,0.15643936,0.073531237,-0.012249825,-0.092088648,-0.17459912,-0.19586979,-0.28318428,-0.37358885,-0.46921186,-0.57488783,-0.66113822,-0.74535154,-0.8331301,-0.93216153,-1.0236525,-1.1249342,-1.2106588,-1.2990515,-1.3828393,-1.4661416,-1.5482861,-1.6241939,-1.6880209,-1.7357837,-1.7752756,-1.7686989,-1.755708,-1.7140137,-1.6529955,-1.590708,-1.5206517,-1.4407084,-1.3607267,-1.2802757,-1.1962034,-1.1043342,-1.0277879,-0.94013618,-0.85412163,-0.77966813,-0.69861114,-0.62175516,-0.52496577,-0.44264318,-0.35700236,-0.27419542,-0.18944352,-0.1049022,-0.019164532,0.061884821,0.14431262,0.22847952,0.31047422,0.39627033,0.48802145,0.57643133,0.65454707,0.58229369,0.63572556,0.6151238,0.62289428,0.70805464,0.78861814,0.87024776,0.9593251,1.0379001,1.1252708,1.2080271,1.2926795,1.2280557,1.1360835,1.0495155,0.96255701,0.86872248,0.78304058,0.69128988,0.62331411,0.56298207,0.52131072,0.49418198,0.49725075,0.52944453,0.57084149,0.64637929,0.74983645,0.83623728,0.91990463,1.0203082,1.1015375,1.197003,1.2904622,1.3830267,1.4763868,1.5684886,1.6529227,1.7272012,1.7132705,1.6627065,1.7551965,1.8503429,1.9482496,2.0351321,2.0811045,1.9879972,1.9223256,1.8408707,1.7593158,1.6701148,1.5917168,1.516086,1.5006483,1.5337863,1.6093748,1.6310501,1.5529934,1.4620587,1.3800981,1.2951404,1.2156045,1.1377972,1.0597386,0.97705826,0.89361192,0.81566007,0.72679028,0.64319386,0.56383623,0.47333892,0.3978991,0.31734548,0.25300649,0.18915727,0.14210384,0.10469792,0.1097261,0.13205147,0.15522577,0.18541112,0.22743449,0.26291257,0.30997897,0.34989452,0.40533155,0.47539235,0.52294083,0.46281912,0.35510465,0.28923795,0.21833298,0.11978989,0.017596503,-0.055762324,-0.11835592,-0.19611042,-0.27338781,-0.37205598,-0.49349081,-0.58200776,-0.69069685,-0.78872347,-0.88729883,-0.98456014,-1.0824305,-1.1799589,-1.2981589,-1.4167147,-1.5127199,-1.6069091,-1.6870443,-1.7424123,-1.7803692,-1.8047164,-1.8160474,-1.7931256,-1.7288119,-1.6620972,-1.5757819,-1.4987228,-1.4112022,-1.322699,-1.2410896,-1.1567935,-1.0701778,-0.98704582,-0.90011493,-0.8213543,-0.72968225,-0.64104238,-0.55527467,-0.47043893,-0.38534194,-0.37846611,-0.36339335,-0.27891889,-0.19977131,-0.10775275,-0.020211744,0.059667626,0.017424639,-0.063089201,-0.12282101,-0.069574512,-0.13256368,-0.21087176,-0.29034565,-0.37671659,-0.45647298,-0.5322708,-0.60593922,-0.68012517,-0.74467026,-0.82086069,-0.89334104,-0.95679208,-1.01949,-1.0786234,-1.1394835,-1.197277,-1.2437717,-1.2896434,-1.3318497,-1.3836696,-1.4035301,-1.4252363,-1.4354734,-1.4396036,-1.436922,-1.4330434,-1.4032974,-1.3626524,-1.3066936,-1.23593,-1.1621451,-1.069217,-0.98031122,-0.88346888,-0.79948324,-0.73519624,-0.65070446,-0.58437747,-0.49903376,-0.42498522,-0.34144082,-0.2560868,-0.25505856,-0.16217767,-0.06966728,4.6271969E-4,0.066528839,0.12322635,0.19063426,0.26419283,0.35719175:4
1.6220523,1.4512582,1.2774954,1.0854824,0.90419064,0.73051588,0.51896957,0.37335321,0.19455305,0.021012644,-0.22800833,-0.39886011,-0.63346508,-0.81993245,-1.0546072,-1.221775,-1.4626557,-1.6349614,-1.8684739,-2.0411363,-2.2175677,-2.4556297,-2.6368062,-2.8688132,-2.9571339,-2.8120499,-2.6666387,-2.4747684,-2.3070855,-2.1601157,-1.9921161,-1.8716228,-1.7233987,-1.5758418,-1.4670852,-1.3321865,-1.2264873,-1.1074824,-1.0194308,-1.0291135,-0.87415586,-0.7960408,-0.69978918,-0.63717093,-0.5750824,-0.43850908,-0.57252548,-0.4065691,-0.31739651,-0.35048013,-0.36313702,-0.40547956,-0.5659304,-0.70823792,-0.80163788,-0.81254558,-0.66811758,-0.57313862,-0.4745262,-0.3568981,-0.2080642,-0.1002939,-0.090981442,0.018441716,0.0082211986,0.080483279,0.036351254,0.031630531,0.074366783,0.057277076,0.17831052,0.21516178,0.32619274,0.47681101,0.55276451,0.64711035,0.65965083,0.55129528,0.38914287,0.20287596,0.039308552,0.00361958,-0.21351303,-0.3539644,-0.48924418,-0.49319854,-0.60545102,-0.70429734,-0.72210748,-0.83355742,-0.91468343,-0.88823856,-0.88727961,-0.73471307,-0.62943961,-0.62541842,-0.45234693,-0.42848235,-0.34376092,-0.2288784,-0.23563174,-0.19256021,-0.051729386,-0.055602647,-0.023732341,0.0051725602,0.11451181,0.1645752,0.073289331,0.14178877,0.20161732,0.20933917,0.18421753,0.22947153,0.2973019,0.3446836,0.41866684,0.44474717,0.56351634,0.65755136,0.77017821,0.90845248,0.89615333,1.0012635,1.105146,1.0347435,0.86184713,0.673158,0.50850168,0.40653933,0.32274246,0.14953551,-0.079943749,-0.19512453,-0.31884525,-0.35634816,-0.5523465,-0.72170577,-0.64239641,-0.74692757,-0.96164406,-0.84704749,-0.83290621,-0.81412416,-0.67902891,-0.5625438,-0.46873507,-0.36965748,-0.21629603,-0.13397514,-0.15170638,-0.041315501,0.061810118,-0.0031571145,0.13650448,0.24576144,0.38811045,0.44531143,0.56871793,0.67286294,0.80744872,0.90617648,1.005037,1.0849006,1.129348,1.0708102,1.0222328,1.100331,1.2849661,1.4115537,1.5526372,1.6656583,1.7923435,1.8499797,1.7245934,1.5057728,1.3317808,1.1759257,1.1201679,0.98114302,0.85456,0.71594003,0.57120134,0.41377464,0.34824925,0.19957298,0.11689787,0.011561276,-0.1439062,-0.24546309,-0.3750421,-0.49470792,-0.6221413,-0.76630216,-0.94699707,-1.1127839,-1.2857688,-1.1943903,-1.0163885,-1.0752452,-0.98546462,-0.81666967,-0.71774828,-0.55517876,-0.49139188,-0.41824009,-0.33957271,-0.29229222,-0.29318062,-0.13909759,-0.026208868,0.12632464,0.16436586,0.28275665,0.29577532,0.4693125,0.564374,0.69644208,0.79408309,0.76592999,0.63799403,0.49708124,0.34561758,0.25161673,0.23434673,0.092103862,-0.025949921,0.0027934555,-0.085949985,-0.18985137,-0.29164875,-0.40647161,-0.54984412,-0.55511713,-0.34259609,-0.2319672,-0.17247366,-0.075818425,0.011923072,0.21398527,0.30331107,0.40629738,0.56289087,0.65636847,0.75404724,0.80963933,0.93462492,1.0581391,1.1604423,1.3161247,1.4708734,1.6394209,1.7550708,1.8133162,1.719475,1.6037541,1.4994248,1.3579839,1.3239,1.1734001,1.0640969,0.98568169,0.94648051,1.0370106,0.92828797,0.82458015,0.75156289,0.66379872,0.58278211,0.53261866,0.47858687,0.53445186,0.49242937,0.34391427,0.23608879,0.11440569,-0.068801063,-0.17454557,-0.36604104,-0.4910032,-0.58931604,-0.70601253,-0.51811289,-0.38695947,-0.19134106,-0.034366257,0.12629701,0.30443037,0.45730251,0.61596297,0.77486569,0.94977278,1.1439072,1.2889689,1.3490363,1.5327201,1.7094609,1.8376556,2.0411989,2.2105088,2.3744977,2.4450763,2.3630348,2.21738,2.0504479,1.8923187,1.9190376,1.7930106,1.6386401,1.4738892,1.3282945,1.2652196,1.1584719,1.0123453,0.8662987,0.75160132,0.63123994,0.50678092,0.36138974,0.26821296,0.11750048,0.013483908,-0.10766063,-0.2330176,-0.35406255,-0.44918503,-0.60401517,-0.70717794,-0.68239131,-0.58029361,-0.44932489,-0.36870548,-0.34271011,-0.29197765,-0.10825157,0.027162795,-0.05783593,0.12035904,0.21687385,0.35692351,0.52347815,0.66865861,0.54144416,0.44740577,0.29169691,0.19765876,0.13827623,0.063109932,-0.0091930432,-0.012750904,-0.076881545,-0.10956667,-0.14961124,-0.1870417,-0.22357079,-0.26711352,-0.34378669,-0.40924317,-0.48185154,-0.49309471,-0.36646534,-0.19723748,-0.070208726,0.096774939,0.28945109,0.30773537,0.27635918,0.21895142,0.1823836,0.20688181,0.1263325,0.057660327,0.0052901375,0.014893382,0.0091779045,-0.086668838,-0.13951489,-0.2658245,-0.39098154,-0.43411207,-0.51389405,-0.66911183,-0.77871259,-0.87093531,-1.0086483,-1.0754435,-1.2144453,-1.284693,-1.4229568,-1.5676494,-1.7213175,-1.812026,-1.9362694,-1.9918868,-2.1697229,-2.1613049,-2.2553828,-2.3970152,-2.2718656,-2.3865858,-2.4223743,-2.2096411,-2.0069866,-1.8306108,-1.6108345,-1.4205995,-1.2410749,-1.0597768,-0.88754431,-0.70371183,-0.52249713,-0.34340612,-0.1063173,0.068220975,0.25129482,0.43154286,0.60568728,0.79177385,0.97397478,1.1572783,1.335186,1.5454494,1.5904376,1.6131107,1.7199657,1.6478079,1.7212117:1
2.9441257,2.9069073,2.7807871,2.61853,2.4613559,2.2972078,2.1326034,1.9785408,1.8299202,1.6816751,1.5154436,1.3416084,1.1986666,1.053347,0.88973818,0.77740782,0.63188075,0.47433644,0.37520288,0.28732984,0.12394714,-0.010081689,-0.069450071,-0.16541898,-0.22334382,-0.32150049,-0.4856532,-0.63577244,-0.78900753,-0.94414511,-1.1127328,-1.2765273,-1.4297137,-1.5791643,-1.743835,-1.8875643,-2.0503709,-2.2050965,-2.3541535,-2.5209781,-2.6620056,-2.4973643,-2.3348919,-2.1482555,-2.011998,-1.898331,-1.7884098,-1.6342376,-1.4642264,-1.3843245,-1.2785236,-1.1515813,-1.0359218,-0.99769317,-0.95411434,-0.92255341,-0.84664972,-0.82023598,-0.69649373,-0.58033768,-0.51729679,-0.46590392,-0.40067065,-0.40843293,-0.30442015,-0.28351453,-0.16660509,-0.12868148,-0.14568587,-0.031750076,0.033982933,0.10718069,0.1590767,0.23524946,0.24811093,0.071107927,-0.15016115,-0.22653265,-0.37477227,-0.54908536,-0.56793853,-0.66055421,-0.56925769,-0.47476596,-0.40617526,-0.33557648,-0.25343391,-0.1767461,-0.20289062,-0.16362511,-0.042050769,0.046469992,0.18132335,0.293262,0.24210989,0.360354,0.48492075,0.60023365,0.60219232,0.75380691,0.87390987,0.96886776,1.111699,1.1327169,0.97725919,0.81005392,0.67221901,0.50107997,0.34155945,0.1995986,0.12597291,-0.015947019,-0.17500629,-0.33831009,-0.49316734,-0.64584294,-0.80596203,-0.86023245,-0.99693949,-0.98489729,-1.0261563,-0.96919693,-0.91604328,-0.80233924,-0.7720846,-0.66377503,-0.51821496,-0.39849842,-0.31542939,-0.20174109,-0.13721646,-0.15904049,-0.15007038,-0.03492149,0.071488232,0.11439671,0.21684605,0.35186725,0.2642853,0.38426497,0.39449675,0.51033724,0.63755891,0.72855634,0.88411522,0.99074475,1.0937215,1.1461609,1.1172236,0.91027782,0.74699665,0.60952615,0.52482607,0.37450354,0.22585345,0.19186548,0.054105866,-0.067324501,-0.21657341,-0.36255965,-0.54082656,-0.69157117,-0.83484255,-0.97780769,-0.95373662,-0.84909542,-0.76939889,-0.70495681,-0.63690346,-0.50230798,-0.41162071,-0.28975294,-0.18729561,-0.16166394,-0.046554842,0.039809627,0.16898503,0.2833933,0.3774804,0.43863428,0.55358333,0.6701128,0.65597237,0.80022013,0.90547931,1.0443375,1.162954,1.3052864,1.4403366,1.5684425,1.6710207,1.5812114,1.4797994,1.3246394,1.2292657,1.0768237,0.94555324,0.9114601,0.70913726,0.51481243,0.45896955,0.4860645,0.32335974,0.1783665,0.061738185,-0.11167237,-0.26604954,-0.28781387,-0.27502188,-0.18761854,-0.052574168,0.045070336,0.13305014,0.28117777,0.22799776,0.35204998,0.51274021,0.66200199,0.79583084,0.85870323,1.0268644,1.0861228,1.2183976,1.3741261,1.4547596,1.3024266,1.1368137,1.0072033,0.85920911,0.78392816,0.68641183,0.54016984,0.41120388,0.45234863,0.31407643,0.17569438,0.035435205,-0.061262291,-0.10419007,-0.24229345,-0.36160092,-0.37485845,-0.45543927,-0.51092497,-0.4349649,-0.38971579,-0.19890645,-0.043210604,0.098040489,0.26920314,0.40697943,0.51264671,0.62963279,0.79551996,1.0010658,1.1394289,1.2646456,1.414138,1.4321308,1.3373884,1.2259033,1.1089059,1.0191481,0.94385605,0.83205476,0.70319065,0.78946787,0.70816534,0.59135178,0.49702063,0.37747971,0.24327888,0.35669992,0.25782353,0.16313681,0.04048216,-0.048229363,-0.14877341,-0.27662393,-0.29536472,-0.20112638,-0.037306012,0.08411226,0.23010996,0.38223156,0.54536606,0.59174098,0.74248853,0.91777953,1.085084,1.2264407,1.3795605,1.262398,1.1145845,1.0399936,0.88661558,0.85749564,0.7398654,0.63927516,0.54044815,0.58318985,0.54602488,0.44723953,0.34889037,0.26066974,0.14520675,0.058070845,-0.02547606,0.058122346,-0.028275573,-0.09058932,-0.22496257,-0.27895441,-0.36201452,-0.5291947,-0.64046481,-0.75408362,-0.80240329,-0.84914918,-0.83405365,-0.75094893,-0.58868705,-0.44713143,-0.27750797,-0.12359047,-0.012409885,0.14203587,0.2938242,0.44815849,0.45164043,0.35457382,0.27207686,0.15224767,0.067472009,0.027864563,-0.11489012,-0.10566476,-0.24108119,-0.31994555,-0.37168288,-0.46239086,-0.58908847,-0.5259718,-0.59296919,-0.66040153,-0.75823347,-0.79144465,-0.87990445,-0.92494013,-0.96906056,-1.029159,-1.0062323,-1.0907792,-1.052598,-0.87256868,-0.65306697,-0.60038235,-0.39512742,-0.24146057,-0.23315925,-0.33769457,-0.40760854,-0.50355806,-0.41326978,-0.48481422,-0.55571207,-0.5817209,-0.64758857,-0.70730295,-0.65660948,-0.78729087,-0.84090246,-0.89435378,-0.93732832,-0.98687668,-1.0815234,-1.1533936,-1.1695878,-1.2062425,-1.3033942,-1.3400029,-1.3600313,-1.4830361,-1.5282888,-1.6172255,-1.6842996,-1.7329789,-1.8844062,-2.0563876,-2.2019325,-2.2699831,-2.2922996,-2.332906,-2.1917468,-2.1024553,-1.9435909,-1.7936626,-1.6206712,-1.4754882,-1.3029718,-1.1517508,-0.98491251,-0.84310263,-0.67738525,-0.52486647,-0.35920583,-0.20543158,-0.041624489,0.11445563,0.26936593,0.42503239,0.58351685,0.68208023,0.77585817,0.9493511,1.0981332,1.2653201,1.424215,1.5752738,1.7351902,1.8993023,2.05306,2.2065663,2.3756914,2.5198531,2.683021,2.8351394:1
1.1577772,1.0966776,1.0252268,0.96567818,0.89271657,0.88208369,0.8480284,0.75844617,0.67808363,0.6048242,0.521768,0.46331762,0.51583545,0.47157786,0.38659742,0.31472581,0.25150768,0.16108444,0.064761855,0.012257718,0.093874177,0.2072599,0.25946132,0.22674576,0.15578601,0.11159993,0.068441697,0.053867885,0.016877478,-0.056735709,-0.10568252,-0.17298733,-0.23330914,-0.26927743,-0.26959792,-0.17431884,-0.16397617,-0.22388661,-0.30499441,-0.37087671,-0.44927538,-0.49694289,-0.55361925,-0.61152045,-0.53097413,-0.43933512,-0.35198302,-0.25615772,-0.17617978,-0.083955227,0.01356492,0.10592703,0.08133578,0.012198645,-0.071078218,-0.12230178,-0.19831871,-0.17173736,-0.22577567,-0.29385132,-0.38100642,-0.47964492,-0.53000711,-0.46176294,-0.52158612,-0.61418514,-0.70631155,-0.79605473,-0.85572236,-0.91990022,-0.93217287,-0.93230765,-0.8164344,-0.78878528,-0.84286759,-0.87994686,-0.94227314,-0.96531071,-1.0214008,-1.091453,-1.1606264,-1.2274243,-1.2966414,-1.3611683,-1.4144234,-1.4830816,-1.5349376,-1.5794083,-1.5972562,-1.5921312,-1.5838147,-1.5923748,-1.5824891,-1.5319717,-1.4406001,-1.3365072,-1.2202285,-1.1218474,-1.0098477,-0.91077861,-0.79325078,-0.73270127,-0.6688809,-0.55254196,-0.4558944,-0.35054255,-0.253692,-0.15496453,-0.049064918,0.050092419,0.15368451,0.25788493,0.36053246,0.47221757,0.57193809,0.67291818,0.75904321,0.87617454,0.93925239,1.0424078,1.1408552,1.2399727,1.3384697,1.4548848,1.5387606,1.6592272,1.7507927,1.7884057,1.8359594,1.9547677,2.0169849,2.0621457,2.1646973,2.2642141,2.3637901,2.4834371,2.5828364,2.6792734,2.8031037,2.8641708,2.8962861,2.8825077,2.7578235,2.6645326,2.5636985,2.4621546,2.3577721,2.2582339,2.1560397,2.0526552,1.947403,1.8854532,1.7879523,1.6799263,1.5804367,1.4816745,1.3794163,1.2777383,1.1801999,1.077997,0.97610987,0.87693967,0.77707658,0.66625245,0.59350297,0.5175222,0.48154973,0.37600208,0.26875338,0.17479086,0.11773801,0.075716161,-0.033837545,-0.1265331,-0.21254738,-0.2331931,-0.3132292,-0.42622535,-0.52213161,-0.63314482,-0.75581814,-0.82553299,-0.89679259,-0.93037417,-0.98304368,-1.0434951,-1.1378429,-1.2097557,-1.2843303,-1.3861903,-1.5019965,-1.5814908,-1.5713343,-1.5646137,-1.5715309,-1.5523331,-1.5397546,-1.517024,-1.4936829,-1.4653329,-1.4673551,-1.4322577,-1.3858649,-1.3220726,-1.2930633,-1.3494013,-1.4033335,-1.4130294,-1.3752382,-1.3293037,-1.2783389,-1.2218764,-1.1693692,-1.0815542,-0.99372726,-0.93592974,-0.95877738,-0.89777714,-0.84649123,-0.77263869,-0.71834842,-0.66263603,-0.63483275,-0.66638985,-0.60236557,-0.54648832,-0.52398084,-0.48130203,-0.44288107,-0.49871352,-0.60659192,-0.69084964,-0.80212036,-0.89976328,-1.0236191,-0.98756944,-0.92778714,-0.86081002,-0.79930192,-0.76800414,-0.79928542,-0.75949995,-0.68051467,-0.60386239,-0.57640985,-0.60378979,-0.59398901,-0.52989307,-0.42624929,-0.35878977,-0.32409311,-0.28117563,-0.20742005,-0.14782092,-0.12819056,-0.052175234,-0.11928588,-0.20050402,-0.12250291,-0.03247097,0.062373111,0.096759374,0.1220785,0.21607547,0.31207115,0.42360746,0.47898671,0.48285139,0.43824024,0.50263486,0.60244288,0.70567926,0.81196264,0.81684669,0.89189374,0.97732223,1.043445,1.0802832,1.1386346,1.1966755,1.2763716,1.3376057,1.3584124,1.3169433,1.2053338,1.0799857,0.97479006,0.8565516,0.72925592,0.62595693,0.570858,0.47205482,0.37132815,0.28319523,0.17223114,0.080274537,-0.011460801,-0.11466698,-0.20167918,-0.17789422,-0.23751816,-0.33351366,-0.43026395,-0.52258913,-0.62506168,-0.73054539,-0.82787521,-0.92739741,-1.0212137,-1.1364855,-1.238937,-1.3360803,-1.4126255,-1.4252497,-1.3462446,-1.3125427,-1.2743741,-1.1939621,-1.114177,-1.0227867,-0.97037443,-0.89528816,-0.81734267,-0.70919564,-0.6308029,-0.54616033,-0.43868178,-0.33714468,-0.27466461,-0.19219953,-0.12042452,-0.045312753,0.033504293,0.027316831,-0.047711063,-0.12234024,-0.17201775,-0.21732125,-0.15068577,-0.079127524,0.0070492663,0.079936505,0.1501802,0.24791432,0.34191626,0.43851092,0.51935609,0.50138099,0.52992284,0.62613556,0.71228216,0.80473497,0.88802008,0.97366116,0.97589096,1.0518429,1.1516055,1.2526666,1.3533357,1.4468495,1.5372982,1.6102912,1.5374458,1.4227897,1.3135418,1.1987695,1.0829819,0.96145881,0.88835163,0.7727111,0.67115885,0.5759033,0.62449997,0.56672048,0.48343045,0.3552416,0.24261233,0.15252751,0.062803673,-0.01294521,0.041450313,0.12573722,0.21155308,0.2386899,0.17416087,0.08023537,0.0078604939,-0.049020985,-0.15369157,-0.26700899,-0.35319891,-0.45503157,-0.41100399,-0.45176105,-0.54822063,-0.63145068,-0.70230206,-0.79251371,-0.88170643,-0.97524492,-1.0235492,-1.1053494,-1.0341606,-0.90924228,-0.80141558,-0.67679843,-0.59959363,-0.50532727,-0.39715835,-0.36811152,-0.41253851,-0.29462789,-0.17717825,-0.059708876,0.052317371,0.15320108,0.26744513,0.32756601,0.40219997,0.50620288,0.62652084,0.72792983,0.82669807,0.92166912,1.012527,1.1319347,1.1943329:3
2.6126318,2.5320657,2.4374851,2.3401392,2.2465018,2.1624109,2.0480925,1.9583205,1.883199,1.7737435,1.6966479,1.5815723,1.5119449,1.404913,1.3202497,1.2657957,1.1531891,1.0835634,0.96099976,0.89180137,0.77874961,0.70926045,0.62653402,0.53099141,0.43432185,0.33812092,0.24854813,0.21097032,0.22214888,0.25594846,0.19620827,0.13283473,0.024652068,-0.063293704,-0.15242956,-0.23240716,-0.31554864,-0.39319394,-0.45579134,-0.57682094,-0.62586825,-0.63719287,-0.66624215,-0.79066131,-0.79180156,-0.80703383,-0.86624694,-0.94549583,-1.0214345,-1.0725434,-1.1995985,-1.2755151,-1.3508339,-1.3937175,-1.4821936,-1.5833536,-1.5989977,-1.6065377,-1.5730923,-1.5164661,-1.4530347,-1.3656095,-1.2795954,-1.1657707,-1.1015891,-1.1440963,-1.1911562,-1.2629306,-1.34232,-1.3732947,-1.3201226,-1.3984078,-1.4394105,-1.4768055,-1.5518449,-1.5322105,-1.4428793,-1.3790243,-1.399308,-1.3993957,-1.4613956,-1.4951495,-1.5228253,-1.5369176,-1.5490848,-1.6008962,-1.623206,-1.6179823,-1.615503,-1.6523604,-1.6362065,-1.5520607,-1.4560014,-1.3588728,-1.2768559,-1.1553489,-1.0802185,-0.96706666,-0.88350809,-0.81742633,-0.71472188,-0.60691029,-0.50071097,-0.43195809,-0.34738984,-0.22664422,-0.16316459,-0.17337869,-0.17880895,-0.15744935,-0.12677015,-0.0056936335,0.07595783,0.14100591,0.26002484,0.33139904,0.44666849,0.503844,0.62515664,0.71586407,0.75067564,0.78666796,0.75013239,0.69619617,0.67886166,0.63109206,0.56168599,0.50070741,0.44828473,0.47822362,0.56855646,0.60005547,0.6000883,0.55547929,0.50041097,0.43484837,0.39745719,0.36777704,0.40919281,0.52077671,0.59246635,0.70165217,0.73090424,0.7111158,0.70877399,0.66146735,0.64555174,0.59674717,0.56976969,0.56410942,0.56309845,0.55936078,0.5364603,0.48994685,0.43733085,0.41317746,0.37117877,0.3457675,0.34007405,0.3084143,0.30251387,0.38988581,0.52142955,0.62914887,0.70742148,0.75416184,0.75536584,0.75184573,0.73331684,0.70654028,0.68042818,0.65954274,0.65699174,0.65633734,0.6491012,0.61854304,0.60884366,0.59678315,0.55800964,0.49701677,0.48510511,0.4689114,0.47570783,0.45104354,0.38762121,0.44427065,0.45907767,0.41824255,0.37140655,0.31962625,0.26703405,0.24971045,0.17460287,0.065893917,-0.034472882,-0.12601612,-0.1454887,-0.1746049,-0.17100493,-0.26495708,-0.26744569,-0.24602434,-0.1935117,-0.071543443,0.037480893,0.078942856,0.18968844,0.31831464,0.36799879,0.49292208,0.60549863,0.70680571,0.78149304,0.90213933,1.0173233,1.1261485,1.2267019,1.2842671,1.3296636,1.3650228,1.2976683,1.2341885,1.1335445,1.0430837,0.94119666,0.82096795,0.69834417,0.6226405,0.52872811,0.3973598,0.27397025,0.21487566,0.1029577,-0.026261185,-0.091650439,-0.02775479,0.057858071,0.061812108,0.062200214,0.078855962,0.11260944,0.17379869,0.19957073,0.21634479,0.20693831,0.1868763,0.12476333,0.13682586,0.18669769,0.26413078,0.24211784,0.22714596,0.30977516,0.31088954,0.2748236,0.32429216,0.29977726,0.22701471,0.20979807,0.2618984,0.28055074,0.28869524,0.26966449,0.24823022,0.28276506,0.3332553,0.30561366,0.30208227,0.26317476,0.16131189,0.10233448,-0.012672308,-0.079918922,-0.17669299,-0.15255521,-0.12551939,-0.1383202,-0.1284489,-0.10137152,-0.025549661,-0.02256806,-0.040001804,-0.03810584,0.018835485,0.074092094,0.14312864,0.16204627,0.11621371,-0.021521667,-0.075516942,-0.19781097,-0.19909277,-0.14660739,-0.091867254,-0.016949998,0.039099189,0.0095551134,-0.087507706,0.015476635,0.07537772,0.072931748,0.11089043,0.19025236,0.26946661,0.32253457,0.35111924,0.37101835,0.32002862,0.22200173,0.10252072,0.040800522,-0.08136656,-0.17164905,-0.24933317,-0.37103477,-0.44039764,-0.55407058,-0.64273145,-0.67844676,-0.66317157,-0.67366115,-0.76993099,-0.85356075,-0.97092205,-1.0451839,-1.1252494,-1.2334406,-1.3298876,-1.4116082,-1.5242659,-1.6197456,-1.6888929,-1.7809835,-1.8496533,-1.8231222,-1.8017511,-1.7460376,-1.7300937,-1.7079853,-1.628816,-1.5973754,-1.5138393,-1.4816218,-1.376487,-1.3136032,-1.306304,-1.3607036,-1.480723,-1.4890788,-1.4342937,-1.3732632,-1.3241269,-1.2299101,-1.1840202,-1.1150171,-1.1618321,-1.1727248,-1.121205,-1.0359909,-0.95696184,-0.90812602,-0.82990875,-0.78307392,-0.84211083,-0.89398923,-1.0133838,-1.0832029,-1.1733589,-1.2070667,-1.2495466,-1.2559825,-1.1976614,-1.1077756,-1.0537176,-0.97474035,-0.88460785,-0.78445397,-0.70358214,-0.6108053,-0.54733945,-0.54909638,-0.54185941,-0.46522089,-0.384479,-0.28829183,-0.19203379,-0.12854636,-0.049802854,0.048796337,0.12688948,0.21033663,0.3238357,0.35680248,0.32416523,0.269473,0.35157084,0.42735938,0.50111507,0.57771098,0.67240471,0.76027815,0.82781777,0.93910504,1.0478321,1.1081758,1.17187,1.1773671,1.2758291,1.3380351,1.4269683,1.5207023,1.6318274,1.7254438,1.7915619,1.883282,1.9875308,2.0505441,2.1833422,2.2417189,2.3622402,2.4327186,2.5407493,2.6297408,2.7487853,2.768586,2.7330518,2.6369004:3
-0.087432295,-0.1882326,-0.28330969,-0.37411687,-0.45956096,-0.50937974,-0.51504203,-0.42316712,-0.43342114,-0.42573236,-0.47689741,-0.51122432,-0.53922965,-0.55702377,-0.58921951,-0.61027913,-0.64328655,-0.68183096,-0.70857387,-0.72782352,-0.75178541,-0.76560973,-0.76708011,-0.76377652,-0.75641106,-0.73356448,-0.70259942,-0.66005678,-0.60019425,-0.51085168,-0.40574038,-0.30670771,-0.21800163,-0.13567093,-0.055791064,0.026614917,0.09805754,0.17337545,0.24567717,0.30206684,0.35626799,0.41408085,0.47859756,0.5356619,0.61818454,0.59135875,0.5390766,0.51917469,0.54032996,0.55462277,0.55712097,0.56738897,0.58619615,0.61503701,0.65074619,0.68699283,0.73641064,0.82165951,0.91462581,0.99727277,0.99007049,0.98721319,1.0038666,1.021762,1.0273141,1.0273284,1.0279181,1.0381871,1.0587525,1.078957,1.1095117,1.1507374,1.1843425,1.2228422,1.2626417,1.2971558,1.3279001,1.3573108,1.3720536,1.3852774,1.4111772,1.4594236,1.5535161,1.6746316,1.8109955,1.9473398,2.0836859,2.2199819,2.23718,2.1008876,1.976851,1.8767243,1.7687349,1.6325705,1.4963669,1.3758381,1.2892269,1.2642719,1.2818925,1.3081271,1.3257464,1.3257007,1.3200857,1.3269009,1.337962,1.341804,1.3335553,1.3229393,1.2949436,1.2783536,1.2482808,1.2045537,1.1733649,1.1290483,1.0865087,1.0465542,1.0116519,0.98146304,0.93565307,0.86742499,0.80086127,0.72460138,0.63642815,0.52581683,0.39620174,0.29480806,0.2484956,0.21977036,0.2006081,0.18297585,0.16921771,0.16546067,0.16850787,0.17108895,0.17113954,0.17576872,0.1861868,0.20253785,0.22167546,0.2434603,0.252613,0.25655645,0.28097026,0.21675997,0.18990594,0.18850069,0.18976069,0.20151889,0.22271641,0.24781473,0.17081771,0.12233533,0.060674302,-0.02471137,-0.11349388,-0.20367876,-0.30358713,-0.40401194,-0.5080627,-0.60315503,-0.70104251,-0.79734328,-0.8919286,-0.98990379,-1.0555608,-1.1423664,-1.1945126,-1.2250304,-1.2371729,-1.227046,-1.2118172,-1.1965747,-1.1723432,-1.1423925,-1.1159561,-1.0799,-1.0402867,-0.99338438,-0.94190263,-0.88308417,-0.82501713,-0.76403068,-0.72301586,-0.70740014,-0.69511644,-0.63943676,-0.57223783,-0.50469721,-0.44327419,-0.40659814,-0.35281257,-0.27521883,-0.35451049,-0.43668903,-0.5186892,-0.59504974,-0.70044513,-0.76511937,-0.85473196,-0.95039116,-1.0456682,-1.1547276,-1.2631807,-1.3858326,-1.5070543,-1.6258038,-1.7255311,-1.8029086,-1.8557554,-1.8496117,-1.8181018,-1.7614297,-1.6952169,-1.616019,-1.5389488,-1.452694,-1.3651228,-1.2734116,-1.1788209,-1.0866524,-0.9927892,-0.89605823,-0.799734,-0.70645554,-0.60612607,-0.51602152,-0.41276133,-0.31924126,-0.22322217,-0.12418054,-0.19466805,-0.21504846,-0.11993859,-0.017176451,0.079378368,0.17919999,0.27117663,0.33264823,0.44258802,0.48422229,0.38034176,0.27744215,0.17790332,0.082837236,-0.012913378,-0.11010582,-0.20427293,-0.29193875,-0.37945214,-0.46108958,-0.53940442,-0.61235744,-0.68816886,-0.75252054,-0.80893843,-0.820744,-0.77858859,-0.70602985,-0.61198342,-0.49714511,-0.37157704,-0.24975111,-0.129494,-0.0080366059,0.10618113,0.23655328,0.35810115,0.46647673,0.58978376,0.71153184,0.83277738,0.80441888,0.87351767,0.99552821,1.0914644,1.1883227,1.2720173,1.3406046,1.2900859,1.2193865,1.148229,1.071823,1.0020142,0.94735712,0.93218763,0.96266696,1.0535879,1.1578416,1.2779537,1.398121,1.5344793,1.6708412,1.654125,1.6804282,1.775933,1.8918294,1.9958424,1.9167512,1.8318051,1.7263423,1.6057146,1.500169,1.4024526,1.4239732,1.4950616,1.584459,1.4645359,1.371135,1.2351872,1.1163339,0.99821852,0.89475001,0.79306831,0.69801389,0.59042899,0.47377142,0.35714001,0.31941276,0.36743252,0.42487396,0.48551604,0.55729882,0.63178936,0.70134164,0.78592576,0.86333452,0.93904445,1.0213615,1.0956687,1.0658108,0.98157817,0.89034502,0.7903245,0.69638339,0.59431601,0.48932791,0.4026207,0.46743753,0.38698977,0.28780429,0.17992535,0.065499742,-0.0026320739,-0.10286167,-0.20289359,-0.31156711,-0.42035412,-0.52365393,-0.62358196,-0.72383381,-0.83662229,-0.93694828,-1.0638492,-1.1760123,-1.2610896,-1.3200162,-1.3530416,-1.363285,-1.3540279,-1.2920288,-1.2009902,-1.103199,-1.0144376,-0.91382485,-0.82219989,-0.72004353,-0.62254904,-0.5273867,-0.50929883,-0.40830536,-0.30955253,-0.21472752,-0.10982496,-0.030402859,-0.12880629,-0.22907304,-0.321828,-0.41334921,-0.47862148,-0.56921598,-0.66596869,-0.75179419,-0.83982839,-0.92482052,-1.006656,-1.0298631,-0.96702242,-0.89433802,-0.89200882,-0.96050034,-0.96223554,-1.0598646,-1.1540296,-1.2374248,-1.3187278,-1.3991554,-1.4771394,-1.5556347,-1.6299421,-1.6877245,-1.7499879,-1.8062694,-1.8602555,-1.9131938,-1.9694151,-2.0330879,-2.0762704,-2.037028,-1.9797177,-1.9025364,-1.8114697,-1.7210373,-1.611806,-1.4974989,-1.3834709,-1.2650686,-1.1454078,-1.0277844,-0.89586953,-0.77798614,-0.66867851,-0.5563368,-0.43756779,-0.33969716,-0.29834849,-0.24055185,-0.15590142:4
1.5789019,1.5360998,1.4706276,1.406264,1.3257019,1.2513377,1.1748949,1.1279145,1.0987918,1.0278014,0.95257778,0.89204574,0.83088602,0.76804172,0.70078181,0.61304756,0.56025613,0.55597917,0.61486651,0.68352374,0.73785455,0.81097417,0.88152832,0.94183925,0.89808962,0.82911606,0.74364667,0.66255108,0.60370868,0.5349689,0.47770784,0.40289776,0.29107966,0.14741769,0.023597193,-0.092377331,-0.16417026,-0.24762854,-0.36142229,-0.42964176,-0.54455781,-0.6313806,-0.73014465,-0.83835431,-0.94573623,-1.0410456,-1.0878491,-1.0938589,-1.0955608,-1.1069101,-1.1382478,-1.0915982,-1.0725383,-1.0101573,-0.93640942,-0.84967793,-0.82406091,-0.71972737,-0.64531658,-0.54041954,-0.45260969,-0.40914468,-0.35560951,-0.29684642,-0.19633182,-0.090104031,0.013084194,0.10104238,0.1913561,0.20074875,0.12552732,0.052134065,-0.045986051,-0.12777883,-0.21989689,-0.30919017,-0.3992435,-0.4841742,-0.55765304,-0.64114433,-0.70531197,-0.78409487,-0.87197073,-0.94326231,-1.0244828,-1.113002,-1.1989545,-1.2508415,-1.322996,-1.3564398,-1.4348749,-1.5079881,-1.5573646,-1.6295809,-1.6919896,-1.7656885,-1.8522544,-1.8194827,-1.7641658,-1.671232,-1.5669442,-1.4704449,-1.3998,-1.2955629,-1.1848075,-1.0697842,-0.96921339,-0.8860616,-0.79393678,-0.70588163,-0.59295387,-0.49994885,-0.40878827,-0.31888731,-0.21687989,-0.11569431,-0.0079414714,0.097720749,0.20191907,0.31525727,0.41805599,0.52970046,0.6393578,0.71049664,0.82878997,0.94175423,1.0550824,1.1772913,1.2957988,1.4077907,1.5182542,1.6558829,1.765559,1.8941025,1.9270821,1.8982309,1.9705093,2.01459,2.0097674,2.0647331,2.122399,2.1859861,2.2410008,2.2297368,2.1287591,1.998467,1.9215248,1.8513993,1.7388713,1.6595452,1.5788488,1.4671926,1.4469563,1.3441134,1.2632621,1.1679395,1.0904542,1.0099192,0.93316266,0.82017265,0.70458355,0.64243796,0.53055449,0.41725259,0.30853303,0.20083643,0.084285555,-0.020752983,-0.12601491,-0.23955519,-0.34078386,-0.44844083,-0.55193668,-0.61994123,-0.67482494,-0.78152281,-0.8797916,-0.94529151,-1.0475402,-1.1020787,-1.1718117,-1.2605986,-1.3182976,-1.3811794,-1.4508533,-1.5602592,-1.6232575,-1.6667864,-1.73749,-1.7998468,-1.8846026,-1.8918381,-1.9641935,-1.9650561,-1.9059954,-1.8332321,-1.7795105,-1.6997648,-1.5973742,-1.5135319,-1.4209365,-1.3580306,-1.2494273,-1.1402401,-1.0721927,-0.98823926,-0.92812861,-0.91362147,-0.84023531,-0.74777907,-0.667633,-0.57529744,-0.5079296,-0.45207081,-0.40261938,-0.32601069,-0.23186342,-0.12879631,-0.024992239,0.021835306,0.085922106,0.17023951,0.25053933,0.31774544,0.24066446,0.13181421,0.022450217,-0.084446501,-0.1847395,-0.29202482,-0.37836475,-0.48352846,-0.6118277,-0.73890002,-0.85671001,-0.99563152,-1.1122612,-1.2630723,-1.3906226,-1.4889934,-1.493492,-1.4575706,-1.3501886,-1.2313267,-1.1139974,-1.001513,-0.891304,-0.78507821,-0.70003721,-0.61637851,-0.53960471,-0.45886632,-0.36593821,-0.27246933,-0.19673213,-0.13750364,-0.097460179,-0.0039403533,0.084944956,0.17943037,0.25826992,0.34826629,0.43668508,0.5204936,0.61394322,0.6571359,0.54715616,0.44021114,0.35215927,0.27606858,0.1772068,0.11598508,0.11450385,0.18507571,0.26823322,0.35720513,0.42062608,0.51104509,0.60900666,0.69617481,0.75935121,0.82530489,0.91121597,1.0003515,1.092513,1.1985261,1.2030133,1.0958097,0.99647038,0.89572809,0.79519904,0.71902024,0.62316085,0.51934361,0.42173304,0.32486884,0.27431661,0.27087532,0.26659918,0.16264019,0.055080655,-0.04803483,-0.15347242,-0.26427087,-0.37458879,-0.45582762,-0.51967173,-0.58960247,-0.69141169,-0.79583366,-0.83445426,-0.94469561,-1.0339095,-1.1289553,-1.2316904,-1.3347347,-1.3958985,-1.4478773,-1.3796711,-1.3356195,-1.2914578,-1.1746814,-1.0635618,-0.92568121,-0.80948085,-0.69846828,-0.59486414,-0.51722085,-0.38428981,-0.25256185,-0.15041076,-0.047187292,0.048249204,0.16695,0.27127712,0.36080737,0.47030769,0.51243245,0.45682706,0.39512931,0.38216362,0.41665299,0.48098773,0.5448608,0.63727924,0.74568019,0.84069825,0.93476309,1.0290842,1.1120299,1.1355537,1.1751969,1.2710743,1.3671929,1.4577602,1.5308019,1.6060667,1.6860172,1.763587,1.7307855,1.6442885,1.5624548,1.4971176,1.4178718,1.3391051,1.2758134,1.2392457,1.1701809,1.1275057,1.0794108,0.97589461,0.89096562,0.79472298,0.68946194,0.59508191,0.5619681,0.57717877,0.61687032,0.70059206,0.74224956,0.64503916,0.55389763,0.46060224,0.35427626,0.2814145,0.17665069,0.086064504,-0.015738387,-0.11465098,-0.22255076,-0.33049219,-0.43573418,-0.53480104,-0.63531741,-0.73962498,-0.83516609,-0.90827797,-1.0098488,-1.0380277,-1.0332891,-1.0179719,-0.91528246,-0.80451047,-0.72847129,-0.66612094,-0.56094332,-0.47607438,-0.37033857,-0.25873339,-0.14532587,-0.032027905,0.084847394,0.20830234,0.28780754,0.40838723,0.52560077,0.65439194,0.77921668,0.91687639,1.0127224,1.1005023,1.2344818,1.3607764,1.4849658,1.6049431,1.6795047,1.6291826:5
0.31854546,0.28816073,0.24971481,0.2188746,0.1627592,0.1035392,0.056022799,0.0094711613,-0.047255264,-0.067265302,-0.092189143,-0.11880558,-0.15699668,-0.1789079,-0.19949881,-0.23388437,-0.26618592,-0.29399291,-0.33986374,-0.35169354,-0.4128427,-0.43885794,-0.49495536,-0.52576473,-0.54275125,-0.61091659,-0.63007792,-0.67953625,-0.71994227,-0.78002782,-0.84147603,-0.89384365,-0.91965276,-0.94571166,-0.94567125,-0.95431395,-0.95773466,-0.98210695,-0.98695372,-0.97568885,-0.86346421,-0.74710431,-0.6286459,-0.53505091,-0.41560001,-0.32520474,-0.2070529,-0.089180453,-0.011452405,0.093117565,0.195339,0.25189095,0.3548094,0.39708503,0.44540757,0.4738063,0.52269793,0.55219728,0.57002221,0.57832985,0.58585469,0.58797232,0.57809621,0.58854885,0.61240395,0.66960245,0.69770714,0.75333328,0.78375331,0.81393272,0.83726448,0.8509743,0.85742559,0.88065672,0.89932503,0.92547697,0.97321933,1.0490968,1.1308193,1.18535,1.2311785,1.251863,1.2569271,1.2736149,1.2810424,1.2988569,1.4440746,1.5565997,1.6741264,1.8089199,1.9249673,2.0394762,2.1606401,2.2173154,2.2466674,2.2350878,2.2107909,2.133216,2.0544424,1.9874868,1.8429662,1.7507477,1.6766724,1.5646706,1.4600751,1.348363,1.2451612,1.1335545,1.0555951,0.90435239,0.7994732,0.67507012,0.61468044,0.5587877,0.52191507,0.5077643,0.52304033,0.54417588,0.58003891,0.64659163,0.64965348,0.61376829,0.5732336,0.52827452,0.50033552,0.46369675,0.42066063,0.38270856,0.33396558,0.29320439,0.2413388,0.19855706,0.12768067,0.074590344,-0.0035186764,-0.074155975,-0.19266784,-0.30193261,-0.39491044,-0.47561311,-0.4766425,-0.48641546,-0.44885096,-0.43195921,-0.40052345,-0.38340266,-0.37928864,-0.38533742,-0.39488577,-0.38890257,-0.37143204,-0.36015063,-0.34780329,-0.34288766,-0.32715582,-0.31299054,-0.28967558,-0.25394515,-0.21661865,-0.1870162,-0.1630779,-0.16080957,-0.16124541,-0.1775765,-0.20485884,-0.25020001,-0.34978016,-0.45922833,-0.56120725,-0.65923117,-0.77102587,-0.86943079,-0.98581387,-1.0842434,-1.1942614,-1.2982351,-1.4151709,-1.5322236,-1.6405724,-1.6877439,-1.5748727,-1.5016828,-1.4302754,-1.3394839,-1.2778374,-1.2028017,-1.1301894,-1.0559887,-0.98442469,-0.91297866,-0.82680859,-0.75197748,-0.67570038,-0.5974894,-0.52641423,-0.45726717,-0.37204077,-0.32816132,-0.25746089,-0.19757648,-0.13939646,-0.10738239,-0.051556549,-0.0036246919,0.052267607,0.1095323,0.1614729,0.19581301,0.25842513,0.28520934,0.30423432,0.34197589,0.36266634,0.36516351,0.3408059,0.30906602,0.24454058,0.18005822,0.093352927,0.0047217069,-0.073335897,-0.17276013,-0.31197969,-0.4149545,-0.51506636,-0.61328104,-0.71440075,-0.85779137,-0.95753051,-1.0714083,-1.1931957,-1.2934141,-1.4315971,-1.5336551,-1.6404243,-1.7348166,-1.8311459,-1.806214,-1.7069141,-1.6264324,-1.5410156,-1.4429161,-1.3617436,-1.2571107,-1.157463,-1.0683203,-0.97141583,-0.88169263,-0.77071933,-0.67410364,-0.5729398,-0.47764952,-0.38094714,-0.27621683,-0.17703513,-0.080186851,0.017994585,0.10472579,0.20935318,0.29941349,0.41593753,0.51363597,0.61069875,0.64529895,0.74138756,0.83919826,0.89082755,0.93202012,0.93964207,0.97506485,0.98636822,0.98243113,0.95942025,0.92359523,0.84306156,0.75434734,0.66338584,0.56359465,0.46041625,0.3672488,0.27646747,0.19071007,0.090899843,0.014248049,-0.018766527,0.09168433,0.19940533,0.27963005,0.41670391,0.54904832,0.68390836,0.77956755,0.91165594,1.0440729,1.1344344,1.2249747,1.313042,1.3917403,1.4794704,1.5464302,1.6044766,1.6710239,1.7161658,1.7463085,1.7464334,1.758478,1.739662,1.6859763,1.6420935,1.5834532,1.5211052,1.4631487,1.3986986,1.3251184,1.2610924,1.196027,1.1151191,1.0274251,0.95602347,0.88061032,0.79995851,0.70895118,0.62658906,0.53532056,0.44690556,0.3332372,0.22763723,0.11865472,0.0098916159,-0.093803304,-0.17623439,-0.26997445,-0.28672597,-0.22028723,-0.14307069,-0.058098294,0.015233384,0.092603867,0.17851125,0.26074878,0.34543039,0.42688059,0.49628378,0.58176633,0.66065438,0.73793396,0.80930836,0.86904963,0.92186424,0.97725981,0.97791266,0.96657737,0.94540224,0.92226544,0.88470809,0.84949793,0.81219315,0.7447826,0.70467337,0.63478141,0.58244897,0.5334522,0.46284981,0.39383658,0.31299357,0.20324215,0.12579192,0.039346151,-0.057350194,-0.13230241,-0.24231578,-0.36032468,-0.47101152,-0.58433135,-0.69787667,-0.82050048,-0.93260598,-1.0480493,-1.1333861,-1.2418259,-1.3466472,-1.453892,-1.5586433,-1.6551868,-1.7478156,-1.8682313,-1.9641721,-2.052387,-2.1659351,-2.2720348,-2.3636472,-2.4644006,-2.5327681,-2.609555,-2.6815666,-2.661437,-2.5551625,-2.4327797,-2.3295853,-2.2181447,-2.1046044,-1.98986,-1.8454906,-1.7298391,-1.6250726,-1.5199091,-1.406041,-1.2901075,-1.1757206,-1.0616006,-0.91071432,-0.7966702,-0.68243884,-0.53402433,-0.40616168,-0.28510866,-0.1434861,-0.043791384,0.064726727,0.16679398,0.23773786,0.30548111,0.32910232,0.34930395,0.36056621,0.34967974,0.34040995:2
1.5076073,1.4709267,1.4717012,1.4315454,1.4067866,1.3800829,1.3234472,1.2762399,1.2356767,1.1834287,1.153186,1.1196455,1.0544942,0.99605258,0.94452966,0.90876066,0.88380661,0.85054803,0.81445102,0.86600084,0.91194988,0.99032431,1.0465516,1.1109134,1.1666452,1.2257667,1.2881529,1.3327907,1.382055,1.4060397,1.397138,1.4066168,1.3733876,1.3446096,1.3032751,1.2727667,1.2077555,1.1472831,1.0707533,0.98315996,0.93572003,0.85965307,0.77103385,0.6892001,0.59006514,0.49355905,0.40547503,0.34730307,0.25371204,0.16483095,0.089487344,0.008147118,-0.074119958,-0.15208058,-0.21315035,-0.24305718,-0.30455853,-0.32022463,-0.31435949,-0.24004649,-0.15969435,-0.10997432,-0.063058143,-0.076198135,-0.081493473,-0.085947206,-0.10151078,-0.14219259,-0.18187013,-0.23085038,-0.28873637,-0.35412608,-0.40863533,-0.4571205,-0.51567138,-0.57193985,-0.63637833,-0.68322175,-0.75679249,-0.80256322,-0.86517252,-0.9310592,-0.99088584,-1.053189,-1.1055494,-1.1665688,-1.2349014,-1.2906736,-1.3628042,-1.4069025,-1.4703098,-1.5007993,-1.540599,-1.5568106,-1.5780645,-1.5909653,-1.6056421,-1.631014,-1.667223,-1.7094559,-1.6939496,-1.7322309,-1.7472834,-1.7689619,-1.8455257,-1.882258,-1.9041131,-1.8373723,-1.7737611,-1.7237482,-1.6378546,-1.583784,-1.5281697,-1.4785954,-1.4158426,-1.3624367,-1.2971848,-1.2277375,-1.1745533,-1.101226,-1.0430738,-0.98298884,-0.921862,-0.85528748,-0.80478714,-0.75084243,-0.72096325,-0.6669464,-0.64745722,-0.59336879,-0.56168502,-0.52302991,-0.49676029,-0.43700071,-0.40264155,-0.37659428,-0.31365146,-0.28063812,-0.22597575,-0.18986296,-0.14321789,-0.11904622,-0.084289442,-0.047189009,-0.020420031,0.019602594,0.07970821,0.1185007,0.14082489,0.18566634,0.20499969,0.23543776,0.28557831,0.3013178,0.34424857,0.36613021,0.36509924,0.39022782,0.41969301,0.44582476,0.45720575,0.48232106,0.45213789,0.42987292,0.39492555,0.40103982,0.36539981,0.3281737,0.3049543,0.24867624,0.2834066,0.35268602,0.40466403,0.4478849,0.50066865,0.53898722,0.58579161,0.63933504,0.66496372,0.69517973,0.75324994,0.86373762,0.97433539,1.0848015,1.1498534,1.2152313,1.3209324,1.3904925,1.4566967,1.521984,1.5556463,1.6128848,1.6012475,1.6542338,1.699069,1.6990182,1.7004056,1.7511699,1.7941675,1.8485751,1.8714148,1.8085121,1.7578149,1.6932774,1.6401088,1.5659405,1.4906065,1.4515984,1.4045811,1.3460714,1.2758713,1.1657891,1.0824117,1.1328955,1.1747529,1.1949462,1.1970716,1.2010619,1.1810657,1.1474559,1.124664,1.1039861,1.0616343,1.021173,0.98416118,0.94237342,0.89586775,0.85854378,0.82899964,0.77654738,0.73114342,0.68638367,0.64742812,0.59967976,0.57081645,0.53288703,0.50139796,0.4695148,0.46201756,0.41530426,0.38632511,0.36377397,0.33947868,0.31661475,0.28870759,0.24097108,0.21416933,0.17766244,0.15891158,0.13342731,0.13167338,0.098993413,0.071220893,0.061674549,0.056366402,0.047697253,0.04277468,0.020481796,-0.0017614795,-0.027020679,-0.054889218,-0.079199898,-0.15081139,-0.23733282,-0.3011255,-0.3857741,-0.41823506,-0.45051667,-0.46451349,-0.47120884,-0.48948666,-0.49872572,-0.52588947,-0.54941025,-0.56094217,-0.61856954,-0.67274821,-0.73842288,-0.79836291,-0.87002704,-0.94793399,-1.0260002,-1.1050397,-1.1576813,-1.2191284,-1.3032588,-1.378588,-1.465436,-1.5238635,-1.6189445,-1.68255,-1.7536293,-1.8347566,-1.760093,-1.7822136,-1.8393907,-1.8445493,-1.7925423,-1.7690693,-1.7349002,-1.6825398,-1.6402758,-1.6071627,-1.5624595,-1.5311086,-1.5050676,-1.4730316,-1.4397575,-1.4059602,-1.3791377,-1.3636153,-1.3258709,-1.2865047,-1.2690175,-1.2196414,-1.1794593,-1.145998,-1.1093031,-1.085392,-1.0485547,-1.0186908,-0.98809589,-0.92666861,-0.89026569,-0.83146005,-0.78535284,-0.74087878,-0.69424656,-0.65502935,-0.64326467,-0.60990754,-0.5911683,-0.56007853,-0.55070888,-0.56860579,-0.56434273,-0.60181221,-0.64907757,-0.67546742,-0.65841332,-0.64710388,-0.60250622,-0.64003506,-0.67386231,-0.70290653,-0.73324917,-0.76821539,-0.85391666,-0.92260136,-1.0029992,-1.0753576,-1.1411591,-1.1547834,-1.213677,-1.1484013,-1.0862002,-0.98993235,-0.89936116,-0.83321705,-0.72993117,-0.65971138,-0.55727515,-0.48393427,-0.38693274,-0.29360623,-0.1960664,-0.098840819,-0.0037615675,0.085708607,0.13265445,0.22559571,0.30062453,0.34987874,0.39286458,0.44634259,0.46989772,0.45074087,0.45650331,0.48069826,0.53805986,0.53233183,0.54681196,0.60451701,0.6465601,0.66682365,0.66625857,0.63945078,0.59430588,0.55525711,0.49128933,0.42691078,0.37296537,0.32717142,0.26217001,0.19371495,0.14255092,0.082191298,0.013144797,0.033420053,0.14162495,0.23510252,0.31277366,0.42118389,0.48975848,0.58350947,0.65416555,0.71778303,0.79034427,0.8756909,0.92918701,0.98895258,1.0374882,1.0933385,1.141963,1.1793966,1.2229263,1.2697316,1.317305,1.356036,1.3857614,1.427511,1.4685403,1.4750044,1.4919989,1.5036882,1.5171064,1.5339229:2
1.4644501,1.422143,1.3743136,1.3098679,1.2518855,1.2728627,1.3247593,1.281132,1.2616782,1.1735482,1.1206734,1.0901866,1.0313874,0.9657908,0.87731337,0.85138846,0.78438342,0.73118276,0.68524673,0.64903759,0.62100574,0.6651966,0.59227084,0.55158426,0.46489524,0.39366536,0.34711036,0.32416757,0.30244457,0.27794827,0.25512289,0.23021958,0.20037459,0.183823,0.16205516,0.13577314,0.11366087,0.09278897,0.075962606,0.052587239,0.034693709,0.015938312,-0.013469133,-0.03550179,-0.049930962,-0.093177187,-0.12287108,-0.14664603,-0.17403671,-0.19031762,-0.22833181,-0.24969149,-0.27295305,-0.30015995,-0.32057442,-0.34324968,-0.36528663,-0.38854492,-0.41125968,-0.4211855,-0.4516878,-0.47947848,-0.50473371,-0.53383053,-0.57046979,-0.61732779,-0.64793747,-0.70261955,-0.7354768,-0.7898282,-0.853107,-0.9254996,-0.99230904,-1.0575521,-1.1230041,-1.1922864,-1.2602218,-1.3219669,-1.3950311,-1.4734345,-1.5351144,-1.595354,-1.6762823,-1.737568,-1.7581548,-1.7765691,-1.7852959,-1.8097996,-1.8037564,-1.8261583,-1.8279495,-1.8198178,-1.8124566,-1.8006396,-1.7773649,-1.7562452,-1.7271619,-1.7130108,-1.6877061,-1.6089096,-1.5508874,-1.5238537,-1.4643133,-1.3779964,-1.3350327,-1.2668963,-1.233345,-1.1869187,-1.1468191,-1.091179,-1.0272415,-0.98030056,-0.92662705,-0.84653962,-0.79687672,-0.74908093,-0.69992899,-0.65984107,-0.60665077,-0.55494405,-0.49542483,-0.43200952,-0.38739339,-0.31802185,-0.2732849,-0.22059383,-0.16628709,-0.11761272,-0.070352244,-0.024757444,0.02274909,0.073149153,0.11045693,0.15546822,0.18687333,0.23073301,0.25711331,0.27878013,0.30997183,0.32385894,0.34499136,0.3426835,0.3553206,0.32359886,0.28978789,0.25390995,0.20930144,0.14670224,0.073839888,-0.0048079263,-0.084579412,-0.15787514,-0.21479057,-0.29124034,-0.37077707,-0.42305661,-0.49851146,-0.55479886,-0.63671472,-0.68898675,-0.76302434,-0.79293455,-0.82707211,-0.86499588,-0.87266111,-0.85940144,-0.82633848,-0.77075431,-0.73016356,-0.65958764,-0.61083095,-0.53013611,-0.4474966,-0.36385081,-0.30286445,-0.21066478,-0.14291348,-0.074045225,-0.0075522364,0.073873996,0.15583944,0.21880156,0.31041851,0.37228477,0.46066835,0.54565628,0.62982368,0.69596214,0.76848647,0.83721816,0.90069589,0.94998715,1.0023216,1.0601481,1.1043119,1.1516511,1.2008191,1.2541241,1.2776123,1.3063056,1.3416985,1.3914235,1.4094617,1.4332575,1.4661035,1.4737594,1.4983221,1.4997368,1.5107284,1.5393941,1.5540685,1.5692754,1.5821879,1.6270752,1.6343452,1.6595071,1.678117,1.6859578,1.706927,1.7240338,1.7449721,1.7397056,1.7435619,1.7337192,1.708852,1.6693275,1.6260803,1.573382,1.5506179,1.5172375,1.4642569,1.4196488,1.3678852,1.2899822,1.2262075,1.1566846,1.0732002,0.98257196,0.94699511,0.91829465,0.89603349,0.85649555,0.77891589,0.71756918,0.63568929,0.54558033,0.45770782,0.40319043,0.32347592,0.26240811,0.17717253,0.098744351,0.036346448,-0.049029375,-0.10461271,-0.16613197,-0.25478788,-0.34281272,-0.43577141,-0.49845516,-0.57190999,-0.65563968,-0.72425334,-0.7994309,-0.88339803,-0.94932968,-1.034654,-1.1189755,-1.1455435,-1.0816091,-1.0277617,-0.96802552,-0.89668667,-0.84127033,-0.76935249,-0.70165829,-0.63778235,-0.57496847,-0.50494344,-0.446092,-0.38347406,-0.3102824,-0.25078904,-0.19578257,-0.13409522,-0.071435517,3.1269911E-4,0.058526123,0.083879713,0.097368737,0.09851103,0.094667397,0.089617554,0.080060943,0.071481272,0.056082006,0.039460334,0.016158447,-0.0063740109,-0.049394707,-0.073754781,-0.11917049,-0.14107212,-0.1889806,-0.23497827,-0.28165626,-0.3311643,-0.3744168,-0.42562995,-0.46608652,-0.50559569,-0.55495836,-0.59653649,-0.64395707,-0.68889753,-0.73627235,-0.7842878,-0.82857777,-0.86778911,-0.9127151,-0.95065679,-0.99089169,-1.0258293,-1.0667669,-1.1050708,-1.1394547,-1.1730809,-1.2068189,-1.2546239,-1.2827898,-1.3174099,-1.3485749,-1.379442,-1.4081413,-1.4285685,-1.445162,-1.4365318,-1.3838605,-1.3400527,-1.2884534,-1.2494389,-1.2012849,-1.1777624,-1.1824193,-1.1878156,-1.1716819,-1.1739066,-1.153988,-1.1444823,-1.1151766,-1.1005234,-1.0914621,-1.0677228,-1.0441009,-1.0220936,-0.99140557,-0.97014112,-0.92904409,-0.8924985,-0.85159758,-0.78597994,-0.75203864,-0.72668729,-0.69742868,-0.64983198,-0.60893976,-0.55655875,-0.50206423,-0.45379688,-0.39961263,-0.35489993,-0.28167527,-0.22988118,-0.17885586,-0.12659516,-0.042826018,0.011461693,0.063979946,0.15126419,0.24170271,0.33068072,0.42283983,0.51440579,0.59319001,0.67043602,0.71315998,0.74373905,0.77197387,0.78850496,0.81488378,0.90470453,0.97714077,1.0445507,1.1138951,1.1751387,1.2234658,1.2808334,1.326894,1.370568,1.4239748,1.4778484,1.5145785,1.557164,1.5767271,1.604214,1.6357398,1.6680225,1.705398,1.7197648,1.7431446,1.7754092,1.8296183,1.82175,1.7915702,1.7830572,1.7515838,1.7204381,1.6878348,1.6570102,1.6248526,1.5896852,1.5685216,1.5466827,1.531755,1.5313276,1.5119928,1.4902344:2
1.052473,0.96865113,0.89432728,0.82082918,0.75332446,0.70752198,0.67053979,0.59772653,0.52885071,0.46038453,0.38993731,0.31720498,0.2475524,0.17759929,0.10888479,0.042835361,-0.022068897,-0.08235279,-0.14141043,-0.20076534,-0.24656208,-0.26913211,-0.25036006,-0.21361541,-0.16342415,-0.096813407,-0.015546714,0.061074185,0.14067085,0.23049664,0.31757414,0.42118907,0.49002188,0.42744126,0.32287661,0.24363225,0.1674024,0.10359146,0.026496617,0.0064495426,0.008852496,-0.04639025,-0.11701613,-0.17995159,-0.2586735,-0.33701802,-0.41528197,-0.49215078,-0.56731045,-0.63991003,-0.69969649,-0.77394826,-0.84934924,-0.91458244,-0.96826898,-1.027048,-1.0815385,-1.1449933,-1.1916985,-1.2553106,-1.3028143,-1.3527288,-1.3944959,-1.4327929,-1.4610504,-1.4870044,-1.5211891,-1.5545945,-1.576673,-1.5998553,-1.6136959,-1.6125779,-1.5913515,-1.5633792,-1.5152829,-1.4398008,-1.341549,-1.2624213,-1.1926644,-1.1191648,-1.1507233,-1.1636464,-1.159591,-1.1439492,-1.1004978,-1.1077699,-1.0745026,-1.0228178,-1.0084269,-0.99333926,-0.98102852,-0.96450696,-0.95445666,-0.93730965,-0.86884836,-0.82555182,-0.77746342,-0.80639,-0.81618655,-0.81340092,-0.8152034,-0.7878877,-0.7511159,-0.72846624,-0.71194644,-0.69473065,-0.66713806,-0.6271363,-0.59962536,-0.56257682,-0.56112895,-0.57591697,-0.59997987,-0.61573078,-0.63115102,-0.64265591,-0.64218225,-0.63037583,-0.62839109,-0.66149289,-0.68915014,-0.70057282,-0.69173717,-0.6764449,-0.66205131,-0.63459617,-0.61168273,-0.59562344,-0.5874136,-0.5645816,-0.51434237,-0.46676832,-0.41513063,-0.36151647,-0.3095383,-0.25530489,-0.19233387,-0.17249754,-0.1292231,-0.06915121,0.0044778535,0.06356138,0.13623836,0.19992798,0.25907985,0.33288974,0.39754304,0.47202016,0.54545127,0.61651392,0.68494272,0.76165513,0.83092566,0.90600088,0.97954368,1.0482517,1.1170012,1.1959125,1.2678159,1.3425932,1.4153201,1.4905953,1.5573116,1.6335039,1.7120811,1.7834721,1.8570364,1.9285956,1.9998509,2.0804304,2.1582732,2.2261495,2.3015958,2.3754953,2.4489234,2.4269537,2.3597934,2.293399,2.208322,2.1446174,2.1068396,2.024866,1.947522,1.8741946,1.8024922,1.7291026,1.6507284,1.575996,1.5021447,1.4265623,1.3609277,1.2860056,1.2070277,1.1303381,1.0620169,1.0116038,0.96930021,0.95440259,0.94793943,0.92030586,0.90774773,0.88429004,0.90161512,0.9059786,0.90557284,0.88543333,0.90155729,0.91967686,0.92498495,0.91901755,0.8831917,0.82193097,0.7848388,0.72850716,0.67383669,0.61210464,0.54447392,0.46298257,0.38750215,0.31846786,0.24882905,0.19032976,0.12209988,0.070266474,0.024240893,-0.016744831,-0.048768775,-0.067070602,-0.088187933,-0.10657243,-0.12389049,-0.11736061,-0.11223645,-0.10522896,-0.090469933,-0.073149472,-0.055870803,-0.038377215,-0.014563014,0.016508858,0.053452897,0.093688704,0.12897367,0.15829807,0.10316454,0.11382248,0.16104446,0.20432731,0.25568517,0.31064501,0.34029741,0.29519297,0.24397533,0.18225401,0.12211275,0.059797862,0.0047002586,-0.055979168,-0.11925829,-0.18283083,-0.24269431,-0.30162018,-0.36326022,-0.43479435,-0.49102299,-0.5560164,-0.61475531,-0.67473178,-0.74272307,-0.80930235,-0.87031449,-0.93380417,-0.99929343,-1.0564524,-1.1482849,-1.2381228,-1.3208734,-1.3984826,-1.4552441,-1.5132683,-1.5518387,-1.5912638,-1.6098767,-1.6248792,-1.6384868,-1.636313,-1.6217145,-1.6110499,-1.5726461,-1.5395837,-1.4900288,-1.4315548,-1.3857784,-1.3147954,-1.2602525,-1.1795382,-1.1154265,-1.0400466,-0.97095018,-0.8912201,-0.82587343,-0.73773199,-0.71316215,-0.77639695,-0.77957959,-0.72956262,-0.66126528,-0.59059965,-0.51192163,-0.43183931,-0.35043258,-0.27205304,-0.19776129,-0.13674373,-0.1677479,-0.25943293,-0.35422625,-0.43515595,-0.51679381,-0.58380992,-0.55227242,-0.51879724,-0.62223009,-0.72724153,-0.80751544,-0.89289208,-0.96994877,-1.0308686,-1.106182,-1.1647072,-1.2256471,-1.2921292,-1.3425823,-1.3813269,-1.4246308,-1.457576,-1.4816445,-1.483815,-1.435959,-1.3892311,-1.3155322,-1.2503674,-1.1850565,-1.1131724,-1.0408642,-0.96993666,-0.89925749,-0.82436876,-0.74683993,-0.67131056,-0.59981492,-0.52471659,-0.44579873,-0.36547048,-0.29560226,-0.21435724,-0.14174876,-0.061767462,0.011401102,0.087541982,0.15862825,0.24284471,0.3259627,0.40496175,0.48235926,0.47763444,0.54716938,0.59247664,0.6662756,0.72941749,0.64780143,0.55819285,0.50057326,0.45511949,0.41270092,0.38291649,0.38614154,0.41422697,0.48874754,0.5616128,0.62816656,0.70666549,0.77581738,0.85017282,0.92382005,0.99615646,1.0701294,1.1441885,1.21707,1.291759,1.3664896,1.4389188,1.5082857,1.4579669,1.4835265,1.5569272,1.6307187,1.7032013,1.7816031,1.7639455,1.6896904,1.6221766,1.5504054,1.4734102,1.4416124,1.4784618,1.5040447,1.4619122,1.4037538,1.3327462,1.2649842,1.1892252,1.1225777,1.0416158,0.98249243,0.90566636,0.83563931,0.7670268,0.6926095,0.63567045,0.6237948,0.64656148,0.69605519,0.78564148,0.86780731,0.94640777,1.0358715:4
2.8965617,2.7897398,2.6898737,2.5735872,2.4525298,2.3540438,2.2427229,2.12255,2.0359037,1.910578,1.7979468,1.6788769,1.5603041,1.4664214,1.355397,1.2346707,1.1178645,0.99778477,0.8882149,0.79077878,0.67659094,0.55658757,0.44192555,0.32430274,0.20521808,0.089045777,-0.028381086,-0.14331929,-0.26381393,-0.38180564,-0.4978583,-0.61402143,-0.73093431,-0.84714915,-0.97914431,-1.1097992,-1.1965116,-1.2756016,-1.3916926,-1.5339597,-1.6490604,-1.7556222,-1.7418628,-1.7447709,-1.7009532,-1.7026992,-1.6872256,-1.6876451,-1.6578994,-1.6199562,-1.5732279,-1.4983262,-1.421244,-1.3418852,-1.2654416,-1.1948541,-1.1372743,-1.0889508,-1.0238248,-1.0215882,-1.1063759,-1.0674359,-0.98776166,-0.90962109,-0.81450585,-0.76538623,-0.69899348,-0.65988405,-0.63526695,-0.72565798,-0.82685961,-0.8218245,-0.75620894,-0.66678384,-0.5976317,-0.50053621,-0.46292361,-0.50367882,-0.49849705,-0.47150699,-0.45270403,-0.43429625,-0.39064932,-0.34694751,-0.40314365,-0.51161495,-0.59785328,-0.69839008,-0.80329922,-0.90131843,-0.97440978,-0.93137643,-0.92886585,-0.86905482,-0.79705379,-0.74474002,-0.65452481,-0.59237644,-0.50276592,-0.40738067,-0.35000544,-0.33916379,-0.3465033,-0.26729739,-0.20090094,-0.11272102,-0.029264689,0.03952642,0.096651249,0.1740842,0.22501351,0.15803498,0.081807449,0.058703467,0.093197388,0.1722101,0.26360845,0.35539891,0.42786015,0.49022736,0.58033379,0.663831,0.74698639,0.7678955,0.70682312,0.75738137,0.83658323,0.89359294,0.98048839,1.041048,1.0433184,1.099383,1.1576003,1.2212718,1.3039613,1.3653635,1.424927,1.4712177,1.4791412,1.4068279,1.2960941,1.216785,1.1181343,1.0192398,0.92144929,0.81674075,0.71365527,0.59450886,0.47994044,0.37725392,0.26660187,0.14900616,0.028844953,0.042578799,-0.0092121838,-0.14347134,-0.25458982,-0.39639663,-0.46964219,-0.59406131,-0.73006235,-0.84956967,-0.84471169,-0.94856101,-1.0243237,-1.0483127,-0.9687217,-0.88876027,-0.80648019,-0.71392401,-0.62179092,-0.51769784,-0.41074016,-0.35382507,-0.31875493,-0.40219749,-0.50171909,-0.51755543,-0.44256833,-0.36521169,-0.2538428,-0.15230004,-0.035274132,0.076480908,0.1324579,0.16955721,0.24622522,0.33942697,0.39627813,0.46684331,0.49510591,0.4105268,0.32424224,0.25580893,0.20240807,0.30963869,0.39406027,0.47609543,0.51863095,0.65707734,0.75705854,0.86409489,0.83493975,0.86840426,1.0037104,1.1015053,1.1320385,1.2242643,1.3191327,1.4262976,1.5255286,1.606761,1.5877042,1.471632,1.3555948,1.2380873,1.1213782,1.0040689,0.92609889,0.82204392,0.72911273,0.65228543,0.63321756,0.55499139,0.45594929,0.36303591,0.25112732,0.14059721,0.15565496,0.094037835,-0.01908549,-0.10705262,-0.17953791,-0.17939159,-0.14650194,-0.11516419,-0.045370965,0.054602521,0.029963556,-0.032124495,-0.083412696,-0.16802172,-0.23820601,-0.31695813,-0.39841341,-0.39847667,-0.53595347,-0.67755947,-0.79979677,-0.84464122,-0.89811036,-0.98870137,-1.0751859,-1.1394988,-1.238712,-1.3425581,-1.4154464,-1.4833147,-1.5323625,-1.4742521,-1.3842895,-1.2905731,-1.1828318,-1.0829142,-0.97830207,-0.87469437,-0.76327244,-0.65024568,-0.5474777,-0.44195722,-0.34879809,-0.34030655,-0.32175065,-0.34058438,-0.26504291,-0.16428372,-0.058950163,0.032568256,0.13643344,0.24548193,0.34515002,0.45004999,0.49044616,0.59260995,0.70192307,0.80263814,0.91127757,1.0155107,1.1128385,1.2059308,1.2771286,1.2560533,1.1469338,1.0471451,0.95075959,0.83614065,0.76983136,0.68612918,0.57609337,0.48802523,0.46760367,0.49105695,0.43716564,0.33118231,0.23086594,0.15299946,0.12225458,0.073374231,-0.011200482,-0.10900422,-0.1277766,-0.025007392,0.043445533,0.053072666,-0.0054483886,-0.068923974,-0.1393089,-0.17432481,-0.22343361,-0.28944811,-0.35206104,-0.41273317,-0.34061915,-0.28979408,-0.35084102,-0.41485634,-0.46754077,-0.51500858,-0.56984631,-0.61934733,-0.67781128,-0.74026472,-0.68631875,-0.54091092,-0.44306494,-0.34598085,-0.21130463,-0.11978188,-0.039667664,0.053235773,0.15914079,0.14944701,0.080612159,0.011268031,-0.021130893,-0.085234753,-0.15350851,-0.18024483,-0.2050377,-0.28103869,-0.3497824,-0.3808796,-0.43782632,-0.511527,-0.59543283,-0.64045461,-0.67115756,-0.57447851,-0.57796467,-0.58195951,-0.63152029,-0.66065776,-0.66092874,-0.73532083,-0.81736566,-0.9177228,-1.0063096,-1.0283208,-1.0119518,-1.053253,-1.0907065,-1.0975467,-1.125127,-1.179933,-1.1730225,-1.2301419,-1.2800535,-1.3241443,-1.3803469,-1.4198669,-1.4481895,-1.4871962,-1.5115777,-1.5648023,-1.4902866,-1.6158966,-1.5112525,-1.3973689,-1.2544284,-1.1384754,-1.0247388,-0.91110078,-0.767314,-0.64758905,-0.53112643,-0.41405321,-0.29661222,-0.18026056,-0.063775648,0.05424626,0.1715669,0.28826214,0.40519192,0.52313532,0.64041589,0.75843945,0.87646211,0.99441654,1.1088959,1.2143614,1.3174164,1.4369217,1.5566531,1.6744789,1.783104,1.8951205,2.001971,2.1212007,2.2398726,2.3406024,2.4478879,2.5675039,2.6873175,2.79453,2.8976203,2.976135,2.9497131:3
2.029384,1.9304598,1.8839756,1.9186774,1.8628758,1.7936777,1.7097323,1.6243245,1.5089387,1.392335,1.2764964,1.1774451,1.1224536,1.1383237,1.2060309,1.2902344,1.3643039,1.3741948,1.2773393,1.1819366,1.0733891,0.96704971,0.84816431,0.71640052,0.59776697,0.48045916,0.3505063,0.23127084,0.10294297,-0.0086211299,-0.11859671,-0.20992625,-0.25337483,-0.25335755,-0.21955757,-0.16816884,-0.098439212,-0.028716343,0.052038179,0.13515488,0.21736017,0.30284686,0.36330581,0.44537262,0.53555115,0.56580732,0.47553468,0.3820132,0.29254749,0.19711227,0.10488141,0.011616261,-0.081259369,-0.1793111,-0.24610052,-0.18682166,-0.10164362,-0.16893141,-0.2608169,-0.35459801,-0.44731972,-0.54268432,-0.63837257,-0.73283327,-0.82697736,-0.92529354,-1.0194159,-1.1154991,-1.2062626,-1.3034597,-1.3979874,-1.4936008,-1.5844852,-1.6807541,-1.7753859,-1.8685264,-1.9560203,-2.0503134,-2.1341387,-2.2150237,-2.281863,-2.3318371,-2.3502355,-2.3276907,-2.2771974,-2.1986927,-2.1109328,-2.008209,-1.8912492,-1.797543,-1.7186522,-1.6417564,-1.5750225,-1.5017801,-1.4146375,-1.3261339,-1.2419214,-1.1598201,-1.077886,-0.988908,-0.89924866,-0.81479078,-0.73949365,-0.69500534,-0.72164887,-0.66191862,-0.54746537,-0.44882446,-0.34163507,-0.23527553,-0.12927133,-0.0096692683,0.095390865,0.20047061,0.23950795,0.11946703,0.026067277,-0.023106489,0.0038327098,-0.084646626,-0.18056894,-0.2637571,-0.33760423,-0.41676936,-0.48586014,-0.551133,-0.61207555,-0.65506207,-0.6419109,-0.55103254,-0.43146353,-0.2988327,-0.34181332,-0.43793397,-0.52392709,-0.60114615,-0.6673887,-0.72459619,-0.78029143,-0.83034517,-0.87447196,-0.90194679,-0.93285498,-0.95028385,-0.9647591,-0.97862053,-0.99610413,-1.015718,-1.0204156,-1.0190117,-1.0082777,-0.99260927,-0.97171366,-0.95817655,-0.93081473,-0.88888638,-0.84093843,-0.78400987,-0.68621423,-0.57812455,-0.48112929,-0.393398,-0.31902982,-0.2528727,-0.18579804,-0.13725834,-0.08925744,-0.047556994,-0.0033357315,0.097728073,0.1757706,0.26743231,0.33755115,0.37948312,0.33327218,0.33382418,0.36009827,0.34590467,0.33784752,0.34053063,0.38181927,0.38087133,0.38240038,0.39437428,0.40798545,0.42166133,0.44298211,0.47818876,0.50334039,0.53380333,0.5636514,0.59558068,0.61931749,0.63617377,0.64607493,0.65864597,0.66763032,0.65790503,0.57840544,0.57716455,0.6254361,0.71959022,0.82987821,0.9631954,1.0818882,1.2008177,1.3198571,1.4244396,1.5294009,1.6627593,1.7956715,1.9287839,2.0621674,2.1954973,2.3288385,2.46207,2.5416733,2.4440453,2.3106909,2.1773331,2.058673,1.9252608,1.805934,1.6732156,1.5544765,1.4357432,1.3169389,1.1982796,1.0944504,1.0044558,0.93358721,0.89199779,0.85266848,0.81426892,0.7791856,0.74887748,0.74339742,0.75315996,0.76020835,0.75155912,0.74162829,0.71711522,0.68527235,0.66223742,0.63519556,0.61578018,0.60044751,0.59133583,0.5711008,0.55740347,0.54987221,0.54955873,0.55783746,0.55848836,0.54064472,0.5677299,0.61202224,0.58259187,0.50004599,0.43413453,0.39764276,0.31002857,0.23087732,0.15308786,0.07135515,-0.0084898228,-0.092454612,-0.16688481,-0.24926304,-0.35146814,-0.44728793,-0.51199095,-0.54657143,-0.56998002,-0.58007639,-0.57564628,-0.56614703,-0.54633129,-0.52526492,-0.49781578,-0.47695428,-0.44479217,-0.42358669,-0.39706927,-0.37128856,-0.34265818,-0.30945943,-0.26686868,-0.21429468,-0.15385997,-0.08971327,-0.058335773,-0.044339413,-0.12853837,-0.17478402,-0.15782725,-0.10807896,-0.05735747,0.0027580716,0.069893252,0.14058865,0.2123434,0.2901307,0.36918099,0.45529997,0.47083646,0.37132186,0.40624337,0.48583166,0.56579767,0.65555474,0.77868824,0.76602805,0.63293437,0.57557568,0.4707628,0.37469233,0.27534553,0.17344943,0.08142977,-0.031002271,-0.076765628,-0.044555949,-0.049634263,-0.1270845,-0.22398259,-0.31240001,-0.39449055,-0.48191037,-0.58348545,-0.68871017,-0.7917338,-0.90651983,-1.0114978,-1.1001376,-1.1972448,-1.2963281,-1.3945438,-1.5096754,-1.6340565,-1.736131,-1.8197311,-1.8909777,-1.9534547,-2.0008507,-2.0292601,-2.0433793,-2.0313562,-1.9933353,-1.9214463,-1.8401671,-1.7518205,-1.6619284,-1.5727062,-1.484237,-1.3884021,-1.2925447,-1.19163,-1.0962388,-0.99790232,-0.89497245,-0.79996086,-0.69900108,-0.59700409,-0.49234667,-0.39666806,-0.29618278,-0.19791689,-0.099784994,-0.0053397112,0.086378155,0.13769379,0.050864884,-0.015522581,0.059938774,0.16421941,0.26703416,0.38129504,0.48410017,0.60378131,0.64087604,0.53668098,0.44807183,0.34562971,0.24578978,0.15199408,0.06728441,-0.018375219,-0.095372597,-0.17639383,-0.24559956,-0.31359384,-0.37272446,-0.3996481,-0.36964201,-0.30785764,-0.23049193,-0.14281384,-0.046733274,0.052706493,0.16639273,0.26659302,0.38288515,0.4999438,0.61866029,0.74987973,0.86922782,0.94061677,1.0286548,1.1340276,1.239881,1.2234753,1.1320333,1.0550888,0.99316516,0.96990894,1.0344741,1.1261214,1.2390609,1.335892,1.4465566,1.5598991,1.6707892,1.7689471,1.8242268,1.8773385,1.955389:4
1.4576205,1.3842164,1.2982146,1.2191348,1.1525482,1.1170094,1.0555332,0.98308758,0.91656308,0.89773604,0.88480752,0.81728697,0.72985892,0.63434453,0.53188597,0.45544735,0.42599104,0.42925637,0.49505209,0.54815282,0.55244402,0.48776812,0.43985666,0.3761632,0.283681,0.15868622,0.070923347,-0.033418641,-0.12566022,-0.24926073,-0.3677772,-0.47727545,-0.57495804,-0.67182475,-0.75626101,-0.82454099,-0.86818627,-0.84712532,-0.74647621,-0.65580431,-0.56383906,-0.48570237,-0.39481579,-0.30096674,-0.32302368,-0.24161728,-0.24193376,-0.13027026,-0.10473476,0.0076095812,0.095173428,0.21368015,0.26917318,0.22678031,0.14325147,0.065164099,-0.031774896,-0.099250598,-0.1582608,-0.17311153,-0.20773029,-0.26278387,-0.3356133,-0.4110784,-0.47251982,-0.53697054,-0.55402258,-0.58062896,-0.63507192,-0.69648136,-0.73965044,-0.81700333,-0.88657461,-0.95542161,-0.99183247,-1.0181318,-1.0342858,-1.1062711,-1.1279126,-1.1469648,-1.2090024,-1.2304617,-1.2318913,-1.2155879,-1.2227804,-1.2952577,-1.4284824,-1.5171857,-1.6266131,-1.7190127,-1.7763728,-1.8184572,-1.7819906,-1.7065945,-1.695015,-1.6132793,-1.5141313,-1.4290054,-1.3405844,-1.2514001,-1.1388015,-1.0299171,-0.92942648,-0.80945033,-0.69373137,-0.59854089,-0.48654721,-0.38333689,-0.25122351,-0.15430132,-0.029269862,0.051737612,0.18044863,0.27222398,0.39653873,0.46901133,0.57954622,0.69907311,0.81397251,0.94057134,1.0714906,1.1925359,1.2937937,1.4095784,1.5185579,1.6346033,1.7515772,1.8588123,1.9784613,2.0852734,2.2104212,2.2919301,2.3451262,2.2957604,2.1921587,2.0924892,1.9595906,1.8304961,1.7319515,1.6389645,1.5460658,1.5121378,1.4171742,1.347263,1.2272436,1.1103018,0.9896653,0.96609438,0.86423627,0.79310395,0.73145571,0.61788276,0.5061843,0.43316453,0.29679269,0.163399,0.078843542,-0.020206115,-0.14928314,-0.23526118,-0.28208102,-0.36554651,-0.48749853,-0.56298788,-0.66968519,-0.79264787,-0.89367013,-1.0207899,-1.0656152,-1.17886,-1.2521797,-1.3503512,-1.4500404,-1.511869,-1.5967804,-1.5485778,-1.4445087,-1.3765378,-1.4238377,-1.4549182,-1.3822045,-1.2795882,-1.1809894,-1.0889572,-0.99167187,-0.89317508,-0.77579406,-0.65679885,-0.52301218,-0.42090462,-0.337584,-0.26510123,-0.17449986,-0.15956294,-0.2408599,-0.25137064,-0.22265057,-0.15298132,-0.072300832,0.039860391,0.15258187,0.22791268,0.24427251,0.26625053,0.32418476,0.41701131,0.48385253,0.52038642,0.56230419,0.58006162,0.63491499,0.65016377,0.64969777,0.55079507,0.42621678,0.3143692,0.19535809,0.054315885,-0.048998116,-0.17776807,-0.31288331,-0.4455587,-0.58106266,-0.70484992,-0.8452215,-0.95951538,-1.0369539,-1.029651,-0.94910285,-0.89608602,-0.83763042,-0.75924414,-0.67584705,-0.59382347,-0.49206959,-0.39238059,-0.33287079,-0.24670064,-0.16316622,-0.080046585,-1.6577017E-4,0.10400447,0.12283613,0.17417184,0.20523038,0.28080437,0.37695993,0.46294721,0.56671248,0.63184743,0.70119433,0.80790392,0.84326254,0.79326034,0.74252311,0.71742773,0.72797872,0.83077785,0.89841493,0.96167684,1.0217646,1.0699068,1.0939075,1.1215177,1.1809303,1.2659871,1.3618839,1.4334644,1.4093892,1.3004273,1.1829059,1.0737531,0.97046271,0.8722205,0.77736065,0.68027868,0.59942735,0.49901417,0.39696632,0.28301976,0.17685773,0.099140141,0.0056805585,-0.100683,-0.20346025,-0.32853332,-0.45243211,-0.55302506,-0.69824016,-0.81119001,-0.94739265,-1.0297371,-1.155615,-1.2999899,-1.3654371,-1.3884121,-1.4842512,-1.5736546,-1.618791,-1.661464,-1.6339119,-1.7035467,-1.6440129,-1.653907,-1.5288978,-1.4695747,-1.3717833,-1.3266976,-1.23152,-1.1039425,-0.99098743,-0.92785731,-0.8242192,-0.74130711,-0.68551954,-0.56396841,-0.46059049,-0.39227468,-0.27379385,-0.17659658,-0.0655206,0.048965647,0.14839945,0.26004785,0.36096152,0.46657477,0.57145566,0.68498894,0.81043351,0.82766707,0.76148247,0.70004136,0.63866828,0.56428496,0.52800496,0.60059082,0.69469471,0.79982721,0.90801048,1.0127723,1.1053283,1.2025786,1.2847569,1.3421318,1.4249999,1.522545,1.6159533,1.7055743,1.7658555,1.8385544,1.9011009,1.9744793,1.9038505,1.8516169,1.7901496,1.7038194,1.6100088,1.495653,1.4069863,1.3439054,1.2479771,1.1301661,1.0213159,0.9090792,0.81830256,0.73863488,0.7034659,0.69845053,0.70055255,0.69369385,0.76369162,0.67861074,0.57611655,0.47436036,0.37134183,0.26597157,0.16000216,0.071538194,-0.03507512,-0.13294508,-0.24474949,-0.34946076,-0.4716849,-0.58203606,-0.68322836,-0.78352936,-0.89143125,-1.0024995,-1.1093492,-1.2199127,-1.3078437,-1.3819701,-1.4735198,-1.5785809,-1.6603507,-1.7646838,-1.8185967,-1.8540011,-1.8933896,-1.7935907,-1.6647369,-1.5089386,-1.3835714,-1.2527906,-1.1185482,-0.98761866,-0.8453057,-0.71455064,-0.55856796,-0.45169722,-0.30683737,-0.17351046,-0.031225766,0.09248074,0.15632099,0.21794738,0.31053165,0.40957286,0.51990664,0.62835687,0.72168878,0.83877801,0.96513852,1.0640281,1.1726478,1.2948229,1.4051456:5
2.5200703,2.3964235,2.2657177,2.0998338,1.9833902,1.8378964,1.7073705,1.5728538,1.4194459,1.2891574,1.1420951,0.99708728,0.86592715,0.72548814,0.57960988,0.43476308,0.29411491,0.1479215,0.014031256,-0.13742217,-0.28001139,-0.42649847,-0.56971032,-0.68744198,-0.83358818,-0.97169211,-1.0906458,-1.2017529,-1.3414833,-1.4931037,-1.5905858,-1.6021734,-1.5862619,-1.4808828,-1.4014203,-1.3988912,-1.3348862,-1.2965656,-1.2818031,-1.221,-1.1817011,-1.2278425,-1.2769846,-1.2279938,-1.1557466,-1.0758689,-0.98724481,-0.98008643,-0.93308897,-0.81495307,-0.73769187,-0.65906654,-0.59353272,-0.51328981,-0.44629799,-0.39349103,-0.38977387,-0.39883,-0.37083921,-0.29289441,-0.28638241,-0.29541105,-0.23398972,-0.099123182,-0.077865979,0.031115009,0.11754987,0.14045287,0.21414824,0.22582652,0.28521477,0.35559026,0.38544938,0.46098037,0.41338554,0.48984427,0.59456068,0.62571586,0.62898355,0.63237672,0.65275219,0.67144892,0.67116359,0.66215497,0.66048094,0.68401808,0.69928052,0.72684292,0.72316726,0.71538597,0.71598117,0.7599868,0.8012833,0.83181117,0.84640109,0.74668342,0.74264022,0.72045059,0.68584669,0.66193959,0.61822615,0.50696599,0.33713458,0.17409822,0.040938585,-0.10325781,-0.27634202,-0.40278835,-0.50079723,-0.54144781,-0.69599788,-0.84417299,-1.0002425,-1.1039674,-1.2189106,-1.1695929,-1.1059955,-1.0239273,-0.92666847,-0.83386111,-0.75605898,-0.69986569,-0.62052838,-0.56443511,-0.45524432,-0.34642036,-0.25253999,-0.1859554,-0.085892345,-0.025248348,0.10073523,0.21518325,0.2648089,0.16157036,0.043216664,-0.10259766,-0.16096187,-0.14717388,-0.10340032,-0.041435978,0.043130294,0.11832851,0.18141407,0.23445465,0.328278,0.43267216,0.52706832,0.65164798,0.77816269,0.87012142,0.95727517,1.0413559,1.125389,1.2241601,1.2499214,1.1263038,0.98907724,0.85821103,0.73618259,0.61386021,0.49061874,0.37275529,0.23662224,0.095286061,-0.023427091,-0.14467721,-0.27008562,-0.38470294,-0.48611044,-0.60444721,-0.73752498,-0.86926437,-1.0270502,-1.184487,-1.331582,-1.5158215,-1.6714375,-1.826452,-1.994917,-2.0246908,-2.0910676,-2.0569514,-1.9482034,-1.8281743,-1.8551738,-1.7326299,-1.6188417,-1.46959,-1.3425158,-1.2341507,-1.0875577,-0.9480533,-0.78422022,-0.63336456,-0.49048231,-0.38792124,-0.24544094,-0.1003937,0.034395897,0.15210987,0.25535007,0.36037141,0.36406015,0.29788388,0.22683671,0.1739543,0.14319948,0.14000605,0.23873511,0.36831091,0.46703511,0.5783216,0.6387044,0.72155714,0.80196806,0.92158302,0.97552019,1.0549577,1.1584757,1.19543,1.2860583,1.3891067,1.4316613,1.5100767,1.5820711,1.6824896,1.7930116,1.8811547,1.9828319,2.0948074,2.2123964,2.1355217,1.9853226,1.8435301,1.6972177,1.5482048,1.4230932,1.2844179,1.1370999,1.0267206,0.93158058,0.80310588,0.66762643,0.53584941,0.39945307,0.28126909,0.25089622,0.25785969,0.30755211,0.37749745,0.3180311,0.19980872,0.072681849,-0.040666084,-0.17408637,-0.29998023,-0.42757998,-0.55837564,-0.69109757,-0.82671781,-0.95765288,-1.0872232,-1.187965,-1.2131843,-1.2854636,-1.3669976,-1.4594312,-1.5501941,-1.5955743,-1.7008283,-1.6332294,-1.5192489,-1.4703239,-1.4015273,-1.3374997,-1.2089724,-1.0468353,-0.94723409,-0.89431874,-0.80409151,-0.74202125,-0.73284331,-0.61024509,-0.52448094,-0.41808054,-0.28679505,-0.13843871,-0.060630506,-0.0011148217,0.098938077,0.23733902,0.39985995,0.54633785,0.67167126,0.77227888,0.86754407,0.99410824,1.1397448,1.2620664,1.3268005,1.4813241,1.6102687,1.7199264,1.7287853,1.6138063,1.5050536,1.4106417,1.3082657,1.2187358,1.1415479,1.072039,0.99908747,0.93490258,0.87975819,0.87020425,0.79666395,0.69081023,0.5956047,0.51478277,0.41862424,0.31713487,0.26846228,0.23632675,0.28190089,0.3488628,0.45457195,0.54132593,0.66352759,0.78836306,0.80607577,0.70019055,0.56352266,0.46595352,0.3352625,0.21420086,0.1547377,0.055940061,-0.076003463,-0.22638216,-0.37375876,-0.51197304,-0.63497016,-0.6692613,-0.74779343,-0.86364791,-0.94599385,-1.0803153,-1.2129343,-1.2657042,-1.3194144,-1.2993618,-1.2782168,-1.1956263,-1.060639,-0.92624965,-0.79309532,-0.64743797,-0.51418336,-0.37135913,-0.22761214,-0.086415625,0.069209599,0.22004928,0.37261537,0.53130774,0.61830005,0.54357744,0.42624349,0.33950126,0.21704178,0.13962339,0.020689067,-0.06946793,-0.15490099,-0.20560494,-0.25469165,-0.33422339,-0.40382264,-0.50285979,-0.61684172,-0.70011425,-0.71595721,-0.7323003,-0.80217901,-0.86539767,-0.94887676,-1.05886,-1.1767859,-1.22943,-1.3319134,-1.3303584,-1.3016374,-1.3706761,-1.4262931,-1.4854895,-1.4669991,-1.5189411,-1.4573624,-1.4143325,-1.3649424,-1.2136554,-1.0720899,-0.93036655,-0.78451324,-0.6435502,-0.49975294,-0.35721592,-0.21404071,-0.071674313,0.072877054,0.21211235,0.35826554,0.50016772,0.65055073,0.79886181,0.94638884,1.0980786,1.2380343,1.3900872,1.5374562,1.6543948,1.8108773,1.9766073,2.1329574,2.2748047,2.3941686,2.495579:5
1.0530278,1.0067363,0.93660487,0.85892953,0.79182877,0.71708009,0.64891752,0.59046844,0.52055413,0.50981892,0.43698132,0.36638148,0.29362208,0.21381157,0.14122776,0.06674944,-0.017997708,-0.071266708,-0.023202864,0.05935998,0.14728194,0.22454201,0.32024506,0.35494936,0.34457761,0.26678449,0.19108944,0.097923399,0.019070877,-0.055642415,-0.12635318,-0.19910388,-0.27614428,-0.38846239,-0.50648331,-0.59366568,-0.7182257,-0.82515534,-0.8993752,-0.98283426,-1.0808114,-1.074112,-1.0191648,-0.92834358,-0.84518509,-0.79844194,-0.69586544,-0.59400193,-0.50182408,-0.44323016,-0.3526037,-0.28283915,-0.18473676,-0.092727695,0.0075084553,0.10828651,0.19619842,0.15221199,0.062120999,-0.050966974,-0.13174437,-0.19219029,-0.27189125,-0.34301639,-0.42743898,-0.51781378,-0.61395592,-0.71574266,-0.8152467,-0.85789995,-0.8274567,-0.81495561,-0.89120104,-0.97410094,-1.0543966,-1.1436193,-1.2244153,-1.2900908,-1.347401,-1.392046,-1.4716677,-1.5191667,-1.5019506,-1.4739186,-1.4630601,-1.4765885,-1.5248586,-1.5861582,-1.6457778,-1.7234953,-1.7182889,-1.6106909,-1.5689033,-1.4587383,-1.3161705,-1.2075275,-1.0769459,-0.97572933,-0.86040637,-0.72822839,-0.63080556,-0.55294919,-0.4237866,-0.31483507,-0.2021158,-0.062478822,0.069373248,0.18987685,0.31003301,0.39732168,0.54061678,0.66144304,0.79352014,0.91459088,0.98989693,1.0885117,1.2091104,1.3412921,1.4528361,1.5720816,1.6599232,1.8032614,1.7754077,1.8763085,1.9860505,1.8948121,2.0078749,2.1110858,2.2432442,2.3530335,2.4169423,2.4858786,2.5922152,2.6094749,2.6106665,2.6055091,2.5496398,2.493154,2.4771711,2.4011793,2.2796571,2.1633573,2.0343293,1.9800781,1.9262776,1.8341653,1.7792863,1.6941717,1.5801524,1.4416699,1.3324629,1.2233056,1.1252444,1.0030112,0.89894768,0.80892513,0.72580729,0.63763535,0.51807516,0.39783695,0.26610536,0.13399907,0.014566418,-0.11631653,-0.23484994,-0.34325354,-0.44046367,-0.53779979,-0.64373604,-0.74632017,-0.85812732,-0.97438685,-1.098031,-1.2271194,-1.3453364,-1.4513439,-1.5442976,-1.636506,-1.7215643,-1.7295382,-1.6528676,-1.5738655,-1.5111388,-1.4527686,-1.3978736,-1.3861601,-1.437586,-1.439549,-1.3956888,-1.3345755,-1.2487378,-1.1469781,-1.0505648,-0.9449142,-0.87893327,-0.78406448,-0.72165592,-0.69633468,-0.74059199,-0.62513142,-0.51879152,-0.41515208,-0.305996,-0.21857606,-0.20008074,-0.22990733,-0.16216837,-0.058085003,0.010122922,0.030575628,0.090043091,0.17939552,0.25393726,0.33340731,0.44416624,0.43680308,0.35033639,0.26246522,0.17598036,0.090446815,-0.01300593,-0.11262947,-0.21792871,-0.27932829,-0.38053991,-0.50098457,-0.63322246,-0.7548764,-0.88765072,-0.98775726,-1.0582695,-0.97503327,-0.88739468,-0.80270871,-0.74163116,-0.68022999,-0.60643269,-0.50363346,-0.39998671,-0.32559395,-0.27673921,-0.22129952,-0.12925681,-0.037378334,0.019240487,0.10225757,0.19993404,0.29181135,0.36603235,0.40460932,0.34007942,0.28089569,0.18993107,0.081445125,-0.016493763,-0.10195419,-0.072974505,-0.015707651,0.075230266,0.14460532,0.25992414,0.33308058,0.32634718,0.31336901,0.37338365,0.41133187,0.50440717,0.56993377,0.61619046,0.71181917,0.80495421,0.86135799,0.85318696,0.91194821,0.99360575,1.093941,1.175751,1.2786017,1.3616183,1.4661782,1.5270973,1.4425094,1.3402136,1.2437486,1.1411334,1.0478792,0.95301238,0.87093506,0.77416899,0.67489694,0.57790966,0.48213082,0.38445685,0.28908522,0.22342948,0.16976772,0.073576429,-0.025889181,-0.12431657,-0.22237112,-0.31751992,-0.4184539,-0.51842186,-0.61997726,-0.72555089,-0.82932687,-0.92660412,-1.0069081,-1.0874112,-1.1870043,-1.2608721,-1.3690482,-1.4521757,-1.4750923,-1.4425392,-1.3860482,-1.2779562,-1.1661435,-1.0863154,-1.0202986,-0.93515164,-0.82410606,-0.73751452,-0.66531103,-0.55803154,-0.43022684,-0.33789554,-0.25198514,-0.11556677,-0.043711463,0.053502594,0.14786025,0.23639826,0.27654695,0.23194187,0.20293766,0.21565697,0.26231179,0.33225828,0.42576511,0.47123925,0.5450529,0.62191671,0.69096414,0.76235616,0.82574925,0.88500251,0.93978493,1.0143244,1.0871655,1.1598586,1.2334482,1.3011933,1.379951,1.4704203,1.5503267,1.539812,1.457647,1.3860847,1.3194271,1.2545948,1.1643634,1.0822137,1.0071994,0.98816203,0.92690797,0.82550428,0.70973787,0.59071461,0.50777223,0.46950947,0.37970005,0.30333704,0.27411494,0.32887705,0.4061452,0.42375017,0.31122908,0.2035799,0.11432521,0.019283591,-0.0877518,-0.1908854,-0.30200078,-0.40389207,-0.50501483,-0.5819416,-0.68116179,-0.77228838,-0.87167315,-0.95104669,-1.0549362,-1.1605707,-1.263362,-1.3452092,-1.4497644,-1.5459855,-1.5842994,-1.5440112,-1.5180067,-1.4555132,-1.3845413,-1.3260162,-1.2593572,-1.1598605,-1.0585378,-0.95583272,-0.85233831,-0.74860079,-0.64279838,-0.54002584,-0.43297284,-0.32873587,-0.22266714,-0.12002299,-0.062646447,-0.0089527214,0.093358017,0.20137999,0.31216896,0.42254778,0.53813569,0.60236597,0.69504617,0.81635938,0.94348727,1.0672668:5
0.39756385,0.34279134,0.2684251,0.19519517,0.11811451,0.077420629,-0.033246418,-0.11520019,-0.21100207,-0.29493086,-0.39667094,-0.49636381,-0.59633407,-0.69632319,-0.80469599,-0.91793357,-1.0155657,-1.1417123,-1.2566836,-1.3503306,-1.4480895,-1.5341707,-1.6190693,-1.7039348,-1.7777776,-1.8738502,-1.9688334,-2.0565314,-2.1207246,-2.1860575,-2.2267669,-2.2496595,-2.2488136,-2.2175353,-2.1195379,-2.0046346,-1.8885555,-1.8070104,-1.6956023,-1.6193024,-1.5227781,-1.4288297,-1.2959389,-1.1991383,-1.0820935,-0.95828738,-0.81222265,-0.66631747,-0.54261992,-0.42093914,-0.28616086,-0.17018651,-0.03840868,0.082664705,0.21033914,0.31203521,0.4074906,0.50209254,0.56452517,0.59016132,0.59819278,0.56626733,0.57248022,0.56189624,0.54235609,0.51936684,0.51389213,0.42506282,0.38543112,0.31825088,0.25688819,0.22473344,0.28504905,0.33981451,0.33211405,0.28431894,0.22707425,0.16472288,0.067967197,-0.021656541,-0.032104459,0.015386707,0.068058404,0.10703531,0.16627973,0.21190263,0.28761483,0.34471795,0.41476197,0.45433852,0.51955596,0.58081291,0.63714854,0.69819714,0.76988901,0.83993057,0.90257927,0.96749245,1.013755,1.0566937,1.1139556,1.1395459,1.1680785,1.1854563,1.1878932,1.187653,1.1978443,1.2169868,1.2610673,1.3415247,1.4584167,1.5466452,1.6386156,1.7599592,1.8801264,1.9737748,2.0261164,2.0665904,2.0729524,2.0439257,1.9893383,1.8553409,1.73394,1.6775826,1.6255239,1.5623382,1.4206963,1.2643642,1.1386221,1.0281349,1.0150925,1.0612274,1.1123329,1.1367784,1.1373269,1.1209244,1.0936283,1.0615402,1.0398805,1.0469239,1.0569668,1.0635631,1.0480754,1.0036487,0.92480355,0.88076827,0.84111121,0.76816884,0.72887817,0.66302404,0.57769782,0.50152894,0.45626835,0.37838509,0.32445891,0.2920345,0.27237493,0.2560116,0.22164736,0.14385483,0.05794267,-0.05488847,-0.16101452,-0.27200337,-0.37374041,-0.49732004,-0.59835616,-0.68537097,-0.74436989,-0.79862424,-0.82120415,-0.89530539,-0.94441041,-0.94678838,-0.94603026,-0.93141032,-0.8983665,-0.8751581,-0.85085026,-0.81962233,-0.78012926,-0.71175483,-0.64203542,-0.59097833,-0.53450933,-0.49337582,-0.45481329,-0.37661993,-0.30281718,-0.23536652,-0.14751248,-0.06141817,0.028285733,0.092972719,0.16347551,0.21774011,0.27030422,0.30215741,0.29205867,0.26851355,0.17963962,0.092613288,0.001685382,0.018343343,0.072281012,0.1369062,0.20899284,0.26764767,0.34899656,0.36375039,0.44168547,0.49485015,0.53952187,0.58186526,0.59319521,0.4825354,0.45566819,0.56019362,0.67237962,0.65221541,0.55671806,0.45599765,0.30642146,0.19068767,0.068779362,-0.088211223,-0.21195729,-0.33491291,-0.46067936,-0.58732006,-0.71024884,-0.83427644,-0.93166306,-1.0587757,-1.1815904,-1.2889126,-1.4015351,-1.5228999,-1.6245039,-1.7405821,-1.8648161,-1.9874056,-2.1149601,-2.1123998,-2.1305564,-2.0543835,-1.9851614,-1.8911422,-1.8132297,-1.7148424,-1.6330458,-1.5359496,-1.4372177,-1.3355943,-1.2372367,-1.1352925,-1.0324251,-0.93507274,-0.82460253,-0.72200794,-0.62483945,-0.53149405,-0.42420605,-0.3201184,-0.21997782,-0.11706598,-0.014372323,0.093777579,0.1905003,0.24044228,0.2079964,0.28594665,0.39283205,0.4904914,0.6026923,0.72411994,0.83475656,0.92439794,0.98449272,1.0157198,1.0119269,0.91118365,0.80329044,0.71224309,0.60717774,0.51813306,0.40896264,0.31576786,0.20372586,0.098837803,-0.013085158,-0.10772438,-0.21591047,-0.31788929,-0.42362398,-0.53671381,-0.63867137,-0.74222267,-0.84935594,-0.95214035,-1.0465029,-1.1483587,-1.0982199,-1.0292283,-0.88088519,-0.73219908,-0.58084201,-0.45945698,-0.30791754,-0.15735106,-0.0060213015,0.14036942,0.2509507,0.37674815,0.48938842,0.58833628,0.68990254,0.78853168,0.87171494,0.96340444,1.0584159,1.1531438,1.2142479,1.3009775,1.3635151,1.4077501,1.4626984,1.4070406,1.3239055,1.236964,1.1469111,1.0602285,0.98616454,1.0884111,1.1751597,1.2591761,1.3438512,1.4077411,1.4684109,1.5021366,1.4634479,1.3870149,1.3119519,1.2292815,1.1288127,1.0669345,1.1317913,1.2098359,1.2799991,1.3122226,1.2342766,1.1858308,1.1132412,1.0170271,0.9099003,0.7830441,0.64260132,0.54200154,0.49921817,0.5237355,0.48663175,0.40398648,0.31861021,0.22821725,0.12223588,-0.018703228,-0.073410552,-0.14625796,-0.25106373,-0.36997138,-0.4919827,-0.60725385,-0.71558724,-0.83067919,-0.93747033,-1.0488046,-1.1663161,-1.2710187,-1.3829297,-1.4835241,-1.602221,-1.7093253,-1.831945,-1.9520172,-1.999713,-1.9654322,-1.8578504,-1.737413,-1.6374309,-1.5199701,-1.3979411,-1.290645,-1.1823923,-1.0529287,-0.94578144,-0.82463905,-0.71542704,-0.59135919,-0.48614686,-0.37673636,-0.25438657,-0.15273526,-0.025563064,0.10760935,0.22141962,0.33516341,0.43014047,0.54956398,0.58205362,0.56889978,0.5375072,0.50048717,0.46576781,0.43579778,0.38970739,0.33361366,0.26180871,0.18710258,0.085692079,0.010134615,0.11003673,0.20608911,0.28078792,0.35762524,0.35170468,0.40769644,0.4004002:2
2.1855867,2.1390674,2.0895875,2.0097272,1.9294888,1.8480129,1.7942407,1.713674,1.6312428,1.576948,1.4961882,1.4143069,1.3604177,1.2781448,1.2231456,1.1417432,1.0764302,1.0056828,0.92429606,0.84368187,0.79949045,0.73868694,0.66005875,0.58242138,0.52875346,0.46218247,0.41064498,0.36166248,0.30291736,0.25744949,0.19546578,0.14879817,0.076697515,0.031812851,-0.019631491,-0.066041941,-0.11913119,-0.16071765,-0.20982411,-0.25107069,-0.29121303,-0.32681492,-0.36386441,-0.38624708,-0.4031204,-0.42007973,-0.42768292,-0.43513179,-0.44620002,-0.45550728,-0.45432116,-0.46093761,-0.46087508,-0.46784259,-0.46041057,-0.45654686,-0.4521609,-0.45352062,-0.43681652,-0.43961998,-0.41867052,-0.40711781,-0.40682439,-0.39553366,-0.3993629,-0.40240159,-0.40589674,-0.41781032,-0.42643788,-0.44264077,-0.46580801,-0.50688862,-0.55676608,-0.59259144,-0.64072631,-0.68670006,-0.72522846,-0.77270935,-0.82219635,-0.87103138,-0.89929151,-0.94187366,-0.99288338,-1.0458672,-1.1083865,-1.1667981,-1.2274627,-1.2849086,-1.341727,-1.4063783,-1.4658067,-1.5332302,-1.602251,-1.6442818,-1.6806428,-1.6581013,-1.6193382,-1.5713167,-1.5196384,-1.4429404,-1.364368,-1.312854,-1.2628394,-1.2335526,-1.1995272,-1.1571627,-1.1261529,-1.0869147,-1.0511562,-1.0138645,-0.97657903,-0.9466154,-0.91361084,-0.87901923,-0.84462021,-0.81683302,-0.79195741,-0.77235032,-0.75682856,-0.74008364,-0.73072115,-0.71171141,-0.67799116,-0.63767005,-0.60015899,-0.55915675,-0.52220118,-0.48715997,-0.46515432,-0.42532285,-0.39299056,-0.36652869,-0.3460377,-0.31638395,-0.30019073,-0.29839156,-0.28566576,-0.28527451,-0.28829507,-0.2956196,-0.29997267,-0.30891236,-0.32647195,-0.32573085,-0.33005485,-0.34083561,-0.33310191,-0.31142477,-0.314738,-0.31401812,-0.28874826,-0.25348943,-0.20088609,-0.14608588,-0.071714217,0.0035500964,0.076657727,0.12918777,0.20701967,0.28154162,0.3556584,0.4284633,0.50153466,0.56868536,0.61937629,0.66637172,0.73145235,0.77811907,0.8248307,0.86917903,0.9187258,0.95717523,0.99603846,1.0337201,1.0653744,1.1000204,1.1319858,1.1611059,1.1864499,1.2010121,1.2160045,1.2297563,1.2242009,1.2312876,1.2180851,1.1937997,1.1816855,1.1643309,1.1451564,1.1407751,1.1399765,1.1617077,1.1885025,1.2187866,1.2486065,1.2868765,1.3161961,1.3491385,1.3797814,1.4030457,1.4314066,1.4567033,1.4730608,1.4770891,1.4802594,1.4787316,1.4755113,1.4797261,1.4767849,1.4691214,1.4683228,1.4614392,1.4531935,1.4469602,1.447277,1.4522367,1.4550381,1.4631461,1.4702122,1.4838491,1.4845344,1.4877371,1.4900882,1.4932495,1.4828657,1.46081,1.4374452,1.4108076,1.37324,1.3183975,1.270528,1.2014828,1.1320379,1.0609263,0.99150428,0.91997002,0.86502239,0.80118983,0.74323034,0.74237055,0.77984353,0.79877135,0.81506788,0.82118913,0.82286072,0.81620595,0.81140277,0.7965865,0.76649106,0.74045871,0.69246926,0.66447386,0.62857157,0.58617305,0.53385335,0.47779773,0.41943784,0.3598121,0.3062982,0.24597939,0.19363477,0.13971354,0.083179517,0.030281203,-0.027535147,-0.087900825,-0.14493434,-0.19571707,-0.24830276,-0.30509862,-0.35741807,-0.40781685,-0.46999229,-0.50908608,-0.53362091,-0.56053109,-0.55867963,-0.5332516,-0.51382796,-0.51852679,-0.50415235,-0.49494245,-0.46973059,-0.45766369,-0.44195858,-0.42305104,-0.40351449,-0.39340818,-0.37533319,-0.36131937,-0.35152845,-0.34343727,-0.33869033,-0.33301179,-0.33815071,-0.3485909,-0.37014664,-0.39147193,-0.41408055,-0.44417477,-0.45760707,-0.47162438,-0.50188808,-0.53612891,-0.5743004,-0.62536356,-0.67570838,-0.72612282,-0.77668528,-0.82761724,-0.89252783,-0.95582845,-1.0071966,-1.0576442,-1.1308215,-1.1690893,-1.2355126,-1.2995992,-1.3441345,-1.3841541,-1.428086,-1.4816628,-1.5332932,-1.577941,-1.6482012,-1.6895033,-1.7276826,-1.7417969,-1.7465604,-1.7154114,-1.6806445,-1.6249293,-1.5678464,-1.5188182,-1.4635069,-1.4093089,-1.3540369,-1.288875,-1.2349485,-1.1725259,-1.1175546,-1.0807961,-1.0450893,-1.0197445,-0.99100374,-0.96479707,-0.94259112,-0.92682111,-0.91803468,-0.89720159,-0.89668063,-0.90425282,-0.91279192,-0.91836993,-0.93117677,-0.95372095,-0.99526406,-1.036329,-1.0792718,-1.1215925,-1.1711918,-1.2091214,-1.246542,-1.2761717,-1.2719997,-1.2484384,-1.197407,-1.1168787,-1.0613961,-1.0047103,-0.94822896,-0.89225951,-0.83531583,-0.78843816,-0.74015002,-0.68188632,-0.62309654,-0.54773409,-0.47946814,-0.43365162,-0.39577378,-0.35649205,-0.32021508,-0.28249961,-0.24556041,-0.2134205,-0.17950262,-0.14432868,-0.10994939,-0.070152731,-0.033075965,-0.0017969849,0.041032263,0.082172819,0.13053292,0.1760433,0.22347116,0.27999187,0.33629916,0.39330926,0.4490743,0.5045953,0.56314817,0.6417626,0.69828172,0.77854896,0.84706363,0.91504386,0.9970455,1.0513245,1.132571,1.2141133,1.270481,1.3499306,1.4314129,1.4856698,1.5669982,1.6481976,1.7215951,1.7829562,1.863327,1.943781,2.0246013,2.105581,2.1595364,2.1823681,2.1936539:2
2.5433069,2.43792,2.3384151,2.2125315,2.093182,1.9740061,1.8628929,1.7487476,1.7137979,1.5899848,1.4688255,1.4536129,1.3978386,1.2889479,1.1839488,1.0699771,1.0595058,0.99919642,0.89873543,0.78072407,0.68356048,0.56633114,0.56020187,0.5673644,0.4571235,0.35257363,0.24766782,0.14479488,0.063544583,-0.042756815,-0.078654998,-0.052717399,-0.0032278464,-0.10033266,-0.19947114,-0.30244659,-0.39442106,-0.49204995,-0.59189157,-0.68973742,-0.78651048,-0.89580904,-0.99946268,-1.0992567,-1.1924986,-1.2914191,-1.3941839,-1.4894298,-1.561277,-1.4428839,-1.3763704,-1.2669555,-1.1683914,-1.0984155,-0.99315568,-0.91449742,-0.81688431,-0.74561766,-0.6991079,-0.61295852,-0.51306438,-0.45310723,-0.36800351,-0.2951939,-0.15687974,-0.063496852,-0.042298468,-0.12716098,-0.22342306,-0.29914879,-0.40541565,-0.42248632,-0.52866569,-0.61076988,-0.62730292,-0.71019426,-0.80532922,-0.82621574,-0.89365747,-0.93823783,-0.96955033,-1.0536283,-1.1392607,-1.1757784,-1.283512,-1.3110594,-1.2474728,-1.1590497,-1.069315,-0.9645169,-0.84626047,-0.74053375,-0.65627573,-0.53624479,-0.41851499,-0.34517585,-0.23402606,-0.13817873,-0.051013653,0.053165185,0.16760388,0.2832083,0.35934433,0.47133603,0.58944753,0.67981408,0.77993832,0.89237107,1.0139346,1.1377178,1.156362,1.0903445,1.0076323,0.93391239,0.84061789,0.77959367,0.75608309,0.65645702,0.68235668,0.6301455,0.59753764,0.59796314,0.57199124,0.52129023,0.45347866,0.42229266,0.47634176,0.50319996,0.44960054,0.44655662,0.35621304,0.36822049,0.2865438,0.27271801,0.33816357,0.34379721,0.2996433,0.22198029,0.18412019,0.10075671,0.052727463,0.022434874,-0.060181071,-0.11639956,-0.19957738,-0.28869192,-0.36911165,-0.45763181,-0.54421163,-0.61191253,-0.68473529,-0.76876699,-0.8389852,-0.89817073,-0.95639018,-0.99992351,-1.0514291,-1.102362,-1.1427425,-1.1780498,-1.2025848,-1.1131741,-0.98561286,-0.84341244,-0.73338524,-0.59758279,-0.46356867,-0.32067306,-0.17786953,-0.035725537,0.075130995,0.19853349,0.34099752,0.46665947,0.60975935,0.75319361,0.89642418,1.0394508,1.1825382,1.3084653,1.4179658,1.3996874,1.3105016,1.2234783,1.1533287,1.0853517,1.137803,1.2181256,1.3054146,1.3795761,1.4620375,1.5464502,1.6030574,1.6168304,1.5994865,1.4820193,1.3848495,1.2811409,1.1890206,1.1144006,0.99237874,1.0690283,1.1450108,1.2189961,1.3298494,1.3597566,1.2163851,1.1163362,0.99907215,0.8908819,0.74927506,0.60613308,0.46417435,0.34343313,0.26660046,0.13991901,-0.0019402872,-0.14261846,-0.27918871,-0.40625225,-0.49095669,-0.61853935,-0.74649592,-0.88710773,-1.0269734,-1.1657054,-1.2709847,-1.3419938,-1.3886982,-1.4123088,-1.4344846,-1.4095054,-1.4220427,-1.391462,-1.3445962,-1.29033,-1.243731,-1.1750917,-1.1152585,-1.0370682,-0.96500661,-0.87703666,-0.78653133,-0.69443988,-0.5887139,-0.48576783,-0.40211673,-0.31638382,-0.22457896,-0.1031118,0.010397411,0.12310174,0.25367388,0.34080558,0.45535258,0.49156394,0.57169032,0.5455649,0.59878549,0.62066048,0.64370875,0.67235061,0.58876739,0.64992791,0.69745576,0.75559719,0.76395738,0.74036267,0.81025244,0.88210947,0.88732474,0.92587681,1.0128942,1.0144039,1.1189297,1.1621487,1.2419977,1.3018087,1.2381625,1.1266043,1.0239769,0.92138294,0.82859092,0.7687841,0.66183942,0.56652804,0.54687902,0.44814488,0.34498768,0.25447041,0.14185728,0.099046672,0.016759624,-0.11159599,-0.20157965,-0.28920494,-0.3880181,-0.48614431,-0.5829873,-0.65474924,-0.76438235,-0.87685915,-0.95623907,-1.0496538,-1.1348494,-1.2173846,-1.2947368,-1.3187942,-1.2268203,-1.1200962,-1.0487749,-1.0832833,-1.0132153,-0.91826486,-0.88925192,-0.79446696,-0.73233467,-0.69813696,-0.74072117,-0.66263063,-0.60909276,-0.50468733,-0.47052091,-0.48153519,-0.38528425,-0.29123055,-0.29059661,-0.18998852,-0.13316284,-0.053343386,0.037837947,-0.013009927,-0.1248394,-0.23940026,-0.29485287,-0.38987634,-0.4962484,-0.48984135,-0.58295535,-0.66120976,-0.77217177,-0.77075168,-0.8135204,-0.91213829,-0.99117282,-1.0948659,-1.1463248,-1.2490128,-1.3038218,-1.3649528,-1.4529857,-1.5469291,-1.6451332,-1.7382209,-1.8286761,-1.9254103,-2.0228735,-2.1190731,-2.1690803,-2.0642986,-1.99646,-1.9328566,-1.836044,-1.7230486,-1.6729544,-1.5729612,-1.4552192,-1.3508855,-1.278091,-1.1997276,-1.1082081,-0.98314879,-0.9579632,-0.89024462,-0.79695582,-0.71505336,-0.60046806,-0.53138977,-0.50483427,-0.40904912,-0.30363252,-0.2766036,-0.19384547,-0.13088219,-0.017427437,0.0047773633,-0.053081031,-0.1000922,-0.049404821,0.057210698,0.14964691,0.20229591,0.32847358,0.37233336,0.47513573,0.57090987,0.60080479,0.55337378,0.54343279,0.6027695,0.70616931,0.75119138,0.87255104,0.94879968,1.0423651,1.0716226,1.0365521,1.0676318,1.1470803,1.2283464,1.3247058,1.4001999,1.3570115,1.3945852,1.4869431,1.6026391,1.6083736,1.6671494,1.7698462,1.8246981,1.8843872,1.9950767,2.0681057,2.1687623,2.2711989,2.3659575,2.4733305:6
1.1556669,1.0201105,0.88572236,0.80147473,0.64743588,0.64636811,0.51686272,0.41126987,0.32381233,0.24814773,0.1515621,0.03435268,-0.095756893,-0.24285106,-0.41440324,-0.58738817,-0.80434109,-0.9813233,-1.0859095,-0.91101491,-0.73584053,-0.57109206,-0.42998478,-0.25403553,-0.091269013,0.01983873,0.17546155,0.3011212,0.46835872,0.53490567,0.68767045,0.8261332,1.0150398,1.0717003,1.2393795,1.3905025,1.5590062,1.7058443,1.8800273,1.7743559,1.6681062,1.5141381,1.385409,1.2749116,1.1365507,0.99746785,0.87797664,0.76379076,0.65924751,0.56889325,0.46014889,0.29359422,0.23349312,0.15330102,0.017743983,-0.056912304,-0.19015071,-0.35402005,-0.48389151,-0.59981145,-0.65850027,-0.81790792,-0.90683887,-0.79524056,-0.63737624,-0.48724557,-0.32230708,-0.15721286,-0.019902563,0.04763958,0.24251877,0.38297174,0.53590359,0.70672597,0.66014945,0.83120895,0.99000427,1.0591067,1.2921064,1.4700421,1.4311739,1.322533,1.1805663,1.0645265,0.94089388,0.86940394,0.77290196,0.72540845,0.72195288,0.62493908,0.55506059,0.44442406,0.31594841,0.13289631,0.06756872,-0.060047171,-0.11135621,-0.17972002,-0.15155173,-0.23591747,-0.34684568,-0.38499721,-0.44981891,-0.52216804,-0.53632879,-0.60216171,-0.67762825,-0.80471828,-0.93265887,-0.84731102,-0.76547167,-0.72356698,-0.65690487,-0.56153499,-0.40174207,-0.24792483,-0.053528436,0.10490174,0.31264797,0.50873207,0.72510438,0.72370703,0.64606954,0.58137534,0.57813,0.54033446,0.39656882,0.48449823,0.37013613,0.35204137,0.32059211,0.28644502,0.31025595,0.32393719,0.2455703,0.21123854,0.10615207,0.10266722,-0.027851436,-0.06198204,-0.16351233,-0.21662222,-0.31513996,-0.40884518,-0.47889328,-0.51851959,-0.6569517,-0.66321278,-0.70137477,-0.83847801,-0.94185218,-1.0352085,-1.0026933,-1.1146788,-1.0144006,-0.97142798,-0.83371963,-0.76617759,-0.59446595,-0.41737008,-0.25831273,-0.12248726,-0.11581514,-0.23769812,-0.26226862,-0.31456037,-0.38849107,-0.46577596,-0.41412061,-0.50005662,-0.60785625,-0.6476069,-0.76754347,-0.84207803,-0.7700671,-0.89207541,-0.9908,-1.0887437,-1.2069088,-1.2568446,-1.3320793,-1.4112933,-1.5092174,-1.6334907,-1.7197563,-1.8342347,-1.9377157,-2.0497743,-2.1827579,-2.3027683,-2.4619278,-2.6073606,-2.7777361,-2.7462354,-2.5471679,-2.3702007,-2.1777828,-1.9382345,-1.7470565,-1.5072508,-1.2686015,-1.0757242,-0.88415569,-0.64421903,-0.40682326,-0.2167391,0.022485704,0.25984068,0.4944314,0.68221434,0.7308386,0.96815753,1.2055586,1.4422643,1.6802037,1.9176407,2.1551927,2.3960387,2.5362751,2.6852766,2.8761009,2.9990822,2.8929056,2.7997578,2.6577271,2.4650065,2.2288538,1.9925958,1.7548896,1.5637418,1.3259729,1.1337042,0.89920584,0.7028359,0.46444748,0.27313375,0.036819282,-0.19920917,-0.41977714,-0.62597782,-0.86024126,-1.0980714,-1.2883832,-1.5234177,-1.7592137,-1.9500088,-2.1841764,-2.3768582,-2.5896275,-2.4479829,-2.3014953,-2.1334879,-2.0016045,-1.8624117,-1.7760476,-1.7289211,-1.6669839,-1.5295006,-1.3843066,-1.3208806,-1.2059108,-1.0839824,-1.0081109,-0.95912658,-1.0651067,-1.0099038,-0.85013919,-0.72607933,-0.54532499,-0.40610533,-0.32277026,-0.21324455,-0.26628413,-0.25360486,-0.21689396,-0.12253773,-0.01973741,0.047255798,0.043423681,-0.04669958,0.059861825,0.17152683,0.2234337,0.28712986,0.32845078,0.36459106,0.40414328,0.48006666,0.48580361,0.31675318,0.1430809,0.054709095,-0.11873447,-0.29311635,-0.44891332,-0.52563303,-0.43506458,-0.39083934,-0.32500649,-0.24213514,-0.1862458,-0.13555784,-0.16921893,-0.076627915,0.021458134,0.078743833,0.18612957,0.21784801,0.11569386,0.23127124,0.31180145,0.42106606,0.470798,0.49286725,0.5880848,0.68519666,0.68362327,0.72179791,0.81279525,0.90734574,1.0029736,1.117327,1.1571058,1.0176211,0.84907727,0.66282479,0.45025441,0.39078431,0.19921407,0.015036793,-0.02595061,-0.25563192,-0.36027419,-0.25042338,-0.16227194,-0.070546591,-0.018215535,0.079453309,0.16961932,0.25227961,0.18103747,0.16581428,0.29208002,0.37979555,0.49651389,0.52372605,0.58260694,0.68595506,0.78915003,0.90765867,1.0638739,0.95087554,0.76025885,0.6481153,0.56310835,0.43425102,0.26016957,0.12411349,-0.0047413455,-0.18848202,-0.36529065,-0.54499542,-0.70798338,-0.89372466,-1.0879577,-1.2655359,-1.1996771,-1.0236563,-0.87324326,-0.72822655,-0.54687129,-0.50204677,-0.35462861,-0.19615602,-0.085636916,0.030332609,0.19050118,0.046046649,0.17748782,0.30406833,0.43567158,0.50203854,0.67655842,0.71806127,0.61892037,0.7860606,0.89227931,1.0273018,1.0662741,1.2090579,1.3596408,1.4603055,1.5331631,1.4340133,1.2733517,1.1068455,0.96723556,0.80132136,0.66733618,0.52997803,0.36626726,0.28346988,0.19060018,0.10785594,-0.058108678,-0.22291405,-0.36603252,-0.52090129,-0.658436,-0.79531322,-0.90112817,-0.76175137,-0.58131213,-0.45782466,-0.3230419,-0.1448219,-0.13094364,0.05317676,0.13008722,0.27081167,0.43229733,0.44913876,0.63861998,0.73117823,0.88510179,1.0637653,1.1567299:1
1.267796,1.2211045,1.1740912,1.1071401,1.0408387,0.97382053,0.89699416,0.82340023,0.75327796,0.66514388,0.56326152,0.47705336,0.37261396,0.2802712,0.1815333,0.086568689,-0.026842576,-0.13325813,-0.25828448,-0.35280086,-0.47778101,-0.57211167,-0.69695925,-0.82188858,-0.91618899,-1.0410982,-1.1658534,-1.2905524,-1.3846244,-1.4019914,-1.3372608,-1.2514095,-1.1770393,-1.0840674,-0.99740137,-0.91663636,-0.83351733,-0.75041898,-0.6746752,-0.57629332,-0.49701993,-0.40372019,-0.32258558,-0.24112392,-0.14972409,-0.075186207,-2.0292549E-4,0.076711727,0.15427795,0.23241036,0.31051126,0.37871965,0.44404697,0.5111023,0.57002624,0.63518284,0.68902813,0.74857638,0.8195934,0.87199583,0.91220333,0.95209136,0.98076931,0.99514886,1.0261418,1.0884512,1.136315,1.1958393,1.2024167,1.2315918,1.2185787,1.1914372,1.1642604,1.122551,1.0781808,0.99987948,0.93798039,0.8551514,0.77042936,0.69449806,0.61300478,0.51044328,0.44078061,0.35776146,0.27388662,0.24936733,0.25140406,0.29253094,0.33995246,0.43929618,0.50011603,0.57065941,0.63340923,0.68294992,0.70277429,0.76914038,0.81687972,0.89405937,0.95762203,1.0119007,1.0555689,1.1037967,1.1174591,1.128843,1.1241798,1.1028718,1.0723855,1.0232535,0.9765948,0.93267064,0.87052538,0.81993879,0.72055213,0.64746623,0.57019157,0.49217838,0.4210129,0.34971353,0.27800901,0.19807564,0.10880588,0.034180966,-0.045415752,-0.14271227,-0.2181717,-0.30935071,-0.40696461,-0.50375784,-0.59919224,-0.66730158,-0.76351423,-0.85983936,-0.95575948,-1.0508319,-1.1577759,-1.2712974,-1.3658255,-1.4580752,-1.5228924,-1.6153761,-1.7075311,-1.7987261,-1.8998513,-1.9565792,-2.0372736,-2.1298112,-2.2179129,-2.2570962,-2.1924185,-2.0940761,-1.9962044,-1.950341,-1.8559017,-1.7756242,-1.6811257,-1.5916089,-1.5146519,-1.4245456,-1.3410755,-1.2663717,-1.1665862,-1.0894794,-0.98488633,-0.90436077,-0.81390425,-0.76241909,-0.74367758,-0.67691561,-0.60147661,-0.5502881,-0.4543142,-0.36478508,-0.28516563,-0.18292536,-0.093516083,-0.014751685,0.071033837,0.15389579,0.23794502,0.31505089,0.39610977,0.46910689,0.55078171,0.60887225,0.62715053,0.6522957,0.64981561,0.62147443,0.57330713,0.55538504,0.5405143,0.48705824,0.42897788,0.40161799,0.33012204,0.26379293,0.18605658,0.12388243,0.11169746,0.1087612,0.14069024,0.1879955,0.22596155,0.2310902,0.21879339,0.16215391,0.13949405,0.068432954,0.0020551766,-0.043377497,-0.13425523,-0.16614277,-0.20890016,-0.27352102,-0.32433662,-0.37640724,-0.43322401,-0.45731948,-0.51541846,-0.57442032,-0.58648816,-0.65939688,-0.67750615,-0.74461426,-0.80113235,-0.84484541,-0.88181603,-0.92173818,-0.94835967,-0.98622545,-1.0028275,-1.0286129,-1.0251859,-1.036242,-1.052805,-1.0454438,-1.0087638,-0.95809564,-0.89247921,-0.83723028,-0.72563047,-0.64018883,-0.55096066,-0.46127474,-0.34352883,-0.25061587,-0.12948621,-0.0045976438,0.058990692,0.15428624,0.2520763,0.34966009,0.44963324,0.52858615,0.61275155,0.67741591,0.7193281,0.73691916,0.76245549,0.76597613,0.76543386,0.74142139,0.73065003,0.71969228,0.71693229,0.67752917,0.65509047,0.62823608,0.60252005,0.56668542,0.54557005,0.5769384,0.63922886,0.70039722,0.74985862,0.80393991,0.83608997,0.90359189,0.93261866,0.90346644,0.94753513,1.0049806,1.0504482,1.0843584,1.1223127,1.1489299,1.1667902,1.194621,1.2217358,1.2346954,1.3255995,1.4127285,1.4917571,1.6002289,1.6879299,1.7704221,1.8759048,1.934751,1.9747006,1.9542459,1.9119743,1.806033,1.7529419,1.6580167,1.5756241,1.4856254,1.3957787,1.3208367,1.2783642,1.2519137,1.2403828,1.2335694,1.2180801,1.1825982,1.1595623,1.138464,1.1025065,1.0680461,1.027076,0.96638915,0.91903257,0.85441465,0.81916477,0.77144113,0.72521296,0.69072832,0.6733293,0.6501573,0.6222412,0.59552208,0.56874147,0.54823696,0.52362205,0.49676925,0.46555056,0.44110163,0.40421849,0.36021147,0.31874783,0.26146208,0.2011962,0.11265174,0.015575176,-0.082830599,-0.18127661,-0.24518245,-0.28237653,-0.34941747,-0.41778467,-0.49871001,-0.54974808,-0.61380103,-0.67354988,-0.72594222,-0.7879672,-0.87270585,-0.93602741,-1.0205588,-1.1093039,-1.1396734,-1.193701,-1.2488818,-1.3216545,-1.4092657,-1.4309148,-1.4958307,-1.5609914,-1.6287279,-1.69916,-1.7667028,-1.8311145,-1.8966732,-1.9614506,-2.0188833,-2.0654166,-2.095103,-2.1000313,-2.1041822,-2.0988712,-2.0770579,-2.0293572,-1.9515006,-1.8728478,-1.8164117,-1.7778132,-1.7329752,-1.6494671,-1.5644463,-1.4822247,-1.4013161,-1.3291007,-1.2369578,-1.1502948,-1.0649103,-0.98860499,-0.88835974,-0.80616421,-0.70674902,-0.60816274,-0.51415606,-0.41102403,-0.31268784,-0.22049648,-0.14961619,-0.082345952,-0.009162526,0.086419746,0.15860036,0.26221906,0.33140363,0.40365478,0.46876484,0.51071028,0.54401082,0.5883966,0.6656765,0.77472557,0.85100948,0.93635855,1.0075834,1.065344,1.1381161,1.1849315,1.2266997,1.2635313,1.2910986,1.3031831:2
0.60317821,0.53733446,0.45178962,0.39196162,0.31494548,0.24605246,0.18986767,0.12698273,0.057675493,-0.0085529873,-0.10797651,-0.19052853,-0.28996773,-0.39854047,-0.50139783,-0.58391046,-0.64807112,-0.71612154,-0.78858535,-0.85083538,-0.91814417,-0.9910328,-1.0818612,-1.160691,-1.2529221,-1.2958113,-1.297936,-1.2642271,-1.2984683,-1.2693649,-1.2557505,-1.2457159,-1.2163829,-1.263499,-1.3165197,-1.3819619,-1.4036334,-1.3529427,-1.2915831,-1.2439728,-1.2078338,-1.1645146,-1.1016801,-1.0506001,-0.97984896,-0.90944332,-0.8564959,-0.77336035,-0.69681841,-0.63433719,-0.56842145,-0.51009417,-0.45854566,-0.40322055,-0.32404617,-0.32493025,-0.2892184,-0.32510171,-0.30517844,-0.28507412,-0.27238625,-0.2190999,-0.18629997,-0.12388703,-0.063145344,-0.024134252,0.02450137,0.068169173,0.089524151,0.12026041,0.12907627,0.13386309,0.12250428,0.081314699,0.011474511,-0.073586635,-0.14583184,-0.18996785,-0.27408163,-0.36717826,-0.45616737,-0.5390987,-0.62225164,-0.69902282,-0.79652044,-0.87419922,-0.95836801,-0.99648241,-1.0206147,-1.0264935,-0.98145918,-0.94504216,-0.88421683,-0.85891227,-0.82746692,-0.77057834,-0.71396285,-0.64258251,-0.56425335,-0.49268138,-0.42278119,-0.3437439,-0.27721991,-0.19645152,-0.12620575,-0.070355147,-0.0022029822,0.058000451,0.12648877,0.19003895,0.25165213,0.32561448,0.38320458,0.44765467,0.50457391,0.58638667,0.63789686,0.7062327,0.76072209,0.81283094,0.86204142,0.92224511,0.97531934,1.0273641,1.0794904,1.1273501,1.1726353,1.2224726,1.2408371,1.2416971,1.2316322,1.1857856,1.1421769,1.0995999,1.0321575,0.96550766,0.97820381,0.91696567,0.88234701,0.96076842,0.85370059,0.77590126,0.69200082,0.6725604,0.62525258,0.65512463,0.68972478,0.75091626,0.82374035,0.8995424,0.97643882,1.0569007,1.1209234,1.1831365,1.2525527,1.3202882,1.3856493,1.4600156,1.5321435,1.5895476,1.6505475,1.7158266,1.7654201,1.7686095,1.7929974,1.7896017,1.7346097,1.7398133,1.6470034,1.6238652,1.5626036,1.4932694,1.43563,1.3371727,1.2510297,1.142272,1.0306495,0.93103602,0.8750669,0.81787887,0.81645679,0.84001634,0.87458815,0.89883732,0.91906676,0.97420285,1.041034,1.0833405,1.1156707,1.1505077,1.1828969,1.1847343,1.1560586,1.1525269,1.1274612,1.0604399,0.98765692,0.95418884,0.86674674,0.79636121,0.72616186,0.641153,0.57449985,0.48723604,0.41484695,0.34463214,0.26072881,0.18466816,0.10963306,0.026550023,-0.041705325,-0.11705183,-0.18394649,-0.25487575,-0.33653696,-0.41651665,-0.48387075,-0.56770067,-0.64203045,-0.72262819,-0.79843843,-0.88530143,-0.96519485,-1.0610773,-1.1369578,-1.2219803,-1.3045111,-1.3771192,-1.4630555,-1.5413089,-1.6150578,-1.6913302,-1.769115,-1.8520745,-1.9294711,-2.0132447,-1.9883125,-1.9231795,-1.8401526,-1.7604794,-1.6770162,-1.5810439,-1.4707068,-1.3744882,-1.2771226,-1.1876574,-1.1034543,-1.020293,-0.93518357,-0.8420107,-0.76685669,-0.70487762,-0.6193723,-0.54697124,-0.48852427,-0.43357635,-0.37502437,-0.31755462,-0.25313484,-0.19547573,-0.1800205,-0.14158731,-0.096561489,-0.086606128,-0.079906697,-0.08092509,-0.099716814,-0.11486142,-0.13525831,-0.1646596,-0.18989457,-0.22183366,-0.26308697,-0.29069438,-0.31563427,-0.33180014,-0.37273814,-0.40527443,-0.43521922,-0.46596203,-0.50696073,-0.55693125,-0.59866741,-0.64014771,-0.6942735,-0.73867143,-0.80236193,-0.87121423,-0.92577314,-0.99644509,-1.0698147,-1.107509,-1.1394299,-1.168983,-1.2280002,-1.297797,-1.3701244,-1.4416047,-1.5037856,-1.5720844,-1.6479022,-1.7023363,-1.7733178,-1.8328227,-1.9025648,-1.9503722,-1.9830081,-1.9968503,-1.9600002,-1.9077856,-1.8539602,-1.8458612,-1.7719745,-1.7579031,-1.704445,-1.6208896,-1.5368203,-1.4460661,-1.3550261,-1.2394,-1.118728,-1.011519,-0.93222593,-0.86393388,-0.74941465,-0.67123501,-0.5925473,-0.53412246,-0.47832506,-0.43910905,-0.40726148,-0.38576583,-0.38448543,-0.37987745,-0.36888622,-0.36160066,-0.32891124,-0.28908076,-0.24886921,-0.20586889,-0.16046298,-0.11318107,-0.065508402,-0.02104555,0.012741293,0.056596924,0.093654297,0.13686184,0.17720616,0.23673071,0.27858419,0.32099542,0.35946701,0.38027556,0.41525205,0.43234904,0.44789968,0.48892385,0.54474915,0.60840452,0.6922602,0.77863804,0.86366692,0.92409529,0.98752706,1.0432439,1.1008616,1.1319501,1.1525823,1.1458003,1.1753973,1.1804027,1.2437529,1.2563103,1.2603114,1.3528932,1.3652641,1.3519011,1.3412614,1.2919153,1.2747706,1.2182261,1.165669,1.0945273,1.0186442,1.0529278,1.1435786,1.2070499,1.2697536,1.3226735,1.3686085,1.4147839,1.4387302,1.4631216,1.4699726,1.4714325,1.4572767,1.4496068,1.4390191,1.4616994,1.410479,1.357373,1.2846598,1.2007498,1.1189576,1.0276516,0.9659913,0.85293313,0.80151863,0.84000351,0.88311211,0.92725339,0.94269625,0.95966941,0.95718498,0.97205246,0.96558638,0.96203993,0.94159816,0.91046081,0.89136563,0.88691504,0.84926,0.81152798,0.75811623,0.69953242,0.63954489:2
1.369025,1.2784072,1.1886911,1.0989039,1.0277653,0.95842894,0.89728785,0.83379411,0.74244995,0.67432681,0.60770946,0.71255354,0.70349915,0.63394341,0.56587385,0.47531666,0.42368452,0.34731215,0.35280979,0.32779445,0.29344542,0.20368412,0.12784242,0.048688406,-0.018663661,-0.046635357,0.052209765,0.17277179,0.26414816,0.2642107,0.22644968,0.20676806,0.14149248,0.062037239,0.0076886496,-0.033656375,-0.12160316,-0.17909805,-0.18624887,-0.10133633,-0.15208789,-0.18866657,-0.23269261,-0.30251394,-0.33779101,-0.38080337,-0.43487743,-0.53079813,-0.6102721,-0.68504167,-0.68489015,-0.56417019,-0.44564466,-0.32533514,-0.20987174,-0.088250755,0.0058196288,0.010360975,-0.033903081,-0.076324418,-0.11926881,-0.16245328,-0.16360568,-0.20851976,-0.24725438,-0.28371508,-0.22073066,-0.19674361,-0.23406002,-0.29577763,-0.37418845,-0.41094166,-0.46618491,-0.50144146,-0.53211167,-0.43565002,-0.40074286,-0.44820488,-0.51620529,-0.60617688,-0.69219174,-0.79763408,-0.88664423,-0.96516385,-1.0353002,-1.1427319,-1.2388812,-1.3343812,-1.3860523,-1.4138169,-1.4572743,-1.48769,-1.5227236,-1.5598244,-1.5939983,-1.589506,-1.6054299,-1.5530192,-1.4607185,-1.3445218,-1.2279512,-1.0964118,-0.96903955,-0.83495988,-0.70707273,-0.57608687,-0.42448185,-0.32032003,-0.23405346,-0.10902867,0.058790158,0.12389033,0.25183287,0.39426536,0.52298429,0.652673,0.81605944,0.98234488,1.1485645,1.0989546,1.1859184,1.3470524,1.5120737,1.5921819,1.6812993,1.8453472,2.013736,2.177245,2.3048525,2.4506246,2.5792066,2.67672,2.8070008,2.8642015,2.878721,2.8203177,2.6673617,2.5673019,2.4694619,2.3677513,2.2410286,2.1532136,2.040541,1.8772463,1.7108887,1.5872497,1.4194598,1.2534885,1.1302475,0.97037526,0.83489147,0.69606186,0.58026202,0.41541611,0.27169031,0.15712122,-0.0098884021,-0.14171427,-0.25008385,-0.38262802,-0.33015974,-0.4634699,-0.54219954,-0.6772667,-0.845248,-0.97022504,-1.0987811,-1.2284889,-1.3863249,-1.4977254,-1.5939224,-1.6304646,-1.5623661,-1.5463149,-1.5117119,-1.4575165,-1.4313076,-1.4032435,-1.3771314,-1.3545607,-1.3155566,-1.2860057,-1.268852,-1.2198236,-1.1928956,-1.1893552,-1.1430929,-1.1002546,-1.0710442,-1.0664792,-1.006253,-0.92464382,-0.84599846,-0.76358257,-0.64065825,-0.61216733,-0.54550646,-0.5472331,-0.52841162,-0.46701331,-0.39414689,-0.3288665,-0.25367571,-0.21596654,-0.25600417,-0.35962227,-0.35877259,-0.29212338,-0.23417586,-0.20171407,-0.17715097,-0.14556895,-0.080485643,-0.047756575,-0.080263432,-0.15361316,-0.27134004,-0.3997139,-0.52891721,-0.63209568,-0.77268661,-0.90195744,-0.99670582,-0.95434158,-0.91508753,-0.84381925,-0.80970262,-0.7294968,-0.68919475,-0.63107158,-0.56938785,-0.48994089,-0.44334613,-0.47721093,-0.53377098,-0.58439006,-0.49167211,-0.39111992,-0.33385022,-0.22802071,-0.1487499,-0.043985066,-0.037595824,0.067869671,0.093272914,0.077352546,0.039513035,-0.058880671,-0.20745068,-0.17411369,-0.070964066,0.045792769,0.14605565,0.24162138,0.2101803,0.25964183,0.36573987,0.46369439,0.59227177,0.68690411,0.67109073,0.66374924,0.74779079,0.8665842,0.97494112,1.0749095,1.0762554,1.2061177,1.3246273,1.4409952,1.557119,1.6769251,1.7367263,1.6636347,1.5409946,1.4323728,1.3169618,1.1943216,1.0808015,0.96149719,0.83933261,0.80455405,0.69174904,0.56213595,0.45735746,0.33716017,0.22131106,0.10085239,-0.0022544958,0.028790954,0.018172137,-0.073417746,-0.19098626,-0.31210449,-0.43057641,-0.51988119,-0.65038787,-0.7555227,-0.86619314,-0.97892562,-1.0809724,-1.1946798,-1.309692,-1.4033887,-1.524305,-1.6395519,-1.7528054,-1.8604216,-1.9430634,-1.8469997,-1.7600574,-1.654672,-1.5261005,-1.4464574,-1.3671116,-1.3132717,-1.2545047,-1.1629548,-1.0963607,-1.0366114,-0.96522907,-0.84532194,-0.67950851,-0.51379366,-0.41690279,-0.421798,-0.31738542,-0.22667797,-0.12416759,-0.03344965,0.043144172,0.094638415,0.16454551,0.22704357,0.23406072,0.14358072,0.02821464,-0.051638237,-0.081558054,0.03185848,0.12903672,0.24100681,0.35473901,0.4246509,0.40172757,0.52354473,0.61919062,0.71774349,0.82005088,0.914641,0.98697028,1.1313791,1.2455092,1.3563782,1.4864574,1.5919042,1.7058256,1.8339474,1.8693802,1.8146223,1.7524205,1.651971,1.5310925,1.4196461,1.3807654,1.2612784,1.1146778,0.99947008,0.92891583,0.87615676,0.94144893,0.86231476,0.76864927,0.62151222,0.48308855,0.35517189,0.2685087,0.14662107,0.16620588,0.25912189,0.35673054,0.33954483,0.26141208,0.15157728,0.046530252,-0.074431339,-0.19348502,-0.25651672,-0.37113382,-0.48464098,-0.53911449,-0.62966889,-0.5591839,-0.6371315,-0.69848078,-0.80430977,-0.91445821,-1.0187563,-1.1214953,-1.1857078,-1.2640216,-1.3332342,-1.3844512,-1.3134158,-1.1653921,-1.0428813,-0.91643207,-0.7659246,-0.63448044,-0.47620348,-0.355424,-0.20330655,-0.15575373,-0.19327667,-0.052326003,0.074581398,0.20493772,0.33239828,0.4661717,0.61557097,0.67180993,0.75386431,0.8864352,1.0403872,1.1781399,1.3395698,1.3974788:3
2.46462,2.3721087,2.322358,2.2320135,2.1751475,2.0956829,2.0081377,1.8895106,1.8137727,1.7485866,1.6629568,1.5764515,1.4941816,1.4191674,1.3569866,1.2586671,1.2094083,1.1421025,1.0599032,0.98955151,0.89884372,0.81694319,0.76303737,0.73335048,0.64811065,0.59877338,0.51409205,0.42312667,0.37711878,0.28362342,0.25644166,0.23204731,0.17172737,0.11390768,0.038074401,-0.037549997,-0.099841765,-0.17113787,-0.24277649,-0.31680764,-0.34760455,-0.31295781,-0.36248115,-0.43446438,-0.48278288,-0.59131714,-0.64545477,-0.65659419,-0.7360885,-0.83666198,-0.933162,-0.92079296,-0.87267466,-0.88474939,-0.80881832,-0.72590884,-0.64233288,-0.55135937,-0.53283547,-0.45462805,-0.39307286,-0.42637271,-0.47851906,-0.4748247,-0.54830554,-0.63528393,-0.63029608,-0.67110242,-0.73810153,-0.82222275,-0.88889364,-0.89219179,-0.9117118,-0.95978065,-1.0260826,-1.0742009,-1.1008664,-1.156014,-1.2053212,-1.2354121,-1.2905444,-1.3403289,-1.3834554,-1.4054483,-1.4486997,-1.4025195,-1.3581679,-1.2964703,-1.2184914,-1.1566832,-1.0876925,-1.030139,-0.91180822,-0.82683421,-0.71953518,-0.66371744,-0.58137045,-0.5185675,-0.43149814,-0.3539019,-0.29371482,-0.21470112,-0.17065733,-0.089117146,-0.0056000092,0.045260186,0.072836706,0.1555446,0.23861559,0.32252787,0.40788419,0.46912407,0.52682416,0.61059179,0.68698438,0.77998944,0.88152551,0.98712085,1.0363035,1.0184942,1.0083852,0.96938076,0.9061857,0.89425216,0.84973696,0.79169592,0.75281206,0.74823758,0.70902147,0.67385224,0.62413494,0.5877915,0.59175675,0.62668898,0.59025528,0.54904346,0.50354851,0.52402233,0.48578467,0.41935007,0.36118641,0.37178336,0.38884967,0.43434484,0.37275561,0.29126813,0.17349525,0.06692711,-0.04169787,-0.14898665,-0.25332472,-0.32089877,-0.41713002,-0.50449577,-0.5491527,-0.6087022,-0.69632172,-0.78585497,-0.84903288,-0.9301731,-0.96436751,-1.0415283,-1.1175816,-1.1622519,-1.2277323,-1.3015363,-1.334652,-1.3328294,-1.3796048,-1.3491822,-1.2939712,-1.259088,-1.2084512,-1.1342908,-1.0388267,-0.95631993,-0.83866131,-0.7179606,-0.59805864,-0.51488889,-0.47566597,-0.35388206,-0.23095489,-0.147757,-0.024880581,0.096899977,0.17926531,0.30261726,0.40192993,0.51030813,0.59573517,0.71650378,0.7884405,0.87833325,1.000948,1.0835083,1.207687,1.3259651,1.4114567,1.5351566,1.6552595,1.7251976,1.7780779,1.8504355,1.9270158,1.9505938,2.0099874,1.9640598,1.9124362,1.826868,1.7461511,1.6978725,1.7033345,1.6200152,1.5415291,1.4771199,1.3956414,1.3597547,1.3171727,1.2325871,1.1366688,1.0530181,0.93023121,0.80707635,0.70876714,0.60086932,0.47656757,0.39309969,0.3056996,0.22903841,0.10795687,0.022260101,-0.099047877,-0.21464817,-0.30842939,-0.36957499,-0.43763718,-0.55469397,-0.67759258,-0.76733556,-0.88520578,-0.95063479,-1.0155042,-1.1333466,-1.2179973,-1.3048077,-1.350608,-1.4072825,-1.4058223,-1.4880473,-1.4193224,-1.412912,-1.4440649,-1.3893332,-1.3484945,-1.2949948,-1.2395011,-1.2448193,-1.3261716,-1.369665,-1.3325689,-1.2733004,-1.2144575,-1.134783,-1.0785467,-1.0532476,-0.98057847,-0.89987359,-0.81728758,-0.7785377,-0.72182222,-0.63258129,-0.54320112,-0.46261785,-0.38040899,-0.27945324,-0.21021169,-0.15048903,-0.058932857,0.018492614,0.12851488,0.20362362,0.31580971,0.39098141,0.41026626,0.49113737,0.54132825,0.48997527,0.57707017,0.63664584,0.73579295,0.69935556,0.74515001,0.85018834,0.87687232,0.96593201,1.0081414,1.0387961,1.0966423,1.0674877,0.94427744,0.87957449,0.81216937,0.7580375,0.65332415,0.60256963,0.52900715,0.41187996,0.31730472,0.26036446,0.18609813,0.1398666,0.063976784,-0.031748074,-0.13760371,-0.23337297,-0.22994396,-0.32994593,-0.44886881,-0.54041527,-0.63691107,-0.71567257,-0.78700371,-0.87124844,-0.98909854,-1.0615918,-1.1333999,-1.2316358,-1.2949396,-1.3600898,-1.4801723,-1.5870092,-1.5482865,-1.4759291,-1.4565846,-1.4912047,-1.4132307,-1.3395788,-1.3464277,-1.3101472,-1.2392457,-1.1692415,-1.2147425,-1.2588906,-1.1680093,-1.0899121,-1.1141712,-1.0355527,-0.95060399,-0.92347672,-0.92458469,-0.84274152,-0.77224845,-0.76588136,-0.71695567,-0.65071225,-0.68389593,-0.76767173,-0.80396869,-0.81735931,-0.92635853,-1.031111,-1.0225354,-0.94759989,-0.86898213,-0.78813998,-0.70279175,-0.68008009,-0.68750113,-0.6628975,-0.57067459,-0.48905813,-0.40314671,-0.36409757,-0.39921448,-0.33196422,-0.29037454,-0.22077923,-0.25406875,-0.24496132,-0.31448047,-0.32475126,-0.25155386,-0.15887655,-0.068893554,-0.020584333,-0.02164187,0.04664538,0.1295355,0.23026377,0.22312888,0.2650836,0.35910738,0.33047161,0.30091713,0.35850118,0.44207483,0.50015399,0.50479477,0.59151887,0.66021894,0.72421554,0.71885219,0.83466523,0.92323162,0.97545983,1.0031203,1.0878645,1.2024793,1.2229843,1.2068388,1.2780029,1.3632665,1.4125868,1.4215449,1.5095685,1.6257,1.6299541,1.6841636,1.8066017,1.9234926,1.9501766,2.0345646,2.1563371,2.2318876,2.3517961,2.4679088:6
2.1686493,2.0675835,1.9682861,1.8753848,1.7902002,1.6947733,1.5949638,1.5050727,1.4205263,1.3228668,1.2269989,1.1385741,1.049627,0.94820709,0.85780719,0.77185569,0.67480979,0.58144215,0.4706726,0.37186245,0.35009147,0.40861889,0.48241612,0.54974549,0.62175883,0.65798353,0.69537899,0.71846577,0.74359791,0.74881131,0.75492598,0.76924727,0.77498628,0.77388108,0.76006345,0.75544421,0.76408813,0.75548224,0.74021722,0.73796698,0.72180908,0.71096644,0.71098904,0.7134077,0.71788424,0.71499478,0.70578001,0.69107236,0.6698006,0.6471628,0.62655646,0.60537686,0.58692405,0.57058348,0.56455996,0.54946331,0.55823429,0.56799328,0.57430749,0.5609397,0.51826694,0.50268865,0.47518819,0.42860395,0.37928422,0.3099291,0.25342851,0.19113425,0.13310017,0.074590279,0.0057844832,-0.071362164,-0.17431488,-0.25898739,-0.33762494,-0.39507675,-0.45990074,-0.51953404,-0.57044234,-0.61822756,-0.66851802,-0.7033718,-0.73349613,-0.75640974,-0.78224379,-0.80449925,-0.83035818,-0.84368116,-0.85176791,-0.85147564,-0.8373061,-0.81173174,-0.77993305,-0.74014902,-0.70033843,-0.66274396,-0.63335358,-0.60736395,-0.55587828,-0.49921693,-0.4348094,-0.38472359,-0.45647866,-0.51959902,-0.59970597,-0.67640717,-0.75518063,-0.83730339,-0.92009394,-0.99706265,-1.0912288,-1.1789694,-1.2777688,-1.3615308,-1.4694922,-1.5782239,-1.6105045,-1.6246416,-1.6527833,-1.6561065,-1.6650779,-1.6640061,-1.6633781,-1.6588885,-1.651064,-1.6319455,-1.6050354,-1.5758824,-1.531301,-1.4748623,-1.4117466,-1.3408813,-1.2394807,-1.134708,-1.036932,-0.95250105,-0.84345985,-0.75397272,-0.68918596,-0.59198579,-0.50118653,-0.40433475,-0.30925438,-0.22473472,-0.11071725,0.0062171002,0.11559042,0.21478801,0.1192225,0.020392883,-0.06549114,-0.16354999,-0.25720689,-0.35228526,-0.44134323,-0.54106437,-0.6403309,-0.72479582,-0.81214249,-0.88576189,-0.98336607,-1.0624798,-1.1332194,-1.2072633,-1.2698504,-1.3043092,-1.3138733,-1.2871051,-1.2541093,-1.2070066,-1.1603237,-1.0890807,-1.0218644,-0.94976713,-0.87953046,-0.79993338,-0.70673727,-0.63197973,-0.5433049,-0.4585822,-0.38584378,-0.30645287,-0.22253163,-0.13288298,-0.043374243,0.042084657,0.11859595,0.19986789,0.2938014,0.37233993,0.46698804,0.54810518,0.64303552,0.72681266,0.80475939,0.90356181,0.98679687,1.0790843,1.1777918,1.266514,1.3535025,1.452722,1.5139576,1.4104609,1.2983355,1.2113595,1.1195158,1.0644673,1.0268936,1.0484621,1.1156906,1.194081,1.2695655,1.352217,1.4335402,1.5105028,1.5916729,1.6713953,1.7465719,1.8324954,1.9205493,2.0067221,2.084384,2.1509412,2.1699326,2.0780146,2.0212108,2.0719659,1.9844505,1.8899586,1.7947645,1.6988535,1.6059156,1.5191733,1.408231,1.3200456,1.228425,1.1342381,1.0349316,0.93881746,0.85441015,0.75661652,0.69280371,0.63548347,0.59776516,0.58209612,0.59029634,0.62580985,0.6914147,0.75541174,0.81850404,0.90930266,0.9960539,1.0892995,1.1042025,1.0213339,0.93373834,0.85224811,0.76050887,0.72175025,0.68130277,0.59371969,0.51303471,0.41879199,0.33396244,0.25138418,0.16681646,0.078624287,-0.0030426652,-0.090410133,-0.17753428,-0.24739453,-0.33856256,-0.42057787,-0.49731699,-0.58346629,-0.66775653,-0.75448278,-0.8311412,-0.91752771,-0.98680366,-1.0701577,-1.1469769,-1.2214107,-1.3039458,-1.3794947,-1.452866,-1.5229269,-1.5969851,-1.649251,-1.6941514,-1.732964,-1.7428051,-1.7540503,-1.7526959,-1.7368243,-1.6896813,-1.630543,-1.5601383,-1.4841994,-1.4124971,-1.3223761,-1.2470721,-1.1490174,-1.0563062,-0.95742605,-0.86194893,-0.74201813,-0.62307864,-0.53160458,-0.41333543,-0.31410579,-0.22502292,-0.12618973,-0.016484738,-0.083581247,-0.15420609,-0.22805105,-0.28368408,-0.33910019,-0.3867108,-0.35314922,-0.40492426,-0.46125575,-0.52324115,-0.5798285,-0.65493156,-0.69953801,-0.74080493,-0.7585141,-0.69659636,-0.61887683,-0.59371737,-0.70074731,-0.77459008,-0.83701209,-0.89742019,-0.95160894,-1.0014198,-1.0500544,-1.0992271,-1.131088,-1.1744767,-1.2116009,-1.257713,-1.2941212,-1.309663,-1.3190535,-1.3202009,-1.3170843,-1.3178382,-1.3096621,-1.29572,-1.2741554,-1.2365578,-1.1785013,-1.1185054,-1.0396416,-0.92743136,-0.82223381,-0.72778882,-0.64972467,-0.57281567,-0.49479401,-0.40874656,-0.33558493,-0.2617934,-0.18031917,-0.10036699,-0.021706092,0.073871283,0.14198853,0.20597655,0.20246294,0.18094879,0.16153275,0.13828117,0.12330255,0.098698437,0.097370417,0.10277894,0.12230176,0.13209274,0.1482849,0.16808648,0.18982399,0.20632926,0.23357935,0.26556086,0.30057545,0.33439841,0.36149048,0.38658491,0.41513949,0.4374044,0.46062821,0.48554056,0.50514824,0.51199168,0.51327468,0.5035452,0.48172139,0.44543243,0.42482183,0.40380629,0.38213545,0.39200452,0.47307179,0.545841,0.61217882,0.70821888,0.79428476,0.88518926,0.98313597,1.0691803,1.1613604,1.2597663,1.3447804,1.434584,1.5356057,1.6298712,1.7084752,1.7724645,1.8618688,1.949001,2.0512866,2.1302465:4
2.440555,2.4620559,2.4106147,2.3226001,2.2236189,2.1161158,2.018979,1.9272048,1.8292391,1.7339825,1.6446189,1.5715736,1.47542,1.3842695,1.3068233,1.2518799,1.1595223,1.0932657,1.026666,0.9370883,0.84438224,0.75246131,0.65545097,0.56658011,0.47302454,0.38212641,0.30833207,0.22219367,0.12432604,0.030256393,-0.068119606,-0.16277653,-0.25591968,-0.3572889,-0.45202902,-0.54550917,-0.64619981,-0.74237077,-0.83480421,-0.93132659,-1.0268536,-1.123097,-1.2269277,-1.3295697,-1.4227131,-1.5228438,-1.6053628,-1.6800992,-1.7749122,-1.869448,-1.9105608,-1.8757588,-1.8307097,-1.789183,-1.7635445,-1.7532398,-1.7362952,-1.6861742,-1.5989516,-1.545479,-1.4566858,-1.4889303,-1.3848522,-1.2709865,-1.180126,-1.1035113,-1.0429645,-0.99642793,-0.95882906,-0.91128217,-0.80110354,-0.69351241,-0.59133309,-0.48446376,-0.40046329,-0.36907294,-0.2921401,-0.19818541,-0.11313919,-0.034775973,0.0446284,0.14073696,0.2242259,0.30555962,0.39046857,0.45957244,0.399478,0.26393792,0.14121048,0.024771196,-0.075641028,-0.17057897,-0.25015698,-0.35080683,-0.44364138,-0.52802715,-0.60652111,-0.70365425,-0.81386241,-0.92941654,-1.0075674,-1.0255965,-1.1111693,-1.1372677,-1.1923763,-1.1703448,-1.0880724,-1.0064748,-0.9282879,-0.84476886,-0.75669746,-0.67082242,-0.5838476,-0.48675438,-0.39386928,-0.29947199,-0.19453089,-0.10070698,-0.0058408576,0.086105772,0.17549769,0.26756888,0.36166022,0.45804963,0.54770753,0.646357,0.73935953,0.70899067,0.62366411,0.52085384,0.42744225,0.34045883,0.35255572,0.38627299,0.48958581,0.59156312,0.69755333,0.77825204,0.83752369,0.84225711,0.93484106,0.97829509,1.0733873,1.1703768,1.2511553,1.2132743,1.1344121,1.0480571,0.96278827,0.89104048,0.85937644,0.77080652,0.67971656,0.59233034,0.50204235,0.45807921,0.48901514,0.50240135,0.41650528,0.32307501,0.22742515,0.13997111,0.045799541,-0.050138866,-0.15391355,-0.255766,-0.35713934,-0.46050429,-0.55586463,-0.66234384,-0.76216762,-0.86915851,-0.9724962,-1.0791152,-1.1739842,-1.2639151,-1.3442414,-1.4184581,-1.3520958,-1.3165072,-1.2152008,-1.1144583,-1.0283933,-0.91895568,-0.82687575,-0.72514221,-0.63921074,-0.51544169,-0.4040752,-0.30315981,-0.2039768,-0.092753725,-0.0030353534,0.098197367,0.19943183,0.31163373,0.40550658,0.49272939,0.58570718,0.68777508,0.77996555,0.84557327,0.81262553,0.76482764,0.72719692,0.71230474,0.77797558,0.85671392,0.93709248,1.0178172,1.0917494,1.1229353,1.1886874,1.2696544,1.3296089,1.4102448,1.5059924,1.5879812,1.5665123,1.4760042,1.3806026,1.2870742,1.1750547,1.0726269,0.96939988,0.89081848,0.81932715,0.72297837,0.63955576,0.55616755,0.57492881,0.65080388,0.74893733,0.82261774,0.82966254,0.74749715,0.65222085,0.55503607,0.46044745,0.36993969,0.27502944,0.1840083,0.089007591,0.0023522248,-0.091508074,-0.18690949,-0.2781049,-0.36836335,-0.45903497,-0.54710197,-0.63950546,-0.7336238,-0.79353823,-0.88601122,-0.98119435,-1.0705746,-1.1573287,-1.2430988,-1.3267615,-1.393567,-1.3800415,-1.2708545,-1.1723067,-1.0731488,-0.96157759,-0.82941237,-0.73525458,-0.62234832,-0.50470836,-0.42782772,-0.33774002,-0.23262226,-0.10863646,0.012976741,0.10050074,0.16345108,0.25604934,0.37182587,0.44925638,0.55263595,0.66572347,0.69671838,0.73475294,0.82861125,0.90734062,0.99236117,1.0728524,1.1678914,1.2902348,1.4026722,1.4228414,1.3447797,1.2647274,1.186361,1.1035573,1.0368448,0.95600327,0.93361254,0.97718826,1.0349851,1.0981454,1.0436511,0.96764942,0.85669191,0.76711217,0.69839473,0.59309808,0.46172597,0.36500221,0.35240867,0.27833695,0.18575038,0.075247327,-0.016019911,-0.1212832,-0.23117377,-0.2955506,-0.41413675,-0.50724174,-0.58110186,-0.66903662,-0.76551302,-0.8274907,-0.77243868,-0.68416704,-0.5918704,-0.504023,-0.46555147,-0.40728398,-0.31618325,-0.22164724,-0.12782538,-0.038849588,0.051458164,0.14274898,0.23729191,0.33127098,0.42562307,0.51883914,0.61698909,0.59335594,0.49650118,0.40460607,0.30719029,0.20990577,0.11539628,0.033292918,-0.027333856,-0.054140992,-0.08775388,-0.17255399,-0.26233958,-0.34754735,-0.44196539,-0.53557442,-0.5909773,-0.59755354,-0.58549685,-0.6642533,-0.74882942,-0.84151407,-0.91925978,-0.99391048,-1.0763205,-1.1234656,-1.2035365,-1.2441239,-1.3142712,-1.3886211,-1.4472537,-1.5394804,-1.5850077,-1.6511964,-1.6965355,-1.7802133,-1.8898047,-1.9988619,-2.0346448,-1.9889393,-1.9139704,-1.828668,-1.7425848,-1.6580967,-1.5639466,-1.4798843,-1.3853769,-1.2963391,-1.2035759,-1.108476,-1.0169538,-0.91923871,-0.82269309,-0.72978296,-0.63484983,-0.53885812,-0.44796207,-0.34892668,-0.2556174,-0.1595744,-0.066798354,0.033441926,0.1217086,0.21864313,0.31058368,0.40406817,0.49523391,0.58915186,0.68426608,0.77646846,0.86770993,0.95950916,1.0512393,1.1471359,1.2391376,1.3322074,1.4238626,1.5146597,1.6093604,1.7050851,1.7992823,1.8772495,1.9678878,2.0645235,2.1598714,2.2207004,2.315626,2.3678048:5
1.7733569,1.6418706,1.5448796,1.4405968,1.3080366,1.209331,1.1074527,0.97515695,0.87835119,0.77314187,0.66320952,0.53853601,0.43570123,0.33538562,0.23374567,0.12413144,0.010782358,-0.10282683,-0.20526129,-0.30971022,-0.411381,-0.51513091,-0.6391065,-0.72467612,-0.82324821,-0.92292565,-1.022749,-1.1214991,-1.2175091,-1.2919342,-1.3888768,-1.5018194,-1.5840317,-1.6659739,-1.7557688,-1.8536395,-1.8578213,-1.958974,-1.9556252,-1.8727813,-1.7872686,-1.6990604,-1.6155205,-1.532613,-1.435314,-1.3431418,-1.2486984,-1.1601018,-1.0744826,-0.98627639,-0.89379969,-0.80274861,-0.70471564,-0.6326428,-0.56085509,-0.49355978,-0.48399928,-0.50747585,-0.5020362,-0.43613334,-0.34347517,-0.25650378,-0.16772829,-0.073275859,0.0049855029,0.069939373,0.13097707,0.18376225,0.28201626,0.38138203,0.47401327,0.57006164,0.67740312,0.74815081,0.70909853,0.59957614,0.48480018,0.38681122,0.2663709,0.15392219,0.068583043,-0.044343042,-0.14646677,-0.25927819,-0.37809887,-0.4723754,-0.57106,-0.66588401,-0.70924249,-0.67244805,-0.5876394,-0.44780518,-0.37713505,-0.27089229,-0.12863566,-0.032410267,0.084935582,0.14396921,0.20731608,0.2210482,0.26971712,0.37321701,0.42604567,0.55024871,0.6468924,0.72017587,0.81859655,0.92353922,0.98319789,1.0534567,1.1519706,1.2398849,1.3102482,1.325898,1.2614119,1.1832109,1.1151635,1.0477155,0.99099392,0.94848717,0.88904219,0.8948412,0.91107608,0.96154862,1.0055276,1.0560314,1.1243346,1.194744,1.2454348,1.2959019,1.2992169,1.2670551,1.2817433,1.3503398,1.4197646,1.4928273,1.5776892,1.6615157,1.7435647,1.7629914,1.6722861,1.5902213,1.4821088,1.3401942,1.1986643,1.0461569,0.98314284,0.86184614,0.71904735,0.57076284,0.43281023,0.36385409,0.32257904,0.2902444,0.25047921,0.17190527,0.053397779,-0.070365237,-0.17334171,-0.29316711,-0.39911234,-0.49994814,-0.54828979,-0.58109952,-0.67884027,-0.79415569,-0.90592895,-1.0072067,-1.1372806,-1.236611,-1.3525332,-1.4761884,-1.5748657,-1.67681,-1.8115163,-1.9098052,-2.0243873,-2.1409132,-2.2055181,-2.3266097,-2.4313878,-2.4592873,-2.3736986,-2.2856183,-2.2229567,-2.1510546,-2.1057238,-2.034744,-1.9368961,-1.8640089,-1.8259104,-1.7724447,-1.6505986,-1.5317366,-1.4231836,-1.3210123,-1.2440348,-1.1534784,-1.0373064,-0.9301344,-0.82122232,-0.74196923,-0.64610285,-0.54673327,-0.45927076,-0.37931136,-0.29816155,-0.16655186,-0.031716221,0.076428072,0.2170507,0.35922141,0.49510227,0.55085849,0.50468186,0.49981321,0.45285132,0.44613129,0.44090019,0.48293751,0.52652863,0.52467585,0.60006277,0.69202875,0.7526866,0.78220238,0.8634422,0.91277752,0.9939068,1.0428214,1.077798,1.1415252,1.207869,1.2851164,1.3771534,1.434575,1.4880069,1.5791862,1.6495238,1.7048731,1.652793,1.5377148,1.4531038,1.3401023,1.2425859,1.1658119,1.1016036,1.0365615,0.9666145,0.93545278,0.89603505,0.80722866,0.72416412,0.64351862,0.5717633,0.51630949,0.45406964,0.39027704,0.33288584,0.38504681,0.421228,0.40172621,0.46155634,0.5276219,0.60658292,0.67918498,0.71627389,0.60548516,0.46086723,0.31273528,0.20049537,0.064075231,-0.073709127,-0.21526908,-0.32628191,-0.44541207,-0.54459052,-0.6795876,-0.78471282,-0.91233345,-1.0315068,-1.1651155,-1.2708569,-1.3776392,-1.491488,-1.6053079,-1.7254657,-1.827867,-1.9315425,-1.9857025,-1.8626567,-1.749869,-1.6598037,-1.5405715,-1.4308079,-1.32267,-1.2150745,-1.098326,-0.9848909,-0.87059071,-0.75266357,-0.65201101,-0.52615121,-0.41013081,-0.29954318,-0.19114139,-0.068466784,0.018546288,0.11418771,0.23194385,0.3429629,0.47236317,0.52769527,0.50124975,0.49606145,0.52413071,0.55661422,0.60255845,0.60359283,0.55571522,0.48231003,0.4000155,0.30636664,0.265374,0.41567559,0.54588729,0.62240169,0.6574745,0.67924482,0.69727811,0.69026475,0.65782173,0.68521902,0.72756876,0.79077151,0.85832952,0.87845504,0.82705211,0.78713782,0.75395909,0.70036893,0.63895356,0.55915366,0.47705236,0.39240083,0.35221393,0.28400494,0.19288284,0.11254256,0.02069562,-0.064022972,-0.16073809,-0.22950952,-0.32069214,-0.38254215,-0.473163,-0.52856146,-0.58749969,-0.63355574,-0.63692659,-0.53436114,-0.472078,-0.35865182,-0.32637043,-0.22233081,-0.10647197,-0.012343329,0.095216109,0.19028652,0.23687953,0.29254948,0.3718036,0.40866191,0.32124468,0.24498407,0.29827706,0.27983164,0.25990779,0.22100201,0.19279434,0.17197796,0.11838875,0.058480033,0.0068020615,-0.094837628,-0.2016297,-0.29874921,-0.40097622,-0.51212011,-0.60443742,-0.70542085,-0.78800207,-0.82980008,-0.9407021,-1.0264858,-1.0608742,-1.1227179,-1.0262972,-0.92169192,-0.81319389,-0.71374612,-0.61057079,-0.49829534,-0.38607178,-0.27391726,-0.16999976,-0.067534409,0.047334294,0.16309244,0.27192446,0.37509781,0.47727522,0.58969809,0.71503435,0.81308034,0.93035695,1.0511102,1.1571289,1.2572146,1.3768642,1.4955512,1.5878638,1.6961039,1.814675,1.9356444,1.9164221,1.8377882:5
1.8233139,1.7403665,1.660148,1.5481494,1.4306184,1.3553076,1.2442482,1.1860868,1.0625666,1.0592648,0.99931245,0.91782826,0.92321919,0.82135904,0.74926085,0.68809712,0.60197396,0.44596501,0.37626129,0.31198587,0.22188756,0.13188658,0.042822114,0.057882353,-0.040472597,-0.14170687,-0.24021164,-0.37202334,-0.51857993,-0.54706591,-0.40428289,-0.26842757,-0.14662423,-0.019569392,0.11397101,0.24138539,0.36542468,0.50259343,0.60354849,0.57182625,0.62136627,0.7446826,0.88425981,1.0029816,1.132772,1.2820416,1.3530941,1.2999764,1.1819911,1.0336936,0.95119569,0.85918525,0.77836491,0.7196912,0.59124535,0.57218494,0.45403687,0.3300049,0.43471676,0.41659084,0.28784732,0.18782961,0.12145611,8.5879215E-4,-0.080153969,-0.15627869,-0.21335776,-0.2979521,-0.32654498,-0.40476962,-0.33896236,-0.21183817,-0.11464352,-0.013497774,0.16297913,0.2769516,0.42798116,0.53761132,0.53617627,0.50860229,0.45614946,0.40189887,0.35404751,0.29495963,0.24868338,0.19017479,0.13868949,0.08504295,0.043044851,-0.033112111,-0.064877045,-0.15097961,-0.21887574,-0.25622585,-0.3465331,-0.29304536,-0.25489291,-0.21056768,-0.23476464,-0.31240237,-0.37428975,-0.46975119,-0.48315944,-0.56887633,-0.64095455,-0.70275806,-0.79451923,-0.89479682,-0.96781078,-1.0033771,-1.1002225,-1.1579956,-1.2985347,-1.3777745,-1.4447222,-1.5248662,-1.6356947,-1.6954443,-1.7711519,-1.876975,-1.9708344,-2.124278,-2.1746482,-2.2391106,-2.3087215,-2.2046158,-2.0488376,-1.8978735,-1.8565612,-1.7712654,-1.7216297,-1.638879,-1.5131033,-1.4025149,-1.3251577,-1.1707128,-1.0237548,-0.88144336,-0.74449314,-0.58254885,-0.47323866,-0.31167431,-0.18445241,-0.036281638,0.10678772,0.22880476,0.38561131,0.51410336,0.64077888,0.78562614,0.94080207,1.0705713,1.2161461,1.3432434,1.5033948,1.6337404,1.7868442,1.9359548,2.0934527,2.2142912,2.3484717,2.4928549,2.6241279,2.7484731,2.8850063,2.80649,2.6791556,2.5659523,2.4517506,2.3337638,2.1958061,2.0841608,1.9402179,1.8252696,1.6640037,1.5146482,1.3747677,1.2224013,1.0837447,0.9256383,0.78499078,0.64464664,0.512198,0.36074988,0.21026397,0.055620073,-0.06190257,-0.20722618,-0.35868478,-0.51370452,-0.64282275,-0.80031689,-0.91981023,-1.0748347,-1.2108121,-1.355543,-1.5079039,-1.6514201,-1.7951766,-1.9411001,-2.0060013,-1.9014793,-1.9930343,-1.8799437,-1.8186189,-1.7777608,-1.7310891,-1.6589211,-1.6135551,-1.6398174,-1.5768836,-1.4903219,-1.4150073,-1.3129878,-1.2326647,-1.1697423,-1.0820842,-1.1281101,-1.066043,-0.99910726,-0.93964687,-0.91136351,-0.93251242,-0.93955688,-0.89189256,-0.87564478,-1.0019804,-1.1174613,-1.188437,-1.070988,-1.19658,-1.1006025,-1.1193506,-1.0356872,-1.0744242,-1.0646916,-0.94128624,-0.91896077,-0.88656601,-0.78419396,-0.77902395,-0.81192467,-0.68861877,-0.61761967,-0.5896185,-0.55931244,-0.49164153,-0.47211503,-0.47677008,-0.40782589,-0.36779229,-0.26550103,-0.1894716,-0.2753049,-0.28290056,-0.22790415,-0.24258561,-0.21034491,-0.090919442,-0.14022963,-0.061350699,-0.027161148,0.038949629,0.072097789,-0.064859246,-0.20250623,-0.34305308,-0.48235392,-0.60841207,-0.74994931,-0.88203136,-1.0082496,-0.88562925,-0.79502375,-0.67509167,-0.58721628,-0.51022689,-0.44942058,-0.37448262,-0.29568152,-0.32737362,-0.35709489,-0.23120431,-0.13951798,-0.051842406,0.035402489,0.12869286,0.19795061,0.21680995,0.087449984,0.21532231,0.30737329,0.40657487,0.49537795,0.4441849,0.55120138,0.67581216,0.74228903,0.85441075,0.94953591,1.0830179,0.97373167,0.82841507,0.70478367,0.54953773,0.38387112,0.36819759,0.23836137,0.094674825,0.038273424,-0.10905105,-0.23287669,-0.34997583,-0.48528059,-0.60009694,-0.66632351,-0.5641336,-0.4563594,-0.34349143,-0.25633253,-0.17846278,-0.068980209,0.0078317258,-0.01177763,0.092903253,0.21729573,0.30241475,0.32640939,0.4180254,0.53037384,0.57093519,0.65685073,0.74733339,0.85475518,0.94555197,1.0491517,1.157513,1.2508768,1.2572544,1.1646577,1.0486901,0.87429714,0.75312569,0.56519555,0.45431804,0.39275906,0.21666709,0.11831665,0.024037558,-0.10756839,-0.11762235,-0.23154734,-0.32788073,-0.41503649,-0.46180286,-0.63184426,-0.77479244,-0.94300336,-1.0597059,-1.1880254,-1.323121,-1.3322338,-1.1952832,-1.0655254,-0.93052789,-0.80352661,-0.67797368,-0.54332012,-0.42800082,-0.28496067,-0.14912014,-0.041762731,0.11466128,0.20188845,0.13937874,0.082046136,0.19639402,0.29875207,0.43342156,0.49690445,0.55695292,0.7253264,0.75701959,0.87935879,0.94293428,1.0400187,1.1255951,1.0622417,0.93234842,0.83320377,0.70980263,0.70540942,0.59401725,0.50173836,0.39778566,0.37206679,0.24953762,0.2430988,0.11111721,0.027668127,-0.0231039,-0.11255102,-0.24446772,-0.3585957,-0.45975832,-0.57993098,-0.51892738,-0.33314672,-0.15196176,-0.019574464,0.10257749,0.2207911,0.35697067,0.4965933,0.63820796,0.61562812,0.73445717,0.86859969,0.96231419,1.1357466,1.2580503,1.2078846,1.3882052,1.5269413,1.6642856,1.7508782,1.8286975:1
1.6118105,1.5389571,1.4670949,1.4383958,1.4411417,1.4464338,1.4237926,1.4026324,1.3909128,1.3439212,1.2413967,1.1223389,0.98953323,0.8553516,0.70554891,0.57738405,0.46919557,0.3256472,0.20874424,0.080729842,-0.061003418,-0.1830835,-0.3205767,-0.41448632,-0.50277291,-0.57704796,-0.64434971,-0.72329299,-0.83499953,-0.9386761,-1.0592952,-1.1450089,-1.0705313,-0.95484249,-0.84762276,-0.72428265,-0.6696178,-0.55622405,-0.51812433,-0.39901593,-0.31108875,-0.32205179,-0.2230726,-0.17369812,-0.07817671,0.005587525,0.021638044,0.048933272,0.091569767,0.1562887,0.25564944,0.25338693,0.28120132,0.32851141,0.39203858,0.42010984,0.42137824,0.40922568,0.37531467,0.3687786,0.39314271,0.43840215,0.47649092,0.52643374,0.58169905,0.62345575,0.65223387,0.6456501,0.60737682,0.54089508,0.52857276,0.55199521,0.59353424,0.62575502,0.65157434,0.67259879,0.59892799,0.63670403,0.6958527,0.72541101,0.76725964,0.78287038,0.77700108,0.80492833,0.85156804,0.8611186,0.90214897,0.95539771,1.0121787,1.0754484,1.1305518,1.1230124,1.1563822,1.220303,1.1637809,1.0573944,0.95300322,0.84917858,0.7624876,0.65786805,0.5556709,0.4901935,0.40055967,0.29396129,0.18682058,0.0915555,0.021842992,-0.088345805,-0.18724981,-0.27970484,-0.39222669,-0.48784163,-0.59220206,-0.66190153,-0.76649592,-0.8591499,-0.80889268,-0.73629247,-0.64593094,-0.5586097,-0.50734618,-0.4299532,-0.36360952,-0.28373512,-0.2235722,-0.15049216,-0.072252885,-0.020376446,0.048991753,0.12487655,0.19178002,0.22216856,0.24946465,0.36279069,0.29006616,0.17174195,0.088017973,-0.032757556,-0.10526371,-0.21908305,-0.32585747,-0.40922027,-0.46516562,-0.57452291,-0.69967618,-0.79244755,-0.92310805,-0.9305956,-1.0189079,-1.116457,-1.227475,-1.3008458,-1.4077611,-1.5480043,-1.5914841,-1.4777088,-1.3250533,-1.1990654,-1.1060807,-0.99546579,-0.86484735,-0.75537866,-0.67543605,-0.56498963,-0.49408415,-0.42871962,-0.35012085,-0.29693221,-0.35980027,-0.37072663,-0.40996793,-0.30397962,-0.18458137,-0.096554959,0.0026601907,0.10745855,0.14633283,0.22078626,0.30403272,0.27789903,0.29703714,0.3701458,0.46897674,0.53173678,0.63232808,0.69016267,0.78464649,0.79149795,0.78655509,0.86787743,0.94374602,1.0063459,1.0802187,1.1556574,1.1725964,1.191497,1.2983675,1.403641,1.4794288,1.5755251,1.5658708,1.6727061,1.781399,1.8512003,1.9604858,2.011424,2.1240592,2.2230315,2.320894,2.3738206,2.2641478,2.1520131,2.0457112,1.9470508,1.8360439,1.7601302,1.6413923,1.5682533,1.4517019,1.4268737,1.3521072,1.2611369,1.1750275,1.0752058,1.0224046,1.0354553,0.91867083,0.85459716,0.76469814,0.72287729,0.60650745,0.52765926,0.5424991,0.51655854,0.42293373,0.33867783,0.24583475,0.22093293,0.11001241,7.3006144E-4,0.041798519,0.02464148,0.041456914,-0.031243884,-0.1191468,-0.18473169,-0.25439608,-0.36578879,-0.44030899,-0.47717763,-0.58878759,-0.67898977,-0.78581771,-0.75734612,-0.75771293,-0.7532358,-0.86520862,-0.93204656,-1.0482766,-1.0857487,-1.2024018,-1.3231153,-1.3974926,-1.4902025,-1.6137347,-1.7359723,-1.8189246,-1.9516137,-1.9784163,-2.1000835,-2.22781,-2.2951032,-2.4354799,-2.5071853,-2.6074731,-2.5778667,-2.4614201,-2.4153652,-2.3246734,-2.2170235,-2.1136535,-2.0122774,-1.9802488,-1.8760146,-1.7808275,-1.7120087,-1.6088727,-1.5040225,-1.4772071,-1.4050191,-1.3073987,-1.2254842,-1.1170822,-1.0688409,-0.98490167,-0.8721876,-0.74111731,-0.63406342,-0.51967509,-0.39602279,-0.48116031,-0.54501547,-0.6485186,-0.69159531,-0.80527326,-0.90928236,-0.90832427,-1.0010558,-1.0672257,-1.1940049,-1.1623559,-1.187786,-1.2475984,-1.3593487,-1.3819442,-1.4692884,-1.5657449,-1.5313308,-1.5798854,-1.664062,-1.7105352,-1.7794916,-1.7681556,-1.6763397,-1.5682765,-1.4814175,-1.3763611,-1.284948,-1.162457,-1.1168555,-1.0055009,-0.89555083,-0.78310438,-0.69765372,-0.5929081,-0.49827878,-0.41609081,-0.30238354,-0.19008644,-0.11211242,-0.036102806,0.067960919,0.18909324,0.27437902,0.36328228,0.4709739,0.55119576,0.66815484,0.78982112,0.90321096,1.0197845,0.95904866,0.91371316,0.80443429,0.77661391,0.66913742,0.71393439,0.64124973,0.55329605,0.5448878,0.52091124,0.55735514,0.47713834,0.48431766,0.39961338,0.47621707,0.51338595,0.48782847,0.42064675,0.4354599,0.34973179,0.3091567,0.39626756,0.46025486,0.42688701,0.42704173,0.37517295,0.33090386,0.33300971,0.2565637,0.20193644,0.19743617,0.26382832,0.30811606,0.2602315,0.28100788,0.21151805,0.13378791,0.1736483,0.10357725,0.029547334,-0.014111428,0.012355639,0.090302789,0.079129319,0.038102681,0.063906948,0.0062378007,-0.05991474,-0.0620717,-0.11055259,-0.14175932,-0.19567999,-0.20804551,-0.23426274,-0.22403187,-0.10603782,0.022279474,0.098136787,0.24975708,0.3800135,0.50786397,0.57530069,0.6286199,0.76088245,0.89051269,1.0017802,1.0930142,1.1722888,1.2453873,1.2233905,1.1743209,1.2964487,1.3682371,1.420128,1.5061367,1.5727158:6
3.0164107,3.0238023,2.9603883,2.8276111,2.7291289,2.6189496,2.5266965,2.4156476,2.3160301,2.2153301,2.0997477,2.001904,1.8944771,1.7882952,1.6749487,1.5788022,1.4766782,1.3764468,1.2543371,1.1547292,1.0526163,0.94398392,0.84108717,0.75242955,0.67152145,0.56654839,0.45707268,0.35560579,0.23416093,0.14336314,0.040742049,-0.078025076,-0.19515203,-0.2923023,-0.37413142,-0.45379576,-0.52794907,-0.63006094,-0.75289503,-0.85937728,-0.95585853,-1.0675416,-1.1438633,-1.189767,-1.30369,-1.3557032,-1.3680755,-1.2976419,-1.2565291,-1.2440817,-1.2657761,-1.2711971,-1.2526342,-1.2215459,-1.1861004,-1.1510645,-1.140875,-1.1115277,-1.0869157,-1.0468384,-1.0140112,-0.95215398,-0.88028712,-0.8387353,-0.81990173,-0.76893002,-0.69492233,-0.64962949,-0.61501983,-0.58880007,-0.57605393,-0.56429685,-0.60880747,-0.56622368,-0.52471397,-0.48829257,-0.46481601,-0.47381188,-0.47638275,-0.46630121,-0.45705579,-0.45761534,-0.45145333,-0.46639623,-0.50335047,-0.58993752,-0.68206617,-0.76237126,-0.8012736,-0.7544654,-0.7373853,-0.67723279,-0.61857805,-0.54333676,-0.46300204,-0.43350788,-0.38592713,-0.30302994,-0.2668192,-0.20624539,-0.16127084,-0.11228394,-0.083792955,-0.18887511,-0.14309559,-0.074131561,-0.0071008706,0.059702654,0.13587796,0.18319154,0.17982228,0.25279847,0.32304962,0.41798355,0.35944885,0.43783418,0.47927551,0.46662794,0.38222248,0.47922441,0.50161338,0.42533123,0.48814496,0.55887859,0.60920117,0.65143341,0.64438234,0.70528713,0.79794915,0.79184105,0.69022653,0.72396783,0.71506163,0.74757716,0.80406996,0.88875493,0.97642329,1.0326376,0.96116413,0.85832125,0.73966307,0.62478669,0.50301206,0.36304102,0.29301679,0.18838883,0.07138509,-0.045368828,-0.16495209,-0.26042085,-0.35857407,-0.41340614,-0.46312042,-0.55806374,-0.66998162,-0.76190602,-0.86476373,-0.96973559,-0.92642911,-0.89680539,-0.8275616,-0.74776953,-0.67716228,-0.61136625,-0.49946335,-0.46446972,-0.38184639,-0.32997454,-0.25332372,-0.1627908,-0.14223512,-0.19808934,-0.18401611,-0.18204244,-0.082596674,-0.039251673,0.031046606,0.14181389,0.12905987,0.093692286,0.20189806,0.22320307,0.2904656,0.37424246,0.40950343,0.49519655,0.57577618,0.5569264,0.61736308,0.56388094,0.5196898,0.46734877,0.46699126,0.50099562,0.59495883,0.68104014,0.77613583,0.8226143,0.87520312,0.93492377,1.0312563,1.0969104,1.1773751,1.1836773,1.1711853,1.2175445,1.3159871,1.3746497,1.465385,1.4813973,1.5494835,1.6477483,1.6648616,1.6271327,1.5528091,1.5013545,1.4038948,1.2992072,1.2032128,1.1640897,1.125873,1.0188088,0.90998835,0.8127654,0.70879251,0.60164386,0.49888874,0.41361184,0.43718103,0.4609001,0.50388183,0.50473942,0.41032168,0.31350871,0.21368577,0.11492289,0.023859834,-0.062947505,-0.06825818,-0.17267632,-0.26768023,-0.37051853,-0.46784689,-0.57031842,-0.60869563,-0.62678412,-0.7221109,-0.824445,-0.92093806,-1.0103342,-1.0832646,-1.176523,-1.2712755,-1.3558753,-1.4474577,-1.5370326,-1.6013402,-1.6622532,-1.5828357,-1.521059,-1.4368498,-1.4077563,-1.3452788,-1.2670194,-1.1798224,-1.1110561,-1.014244,-0.95122992,-0.92724682,-0.8539424,-0.7450922,-0.64156535,-0.59305635,-0.4475841,-0.35743299,-0.28610524,-0.18038132,-0.06851104,0.078844394,0.16625948,0.26482729,0.38395313,0.47350741,0.6107307,0.69819007,0.81365529,0.88968589,0.95787299,0.90374558,0.8327613,0.74088092,0.64245839,0.54601512,0.47130068,0.40685087,0.31297628,0.22762795,0.16700608,0.23146238,0.19581002,0.13932433,0.071732821,0.0072104561,-0.049565213,-0.11003195,-0.17718271,-0.23826238,-0.2921455,-0.21737534,-0.13164948,-0.038665326,-0.012763846,-0.041462021,-0.09051889,-0.14907005,-0.1909741,-0.20462399,-0.21007498,-0.25806903,-0.33904087,-0.3810107,-0.49493054,-0.53241049,-0.54811286,-0.60783918,-0.67037043,-0.77264879,-0.80525613,-0.85652632,-0.93629564,-0.86214449,-0.88022911,-0.98456343,-1.0211421,-0.99146244,-1.0795564,-1.0406364,-0.97927385,-0.87489624,-0.84354707,-0.83084696,-0.84332762,-0.87745681,-0.84562908,-0.81335029,-0.87520973,-0.90929279,-0.94291156,-0.89866302,-0.83332778,-0.83632228,-0.77092163,-0.7633927,-0.75175028,-0.78379041,-0.73911948,-0.75175533,-0.69995158,-0.69614269,-0.652611,-0.64157659,-0.67232087,-0.61099795,-0.65720114,-0.69441293,-0.74617448,-0.81759351,-0.90687909,-1.0021293,-1.0673843,-1.0887005,-1.0780462,-1.0583136,-1.0990494,-1.155319,-1.1668018,-1.2112405,-1.2588941,-1.3166754,-1.3510935,-1.4019021,-1.3921839,-1.4273123,-1.3146366,-1.3973853,-1.4162726,-1.3162531,-1.1990885,-1.0802805,-0.98624318,-0.86629639,-0.75944954,-0.655018,-0.53561219,-0.4140417,-0.32079093,-0.20213279,-0.099866252,0.019991514,0.1187942,0.23258539,0.33468777,0.44435899,0.55922674,0.65283713,0.76429681,0.87489661,0.97784364,1.0761343,1.1806298,1.2915598,1.3963292,1.505181,1.60502,1.7064666,1.8085103,1.9164384,2.0212857,2.1248453,2.2367931,2.3361439,2.4344019,2.5561607,2.6595979,2.7581588,2.8734413,2.9744864:3
2.1592943,2.0893885,2.0133269,1.9142111,1.8226233,1.7324361,1.640864,1.5543662,1.4942208,1.43707,1.3435401,1.2532069,1.2091652,1.1618468,1.0722811,0.98906157,0.93968691,0.91368829,0.86879608,0.81196895,0.71796999,0.61087866,0.51887933,0.44264651,0.40312779,0.37441447,0.28456238,0.1989401,0.10631207,0.01883742,-0.073309588,-0.15960476,-0.25245829,-0.34454733,-0.4310533,-0.5202781,-0.60785729,-0.69587149,-0.78639262,-0.8796075,-0.9713599,-1.0594798,-1.1401052,-1.192732,-1.1837344,-1.1405592,-1.0739776,-0.97978712,-0.9319317,-0.85478423,-0.76322596,-0.73578198,-0.71217207,-0.64597483,-0.59440295,-0.50537766,-0.4513329,-0.40779572,-0.35983136,-0.29599358,-0.22687073,-0.16696818,-0.13641376,-0.072229105,0.0090011406,0.058305895,0.14449896,0.22349006,0.19350798,0.10240965,0.037328644,-0.050838644,-0.070535523,-0.15836415,-0.18071014,-0.13262742,-0.043377672,0.05677083,0.12445292,0.22016529,0.3272097,0.38450814,0.46504034,0.54322074,0.64268208,0.73185217,0.79821948,0.86935585,0.97136242,1.034332,1.1175424,1.1926184,1.2928532,1.4038076,1.4404313,1.3780851,1.3196335,1.2406004,1.1995542,1.1055206,1.1304792,1.0609861,1.0085031,0.98873364,1.0088647,0.9277108,0.86885137,0.81367795,0.74653588,0.77768912,0.80088992,0.77086932,0.70039006,0.65933338,0.56529117,0.53841631,0.49530506,0.42635594,0.47157611,0.48276975,0.47407855,0.42886634,0.35291096,0.31860957,0.24089522,0.19751353,0.15065957,0.072417981,0.044437001,0.07519479,0.098134223,0.10185839,0.036956085,-0.0047668659,-0.059681068,-0.14136072,-0.17040536,-0.20769962,-0.27606796,-0.35090631,-0.39047177,-0.37288774,-0.43217466,-0.53281832,-0.58188635,-0.68028202,-0.73155642,-0.74259507,-0.81607009,-0.89685363,-0.93505592,-1.0457883,-1.0616534,-1.0755437,-0.96201353,-0.84861135,-0.73492589,-0.62145594,-0.49406124,-0.38100035,-0.25338564,-0.13990158,-0.026339885,0.10113444,0.22801973,0.32867284,0.42211016,0.52131764,0.63916875,0.74956121,0.80808147,0.86617996,0.89749656,0.916963,0.950778,0.98513711,0.99668352,0.99539674,0.9591861,0.91364245,0.96100342,0.99105352,0.99977639,1.0998983,1.1040073,0.99340974,0.93664535,0.87572784,0.78857193,0.70589202,0.62604999,0.52555999,0.42872068,0.31504528,0.20174865,0.089252281,-0.03763244,-0.12746391,-0.21670032,-0.33132795,-0.45625316,-0.56857087,-0.69454822,-0.8077784,-0.92028474,-0.98324108,-1.0527106,-1.1644535,-1.1443239,-1.0711181,-1.0188762,-0.96228047,-0.88068434,-0.80083634,-0.72712375,-0.66516059,-0.64109734,-0.5789833,-0.49872786,-0.46949805,-0.40063676,-0.34133216,-0.29036759,-0.32707792,-0.2480822,-0.19349852,-0.12872338,-0.12120525,-0.094608493,-0.024859938,8.2939313E-4,0.057620198,0.13643598,0.19294911,0.21123586,0.13145747,0.10932072,0.038304816,0.019860524,0.13050093,0.1447681,0.24106539,0.3057989,0.35371826,0.39933662,0.35014021,0.32885571,0.41150377,0.45524882,0.48026017,0.54837342,0.60937014,0.55187362,0.56438008,0.65632754,0.69556645,0.76793124,0.73794325,0.71792985,0.82197613,0.90295864,0.86179125,0.9527968,1.0006029,1.0900716,1.1632062,1.1065041,1.0087154,0.89902407,0.86040867,0.7327,0.65109209,0.59749574,0.48502154,0.3720935,0.35072132,0.25596083,0.17083642,0.10083408,0.024298488,-0.07434692,-0.09447354,-0.19837858,-0.27855358,-0.34863727,-0.44833658,-0.51605604,-0.61281215,-0.67862875,-0.74648078,-0.81009582,-0.89334791,-0.97563982,-1.061606,-1.1156274,-1.1965497,-1.2666114,-1.3509741,-1.3980125,-1.4973336,-1.5689838,-1.6465706,-1.7363978,-1.8241278,-1.8877024,-1.9203316,-2.0135127,-2.098983,-2.1792832,-2.2524374,-2.2860715,-2.308848,-2.2972409,-2.2607198,-2.2128872,-2.2390413,-2.3381945,-2.4441931,-2.5416193,-2.6218084,-2.6143509,-2.564624,-2.5256744,-2.4897828,-2.439686,-2.389689,-2.3010796,-2.2473829,-2.159643,-2.0564914,-1.9728885,-1.8928857,-1.805035,-1.7306208,-1.6455946,-1.5475838,-1.4640494,-1.379002,-1.3016485,-1.2419439,-1.1792205,-1.0906199,-1.0704432,-0.98161241,-0.91625733,-0.83076649,-0.75506012,-0.75201062,-0.70130895,-0.60647629,-0.54156442,-0.47136739,-0.38930796,-0.31287805,-0.28229455,-0.28016251,-0.25264014,-0.15581942,-0.10663437,-0.029658078,0.019324622,0.029411367,0.13287306,0.21120432,0.21888881,0.29120262,0.36863607,0.34871876,0.27263104,0.23798924,0.18153862,0.1018265,0.13348126,0.063267884,0.0080217828,-0.064028425,-0.09406332,-0.12741645,-0.19790706,-0.24544347,-0.23092212,-0.13058596,-0.10886018,-0.017172998,0.071347037,0.14678788,0.2004127,0.28022536,0.38060597,0.42368072,0.51361974,0.59055226,0.6502627,0.71987082,0.67561025,0.64820258,0.59741318,0.62595817,0.67002028,0.78249934,0.80748859,0.85786606,0.97080056,1.0245777,1.1105613,1.1168018,1.1100893,1.0699715,1.103801,1.190594,1.2388886,1.3075399,1.3934055,1.4433701,1.4097496,1.4088314,1.501335,1.57712,1.6364913,1.6156638,1.7088193,1.7920242,1.8004996,1.8483531,1.903042,1.9989402,2.0978072:6
1.3243546,1.2130204,1.1380553,0.99156842,0.89320018,0.75111635,0.83889702,0.84740792,0.70285691,0.57700504,0.58395182,0.52254997,0.4080825,0.26544945,0.13930257,0.088609834,-0.0098729559,-0.1230579,-0.17165798,-0.26306177,-0.39689948,-0.52355183,-0.627045,-0.71145666,-0.7867574,-0.84835908,-1.0108378,-1.1862871,-1.167396,-1.3672562,-1.5313127,-1.5518606,-1.7081753,-1.5656744,-1.4155225,-1.2605065,-1.0854691,-0.93471715,-0.9824344,-1.0711381,-0.95571562,-0.78866531,-0.70265583,-0.61957323,-0.48895229,-0.36260665,-0.2999733,-0.21304816,-0.27690575,-0.10684236,-0.02812234,0.090485141,0.25665123,0.36367815,0.48221955,0.64799759,0.80872561,0.93260709,0.91342625,0.7759786,0.64581486,0.5504463,0.53364379,0.37649063,0.3187957,0.19681186,0.1392012,8.41597E-4,-0.044138358,-0.14115123,-0.20896242,-0.21906282,-0.28125306,-0.31710313,-0.42249375,-0.44698039,-0.5340789,-0.55229084,-0.62361839,-0.56495214,-0.66791805,-0.66526871,-0.48357164,-0.31683726,-0.30714466,-0.25430698,-0.021248916,0.14945798,0.29175834,0.43302982,0.52601314,0.74807991,0.9067888,1.0459198,1.1189131,1.132956,1.1006812,1.0108488,0.93378606,0.85181905,0.80648238,0.75295863,0.704738,0.64243322,0.64279103,0.60597481,0.56817734,0.50969545,0.46698364,0.37447319,0.3005534,0.28698788,0.2622672,0.24091974,0.25655271,0.22047447,0.18854194,0.21342351,0.19250842,0.14968316,0.10073303,0.021074658,-0.1003446,-0.14763193,-0.21286177,-0.35099268,-0.28044964,-0.13315433,0.034118411,0.1764427,0.33270046,0.47730663,0.46272291,0.45659916,0.38671035,0.40281518,0.40680904,0.41412266,0.35649267,0.33194085,0.25012121,0.26977231,0.22106552,0.071950908,0.100528,-0.063359914,-0.10084812,-0.16520435,-0.31791565,-0.47698655,-0.58781864,-0.74248836,-0.71141558,-0.5965132,-0.45592867,-0.280404,-0.10264744,-0.041386458,-0.15361704,-0.27379477,-0.40504664,-0.49417193,-0.52055242,-0.5097348,-0.38581264,-0.21435753,-0.051015087,0.1754353,0.34531602,0.57033494,0.76525875,0.96721288,1.1443174,1.3466297,1.4947645,1.7185199,1.8902233,2.0348587,2.2440602,2.4116509,2.5779054,2.8028298,2.9490906,3.1572902,3.2637532,3.3480185,3.1850553,3.1121595,2.9783045,2.8018915,2.632659,2.4113448,2.1842823,1.9531955,1.7836311,1.6103937,1.4220206,1.2213162,1.0358328,0.86790556,0.69462791,0.47042255,0.29149108,0.11832827,-0.052504207,-0.22299544,-0.392879,-0.56469426,-0.76680543,-0.9474383,-1.1404031,-1.3107992,-1.4895536,-1.6967237,-1.8836549,-2.0514245,-2.2675185,-2.4338723,-2.6214414,-2.7891102,-2.7218074,-2.6026203,-2.4536345,-2.3325018,-2.2035489,-2.0611662,-1.9499766,-1.7982293,-1.7170442,-1.642538,-1.5627157,-1.4428853,-1.3816302,-1.3273999,-1.2540325,-1.1710118,-1.0682463,-1.1354744,-1.1572663,-0.98779534,-0.87073133,-0.83749697,-0.8305707,-0.69117712,-0.58359856,-0.6760189,-0.61525353,-0.50663041,-0.44302215,-0.46892203,-0.57132485,-0.47788347,-0.45183302,-0.39484152,-0.33839813,-0.21136213,-0.29751463,-0.20871246,-0.22486385,-0.16941196,-0.19072218,-0.22051386,-0.18172282,-0.13680108,-0.087842491,-0.019883268,-0.0017137155,0.080867048,0.066602224,-0.11363532,-0.24447057,-0.42383093,-0.59329431,-0.6389571,-0.80088019,-0.96644884,-1.11604,-1.1423464,-0.96899627,-1.0259756,-0.94739397,-0.88481899,-0.79969545,-0.71993425,-0.63695424,-0.5549825,-0.5256758,-0.48962821,-0.57062378,-0.46444991,-0.41734949,-0.29847503,-0.17560697,-0.096655502,0.009916657,-0.027785141,0.0785028,0.16694495,0.30237971,0.32482296,0.23354842,0.074885433,0.044202683,0.12169353,0.26308097,0.38000854,0.46761015,0.56293795,0.6356393,0.65044395,0.55554143,0.71473495,0.80590749,0.89292872,1.0022996,1.1013281,1.2186485,1.3350252,1.4519179,1.5937082,1.6364283,1.409895,1.2419808,1.0933522,1.0050579,1.1691022,0.98146458,1.0090941,0.90466556,0.71776606,0.54901813,0.45559258,0.27276117,0.14979039,0.020219437,-0.065724306,-0.10792258,-0.17838968,-0.28721333,-0.48559949,-0.64538289,-0.82731172,-0.84790718,-0.7244872,-0.67476034,-0.58056268,-0.51602177,-0.52307228,-0.45269509,-0.33995404,-0.30420017,-0.21106556,-0.15340687,-0.19148545,-0.17678765,-0.1942336,-0.044134999,0.10658435,0.25864202,0.22289543,0.031315528,0.14562324,0.22051235,0.39176571,0.57005107,0.73798567,0.85337784,1.0034997,1.1273134,1.0594612,1.1645253,1.211807,1.063561,0.8867843,0.7355833,0.59291386,0.56402476,0.41664633,0.51053703,0.33260046,0.16985353,0.17585794,0.068360686,-0.091576167,-0.24053608,-0.26927727,-0.33246216,-0.33486883,-0.47924438,-0.55701974,-0.61654146,-0.69505171,-0.80137804,-0.92554688,-1.020549,-1.2038064,-1.2428079,-1.2252471,-1.2557388,-1.4784352,-1.5980794,-1.4928893,-1.3532844,-1.3463848,-1.3716121,-1.1999501,-0.98203986,-0.81756023,-0.70308373,-0.59049455,-0.48999005,-0.37014429,-0.25639976,-0.15369514,0.0019092118,0.13813974,0.24800491,0.17838079,0.32229282,0.45062611,0.60822501,0.76551285,0.95506381,1.042417,1.1189428,1.2703255,1.3907199:1
2.3626093,2.2862955,2.1543431,2.0447011,1.9017963,1.7862672,1.6587458,1.5296801,1.4556634,1.3477248,1.2222682,1.0984619,0.94399078,0.81062135,0.67747777,0.54527773,0.40453857,0.24365935,0.11951577,-0.041845407,-0.1650934,-0.30036499,-0.47393723,-0.6035293,-0.72303825,-0.90352089,-1.0210281,-1.2008986,-1.3212928,-1.4996182,-1.6221042,-1.8013061,-1.92889,-2.0598877,-2.2009913,-2.1721373,-2.0389645,-1.884254,-1.772605,-1.6534572,-1.5381046,-1.4292215,-1.3385406,-1.2557676,-1.1545093,-1.07496,-0.95244984,-0.86288281,-0.77699251,-0.68469359,-0.62879789,-0.5857185,-0.53606378,-0.44334395,-0.37986654,-0.36088172,-0.40147968,-0.3519348,-0.33988678,-0.28066271,-0.26518041,-0.16694788,-0.15450429,-0.044219382,-0.047277316,0.019304786,0.097685939,0.14498057,0.24033604,0.32303577,0.33169349,0.33701,0.33106128,0.32160627,0.35559852,0.41654342,0.41158222,0.31616295,0.18026518,0.069465366,-0.062469956,-0.18224876,-0.21605697,-0.36058792,-0.31485329,-0.21822609,-0.16489598,-0.14251868,-0.079447712,-0.045523665,-0.020239703,-0.070402287,-0.069052645,-0.062607511,-0.078597048,-0.091107548,-0.058162448,0.075815114,0.15681384,0.25404388,0.41248651,0.5100607,0.57491965,0.58549767,0.52166081,0.50176316,0.42478613,0.32454601,0.24456816,0.13602517,0.038165873,-0.072740252,-0.20281466,-0.28589625,-0.33416451,-0.46715879,-0.5457173,-0.66174839,-0.70545149,-0.65148932,-0.67658062,-0.58947947,-0.53080366,-0.42313846,-0.36547283,-0.30872163,-0.20845255,-0.21833064,-0.11312174,-0.064303881,0.032321056,0.13163627,0.20449445,0.19083578,0.21257824,0.18616571,0.1971224,0.27943324,0.32073328,0.37850921,0.44464172,0.5396336,0.62264937,0.67385828,0.71344656,0.80076074,0.87324265,0.97016654,1.0589246,1.1274658,1.0720812,0.9391531,0.78076375,0.63038671,0.47202087,0.34079288,0.33688915,0.25536473,0.12303359,0.064849342,0.11769155,-0.0079078646,-0.15306843,-0.29712573,-0.3551687,-0.44753951,-0.44952974,-0.57004817,-0.56774082,-0.5364573,-0.43101087,-0.36507379,-0.30020506,-0.17315944,-0.11689433,0.015668074,0.07007435,0.17756077,0.20937762,0.099134255,0.13671953,0.21802388,0.31982034,0.40315358,0.46046149,0.50751475,0.51578153,0.48714876,0.52706486,0.52943379,0.46583851,0.39673087,0.34726615,0.32030481,0.23383961,0.11248262,0.012786349,-0.089397395,-0.1220805,-0.17989785,-0.26416547,-0.35482413,-0.46070555,-0.56062594,-0.66139598,-0.71518868,-0.58105488,-0.48573429,-0.43094441,-0.31112945,-0.26617298,-0.116562,-0.016066505,0.15093315,0.25158095,0.35851207,0.45529276,0.56155915,0.64961896,0.70472712,0.6874078,0.79965013,0.90351419,1.0021245,1.1173374,1.1893018,1.2863392,1.4016094,1.3637313,1.3200288,1.3737411,1.3267986,1.2680499,1.2172093,1.1280471,1.2604618,1.1563369,1.0776521,1.0060828,1.0195612,1.0198359,0.92634432,0.87148066,0.80972341,0.72251869,0.67796687,0.60309007,0.51932764,0.43684854,0.3806863,0.28715987,0.16219536,0.052924208,-0.040910967,-0.13420353,-0.27043246,-0.16734242,-0.060351467,0.053796488,0.18470863,0.27343157,0.39236942,0.51370556,0.64062586,0.72772531,0.84223888,0.95216817,1.0746328,1.1893903,1.2769466,1.4077777,1.5178705,1.6272984,1.7606695,1.8631782,1.8430406,1.7768834,1.7099983,1.6254384,1.5889149,1.5084453,1.4668952,1.3942521,1.3307145,1.215536,1.1509117,1.0461898,0.99378814,1.112994,1.149844,1.0715528,0.94224093,0.83322409,0.73411259,0.66453384,0.59897021,0.47211945,0.50097479,0.42992155,0.31459149,0.22769293,0.14369406,0.10304544,0.03467052,-0.050409101,-0.10385796,-0.14467812,-0.23512796,-0.30247745,-0.33589811,-0.43541597,-0.53854524,-0.63509418,-0.7137147,-0.80614502,-0.92373132,-0.81038785,-0.64033528,-0.5343408,-0.41852863,-0.29938084,-0.18408737,-0.071528771,0.03643474,0.14279229,0.26761752,0.40764091,0.34078781,0.24789805,0.15325028,0.085944289,0.035598904,-0.08012021,-0.15883215,-0.25001427,-0.27905389,-0.33486983,-0.38185052,-0.41116886,-0.45578001,-0.46089808,-0.50425137,-0.582313,-0.61141372,-0.66838088,-0.71992871,-0.75956021,-0.73732837,-0.5832418,-0.50651866,-0.4882027,-0.51319608,-0.53360153,-0.56002523,-0.59945703,-0.63559921,-0.67183653,-0.7006738,-0.78233193,-0.84773867,-0.97426459,-1.0342399,-1.0872097,-1.1469093,-1.285826,-1.2472828,-1.3624422,-1.4664201,-1.5189539,-1.6044615,-1.6469275,-1.725822,-1.8171164,-1.7815503,-1.8344812,-1.9676968,-2.0206761,-2.1400711,-2.2274329,-2.1729377,-2.2743812,-2.4136375,-2.4943245,-2.3305024,-2.3608462,-2.5363677,-2.6692683,-2.6983378,-2.581607,-2.4047405,-2.2291294,-2.1103657,-1.9344214,-1.806625,-1.6443675,-1.5035753,-1.3850219,-1.2018129,-1.077066,-0.94569712,-0.80015398,-0.64790848,-0.52264766,-0.39739194,-0.25584921,-0.10571967,0.036317564,0.16503603,0.28950462,0.41601002,0.5463253,0.67400521,0.8020232,0.93163374,1.0951913,1.2285831,1.3635961,1.4908811,1.6185919,1.7394684,1.8744066,2.0048806,2.1805308,2.3370965,2.4315424,2.4844894,2.4346439:1
1.3605708,1.2741537,1.1935894,1.1277521,1.0798083,0.9918736,0.88088971,0.82808783,0.7547896,0.73275497,0.65074752,0.56467896,0.51693066,0.55000948,0.46289773,0.39129032,0.34008422,0.34456335,0.37403904,0.29433733,0.24777958,0.16288202,0.18519976,0.21638636,0.28980129,0.37376799,0.31839863,0.21767762,0.14921983,0.065064161,0.017304899,-0.068769301,-0.15356218,-0.19989526,-0.20496997,-0.13172507,-0.13600588,-0.16805949,-0.25379464,-0.35295515,-0.42614377,-0.51017964,-0.59497215,-0.69866427,-0.73756889,-0.75082998,-0.69688798,-0.63920279,-0.56904301,-0.4873761,-0.46982288,-0.3924898,-0.31635376,-0.1988882,-0.096998865,-0.12017922,-0.18825967,-0.22408929,-0.29398555,-0.37010339,-0.42294466,-0.39766544,-0.43250412,-0.48459564,-0.54312964,-0.62404667,-0.70698041,-0.77362433,-0.82708603,-0.78985544,-0.80715495,-0.87440124,-0.94341841,-0.99865979,-1.0936599,-1.1650494,-1.2373569,-1.3389665,-1.4400815,-1.4968861,-1.5496564,-1.581728,-1.634534,-1.6878003,-1.7305786,-1.7774064,-1.7826655,-1.8376935,-1.8103196,-1.7448275,-1.7015101,-1.6215092,-1.5498837,-1.5251258,-1.4293516,-1.3296216,-1.2437247,-1.1438491,-1.0380782,-0.9561308,-0.85131435,-0.7513585,-0.6544367,-0.56565446,-0.46497529,-0.3652111,-0.32770007,-0.26857133,-0.17871986,-0.08662052,0.019868718,0.10829265,0.16360028,0.26493445,0.31537252,0.37164554,0.46826535,0.56354898,0.65996577,0.75671295,0.85063668,0.93683619,1.0431652,1.1377461,1.2329498,1.3269131,1.4273745,1.5202294,1.6222053,1.7276396,1.8098279,1.9190513,2.0103305,2.0592768,2.1449157,2.2556334,2.3513428,2.4466271,2.539284,2.6381763,2.7406693,2.8242923,2.824778,2.8088441,2.7116426,2.614925,2.5183097,2.421529,2.3237211,2.2239463,2.1298945,2.0313271,1.9405523,1.8384632,1.7428734,1.6494585,1.5503713,1.4588309,1.3563962,1.266991,1.1607147,1.0696192,0.96633286,0.8710598,0.7725199,0.67458442,0.58212989,0.47896232,0.38433664,0.28477402,0.19051789,0.090647314,-0.0065108762,-0.097510926,-0.19473827,-0.29370501,-0.38377835,-0.48696546,-0.58027017,-0.67039576,-0.77061564,-0.86809886,-0.95758363,-1.0614194,-1.1596669,-1.2584275,-1.3548391,-1.4582691,-1.5477626,-1.6386019,-1.7318814,-1.8336051,-1.8480347,-1.8582803,-1.7915338,-1.7712234,-1.7309879,-1.6992592,-1.628448,-1.5597366,-1.5180637,-1.4414889,-1.3908905,-1.3105507,-1.2590422,-1.2089308,-1.1546178,-1.1199615,-1.0725594,-1.0502113,-1.1098762,-1.0773559,-1.0286397,-0.96333812,-0.88978831,-0.84135728,-0.83085869,-0.88464072,-0.84923421,-0.77615664,-0.71262162,-0.67372232,-0.69181463,-0.63274028,-0.58196832,-0.55580467,-0.59497832,-0.68858824,-0.7948014,-0.90813412,-1.0107674,-1.0543891,-1.0226975,-0.96108581,-0.91865599,-0.85425054,-0.77061702,-0.68525984,-0.62504901,-0.62138657,-0.71491629,-0.65048822,-0.60148752,-0.50796051,-0.4222319,-0.3900138,-0.31744542,-0.26135495,-0.2209089,-0.18197852,-0.20229996,-0.2936776,-0.38080402,-0.44144293,-0.34289522,-0.22409535,-0.12028652,-0.065808693,-0.13148031,-0.052727598,0.035454607,0.084249401,0.17918408,0.1994738,0.12907139,0.20089567,0.31633306,0.44790896,0.55824018,0.57969833,0.66485839,0.71421371,0.79105115,0.89277122,0.82198129,0.73492152,0.65084015,0.56458115,0.4662485,0.39584501,0.2988845,0.20072763,0.11516486,0.025712761,-0.050806577,-0.079303814,-0.1770095,-0.27468184,-0.26027238,-0.28381012,-0.37143533,-0.45352235,-0.53303995,-0.60660479,-0.68463271,-0.74320532,-0.81327344,-0.89018355,-0.84506549,-0.9164733,-0.97240616,-1.0331471,-1.0607878,-1.0567018,-1.0152481,-0.92822326,-0.87104835,-0.85737944,-0.75197788,-0.68199301,-0.60696198,-0.51720589,-0.52818169,-0.51528327,-0.4548981,-0.38552655,-0.2829841,-0.19665922,-0.091512014,-0.0085565521,-0.013080046,0.091846986,0.1506081,0.22790641,0.28256198,0.25482071,0.18046707,0.1128182,0.078864477,0.084047885,0.16905325,0.27257617,0.36685271,0.44575114,0.43996473,0.53449247,0.62797067,0.72236929,0.8181042,0.81914472,0.87876772,0.97251376,1.06058,1.1510046,1.2364153,1.2810923,1.3939477,1.4855563,1.5810291,1.6275037,1.5569104,1.4525933,1.3524415,1.3159394,1.2149426,1.1684078,1.0949784,1.0042656,0.9223032,0.89439624,0.82592509,0.73990738,0.7201532,0.66699389,0.61989119,0.64365402,0.54537414,0.46485273,0.3855642,0.39392668,0.45572089,0.55414341,0.59120466,0.61308799,0.57403536,0.50283633,0.46594806,0.40801892,0.33263686,0.27943763,0.24394103,0.28236612,0.21069931,0.12152048,0.025472754,-0.067669035,-0.17638219,-0.16096202,-0.15717385,-0.12413901,-0.18675324,-0.2714615,-0.35634046,-0.44801714,-0.52978513,-0.60994196,-0.67717744,-0.73247199,-0.83175924,-0.84173347,-0.89984049,-0.80283,-0.66903588,-0.54325936,-0.46323903,-0.36206889,-0.29761966,-0.2572093,-0.12882158,-0.044937265,0.047646278,0.15177708,0.23959891,0.29142316,0.35314858,0.30125634,0.38811177,0.46346312,0.56980572,0.7003833,0.80878419,0.86894666,0.9677818,1.1047254,1.2417993,1.3146814,1.3689806:3
3.1665154,3.0980892,2.9834644,2.7961631,2.5947828,2.4431879,2.2797514,2.1166668,1.9569058,1.8028566,1.6448481,1.4950952,1.3213791,1.1356984,0.97162271,0.81665429,0.66193186,0.50103546,0.34095093,0.19155151,0.03400692,-0.17521605,-0.32400831,-0.47996515,-0.65738715,-0.83838011,-0.99369861,-1.153667,-1.3104362,-1.461187,-1.6342585,-1.8244657,-1.9885205,-2.0875038,-2.2143674,-2.363753,-2.3202814,-2.2071694,-2.069536,-2.0355568,-1.9183441,-1.8329497,-1.7521208,-1.613435,-1.4981362,-1.4338545,-1.3692773,-1.2920959,-1.2141122,-1.1362577,-1.0552994,-1.1796544,-1.2620875,-1.1744727,-1.1147009,-1.0490087,-0.92951582,-0.81750922,-0.75284368,-0.62590402,-0.57674689,-0.52533709,-0.51955889,-0.43374227,-0.34577001,-0.26624286,-0.20759395,-0.1668884,-0.17411948,-0.12425548,-0.11707451,-0.1944033,-0.14235958,-0.09008895,0.002298244,0.0064672396,0.073800882,0.12711148,0.20277359,0.28608919,0.14338108,-0.021998683,-0.11049474,-0.24965895,-0.35819554,-0.47591641,-0.58975414,-0.59406351,-0.55880541,-0.43346915,-0.36679959,-0.27694268,-0.22018245,-0.16623738,-0.10085117,-0.092154983,-0.0011256677,0.10126578,0.16446644,0.19991717,0.22836561,0.32944383,0.44177111,0.54345088,0.65909283,0.76821419,0.84510005,0.8849081,0.97868371,1.0881375,1.1684482,1.2397205,1.3502085,1.4549052,1.3946628,1.2722172,1.0995415,0.95340812,0.86664085,0.73273315,0.57398289,0.43464559,0.26964114,0.25030274,0.1408605,0.009102797,-0.099922772,-0.057249301,-0.20965163,-0.27680269,-0.42117745,-0.50646104,-0.56595815,-0.64554664,-0.77392045,-0.93340522,-0.86296602,-0.76263726,-0.73731094,-0.67238687,-0.53194247,-0.4304251,-0.29350769,-0.20584095,-0.18670203,-0.041748192,0.041222112,0.14887727,0.24814727,0.2723332,0.44773391,0.53853137,0.64233505,0.63565135,0.73575198,0.92173675,0.88040017,0.83947662,1.0155021,1.0539969,1.182406,1.3005151,1.3925737,1.5112015,1.5936707,1.724027,1.8535647,1.8358178,1.7105642,1.5657057,1.4412832,1.2945553,1.1821216,1.0569939,0.91311581,0.7563888,0.60100498,0.62011783,0.49823826,0.35348139,0.21416166,0.104595,-0.031582895,-0.22179976,-0.28816551,-0.41799368,-0.55580514,-0.70773347,-0.82293804,-0.99482211,-1.1087132,-1.2919598,-1.2866047,-1.43521,-1.5815517,-1.6280716,-1.4998085,-1.4981763,-1.4280583,-1.3007155,-1.1239612,-0.99787897,-0.87029674,-0.78042059,-0.66739872,-0.57162745,-0.40705847,-0.2609922,-0.10589652,0.010980246,0.09556572,0.0019787062,-0.11461447,-0.0055858823,0.093800241,0.18756925,0.26887421,0.38991762,0.38070623,0.34668287,0.44642661,0.57988757,0.6761441,0.68708123,0.52812163,0.41670106,0.34992369,0.38682491,0.27657129,0.10761503,-0.05984422,-0.062261851,0.022438634,0.055795346,-0.060258096,-0.18791961,-0.31053698,-0.4694784,-0.55457948,-0.65367049,-0.79132712,-0.91755021,-1.0621596,-1.1434575,-0.97900948,-0.83801164,-0.69568564,-0.55312504,-0.50433756,-0.36545786,-0.40072817,-0.28715179,-0.15953635,-0.033950825,0.071111436,0.21902881,0.30771118,0.35359537,0.46651386,0.58188492,0.69053707,0.83027352,0.93646577,1.0815669,1.2644818,1.4093113,1.2859795,1.144844,1.033634,0.90434622,0.84129261,0.76352162,0.65488827,0.51529948,0.46495374,0.46514724,0.37266607,0.25609113,0.1511961,0.038123699,-0.10456514,-0.20213272,-0.26604383,-0.20273768,-0.29636704,-0.38956441,-0.51372241,-0.60938373,-0.65873724,-0.74476856,-0.81979439,-0.91180876,-1.0016334,-1.1145315,-1.0062078,-0.85768931,-0.82246997,-0.71944989,-0.5269172,-0.37363578,-0.19004775,-0.07154755,0.057267732,0.019078917,0.16969656,0.32934502,0.47733321,0.61366411,0.82282425,1.021084,1.1385393,1.0870991,0.99721863,0.89371496,0.79335196,0.73956686,0.65435189,0.54109243,0.55150518,0.53616349,0.47314968,0.42403975,0.33550907,0.27437684,0.21914223,0.11201436,0.13971351,0.19321497,0.1409799,0.064247615,-0.014707236,-0.11541992,-0.16965238,-0.17316489,-0.22332062,-0.27604237,-0.33777178,-0.43375942,-0.45896523,-0.57960154,-0.57111487,-0.47385052,-0.36549473,-0.21885706,-0.07296977,0.074461125,0.060961526,0.20914014,0.34323604,0.49078499,0.63101982,0.56015333,0.49232278,0.42409703,0.36936431,0.27286369,0.22567407,0.16619616,0.040630416,-0.062025354,-0.21548754,-0.18503839,-0.12664127,-0.18911127,-0.11529017,-0.2111627,-0.32934672,-0.41617038,-0.46981385,-0.45309775,-0.51129894,-0.58285672,-0.68316533,-0.73919818,-0.83439096,-0.93976404,-0.83295477,-0.69604595,-0.53919667,-0.57702691,-0.68363285,-0.75643255,-0.76103407,-0.85398752,-0.94138225,-1.0038404,-1.0661965,-1.1133074,-1.2111371,-1.283655,-1.3890217,-1.5054019,-1.6778478,-1.7878539,-1.8963624,-1.9528543,-1.7880558,-1.6327066,-1.4770209,-1.3211447,-1.1236189,-0.98762455,-0.8011254,-0.64508826,-0.49305437,-0.28926552,-0.12791345,0.024926478,0.19202506,0.38576881,0.54050466,0.6940556,0.86621465,1.0561039,1.2103119,1.3862045,1.5698596,1.7208358,1.9285383,2.0791161,2.2647729,2.4281202,2.5921167,2.7575446,2.9098364,3.0394645,3.1336087:1
2.7840962,2.6715872,2.5354642,2.409404,2.269649,2.1562343,2.0329818,1.8918373,1.8156835,1.7332354,1.6278205,1.5161989,1.4978645,1.4382138,1.3713994,1.261191,1.1740402,1.064535,1.0262998,1.0381971,0.99268455,0.86705095,0.75476049,0.65280937,0.53630972,0.4197515,0.32223439,0.20236448,0.15803003,0.18650101,0.15872617,0.049428005,-0.058667766,-0.14146934,-0.24626917,-0.35419966,-0.46171513,-0.56208991,-0.67270017,-0.77700492,-0.87999018,-0.96374129,-1.0677247,-1.173751,-1.2767157,-1.3702667,-1.4533847,-1.5612772,-1.5863781,-1.5012284,-1.4438102,-1.343149,-1.3242642,-1.1936919,-1.0554069,-1.0348187,-0.960004,-0.86736785,-0.83457747,-0.72416847,-0.65596248,-0.54682452,-0.47785422,-0.39731046,-0.30560762,-0.18618068,-0.11603825,0.033029146,0.087767732,0.23248844,0.30934427,0.24177602,0.15467898,0.051407425,-0.021910846,-0.11370427,-0.20058496,-0.2446379,-0.33405552,-0.43265576,-0.49896508,-0.54746004,-0.5804135,-0.67923191,-0.76367055,-0.87657188,-0.91454515,-0.93409094,-0.95165083,-0.98991442,-1.1168044,-1.1605185,-1.2688526,-1.2749604,-1.2028159,-1.1067954,-0.99812718,-0.89309651,-0.80541204,-0.67787363,-0.60937944,-0.51786118,-0.4044024,-0.30367236,-0.18044586,-0.062759521,0.046046063,0.13812259,0.23642021,0.34571654,0.45390563,0.54943401,0.67288218,0.7692339,0.88316728,1.0001563,1.1175726,1.2295763,1.2709761,1.1823156,1.0856547,0.99829876,0.95857642,0.83517339,0.83969358,0.74483069,0.65601392,0.60917468,0.67142371,0.63079598,0.57158446,0.46274128,0.44246082,0.34727889,0.34509999,0.40487426,0.3676295,0.31768068,0.2295063,0.19324042,0.14290369,0.052013496,0.0086735112,0.042324827,0.090914288,0.14558209,0.11316659,0.057474778,-0.0040983329,0.024530717,-0.060990908,-0.12911774,-0.11086228,-0.20055767,-0.26076438,-0.27276635,-0.22739088,-0.17312731,-0.18979857,-0.22607313,-0.30997026,-0.30909481,-0.40222493,-0.48945493,-0.52406229,-0.56809585,-0.6677308,-0.76146203,-0.78239849,-0.80200319,-0.8880313,-0.92549601,-1.0372627,-1.0623955,-1.1240077,-1.2483137,-1.2871775,-1.4195234,-1.5576045,-1.6857441,-1.664753,-1.5805614,-1.4852676,-1.4114883,-1.3030891,-1.195756,-1.1030963,-1.0293501,-0.92811689,-0.82350878,-0.71430929,-0.60882068,-0.49454667,-0.39227516,-0.27980406,-0.17100341,-0.096353976,0.015656859,0.03946896,0.12845267,0.23047278,0.31312038,0.39798645,0.49871563,0.61542091,0.71533911,0.76613306,0.8046223,0.89039922,0.98265671,1.0873438,1.2097627,1.227137,1.1803823,1.1419952,1.1946942,1.2474869,1.3272904,1.3958156,1.4483881,1.4818259,1.4836292,1.5562121,1.659593,1.7818014,1.7960651,1.8699756,1.9566169,2.0374341,2.0419176,1.9463457,1.8522385,1.7587025,1.6539734,1.5511718,1.5748978,1.4756572,1.3701786,1.2614361,1.156069,1.0499349,0.94421128,0.83852955,0.73308842,0.62873378,0.58994344,0.48490037,0.38118049,0.2737218,0.16700014,0.056507201,-0.047878573,-0.15294156,-0.26241305,-0.37033504,-0.48377026,-0.59103354,-0.69291525,-0.75439728,-0.86082536,-0.96967902,-1.0778328,-1.1844138,-1.2985769,-1.4099951,-1.5134816,-1.6203616,-1.651199,-1.6847241,-1.5975816,-1.5112506,-1.419058,-1.3923592,-1.2968355,-1.2647947,-1.241633,-1.1810889,-1.108257,-1.1062153,-1.0562005,-1.0183699,-1.097845,-0.99811062,-0.96843335,-0.88185464,-0.82393048,-0.82318067,-0.73171536,-0.74785053,-0.66438266,-0.63138537,-0.57204407,-0.63332003,-0.7074675,-0.76804625,-0.78674482,-0.73522902,-0.66536648,-0.68265517,-0.6145685,-0.54443314,-0.54960544,-0.47933534,-0.44664336,-0.55007492,-0.6251768,-0.64490668,-0.60060383,-0.53203225,-0.56933887,-0.5025313,-0.45541524,-0.40221207,-0.32538025,-0.3478662,-0.43314955,-0.38151206,-0.36978498,-0.28615633,-0.24922559,-0.16604713,-0.25979722,-0.18678298,-0.1455319,-0.070738531,-0.092859222,0.0044518209,0.046260961,0.09224052,0.18912933,0.17881989,0.074072244,-0.028136897,-0.13442565,-0.24708592,-0.35067206,-0.43633904,-0.54434231,-0.64685594,-0.73253451,-0.78353527,-0.79581812,-0.7087864,-0.60360812,-0.50012886,-0.47262035,-0.42902874,-0.32473039,-0.24639408,-0.20283724,-0.09480473,-0.014401521,0.077492247,-0.012909663,-0.087956717,-0.19049583,-0.24140782,-0.30759395,-0.39738518,-0.46100521,-0.49707386,-0.4899214,-0.57970177,-0.67683935,-0.68732294,-0.7854283,-0.84397482,-0.8747097,-0.95840802,-1.0387589,-1.1374087,-1.2243456,-1.2474601,-1.1820973,-1.1206922,-1.013093,-0.92682035,-0.86537014,-0.76033905,-0.69144157,-0.58322713,-0.53640092,-0.459245,-0.35561205,-0.27698338,-0.1931755,-0.050708597,8.7366871E-4,-0.015731336,-0.016114109,-0.0040280082,0.11334399,0.24399889,0.32675687,0.4019292,0.53619451,0.58571298,0.71451523,0.77877154,0.84881403,0.80295179,0.7988514,0.85502,0.97351326,1.0081153,1.1438692,1.2016057,1.3220612,1.4177708,1.3860643,1.3934064,1.5021865,1.5704131,1.6552195,1.7353653,1.707318,1.8165689,1.9109403,2.0368524,2.1508587,2.177102,2.2374111,2.3524448,2.4038735,2.515419,2.6148033,2.7055819:6
1.1195851,1.028228,0.9252182,0.81091243,0.71455904,0.64253047,0.62355453,0.56525392,0.47509095,0.38627116,0.27105673,0.16583864,0.061402459,-0.026429501,-0.080821376,-0.16432515,-0.27828279,-0.39419254,-0.50471789,-0.58878508,-0.65108372,-0.65538754,-0.69653881,-0.71569535,-0.64287596,-0.59154977,-0.47186316,-0.35293701,-0.23275238,-0.11317199,0.0086119149,0.13000065,0.25042557,0.37015343,0.48624173,0.61075711,0.72371163,0.82663379,0.92625796,1.0426112,1.1577803,1.2700266,1.3654988,1.4820261,1.5987085,1.7148468,1.822744,1.7921713,1.6857689,1.5634362,1.4447225,1.3377823,1.2253117,1.1113654,1.0022575,0.98737183,0.96263619,0.87410429,0.76869929,0.67286078,0.57081984,0.52291467,0.4512198,0.48426996,0.51693918,0.56161658,0.54355458,0.45537464,0.36907769,0.31581343,0.20756459,0.11875348,0.023356415,-0.055266407,-0.15773916,-0.27355149,-0.34468136,-0.39184194,-0.3656836,-0.28856719,-0.16406764,-0.045190898,0.012226751,0.0050755671,-0.057939507,-0.13973027,-0.23409114,-0.30546045,-0.36408332,-0.43930212,-0.51518861,-0.54949316,-0.62230078,-0.53389984,-0.48071753,-0.44186899,-0.39003105,-0.38575447,-0.34829685,-0.29437429,-0.25929139,-0.21830641,-0.15193786,-0.051646806,0.036326037,0.12632809,0.19339073,0.16387393,0.056298656,-0.07155526,-0.21103872,-0.32337915,-0.37984048,-0.43482183,-0.36429486,-0.30302596,-0.24521018,-0.18397714,-0.080300038,-0.03881044,0.053874361,0.16323999,0.27645155,0.38154749,0.47743432,0.58269385,0.69324488,0.803012,0.88150554,0.94996057,0.96805493,0.87906063,0.76337773,0.65258417,0.65918716,0.73453321,0.83975558,0.94224469,1.0527357,1.1300235,1.2330147,1.2867718,1.3210039,1.3196186,1.3342925,1.3512659,1.4079919,1.485878,1.5649153,1.6377803,1.7319837,1.8593589,1.9781366,2.0264041,1.9321648,1.8006571,1.6705722,1.5415745,1.4088927,1.2772478,1.1474586,1.0270696,0.89075457,0.74854928,0.63285251,0.51259284,0.37147994,0.23141031,0.082772544,-0.074877314,-0.2224194,-0.37915175,-0.52576228,-0.66390118,-0.81222266,-0.93248526,-1.0689533,-1.0989876,-1.0877441,-1.0260021,-0.99430501,-0.99904668,-0.92703616,-0.81429163,-0.70763986,-0.59786815,-0.52830041,-0.45172059,-0.39581409,-0.36302303,-0.24983021,-0.16243001,-0.063569464,0.042597588,0.13928691,0.24165312,0.32351883,0.38833671,0.42886047,0.49148579,0.55776934,0.65070026,0.73744678,0.81396852,0.88052381,0.96454933,1.056322,1.1653574,1.2483405,1.1893303,1.0323464,0.88961193,0.73156204,0.61280973,0.45422696,0.31612333,0.16903804,0.093855706,0.060595197,0.065001987,0.13077112,0.19340929,0.27345746,0.36820959,0.44695868,0.5179896,0.54017211,0.54058327,0.61728116,0.69011824,0.76867824,0.83849611,0.8911561,0.93093763,1.0266891,1.1277792,1.1312611,1.1095582,1.0013271,0.88248209,0.76713757,0.65324404,0.54233776,0.44249134,0.34286042,0.22800075,0.10528889,-0.012604134,-0.12458917,-0.22856954,-0.32367858,-0.38180097,-0.49410173,-0.61675071,-0.72391743,-0.7511107,-0.87692079,-0.98288331,-1.0165462,-1.1323185,-1.2358416,-1.3667911,-1.4832271,-1.6026441,-1.6946876,-1.8078298,-1.9263892,-2.0535127,-2.1170682,-2.2453156,-2.3329758,-2.4042065,-2.5213224,-2.6394433,-2.683888,-2.7548219,-2.6847962,-2.689024,-2.6479967,-2.7064525,-2.6446255,-2.6181303,-2.5277092,-2.4564614,-2.3630876,-2.2868964,-2.2606254,-2.180811,-2.1006426,-2.0189261,-2.0517626,-1.961886,-1.8614523,-1.7407874,-1.6256037,-1.5225405,-1.4039558,-1.2934121,-1.1561207,-1.0410721,-0.92475394,-0.88279019,-0.75918233,-0.64905911,-0.5313189,-0.41200095,-0.2975716,-0.19450519,-0.10877427,-0.18109294,-0.25460765,-0.317989,-0.37145597,-0.40649523,-0.35694502,-0.30144989,-0.2185816,-0.13712125,-0.060415097,0.0226776,0.11025831,0.16365835,0.19088419,0.27371316,0.36517167,0.44699206,0.5310958,0.63259935,0.74693816,0.85880209,0.8696552,0.75747782,0.65084338,0.56331383,0.48371805,0.40481529,0.30370372,0.21647605,0.16913925,0.12900994,0.099184349,0.015713013,-0.078126303,-0.19599823,-0.32065698,-0.44489074,-0.54656882,-0.63888964,-0.64778687,-0.57971755,-0.47466228,-0.3571908,-0.23807514,-0.18812592,-0.26396147,-0.38532858,-0.49528958,-0.59125472,-0.6727606,-0.76326864,-0.8781016,-0.99527997,-1.0831803,-1.1916181,-1.2979861,-1.4077018,-1.5192999,-1.6249866,-1.6781138,-1.720751,-1.7019492,-1.6218802,-1.5590673,-1.4426563,-1.3290819,-1.2406532,-1.1327128,-1.0243858,-0.90340964,-0.78795933,-0.67428509,-0.56337911,-0.44687384,-0.39602803,-0.32350078,-0.20609162,-0.079427625,0.058687006,0.19097403,0.31762153,0.45111514,0.57092304,0.7000725,0.82291708,0.95282319,1.0827239,1.201399,1.3301022,1.3816272,1.3092391,1.2154983,1.1459984,1.0905661,1.0369175,0.99467753,0.90553228,0.85510477,0.8103604,0.77763172,0.83621383,0.84564753,0.81250573,0.72762786,0.6378508,0.60680078,0.530464,0.45895869,0.40378449,0.37444444,0.37205784,0.424946,0.51999913,0.63081521,0.73793719,0.86269494,0.93738333,1.0537228:5
1.3911773,1.2427788,1.0865586,0.91925287,0.76940179,0.62057737,0.47181344,0.32354761,0.16479859,0.01425927,-0.14466325,-0.29662214,-0.44632219,-0.59348583,-0.7318235,-0.87268159,-0.99552952,-1.1328213,-1.1981082,-1.2856058,-1.3841044,-1.5097708,-1.5676621,-1.5657661,-1.589341,-1.6150416,-1.6238541,-1.517285,-1.4250909,-1.3161268,-1.2176705,-1.116057,-1.0394223,-0.96571727,-0.97872201,-0.9985991,-0.9899007,-0.92920539,-0.91843692,-0.83013022,-0.76985072,-0.69570469,-0.73456566,-0.6268828,-0.52979972,-0.41649443,-0.3235006,-0.24943497,-0.15315982,-0.084879558,-0.09729885,-0.065144726,-0.081940078,-0.067552986,-0.016863969,0.12167801,0.16631946,0.28661172,0.43568001,0.5212851,0.55241485,0.65934725,0.75626342,0.83403499,0.93794911,0.90932744,1.0087331,1.1357283,1.0843101,1.0715604,1.0862105,1.1038172,0.99914779,0.90782413,0.82503564,0.68162963,0.56080832,0.47329344,0.47849374,0.45229795,0.40249667,0.3292525,0.28075989,0.2397337,0.13025014,0.075256756,0.0021287398,-0.043790095,-0.047223287,-0.19870998,-0.34623638,-0.39428826,-0.49554049,-0.6392753,-0.77642306,-0.7859997,-0.89565968,-0.86035589,-0.88044491,-0.85013595,-0.8202447,-0.76192152,-0.68423178,-0.71564878,-0.60385883,-0.54561822,-0.42357308,-0.32203316,-0.27139501,-0.20451435,-0.12271434,-0.14445721,-0.0072370409,0.13130549,0.16908477,0.25127312,0.30530539,0.35590891,0.39993163,0.47143199,0.55871596,0.6300556,0.72557072,0.81364494,0.88336979,0.95724966,1.0357724,1.0327857,0.971088,0.88794977,0.81074469,0.76597806,0.73622665,0.80120629,0.88780221,0.92611609,1.0179841,1.0337889,1.0715163,1.1343974,1.2226728,1.3203024,1.4165371,1.4972537,1.4936894,1.5412502,1.639568,1.7073933,1.7211556,1.7615164,1.8183276,1.8711225,1.8231635,1.6890429,1.5570369,1.434452,1.3185459,1.2116979,1.1670769,1.054921,0.95635469,0.84783548,0.71717903,0.57814846,0.44325789,0.39141256,0.28242499,0.14882226,0.025608781,5.0602845E-4,-0.074763386,-0.18889066,-0.32673043,-0.38289197,-0.4870096,-0.61634598,-0.72678512,-0.86910529,-1.004883,-1.1480822,-1.2933117,-1.4394756,-1.5876738,-1.7247887,-1.867871,-2.0058863,-1.9079024,-2.0038975,-2.0055838,-2.0433495,-1.9514808,-1.9525632,-1.926305,-1.858055,-1.8498939,-1.7169576,-1.5717231,-1.4102451,-1.2617293,-1.0814245,-0.95964382,-0.80809074,-0.73718428,-0.84921039,-0.73280352,-0.58775737,-0.43622783,-0.24536036,-0.0917038,0.013142155,0.027368373,0.012847717,0.0060995712,-0.046070031,0.0091955988,-0.0048741611,-0.0049853628,0.088315308,0.17930084,0.2230426,0.30929976,0.2255617,0.16842623,0.26139404,0.27645287,0.36252462,0.34040501,0.38877049,0.45348251,0.58720099,0.55131905,0.632307,0.64057403,0.75778296,0.90222481,1.023005,1.1188618,1.1664775,1.2467952,1.3270317,1.3949663,1.3309434,1.2168339,1.1596376,1.0481077,0.95374678,0.86680313,0.7724134,0.66543722,0.55889011,0.49841253,0.46290627,0.33146298,0.16265873,-0.0077241122,-0.1849701,-0.34597687,-0.45375786,-0.56824342,-0.48608279,-0.52378142,-0.56976681,-0.61767558,-0.72845714,-0.88491103,-0.98908478,-1.1072095,-1.2315853,-1.3526894,-1.4677024,-1.6005603,-1.7186999,-1.8595493,-1.8919484,-1.9874841,-2.0789964,-2.0650243,-2.1396137,-2.1366841,-2.1785359,-2.1681053,-2.1256952,-2.0753834,-2.0791356,-1.9815031,-1.9408392,-1.9731627,-1.9629984,-1.8722024,-1.8025279,-1.6704517,-1.540819,-1.3936217,-1.233991,-1.1019353,-0.99962246,-0.8647151,-0.72818635,-0.61733393,-0.52437459,-0.51734571,-0.39399126,-0.28266196,-0.19665892,-0.054811415,0.030493692,0.07116164,0.098337078,0.23348648,0.34071118,0.50165442,0.62696795,0.77831449,0.8712768,1.0023679,1.0604836,1.231904,1.4004168,1.5786714,1.6848558,1.8375468,1.8893268,1.8052077,1.7184398,1.6257977,1.5538069,1.4936012,1.4274615,1.3614092,1.3117273,1.2901014,1.2288762,1.1341974,1.0363934,0.95337251,0.8782424,0.78397446,0.72346933,0.74822005,0.84778094,0.97378816,1.098267,1.2231923,1.2554903,1.1792014,1.0901877,0.99900394,0.90188765,0.84051632,0.75929299,0.65447417,0.5588124,0.44811614,0.31780381,0.24352898,0.15486097,0.041199799,-0.11740555,-0.18314439,-0.227474,-0.27513232,-0.40953012,-0.52973574,-0.51567215,-0.59246863,-0.57382365,-0.64443547,-0.58639887,-0.44407344,-0.30921155,-0.16716185,-0.034732251,0.094491242,0.24065251,0.38249696,0.52049664,0.66100571,0.79019846,0.9417138,1.0713868,1.2081489,1.1691483,1.0357568,0.90094319,0.83512369,0.76825132,0.65785868,0.56637354,0.50260607,0.37925494,0.26385659,0.17200331,0.14740428,0.044206282,0.042600105,0.010264009,0.010644053,-0.056041656,-0.11599015,-0.24178105,-0.39382774,-0.56161596,-0.67897945,-0.79270332,-0.80740109,-0.86317144,-0.83040339,-0.79386923,-0.75253306,-0.81511185,-0.85842371,-0.87505591,-0.7247019,-0.55282249,-0.40411498,-0.25723236,-0.083230473,0.06647836,0.23203546,0.39050964,0.53790228,0.69438564,0.86236517,1.010749,1.1604964,1.3155149,1.4401294:5
0.69653153,0.69565525,0.66308281,0.64936734,0.58197376,0.51866457,0.42390043,0.29327887,0.19178814,0.057748685,-0.048884756,-0.16765405,-0.2729431,-0.38695644,-0.49498505,-0.63642547,-0.74198607,-0.87750387,-1.0135409,-1.1203413,-1.2393052,-1.3688249,-1.4760858,-1.5871872,-1.7204588,-1.8366187,-1.9628592,-2.0721768,-2.2051592,-2.3124578,-2.417362,-2.4378671,-2.3510698,-2.2578329,-2.1799286,-2.0817334,-1.9991029,-1.901806,-1.8004996,-1.6940453,-1.6033821,-1.5000174,-1.4024906,-1.3111372,-1.2076239,-1.116702,-1.0223796,-0.91754516,-0.82587282,-0.73903341,-0.6343876,-0.5401217,-0.43770132,-0.34641461,-0.25379437,-0.15252435,-0.048750461,0.047375595,0.098907104,0.19536373,0.2908179,0.38024348,0.41200049,0.4325478,0.52156674,0.57821601,0.68601973,0.80381672,0.8885725,0.94923992,1.0550899,1.091447,1.1721954,1.2252476,1.2706056,1.2829956,1.3020849,1.301264,1.289378,1.2880622,1.2966714,1.3183307,1.3131143,1.2864276,1.2485271,1.188058,1.1373998,1.0690102,1.0053199,0.92231853,0.85717741,0.78430112,0.72368954,0.76852976,0.82574369,0.8920878,0.96621326,1.0350574,1.0689949,1.1779987,1.2503968,1.3034815,1.3680464,1.4100529,1.420372,1.3959491,1.347892,1.2984018,1.2369624,1.1757021,1.1418826,1.1336045,1.0982512,0.98909799,0.97929607,0.91749635,0.84244472,0.74988198,0.68042381,0.6096166,0.52163758,0.45676288,0.37382793,0.37172667,0.28744966,0.20703174,0.10607886,0.0055668202,-0.10872186,-0.216198,-0.31040009,-0.4054614,-0.50126051,-0.57429733,-0.68569086,-0.78998615,-0.90761962,-0.98553331,-1.0763806,-1.1633814,-1.2420539,-1.3193823,-1.3765314,-1.3813555,-1.4756986,-1.417992,-1.3099833,-1.2067714,-1.0863406,-0.95381982,-0.8524005,-0.72179089,-0.62709142,-0.51533053,-0.41528101,-0.32432354,-0.22809098,-0.12917364,-0.031265942,0.056872459,0.14782912,0.22650972,0.30911942,0.40104354,0.43858059,0.49298174,0.50672728,0.50155671,0.47124589,0.44587825,0.38764944,0.35536367,0.30283554,0.24624544,0.15611102,0.057779024,-0.031615185,-0.12794544,-0.18755479,-0.20937734,-0.1376545,-0.036273021,0.089120857,0.18237924,0.26861743,0.29930956,0.29989567,0.26919047,0.23288303,0.17492806,0.11603681,0.038722898,-0.028687428,-0.10227209,-0.17369176,-0.23792976,-0.30111563,-0.3668842,-0.42609505,-0.48171658,-0.526749,-0.57120315,-0.62098454,-0.66845358,-0.71893769,-0.75363522,-0.79244072,-0.80328966,-0.7142619,-0.63494514,-0.56277991,-0.49092351,-0.42905995,-0.38044078,-0.32554777,-0.27104388,-0.2372552,-0.21450529,-0.19741325,-0.16935427,-0.16490105,-0.16468428,-0.15986133,-0.099624972,-0.042628904,0.032181757,0.10164647,0.16179405,0.19779139,0.22369122,0.25722014,0.3060336,0.35405728,0.40697298,0.48090802,0.57589555,0.64752039,0.72839883,0.77847328,0.8267369,0.88388756,0.92132827,0.92804477,0.92890823,0.92297245,0.9702504,1.0614453,1.1622063,1.2532729,1.3543733,1.4488711,1.5214024,1.615362,1.626666,1.6488296,1.69498,1.7359335,1.7507113,1.7491345,1.7397473,1.6688312,1.5943599,1.654822,1.6773165,1.6638471,1.6156865,1.633323,1.6310604,1.599106,1.499919,1.4641216,1.4662044,1.4517292,1.4917088,1.5090088,1.4177564,1.3559821,1.2919413,1.1914543,1.0922676,0.99648935,0.9098458,0.96925104,1.0104693,1.0681923,1.0902219,1.1013978,1.105279,1.0816431,1.0544819,1.0189568,0.96645396,0.91522523,0.87971514,0.83218233,0.77051273,0.72286923,0.70605363,0.65806743,0.63445712,0.60384286,0.56488,0.52593473,0.49157691,0.43868298,0.38273007,0.32639384,0.25704456,0.16989807,0.0717869,-0.021023052,-0.090864788,-0.1790129,-0.15892471,-0.13082417,-0.10589678,-0.062245323,-0.033338297,-0.003395469,0.028752661,0.053463363,0.086929695,0.11156171,0.11350153,0.13879265,0.14443954,0.16428314,0.18161229,0.18219999,0.1716044,0.16283518,0.16595876,0.17542079,0.16095338,0.14357171,0.11223372,0.069852943,0.0011640068,-0.029288134,-0.14440151,-0.25376335,-0.358995,-0.45809688,-0.55162019,-0.64665873,-0.7371787,-0.82903108,-0.90901487,-1.0071525,-1.0952675,-1.1762495,-1.2548375,-1.3330807,-1.4050578,-1.4766352,-1.5417415,-1.6192283,-1.6814951,-1.7467664,-1.798778,-1.8516182,-1.8858431,-1.9235977,-1.934852,-1.9708338,-1.9854746,-1.9710862,-1.9756967,-1.9783403,-1.9666126,-1.9634394,-1.9358599,-1.8972697,-1.8698897,-1.8253823,-1.7893524,-1.7364018,-1.6974713,-1.6444874,-1.5796103,-1.4978598,-1.4409775,-1.3558285,-1.2500487,-1.1339016,-1.0189488,-0.90299962,-0.81967845,-0.71972046,-0.60087492,-0.47918316,-0.36577872,-0.27965585,-0.19034847,-0.10630908,-0.022569935,0.037539465,0.10531155,0.15530571,0.18264077,0.19234318,0.18333342,0.10900072,0.054172788,-0.025794792,-0.09848522,-0.18041028,-0.26385912,-0.33971468,-0.28654842,-0.21400098,-0.13806315,-0.070372172,0.0089290677,0.079045345,0.1605683,0.22460687,0.28830878,0.34799602,0.41446557,0.47424591,0.52375682,0.54388583,0.58744391,0.6273595,0.63449982,0.68045272:2
0.47965214,0.38457702,0.28293671,0.18700703,0.091194376,-0.0088443138,-0.10226057,-0.20448284,-0.33016718,-0.39634993,-0.50349577,-0.58679651,-0.68830327,-0.78358324,-0.86840901,-0.97709974,-1.076816,-1.1919339,-1.2906165,-1.4097279,-1.4960109,-1.6103435,-1.6953871,-1.7887264,-1.835578,-1.8725788,-1.914862,-1.9290173,-1.9354145,-1.912659,-1.8769224,-1.8436466,-1.7886571,-1.7248149,-1.6567704,-1.5508663,-1.4746449,-1.3963633,-1.28154,-1.1681827,-1.0802621,-0.96248981,-0.84764182,-0.75165009,-0.63001285,-0.53530898,-0.42055274,-0.32696682,-0.20121993,-0.074960484,0.050960373,0.17842061,0.30679929,0.43214514,0.5391561,0.66978636,0.79128146,0.8868112,0.97767356,1.0699416,1.0267791,0.93404892,0.82727441,0.72218033,0.61499302,0.52989843,0.44014326,0.35753598,0.27611563,0.20036825,0.13635318,0.081921822,0.067433789,0.077383831,0.11203308,0.1741463,0.24477061,0.32045302,0.41630147,0.49082966,0.59333752,0.67808628,0.77061082,0.87025574,0.95286405,1.0533032,1.157794,1.2608986,1.3631113,1.4663155,1.5501645,1.4910694,1.4876052,1.5400168,1.626422,1.7257208,1.8362447,1.9527362,2.0466216,2.0514372,1.9692972,1.9018544,1.7745828,1.6463424,1.5185286,1.3959104,1.3138217,1.332968,1.38875,1.4289514,1.3207641,1.202289,1.1524328,1.0427809,0.92174574,0.81751936,0.71377856,0.58384887,0.48059141,0.35157054,0.24530671,0.14471913,0.018454964,-0.067664512,-0.1195221,-0.1499405,-0.15850801,-0.14299693,-0.094718235,-0.02280013,0.049792254,0.13369097,0.21407993,0.30519837,0.38567231,0.47859155,0.55513715,0.6460616,0.72726054,0.81292331,0.73969511,0.64809338,0.55626919,0.45171896,0.35853938,0.27008813,0.16820192,0.076705414,-0.01700796,-0.12122447,-0.2030032,-0.30729381,-0.39998116,-0.49950821,-0.60222264,-0.69525594,-0.79124908,-0.8869102,-0.9884318,-1.0865345,-1.1728165,-1.2689085,-1.3653555,-1.4637132,-1.561847,-1.6591227,-1.7455009,-1.8350083,-1.9153972,-1.966291,-2.0249936,-2.0852605,-2.1112609,-2.087289,-2.0704493,-2.0210497,-1.9624553,-1.8835669,-1.7990593,-1.7210818,-1.6133698,-1.5197261,-1.4210479,-1.2933212,-1.1947474,-1.0658434,-0.93532984,-0.825309,-0.70263057,-0.61297388,-0.49168755,-0.39505712,-0.2908418,-0.18715061,-0.081264243,-7.762628E-4,0.0997306,0.20398326,0.17149336,0.071865558,5.1297027E-5,-0.063628062,-0.14102665,-0.21729137,-0.29383506,-0.36359867,-0.42902184,-0.49658287,-0.56654593,-0.63920584,-0.69392029,-0.71022822,-0.63770583,-0.54417254,-0.4901483,-0.58130346,-0.66094302,-0.73790934,-0.80049113,-0.85570333,-0.91422773,-0.96781703,-1.0114191,-1.0540929,-1.0916104,-1.1368761,-1.1701221,-1.1972352,-1.2293541,-1.2528578,-1.2839619,-1.3164958,-1.3316004,-1.3486967,-1.3625419,-1.3645076,-1.360168,-1.3324898,-1.3126686,-1.28657,-1.2602238,-1.2221951,-1.1795252,-1.0800723,-0.99545674,-0.90371794,-0.81775038,-0.72429573,-0.64129351,-0.55048344,-0.47859313,-0.38194861,-0.29429648,-0.19986469,-0.11136122,-0.028733362,0.072338816,0.17050851,0.22482951,0.2446496,0.29654859,0.28945404,0.28167112,0.26601112,0.24527293,0.22449168,0.21658905,0.20727207,0.20835067,0.21106134,0.19026995,0.19308583,0.18361759,0.20053412,0.20664869,0.22398143,0.23664049,0.25928097,0.28179666,0.30436534,0.32840449,0.35815364,0.38388226,0.40290682,0.42797366,0.45565571,0.49554186,0.55050854,0.59503435,0.63724283,0.68146017,0.72711762,0.7676658,0.80792516,0.86968864,0.91251441,0.95107166,0.98858663,1.0263358,1.070509,1.1049265,1.1366506,1.1676476,1.1982951,1.2289581,1.2490824,1.2835604,1.320484,1.3703255,1.4592977,1.4396292,1.488414,1.5520899,1.4637932,1.4012215,1.3986998,1.4284225,1.4598548,1.488428,1.5149034,1.5181158,1.4911896,1.3887739,1.3244062,1.2029459,1.1050271,1.0388518,0.96045639,0.8744845,0.78745591,0.78790428,0.85004893,0.90955217,0.98232834,1.0468227,1.0909647,1.10115,1.1398289,1.1337407,1.1313126,1.1065162,1.0823029,1.1353674,1.1902712,1.2552923,1.2496426,1.2323607,1.2094147,1.182546,1.1647889,1.1603269,1.1551015,1.1489923,1.1368336,1.1348319,1.132543,1.1287239,1.1528728,1.1571222,1.1621971,1.1617619,1.1741904,1.1052419,1.0427358,0.99543658,0.93488667,0.86885808,0.78438866,0.71931892,0.63296198,0.54492588,0.45274657,0.35536459,0.2692015,0.18087842,0.098572494,-3.3222853E-4,-0.091861125,-0.18483968,-0.28555549,-0.38819819,-0.4798238,-0.535648,-0.62080503,-0.67524237,-0.74891893,-0.79411449,-0.84726339,-0.88929166,-0.9321964,-0.95374898,-0.97425838,-0.9928241,-1.0178106,-1.0189512,-1.0185505,-1.0129823,-1.0016103,-0.99854729,-0.97987162,-0.9507278,-0.92853096,-0.90629105,-0.88320863,-0.85449167,-0.82341511,-0.78190501,-0.73120821,-0.67331337,-0.63067373,-0.56499334,-0.50386128,-0.43737383,-0.37249182,-0.29767481,-0.22662767,-0.15151163,-0.16494985,-0.19060047,-0.13043614,-0.061884419,0.024796557,0.1052848,0.1862801,0.27731857,0.36243046,0.43832105:4
2.0568524,1.9556504,1.8710636,1.7895469,1.7073255,1.6256672,1.5163052,1.4235964,1.4498445,1.510482,1.5219526,1.44026,1.3533075,1.2706908,1.1939721,1.1048326,1.0235011,0.94521257,0.86364691,0.76778448,0.68492658,0.60461743,0.4987159,0.41933187,0.33692882,0.23484288,0.1463786,0.11785944,0.11713256,0.16481866,0.23296127,0.3035401,0.3658847,0.42877236,0.50025935,0.558029,0.50541584,0.4187267,0.34251607,0.25479751,0.18883015,0.11149639,0.028337032,-0.043247458,-0.1239019,-0.21021432,-0.29335609,-0.36396381,-0.44405383,-0.52527328,-0.5972837,-0.67287228,-0.75336988,-0.82836117,-0.9105583,-0.99162768,-1.0752048,-1.1413327,-1.2238901,-1.3062244,-1.378996,-1.4562282,-1.5309634,-1.5990207,-1.6727503,-1.7298126,-1.7870324,-1.8296731,-1.8520145,-1.8405223,-1.7761262,-1.7023651,-1.628597,-1.5540981,-1.4482085,-1.3721039,-1.263735,-1.1536178,-1.0435103,-0.96561462,-0.85522249,-0.76404577,-0.70365647,-0.59797462,-0.51440307,-0.42401502,-0.32559725,-0.21598825,-0.10642117,0.003224607,-0.02897065,-0.13883793,-0.2180031,-0.2968031,-0.37606494,-0.45364456,-0.53151883,-0.60064091,-0.66061703,-0.72741971,-0.78400167,-0.79893382,-0.75005001,-0.70513222,-0.77615197,-0.83125032,-0.8956208,-0.95230164,-1.0134811,-1.0544463,-1.1015759,-1.1479763,-1.1772855,-1.2153779,-1.2495355,-1.2645708,-1.2798602,-1.2921774,-1.2959448,-1.2758235,-1.2483741,-1.2327401,-1.2129329,-1.1757845,-1.138223,-1.0909736,-1.0305661,-0.9398897,-0.83906683,-0.75844086,-0.68370011,-0.60065711,-0.53667691,-0.49095239,-0.45532032,-0.39454328,-0.32866661,-0.26176974,-0.18809174,-0.10666531,-0.056323455,-0.020380327,-0.018733292,-0.017055062,-0.016735962,-0.0071439523,5.3611046E-4,0.022218542,0.04642154,0.066596294,0.10421991,0.1322568,0.16581329,0.22427097,0.31537398,0.38623095,0.41829125,0.43340331,0.44574609,0.44723756,0.44183835,0.38103402,0.29877307,0.25309284,0.26233243,0.25257692,0.30516294,0.37063072,0.40490577,0.45713653,0.50667334,0.56065649,0.61039448,0.64868198,0.69592268,0.72704904,0.7627336,0.79339991,0.82737508,0.85774436,0.89169538,0.91801299,0.93496101,0.95316496,0.96017132,0.96152598,0.97425333,0.97745161,1.0476489,1.1247956,1.208867,1.3200137,1.3991251,1.5098393,1.5938673,1.6980594,1.8072577,1.8970015,1.8997909,1.790968,1.6803374,1.6025917,1.4937449,1.3933708,1.31645,1.2593918,1.150693,1.0674384,1.1109405,1.185088,1.2545925,1.1986884,1.1377603,1.1018304,1.097241,1.1428604,1.1757277,1.2183094,1.2300817,1.2493865,1.2390227,1.2438011,1.2281661,1.2178027,1.1964103,1.1700032,1.1382878,1.1143053,1.1026562,1.0777148,1.0505375,1.011625,0.97945912,0.94922899,0.91233522,0.87497805,0.83971918,0.8132717,0.78614806,0.76595989,0.73528966,0.67171095,0.65118916,0.63462251,0.61534297,0.60614576,0.60018177,0.57834738,0.53524981,0.51232915,0.48072958,0.44017992,0.39164786,0.35151379,0.30394927,0.24318552,0.20264774,0.14758987,0.067119683,-0.0134369,-0.095739653,-0.16844884,-0.25513397,-0.33014975,-0.40316732,-0.47640056,-0.51641436,-0.55956225,-0.59546165,-0.61422948,-0.63540691,-0.65739545,-0.66667273,-0.66898136,-0.67730307,-0.67165169,-0.67642212,-0.67018589,-0.66710717,-0.65554555,-0.64914939,-0.64239055,-0.62906918,-0.60900555,-0.58432756,-0.55217754,-0.51501952,-0.47284473,-0.4203328,-0.37289161,-0.37730504,-0.42305678,-0.41551735,-0.37321505,-0.33337103,-0.28459901,-0.2349626,-0.18872257,-0.14272422,-0.093347392,-0.034860001,0.021094133,0.033206425,-0.041451426,-0.10694751,-0.17232051,-0.23943148,-0.30376385,-0.36352689,-0.43022049,-0.50912579,-0.59745714,-0.66667652,-0.73144212,-0.79732329,-0.8694012,-0.93647993,-1.0021245,-1.0740921,-1.1299588,-1.2079257,-1.2651976,-1.3404753,-1.3964935,-1.4684237,-1.5783705,-1.6562549,-1.7588062,-1.8437769,-1.9205413,-1.9905226,-2.0431167,-2.0996005,-2.1369607,-2.1658296,-2.1651007,-2.1569463,-2.1361326,-2.0999795,-2.0440123,-1.9630252,-1.9046767,-1.8304577,-1.7484888,-1.6822313,-1.5835811,-1.4991179,-1.4448436,-1.3797885,-1.3052587,-1.2055125,-1.1044298,-1.0485778,-0.99328779,-0.94015686,-0.84073362,-0.7365653,-0.6306873,-0.52443384,-0.41747192,-0.31164882,-0.20570403,-0.098682372,0.0096617838,0.11883104,0.22687245,0.31210393,0.40299496,0.35011294,0.33411038,0.39434998,0.50182801,0.61103256,0.72039036,0.8027363,0.91131091,0.96338838,0.88778874,0.80860062,0.74582522,0.6650239,0.59254812,0.51018732,0.43274887,0.36079829,0.29693303,0.22637074,0.15818198,0.10151117,0.042822507,-0.0040799313,-0.048275548,-0.075368911,-0.080771987,-0.03350243,0.014859109,0.078683696,0.15415472,0.23765725,0.32054662,0.40149221,0.48629775,0.56730889,0.65135952,0.73402376,0.80809665,0.88800644,0.97888272,1.0663942,1.1480607,1.2333488,1.3166336,1.3985442,1.4305316,1.3558966,1.2984221,1.2954333,1.3553313,1.4195745,1.5076024,1.5926853,1.6686877,1.7387627,1.8214503,1.9060343,1.981383,2.0512709:4
0.45747258,0.3679783,0.3033898,0.23900523,0.16957536,0.1032015,0.03188769,-0.034506651,-0.077914626,-0.055068456,0.03484653,0.17190384,0.16136183,0.060678837,-0.016624024,-0.084711659,-0.14898808,-0.21861661,-0.25918992,-0.29997287,-0.34788861,-0.38080796,-0.42148957,-0.45217544,-0.48627808,-0.5106821,-0.51844376,-0.51902356,-0.50902386,-0.49191091,-0.46810824,-0.44579047,-0.40985711,-0.36785724,-0.31832895,-0.22611303,-0.12757626,-0.020635889,0.077629079,0.16587163,0.23120547,0.29849972,0.35744936,0.42273956,0.48924004,0.55420769,0.59792411,0.65525392,0.73505523,0.81474324,0.78858258,0.76829206,0.77661356,0.80634741,0.8970803,0.97586389,0.98066839,0.97489117,0.98097686,0.96936016,0.97859536,0.99261247,1.0018286,1.0175248,1.0318576,1.0434898,1.0643074,1.0973297,1.1272979,1.1537122,1.1879827,1.2160597,1.2587211,1.29568,1.3415923,1.3615022,1.3966758,1.4237079,1.4526069,1.4760295,1.5107634,1.6130212,1.621996,1.5039576,1.459867,1.5797636,1.5092165,1.4249729,1.342168,1.2750861,1.2541253,1.2384992,1.2193551,1.1995474,1.1820457,1.157954,1.1257931,1.0861486,1.0408638,0.99771974,0.9570023,0.91599349,0.88162071,0.83705382,0.81088852,0.78601659,0.76705178,0.73103898,0.69306891,0.66455065,0.6496477,0.64416035,0.64445453,0.64217551,0.64907564,0.65824428,0.67863142,0.7021312,0.71103702,0.66316979,0.59365536,0.52173486,0.44809053,0.37912065,0.30790374,0.23552847,0.17609554,0.11353252,0.043639179,-0.0098828468,-0.10240908,-0.19943508,-0.2545355,-0.30307605,-0.34106554,-0.37399674,-0.39783936,-0.41002516,-0.41854736,-0.42151271,-0.41244033,-0.40139065,-0.37878804,-0.36383143,-0.34225222,-0.32593715,-0.31276944,-0.27668987,-0.23669005,-0.1907716,-0.15313945,-0.11832771,-0.080717016,-0.038566091,0.0072019648,0.068653119,0.1279537,0.18105852,0.24808637,0.32306019,0.42470313,0.51279496,0.58125215,0.49562495,0.37918759,0.27405294,0.18515896,0.16421229,0.16757911,0.21182985,0.26727369,0.32525249,0.39610017,0.46439209,0.53655148,0.61326004,0.71862038,0.85588941,0.83790365,0.74587545,0.61104524,0.5268981,0.43959095,0.33701664,0.23306148,0.12677982,-0.0068812395,-0.092085446,-0.17030864,-0.18519789,-0.28003342,-0.36397357,-0.45351671,-0.53273086,-0.61046883,-0.70958788,-0.80461051,-0.9007241,-0.99347526,-1.0786384,-1.1764283,-1.2621865,-1.3505945,-1.4691736,-1.5863274,-1.6925196,-1.7903894,-1.8961869,-1.9836113,-2.0645209,-2.1347946,-2.1461343,-2.1231342,-2.0886197,-2.0352005,-1.9734419,-1.9030067,-1.8349184,-1.7602702,-1.6886722,-1.6033394,-1.5262642,-1.4450407,-1.358286,-1.2750675,-1.1877157,-1.1047228,-1.0279026,-0.94746101,-0.85489576,-0.77969498,-0.68779757,-0.59561253,-0.50875602,-0.4202693,-0.32893583,-0.24541378,-0.15685956,-0.05946557,0.043733728,0.13878772,0.21996932,0.1684048,0.083328251,0.11526949,0.21842198,0.31643652,0.40466549,0.50958867,0.61975954,0.70989439,0.81768278,0.91735731,0.94486763,0.84306115,0.73418009,0.63578175,0.58018537,0.48238759,0.383455,0.2846766,0.18842866,0.087786645,-0.0070036037,-0.10926069,-0.19876444,-0.29104212,-0.38003078,-0.47277472,-0.55716572,-0.62735385,-0.65732216,-0.65742966,-0.62825606,-0.57141209,-0.50052128,-0.40386347,-0.30595485,-0.17466615,-0.035029315,0.077528973,0.21250805,0.32040003,0.4028959,0.53705769,0.64563405,0.73026413,0.73045936,0.78024767,0.84369354,0.93614009,1.0161629,1.1367389,1.1342702,1.0469894,1.0603988,1.1201173,1.1937596,1.2765363,1.352379,1.4281685,1.503538,1.5856669,1.6636933,1.7517778,1.8579242,1.9490306,2.0362701,2.1256221,2.2161488,2.1865436,2.089655,2.0018357,1.906735,1.7934397,1.6790747,1.5646352,1.490483,1.3975967,1.2942847,1.1931261,1.1029144,0.99086931,0.87310325,0.73648219,0.62439498,0.54184571,0.48987125,0.50009588,0.54677408,0.54005038,0.46739861,0.43073622,0.35482174,0.28317394,0.19515424,0.1012233,0.0054264956,-0.12862829,-0.2433738,-0.38288282,-0.52328755,-0.66356731,-0.80330887,-0.93711127,-0.98905624,-1.0253826,-1.0361966,-1.0041208,-0.93802996,-0.86511557,-0.79137526,-0.71708195,-0.64533747,-0.58352747,-0.50461053,-0.42499933,-0.33009191,-0.26375772,-0.18187883,-0.085936513,-0.023799835,-0.12287246,-0.21243574,-0.30907453,-0.40578949,-0.49646097,-0.61031577,-0.62900788,-0.56080518,-0.48674951,-0.56177828,-0.66074513,-0.75997978,-0.86353155,-0.96136362,-1.0577916,-1.1636439,-1.2680707,-1.3668036,-1.4618943,-1.5627545,-1.6601903,-1.7470089,-1.8475395,-1.927233,-2.0255123,-2.1034799,-2.1907843,-2.2735901,-2.3462983,-2.4118794,-2.459792,-2.4853051,-2.4501382,-2.3832185,-2.2923936,-2.2005808,-2.1070819,-2.0091989,-1.8985521,-1.7676529,-1.6711198,-1.5725183,-1.480849,-1.4115805,-1.3328934,-1.2564737,-1.1782793,-1.1008268,-1.0198782,-0.93718143,-0.82960895,-0.7409599,-0.64405619,-0.54316178,-0.453915,-0.36221193,-0.25060436,-0.18480617,-0.1376121,-0.030903037,0.063683168,0.15114671,0.23165765,0.32800854,0.40474791:4
0.99111978,0.92726234,0.85656401,0.78490288,0.6952192,0.63318046,0.54339843,0.47106894,0.40104226,0.32718494,0.26112742,0.20123327,0.13550233,0.065895027,-0.011647738,-0.095625306,-0.16930322,-0.24711906,-0.31360609,-0.39138334,-0.47521508,-0.55300302,-0.62107465,-0.70783524,-0.79124129,-0.89096892,-0.99166831,-1.0773924,-1.1868941,-1.2931163,-1.4016254,-1.5086914,-1.6142873,-1.722504,-1.83136,-1.9184105,-2.0180561,-2.113187,-2.2039921,-2.2908465,-2.3772332,-2.4536164,-2.507965,-2.5256002,-2.4427367,-2.3240971,-2.2092343,-2.0999955,-1.9890808,-1.8692128,-1.7461495,-1.6301566,-1.5191659,-1.4128296,-1.2862901,-1.1855865,-1.0555582,-0.9527384,-0.83724697,-0.72161567,-0.60661274,-0.49331752,-0.38508749,-0.26158887,-0.15491857,-0.037668941,0.068198772,0.17257293,0.27294253,0.38727174,0.48672277,0.57481942,0.63929205,0.67495142,0.68591395,0.690042,0.67613345,0.65470872,0.62546493,0.59121285,0.54801847,0.50822023,0.46868246,0.4089386,0.35732138,0.2843333,0.21131169,0.12481557,0.05745761,0.0027591673,-0.059824019,-0.12118811,-0.19500969,-0.27772312,-0.33561827,-0.40181255,-0.46781738,-0.54217497,-0.61272553,-0.68188329,-0.75930811,-0.84606206,-0.93722651,-1.0114495,-1.0822447,-1.1402179,-1.1740448,-1.1393852,-1.064861,-0.99084592,-0.91701769,-0.85303058,-0.77465128,-0.6943362,-0.61822254,-0.52596275,-0.43559697,-0.32972432,-0.23485281,-0.1272938,-0.0048025955,0.11706242,0.18840768,0.28142321,0.37311822,0.45418859,0.49780916,0.54203075,0.58113624,0.61577739,0.64318381,0.68139721,0.71469204,0.75932301,0.79241932,0.82430127,0.85261148,0.88425223,0.90315331,0.92826648,0.95823762,0.98998284,1.0303096,1.0689579,1.1043929,1.1437088,1.1646022,1.175821,1.2079282,1.2194554,1.2320783,1.2357876,1.2251864,1.201893,1.1762732,1.1708501,1.1793032,1.1710558,1.2398003,1.3513518,1.4509874,1.5654586,1.6564033,1.7540074,1.8387721,1.9334156,1.9840373,2.0174109,2.0392107,1.9948446,1.9083939,1.7785324,1.6776438,1.5839503,1.5570048,1.5322798,1.4843265,1.3694994,1.2468616,1.1325233,1.0659473,1.0412548,1.0218108,0.99145101,0.97425018,0.95245747,0.91970205,0.893644,0.8740027,0.82770561,0.78784249,0.72679418,0.65128933,0.5789376,0.51721055,0.47488769,0.41605229,0.44721234,0.41629653,0.38968779,0.35952092,0.32695511,0.33083685,0.34019268,0.31687343,0.32128879,0.29607001,0.23132691,0.1639267,0.047780057,-0.10624628,-0.25366223,-0.36273626,-0.466219,-0.55504384,-0.62747931,-0.70367218,-0.65992756,-0.60453838,-0.55074285,-0.51117529,-0.45676495,-0.41610346,-0.39893842,-0.36644088,-0.32920462,-0.28727313,-0.24656779,-0.20942614,-0.17952377,-0.16973355,-0.16378982,-0.14447441,-0.155115,-0.17906255,-0.19467036,-0.21444749,-0.2503569,-0.29923651,-0.38108876,-0.4773185,-0.53560158,-0.62435481,-0.77000558,-0.90046186,-1.0192031,-1.1455623,-1.2620513,-1.3780791,-1.4761091,-1.5763444,-1.6123558,-1.5536443,-1.5623282,-1.5288033,-1.4452646,-1.3505005,-1.2589203,-1.1338092,-1.0254679,-0.90943195,-0.84985003,-0.75507692,-0.66060343,-0.55911913,-0.45939731,-0.40762924,-0.30835639,-0.2177152,-0.1561933,-0.10476373,-0.043402854,-0.014120013,-0.045454043,-0.067139848,-0.12464573,-0.16400286,-0.19454694,-0.135325,-0.069299242,0.0036514116,0.1124468,0.18391231,0.25673292,0.32354438,0.37253019,0.43523705,0.46895375,0.50633764,0.5204198,0.43773127,0.35748002,0.2744093,0.16476675,0.071620314,-0.031596162,-0.13529303,-0.23277821,-0.33826693,-0.45055449,-0.55920927,-0.65938875,-0.7851953,-0.88205891,-0.94451517,-1.0455942,-1.1671438,-1.2953174,-1.4398986,-1.5573205,-1.6556121,-1.7615267,-1.8572549,-1.9308492,-1.9823683,-1.9142238,-1.8100792,-1.6579396,-1.5067764,-1.390949,-1.2418039,-1.0890686,-0.94045547,-0.82506953,-0.67925183,-0.55971112,-0.40558096,-0.28604878,-0.16849864,-0.022194871,0.09842615,0.21314369,0.32829168,0.44451006,0.56044997,0.65894729,0.76087095,0.85111173,0.95042839,1.0303922,1.1192921,1.1989103,1.2751826,1.346703,1.4057694,1.4299739,1.3995476,1.3674725,1.3113365,1.2555453,1.1899495,1.1207163,1.0540644,0.97966817,0.90190388,0.83496935,0.74095639,0.79901936,0.889124,1.0066689,1.0974855,1.1839527,1.2671703,1.353729,1.4332593,1.5036741,1.5377068,1.4973928,1.4349373,1.3640792,1.2713907,1.1897839,1.2292107,1.2720268,1.3050477,1.2622538,1.1960263,1.128473,1.0697925,0.99405417,0.94016318,0.86490468,0.7922231,0.7062161,0.59592561,0.47017377,0.35662743,0.26197409,0.15115283,0.027610555,-0.082368716,-0.20414301,-0.29893501,-0.41683283,-0.52562113,-0.64250253,-0.74792667,-0.85638243,-0.96557675,-1.0766452,-1.2001198,-1.3033978,-1.3452407,-1.222654,-1.1163983,-1.0063357,-0.87006163,-0.75592287,-0.64086328,-0.52490917,-0.4045132,-0.27153195,-0.15801111,-0.022102141,0.11018057,0.24620943,0.38237314,0.51791433,0.65196914,0.75033076,0.85074915,0.95101148,1.02519,1.0825152,1.0779815,1.0658207,1.0356908:2
2.0718812,2.053948,2.0658342,2.0232204,1.9756527,1.9055142,1.8818946,1.9430499,2.0121152,2.0891116,2.1540565,2.2299197,2.3041652,2.3285029,2.2518401,2.1740991,2.1028397,2.0376651,1.9670418,1.903312,1.825285,1.7983274,1.7389006,1.6229341,1.5646331,1.4568155,1.351262,1.2475201,1.1415503,1.0458231,0.93593764,0.84106127,0.73997447,0.63116277,0.52748618,0.44624671,0.34997563,0.24389648,0.15306029,0.03242467,-0.057812191,-0.16594005,-0.25732754,-0.36611587,-0.47370712,-0.56178508,-0.66785952,-0.76706233,-0.86307048,-0.96682884,-1.071746,-1.1670341,-1.2524038,-1.2978922,-1.3848116,-1.4718996,-1.5401377,-1.4500819,-1.3639257,-1.3057729,-1.2122829,-1.114823,-1.0202637,-0.92203678,-0.82751255,-0.73064379,-0.73789372,-0.67144977,-0.59223859,-0.54069459,-0.5536709,-0.48947338,-0.42727222,-0.42944474,-0.39033972,-0.36337517,-0.42816878,-0.50768055,-0.56813821,-0.617292,-0.58516481,-0.54304947,-0.52275932,-0.46425193,-0.46531797,-0.41803178,-0.36683425,-0.31214163,-0.33440529,-0.41278782,-0.40207437,-0.34294361,-0.31638096,-0.25280298,-0.22240455,-0.20950795,-0.14647457,-0.12804464,-0.16528189,-0.12652143,-0.071903769,-0.012026025,0.036872018,0.038156713,0.058097266,0.12911696,0.19002213,0.22153069,0.27765959,0.35352174,0.41223991,0.50971434,0.59138458,0.65764455,0.58730465,0.49998244,0.41843956,0.31881888,0.29176937,0.2017489,0.11198269,0.061122448,-0.01139841,-0.10192507,-0.16691163,-0.25265452,-0.34152122,-0.44338563,-0.5187001,-0.59312252,-0.64979052,-0.66719066,-0.74144882,-0.82620033,-0.91509819,-1.0069289,-1.0737786,-1.0447413,-0.95228816,-0.86052164,-0.81138554,-0.70749868,-0.61581134,-0.51346076,-0.41650918,-0.33345402,-0.23000591,-0.11691119,-0.003229812,0.082547425,0.17496372,0.26001965,0.2441214,0.16831736,0.13400424,0.094994463,0.01050684,-0.025817277,-0.028231813,-0.10972339,-0.1231316,-0.046510025,0.030167989,0.11318071,0.17914787,0.24464791,0.27782806,0.22731859,0.21226739,0.2983493,0.35699748,0.46464104,0.51936476,0.59290638,0.55851464,0.54934243,0.57359915,0.62774412,0.70329871,0.79575914,0.84874834,0.83820717,0.91955737,1.001263,1.0841822,1.1533677,1.1435736,1.2335414,1.3129899,1.3901453,1.4546444,1.5463146,1.6331903,1.7109056,1.8000603,1.8884375,1.9710662,2.056601,2.1223041,2.0318054,1.9356445,1.8503396,1.7644913,1.7076138,1.622462,1.5305776,1.5101883,1.414664,1.3196227,1.28707,1.2397422,1.1478325,1.0925086,1.0013742,1.0103707,0.99814204,0.89839471,0.85492405,0.76144501,0.75290325,0.77292788,0.6735565,0.5824171,0.49127484,0.46855617,0.41358584,0.36706662,0.27329218,0.2185503,0.13387036,0.10749586,0.025902486,0.082118746,0.053073388,0.077583266,0.097201616,-8.0906493E-4,-0.082269865,-0.12328846,-0.20792361,-0.27154206,-0.30412938,-0.38960501,-0.48088026,-0.57319369,-0.66646238,-0.63725725,-0.54922443,-0.49965178,-0.49907581,-0.40231222,-0.38467818,-0.32375828,-0.24986863,-0.22119968,-0.18669666,-0.20305597,-0.28440352,-0.36991412,-0.43195378,-0.5249828,-0.56587213,-0.66131389,-0.75634417,-0.76291094,-0.8521603,-0.9475203,-1.0148225,-1.109635,-1.1508595,-1.1853234,-1.2776032,-1.3869237,-1.4842857,-1.5904015,-1.700355,-1.8090748,-1.8865559,-1.9380172,-2.0402459,-2.1358414,-2.2192141,-2.1775602,-2.0992186,-2.0130129,-1.905663,-1.796699,-1.7541995,-1.6678422,-1.5604813,-1.4744176,-1.4225111,-1.3418117,-1.2356243,-1.164025,-1.182647,-1.1201235,-1.0651377,-1.0063796,-0.90121154,-0.86337397,-0.79368342,-0.7028133,-0.61515718,-0.6069146,-0.51168152,-0.43904695,-0.35746029,-0.24752352,-0.19876461,-0.15661238,-0.046905678,0.062312028,0.13246115,0.17281023,0.22904945,0.32853624,0.42474228,0.49676495,0.60762403,0.68529642,0.76945112,0.7229106,0.64114933,0.56244643,0.49547008,0.3970101,0.33792782,0.29515653,0.20592165,0.082771398,0.088504471,0.0073707014,-0.085887249,-0.10783809,-0.095606831,-0.18365332,-0.23087015,-0.33041089,-0.29854977,-0.21861736,-0.28200659,-0.32882615,-0.43407598,-0.49094713,-0.46820241,-0.38145628,-0.41194039,-0.48035644,-0.48615494,-0.56625445,-0.59355539,-0.54401858,-0.4870499,-0.41876991,-0.43446835,-0.47843729,-0.53574518,-0.59308722,-0.59714915,-0.67432491,-0.74132092,-0.81140683,-0.88233376,-0.80029852,-0.71821747,-0.62597345,-0.5815778,-0.61304995,-0.62330899,-0.65775205,-0.69824257,-0.67417731,-0.73603545,-0.80549946,-0.84218502,-0.90132095,-0.94975685,-1.0139943,-1.0722223,-1.1271658,-1.1658501,-1.2061124,-1.2727828,-1.3434239,-1.4216913,-1.4614117,-1.4332433,-1.3369002,-1.2466735,-1.1390394,-1.0512593,-0.96543057,-0.87085713,-0.76168648,-0.68338812,-0.62632301,-0.5237239,-0.42817448,-0.31947573,-0.21115079,-0.12072725,-0.012957592,0.095427304,0.20022157,0.26072336,0.28739571,0.38357776,0.48093701,0.58027175,0.68858564,0.8041937,0.90582318,0.98965667,1.0802481,1.1873763,1.3048455,1.4194227,1.5398678,1.6464292,1.7295432,1.786345,1.857266,1.8985004,1.9461038,1.9915355,2.0353156:6
1.0944304,0.99006837,0.8974988,0.83213919,0.74257103,0.68359764,0.62570464,0.52216754,0.42220479,0.35934907,0.28850444,0.20697456,0.093214772,0.0062842465,-0.081525925,-0.19884981,-0.32166268,-0.41858094,-0.51605136,-0.63148983,-0.73046326,-0.80681724,-0.91753893,-0.94289909,-1.0270024,-1.045816,-1.0271551,-0.92229544,-0.79591533,-0.66516425,-0.53617561,-0.40718496,-0.2851419,-0.17032782,-0.06267674,0.037251369,0.13750022,0.24564373,0.34005092,0.4422082,0.54201608,0.64558353,0.74546411,0.84183312,0.88311833,0.78366627,0.65161161,0.52467415,0.41481737,0.33167967,0.23819557,0.15222542,0.035805894,-0.07109544,-0.15054928,-0.22470864,-0.31553712,-0.37253808,-0.36938905,-0.43357569,-0.53793267,-0.65089921,-0.75145061,-0.85478216,-0.94591128,-1.0339132,-1.1172226,-1.0990379,-1.1103848,-1.1993478,-1.2857606,-1.371305,-1.4526186,-1.5474013,-1.6264404,-1.6827974,-1.7476531,-1.7597165,-1.7188514,-1.6526699,-1.5496581,-1.4554295,-1.3903246,-1.3060352,-1.2111915,-1.1149374,-1.0174558,-0.91621953,-0.80957256,-0.71851447,-0.62436672,-0.5155,-0.41047028,-0.32112898,-0.22611734,-0.15710144,-0.053511155,0.040613667,0.12374945,0.22250503,0.31506985,0.41419716,0.51130238,0.59867941,0.69876454,0.78394609,0.87631783,0.96542786,1.0603998,1.151477,1.2487841,1.3371796,1.399629,1.4820721,1.5646971,1.6562048,1.7475121,1.8441482,1.9262552,2.022353,2.113921,2.2046704,2.2948882,2.3658385,2.3288437,2.2371635,2.137489,2.0452197,1.946267,1.8530992,1.7561584,1.6644457,1.5696699,1.4738955,1.3772789,1.2840751,1.1896246,1.0958674,1.000083,0.91641774,0.82336072,0.72664082,0.63245437,0.53546091,0.44072333,0.34446998,0.24730608,0.15131064,0.053482886,-0.045553349,-0.15044473,-0.24756456,-0.30580948,-0.39205298,-0.46916734,-0.53644966,-0.63491711,-0.72754136,-0.81911475,-0.91194125,-0.97749012,-1.0726899,-1.1545559,-1.231921,-1.351226,-1.4245141,-1.5066689,-1.6101044,-1.6905779,-1.7174466,-1.8185592,-1.7555096,-1.7239549,-1.6983789,-1.6360584,-1.5617863,-1.5136842,-1.4709995,-1.3763261,-1.3300714,-1.3619661,-1.3856005,-1.4087134,-1.3551107,-1.2781434,-1.2010081,-1.1981596,-1.1408915,-1.0594163,-1.0053696,-0.91149887,-0.82522061,-0.74710117,-0.66885772,-0.66841248,-0.69435878,-0.71088737,-0.64158183,-0.56012178,-0.50206749,-0.4276954,-0.3572444,-0.34517872,-0.2380838,-0.13453694,-0.016757594,0.11166049,0.23246295,0.34218537,0.28977199,0.19000313,0.088755062,-0.0020755245,-0.089129971,-0.17243964,-0.27377938,-0.36765721,-0.45069647,-0.55214598,-0.6614433,-0.77898392,-0.90338956,-1.0246294,-1.1427696,-1.2727997,-1.3853997,-1.4940605,-1.5538268,-1.5584628,-1.4806832,-1.3893435,-1.3290736,-1.2599722,-1.1320697,-1.0549009,-0.9267598,-0.80764572,-0.70010355,-0.5710689,-0.49667609,-0.42687171,-0.30797125,-0.20127694,-0.10145862,0.0078411265,0.10828725,0.22830945,0.35551431,0.46142946,0.46279951,0.38540102,0.31318619,0.25172563,0.19633391,0.13788187,0.077681082,0.034113929,0.042580667,0.074526179,0.16798686,0.22549611,0.30419603,0.40674595,0.4902064,0.5570225,0.5649954,0.61875206,0.71270164,0.80642982,0.87885591,0.96145616,1.0596674,1.1485173,1.0614306,0.95502259,0.83946012,0.72245628,0.61352235,0.54265659,0.43715315,0.35655393,0.25546687,0.20724893,0.20693355,0.2220003,0.13722437,0.034908665,-0.07052915,-0.1751408,-0.27427289,-0.38009446,-0.48388357,-0.59019224,-0.69569416,-0.78478944,-0.8688992,-0.92436856,-1.0323084,-1.1369626,-1.2407286,-1.3472988,-1.4529999,-1.5253403,-1.6229116,-1.7127591,-1.6913216,-1.7808829,-1.8356122,-1.8875349,-1.8898575,-1.8883188,-1.9033157,-1.8238833,-1.7236734,-1.6243046,-1.516381,-1.4212808,-1.3110494,-1.1767737,-1.0639727,-0.9348366,-0.81421239,-0.70336919,-0.57518027,-0.47297118,-0.34588577,-0.25416087,-0.19673264,-0.078832719,0.0022834061,0.11591128,0.25870498,0.37236335,0.49517022,0.61818489,0.74188063,0.80671177,0.72671181,0.65040636,0.58047587,0.5115926,0.44775053,0.41621525,0.48250139,0.55915833,0.6604856,0.74622244,0.82885014,0.90806207,0.98189685,1.065827,1.0858858,1.1404449,1.2045121,1.2765991,1.3445779,1.4163815,1.5037654,1.6058694,1.639752,1.5313794,1.4312062,1.3415572,1.2794683,1.1911195,1.1119037,1.0541083,1.0248449,0.91895824,0.81615824,0.69687399,0.59578679,0.54399834,0.57167223,0.62707418,0.70997593,0.78769129,0.88084824,0.93594921,0.8374878,0.72689069,0.62078337,0.52264791,0.43301991,0.32778102,0.25866217,0.19839923,0.19987347,0.22173187,0.25227587,0.34626906,0.43742088,0.54693652,0.6529466,0.76051745,0.8691915,0.94241128,1.0497616,1.1618552,1.2736019,1.3785142,1.4874799,1.4374395,1.3532755,1.2929973,1.2434165,1.1572896,1.117561,1.0592944,1.0108806,0.9907984,0.99970379,0.91304822,0.85344476,0.77557144,0.69752972,0.62082918,0.52169818,0.4809116,0.49894838,0.56231288,0.65343236,0.77240161,0.86871172,0.9504329,1.0460935,1.1247095:5
2.2775165,2.1613743,2.0453693,1.9285272,1.8127481,1.6972027,1.5680282,1.4531256,1.3678034,1.2604377,1.1566239,1.0532667,0.96385871,0.87041552,0.75838906,0.6436821,0.53872804,0.44766318,0.39531075,0.36970944,0.30928589,0.19359865,0.10938494,0.01861011,0.031363475,0.043258728,-0.058814596,-0.12593114,-0.22339592,-0.33144339,-0.42730998,-0.52197888,-0.6156726,-0.71901507,-0.80734645,-0.90833632,-1.0022089,-1.0935855,-1.1952004,-1.1971526,-1.1109964,-1.0213691,-0.93256002,-0.83409142,-0.74067597,-0.66404397,-0.57851966,-0.54128114,-0.50443338,-0.39340486,-0.35620611,-0.28595736,-0.23907208,-0.14154824,-0.10553049,-0.072729916,-0.11517368,-0.21448918,-0.30806185,-0.38662431,-0.47475797,-0.57361449,-0.64742393,-0.73970538,-0.82456706,-0.88314463,-0.96921923,-0.9979806,-0.90313791,-0.8170269,-0.71407312,-0.62820175,-0.5419235,-0.47790371,-0.43343107,-0.34581864,-0.22677785,-0.15147589,-0.029259601,0.075744751,0.10944945,0.20904474,0.30515828,0.41562006,0.51265223,0.53980551,0.61844843,0.71856665,0.78985314,0.84976351,0.94589673,1.0256127,1.1084304,1.1891303,1.2771802,1.2282441,1.1214796,1.0119502,0.90176347,0.83412376,0.74287308,0.68290303,0.57697735,0.53356415,0.434966,0.35073835,0.35611325,0.2629743,0.2130962,0.1235248,0.095296059,0.067686401,0.0065951198,-0.024029785,-0.092444059,-0.13009681,-0.10566568,-0.13896245,-0.2259736,-0.28247677,-0.29751441,-0.38543897,-0.42746403,-0.50858473,-0.5934013,-0.56781266,-0.4577107,-0.38205094,-0.30497654,-0.26449126,-0.29597214,-0.28287641,-0.35628211,-0.40422937,-0.41980335,-0.4835444,-0.41496324,-0.3162664,-0.23291159,-0.1324301,-0.024827867,0.071133875,0.17298888,0.28404894,0.38620157,0.49076115,0.59226859,0.69263499,0.79499057,0.90821309,1.0134772,1.1155634,1.2157571,1.3068926,1.4070998,1.515238,1.5890302,1.6904081,1.7459088,1.7590528,1.7969536,1.8054541,1.8655235,1.9078477,1.9895867,2.0364495,1.963231,1.8769736,1.799235,1.7134527,1.622663,1.5443092,1.5213687,1.470902,1.385702,1.2855088,1.1817372,1.0690864,0.96493022,0.86434495,0.76349843,0.66301596,0.56180248,0.48926131,0.38090056,0.28102427,0.18027426,0.079986676,-0.021595908,-0.12123855,-0.22213357,-0.32170662,-0.42177795,-0.4900374,-0.59966742,-0.69303986,-0.78919368,-0.88554302,-0.98056545,-1.0809442,-1.1525391,-1.1614355,-1.2815674,-1.3752764,-1.4295354,-1.3135028,-1.197844,-1.099628,-0.99440922,-0.89869783,-0.82802256,-0.74161064,-0.67306836,-0.6059803,-0.55303442,-0.4852046,-0.49562614,-0.45358107,-0.396939,-0.3233681,-0.27666277,-0.22113496,-0.15534688,-0.17862165,-0.091142888,-0.018015719,-0.0074824167,0.085762092,0.11194684,0.20256709,0.11185291,0.043023312,0.010629386,-0.090373843,-0.075019337,-0.16631062,-0.25478015,-0.17748396,-0.1246385,-0.045876199,-0.0099348089,0.071485859,0.14422162,0.064311927,0.03342741,-0.0044215662,0.11638335,0.15952339,0.22280487,0.21881933,0.19657405,0.26228382,0.32670973,0.39253347,0.41136204,0.35662116,0.43777602,0.52111737,0.57836,0.54473126,0.65140847,0.75746007,0.73323796,0.8563786,0.92884255,1.0067568,1.0976019,1.185687,1.2324641,1.1350222,1.0377113,0.92280126,0.84706355,0.73093605,0.63676335,0.59559679,0.48126407,0.36964012,0.3131888,0.25360363,0.18026664,0.086633566,-0.010480424,-0.10592012,-0.14258946,-0.16780539,-0.26630235,-0.35735899,-0.43184208,-0.52274756,-0.57831969,-0.68421314,-0.75809681,-0.86123013,-0.95891162,-1.0375402,-1.1140967,-1.2000145,-1.3026568,-1.3855751,-1.4770699,-1.5333536,-1.6155292,-1.7042973,-1.7755119,-1.8642978,-1.902528,-1.9880124,-2.0805935,-2.1533522,-2.2006389,-2.207858,-2.1799521,-2.1182997,-2.0954894,-2.2100755,-2.3180641,-2.3641071,-2.4634432,-2.5435048,-2.4824314,-2.361058,-2.3144131,-2.2589178,-2.2470446,-2.210755,-2.1257081,-2.023509,-1.9117922,-1.8198063,-1.7547357,-1.6518075,-1.5619536,-1.5057904,-1.3936029,-1.2844506,-1.1989235,-1.0925073,-0.997557,-0.90823264,-0.83432953,-0.81563047,-0.711473,-0.62318018,-0.56241633,-0.46819971,-0.37623133,-0.37796693,-0.36298173,-0.27025481,-0.17406192,-0.11848545,-0.054929043,0.038609619,0.070141845,0.16670936,0.23115921,0.31713797,0.32421175,0.27572023,0.17782877,0.16467078,0.069574925,-0.024638022,-0.013894189,-0.1034277,-0.16970361,-0.25836268,-0.25560052,-0.32221863,-0.40438441,-0.49465036,-0.57403683,-0.66192447,-0.72068548,-0.62296204,-0.52071611,-0.48998814,-0.4161151,-0.33369382,-0.29143537,-0.1991455,-0.098468869,-0.081005448,-0.0080382587,0.084486794,0.13909156,0.19975897,0.27913345,0.35845926,0.40154327,0.3809161,0.33440243,0.30590093,0.34284782,0.39947915,0.49770029,0.54378933,0.63297828,0.68178042,0.63803289,0.69308749,0.72794948,0.8087006,0.89357046,0.92811957,0.90536157,0.97950557,1.0191365,1.1110257,1.2005849,1.2127651,1.2489428,1.3154464,1.4144094,1.4394359,1.4086967,1.514926,1.6410845,1.6528155,1.7693055,1.8101536,1.8987447,2.0007311,2.0687915,2.1555004,2.2270633:6
-0.020532307,-0.1006893,-0.1482223,-0.20846936,-0.19921412,-0.24520728,-0.29094117,-0.34185982,-0.43529082,-0.49833114,-0.39690127,-0.297285,-0.40354672,-0.50035968,-0.59674968,-0.72692091,-0.88065624,-0.85908709,-0.88765297,-0.99439181,-1.0809079,-1.1365868,-1.3073772,-1.399889,-1.5778104,-1.7447267,-1.8999184,-2.0835066,-2.2466859,-2.422346,-2.5215403,-2.5077484,-2.3433663,-2.1542612,-1.9692014,-1.7703971,-1.578417,-1.3794341,-1.1919126,-1.0064947,-0.82512451,-0.63560603,-0.43425681,-0.23736479,-0.047117179,0.15290969,0.34394117,0.52903539,0.71222527,0.89814104,1.0873169,1.2829966,1.4724949,1.6590849,1.8666717,2.0720864,2.2363077,2.436321,2.6293747,2.8366716,2.9308238,2.934571,2.8715636,2.7099407,2.5037302,2.300615,2.1129112,1.9255834,1.7539735,1.563209,1.3749336,1.1764998,0.98656877,0.79100811,0.68042981,0.58218905,0.40887887,0.20562838,0.027123083,-0.16432011,-0.35191226,-0.55642145,-0.75369281,-0.91625428,-1.1234477,-1.3065211,-1.5000281,-1.6656269,-1.7610999,-1.8301837,-1.9775849,-2.1303359,-2.0591846,-1.9827118,-1.8651417,-1.7151912,-1.6298092,-1.4916637,-1.3116557,-1.1688357,-1.0883763,-0.99003053,-1.0815776,-0.95449794,-0.78834921,-0.6216645,-0.54091888,-0.49195604,-0.39915716,-0.26160799,-0.26826406,-0.11910176,-0.013572374,0.055896208,0.13415204,0.1235923,-0.015475928,-0.19558312,-0.43129957,-0.52967057,-0.4387094,-0.28772148,-0.17507484,-0.11861794,-0.022819036,0.021994643,0.094263025,0.14422986,0.03509287,0.1100837,0.20898005,0.25555767,0.30244551,0.30975784,0.32186544,0.40302083,0.50095807,0.61792173,0.74355263,0.8617312,0.72186582,0.5394341,0.33339994,0.15056313,-3.5890571E-4,-0.13507578,-0.31975399,-0.5575953,-0.68807146,-0.7361359,-0.7596141,-0.61704668,-0.53235726,-0.37874777,-0.23790142,-0.10355479,-0.013083802,0.024690394,0.075089953,0.089423503,0.14357827,0.18671335,0.26556974,0.2459222,0.370514,0.40654432,0.51689572,0.63922348,0.79217471,0.77729779,0.84015091,0.77331101,0.55874313,0.35920505,0.17141969,-0.0014116234,-0.098535521,-0.17953609,-0.37534636,-0.55746457,-0.73942029,-0.92573083,-1.0875375,-1.1432672,-1.3271422,-1.4114895,-1.2762741,-1.1363606,-1.2890095,-1.168,-1.0901989,-0.99108568,-0.86719855,-0.77331635,-0.68623545,-0.52148424,-0.41643227,-0.31222252,-0.17664015,-0.13852997,-0.030206358,0.1211831,0.045693683,0.16812307,0.26986855,0.36509983,0.42564418,0.57421425,0.58054309,0.68896714,0.69863521,0.77320981,0.85186151,0.97283753,1.1099585,1.2114351,1.3461701,1.5104436,1.6242904,1.701411,1.6812346,1.5508989,1.3152768,1.0961794,0.95709979,0.76919008,0.58095766,0.63928104,0.44593699,0.22493161,0.059332958,-0.13902583,-0.25285429,-0.31054277,-0.57249804,-0.81693938,-1.0149369,-1.2258556,-1.253096,-1.1160394,-1.1304864,-1.1119258,-1.0298577,-0.8868882,-0.82354647,-0.69277974,-0.63938413,-0.55060544,-0.41072758,-0.25591477,-0.11168862,0.0158091,0.048949532,0.17881375,0.24278496,0.41938748,0.57256051,0.75178583,0.82685733,1.0121297,1.1796167,1.0745167,0.88212034,0.6466763,0.52514205,0.34702525,0.30964961,0.22723823,0.033827751,-0.13143807,-0.2772593,-0.49220796,-0.59250431,-0.77037909,-0.95613039,-1.0796081,-0.90384299,-0.72556233,-0.52149887,-0.34745391,-0.22120255,-0.1017309,0.015626286,0.081087993,0.17105784,0.41417701,0.53413335,0.72839831,0.92712727,1.0941836,1.2702569,1.4294317,1.5349303,1.6782577,1.8430145,1.7536803,1.5821012,1.4250116,1.270159,1.094344,0.92507958,0.98328626,0.80944892,0.64024187,0.49786801,0.32326353,0.41273717,0.34359448,0.15644422,-7.6873308E-4,-0.087712549,-0.25643664,-0.41915172,-0.53083003,-0.43989916,-0.62034946,-0.74052694,-0.88913901,-0.93105039,-1.036132,-1.1784832,-1.30263,-1.4536755,-1.5801272,-1.658021,-1.4551192,-1.2071284,-1.0028435,-0.83265107,-0.62615412,-0.42861127,-0.39655317,-0.18858514,0.021294649,0.23172385,0.380221,0.4087486,0.67977895,0.8362975,1.0426968,1.182162,1.4000035,1.6587372,1.695746,1.5616848,1.4791762,1.3414317,1.2596322,1.0755216,1.0593911,0.94225892,0.82924157,0.87111089,0.70097959,0.60014302,0.47963131,0.60932737,0.56364751,0.46774155,0.31117501,0.30680942,0.17199306,0.021816411,-0.0298148,0.087340804,-0.066881439,-0.18060949,-0.30825292,-0.44066284,-0.48966931,-0.65169158,-0.77101957,-0.88124267,-0.99763571,-1.1213635,-1.0583787,-0.87433827,-0.68517388,-0.47070526,-0.28193459,-0.081757707,0.10027322,0.28724346,0.36323501,0.4869543,0.66543877,0.86052642,1.0532388,1.2675154,1.4398339,1.6032106,1.4895702,1.3982369,1.2272481,1.0481019,0.99942378,0.85922684,0.70269214,0.73364725,0.55658682,0.49761869,0.37898677,0.23911841,0.32686598,0.37784247,0.26419188,0.13377858,0.025246819,-0.10492245,0.1061061,0.028981127,-0.050871384,-0.15797527,-0.30232677,-0.3804628,-0.48690876,-0.53642458,-0.63474191,-0.573132,-0.63906797,-0.75473753,-0.82489354,-0.94942461,-0.77231835,-0.50647368,-0.35376741,-0.096812838:1
2.3796473,2.240383,2.0712178,1.9185908,1.7657418,1.6363085,1.5156811,1.3866224,1.2956144,1.2320623,1.1028597,0.94668621,0.79131,0.65558885,0.58720585,0.47033914,0.4103813,0.49585718,0.57655327,0.66842297,0.77976058,0.71841696,0.59331045,0.49015925,0.36192515,0.22888482,0.090680599,-0.027612665,-0.1745614,-0.30209495,-0.42037639,-0.55750055,-0.66591478,-0.77183079,-0.87491793,-0.99464959,-1.0362646,-1.1261826,-1.2266042,-1.3424485,-1.4677545,-1.552257,-1.6466788,-1.7673004,-1.8655272,-1.8492327,-1.8981485,-1.8014657,-1.6802154,-1.561878,-1.4368296,-1.3119503,-1.1883437,-1.0671147,-0.94312758,-0.8217131,-0.6938219,-0.57572335,-0.45060839,-0.37446002,-0.24844849,-0.13098313,-0.055262587,0.06582983,0.14289286,0.24327435,0.36646366,0.46732673,0.59678224,0.71302867,0.7917601,0.83214122,0.93593749,1.0381584,1.129435,1.2334775,1.3227817,1.2855363,1.2000477,1.1326692,1.1006608,1.0283516,0.93055311,0.88498878,0.83653361,0.75529857,0.63678927,0.58822104,0.4939047,0.40345009,0.32798539,0.30962632,0.28635463,0.24125954,0.20267537,0.31974939,0.42163019,0.53638243,0.56228548,0.47290883,0.3955375,0.34048731,0.2827989,0.2223596,0.1206194,0.046345653,-0.033514241,-0.17132202,-0.32664924,-0.45280837,-0.52374628,-0.54376561,-0.54571685,-0.60867638,-0.67387097,-0.77163727,-0.8958966,-0.86935131,-0.93282565,-0.86598587,-0.93704893,-0.98453015,-0.98575291,-0.99486247,-0.9611269,-0.94053894,-0.84048763,-0.76380449,-0.66593246,-0.58340671,-0.43927861,-0.33799006,-0.25107396,-0.18472814,-0.11820717,0.0015834357,0.10872331,0.22206743,0.3592146,0.48076918,0.60341554,0.71122217,0.81239359,0.86623855,0.8238687,0.75842973,0.66488612,0.55028209,0.44114537,0.35589316,0.31866795,0.26019384,0.16985754,0.084201726,0.10331953,0.08802854,0.028335234,-0.06399303,-0.16218904,-0.27225923,-0.38139533,-0.49141887,-0.59918738,-0.69594097,-0.67464061,-0.68810526,-0.62779935,-0.54733702,-0.5789133,-0.67245393,-0.69603818,-0.77687432,-0.86645134,-0.93019991,-0.99791422,-1.0562734,-1.1297002,-1.1981428,-1.1444628,-1.0387452,-0.88188173,-0.74064392,-0.56812611,-0.39562281,-0.25499165,-0.099151216,0.043823565,0.18209631,0.35519034,0.52868266,0.70222423,0.85945201,1.0332015,1.2065534,1.3663267,1.5374727,1.7110827,1.8684486,2.0262062,2.1352742,2.2403967,2.2792792,2.2460142,2.1717772,2.0303883,1.8730376,1.7157302,1.5584865,1.4012474,1.2278762,1.0706532,0.89722832,0.72382589,0.55037845,0.37689551,0.20341405,0.029962441,-0.14352128,-0.30091777,-0.47454281,-0.64806132,-0.80559152,-0.97911013,-0.95450531,-0.84997648,-0.74936297,-0.67958626,-0.62642398,-0.58476117,-0.67699104,-0.67511676,-0.57823577,-0.43646161,-0.30206983,-0.19940051,-0.096287985,-0.019644347,0.054492477,0.047177146,0.059919052,0.11797816,0.18958963,0.20087462,0.29663191,0.40668567,0.50233569,0.55476182,0.62897064,0.71467283,0.80346689,0.8407841,0.91580314,0.98471771,1.10722,1.1316537,1.0295267,0.90684268,0.78599604,0.66469517,0.54217822,0.42319075,0.30037168,0.18373665,0.056879165,-0.068565215,-0.19411434,-0.24953614,-0.32476326,-0.40400599,-0.49980791,-0.56777427,-0.6160182,-0.73966242,-0.86298462,-0.92061422,-1.0225961,-1.0716441,-1.1444369,-1.1825471,-1.2301995,-1.3526873,-1.3457103,-1.2537064,-1.2447,-1.2363904,-1.1684311,-1.1357375,-1.0771916,-1.0451527,-0.99776945,-0.87535529,-0.75116627,-0.71847121,-0.68508232,-0.56788126,-0.50396975,-0.4169133,-0.29482483,-0.21725034,-0.14253494,-0.040516031,-8.8390436E-4,0.11760713,0.20506279,0.31742918,0.3985856,0.35341561,0.22131433,0.076898412,0.031293068,-0.062570932,-0.12755152,-0.2128137,-0.26390258,-0.28685934,-0.24542327,-0.18114897,-0.13194271,-0.058818955,0.035591788,0.13979527,0.21746679,0.28548779,0.38991419,0.48741081,0.48973306,0.55458912,0.63807445,0.7088942,0.78299958,0.85433223,0.91298971,0.98486651,1.0843011,1.1955547,1.2632437,1.2064039,1.0730901,0.93280096,0.80623743,0.66437076,0.5331628,0.41610374,0.31328499,0.19079888,0.10380826,-0.031116924,-0.16407561,-0.28762367,-0.40660751,-0.54191706,-0.65382902,-0.79163407,-0.91561107,-1.0490463,-1.1676166,-1.2707234,-1.3849659,-1.4800905,-1.6010605,-1.7213423,-1.8411511,-1.9507028,-2.0545977,-2.1429079,-2.2429747,-2.3062292,-2.2965574,-2.3792399,-2.3395748,-2.3877235,-2.3079627,-2.2100103,-2.1136505,-2.0029116,-1.8881784,-1.7728533,-1.6548015,-1.5337494,-1.4043487,-1.2847807,-1.1563884,-1.0153253,-0.88314685,-0.752634,-0.63097855,-0.50208577,-0.37260099,-0.24087641,-0.087535256,0.060422604,0.18389386,0.31871262,0.43463182,0.54915081,0.70808088,0.83844942,0.97513818,0.90183408,0.80719562,0.6998064,0.57435252,0.46443852,0.40150691,0.39953515,0.41730953,0.53015591,0.65648856,0.74276766,0.82636225,0.90410579,0.97207892,1.0647525,1.1664014,1.2046575,1.2614846,1.3903251,1.4960885,1.6221846,1.7489207,1.8483542,1.940343,2.0341926,2.1117199,2.1841505,2.2542136,2.3389806:5
1.2083359,1.2130976,1.1874088,1.1200523,1.0111549,0.94062344,0.85658327,0.83077865,0.86991485,0.99434148,1.1041566,1.1902115,1.2239735,1.2103807,1.1947845,1.1439992,1.0903315,1.0078464,0.92082115,0.84347774,0.72689705,0.62429529,0.48645748,0.3252047,0.20478492,0.050215111,-0.10070762,-0.25120076,-0.39844109,-0.51679596,-0.67061895,-0.80276053,-0.93303815,-1.0854195,-1.1948476,-1.3372869,-1.4844714,-1.6106769,-1.7285625,-1.7327219,-1.7839769,-1.6851039,-1.5629493,-1.4087785,-1.2269847,-1.0904444,-0.90537865,-0.76373695,-0.59520494,-0.44159246,-0.33343753,-0.19266092,-0.10881739,0.043140755,0.1447343,0.26940806,0.3739382,0.40387458,0.54101215,0.64466006,0.7435761,0.87281635,0.9259916,1.0306978,1.0975366,1.1281309,1.1760257,1.1374125,1.106355,1.0472586,0.98781454,0.91163193,0.85591697,0.78145539,0.70210393,0.64603772,0.61317909,0.57073428,0.55997646,0.5742124,0.5891886,0.5636508,0.51343429,0.4540028,0.38856123,0.30911216,0.25295146,0.1304164,0.036330312,-0.056102528,-0.21994154,-0.36036757,-0.49182267,-0.5875791,-0.72530914,-0.82874196,-0.95712523,-1.0367316,-1.2243462,-1.3574529,-1.4821929,-1.6073717,-1.7426551,-1.7646658,-1.884011,-1.9468275,-1.9179622,-1.7744668,-1.6421982,-1.5008071,-1.3708973,-1.2417963,-1.1280526,-0.99602857,-0.88425494,-0.74745083,-0.61738217,-0.51688997,-0.39297449,-0.27685027,-0.16073653,-0.058007429,0.065234179,0.12000118,0.19277144,0.23943338,0.24491225,0.28489142,0.2814136,0.27451301,0.30335976,0.27240621,0.28758102,0.30682803,0.26743495,0.25934032,0.17840039,0.16948148,0.12152403,0.11837242,0.048613625,-0.056812757,-0.12018813,-0.21597817,-0.33756515,-0.44602177,-0.55250963,-0.63900155,-0.73522899,-0.82667864,-0.87789288,-0.85125435,-0.7221352,-0.5816824,-0.41282838,-0.28791205,-0.11203614,0.010631247,0.1394487,0.22519684,0.26470755,0.29754488,0.40604388,0.49184885,0.53641889,0.56995306,0.64214793,0.63346316,0.65791186,0.60969552,0.52100433,0.44256963,0.43011739,0.33123157,0.29044656,0.24553547,0.22977676,0.27244782,0.3201172,0.42298554,0.48030532,0.60600933,0.70426876,0.78439629,0.83401389,0.9073837,0.84514131,0.83341339,0.82869353,0.80659972,0.79379355,0.86693904,1.055552,1.1969699,1.3561354,1.5114691,1.6626375,1.8168475,1.9140075,1.9958611,2.047056,2.0103991,1.9531722,1.9107138,1.8469643,1.8708208,1.8126653,1.6276045,1.4325901,1.2846461,1.1016722,1.1209067,1.0197718,0.97383462,0.95277027,0.97738756,1.0160346,1.0558839,1.0872909,1.0667703,1.043323,1.0641083,1.1432239,1.0336141,1.0952436,1.1148821,1.0908107,1.1576785,1.0662985,1.1539902,1.0716853,1.1097466,1.1009489,1.1349823,1.102808,1.1116423,1.1478229,1.0486171,1.1071319,1.0743266,1.0970605,1.0882202,1.1067661,1.1211639,1.1004502,1.1064357,1.0951432,1.0794215,1.0567994,1.0112098,0.96584346,0.90011311,0.81150723,0.74265459,0.62993875,0.50781899,0.36782055,0.23027087,0.096523079,-0.067731708,-0.065670402,-0.19747895,-0.27118325,-0.23644856,-0.36418524,-0.51052621,-0.65894391,-0.75699863,-0.70166102,-0.65939388,-0.6402287,-0.59870897,-0.53330166,-0.48763865,-0.44562995,-0.40131186,-0.37133193,-0.34195177,-0.31955404,-0.31000213,-0.29039666,-0.27747701,-0.28477308,-0.28120226,-0.27268084,-0.28038853,-0.27377257,-0.26060338,-0.25814975,-0.2809938,-0.29546983,-0.28807454,-0.28677079,-0.31408066,-0.35524064,-0.38109206,-0.40010279,-0.45069665,-0.5294413,-0.61085056,-0.7551906,-0.87063481,-0.94834316,-1.0275423,-0.91815986,-0.80849122,-0.72303111,-0.60360035,-0.4990825,-0.39831881,-0.30136426,-0.20302841,-0.091870665,0.013366989,0.088471669,0.10970792,0.064507061,0.0056704148,-0.072560746,-0.16117095,-0.27451895,-0.34722848,-0.2772278,-0.15651664,-0.054192947,0.024887118,0.12382594,0.19514464,0.25377264,0.28058187,0.31796123,0.35534833,0.36856053,0.41561346,0.36001893,0.31805715,0.17098446,0.11301897,-0.0028404536,-0.14379544,-0.26975451,-0.34306996,-0.4745138,-0.61728022,-0.7287574,-0.8547259,-0.99469248,-1.1226116,-1.2530578,-1.3299492,-1.4495556,-1.5946221,-1.7187888,-1.8782916,-2.0163532,-2.1362178,-2.2665988,-2.4286933,-2.5639164,-2.7058734,-2.8399465,-2.9716668,-3.0885431,-3.1811551,-3.0098489,-2.9214914,-2.7641222,-2.6068103,-2.4642506,-2.371328,-2.2170702,-2.0649951,-1.894093,-1.718033,-1.5733683,-1.3863039,-1.2023679,-1.0168011,-0.83761297,-0.69434381,-0.52751753,-0.39792332,-0.2710246,-0.13477869,-0.021686671,0.097241079,0.20095041,0.2757057,0.36866689,0.45911012,0.56526392,0.65013474,0.70352491,0.74095206,0.70604017,0.70837525,0.72665826,0.67507605,0.61477106,0.52611086,0.46172051,0.40583656,0.3029269,0.21093158,0.076936805,0.0084846729,-0.10628919,-0.2019746,-0.28829158,-0.41738397,-0.49680269,-0.53705537,-0.41547003,-0.28030025,-0.1622183,-0.0073856277,0.10286326,0.25442025,0.374766,0.46905675,0.57935252,0.68420952,0.79299375,0.90856509,0.99919494,1.0995058,1.1883198:2
1.8589302,1.7040104,1.5838782,1.4557776,1.3642029,1.2855773,1.1740712,1.0912888,0.99509013,0.88689763,0.78442667,0.68806052,0.59641418,0.53687854,0.59031596,0.54220417,0.43355301,0.33552747,0.22163602,0.1055526,-0.0036276511,-0.11646351,-0.13636515,-0.29452659,-0.34527727,-0.19294521,-0.053154578,0.093570817,0.27350726,0.34725058,0.41496087,0.56312049,0.7081794,0.89098843,0.91630996,1.0135622,1.1868734,1.3331513,1.5178151,1.6602852,1.826218,1.8823961,1.6900114,1.6843093,1.6311929,1.5358178,1.3897364,1.3046116,1.2374419,1.119722,1.1377853,1.0329474,0.91848562,0.80438439,0.71131763,0.58655379,0.50779901,0.5187258,0.45401042,0.35396232,0.25816628,0.17691649,0.107968,0.012050324,-0.082828692,-0.17800943,-0.23590973,-0.36447089,-0.44330348,-0.29787376,-0.12077621,-0.085860248,0.059028875,0.22900897,0.34070177,0.50103106,0.64053158,0.80704012,0.97582771,1.1194307,1.2332479,1.267152,1.2363609,1.1297919,1.0411776,0.94107416,0.82460615,0.70260914,0.59869374,0.4910442,0.38066119,0.26639852,0.16436641,0.065186835,-0.010955057,-0.041958409,-0.12820732,-0.2287728,-0.32649307,-0.41413181,-0.51710858,-0.588135,-0.65830428,-0.74562264,-0.8528594,-0.8395018,-0.68249245,-0.53960327,-0.50410184,-0.36157917,-0.3128933,-0.31003836,-0.34813101,-0.39777293,-0.450196,-0.50549925,-0.57073565,-0.60923904,-0.63105167,-0.67680299,-0.74000765,-0.77450428,-0.83069222,-0.86428589,-0.98112994,-1.0802971,-1.1391189,-1.1542886,-1.1467711,-1.1912051,-1.2047985,-1.2793062,-1.3968499,-1.4793002,-1.5235409,-1.6334501,-1.7620364,-1.8713062,-2.0477504,-2.1797654,-2.2299211,-2.3836903,-2.5080963,-2.4029581,-2.2296625,-2.0715575,-1.9086181,-1.7668621,-1.6074654,-1.4464443,-1.2985616,-1.1378236,-0.97780709,-0.81488203,-0.66298431,-0.5205971,-0.35027782,-0.20222863,-0.087821506,0.051094095,0.20271286,0.36029479,0.51327313,0.59822144,0.76144433,0.92277184,1.0737232,1.2339524,1.384432,1.5360086,1.6959653,1.8446155,2.0203999,2.1547828,2.3283084,2.4328057,2.441281,2.3520642,2.2108251,2.0472471,1.8686521,1.7216276,1.5636663,1.4165778,1.2626564,1.0948852,0.96311358,0.89181148,0.83037174,0.66734764,0.52024963,0.45045506,0.32374496,0.16560949,0.02937128,-0.022375637,-0.15953704,-0.32825442,-0.46957491,-0.63124763,-0.79183585,-0.93765799,-1.0947913,-1.2548062,-1.4013162,-1.5616868,-1.7078298,-1.8800272,-2.0199959,-2.1829857,-2.330717,-2.477305,-2.6376314,-2.6004319,-2.4229395,-2.2499631,-2.0658385,-1.901752,-1.7556177,-1.6203539,-1.4633419,-1.3956785,-1.2409395,-1.1632295,-1.0415175,-0.97070582,-0.90305305,-0.82585179,-0.76917564,-0.72503083,-0.70887426,-0.83748504,-0.97661853,-1.0543675,-0.89050129,-0.91138435,-0.85543033,-0.77734705,-0.69404872,-0.64193065,-0.56523415,-0.48517777,-0.3959583,-0.38999108,-0.38923871,-0.29840903,-0.23387999,-0.1252723,-0.013811114,-0.027885758,0.014753011,0.06192364,0.12985341,0.17959866,0.066457728,0.10042264,-0.035539523,-0.17280523,-0.33574097,-0.33345727,-0.50720069,-0.66081899,-0.72265105,-0.67528882,-0.61690552,-0.55173374,-0.56493106,-0.60605839,-0.51464781,-0.44598047,-0.34291861,-0.30461192,-0.27270004,-0.2091854,-0.14088875,-0.020574577,0.061008165,0.1537928,0.19726243,0.32340283,0.3285265,0.45641897,0.55104064,0.59150026,0.64732908,0.6958281,0.76882451,0.84518727,0.69820196,0.54264153,0.37956934,0.23987078,0.23158938,0.07722562,-0.074860463,-0.18669062,-0.090915455,-0.062883325,0.043433015,0.12278544,0.18846362,0.2602303,0.41596518,0.36531092,0.46162658,0.57274208,0.52070168,0.59698888,0.68594822,0.76309925,0.76608867,0.85556951,0.94322664,1.0108168,1.1302186,1.2196033,1.34038,1.4322945,1.5102632,1.4262678,1.2530405,1.114787,0.94729993,0.79183821,0.61229822,0.56722612,0.44169342,0.28121866,0.13783025,0.092754586,-0.04765487,-0.20234419,-0.23231846,-0.40772442,-0.50874331,-0.41084683,-0.30440482,-0.21892765,-0.1728713,-0.06516063,0.047079983,0.12694388,0.2401863,0.33740107,0.47105253,0.46142228,0.45446735,0.56848827,0.66455548,0.76691176,0.89185219,0.99751191,1.1250295,1.2559548,1.2080043,0.99722231,0.84501664,0.73901077,0.59045926,0.40925195,0.28795278,0.12397603,-0.0027764279,-0.14283,-0.28548388,-0.35701786,-0.47871084,-0.65081144,-0.85535798,-1.0463685,-1.2348285,-1.2615769,-1.2973895,-1.3884295,-1.2797535,-1.135936,-0.99961125,-0.8770278,-0.7472881,-0.61605607,-0.47456889,-0.32642524,-0.18730958,-0.28793126,-0.3379859,-0.39537227,-0.29973026,-0.2274553,-0.077998696,-0.047149086,-0.18407821,-0.19790391,-0.036360651,-0.18040179,-0.21944011,-0.31040531,-0.39966132,-0.43266029,-0.48200424,-0.57131558,-0.68337727,-0.78919292,-0.92449741,-1.0045786,-1.1090591,-1.2418508,-1.1781953,-0.99719705,-0.81503592,-0.60894973,-0.40328137,-0.2152667,-0.044383303,0.15800613,0.23812036,0.40924833,0.59179718,0.77281786,0.8472685,0.88538272,1.0543975,1.2206992,1.3149261,1.3942386,1.5217385,1.6795445,1.8394381:1
-0.77025377,-0.79484363,-0.82141058,-0.84495295,-0.86159284,-0.87426171,-0.87357771,-0.87653083,-0.8746559,-0.87158448,-0.87857749,-0.87987137,-0.86701459,-0.88279838,-0.87934699,-0.87617343,-0.85064243,-0.85781616,-0.84546426,-0.83413513,-0.83327491,-0.8354763,-0.84555287,-0.85561417,-0.87701451,-0.9027766,-0.93309326,-0.96836267,-1.005434,-1.0475155,-1.0872792,-1.1216776,-1.1509839,-1.1650334,-1.1495996,-1.1322883,-1.1041187,-1.0797166,-1.037049,-0.98710022,-0.93109034,-0.8678894,-0.81427373,-0.7530595,-0.68617672,-0.62386781,-0.56020395,-0.49954872,-0.43691625,-0.38309694,-0.31911192,-0.24439759,-0.17488728,-0.11492003,-0.057975819,-0.0086895667,0.055819889,0.10299315,0.13812698,0.1792352,0.22252041,0.25446271,0.29274375,0.31747241,0.33571563,0.35696604,0.36759889,0.38701179,0.39522168,0.40526842,0.40700799,0.40659026,0.40887547,0.44312475,0.5038103,0.58746929,0.65500148,0.72551763,0.80141691,0.86945138,0.93200809,0.99213713,1.0585294,1.1260473,1.1943217,1.2620669,1.3309039,1.3983004,1.4553274,1.5238307,1.5973432,1.6562629,1.7234774,1.8038177,1.871026,1.9363073,2.0204482,2.1032996,2.1625354,2.1813155,2.1533189,2.1054649,2.051037,1.9669076,1.9000432,1.8277739,1.7543503,1.6967172,1.6140324,1.5528178,1.4973665,1.4293479,1.3623706,1.2969158,1.2340578,1.1779929,1.1102077,1.0428049,1.0444083,0.98986166,0.93730059,0.88655471,0.83691845,0.78299348,0.73674898,0.67836596,0.63907678,0.59795811,0.59471547,0.62578159,0.65195558,0.67557482,0.70659541,0.73164854,0.74858784,0.75726544,0.75095377,0.73837691,0.72275137,0.70560577,0.68687237,0.66415396,0.64238231,0.62250219,0.6038693,0.57241726,0.54380371,0.51752136,0.48264388,0.44266421,0.39798538,0.35690375,0.31516953,0.26418355,0.21453544,0.16442469,0.10959472,0.05623103,-0.011747349,-0.055916828,-0.12635119,-0.18085379,-0.25405031,-0.32711942,-0.39147302,-0.44767113,-0.50501823,-0.56860751,-0.62613109,-0.68205573,-0.74047857,-0.79562209,-0.85146249,-0.85062851,-0.81359946,-0.78479997,-0.75585789,-0.73352812,-0.71621511,-0.70885033,-0.70301024,-0.70740664,-0.71302239,-0.70836768,-0.71225975,-0.70830226,-0.71308147,-0.70938112,-0.69595636,-0.69583764,-0.68912709,-0.69488113,-0.69057278,-0.68714121,-0.69833958,-0.68941398,-0.69393779,-0.69036962,-0.68283021,-0.67591587,-0.66984071,-0.6641659,-0.67186492,-0.6836655,-0.69898741,-0.72483793,-0.7520771,-0.77894939,-0.81723923,-0.85695263,-0.89659127,-0.93773928,-0.98377526,-1.0324754,-1.0835838,-1.1374842,-1.1980667,-1.2791739,-1.3405867,-1.4202397,-1.5001185,-1.5814951,-1.6626853,-1.7117402,-1.7120313,-1.6670183,-1.6122684,-1.5543976,-1.4983336,-1.4361032,-1.3797495,-1.3268501,-1.2643325,-1.2056364,-1.1454306,-1.0912359,-1.0340293,-0.97813651,-0.92427891,-0.86173419,-0.80820424,-0.75008335,-0.69258541,-0.63128917,-0.57902468,-0.51830381,-0.466876,-0.40341291,-0.34978382,-0.28969984,-0.26058832,-0.20746323,-0.14104608,-0.080493151,-0.022325108,0.037468192,0.096597063,0.15729743,0.19792909,0.24629306,0.28704657,0.32908495,0.35594314,0.37298239,0.37758638,0.37566124,0.36208628,0.3432076,0.30379241,0.26187497,0.21963283,0.17608222,0.1359724,0.10174637,0.11745003,0.18939667,0.25570496,0.31030408,0.38067391,0.44197175,0.50324746,0.57086453,0.62977341,0.69608797,0.75975624,0.82903754,0.91048929,0.98854799,1.0660186,1.1302003,1.1892727,1.2669068,1.3296139,1.3419077,1.3351376,1.3476916,1.3549687,1.3629177,1.3803905,1.39953,1.4302872,1.4652784,1.5029603,1.5408497,1.5824688,1.619148,1.6491524,1.6744518,1.683271,1.6499709,1.6885331,1.7168983,1.6904569,1.6522659,1.6160949,1.5705434,1.525643,1.4744252,1.4273301,1.3654704,1.3070446,1.2469259,1.1858156,1.1210229,1.0392272,0.97218983,0.8882665,0.8234254,0.73952852,0.67481788,0.61058973,0.57218961,0.55880125,0.5901421,0.62745282,0.66998094,0.70175665,0.74116297,0.78141641,0.81502885,0.85484308,0.88613888,0.91253115,0.93561646,0.95036001,0.95475573,0.94294989,0.91629807,0.87617091,0.8402829,0.79636415,0.74485349,0.69142083,0.64497647,0.59086049,0.54185906,0.47913765,0.43546128,0.39206916,0.3401382,0.29952743,0.25620986,0.19614184,0.15076341,0.10724843,0.064859378,0.010839307,0.01734915,-0.05153912,-0.1276475,-0.18257916,-0.25227455,-0.31612991,-0.33907654,-0.39134165,-0.44581352,-0.48976975,-0.55187696,-0.59690903,-0.65721274,-0.71910742,-0.78582505,-0.84862244,-0.91639958,-0.9768303,-1.0324536,-1.0962607,-1.1562394,-1.224577,-1.2509546,-1.32563,-1.378501,-1.4455281,-1.5026256,-1.5703803,-1.6260185,-1.6931297,-1.759387,-1.7860804,-1.8466359,-1.9143139,-1.9198931,-1.8600428,-1.7969436,-1.7385078,-1.6801174,-1.6190592,-1.5551789,-1.4998926,-1.4299445,-1.3758854,-1.3128003,-1.2463027,-1.1723811,-1.1033279,-1.0319701,-0.97385727,-0.90765128,-0.83650251,-0.78474377,-0.75486828,-0.72507441,-0.71350097,-0.7088983,-0.71303206,-0.72778016,-0.74789945:2
1.6429926,1.5471505,1.5032781,1.5577229,1.618877,1.5529737,1.4726964,1.4031247,1.3457694,1.3007816,1.250338,1.1593796,1.0498134,0.95523682,0.82909212,0.68673161,0.56060872,0.46407246,0.38977811,0.26696068,0.15367349,0.027689424,-0.098113994,-0.22373693,-0.33296174,-0.46805692,-0.59959542,-0.70971671,-0.83346114,-0.95796818,-1.0820061,-1.1935359,-1.3125127,-1.4166446,-1.5395998,-1.6559997,-1.7625142,-1.8321979,-1.9262814,-1.9082532,-1.7914691,-1.675362,-1.5668386,-1.5166371,-1.4239479,-1.3607078,-1.2617588,-1.2071654,-1.1512436,-1.0490804,-1.0102901,-0.92312947,-0.8897416,-0.83700293,-0.74747837,-0.70830292,-0.64240387,-0.56832138,-0.51257266,-0.45582237,-0.47073664,-0.38207076,-0.33110173,-0.25488029,-0.18856791,-0.18891344,-0.11351251,-0.015671879,-0.018304766,0.07878129,0.12694665,0.19061383,0.17940628,0.15666062,0.15292414,0.24252339,0.27165785,0.3959838,0.41718954,0.48850424,0.50498142,0.48074483,0.52269747,0.55174447,0.63583284,0.68403194,0.72773876,0.72850952,0.76801936,0.80431782,0.87541988,0.91837055,0.93646797,1.0079227,1.0881943,1.1125058,1.1785836,1.2192536,1.2761656,1.3189962,1.4105155,1.5043247,1.4929108,1.3714759,1.2779632,1.1557437,1.0587262,0.93238455,0.86471786,0.76326421,0.65455566,0.56367871,0.5004754,0.3943321,0.30106435,0.21889845,0.09929572,0.044774865,-0.061000233,-0.18691282,-0.27471658,-0.36562357,-0.43509987,-0.53163021,-0.62450275,-0.69923224,-0.7813876,-0.90907113,-0.95027556,-0.91295547,-0.85981879,-0.78332866,-0.70282462,-0.62415499,-0.55831867,-0.50724218,-0.43345887,-0.34644681,-0.26696955,-0.18542473,-0.095324487,-0.038879648,0.050168915,0.13408417,0.084241039,-0.00337395,-0.10817518,-0.14815415,-0.25201874,-0.31436232,-0.36270585,-0.43238014,-0.53333212,-0.58542693,-0.68617258,-0.73843506,-0.76673176,-0.85871878,-0.93723334,-0.98193522,-1.0855909,-1.1145405,-1.1998645,-1.2952898,-1.3735157,-1.4065476,-1.501518,-1.5727436,-1.6480377,-1.710636,-1.8096554,-1.8617714,-1.7978323,-1.6957015,-1.5791218,-1.4758057,-1.3724753,-1.2688207,-1.1546006,-1.0453913,-0.92494399,-0.81139727,-0.69604361,-0.58327482,-0.48116891,-0.3835422,-0.25515013,-0.16079212,-0.068351707,0.014925809,-0.0042960495,0.02670441,0.1012992,0.2206163,0.29144583,0.41553066,0.49121326,0.59279623,0.64409278,0.6772766,0.73028259,0.83972885,0.90120489,1.0084269,1.0905697,1.1188374,1.1889545,1.2575903,1.3576405,1.4382404,1.4736394,1.5627595,1.6553075,1.7408295,1.8046629,1.8996668,1.9927395,2.0673066,2.1649948,2.2515937,2.3449729,2.4432603,2.3427416,2.2379511,2.1531679,2.061058,2.0352966,1.929515,1.8920031,1.8288049,1.7423895,1.6492469,1.6054723,1.581854,1.4738109,1.4278801,1.3146912,1.2775035,1.2880368,1.2133757,1.1175908,1.0740886,0.97731154,0.87813796,0.9008131,0.91218593,0.89666718,0.84096662,0.81370092,0.70817988,0.64179396,0.61334364,0.50959613,0.44122954,0.3952136,0.43089169,0.40412028,0.38628564,0.288611,0.24642303,0.14065062,0.10297631,0.0053297008,-0.095012072,-0.11754885,-0.21399572,-0.31338802,-0.36601434,-0.37579357,-0.29712948,-0.21041422,-0.1353542,-0.15191991,-0.051623185,0.019734373,0.071665899,0.11082572,0.21764256,0.2671069,0.34692774,0.26803044,0.17884592,0.13438111,0.044082898,0.028956282,-0.034137598,-0.11867031,-0.19318375,-0.2797079,-0.26844254,-0.35029238,-0.41248278,-0.53009301,-0.56467172,-0.67748844,-0.76543714,-0.783627,-0.86429199,-0.96756278,-1.0500907,-1.1533794,-1.2267511,-1.2932563,-1.3358461,-1.2760946,-1.1789492,-1.1362111,-1.0688837,-0.94460351,-0.87056417,-0.79037125,-0.71143553,-0.62047082,-0.56507504,-0.47180283,-0.34522929,-0.25322045,-0.1444648,-0.032879169,0.059951739,0.15575068,0.24718867,0.32041171,0.24053872,0.1571308,0.1003532,0.021457936,-0.022031955,-0.059499381,-0.11686024,-0.17723589,-0.14132723,-0.20891719,-0.23506889,-0.30683784,-0.33185252,-0.27080147,-0.31999202,-0.36431652,-0.39530715,-0.42504588,-0.49900904,-0.45634811,-0.45396317,-0.48511309,-0.55439729,-0.54981484,-0.65196723,-0.68160872,-0.59777998,-0.55044721,-0.56888394,-0.58622047,-0.60722833,-0.6804628,-0.69652261,-0.754622,-0.82265462,-0.79826544,-0.7539298,-0.6917063,-0.71903973,-0.77541154,-0.76638754,-0.8417553,-0.87688681,-0.89614523,-0.95701199,-1.0345747,-1.0258312,-1.0929408,-1.1369512,-1.2134,-1.2858664,-1.3008843,-1.3648023,-1.4313664,-1.5010368,-1.5584197,-1.6328331,-1.696965,-1.6929551,-1.6037188,-1.5271622,-1.5584824,-1.4497925,-1.3080935,-1.1841815,-1.0570804,-0.94753216,-0.82159576,-0.69551379,-0.56962427,-0.46322825,-0.39393099,-0.25877761,-0.1447556,-0.018173446,0.1084813,0.23503886,0.3620707,0.48848255,0.61504292,0.74180343,0.86889633,0.98024974,1.0766821,1.1414198,1.2199615,1.277959,1.3003768,1.3478272,1.3584915,1.3983519,1.4408293,1.4619061,1.4814127,1.481887,1.4733662,1.438327,1.3646536,1.2923251,1.3159942,1.3933397,1.4742626,1.5439926,1.6029195:6
2.689522,2.5626704,2.4306561,2.2684953,2.1282985,1.9949285,1.8667333,1.7350664,1.59753,1.4717345,1.319095,1.1687069,1.0479196,0.90603584,0.76603159,0.63312539,0.50893714,0.40578424,0.27136392,0.12520689,0.0037918637,-0.14293779,-0.26386765,-0.39190249,-0.52804713,-0.63720195,-0.78685267,-0.89895008,-1.033745,-1.1532038,-1.2305455,-1.2871075,-1.3834696,-1.3477714,-1.3086868,-1.3219883,-1.2618798,-1.198532,-1.1257629,-1.0512846,-0.9839899,-0.90757186,-0.82285635,-0.77070543,-0.74006655,-0.78448172,-0.70868469,-0.63823971,-0.56170248,-0.51411638,-0.49043611,-0.57555575,-0.63376513,-0.55820131,-0.48274862,-0.41571308,-0.3266004,-0.26330983,-0.22724024,-0.14027026,-0.065454634,0.016646442,0.026324821,-0.073512767,0.015373077,0.09350396,0.20908503,0.21746605,0.21686233,0.24793491,0.30228777,0.30643693,0.29441078,0.28540924,0.28711055,0.20742184,0.13697672,0.043209193,-0.073634919,-0.19584266,-0.31480542,-0.41218466,-0.38754847,-0.34533623,-0.32600016,-0.33953819,-0.27991799,-0.21361322,-0.19723668,-0.20206734,-0.13815437,-0.070060207,0.012423065,0.044339246,0.099461104,0.15088703,0.20489809,0.26082122,0.31303655,0.27005137,0.1611909,0.060905228,-0.010071828,0.07657385,0.13676158,0.22588149,0.29568774,0.33019577,0.37758844,0.45293976,0.56196344,0.63055643,0.6463588,0.56075163,0.624682,0.70965068,0.76566649,0.87001478,0.94731099,0.99307409,1.0448396,1.1426232,1.2382997,1.3335149,1.4286711,1.4888827,1.4840384,1.3609049,1.1929172,1.022243,0.89096918,0.7302007,0.59239239,0.46161875,0.33226277,0.23516327,0.091506776,-0.03738707,-0.15945352,-0.2776173,-0.38760392,-0.52413887,-0.53636526,-0.69253092,-0.84401444,-0.97349659,-1.1107833,-1.244123,-1.4071162,-1.5273493,-1.6369862,-1.7614078,-1.8482277,-1.858132,-1.813788,-1.7606101,-1.6977327,-1.6064385,-1.5245003,-1.4283823,-1.3178375,-1.2212027,-1.121131,-1.0232501,-0.97119151,-1.0061275,-0.93783764,-0.83157229,-0.72318324,-0.59848352,-0.48948109,-0.43815647,-0.33596567,-0.22898796,-0.11845239,0.0043881022,0.039062238,-0.033700042,-0.13619034,-0.19093106,-0.2467575,-0.19359023,-0.050710722,0.060751735,0.095934401,0.19991346,0.34874037,0.47641233,0.62340937,0.67623998,0.67366172,0.80430535,0.93077649,1.0877153,1.1721963,1.328738,1.4511973,1.5882362,1.725183,1.853142,1.9328586,1.9034832,1.8087463,1.704977,1.6050668,1.459542,1.3760533,1.2666264,1.1492512,1.0862671,1.0267191,0.89051455,0.78781518,0.65349921,0.60466793,0.58722327,0.48414594,0.37455082,0.28725117,0.18756813,0.081607184,-0.021442889,0.0037524786,-0.051805954,-0.15691472,-0.2666331,-0.36027168,-0.45628527,-0.42814138,-0.43959262,-0.37379031,-0.30019668,-0.20803961,-0.18440611,-0.21946696,-0.30467763,-0.37803062,-0.47890513,-0.55400414,-0.67239129,-0.76158536,-0.83299812,-0.91691969,-1.0547365,-1.1739922,-1.2897637,-1.3227422,-1.4051087,-1.5180196,-1.6271574,-1.7241492,-1.8350162,-1.9252958,-2.0090903,-2.0865468,-2.1761718,-2.1764135,-2.0652734,-2.0244745,-1.9108997,-1.7909136,-1.6691798,-1.5522409,-1.420106,-1.2971122,-1.176397,-1.0505638,-0.92299211,-0.8053998,-0.68921347,-0.56732394,-0.45407104,-0.44171333,-0.44427197,-0.32346071,-0.21028299,-0.0787522,0.044536348,0.1537618,0.2708216,0.38257535,0.52335445,0.63058176,0.74113448,0.73330802,0.85189268,0.9603913,1.107328,1.2116983,1.3407771,1.4788055,1.5964674,1.713533,1.8447276,1.8473081,1.8018046,1.7356816,1.6601064,1.5432416,1.4837368,1.3787646,1.3063971,1.1893043,1.0721909,1.0481479,1.014074,0.89700291,0.79429806,0.67548754,0.56260368,0.551881,0.62901656,0.63106224,0.52828444,0.43753473,0.32960138,0.28198011,0.27432898,0.19159063,0.10219947,0.020665392,-0.054906719,0.052571659,0.17755286,0.22844367,0.19900558,0.12650195,0.067197983,-0.012383513,-0.090908746,-0.058165161,-0.11977677,-0.1998973,-0.30000763,-0.37464622,-0.42366961,-0.39678734,-0.45326302,-0.5294602,-0.57158616,-0.61186941,-0.67425462,-0.73847005,-0.79930109,-0.84720048,-0.73767519,-0.62074534,-0.49132325,-0.35985717,-0.23751693,-0.11627124,-0.023220724,-0.040480541,-0.079124837,-0.11427933,-0.11318115,-0.16730552,-0.20843303,-0.25682085,-0.16795851,-0.17150327,-0.21635642,-0.27480092,-0.34773932,-0.42672325,-0.39314573,-0.34226056,-0.38652793,-0.44753413,-0.46251608,-0.58661106,-0.58899453,-0.64324975,-0.70433005,-0.77549956,-0.84024429,-0.90013183,-0.89937936,-0.94864383,-0.90093055,-0.78270965,-0.73711381,-0.74351615,-0.72662308,-0.76718812,-0.74696535,-0.85868143,-0.93673278,-0.99268052,-1.0697991,-1.1007819,-1.1635719,-1.1974461,-1.2577253,-1.3048239,-1.2089749,-1.075894,-0.94194527,-0.80788971,-0.69191875,-0.55466446,-0.43749896,-0.31027761,-0.17426912,-0.040009088,0.095154481,0.22390438,0.36584782,0.49104178,0.62022092,0.76952288,0.92574029,1.0578337,1.1924691,1.324407,1.4565834,1.5873944,1.7215039,1.8655208,2.0206952,2.1527713,2.2833304,2.4159394,2.5688322,2.7087034,2.7907129,2.7524181:3
0.23064222,0.18819692,0.14567752,0.10356401,0.058601963,0.0067487993,-0.041513775,-0.086041878,-0.13885636,-0.15266687,-0.11291138,-0.057383266,0.0028143364,0.055152237,0.091214778,0.12103342,0.11116861,0.085838912,0.041272392,-0.004582135,-0.064172869,-0.13505235,-0.1948095,-0.2544177,-0.3251074,-0.39559683,-0.4523894,-0.52810999,-0.59930062,-0.64196937,-0.66091166,-0.69542042,-0.73128666,-0.77400525,-0.79942714,-0.82522696,-0.85400174,-0.87493557,-0.90067357,-0.92817637,-0.9384973,-0.96461575,-0.97711635,-0.9905846,-1.0101457,-1.0154978,-1.035865,-1.0590717,-1.0692804,-1.0835757,-1.0964479,-1.0972761,-1.1032832,-1.1032869,-1.0910028,-1.069842,-1.0602115,-1.0485826,-1.0234132,-0.99836768,-0.95754643,-0.91276512,-0.87671435,-0.83679058,-0.77897046,-0.72050298,-0.6614633,-0.59310426,-0.51493326,-0.44448344,-0.37500703,-0.30326849,-0.22967475,-0.14655373,-0.065806667,0.010765949,0.10515526,0.16707877,0.20492215,0.23662423,0.24558,0.2652567,0.2817705,0.29119697,0.31997239,0.3207444,0.32367743,0.32292552,0.3183253,0.33888813,0.37213277,0.41384022,0.45408424,0.50791344,0.57411718,0.63403752,0.69007612,0.745528,0.7901088,0.81858584,0.85379339,0.90294727,0.95574592,1.0115018,1.0730231,1.1275754,1.180766,1.2595995,1.3135283,1.3660673,1.4172041,1.4558343,1.4916561,1.5207748,1.5576261,1.5902769,1.6221443,1.6622754,1.7328262,1.8208343,1.9338519,2.0246537,2.1158609,2.1626133,2.1704028,2.1384515,2.0593678,1.9889262,1.895197,1.7845689,1.6963901,1.6288011,1.6271596,1.644052,1.6504512,1.6421081,1.6303762,1.6071407,1.5847956,1.5563745,1.5282152,1.4866345,1.4472003,1.4207731,1.3893008,1.3470841,1.2857899,1.2151464,1.1122567,1.0268653,0.99654617,0.96893896,0.9359491,0.89920232,0.85443382,0.79903584,0.74806359,0.72474895,0.69684739,0.63096173,0.57334544,0.52005012,0.4694614,0.38144302,0.30339382,0.21986868,0.15088874,0.069666585,-0.0037255272,-0.086235679,-0.16096401,-0.24191715,-0.32112262,-0.41178468,-0.49009311,-0.5778206,-0.65909189,-0.73802752,-0.81628674,-0.86189857,-0.92111907,-0.95995021,-1.0151892,-1.0702284,-1.1304126,-1.1582677,-1.1860719,-1.2023136,-1.208635,-1.2183642,-1.2125627,-1.2030117,-1.187309,-1.1602618,-1.1418869,-1.1306894,-1.1279665,-1.1125564,-1.1018488,-1.087158,-1.0546687,-1.0098542,-0.97119846,-0.93892286,-0.91825337,-0.90328478,-0.87746864,-0.83922614,-0.81132633,-0.77584827,-0.72248611,-0.66118854,-0.59108804,-0.52577975,-0.46351668,-0.40750478,-0.3404075,-0.27080962,-0.20700571,-0.14847674,-0.08079659,-0.015962264,0.049741708,0.1161711,0.1801907,0.22835052,0.28714426,0.33541429,0.35610929,0.32907419,0.2932851,0.22746401,0.15612933,0.12943995,0.19692053,0.26118701,0.32512357,0.37433066,0.41450556,0.45531023,0.46891586,0.47317973,0.47691489,0.41950761,0.33193195,0.24140158,0.1625576,0.079035653,-0.005576568,-0.086790399,-0.16246522,-0.2479852,-0.32463403,-0.40490553,-0.48741929,-0.56850023,-0.64507723,-0.72863281,-0.80849469,-0.88786759,-0.96427396,-1.0463775,-1.1252787,-1.1992071,-1.2881261,-1.369746,-1.4458528,-1.5264685,-1.5955218,-1.6817842,-1.7605978,-1.8330731,-1.9141499,-1.9638143,-1.9068004,-1.8144377,-1.7297924,-1.6584275,-1.5584804,-1.4704192,-1.3625622,-1.2771691,-1.1934117,-1.0975745,-0.99458877,-0.89808999,-0.78832324,-0.70157081,-0.59489408,-0.49268356,-0.40668208,-0.2999707,-0.23210884,-0.13642844,-0.057964005,0.048325568,0.15496768,0.22748133,0.2945527,0.39250909,0.47586539,0.53709887,0.60225709,0.63201983,0.61045614,0.65811216,0.72052655,0.81080533,0.88136132,0.96365785,1.0281604,1.0812708,1.1441118,1.1911042,1.2317232,1.2680399,1.2614019,1.2297442,1.1847591,1.1407302,1.0875809,1.0288792,0.96428181,0.90805778,0.84300027,0.77350207,0.72890693,0.76538397,0.83637637,0.90972007,0.97222775,1.0536578,1.1157575,1.1887421,1.2565071,1.3198828,1.3812071,1.4398816,1.481237,1.5272882,1.5222866,1.5097906,1.4737732,1.4240349,1.3606565,1.3037618,1.2055158,1.1275556,1.1401108,1.1967138,1.2559074,1.3059558,1.3368021,1.3622595,1.3126299,1.2607917,1.1962682,1.1139486,1.0399527,0.9842109,0.91765126,0.85260484,0.75830489,0.69687627,0.60904245,0.51819573,0.42439324,0.33469741,0.2536515,0.1695114,0.073173932,-0.006635744,-0.09247788,-0.16614831,-0.25210954,-0.33140546,-0.41674785,-0.49277416,-0.56976624,-0.65269475,-0.73556191,-0.81443315,-0.89385697,-0.96676094,-1.0505561,-1.1258835,-1.2108262,-1.2920415,-1.3641131,-1.4459101,-1.5283893,-1.606245,-1.6868767,-1.7556552,-1.8380963,-1.9036336,-1.9847974,-1.9925177,-1.9185977,-1.8419365,-1.7502731,-1.6720497,-1.580727,-1.492408,-1.4051759,-1.328284,-1.2388004,-1.1478669,-1.0597675,-0.96814588,-0.87945548,-0.78947816,-0.69951667,-0.600786,-0.51269368,-0.41250436,-0.32047121,-0.21492764,-0.1105149,-0.0096104418,0.059068715,0.10832625,0.17242996,0.22699885,0.2862086,0.26895159,0.2578867:2
-0.010878665,-0.062580552,-0.1077638,-0.15409813,-0.22209562,-0.2872769,-0.35099394,-0.41537922,-0.47388937,-0.54518011,-0.59965293,-0.66642719,-0.73111398,-0.79467276,-0.84968438,-0.90921954,-0.96320153,-1.005195,-1.0526692,-1.0774457,-1.1297127,-1.173273,-1.2159635,-1.2417057,-1.258647,-1.310353,-1.3556531,-1.3845023,-1.3866195,-1.4145508,-1.4282763,-1.4424615,-1.4508856,-1.4703224,-1.470094,-1.4976368,-1.4931397,-1.5026812,-1.5094034,-1.4973864,-1.4967473,-1.4324872,-1.4002261,-1.3483227,-1.2444186,-1.1359757,-1.0282209,-0.91637618,-0.81446174,-0.71219156,-0.58837432,-0.48484378,-0.38965428,-0.29035052,-0.19017506,-0.10875452,-0.049010886,-3.7613834E-4,0.043909308,0.080962617,0.10378182,0.12920979,0.14683413,0.16003238,0.16869605,0.18530274,0.18888259,0.20570779,0.23241676,0.25657775,0.25622443,0.28506106,0.36547056,0.40190841,0.45139782,0.50132443,0.54868073,0.58958623,0.64219056,0.72303173,0.81546068,0.87316455,0.93117456,1.0033121,1.068646,1.1405981,1.2138547,1.2235068,1.2673253,1.3168203,1.3212854,1.3650898,1.3685476,1.4047983,1.4152528,1.4260888,1.4515606,1.474907,1.5386933,1.6168083,1.7154053,1.8167891,1.9202272,2.0294077,2.1036959,2.2150661,2.3257198,2.4328013,2.536682,2.5580868,2.5436677,2.4947474,2.429675,2.3061667,2.1717864,2.0382938,1.9047729,1.7975585,1.6630768,1.553197,1.4670897,1.3696075,1.2734991,1.1783511,1.1050696,1.0450446,1.0129855,0.98466494,0.94886333,0.94448282,0.90566352,0.86560133,0.82011911,0.79003945,0.72842871,0.66767473,0.59120903,0.54462386,0.48218213,0.40968548,0.39747814,0.34435625,0.31892252,0.26698746,0.22926866,0.12847504,0.068158991,-0.04050311,0.041870836,-0.028905322,-0.12956986,-0.22294729,-0.31597505,-0.38784333,-0.45487601,-0.46614602,-0.4849266,-0.48596638,-0.46922108,-0.45390583,-0.45762225,-0.46439471,-0.48542472,-0.51697379,-0.54062054,-0.55723341,-0.51382825,-0.41793042,-0.35272124,-0.32798997,-0.35109419,-0.45474401,-0.52385062,-0.61870513,-0.65818863,-0.67745361,-0.69791462,-0.70350817,-0.72765179,-0.73518186,-0.74325798,-0.74486832,-0.76128065,-0.78094658,-0.77456036,-0.79225123,-0.77921408,-0.82328003,-0.85376651,-0.84278103,-0.89453298,-0.95989941,-0.97617405,-0.94615259,-0.8915363,-0.82879186,-0.76349621,-0.70600848,-0.6310098,-0.55895783,-0.47918551,-0.42260834,-0.35388027,-0.27047275,-0.19114655,-0.12382885,-0.050524716,0.0068890243,0.076868636,0.14636494,0.12790435,0.089729412,0.056009164,0.024620448,-0.0012324258,-0.024574556,-0.043633382,-0.05832132,-0.069928795,-0.076634021,-0.078826814,-0.07766382,-0.072410328,-0.063628655,-0.049301796,-0.040930534,-0.14105122,-0.25698236,-0.39087942,-0.52505144,-0.65768228,-0.79097773,-0.92309826,-1.0243695,-1.1550008,-1.2860049,-1.4203457,-1.5504156,-1.6813154,-1.7808493,-1.8524037,-1.8282572,-1.7697247,-1.7062446,-1.6302547,-1.5432038,-1.4549839,-1.3787397,-1.2840062,-1.2022029,-1.1121897,-1.0190648,-0.93034229,-0.84186576,-0.74904517,-0.65969977,-0.57914848,-0.53685414,-0.4369635,-0.34876088,-0.26678013,-0.17556107,-0.081072756,-0.0075596452,0.085917009,0.14345675,0.2219529,0.31034178,0.3938895,0.48564825,0.56868153,0.65985191,0.74661426,0.83512283,0.91722851,1.0068981,1.0760633,1.1595172,1.227875,1.3177032,1.3819165,1.4434979,1.5031673,1.5598108,1.5861764,1.5673271,1.5004,1.4463315,1.3582124,1.2838064,1.1993745,1.198751,1.265186,1.3412172,1.4244156,1.4955038,1.5572053,1.6051722,1.6399431,1.6434345,1.6338119,1.6157591,1.5717227,1.5406529,1.4971071,1.4339029,1.3683245,1.3059941,1.2456807,1.1868353,1.117452,1.0539845,0.9911254,0.92519731,0.86380988,0.80145427,0.74139652,0.67148191,0.60735495,0.54147989,0.46089386,0.37678237,0.30998046,0.22627495,0.13105291,0.05357792,-0.03324581,-0.11485418,-0.21934022,-0.3278049,-0.40534133,-0.51224564,-0.61857068,-0.72422364,-0.82101954,-0.92194675,-1.0415469,-1.146666,-1.2515277,-1.3564219,-1.43299,-1.5227938,-1.604717,-1.538682,-1.4487816,-1.4737389,-1.3886906,-1.3756271,-1.2614894,-1.1365166,-1.0506788,-0.94163132,-0.82982964,-0.72296,-0.61447682,-0.50487158,-0.39535097,-0.28410248,-0.18581357,-0.092284964,6.4309035E-4,0.10353858,0.19080691,0.28034245,0.36341715,0.44996291,0.54249875,0.62120129,0.69165666,0.76750485,0.84429746,0.90734487,0.95197306,0.9266406,0.90386411,0.86333729,0.81483067,0.77166216,0.71395633,0.65944571,0.60623955,0.54162136,0.47835507,0.40761254,0.3677288,0.29571637,0.2240833,0.14624428,0.068680726,0.0010565717,-0.071970313,-0.17777287,-0.28484994,-0.39255306,-0.45420638,-0.52226562,-0.61790188,-0.68169096,-0.75344292,-0.84374652,-0.94117757,-1.038864,-1.1321327,-1.2303372,-1.2759554,-1.3547826,-1.4100881,-1.3775863,-1.2879732,-1.1733749,-1.0826426,-0.97602172,-0.87562083,-0.77753824,-0.6754383,-0.56031468,-0.4614327,-0.34246889,-0.22781319,-0.11018491,-0.003564149,0.061496434,0.10306352,0.094745422,0.087721735,0.047907771,0.012822232:2
3.1019944,2.9064049,2.7412795,2.5438373,2.3789244,2.2140991,2.0172609,1.8509214,1.6859115,1.5096569,1.3243575,1.1585723,0.99359635,0.82516846,0.63206366,0.46580881,0.27229848,0.10307031,-0.061000386,-0.22724336,-0.42537142,-0.58491628,-0.71572183,-0.86770459,-1.0282272,-1.2203075,-1.3970549,-1.4855768,-1.448544,-1.3710842,-1.2816459,-1.261065,-1.2038818,-1.1029246,-1.0002325,-0.88998695,-0.76927035,-0.6602641,-0.55521854,-0.52490753,-0.50560758,-0.39997765,-0.29961877,-0.24554617,-0.18675121,-0.19097819,-0.29540646,-0.44423468,-0.4991591,-0.42043681,-0.37282093,-0.31845618,-0.31679597,-0.23074169,-0.15274055,-0.099014311,0.01868525,0.11486287,0.12444585,0.025309475,0.043911278,0.12862796,0.18509698,0.32101639,0.34744756,0.3398218,0.416283,0.4886976,0.56527581,0.63031851,0.6090648,0.49915473,0.35123092,0.21703254,0.10724796,-0.041907229,-0.15578087,-0.29060225,-0.39734241,-0.51476034,-0.55194427,-0.54017087,-0.51018533,-0.48701044,-0.40967497,-0.35988931,-0.29065437,-0.33629875,-0.25625024,-0.1796173,-0.15965102,-0.1322246,-0.049435131,0.01375271,0.040023078,0.0034243204,-0.037675382,0.041189317,0.089552976,0.16491225,0.16086128,0.14048616,0.20101881,0.23564099,0.2728381,0.2987451,0.27129387,0.30255377,0.38181516,0.46957588,0.54153326,0.63807341,0.73100719,0.80172304,0.86401197,0.87776662,0.86440918,0.85654551,0.98371099,1.0960899,1.2202582,1.2967319,1.4066939,1.5352527,1.6669213,1.7922402,1.868892,1.8574566,1.7475041,1.604583,1.4634901,1.3245636,1.2531666,1.1337666,1.043027,0.89309018,0.76789856,0.7174621,0.67208527,0.62030398,0.55909779,0.4261982,0.28666506,0.1467302,0.0084869355,-0.042902396,-0.17135206,-0.30536534,-0.42744635,-0.42485957,-0.38515782,-0.51940109,-0.67228941,-0.81114818,-0.9372493,-1.0810559,-1.2141951,-1.360098,-1.5010798,-1.641768,-1.7779102,-1.9109698,-2.0521371,-2.052205,-1.9875872,-1.8937307,-1.7875408,-1.675253,-1.5280334,-1.4955843,-1.3432488,-1.3499549,-1.2291614,-1.0610116,-0.90569548,-0.73464001,-0.66881264,-0.58220031,-0.46554981,-0.38893275,-0.31224273,-0.41472984,-0.52849902,-0.61796301,-0.67711933,-0.74539104,-0.62775006,-0.484099,-0.34008917,-0.2013514,-0.019106402,0.13988544,0.30034908,0.41167455,0.4575414,0.3606031,0.30031579,0.43253582,0.46358351,0.61279731,0.78955197,0.95096493,1.094677,1.2191531,1.2945174,1.3022202,1.2905901,1.2982767,1.3047595,1.1954627,1.1314104,0.96277471,0.88060849,0.74920921,0.59025204,0.57543148,0.59240616,0.57155202,0.48936318,0.36864231,0.27723718,0.087925012,-0.063486898,-0.13263837,-0.2861744,-0.43384414,-0.5749384,-0.58185635,-0.49213393,-0.38749112,-0.26181167,-0.22098372,-0.2808921,-0.36552299,-0.45779257,-0.53951543,-0.62195325,-0.79601444,-0.94651595,-1.0609447,-1.0445947,-1.1581822,-1.3055251,-1.4425524,-1.6046584,-1.7353494,-1.8434239,-1.9510964,-2.0735331,-2.0215427,-1.8651095,-1.7672735,-1.6237632,-1.4920093,-1.3467549,-1.206764,-1.1174464,-0.9797887,-0.82504768,-0.75129666,-0.68011662,-0.60955984,-0.59339692,-0.47972504,-0.37330666,-0.3870429,-0.42831581,-0.39915537,-0.26430815,-0.12255549,0.035263155,0.061420897,0.19468498,0.33138895,0.48316815,0.61387725,0.62467293,0.74727853,0.8782075,1.0375782,1.1546311,1.3116716,1.4556085,1.5606558,1.6934009,1.8273916,1.8078586,1.6926972,1.5816826,1.4493116,1.3218613,1.2274705,1.1033367,0.97360371,0.8570302,0.73724618,0.66391178,0.73165034,0.63463342,0.51442875,0.39518535,0.30311482,0.35783345,0.28650125,0.18726119,0.073924711,-0.016004736,0.062340312,0.21473689,0.31498429,0.27998556,0.20259785,0.12365247,0.027094492,-0.065491623,-0.022746366,-0.088226014,-0.17086334,-0.26239183,-0.34995886,-0.24514509,-0.12301326,-0.14284243,-0.21525281,-0.30453429,-0.37472223,-0.46506807,-0.56082046,-0.63573154,-0.67805714,-0.52733122,-0.39070616,-0.24527084,-0.10280817,0.0030925985,0.14752184,0.29597552,0.43983139,0.58227713,0.70904159,0.80030968,0.75019303,0.64263838,0.58273158,0.56181134,0.4369477,0.38202343,0.35027913,0.27037677,0.17285885,0.13275262,0.039375499,-0.053194221,-0.14750656,-0.10267588,0.013096547,-0.0071336962,-0.069517238,-0.16628133,-0.22173406,-0.32583034,-0.41796406,-0.37895146,-0.42606911,-0.54610177,-0.65324835,-0.75587816,-0.82168691,-0.88102195,-0.94726014,-0.94154678,-0.90789396,-0.76167723,-0.62873577,-0.56789352,-0.58073544,-0.56630791,-0.58807474,-0.64312953,-0.66107107,-0.74739977,-0.83600168,-0.90078358,-0.97232484,-1.0877457,-1.068478,-1.1857483,-1.209008,-1.2617744,-1.3303081,-1.3736576,-1.4237355,-1.4191026,-1.4838219,-1.5419488,-1.6120846,-1.6687991,-1.7029291,-1.5612051,-1.3967328,-1.2317783,-1.0365426,-0.87015988,-0.70496435,-0.5396778,-0.37411257,-0.1877829,-0.012803088,0.15276356,0.3362713,0.51471708,0.67981521,0.84543929,1.0290631,1.2076071,1.3081056,1.4740801,1.6572653,1.8367673,2.001958,2.1675621,2.3399689,2.5106808,2.6960242,2.861511,3.0270915,3.1037924:3
0.79583195,0.66169906,0.49946453,0.35914679,0.2304636,0.094897102,-0.058769317,-0.18838512,-0.34198133,-0.49474661,-0.52029572,-0.48099506,-0.44967454,-0.3915168,-0.314787,-0.28051289,-0.2638225,-0.17980324,-0.10003208,-0.074885798,-0.039451735,-0.028111834,-0.11136669,-0.15019625,-0.050746538,0.04925509,0.16498795,0.1901609,0.15919153,0.23135211,0.2771189,0.3473379,0.41981075,0.42856416,0.32334243,0.19213656,0.07188463,-0.015080269,-0.049409703,0.010213285,0.13565179,0.23050983,0.20595197,0.30197571,0.4150767,0.51103703,0.64225358,0.7172158,0.62377678,0.53014722,0.64791003,0.7665757,0.88048417,1.0120635,1.1297825,1.1334287,1.2626053,1.3935065,1.5121547,1.6423101,1.705782,1.6489497,1.5270064,1.373649,1.2354718,1.0965448,0.96390234,0.80753534,0.67316847,0.53597114,0.44758349,0.29968875,0.15377184,0.011708655,-0.13020835,-0.25669908,-0.40539397,-0.54955165,-0.70304211,-0.83111999,-0.92367319,-0.95097684,-0.94197866,-1.0808196,-1.2198227,-1.3592081,-1.513782,-1.647347,-1.7925972,-1.9289817,-2.0670441,-2.2131336,-2.3144973,-2.3861027,-2.4618695,-2.455141,-2.327715,-2.2243179,-2.0837022,-1.9702392,-1.8409246,-1.7046514,-1.5850305,-1.4635708,-1.3823573,-1.4142435,-1.4420083,-1.3609416,-1.2214545,-1.1013025,-0.99470547,-0.85833499,-0.83787898,-0.84039491,-0.71951507,-0.64602288,-0.58783575,-0.52905606,-0.60507638,-0.73894546,-0.83712775,-0.92030824,-0.98836666,-0.88695036,-0.74845518,-0.60470848,-0.469208,-0.30809375,-0.16133291,-0.093478276,0.068598794,0.226775,0.34938838,0.47479159,0.51706598,0.55281679,0.71501791,0.87376525,0.99838285,1.139746,1.2707542,1.402903,1.54221,1.7051301,1.8365998,1.9691173,2.0877055,2.1407043,2.0514274,1.8977786,1.7452449,1.6328913,1.4427121,1.2818377,1.1297045,1.0313815,0.84151654,0.76375185,0.61281552,0.49906406,0.33887482,0.27567777,0.30732872,0.31048933,0.18344633,0.028411393,-0.11364626,-0.16581299,-0.32389572,-0.46556258,-0.5498238,-0.54563107,-0.47521259,-0.36506744,-0.22596215,-0.12164868,-0.13631316,-0.19176062,-0.29963569,-0.3237649,-0.45767749,-0.58831671,-0.70220001,-0.68677514,-0.82831342,-0.97120714,-1.1004162,-1.2446774,-1.2417398,-1.2443557,-1.3309733,-1.4602416,-1.5863698,-1.7165646,-1.8371178,-1.9726312,-2.0885682,-2.1587675,-2.2265846,-2.2948004,-2.1276175,-1.9967447,-1.8320998,-1.6835013,-1.5231725,-1.3576948,-1.1955881,-1.0350252,-0.87253554,-0.70828007,-0.5631016,-0.59158498,-0.63604864,-0.56902128,-0.4340266,-0.29400868,-0.14817992,0.014837806,0.18475643,0.37322942,0.46333356,0.55960349,0.69662377,0.8664457,1.0307621,1.2210082,1.3609918,1.5259476,1.6266009,1.6210441,1.5425733,1.4318127,1.3397449,1.2430519,1.1257338,1.0189714,0.96081094,0.92965205,0.81113422,0.70169271,0.60469383,0.55724443,0.5954678,0.54283983,0.44651811,0.34793228,0.26721596,0.22360888,0.12907878,0.027883582,-0.053129625,0.017246622,0.13937471,0.27789614,0.44247647,0.48295731,0.44220326,0.35377212,0.27155033,0.20593632,0.29025022,0.27097721,0.17989552,0.057606493,-0.048691111,-0.14188778,-0.22757115,-0.091395542,0.059519045,0.038949911,-0.014802121,-0.11507085,-0.20659853,-0.26110422,-0.33313285,-0.40488197,-0.48003069,-0.54371947,-0.59781489,-0.57431597,-0.43402511,-0.36087863,-0.25561106,-0.11112234,0.028097315,0.1654333,0.31126396,0.44787315,0.59469757,0.67444519,0.65172454,0.61382683,0.5786843,0.57796268,0.51360076,0.45568753,0.55069517,0.63837457,0.61053512,0.53465254,0.45328803,0.37117079,0.24985411,0.10799729,0.062744141,0.21483368,0.28900623,0.25690554,0.17896018,0.11984132,0.015553368,-0.098176615,-0.14961553,-0.19115159,-0.30383618,-0.39086041,-0.44677385,-0.53885624,-0.52870778,-0.57862911,-0.64039423,-0.70929434,-0.77047718,-0.79161076,-0.84322921,-0.89724463,-0.95319303,-1.0248863,-1.0810026,-1.1384416,-1.2049152,-1.2565979,-1.3040573,-1.3169056,-1.1632958,-0.99896747,-0.83151215,-0.66465016,-0.46620295,-0.26688739,-0.10392215,0.061408199,0.26137795,0.34680873,0.40216868,0.56037099,0.69578035,0.82482958,0.9346527,1.106825,1.2729789,1.3962709,1.4873774,1.6157533,1.7821258,1.9484455,2.1152139,2.2709563,2.3707582,2.5040056,2.5519165,2.4609312,2.3834399,2.2650632,2.1257152,1.9333368,1.766103,1.6329357,1.4541738,1.3012332,1.1805477,1.0108935,0.89263179,0.75538557,0.59075843,0.40022945,0.30082216,0.13141447,-0.062562268,-0.22411367,-0.38964813,-0.58851579,-0.75941382,-0.90473761,-1.0677974,-1.2025938,-1.3429068,-1.2669724,-1.1789993,-1.0950866,-1.0199907,-0.94526642,-0.90483751,-0.84170903,-0.79676579,-0.75641738,-0.71299594,-0.65526519,-0.59371064,-0.46136209,-0.3324724,-0.26510541,-0.22851791,-0.10507812,-0.020603293,-0.087903918,-0.18359241,-0.25621482,-0.18461476,-0.075260432,0.052616303,0.12305935,0.22363825,0.31984583,0.38867594,0.44797313,0.46992286,0.36316496,0.40971167,0.48914131,0.59762147,0.66669325,0.59106364,0.62985385,0.69523702,0.74849432,0.81583594:3
2.4994921,2.4131337,2.2901383,2.203793,2.0809233,1.9800375,1.8719206,1.7491476,1.6263861,1.5036361,1.4175281,1.2948391,1.2088452,1.1042484,1.1071091,1.1435475,1.1809221,1.2136188,1.2361596,1.2491517,1.2471032,1.229656,1.2104293,1.1844335,1.159266,1.1228752,1.0960722,1.0644608,1.0295131,1.0090246,0.9800176,0.94996979,0.91669332,0.89969588,0.89325777,0.8545603,0.78748112,0.72066463,0.6272151,0.52935961,0.43922714,0.34880593,0.24481147,0.13382244,0.027484993,-0.033178331,-0.081967494,-0.11419036,-0.13336522,-0.15676078,-0.17773328,-0.19772969,-0.22490004,-0.24450016,-0.27543197,-0.29806935,-0.30902781,-0.30661661,-0.30349045,-0.29504679,-0.27890537,-0.26314801,-0.25366534,-0.23266849,-0.21279721,-0.20130966,-0.23992084,-0.2419806,-0.1887832,-0.14558457,-0.16546391,-0.27521765,-0.3820066,-0.46990818,-0.58425443,-0.66246999,-0.7756485,-0.8561521,-0.9605697,-1.0437764,-1.133182,-1.2162221,-1.3068138,-1.3849168,-1.4446752,-1.5085661,-1.5237493,-1.51333,-1.5183757,-1.5271854,-1.5302326,-1.5198846,-1.5007003,-1.4685174,-1.436233,-1.4104941,-1.3812474,-1.3451089,-1.3041465,-1.2630267,-1.2285651,-1.1855766,-1.1387094,-1.0871624,-1.0366855,-0.97710488,-0.9189444,-0.85815964,-0.78183383,-0.7127971,-0.64522032,-0.5622086,-0.49972267,-0.41983652,-0.34752338,-0.26970227,-0.22609076,-0.30568312,-0.41326643,-0.43154067,-0.39992671,-0.337448,-0.257543,-0.18071328,-0.10584616,-0.024301055,0.051407748,0.13398835,0.20326573,0.28609604,0.36809655,0.45073465,0.52785863,0.49228773,0.41914816,0.32193653,0.2441508,0.15501845,0.070577702,-0.014124605,-0.1021411,-0.18964216,-0.28160628,-0.36536122,-0.45063992,-0.53701265,-0.63474991,-0.72667196,-0.81392049,-0.8989633,-0.98459732,-1.0698227,-1.1711789,-1.2455582,-1.3224908,-1.34317,-1.331728,-1.3094084,-1.2544244,-1.2121433,-1.1657529,-1.1335765,-1.1034111,-1.063428,-1.009684,-0.92349016,-0.85090695,-0.74044943,-0.62497813,-0.50986474,-0.42494743,-0.31945553,-0.20316706,-0.081253202,0.0070524347,0.098598045,0.21489085,0.31006344,0.37125225,0.38587252,0.45941765,0.53724652,0.65369109,0.77485592,0.89586899,1.0188899,1.1087408,1.1052094,1.0334838,0.92543977,0.84621482,0.75918726,0.67413333,0.5809903,0.50357753,0.43142404,0.37074022,0.36673548,0.41904522,0.4941365,0.57575148,0.65910011,0.74318505,0.8232447,0.91298387,0.9983956,1.09923,1.2064822,1.3272561,1.4151067,1.5091682,1.5843088,1.5424847,1.5889879,1.6695289,1.755049,1.8430731,1.9646679,2.0474376,2.001737,1.9177557,1.8087966,1.7070219,1.5841993,1.461498,1.3395235,1.2418248,1.1682951,1.1755232,1.2366316,1.2932944,1.2635865,1.1604184,1.0520824,0.92927627,0.8062681,0.68557563,0.56619064,0.47854093,0.3660424,0.26874329,0.16837968,0.056719078,-0.029241591,-0.10849116,-0.18058075,-0.25495005,-0.32669127,-0.39162168,-0.42877766,-0.44097069,-0.37900834,-0.30961816,-0.24413884,-0.1483905,-0.068496742,0.027783466,0.092026427,0.17737903,0.26836642,0.3658957,0.45274297,0.3752622,0.29098598,0.19215109,0.086379283,-0.0018093535,-0.1205966,-0.20743736,-0.30882551,-0.40245461,-0.49950059,-0.54972043,-0.52078977,-0.59920173,-0.68996618,-0.77731558,-0.88522498,-0.98166183,-1.0633654,-1.1457119,-1.249149,-1.3255519,-1.4254652,-1.5089297,-1.5904483,-1.6538431,-1.6931556,-1.7191583,-1.7348342,-1.7185642,-1.6731191,-1.607077,-1.5221945,-1.4117605,-1.2957878,-1.1860265,-1.0883683,-0.99140961,-0.89781239,-0.8083695,-0.71970662,-0.69493915,-0.59538985,-0.50920733,-0.41231278,-0.32718506,-0.2494137,-0.16100072,-0.20583754,-0.27250545,-0.35535252,-0.42506492,-0.48860884,-0.55529872,-0.61531518,-0.67157986,-0.69531714,-0.63344315,-0.59082398,-0.66324665,-0.73077961,-0.79330941,-0.86105051,-0.92560315,-0.9870995,-1.0466838,-1.0881697,-1.1216119,-1.1498582,-1.17329,-1.2007659,-1.2312289,-1.2619707,-1.2862383,-1.313127,-1.3434868,-1.3665561,-1.3882154,-1.4133086,-1.4318295,-1.4488358,-1.445038,-1.4379408,-1.4131152,-1.3717847,-1.318466,-1.2416711,-1.1507553,-1.0624969,-0.97679249,-0.89708043,-0.79400562,-0.72109868,-0.61951521,-0.5192063,-0.44120314,-0.36316281,-0.28842181,-0.21780933,-0.16178868,-0.20058603,-0.23320444,-0.24479672,-0.24120929,-0.23082033,-0.15113847,-0.17021453,-0.17928213,-0.1940203,-0.19329836,-0.18618158,-0.17234392,-0.15784412,-0.14195385,-0.11506211,-0.097674309,-0.078946116,-0.060316848,-0.03922703,-0.014757009,0.012122438,0.047110171,0.074719326,0.10033102,0.15801484,0.26477655,0.38346815,0.46769874,0.54612977,0.62438038,0.70490814,0.77502247,0.79889095,0.81365917,0.84893304,0.87285606,0.90135344,0.91866274,0.94757661,0.97598847,1.0068077,1.0454229,1.0782841,1.1156754,1.143286,1.1733323,1.200445,1.2061842,1.2131672,1.2069121,1.2219565,1.2563686,1.3063837,1.3846088,1.4687039,1.5087552,1.565858,1.6531569,1.7756968,1.8622192,1.984953,2.1078656,2.2225755,2.3177833,2.4407238,2.51519:4
2.5389517,2.4351983,2.3151502,2.2025957,2.0752675,1.9635098,1.852387,1.7327158,1.6369789,1.5550931,1.427229,1.3175203,1.2007493,1.0874829,0.97384692,0.85892745,0.74260024,0.6241327,0.51977146,0.40121288,0.29784974,0.19396971,0.089323942,-0.0034450946,-0.11407069,-0.22977752,-0.34520785,-0.45590492,-0.56795971,-0.67410759,-0.7909573,-0.90595365,-1.0202157,-1.1271781,-1.2327154,-1.2930785,-1.403415,-1.5077509,-1.6165192,-1.7128904,-1.7618593,-1.6967767,-1.5979824,-1.5235187,-1.4477581,-1.3329377,-1.2434235,-1.1968624,-1.1208725,-1.0389535,-0.98347835,-0.96845178,-0.88094741,-0.78633134,-0.67212526,-0.57420446,-0.52051598,-0.48347636,-0.4035231,-0.35260432,-0.3047278,-0.25021565,-0.19510158,-0.12902249,-0.062625733,0.015275621,0.06090323,0.12324984,0.20777802,0.26616508,0.2878801,0.23263973,0.14753726,0.057960986,-0.046594667,-0.17758269,-0.29813571,-0.41917081,-0.49290015,-0.49580944,-0.4167595,-0.34433205,-0.2601278,-0.16522055,-0.095910115,-0.021973398,0.060725188,0.1533968,0.24669936,0.33857904,0.39919441,0.43895471,0.5364666,0.62442939,0.72029847,0.79322448,0.86266725,0.95166445,0.98800474,0.92699115,0.86180856,0.79602766,0.743665,0.76112287,0.77267462,0.79083978,0.84594736,0.85417067,0.88111149,0.94542097,0.99347478,1.0705411,1.1295851,1.163602,1.1914737,1.2150553,1.2553068,1.3083284,1.3543751,1.3906118,1.4331159,1.480975,1.509256,1.4750736,1.372851,1.2738146,1.175162,1.0895494,0.98417121,0.91558393,0.81756791,0.70171039,0.58965726,0.47309014,0.36693737,0.27485124,0.15967833,0.044021891,-0.06821984,-0.18364748,-0.29607155,-0.41793296,-0.51515821,-0.66216284,-0.78307925,-0.9160267,-1.0345536,-1.1490558,-1.2604541,-1.3011619,-1.2788047,-1.2807244,-1.2731407,-1.2448877,-1.1934416,-1.15121,-1.163843,-1.0644992,-1.081176,-1.0154277,-0.93661751,-0.8424608,-0.73853562,-0.63866752,-0.54593497,-0.46717005,-0.38073555,-0.30696994,-0.24369855,-0.16051237,-0.092943385,-0.025988372,0.038286972,0.12570287,0.21720089,0.236594,0.27469922,0.26531675,0.24669744,0.24429576,0.27483608,0.34983384,0.42347951,0.51751691,0.61117682,0.70184332,0.76114567,0.84954181,0.93300102,0.981948,1.0604564,1.1519712,1.2236373,1.2947077,1.3566212,1.447536,1.5441097,1.5333009,1.4222084,1.3219586,1.2049668,1.1007012,1.0476734,0.97214713,0.86464824,0.77632763,0.73502513,0.69288323,0.59122232,0.48266229,0.37901687,0.27359698,0.18250494,0.15137315,0.16511594,0.19077629,0.15206151,0.053750022,-0.048058304,-0.14245495,-0.24197293,-0.35190899,-0.45771501,-0.56480356,-0.67284842,-0.77921573,-0.88674393,-0.99670598,-1.0961351,-1.1985788,-1.2984452,-1.4018525,-1.4810921,-1.568022,-1.6627174,-1.6296429,-1.7155775,-1.8045162,-1.8345552,-1.9256148,-2.0352284,-2.1157048,-2.1720865,-2.2313547,-2.3033235,-2.3743436,-2.3142727,-2.2075156,-2.1117111,-2.0590292,-1.943192,-1.8704664,-1.792982,-1.7141501,-1.6261042,-1.5370411,-1.4200276,-1.3028581,-1.2009347,-1.0812631,-0.98381115,-0.86116703,-0.7459316,-0.61772336,-0.49688223,-0.40769475,-0.33662932,-0.27679178,-0.20462177,-0.096217627,0.013540486,0.11143875,0.19753315,0.29457905,0.37338253,0.48741983,0.58279415,0.66493255,0.7296596,0.82933223,0.93015137,1.0039701,0.92870238,0.83114841,0.74967809,0.66733114,0.6021063,0.54592043,0.48257693,0.40748106,0.3530056,0.33007694,0.29100427,0.23223099,0.16577662,0.075994356,-0.0041343341,-0.040686945,-0.10295291,-0.10670728,-0.19118201,-0.2761242,-0.3448374,-0.39628766,-0.40654012,-0.36722476,-0.28711546,-0.2068176,-0.23314189,-0.31572781,-0.39436104,-0.47444706,-0.54751528,-0.6247214,-0.67324972,-0.74233811,-0.83475284,-0.91989411,-1.010845,-1.0938315,-1.184937,-1.2705211,-1.3491925,-1.4158455,-1.4560104,-1.4393213,-1.3375749,-1.2020674,-1.0812337,-0.95146768,-0.84856367,-0.71430836,-0.68508145,-0.65913437,-0.62736579,-0.59003835,-0.54440871,-0.49303752,-0.4336677,-0.37021024,-0.29890266,-0.22347058,-0.14333533,-0.058878433,0.029961923,0.12653449,0.2235083,0.3237475,0.41764151,0.52378174,0.63266565,0.70848498,0.81077796,0.925862,1.0444297,1.1634934,1.2845286,1.4074001,1.5319773,1.6577035,1.7855189,1.7770924,1.6509017,1.5260046,1.4024724,1.2800599,1.159615,1.0411025,0.92470047,0.81023667,0.69812001,0.58790432,0.48079202,0.37655436,0.27569889,0.17801691,0.083736106,-0.0068011967,-0.092605021,-0.1743032,-0.25123958,-0.32313815,-0.38934352,-0.45024632,-0.50420999,-0.55183974,-0.59308222,-0.62688129,-0.65380907,-0.67287423,-0.67558879,-0.67920421,-0.67575505,-0.66431284,-0.65059994,-0.62560127,-0.59161481,-0.55059444,-0.50274423,-0.44841358,-0.38818039,-0.32179992,-0.2501909,-0.17296732,-0.091402334,-0.0052074694,0.085440006,0.17968495,0.27752662,0.37882641,0.4831001,0.59023735,0.70000638,0.81226482,0.92684479,1.0434445,1.1620409,1.2823571,1.4043625,1.527912,1.653172,1.7797567,1.9076225,2.0373826,2.1680502,2.3006733,2.4327371:5
2.8759524,2.7471677,2.6165862,2.485605,2.3660282,2.2369523,2.1195642,1.9886981,1.8714423,1.7477015,1.6116409,1.5052174,1.3668337,1.2521598,1.1161963,0.99180713,0.85956331,0.73780196,0.6184135,0.48794681,0.3465265,0.21842488,0.094933307,-0.025296657,-0.16226668,-0.27551906,-0.40685776,-0.49009695,-0.57464308,-0.70233593,-0.83035357,-0.98126144,-1.1048944,-1.192217,-1.24431,-1.3129966,-1.2077067,-1.2157005,-1.1208858,-1.01636,-1.0561346,-1.0982214,-1.0367682,-0.9189936,-0.8201864,-0.78646715,-0.80061304,-0.68909935,-0.55296595,-0.42032365,-0.36310529,-0.30616775,-0.25559005,-0.23611225,-0.24868387,-0.31757614,-0.36757927,-0.36836999,-0.33358538,-0.27889488,-0.2795678,-0.3379702,-0.29124001,-0.25961161,-0.1962442,-0.15569627,-0.23783515,-0.21269505,-0.11503231,-0.074578119,-0.096247796,-0.034215849,0.012164429,0.072619196,0.12280729,0.097125783,-0.044923035,-0.22658247,-0.37447069,-0.52245171,-0.67114087,-0.78540679,-0.8632392,-0.90152826,-0.85829351,-0.79697701,-0.73746537,-0.66126276,-0.60941221,-0.56084754,-0.5408676,-0.45140576,-0.37578439,-0.33374512,-0.41035232,-0.48932527,-0.54266504,-0.46654781,-0.36484716,-0.26445832,-0.15860909,-0.055947605,-0.054650813,-0.11002438,-0.016911042,0.043593719,0.093665999,0.1235975,0.0013248463,-0.13667525,-0.23810082,-0.19189392,-0.10681642,-0.0429358,0.028060292,0.12627453,0.015488723,0.094136171,0.16510233,0.29851039,0.38265021,0.44343184,0.56462928,0.45714319,0.55294454,0.69587587,0.82685515,0.91862022,0.92843101,1.0187161,1.0713824,1.1824066,1.273861,1.3512668,1.396197,1.465371,1.5487448,1.5832677,1.5309291,1.3952555,1.2493392,1.09512,0.95418001,0.78642467,0.651506,0.52658911,0.38317383,0.22934036,0.085461292,-0.048029487,-0.16595026,-0.16632736,-0.27678967,-0.41878184,-0.54019546,-0.67967968,-0.82508447,-0.97374703,-1.1228381,-1.2788938,-1.4008841,-1.5212773,-1.5897879,-1.7057968,-1.7345661,-1.6689394,-1.6252749,-1.5585481,-1.4671086,-1.3961963,-1.325867,-1.1954524,-1.0974081,-0.98954196,-0.89273078,-0.90893459,-1.0221431,-1.0258515,-0.94361987,-0.85849965,-0.7487585,-0.61449758,-0.48153448,-0.34760006,-0.31150619,-0.3359237,-0.37036732,-0.27004605,-0.21289519,-0.07561326,0.02812299,0.12466409,0.083696672,-0.027430473,-0.12427302,-0.20761822,-0.29353902,-0.28900917,-0.16936129,-0.039208353,0.066874705,0.077472342,0.14997314,0.2802554,0.40024272,0.5286209,0.6579268,0.69532787,0.71696455,0.84661864,0.95303913,1.0718571,1.1901315,1.2374299,1.3713429,1.5039545,1.6205926,1.7378659,1.861819,1.9767812,2.098883,2.1190706,2.0127733,1.8697409,1.7485085,1.5964922,1.4640105,1.4165621,1.3211722,1.1946709,1.0566247,0.92933263,0.78411307,0.64892049,0.64221699,0.56064336,0.43624705,0.29170154,0.17294157,0.042401013,0.034386127,-0.087334632,-0.22781129,-0.33885136,-0.48406114,-0.52575799,-0.49239861,-0.41326984,-0.37132597,-0.23326968,-0.16998163,-0.17914471,-0.28496434,-0.34954682,-0.45332385,-0.55275148,-0.56642098,-0.68878336,-0.80398888,-0.93059677,-1.0463711,-1.1624631,-1.1683285,-1.0992625,-1.0724031,-1.1436221,-1.238579,-1.3444582,-1.4534867,-1.565968,-1.649358,-1.7418685,-1.8308624,-1.8884232,-1.8169273,-1.7046421,-1.5675235,-1.4075221,-1.2892894,-1.166854,-1.0561535,-0.90437401,-0.75685327,-0.6153408,-0.43420766,-0.31863527,-0.28977744,-0.25406874,-0.1008417,0.034724456,0.18205881,0.32465592,0.43363952,0.58283633,0.76441941,0.88012327,0.96663352,1.0951433,1.2770702,1.4285314,1.5364163,1.6735364,1.6775451,1.6012018,1.4982813,1.3976883,1.286116,1.17148,1.188966,1.0748901,0.95669536,0.83606766,0.72187448,0.78260461,0.74692772,0.65343455,0.54963456,0.43260413,0.35286544,0.32744169,0.2231794,0.14099938,0.09943633,0.20364134,0.31827159,0.44146597,0.46552508,0.39873199,0.32378236,0.22806599,0.13861713,0.057211765,0.053709627,-0.070859114,-0.21937288,-0.32875909,-0.31284125,-0.18230907,-0.16000465,-0.24606257,-0.36965824,-0.42720797,-0.5570817,-0.67012106,-0.7646195,-0.83154371,-0.80290076,-0.8435653,-0.95186042,-0.86727993,-0.78860094,-0.65749072,-0.52578916,-0.40333734,-0.29250333,-0.30010701,-0.32960598,-0.35183386,-0.36163258,-0.36275296,-0.30785451,-0.33533181,-0.37239428,-0.44058253,-0.49884287,-0.38713495,-0.38709833,-0.45300429,-0.55933168,-0.68129619,-0.80654177,-0.88425955,-0.77485266,-0.69023894,-0.70590503,-0.7327369,-0.78031839,-0.84776628,-0.91766976,-0.95482829,-1.0649296,-1.1399336,-1.2149376,-1.2825511,-1.3400544,-1.3831662,-1.4187828,-1.4291587,-1.4336344,-1.4289421,-1.4696702,-1.470373,-1.4170708,-1.281103,-1.143373,-1.0168692,-0.88742506,-0.75213354,-0.63324802,-0.50249102,-0.37155855,-0.24156582,-0.1122571,0.016087824,0.14222468,0.26514599,0.39423251,0.52437232,0.64880634,0.76888708,0.8993803,1.0154301,1.1404887,1.2630978,1.3891974,1.5119184,1.6327308,1.758265,1.8784103,2.0083122,2.1212549,2.2514239,2.3676503,2.49372,2.6130712,2.721122,2.8118245:3
0.51577724,0.48962325,0.46105382,0.41668129,0.38655065,0.3569644,0.30967177,0.24995576,0.1946298,0.15829657,0.10603447,0.043247525,-0.017823247,-0.069619903,-0.13598399,-0.22644362,-0.29357186,-0.39243252,-0.48322991,-0.58459579,-0.67779509,-0.76832205,-0.88249993,-0.97321633,-1.0874252,-1.202707,-1.3159872,-1.4021377,-1.3944392,-1.3530235,-1.3156381,-1.2366274,-1.1566023,-1.0779836,-0.99807637,-0.92206554,-0.84812839,-0.76605883,-0.69634516,-0.63179231,-0.56296689,-0.50189748,-0.46372127,-0.41591371,-0.36749145,-0.33518328,-0.30921917,-0.2610954,-0.2031246,-0.21859678,-0.20878054,-0.13523246,-0.16973165,-0.20324202,-0.22818688,-0.24315721,-0.2524411,-0.2920173,-0.29594928,-0.32233678,-0.34702608,-0.36998245,-0.40490592,-0.42699183,-0.46772623,-0.4763827,-0.51366224,-0.54463426,-0.57325518,-0.59228628,-0.62041491,-0.65040637,-0.67791951,-0.72308567,-0.77144072,-0.80569645,-0.85762796,-0.90563594,-0.96104078,-1.0249394,-1.0614124,-1.1091491,-1.1538048,-1.1966088,-1.2354411,-1.2577751,-1.2867721,-1.3167898,-1.3320202,-1.3447903,-1.3325483,-1.299065,-1.211988,-1.131459,-1.0799796,-1.0045121,-0.94516107,-0.86997599,-0.80398983,-0.74573067,-0.69280507,-0.64383068,-0.59018452,-0.544329,-0.49276974,-0.44650779,-0.40879952,-0.37503048,-0.33911694,-0.30979266,-0.29225205,-0.25073511,-0.22681532,-0.1985604,-0.16839584,-0.11331454,-0.046989807,0.030944437,0.10273204,0.13879296,0.18812557,0.25179465,0.30115625,0.36203232,0.38264921,0.3979873,0.40671536,0.36965208,0.32691454,0.29046522,0.27514771,0.23058972,0.21863325,0.20823442,0.19827229,0.22728935,0.22560663,0.26670074,0.35901008,0.43852342,0.53130264,0.61643867,0.69330964,0.78867224,0.86535105,0.94949609,1.0365319,1.1294799,1.216335,1.2993068,1.3662861,1.4590359,1.5354842,1.6149474,1.6900274,1.7733037,1.8567153,1.9323227,2.0085954,2.0793159,2.1481587,2.2123147,2.2457401,2.3262568,2.4242214,2.51413,2.5666012,2.5406072,2.5594605,2.5387366,2.4899951,2.4569765,2.468089,2.4264887,2.3656955,2.3372593,2.2838123,2.2138483,2.1444056,2.056597,1.9871999,1.9074143,1.834027,1.7597383,1.6804487,1.5988786,1.5472405,1.4709174,1.3810199,1.2878085,1.2074915,1.1098366,1.0139521,0.92215188,0.83343649,0.7473659,0.64951992,0.56604825,0.47078811,0.38882479,0.29440652,0.21327838,0.11685529,0.038383869,-0.047886919,-0.12798385,-0.20713509,-0.26733058,-0.30726538,-0.33766726,-0.30800511,-0.23124808,-0.16372927,-0.14195325,-0.14210784,-0.18574988,-0.23963637,-0.28571837,-0.32642542,-0.34206229,-0.3888754,-0.46180065,-0.51874242,-0.57031841,-0.62667745,-0.67905436,-0.71039407,-0.77119682,-0.79425854,-0.83679122,-0.84220253,-0.88510982,-0.90777867,-0.90757105,-0.9302608,-0.95972274,-0.98638167,-1.0180207,-1.0685195,-1.0958069,-1.1355966,-1.1736566,-1.2217971,-1.2575099,-1.3000259,-1.3532961,-1.422439,-1.5268301,-1.6221241,-1.7089164,-1.7901695,-1.8841815,-1.9447098,-1.9753172,-1.9951297,-1.9911983,-1.9173675,-1.849316,-1.7894704,-1.7411482,-1.7089271,-1.6382708,-1.5641372,-1.4786564,-1.3961612,-1.3173947,-1.2344275,-1.1813829,-1.0972963,-1.068605,-0.98651166,-0.94005819,-0.89435809,-0.89757401,-0.85826175,-0.84597179,-0.86105314,-0.8250073,-0.80973165,-0.82404699,-0.87465086,-0.9322661,-1.0089465,-1.0634417,-1.0049144,-0.91670728,-0.80771766,-0.72273132,-0.63780747,-0.53063334,-0.47259235,-0.41683813,-0.36268085,-0.31372872,-0.27558933,-0.23121069,-0.19511835,-0.16186957,-0.16745712,-0.2249164,-0.16273771,-0.11116101,-0.069839357,-0.031156146,-0.010785941,-0.01161001,-0.041288941,-0.071516445,-0.1022175,-0.15042969,-0.1958509,-0.24983645,-0.29428523,-0.34490787,-0.41598212,-0.46472754,-0.50233121,-0.57888742,-0.53552903,-0.61440862,-0.56983242,-0.63687637,-0.68744129,-0.72003537,-0.75954558,-0.76137424,-0.73058406,-0.6505063,-0.58645505,-0.50959599,-0.42863613,-0.39869902,-0.32789724,-0.23666378,-0.2089379,-0.15673671,-0.085415709,-0.029907,-0.026703203,0.047075664,0.12094091,0.19808809,0.27149709,0.34578558,0.41641423,0.49315144,0.56588953,0.63034358,0.65630554,0.65408615,0.69246338,0.76964045,0.85386904,0.93748308,1.0133309,1.0946321,1.1733682,1.2566326,1.3410647,1.4135255,1.4545519,1.4536366,1.4463633,1.4303534,1.4065945,1.3691454,1.317226,1.264457,1.185555,1.1319022,1.0951725,1.0560173,1.0003602,0.91474286,0.83725915,0.77609161,0.73522669,0.71144504,0.76822148,0.82321939,0.9120233,1.0079104,1.0731943,1.1380943,1.1968444,1.2270787,1.2320761,1.1524064,1.0891618,1.0301526,1.0193624,0.98188565,0.94837552,0.92432448,0.88027518,0.8260252,0.75267119,0.6623572,0.57493844,0.47678041,0.41319292,0.32522899,0.27555744,0.18420905,0.13618134,0.063098496,0.0050754992,-0.026885015,-0.069972919,-0.076782492,-0.089286374,-0.065116729,-0.018548241,0.045999419,0.093282857,0.11526496,0.15024801,0.18784063,0.24103457,0.27465077,0.29765764,0.33805432,0.38713558,0.40469957,0.44442092,0.48089909,0.49634453:2
3.0319906,2.892506,2.751432,2.610196,2.4692357,2.3287169,2.1884199,2.0509062,1.9763059,1.8268228,1.6766242,1.5339237,1.3938861,1.2559584,1.11391,0.97512464,0.83374778,0.69106756,0.567077,0.43907204,0.30113194,0.16141279,0.02069546,-0.12847697,-0.29367694,-0.40886324,-0.5737022,-0.69974662,-0.7663205,-0.77299015,-0.79927465,-0.82173331,-0.83185551,-0.84152673,-0.83671053,-0.80555366,-0.81737147,-0.74103582,-0.77344701,-0.72811758,-0.63862889,-0.62880061,-0.61479537,-0.56342077,-0.45590899,-0.38050794,-0.35303389,-0.2881866,-0.21611656,-0.18342411,-0.20081172,-0.1818637,-0.22022873,-0.28641721,-0.27419516,-0.25002024,-0.2206236,-0.22082729,-0.2800465,-0.34193832,-0.32678152,-0.27693967,-0.21501933,-0.16667157,-0.15407984,-0.2019627,-0.19231513,-0.23149285,-0.23276119,-0.17714224,-0.15525873,-0.18067951,-0.29909037,-0.45636805,-0.56779199,-0.73527437,-0.89613746,-0.9511498,-0.89607988,-0.86100576,-0.81793604,-0.76239302,-0.73520272,-0.64021303,-0.53058094,-0.49730299,-0.46356256,-0.47435762,-0.40566366,-0.35340498,-0.30980086,-0.22344713,-0.16437023,-0.10800684,-0.074360298,-0.10873227,-0.22715409,-0.21744008,-0.12864407,-0.037498866,0.05199114,0.049059549,0.13608503,0.22380025,0.3248949,0.32558508,0.24753659,0.34243894,0.44485912,0.5636894,0.59179976,0.66174889,0.76844709,0.8750969,0.99704702,1.0736495,1.1270563,1.1874983,1.1354362,1.0188225,0.8886755,0.78549831,0.65528901,0.54034336,0.40749671,0.28930523,0.1645123,0.034647751,-0.080547789,-0.20863724,-0.3408341,-0.45798949,-0.5863792,-0.61001382,-0.57233886,-0.68142694,-0.81575615,-0.93696061,-1.0602939,-1.1770435,-1.2939575,-1.430233,-1.5442199,-1.6754397,-1.7994199,-1.9290075,-2.0331438,-1.9270506,-1.8028815,-1.7086962,-1.5800862,-1.488899,-1.3577076,-1.2578041,-1.159242,-1.1080017,-1.1988298,-1.0539592,-0.94398454,-0.78851263,-0.67994836,-0.57315959,-0.51427613,-0.4260632,-0.26758983,-0.1982186,-0.038521188,0.072928533,0.09830858,0.0066723169,-0.1015349,-0.19854617,-0.27670336,-0.35879809,-0.34089002,-0.28503924,-0.1906855,-0.12923324,-0.055404135,0.059153892,0.15060789,0.16270974,0.28180865,0.39001176,0.48483384,0.61721643,0.71306064,0.70124646,0.6608357,0.75444188,0.89956182,1.0259466,1.1782488,1.3337065,1.4169229,1.4662302,1.5041993,1.5931591,1.7143274,1.8235895,1.9225202,2.0496504,2.1358941,2.2317597,2.3381684,2.3732121,2.2841047,2.1225652,1.9498576,1.8089472,1.653918,1.5034883,1.3585695,1.1889097,1.0169117,0.98157198,0.91435983,0.82211258,0.70647089,0.55794597,0.41837863,0.27353115,0.29443091,0.23241482,0.11927469,-0.037157032,-0.1489611,-0.16668903,-0.066771209,-0.05216949,0.037973142,0.1352003,0.23005483,0.29078519,0.25462108,0.11731662,-0.016651823,-0.10671225,-0.26692543,-0.37081167,-0.42674347,-0.56698179,-0.6948454,-0.75677668,-0.8879106,-0.96374069,-0.93103159,-1.0109052,-1.1371726,-1.2571048,-1.3281692,-1.43205,-1.5514455,-1.6821806,-1.7906393,-1.8919706,-2.0051784,-2.0973667,-2.196774,-2.1151228,-1.9597768,-1.8268797,-1.6924279,-1.5416394,-1.4121421,-1.2929358,-1.157077,-1.0115119,-0.85185082,-0.91802381,-0.80227137,-0.82892422,-0.72731751,-0.68112565,-0.59972564,-0.49356042,-0.36369065,-0.22888936,-0.085946964,-0.0085472102,0.096542127,0.15131812,0.24855805,0.36532193,0.5146258,0.67987628,0.81870669,0.91564817,1.0188925,1.1952716,1.3334993,1.4004392,1.3371172,1.2275372,1.1217692,1.0102706,0.91435366,0.80198925,0.73124385,0.62480202,0.53639125,0.45481473,0.37713157,0.27193059,0.28984213,0.27715844,0.19602817,0.099889547,0.024811896,-0.052383356,-0.13921789,-0.23292223,-0.30886097,-0.40618353,-0.39415666,-0.287067,-0.20905738,-0.2729393,-0.34079292,-0.41677958,-0.45348598,-0.51449864,-0.60172772,-0.62050686,-0.64452544,-0.72604024,-0.81283592,-0.88384862,-0.94737536,-0.92600904,-0.87054462,-0.91647682,-0.97055462,-1.0439525,-1.0454263,-1.101202,-1.1343254,-1.1731904,-1.1302284,-1.1205983,-1.0020938,-0.87152515,-0.7432913,-0.62615715,-0.49237068,-0.35270349,-0.21718697,-0.12040181,-0.10300205,-0.11135256,-0.064060363,-0.093439626,-0.035855284,-0.021040233,-0.063104675,-0.10853717,-0.15421655,-0.19210187,-0.16495924,-0.040077395,0.034209727,0.018116181,-0.014517005,-0.024750896,0.0089734458,0.014426073,-0.025968644,-0.10366438,-0.18231254,-0.26527303,-0.36349533,-0.42819595,-0.38337203,-0.23922898,-0.12746011,0.0174597,0.070387161,0.072704103,0.041420253,0.018203762,0.0086187874,-0.028797885,-0.041643245,-0.12792438,-0.23075084,-0.31701851,-0.40041643,-0.46948052,-0.51083396,-0.48979948,-0.53044146,-0.56415229,-0.57837598,-0.60917265,-0.64494369,-0.67911025,-0.69150113,-0.73547523,-0.74504344,-0.61701969,-0.48601474,-0.35269046,-0.21375788,-0.072678648,0.070823445,0.21294979,0.34198334,0.45852599,0.59960158,0.7502259,0.88211437,1.022542,1.1650935,1.3038977,1.4286563,1.5674752,1.7136082,1.8463103,1.9826098,2.1413135,2.290857,2.4313855,2.5688556,2.712725,2.8852121,2.9762164,3.0194743:3
2.4105214,2.3085656,2.1931407,2.0479418,1.9126965,1.7887113,1.6612956,1.5132488,1.3947765,1.2364435,1.1215249,0.96910752,0.86470141,0.75199429,0.78452661,0.83924033,0.77543496,0.63477958,0.49523835,0.37033148,0.28050996,0.13413302,2.5256627E-4,-0.071781879,-0.16177322,-0.19023715,-0.13636559,-0.039882864,0.042082851,0.04170142,-0.0089843681,-0.10513783,-0.20970589,-0.31768359,-0.38743617,-0.51844216,-0.63150536,-0.66452626,-0.7685655,-0.87466218,-0.97930996,-1.1127378,-1.2172216,-1.3137696,-1.3119892,-1.1842391,-1.201158,-1.2728436,-1.3780413,-1.4847307,-1.572051,-1.6498508,-1.6829429,-1.7111108,-1.684351,-1.6908529,-1.7912368,-1.8398303,-1.7749071,-1.6539683,-1.5289007,-1.427033,-1.3075193,-1.1794011,-1.0338238,-0.9417808,-0.81679394,-0.71757327,-0.58704836,-0.47968955,-0.45117122,-0.3657381,-0.23949549,-0.13173247,-0.028195299,0.084666551,0.15776279,0.27248709,0.38464288,0.50129187,0.60213369,0.71362382,0.82064259,0.92632422,1.0495318,1.1436325,1.1349071,1.0541904,0.98315875,0.89610949,0.81431131,0.74234585,0.65930656,0.61739601,0.55304988,0.48478321,0.41374756,0.36605262,0.38469969,0.3456108,0.26815953,0.1920832,0.13180218,0.059767937,0.036721755,0.0071627841,-0.073818291,-0.12896079,-0.17792469,-0.2420948,-0.3180925,-0.39020563,-0.30804039,-0.20068066,-0.13119503,-0.15893809,-0.20153605,-0.23820795,-0.28950572,-0.31616896,-0.33504338,-0.32358819,-0.3717858,-0.41205833,-0.40404664,-0.48895309,-0.47850982,-0.47397526,-0.5529541,-0.5905428,-0.65107444,-0.65072741,-0.70621206,-0.7115328,-0.74658036,-0.81397036,-0.81658277,-0.85577639,-0.88935574,-0.87850335,-0.86664589,-0.74558142,-0.65410588,-0.53269185,-0.42009218,-0.31733556,-0.18893483,-0.13710198,-0.17964928,-0.22721311,-0.24185384,-0.23562467,-0.22519452,-0.24378357,-0.27307814,-0.33565721,-0.33354507,-0.34955787,-0.33975974,-0.22231852,-0.19898535,-0.22616577,-0.24872854,-0.31729222,-0.37619366,-0.38490749,-0.43486483,-0.45394561,-0.38701243,-0.3085423,-0.32120131,-0.3644809,-0.41005644,-0.45815841,-0.51449341,-0.56579082,-0.60846634,-0.65790574,-0.69958334,-0.73599141,-0.76905455,-0.79330818,-0.80466841,-0.79545683,-0.70064496,-0.57974092,-0.45589796,-0.33951288,-0.21748835,-0.1014474,0.02116271,0.12814237,0.24309023,0.40593696,0.48914041,0.61172424,0.73559218,0.86387768,0.99160994,1.1297608,1.2582519,1.3698219,1.5069678,1.6289278,1.7499866,1.8811044,2.023346,2.1517838,2.2725008,2.4277957,2.5553286,2.7035151,2.812597,2.8953594,2.9328087,2.9011421,2.861365,2.7483606,2.6291278,2.5040086,2.3820169,2.2604464,2.1182706,1.9833193,1.8556397,1.7331033,1.6120442,1.491611,1.36812,1.2423413,1.1240734,0.99858072,0.87019833,0.73065051,0.59787724,0.47035622,0.34841604,0.2296046,0.1071769,-0.020270356,-0.14132036,-0.2663972,-0.38773618,-0.50936069,-0.62671732,-0.70272818,-0.73850718,-0.70784322,-0.66410739,-0.57125369,-0.5434697,-0.48360761,-0.40735441,-0.3343143,-0.40471922,-0.3494585,-0.27197506,-0.19934761,-0.1559314,-0.11671364,-0.091412817,-0.066266484,-0.087525748,0.031667978,0.11150796,0.16674404,0.13966811,0.014978307,-0.071435418,-0.033273356,-0.011925721,0.024795343,0.069130124,0.013620144,0.02594535,0.040983504,0.05086802,-0.023896008,-0.11241704,-0.096414521,-0.077480928,-0.047003695,-0.061179549,-0.15104513,-0.1598308,-0.16693424,-0.18000289,-0.26793653,-0.37684229,-0.45227977,-0.59300914,-0.71692398,-0.75031205,-0.71427402,-0.67924716,-0.64965624,-0.60780728,-0.56426501,-0.52026302,-0.47507274,-0.43146279,-0.41914865,-0.5114017,-0.56679201,-0.5188386,-0.47463701,-0.42604309,-0.40945387,-0.46885373,-0.43802211,-0.40168067,-0.37101521,-0.37484802,-0.49349533,-0.57244846,-0.51862398,-0.45659343,-0.40279811,-0.33769174,-0.26324633,-0.19525697,-0.21277954,-0.12972339,-0.07479332,0.0058152342,0.07937396,0.1144534,0.056450397,0.092215616,0.16163486,0.24470802,0.31204373,0.3745116,0.35675959,0.44834187,0.52470722,0.58607017,0.63867724,0.73407239,0.80341797,0.82619387,0.7361979,0.62597326,0.51167767,0.40649393,0.29913245,0.17257296,0.06089161,-0.048490769,-0.15421542,-0.26062223,-0.37865978,-0.48858553,-0.59307199,-0.65022651,-0.70422703,-0.81644943,-0.92201067,-1.0364052,-1.1386871,-1.2517575,-1.3768821,-1.4772247,-1.5946537,-1.7231954,-1.8185629,-1.8748618,-1.844611,-1.7931201,-1.7402997,-1.6818781,-1.6100725,-1.5632701,-1.49689,-1.4275608,-1.3543762,-1.3072381,-1.2574387,-1.3242171,-1.4370842,-1.4286968,-1.374152,-1.2919459,-1.1982052,-1.0980265,-0.966378,-0.9154428,-0.80771519,-0.73921677,-0.64005556,-0.53531435,-0.43109417,-0.32373712,-0.22912734,-0.13315759,-0.059424757,-0.055241494,-0.15003441,-0.19013284,-0.16848191,-0.080825473,0.027531449,0.10871553,0.21740197,0.30586752,0.40021126,0.49004562,0.59379503,0.6992107,0.81479105,0.89483534,0.9389831,1.0616253,1.1861587,1.3010486,1.3848812,1.4748786,1.5933399,1.706339,1.793322,1.8820929,1.9849534,2.0651716,2.1559865,2.2524382,2.3479625,2.4216773:3
2.3541328,2.2420047,2.1296136,2.0169883,1.9331017,1.8271689,1.7137604,1.6305671,1.523118,1.4108572,1.2978154,1.2217451,1.1191102,1.0387752,0.98422347,0.9932481,1.0109539,1.0343806,1.0676003,1.096069,1.108143,1.1201933,1.1096349,1.103671,1.0908584,1.0730687,1.0821711,1.0662572,1.05182,1.0436356,1.0153668,0.97108606,0.96322803,0.90729384,0.81156912,0.74328349,0.67337515,0.58750241,0.52726885,0.43782987,0.35566203,0.30791232,0.26196478,0.21056038,0.17493297,0.13215085,0.10285281,0.071623952,0.040402423,0.0096922076,2.2127366E-5,5.3225507E-4,-0.0041126952,-0.017438851,-0.016157584,-0.016120765,-0.016936095,7.8933604E-4,0.0029213794,0.027019147,0.044841583,0.057673687,0.077946205,0.064618063,0.0058683241,-0.048980413,-0.10583765,-0.16459489,-0.23200127,-0.30748262,-0.36232856,-0.45627077,-0.52014066,-0.60031819,-0.69204218,-0.76768604,-0.85512552,-0.92669417,-0.99816578,-1.0637219,-1.1193518,-1.1589858,-1.1850885,-1.1998011,-1.2011029,-1.1974807,-1.1860167,-1.1674796,-1.1453558,-1.1347109,-1.1122944,-1.0933716,-1.0572484,-1.0212011,-0.98565768,-0.95244279,-0.91818977,-0.87202358,-0.82539196,-0.77115572,-0.71271272,-0.65772949,-0.58086998,-0.51317866,-0.45193288,-0.39180919,-0.31991796,-0.25972598,-0.20392328,-0.23045248,-0.1677984,-0.079089092,-0.020129041,0.0070928591,-0.072363742,-0.15594464,-0.24808001,-0.33522934,-0.42087976,-0.50360312,-0.60425273,-0.68578654,-0.75664256,-0.84086904,-0.91896979,-1.0083585,-1.0921853,-1.1784596,-1.2645998,-1.3485475,-1.4318523,-1.5157239,-1.5937461,-1.6836368,-1.7761348,-1.870649,-1.9100471,-1.9230699,-1.9218649,-1.8895252,-1.8357857,-1.7563646,-1.6666857,-1.5637619,-1.4635235,-1.363724,-1.2633245,-1.1609877,-1.0557107,-0.96130657,-0.87977734,-0.82141494,-0.7655328,-0.66009225,-0.55203426,-0.47990259,-0.37168669,-0.26291865,-0.15350839,-0.043240175,0.066940832,0.17627609,0.28661081,0.39712569,0.47316231,0.58471088,0.69673448,0.80934006,0.89363855,0.83784928,0.80145834,0.83588833,0.75444701,0.67876206,0.61368704,0.54304027,0.47125855,0.40790541,0.33401751,0.30511389,0.3579383,0.43600738,0.51711283,0.62493092,0.73770178,0.85035602,0.92682504,1.0395897,1.1162327,1.2290935,1.341989,1.4342213,1.5316597,1.6285064,1.5612305,1.4815477,1.4435413,1.4789814,1.4046029,1.3701304,1.4324906,1.5385841,1.6243576,1.7379586,1.8514939,1.9637486,2.008715,1.954363,1.8903548,1.7783584,1.6668607,1.5571715,1.5062506,1.5584822,1.525051,1.4132442,1.3012575,1.188307,1.0755087,0.99898298,0.88676393,0.77354303,0.66222387,0.57608736,0.53077663,0.52739051,0.57708356,0.64420777,0.70862658,0.79064192,0.84489747,0.90277301,0.87574174,0.79423034,0.71089735,0.62164291,0.53632473,0.45693886,0.34283986,0.26273745,0.15339709,0.07587819,-0.033864616,-0.1448844,-0.25224394,-0.32726823,-0.4341918,-0.54033376,-0.64515727,-0.7503236,-0.84424148,-0.91009379,-0.98420643,-1.0659937,-1.143767,-1.2002751,-1.2361277,-1.2433238,-1.2140277,-1.1507415,-1.0817865,-0.98806926,-0.91244454,-0.84015227,-0.75874161,-0.6788851,-0.59024451,-0.50251056,-0.42568151,-0.34681943,-0.29750071,-0.22308927,-0.13004359,-0.067786593,0.016585298,0.058872723,0.13195485,0.2179283,0.3159089,0.2845652,0.19680365,0.13001932,0.035495532,-0.023633625,-0.11052594,-0.18622855,-0.25992871,-0.33944478,-0.40974065,-0.47215742,-0.41493484,-0.43834032,-0.52699906,-0.59298906,-0.67097392,-0.7410479,-0.81158118,-0.88295673,-0.94916922,-1.0177675,-1.0932483,-1.1488593,-1.2146877,-1.2791145,-1.338266,-1.3994813,-1.4634626,-1.5135028,-1.5588509,-1.6222802,-1.6675415,-1.7168749,-1.7518445,-1.7935689,-1.8257742,-1.8614336,-1.8796325,-1.8885265,-1.888865,-1.8679959,-1.8180585,-1.7469085,-1.6684125,-1.5929898,-1.5167755,-1.4421139,-1.3451106,-1.2650258,-1.1797528,-1.0844502,-0.99589906,-0.89847093,-0.8024981,-0.70651122,-0.65035444,-0.58776505,-0.49352329,-0.3902035,-0.30477644,-0.20010733,-0.098436822,0.0087608815,0.058726715,1.7065652E-4,-0.058275929,-0.11734268,-0.17373014,-0.22419776,-0.2554182,-0.17774583,-0.19547649,-0.23159239,-0.27636295,-0.32349836,-0.36560135,-0.40002883,-0.42349036,-0.44116368,-0.45823953,-0.46389082,-0.47457824,-0.47967311,-0.49288538,-0.50243986,-0.49634262,-0.47716475,-0.46008605,-0.43694477,-0.41809393,-0.37760697,-0.33286406,-0.27975092,-0.18416092,-0.091551486,-0.017187125,0.050716669,0.10965918,0.17495008,0.22437043,0.28599492,0.3332193,0.35265151,0.35656062,0.36331096,0.35685384,0.36522564,0.36500309,0.38699386,0.40542913,0.42561525,0.44886736,0.46953634,0.4934227,0.5175117,0.54063192,0.57734152,0.61089447,0.63612775,0.66550144,0.69603449,0.72664071,0.76037429,0.79014122,0.81294064,0.84156785,0.86756728,0.89475858,0.91243097,0.92358632,0.93217053,0.94902527,0.99457616,1.04926,1.1246598,1.191038,1.267798,1.3604027,1.4597442,1.5399495,1.651314,1.7646492,1.8512889,1.9551293,2.0679348,2.1802619,2.2921866,2.3541287:4
2.4496199,2.3563592,2.2801448,2.1899006,2.0990087,2.0068212,1.9154594,1.8246666,1.7341591,1.6495163,1.5531995,1.465441,1.3493393,1.2614244,1.1667705,1.0664277,0.99539256,0.93786421,0.86725833,0.80486844,0.74509691,0.68691118,0.63543004,0.58438425,0.55832503,0.51619174,0.49399348,0.4765474,0.46061029,0.42966478,0.39727732,0.36626305,0.35472477,0.35736794,0.33723427,0.34074558,0.33068072,0.3010878,0.25351137,0.20514521,0.1469678,0.067782514,-0.015243433,-0.10342873,-0.18496027,-0.27002609,-0.34810379,-0.43323085,-0.51276709,-0.56417679,-0.58323032,-0.58440964,-0.58270058,-0.58350699,-0.57854522,-0.5672114,-0.54964057,-0.53356568,-0.51423914,-0.50214123,-0.48021559,-0.44601307,-0.4110449,-0.37240352,-0.33451444,-0.29530487,-0.2992246,-0.3183086,-0.26918439,-0.21466264,-0.15930444,-0.099228112,-0.033303695,0.04878854,0.15261553,0.15928006,0.046286402,-0.044239224,-0.1284494,-0.21065689,-0.29137175,-0.36403785,-0.44230921,-0.5260571,-0.59349208,-0.65958258,-0.73410676,-0.80799082,-0.86906801,-0.94411084,-1.0056033,-1.0817948,-1.1715444,-1.2592618,-1.3626777,-1.4771733,-1.579623,-1.6703547,-1.7484359,-1.80605,-1.8237324,-1.8191095,-1.8074769,-1.7878369,-1.7494013,-1.7074198,-1.6568783,-1.6009318,-1.5352181,-1.4723598,-1.4048244,-1.3345464,-1.2687327,-1.1980853,-1.1177532,-1.0468757,-0.9757184,-0.89777913,-0.819509,-0.77649386,-0.86192562,-0.87102468,-0.82202413,-0.74017406,-0.65596935,-0.57812133,-0.49395203,-0.40533105,-0.3495136,-0.26402922,-0.17780869,-0.099845449,-0.18737442,-0.269118,-0.34911303,-0.43183598,-0.51758681,-0.5984773,-0.60453308,-0.60608097,-0.66605509,-0.75015131,-0.82812418,-0.90717492,-0.98408098,-1.0632327,-1.1308705,-1.1938357,-1.2509741,-1.2889224,-1.2764222,-1.2418029,-1.1723907,-1.075952,-0.98759147,-0.8903195,-0.79420421,-0.67789479,-0.561729,-0.45387659,-0.36141709,-0.25863915,-0.16825229,-0.066533135,0.036456753,0.139661,0.22884221,0.28279451,0.27920629,0.37346616,0.47663949,0.57925204,0.68232814,0.77493744,0.83958022,0.77808923,0.70041915,0.62407496,0.5511273,0.48234928,0.42932159,0.39434103,0.42106306,0.49026784,0.56195501,0.64572525,0.7405245,0.83376145,0.93134593,1.0348184,1.1247883,1.2099761,1.3286678,1.4308276,1.4948224,1.4632271,1.4739078,1.5607938,1.679993,1.7784589,1.8829179,1.9652034,2.0288017,2.0932132,2.0474474,1.9977649,1.9489042,1.8521676,1.7658235,1.6715694,1.6055032,1.6066836,1.5758418,1.4581725,1.3993121,1.3016646,1.1830098,1.0657346,0.96430057,0.84654795,0.72900275,0.62618233,0.55927583,0.53180698,0.52707979,0.55924078,0.61524297,0.68707883,0.75580424,0.82624574,0.90672917,0.96651387,0.87811605,0.78513468,0.69641833,0.61227803,0.50386437,0.50894114,0.45507357,0.35812499,0.26110964,0.17155225,0.07154854,-0.019842573,-0.11741527,-0.22830654,-0.31549033,-0.41758812,-0.50728929,-0.60913236,-0.69617002,-0.7969661,-0.89108476,-0.99646394,-1.0585903,-1.1038903,-1.1185177,-1.0925686,-1.0493935,-0.98479291,-0.90255136,-0.83223173,-0.75573652,-0.66922011,-0.58520861,-0.49857787,-0.41738155,-0.3309258,-0.25966868,-0.226384,-0.1412692,-0.057152287,0.026750004,0.10500241,0.18892068,0.27224068,0.21800361,0.13726899,0.062022576,-0.019379602,-0.092310917,-0.11729457,-0.19780637,-0.27740639,-0.34952195,-0.42508081,-0.50004192,-0.56820666,-0.62573024,-0.61279674,-0.54932898,-0.4923553,-0.57920141,-0.65970282,-0.73916845,-0.82067746,-0.89425246,-0.96730559,-1.0409724,-1.1123091,-1.1804559,-1.251949,-1.3163551,-1.3787718,-1.4416355,-1.5044421,-1.5620171,-1.6118911,-1.6713664,-1.713085,-1.7470725,-1.7756106,-1.8051577,-1.8265337,-1.837104,-1.8374931,-1.8171591,-1.777304,-1.7271074,-1.6531377,-1.5664338,-1.4843348,-1.4056004,-1.3108988,-1.2282476,-1.1385001,-1.0479194,-0.95052714,-0.85218212,-0.77280079,-0.6925506,-0.61011775,-0.53974163,-0.47536812,-0.37030784,-0.28773367,-0.18290821,-0.09243692,0.012381837,0.12033761,0.046967156,-0.021140503,-0.095054239,-0.14863326,-0.21284665,-0.25092018,-0.27598091,-0.28249478,-0.21060972,-0.2347457,-0.26069864,-0.2805758,-0.30539684,-0.32851344,-0.3507238,-0.36268686,-0.36981329,-0.37966333,-0.38863492,-0.40395704,-0.41606793,-0.40613909,-0.39639529,-0.38344277,-0.3562007,-0.30726745,-0.2705152,-0.22051599,-0.16642478,-0.090735058,0.015835605,0.098380284,0.17491479,0.24549613,0.31183873,0.37509756,0.43469261,0.49543221,0.55426666,0.61314967,0.64279126,0.62771861,0.60644215,0.59820288,0.6