/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.path;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.executor.fill.LastPointReader;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.SeriesReader;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialPath
extends Path
implements Comparable<Path>,
Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(PartialPath.class);
    protected String[] nodes;

    public PartialPath() {
    }

    public PartialPath(String path) throws IllegalPathException {
        this.nodes = MetaUtils.splitPathToDetachedPath(path);
        this.fullPath = path;
    }

    public PartialPath(String device, String measurement) throws IllegalPathException {
        this.fullPath = device + "." + measurement;
        this.nodes = MetaUtils.splitPathToDetachedPath(this.fullPath);
    }

    public PartialPath(String[] partialNodes) {
        this.nodes = partialNodes;
    }

    public PartialPath(String path, boolean needSplit) {
        super(path, needSplit);
    }

    public PartialPath concatPath(PartialPath partialPath) {
        int len = this.nodes.length;
        String[] newNodes = Arrays.copyOf(this.nodes, this.nodes.length + partialPath.nodes.length);
        System.arraycopy(partialPath.nodes, 0, newNodes, len, partialPath.nodes.length);
        return new PartialPath(newNodes);
    }

    public void concatPath(String[] otherNodes) {
        int len = this.nodes.length;
        this.nodes = Arrays.copyOf(this.nodes, this.nodes.length + otherNodes.length);
        System.arraycopy(otherNodes, 0, this.nodes, len, otherNodes.length);
        this.fullPath = String.join((CharSequence)".", this.nodes);
    }

    public PartialPath concatNode(String node) {
        String[] newPathNodes = Arrays.copyOf(this.nodes, this.nodes.length + 1);
        newPathNodes[newPathNodes.length - 1] = node;
        return new PartialPath(newPathNodes);
    }

    public String[] getNodes() {
        return this.nodes;
    }

    public int getNodeLength() {
        return this.nodes.length;
    }

    public String getTailNode() {
        if (this.nodes.length <= 0) {
            return "";
        }
        return this.nodes[this.nodes.length - 1];
    }

    public List<PartialPath> alterPrefixPath(PartialPath prefix) {
        Validate.notNull((Object)prefix);
        for (String node : prefix.getNodes()) {
            if (!"**".equals(node) && !"*".equals(node)) continue;
            throw new IllegalArgumentException("Wildcards are not allowed in the prefix path: " + prefix.getFullPath());
        }
        ArrayList<List<String>> results = new ArrayList<List<String>>();
        this.alterPrefixPathInternal(Arrays.asList(prefix.getNodes()), Arrays.asList(this.nodes), new ArrayList<String>(), results);
        return results.stream().map(r -> new PartialPath(r.toArray(new String[0]))).collect(Collectors.toList());
    }

    private boolean alterPrefixPathInternal(List<String> prefix, List<String> path, List<String> current, List<List<String>> results) {
        if (prefix.isEmpty()) {
            current.addAll(path);
            results.add(current);
            return !path.isEmpty() && "**".equals(path.get(0));
        }
        if (path.isEmpty()) {
            return false;
        }
        if ("**".equals(path.get(0))) {
            for (int j = 1; j <= prefix.size(); ++j) {
                ArrayList<String> copy = new ArrayList<String>(current);
                copy.addAll(prefix.subList(0, j));
                if (!this.alterPrefixPathInternal(prefix.subList(j, prefix.size()), path.subList(1, path.size()), copy, results)) continue;
                return true;
            }
            ArrayList<String> copy = new ArrayList<String>(current);
            copy.addAll(prefix);
            return this.alterPrefixPathInternal(Collections.emptyList(), path.subList(0, path.size()), copy, results);
        }
        if ("*".equals(path.get(0)) || prefix.get(0).equals(path.get(0))) {
            current.add(prefix.get(0));
            return this.alterPrefixPathInternal(prefix.subList(1, prefix.size()), path.subList(1, path.size()), current, results);
        }
        return false;
    }

    public boolean matchFullPath(PartialPath rPath) {
        return this.matchFullPath(rPath.getNodes(), 0, 0, false);
    }

    private boolean matchFullPath(String[] pathNodes, int pathIndex, int patternIndex, boolean multiLevelWild) {
        if (pathIndex == pathNodes.length && patternIndex == this.nodes.length) {
            return true;
        }
        if (patternIndex == this.nodes.length && multiLevelWild) {
            return this.matchFullPath(pathNodes, pathIndex + 1, patternIndex, true);
        }
        if (pathIndex >= pathNodes.length || patternIndex >= this.nodes.length) {
            return false;
        }
        String pathNode = pathNodes[pathIndex];
        String patternNode = this.nodes[patternIndex];
        boolean isMatch = false;
        if (patternNode.equals("**")) {
            isMatch = this.matchFullPath(pathNodes, pathIndex + 1, patternIndex + 1, true);
        } else {
            if (patternNode.contains("*")) {
                if (Pattern.matches(patternNode.replace("*", ".*"), pathNode)) {
                    isMatch = this.matchFullPath(pathNodes, pathIndex + 1, patternIndex + 1, false);
                }
            } else if (patternNode.equals(pathNode)) {
                isMatch = this.matchFullPath(pathNodes, pathIndex + 1, patternIndex + 1, false);
            }
            if (!isMatch && multiLevelWild) {
                isMatch = this.matchFullPath(pathNodes, pathIndex + 1, patternIndex, true);
            }
        }
        return isMatch;
    }

    public boolean matchPrefixPath(PartialPath rPath) {
        String[] rNodes = rPath.getNodes();
        if (this.nodes.length > rNodes.length) {
            return false;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i].equals("**")) {
                return true;
            }
            if (this.nodes[i].equals("*") || this.nodes[i].equals(rNodes[i])) continue;
            return false;
        }
        return true;
    }

    public String getFullPath() {
        if (this.fullPath == null) {
            StringBuilder s = new StringBuilder(this.nodes[0]);
            for (int i = 1; i < this.nodes.length; ++i) {
                s.append(".").append(this.nodes[i]);
            }
            this.fullPath = s.toString();
        }
        return this.fullPath;
    }

    public PartialPath copy() {
        PartialPath result = new PartialPath();
        result.nodes = this.nodes;
        result.fullPath = this.fullPath;
        result.device = this.device;
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PartialPath)) {
            return false;
        }
        String[] otherNodes = ((PartialPath)obj).getNodes();
        if (this.nodes.length != otherNodes.length) {
            return false;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i].equals(otherNodes[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(String obj) {
        return this.getFullPath().equals(obj);
    }

    public int hashCode() {
        return this.getFullPath().hashCode();
    }

    public String getMeasurement() {
        return this.nodes[this.nodes.length - 1];
    }

    public String getFirstNode() {
        return this.nodes[0];
    }

    public String getDevice() {
        if (this.device != null) {
            return this.device;
        }
        if (this.nodes.length == 1) {
            return "";
        }
        StringBuilder s = new StringBuilder(this.nodes[0]);
        for (int i = 1; i < this.nodes.length - 1; ++i) {
            s.append(".");
            s.append(this.nodes[i]);
        }
        this.device = s.toString();
        return this.device;
    }

    public String getMeasurementAlias() {
        throw new RuntimeException("Only MeasurementPath support alias");
    }

    public void setMeasurementAlias(String measurementAlias) {
        throw new RuntimeException("Only MeasurementPath support alias");
    }

    public boolean isMeasurementAliasExists() {
        return false;
    }

    public String getFullPathWithAlias() {
        throw new RuntimeException("Only MeasurementPath support alias");
    }

    public IMeasurementSchema getMeasurementSchema() throws MetadataException {
        throw new MetadataException("This path doesn't represent a measurement");
    }

    public TSDataType getSeriesType() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This path doesn't represent a measurement");
    }

    @Override
    public int compareTo(Path path) {
        PartialPath partialPath = (PartialPath)path;
        return this.getFullPath().compareTo(partialPath.getFullPath());
    }

    public boolean startsWith(String[] otherNodes) {
        for (int i = 0; i < otherNodes.length; ++i) {
            if (this.nodes[i].equals(otherNodes[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getFullPath();
    }

    public PartialPath getDevicePath() {
        return new PartialPath(Arrays.copyOf(this.nodes, this.nodes.length - 1));
    }

    public Path toTSFilePath() {
        return new Path(this.getDevice(), this.getMeasurement());
    }

    public static List<String> toStringList(List<PartialPath> pathList) {
        ArrayList<String> ret = new ArrayList<String>();
        for (PartialPath path : pathList) {
            ret.add(path.getFullPath());
        }
        return ret;
    }

    public static List<PartialPath> fromStringList(List<String> pathList) {
        if (pathList == null || pathList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PartialPath> ret = new ArrayList<PartialPath>();
        for (String s : pathList) {
            try {
                ret.add(new PartialPath(s));
            }
            catch (IllegalPathException e) {
                logger.warn("Encountered an illegal path {}", (Object)s);
            }
        }
        return ret;
    }

    public LastPointReader createLastPointReader(TSDataType dataType, Set<String> deviceMeasurements, QueryContext context, QueryDataSource dataSource, long queryTime, Filter timeFilter) {
        throw new UnsupportedOperationException("Should call exact sub class!");
    }

    public SeriesReader createSeriesReader(Set<String> allSensors, TSDataType dataType, QueryContext context, QueryDataSource dataSource, Filter timeFilter, Filter valueFilter, TsFileFilter fileFilter, boolean ascending) {
        throw new UnsupportedOperationException("Should call exact sub class!");
    }

    public SeriesReader createSeriesReader(Set<String> allSensors, TSDataType dataType, QueryContext context, List<TsFileResource> seqFileResource, List<TsFileResource> unseqFileResource, Filter timeFilter, Filter valueFilter, boolean ascending) {
        throw new UnsupportedOperationException("Should call exact sub class!");
    }

    public TsFileResource createTsFileResource(List<ReadOnlyMemChunk> readOnlyMemChunk, List<IChunkMetadata> chunkMetadataList, TsFileResource originTsFileResource) throws IOException {
        throw new UnsupportedOperationException("Should call exact sub class!");
    }

    public ITimeSeriesMetadata generateTimeSeriesMetadata(List<ReadOnlyMemChunk> readOnlyMemChunk, List<IChunkMetadata> chunkMetadataList) throws IOException {
        throw new UnsupportedOperationException("Should call exact sub class!");
    }

    public ReadOnlyMemChunk getReadOnlyMemChunkFromMemTable(IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable, long timeLowerBound) throws QueryProcessException, IOException {
        throw new UnsupportedOperationException("Should call exact sub class!");
    }

    protected List<Modification> getModificationsForMemtable(IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable) {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        boolean foundMemtable = false;
        for (Pair<Modification, IMemTable> entry : modsToMemtable) {
            if (!foundMemtable && !((IMemTable)entry.right).equals(memTable)) continue;
            modifications.add((Modification)entry.left);
            foundMemtable = true;
        }
        return modifications;
    }

    public PartialPath clone() {
        return new PartialPath((String[])this.getNodes().clone());
    }

    public List<IChunkMetadata> getVisibleMetadataListFromWriter(RestorableTsFileIOWriter writer, TsFileResource tsFileResource, QueryContext context) {
        throw new UnsupportedOperationException("Should call exact sub class!");
    }
}

