/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.utils.nodetool.function;

import com.google.common.base.Throwables;
import io.airlift.airline.Option;
import io.airlift.airline.OptionType;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.utils.nodetool.ClusterMonitor;
import org.apache.iotdb.cluster.utils.nodetool.ClusterMonitorMBean;
import org.apache.iotdb.cluster.utils.nodetool.Printer;

public abstract class NodeToolCmd
implements Runnable {
    @Option(type=OptionType.GLOBAL, name={"-h", "--host"}, description="Node hostname or ip address")
    private String host = "127.0.0.1";
    @Option(type=OptionType.GLOBAL, name={"-p", "--port"}, description="Remote jmx agent port number")
    private String port = "31999";
    @Option(type=OptionType.GLOBAL, name={"-u", "--user"}, description="The username to access the remote jmx")
    private String user = "root";
    @Option(type=OptionType.GLOBAL, name={"-pw", "--password"}, description="The password to access the remote jmx")
    private String password = "passw!d";
    private static final String JMX_URL_FORMAT = "service:jmx:rmi:///jndi/rmi://%s:%s/jmxrmi";
    public static final String BUILDING_CLUSTER_INFO = "The cluster is being created.";
    public static final String META_LEADER_UNKNOWN_INFO = "Meta group leader is unknown, please try again later.";
    static final String FAIL_TO_GET_ALL_SLOT_STATUS_INFO = "Fail to get all slot status, please check node status and try again later.";

    @Override
    public void run() {
        try {
            MBeanServerConnection mbsc = this.connect();
            ObjectName name = new ObjectName(ClusterMonitor.INSTANCE.getMbeanName());
            ClusterMonitorMBean clusterMonitorProxy = JMX.newMBeanProxy(mbsc, name, ClusterMonitorMBean.class);
            this.execute(clusterMonitorProxy);
        }
        catch (MalformedObjectNameException e) {
            Printer.errPrintln(e.getMessage());
        }
    }

    protected abstract void execute(ClusterMonitorMBean var1);

    private MBeanServerConnection connect() {
        MBeanServerConnection mbsc = null;
        try {
            String jmxURL = String.format(JMX_URL_FORMAT, this.host, this.port);
            JMXServiceURL serviceURL = new JMXServiceURL(jmxURL);
            Map<String, String[]> environment = Collections.singletonMap("jmx.remote.credentials", new String[]{this.user, this.password});
            JMXConnector connector = JMXConnectorFactory.connect(serviceURL, environment);
            mbsc = connector.getMBeanServerConnection();
        }
        catch (IOException e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            Printer.errPrintln(String.format("nodetool: Failed to connect to '%s:%s' - %s: '%s'.", this.host, this.port, rootCause.getClass().getSimpleName(), rootCause.getMessage()));
            System.exit(1);
        }
        return mbsc;
    }

    public static String nodeCharacterToString(Node node, NodeCharacter character) {
        return String.format("%s (%s)", new Object[]{NodeToolCmd.nodeToString(node), character});
    }

    public static String nodeToString(Node node) {
        return String.format("%s:%d:%d:%d", node.getInternalIp(), node.getMetaPort(), node.getDataPort(), node.getClientPort());
    }

    public static String redirectToQueryMetaLeader(Node node) {
        return String.format("Please redirect to query meta group leader %s", NodeToolCmd.nodeToString(node));
    }

    public static String partitionGroupToString(PartitionGroup group) {
        StringBuilder stringBuilder = new StringBuilder("[");
        if (!group.isEmpty()) {
            stringBuilder.append(NodeToolCmd.nodeToString((Node)group.get(0)));
        }
        for (int i = 1; i < group.size(); ++i) {
            stringBuilder.append(", ").append(NodeToolCmd.nodeToString((Node)group.get(i)));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

