/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.handlers.caller;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCatchUpInBatchHandler
implements AsyncMethodCallback<Long> {
    private static final Logger logger = LoggerFactory.getLogger(LogCatchUpInBatchHandler.class);
    private Node follower;
    private List<ByteBuffer> logs;
    private AtomicBoolean appendSucceed;
    private String memberName;
    private RaftMember raftMember;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(Long response) {
        logger.debug("{}: Received a catch-up result size of {} from {}", new Object[]{this.memberName, this.logs.size(), this.follower});
        long resp = response;
        if (resp == -1L) {
            AtomicBoolean atomicBoolean = this.appendSucceed;
            synchronized (atomicBoolean) {
                this.appendSucceed.set(true);
                this.appendSucceed.notifyAll();
            }
            logger.debug("{}: Succeeded to send logs, size is {}", (Object)this.memberName, (Object)this.logs.size());
        } else {
            if (resp == -2L) {
                logger.error("{}: Log mismatch occurred when sending logs, whose size is {}", (Object)this.memberName, (Object)this.logs.size());
                AtomicBoolean atomicBoolean = this.appendSucceed;
                synchronized (atomicBoolean) {
                    this.appendSucceed.notifyAll();
                }
            }
            logger.debug("{}: Received a rejection because term is updated to {} when sending {} logs", new Object[]{this.memberName, resp, this.logs.size()});
            this.raftMember.stepDown(resp, false);
            AtomicBoolean atomicBoolean = this.appendSucceed;
            synchronized (atomicBoolean) {
                this.appendSucceed.notifyAll();
            }
            logger.warn("{}: Catch-up with {} logs aborted because leadership is lost", (Object)this.logs.size(), (Object)this.memberName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Exception exception) {
        AtomicBoolean atomicBoolean = this.appendSucceed;
        synchronized (atomicBoolean) {
            this.appendSucceed.notifyAll();
        }
        logger.warn("{}: Catch-up fails when sending log, whose size is {}", new Object[]{this.memberName, this.logs.size(), exception});
    }

    public void setAppendSucceed(AtomicBoolean appendSucceed) {
        this.appendSucceed = appendSucceed;
    }

    public void setRaftMember(RaftMember raftMember) {
        this.raftMember = raftMember;
        this.memberName = raftMember.getName();
    }

    public void setFollower(Node follower) {
        this.follower = follower;
    }

    public void setLogs(List<ByteBuffer> logs) {
        this.logs = logs;
    }
}

