/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.partition;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.cluster.partition.PartitionGroup;

public class NodeRemovalResult {
    private final List<PartitionGroup> removedGroupList = new ArrayList<PartitionGroup>();

    public PartitionGroup getRemovedGroup(int raftId) {
        for (PartitionGroup group : this.removedGroupList) {
            if (group.getRaftId() != raftId) continue;
            return group;
        }
        return null;
    }

    public void addRemovedGroup(PartitionGroup group) {
        this.removedGroupList.add(group);
    }

    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.removedGroupList.size());
        for (PartitionGroup group : this.removedGroupList) {
            group.serialize(dataOutputStream);
        }
    }

    public void deserialize(ByteBuffer buffer) {
        int removedGroupListSize = buffer.getInt();
        for (int i = 0; i < removedGroupListSize; ++i) {
            PartitionGroup group = new PartitionGroup();
            group.deserialize(buffer);
            this.removedGroupList.add(group);
        }
    }
}

