/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi;

import com.squareup.moshi.JsonQualifier;
import com.squareup.moshi.internal.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
public final class Types {
    private Types() {
    }

    @Nullable
    public static Set<? extends Annotation> nextAnnotations(Set<? extends Annotation> annotations, Class<? extends Annotation> jsonQualifier) {
        if (!jsonQualifier.isAnnotationPresent(JsonQualifier.class)) {
            throw new IllegalArgumentException(jsonQualifier + " is not a JsonQualifier.");
        }
        if (annotations.isEmpty()) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!jsonQualifier.equals(annotation.annotationType())) continue;
            LinkedHashSet<? extends Annotation> delegateAnnotations = new LinkedHashSet<Annotation>(annotations);
            delegateAnnotations.remove(annotation);
            return Collections.unmodifiableSet(delegateAnnotations);
        }
        return null;
    }

    public static ParameterizedType newParameterizedType(Type rawType, Type ... typeArguments) {
        return new Util.ParameterizedTypeImpl(null, rawType, typeArguments);
    }

    public static ParameterizedType newParameterizedTypeWithOwner(Type ownerType, Type rawType, Type ... typeArguments) {
        return new Util.ParameterizedTypeImpl(ownerType, rawType, typeArguments);
    }

    public static GenericArrayType arrayOf(Type componentType) {
        return new Util.GenericArrayTypeImpl(componentType);
    }

    public static WildcardType subtypeOf(Type bound) {
        return new Util.WildcardTypeImpl(new Type[]{bound}, Util.EMPTY_TYPE_ARRAY);
    }

    public static WildcardType supertypeOf(Type bound) {
        return new Util.WildcardTypeImpl(new Type[]{Object.class}, new Type[]{bound});
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(Types.getRawType(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return Types.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + className);
    }

    public static Type collectionElementType(Type context, Class<?> contextRawType) {
        Type collectionType = Types.getSupertype(context, contextRawType, Collection.class);
        if (collectionType instanceof WildcardType) {
            collectionType = ((WildcardType)collectionType).getUpperBounds()[0];
        }
        if (collectionType instanceof ParameterizedType) {
            return ((ParameterizedType)collectionType).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    public static boolean equals(@Nullable Type a, @Nullable Type b) {
        if (a == b) {
            return true;
        }
        if (a instanceof Class) {
            if (b instanceof GenericArrayType) {
                return Types.equals(((Class)a).getComponentType(), ((GenericArrayType)b).getGenericComponentType());
            }
            return a.equals(b);
        }
        if (a instanceof ParameterizedType) {
            if (!(b instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType pa = (ParameterizedType)a;
            ParameterizedType pb = (ParameterizedType)b;
            Object[] aTypeArguments = pa instanceof Util.ParameterizedTypeImpl ? ((Util.ParameterizedTypeImpl)pa).typeArguments : pa.getActualTypeArguments();
            Object[] bTypeArguments = pb instanceof Util.ParameterizedTypeImpl ? ((Util.ParameterizedTypeImpl)pb).typeArguments : pb.getActualTypeArguments();
            return Types.equals(pa.getOwnerType(), pb.getOwnerType()) && pa.getRawType().equals(pb.getRawType()) && Arrays.equals(aTypeArguments, bTypeArguments);
        }
        if (a instanceof GenericArrayType) {
            if (b instanceof Class) {
                return Types.equals(((Class)b).getComponentType(), ((GenericArrayType)a).getGenericComponentType());
            }
            if (!(b instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType ga = (GenericArrayType)a;
            GenericArrayType gb = (GenericArrayType)b;
            return Types.equals(ga.getGenericComponentType(), gb.getGenericComponentType());
        }
        if (a instanceof WildcardType) {
            if (!(b instanceof WildcardType)) {
                return false;
            }
            WildcardType wa = (WildcardType)a;
            WildcardType wb = (WildcardType)b;
            return Arrays.equals(wa.getUpperBounds(), wb.getUpperBounds()) && Arrays.equals(wa.getLowerBounds(), wb.getLowerBounds());
        }
        if (a instanceof TypeVariable) {
            if (!(b instanceof TypeVariable)) {
                return false;
            }
            TypeVariable va = (TypeVariable)a;
            TypeVariable vb = (TypeVariable)b;
            return va.getGenericDeclaration() == vb.getGenericDeclaration() && va.getName().equals(vb.getName());
        }
        return false;
    }

    public static Set<? extends Annotation> getFieldJsonQualifierAnnotations(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            Annotation[] fieldAnnotations = field.getDeclaredAnnotations();
            LinkedHashSet<Annotation> annotations = new LinkedHashSet<Annotation>(fieldAnnotations.length);
            for (Annotation annotation : fieldAnnotations) {
                if (!annotation.annotationType().isAnnotationPresent(JsonQualifier.class)) continue;
                annotations.add(annotation);
            }
            return Collections.unmodifiableSet(annotations);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Could not access field " + fieldName + " on class " + clazz.getCanonicalName(), e);
        }
    }

    static <T extends Annotation> T createJsonQualifierImplementation(final Class<T> annotationType) {
        if (!annotationType.isAnnotation()) {
            throw new IllegalArgumentException(annotationType + " must be an annotation.");
        }
        if (!annotationType.isAnnotationPresent(JsonQualifier.class)) {
            throw new IllegalArgumentException(annotationType + " must have @JsonQualifier.");
        }
        if (annotationType.getDeclaredMethods().length != 0) {
            throw new IllegalArgumentException(annotationType + " must not declare methods.");
        }
        return (T)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName;
                switch (methodName = method.getName()) {
                    case "annotationType": {
                        return annotationType;
                    }
                    case "equals": {
                        Object o = args[0];
                        return annotationType.isInstance(o);
                    }
                    case "hashCode": {
                        return 0;
                    }
                    case "toString": {
                        return "@" + annotationType.getName() + "()";
                    }
                }
                return method.invoke(proxy, args);
            }
        }));
    }

    static Type[] mapKeyAndValueTypes(Type context, Class<?> contextRawType) {
        if (context == Properties.class) {
            return new Type[]{String.class, String.class};
        }
        Type mapType = Types.getSupertype(context, contextRawType, Map.class);
        if (mapType instanceof ParameterizedType) {
            ParameterizedType mapParameterizedType = (ParameterizedType)mapType;
            return mapParameterizedType.getActualTypeArguments();
        }
        return new Type[]{Object.class, Object.class};
    }

    static Type getSupertype(Type context, Class<?> contextRawType, Class<?> supertype) {
        if (!supertype.isAssignableFrom(contextRawType)) {
            throw new IllegalArgumentException();
        }
        return Util.resolve(context, contextRawType, Util.getGenericSupertype(context, contextRawType, supertype));
    }

    static Type getGenericSuperclass(Type type) {
        Class<?> rawType = Types.getRawType(type);
        return Util.resolve(type, rawType, rawType.getGenericSuperclass());
    }

    static Type arrayComponentType(Type type) {
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        if (type instanceof Class) {
            return ((Class)type).getComponentType();
        }
        return null;
    }

    static boolean isAllowedPlatformType(Type type) {
        return type == Boolean.class || type == Byte.class || type == Character.class || type == Double.class || type == Float.class || type == Integer.class || type == Long.class || type == Short.class || type == String.class || type == Object.class;
    }
}

