/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy.optimizer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.strategy.optimizer.IFilterOptimizer;

public class MergeSingleFilterOptimizer
implements IFilterOptimizer {
    @Override
    public FilterOperator optimize(FilterOperator filter) throws LogicalOptimizeException {
        this.mergeSamePathFilter(filter);
        return filter;
    }

    private void checkInnerFilterLen(List<FilterOperator> children) throws LogicalOptimizeException {
        if (children.isEmpty()) {
            throw new LogicalOptimizeException("this inner filter has no children!");
        }
        if (children.size() == 1) {
            throw new LogicalOptimizeException("this inner filter has just one child!");
        }
    }

    private PartialPath mergeSamePathFilter(FilterOperator filter) throws LogicalOptimizeException {
        if (filter.isLeaf()) {
            return filter.getSinglePath();
        }
        List<FilterOperator> children = filter.getChildren();
        this.checkInnerFilterLen(children);
        PartialPath childPath = this.mergeSamePathFilter(children.get(0));
        for (int i = 1; i < children.size(); ++i) {
            PartialPath tempPath = this.mergeSamePathFilter(children.get(i));
            if (tempPath != null && tempPath.equals(childPath)) continue;
            childPath = null;
        }
        if (childPath != null) {
            filter.setIsSingle(true);
            filter.setSinglePath(childPath);
            return childPath;
        }
        if (!children.isEmpty() && this.allIsBasic(children)) {
            children.sort(Comparator.comparing(o -> o.getSinglePath().getFullPath()));
        }
        ArrayList<FilterOperator> ret = new ArrayList<FilterOperator>();
        int firstNonSingleIndex = this.mergeSingleFilters(ret, filter);
        return this.addLastNullChild(ret, filter, firstNonSingleIndex, childPath);
    }

    private int mergeSingleFilters(List<FilterOperator> ret, FilterOperator filter) {
        PartialPath tempPath;
        int firstNonSingleIndex;
        List<FilterOperator> children = filter.getChildren();
        ArrayList<FilterOperator> tempExtrNode = null;
        PartialPath childPath = null;
        for (firstNonSingleIndex = 0; firstNonSingleIndex < children.size() && (tempPath = children.get(firstNonSingleIndex).getSinglePath()) != null; ++firstNonSingleIndex) {
            if (childPath == null) {
                childPath = tempPath;
                tempExtrNode = new ArrayList<FilterOperator>();
                tempExtrNode.add(children.get(firstNonSingleIndex));
                continue;
            }
            if (childPath.equals(tempPath)) {
                FilterOperator child = children.get(firstNonSingleIndex);
                if (tempExtrNode.contains(child)) continue;
                tempExtrNode.add(child);
                continue;
            }
            if (tempExtrNode.size() == 1) {
                ret.add((FilterOperator)tempExtrNode.get(0));
                tempExtrNode.set(0, children.get(firstNonSingleIndex));
                childPath = tempPath;
                continue;
            }
            FilterOperator newFilter = new FilterOperator(filter.getFilterType(), true);
            newFilter.setSinglePath(childPath);
            newFilter.setChildren(tempExtrNode);
            ret.add(newFilter);
            tempExtrNode = new ArrayList();
            tempExtrNode.add(children.get(firstNonSingleIndex));
            childPath = tempPath;
        }
        if (childPath != null) {
            if (tempExtrNode.size() == 1) {
                ret.add((FilterOperator)tempExtrNode.get(0));
            } else {
                FilterOperator newFil = new FilterOperator(filter.getFilterType(), true);
                newFil.setSinglePath(childPath);
                newFil.setChildren(tempExtrNode);
                ret.add(newFil);
            }
        }
        return firstNonSingleIndex;
    }

    private PartialPath addLastNullChild(List<FilterOperator> ret, FilterOperator filter, int i, PartialPath childPath) {
        List<FilterOperator> children = filter.getChildren();
        while (i < children.size()) {
            ret.add(children.get(i));
            ++i;
        }
        if (ret.size() == 1) {
            filter.setIsSingle(true);
            filter.setSinglePath(childPath);
            filter.setChildren(ret.get(0).getChildren());
            return childPath;
        }
        filter.setIsSingle(false);
        filter.setChildren(ret);
        return null;
    }

    private boolean allIsBasic(List<FilterOperator> children) {
        for (FilterOperator child : children) {
            if (child instanceof BasicFunctionOperator) continue;
            return false;
        }
        return true;
    }
}

