/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup.timeindex;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.engine.storagegroup.timeindex.ITimeIndex;
import org.apache.iotdb.db.exception.PartitionViolationException;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTimeIndex
implements ITimeIndex {
    private static final Logger logger = LoggerFactory.getLogger(FileTimeIndex.class);
    private static final FileReaderManager FILE_READER_MANAGER = FileReaderManager.getInstance();
    protected long startTime;
    protected long endTime;

    public FileTimeIndex() {
        this.startTime = Long.MAX_VALUE;
        this.endTime = Long.MIN_VALUE;
    }

    public FileTimeIndex(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((long)this.startTime, (OutputStream)outputStream);
        ReadWriteIOUtils.write((long)this.endTime, (OutputStream)outputStream);
    }

    @Override
    public FileTimeIndex deserialize(InputStream inputStream) throws IOException {
        return new FileTimeIndex(ReadWriteIOUtils.readLong((InputStream)inputStream), ReadWriteIOUtils.readLong((InputStream)inputStream));
    }

    @Override
    public FileTimeIndex deserialize(ByteBuffer buffer) {
        return new FileTimeIndex(buffer.getLong(), buffer.getLong());
    }

    @Override
    public void close() {
    }

    @Override
    public Set<String> getDevices(String tsFilePath, TsFileResource tsFileResource) {
        FILE_READER_MANAGER.increaseFileReaderReference(tsFileResource, tsFileResource.isClosed());
        try {
            TsFileSequenceReader fileReader = FileReaderManager.getInstance().get(tsFilePath, true);
            HashSet<String> hashSet = new HashSet<String>(fileReader.getAllDevices());
            return hashSet;
        }
        catch (NoSuchFileException e) {
            if (tsFileResource.isDeleted()) {
                Set<String> set = Collections.emptySet();
                return set;
            }
            logger.error("Can't read file {} from disk ", (Object)tsFilePath, (Object)e);
            throw new RuntimeException("Can't read file " + tsFilePath + " from disk");
        }
        catch (Exception e) {
            logger.error("Failed to get devices from tsfile: {}", (Object)tsFilePath, (Object)e);
            throw new RuntimeException("Failed to get devices from tsfile:: " + tsFilePath);
        }
        finally {
            FILE_READER_MANAGER.decreaseFileReaderReference(tsFileResource, tsFileResource.isClosed());
        }
    }

    @Override
    public boolean endTimeEmpty() {
        return this.endTime == Long.MIN_VALUE;
    }

    @Override
    public boolean stillLives(long ttlLowerBound) {
        if (ttlLowerBound == Long.MAX_VALUE) {
            return true;
        }
        return this.endTime >= ttlLowerBound;
    }

    @Override
    public long calculateRamSize() {
        return RamUsageEstimator.sizeOf((Object)this.startTime) + RamUsageEstimator.sizeOf((Object)this.endTime);
    }

    @Override
    public long getTimePartition(String tsFilePath) {
        try {
            String[] filePathSplits = FilePathUtils.splitTsFilePath((String)tsFilePath);
            return Long.parseLong(filePathSplits[filePathSplits.length - 2]);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private long getTimePartitionWithCheck() {
        long endPartitionId;
        long startPartitionId = StorageEngine.getTimePartition(this.startTime);
        if (startPartitionId == (endPartitionId = StorageEngine.getTimePartition(this.endTime))) {
            return startPartitionId;
        }
        return -1L;
    }

    @Override
    public long getTimePartitionWithCheck(String tsFilePath) throws PartitionViolationException {
        long partitionId = this.getTimePartitionWithCheck();
        if (partitionId == -1L) {
            throw new PartitionViolationException(tsFilePath);
        }
        return partitionId;
    }

    @Override
    public boolean isSpanMultiTimePartitions() {
        long partitionId = this.getTimePartitionWithCheck();
        return partitionId == -1L;
    }

    @Override
    public void updateStartTime(String deviceId, long time) {
        if (this.startTime > time) {
            this.startTime = time;
        }
    }

    @Override
    public void updateEndTime(String deviceId, long time) {
        if (this.endTime < time) {
            this.endTime = time;
        }
    }

    @Override
    public void putStartTime(String deviceId, long time) {
        this.startTime = time;
    }

    @Override
    public void putEndTime(String deviceId, long time) {
        this.endTime = time;
    }

    @Override
    public long getStartTime(String deviceId) {
        return this.startTime;
    }

    @Override
    public long getMinStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime(String deviceId) {
        return this.endTime;
    }

    @Override
    public long getMaxEndTime() {
        return this.endTime;
    }

    @Override
    public boolean checkDeviceIdExist(String deviceId) {
        return true;
    }

    @Override
    public int compareDegradePriority(ITimeIndex timeIndex) {
        if (timeIndex instanceof DeviceTimeIndex) {
            return 1;
        }
        if (timeIndex instanceof FileTimeIndex) {
            return Long.compare(this.startTime, timeIndex.getMinStartTime());
        }
        logger.error("Wrong timeIndex type {}", (Object)timeIndex.getClass().getName());
        throw new RuntimeException("Wrong timeIndex type " + timeIndex.getClass().getName());
    }

    @Override
    public boolean mayContainsDevice(String device) {
        return true;
    }
}

