/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.interceptor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.conf.LogPrivacyUtil;
import org.apache.flume.interceptor.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveHeaderInterceptor
implements Interceptor {
    static final String WITH_NAME = "withName";
    static final String FROM_LIST = "fromList";
    static final String LIST_SEPARATOR = "fromListSeparator";
    static final String LIST_SEPARATOR_DEFAULT = "\\s*,\\s*";
    static final String MATCH_REGEX = "matching";
    private static final Logger LOG = LoggerFactory.getLogger(RemoveHeaderInterceptor.class);
    private final String withName;
    private final Set<String> fromList;
    private final Pattern matchRegex;

    private RemoveHeaderInterceptor(String withName, String fromList, String listSeparator, Pattern matchRegex) {
        this.withName = withName;
        assert (listSeparator != null) : "Default value used otherwise";
        this.fromList = fromList != null ? new HashSet<String>(Arrays.asList(fromList.split(listSeparator))) : null;
        this.matchRegex = matchRegex;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void close() {
    }

    @Override
    public List<Event> intercept(List<Event> events) {
        for (Event event : events) {
            this.intercept(event);
        }
        return events;
    }

    @Override
    public Event intercept(Event event) {
        assert (event != null) : "Missing Flume event while intercepting";
        try {
            Map headers = event.getHeaders();
            if (this.withName != null && headers.remove(this.withName) != null) {
                LOG.trace("Removed header \"{}\" for event: {}", (Object)this.withName, (Object)event);
            }
            if (this.fromList != null || this.matchRegex != null) {
                Iterator headerIterator = headers.keySet().iterator();
                LinkedList<String> removedHeaders = new LinkedList<String>();
                while (headerIterator.hasNext()) {
                    Matcher matcher;
                    String currentHeader = (String)headerIterator.next();
                    if (this.fromList != null && this.fromList.contains(currentHeader)) {
                        headerIterator.remove();
                        removedHeaders.add(currentHeader);
                        continue;
                    }
                    if (this.matchRegex == null || !(matcher = this.matchRegex.matcher(currentHeader)).matches()) continue;
                    headerIterator.remove();
                    removedHeaders.add(currentHeader);
                }
                if (!removedHeaders.isEmpty() && LogPrivacyUtil.allowLogRawData()) {
                    LOG.trace("Removed headers \"{}\" for event: {}", removedHeaders, (Object)event);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to process event " + event, (Throwable)e);
        }
        return event;
    }

    public static class Builder
    implements Interceptor.Builder {
        String withName;
        String fromList;
        String listSeparator;
        Pattern matchRegex;

        @Override
        public Interceptor build() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating RemoveHeaderInterceptor with: withName={}, fromList={}, listSeparator={}, matchRegex={}", (Object[])new String[]{this.withName, this.fromList, this.listSeparator, String.valueOf(this.matchRegex)});
            }
            return new RemoveHeaderInterceptor(this.withName, this.fromList, this.listSeparator, this.matchRegex);
        }

        @Override
        public void configure(Context context) {
            this.withName = context.getString(RemoveHeaderInterceptor.WITH_NAME);
            this.fromList = context.getString(RemoveHeaderInterceptor.FROM_LIST);
            this.listSeparator = context.getString(RemoveHeaderInterceptor.LIST_SEPARATOR, RemoveHeaderInterceptor.LIST_SEPARATOR_DEFAULT);
            String matchRegexStr = context.getString(RemoveHeaderInterceptor.MATCH_REGEX);
            if (matchRegexStr != null) {
                this.matchRegex = Pattern.compile(matchRegexStr);
            }
        }
    }
}

