/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.parser;

import java.util.List;
import net.sf.jsqlparser.expression.ArrayExpression;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.TransformParser;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformParser(values={ArrayExpression.class})
public class ArrayParser
implements ValueParser {
    private final ValueParser left;
    private final ValueParser right;

    public ArrayParser(ArrayExpression expr) {
        this.left = OperatorTools.buildParser(expr.getObjExpression());
        this.right = OperatorTools.buildParser(expr.getIndexExpression());
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object leftValue = this.left.parse(sourceData, rowIndex, context);
        Object rightValue = this.right.parse(sourceData, rowIndex, context);
        if (leftValue instanceof List && rightValue instanceof Number) {
            List leftObj = (List)leftValue;
            Number rightObj = (Number)rightValue;
            return leftObj.get(rightObj.intValue());
        }
        return null;
    }
}

