/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"url_decode"}, parameter="(String str[, String charset])", descriptions={"- Return \"\" if 'str' is NULL, or there is an issue with the decoding process(such as encountering an illegal escape pattern), or the encoding scheme is not supported;", "- Return the result of decoding a given 'str' in 'application/x-www-form-urlencoded' format using the charset(default:UTF-8) encoding scheme."}, examples={"url_decode('https%3A%2F%2Fapache.inlong.com%2Fsearch%3Fq%3Djava+url+encode') = \"https://apache.inlong.com/search?q=java url encode\"", "url_decode('https%3A%2F%2Fapache.inlong.com%2Fsearch%3Fq%3Djava+url+encode','UTF-8') = \"https://apache.inlong.com/search?q=java url encode\""})
public class UrlDecodeFunction
implements ValueParser {
    private final ValueParser stringParser;
    private final ValueParser charsetParser;
    private final String exprKey;

    public UrlDecodeFunction(Function expr) {
        List params = expr.getParameters().getExpressions();
        this.stringParser = OperatorTools.buildParser((Expression)params.get(0));
        this.charsetParser = params.size() > 1 ? OperatorTools.buildParser((Expression)params.get(1)) : null;
        this.exprKey = expr.toString();
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Map<String, Object> runtimeParams = context.getRuntimeParams();
        if (runtimeParams.containsKey(this.exprKey)) {
            return runtimeParams.get(this.exprKey);
        }
        Object stringObj = this.stringParser.parse(sourceData, rowIndex, context);
        if (stringObj == null) {
            runtimeParams.put(this.exprKey, null);
            return null;
        }
        String string = OperatorTools.parseString(stringObj);
        if (string == null) {
            runtimeParams.put(this.exprKey, null);
            return null;
        }
        try {
            if (this.charsetParser == null) {
                String exprValue = URLDecoder.decode(string, StandardCharsets.UTF_8.toString());
                runtimeParams.put(this.exprKey, exprValue);
                return exprValue;
            }
            Object charsetObj = this.charsetParser.parse(sourceData, rowIndex, context);
            if (charsetObj == null) {
                runtimeParams.put(this.exprKey, null);
                return null;
            }
            String charset = OperatorTools.parseString(charsetObj);
            if (charset == null) {
                runtimeParams.put(this.exprKey, null);
                return null;
            }
            String exprValue = URLDecoder.decode(string, charset);
            runtimeParams.put(this.exprKey, exprValue);
            return exprValue;
        }
        catch (Exception e) {
            runtimeParams.put(this.exprKey, null);
            return null;
        }
    }
}

