/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="json", names={"json_unquote"}, parameter="(String data)", descriptions={"- Return \"\" if data is NULL;", "- Return the 'data' unmodified if the value does not start and end with double quotes or if it starts and ends with double quotes but is not a valid JSON string literal.", "Note: JSON_UNQUOTE will unescapes escaped special characters ('\"', '', '/', 'b', 'f', 'n', 'r', 't')"}, examples={"json_unquote('Hello, World!') = \"Hello, World!\"", "json_unquote('Complex string with / and \\\\') = \"Complex string with / and \\\\\""})
public class JsonUnQuoteFunction
implements ValueParser {
    private ValueParser jsonParser;

    public JsonUnQuoteFunction(Function expr) {
        this.jsonParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        if (this.jsonParser == null) {
            return null;
        }
        String jsonString = OperatorTools.parseString(this.jsonParser.parse(sourceData, rowIndex, context));
        if (jsonString == null) {
            return null;
        }
        if (jsonString.length() < 2 || jsonString.charAt(0) != '\"' || jsonString.charAt(jsonString.length() - 1) != '\"') {
            return jsonString;
        }
        try {
            return JSON.parseObject((String)jsonString, String.class);
        }
        catch (JSONException e) {
            return jsonString;
        }
    }
}

