/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

@Internal
public class StreamGroupedReduceOperator<IN>
extends AbstractUdfStreamOperator<IN, ReduceFunction<IN>>
implements OneInputStreamOperator<IN, IN> {
    private static final long serialVersionUID = 1L;
    private static final String STATE_NAME = "_op_state";
    private transient ValueState<IN> values;
    private final TypeSerializer<IN> serializer;

    public StreamGroupedReduceOperator(ReduceFunction<IN> reducer, TypeSerializer<IN> serializer) {
        super(reducer);
        this.serializer = serializer;
    }

    @Override
    public void open() throws Exception {
        super.open();
        ValueStateDescriptor stateId = new ValueStateDescriptor(STATE_NAME, this.serializer);
        this.values = (ValueState)this.getPartitionedState(stateId);
    }

    @Override
    public void processElement(StreamRecord<IN> element) throws Exception {
        IN value = element.getValue();
        Object currentValue = this.values.value();
        if (currentValue != null) {
            Object reduced = ((ReduceFunction)this.userFunction).reduce(currentValue, value);
            this.values.update(reduced);
            this.output.collect(element.replace(reduced));
        } else {
            this.values.update(value);
            this.output.collect(element.replace(value));
        }
    }
}

