/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.changelog;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.changelog.ChangelogStateHandle;
import org.apache.flink.util.Preconditions;

@Internal
public interface ChangelogStateBackendHandle
extends KeyedStateHandle {
    public List<KeyedStateHandle> getMaterializedStateHandles();

    public List<ChangelogStateHandle> getNonMaterializedStateHandles();

    public long getMaterializationID();

    public static class ChangelogStateBackendHandleImpl
    implements ChangelogStateBackendHandle {
        private static final long serialVersionUID = 1L;
        private final List<KeyedStateHandle> materialized;
        private final List<ChangelogStateHandle> nonMaterialized;
        private final KeyGroupRange keyGroupRange;
        private final long materializationID;
        private final long persistedSizeOfThisCheckpoint;
        private final StateHandleID stateHandleID;

        public ChangelogStateBackendHandleImpl(List<KeyedStateHandle> materialized, List<ChangelogStateHandle> nonMaterialized, KeyGroupRange keyGroupRange, long materializationID, long persistedSizeOfThisCheckpoint) {
            this(materialized, nonMaterialized, keyGroupRange, materializationID, persistedSizeOfThisCheckpoint, StateHandleID.randomStateHandleId());
        }

        private ChangelogStateBackendHandleImpl(List<KeyedStateHandle> materialized, List<ChangelogStateHandle> nonMaterialized, KeyGroupRange keyGroupRange, long materializationID, long persistedSizeOfThisCheckpoint, StateHandleID stateHandleId) {
            this.materialized = Collections.unmodifiableList(materialized);
            this.nonMaterialized = Collections.unmodifiableList(nonMaterialized);
            this.keyGroupRange = keyGroupRange;
            this.persistedSizeOfThisCheckpoint = persistedSizeOfThisCheckpoint;
            Preconditions.checkArgument((keyGroupRange.getNumberOfKeyGroups() > 0 ? 1 : 0) != 0);
            this.materializationID = materializationID;
            this.stateHandleID = stateHandleId;
        }

        public static ChangelogStateBackendHandleImpl restore(List<KeyedStateHandle> materialized, List<ChangelogStateHandle> nonMaterialized, KeyGroupRange keyGroupRange, long materializationID, long persistedSizeOfThisCheckpoint, StateHandleID stateHandleId) {
            return new ChangelogStateBackendHandleImpl(materialized, nonMaterialized, keyGroupRange, materializationID, persistedSizeOfThisCheckpoint, stateHandleId);
        }

        @Override
        public void registerSharedStates(SharedStateRegistry stateRegistry, long checkpointID) {
            for (KeyedStateHandle keyedStateHandle : this.materialized) {
                stateRegistry.registerReference(new SharedStateRegistryKey(keyedStateHandle.getStateHandleId().toString()), new StreamStateHandleWrapper(keyedStateHandle), checkpointID);
            }
            stateRegistry.registerAll(this.materialized, checkpointID);
            stateRegistry.registerAll(this.nonMaterialized, checkpointID);
        }

        @Override
        public void discardState() throws Exception {
        }

        @Override
        public KeyGroupRange getKeyGroupRange() {
            return this.keyGroupRange;
        }

        @Override
        @Nullable
        public KeyedStateHandle getIntersection(KeyGroupRange keyGroupRange) {
            KeyGroupRange intersection = this.keyGroupRange.getIntersection(keyGroupRange);
            if (intersection.getNumberOfKeyGroups() == 0) {
                return null;
            }
            List<KeyedStateHandle> basePart = this.materialized.stream().map(entry -> entry.getIntersection(keyGroupRange)).filter(Objects::nonNull).collect(Collectors.toList());
            List<ChangelogStateHandle> deltaPart = this.nonMaterialized.stream().map(handle -> (ChangelogStateHandle)handle.getIntersection(keyGroupRange)).filter(Objects::nonNull).collect(Collectors.toList());
            return new ChangelogStateBackendHandleImpl(basePart, deltaPart, intersection, this.materializationID, this.persistedSizeOfThisCheckpoint);
        }

        @Override
        public StateHandleID getStateHandleId() {
            return this.stateHandleID;
        }

        @Override
        public long getStateSize() {
            return this.materialized.stream().mapToLong(StateObject::getStateSize).sum() + this.nonMaterialized.stream().mapToLong(StateObject::getStateSize).sum();
        }

        @Override
        public long getCheckpointedSize() {
            return this.persistedSizeOfThisCheckpoint;
        }

        @Override
        public List<KeyedStateHandle> getMaterializedStateHandles() {
            return this.materialized;
        }

        @Override
        public List<ChangelogStateHandle> getNonMaterializedStateHandles() {
            return this.nonMaterialized;
        }

        @Override
        public long getMaterializationID() {
            return this.materializationID;
        }

        public String toString() {
            return String.format("keyGroupRange=%s, basePartSize=%d, deltaPartSize=%d", this.keyGroupRange, this.materialized.size(), this.nonMaterialized.size());
        }

        private static class StreamStateHandleWrapper
        implements StreamStateHandle {
            private static final long serialVersionUID = 1L;
            private final KeyedStateHandle keyedStateHandle;

            StreamStateHandleWrapper(KeyedStateHandle keyedStateHandle) {
                this.keyedStateHandle = keyedStateHandle;
            }

            @Override
            public void discardState() throws Exception {
                this.keyedStateHandle.discardState();
            }

            @Override
            public long getStateSize() {
                return this.keyedStateHandle.getStateSize();
            }

            @Override
            public FSDataInputStream openInputStream() throws IOException {
                throw new UnsupportedOperationException("Should not call here.");
            }

            @Override
            public Optional<byte[]> asBytesIfInMemory() {
                throw new UnsupportedOperationException("Should not call here.");
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                StreamStateHandleWrapper that = (StreamStateHandleWrapper)o;
                return Objects.equals((Object)this.keyedStateHandle.getStateHandleId(), (Object)that.keyedStateHandle.getStateHandleId());
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.keyedStateHandle.getStateHandleId()});
            }

            public String toString() {
                return "Wrapped{" + this.keyedStateHandle + '}';
            }
        }
    }
}

