/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.stream;

import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.pojo.workflow.form.process.StreamResourceProcessForm;
import org.apache.inlong.manager.service.listener.StreamTaskListenerFactory;
import org.apache.inlong.manager.service.listener.stream.InitStreamCompleteListener;
import org.apache.inlong.manager.service.listener.stream.InitStreamFailedListener;
import org.apache.inlong.manager.service.listener.stream.InitStreamListener;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.ServiceTask;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.TaskListenerFactory;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateStreamWorkflowDefinition
implements WorkflowDefinition {
    private static final Logger log = LoggerFactory.getLogger(CreateStreamWorkflowDefinition.class);
    @Autowired
    private InitStreamListener initStreamListener;
    @Autowired
    private InitStreamCompleteListener initStreamCompleteListener;
    @Autowired
    private InitStreamFailedListener initStreamFailedListener;
    @Autowired
    private StreamTaskListenerFactory streamTaskListenerFactory;

    @Override
    public WorkflowProcess defineProcess() {
        WorkflowProcess process = new WorkflowProcess();
        process.setName(this.getProcessName().name());
        process.setType(this.getProcessName().getDisplayName());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(StreamResourceProcessForm.class);
        process.setVersion(1);
        process.setHidden(Integer.valueOf(1));
        process.addListener((ProcessEventListener)this.initStreamListener);
        process.addListener((ProcessEventListener)this.initStreamFailedListener);
        process.addListener((ProcessEventListener)this.initStreamCompleteListener);
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        ServiceTask initMQTask = new ServiceTask();
        initMQTask.setName("InitMQ");
        initMQTask.setDisplayName("Stream-InitMQ");
        initMQTask.setServiceTaskType(ServiceTaskType.INIT_MQ);
        initMQTask.setListenerFactory((TaskListenerFactory)this.streamTaskListenerFactory);
        process.addTask((WorkflowTask)initMQTask);
        ServiceTask initSinkTask = new ServiceTask();
        initSinkTask.setName("InitSink");
        initSinkTask.setDisplayName("Stream-InitSink");
        initSinkTask.setServiceTaskType(ServiceTaskType.INIT_SINK);
        initSinkTask.setListenerFactory((TaskListenerFactory)this.streamTaskListenerFactory);
        process.addTask((WorkflowTask)initSinkTask);
        ServiceTask initSortTask = new ServiceTask();
        initSortTask.setName("InitSort");
        initSortTask.setDisplayName("Stream-InitSort");
        initSortTask.setServiceTaskType(ServiceTaskType.INIT_SORT);
        initSortTask.setListenerFactory((TaskListenerFactory)this.streamTaskListenerFactory);
        process.addTask((WorkflowTask)initSortTask);
        ServiceTask initSourceTask = new ServiceTask();
        initSourceTask.setName("InitSource");
        initSourceTask.setDisplayName("Stream-InitSource");
        initSourceTask.setServiceTaskType(ServiceTaskType.INIT_SOURCE);
        initSourceTask.setListenerFactory((TaskListenerFactory)this.streamTaskListenerFactory);
        process.addTask((WorkflowTask)initSourceTask);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        startEvent.addNext((Element)initMQTask);
        initMQTask.addNext((Element)initSinkTask);
        initSinkTask.addNext((Element)initSortTask);
        initSortTask.addNext((Element)initSourceTask);
        initSourceTask.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.CREATE_STREAM_RESOURCE;
    }
}

