/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.schedule;

import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.workflow.processor.OfflineJobOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfflineJobOperatorFactory {
    private static final Logger log = LoggerFactory.getLogger(OfflineJobOperatorFactory.class);
    public static final String DEFAULT_OPERATOR_CLASS_NAME = "org.apache.inlong.manager.plugin.offline.FlinkOfflineJobOperator";

    public static OfflineJobOperator getOfflineJobOperator() {
        return OfflineJobOperatorFactory.getOfflineJobOperator(DEFAULT_OPERATOR_CLASS_NAME);
    }

    public static OfflineJobOperator getOfflineJobOperator(String operatorClassName) {
        return OfflineJobOperatorFactory.getOfflineJobOperator(operatorClassName, Thread.currentThread().getContextClassLoader());
    }

    public static OfflineJobOperator getOfflineJobOperator(String operatorClassName, ClassLoader classLoader) {
        try {
            Class<?> operatorClass = classLoader.loadClass(operatorClassName);
            Object operator = operatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return (OfflineJobOperator)operator;
        }
        catch (Throwable e) {
            log.error("Failed to get offline job operator: ", e);
            throw new BusinessException("Failed to get offline job operator: " + e.getMessage());
        }
    }
}

