/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.sink;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.mapper.StreamSinkEntityMapper;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.sink.SinkInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.StreamResourceProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.resource.sink.SinkResourceOperator;
import org.apache.inlong.manager.service.resource.sink.SinkResourceOperatorFactory;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SinkOperateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StreamSinkResourceListener
implements SinkOperateListener {
    private static final Logger log = LoggerFactory.getLogger(StreamSinkResourceListener.class);
    @Autowired
    private StreamSinkEntityMapper sinkEntityMapper;
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private SinkResourceOperatorFactory resourceOperatorFactory;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public boolean accept(WorkflowContext context) {
        ProcessForm processForm = context.getProcessForm();
        return processForm instanceof StreamResourceProcessForm;
    }

    public ListenerResult listen(WorkflowContext context) {
        StreamResourceProcessForm form = (StreamResourceProcessForm)context.getProcessForm();
        InlongStreamInfo streamInfo = form.getStreamInfo();
        String groupId = streamInfo.getInlongGroupId();
        String streamId = streamInfo.getInlongStreamId();
        log.info("begin to create sink resource for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        GroupStatus groupStatus = GroupStatus.forCode((int)groupInfo.getStatus());
        Preconditions.expectTrue((GroupStatus.CONFIG_FAILED != groupStatus ? 1 : 0) != 0, (String)String.format("group status=%s not support start stream for groupId=%s", groupStatus, groupId));
        List sinkInfos = this.sinkEntityMapper.selectAllConfig(groupId, (List)Lists.newArrayList((Object[])new String[]{streamId}));
        List needCreateResources = sinkInfos.stream().filter(sinkInfo -> InlongConstants.ENABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(needCreateResources)) {
            log.info("sink resources have been created for group [" + groupId + "] and stream [" + streamId + "]");
            return ListenerResult.success();
        }
        for (SinkInfo sinkInfo2 : needCreateResources) {
            SinkResourceOperator resourceOperator = this.resourceOperatorFactory.getInstance(sinkInfo2.getSinkType());
            resourceOperator.createSinkResource(sinkInfo2);
        }
        log.info("success to create sink resources for group [" + groupId + "] and stream [" + streamId + "]");
        return ListenerResult.success();
    }
}

