/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.config;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.common.pojo.dataproxy.DataProxyNodeInfo;
import org.apache.inlong.common.pojo.dataproxy.DataProxyNodeResponse;
import org.apache.inlong.common.util.BasicAuth;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.ObjectUtils;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.dataproxy.common.ErrorCode;
import org.apache.inlong.sdk.dataproxy.common.ProcessResult;
import org.apache.inlong.sdk.dataproxy.common.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.common.SdkConsts;
import org.apache.inlong.sdk.dataproxy.config.ConfigHolder;
import org.apache.inlong.sdk.dataproxy.config.EncryptConfigEntry;
import org.apache.inlong.sdk.dataproxy.config.HostInfo;
import org.apache.inlong.sdk.dataproxy.config.ProxyClusterConfig;
import org.apache.inlong.sdk.dataproxy.config.ProxyConfigEntry;
import org.apache.inlong.sdk.dataproxy.utils.LogCounter;
import org.apache.inlong.sdk.dataproxy.utils.ProxyUtils;
import org.apache.inlong.sdk.dataproxy.utils.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyConfigManager
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(ProxyConfigManager.class);
    private static final LogCounter exptCounter = new LogCounter(10L, 100000L, 60000L);
    private static final LogCounter parseCounter = new LogCounter(10L, 100000L, 60000L);
    protected static final LogCounter cntCounter = new LogCounter(10L, 100000L, 60000L);
    private static final Map<String, Tuple2<AtomicLong, String>> fetchFailProxyMap = new ConcurrentHashMap<String, Tuple2<AtomicLong, String>>();
    private static final Map<String, Tuple2<AtomicLong, String>> fetchFailEncryptMap = new ConcurrentHashMap<String, Tuple2<AtomicLong, String>>();
    private static final ReentrantReadWriteLock fileRw = new ReentrantReadWriteLock();
    private final String callerId;
    private final Gson gson = new Gson();
    private final ConfigHolder configHolder;
    private final ThreadLocalRandom random = ThreadLocalRandom.current();
    private final AtomicBoolean shutDown = new AtomicBoolean(false);
    private ProxyClientConfig mgrConfig = null;
    private String localProxyConfigStoreFile;
    private String proxyConfigVisitUrl;
    private String proxyQueryFailKey;
    private String proxyConfigCacheFile;
    private ProxyConfigEntry proxyConfigEntry = null;
    private List<HostInfo> proxyInfoList = new ArrayList<HostInfo>();
    private int oldStat = 0;
    private String localMd5;
    private long lstUpdateTime = 0L;
    private String encryptConfigVisitUrl;
    private String encryptQueryFailKey;
    private String encryptConfigCacheFile;
    private EncryptConfigEntry userEncryptConfigEntry;

    public ProxyConfigManager(ProxyClientConfig configure) {
        this("MetaQuery", configure, null);
    }

    public ProxyConfigManager(String callerId, ProxyClientConfig configure, ConfigHolder configHolder) {
        this.callerId = callerId;
        this.configHolder = configHolder;
        if (configure != null) {
            this.storeAndBuildMetaConfigure(configure);
        }
        if (this.configHolder != null) {
            this.setName("ConfigManager-" + this.callerId);
            logger.info("ConfigManager({}) started, groupId={}", (Object)this.callerId, (Object)this.mgrConfig.getInlongGroupId());
        }
    }

    public boolean updProxyClientConfig(ProxyClientConfig configure, ProcessResult procResult) {
        if (this.shutDown.get()) {
            return procResult.setFailResult(ErrorCode.SDK_CLOSED);
        }
        if (this.configHolder != null) {
            return procResult.setFailResult(ErrorCode.ILLEGAL_CALL_STATE);
        }
        this.storeAndBuildMetaConfigure(configure);
        return procResult.setSuccess();
    }

    public void shutDown() {
        if (this.configHolder == null) {
            return;
        }
        if (this.shutDown.compareAndSet(false, true)) {
            this.interrupt();
            logger.info("ConfigManager({}) begin to shutdown, groupId={}!", (Object)this.callerId, (Object)this.mgrConfig.getInlongGroupId());
        }
    }

    public boolean getGroupIdConfigure(boolean needRetry, ProcessResult procResult) {
        if (this.shutDown.get()) {
            return procResult.setFailResult(ErrorCode.SDK_CLOSED);
        }
        if (this.mgrConfig == null) {
            return procResult.setFailResult(ErrorCode.CONFIGURE_NOT_INITIALIZED);
        }
        if (this.mgrConfig.isOnlyUseLocalProxyConfig()) {
            return this.getLocalProxyListFromFile(this.localProxyConfigStoreFile, procResult);
        }
        boolean readFromRmt = false;
        if (!this.tryToReadCacheProxyEntry(procResult)) {
            int retryCount = 0;
            while (!this.shutDown.get()) {
                if (this.requestProxyEntryQuietly(procResult)) {
                    readFromRmt = true;
                    break;
                }
                if (!needRetry || ++retryCount >= this.mgrConfig.getMetaQueryMaxRetryIfFail() || this.shutDown.get()) break;
                ProxyUtils.sleepSomeTime(this.mgrConfig.getMetaQueryWaitMsIfFail());
            }
        }
        if (this.shutDown.get()) {
            return procResult.setFailResult(ErrorCode.SDK_CLOSED);
        }
        if (readFromRmt && procResult.isSuccess()) {
            this.tryToWriteCacheProxyEntry((ProxyConfigEntry)procResult.getRetData());
        }
        return procResult.isSuccess();
    }

    public boolean getEncryptConfigure(boolean needRetry, ProcessResult procResult) {
        if (this.shutDown.get()) {
            return procResult.setFailResult(ErrorCode.SDK_CLOSED);
        }
        if (this.mgrConfig == null) {
            return procResult.setFailResult(ErrorCode.CONFIGURE_NOT_INITIALIZED);
        }
        boolean readFromRmt = false;
        if (!this.readCachedPubKeyEntry(procResult)) {
            int retryCount = 0;
            while (!this.shutDown.get()) {
                if (this.requestPubKeyFromManager(procResult)) {
                    readFromRmt = true;
                    break;
                }
                if (!needRetry || ++retryCount >= this.mgrConfig.getMetaQueryMaxRetryIfFail() || this.shutDown.get()) break;
                ProxyUtils.sleepSomeTime(this.mgrConfig.getMetaQueryWaitMsIfFail());
            }
        }
        if (this.shutDown.get()) {
            return procResult.setFailResult(ErrorCode.SDK_CLOSED);
        }
        if (readFromRmt && procResult.isSuccess()) {
            this.writeCachePubKeyEntryFile((EncryptConfigEntry)procResult.getRetData());
        }
        return procResult.isSuccess();
    }

    @Override
    public void run() {
        logger.info("ConfigManager({}) thread start, groupId={}", (Object)this.callerId, (Object)this.mgrConfig.getInlongGroupId());
        ProcessResult procResult = new ProcessResult();
        while (!this.shutDown.get()) {
            long curTime = System.currentTimeMillis();
            this.updateMetaInfoFromRemote(procResult);
            if (this.configHolder != null && this.configHolder.getMetricHolder() != null) {
                this.configHolder.getMetricHolder().addMetaSyncMetric(procResult.getErrCode(), System.currentTimeMillis() - curTime);
            }
            if (this.shutDown.get()) break;
            ProxyUtils.sleepSomeTime(this.mgrConfig.getMgrMetaSyncInrMs() + (long)(this.random.nextInt(100) * 100));
        }
        logger.info("ConfigManager({}) worker existed, groupId={}", (Object)this.callerId, (Object)this.mgrConfig.getInlongGroupId());
    }

    private boolean updateMetaInfoFromRemote(ProcessResult procResult) {
        if (!this.doProxyEntryQueryWork(procResult)) {
            return procResult.isSuccess();
        }
        if (this.mgrConfig.isEnableReportEncrypt() && !this.doEncryptConfigEntryQueryWork(procResult)) {
            return procResult.isSuccess();
        }
        return procResult.setSuccess();
    }

    public ProxyConfigEntry getProxyConfigEntry() {
        return this.proxyConfigEntry;
    }

    public EncryptConfigEntry getUserEncryptConfigEntry() {
        return this.userEncryptConfigEntry;
    }

    public boolean doProxyEntryQueryWork(ProcessResult procResult) {
        if (this.localMd5 == null) {
            this.localMd5 = this.calcHostInfoMd5(this.proxyInfoList);
        }
        ProxyConfigEntry rmtProxyConfigEntry = null;
        if (this.mgrConfig.isOnlyUseLocalProxyConfig()) {
            if (!this.getLocalProxyListFromFile(this.localProxyConfigStoreFile, procResult)) {
                return false;
            }
            rmtProxyConfigEntry = (ProxyConfigEntry)procResult.getRetData();
        } else {
            int retryCnt = 0;
            while (!(this.shutDown.get() || this.requestProxyEntryQuietly(procResult) || ++retryCnt >= this.mgrConfig.getMetaSyncMaxRetryIfFail() || this.shutDown.get())) {
                ProxyUtils.sleepSomeTime(this.mgrConfig.getMetaSyncWaitMsIfFail());
            }
            if (this.shutDown.get()) {
                return procResult.setFailResult(ErrorCode.SDK_CLOSED);
            }
            if (procResult.isSuccess()) {
                rmtProxyConfigEntry = (ProxyConfigEntry)procResult.getRetData();
                this.tryToWriteCacheProxyEntry(rmtProxyConfigEntry);
            }
            if (this.localMd5 == null && rmtProxyConfigEntry == null) {
                if (exptCounter.shouldPrint()) {
                    logger.warn("ConfigManager({}) connect manager({}) failure, get cached configure, groupId={}", new Object[]{this.callerId, this.proxyConfigVisitUrl, this.mgrConfig.getInlongGroupId()});
                }
                if (this.tryToReadCacheProxyEntry(procResult)) {
                    rmtProxyConfigEntry = (ProxyConfigEntry)procResult.getRetData();
                }
            }
            if (this.localMd5 != null && rmtProxyConfigEntry == null && this.proxyInfoList != null && exptCounter.shouldPrint()) {
                logger.warn("ConfigManager({}) connect manager({}) failure, using the last configure, groupId={}", new Object[]{this.callerId, this.proxyConfigVisitUrl, this.mgrConfig.getInlongGroupId()});
            }
        }
        if (this.localMd5 == null && rmtProxyConfigEntry == null && this.proxyInfoList == null) {
            if (exptCounter.shouldPrint()) {
                if (this.mgrConfig.isOnlyUseLocalProxyConfig()) {
                    logger.warn("ConfigManager({}) continue fetch proxy meta failure, localFile={}, groupId={}", new Object[]{this.callerId, this.localProxyConfigStoreFile, this.mgrConfig.getInlongGroupId()});
                } else {
                    logger.warn("ConfigManager({}) continue fetch proxy meta failure, manager={}, groupId={}", new Object[]{this.callerId, this.proxyConfigVisitUrl, this.mgrConfig.getInlongGroupId()});
                }
            }
            return procResult.isSuccess();
        }
        this.compareAndUpdateProxyList(rmtProxyConfigEntry);
        return procResult.setSuccess();
    }

    public boolean doEncryptConfigEntryQueryWork(ProcessResult procResult) {
        int retryCount = 0;
        while (!(this.shutDown.get() || this.requestPubKeyFromManager(procResult) || ++retryCount >= this.mgrConfig.getMetaSyncMaxRetryIfFail() || this.shutDown.get())) {
            ProxyUtils.sleepSomeTime(this.mgrConfig.getMetaSyncWaitMsIfFail());
        }
        if (this.shutDown.get()) {
            return procResult.setFailResult(ErrorCode.SDK_CLOSED);
        }
        if (!procResult.isSuccess()) {
            if (exptCounter.shouldPrint()) {
                if (this.userEncryptConfigEntry == null) {
                    logger.warn("ConfigManager({}) continue fetch encrypt meta failure, manager={}, username={}", new Object[]{this.callerId, this.encryptConfigVisitUrl, this.mgrConfig.getRptUserName()});
                } else {
                    logger.warn("ConfigManager({}) fetch encrypt failure, manager={}, use the last pubKey, username={}", new Object[]{this.callerId, this.encryptConfigVisitUrl, this.mgrConfig.getRptUserName()});
                }
            }
            return procResult.isSuccess();
        }
        EncryptConfigEntry rmtEncryptEntry = (EncryptConfigEntry)procResult.getRetData();
        this.updateEncryptConfigEntry(rmtEncryptEntry);
        this.writeCachePubKeyEntryFile(rmtEncryptEntry);
        return procResult.setSuccess();
    }

    public boolean getLocalProxyListFromFile(String filePath, ProcessResult procResult) {
        String strRet;
        try {
            byte[] fileBytes = Files.readAllBytes(Paths.get(filePath, new String[0]));
            strRet = new String(fileBytes);
        }
        catch (Throwable ex) {
            return procResult.setFailResult(ErrorCode.READ_LOCAL_FILE_FAILURE, "Read local configure failure from " + filePath + ", reason is " + ex.getMessage());
        }
        if (StringUtils.isBlank(strRet)) {
            return procResult.setFailResult(ErrorCode.BLANK_FILE_CONTENT, "Blank configure local file from " + filePath);
        }
        return this.getProxyConfigEntry(false, strRet, procResult);
    }

    private boolean requestProxyEntryQuietly(ProcessResult procResult) {
        String qryResult = this.getManagerQryResultInFailStatus(true);
        if (qryResult != null) {
            return procResult.setFailResult(ErrorCode.FREQUENT_RMT_FAILURE_VISIT, "Query fail(" + qryResult + ") just now, retry later!");
        }
        List<BasicNameValuePair> params = this.buildProxyNodeQueryParams();
        logger.debug("ConfigManager({}) request configure to manager({}), param={}", new Object[]{this.callerId, this.proxyConfigVisitUrl, params});
        if (!this.requestConfiguration(true, this.proxyConfigVisitUrl, params, procResult)) {
            return false;
        }
        String content = (String)procResult.getRetData();
        logger.debug("ConfigManager({}) received configure, from manager({}), groupId={}, result={}", new Object[]{this.callerId, this.proxyConfigVisitUrl, this.mgrConfig.getInlongGroupId(), content});
        try {
            if (this.getProxyConfigEntry(true, content, procResult)) {
                this.rmvManagerQryFailStatus(true);
            } else {
                this.bookManagerQryFailStatus(true, procResult.getErrMsg());
                if (cntCounter.shouldPrint()) {
                    logger.warn("ConfigManager({}) illegal content, from=({}), groupId={}, content={}, result={}", new Object[]{this.callerId, this.proxyConfigVisitUrl, this.mgrConfig.getInlongGroupId(), content, procResult});
                }
            }
            return procResult.isSuccess();
        }
        catch (Throwable ex) {
            if (exptCounter.shouldPrint()) {
                logger.warn("ConfigManager({}) parse exception, from manager({}), groupId={}, result={}", new Object[]{this.callerId, this.proxyConfigVisitUrl, this.mgrConfig.getInlongGroupId(), content, ex});
            }
            this.bookManagerQryFailStatus(true, ex.getMessage());
            return procResult.setFailResult(ErrorCode.PARSE_PROXY_META_EXCEPTION, ex.getMessage());
        }
    }

    private String calcHostInfoMd5(List<HostInfo> hostInfoList) {
        if (hostInfoList == null || hostInfoList.isEmpty()) {
            return null;
        }
        Collections.sort(hostInfoList);
        StringBuilder hostInfoMd5 = new StringBuilder();
        for (HostInfo hostInfo : hostInfoList) {
            if (hostInfo == null) continue;
            hostInfoMd5.append(hostInfo.getHostName());
            hostInfoMd5.append(":");
            hostInfoMd5.append(hostInfo.getPortNumber());
            hostInfoMd5.append(";");
        }
        return DigestUtils.md5Hex((String)hostInfoMd5.toString());
    }

    private void compareAndUpdateProxyList(ProxyConfigEntry proxyEntry) {
        boolean nodeChanged;
        ArrayList<HostInfo> newProxyNodeList;
        int newSwitchStat;
        if ((proxyEntry == null || proxyEntry.isNodesEmpty()) && (this.proxyInfoList.isEmpty() || System.currentTimeMillis() - this.lstUpdateTime < this.mgrConfig.getForceReChooseInrMs())) {
            return;
        }
        if (proxyEntry == null || proxyEntry.isNodesEmpty()) {
            newSwitchStat = this.oldStat;
            newProxyNodeList = new ArrayList<HostInfo>(this.proxyInfoList.size());
            newProxyNodeList.addAll(this.proxyInfoList);
        } else {
            this.proxyConfigEntry = proxyEntry;
            this.configHolder.updateAllowedMaxPkgLength(proxyEntry.getMaxPacketLength());
            newSwitchStat = proxyEntry.getSwitchStat();
            newProxyNodeList = new ArrayList(proxyEntry.getSize());
            for (Map.Entry<String, HostInfo> entry : proxyEntry.getHostMap().entrySet()) {
                newProxyNodeList.add(entry.getValue());
            }
        }
        String newMd5 = this.calcHostInfoMd5(newProxyNodeList);
        String oldMd5 = this.calcHostInfoMd5(this.proxyInfoList);
        boolean bl = nodeChanged = newMd5 != null && !newMd5.equals(oldMd5);
        if (nodeChanged || newSwitchStat != this.oldStat || System.currentTimeMillis() - this.lstUpdateTime >= this.mgrConfig.getForceReChooseInrMs()) {
            this.proxyInfoList = newProxyNodeList;
            this.configHolder.updateProxyNodes(nodeChanged, this.proxyInfoList);
            this.lstUpdateTime = System.currentTimeMillis();
            this.oldStat = newSwitchStat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToWriteCacheProxyEntry(ProxyConfigEntry entry) {
        logger.debug("ConfigManager({}) write {} to cache file ({})", new Object[]{this.callerId, entry, this.proxyConfigCacheFile});
        fileRw.writeLock().lock();
        try {
            File file = new File(this.proxyConfigCacheFile);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileWriter fileWriter = new FileWriter(this.proxyConfigCacheFile);
            this.gson.toJson((Object)entry, (Appendable)fileWriter);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Throwable ex) {
            if (exptCounter.shouldPrint()) {
                logger.warn("ConfigManager({}) write cache file({}) exception, groupId={}, data={}", new Object[]{this.callerId, this.mgrConfig.getInlongGroupId(), this.proxyConfigCacheFile, entry.toString(), ex});
            }
        }
        finally {
            fileRw.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryToReadCacheProxyEntry(ProcessResult procResult) {
        fileRw.readLock().lock();
        try {
            File file = new File(this.proxyConfigCacheFile);
            if (file.exists()) {
                long diffTime = System.currentTimeMillis() - file.lastModified();
                if (this.mgrConfig.getMetaCacheExpiredMs() > 0L && diffTime < this.mgrConfig.getMetaCacheExpiredMs()) {
                    JsonReader reader = new JsonReader((Reader)new FileReader(this.proxyConfigCacheFile));
                    ProxyConfigEntry proxyConfigEntry = (ProxyConfigEntry)this.gson.fromJson(reader, ProxyConfigEntry.class);
                    boolean bl = procResult.setSuccess(proxyConfigEntry);
                    return bl;
                }
                boolean bl = procResult.setFailResult(ErrorCode.LOCAL_FILE_EXPIRED);
                return bl;
            }
            boolean bl = procResult.setFailResult(ErrorCode.LOCAL_FILE_NOT_EXIST);
            return bl;
        }
        catch (Throwable ex) {
            if (exptCounter.shouldPrint()) {
                logger.warn("ConfigManager({}) read cache file({}) exception, groupId={}", new Object[]{this.callerId, this.proxyConfigCacheFile, this.mgrConfig.getInlongGroupId(), ex});
            }
            boolean bl = procResult.setFailResult(ErrorCode.READ_LOCAL_FILE_FAILURE, "read cache configure failure:" + ex.getMessage());
            return bl;
        }
        finally {
            fileRw.readLock().unlock();
        }
    }

    private boolean requestPubKeyFromManager(ProcessResult procResult) {
        JsonObject pubKeyConf;
        String qryResult = this.getManagerQryResultInFailStatus(false);
        if (qryResult != null) {
            procResult.setFailResult(ErrorCode.FREQUENT_RMT_FAILURE_VISIT, "Query fail(" + qryResult + ") just now, retry later!");
        }
        List<BasicNameValuePair> params = this.buildPubKeyQueryParams();
        logger.debug("ConfigManager({}) request pubkey to manager({}), param={}", new Object[]{this.callerId, this.encryptConfigVisitUrl, params});
        if (!this.requestConfiguration(false, this.encryptConfigVisitUrl, params, procResult)) {
            return false;
        }
        String content = (String)procResult.getRetData();
        logger.debug("ConfigManager({}) received pubkey from manager({}), result={}", new Object[]{this.callerId, this.encryptConfigVisitUrl, content});
        try {
            pubKeyConf = JsonParser.parseString((String)content).getAsJsonObject();
        }
        catch (Throwable ex) {
            if (parseCounter.shouldPrint()) {
                logger.warn("ConfigManager({}) parse failure, userName={}, config={}!", new Object[]{this.callerId, this.mgrConfig.getRptUserName(), content});
            }
            String errorMsg = "parse pubkey failure:" + ex.getMessage();
            this.bookManagerQryFailStatus(false, errorMsg);
            return procResult.setFailResult(ErrorCode.PARSE_RMT_CONTENT_FAILURE, errorMsg);
        }
        if (pubKeyConf == null) {
            String errorMsg = "No public key information";
            this.bookManagerQryFailStatus(false, errorMsg);
            return procResult.setFailResult(ErrorCode.PARSE_RMT_CONTENT_IS_NULL);
        }
        try {
            if (!pubKeyConf.has("resultCode")) {
                if (parseCounter.shouldPrint()) {
                    logger.warn("ConfigManager({}) config failure: resultCode field not exist, userName={}, config={}!", new Object[]{this.callerId, this.mgrConfig.getRptUserName(), content});
                }
                throw new Exception("resultCode field not exist");
            }
            int resultCode = pubKeyConf.get("resultCode").getAsInt();
            if (resultCode != 0) {
                if (parseCounter.shouldPrint()) {
                    logger.warn("ConfigManager({}) config failure: resultCode != 0, userName={}, config={}!", new Object[]{this.callerId, this.mgrConfig.getRptUserName(), content});
                }
                throw new Exception("resultCode != 0!");
            }
            if (!pubKeyConf.has("resultData")) {
                if (parseCounter.shouldPrint()) {
                    logger.warn("ConfigManager({}) config failure: resultData field not exist, userName={}, config={}!", new Object[]{this.callerId, this.mgrConfig.getRptUserName(), content});
                }
                throw new Exception("resultData field not exist");
            }
            JsonObject resultData = pubKeyConf.get("resultData").getAsJsonObject();
            if (resultData != null) {
                String publicKey = resultData.get("publicKey").getAsString();
                if (StringUtils.isBlank(publicKey)) {
                    if (parseCounter.shouldPrint()) {
                        logger.warn("ConfigManager({}) config failure: publicKey is blank, userName={}, config={}!", new Object[]{this.callerId, this.mgrConfig.getRptUserName(), content});
                    }
                    throw new Exception("publicKey is blank!");
                }
                String username = resultData.get("username").getAsString();
                if (StringUtils.isBlank(username)) {
                    if (parseCounter.shouldPrint()) {
                        logger.warn("ConfigManager({}) config failure: username is blank, userName={}, config={}!", new Object[]{this.callerId, this.mgrConfig.getRptUserName(), content});
                    }
                    throw new Exception("username is blank!");
                }
                String versionStr = resultData.get("version").getAsString();
                if (StringUtils.isBlank(versionStr)) {
                    if (parseCounter.shouldPrint()) {
                        logger.warn("ConfigManager({}) config failure: version is blank, userName={}, config={}!", new Object[]{this.callerId, this.mgrConfig.getRptUserName(), content});
                    }
                    throw new Exception("version is blank!");
                }
                this.rmvManagerQryFailStatus(false);
                return procResult.setSuccess(new EncryptConfigEntry(username, versionStr, publicKey));
            }
            throw new Exception("resultData value is null!");
        }
        catch (Throwable ex) {
            this.bookManagerQryFailStatus(false, ex.getMessage());
            return procResult.setFailResult(ErrorCode.PARSE_ENCRYPT_META_EXCEPTION, ex.getMessage());
        }
    }

    private void updateEncryptConfigEntry(EncryptConfigEntry newEncryptEntry) {
        newEncryptEntry.getRsaEncryptedKey();
        this.userEncryptConfigEntry = newEncryptEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readCachedPubKeyEntry(ProcessResult procResult) {
        FileInputStream fis = null;
        fileRw.readLock().lock();
        try {
            File file = new File(this.encryptConfigCacheFile);
            if (file.exists()) {
                long diffTime = System.currentTimeMillis() - file.lastModified();
                if (this.mgrConfig.getMetaCacheExpiredMs() > 0L && diffTime < this.mgrConfig.getMetaCacheExpiredMs()) {
                    fis = new FileInputStream(file);
                    ObjectInputStream is = new ObjectInputStream(fis);
                    EncryptConfigEntry entry = (EncryptConfigEntry)is.readObject();
                    fis.close();
                    boolean bl = procResult.setSuccess(entry);
                    return bl;
                }
                boolean bl = procResult.setFailResult(ErrorCode.LOCAL_FILE_EXPIRED);
                return bl;
            }
            boolean bl = procResult.setFailResult(ErrorCode.LOCAL_FILE_NOT_EXIST);
            return bl;
        }
        catch (Throwable ex) {
            if (exptCounter.shouldPrint()) {
                logger.warn("ConfigManager({}) read({}) file exception, userName={}", new Object[]{this.callerId, this.encryptConfigCacheFile, this.mgrConfig.getRptUserName(), ex});
            }
            boolean bl = procResult.setFailResult(ErrorCode.READ_LOCAL_FILE_FAILURE, "read PubKeyEntry file failure:" + ex.getMessage());
            return bl;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
            fileRw.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCachePubKeyEntryFile(EncryptConfigEntry entry) {
        FileOutputStream fos = null;
        fileRw.writeLock().lock();
        try {
            File file = new File(this.encryptConfigCacheFile);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            fos = new FileOutputStream(file);
            ObjectOutputStream p = new ObjectOutputStream(fos);
            p.writeObject(entry);
            p.flush();
        }
        catch (Throwable ex) {
            if (exptCounter.shouldPrint()) {
                logger.warn("ConfigManager({}) write file({}) exception, userName={}, content={}", new Object[]{this.callerId, this.encryptConfigCacheFile, this.mgrConfig.getRptUserName(), entry.toString(), ex});
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable file) {}
            }
            fileRw.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestConfiguration(boolean queryProxyInfo, String url, List<BasicNameValuePair> params, ProcessResult procResult) {
        Object httpClient;
        BasicHttpParams myParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)myParams, (int)this.mgrConfig.getMgrConnTimeoutMs());
        HttpConnectionParams.setSoTimeout((HttpParams)myParams, (int)this.mgrConfig.getMgrSocketTimeoutMs());
        try {
            httpClient = this.mgrConfig.isVisitMgrByHttps() ? this.getCloseableHttpClient(params) : new DefaultHttpClient((HttpParams)myParams);
        }
        catch (Throwable eHttp) {
            if (exptCounter.shouldPrint()) {
                logger.warn("ConfigManager({}) create Http(s) client failure, url={}, params={}", new Object[]{this.callerId, url, params, eHttp});
            }
            return procResult.setFailResult(ErrorCode.BUILD_HTTP_CLIENT_EXCEPTION, eHttp.getMessage());
        }
        HttpPost httpPost = null;
        try {
            httpPost = new HttpPost(url);
            this.addAuthorizationInfo(httpPost);
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(params, StandardCharsets.UTF_8);
            httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            String returnStr = EntityUtils.toString((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() != 200) {
                String errMsg = response.getStatusLine().getStatusCode() + ":" + returnStr;
                if (response.getStatusLine().getStatusCode() >= 500) {
                    this.bookManagerQryFailStatus(queryProxyInfo, errMsg);
                }
                boolean bl = procResult.setFailResult(ErrorCode.RMT_RETURN_FAILURE, errMsg);
                return bl;
            }
            if (StringUtils.isBlank(returnStr)) {
                String errMsg = "server return blank entity!";
                this.bookManagerQryFailStatus(queryProxyInfo, errMsg);
                boolean bl = procResult.setFailResult(ErrorCode.RMT_RETURN_BLANK_CONTENT, errMsg);
                return bl;
            }
            boolean bl = procResult.setSuccess(returnStr);
            return bl;
        }
        catch (Throwable ex) {
            if (exptCounter.shouldPrint()) {
                logger.warn("ConfigManager({}) connect manager({}) exception, params={}", new Object[]{this.callerId, url, params, ex});
            }
            boolean bl = procResult.setFailResult(ErrorCode.HTTP_VISIT_EXCEPTION, ex.getMessage());
            return bl;
        }
        finally {
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
            if (httpClient != null) {
                httpClient.getConnectionManager().shutdown();
            }
        }
    }

    private CloseableHttpClient getCloseableHttpClient(List<BasicNameValuePair> params) throws NoSuchAlgorithmException, KeyManagementException {
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        for (BasicNameValuePair paramItem : params) {
            headers.add(new BasicHeader(paramItem.getName(), paramItem.getValue()));
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.mgrConfig.getMgrSocketTimeoutMs()).setConnectTimeout(this.mgrConfig.getMgrConnTimeoutMs()).build();
        SSLContext sslContext = SSLContexts.custom().build();
        SSLConnectionSocketFactory sslSf = new SSLConnectionSocketFactory(sslContext, new String[]{this.mgrConfig.getTlsVersion()}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultHeaders(headers).setDefaultRequestConfig(requestConfig).setSSLSocketFactory((LayeredConnectionSocketFactory)sslSf).build();
        return httpClient;
    }

    private void storeAndBuildMetaConfigure(ProxyClientConfig config) {
        this.mgrConfig = config;
        this.proxyConfigEntry = null;
        this.proxyInfoList.clear();
        this.oldStat = 0;
        this.localMd5 = null;
        this.lstUpdateTime = 0L;
        this.userEncryptConfigEntry = null;
        StringBuilder strBuff = new StringBuilder(512);
        this.proxyConfigVisitUrl = strBuff.append(this.mgrConfig.isVisitMgrByHttps() ? SdkConsts.PREFIX_HTTPS : SdkConsts.PREFIX_HTTP).append(this.mgrConfig.getManagerIP()).append(":").append(this.mgrConfig.getManagerPort()).append("/inlong/manager/openapi/dataproxy/getIpList/").append(this.mgrConfig.getInlongGroupId()).toString();
        strBuff.delete(0, strBuff.length());
        this.proxyQueryFailKey = strBuff.append("proxy:").append(this.mgrConfig.getInlongGroupId()).append("#").append(this.mgrConfig.getRegionName()).append("#").append(this.mgrConfig.getDataRptProtocol()).toString();
        strBuff.delete(0, strBuff.length());
        this.localProxyConfigStoreFile = strBuff.append(this.mgrConfig.getMetaStoreBasePath()).append("/.inlong/").append(this.mgrConfig.getInlongGroupId()).append(".local").toString();
        strBuff.delete(0, strBuff.length());
        this.proxyConfigCacheFile = strBuff.append(this.mgrConfig.getMetaStoreBasePath()).append("/.inlong/").append(this.mgrConfig.getInlongGroupId()).append(".proxyip").toString();
        strBuff.delete(0, strBuff.length());
        this.encryptConfigVisitUrl = this.mgrConfig.getRptRsaPubKeyUrl();
        this.encryptQueryFailKey = strBuff.append("encrypt:").append(this.mgrConfig.getRptUserName()).toString();
        strBuff.delete(0, strBuff.length());
        this.encryptConfigCacheFile = strBuff.append(this.mgrConfig.getMetaStoreBasePath()).append("/.inlong/").append(this.mgrConfig.getRptUserName()).append(".pubKey").toString();
        strBuff.delete(0, strBuff.length());
    }

    private void addAuthorizationInfo(HttpPost httpPost) {
        if (this.mgrConfig.isEnableMgrAuthz()) {
            httpPost.addHeader("authorization", BasicAuth.genBasicAuthCredential(this.mgrConfig.getMgrAuthSecretId(), this.mgrConfig.getMgrAuthSecretKey()));
        }
    }

    private List<BasicNameValuePair> buildProxyNodeQueryParams() {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("ip", ProxyUtils.getLocalIp()));
        params.add(new BasicNameValuePair("protocolType", this.mgrConfig.getDataRptProtocol()));
        return params;
    }

    private List<BasicNameValuePair> buildPubKeyQueryParams() {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("operation", "query"));
        params.add(new BasicNameValuePair("username", this.mgrConfig.getRptUserName()));
        return params;
    }

    private void bookManagerQryFailStatus(boolean proxyQry, String errMsg) {
        if (proxyQry) {
            fetchFailProxyMap.put(this.proxyQueryFailKey, new Tuple2<AtomicLong, String>(new AtomicLong(System.currentTimeMillis()), errMsg));
        } else {
            fetchFailEncryptMap.put(this.encryptQueryFailKey, new Tuple2<AtomicLong, String>(new AtomicLong(System.currentTimeMillis()), errMsg));
        }
    }

    private void rmvManagerQryFailStatus(boolean proxyQry) {
        if (proxyQry) {
            fetchFailProxyMap.remove(this.proxyQueryFailKey);
        } else {
            fetchFailEncryptMap.remove(this.encryptQueryFailKey);
        }
    }

    private String getManagerQryResultInFailStatus(boolean proxyQry) {
        if (this.mgrConfig.getMetaQryFailCacheExpiredMs() <= 0L) {
            return null;
        }
        Tuple2<AtomicLong, String> queryResult = proxyQry ? fetchFailProxyMap.get(this.proxyQueryFailKey) : fetchFailEncryptMap.get(this.encryptQueryFailKey);
        if (queryResult != null && System.currentTimeMillis() - queryResult.getF0().get() < this.mgrConfig.getMetaQryFailCacheExpiredMs()) {
            return queryResult.getF1();
        }
        return null;
    }

    protected boolean getProxyConfigEntry(boolean fromManager, String strRet, ProcessResult procResult) {
        List<DataProxyNodeInfo> nodeList;
        DataProxyNodeResponse proxyNodeConfig;
        if (fromManager) {
            ProxyClusterConfig clusterConfig;
            try {
                clusterConfig = (ProxyClusterConfig)this.gson.fromJson(strRet, ProxyClusterConfig.class);
            }
            catch (Throwable ex) {
                if (parseCounter.shouldPrint()) {
                    logger.warn("ConfigManager({}) parse exception, groupId={}, config={}", new Object[]{this.callerId, this.mgrConfig.getInlongGroupId(), strRet, ex});
                }
                return procResult.setFailResult(ErrorCode.PARSE_RMT_CONTENT_FAILURE, "parse failure:" + ex.getMessage());
            }
            if (clusterConfig == null) {
                return procResult.setFailResult(ErrorCode.PARSE_RMT_CONTENT_IS_NULL);
            }
            if (!clusterConfig.isSuccess()) {
                return procResult.setFailResult(ErrorCode.RMT_RETURN_ERROR, clusterConfig.getErrMsg());
            }
            if (clusterConfig.getData() == null) {
                return procResult.setFailResult(ErrorCode.META_FIELD_DATA_IS_NULL);
            }
            proxyNodeConfig = clusterConfig.getData();
            if (proxyNodeConfig.getNodeList() == null) {
                return procResult.setFailResult(ErrorCode.META_FIELD_NODE_LIST_NULL);
            }
        } else {
            try {
                proxyNodeConfig = (DataProxyNodeResponse)this.gson.fromJson(strRet, DataProxyNodeResponse.class);
            }
            catch (Throwable ex) {
                if (parseCounter.shouldPrint()) {
                    logger.warn("ConfigManager({}) parse local file exception, groupId={}, config={}", new Object[]{this.callerId, this.mgrConfig.getInlongGroupId(), strRet, ex});
                }
                return procResult.setFailResult(ErrorCode.PARSE_FILE_CONTENT_FAILURE, "parse failure:" + ex.getMessage());
            }
            if (proxyNodeConfig == null) {
                return procResult.setFailResult(ErrorCode.PARSE_FILE_CONTENT_IS_NULL);
            }
            if (proxyNodeConfig.getNodeList() == null) {
                return procResult.setFailResult(ErrorCode.META_FIELD_NODE_LIST_NULL);
            }
        }
        if (CollectionUtils.isEmpty(nodeList = proxyNodeConfig.getNodeList())) {
            return procResult.setFailResult(ErrorCode.META_NODE_LIST_IS_EMPTY);
        }
        HashMap<String, HostInfo> hostMap = new HashMap<String, HostInfo>();
        for (DataProxyNodeInfo proxy : nodeList) {
            if (ObjectUtils.isEmpty(proxy.getId()) || StringUtils.isEmpty(proxy.getIp()) || ObjectUtils.isEmpty(proxy.getPort()) || proxy.getPort() < 0) {
                if (!exptCounter.shouldPrint()) continue;
                logger.warn("Invalid proxy node: groupId={}, id={}, ip={}, port={}", new Object[]{this.mgrConfig.getInlongGroupId(), proxy.getId(), proxy.getIp(), proxy.getPort()});
                continue;
            }
            HostInfo tmpHostInfo = new HostInfo(proxy.getIp(), proxy.getPort());
            hostMap.put(tmpHostInfo.getReferenceName(), tmpHostInfo);
        }
        if (hostMap.isEmpty()) {
            return procResult.setFailResult(ErrorCode.NODE_LIST_RECORD_INVALID);
        }
        int clusterId = -1;
        if (ObjectUtils.isNotEmpty(proxyNodeConfig.getClusterId())) {
            clusterId = proxyNodeConfig.getClusterId();
        }
        int load = 0;
        if (ObjectUtils.isNotEmpty(proxyNodeConfig.getLoad())) {
            load = proxyNodeConfig.getLoad() > 200 ? 200 : Math.max(proxyNodeConfig.getLoad(), 0);
        }
        boolean isIntranet = true;
        if (ObjectUtils.isNotEmpty(proxyNodeConfig.getIsIntranet())) {
            isIntranet = proxyNodeConfig.getIsIntranet() == 1;
        }
        int isSwitch = 0;
        if (ObjectUtils.isNotEmpty(proxyNodeConfig.getIsSwitch())) {
            isSwitch = proxyNodeConfig.getIsSwitch();
        }
        ProxyConfigEntry proxyEntry = new ProxyConfigEntry();
        proxyEntry.setClusterId(clusterId);
        proxyEntry.setGroupId(this.mgrConfig.getInlongGroupId());
        proxyEntry.setInterVisit(isIntranet);
        proxyEntry.setHostMap(hostMap);
        proxyEntry.setSwitchStat(isSwitch);
        proxyEntry.setLoad(load);
        proxyEntry.setMaxPacketLength(proxyNodeConfig.getMaxPacketLength() != null ? proxyNodeConfig.getMaxPacketLength() : -1);
        return procResult.setSuccess(proxyEntry);
    }
}

